package com.dtyunxi.yundt.cube.center.inventory.param;

import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wufan
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PreemptParam extends OperationParam{

    private static final String DESC = "预占";

    /**
     * 是否是销售单预占
     */
    private Boolean isSaleOrder = Boolean.FALSE;

    /**
     * 是否校验负库存
     */
    private Boolean validNegative = Boolean.TRUE;

    public PreemptParam () {
        this.setDesc(DESC);
        this.setFlag(CsInventoryInOutEnum.OUT.getCode());
    }
}
