package com.dtyunxi.yundt.cube.center.inventory.param;

import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 释放预占并出库参数
 * @author wufan
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ReleasePreemptAndOutParam extends OperationParam{
    private static final String DESC = "释放预占并出库";

    public ReleasePreemptAndOutParam() {
        this.setDesc(DESC);
        this.setFlag(CsInventoryInOutEnum.OUT.getCode());
    }

    /**
     * 是否允许可用库存小于0
     */
    private boolean isAvailableLowerZero = Boolean.FALSE;

    /**
     * 是否允许实际库存小于0
     */
    private boolean isBalanceLowerZero = Boolean.FALSE;

    /**
     * 是否是销售单预占
     */
    private Boolean isSaleOrder = Boolean.FALSE;

}
