package com.dtyunxi.yundt.cube.center.inventory.param;

import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wufan
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ReleasePreemptParam extends OperationParam {
    private static final String DESC = "释放预占";

    public ReleasePreemptParam() {
        this.setDesc(DESC);
        this.setFlag(CsInventoryInOutEnum.IN.getCode());
    }

    /**
     * 是否全部释放
     */
    private boolean isAllRelease = Boolean.TRUE;

    public Boolean isErrorForNotFoundPreempt = Boolean.TRUE;

    /**
     * 是否是销售单
     */
    private Boolean isSaleOrder = Boolean.FALSE;
}
