package com.dtyunxi.yundt.cube.center.inventory.transaction;

import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class TransactionCallBackService {

    public void execute(final TransactionCallBackAction action) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
                @Override
                public void afterCommit() {
                    if (null != action) {
                        action.callback();
                    }
                }
            });
        } else {
            if (null != action) {
                action.callback();
            }
        }
    }
}
