/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.inventory;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryTotalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsPhysicsInventoryTotalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsInventoryPreemptionEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsLogicWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryInitOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInventoryExposedApiImpl")
public class CsInventoryExposedApiImpl
implements ICsInventoryExposedApi {
    private Logger logger = LoggerFactory.getLogger(CsInventoryExposedApiImpl.class);
    @Autowired
    private ICsInventoryExposedService csInventoryExposedService;
    @Resource
    private ICsInventoryPreemptionService csInventoryPreemptionService;
    @Resource
    private ICsLogicWarehouseQueryService csLogicWarehouseQueryService;
    @Resource
    private CsCommonService csCommonService;
    @Resource
    private ICsInventoryPreemptionQueryService csInventoryPreemptionQueryService;
    @Resource
    private ICsLogicInventoryTotalService csLogicInventoryTotalService;
    @Resource
    private ICsPhysicsInventoryTotalService csPhysicsInventoryTotalService;

    public RestResponse<Boolean> preemptInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        Boolean preemptFlag = this.csInventoryExposedService.preemptInventory(inventoryOperateReqDto);
        return new RestResponse((Object)preemptFlag);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public RestResponse<Boolean> preemptInventoryByYxy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        Boolean preemptFlag = this.preemptInventoryExt(inventoryOperateReqDto);
        return new RestResponse((Object)preemptFlag);
    }

    public Boolean preemptInventoryExt(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u9884\u5360,\u5165\u53c2\uff1a{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        if (CsInventorySourceTypeEnum.OUT_ALLOT.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_OTHER.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_OTHER_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_SEPARATE.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_SEPARATE_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_BACKTRACK.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_BACKTRACK_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_TOP_BACKTRACK.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_TOP_BACKTRACK_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_MATERIAL_ADJUST.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_MATERIAL_ADJUST_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_INTERIOR_ADJUST.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_INTERIOR_ADJUST_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.SECOND_OUT_TOP_BACKTRACK.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.SECOND_OUT_TOP_BACKTRACK_PREEMPT.getCode());
        }
        inventoryOperateReqDto.setUpdateTotalFlag(YesNoEnum.NO.getValue());
        Boolean preemptFlag = this.csInventoryExposedService.preemptInventory(inventoryOperateReqDto);
        List collect = inventoryOperateReqDto.getOperateCargoReqDtoList().stream().filter(c -> ObjectUtils.isNotEmpty((Object)c.getBatch())).map(c -> {
            c.setBatch(null);
            return c;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            inventoryOperateReqDto.setOperateCargoReqDtoList(collect);
            inventoryOperateReqDto.setSuffix("suffix");
            preemptFlag = this.csInventoryExposedService.preemptCommonInventory(inventoryOperateReqDto, inventoryOperateReqDto.getOperateCargoReqDtoList());
        }
        this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u9884\u5360,\u5e93\u5b58\u9884\u5360\u7ed3\u675f\uff1a{}", (Object)preemptFlag);
        return preemptFlag;
    }

    private void joinName(CsInventoryOperateReqDto inventoryOperateReqDto) {
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        List<String> warehouseCodes = operateCargoReqDtoList.stream().map(CsInventoryOperateCargoReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List<String> cargoCodes = operateCargoReqDtoList.stream().map(CsInventoryOperateCargoReqDto::getCargoCode).distinct().collect(Collectors.toList());
        List<CsLogicWarehouseEo> csLogicWarehouseEos = this.csLogicWarehouseQueryService.queryByWarehouseCodes(warehouseCodes);
        List<CargoEo> cargoEoList = this.csCommonService.queryCargo(cargoCodes);
        Map<String, CsLogicWarehouseEo> warehouseMap = csLogicWarehouseEos.stream().collect(Collectors.toMap(CsLogicWarehouseEo::getWarehouseCode, entity -> entity, (v1, v2) -> v2));
        Map<String, CargoEo> cargoMap = cargoEoList.stream().collect(Collectors.toMap(StdCargoEo::getCode, entity -> entity, (v1, v2) -> v2));
        for (CsInventoryOperateCargoReqDto cargoReqDto : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
            CargoEo cargoEo;
            CsLogicWarehouseEo csLogicWarehouseEo = warehouseMap.get(cargoReqDto.getWarehouseCode());
            if (null != csLogicWarehouseEo) {
                // empty if block
            }
            if (null == (cargoEo = cargoMap.get(cargoReqDto.getCargoCode()))) continue;
        }
    }

    public RestResponse<Boolean> preemptOrderInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        Boolean preemptFlag = this.csInventoryExposedService.preemptOrderInventory(inventoryOperateReqDto);
        return new RestResponse((Object)preemptFlag);
    }

    public RestResponse<Boolean> releaseInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        Boolean releaseFlag = this.csInventoryExposedService.releaseInventory(inventoryOperateReqDto, true);
        return new RestResponse((Object)releaseFlag);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public RestResponse<Boolean> releaseInventoryByYxy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        Boolean releaseFlag = this.releaseInventoryPreempt(inventoryOperateReqDto);
        return new RestResponse((Object)releaseFlag);
    }

    public Boolean releaseInventoryPreempt(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u91ca\u653e,\u5165\u53c2\uff1a{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        Boolean releaseFlag = true;
        List<CsInventoryPreemptionEo> preemptionEoList = this.csInventoryPreemptionQueryService.queryCsInventoryPreemptionBySourceNo(inventoryOperateReqDto.getSourceNo(), CsValidFlagEnum.ENABLE.getCode());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(preemptionEoList), "\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u91ca\u653e");
        this.joinReleaseInventory(inventoryOperateReqDto, preemptionEoList);
        this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u91ca\u653e,\u5f00\u59cb\u91ca\u653e\uff1a{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        releaseFlag = this.csInventoryExposedService.releaseInventory(inventoryOperateReqDto, true);
        this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u91ca\u653e,\u66f4\u65b0\u9884\u5360\u8bb0\u5f55\u72b6\u6001\uff1a{}", (Object)LogUtils.buildLogContent(preemptionEoList));
        this.csInventoryPreemptionService.updateStatusDisable(preemptionEoList);
        this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u91ca\u653e,\u9884\u5360\u8bb0\u5f55\u72b6\u6001\u66f4\u65b0\u5b8c\u6bd5\uff1a{}", (Object)releaseFlag);
        return releaseFlag;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public RestResponse<Boolean> reloadPreOccupy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        CsInventoryOperateReqDto csInventoryOperateReq = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)csInventoryOperateReq, (Object)inventoryOperateReqDto, (String[])new String[0]);
        csInventoryOperateReq.setSourceType(CsInventorySourceTypeEnum.IN_SALE_MODIFY_RELEASE.getCode());
        Boolean releaseResult = this.releaseInventoryPreempt(csInventoryOperateReq);
        AssertUtil.isTrue(releaseResult, "\u5e93\u5b58\u9884\u5360\u91ca\u653e\u5931\u8d25");
        Boolean preemptInventoryResult = this.preemptInventoryExt(inventoryOperateReqDto);
        AssertUtil.isTrue(preemptInventoryResult, "\u5e93\u5b58\u9884\u5360\u91ca\u653e\u5931\u8d25");
        return new RestResponse((Object)true);
    }

    private void joinReleaseInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryPreemptionEo> preemptionEoList) {
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        inventoryOperateReqDto.setUpdateTotalFlag(YesNoEnum.NO.getValue());
        Boolean isTotal = false;
        for (CsInventoryPreemptionEo preemptionEo : preemptionEoList) {
            CsInventoryOperateCargoReqDto cargoReqDto = new CsInventoryOperateCargoReqDto();
            CubeBeanUtils.copyProperties((Object)cargoReqDto, (Object)preemptionEo, (String[])new String[0]);
            cargoReqDto.setChangeInventory(preemptionEo.getPreemptNum());
            operateCargoReqDtoList.add(cargoReqDto);
            if (!StringUtils.isEmpty((CharSequence)cargoReqDto.getBatch())) continue;
            isTotal = true;
        }
        if (!isTotal.booleanValue()) {
            inventoryOperateReqDto.setUpdateTotalFlag(YesNoEnum.YES.getValue());
        }
        inventoryOperateReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
    }

    public RestResponse<Boolean> releaseOrderInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        Boolean releaseFlag = this.csInventoryExposedService.releaseOrderInventory(inventoryOperateReqDto);
        return new RestResponse((Object)releaseFlag);
    }

    public RestResponse<Boolean> releaseInventoryByPreemption(CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto) {
        Boolean releaseFlag = false;
        try {
            releaseFlag = this.csInventoryExposedService.releaseInventoryByPreemption(releasePreemptOperateReqDto);
            this.logger.info("releaseInventoryByPreemption==>sourceNo:{},commonApproveReleaseFlag:{}", (Object)releasePreemptOperateReqDto.getSourceNo(), (Object)releaseFlag);
        }
        catch (BizException ex) {
            if (!CsInventoryExceptionCode.NO_FOUND_PREEMPT_RECORD.getCode().equals(ex.getCode())) {
                throw new BizException(ex.getCode(), ex.getMessage());
            }
            this.logger.info("releaseInventoryByPreemption==>sourceNo:{},\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u7ee7\u7eed\u6267\u884c", (Object)releasePreemptOperateReqDto.getSourceNo());
        }
        return new RestResponse((Object)releaseFlag);
    }

    public RestResponse<Boolean> approvePassInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        Boolean approveFlag = this.csInventoryExposedService.approvePassInventory(inventoryOperateReqDto);
        return new RestResponse((Object)approveFlag);
    }

    public RestResponse<Boolean> deductionInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        Boolean releaseFlag = this.csInventoryExposedService.deductionInventory(inventoryOperateReqDto);
        return new RestResponse((Object)releaseFlag);
    }

    public RestResponse<Boolean> initPhysicsInventory(CsInventoryInitOperateReqDto csInventoryInitOperateReqDto) {
        Boolean releaseFlag = this.csInventoryExposedService.initPhysicsInventory(csInventoryInitOperateReqDto);
        return new RestResponse((Object)releaseFlag);
    }

    public RestResponse<Boolean> initLogicPhysicsInventory(List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList) {
        Boolean releaseFlag = this.csInventoryExposedService.initLogicPhysicsInventory(operateCargoReqDtoList, null);
        return new RestResponse((Object)releaseFlag);
    }

    public RestResponse<Integer> updateInventoryTotalBalance(String preOrderNo, String type) {
        Integer updateNum = this.csInventoryExposedService.updateInventoryTotalBalance(preOrderNo, type);
        this.csLogicInventoryTotalService.updateLogicInventoryTotalAvailable();
        this.csPhysicsInventoryTotalService.updatePhysicsInventoryTotalAvailable();
        return new RestResponse((Object)updateNum);
    }

    public RestResponse<Integer> updateInventoryTotalPreempt(String preOrderNo, String type) {
        Integer updateNum = this.csInventoryExposedService.updateInventoryTotalPreempt(preOrderNo, type);
        this.csLogicInventoryTotalService.updateLogicInventoryTotalAvailable();
        return new RestResponse((Object)updateNum);
    }
}

