/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.CargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CsCommonServiceImpl
implements CsCommonService {
    private static final Logger logger = LoggerFactory.getLogger(CsCommonServiceImpl.class);
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private CargoMapper cargoMapper;
    @Resource
    private ICsLogicWarehouseQueryService csLogicWarehouseQueryService;

    @Override
    public Long getUserOrganizationId() {
        RestResponse restResponse;
        Long userId = this.context.userId();
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7id\uff0cuserId:{}", (Object)userId);
        if (null != userId && null != (restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId())).getData()) {
            logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7id\uff0corganizationId:{}", restResponse.getData());
            return (Long)restResponse.getData();
        }
        return null;
    }

    @Override
    public Long getOrganizationIdByUserId(Long userId) {
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(userId);
        if (null != restResponse.getData()) {
            return (Long)restResponse.getData();
        }
        return null;
    }

    @Override
    public List<CargoEo> queryCargo(List<String> cargoCodeList) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"code", cargoCodeList);
        List list = this.cargoMapper.selectList((Wrapper)wrapper);
        return list;
    }

    @Override
    public String getItemCode(String cargoCode) {
        int i = cargoCode.lastIndexOf(".");
        String substring = cargoCode.substring(i + 1, cargoCode.length());
        return substring;
    }

    @Override
    public List<Long> getUserLogicWarehouseIds() {
        List<Long> warehouseIds = new ArrayList<Long>();
        Long userId = this.context.userId();
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684userId:{}", (Object)userId);
        if (Objects.isNull(userId)) {
            return warehouseIds;
        }
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        logger.info("\u6839\u636euserId\u67e5\u8be2\u5230\u7ec4\u7ec7id\uff1a{}", (Object)orgId);
        if (Objects.isNull(orgId)) {
            return warehouseIds;
        }
        CsLogicWarehouseQueryDto queryDto = new CsLogicWarehouseQueryDto();
        queryDto.setOrganizationId(orgId);
        List<CsLogicWarehouseRespDto> list = this.csLogicWarehouseQueryService.queryByParam(queryDto);
        if (!CollectionUtils.isEmpty(list)) {
            warehouseIds = list.stream().map(e -> e.getId()).collect(Collectors.toList());
        }
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u903b\u8f91\u4ed3\u5e93id\u96c6\u5408\uff0c\u8fd4\u53c2\uff1a{}", (Object)JSON.toJSONString(warehouseIds));
        return warehouseIds;
    }
}

