/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.CsInventoryStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryBasicsService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryPreSplitService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryTotalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsPhysicsInventoryTotalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.RepeatFilter;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.warehouse.CsRelWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsActivityInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsInventoryPreemptionEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLogicInventoryTotalEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsPhysicsInventoryTotalEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.log.CsInventoryLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsRelWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsActivityInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsInventoryPreemptionMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsLogicInventoryTotalMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsPhysicsInventoryTotalMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.log.CsInventoryLogMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.vo.InventoryStatisticNumVo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryInitOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsActivityInventoryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCargoTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInventoryExposedServiceImpl")
public class CsInventoryExposedServiceImpl
implements ICsInventoryExposedService,
ICsInventoryPreSplitService {
    private Logger logger = LoggerFactory.getLogger(CsInventoryExposedServiceImpl.class);
    @Autowired
    private CsRelWarehouseDas csRelWarehouseDas;
    @Autowired
    private ICsDeliveryNoticeOrderService csDeliveryNoticeOrderService;
    @Resource
    private CsInventoryPreemptionMapper csInventoryPreemptionMapper;
    @Resource
    private CsActivityInventoryMapper csActivityInventoryMapper;
    @Resource
    private CsLogicInventoryTotalMapper csLogicInventoryTotalMapper;
    @Resource
    private CsPhysicsInventoryTotalMapper csPhysicsInventoryTotalMapper;
    @Resource
    private CsInventoryLogMapper csInventoryLogMapper;
    @Autowired
    private RepeatFilter repeatFilter;
    @Resource
    private ICsLogicInventoryService csLogicInventoryService;
    @Resource
    private ICsLogicInventoryTotalService csLogicInventoryTotalService;
    @Resource
    private ICsPhysicsInventoryTotalService csPhysicsInventoryTotalService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean preemptInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("preemptInventory==>\u5e93\u5b58\u9884\u5360,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        this.checkParams(inventoryOperateReqDto);
        this.preemptIdempotentCheck(inventoryOperateReqDto);
        inventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        Map<String, List<CsInventoryOperateCargoReqDto>> splitReqCargoMap = this.splitReqCargo(operateCargoReqDtoList);
        this.logger.info("preemptInventory==>\u5e93\u5b58\u9884\u5360,\u533a\u5206\u6d3b\u52a8\u8d27\u54c1\u548c\u666e\u901a\u8d27\u54c1splitReqCargoMap:{}", (Object)LogUtils.buildLogContent(splitReqCargoMap));
        List<CsInventoryOperateCargoReqDto> actCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.ACTIVITY.getCode());
        List<CsInventoryOperateCargoReqDto> commonCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.COMMON.getCode());
        Boolean commonFlag = true;
        Boolean actFlag = true;
        if (CollectionUtils.isNotEmpty(actCargoList)) {
            actFlag = this.preemptActInventory(inventoryOperateReqDto, actCargoList);
        }
        if (CollectionUtils.isNotEmpty(commonCargoList)) {
            commonFlag = this.preemptCommonInventory(inventoryOperateReqDto, commonCargoList);
        }
        if (!commonFlag.booleanValue() || !actFlag.booleanValue()) {
            throw new BizException("\u5e93\u5b58\u9884\u5360\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean preemptOrderInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("preemptOrderInventory==>\u5e93\u5b58\u9884\u5360\uff0c\u5305\u542b\u5355\u636e\u64cd\u4f5c-\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        Boolean preemptInventoryFlag = true;
        Boolean generateFlag = true;
        preemptInventoryFlag = this.preemptInventory(inventoryOperateReqDto);
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        CompletableFuture.runAsync(() -> {
            this.logger.info("\u5f02\u6b65\u64cd\u4f5c\u5f00\u59cb\uff1a\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\uff0csourceNo\uff1a{}", (Object)sourceNo);
            this.csDeliveryNoticeOrderService.generateOutNoticeOrder(sourceNo);
            this.logger.info("\u5f02\u6b65\u64cd\u4f5c\u7ed3\u675f\uff0c\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5b8c\u6210");
        });
        this.logger.info("preemptOrderInventory==>preemptInventoryFlag:{},generateFlag:{}", (Object)preemptInventoryFlag, (Object)generateFlag);
        if (!preemptInventoryFlag.booleanValue() || !generateFlag.booleanValue()) {
            throw new BizException("\u5e93\u5b58\u9884\u5360\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean releaseInventory(CsInventoryOperateReqDto inventoryOperateReqDto, Boolean idempotentCheck) {
        this.logger.info("releaseInventory==>\u5e93\u5b58\u91ca\u653e,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        if (idempotentCheck.booleanValue()) {
            this.releaseIdempotentCheck(inventoryOperateReqDto);
        }
        this.checkParams(inventoryOperateReqDto);
        inventoryOperateReqDto.setNegativeValidate(YesNoEnum.NO.getValue());
        inventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        Map<String, List<CsInventoryOperateCargoReqDto>> splitReqCargoMap = this.splitReqCargo(operateCargoReqDtoList);
        this.logger.info("releaseInventory==>\u5e93\u5b58\u91ca\u653e,\u533a\u5206\u6d3b\u52a8\u8d27\u54c1\u548c\u666e\u901a\u8d27\u54c1splitReqCargoMap:{}", (Object)LogUtils.buildLogContent(splitReqCargoMap));
        List<CsInventoryOperateCargoReqDto> actCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.ACTIVITY.getCode());
        List<CsInventoryOperateCargoReqDto> commonCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.COMMON.getCode());
        Boolean commonFlag = true;
        Boolean actFlag = true;
        if (CollectionUtils.isNotEmpty(actCargoList)) {
            actFlag = this.releaseActInventory(inventoryOperateReqDto, actCargoList);
        }
        if (CollectionUtils.isNotEmpty(commonCargoList)) {
            commonFlag = this.releaseCommonInventory(inventoryOperateReqDto, commonCargoList);
        }
        if (!commonFlag.booleanValue() || !actFlag.booleanValue()) {
            throw new BizException(CsInventoryExceptionCode.INVENTORY_NOT_PREEMPT.getCode(), CsInventoryExceptionCode.INVENTORY_NOT_PREEMPT.getMsg());
        }
        return true;
    }

    @Override
    public Boolean releaseOrderInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("releaseOrderInventory==>\u5e93\u5b58\u91ca\u653e\uff0c\u5305\u542b\u5355\u636e\u64cd\u4f5c-\u53d6\u6d88\u53d1\u8d27\u901a\u77e5\u5355,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        Boolean releaseInventoryFlag = true;
        releaseInventoryFlag = this.releaseInventory(inventoryOperateReqDto, true);
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        String sourceType = inventoryOperateReqDto.getSourceType();
        String action = CsDocumentActionEnum.CANCEL_PAY.getCode();
        if (CsInventorySourceTypeEnum.IN_BUSINESS_APPROVE_RELEASE.getCode().equals(sourceType) || CsInventorySourceTypeEnum.IN_FINANCE_APPROVE_RELEASE.getCode().equals(sourceType)) {
            action = CsDocumentActionEnum.AUDIT_ADJUST.getCode();
        }
        this.csDeliveryNoticeOrderService.updateOrderStatus(sourceNo, action);
        if (!releaseInventoryFlag.booleanValue()) {
            throw new BizException("\u5e93\u5b58\u91ca\u653e\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean deductionInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("deductionInventory==>\u5e93\u5b58\u53d1\u8d27\u6263\u51cf,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        this.deductionIdempotentCheck(inventoryOperateReqDto);
        this.checkParams(inventoryOperateReqDto);
        inventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        Map<String, List<CsInventoryOperateCargoReqDto>> splitReqCargoMap = this.splitReqCargo(operateCargoReqDtoList);
        this.logger.info("deductionInventory==>\u5e93\u5b58\u53d1\u8d27\u6263\u51cf,\u533a\u5206\u6d3b\u52a8\u8d27\u54c1\u548c\u666e\u901a\u8d27\u54c1splitReqCargoMap:{}", (Object)LogUtils.buildLogContent(splitReqCargoMap));
        List<CsInventoryOperateCargoReqDto> actCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.ACTIVITY.getCode());
        List<CsInventoryOperateCargoReqDto> commonCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.COMMON.getCode());
        Boolean commonFlag = true;
        Boolean actFlag = true;
        if (CollectionUtils.isNotEmpty(actCargoList)) {
            actFlag = this.deductionActInventory(inventoryOperateReqDto, actCargoList);
        }
        if (CollectionUtils.isNotEmpty(commonCargoList)) {
            commonFlag = this.deductionCommonInventory(inventoryOperateReqDto, commonCargoList);
            this.deductionCommonPhysicInventory(inventoryOperateReqDto, commonCargoList);
        }
        if (!commonFlag.booleanValue() || !actFlag.booleanValue()) {
            throw new BizException("\u5e93\u5b58\u53d1\u8d27\u6263\u51cf\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean initPhysicsInventory(CsInventoryInitOperateReqDto csInventoryInitOperateReqDto) {
        this.logger.info("inPhysicsInventory==>\u5165\u5e93\u7269\u7406\u4ed3\u5e93\u5b58,csInventoryInitOperateReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryInitOperateReqDto));
        this.checkParams(csInventoryInitOperateReqDto);
        List warehouseCodeList = csInventoryInitOperateReqDto.getWarehouseCodeList();
        List operateCargoReqDtoList = csInventoryInitOperateReqDto.getOperateCargoReqDtoList();
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        for (String warehouseCode : warehouseCodeList) {
            CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
            csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
            csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
            csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
            csInventoryInOutBasicsDto.setSourceNo("INIT_" + IdUtils.getId());
            csInventoryInOutBasicsDto.setSourceType(CsInventorySourceTypeEnum.INITIALIZE_INVENTORY.getCode());
            for (CsInventoryOperateCargoReqDto actDto : operateCargoReqDtoList) {
                CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
                inOutBasicsCargoDto.setCargoCode(actDto.getCargoCode());
                inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
                inOutBasicsCargoDto.setBalance(actDto.getChangeInventory().abs());
                inOutBasicsCargoDto.setAvailable(actDto.getChangeInventory().abs());
                inOutBasicsCargoDto.setWarehouseCode(warehouseCode);
                inOutBasicsCargoDto.setBatch(actDto.getBatch());
                inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
            }
            csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
            ICsInventoryBasicsService physicsInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.PHYSICS.getCode());
            physicsInventoryService.inInventory(csInventoryInOutBasicsDto);
            CsRelWarehouseEo queryEo = new CsRelWarehouseEo();
            queryEo.setWarehouseCode(warehouseCode);
            queryEo.setRefWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            queryEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
            List csRelWarehouseEoList = this.csRelWarehouseDas.select((BaseEo)queryEo);
            if (CollectionUtils.isEmpty((Collection)csRelWarehouseEoList)) continue;
            ICsInventoryBasicsService logicInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.LOGIC.getCode());
            for (CsRelWarehouseEo csRelWarehouseEo : csRelWarehouseEoList) {
                csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
                inOutBasicsCargoDtoList.forEach(dto -> dto.setWarehouseId(csRelWarehouseEo.getRefWarehouseId()));
                logicInventoryService.inInventory(csInventoryInOutBasicsDto);
            }
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Boolean initLogicPhysicsInventory(List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList, String sourceNo) {
        long timeMillis = System.currentTimeMillis();
        this.logger.info("\u76d8\u70b9\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)timeMillis);
        this.checkParams2(operateCargoReqDtoList);
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setCoverInventoryFlag(operateCargoReqDtoList.get(0).getCoverInventoryFlag());
        sourceNo = StringUtils.isNotBlank((CharSequence)sourceNo) ? sourceNo : "INIT_" + IdUtils.getId();
        csInventoryInOutBasicsDto.setSourceNo(sourceNo);
        String sourceType = CsInventoryCoverInventoryFlagEnum.UPDATE.getCode().equals(csInventoryInOutBasicsDto.getCoverInventoryFlag()) ? CsInventorySourceTypeEnum.INITIALIZE_INVENTORY.getCode() : CsInventorySourceTypeEnum.CHECK_INVENTORY.getCode();
        csInventoryInOutBasicsDto.setSourceType(sourceType);
        for (CsInventoryOperateCargoReqDto actDto : operateCargoReqDtoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(actDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setBalance(actDto.getChangeInventory().abs());
            inOutBasicsCargoDto.setAvailable(actDto.getChangeInventory().abs());
            inOutBasicsCargoDto.setWarehouseCode(actDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(actDto.getBatch());
            inOutBasicsCargoDto.setExpireTime(actDto.getExpireTime());
            inOutBasicsCargoDto.setProduceTime(actDto.getProduceTime());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        long timeMillis1 = System.currentTimeMillis();
        this.logger.info("\u76d8\u70b9\uff0c\u5f00\u59cb\u5904\u7406[\u64cd\u4f5c\u7269\u7406\u4ed3\u3001\u903b\u8f91\u4ed3\u5e93\u5b58(\u6279\u6b21\u5e93\u5b58)],\u524d\u7f6e\u5904\u7406\u8017\u65f6\u65f6\u95f4\uff1a{}", (Object)(timeMillis1 - timeMillis));
        this.operateInventory(csInventoryInOutBasicsDto);
        long timeMillis2 = System.currentTimeMillis();
        this.logger.info("\u76d8\u70b9\uff0c\u7ed3\u675f\u5904\u7406[\u64cd\u4f5c\u7269\u7406\u4ed3\u3001\u903b\u8f91\u4ed3\u5e93\u5b58(\u6279\u6b21\u5e93\u5b58)],\u8017\u65f6\u65f6\u95f4\uff1a{}", (Object)(timeMillis2 - timeMillis1));
        this.updateInventoryTotalBalance(sourceNo, sourceType);
        long timeMillis3 = System.currentTimeMillis();
        this.logger.info("\u76d8\u70b9\uff0c\u66f4\u65b0\u5373\u65f6\u5e93\u5b58,\u8017\u65f6\u65f6\u95f4\uff1a{}", (Object)(timeMillis3 - timeMillis2));
        this.csLogicInventoryService.updateLogicInventoryAvailable();
        this.csLogicInventoryTotalService.updateLogicInventoryTotalAvailable();
        this.csPhysicsInventoryTotalService.updatePhysicsInventoryTotalAvailable();
        long timeMillis4 = System.currentTimeMillis();
        this.logger.info("\u76d8\u70b9\uff0c\u66f4\u65b0\u53ef\u7528\u5e93\u5b58,\u8017\u65f6\u65f6\u95f4\uff1a{}", (Object)(timeMillis4 - timeMillis3));
        this.logger.info("initLogicPhysicsInventory==>\u5165\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,\u7ed3\u675f");
        return true;
    }

    @Override
    public void operateInventory(CsInventoryInOutBasicsDto csInventoryInOutBasicsDto) {
        this.logger.info("operateInventory==>\u5165\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)LogUtils.buildLogContent(csInventoryInOutBasicsDto));
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto2 = new CsInventoryInOutBasicsDto();
        BeanUtils.copyProperties((Object)csInventoryInOutBasicsDto, (Object)csInventoryInOutBasicsDto2);
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)inOutBasicsCargoDtoList, (Collection)csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList(), CsInventoryInOutBasicsCargoDto.class);
        ICsInventoryBasicsService logicInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        logicInventoryService.inInventory(csInventoryInOutBasicsDto);
        ICsInventoryBasicsService physicsInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.PHYSICS.getCode());
        csInventoryInOutBasicsDto2.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        for (CsInventoryInOutBasicsCargoDto dto : csInventoryInOutBasicsDto2.getInOutBasicsCargoDtoList()) {
            dto.setPreempt(BigDecimal.valueOf(0L));
        }
        physicsInventoryService.inInventory(csInventoryInOutBasicsDto2);
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        this.logger.info("operateInventory==>\u5165\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58\u5b8c\u6210");
    }

    @Override
    public Boolean approvePassInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.operateInventory(inventoryOperateReqDto);
        this.updateOrderDetailBatch(inventoryOperateReqDto);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrderDetailBatch(CsInventoryOperateReqDto inventoryOperateReqDto) {
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        this.logger.info("approveInventory==>\u5f00\u59cb\u66f4\u65b0\u5355\u636e\u6279\u6b21\u53f7");
        Integer num = this.csDeliveryNoticeOrderService.updateDetailBatch(inventoryOperateReqDto);
        this.logger.info("approveInventory==>\u5b8c\u6210\u66f4\u65b0\u5355\u636e\u6279\u6b21\u53f7,\u66f4\u65b0\u6761\u6570\uff1a{}", (Object)num);
    }

    @Transactional(rollbackFor={Exception.class})
    public void operateInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)operateCargoReqDtoList, (Collection)inventoryOperateReqDto.getOperateCargoReqDtoList(), CsInventoryOperateCargoReqDto.class);
        this.logger.info("approveInventory-->\u5ba1\u6279\u5e93\u5b58\u64cd\u4f5c,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        this.checkParams(inventoryOperateReqDto);
        String sourceType = inventoryOperateReqDto.getSourceType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceType) && (CsInventorySourceTypeEnum.OUT_BUSINESS_APPROVE_PREEMPT.getCode().equals(sourceType) || CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT.getCode().equals(sourceType)), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u53c2\u6570\u6709\u8bef\uff0c\u53ea\u80fd\u4e3a\u4e1a\u52a1\u5ba1\u6279\u6216\u8005\u8d22\u52a1\u5ba1\u6279");
        this.approvePassInventoryAct(inventoryOperateReqDto);
        this.approvePassInventoryCommon(inventoryOperateReqDto);
        inventoryOperateReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
    }

    private void approvePassInventoryCommon(CsInventoryOperateReqDto inventoryOperateReqDto) {
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        ArrayList commonList = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto commonDto : operateCargoReqDtoList) {
            Long activityId = commonDto.getActivityId();
            if (null != activityId) continue;
            commonList.add(commonDto);
        }
        this.logger.info("approvePassInventoryCommon==>,sourceNo:{},commonList:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(commonList));
        if (CollectionUtils.isEmpty((Collection)commonList)) {
            return;
        }
        String sourceType = inventoryOperateReqDto.getSourceType();
        String releaseSourceType = CsInventorySourceTypeEnum.IN_BUSINESS_APPROVE_RELEASE.getCode();
        if (CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT.getCode().equals(sourceType)) {
            releaseSourceType = CsInventorySourceTypeEnum.IN_FINANCE_APPROVE_RELEASE.getCode();
        }
        CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto = new CsInventoryReleasePreemptOperateReqDto();
        releasePreemptOperateReqDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        releasePreemptOperateReqDto.setSourceType(releaseSourceType);
        releasePreemptOperateReqDto.setActivityFlag(YesNoEnum.NO.getValue());
        try {
            Boolean commonApproveReleaseFlag = this.releaseInventoryByPreemption(releasePreemptOperateReqDto);
            this.logger.info("approvePassInventoryCommon==>sourceNo:{},commonApproveReleaseFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)commonApproveReleaseFlag);
        }
        catch (BizException ex) {
            if (!CsInventoryExceptionCode.NO_FOUND_PREEMPT_RECORD.getCode().equals(ex.getCode())) {
                throw new BizException(ex.getCode(), ex.getMessage());
            }
            inventoryOperateReqDto.setNegativeValidate(YesNoEnum.YES.getValue());
            this.logger.info("approvePassInventoryCommon==>sourceNo:{},\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728\u91cd\u65b0\u9884\u5360\uff0c\u7ee7\u7eed\u6267\u884c", (Object)inventoryOperateReqDto.getSourceNo());
        }
        if (StringUtils.isNotBlank((CharSequence)((CsInventoryOperateCargoReqDto)commonList.get(0)).getBatch())) {
            Boolean commonApprovePreemptFlag = this.preemptCommonInventory(inventoryOperateReqDto, commonList);
            this.logger.info("approvePassInventoryCommon==>sourceNo:{},commonApprovePreemptFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)commonApprovePreemptFlag);
        }
        commonList.forEach(common -> common.setBatch(null));
        Map<String, List<CsInventoryOperateCargoReqDto>> commonMap = commonList.stream().collect(Collectors.groupingBy(common -> common.getWarehouseCode() + "_" + common.getCargoCode()));
        Set<Map.Entry<String, List<CsInventoryOperateCargoReqDto>>> entrySet = commonMap.entrySet();
        ArrayList updateList = Lists.newArrayList();
        for (Map.Entry<String, List<CsInventoryOperateCargoReqDto>> entry : entrySet) {
            List<CsInventoryOperateCargoReqDto> list = entry.getValue();
            BigDecimal totalChangeInventory = list.stream().map(CsInventoryOperateCargoReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
            CsInventoryOperateCargoReqDto cargoReqDto = list.get(0);
            cargoReqDto.setChangeInventory(totalChangeInventory);
            cargoReqDto.setBatch(null);
            updateList.add(cargoReqDto);
        }
        this.preemptCommonInventory(inventoryOperateReqDto, updateList);
    }

    private void approvePassInventoryAct(CsInventoryOperateReqDto inventoryOperateReqDto) {
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        ArrayList actList = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto actDto : operateCargoReqDtoList) {
            Long activityId = actDto.getActivityId();
            if (null == activityId) continue;
            actList.add(actDto);
        }
        this.logger.info("approvePassInventoryAct==>,sourceNo:{},actList:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(actList));
        if (CollectionUtils.isEmpty((Collection)actList)) {
            return;
        }
        Map<Long, String> activityStatusMap = this.queryActivityStatus(actList);
        Iterator iterator = actList.iterator();
        while (iterator.hasNext()) {
            CsInventoryOperateCargoReqDto next = (CsInventoryOperateCargoReqDto)iterator.next();
            if (!CsActivityInventoryStatusEnum.TERMINATE.getCode().equals(activityStatusMap.get(next.getActivityId()))) continue;
            iterator.remove();
            for (CsInventoryOperateCargoReqDto cargoReqDto : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
                if (null == cargoReqDto.getActivityId() || !cargoReqDto.getActivityId().equals(next.getActivityId())) continue;
                this.logger.info("\u8d27\u54c1\uff1a{}\uff0c\u8fc7\u6ee4\u5df2\u7ed3\u675f\u6d3b\u52a8\uff0cactivityId:{}", (Object)next.getCargoCode(), (Object)next.getActivityId());
                cargoReqDto.setActivityId(null);
            }
        }
        if (CollectionUtils.isEmpty((Collection)actList)) {
            return;
        }
        String sourceType = inventoryOperateReqDto.getSourceType();
        String releaseSourceType = CsInventorySourceTypeEnum.IN_ACT_CANCEL_PREEMPT.getCode();
        if (CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT.getCode().equals(sourceType)) {
            releaseSourceType = CsInventorySourceTypeEnum.IN_ACT_AUDIT_RELEASE.getCode();
        }
        CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto = new CsInventoryReleasePreemptOperateReqDto();
        releasePreemptOperateReqDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        releasePreemptOperateReqDto.setSourceType(releaseSourceType);
        releasePreemptOperateReqDto.setActivityFlag(YesNoEnum.YES.getValue());
        try {
            Boolean actApproveReleaseFlag = this.releaseInventoryByPreemption(releasePreemptOperateReqDto);
            this.logger.info("approvePassInventoryAct==>sourceNo:{},actApproveReleaseFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)actApproveReleaseFlag);
        }
        catch (BizException ex) {
            if (!CsInventoryExceptionCode.NO_FOUND_PREEMPT_RECORD.getCode().equals(ex.getCode())) {
                throw new BizException(ex.getCode(), ex.getMessage());
            }
            inventoryOperateReqDto.setNegativeValidate(YesNoEnum.YES.getValue());
            this.logger.info("approvePassInventoryAct==>sourceNo:{},\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728\u91cd\u65b0\u9884\u5360\uff0c\u7ee7\u7eed\u6267\u884c", (Object)inventoryOperateReqDto.getSourceNo());
        }
        Boolean preemptActFlag = this.preemptActInventory(inventoryOperateReqDto, actList);
        this.logger.info("approvePassInventoryAct==>sourceNo:{},preemptActFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)preemptActFlag);
    }

    @Override
    public Boolean releaseInventoryByPreemption(CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto) {
        this.logger.info("releaseInventoryByPreemption==>\u6839\u636e\u9884\u5360\u8bb0\u5f55\uff0c\u91ca\u653e\u4e4b\u524d\u9884\u5360\u7684\u5e93\u5b58,releasePreemptOperateReqDto:{}", (Object)LogUtils.buildLogContent(releasePreemptOperateReqDto));
        String sourceNo = releasePreemptOperateReqDto.getSourceNo();
        String sourceType = releasePreemptOperateReqDto.getSourceType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo), "\u6765\u6e90\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceType), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List operateCargoReqDtoList = releasePreemptOperateReqDto.getOperateCargoReqDtoList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_no", (Object)sourceNo);
        queryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        List includeSourceTypeList = releasePreemptOperateReqDto.getIncludeSourceTypeList();
        if (CollectionUtils.isNotEmpty((Collection)includeSourceTypeList)) {
            queryWrapper.in((Object)"source_type", (Collection)includeSourceTypeList);
        }
        if (CollectionUtils.isNotEmpty((Collection)operateCargoReqDtoList)) {
            List cargoCodeList = operateCargoReqDtoList.stream().filter(dto -> StringUtils.isBlank((CharSequence)dto.getCargoCode())).map(CsInventoryOperateCargoReqDto::getCargoCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(cargoCodeList)) {
                queryWrapper.in((Object)"cargo_code", cargoCodeList);
            }
            List warehouseCodeList = operateCargoReqDtoList.stream().filter(dto -> StringUtils.isBlank((CharSequence)dto.getWarehouseCode())).map(CsInventoryOperateCargoReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(cargoCodeList)) {
                queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
            }
        }
        Integer activityFlag = releasePreemptOperateReqDto.getActivityFlag();
        if (YesNoEnum.YES.getValue().equals(activityFlag)) {
            queryWrapper.eq((Object)"activity_flag", (Object)YesNoEnum.YES.getValue());
        } else if (YesNoEnum.NO.getValue().equals(activityFlag)) {
            queryWrapper.eq((Object)"activity_flag", (Object)YesNoEnum.NO.getValue());
        }
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csInventoryPreemptionEoList = this.csInventoryPreemptionMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)csInventoryPreemptionEoList)) {
            this.logger.error("releasePreemptionInfo==>\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55,sourceNo:{}", (Object)sourceNo);
            throw new BizException(CsInventoryExceptionCode.NO_FOUND_PREEMPT_RECORD.getCode(), "\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55");
        }
        CsInventoryOperateReqDto releaseOperateReqDto = new CsInventoryOperateReqDto();
        releaseOperateReqDto.setSourceNo(releasePreemptOperateReqDto.getSourceNo());
        releaseOperateReqDto.setSourceType(sourceType);
        releaseOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        ArrayList releaseBatchCargoReqDtoList = Lists.newArrayList();
        ArrayList releaseUnBatchCargoReqDtoList = Lists.newArrayList();
        for (CsInventoryPreemptionEo csInventoryPreemptionEo : csInventoryPreemptionEoList) {
            CsInventoryOperateCargoReqDto releaseCargoReqDto = new CsInventoryOperateCargoReqDto();
            releaseCargoReqDto.setCargoCode(csInventoryPreemptionEo.getCargoCode());
            releaseCargoReqDto.setWarehouseCode(csInventoryPreemptionEo.getWarehouseCode());
            releaseCargoReqDto.setChangeInventory(csInventoryPreemptionEo.getPreemptNum());
            releaseCargoReqDto.setBatch(csInventoryPreemptionEo.getBatch());
            releaseCargoReqDto.setActivityId(csInventoryPreemptionEo.getActivityId());
            if (StringUtils.isNotBlank((CharSequence)releaseCargoReqDto.getBatch())) {
                releaseBatchCargoReqDtoList.add(releaseCargoReqDto);
                continue;
            }
            releaseUnBatchCargoReqDtoList.add(releaseCargoReqDto);
        }
        Boolean releaseBatchInventory = true;
        if (CollectionUtils.isNotEmpty((Collection)releaseBatchCargoReqDtoList)) {
            ArrayList updateList = Lists.newArrayList();
            Map<String, List<CsInventoryOperateCargoReqDto>> cargoMap = releaseBatchCargoReqDtoList.stream().collect(Collectors.groupingBy(dto -> dto.getWarehouseCode() + "_" + dto.getCargoCode() + "_" + dto.getBatch() + "_" + dto.getActivityId()));
            Set<Map.Entry<String, List<CsInventoryOperateCargoReqDto>>> entrySet = cargoMap.entrySet();
            for (Map.Entry<String, List<CsInventoryOperateCargoReqDto>> entry : entrySet) {
                List<CsInventoryOperateCargoReqDto> list = entry.getValue();
                BigDecimal totalChangeInventory = list.stream().map(CsInventoryOperateCargoReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
                CsInventoryOperateCargoReqDto cargoReqDto = list.get(0);
                cargoReqDto.setChangeInventory(totalChangeInventory);
                updateList.add(cargoReqDto);
                releaseOperateReqDto.setOperateCargoReqDtoList((List)updateList);
            }
            releaseBatchInventory = this.releaseInventory(releaseOperateReqDto, false);
        }
        Boolean releaseTotalInventory = true;
        if (CollectionUtils.isNotEmpty((Collection)releaseUnBatchCargoReqDtoList)) {
            ArrayList updateList = Lists.newArrayList();
            Map<String, List<CsInventoryOperateCargoReqDto>> cargoMap = releaseUnBatchCargoReqDtoList.stream().collect(Collectors.groupingBy(dto -> dto.getWarehouseCode() + "_" + dto.getCargoCode() + "_" + dto.getActivityId()));
            Set<Map.Entry<String, List<CsInventoryOperateCargoReqDto>>> entrySet = cargoMap.entrySet();
            for (Map.Entry<String, List<CsInventoryOperateCargoReqDto>> entry : entrySet) {
                List<CsInventoryOperateCargoReqDto> list = entry.getValue();
                BigDecimal totalChangeInventory = list.stream().map(CsInventoryOperateCargoReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
                CsInventoryOperateCargoReqDto cargoReqDto = list.get(0);
                cargoReqDto.setChangeInventory(totalChangeInventory);
                updateList.add(cargoReqDto);
            }
            releaseOperateReqDto.setOperateCargoReqDtoList((List)updateList);
            releaseTotalInventory = this.releaseInventory(releaseOperateReqDto, false);
        }
        if (!releaseBatchInventory.booleanValue() || !releaseTotalInventory.booleanValue()) {
            return false;
        }
        return true;
    }

    private void checkParams(CsInventoryInitOperateReqDto csInventoryInitOperateReqDto) {
        AssertUtil.isTrue(null != csInventoryInitOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List warehouseCodeList = csInventoryInitOperateReqDto.getWarehouseCodeList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)warehouseCodeList), "\u4ed3\u5e93\u7f16\u7801\u96c6\u5408\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(warehouseCodeList.size() <= 200, "\u5355\u6b21\u64cd\u4f5c\u5e93\u5b58\u96c6\u5408\u5927\u5c0f\u6700\u5927\u9650\u5236\u4e3a200");
        List operateDetailReqDtoList = csInventoryInitOperateReqDto.getOperateCargoReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)operateDetailReqDtoList), "\u8d27\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInventoryOperateCargoReqDto inventoryOperateDetailReqDto : operateDetailReqDtoList) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getCargoCode()), "\u8d27\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(null != inventoryOperateDetailReqDto.getChangeInventory(), "\u53d8\u52a8\u5e93\u5b58\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkParams2(List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(operateCargoReqDtoList), "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(operateCargoReqDtoList.size() <= 10000, "\u5355\u6b21\u64cd\u4f5c\u5e93\u5b58\u96c6\u5408\u5927\u5c0f\u6700\u5927\u9650\u5236\u4e3a10000");
        for (CsInventoryOperateCargoReqDto inventoryOperateDetailReqDto : operateCargoReqDtoList) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getCargoCode()), "\u8d27\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getBatch()), "\u8d27\u54c1\u6279\u6b21\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(null != inventoryOperateDetailReqDto.getChangeInventory(), "\u53d8\u52a8\u5e93\u5b58\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Boolean deductionActInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList) {
        CsInventoryOperateReqDto actOperateReqDto = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)actOperateReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        actOperateReqDto.setOperateCargoReqDtoList(actCargoList);
        Map<Long, String> activityStatusMap = this.queryActivityStatus(actCargoList);
        ArrayList activityList = Lists.newArrayList();
        ArrayList logicList = Lists.newArrayList();
        ArrayList physicList = Lists.newArrayList();
        this.joinCargoList(actCargoList, activityStatusMap, activityList, logicList, physicList);
        ICsInventoryBasicsService activityInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.ACTIVITY.getCode());
        this.logger.info("deductionActInventory==>\u5904\u7406\u6d3b\u52a8\u5e93\u5b58,sourceNo:{},activityInventoryService:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(activityInventoryService));
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(inventoryOperateReqDto.getInOutFlag());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.ACTIVITY.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        csInventoryInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        csInventoryInOutBasicsDto.setUpdateAvailableFlag(YesNoEnum.NO.getValue());
        if (CollectionUtils.isNotEmpty((Collection)activityList)) {
            csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)activityList);
            Boolean commonFlag = activityInventoryService.outInventory(csInventoryInOutBasicsDto);
            this.logger.info("deductionActInventory==>\u5904\u7406\u6d3b\u52a8\u5e93\u5b58,\u51fa\u5e93\u540e\u7684\u64cd\u4f5c\u7ed3\u679c,sourceNo:{},commonFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(commonFlag));
        }
        ICsInventoryBasicsService logicInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)logicList);
        logicInventoryService.outInventory(csInventoryInOutBasicsDto);
        ICsInventoryBasicsService physicInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.PHYSICS.getCode());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)physicList);
        physicInventoryService.outInventory(csInventoryInOutBasicsDto);
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        logicList.forEach(e -> e.setBatch(null));
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)logicList);
        logicInventoryService.outInventory(csInventoryInOutBasicsDto);
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        physicList.forEach(e -> e.setBatch(null));
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)physicList);
        physicInventoryService.outInventory(csInventoryInOutBasicsDto);
        for (CsInventoryInOutBasicsCargoDto dto : logicList) {
            CsInventoryPreemptionEo eo = new CsInventoryPreemptionEo();
            eo.setSourceType(CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT.getCode());
            eo.setActivityId(dto.getActivityId());
            eo.setCargoCode(dto.getCargoCode());
            eo.setBatch(dto.getBatch());
            eo.setWarehouseCode(dto.getWarehouseCode());
            eo.setPreemptNum(null == dto.getCompleted() ? BigDecimal.valueOf(0L) : dto.getCompleted());
            if (StringUtils.isEmpty((CharSequence)eo.getWarehouseCode()) || StringUtils.isEmpty((CharSequence)eo.getWarehouseCode()) || StringUtils.isEmpty((CharSequence)eo.getBatch()) || null == eo.getActivityId()) continue;
            this.logger.info("deductionActInventory==>\u5904\u7406\u6d3b\u52a8\u5e93\u5b58,\u66f4\u65b0\u6d3b\u52a8\u9884\u5360\u6570\u91cf\u8bb0\u5f55");
            this.csInventoryPreemptionMapper.updatePreempt(eo);
        }
        return true;
    }

    private Boolean deductionActInventory1(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList) {
        List activityIdList = actCargoList.stream().map(CsInventoryOperateCargoReqDto::getActivityId).distinct().collect(Collectors.toList());
        QueryWrapper activityInventoryEoQueryWrapper = new QueryWrapper();
        activityInventoryEoQueryWrapper.in((Object)"activity_id", activityIdList);
        List csActivityInventoryEoList = this.csActivityInventoryMapper.selectList((Wrapper)activityInventoryEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csActivityInventoryEoList), "\u67e5\u8be2\u4e0d\u5230\u6d3b\u52a8\u4fe1\u606f");
        Map<Long, List<CsActivityInventoryEo>> actListMap = csActivityInventoryEoList.stream().collect(Collectors.groupingBy(CsActivityInventoryEo::getActivityId));
        ArrayList actDtoList = Lists.newArrayList();
        ArrayList logicDtoList = Lists.newArrayList();
        ArrayList physicsDtoList = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto cargoDto : actCargoList) {
            CsInventoryInOutBasicsCargoDto actBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            CsInventoryInOutBasicsCargoDto logicBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            CsInventoryInOutBasicsCargoDto physicsBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            actDtoList.add(actBasicsCargoDto);
            logicDtoList.add(logicBasicsCargoDto);
            physicsDtoList.add(physicsBasicsCargoDto);
            actBasicsCargoDto.setWarehouseCode(cargoDto.getWarehouseCode());
            actBasicsCargoDto.setBatch(cargoDto.getBatch());
            actBasicsCargoDto.setExpireTime(cargoDto.getExpireTime());
            actBasicsCargoDto.setProduceTime(cargoDto.getProduceTime());
            actBasicsCargoDto.setCargoCode(cargoDto.getCargoCode());
            actBasicsCargoDto.setActivityFlag(YesNoEnum.YES.getValue());
            actBasicsCargoDto.setActivityId(cargoDto.getActivityId());
            CubeBeanUtils.copyProperties((Object)logicBasicsCargoDto, (Object)actBasicsCargoDto, (String[])new String[0]);
            CubeBeanUtils.copyProperties((Object)physicsBasicsCargoDto, (Object)actBasicsCargoDto, (String[])new String[0]);
            logicBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            logicBasicsCargoDto.setActivityId(null);
            physicsBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            physicsBasicsCargoDto.setActivityId(null);
            Long activityId = cargoDto.getActivityId();
            List<CsActivityInventoryEo> eoList = actListMap.get(activityId);
            if (CollectionUtils.isEmpty(eoList)) continue;
            CsActivityInventoryEo csActivityInventoryEo = eoList.get(0);
            String finishFlag = csActivityInventoryEo.getFinishFlag();
            this.deductionActInventoryCalculate(cargoDto, actBasicsCargoDto, logicBasicsCargoDto, physicsBasicsCargoDto, finishFlag);
        }
        CsInventoryInOutBasicsDto actInOutBasicsDto = new CsInventoryInOutBasicsDto();
        actInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.ACTIVITY.getCode());
        actInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        actInOutBasicsDto.setUpdateAvailableFlag(YesNoEnum.NO.getValue());
        actInOutBasicsDto.setNegativeValidate(YesNoEnum.YES.getValue());
        actInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        actInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        actInOutBasicsDto.setInOutBasicsCargoDtoList((List)actDtoList);
        CsInventoryInOutBasicsDto logicInOutBasicsDto = new CsInventoryInOutBasicsDto();
        logicInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        logicInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        logicInOutBasicsDto.setUpdateAvailableFlag(YesNoEnum.NO.getValue());
        logicInOutBasicsDto.setNegativeValidate(YesNoEnum.YES.getValue());
        logicInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        logicInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        logicInOutBasicsDto.setInOutBasicsCargoDtoList((List)logicDtoList);
        CsInventoryInOutBasicsDto physicsInOutBasicsDto = new CsInventoryInOutBasicsDto();
        physicsInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        physicsInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        physicsInOutBasicsDto.setUpdateAvailableFlag(YesNoEnum.YES.getValue());
        physicsInOutBasicsDto.setNegativeValidate(YesNoEnum.YES.getValue());
        physicsInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        physicsInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        physicsInOutBasicsDto.setInOutBasicsCargoDtoList((List)logicDtoList);
        ICsInventoryBasicsService actInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.ACTIVITY.getCode());
        ICsInventoryBasicsService logicInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.LOGIC.getCode());
        ICsInventoryBasicsService physicsInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.PHYSICS.getCode());
        Boolean actFlag = actInventoryService.outInventory(actInOutBasicsDto);
        this.logger.info("deductionActInventory==>\u64cd\u4f5c\u6d3b\u52a8\u5e93\u5b58,actFlag:{}", (Object)actFlag);
        Boolean logicFlag = logicInventoryService.outInventory(logicInOutBasicsDto);
        logicInOutBasicsDto.getInOutBasicsCargoDtoList().forEach(dto -> dto.setBatch(null));
        logicInventoryService.outInventory(logicInOutBasicsDto);
        this.logger.info("deductionActInventory==>\u64cd\u4f5c\u903b\u8f91\u5e93\u5b58,logicFlag:{}", (Object)logicFlag);
        Boolean physicsFlag = physicsInventoryService.outInventory(physicsInOutBasicsDto);
        physicsInOutBasicsDto.getInOutBasicsCargoDtoList().forEach(dto -> dto.setBatch(null));
        physicsInventoryService.outInventory(physicsInOutBasicsDto);
        this.logger.info("deductionActInventory==>\u64cd\u4f5c\u7269\u7406\u5e93\u5b58,physicsFlag:{}", (Object)physicsFlag);
        return true;
    }

    private void deductionActInventoryCalculate(CsInventoryOperateCargoReqDto cargoDto, CsInventoryInOutBasicsCargoDto actBasicsCargoDto, CsInventoryInOutBasicsCargoDto logicBasicsCargoDto, CsInventoryInOutBasicsCargoDto physicsBasicsCargoDto, String finishFlag) {
        this.logger.info("deductionActInventoryCalculate==>cargoDto:{}", (Object)LogUtils.buildLogContent(cargoDto));
        if (CsActivityInventoryStatusEnum.ONGOING.getCode().equals(finishFlag)) {
            physicsBasicsCargoDto.setBalance(cargoDto.getChangeInventory().abs().negate());
            logicBasicsCargoDto.setBalance(cargoDto.getChangeInventory().abs().negate());
            logicBasicsCargoDto.setActivityAllocate(cargoDto.getChangeInventory().abs().negate());
            actBasicsCargoDto.setBalance(cargoDto.getChangeInventory().abs().negate());
            actBasicsCargoDto.setPreempt(cargoDto.getChangeInventory().abs().negate());
        } else if (CsActivityInventoryStatusEnum.TERMINATE.getCode().equals(finishFlag)) {
            physicsBasicsCargoDto.setBalance(cargoDto.getChangeInventory().abs().negate());
            logicBasicsCargoDto.setBalance(cargoDto.getChangeInventory().abs().negate());
            logicBasicsCargoDto.setActivityAllocate(cargoDto.getChangeInventory().abs().negate());
        }
    }

    private Map<Long, String> queryActivityStatus(List<CsInventoryOperateCargoReqDto> actCargoList) {
        List activityIds = actCargoList.stream().map(CsInventoryOperateCargoReqDto::getActivityId).distinct().collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"activity_id", activityIds);
        wrapper.groupBy((Object)"activity_id");
        List csActivityInventoryEos = this.csActivityInventoryMapper.selectList((Wrapper)wrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csActivityInventoryEos), "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        Map<Long, String> activityStatusMap = csActivityInventoryEos.stream().collect(Collectors.toMap(CsActivityInventoryEo::getActivityId, CsActivityInventoryEo::getFinishFlag));
        return activityStatusMap;
    }

    private void joinCargoList(List<CsInventoryOperateCargoReqDto> actCargoList, Map<Long, String> activityStatusMap, List<CsInventoryInOutBasicsCargoDto> activityList, List<CsInventoryInOutBasicsCargoDto> logicList, List<CsInventoryInOutBasicsCargoDto> physicList) {
        for (CsInventoryOperateCargoReqDto cargoReqDto : actCargoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setWarehouseCode(cargoReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(cargoReqDto.getBatch());
            inOutBasicsCargoDto.setExpireTime(cargoReqDto.getExpireTime());
            inOutBasicsCargoDto.setProduceTime(cargoReqDto.getProduceTime());
            inOutBasicsCargoDto.setCargoCode(cargoReqDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.YES.getValue());
            inOutBasicsCargoDto.setActivityId(cargoReqDto.getActivityId());
            inOutBasicsCargoDto.setBalance(cargoReqDto.getChangeInventory().abs().negate());
            inOutBasicsCargoDto.setCompleted(cargoReqDto.getChangeInventory().abs());
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto1 = new CsInventoryInOutBasicsCargoDto();
            CubeBeanUtils.copyProperties((Object)inOutBasicsCargoDto1, (Object)inOutBasicsCargoDto, (String[])new String[0]);
            if (CsActivityInventoryStatusEnum.ONGOING.getCode().equals(activityStatusMap.get(cargoReqDto.getActivityId()))) {
                CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto2 = new CsInventoryInOutBasicsCargoDto();
                CubeBeanUtils.copyProperties((Object)inOutBasicsCargoDto2, (Object)inOutBasicsCargoDto, (String[])new String[0]);
                inOutBasicsCargoDto.setPreempt(cargoReqDto.getChangeInventory().abs().negate());
                activityList.add(inOutBasicsCargoDto);
                inOutBasicsCargoDto2.setActivityAllocate(cargoReqDto.getChangeInventory().abs().negate());
                logicList.add(inOutBasicsCargoDto2);
            } else {
                inOutBasicsCargoDto.setPreempt(cargoReqDto.getChangeInventory().abs().negate());
                logicList.add(inOutBasicsCargoDto);
            }
            inOutBasicsCargoDto1.setAvailable(cargoReqDto.getChangeInventory().abs().negate());
            physicList.add(inOutBasicsCargoDto1);
        }
    }

    private Boolean deductionCommonInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> commonCargoList) {
        this.logger.info("deductionCommonInventory==>\u6263\u51cf\u903b\u8f91\u4ed3\u5e93\u5b58,inventoryOperateReqDto:{},commonCargoList:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto), (Object)LogUtils.buildLogContent(commonCargoList));
        CsInventoryOperateReqDto commonOperateReqDto = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)commonOperateReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        commonOperateReqDto.setOperateCargoReqDtoList(commonCargoList);
        ICsInventoryBasicsService logicInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.LOGIC.getCode());
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(inventoryOperateReqDto.getInOutFlag());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(inventoryOperateReqDto.getNegativeValidate());
        csInventoryInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        csInventoryInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        csInventoryInOutBasicsDto.setUpdateAvailableFlag(YesNoEnum.NO.getValue());
        for (CsInventoryOperateCargoReqDto commonDto : commonCargoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(commonDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setPreempt(commonDto.getChangeInventory().abs().negate());
            inOutBasicsCargoDto.setBalance(commonDto.getChangeInventory().abs().negate());
            inOutBasicsCargoDto.setCompleted(commonDto.getChangeInventory().abs());
            inOutBasicsCargoDto.setWarehouseCode(commonDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(commonDto.getBatch());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        Boolean commonFlag = logicInventoryService.outInventory(csInventoryInOutBasicsDto);
        this.logger.info("deductionCommonInventory==>\u6263\u51cf\u903b\u8f91\u4ed3\u5e93\u5b58,\u51fa\u5e93\u540e\u7684\u64cd\u4f5c\u7ed3\u679c,commonFlag:{}", (Object)LogUtils.buildLogContent(commonFlag));
        csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList().forEach(e -> e.setBatch(null));
        Boolean commonTotalFlag = logicInventoryService.outInventory(csInventoryInOutBasicsDto);
        this.logger.info("deductionCommonInventory==>\u6263\u51cf\u903b\u8f91\u4ed3\u5e93\u5b58,\u51fa\u5e93\u540e\u7684\u64cd\u4f5c\u7ed3\u679c,commonTotalFlag:{}", (Object)LogUtils.buildLogContent(commonTotalFlag));
        return commonFlag != false && commonTotalFlag != false;
    }

    private Boolean deductionCommonPhysicInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> commonCargoList) {
        this.logger.info("deductionCommonPhysicInventory==>\u6263\u51cf\u7269\u7406\u4ed3\u5e93\u5b58,inventoryOperateReqDto:{},commonCargoList:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto), (Object)LogUtils.buildLogContent(commonCargoList));
        CsInventoryOperateReqDto commonOperateReqDto = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)commonOperateReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        commonOperateReqDto.setOperateCargoReqDtoList(commonCargoList);
        ICsInventoryBasicsService physicInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.PHYSICS.getCode());
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(inventoryOperateReqDto.getInOutFlag());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(inventoryOperateReqDto.getNegativeValidate());
        csInventoryInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        csInventoryInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        csInventoryInOutBasicsDto.setUpdateAvailableFlag(YesNoEnum.NO.getValue());
        for (CsInventoryOperateCargoReqDto commonDto : commonCargoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(commonDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setBalance(commonDto.getChangeInventory().abs().negate());
            inOutBasicsCargoDto.setCompleted(commonDto.getChangeInventory().abs());
            inOutBasicsCargoDto.setWarehouseCode(commonDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(commonDto.getBatch());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        Boolean commonFlag = physicInventoryService.outInventory(csInventoryInOutBasicsDto);
        this.logger.info("deductionCommonPhysicInventory==>\u6263\u51cf\u7269\u7406\u4ed3\u5e93\u5b58,\u51fa\u5e93\u540e\u7684\u64cd\u4f5c\u7ed3\u679c,commonFlag:{}", (Object)LogUtils.buildLogContent(commonFlag));
        csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList().forEach(e -> e.setBatch(null));
        Boolean commonTotalFlag = physicInventoryService.outInventory(csInventoryInOutBasicsDto);
        this.logger.info("deductionCommonPhysicInventory==>\u6263\u51cf\u7269\u7406\u4ed3\u5e93\u5b58,\u51fa\u5e93\u540e\u7684\u64cd\u4f5c\u7ed3\u679c,commonTotalFlag:{}", (Object)LogUtils.buildLogContent(commonTotalFlag));
        return commonFlag != false && commonTotalFlag != false;
    }

    private Boolean releaseActInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList) {
        CsInventoryOperateReqDto actOperateReqDto = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)actOperateReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        actOperateReqDto.setOperateCargoReqDtoList(actCargoList);
        Map<Long, String> activityStatusMap = this.queryActivityStatus(actCargoList);
        ArrayList activityList = Lists.newArrayList();
        ArrayList logicList = Lists.newArrayList();
        this.joinCargoListToRelease(actCargoList, activityStatusMap, activityList, logicList);
        ICsInventoryBasicsService activityInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.ACTIVITY.getCode());
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(inventoryOperateReqDto.getInOutFlag());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.ACTIVITY.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        csInventoryInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        if (CsInventorySourceTypeEnum.IN_SALE_RELEASE.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            csInventoryInOutBasicsDto.setSourceType(CsInventorySourceTypeEnum.IN_ACT_CANCEL_PREEMPT.getCode());
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)activityList);
        if (CollectionUtils.isNotEmpty((Collection)activityList)) {
            Boolean commonFlag = activityInventoryService.inInventory(csInventoryInOutBasicsDto);
            this.logger.info("releaseActInventory==>\u91ca\u653e\u9884\u5360\u7684\u6d3b\u52a8\u5e93\u5b58,\u6d3b\u52a8\u5165\u5e93\u540e\u7684\u64cd\u4f5c\u7ed3\u679c,sourceNo:{},commonFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(commonFlag));
        }
        if (CollectionUtils.isNotEmpty((Collection)logicList)) {
            ICsInventoryBasicsService logicInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.LOGIC.getCode());
            csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
            csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)logicList);
            csInventoryInOutBasicsDto.setUpdateTotalFlag(YesNoEnum.YES.getValue());
            Boolean commonFlag = logicInventoryService.inInventory(csInventoryInOutBasicsDto);
            this.logger.info("releaseActInventory==>\u91ca\u653e\u9884\u5360\u7684\u6d3b\u52a8\u5e93\u5b58,\u903b\u8f91\u5165\u5e93\u540e\u7684\u64cd\u4f5c\u7ed3\u679c,sourceNo:{},commonFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(commonFlag));
        }
        return true;
    }

    private void joinCargoListToRelease(List<CsInventoryOperateCargoReqDto> actCargoList, Map<Long, String> activityStatusMap, List<CsInventoryInOutBasicsCargoDto> activityList, List<CsInventoryInOutBasicsCargoDto> logicList) {
        for (CsInventoryOperateCargoReqDto cargoReqDto : actCargoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setWarehouseCode(cargoReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(cargoReqDto.getBatch());
            inOutBasicsCargoDto.setExpireTime(cargoReqDto.getExpireTime());
            inOutBasicsCargoDto.setProduceTime(cargoReqDto.getProduceTime());
            inOutBasicsCargoDto.setCargoCode(cargoReqDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.YES.getValue());
            inOutBasicsCargoDto.setActivityId(cargoReqDto.getActivityId());
            if (CsActivityInventoryStatusEnum.ONGOING.getCode().equals(activityStatusMap.get(cargoReqDto.getActivityId()))) {
                inOutBasicsCargoDto.setPreempt(cargoReqDto.getChangeInventory().abs().negate());
                inOutBasicsCargoDto.setAvailable(cargoReqDto.getChangeInventory().abs());
                activityList.add(inOutBasicsCargoDto);
                continue;
            }
            inOutBasicsCargoDto.setPreempt(cargoReqDto.getChangeInventory().abs().negate());
            inOutBasicsCargoDto.setAvailable(cargoReqDto.getChangeInventory().abs());
            logicList.add(inOutBasicsCargoDto);
        }
    }

    private Boolean releaseCommonInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> commonCargoList) {
        this.logger.info("preemptInventory==>\u91ca\u653e\u9884\u5360\u7684\u903b\u8f91\u4ed3\u5e93\u5b58,inventoryOperateReqDto:{},commonCargoList:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto), (Object)LogUtils.buildLogContent(commonCargoList));
        CsInventoryOperateReqDto commonOperateReqDto = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)commonOperateReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        commonOperateReqDto.setOperateCargoReqDtoList(commonCargoList);
        ICsInventoryBasicsService logicInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.LOGIC.getCode());
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(inventoryOperateReqDto.getInOutFlag());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(inventoryOperateReqDto.getNegativeValidate());
        csInventoryInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        csInventoryInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        csInventoryInOutBasicsDto.setUpdateTotalFlag(inventoryOperateReqDto.getUpdateTotalFlag());
        for (CsInventoryOperateCargoReqDto commonDto : commonCargoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(commonDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setPreempt(commonDto.getChangeInventory().abs().negate());
            inOutBasicsCargoDto.setWarehouseCode(commonDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(commonDto.getBatch());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        Boolean commonFlag = logicInventoryService.inInventory(csInventoryInOutBasicsDto);
        this.logger.info("preemptInventory==>\u91ca\u653e\u9884\u5360\u7684\u903b\u8f91\u4ed3\u5e93\u5b58,\u5165\u5e93\u540e\u7684\u64cd\u4f5c\u7ed3\u679c,commonFlag:{}", (Object)LogUtils.buildLogContent(commonFlag));
        return commonFlag;
    }

    private Boolean preemptActInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList) {
        List<CsInventoryOperateCargoReqDto> csInventoryOperateCargoReqDtoList = this.prepositionActCargoInfo(inventoryOperateReqDto, actCargoList);
        CsInventoryOperateReqDto actOperateReqDto = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)actOperateReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        actOperateReqDto.setOperateCargoReqDtoList(csInventoryOperateCargoReqDtoList);
        ICsInventoryBasicsService activityInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.ACTIVITY.getCode());
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(inventoryOperateReqDto.getInOutFlag());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.ACTIVITY.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.YES.getValue());
        csInventoryInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        csInventoryInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        for (CsInventoryOperateCargoReqDto actDto : csInventoryOperateCargoReqDtoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(actDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.YES.getValue());
            inOutBasicsCargoDto.setPreempt(actDto.getChangeInventory().abs());
            inOutBasicsCargoDto.setWarehouseCode(actDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(actDto.getBatch());
            inOutBasicsCargoDto.setActivityId(actDto.getActivityId());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        Boolean commonFlag = activityInventoryService.outInventory(csInventoryInOutBasicsDto);
        return commonFlag;
    }

    private List<CsInventoryOperateCargoReqDto> prepositionActCargoInfo(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList) {
        this.logger.info("prepositionActiCargoInfo==>sourceNo:{},actCargoList:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(actCargoList));
        if (CollectionUtils.isEmpty(actCargoList)) {
            return Lists.newArrayList();
        }
        List activityIdList = actCargoList.stream().map(CsInventoryOperateCargoReqDto::getActivityId).distinct().collect(Collectors.toList());
        List cargoCodeList = actCargoList.stream().map(CsInventoryOperateCargoReqDto::getCargoCode).distinct().collect(Collectors.toList());
        List warehouseCodeList = actCargoList.stream().map(CsInventoryOperateCargoReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        QueryWrapper actQueryWrapper = new QueryWrapper();
        actQueryWrapper.in((Object)"cargo_code", cargoCodeList);
        actQueryWrapper.in((Object)"activity_id", activityIdList);
        actQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        actQueryWrapper.gt((Object)"available", (Object)BigDecimal.ZERO);
        List activityInventoryEoList = this.csActivityInventoryMapper.selectList((Wrapper)actQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)activityInventoryEoList), "\u67e5\u8be2\u4e0d\u5230\u6d3b\u52a8\u8d27\u54c1\u4fe1\u606f");
        Map<String, List<CsActivityInventoryEo>> csActEoMap = activityInventoryEoList.stream().collect(Collectors.groupingBy(eo -> eo.getActivityId() + "_" + eo.getWarehouseCode() + "_" + eo.getCargoCode()));
        this.logger.info("prepositionActCargoInfo==>\u5206\u7ec4\u540e\u7684\u4fe1\u606f,sourceNo:{},csActEoMap:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(csActEoMap));
        ArrayList csInventoryOperateCargoReqDtoList = Lists.newArrayList();
        block0: for (CsInventoryOperateCargoReqDto cargoReqDto : actCargoList) {
            String key = cargoReqDto.getActivityId() + "_" + cargoReqDto.getWarehouseCode() + "_" + cargoReqDto.getCargoCode();
            List<CsActivityInventoryEo> csActivityInventoryEoList = csActEoMap.get(key);
            if (CollectionUtils.isEmpty(csActivityInventoryEoList)) continue;
            List actBalanceList = csActivityInventoryEoList.stream().sorted(Comparator.comparing(CsActivityInventoryEo::getAvailable).reversed()).collect(Collectors.toList());
            CsActivityInventoryEo csActivityInventoryEo = csActivityInventoryEoList.get(0);
            BigDecimal changeInventory = cargoReqDto.getChangeInventory();
            BigDecimal totalBatchSurplus = csActivityInventoryEoList.stream().map(CsActivityInventoryEo::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.logger.info("prepositionActCargoInfo==>totalBatchSurplus:{}", (Object)totalBatchSurplus);
            if (changeInventory.compareTo(totalBatchSurplus) > 0) {
                this.logger.info("\u5355\u636e\u53f7sourceNo:{},\u8d27\u54c1cargoCode:{}\u6d3b\u52a8\u5269\u4f59\u5e93\u5b58\u4e0d\u8db3,activityCode:{}", new Object[]{inventoryOperateReqDto.getSourceNo(), csActivityInventoryEo.getCargoCode(), csActivityInventoryEo.getCargoCode()});
                throw new BizException(String.format("\u8d27\u54c1\u3010%s\u3011\u6d3b\u52a8\u5269\u4f59\u5e93\u5b58\u4e0d\u8db3", csActivityInventoryEo.getCargoName()));
            }
            for (CsActivityInventoryEo actEo : actBalanceList) {
                BigDecimal available = actEo.getAvailable();
                BigDecimal subtract = available.subtract(changeInventory);
                this.logger.info("prepositionActCargoInfo==>\u6570\u636e\u5bf9\u6bd4,sourceNo:{},available:{},subtract:{},changeInventory:{}", new Object[]{inventoryOperateReqDto.getSourceNo(), available, subtract, changeInventory});
                int compareVal = subtract.compareTo(BigDecimal.ZERO);
                CsInventoryOperateCargoReqDto batchReqDto = new CsInventoryOperateCargoReqDto();
                CubeBeanUtils.copyProperties((Object)batchReqDto, (Object)cargoReqDto, (String[])new String[0]);
                if (StringUtils.isBlank((CharSequence)cargoReqDto.getBatch())) {
                    batchReqDto.setBatch(actEo.getBatch());
                }
                csInventoryOperateCargoReqDtoList.add(batchReqDto);
                if (compareVal >= 0) {
                    batchReqDto.setChangeInventory(changeInventory);
                    continue block0;
                }
                if (compareVal >= 0) continue;
                batchReqDto.setChangeInventory(available);
                changeInventory = subtract.abs();
            }
        }
        return csInventoryOperateCargoReqDtoList;
    }

    @Override
    public Boolean preemptCommonInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> commonCargoList) {
        CsInventoryOperateReqDto commonOperateReqDto = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)commonOperateReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        commonOperateReqDto.setOperateCargoReqDtoList(commonCargoList);
        ICsInventoryBasicsService logicInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.LOGIC.getCode());
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(inventoryOperateReqDto.getInOutFlag());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(inventoryOperateReqDto.getNegativeValidate());
        csInventoryInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        csInventoryInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        csInventoryInOutBasicsDto.setUpdateTotalFlag(inventoryOperateReqDto.getUpdateTotalFlag());
        for (CsInventoryOperateCargoReqDto commonDto : commonCargoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(commonDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setPreempt(commonDto.getChangeInventory().abs());
            inOutBasicsCargoDto.setWarehouseCode(commonDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(commonDto.getBatch());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        Boolean commonFlag = logicInventoryService.outInventory(csInventoryInOutBasicsDto);
        return commonFlag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Integer updateInventoryTotalBalance(String preOrderNo, String type) {
        List<CsInventoryLogEo> inventoryLogEoList = this.updateLogicInventoryTotalBalance(preOrderNo, type);
        if (CollectionUtils.isEmpty(inventoryLogEoList)) {
            return 0;
        }
        this.updatePhysicsInventoryTotalBalance(preOrderNo, type, inventoryLogEoList);
        this.csInventoryLogMapper.insertBatch(inventoryLogEoList);
        return inventoryLogEoList.size();
    }

    private void updatePhysicsInventoryTotalBalance(String preOrderNo, String type, List<CsInventoryLogEo> inventoryLogEoList) {
        List statisticNumVoList = this.csPhysicsInventoryTotalMapper.queryPhysicsInventoryTotalBalance();
        if (CollectionUtils.isNotEmpty((Collection)statisticNumVoList)) {
            for (InventoryStatisticNumVo inventoryStatisticNumVo : statisticNumVoList) {
                CsPhysicsInventoryTotalEo csPhysicsInventoryTotalEo = new CsPhysicsInventoryTotalEo();
                csPhysicsInventoryTotalEo.setId(inventoryStatisticNumVo.getId());
                csPhysicsInventoryTotalEo.setBalance(inventoryStatisticNumVo.getAfterBalance());
                this.csPhysicsInventoryTotalMapper.updateById((BaseEo)csPhysicsInventoryTotalEo);
                CsInventoryLogEo csInventoryLogEo = new CsInventoryLogEo();
                BeanUtils.copyProperties((Object)inventoryStatisticNumVo, (Object)csInventoryLogEo, (String[])new String[]{"id", "beforePreempt"});
                csInventoryLogEo.setChangeBalance(csInventoryLogEo.getAfterBalance().subtract(csInventoryLogEo.getBeforeBalance()));
                csInventoryLogEo.setSourceNo(preOrderNo);
                csInventoryLogEo.setSourceType(type);
                csInventoryLogEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
                inventoryLogEoList.add(csInventoryLogEo);
            }
        }
    }

    private List<CsInventoryLogEo> updateLogicInventoryTotalBalance(String preOrderNo, String type) {
        ArrayList inventoryLogEoList = Lists.newArrayList();
        List statisticNumVoList = this.csLogicInventoryTotalMapper.queryLogicInventoryTotalBalance();
        if (CollectionUtils.isEmpty((Collection)statisticNumVoList)) {
            return null;
        }
        Date nowDate = new Date();
        for (InventoryStatisticNumVo inventoryStatisticNumVo : statisticNumVoList) {
            CsLogicInventoryTotalEo csLogicInventoryTotalEo = new CsLogicInventoryTotalEo();
            csLogicInventoryTotalEo.setId(inventoryStatisticNumVo.getId());
            csLogicInventoryTotalEo.setBalance(inventoryStatisticNumVo.getAfterBalance());
            this.csLogicInventoryTotalMapper.updateById((BaseEo)csLogicInventoryTotalEo);
            CsInventoryLogEo csInventoryLogEo = new CsInventoryLogEo();
            BeanUtils.copyProperties((Object)inventoryStatisticNumVo, (Object)csInventoryLogEo, (String[])new String[]{"id", "beforePreempt"});
            csInventoryLogEo.setChangeBalance(csInventoryLogEo.getAfterBalance().subtract(csInventoryLogEo.getBeforeBalance()));
            csInventoryLogEo.setSourceNo(preOrderNo);
            csInventoryLogEo.setSourceType(type);
            csInventoryLogEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            csInventoryLogEo.setChangeTime(nowDate);
            inventoryLogEoList.add(csInventoryLogEo);
        }
        return inventoryLogEoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Integer updateInventoryTotalPreempt(String preOrderNo, String type) {
        List<CsInventoryLogEo> inventoryLogEoList = this.updateLogicInventoryTotalPreempt(preOrderNo, type);
        if (CollectionUtils.isEmpty(inventoryLogEoList)) {
            return 0;
        }
        this.csInventoryLogMapper.insertBatch(inventoryLogEoList);
        return inventoryLogEoList.size();
    }

    private List<CsInventoryLogEo> updateLogicInventoryTotalPreempt(String preOrderNo, String type) {
        List statisticNumVoList = this.csLogicInventoryTotalMapper.queryInventoryTotalPreempt();
        if (CollectionUtils.isEmpty((Collection)statisticNumVoList)) {
            return null;
        }
        ArrayList inventoryLogEoList = Lists.newArrayList();
        Date nowDate = new Date();
        for (InventoryStatisticNumVo inventoryStatisticNumVo : statisticNumVoList) {
            if (inventoryStatisticNumVo.getBeforeBalance().compareTo(inventoryStatisticNumVo.getAfterPreempt()) < 0) continue;
            CsLogicInventoryTotalEo csLogicInventoryTotalEo = new CsLogicInventoryTotalEo();
            csLogicInventoryTotalEo.setId(inventoryStatisticNumVo.getId());
            csLogicInventoryTotalEo.setPreempt(inventoryStatisticNumVo.getAfterPreempt());
            this.csLogicInventoryTotalMapper.updateById((BaseEo)csLogicInventoryTotalEo);
            CsInventoryLogEo csInventoryLogEo = new CsInventoryLogEo();
            BeanUtils.copyProperties((Object)inventoryStatisticNumVo, (Object)csInventoryLogEo, (String[])new String[]{"id", "beforeBalance"});
            csInventoryLogEo.setChangePreempt(csInventoryLogEo.getAfterPreempt().subtract(csInventoryLogEo.getBeforePreempt()));
            csInventoryLogEo.setSourceNo(preOrderNo);
            csInventoryLogEo.setSourceType(type);
            csInventoryLogEo.setChangeTime(nowDate);
            csInventoryLogEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            inventoryLogEoList.add(csInventoryLogEo);
        }
        return inventoryLogEoList;
    }

    private void checkParams(CsInventoryOperateReqDto inventoryOperateReqDto) {
        AssertUtil.isTrue(null != inventoryOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getSourceNo()), "\u6765\u6e90\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getSourceType()), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Integer negativeValidate = inventoryOperateReqDto.getNegativeValidate();
        if (null == negativeValidate) {
            negativeValidate = YesNoEnum.YES.getValue();
        }
        AssertUtil.isTrue(YesNoEnum.YES.getValue().equals(negativeValidate) || YesNoEnum.NO.getValue().equals(negativeValidate), "\u662f\u5426\u6821\u9a8c\u8d1f\u5e93\u5b58\u53c2\u6570\u6709\u8bef");
        List operateDetailReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)operateDetailReqDtoList), "\u8d27\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInventoryOperateCargoReqDto inventoryOperateDetailReqDto : operateDetailReqDtoList) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getCargoCode()), "\u8d27\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(null != inventoryOperateDetailReqDto.getChangeInventory(), "\u53d8\u52a8\u5e93\u5b58\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void releaseIdempotentCheck(CsInventoryOperateReqDto inventoryOperateReqDto) {
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        this.repeatFilter.checkRepeat("RELEASE_INVENTORY:" + sourceNo + inventoryOperateReqDto.getSourceType() + inventoryOperateReqDto.getSuffix(), () -> this.releasePreValid(sourceNo), true);
    }

    private void deductionIdempotentCheck(CsInventoryOperateReqDto inventoryOperateReqDto) {
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        this.repeatFilter.checkRepeat("DEDUCTION_INVENTORY:" + sourceNo + inventoryOperateReqDto.getSourceType() + inventoryOperateReqDto.getSuffix(), () -> this.releasePreValid(sourceNo), true);
    }

    private void releasePreValid(String sourceNo) {
        QueryWrapper inventoryPreemptionEoQueryWrapper = new QueryWrapper();
        inventoryPreemptionEoQueryWrapper.eq((Object)"source_no", (Object)sourceNo);
        inventoryPreemptionEoQueryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE);
        inventoryPreemptionEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        PageHelper.startPage((int)1, (int)1);
        List csInventoryPreemptionEoList = this.csInventoryPreemptionMapper.selectList((Wrapper)inventoryPreemptionEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csInventoryPreemptionEoList)) {
            throw new BizException("\u6b64\u5355\u636e\u4e0d\u5b58\u5728\u9884\u5360\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u91ca\u653e\u53d1\u8d27");
        }
    }

    private void preemptIdempotentCheck(CsInventoryOperateReqDto inventoryOperateReqDto) {
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        this.repeatFilter.checkRepeat("PREEMPT_INVENTORY:" + sourceNo + inventoryOperateReqDto.getSourceType() + inventoryOperateReqDto.getSuffix(), () -> this.preemptPreValid(sourceNo), true);
    }

    private void preemptPreValid(String sourceNo) {
        List csInventoryPreemptionEoList = this.csInventoryPreemptionMapper.queryBySourceNo(sourceNo, CsValidFlagEnum.ENABLE.getCode());
        if (CollectionUtils.isNotEmpty((Collection)csInventoryPreemptionEoList)) {
            throw new BizException("\u6b64\u5355\u636e\u5df2\u8fdb\u884c\u9884\u5360\u64cd\u4f5c\uff0c\u4e0d\u80fd\u91cd\u590d\u9884\u5360");
        }
    }
}

