/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsLogicInventoryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLogicInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsLogicInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryUpdateReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csLogicInventoryService")
public class CsLogicInventoryServiceImpl
implements ICsLogicInventoryService {
    private static Logger logger = LoggerFactory.getLogger(CsLogicInventoryServiceImpl.class);
    @Autowired
    private CsLogicInventoryDas csLogicInventoryDas;
    @Resource
    private CsLogicInventoryMapper csLogicInventoryMapper;
    @Autowired
    private ICsLogicInventoryQueryService csLogicInventoryQueryService;

    @Override
    public Long add(CsLogicInventoryAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsLogicInventoryEo insertEo = CsLogicInventoryEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csLogicInventoryDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsLogicInventoryUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsLogicInventoryEo updateEo = CsLogicInventoryEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csLogicInventoryDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsLogicInventoryEo eo = this.csLogicInventoryQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csLogicInventoryDas.logicDeleteById(id);
    }

    @Override
    public void updateLogicInventoryAvailable() {
        this.csLogicInventoryMapper.updateLogicInventoryAvailable();
    }
}

