/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.IBrandApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IBrandService;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.BrandEo;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="brandApi")
public class BrandApiImpl
implements IBrandApi {
    @Resource
    private IBrandService brandService;

    public RestResponse<Void> removeById(String ids) {
        String[] idList = StringUtils.split((String)ids, (String)",");
        this.brandService.removeById(idList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeByCode(String brandCode) {
        this.brandService.removeByCode(brandCode);
        return RestResponse.VOID;
    }

    public RestResponse<Long> modifyStatus(Long id, Integer status) {
        BrandEo brandEo = BrandEo.newInstance();
        brandEo.setId(id);
        brandEo.setStatus(status);
        return new RestResponse((Object)this.brandService.updateStatus(brandEo));
    }

    public RestResponse<Long> addBrand(TagReqDto.BrandReqDto requestBrandDto) {
        if (requestBrandDto.getInstanceId() == null || requestBrandDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        BrandEo brandEo = BrandEo.newInstance((Map)requestBrandDto.getExtFields());
        requestBrandDto.setId(null);
        DtoHelper.dto2Eo((BaseVo)requestBrandDto, (BaseEo)brandEo);
        return new RestResponse((Object)this.brandService.addBrand(brandEo));
    }

    public RestResponse<Void> modifyBrand(TagReqDto.BrandReqDto requestBrandDto) {
        if (requestBrandDto.getId() == null || requestBrandDto.getInstanceId() == null || requestBrandDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        BrandEo brandEo = BrandEo.newInstance((Map)requestBrandDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)requestBrandDto, (BaseEo)brandEo);
        this.brandService.modifyBrand(brandEo);
        return RestResponse.SUCCESS;
    }
}

