/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.UnitTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IUnitService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="unitQueryApi")
public class UnitQueryApiImpl
implements IUnitQueryApi {
    @Resource
    private IUnitService unitService;

    public RestResponse<UnitRespDto> queryById(Long id) {
        return new RestResponse((Object)this.unitService.queryById(id));
    }

    public RestResponse<PageInfo<UnitRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.unitService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<List<UnitRespDto>> queryList(String filter) {
        return new RestResponse(this.unitService.queryList(filter));
    }

    public RestResponse<List<UnitRespDto>> queryByType(String type) {
        return new RestResponse(this.unitService.queryByType(type));
    }

    public RestResponse<List<Map<String, String>>> queryUnitType() {
        List<UnitTypeEnum> unitTypeEnums = this.unitService.queryUnitType();
        ArrayList res = new ArrayList();
        for (UnitTypeEnum unitTypeEnum : unitTypeEnums) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", unitTypeEnum.getTypeCode());
            map.put("name", unitTypeEnum.getDesc());
            res.add(map);
        }
        return new RestResponse(res);
    }

    public RestResponse<List<UnitRespDto>> queryByIds(String unitIds) {
        String[] ids;
        ArrayList<Long> unitIdList = new ArrayList<Long>();
        for (String id : ids = unitIds.trim().split(",")) {
            unitIdList.add(Long.parseLong(id));
        }
        return new RestResponse(this.unitService.queryByIds(unitIdList));
    }
}

