/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DistributionSetReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemCycleBuyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemOnShelfReqListDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirsItemsRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DistributionSetRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemCycleBuyRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfIntegralRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDistributionSetService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemCycleBuyService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.shop.api.dto.message.ShopChangeMessageDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@MQDesc(tag="SHOP_CHANGE")
public class ShopChangeProcess
implements IMessageProcessor<MessageVo> {
    private Logger logger = LoggerFactory.getLogger(ShopChangeProcess.class);
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemApi itemApi;
    @Resource
    private IItemService itemService;
    @Resource
    private IDistributionSetService distributionSetService;
    @Resource
    private IItemCycleBuyService itemCycleBuyService;

    public MessageResponse process(MessageVo message) {
        this.logger.info("\u6536\u5230\u5e97\u94fa\u533a\u57df\u53d8\u66f4\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)message));
        try {
            ShopChangeMessageDto shopChangeMessageDto = (ShopChangeMessageDto)JSON.parseObject((String)message.getData().toString(), ShopChangeMessageDto.class);
            int itemTotalNum = 0;
            int pageNum = 1;
            int pageSize = 1000;
            Long shopId = Long.valueOf(shopChangeMessageDto.getShopId());
            ItemShelfQueryReqDto queryReqDto = new ItemShelfQueryReqDto();
            queryReqDto.setShopId(shopId);
            queryReqDto.setItemStatus(ItemStatus.ITEM_ONSHELF.getStatus());
            PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryShelfItemByPage(queryReqDto, Integer.valueOf(pageNum), Integer.valueOf(pageSize)).getData();
            while (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                for (ItemShelfQueryRespDto itemShelfDto : pageInfo.getList()) {
                    try {
                        ShelfReqDto shelfReqDto = new ShelfReqDto();
                        shelfReqDto.setShopId(shopId);
                        shelfReqDto.setItemId(itemShelfDto.getItemId());
                        List<ItemShelfRespDto> shelfRespDtos = this.itemService.queryItemShelfList(shelfReqDto);
                        List<DirsItemsRespDto> dirItems = this.itemService.queryDirsItems(shopId, itemShelfDto.getItemId());
                        Map<String, List<DirsItemsRespDto>> dirItemMap = dirItems.stream().collect(Collectors.groupingBy(dto -> dto.getSkuId() + String.valueOf(dto.getBusType())));
                        ArrayList itemShelfReqDtos = Lists.newArrayList();
                        for (ItemShelfRespDto itemShelfRespDto : shelfRespDtos) {
                            List<DirsItemsRespDto> skuDirList = dirItemMap.get(itemShelfRespDto.getSkuId() + String.valueOf(itemShelfRespDto.getBusType()));
                            for (DirsItemsRespDto dirItem : skuDirList) {
                                ItemShelfReqDto itemShelfReqDto = this.getItemShelfReqDto(itemShelfRespDto, dirItem.getDirId(), dirItem.getDirType());
                                itemShelfReqDtos.add(itemShelfReqDto);
                            }
                        }
                        ItemOnShelfReqListDto itemOnShelfReqListDto = new ItemOnShelfReqListDto();
                        if (Integer.valueOf(2).equals(shelfRespDtos.get(0).getType())) {
                            List<ItemCycleBuyRespDto> cycleBuyRespDtos = this.itemCycleBuyService.getCycleBuyByShopItem(shopId, itemShelfDto.getItemId());
                            ArrayList cycleBuyReqDtoList = Lists.newArrayList();
                            CubeBeanUtils.copyCollection((Collection)cycleBuyReqDtoList, cycleBuyRespDtos, ItemCycleBuyReqDto.class);
                            itemOnShelfReqListDto.setCycleBuyReqDtos((List)cycleBuyReqDtoList);
                        }
                        itemOnShelfReqListDto.setReshelf(Boolean.valueOf(true));
                        itemOnShelfReqListDto.setItemShelfReqDtos((List)itemShelfReqDtos);
                        this.itemApi.onShelfItem(itemOnShelfReqListDto);
                        ++itemTotalNum;
                    }
                    catch (Exception e) {
                        this.logger.error("\u5e97\u94fa\u53d8\u66f4\u5546\u54c1\u91cd\u65b0\u4e0a\u67b6\u5931\u8d25\uff0cshopId={},itemId={}", new Object[]{shopId, itemShelfDto.getItemId(), e});
                    }
                }
                pageInfo = (PageInfo)this.itemQueryApi.queryShelfItemByPage(queryReqDto, Integer.valueOf(++pageNum), Integer.valueOf(pageSize)).getData();
            }
            this.logger.info("\u5e97\u94fa\u533a\u57df\u53d8\u66f4\u91cd\u65b0\u4e0a\u67b6\u5546\u54c1\u7684\u603b\u6570\uff1a{}\uff0cshopId={}\uff0c", (Object)itemTotalNum, (Object)shopId);
        }
        catch (Exception e) {
            this.logger.error("\u5e97\u94fa\u533a\u57df\u53d8\u66f4\u6d88\u606f\u91cd\u65b0\u4e0a\u67b6\u5546\u54c1\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }

    private ItemShelfReqDto getItemShelfReqDto(ItemShelfRespDto itemShelfRespDto, Long dirId, String dirType) {
        ShelfIntegralRespDto integralRespDto;
        ItemShelfReqDto shelfReqDto = new ItemShelfReqDto();
        shelfReqDto.setDirId(dirId);
        shelfReqDto.setItemId(itemShelfRespDto.getItemId());
        shelfReqDto.setSkuId(itemShelfRespDto.getSkuId());
        shelfReqDto.setInstanceId(itemShelfRespDto.getInstanceId());
        shelfReqDto.setTenantId(itemShelfRespDto.getTenantId());
        shelfReqDto.setShopId(itemShelfRespDto.getShopId());
        shelfReqDto.setSellerId(itemShelfRespDto.getSellerId());
        shelfReqDto.setOrganizationId(itemShelfRespDto.getOrganizationId());
        shelfReqDto.setOrganizationName(itemShelfRespDto.getOrganizationName());
        shelfReqDto.setPrice(itemShelfRespDto.getPrice());
        shelfReqDto.setDirType(dirType);
        shelfReqDto.setItemType(itemShelfRespDto.getItemType());
        shelfReqDto.setBusType(itemShelfRespDto.getBusType());
        shelfReqDto.setType(itemShelfRespDto.getType());
        shelfReqDto.setDistribution(itemShelfRespDto.getDistribution());
        if (Integer.valueOf(1).equals(itemShelfRespDto.getDistribution())) {
            DistributionSetReqDto setReqDto = new DistributionSetReqDto();
            setReqDto.setSkuId(itemShelfRespDto.getSkuId());
            setReqDto.setShopId(itemShelfRespDto.getShopId());
            List<DistributionSetRespDto> distributionSetRespDtos = this.distributionSetService.queryList(setReqDto);
            if (CollectionUtils.isNotEmpty(distributionSetRespDtos)) {
                DistributionSetReqDto distributionSet = new DistributionSetReqDto();
                CubeBeanUtils.copyProperties((Object)distributionSet, (Object)distributionSetRespDtos.get(0), (String[])new String[0]);
                shelfReqDto.setDistributionSet(distributionSet);
            }
        }
        if (null != (integralRespDto = itemShelfRespDto.getShelfIntegral())) {
            shelfReqDto.setCashIntegral(integralRespDto.getCashIntegral());
            shelfReqDto.setCashLimit(integralRespDto.getCashLimit());
            shelfReqDto.setCashAmount(integralRespDto.getCashAmount());
            shelfReqDto.setCashType(integralRespDto.getCashType());
            shelfReqDto.setRuleRemark(integralRespDto.getRuleRemark());
        }
        return shelfReqDto;
    }
}

