/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.DirSortEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectorySortUpdateDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.RootDirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirIndexRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.plugin.EnableCachePlugin;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.contants.ItemConstant;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirIndexDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirIndexEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirRelationEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="directoryItemService")
public class DirectoryItemServiceImpl
implements IDirectoryItemService {
    @Resource
    private DirDas dirDas;
    @Resource
    private DirIndexDas dirIndexDas;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private DirRelationDas dirRelationDas;
    @Autowired
    private IDirectoryService directoryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDirectoryItem(DirEo dir, List<Long> links) {
        if (!ItemConstant.ROOT_NODE.equals(dir.getParentId()) && dir.getParentId() != null) {
            DirEo parent = (DirEo)this.dirDas.selectByPrimaryKey(dir.getParentId());
            if (null == parent) {
                throw new RuntimeException("\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff0c \u4e0d\u5141\u8bb8\u65b0\u589e");
            }
            if (parent.getRootId() == 0L) {
                dir.setRootId(dir.getParentId());
            } else {
                dir.setRootId(parent.getRootId());
            }
            dir.setLv(parent.getRv());
            dir.setRv(Integer.valueOf(parent.getRv() + 1));
            this.dirDas.updateForInsert(dir);
        } else {
            dir.setLv(Integer.valueOf(1));
            dir.setRv(Integer.valueOf(2));
        }
        DirEo directoryItemEo = new DirEo();
        directoryItemEo.setParentId(dir.getParentId());
        directoryItemEo.setInstanceId(dir.getInstanceId());
        directoryItemEo.setTenantId(dir.getTenantId());
        dir.setSort(Integer.valueOf(this.dirDas.count((BaseEo)directoryItemEo)));
        this.dirDas.insert((BaseEo)dir);
        if (ItemConstant.ROOT_NODE.equals(dir.getParentId()) || null == dir.getParentId()) {
            dir.setRootId(dir.getId());
            this.dirDas.updateSelective((BaseEo)dir);
        }
        if (CollectionUtils.isEmpty(links)) {
            return;
        }
        for (Long linkDirId : links) {
            if (linkDirId == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
            DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(linkDirId);
            if (dirEo == null || !dir.getTenantId().equals(dirEo.getTenantId())) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
            }
            DirRelationEo dirRelationEo = new DirRelationEo();
            dirRelationEo.setDirId(dir.getId());
            dirRelationEo.setLinkDirId(linkDirId);
            dirRelationEo.setInstanceId(dir.getInstanceId());
            dirRelationEo.setTenantId(dir.getTenantId());
            this.dirRelationDas.insert((BaseEo)dirRelationEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteDirectoryItem(Long id) {
        if (id == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        DirEo example = DirEo.newInstance();
        example.setParentId(id);
        if (this.dirDas.count((BaseEo)example) > 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EXIST_DIR_CHILD);
        }
        DirEo dir = (DirEo)this.dirDas.selectByPrimaryKey(id);
        if (dir == null) {
            return;
        }
        this.dirDas.logicDeleteById(id);
        if (!ItemConstant.ROOT_NODE.equals(dir.getParentId())) {
            this.dirDas.updateForDelete(dir);
        }
    }

    @Override
    public List<DirEo> queryDirectoryItem(DirEo dirExample) {
        if (dirExample == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        return this.dirDas.select((BaseEo)dirExample);
    }

    @Override
    public List<DirEo> queryByIds(List<Long> ids) {
        DirEo dirExample = DirEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        dirExample.setSqlFilters(sqlFilters);
        return this.queryDirectoryItem(dirExample);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDirectoryItem(DirEo dir, List<Long> linkDirIdList) {
        if (dir == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(dir.getId());
        if (dirEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
        }
        this.dirDas.updateSelective((BaseEo)dir);
        if (dir.getLink() == null && dirEo.getLink() != null) {
            dirEo = (DirEo)this.dirDas.selectByPrimaryKey(dir.getId());
            dirEo.setLink(null);
            this.dirDas.update((BaseEo)dirEo);
        }
        DirRelationEo dirRelationEo = new DirRelationEo();
        dirRelationEo.setDirId(dirEo.getId());
        dirRelationEo.setInstanceId(dirEo.getInstanceId());
        dirRelationEo.setTenantId(dirEo.getTenantId());
        this.dirRelationDas.delete((BaseEo)dirRelationEo);
        if (CollectionUtils.isEmpty(linkDirIdList)) {
            return;
        }
        for (Long linkDirId : linkDirIdList) {
            DirEo checkDirEo = (DirEo)this.dirDas.selectByPrimaryKey(linkDirId);
            if (checkDirEo == null || !checkDirEo.getTenantId().equals(dirEo.getTenantId())) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
            dirRelationEo = new DirRelationEo();
            dirRelationEo.setDirId(dirEo.getId());
            dirRelationEo.setLinkDirId(linkDirId);
            dirRelationEo.setInstanceId(dirEo.getInstanceId());
            dirRelationEo.setTenantId(dirEo.getTenantId());
            this.dirRelationDas.insert((BaseEo)dirRelationEo);
        }
    }

    @Override
    public List<TreeDto<DirectoryItemRespDto>> queryDirByRootIds(List<Long> rootIds, Integer status) {
        ArrayList<TreeDto<DirectoryItemRespDto>> trees = new ArrayList<TreeDto<DirectoryItemRespDto>>();
        if (CollectionUtils.isEmpty(rootIds)) {
            return null;
        }
        DirEo dirEo = new DirEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(rootIds, (String)",")));
        dirEo.setSqlFilters(sqlFilterList);
        dirEo.setOrderBy("sort");
        dirEo.setStatus(status);
        List dirEoList = this.dirDas.select((BaseEo)dirEo);
        for (DirEo eo : dirEoList) {
            List<DirEo> dirList = this.queryDirByRootId(eo.getId(), status);
            if (!CollectionUtils.isNotEmpty(dirList)) continue;
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList(dirList, dtoList, DirectoryItemRespDto.class);
            List tree = TreeDto.createTreeDto(dtoList);
            trees.addAll(tree);
        }
        return trees;
    }

    @Override
    public void initTree() {
        DirEo example = DirEo.newInstance();
        example.setOrderBy("sort");
        List roots = this.dirDas.select((BaseEo)example);
        List trees = TreeDto.createTreeDto((List)roots);
        for (TreeDto treeDto : trees) {
            this.updateLvRv((TreeDto<DirEo>)treeDto, 0);
        }
    }

    private int updateLvRv(TreeDto<DirEo> tree, int index) {
        Stack<TreeDto> stack = new Stack<TreeDto>();
        DirEo updateEo = DirEo.newInstance();
        updateEo.setId(((DirEo)tree.getNode()).getId());
        updateEo.setLv(Integer.valueOf(index + 1));
        if (CollectionUtils.isNotEmpty((Collection)tree.getChildren())) {
            for (TreeDto treeDto : tree.getChildren()) {
                stack.push(treeDto);
            }
            int rv = index + 1;
            while (!stack.empty()) {
                tree = (TreeDto)stack.pop();
                if (null == tree) continue;
                if (CollectionUtils.isNotEmpty((Collection)tree.getChildren())) {
                    rv = this.updateLvRv((TreeDto<DirEo>)tree, rv) + 1;
                    continue;
                }
                rv = this.updateLvRv((TreeDto<DirEo>)tree, rv);
            }
            updateEo.setRv(Integer.valueOf(rv + 1));
            this.dirDas.updateSelective((BaseEo)updateEo);
            return rv;
        }
        updateEo.setRv(Integer.valueOf(index + 2));
        this.dirDas.updateSelective((BaseEo)updateEo);
        return index + 2;
    }

    private List<DirEo> queryDirByRootId(Long rootId, Integer status) {
        DirEo dir = (DirEo)this.dirDas.selectByPrimaryKey(rootId);
        if (null == dir) {
            return null;
        }
        DirEo example = DirEo.newInstance();
        example.setRootId(dir.getRootId());
        example.setOrderBy("sort");
        example.setStatus(status);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.lt((String)"rv", (Object)dir.getRv()));
        sqlFilters.add(SqlFilter.gt((String)"lv", (Object)dir.getLv()));
        example.setSqlFilters(sqlFilters);
        List dirs = this.dirDas.select((BaseEo)example);
        dirs.add(dir);
        return dirs;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mergeDir(Long targetId, String sourceIds) {
        if (!NumberUtils.isDigits((String)sourceIds) || sourceIds.contains(String.valueOf(targetId))) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(targetId);
        if (dirEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
        }
        dirEo = (DirEo)this.dirDas.selectByPrimaryKey(Long.valueOf(sourceIds));
        if (dirEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
        }
        DirItemRelationEo example = DirItemRelationEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"dir_id", (Object)sourceIds));
        example.setSqlFilters(sqlFilters);
        List dirsItemsEos = this.dirItemRelationDas.select((BaseEo)example);
        ArrayList<DirItemRelationEo> insertList = new ArrayList<DirItemRelationEo>();
        for (DirItemRelationEo dirsItemsEo : dirsItemsEos) {
            DirItemRelationEo itemsEo = DirItemRelationEo.newInstance();
            CubeBeanUtils.copyProperties((Object)itemsEo, (Object)dirsItemsEo, (String[])new String[0]);
            itemsEo.setDirId(targetId);
            insertList.add(itemsEo);
        }
        this.dirItemRelationDas.insertBatch(insertList);
    }

    @Override
    @EnableCachePlugin
    public List<Long> convertLinkDir(List<Long> dirIds, Long instanceId, Long tenantId) {
        ArrayList<Long> realDirList = new ArrayList<Long>();
        for (Long id : dirIds) {
            DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(id);
            if (dirEo == null) continue;
            if (null != dirEo.getLink()) {
                realDirList.add(dirEo.getLink());
            } else {
                realDirList.add(id);
            }
            DirRelationEo dirRelationEo = new DirRelationEo();
            dirRelationEo.setDirId(id);
            dirRelationEo.setInstanceId(instanceId);
            dirRelationEo.setTenantId(tenantId);
            List dirRelationEoList = this.dirRelationDas.select((BaseEo)dirRelationEo);
            if (CollectionUtils.isEmpty((Collection)dirRelationEoList)) continue;
            for (DirRelationEo relationEo : dirRelationEoList) {
                realDirList.add(relationEo.getLinkDirId());
            }
        }
        return realDirList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sortDirectory(Long id, DirectorySortUpdateDto directorySortUpdateDto) {
        if (directorySortUpdateDto == null || directorySortUpdateDto.getInstanceId() == null || directorySortUpdateDto.getTenantId() == null || DirSortEnum.getDescByType((String)directorySortUpdateDto.getSortType()) == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirEo directoryItemEo = (DirEo)this.dirDas.selectByPrimaryKey(id);
        if (directoryItemEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        if (!directorySortUpdateDto.getInstanceId().equals(directoryItemEo.getInstanceId()) || !directorySortUpdateDto.getTenantId().equals(directoryItemEo.getTenantId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirEo sameParentItemEo = new DirEo();
        sameParentItemEo.setParentId(directoryItemEo.getParentId());
        sameParentItemEo.setOrderBy("sort");
        sameParentItemEo.setInstanceId(directoryItemEo.getInstanceId());
        sameParentItemEo.setTenantId(directoryItemEo.getTenantId());
        List directoryItemEoList = this.dirDas.select((BaseEo)sameParentItemEo);
        if (CollectionUtils.isEmpty((Collection)directoryItemEoList) || directoryItemEoList.size() == 1) {
            return;
        }
        if (DirSortEnum.BOTTOM.getType().equals(directorySortUpdateDto.getSortType())) {
            directoryItemEoList.remove(directoryItemEo);
            directoryItemEoList.add(directoryItemEo);
        } else if (DirSortEnum.TOP.getType().equals(directorySortUpdateDto.getSortType())) {
            directoryItemEoList.remove(directoryItemEo);
            ArrayList<DirEo> newSortList = new ArrayList<DirEo>();
            newSortList.add(directoryItemEo);
            newSortList.addAll(directoryItemEoList);
            directoryItemEoList.clear();
            directoryItemEoList.addAll(newSortList);
        } else {
            int count = directoryItemEoList.size();
            for (int i = 0; i < count; ++i) {
                if (!((DirEo)directoryItemEoList.get(i)).equals((Object)directoryItemEo)) continue;
                Integer relatedIndex = null;
                if (DirSortEnum.INCR.getType().equals(directorySortUpdateDto.getSortType()) && i != 0) {
                    relatedIndex = i - 1;
                } else if (DirSortEnum.DECR.getType().equals(directorySortUpdateDto.getSortType()) && i != count - 1) {
                    relatedIndex = i + 1;
                }
                if (relatedIndex == null) break;
                directoryItemEoList.set(i, directoryItemEoList.get(relatedIndex));
                directoryItemEoList.set(relatedIndex, directoryItemEo);
                break;
            }
        }
        this.updateDirEoSort(directoryItemEoList);
    }

    @Override
    public void compatSortDirectory(Long id, DirectorySortUpdateDto directorySortUpdateDto) {
        if (directorySortUpdateDto == null || directorySortUpdateDto.getInstanceId() == null || directorySortUpdateDto.getTenantId() == null || DirSortEnum.getDescByType((String)directorySortUpdateDto.getSortType()) == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirEo directoryItemEo = (DirEo)this.dirDas.selectByPrimaryKey(id);
        if (directoryItemEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        if (!directorySortUpdateDto.getInstanceId().equals(directoryItemEo.getInstanceId()) || !directorySortUpdateDto.getTenantId().equals(directoryItemEo.getTenantId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirEo sameParentItemEo = new DirEo();
        sameParentItemEo.setParentId(directoryItemEo.getParentId());
        sameParentItemEo.setOrderBy("sort");
        sameParentItemEo.setInstanceId(directoryItemEo.getInstanceId());
        sameParentItemEo.setTenantId(directoryItemEo.getTenantId());
        List directoryItemEoList = this.dirDas.select((BaseEo)sameParentItemEo);
        if (CollectionUtils.isEmpty((Collection)directoryItemEoList) || directoryItemEoList.size() == 1) {
            return;
        }
        if (DirSortEnum.BOTTOM.getType().equals(directorySortUpdateDto.getSortType())) {
            directoryItemEoList.remove(directoryItemEo);
            directoryItemEoList.add(directoryItemEo);
        } else if (DirSortEnum.TOP.getType().equals(directorySortUpdateDto.getSortType())) {
            directoryItemEoList.remove(directoryItemEo);
            ArrayList<DirEo> newSortList = new ArrayList<DirEo>();
            newSortList.add(directoryItemEo);
            newSortList.addAll(directoryItemEoList);
            directoryItemEoList.clear();
            directoryItemEoList.addAll(newSortList);
        } else {
            if (directoryItemEo.getParentId() == 0L) {
                this.sortDirWithSpecParentId(id, directorySortUpdateDto, directoryItemEo);
                return;
            }
            int count = directoryItemEoList.size();
            for (int i = 0; i < count; ++i) {
                if (!((DirEo)directoryItemEoList.get(i)).equals((Object)directoryItemEo)) continue;
                Integer relatedIndex = null;
                if (DirSortEnum.INCR.getType().equals(directorySortUpdateDto.getSortType()) && i != 0) {
                    relatedIndex = i - 1;
                } else if (DirSortEnum.DECR.getType().equals(directorySortUpdateDto.getSortType()) && i != count - 1) {
                    relatedIndex = i + 1;
                }
                if (relatedIndex == null) break;
                directoryItemEoList.set(i, directoryItemEoList.get(relatedIndex));
                directoryItemEoList.set(relatedIndex, directoryItemEo);
                break;
            }
        }
        this.updateDirEoSort(directoryItemEoList);
    }

    private void sortDirWithSpecParentId(Long id, DirectorySortUpdateDto directorySortUpdateDto, DirEo directoryItemEo) {
        DirIndexEo indexParam = new DirIndexEo();
        indexParam.setRootId(directoryItemEo.getId());
        DirIndexEo indexEo = (DirIndexEo)this.dirIndexDas.selectOne((BaseEo)indexParam);
        if (indexEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        indexParam.setRootId(null);
        indexParam.setDirUsage(indexEo.getDirUsage());
        indexParam.setInstanceId(indexEo.getInstanceId());
        indexParam.setTenantId(indexEo.getTenantId());
        List indexEoList = this.dirIndexDas.select((BaseEo)indexParam);
        if (CollectionUtils.isNotEmpty((Collection)indexEoList)) {
            ArrayList<Long> idsList = new ArrayList<Long>();
            for (DirIndexEo directoryEo : indexEoList) {
                idsList.add(directoryEo.getRootId());
            }
            List<DirectoryItemRespDto> dirList = this.directoryService.queryByIds(idsList, "sort");
            if (CollectionUtils.isNotEmpty(dirList)) {
                for (int i = 0; i < dirList.size(); ++i) {
                    if (!id.equals(dirList.get(i).getId())) continue;
                    DirEo sourceDirUpdateEo = new DirEo();
                    DirEo targetDirUpdateEo = new DirEo();
                    sourceDirUpdateEo.setId(id);
                    if (DirSortEnum.INCR.getType().equals(directorySortUpdateDto.getSortType()) && i != 0) {
                        targetDirUpdateEo.setId(dirList.get(i - 1).getId());
                        sourceDirUpdateEo.setSort(dirList.get(i - 1).getSort());
                        targetDirUpdateEo.setSort(dirList.get(i).getSort());
                    } else if (DirSortEnum.DECR.getType().equals(directorySortUpdateDto.getSortType()) && i != dirList.size() - 1) {
                        targetDirUpdateEo.setId(dirList.get(i + 1).getId());
                        sourceDirUpdateEo.setSort(dirList.get(i + 1).getSort());
                        targetDirUpdateEo.setSort(dirList.get(i).getSort());
                    }
                    this.dirDas.updateSelective((BaseEo)sourceDirUpdateEo);
                    this.dirDas.updateSelective((BaseEo)targetDirUpdateEo);
                    break;
                }
            }
        }
    }

    private void updateDirEoSort(List<DirEo> dirEoList) {
        if (CollectionUtils.isEmpty(dirEoList)) {
            return;
        }
        int sort = 0;
        for (DirEo eo : dirEoList) {
            eo.setSort(Integer.valueOf(sort++));
            this.dirDas.update((BaseEo)eo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sortDirectory(DirectorySortUpdateDto directorySortUpdateDto) {
        Long instanceId = directorySortUpdateDto.getInstanceId();
        Long tenantId = directorySortUpdateDto.getTenantId();
        if (directorySortUpdateDto == null || instanceId == null || tenantId == null || directorySortUpdateDto.getSourceDirId() == null || directorySortUpdateDto.getTargetDirId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirEo sourceDirEo = (DirEo)this.dirDas.selectByPrimaryKey(directorySortUpdateDto.getSourceDirId());
        if (sourceDirEo == null || !instanceId.equals(sourceDirEo.getInstanceId()) || !tenantId.equals(sourceDirEo.getTenantId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        DirEo targetDirEo = (DirEo)this.dirDas.selectByPrimaryKey(directorySortUpdateDto.getTargetDirId());
        if (targetDirEo == null || !instanceId.equals(targetDirEo.getInstanceId()) || !tenantId.equals(targetDirEo.getTenantId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        if (!sourceDirEo.getParentId().equals(targetDirEo.getParentId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<DirEo> newSortList = new ArrayList<DirEo>();
        DirEo selectDir = new DirEo();
        selectDir.setOrderBy("sort");
        selectDir.setParentId(sourceDirEo.getParentId());
        selectDir.setInstanceId(directorySortUpdateDto.getInstanceId());
        selectDir.setTenantId(directorySortUpdateDto.getTenantId());
        if (DirSortEnum.TOP.getType().equalsIgnoreCase(directorySortUpdateDto.getSortType()) || DirSortEnum.BOTTOM.getType().equalsIgnoreCase(directorySortUpdateDto.getSortType())) {
            List sortList = this.dirDas.select((BaseEo)selectDir);
            if (CollectionUtils.isNotEmpty((Collection)sortList)) {
                sortList.remove(sourceDirEo);
                for (int i = 0; i < sortList.size(); ++i) {
                    if (DirSortEnum.TOP.getType().equalsIgnoreCase(directorySortUpdateDto.getSortType())) {
                        if (((DirEo)sortList.get(i)).getId().equals(targetDirEo.getId())) {
                            newSortList.add(sourceDirEo);
                        }
                        newSortList.add((DirEo)sortList.get(i));
                        continue;
                    }
                    if (!DirSortEnum.BOTTOM.getType().equalsIgnoreCase(directorySortUpdateDto.getSortType())) continue;
                    newSortList.add((DirEo)sortList.get(i));
                    if (!((DirEo)sortList.get(i)).getId().equals(targetDirEo.getId())) continue;
                    newSortList.add(sourceDirEo);
                }
            }
        } else {
            DirEo sourceDirUpdateEo = new DirEo();
            sourceDirUpdateEo.setId(sourceDirEo.getId());
            sourceDirUpdateEo.setSort(targetDirEo.getSort());
            DirEo targetDirUpdateEo = new DirEo();
            targetDirUpdateEo.setId(targetDirEo.getId());
            targetDirUpdateEo.setSort(sourceDirEo.getSort());
            this.dirDas.updateSelective((BaseEo)sourceDirUpdateEo);
            this.dirDas.updateSelective((BaseEo)targetDirUpdateEo);
            return;
        }
        this.updateDirEoSort(newSortList);
    }

    @Override
    public List<TreeDto<DirIndexRespDto>> queryDirTreeDetail(RootDirectoryReqDto rootDirectoryReqDto) {
        if (rootDirectoryReqDto == null || rootDirectoryReqDto.getInstanceId() == null || rootDirectoryReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        ArrayList<TreeDto<DirIndexRespDto>> treeDtoList = new ArrayList<TreeDto<DirIndexRespDto>>();
        DirIndexEo dirIndexEo = DirIndexEo.newInstance((Map)rootDirectoryReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)rootDirectoryReqDto, (BaseEo)dirIndexEo);
        QueryParamUtils.columnLike((BaseEo)dirIndexEo, "name", dirIndexEo.getName());
        List dirIndexEoList = this.dirIndexDas.select((BaseEo)dirIndexEo);
        if (CollectionUtils.isEmpty((Collection)dirIndexEoList)) {
            return treeDtoList;
        }
        HashSet<Long> rootIdList = new HashSet<Long>();
        for (DirIndexEo indexEo : dirIndexEoList) {
            rootIdList.add(indexEo.getRootId());
        }
        if (CollectionUtils.isEmpty(rootIdList)) {
            return treeDtoList;
        }
        DirEo dirEo = new DirEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(rootIdList, (String)",")));
        dirEo.setSqlFilters(sqlFilterList);
        dirEo.setOrderBy("sort");
        List dirEoList = this.dirDas.select((BaseEo)dirEo);
        for (DirEo eo : dirEoList) {
            for (DirIndexEo indexEo : dirIndexEoList) {
                if (!eo.getId().equals(indexEo.getRootId())) continue;
                List<DirEo> dirList = this.queryDirByRootId(eo.getId(), null);
                ArrayList dtoList = new ArrayList();
                DtoHelper.eoList2DtoList(dirList, dtoList, DirIndexRespDto.class);
                List tree = TreeDto.createTreeDto(dtoList);
                DirIndexRespDto dirIndexRespDto = (DirIndexRespDto)((TreeDto)tree.get(0)).getNode();
                dirIndexRespDto.setIndexId(indexEo.getId());
                dirIndexRespDto.setIndexName(indexEo.getName());
                dirIndexRespDto.setIndexExtension(indexEo.getExtension());
                if (!eo.getParentId().equals(0L) || eo.getCreateTime().getTime() - indexEo.getCreateTime().getTime() < -100L) {
                    dirIndexRespDto.setLink(eo.getId());
                }
                treeDtoList.addAll(tree);
            }
        }
        return treeDtoList;
    }
}

