/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemSkuVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class IIShelfServiceImpl
implements IShelfService {
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ItemPriceDas itemPriceDas;
    private static final String SHELF_ITEM = "SHELF_ITEM";

    @Override
    public PageInfo<ItemShelfQueryRespDto> getItemShelfPage(ItemShelfQueryReqDto itemShelfQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        LinkedList dtoList = Lists.newLinkedList();
        ShelfItemVo shelfItemVo = new ShelfItemVo();
        CubeBeanUtils.copyProperties((Object)shelfItemVo, (Object)itemShelfQueryReqDto, (String[])new String[0]);
        if (itemShelfQueryReqDto.getGroupBy() == null) {
            shelfItemVo.setGroupBy(Integer.valueOf(1));
        }
        if (ItemStatus.ITEM_SALE_OUT.getStatus().equals(itemShelfQueryReqDto.getItemStatus())) {
            shelfItemVo.setSellOut(Boolean.valueOf(true));
            shelfItemVo.setItemStatus(null);
        }
        if ((pageInfo = this.shelfDas.selectSelfItemByPage(shelfItemVo, pageNum, pageSize)) != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List voList = pageInfo.getList();
            CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)voList, ItemShelfQueryRespDto.class);
            dtoList.forEach(dto -> {
                List itemMediasEoList = this.itemMediasDas.selectByItemId(dto.getItemId());
                if (CollectionUtils.isNotEmpty((Collection)itemMediasEoList)) {
                    dto.setImgPath(((ItemMediasEo)itemMediasEoList.get(0)).getPath1());
                }
                List<ItemShelfSkuRespDto> skuList = this.queryShelfItemSkuList(dto.getShopId(), dto.getItemId(), itemShelfQueryReqDto.getBusType());
                dto.setSkuList(skuList);
            });
        }
        PageInfo resultPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)resultPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        resultPageInfo.setList((List)dtoList);
        return resultPageInfo;
    }

    static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    @Override
    public List<ItemShelfSkuRespDto> queryShelfItemSkuList(Long shopId, Long itemId, Integer busType) {
        ArrayList itemShelfSkuRespDtoList = Lists.newArrayList();
        List list = this.shelfDas.selectSelfItemSkuList(shopId, itemId, busType);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CubeBeanUtils.copyCollection((Collection)itemShelfSkuRespDtoList, (Collection)list, ItemShelfSkuRespDto.class);
            List skuIds = list.stream().map(ShelfItemSkuVo::getId).collect(Collectors.toList());
            List itemPriceEoList = this.itemPriceDas.selectBySkuIds(skuIds);
            ArrayList itemPriceRespDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)itemPriceEoList, (Collection)itemPriceRespDtoList, ItemPriceRespDto.class);
            Map group = itemPriceRespDtoList.stream().collect(Collectors.groupingBy(ItemPriceRespDto::getSkuId, Collectors.toList()));
            itemShelfSkuRespDtoList.forEach(sku -> sku.setItemPriceList((List)group.get(sku.getId())));
        }
        List<ItemShelfSkuRespDto> collect = itemShelfSkuRespDtoList.stream().filter(IIShelfServiceImpl.distinctByKey(itemShelfSkuRespDto -> itemShelfSkuRespDto.getId())).collect(Collectors.toList());
        return collect;
    }

    @Override
    public Long countItemShelf(ItemShelfQueryReqDto itemShelfQueryReqDto) {
        ShelfItemVo shelfItemVo = new ShelfItemVo();
        CubeBeanUtils.copyProperties((Object)shelfItemVo, (Object)itemShelfQueryReqDto, (String[])new String[0]);
        if (ItemStatus.ITEM_SALE_OUT.getStatus().equals(itemShelfQueryReqDto.getItemStatus())) {
            shelfItemVo.setSellOut(Boolean.valueOf(true));
            shelfItemVo.setItemStatus(null);
        }
        return this.shelfDas.selectSelfItemCount(shelfItemVo);
    }

    @Override
    @Cacheable(value={"SHELF_ITEM"}, key="#itemShelfQueryReqDto.shopId+'_'+#itemShelfQueryReqDto.skuId+'_'+#itemShelfQueryReqDto.busType", unless="#result == null")
    public ItemShelfRespDto queryItemShelf(ShelfReqDto itemShelfQueryReqDto) {
        ShelfEo shelfEo = new ShelfEo();
        shelfEo.setSkuId(itemShelfQueryReqDto.getSkuId());
        shelfEo.setShopId(itemShelfQueryReqDto.getShopId());
        shelfEo.setBusType(itemShelfQueryReqDto.getBusType());
        List select = this.shelfDas.select((BaseEo)shelfEo);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            ItemShelfRespDto itemShelfSkuRespDto = new ItemShelfRespDto();
            ShelfEo shelf = (ShelfEo)select.get(0);
            BeanUtils.copyProperties((Object)shelf, (Object)itemShelfSkuRespDto);
            return itemShelfSkuRespDto;
        }
        return null;
    }

    @Override
    @CacheEvict(value={"SHELF_ITEM"}, key="#itemShelfQueryReqDto.shopId+'_'+#itemShelfQueryReqDto.skuId+'_'+#itemShelfQueryReqDto.busType")
    public void clearItemShelfCache(ShelfReqDto itemShelfQueryReqDto) {
    }

    @Override
    public void removeItemShelf(Long id) {
        ShelfEo shelfEo = (ShelfEo)this.shelfDas.selectByPrimaryKey(id);
        if (Objects.isNull(shelfEo)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), ItemExceptionCode.NON_EXIST_ITEM.getMsg());
        }
        this.shelfDas.logicDeleteByExample((BaseEo)shelfEo);
    }

    @Override
    public void batchRemoveShelf(String ids) {
        String[] idList;
        for (String id : idList = ids.split(",")) {
            this.removeItemShelf(Long.valueOf(id));
        }
    }
}

