/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemChangeApplyStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ChangeApplyAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.AuditResultRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemChangeApplyRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.biz.base.constants.ItemType;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemChangeApplyService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemVersionService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemAuditDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemChangeApplyDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAuditEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemChangeApplyEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="iItemChangeApplyService")
public class ItemChangeApplyServiceImpl
implements IItemChangeApplyService {
    private static Logger logger = LoggerFactory.getLogger(ItemChangeApplyServiceImpl.class);
    @Resource
    private ItemChangeApplyDas itemChangeApplyDas;
    @Resource
    private IItemService itemService;
    @Resource
    private ItemAuditDas itemAuditDas;
    @Resource
    IItemVersionService itemVersionService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(ItemChangeApplyReqDto changeApplyDto) {
        ItemChangeApplyEo itemChangeApplyEo = this.getItemChangeApplyEo(changeApplyDto);
        this.itemChangeApplyDas.insert((BaseEo)itemChangeApplyEo);
        return itemChangeApplyEo.getId();
    }

    @Override
    public void commit(Long id) {
        ItemChangeApplyEo itemChangeApplyEo = new ItemChangeApplyEo();
        itemChangeApplyEo.setId(id);
        itemChangeApplyEo.setStatus(ItemChangeApplyStatus.AUDITING.getStatus());
        this.itemChangeApplyDas.updateSelective((BaseEo)itemChangeApplyEo);
    }

    @Override
    public Long update(ItemChangeApplyReqDto itemChangeApplyReqDto) {
        if (null == itemChangeApplyReqDto.getId()) {
            throw new ItemBusinessRuntimeException("\u7533\u8bf7\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItemChangeApplyEo itemChangeApplyEo = this.getItemChangeApplyEo(itemChangeApplyReqDto);
        itemChangeApplyEo.setId(itemChangeApplyReqDto.getId());
        itemChangeApplyEo.setUpdateTime(new Date());
        this.itemChangeApplyDas.updateSelective((BaseEo)itemChangeApplyEo);
        return itemChangeApplyEo.getId();
    }

    private ItemChangeApplyEo getItemChangeApplyEo(ItemChangeApplyReqDto itemChangeApplyReqDto) {
        if (StringUtils.isEmpty((CharSequence)itemChangeApplyReqDto.getItemName())) {
            throw new ItemBusinessRuntimeException("\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)itemChangeApplyReqDto.getCode())) {
            itemChangeApplyReqDto.setCode(UUID.randomUUID().toString());
        }
        this.itemService.validSkuCode(itemChangeApplyReqDto.getItemChangeApplyDto(), itemChangeApplyReqDto.getTenantId());
        ItemChangeApplyEo itemChangeApplyEo = ItemChangeApplyEo.newInstance((Map)itemChangeApplyReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)itemChangeApplyReqDto, (BaseEo)itemChangeApplyEo);
        itemChangeApplyReqDto.getItemChangeApplyDto().setInstanceId(itemChangeApplyReqDto.getInstanceId());
        itemChangeApplyReqDto.getItemChangeApplyDto().setTenantId(itemChangeApplyReqDto.getTenantId());
        itemChangeApplyEo.setId(null);
        itemChangeApplyEo.setContent(JSON.toJSONString((Object)itemChangeApplyReqDto.getItemChangeApplyDto()));
        return itemChangeApplyEo;
    }

    @Override
    public AuditResultRespDto audit(ChangeApplyAuditReqDto changeApplyAuditReqDto) {
        long itemId = 0L;
        if (ItemChangeApplyStatus.AUDIT_SUCCESS.getStatus().equals(changeApplyAuditReqDto.getStatus())) {
            ItemChangeApplyEo itemChangeApplyEo = (ItemChangeApplyEo)this.itemChangeApplyDas.selectByPrimaryKey(changeApplyAuditReqDto.getChangeApplyId());
            ItemChangeApplyDto itemChangeApplyDto = (ItemChangeApplyDto)JSON.parseObject((String)itemChangeApplyEo.getContent(), ItemChangeApplyDto.class);
            CubeBeanUtils.copyProperties((Object)itemChangeApplyEo, (Object)itemChangeApplyDto, (String[])new String[0]);
            itemChangeApplyDto.setSellerId(itemChangeApplyEo.getSellerId());
            itemChangeApplyDto.setShopId(itemChangeApplyEo.getShopId());
            itemChangeApplyDto.setOwnerId(itemChangeApplyEo.getOwnerId());
            if (itemChangeApplyEo.getItemId() != null) {
                itemChangeApplyDto.setItemId(itemChangeApplyEo.getItemId());
            }
            if (itemChangeApplyDto.getItemId() != null) {
                itemId = itemChangeApplyDto.getItemId();
                this.itemService.updateItem(itemChangeApplyDto);
            } else {
                if (itemChangeApplyDto.getItemStatus() == null) {
                    if (itemChangeApplyDto.getType() != null) {
                        if (itemChangeApplyDto.getType().equals(ItemType.GENERAL.getIndex())) {
                            itemChangeApplyDto.setItemStatus(ItemStatus.ITEM_DRAFT.getStatus());
                        } else if (itemChangeApplyDto.getType().equals(ItemType.VIRTUAL.getIndex())) {
                            itemChangeApplyDto.setItemStatus(ItemStatus.ITEM_DRAFT.getStatus());
                        }
                    } else if (itemChangeApplyDto.getType() != null && itemChangeApplyDto.getType().equals(ItemType.PRODUCT.getIndex())) {
                        itemChangeApplyDto.setItemStatus(ItemStatus.PRODUCT_WAIT_PUBLISHED.getStatus());
                    }
                }
                itemId = this.itemService.addItem(itemChangeApplyDto);
            }
            this.itemVersionService.addItemVersion(itemId);
        }
        ItemChangeApplyReqDto changeApply = new ItemChangeApplyReqDto();
        changeApply.setId(changeApplyAuditReqDto.getChangeApplyId());
        changeApply.setStatus(changeApplyAuditReqDto.getStatus());
        changeApply.setInstanceId(changeApplyAuditReqDto.getInstanceId());
        changeApply.setTenantId(changeApplyAuditReqDto.getTenantId());
        changeApply.setItemId(Long.valueOf(itemId));
        this.update(changeApply, itemId);
        AuditResultRespDto auditResultRespDto = new AuditResultRespDto();
        auditResultRespDto.setItemId(Long.valueOf(itemId));
        return auditResultRespDto;
    }

    private Long update(ItemChangeApplyReqDto changeApply, long itemId) {
        if (null == changeApply) {
            throw new ItemBusinessRuntimeException("\u7533\u8bf7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItemChangeApplyEo itemChangeApplyEo = ItemChangeApplyEo.newInstance((Map)changeApply.getExtFields());
        if (itemId > 0L) {
            itemChangeApplyEo.setItemId(Long.valueOf(itemId));
        }
        DtoHelper.dto2Eo((BaseVo)changeApply, (BaseEo)itemChangeApplyEo);
        this.itemChangeApplyDas.updateSelective((BaseEo)itemChangeApplyEo);
        return itemChangeApplyEo.getId();
    }

    @Override
    public ItemChangeApplyRespDto getById(Long id, ItemChangeApplyReqDto itemChangeApplyReqDto, Long tenantId, Long instanceId) {
        if (null == id) {
            logger.error("\u7248\u672cId\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ItemBusinessRuntimeException("\u7248\u672cId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItemChangeApplyEo itemChangeApplyEo = (ItemChangeApplyEo)this.itemChangeApplyDas.selectByPrimaryKey(id);
        if (null == itemChangeApplyEo) {
            throw new ItemBusinessRuntimeException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e");
        }
        ItemChangeApplyRespDto itemVersionDto = new ItemChangeApplyRespDto();
        DtoHelper.eo2Dto((BaseEo)itemChangeApplyEo, (BaseVo)itemVersionDto);
        ItemChangeApplyDto itemChangeApplyDto = (ItemChangeApplyDto)JSON.parseObject((String)itemChangeApplyEo.getContent(), ItemChangeApplyDto.class);
        itemVersionDto.setItemChangeApplyDto(itemChangeApplyDto);
        this.queryAuditDetail(itemVersionDto);
        return itemVersionDto;
    }

    @Override
    public PageInfo<ItemChangeApplyRespDto> queryByPage(ItemChangeApplyReqDto dto, Integer pageNum, Integer pageSize) {
        ItemChangeApplyEo itemChangeApplyEo = ItemChangeApplyEo.newInstance((Map)dto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)itemChangeApplyEo);
        QueryParamUtils.fillQueryCreateStartTime(dto.getCreateBeginTime(), (BaseEo)itemChangeApplyEo);
        QueryParamUtils.fillQueryCreateEndTime(dto.getCreateEndTime(), (BaseEo)itemChangeApplyEo);
        QueryParamUtils.fillQueryUpdateStartTime(dto.getUpdateBeginTime(), (BaseEo)itemChangeApplyEo);
        QueryParamUtils.fillQueryUpdateEndTime(dto.getUpdateEndTime(), (BaseEo)itemChangeApplyEo);
        if (dto.getStatus() == null && dto.getNeStatus() != null) {
            ArrayList<SqlFilter> sqlFilterList = itemChangeApplyEo.getSqlFilters();
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList<SqlFilter>();
            }
            sqlFilterList.add(SqlFilter.ne((String)"status", (Object)dto.getNeStatus()));
            itemChangeApplyEo.setSqlFilters(sqlFilterList);
        }
        PageInfo pageInfo = this.itemChangeApplyDas.selectPage((BaseEo)itemChangeApplyEo, pageNum, pageSize);
        PageInfo itemChangeApplyRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)itemChangeApplyRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList itemChangeApplyRespDtos = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), itemChangeApplyRespDtos, ItemChangeApplyRespDto.class);
        block0: for (ItemChangeApplyRespDto itemChangeApplyRespDto : itemChangeApplyRespDtos) {
            for (ItemChangeApplyEo itemChange : pageInfo.getList()) {
                if (!itemChangeApplyRespDto.getId().equals(itemChange.getId())) continue;
                itemChangeApplyRespDto.setItemChangeApplyDto((ItemChangeApplyDto)JSON.parseObject((String)itemChange.getContent(), ItemChangeApplyDto.class));
                continue block0;
            }
        }
        ArrayList<Long> snapshotIdList = new ArrayList<Long>();
        for (ItemChangeApplyRespDto itemChangeApplyRespDto : itemChangeApplyRespDtos) {
            if (!ItemChangeApplyStatus.AUDITING.getStatus().equals(itemChangeApplyRespDto.getStatus()) && !ItemChangeApplyStatus.DRAFT.getStatus().equals(itemChangeApplyRespDto.getStatus())) {
                this.queryAuditDetail(itemChangeApplyRespDto);
            }
            snapshotIdList.add(itemChangeApplyRespDto.getSnapshotId());
        }
        itemChangeApplyRespDtoPageInfo.setList(itemChangeApplyRespDtos);
        return itemChangeApplyRespDtoPageInfo;
    }

    private void queryAuditDetail(ItemChangeApplyRespDto itemChangeApplyRespDto) {
        ItemAuditEo itemAuditEo = new ItemAuditEo();
        itemAuditEo.setVersionId(itemChangeApplyRespDto.getId());
        itemAuditEo.setInstanceId(itemChangeApplyRespDto.getInstanceId());
        itemAuditEo.setTenantId(itemChangeApplyRespDto.getTenantId());
        PageInfo last = this.itemAuditDas.selectPage((BaseEo)itemAuditEo, Integer.valueOf(1), Integer.valueOf(1));
        if (last == null || CollectionUtils.isEmpty((Collection)last.getList())) {
            return;
        }
        itemAuditEo = (ItemAuditEo)last.getList().get(0);
        itemChangeApplyRespDto.setResult(itemAuditEo.getResult());
        itemChangeApplyRespDto.setAuditDesc(itemAuditEo.getAuditDesc());
        itemChangeApplyRespDto.setAuditPerson(itemAuditEo.getAuditPerson());
        itemChangeApplyRespDto.setAuditTime(itemAuditEo.getCreateTime());
        itemChangeApplyRespDto.setAuditPersonName(itemAuditEo.getAuditPersonName());
    }
}

