/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.BaseEoUtil;
import com.dtyunxi.huieryun.ds.IdGenrator;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.opensearch.api.IIndicesAdminService;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.QueryFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.DistributionFeeDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.CoordinateDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShopRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.LocationDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.TemplateRegionRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.constants.ItemSearchIndexConstant;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.vo.ItemSearchIndexMessageVo;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDistributionSetService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.ConvexUtil;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemAttributesDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.StatDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StatEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdStatEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDeliveryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopWarehouseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.GeoDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.IndicesAdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

public class ItemSearchHttpServiceImpl
implements IItemSearchService {
    private Logger logger = LoggerFactory.getLogger(ItemSearchHttpServiceImpl.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ItemDas itemDas;
    @Resource
    private IItemService itemService;
    @Resource
    private StatDas statDas;
    @Resource
    private ItemAttributesDas itemAttributesDas;
    @Autowired(required=false)
    private IndicesAdminClient adminClient;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private IIndicesAdminService indicesAdminService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IOpenSearchService openSearchService;
    @Resource
    private ISearchIndexService searchIndexService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void initIndex() {
        if (!ItemSearchIndexConstant.USE_ES) {
            return;
        }
        if (this.notExistsThenCreateIndex(ItemSearchIndexConstant.getIndexName())) {
            String basePath = System.getProperty("user.dir");
            String mappingName = "item_index_mapping.json";
            File file = new File(basePath + File.separator + "yundt-cube-center-itembiz" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + mappingName);
            StringBuilder mapping = new StringBuilder();
            InputStream is = null;
            InputStreamReader isr = null;
            BufferedReader in = null;
            try {
                String line;
                if (file.exists()) {
                    is = new FileInputStream(file);
                } else {
                    URL url = ItemSearchHttpServiceImpl.class.getClassLoader().getResource(mappingName);
                    if (url != null) {
                        is = url.openStream();
                    }
                }
                if (is == null) {
                    this.logger.error("\u65e0\u6cd5\u52a0\u8f7dmapping\u914d\u7f6e\u6587\u4ef6\uff0c\u8bf7\u624b\u52a8\u521d\u59cb\u5316es\u76f8\u5173\u64cd\u4f5c\u3002\u521b\u5efaes\uff0c\u6784\u5efamapping");
                    return;
                }
                isr = new InputStreamReader(is, "utf-8");
                in = new BufferedReader(isr);
                while ((line = in.readLine()) != null) {
                    mapping.append(line);
                }
            }
            catch (Exception e) {
                this.deleteIndexName(ItemSearchIndexConstant.getIndexName());
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {}
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>(1);
            map.put("max_result_window", 200000000);
            this.indicesAdminService.updateIndexSetting(ItemSearchIndexConstant.getIndexName(), map);
            boolean result = this.indicesAdminService.putMapping(ItemSearchIndexConstant.getIndexName(), "item_search", ((Object)map).toString());
            if (result) {
                this.sync();
            }
        }
    }

    @Override
    public void index(final Long sellerId, final Long itemId, final Integer itemType, final Integer busType, final String active) {
        this.logger.info("\u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5230es,sellerId:{},itemId:{},itemType:{},operation:{}", new Object[]{sellerId, itemId, itemType, active});
        if (!ItemSearchIndexConstant.USE_ES) {
            return;
        }
        if (itemId == null) {
            this.logger.error("\u6784\u5efaes\u7d22\u5f15\u5931\u8d25\uff0c\u5546\u54c1id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    ItemSearchHttpServiceImpl.this.index(sellerId, itemId, itemType, busType, active, 0);
                }
            });
        } else {
            this.index(sellerId, itemId, itemType, busType, active, 0);
        }
    }

    @Override
    public ItemSearchRespDto query(ItemSearchQueryReqDto itemSearchQueryReqDto, Integer pageNum, Integer pageSize) {
        OSSearchVo osSearchVo = new OSSearchVo();
        try {
            int i;
            String[] itemArr;
            osSearchVo.setIndexName(ItemSearchIndexConstant.getIndexName());
            osSearchVo.setTypeName("item_search");
            if (pageNum == null) {
                pageNum = 1;
            }
            if (pageSize == null) {
                pageSize = 10;
            }
            osSearchVo.setPage(pageNum.intValue());
            osSearchVo.setPageSize(pageSize.intValue());
            if (itemSearchQueryReqDto.getTenantId() != null) {
                osSearchVo.addEqualFilter("tenantId", String.valueOf(itemSearchQueryReqDto.getTenantId()));
            }
            if (itemSearchQueryReqDto.getInstanceId() != null) {
                osSearchVo.addEqualFilter("instanceId", String.valueOf(itemSearchQueryReqDto.getInstanceId()));
            }
            if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getKeyword())) {
                QueryFieldVo queryFieldVo = QueryFieldVo.query((String)itemSearchQueryReqDto.getKeyword(), (String[])new String[]{"name", "displayName", "brand"});
                queryFieldVo.setEscape(true);
                osSearchVo.addQueries(new QueryFieldVo[]{queryFieldVo});
            }
            if (itemSearchQueryReqDto.getBusType() != null) {
                osSearchVo.addEqualFilter("busType", String.valueOf(itemSearchQueryReqDto.getBusType()));
            }
            if (itemSearchQueryReqDto.getType() != null) {
                osSearchVo.addEqualFilter("busType", String.valueOf(itemSearchQueryReqDto.getType()));
            }
            if (itemSearchQueryReqDto.getType() == null && itemSearchQueryReqDto.getNeType() != null) {
                osSearchVo.addNonEqualFilter("type", itemSearchQueryReqDto.getNeType());
            }
            if (itemSearchQueryReqDto.getBrandId() != null) {
                osSearchVo.addEqualFilter("brandId", String.valueOf(itemSearchQueryReqDto.getBrandId()));
            }
            if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getItemIds())) {
                itemArr = new String[itemSearchQueryReqDto.getItemIds().size()];
                for (i = 0; i < itemSearchQueryReqDto.getItemIds().size(); ++i) {
                    itemArr[i] = String.valueOf(itemSearchQueryReqDto.getItemIds().get(i));
                }
                osSearchVo.addInFilter("dirsItemsList.itemId", itemArr);
            }
            if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getInItemIds())) {
                itemArr = new String[itemSearchQueryReqDto.getInItemIds().size()];
                for (i = 0; i < itemSearchQueryReqDto.getInItemIds().size(); ++i) {
                    itemArr[i] = String.valueOf(itemSearchQueryReqDto.getInItemIds().get(i));
                }
                osSearchVo.addInFilter("dirsItemsList.itemId", itemArr);
            }
            if (itemSearchQueryReqDto.getSellerId() != null) {
                String sellerId = String.valueOf(itemSearchQueryReqDto.getSellerId());
                osSearchVo.addInFilter("dirsItemsList.sellerId", new String[]{sellerId});
            }
            if (itemSearchQueryReqDto.getShopId() != null) {
                String shopId = String.valueOf(itemSearchQueryReqDto.getShopId());
                osSearchVo.addInFilter("dirsItemsList.shopId", new String[]{shopId});
            }
            if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getDirIds())) {
                itemArr = new String[itemSearchQueryReqDto.getDirIds().size()];
                for (i = 0; i < itemSearchQueryReqDto.getDirIds().size(); ++i) {
                    itemArr[i] = String.valueOf(itemSearchQueryReqDto.getDirIds().get(i));
                }
                osSearchVo.addInFilter("dirsItemsList.dirId", itemArr);
            }
            if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getProp())) {
                String[] props;
                for (String prop : props = itemSearchQueryReqDto.getProp().split(";")) {
                    String[] searchData = prop.split(":");
                    osSearchVo.addInFilter("searchAttr.searchAttr.name", searchData);
                }
            }
            if (itemSearchQueryReqDto.getMinPrice() != null || itemSearchQueryReqDto.getMaxPrice() != null) {
                if (itemSearchQueryReqDto.getMinPrice() != null && itemSearchQueryReqDto.getMaxPrice() != null) {
                    osSearchVo.addRangeFilter("minPrice", String.valueOf(itemSearchQueryReqDto.getMinPrice()), String.valueOf(itemSearchQueryReqDto.getMaxPrice()));
                } else {
                    osSearchVo.addRangeFilter("minPrice", String.valueOf(itemSearchQueryReqDto.getMinPrice()), String.valueOf(itemSearchQueryReqDto.getMaxPrice()), LogicalSymbol.OR);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getOrderByDesc())) {
                if ("sales".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                    osSearchVo.addSort("salesCount");
                } else if ("price".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                    osSearchVo.addSort("minPrice");
                } else if ("shelfTime".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                    osSearchVo.addSort("itemShelfInfoList.shelfTime");
                }
            } else if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getOrderBy())) {
                if ("sales".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                    osSearchVo.addSort("salesCount", SortOrder.ASC);
                } else if ("price".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                    osSearchVo.addSort("minPrice", SortOrder.ASC);
                } else if ("shelfTime".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                    osSearchVo.addSort("itemShelfInfoList.shelfTime", SortOrder.ASC);
                }
            } else {
                osSearchVo.addSort("shelfTime", SortOrder.DESC);
            }
            SearchResultVo search = this.openSearchService.search(osSearchVo);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("search={}", (Object)search);
            }
            ItemSearchRespDto itemSearchRespDto = new ItemSearchRespDto();
            if (search == null) {
                this.logger.info("\u67e5\u8be2\u4e0d\u5230\u5206\u7c7b\u5546\u54c1\u6570\u636e");
                return itemSearchRespDto;
            }
            int totalSize = (int)search.getTotalSize();
            ArrayList<ItemRespDto> itemRespDtoList = new ArrayList<ItemRespDto>(totalSize);
            List docValues = search.getDocValues();
            for (Map docValue : docValues) {
                ItemRespDto itemRespDto = (ItemRespDto)JacksonUtil.readValue((String)JacksonUtil.toJson((Object)docValue), ItemRespDto.class);
                if (itemRespDto != null) {
                    ItemShopRespDto itemShopRespDto;
                    List itemShopList = itemRespDto.getItemShopList();
                    if (!CollectionUtils.isEmpty((Collection)itemShopList) && (itemShopRespDto = (ItemShopRespDto)itemShopList.get(0)) != null) {
                        itemRespDto.setShopId(itemShopRespDto.getShopId());
                    }
                    this.setMinDistributionInfo(itemRespDto);
                }
                itemRespDtoList.add(itemRespDto);
            }
            PageInfo pageInfo = new PageInfo(itemRespDtoList);
            pageInfo.setTotal(search.getTotalSize());
            Integer pages = Math.toIntExact(search.getTotalSize() / (long)pageSize.intValue());
            if (search.getTotalSize() % (long)pageSize.intValue() != 0L) {
                pages = pages + 1;
            }
            pageInfo.setPages(pages.intValue());
            pageInfo.setPageNum(pageNum.intValue());
            pageInfo.setPageSize(pageSize.intValue());
            itemSearchRespDto.setPageInfo(pageInfo);
            return itemSearchRespDto;
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u641c\u7d22\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    private void setMinDistributionInfo(ItemRespDto itemRespDto) {
        if (CollectionUtils.isEmpty((Collection)itemRespDto.getItemShelfInfoList())) {
            return;
        }
        List shelfRespDtos = itemRespDto.getItemShelfInfoList().stream().filter(shelfDto -> shelfDto.getShopId().equals(itemRespDto.getShopId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(shelfRespDtos)) {
            this.logger.info("\u5546\u54c1\u4e0a\u67b6\u8bb0\u5f55\u4e3a\u7a7a\uff0citemId={}, shopId={}", (Object)itemRespDto.getItemId(), (Object)itemRespDto.getShopId());
            return;
        }
        if (Integer.valueOf(1).equals(((ItemShelfRespDto)shelfRespDtos.get(0)).getDistribution())) {
            itemRespDto.setDistribution(Integer.valueOf(1));
            if (CollectionUtils.isEmpty((Collection)itemRespDto.getDistributionFeeList())) {
                this.logger.info("\u5546\u54c1\u5206\u9500\u4f63\u91d1\u4e3a\u7a7a\uff0citemId={}, shopId={}", (Object)itemRespDto.getItemId(), (Object)itemRespDto.getShopId());
                return;
            }
            BigDecimal min = itemRespDto.getDistributionFeeList().stream().filter(feeDto -> feeDto.getShopId().equals(itemRespDto.getShopId())).map(DistributionFeeDto::getAmount).sorted().min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
            itemRespDto.setDistributionFee(min);
        }
    }

    private Long getMiniDistanceShopId(Map<Long, List<ItemShopRespDto>> shopRespDtoMap, List<ItemShopRespDto> sortShopList) {
        for (ItemShopRespDto itemShopRespDto : sortShopList) {
            if (shopRespDtoMap.get(itemShopRespDto.getShopId()) == null) continue;
            return itemShopRespDto.getShopId();
        }
        return null;
    }

    private Long getShippingShopId(List<ItemShopRespDto> itemShopList) {
        for (ItemShopRespDto itemShopRespDto : itemShopList) {
            if (itemShopRespDto.getBusinessType() == null || !itemShopRespDto.getBusinessType().equals(1)) continue;
            return itemShopRespDto.getShopId();
        }
        return null;
    }

    private Long getShopId(List<ItemShopRespDto> itemShopList, Map<Long, List<ItemShopRespDto>> shopRespDtoMap, List<ItemShopRespDto> sortShop) {
        Long miniDistanceShopId = this.getMiniDistanceShopId(shopRespDtoMap, sortShop);
        if (miniDistanceShopId == null) {
            return this.getShippingShopId(itemShopList);
        }
        return miniDistanceShopId;
    }

    @Override
    public void sync() {
    }

    private boolean notExistsThenCreateIndex(String indexName) {
        try {
            if (this.indicesAdminService.existsIndex(new String[]{indexName})) {
                return false;
            }
            return this.indicesAdminService.createIndex(indexName);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void deleteIndexName(String indexName) {
        this.indicesAdminService.deleteIndex(new String[]{indexName});
    }

    private void index(Long sellerId, Long itemId, Integer itemType, Integer busType, String operation, int retry) {
        if (retry > 3) {
            this.logger.error("\u7d22\u5f15\u91cd\u590d\u6784\u5efa\u8d85\u8fc73\u6b21\uff0c\u5546\u54c1ID\u4e3a:{}\u8bf7\u68c0\u67e5", (Object)itemId);
            return;
        }
        ItemSearchIndexMessageVo itemSearchIndexMessageVo = new ItemSearchIndexMessageVo(sellerId, itemId, itemType, busType, operation, retry);
        itemSearchIndexMessageVo.setMessageId(this.generateId());
        try {
            this.logger.info("\u5f00\u59cb\u53d1\u9001es\u540c\u6b65\u6d88\u606f\uff0cmessageId\uff1a{}", (Object)itemSearchIndexMessageVo.getMessageId());
            MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("ITEM_SEARCH_INDEX", (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
            if ("error".equalsIgnoreCase(messageResponse.getResultMsg())) {
                this.logger.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25");
                this.index(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getItemType(), itemSearchIndexMessageVo.getBusType(), itemSearchIndexMessageVo.getOperation(), itemSearchIndexMessageVo.getRetry() + 1);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public MessageResponse process(Object object) {
        if (object == null) {
            this.logger.error("\u63a5\u53d7\u5230\u7a7a\u7684MQ\u6d88\u606f");
            return MessageResponse.SUCCESS;
        }
        try {
            ItemSearchIndexMessageVo itemSearchIndexMessageVo = (ItemSearchIndexMessageVo)JSON.parseObject((String)object.toString(), ItemSearchIndexMessageVo.class);
            this.logger.info("\u5f00\u59cb\u5904\u7406es\u540c\u6b65\u6d88\u606f\uff0cmessageId\uff1a{}", (Object)itemSearchIndexMessageVo.getMessageId());
            ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemSearchIndexMessageVo.getItemId());
            if (itemEo == null) {
                this.logger.error("\u5546\u54c1ID:{}\u5bf9\u5e94\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)itemSearchIndexMessageVo.getItemId());
                return MessageResponse.SUCCESS;
            }
            switch (itemSearchIndexMessageVo.getOperation()) {
                case "ON_SHELF": {
                    this.createOrUpdateOrRemoveIndex(itemSearchIndexMessageVo);
                    break;
                }
                case "OFF_SHELF": {
                    this.createOrUpdateOrRemoveIndex(itemSearchIndexMessageVo);
                    break;
                }
                case "SALES_COUNT": {
                    this.createOrUpdateOrRemoveIndex(itemSearchIndexMessageVo);
                    break;
                }
                default: {
                    this.logger.error("\u672a\u77e5\u7684\u6d88\u606f\u5904\u7406\u7c7b\u578b:{}", (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private List<ItemShopRespDto> getShopList(Set<Long> shopIds, List<ItemShelfRespDto> itemShelfRespDtos) {
        Map<Long, List<ItemShelfRespDto>> shopItemShelfMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getShopId));
        ArrayList<ItemShopRespDto> itemShopList = new ArrayList<ItemShopRespDto>();
        for (Long shopId : shopIds) {
            this.logger.info("itemSearchIndexMessageVo.getShopId \u5e97\u94faID={}", (Object)shopId);
            ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryById(shopId.longValue(), new String[0]));
            this.logger.info("shopDto={}", JSON.toJSON((Object)shopDto));
            ItemShopRespDto itemShopRespDto = new ItemShopRespDto();
            itemShopRespDto.setShopId(shopId);
            itemShopRespDto.setBusinessType(shopDto.getBusinessType());
            List<ItemShelfRespDto> shopItemSelfList = shopItemShelfMap.get(shopId);
            if (!CollectionUtils.isEmpty(shopItemSelfList)) {
                Integer type = shopItemSelfList.get(0).getType();
                itemShopRespDto.setShelfType(type);
            }
            if (itemShopRespDto.getBusinessType() == null) {
                itemShopRespDto.setBusinessType(Integer.valueOf(shopDto.getType().intValue()));
            }
            ArrayList<LocationDto> locationDtos = new ArrayList<LocationDto>();
            GeoDto geoDto = null;
            if (2 == itemShopRespDto.getBusinessType()) {
                geoDto = this.getShopDeliveryGeo(shopDto);
            } else {
                geoDto = new GeoDto();
                geoDto.setLongitude("-99.140625");
                geoDto.setLatitude("-40.044438");
            }
            if (null != geoDto) {
                LocationDto locationDto = new LocationDto();
                locationDto.setLon(Double.valueOf(geoDto.getLongitude()));
                locationDto.setLat(Double.valueOf(geoDto.getLatitude()));
                locationDtos.add(locationDto);
            }
            itemShopRespDto.setLocation(locationDtos);
            List<TemplateRegionRespDto> templateRegionList = null;
            templateRegionList = 2 == itemShopRespDto.getBusinessType() ? this.getTemplateRegionRespDtoList(shopDto) : this.getRegionShippingList();
            itemShopRespDto.setTemplateRegionList(templateRegionList);
            itemShopList.add(itemShopRespDto);
        }
        return itemShopList;
    }

    private void createOrUpdateIndexGroupBySeller(ItemSearchIndexMessageVo itemSearchIndexMessageVo, ItemEo itemEo, List<ItemShelfRespDto> itemShelfRespDtos) {
        if (itemEo == null) {
            this.logger.error("\u6784\u5efa\u5546\u54c1\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1ID:{}\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)itemSearchIndexMessageVo.getItemId());
            return;
        }
        Long sellerId = itemSearchIndexMessageVo.getSellerId();
        List<ItemRespDto> itemRespDtoList = this.itemService.queryItemRespDto(Lists.newArrayList((Object[])new ItemEo[]{itemEo}), sellerId);
        if (CollectionUtils.isEmpty(itemRespDtoList)) {
            this.logger.error("\u6784\u5efa\u5546\u54c1\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1ID:{}\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)itemSearchIndexMessageVo.getItemId());
            return;
        }
        ItemRespDto itemRespDto = itemRespDtoList.get(0);
        itemRespDto.setItemShelfInfoList(itemShelfRespDtos);
        this.buildSaleCount(itemRespDto);
        this.buildSearchAttr(itemRespDto);
        this.buildPrice(itemRespDto, itemShelfRespDtos);
        Set<Long> itemShopIdSet = itemShelfRespDtos.stream().map(ItemShelfRespDto::getShopId).collect(Collectors.toSet());
        itemRespDto.setItemShopList(this.getShopList(itemShopIdSet, itemShelfRespDtos));
        itemRespDto.setItemId(itemRespDto.getId());
        String groupKey = this.getIndexDocId(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId());
        itemRespDto.setGroupKey(groupKey);
        IDistributionSetService distributionSetService = (IDistributionSetService)SpringBeanUtil.getBean(IDistributionSetService.class);
        if (null != distributionSetService) {
            List<DistributionFeeDto> feeDtos = distributionSetService.calculateFee(itemShelfRespDtos);
            itemRespDto.setDistributionFeeList(feeDtos);
        }
        this.logger.info("itemRespDto={}", JSON.toJSON((Object)itemRespDto));
        try {
            OSSearchVo osSearchVo = new OSSearchVo();
            osSearchVo.setIndexName(ItemSearchIndexConstant.getIndexName());
            osSearchVo.setTypeName("item_search");
            osSearchVo.addEqualFilter("id", itemRespDto.getGroupKey());
            this.logger.info("OSSearchVo:{}", (Object)JSON.toJSONString((Object)osSearchVo));
            SearchResultVo search = this.openSearchService.search(osSearchVo);
            this.logger.info("search:{}", (Object)JSON.toJSONString((Object)search));
            if (search != null) {
                long totalHit = search.getTotalSize();
                if (totalHit == 0L) {
                    this.logger.info("\u521b\u5efa");
                    this.create(itemRespDto);
                } else if (totalHit == 1L) {
                    this.logger.info("\u66f4\u65b0");
                    this.update(itemRespDto);
                } else {
                    this.logger.info("\u5220\u9664");
                    ArrayList<String> indexIdList = new ArrayList<String>();
                    for (Map value : search.getDocValues()) {
                        indexIdList.add((String)value.get("groupKey"));
                    }
                    this.deleteAndCreate(itemRespDto, indexIdList);
                }
            } else {
                this.create(itemRespDto);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u540c\u6b65\u5230ES\u51fa\u73b0\u5f02\u5e38,\u5e76\u4e14\u91cd\u65b0\u53d1\u9001MQ\uff1a{}", (Object)e.getMessage(), (Object)e);
            this.index(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getItemType(), itemSearchIndexMessageVo.getBusType(), itemSearchIndexMessageVo.getOperation(), itemSearchIndexMessageVo.getRetry() + 1);
        }
    }

    private void buildPrice(ItemRespDto itemRespDto, List<ItemShelfRespDto> itemShelfDtos) {
        BigDecimal max = BigDecimal.ZERO;
        BigDecimal min = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(itemShelfDtos)) {
            List priceList = itemShelfDtos.stream().map(ItemShelfRespDto::getPrice).collect(Collectors.toList());
            max = (BigDecimal)priceList.stream().max(BigDecimal::compareTo).get();
            min = (BigDecimal)priceList.stream().min(BigDecimal::compareTo).get();
        }
        itemRespDto.setMinPrice(Double.valueOf(min.doubleValue()));
        itemRespDto.setMaxPrice(Double.valueOf(max.doubleValue()));
    }

    private void buildSaleCount(ItemRespDto itemRespDto) {
        StatEo statEo = new StatEo();
        statEo.setItemId(itemRespDto.getId());
        List statEoList = this.statDas.select((BaseEo)statEo);
        Long salesCount = 0L;
        if (!CollectionUtils.isEmpty((Collection)statEoList)) {
            salesCount = statEoList.stream().mapToLong(StdStatEo::getSalesCount).sum();
        }
        itemRespDto.setSalesCount(salesCount);
    }

    private void buildSearchAttr(ItemRespDto itemRespDto) {
        String searchAttr;
        ItemAttributesEo itemAttributesEo = new ItemAttributesEo();
        itemAttributesEo.setItemId(itemRespDto.getId());
        itemAttributesEo = (ItemAttributesEo)this.itemAttributesDas.selectOne((BaseEo)itemAttributesEo);
        if (itemAttributesEo != null && StringUtils.isNotBlank((CharSequence)(searchAttr = itemAttributesEo.getSearchAttrs())) && searchAttr.startsWith("{")) {
            JSONObject jsonObject = JSON.parseObject((String)searchAttr);
            ArrayList searchAttrList = new ArrayList();
            for (String name : jsonObject.keySet()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", name);
                map.put("value", String.valueOf(jsonObject.get((Object)name)));
                searchAttrList.add(map);
            }
            itemRespDto.setSearchAttr(searchAttrList);
        }
    }

    private String getIndexDocId(Long sellerId, Long itemId) {
        return String.valueOf(sellerId) + itemId;
    }

    private void createOrUpdateOrRemoveIndex(ItemSearchIndexMessageVo itemSearchIndexMessageVo) {
        this.logger.info("ItemSearchIndexMessageVo\uff1a{}", JSON.toJSON((Object)itemSearchIndexMessageVo));
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemSearchIndexMessageVo.getItemId());
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(itemSearchIndexMessageVo.getItemId());
        shelfReqDto.setSellerId(itemSearchIndexMessageVo.getSellerId());
        shelfReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        List<ItemShelfRespDto> itemShelfRespDtos = this.itemService.queryItemShelfList(shelfReqDto);
        if (!CollectionUtils.isEmpty(itemShelfRespDtos)) {
            Map<Long, List<ItemShelfRespDto>> sellerMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getSellerId));
            for (Long sellerId : sellerMap.keySet()) {
                List<ItemShelfRespDto> itemShelfList = sellerMap.get(sellerId);
                ItemSearchIndexMessageVo itemSearchIndexMessage = new ItemSearchIndexMessageVo();
                BeanUtils.copyProperties((Object)itemSearchIndexMessageVo, (Object)itemSearchIndexMessage);
                itemSearchIndexMessage.setSellerId(sellerId);
                this.createOrUpdateIndexGroupBySeller(itemSearchIndexMessage, itemEo, itemShelfList);
            }
        } else if (itemSearchIndexMessageVo.getSellerId() != null) {
            this.deleteByIndexId(this.getIndexDocId(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId()));
        }
    }

    private List<TemplateRegionRespDto> getRegionShippingList() {
        List coordinateDtoList;
        ArrayList<TemplateRegionRespDto> templateRegionList = new ArrayList<TemplateRegionRespDto>();
        TemplateRegionRespDto templateRegionRespDto = new TemplateRegionRespDto();
        templateRegionRespDto.setWarehouseId(Long.valueOf(0L));
        templateRegionRespDto.setType("polygon");
        String geo = "[{\"lng\":62.929688,\"lat\":55.279115},{\"lng\":137.812500,\"lat\":57.704147},{\"lng\":136.582031,\"lat\":17.978733},{\"lng\":62.578125,\"lat\":19.145168},{\"lng\":62.929688,\"lat\":55.279115}]";
        if (StringUtils.isNotBlank((CharSequence)geo) && !CollectionUtils.isEmpty((Collection)(coordinateDtoList = JSON.parseArray((String)geo, CoordinateDto.class)))) {
            ArrayList list1 = new ArrayList();
            ArrayList list2 = new ArrayList();
            for (CoordinateDto coordinateDto : coordinateDtoList) {
                ArrayList<Double> list3 = new ArrayList<Double>();
                list3.add(coordinateDto.getLng());
                list3.add(coordinateDto.getLat());
                list2.add(list3);
            }
            list1.add(list2);
            templateRegionRespDto.setCoordinates(list1);
        }
        templateRegionList.add(templateRegionRespDto);
        return templateRegionList;
    }

    private GeoDto getShopDeliveryGeo(ShopDto shopDto) {
        ShopDeliveryDto shopDeliveryDto = shopDto.getShopDeliveryDto();
        GeoDto geoDto = null;
        if (shopDeliveryDto != null) {
            String[] geo = StringUtils.split((String)shopDeliveryDto.getGeo(), (String)",");
            geoDto = new GeoDto();
            geoDto.setLongitude(geo[0]);
            geoDto.setLatitude(geo[1]);
        }
        return geoDto;
    }

    private List<TemplateRegionRespDto> getTemplateRegionRespDtoList(ShopDto shopDto) {
        List shopWarehouseDtoList = shopDto.getShopWarehouseDto();
        ArrayList<TemplateRegionRespDto> templateRegionList = new ArrayList<TemplateRegionRespDto>();
        if (!CollectionUtils.isEmpty((Collection)shopWarehouseDtoList)) {
            for (ShopWarehouseDto shopWarehouseDto : shopWarehouseDtoList) {
                TemplateRegionRespDto templateRegionRespDto = new TemplateRegionRespDto();
                templateRegionRespDto.setWarehouseId(shopWarehouseDto.getWarehouseId());
                templateRegionRespDto.setType("polygon");
                String geo = shopWarehouseDto.getGeo();
                if (!StringUtils.isNotBlank((CharSequence)geo)) continue;
                List<Object> coordinateDtoList = new ArrayList();
                if (geo.contains("{")) {
                    coordinateDtoList = JSON.parseArray((String)geo, CoordinateDto.class);
                } else {
                    String[] list = geo.split(";");
                    coordinateDtoList = Arrays.stream(list).map(geoStr -> {
                        String[] split = geoStr.split(",");
                        CoordinateDto coordinateDto = new CoordinateDto();
                        coordinateDto.setLng(Double.valueOf(split[0]));
                        coordinateDto.setLat(Double.valueOf(split[1]));
                        return coordinateDto;
                    }).collect(Collectors.toList());
                }
                if (CollectionUtils.isEmpty(coordinateDtoList)) continue;
                ConvexUtil.getCloseCycle(coordinateDtoList);
                ArrayList list1 = new ArrayList();
                ArrayList list2 = new ArrayList();
                for (CoordinateDto coordinateDto : coordinateDtoList) {
                    ArrayList<Double> list3 = new ArrayList<Double>();
                    list3.add(coordinateDto.getLng());
                    list3.add(coordinateDto.getLat());
                    list2.add(list3);
                }
                list1.add(list2);
                templateRegionRespDto.setCoordinates(list1);
                templateRegionList.add(templateRegionRespDto);
            }
        }
        return templateRegionList;
    }

    private void removeIndex(ItemSearchIndexMessageVo itemSearchIndexMessageVo) {
        this.deleteByIndexId(String.valueOf(itemSearchIndexMessageVo.getItemId()));
    }

    private void create(ItemRespDto itemRespDto) {
        IndexDocumentVo indexDocumentVo = new IndexDocumentVo(ItemSearchIndexConstant.getIndexName(), "item_search");
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(itemRespDto.getGroupKey());
        Map describe = CustomBeanUtils.describe((Object)itemRespDto);
        indexDocContentVo.setDocValueMap(describe);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u521b\u5efa\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.addData(indexDocumentVo);
    }

    private void update(ItemRespDto itemRespDto) {
        IndexDocumentVo indexDocumentVo = new IndexDocumentVo(ItemSearchIndexConstant.getIndexName(), "item_search");
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(itemRespDto.getGroupKey());
        Map describe = CustomBeanUtils.describe((Object)itemRespDto);
        indexDocContentVo.setDocValueMap(describe);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u66f4\u65b0\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.updateData(indexDocumentVo);
    }

    private void deleteAndCreate(ItemRespDto itemRespDto, List<String> indexIdList) {
        for (String indexId : indexIdList) {
            if ("null".equals(indexId)) continue;
            this.deleteByIndexId(indexId);
        }
        this.create(itemRespDto);
    }

    private void deleteByIndexId(String indexId) {
        IndexDocumentVo indexDocumentVo = new IndexDocumentVo(ItemSearchIndexConstant.getIndexName(), "item_search");
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(indexId);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u6839\u636eindexId\u5220\u9664\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.deleteData(indexDocumentVo);
    }

    private Long generateId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = BaseEoUtil.getWorkerId();
        return IdGenrator.nextId((long)workerId, (long)tenantCode);
    }
}

