/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.BaseEoUtil;
import com.dtyunxi.huieryun.ds.IdGenrator;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.DistributionFeeDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.CoordinateDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.EsItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShopRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.LocationDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.TemplateRegionRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.constants.ItemSearchIndexConstant;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.vo.ItemSearchIndexMessageVo;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDistributionSetService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.ConvexUtil;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemAttributesDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.StatDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StatEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdStatEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDeliveryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopWarehouseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.GeoDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.geo.builders.PointBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

public class ItemSearchTcpServiceImpl
implements IItemSearchService {
    private Logger logger = LoggerFactory.getLogger(ItemSearchTcpServiceImpl.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ItemDas itemDas;
    @Resource
    private IItemService itemService;
    @Resource
    private StatDas statDas;
    @Resource
    private ItemAttributesDas itemAttributesDas;
    @Autowired(required=false)
    private TransportClient esClient;
    @Autowired(required=false)
    private IndicesAdminClient adminClient;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private IShopQueryApi shopQueryApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void initIndex() {
        if (!ItemSearchIndexConstant.USE_ES) {
            return;
        }
        if (this.notExistsThenCreateIndex(ItemSearchIndexConstant.getIndexName())) {
            String basePath = System.getProperty("user.dir");
            String mappingName = "item_index_mapping.json";
            File file = new File(basePath + File.separator + "yundt-cube-center-itembiz" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + mappingName);
            StringBuilder mapping = new StringBuilder();
            InputStream is = null;
            InputStreamReader isr = null;
            BufferedReader in = null;
            try {
                String line;
                if (file.exists()) {
                    is = new FileInputStream(file);
                } else {
                    URL url = ItemSearchTcpServiceImpl.class.getClassLoader().getResource(mappingName);
                    if (url != null) {
                        is = url.openStream();
                    }
                }
                if (is == null) {
                    this.logger.error("\u65e0\u6cd5\u52a0\u8f7dmapping\u914d\u7f6e\u6587\u4ef6\uff0c\u8bf7\u624b\u52a8\u521d\u59cb\u5316es\u76f8\u5173\u64cd\u4f5c\u3002\u521b\u5efaes\uff0c\u6784\u5efamapping");
                    return;
                }
                isr = new InputStreamReader(is, "utf-8");
                in = new BufferedReader(isr);
                while ((line = in.readLine()) != null) {
                    mapping.append(line);
                }
            }
            catch (Exception e) {
                this.deleteIndexName(ItemSearchIndexConstant.getIndexName());
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {}
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>(1);
            map.put("max_result_window", 200000000);
            this.adminClient.prepareUpdateSettings(new String[]{ItemSearchIndexConstant.getIndexName()}).setSettings(map).get();
            PutMappingRequestBuilder builder = this.adminClient.preparePutMapping(new String[]{ItemSearchIndexConstant.getIndexName()});
            builder.setType("item_search");
            builder.setSource(mapping.toString(), XContentType.JSON);
            PutMappingResponse response = (PutMappingResponse)builder.get();
            if (response.isAcknowledged()) {
                this.sync();
            }
        }
    }

    @Override
    public void index(final Long sellerId, final Long itemId, final Integer itemType, final Integer busType, final String operation) {
        this.logger.info("\u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5230es,sellerId:{},itemId:{},itemType:{},operation:{}", new Object[]{sellerId, itemId, itemType, operation});
        if (!ItemSearchIndexConstant.USE_ES) {
            return;
        }
        if (itemId == null) {
            this.logger.error("\u6784\u5efaes\u7d22\u5f15\u5931\u8d25\uff0c\u5546\u54c1id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    ItemSearchTcpServiceImpl.this.index(sellerId, itemId, itemType, busType, operation, 0);
                }
            });
        } else {
            this.index(sellerId, itemId, itemType, busType, operation, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ItemSearchRespDto query(ItemSearchQueryReqDto itemSearchQueryReqDto, Integer pageNum, Integer pageSize) {
        void var10_21;
        SearchRequestBuilder builder = this.esClient.prepareSearch(new String[]{ItemSearchIndexConstant.getIndexName()});
        builder.setTypes(new String[]{"item_search"});
        if (itemSearchQueryReqDto.getType() == null) {
            itemSearchQueryReqDto.setType(itemSearchQueryReqDto.getItemType());
        }
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        builder.setFrom((pageNum - 1) * pageSize);
        builder.setSize(pageSize.intValue());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (itemSearchQueryReqDto.getTenantId() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (Object)itemSearchQueryReqDto.getTenantId()));
        }
        if (itemSearchQueryReqDto.getInstanceId() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"instanceId", (Object)itemSearchQueryReqDto.getInstanceId()));
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getKeyword())) {
            BoolQueryBuilder subBoolQueryBuilder = QueryBuilders.boolQuery();
            subBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)QueryParser.escape((String)itemSearchQueryReqDto.getKeyword())).boost(2.0f));
            subBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"displayName", (Object)QueryParser.escape((String)itemSearchQueryReqDto.getKeyword())).boost(1.7f));
            subBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"brand", (Object)QueryParser.escape((String)itemSearchQueryReqDto.getKeyword())).boost(1.5f));
            boolQueryBuilder.must((QueryBuilder)subBoolQueryBuilder);
        }
        if (itemSearchQueryReqDto.getType() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)itemSearchQueryReqDto.getType()));
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getBusTypeList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"busType", (Collection)itemSearchQueryReqDto.getBusTypeList()));
        } else if (itemSearchQueryReqDto.getBusType() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"busType", (Object)itemSearchQueryReqDto.getBusType()));
        }
        if (itemSearchQueryReqDto.getType() == null && itemSearchQueryReqDto.getNeType() != null) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)itemSearchQueryReqDto.getNeType()));
        }
        if (itemSearchQueryReqDto.getBrandId() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"brandId", (Object)itemSearchQueryReqDto.getBrandId()));
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getItemIds())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.nestedQuery((String)"dirsItemsList", (QueryBuilder)QueryBuilders.termsQuery((String)"dirsItemsList.itemId", (Collection)itemSearchQueryReqDto.getItemIds()), (ScoreMode)ScoreMode.None));
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getInItemIds())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.nestedQuery((String)"dirsItemsList", (QueryBuilder)QueryBuilders.termsQuery((String)"dirsItemsList.itemId", (Collection)itemSearchQueryReqDto.getInItemIds()), (ScoreMode)ScoreMode.None));
        }
        if (itemSearchQueryReqDto.getSellerId() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.nestedQuery((String)"dirsItemsList", (QueryBuilder)QueryBuilders.termQuery((String)"dirsItemsList.sellerId", (Object)itemSearchQueryReqDto.getSellerId()), (ScoreMode)ScoreMode.None));
        }
        if (itemSearchQueryReqDto.getShopId() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.nestedQuery((String)"dirsItemsList", (QueryBuilder)QueryBuilders.termQuery((String)"dirsItemsList.shopId", (Object)itemSearchQueryReqDto.getShopId()), (ScoreMode)ScoreMode.None));
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getDirIds())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.nestedQuery((String)"dirsItemsList", (QueryBuilder)QueryBuilders.termsQuery((String)"dirsItemsList.dirId", (Collection)itemSearchQueryReqDto.getDirIds()), (ScoreMode)ScoreMode.None));
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getProp())) {
            String[] props;
            for (String string : props = itemSearchQueryReqDto.getProp().split(";")) {
                String[] searchData = string.split(":");
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.nestedQuery((String)"searchAttr", (QueryBuilder)QueryBuilders.termQuery((String)"searchAttr.name", (String)searchData[0]), (ScoreMode)ScoreMode.None));
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.nestedQuery((String)"searchAttr", (QueryBuilder)QueryBuilders.termQuery((String)"searchAttr.value", (String)searchData[1]), (ScoreMode)ScoreMode.None));
            }
        }
        if (itemSearchQueryReqDto.getLat() != null && itemSearchQueryReqDto.getLon() != null) {
            PointBuilder pointBuilder = new PointBuilder(Double.valueOf(itemSearchQueryReqDto.getLon()).doubleValue(), Double.valueOf(itemSearchQueryReqDto.getLat()).doubleValue());
            try {
                GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoIntersectionQuery((String)"itemShopList.templateRegionList", (ShapeBuilder)pointBuilder);
                boolQueryBuilder.filter((QueryBuilder)geoShapeQueryBuilder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (itemSearchQueryReqDto.getMinPrice() != null || itemSearchQueryReqDto.getMaxPrice() != null) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"minPrice");
            if (itemSearchQueryReqDto.getMinPrice() != null) {
                rangeQueryBuilder.from((Object)itemSearchQueryReqDto.getMinPrice());
            }
            if (itemSearchQueryReqDto.getMaxPrice() != null) {
                rangeQueryBuilder.to((Object)itemSearchQueryReqDto.getMaxPrice());
            }
            boolQueryBuilder.filter((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getOrderByDesc())) {
            if ("sales".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                builder.addSort("salesCount", SortOrder.DESC);
            } else if ("price".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                builder.addSort("minPrice", SortOrder.DESC);
            } else if ("shelfTime".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                builder.addSort("itemShelfInfoList.shelfTime", SortOrder.DESC);
            }
        } else if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getOrderBy())) {
            if ("sales".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                builder.addSort("salesCount", SortOrder.ASC);
            } else if ("price".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                builder.addSort("minPrice", SortOrder.ASC);
            } else if ("shelfTime".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                builder.addSort("itemShelfInfoList.shelfTime", SortOrder.ASC);
            }
        }
        builder.setQuery((QueryBuilder)boolQueryBuilder);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("builder={}", (Object)builder);
        }
        SearchResponse response = null;
        System.out.println(builder.toString());
        try {
            response = (SearchResponse)builder.get();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("response={}", (Object)response);
        }
        ItemSearchRespDto itemSearchRespDto = new ItemSearchRespDto();
        if (response == null) {
            return itemSearchRespDto;
        }
        ArrayList<Object> itemRespDtoList = new ArrayList<Object>(response.getHits().getHits().length);
        for (SearchHit searchHit : response.getHits()) {
            itemRespDtoList.add(JSON.parseObject((String)searchHit.getSourceAsString(), EsItemRespDto.class));
        }
        if (itemSearchQueryReqDto.getLat() != null && itemSearchQueryReqDto.getLon() != null && !CollectionUtils.isEmpty(itemRespDtoList)) {
            List<ItemShopRespDto> rangeShopList = this.getRangeShopList(itemSearchQueryReqDto.getLon(), itemSearchQueryReqDto.getLat());
            if (!CollectionUtils.isEmpty((Collection)rangeShopList)) {
                itemSearchRespDto.setRangeShopList(rangeShopList.stream().map(ItemShopRespDto::getShopId).collect(Collectors.toList()));
            }
            itemRespDtoList.forEach(itemRespDto -> {
                if (itemSearchQueryReqDto.getFilterShop() == null || itemSearchQueryReqDto.getFilterShop().booleanValue()) {
                    this.setMiniDistantShopAndShelfType((ItemRespDto)itemRespDto, rangeShopList, itemSearchQueryReqDto.getShopId());
                }
            });
        }
        if (null != itemSearchQueryReqDto.getShopId()) {
            itemRespDtoList.forEach(itemRespDto -> itemRespDto.setShopId(itemSearchQueryReqDto.getShopId()));
        }
        for (ItemRespDto itemRespDto2 : itemRespDtoList) {
            this.setMinDistributionInfo(itemRespDto2);
        }
        PageInfo pageInfo = new PageInfo(itemRespDtoList);
        pageInfo.setTotal(response.getHits().getTotalHits());
        Integer n = Math.toIntExact(response.getHits().getTotalHits() / (long)pageSize.intValue());
        if (response.getHits().getTotalHits() % (long)pageSize.intValue() != 0L) {
            Integer n2 = n + 1;
        }
        pageInfo.setPages(var10_21.intValue());
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        itemSearchRespDto.setPageInfo(pageInfo);
        return itemSearchRespDto;
    }

    private void setMinDistributionInfo(ItemRespDto itemRespDto) {
        List shelfRespDtos = itemRespDto.getItemShelfInfoList().stream().filter(shelfDto -> shelfDto.getShopId().equals(itemRespDto.getShopId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(shelfRespDtos)) {
            if (Integer.valueOf(1).equals(((ItemShelfRespDto)shelfRespDtos.get(0)).getDistribution())) {
                itemRespDto.setDistribution(Integer.valueOf(1));
                if (!CollectionUtils.isEmpty((Collection)itemRespDto.getDistributionFeeList())) {
                    BigDecimal min = itemRespDto.getDistributionFeeList().stream().filter(feeDto -> feeDto.getShopId() != null && feeDto.getShopId().equals(itemRespDto.getShopId())).map(DistributionFeeDto::getAmount).sorted().findFirst().orElse(BigDecimal.ZERO);
                    itemRespDto.setDistributionFee(min);
                } else {
                    this.logger.info("\u5546\u54c1\u5206\u9500\u4f63\u91d1\u4e3a\u7a7a\uff0citemId={}, shopId={}", (Object)itemRespDto.getItemId(), (Object)itemRespDto.getShopId());
                }
            }
        } else {
            this.logger.info("\u5546\u54c1\u4e0a\u67b6\u8bb0\u5f55\u4e3a\u7a7a\uff0citemId={}, shopId={}", (Object)itemRespDto.getItemId(), (Object)itemRespDto.getShopId());
        }
    }

    public static void main(String[] args) {
        ArrayList list = Lists.newArrayList((Object[])new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO});
        list.stream().sorted();
        System.out.println("1111");
    }

    private Long getMiniDistanceShopId(Map<Long, List<ItemShopRespDto>> shopRespDtoMap, List<ItemShopRespDto> sortShopList) {
        for (ItemShopRespDto itemShopRespDto : sortShopList) {
            if (shopRespDtoMap.get(itemShopRespDto.getShopId()) == null) continue;
            return itemShopRespDto.getShopId();
        }
        return null;
    }

    private Long getShippingShopId(List<ItemShopRespDto> itemShopList) {
        for (ItemShopRespDto itemShopRespDto : itemShopList) {
            if (itemShopRespDto.getBusinessType() == null || !itemShopRespDto.getBusinessType().equals(1)) continue;
            return itemShopRespDto.getShopId();
        }
        return null;
    }

    private List<ItemShopRespDto> getRangeShopList(Double lon, Double lat) {
        SearchRequestBuilder builder = this.esClient.prepareSearch(new String[]{ItemSearchIndexConstant.SHOP_INDEX_NAME});
        builder.setTypes(new String[]{ItemSearchIndexConstant.SHOP_INDEX_TYPE_NAME});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (lon != null && lat != null) {
            PointBuilder pointBuilder = new PointBuilder(lon.doubleValue(), lat.doubleValue());
            try {
                GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoIntersectionQuery((String)"templateRegionList", (ShapeBuilder)pointBuilder);
                boolQueryBuilder.filter((QueryBuilder)geoShapeQueryBuilder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        builder.setFrom(0);
        builder.setSize(1000);
        builder.setQuery((QueryBuilder)boolQueryBuilder);
        GeoDistanceSortBuilder sortBuilder = (GeoDistanceSortBuilder)SortBuilders.geoDistanceSort((String)"location", (double)lat, (double)lon).unit(DistanceUnit.METERS).order(SortOrder.ASC);
        builder.addSort((SortBuilder)sortBuilder);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("builder={}", (Object)builder);
        }
        String s = builder.toString();
        this.logger.info("\u5e97\u92ea\u67e5\u8a62\u689d\u4ef6={}", (Object)s);
        SearchResponse response = null;
        try {
            response = (SearchResponse)builder.get();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("response={}", (Object)response);
        }
        if (response == null) {
            return null;
        }
        ArrayList<ItemShopRespDto> itemShopRespDtos = new ArrayList<ItemShopRespDto>(response.getHits().getHits().length);
        for (SearchHit hit : response.getHits()) {
            itemShopRespDtos.add((ItemShopRespDto)JSON.parseObject((String)hit.getSourceAsString(), ItemShopRespDto.class));
        }
        return itemShopRespDtos;
    }

    private Long getShopId(List<ItemShopRespDto> itemShopList, Map<Long, List<ItemShopRespDto>> shopRespDtoMap, List<ItemShopRespDto> sortShop) {
        Long miniDistanceShopId = null;
        if (!CollectionUtils.isEmpty(sortShop)) {
            miniDistanceShopId = this.getMiniDistanceShopId(shopRespDtoMap, sortShop);
        }
        if (miniDistanceShopId == null) {
            return this.getShippingShopId(itemShopList);
        }
        return miniDistanceShopId;
    }

    private void setMiniDistantShopAndShelfType(ItemRespDto itemRespDto, List<ItemShopRespDto> sortShopList, Long shopId) {
        List<ItemShopRespDto> itemShopRespDtos;
        List itemShopList = itemRespDto.getItemShopList();
        Map<Long, List<ItemShopRespDto>> shopRespDtoMap = itemShopList.stream().collect(Collectors.groupingBy(ItemShopRespDto::getShopId));
        itemRespDto.setShopId(shopId == null ? this.getShopId(itemShopList, shopRespDtoMap, sortShopList) : shopId);
        if (itemRespDto.getShopId() != null && !CollectionUtils.isEmpty(itemShopRespDtos = shopRespDtoMap.get(itemRespDto.getShopId()))) {
            itemRespDto.setShelfType(itemShopRespDtos.get(0).getShelfType());
        }
    }

    @Override
    public void sync() {
    }

    private boolean notExistsThenCreateIndex(String indexName) {
        IndicesExistsRequest request = new IndicesExistsRequest(new String[]{indexName});
        try {
            if (((IndicesExistsResponse)this.adminClient.exists(request).get()).isExists()) {
                return false;
            }
            return ((CreateIndexResponse)this.adminClient.prepareCreate(indexName).get()).isAcknowledged();
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void deleteIndexName(String indexName) {
        ((DeleteIndexResponse)this.adminClient.prepareDelete(new String[]{indexName}).get()).isAcknowledged();
    }

    private void index(Long sellerId, Long itemId, Integer itemType, Integer busType, String operation, int retry) {
        if (retry > 3) {
            this.logger.error("\u7d22\u5f15\u91cd\u590d\u6784\u5efa\u8d85\u8fc73\u6b21\uff0c\u5546\u54c1ID\u4e3a:{}\u8bf7\u68c0\u67e5", (Object)itemId);
            return;
        }
        ItemSearchIndexMessageVo itemSearchIndexMessageVo = new ItemSearchIndexMessageVo(sellerId, itemId, itemType, busType, operation, retry);
        itemSearchIndexMessageVo.setMessageId(this.generateId());
        try {
            this.logger.info("\u5f00\u59cb\u53d1\u9001es\u540c\u6b65\u6d88\u606f\uff0cmessageId\uff1a{}, message:{}", (Object)itemSearchIndexMessageVo.getMessageId(), (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
            MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("ITEM_SEARCH_INDEX", (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
            if ("error".equalsIgnoreCase(messageResponse.getResultMsg())) {
                this.logger.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25");
                this.index(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getItemType(), itemSearchIndexMessageVo.getBusType(), itemSearchIndexMessageVo.getOperation(), itemSearchIndexMessageVo.getRetry() + 1);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public MessageResponse process(Object object) {
        Thread.currentThread().setName("ITEM_SEARCH_SERVICE_IMPL_" + UUID.randomUUID().toString());
        if (object == null) {
            this.logger.error("\u63a5\u53d7\u5230\u7a7a\u7684MQ\u6d88\u606f");
            return MessageResponse.SUCCESS;
        }
        try {
            ItemSearchIndexMessageVo itemSearchIndexMessageVo = (ItemSearchIndexMessageVo)JSON.parseObject((String)object.toString(), ItemSearchIndexMessageVo.class);
            this.logger.info("\u5f00\u59cb\u5904\u7406es\u540c\u6b65\u6d88\u606f\uff0cmessageId\uff1a{}", (Object)itemSearchIndexMessageVo.getMessageId());
            ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemSearchIndexMessageVo.getItemId());
            if (itemEo == null) {
                this.logger.error("\u5546\u54c1ID:{}\u5bf9\u5e94\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)itemSearchIndexMessageVo.getItemId());
                return MessageResponse.SUCCESS;
            }
            switch (itemSearchIndexMessageVo.getOperation()) {
                case "ON_SHELF": {
                    this.createOrUpdateOrRemoveIndex(itemSearchIndexMessageVo);
                    break;
                }
                case "OFF_SHELF": {
                    this.createOrUpdateOrRemoveIndex(itemSearchIndexMessageVo);
                    break;
                }
                case "SALES_COUNT": {
                    this.createOrUpdateOrRemoveIndex(itemSearchIndexMessageVo);
                    break;
                }
                default: {
                    this.logger.error("\u672a\u77e5\u7684\u6d88\u606f\u5904\u7406\u7c7b\u578b:{}", (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u540c\u6b65\u5230es\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e, (Object)e.getMessage());
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private List<ItemShopRespDto> getShopList(Set<Long> shopIds, List<ItemShelfRespDto> itemShelfRespDtos) {
        Map<Long, List<ItemShelfRespDto>> shopItemShelfMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getShopId));
        ArrayList<ItemShopRespDto> itemShopList = new ArrayList<ItemShopRespDto>();
        for (Long shopId : shopIds) {
            this.logger.info("itemSearchIndexMessageVo.getShopId \u5e97\u94faID={}", (Object)shopId);
            ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryById(shopId.longValue(), new String[0]));
            this.logger.info("shopDto={}", JSON.toJSON((Object)shopDto));
            ItemShopRespDto itemShopRespDto = new ItemShopRespDto();
            itemShopRespDto.setShopId(shopId);
            itemShopRespDto.setBusinessType(shopDto.getBusinessType());
            List<ItemShelfRespDto> shopItemSelfList = shopItemShelfMap.get(shopId);
            if (!CollectionUtils.isEmpty(shopItemSelfList)) {
                Integer type = shopItemSelfList.get(0).getType();
                itemShopRespDto.setShelfType(type);
            }
            if (itemShopRespDto.getBusinessType() == null) {
                itemShopRespDto.setBusinessType(Integer.valueOf(shopDto.getType().intValue()));
            }
            ArrayList<LocationDto> locationDtos = new ArrayList<LocationDto>();
            GeoDto geoDto = null;
            if (2 == itemShopRespDto.getBusinessType()) {
                geoDto = this.getShopDeliveryGeo(shopDto);
            } else {
                geoDto = new GeoDto();
                geoDto.setLongitude("-99.140625");
                geoDto.setLatitude("-40.044438");
            }
            if (null != geoDto) {
                LocationDto locationDto = new LocationDto();
                locationDto.setLon(Double.valueOf(geoDto.getLongitude()));
                locationDto.setLat(Double.valueOf(geoDto.getLatitude()));
                locationDtos.add(locationDto);
            }
            itemShopRespDto.setLocation(locationDtos);
            List<TemplateRegionRespDto> templateRegionList = null;
            templateRegionList = 2 == itemShopRespDto.getBusinessType() ? this.getTemplateRegionRespDtoList(shopDto) : this.getRegionShippingList();
            itemShopRespDto.setTemplateRegionList(templateRegionList);
            itemShopList.add(itemShopRespDto);
        }
        return itemShopList;
    }

    private void createOrUpdateIndexGroupBySeller(ItemSearchIndexMessageVo itemSearchIndexMessageVo, ItemEo itemEo, List<ItemShelfRespDto> itemShelfRespDtos) {
        if (itemEo == null) {
            this.logger.error("\u6784\u5efa\u5546\u54c1\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1ID:{}\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)itemSearchIndexMessageVo.getItemId());
            return;
        }
        Long sellerId = itemSearchIndexMessageVo.getSellerId();
        this.logger.info("\u5546\u5bb6-\u5546\u54c1-\u4e1a\u52a1\u7c7b\u578b\u7ef4\u5ea6\u6784\u5efaES\u5546\u54c1\u6570\u636e,itemId:{}, sellerId:{},busType:{}", new Object[]{itemSearchIndexMessageVo.getItemId(), sellerId, itemSearchIndexMessageVo.getBusType()});
        List<ItemRespDto> itemRespDtoList = this.itemService.queryItemRespDto(Lists.newArrayList((Object[])new ItemEo[]{itemEo}), sellerId);
        if (CollectionUtils.isEmpty(itemRespDtoList)) {
            this.logger.error("\u6784\u5efa\u5546\u54c1\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1ID:{}\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)itemSearchIndexMessageVo.getItemId());
            return;
        }
        ItemRespDto itemRespDto = itemRespDtoList.get(0);
        itemRespDto.setItemShelfInfoList(itemShelfRespDtos);
        this.buildSaleCount(itemRespDto);
        this.buildSearchAttr(itemRespDto);
        this.buildPrice(itemRespDto, itemShelfRespDtos);
        Set<Long> itemShopIdSet = itemShelfRespDtos.stream().map(ItemShelfRespDto::getShopId).collect(Collectors.toSet());
        itemRespDto.setItemShopList(this.getShopList(itemShopIdSet, itemShelfRespDtos));
        itemRespDto.setType(itemShelfRespDtos.get(0).getItemType());
        itemRespDto.setBusType(itemShelfRespDtos.get(0).getBusType());
        itemRespDto.setItemId(itemRespDto.getId());
        String groupKey = this.getIndexDocId(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getBusType());
        itemRespDto.setGroupKey(groupKey);
        IDistributionSetService distributionSetService = (IDistributionSetService)SpringBeanUtil.getBean(IDistributionSetService.class);
        if (null != distributionSetService) {
            List<DistributionFeeDto> feeDtos = distributionSetService.calculateFee(itemShelfRespDtos);
            itemRespDto.setDistributionFeeList(feeDtos);
        }
        this.logger.info("itemRespDto={}", JSON.toJSON((Object)itemRespDto));
        try {
            SearchRequestBuilder builder = this.esClient.prepareSearch(new String[]{ItemSearchIndexConstant.getIndexName()}).setTypes(new String[]{"item_search"}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)itemRespDto.getGroupKey()));
            SearchResponse response = (SearchResponse)builder.get();
            long totalHit = response.getHits().getTotalHits();
            if (totalHit == 0L) {
                this.create(itemRespDto);
            } else if (totalHit == 1L) {
                this.update(itemRespDto);
            } else {
                ArrayList<String> indexIdList = new ArrayList<String>();
                for (SearchHit searchHitFields : response.getHits().getHits()) {
                    indexIdList.add(searchHitFields.getIndex());
                }
                this.deleteAndCreate(itemRespDto, indexIdList);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u540c\u6b65\u5230ES\u51fa\u73b0\u5f02\u5e38,\u5e76\u4e14\u91cd\u65b0\u53d1\u9001MQ\uff1a{}", (Object)e.getMessage(), (Object)e);
            this.index(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getItemType(), itemSearchIndexMessageVo.getBusType(), itemSearchIndexMessageVo.getOperation(), itemSearchIndexMessageVo.getRetry() + 1);
        }
    }

    private void buildPrice(ItemRespDto itemRespDto, List<ItemShelfRespDto> itemShelfDtos) {
        BigDecimal max = BigDecimal.ZERO;
        BigDecimal min = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(itemShelfDtos)) {
            List priceList = itemShelfDtos.stream().map(ItemShelfRespDto::getPrice).collect(Collectors.toList());
            max = (BigDecimal)priceList.stream().max(BigDecimal::compareTo).get();
            min = (BigDecimal)priceList.stream().min(BigDecimal::compareTo).get();
        }
        itemRespDto.setMinPrice(Double.valueOf(min.doubleValue()));
        itemRespDto.setMaxPrice(Double.valueOf(max.doubleValue()));
    }

    private void buildSaleCount(ItemRespDto itemRespDto) {
        StatEo statEo = new StatEo();
        statEo.setItemId(itemRespDto.getId());
        List statEoList = this.statDas.select((BaseEo)statEo);
        Long salesCount = 0L;
        if (!CollectionUtils.isEmpty((Collection)statEoList)) {
            salesCount = statEoList.stream().mapToLong(StdStatEo::getSalesCount).sum();
        }
        itemRespDto.setSalesCount(salesCount);
    }

    private void buildSearchAttr(ItemRespDto itemRespDto) {
        String searchAttr;
        ItemAttributesEo itemAttributesEo = new ItemAttributesEo();
        itemAttributesEo.setItemId(itemRespDto.getId());
        itemAttributesEo = (ItemAttributesEo)this.itemAttributesDas.selectOne((BaseEo)itemAttributesEo);
        if (itemAttributesEo != null && StringUtils.isNotBlank((CharSequence)(searchAttr = itemAttributesEo.getSearchAttrs())) && searchAttr.startsWith("{")) {
            JSONObject jsonObject = JSON.parseObject((String)searchAttr);
            ArrayList searchAttrList = new ArrayList();
            for (String name : jsonObject.keySet()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", name);
                map.put("value", String.valueOf(jsonObject.get((Object)name)));
                searchAttrList.add(map);
            }
            itemRespDto.setSearchAttr(searchAttrList);
        }
    }

    private String getIndexDocId(Long sellerId, Long itemId, Integer busType) {
        return String.valueOf(sellerId) + itemId + busType;
    }

    private void createOrUpdateOrRemoveIndex(ItemSearchIndexMessageVo itemSearchIndexMessageVo) {
        this.logger.info("\u5f00\u59cb\u521b\u5efa/\u4fee\u6539/\u5220\u9664\u7d22\u5f15\u6570\u636e \u2026\u2026 ItemSearchIndexMessageVo\uff1a{}", JSON.toJSON((Object)itemSearchIndexMessageVo));
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemSearchIndexMessageVo.getItemId());
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(itemSearchIndexMessageVo.getItemId());
        shelfReqDto.setSellerId(itemSearchIndexMessageVo.getSellerId());
        shelfReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        shelfReqDto.setItemType(itemSearchIndexMessageVo.getItemType());
        shelfReqDto.setBusType(itemSearchIndexMessageVo.getBusType());
        List<ItemShelfRespDto> itemShelfRespDtos = this.itemService.queryItemShelfList(shelfReqDto);
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u4e0a\u67b6\u5217\u8868\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(itemShelfRespDtos));
        if (!CollectionUtils.isEmpty(itemShelfRespDtos)) {
            this.logger.info("\u6309\u7167\u5546\u5bb6\u7ef4\u5ea6\u6784\u5efa\u7d22\u5f15\u6570\u636e\u2026\u2026");
            Map<Long, List<ItemShelfRespDto>> sellerMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getSellerId));
            this.logger.info("\u6309\u7167\u5546\u5bb6\u7ef4\u5ea6\u6784\u5efa\u7d22\u5f15\u6570\u636e,sellerMap:{}", (Object)JSON.toJSONString(sellerMap));
            for (Long sellerId : sellerMap.keySet()) {
                List<ItemShelfRespDto> itemShelfList = sellerMap.get(sellerId);
                Map<Integer, List<ItemShelfRespDto>> bizTypeMap = itemShelfList.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getBusType));
                for (Integer bizType : bizTypeMap.keySet()) {
                    List<ItemShelfRespDto> resultList = bizTypeMap.get(bizType);
                    ItemSearchIndexMessageVo itemSearchIndexMessage = new ItemSearchIndexMessageVo();
                    BeanUtils.copyProperties((Object)itemSearchIndexMessageVo, (Object)itemSearchIndexMessage);
                    itemSearchIndexMessage.setSellerId(sellerId);
                    itemSearchIndexMessage.setBusType(bizType);
                    this.createOrUpdateIndexGroupBySeller(itemSearchIndexMessage, itemEo, resultList);
                }
            }
        } else if (itemSearchIndexMessageVo.getSellerId() != null) {
            this.logger.info("\u6839\u636eindexId\u5220\u9664\u7d22\u5f15\u6570\u636e.");
            this.deleteByIndexId(this.getIndexDocId(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getBusType()));
        }
    }

    private List<TemplateRegionRespDto> getRegionShippingList() {
        List coordinateDtoList;
        ArrayList<TemplateRegionRespDto> templateRegionList = new ArrayList<TemplateRegionRespDto>();
        TemplateRegionRespDto templateRegionRespDto = new TemplateRegionRespDto();
        templateRegionRespDto.setWarehouseId(Long.valueOf(0L));
        templateRegionRespDto.setType("polygon");
        String geo = "[{\"lng\":62.929688,\"lat\":55.279115},{\"lng\":137.812500,\"lat\":57.704147},{\"lng\":136.582031,\"lat\":17.978733},{\"lng\":62.578125,\"lat\":19.145168},{\"lng\":62.929688,\"lat\":55.279115}]";
        if (StringUtils.isNotBlank((CharSequence)geo) && !CollectionUtils.isEmpty((Collection)(coordinateDtoList = JSON.parseArray((String)geo, CoordinateDto.class)))) {
            ArrayList list1 = new ArrayList();
            ArrayList list2 = new ArrayList();
            for (CoordinateDto coordinateDto : coordinateDtoList) {
                ArrayList<Double> list3 = new ArrayList<Double>();
                list3.add(coordinateDto.getLng());
                list3.add(coordinateDto.getLat());
                list2.add(list3);
            }
            list1.add(list2);
            templateRegionRespDto.setCoordinates(list1);
        }
        templateRegionList.add(templateRegionRespDto);
        return templateRegionList;
    }

    private GeoDto getShopDeliveryGeo(ShopDto shopDto) {
        ShopDeliveryDto shopDeliveryDto = shopDto.getShopDeliveryDto();
        GeoDto geoDto = null;
        if (shopDeliveryDto != null) {
            String[] geo = StringUtils.split((String)shopDeliveryDto.getGeo(), (String)",");
            geoDto = new GeoDto();
            geoDto.setLongitude(geo[0]);
            geoDto.setLatitude(geo[1]);
        }
        return geoDto;
    }

    private List<TemplateRegionRespDto> getTemplateRegionRespDtoList(ShopDto shopDto) {
        List shopWarehouseDtoList = shopDto.getShopWarehouseDto();
        ArrayList<TemplateRegionRespDto> templateRegionList = new ArrayList<TemplateRegionRespDto>();
        if (!CollectionUtils.isEmpty((Collection)shopWarehouseDtoList)) {
            for (ShopWarehouseDto shopWarehouseDto : shopWarehouseDtoList) {
                TemplateRegionRespDto templateRegionRespDto = new TemplateRegionRespDto();
                templateRegionRespDto.setWarehouseId(shopWarehouseDto.getWarehouseId());
                templateRegionRespDto.setType("polygon");
                String geo = shopWarehouseDto.getGeo();
                if (!StringUtils.isNotBlank((CharSequence)geo)) continue;
                List<Object> coordinateDtoList = new ArrayList();
                if (geo.contains("{")) {
                    coordinateDtoList = JSON.parseArray((String)geo, CoordinateDto.class);
                } else {
                    String[] list = geo.split(";");
                    coordinateDtoList = Arrays.stream(list).map(geoStr -> {
                        String[] split = geoStr.split(",");
                        CoordinateDto coordinateDto = new CoordinateDto();
                        coordinateDto.setLng(Double.valueOf(split[0]));
                        coordinateDto.setLat(Double.valueOf(split[1]));
                        return coordinateDto;
                    }).collect(Collectors.toList());
                }
                if (CollectionUtils.isEmpty(coordinateDtoList)) continue;
                ConvexUtil.getCloseCycle(coordinateDtoList);
                ArrayList list1 = new ArrayList();
                ArrayList list2 = new ArrayList();
                for (CoordinateDto coordinateDto : coordinateDtoList) {
                    ArrayList<Double> list3 = new ArrayList<Double>();
                    list3.add(coordinateDto.getLng());
                    list3.add(coordinateDto.getLat());
                    list2.add(list3);
                }
                list1.add(list2);
                templateRegionRespDto.setCoordinates(list1);
                templateRegionList.add(templateRegionRespDto);
            }
        }
        return templateRegionList;
    }

    private void removeIndex(ItemSearchIndexMessageVo itemSearchIndexMessageVo) {
        this.deleteByIndexId(String.valueOf(itemSearchIndexMessageVo.getItemId()));
    }

    private void create(ItemRespDto itemRespDto) {
        itemRespDto.setItemId(itemRespDto.getId());
        IndexRequestBuilder builder = this.esClient.prepareIndex(ItemSearchIndexConstant.getIndexName(), "item_search");
        builder.setId(itemRespDto.getGroupKey());
        builder.setSource(JSON.toJSONString((Object)itemRespDto), XContentType.JSON);
        this.logger.info("\u65b0\u589e\u8bf7\u6c42\u53c2\u6570={}", (Object)JSON.toJSONString((Object)itemRespDto));
        builder.get();
    }

    private void update(ItemRespDto itemRespDto) {
        this.logger.info("\u66f4\u65b0\u8bf7\u6c42\u53c2\u6570={}", (Object)JSON.toJSONString((Object)itemRespDto));
        UpdateRequestBuilder builder = this.esClient.prepareUpdate(ItemSearchIndexConstant.getIndexName(), "item_search", String.valueOf(itemRespDto.getGroupKey()));
        builder.setDocAsUpsert(true);
        builder.setDoc(JSON.toJSONString((Object)itemRespDto), XContentType.JSON);
        builder.get();
    }

    private void deleteAndCreate(ItemRespDto itemRespDto, List<String> indexIdList) {
        this.logger.info("\u5220\u9664\u65e7\u6570\u636e\u5e76\u91cd\u65b0\u521b\u5efaitemRespDto\uff1a{}\uff0cindexIdList\uff1a{}", (Object)JSON.toJSONString((Object)itemRespDto), (Object)JSON.toJSONString(indexIdList));
        for (String indexId : indexIdList) {
            if ("null".equals(indexId)) continue;
            this.deleteByIndexId(indexId);
        }
        this.create(itemRespDto);
    }

    private void deleteByIndexId(String indexId) {
        this.logger.info("delete es id={}", (Object)indexId);
        DeleteRequestBuilder builder = this.esClient.prepareDelete(ItemSearchIndexConstant.getIndexName(), "item_search", indexId);
        builder.get();
    }

    private Long generateId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = BaseEoUtil.getWorkerId();
        return IdGenrator.nextId((long)workerId, (long)tenantCode);
    }
}

