/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemPriceEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BundleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirItemRelativeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAllowOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemDirQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemMediasReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemModifyStatusReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPropRelationReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPublishReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStatReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfTaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.AllowOrderTimeRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BundleItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirItemRelativeQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirsItemsRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAllowOrderDetailQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAllowOrderQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAttributesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailBaseInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDirQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemOnShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPropRelationRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuListRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStatRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfIntegralRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfTaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfTaskRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.constants.ItemSearchIndexConstant;
import com.dtyunxi.yundt.cube.center.item.biz.base.constants.ItemType;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IBundleItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAuditService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemCycleBuyService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemMediasService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemPriceService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemTagService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IPropService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfIntegralService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.BrandDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemAttributesDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemBundleRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPropRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemTagRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfTaskDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.StatDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.doc.ItemDoc;
import com.dtyunxi.yundt.cube.center.item.dao.base.doc.ItemSkuDoc;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemSearchVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.BrandEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemBundleRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPropRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemTagRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfTaskEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StatEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemPriceEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="itemService")
public class ItemServiceImpl
implements IItemService {
    private static Logger logger = LoggerFactory.getLogger(ItemServiceImpl.class);
    @Resource
    private ItemDas itemDas;
    @Resource
    private IItemPriceService itemPriceService;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private IItemAttributesService itemAttributesService;
    @Resource
    private IItemMediasService itemMediasService;
    @Resource
    private IBundleItemService bundleItemService;
    @Resource
    private IItemTagService itemTagService;
    @Resource
    private IItemSkuService itemSkuService;
    @Resource
    private ItemAttributesDas itemAttributesDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private DirDas dirDas;
    @Resource
    private ItemPriceDas itemPriceDas;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private ItemBundleRelationDas itemBundleRelationDas;
    @Resource
    private ItemTagRelationDas itemTagRelationDas;
    @Resource
    private ShelfTaskDas shelfTaskDas;
    @Resource
    private IPropService propService;
    @Resource
    private ItemPropRelationDas itemPropRelationDas;
    @Autowired(required=false)
    private IItemSearchService itemSearchService;
    @Resource
    private StatDas statDas;
    @Resource
    private IItemAuditService iItemAuditService;
    @Resource
    private IItemShelfService iItemShelfService;
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private BrandDas brandDas;
    @Resource
    private IDirService dirService;
    public static final String CACHE_ITEM_DETAIL_PREFIX = "center_item_item_detail";

    @Override
    public PageInfo<ItemOnShelfRespDto> findItemOnSelf(String filter, Integer pageNum, Integer pageSize) {
        ItemSearchVo itemSearchVo = (ItemSearchVo)JSONObject.parseObject((String)filter, ItemSearchVo.class);
        List<ItemVo> itemEoList = this.pageItemOnSelf(itemSearchVo);
        ArrayList<ItemOnShelfRespDto> managementBlockRespDtos = new ArrayList<ItemOnShelfRespDto>();
        List skuIds = itemEoList.stream().filter(bean -> null != bean.getSkuId()).map(ItemVo::getSkuId).collect(Collectors.toList());
        List itemPriceEos = this.itemPriceDas.selectBySkuIds(skuIds);
        Map group = itemPriceEos.stream().collect(Collectors.groupingBy(StdItemPriceEo::getSkuId, Collectors.toList()));
        List collectDirId = itemEoList.stream().filter(bean -> null != bean.getDirId()).map(ItemVo::getDirId).collect(Collectors.toList());
        List dirEos = this.dirDas.selectByIds(collectDirId);
        Map groupDirEo = dirEos.stream().collect(Collectors.groupingBy(BaseEo::getId, Collectors.toList()));
        for (ItemVo itemVo : itemEoList) {
            ItemOnShelfRespDto newOne = new ItemOnShelfRespDto();
            BeanUtils.copyProperties((Object)itemVo, (Object)newOne);
            newOne.setPath(this.getMainPic(itemVo.getItemId()));
            newOne.setShopId(itemVo.getShopId());
            managementBlockRespDtos.add(newOne);
            List itemPriceEos1 = group.get(itemVo.getSkuId());
            List selectDirEo = groupDirEo.get(itemVo.getDirId());
            if (!CollectionUtils.isEmpty(itemPriceEos1)) {
                Map collect = itemPriceEos1.stream().collect(Collectors.groupingBy(StdItemPriceEo::getPriceType, Collectors.toList()));
                ShelfEo selectItem = new ShelfEo();
                selectItem.setOrderByDesc("updateTime");
                selectItem.setSkuId(itemVo.getSkuId());
                selectItem.setStatus(Integer.valueOf(1));
                selectItem.setDr(0);
                List shelfEos = this.shelfDas.selectList((BaseEo)selectItem);
                List price = collect.get("PRICE");
                newOne.setRetailPrice(CollectionUtils.isEmpty((Collection)shelfEos) ? null : ((ShelfEo)shelfEos.get(0)).getPrice());
                newOne.setSellPrice(CollectionUtils.isEmpty(price) ? null : ((ItemPriceEo)price.get(0)).getPrice());
            }
            if (CollectionUtils.isEmpty(selectDirEo)) continue;
            newOne.setDirName(((DirEo)selectDirEo.get(0)).getName());
        }
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)new PageInfo(itemEoList), (String[])new String[]{"list", "navigatepageNums"});
        result.setList(managementBlockRespDtos);
        return result;
    }

    private String getMainPic(Long itemId) {
        List itemMediasEoList = this.itemMediasDas.selectByItemId(itemId);
        if (CollectionUtils.isNotEmpty((Collection)itemMediasEoList)) {
            return ((ItemMediasEo)itemMediasEoList.get(0)).getPath1();
        }
        return null;
    }

    private List<ItemVo> pageItemOnSelf(ItemSearchVo searchVo) {
        PageHelper.startPage((int)(searchVo.getPageNum() == null ? 1 : searchVo.getPageNum()), (int)(searchVo.getPageSize() == null ? 10 : searchVo.getPageSize()));
        return this.itemDas.pageItemOnSelf(searchVo);
    }

    @Override
    public Long addItem(ItemChangeApplyDto changeApply) {
        this.validSkuCode(changeApply, changeApply.getTenantId());
        ItemEo itemEo = ItemEo.newInstance();
        Integer type = changeApply.getType();
        this.initItemEo(changeApply, itemEo);
        itemEo.setInstanceId(changeApply.getInstanceId());
        itemEo.setTenantId(changeApply.getTenantId());
        this.dealChangeExtension(changeApply, itemEo);
        this.itemDas.insert((BaseEo)itemEo);
        Long itemId = itemEo.getId();
        if (null != itemId) {
            this.addItemAssociateAttr(type, changeApply, itemId, changeApply.getInstanceId(), changeApply.getTenantId());
            this.addItemPropRelation(changeApply, itemId, changeApply.getInstanceId(), changeApply.getTenantId());
        }
        return itemId;
    }

    @Override
    public void audit(ItemAuditReqDto itemAuditReqDto) {
        this.iItemAuditService.saveAuditItem(itemAuditReqDto);
        ItemEo item = (ItemEo)this.itemDas.selectByPrimaryKey(itemAuditReqDto.getItemId());
        if (Objects.isNull(item)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), ItemExceptionCode.NON_EXIST_ITEM.getMsg());
        }
        ItemEo itemEo = ItemEo.newInstance();
        itemEo.setStatus(itemAuditReqDto.getStatus());
        itemEo.setId(itemAuditReqDto.getItemId());
        itemEo.setName(item.getName());
        itemEo.setDisplayName(item.getDisplayName());
        itemEo.setReturnType(item.getReturnType());
        itemEo.setInstanceId(item.getInstanceId());
        itemEo.setType(item.getType());
        this.itemDas.updateSelective((BaseEo)itemEo);
    }

    @Override
    public Long updateItem(ItemChangeApplyDto changeApply) {
        logger.info("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)changeApply));
        ItemEo itemEo = ItemEo.newInstance();
        ItemEo exist = (ItemEo)this.itemDas.selectByPrimaryKey(changeApply.getItemId());
        if (null == exist) {
            throw new BizException("\u627e\u4e0d\u5546\u54c1\u4fe1\u606f");
        }
        logger.info("ItemEo exist info:{}", (Object)JSON.toJSONString((Object)exist));
        Integer type = changeApply.getType();
        this.initItemEo(changeApply, itemEo);
        itemEo.setInstanceId(changeApply.getInstanceId());
        itemEo.setId(changeApply.getItemId());
        itemEo.setTenantId(changeApply.getTenantId());
        this.dealChangeExtension(changeApply, itemEo);
        itemEo.setVersion(Long.valueOf(exist.getVersion() + 1L));
        this.itemDas.updateSelective((BaseEo)itemEo);
        Long itemId = exist.getId();
        this.removeItemAssociateAttr(itemId, type);
        this.addItemAssociateAttr(type, changeApply, itemId, exist.getInstanceId(), exist.getTenantId());
        this.addItemPropRelation(changeApply, itemId, exist.getInstanceId(), exist.getTenantId());
        this.iItemShelfService.updateIndex(itemId);
        return itemId;
    }

    private void dealChangeExtension(ItemChangeApplyDto changeApply, ItemEo itemEo) {
        if (StringUtils.isNotBlank((CharSequence)changeApply.getExtension())) {
            if (StringUtils.isBlank((CharSequence)itemEo.getExtension())) {
                itemEo.setExtension(changeApply.getExtension());
            } else {
                try {
                    JSONObject itemMap = JSON.parseObject((String)itemEo.getExtension());
                    JSONObject versionMap = JSON.parseObject((String)changeApply.getExtension());
                    itemMap.putAll(versionMap);
                    itemEo.setExtension(JSON.toJSONString((Object)itemMap));
                }
                catch (Exception e) {
                    logger.error("\u65b0\u589e\u5546\u54c1\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public ItemEo queryById(Long id) {
        return (ItemEo)this.itemDas.selectByPrimaryKey(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatusBatch(List<Long> itemIds, Integer status) {
        this.itemDas.updateStatusByIds(itemIds, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItem(ItemEo itemEo) {
        List list = this.itemDas.select((BaseEo)itemEo);
        for (ItemEo item : list) {
            this.removeItem(item.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItem(Long id) {
        ItemEo eo = (ItemEo)this.itemDas.selectByPrimaryKey(id);
        if (null != eo) {
            if (eo.getStatus() == 1) {
                throw new ItemBusinessRuntimeException(id + "\u5bf9\u5e94\u7684\u5546\u54c1\u8bf7\u5148\u4e0b\u67b6");
            }
            if (ItemType.BUNDDLE.getIndex().equals(eo.getType())) {
                ItemBundleRelationEo bundleItemEo = ItemBundleRelationEo.newInstance();
                bundleItemEo.setItemId(id);
                this.itemBundleRelationDas.logicDeleteByExample((BaseEo)bundleItemEo);
            }
            ItemMediasEo itemMediasEo = ItemMediasEo.newInstance();
            itemMediasEo.setItemId(id);
            this.itemMediasDas.logicDeleteByExample((BaseEo)itemMediasEo);
            ItemPriceEo priceEo = ItemPriceEo.newInstance();
            priceEo.setItemId(id);
            this.itemPriceDas.logicDeleteByExample((BaseEo)priceEo);
            ItemAttributesEo itemAttributesEo = ItemAttributesEo.newInstance();
            itemAttributesEo.setItemId(id);
            this.itemAttributesDas.logicDeleteByExample((BaseEo)itemAttributesEo);
            ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
            itemSkuEo.setItemId(id);
            this.itemSkuDas.logicDeleteByExample((BaseEo)itemSkuEo);
            this.itemDas.logicDeleteByExample((BaseEo)eo);
            ItemTagRelationEo itemTagEo = new ItemTagRelationEo();
            itemTagEo.setItemId(id);
            this.itemTagRelationDas.logicDeleteByExample((BaseEo)itemTagEo);
            ItemPropRelationEo itemPropRelationEo = ItemPropRelationEo.newInstance();
            itemPropRelationEo.setItemId(id);
            this.itemPropRelationDas.logicDeleteByExample((BaseEo)itemPropRelationEo);
        }
    }

    @Override
    @Transactional
    public void updateItem(ItemEo itemEo) {
        this.itemDas.updateSelective((BaseEo)itemEo);
    }

    @Override
    public void publish(ItemPublishReqDto itemPublishReqDto) {
        if (Objects.isNull(itemPublishReqDto)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        if (Objects.isNull(itemPublishReqDto.getItemId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        ItemEo item = this.queryById(itemPublishReqDto.getItemId());
        if (item == null) {
            return;
        }
        ItemEo itemEo = new ItemEo();
        itemEo.setId(itemPublishReqDto.getItemId());
        if (item.getType().equals(ItemType.GENERAL.getIndex())) {
            itemEo.setStatus(ItemStatus.ITEM_AUDITING.getStatus());
        } else if (item.getType().equals(ItemType.PRODUCT.getIndex())) {
            itemEo.setStatus(ItemStatus.PRODUCT_PUBLISHED.getStatus());
        } else {
            itemEo.setStatus(ItemStatus.ITEM_AUDITING.getStatus());
        }
        this.itemDas.updateSelective((BaseEo)itemEo);
    }

    @Override
    public List<ItemEo> queryItems(ItemEo itemEo) {
        if (itemEo != null) {
            return this.itemDas.select((BaseEo)itemEo);
        }
        return new ArrayList<ItemEo>();
    }

    @Override
    public PageInfo<ItemRespDto> queryByPage(ItemEo itemEo, Integer pageNum, Integer pageSize) {
        PageInfo eoPageInfo = this.itemDas.selectPage((BaseEo)itemEo, pageNum, pageSize);
        ArrayList itemRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), (Collection)itemRespDtoList, ItemRespDto.class);
        PageInfo dtoPageInfo = new PageInfo((List)itemRespDtoList);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList itemIds = Lists.newArrayList();
        for (ItemRespDto item : itemRespDtoList) {
            itemIds.add(item.getId());
        }
        this.setItemSkuByItemIds(itemRespDtoList, itemIds);
        this.setItemMediasByItemIds(itemRespDtoList, itemIds);
        this.setDirsItemsByItemIds(itemRespDtoList, itemIds);
        this.setShelfTasksByItemId(itemRespDtoList, itemIds);
        this.setItemBrandAndDir(itemRespDtoList);
        return dtoPageInfo;
    }

    private void setItemBrandAndDir(List<ItemRespDto> itemRespDtos) {
        ArrayList<SqlFilter> sqlFilterList;
        if (CollectionUtils.isEmpty(itemRespDtos)) {
            return;
        }
        ArrayList<Long> brandIds = new ArrayList<Long>();
        ArrayList<Long> dirIds = new ArrayList<Long>();
        for (ItemRespDto itemRespDto : itemRespDtos) {
            if (null != itemRespDto.getBrandId()) {
                brandIds.add(itemRespDto.getBrandId());
            }
            if (null == itemRespDto.getDirId()) continue;
            dirIds.add(itemRespDto.getDirId());
        }
        Object brandMap = new HashedMap();
        Object dirMap = new HashedMap();
        if (CollectionUtils.isNotEmpty(brandIds)) {
            BrandEo brandEo = BrandEo.newInstance();
            sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", brandIds));
            brandEo.setSqlFilters(sqlFilterList);
            List brands = this.brandDas.select((BaseEo)brandEo, Integer.valueOf(1), Integer.valueOf(brandIds.size()));
            if (CollectionUtils.isNotEmpty((Collection)brands)) {
                brandMap = brands.stream().collect(Collectors.toMap(brand -> brand.getId(), brand -> brand));
            }
        }
        if (CollectionUtils.isNotEmpty(dirIds)) {
            DirEo dirEo = DirEo.newInstance();
            sqlFilterList = new ArrayList();
            sqlFilterList.add(SqlFilter.in((String)"id", dirIds));
            dirEo.setSqlFilters(sqlFilterList);
            List dirs = this.dirDas.select((BaseEo)dirEo, Integer.valueOf(1), Integer.valueOf(dirIds.size()));
            if (CollectionUtils.isNotEmpty((Collection)dirs)) {
                dirMap = dirs.stream().collect(Collectors.toMap(dir -> dir.getId(), dir -> dir));
            }
        }
        for (ItemRespDto itemRespDto : itemRespDtos) {
            DirEo dir2;
            BrandEo brand2;
            if (null != itemRespDto.getBrandId() && null != (brand2 = (BrandEo)brandMap.get(itemRespDto.getBrandId()))) {
                itemRespDto.setBrand(brand2.getName());
            }
            if (null == itemRespDto.getDirId() || null == (dir2 = (DirEo)dirMap.get(itemRespDto.getDirId()))) continue;
            itemRespDto.setDirName(dir2.getName());
        }
    }

    public void setDirsItemsByItemIds(List<ItemRespDto> itemRespDtoList, List<Long> itemIds) {
        List dirsItemsEoList = this.dirItemRelationDas.selectByItemIds(itemIds);
        ArrayList dirsItemsRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)dirsItemsEoList, (Collection)dirsItemsRespDtoList, DirsItemsRespDto.class);
        HashMap dirsItemsMap = Maps.newHashMap();
        for (DirsItemsRespDto dirsItemsRespDto : dirsItemsRespDtoList) {
            List mapDirsItemsList = (List)dirsItemsMap.get(dirsItemsRespDto.getItemId());
            mapDirsItemsList = CollectionUtils.isNotEmpty((Collection)mapDirsItemsList) ? mapDirsItemsList : Lists.newArrayList();
            mapDirsItemsList.add(dirsItemsRespDto);
            dirsItemsMap.put(dirsItemsRespDto.getItemId(), mapDirsItemsList);
        }
        for (ItemRespDto itemRespDto : itemRespDtoList) {
            itemRespDto.setDirsItemsList((List)dirsItemsMap.get(itemRespDto.getId()));
        }
    }

    public void setShelfTasksByItemId(List<ItemRespDto> itemRespDtoList, List<Long> itemIds) {
        List shelfTaskEoList = this.shelfTaskDas.selectByItemIds(itemIds);
        ArrayList shelfTaskDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)shelfTaskEoList, (Collection)shelfTaskDtoList, ShelfTaskRespDto.class);
        HashMap shelfTasksMap = Maps.newHashMap();
        for (ShelfTaskRespDto shelfTaskDto : shelfTaskDtoList) {
            List map = (List)shelfTasksMap.get(shelfTaskDto.getItemId());
            map = CollectionUtils.isNotEmpty((Collection)map) ? map : Lists.newArrayList();
            map.add(shelfTaskDto);
            shelfTasksMap.put(shelfTaskDto.getItemId(), map);
        }
        for (ItemRespDto dto : itemRespDtoList) {
            dto.setShelfTaskRespDtoList((List)shelfTasksMap.get(dto.getId()));
        }
    }

    @Override
    public ItemDetailRespDto queryItemDetail(Long id, String field, Long dirId) {
        ItemDetailRespDto itemDetailDto = new ItemDetailRespDto();
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(id);
        if (itemEo == null) {
            return itemDetailDto;
        }
        ItemPropRelationReqDto itemPropRelationReqDto = new ItemPropRelationReqDto();
        itemPropRelationReqDto.setItemId(id);
        List<ItemPropRelationRespDto> itemPropRelationRespDtos = this.propService.queryItemPropRelation(itemPropRelationReqDto);
        itemDetailDto.setItemPropRelationRespDtos(itemPropRelationRespDtos);
        ItemRespDto itemDto = new ItemRespDto();
        DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)itemDto);
        if (StringUtils.isBlank((CharSequence)field)) {
            itemDetailDto.setItem(itemDto);
            return itemDetailDto;
        }
        if (field.contains("sku")) {
            this.setItemSkuByItemIds(Lists.newArrayList((Object[])new ItemRespDto[]{itemDto}), Lists.newArrayList((Object[])new Long[]{itemEo.getId()}));
            itemDetailDto.setItemSkuList(itemDto.getItemSkuList());
            itemDto.setItemSkuList(null);
        }
        if (field.contains("attributes")) {
            List itemAttributesEoList = this.itemAttributesDas.selectByItemIds(Arrays.asList(itemEo.getId()));
            ArrayList itemAttributesDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)itemAttributesEoList, (Collection)itemAttributesDtoList, ItemAttributesRespDto.class);
            itemDetailDto.setItemAttributesList((List)itemAttributesDtoList);
        }
        if (field.contains("medias")) {
            List itemMediasEoList = this.itemMediasDas.selectByItemId(itemEo.getId());
            ArrayList itemMediasDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)itemMediasEoList, (Collection)itemMediasDtoList, ItemMediasRespDto.class);
            itemDetailDto.setItemMediasList((List)itemMediasDtoList);
        }
        if (field.contains("task")) {
            ShelfTaskEo shelfTaskEo = ShelfTaskEo.newInstance();
            shelfTaskEo.setItemId(id);
            shelfTaskEo.setOrderBy("id");
            List shelfTaskEoList = this.shelfTaskDas.select((BaseEo)shelfTaskEo);
            ArrayList shelfTaskDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)shelfTaskEoList, (Collection)shelfTaskDtoList, ShelfTaskRespDto.class);
            itemDetailDto.setShelfTaskRespDtoList((List)shelfTaskDtoList);
        }
        if (dirId != null) {
            DirItemRelationEo eo = DirItemRelationEo.newInstance();
            eo.setOrderBy("id");
            eo.setDirId(dirId);
            List dirsItemsEo = this.dirItemRelationDas.select((BaseEo)eo);
            LinkedList dirsItemsRespDto = new LinkedList();
            DtoHelper.eoList2DtoList((Collection)dirsItemsEo, dirsItemsRespDto, DirsItemsRespDto.class);
            itemDetailDto.setDirsItemsList(dirsItemsRespDto);
        } else {
            List dirsItemsEoList = this.dirItemRelationDas.selectByItemIds((List)Lists.newArrayList((Object[])new Long[]{itemDto.getId()}));
            DtoHelper.eoList2DtoList((Collection)dirsItemsEoList, (Collection)itemDetailDto.getDirsItemsList(), DirsItemsRespDto.class);
        }
        itemDetailDto.setItem(itemDto);
        if (StringUtils.isNotBlank((CharSequence)itemEo.getSaleChannel())) {
            itemDetailDto.setSaleChannels(Arrays.asList(itemEo.getSaleChannel().split("-")));
        }
        return itemDetailDto;
    }

    @Override
    public ItemDoc queryItemDoc(Long id) {
        ItemDoc itemDoc = new ItemDoc();
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(id);
        CubeBeanUtils.copyProperties((Object)itemDoc, (Object)itemEo, (String[])new String[0]);
        ItemAttributesEo attributesEo = ItemAttributesEo.newInstance();
        attributesEo.setItemId(id);
        List attributesEos = this.itemAttributesDas.select((BaseEo)attributesEo);
        itemDoc.setAttributesEos(attributesEos);
        List<ItemSkuDoc> itemSkuDto = this.itemSkuService.queryItemSku(id);
        itemDoc.setItemSkuDtos(itemSkuDto);
        return itemDoc;
    }

    @Override
    public ItemSearchRespDto queryByKeyword(ItemSearchQueryReqDto itemSearchQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        ItemSearchRespDto itemSearchDto = new ItemSearchRespDto();
        if (ItemSearchIndexConstant.USE_ES) {
            logger.info("\u3010\u67e5\u8be2\u5546\u54c1ES\u7684\u8bf7\u6c42\u53c2\u6570\u3011: {}", (Object)JSON.toJSONString((Object)itemSearchQueryReqDto));
            itemSearchDto = this.itemSearchService.query(itemSearchQueryReqDto, pageNum, pageSize);
            if (logger.isDebugEnabled()) {
                logger.debug("\u3010\u67e5\u8be2\u5546\u54c1ES\u7684\u54cd\u5e94\u7ed3\u679c\u3011: {}", (Object)JSON.toJSONString((Object)itemSearchDto));
            }
            if (itemSearchQueryReqDto.getSearch().booleanValue()) {
                this.fillAttributeAndDirItem(itemSearchDto);
            }
            return itemSearchDto;
        }
        ArrayList propList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getProp())) {
            String[] props = itemSearchQueryReqDto.getProp().split(";");
            for (int i = 0; i < props.length; ++i) {
                String[] searchData = props[i].split(":");
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("name", searchData[0]);
                map.put("value", searchData[1]);
                propList.add(map);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)itemSearchQueryReqDto.getDirIds()) && itemSearchQueryReqDto.getSellerId() == null && itemSearchQueryReqDto.getShopId() == null) {
            pageInfo = this.itemDas.selectByKeyword(itemSearchQueryReqDto.getKeyword(), itemSearchQueryReqDto.getType(), (Long)itemSearchQueryReqDto.getDirIds().get(0), itemSearchQueryReqDto.getBrandId(), propList, itemSearchQueryReqDto.getSellerId(), itemSearchQueryReqDto.getShopId(), null, null, itemSearchQueryReqDto.getInstanceId(), itemSearchQueryReqDto.getTenantId());
            if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                return itemSearchDto;
            }
            ArrayList<Long> itemIdList = new ArrayList<Long>();
            for (ItemEo itemEo : pageInfo.getList()) {
                itemIdList.add(itemEo.getId());
            }
            ItemEo itemEo = new ItemEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(itemIdList, (String)",")));
            itemEo.setSqlFilters(sqlFilterList);
            itemEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
            itemEo.setInstanceId(itemSearchQueryReqDto.getInstanceId());
            itemEo.setTenantId(itemSearchQueryReqDto.getTenantId());
            pageInfo = this.itemDas.selectPage((BaseEo)itemEo, pageNum, pageSize);
        } else {
            pageInfo = this.itemDas.selectByKeyword(itemSearchQueryReqDto.getKeyword(), itemSearchQueryReqDto.getType(), (Long)itemSearchQueryReqDto.getDirIds().get(0), itemSearchQueryReqDto.getBrandId(), propList, itemSearchQueryReqDto.getSellerId(), itemSearchQueryReqDto.getShopId(), pageNum, pageSize, itemSearchQueryReqDto.getInstanceId(), itemSearchQueryReqDto.getTenantId());
        }
        List itemEoList = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)itemEoList)) {
            return itemSearchDto;
        }
        List<ItemRespDto> itemRespDtoList = this.queryItemRespDto(itemEoList, null);
        PageInfo rePageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)rePageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        rePageInfo.setList(itemRespDtoList);
        itemSearchDto.setPageInfo(rePageInfo);
        if (itemSearchQueryReqDto.getSearch().booleanValue()) {
            this.fillAttributeAndDirItem(itemSearchDto);
        }
        return itemSearchDto;
    }

    @Override
    public List<ItemRespDto> queryItemRespDto(List<ItemEo> itemEoList, Long sellerId) {
        ArrayList<ItemRespDto> itemRespDtoList = new ArrayList<ItemRespDto>();
        DtoHelper.eoList2DtoList(itemEoList, itemRespDtoList, ItemRespDto.class);
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        for (ItemEo itemEo : itemEoList) {
            itemIdList.add(itemEo.getId());
        }
        this.setItemSkuByItemIds(itemRespDtoList, itemIdList);
        this.setItemMediasByItemIds(itemRespDtoList, itemIdList);
        DirItemRelationEo dirItemRelationEo = new DirItemRelationEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        dirItemRelationEo.setSellerId(sellerId);
        sqlFilterList.add(SqlFilter.in((String)"item_id", (Object)StringUtils.join(itemIdList, (String)",")));
        dirItemRelationEo.setSqlFilters(sqlFilterList);
        List dirItemRelationEoList = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
        ArrayList dirsItemsList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)dirItemRelationEoList, dirsItemsList, DirsItemsRespDto.class);
        Map<Long, List<DirsItemsRespDto>> group = dirsItemsList.stream().collect(Collectors.groupingBy(DirsItemsRespDto::getItemId));
        itemRespDtoList.forEach(itemRespDto -> {
            if (group.containsKey(itemRespDto.getId())) {
                itemRespDto.setDirsItemsList((List)group.get(itemRespDto.getId()));
            }
        });
        return itemRespDtoList;
    }

    @Override
    public void addOrModifyItemSalesCount(ItemStatReqDto itemStatReqDto) {
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemStatReqDto.getItemId());
        if (itemEo == null) {
            throw new BizException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        StatEo statEo = new StatEo();
        statEo.setItemId(itemStatReqDto.getItemId());
        statEo.setInstanceId(itemStatReqDto.getInstanceId());
        statEo.setTenantId(itemStatReqDto.getTenantId());
        StatEo selectEo = (StatEo)this.statDas.selectOne((BaseEo)statEo);
        if (selectEo == null) {
            statEo.setSalesCount(itemStatReqDto.getSalesCount());
            this.statDas.insert((BaseEo)statEo);
        } else {
            statEo = new StatEo();
            statEo.setId(selectEo.getId());
            statEo.setSalesCount(itemStatReqDto.getSalesCount());
            this.statDas.updateSelective((BaseEo)statEo);
        }
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(itemStatReqDto.getItemId());
        this.refresh(shelfReqDto);
    }

    private void refresh(ShelfReqDto shelfReqDto) {
        if (null == shelfReqDto.getItemId() && null == shelfReqDto.getShopId()) {
            logger.info("\u5546\u54c1id\u548c\u5e97\u94faid\u4e0d\u540c\u65f6\u4e3a\u7a7a,\u4e0d\u66f4\u5546\u54c1es\u6570\u636e");
        }
        int itemTotalNum = 0;
        int pageNum = 1;
        int pageSize = 1000;
        shelfReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        PageInfo<ItemShelfRespDto> pageInfo = this.queryItemShelfByPage(shelfReqDto, pageNum, pageSize);
        while (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            Map<String, List<ItemShelfRespDto>> group = pageInfo.getList().stream().collect(Collectors.groupingBy(shelfRespDto -> shelfRespDto.getShopId().toString() + shelfRespDto.getItemId() + shelfRespDto.getBusType()));
            for (List<ItemShelfRespDto> shelfRespDtos : group.values()) {
                ItemShelfRespDto shelfRespDto2 = shelfRespDtos.get(0);
                this.itemSearchService.index(shelfRespDto2.getSellerId(), shelfRespDto2.getItemId(), shelfRespDto2.getItemType(), shelfRespDto2.getBusType(), "ON_SHELF");
                ++itemTotalNum;
            }
            pageInfo = this.queryItemShelfByPage(shelfReqDto, ++pageNum, pageSize);
        }
        logger.info("\u66f4\u65b0\u5546\u54c1ES\u6570\u636e\uff0c\u53c2\u6570shelfReqDto={},\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)shelfReqDto), (Object)itemTotalNum);
    }

    public PageInfo<ItemShelfRespDto> queryItemShelfByPage(ShelfReqDto shelfReqDto, Integer pageNum, Integer pageSize) {
        ShelfEo shelfEo = ShelfEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfReqDto, (BaseEo)shelfEo);
        PageInfo pageInfo = this.shelfDas.selectPage((BaseEo)shelfEo, pageNum, pageSize);
        ArrayList shelfRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)shelfRespDtoList, ItemShelfRespDto.class);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList((List)shelfRespDtoList);
        return dtoPageInfo;
    }

    @Override
    public ItemStatRespDto queryItemSalesCountByItemId(Long itemId, String filter) {
        RequestDto baseReqDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        StatEo statEo = new StatEo();
        statEo.setItemId(itemId);
        if (baseReqDto != null) {
            statEo.setInstanceId(baseReqDto.getInstanceId());
            statEo.setTenantId(baseReqDto.getTenantId());
        }
        statEo = (StatEo)this.statDas.selectOne((BaseEo)statEo);
        ItemStatRespDto itemStatRespDto = new ItemStatRespDto();
        if (statEo == null) {
            return itemStatRespDto;
        }
        DtoHelper.eo2Dto((BaseEo)statEo, (BaseVo)itemStatRespDto);
        return itemStatRespDto;
    }

    private void fillAttributeAndDirItem(ItemSearchRespDto itemSearchRespDto) {
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        if (null == itemSearchRespDto.getPageInfo()) {
            return;
        }
        List itemRespDtoList = itemSearchRespDto.getPageInfo().getList();
        for (ItemRespDto itemRespDto : itemRespDtoList) {
            itemIdList.add(itemRespDto.getId());
        }
        if (CollectionUtils.isEmpty(itemIdList)) {
            return;
        }
        List itemAttributesEoList = this.itemAttributesDas.selectByItemIds(itemIdList);
        ArrayList<Long> dirIdList = new ArrayList<Long>();
        List dirItemRelationEoList = this.dirItemRelationDas.selectByItemIds(itemIdList);
        for (DirItemRelationEo dirItemRelationEo : dirItemRelationEoList) {
            if (dirItemRelationEo.getDirId() == null || dirIdList.contains(dirItemRelationEo.getDirId())) continue;
            dirIdList.add(dirItemRelationEo.getDirId());
        }
        List dirEoList = this.dirDas.selectByIds(dirIdList);
        ArrayList itemAttributesRespDtoList = new ArrayList();
        ArrayList directoryItemRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)itemAttributesEoList, itemAttributesRespDtoList, ItemAttributesRespDto.class);
        DtoHelper.eoList2DtoList((Collection)dirEoList, directoryItemRespDtoList, DirectoryItemRespDto.class);
        itemSearchRespDto.setAttributesList(itemAttributesRespDtoList);
        itemSearchRespDto.setDirectoryItemList(directoryItemRespDtoList);
    }

    public void setItemMediasByItemIds(List<ItemRespDto> itemDtoList, List<Long> itemIds) {
        List itemMediasEoList = this.itemMediasDas.selectByItemIds(itemIds);
        ArrayList mediasDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemMediasEoList, (Collection)mediasDtoList, ItemMediasRespDto.class);
        Map<Long, List<ItemMediasRespDto>> itemMediasMap = this.getItemMediasMapByItemIds(mediasDtoList);
        for (ItemRespDto itemDto : itemDtoList) {
            itemDto.setItemMediasList(itemMediasMap.get(itemDto.getId()));
        }
    }

    private Map<Long, List<ItemMediasRespDto>> getItemMediasMapByItemIds(List<ItemMediasRespDto> mediasDtoList) {
        HashMap itemMediasMap = Maps.newHashMap();
        for (ItemMediasRespDto itemMediasDto : mediasDtoList) {
            List mapItemMediasList = (List)itemMediasMap.get(itemMediasDto.getItemId());
            mapItemMediasList = CollectionUtils.isEmpty((Collection)mapItemMediasList) ? Lists.newArrayList() : mapItemMediasList;
            mapItemMediasList.add(itemMediasDto);
            itemMediasMap.put(itemMediasDto.getItemId(), mapItemMediasList);
        }
        return itemMediasMap;
    }

    public void setItemSkuByItemIds(List<ItemRespDto> itemDtoList, List<Long> itemIds) {
        List itemBundleRelationEoList;
        List<ItemSkuEo> itemSkuEoList = this.itemSkuService.queryByItemIds(itemIds);
        ArrayList skuDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList(itemSkuEoList, (Collection)skuDtoList, ItemSkuRespDto.class);
        ArrayList skuIds = Lists.newArrayList();
        for (ItemSkuEo itemSkuEo : itemSkuEoList) {
            skuIds.add(itemSkuEo.getId());
        }
        Map<Long, List<ItemPriceRespDto>> itemSkuPriceMap = this.getItemSkuPriceMapBySkuIds(skuIds);
        for (Object itemSkuDto : skuDtoList) {
            itemSkuDto.setItemPriceList(itemSkuPriceMap.get(itemSkuDto.getId()));
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (ItemSkuRespDto itemSkuDto : skuDtoList) {
            arrayList.add(itemSkuDto.getId());
        }
        ItemBundleRelationEo itemBundleRelationEo = new ItemBundleRelationEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (CollectionUtils.isNotEmpty(arrayList)) {
            sqlFilterList.add(SqlFilter.in((String)"sku_id", (Object)StringUtils.join(arrayList, (String)",")));
        }
        itemBundleRelationEo.setSqlFilters(sqlFilterList);
        itemBundleRelationEo.setOrderBy("id");
        if (CollectionUtils.isNotEmpty((Collection)itemBundleRelationEo.getSqlFilters()) && CollectionUtils.isNotEmpty((Collection)(itemBundleRelationEoList = this.itemBundleRelationDas.select((BaseEo)itemBundleRelationEo)))) {
            for (ItemSkuRespDto itemSkuRespDto : skuDtoList) {
                if (itemSkuRespDto.getBundleItemList() == null) {
                    itemSkuRespDto.setBundleItemList(new ArrayList());
                }
                for (ItemBundleRelationEo relationEo : itemBundleRelationEoList) {
                    if (!itemSkuRespDto.getId().equals(relationEo.getSkuId())) continue;
                    BundleItemRespDto bundleItemRespDto = new BundleItemRespDto();
                    DtoHelper.eo2Dto((BaseEo)relationEo, (BaseVo)bundleItemRespDto);
                    itemSkuRespDto.getBundleItemList().add(bundleItemRespDto);
                }
            }
        }
        Map<Long, List<ItemSkuRespDto>> itemSkuDtoMap = this.getItemSkuDtoMap(skuDtoList);
        for (ItemRespDto itemDto : itemDtoList) {
            itemDto.setItemSkuList(itemSkuDtoMap.get(itemDto.getId()));
        }
    }

    public Map<Long, List<ItemSkuRespDto>> getItemSkuDtoMap(List<ItemSkuRespDto> skuDtoList) {
        HashMap itemSkuDtoMap = Maps.newHashMap();
        for (ItemSkuRespDto itemSkuDto : skuDtoList) {
            List mapSkuDtoList = (List)itemSkuDtoMap.get(itemSkuDto.getItemId());
            mapSkuDtoList = CollectionUtils.isEmpty((Collection)mapSkuDtoList) ? Lists.newArrayList() : mapSkuDtoList;
            mapSkuDtoList.add(itemSkuDto);
            itemSkuDtoMap.put(itemSkuDto.getItemId(), mapSkuDtoList);
        }
        return itemSkuDtoMap;
    }

    public Map<Long, List<ItemPriceRespDto>> getItemSkuPriceMapBySkuIds(List<Long> skuIds) {
        HashMap itemPriceMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skuIds)) {
            List itemPriceEoList = this.itemPriceDas.selectBySkuIds(skuIds);
            ArrayList itemPriceRespDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)itemPriceEoList, (Collection)itemPriceRespDtoList, ItemPriceRespDto.class);
            for (ItemPriceRespDto priceRespDto : itemPriceRespDtoList) {
                List priceList = (List)itemPriceMap.get(priceRespDto.getSkuId());
                priceList = CollectionUtils.isEmpty((Collection)priceList) ? Lists.newArrayList() : priceList;
                priceList.add(priceRespDto);
                itemPriceMap.put(priceRespDto.getSkuId(), priceList);
            }
        }
        return itemPriceMap;
    }

    @Override
    public List<ItemEo> queryItemByIds(List<Long> ids) {
        return this.itemDas.selectByIds(ids);
    }

    @Override
    public ItemSkuListRespDto queryItemBySkuId(List<Long> skuIds) {
        ItemSkuListRespDto dto = new ItemSkuListRespDto();
        List<ItemSkuEo> itemSkuEoList = this.getItemSkuRepDtoList(skuIds, dto);
        this.getItemRespDtoList(dto, itemSkuEoList);
        return dto;
    }

    @Override
    public List<ItemRespDto> queryItemStatus(List<Long> itemIdList) {
        List itemEos = this.itemDas.selectByIds(itemIdList);
        ArrayList<ItemEo> itemsInvalidEos = new ArrayList<ItemEo>();
        for (ItemEo eo : itemEos) {
            Integer intStatus = eo.getStatus();
            if (intStatus != 2) continue;
            itemsInvalidEos.add(eo);
        }
        ArrayList<ItemRespDto> itemRespDtoList = new ArrayList<ItemRespDto>();
        DtoHelper.eoList2DtoList(itemsInvalidEos, itemRespDtoList, ItemRespDto.class);
        return itemRespDtoList;
    }

    @Override
    public List<DirItemRelativeQueryRespDto> queryItemDirRelative(DirItemRelativeReqDto dirItemReqDto) {
        List list;
        DirItemRelationEo dirItemRelationEo = DirItemRelationEo.newInstance();
        BeanUtils.copyProperties((Object)dirItemReqDto, (Object)dirItemRelationEo);
        if (CollectionUtils.isNotEmpty((Collection)dirItemReqDto.getDirIds())) {
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"dirId", (Object)dirItemReqDto.getDirIds()));
            dirItemRelationEo.setSqlFilters((List)sqlFilters);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo)))) {
            return list.stream().map(dirItemRelation -> {
                DirItemRelativeQueryRespDto itemDirQueryRespDto = new DirItemRelativeQueryRespDto();
                BeanUtils.copyProperties((Object)dirItemRelation, (Object)itemDirQueryRespDto);
                return itemDirQueryRespDto;
            }).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<ItemDirQueryRespDto> queryItemDir(ItemDirQueryReqDto itemDirQueryReqDto) {
        ArrayList<Long> dirIdList;
        if (itemDirQueryReqDto == null || itemDirQueryReqDto.getInstanceId() == null || itemDirQueryReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<ItemDirQueryRespDto> list = new ArrayList<ItemDirQueryRespDto>();
        if (CollectionUtils.isEmpty((Collection)itemDirQueryReqDto.getItemIdList())) {
            return list;
        }
        for (Long itemId : itemDirQueryReqDto.getItemIdList()) {
            ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
            if (itemEo == null || !itemDirQueryReqDto.getInstanceId().equals(itemEo.getInstanceId()) || !itemDirQueryReqDto.getTenantId().equals(itemEo.getTenantId())) continue;
            ItemDirQueryRespDto itemDirQueryRespDto = new ItemDirQueryRespDto();
            itemDirQueryRespDto.setItemId(itemId);
            dirIdList = this.queryParentDataList(itemEo.getDirId());
            itemDirQueryRespDto.setDirList(dirIdList);
            list.add(itemDirQueryRespDto);
        }
        for (ItemDirQueryRespDto itemDirQueryRespDto : list) {
            DirItemRelationEo dirItemRelationEo = new DirItemRelationEo();
            dirItemRelationEo.setItemId(itemDirQueryRespDto.getItemId());
            dirItemRelationEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
            dirItemRelationEo.setInstanceId(itemDirQueryReqDto.getInstanceId());
            dirItemRelationEo.setTenantId(itemDirQueryReqDto.getTenantId());
            List dirItemRelationEoList = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
            if (CollectionUtils.isEmpty((Collection)dirItemRelationEoList)) continue;
            dirIdList = itemDirQueryRespDto.getDirList();
            if (dirIdList == null) {
                dirIdList = new ArrayList<Long>();
            }
            for (DirItemRelationEo relationEo : dirItemRelationEoList) {
                dirIdList.addAll(this.queryParentDataList(relationEo.getDirId()));
            }
            LinkedHashSet repeat = new LinkedHashSet(dirIdList);
            dirIdList.clear();
            dirIdList.addAll(repeat);
            itemDirQueryRespDto.setDirList(dirIdList);
        }
        return list;
    }

    @Override
    public ItemSearchRespDto queryItemByDirIdDepth(ItemSearchQueryReqDto itemSearchReqDto, Integer pageNum, Integer pageSize) {
        if (CollectionUtils.isNotEmpty((Collection)itemSearchReqDto.getDirIds())) {
            List<Long> dirIdList = this.dirService.getLinkAndChildDirIdList(itemSearchReqDto.getDirIds(), itemSearchReqDto.getInstanceId(), itemSearchReqDto.getTenantId());
            if (CollectionUtils.isEmpty(dirIdList)) {
                return null;
            }
            itemSearchReqDto.setDirIds(dirIdList);
        }
        return this.queryByKeyword(itemSearchReqDto, pageNum, pageSize);
    }

    @Override
    public PageInfo<ShelfTaskQueryRespDto> queryShelfTask(ShelfTaskQueryReqDto shelfTaskQueryReqDto, Integer pageNum, Integer pageSize) {
        List<SqlFilter> sqlFilterList;
        if (shelfTaskQueryReqDto == null || shelfTaskQueryReqDto.getInstanceId() == null || shelfTaskQueryReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ShelfTaskEo shelfTaskEo = new ShelfTaskEo();
        DtoHelper.dto2Eo((BaseVo)shelfTaskQueryReqDto, (BaseEo)shelfTaskEo);
        if (StringUtils.isNotBlank((CharSequence)shelfTaskQueryReqDto.getStartTime())) {
            sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.ge((String)"shelf_time", (Object)shelfTaskQueryReqDto.getStartTime()));
            shelfTaskEo.setSqlFilters(sqlFilterList);
        }
        if (StringUtils.isNotBlank((CharSequence)shelfTaskQueryReqDto.getEndTime())) {
            sqlFilterList = shelfTaskEo.getSqlFilters();
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList();
            }
            sqlFilterList.add(SqlFilter.le((String)"shelf_time", (Object)shelfTaskQueryReqDto.getEndTime()));
            shelfTaskEo.setSqlFilters(sqlFilterList);
        }
        PageInfo itemTimingRespDtoPageInfo = new PageInfo();
        PageInfo shelfTaskEoPageInfo = this.shelfTaskDas.selectPage((BaseEo)shelfTaskEo, pageNum, pageSize);
        List shelfTaskEoList = shelfTaskEoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)shelfTaskEoList)) {
            itemTimingRespDtoPageInfo.setPageNum(pageNum.intValue());
            itemTimingRespDtoPageInfo.setPageSize(pageSize.intValue());
            return itemTimingRespDtoPageInfo;
        }
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        ArrayList<ShelfTaskQueryRespDto> itemTimingRespDtoList = new ArrayList<ShelfTaskQueryRespDto>();
        for (ShelfTaskEo taskEo : shelfTaskEoList) {
            itemIdList.add(taskEo.getItemId());
            ShelfTaskQueryRespDto itemTimingRespDto = new ShelfTaskQueryRespDto();
            DtoHelper.eo2Dto((BaseEo)taskEo, (BaseVo)itemTimingRespDto);
            itemTimingRespDtoList.add(itemTimingRespDto);
        }
        ItemEo itemEo = new ItemEo();
        ArrayList<SqlFilter> sqlFilterList2 = new ArrayList<SqlFilter>();
        sqlFilterList2.add(SqlFilter.in((String)"id", (Object)StringUtils.join(itemIdList, (String)",")));
        itemEo.setSqlFilters(sqlFilterList2);
        List itemEoList = this.itemDas.select((BaseEo)itemEo);
        block1: for (ItemEo eo : itemEoList) {
            for (ShelfTaskQueryRespDto dto : itemTimingRespDtoList) {
                if (!eo.getId().equals(dto.getItemId())) continue;
                dto.setItemName(eo.getName());
                continue block1;
            }
        }
        CubeBeanUtils.copyProperties((Object)itemTimingRespDtoPageInfo, (Object)shelfTaskEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        itemTimingRespDtoPageInfo.setList(itemTimingRespDtoList);
        return itemTimingRespDtoPageInfo;
    }

    @Override
    public ItemAllowOrderQueryRespDto checkItemAllowOrder(List<ItemAllowOrderQueryReqDto> itemAllowOrderReqDtoList) {
        if (CollectionUtils.isEmpty(itemAllowOrderReqDtoList)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        itemAllowOrderReqDtoList.stream().forEach(dto -> {
            if (dto.getInstanceId() == null || dto.getTenantId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
        });
        ArrayList<ItemAllowOrderDetailQueryRespDto> itemAllowOrderDetailRespDtoList = new ArrayList<ItemAllowOrderDetailQueryRespDto>();
        for (ItemAllowOrderQueryReqDto itemAllowOrderReqDto : itemAllowOrderReqDtoList) {
            itemAllowOrderDetailRespDtoList.addAll(this.checkItemAllowOrder(itemAllowOrderReqDto));
        }
        ItemAllowOrderQueryRespDto itemAllowOrderRespDto = new ItemAllowOrderQueryRespDto();
        itemAllowOrderRespDto.setAllAllowOrder(Boolean.valueOf(true));
        for (ItemAllowOrderDetailQueryRespDto itemAllowOrderDetailRespDto : itemAllowOrderDetailRespDtoList) {
            if (itemAllowOrderDetailRespDto.getAllowOrder().booleanValue()) continue;
            itemAllowOrderRespDto.setAllAllowOrder(Boolean.valueOf(false));
            break;
        }
        return itemAllowOrderRespDto;
    }

    private List<ItemAllowOrderDetailQueryRespDto> checkItemAllowOrder(ItemAllowOrderQueryReqDto itemAllowOrderReqDto) {
        ArrayList<ItemAllowOrderDetailQueryRespDto> itemAllowOrderDetailRespDtoList = new ArrayList<ItemAllowOrderDetailQueryRespDto>();
        DirItemRelationEo dirItemRelationEo = new DirItemRelationEo();
        DtoHelper.dto2Eo((BaseVo)itemAllowOrderReqDto, (BaseEo)dirItemRelationEo);
        List dirItemRelationEoList = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
        if (CollectionUtils.isNotEmpty((Collection)dirItemRelationEoList)) {
            Date now = new Date();
            for (DirItemRelationEo relationEo : dirItemRelationEoList) {
                List allowOrderTimeDtoList;
                ItemAllowOrderDetailQueryRespDto itemAllowOrderDetailRespDto = new ItemAllowOrderDetailQueryRespDto();
                DtoHelper.eo2Dto((BaseEo)relationEo, (BaseVo)itemAllowOrderDetailRespDto);
                itemAllowOrderDetailRespDto.setAllowOrder(Boolean.valueOf(true));
                if (StringUtils.isNotBlank((CharSequence)relationEo.getAllowOrderTime()) && CollectionUtils.isNotEmpty((Collection)(allowOrderTimeDtoList = JSON.parseArray((String)relationEo.getAllowOrderTime(), AllowOrderTimeRespDto.class)))) {
                    itemAllowOrderDetailRespDto.setAllowOrderTimeRespDtoList(allowOrderTimeDtoList);
                    Boolean allowOrder = false;
                    for (AllowOrderTimeRespDto allowOrderTimeDto : allowOrderTimeDtoList) {
                        if (!now.after(allowOrderTimeDto.getStartTime()) || !now.before(allowOrderTimeDto.getEndTime())) continue;
                        allowOrder = true;
                        break;
                    }
                    itemAllowOrderDetailRespDto.setAllowOrder(allowOrder);
                }
                itemAllowOrderDetailRespDtoList.add(itemAllowOrderDetailRespDto);
            }
        }
        return itemAllowOrderDetailRespDtoList;
    }

    private List<Long> queryParentDataList(Long dirId) {
        ArrayList<Long> dirIdList;
        block2: {
            dirIdList = new ArrayList<Long>();
            if (dirId == null) {
                return dirIdList;
            }
            DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(dirId);
            if (dirEo == null) break block2;
            do {
                dirIdList.add(dirEo.getId());
            } while (!dirEo.getParentId().equals(0L) && (dirEo = (DirEo)this.dirDas.selectByPrimaryKey(dirEo.getParentId())) != null);
        }
        return dirIdList;
    }

    private List<ItemSkuEo> getItemSkuRepDtoList(List<Long> skuIds, ItemSkuListRespDto dto) {
        ArrayList skuRepDtos = Lists.newArrayList();
        List<ItemSkuEo> itemSkuEoList = this.itemSkuService.queryItemSkuByIds(skuIds);
        DtoHelper.eoList2DtoList(itemSkuEoList, (Collection)skuRepDtos, ItemSkuRespDto.class);
        dto.setItemSkuRespDtos((List)skuRepDtos);
        return itemSkuEoList;
    }

    private void getItemRespDtoList(ItemSkuListRespDto dto, List<ItemSkuEo> itemSkuEoList) {
        List<Object> itemEos = null;
        ArrayList itemIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(itemSkuEoList)) {
            for (ItemSkuEo skuEo : itemSkuEoList) {
                itemIds.add(skuEo.getItemId());
            }
        }
        itemEos = CollectionUtils.isNotEmpty((Collection)itemIds) ? this.queryItemByIds(itemIds) : Lists.newArrayList();
        ArrayList itemRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemEos, (Collection)itemRespDtos, ItemRespDto.class);
        dto.setItemRespDtos((List)itemRespDtos);
    }

    private void addItemAssociateAttr(Integer type, ItemChangeApplyDto publishItemDto, Long itemId, Long instanceId, Long tenantId) {
        List skus = publishItemDto.getSkus();
        HashMap<Long, Long> skuIds = new HashMap<Long, Long>();
        if (CollectionUtils.isNotEmpty((Collection)skus)) {
            for (ItemBundleReqDto itemBundleDto : skus) {
                ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
                this.addItemSku(itemId, itemBundleDto, itemSkuEo, instanceId, tenantId);
                skuIds.put(itemSkuEo.getId(), itemBundleDto.getShelfAmount());
                this.addItemBundle(itemId, type, itemBundleDto, itemSkuEo, instanceId, tenantId);
                this.addItemPrice(itemBundleDto, itemSkuEo, instanceId, tenantId);
                List medias = itemBundleDto.getMedias();
                this.addItemMedias(itemId, medias, itemSkuEo, instanceId, tenantId);
                this.addItemTags(itemId, itemBundleDto.getTags(), itemSkuEo, instanceId, tenantId);
            }
        }
        List medias = publishItemDto.getMedias();
        this.addItemMedias(itemId, medias, null, instanceId, tenantId);
        this.addItemAttr(publishItemDto, itemId, instanceId, tenantId);
        this.addItemTags(itemId, publishItemDto.getTags(), null, instanceId, tenantId);
        this.addItemPropRelation(publishItemDto, itemId, instanceId, tenantId);
    }

    private void addItemSku(Long itemId, ItemBundleReqDto itemBundleDto, ItemSkuEo itemSkuEo, Long instanceId, Long tenantId) {
        DtoHelper.dto2Eo((BaseVo)itemBundleDto, (BaseEo)itemSkuEo);
        itemSkuEo.setItemId(itemId);
        itemSkuEo.setInstanceId(instanceId);
        itemSkuEo.setTenantId(tenantId);
        this.itemSkuService.saveSku(itemSkuEo);
    }

    private void addItemAttr(ItemChangeApplyDto publishItemDto, Long itemId, Long instanceId, Long tenantId) {
        ItemAttributesEo itemAttributesEo = ItemAttributesEo.newInstance();
        itemAttributesEo.setItemId(itemId);
        String attrs = publishItemDto.getAttrs();
        itemAttributesEo.setAttrs(attrs);
        itemAttributesEo.setSearchAttrs(publishItemDto.getSearchAttrs());
        itemAttributesEo.setInstanceId(instanceId);
        itemAttributesEo.setTenantId(tenantId);
        this.itemAttributesService.addProp(itemAttributesEo);
    }

    private void addItemPrice(ItemBundleReqDto itemBundleDto, ItemSkuEo itemSkuEo, Long instanceId, Long tenantId) {
        List itemPriceDtoList = itemBundleDto.getPrices();
        if (CollectionUtils.isNotEmpty((Collection)itemPriceDtoList)) {
            ArrayList itemPriceEos = Lists.newArrayList();
            for (ItemPriceReqDto dto : itemPriceDtoList) {
                ItemPriceEo itemPriceEo = ItemPriceEo.newInstance();
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)itemPriceEo);
                itemPriceEo.setId(null);
                itemPriceEo.setSkuId(itemSkuEo.getId());
                itemPriceEo.setItemId(itemSkuEo.getItemId());
                itemPriceEo.setInstanceId(instanceId);
                itemPriceEo.setTenantId(tenantId);
                itemPriceEos.add(itemPriceEo);
            }
            this.itemPriceService.addBatchItemPrice(itemPriceEos);
        }
    }

    private void addItemBundle(Long itemId, Integer type, ItemBundleReqDto itemBundleDto, ItemSkuEo itemSkuEo, Long instanceId, Long tenantId) {
        List bundleItemDtos;
        if (ItemType.BUNDDLE.getIndex().equals(type) && CollectionUtils.isNotEmpty((Collection)(bundleItemDtos = itemBundleDto.getItemBundles()))) {
            ArrayList bundleItemEos = Lists.newArrayList();
            for (BundleItemReqDto bundleItemDto : bundleItemDtos) {
                ItemBundleRelationEo bundleItemEo = ItemBundleRelationEo.newInstance((Map)bundleItemDto.getExtFields());
                DtoHelper.dto2Eo((BaseVo)bundleItemDto, (BaseEo)bundleItemEo);
                bundleItemEo.setId(null);
                bundleItemEo.setItemId(itemId);
                bundleItemEo.setSkuId(itemSkuEo.getId());
                bundleItemEo.setInstanceId(instanceId);
                bundleItemEo.setTenantId(tenantId);
                bundleItemEos.add(bundleItemEo);
            }
            this.bundleItemService.addBundleItemBatch(bundleItemEos);
        }
    }

    private void addItemMedias(Long itemId, List<ItemMediasReqDto> medias, ItemSkuEo itemSkuEo, Long instanceId, Long tenantId) {
        ArrayList mediasEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(medias)) {
            for (ItemMediasReqDto itemMediasDto : medias) {
                ItemMediasEo itemMediasEo = ItemMediasEo.newInstance((Map)itemMediasDto.getExtFields());
                DtoHelper.dto2Eo((BaseVo)itemMediasDto, (BaseEo)itemMediasEo);
                itemMediasEo.setId(null);
                itemMediasEo.setItemId(itemId);
                if (null != itemSkuEo && null != itemSkuEo.getId()) {
                    itemMediasEo.setSkuId(itemSkuEo.getId());
                }
                itemMediasEo.setInstanceId(instanceId);
                itemMediasEo.setTenantId(tenantId);
                mediasEos.add(itemMediasEo);
            }
        }
        this.itemMediasService.addBatchItemMedias(mediasEos);
    }

    private void addItemTags(Long itemId, List<Long> tags, ItemSkuEo itemSkuEo, Long instanceId, Long tenantId) {
        ArrayList itemTagEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(tags)) {
            for (Long tag : tags) {
                ItemTagRelationEo itemTagEo = ItemTagRelationEo.newInstance();
                itemTagEo.setTagId(tag);
                itemTagEo.setItemId(itemId);
                if (null != itemSkuEo && null != itemSkuEo.getId()) {
                    itemTagEo.setSkuId(itemSkuEo.getId());
                }
                itemTagEo.setInstanceId(instanceId);
                itemTagEo.setTenantId(tenantId);
                itemTagEos.add(itemTagEo);
            }
        }
        this.itemTagService.relateToItem(itemTagEos);
    }

    private void addItemPropRelation(ItemChangeApplyDto publishItemDto, Long itemId, Long instanceId, Long tenantId) {
        if (CollectionUtils.isNotEmpty((Collection)publishItemDto.getItemPropRelationReqDtos())) {
            ArrayList<ItemPropRelationReqDto> dtos = new ArrayList<ItemPropRelationReqDto>();
            for (ItemPropRelationReqDto dto : publishItemDto.getItemPropRelationReqDtos()) {
                if (this.propService.queryPropGroupById(dto.getPropGroupId()) == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPGROUP.getCode(), ItemExceptionCode.NON_EXIST_PROPGROUP.getMsg());
                }
                dto.setItemId(itemId);
                dto.setTenantId(tenantId);
                dto.setInstanceId(instanceId);
                dto.setSellerId(publishItemDto.getSellerId());
                dtos.add(dto);
            }
            this.propService.addItemPropRelation(dtos);
        }
    }

    private void initItemEo(ItemChangeApplyDto changeApply, ItemEo itemEo) {
        DtoHelper.dto2Eo((BaseVo)changeApply, (BaseEo)itemEo);
        itemEo.setName(changeApply.getItemName());
        itemEo.setStatus(changeApply.getItemStatus());
        itemEo.setCode(changeApply.getItemCode());
        itemEo.setDisplayName(changeApply.getDisplayName());
        itemEo.setBrandId(changeApply.getBrandId());
        itemEo.setDetail(changeApply.getDetail());
        itemEo.setBrand(changeApply.getBrand());
        itemEo.setDirId(changeApply.getDirId());
        itemEo.setType(changeApply.getType());
        itemEo.setIsAfterSale(changeApply.getIsAfterSale());
        itemEo.setDirName(changeApply.getDirName());
        itemEo.setVitrual(changeApply.getVirtual());
        itemEo.setSellerId(changeApply.getSellerId());
        itemEo.setShopId(changeApply.getShopId());
        itemEo.setInstanceId(changeApply.getInstanceId());
        itemEo.setTenantId(changeApply.getTenantId());
        itemEo.setVersion(Long.valueOf(1L));
    }

    private void removeItemAssociateAttr(Long itemId, Integer type) {
        ItemMediasEo itemMediasEo = ItemMediasEo.newInstance();
        itemMediasEo.setItemId(itemId);
        this.itemMediasService.removeItemMedias(itemMediasEo);
        this.itemAttributesService.removeByItemId(itemId);
        if (ItemType.BUNDDLE.getIndex().equals(type)) {
            this.bundleItemService.removeByItemId(itemId);
        }
        ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
        itemSkuEo.setItemId(itemId);
        List<ItemSkuEo> itemSkuEos = this.itemSkuService.queryItemSku(itemSkuEo);
        if (CollectionUtils.isEmpty(itemSkuEos)) {
            return;
        }
        ArrayList skuIds = Lists.newArrayList();
        for (ItemSkuEo sku : itemSkuEos) {
            Long skuId = sku.getId();
            ItemPriceEo itemPriceEo = ItemPriceEo.newInstance();
            itemPriceEo.setSkuId(skuId);
            skuIds.add(skuId);
        }
        this.itemPriceService.removeBatchItemPrice(skuIds);
        this.itemSkuService.removeItemSku(skuIds);
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
        if (Objects.isNull(itemEo)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), ItemExceptionCode.NON_EXIST_ITEM.getMsg());
        }
    }

    @Override
    public void validSkuCode(ItemChangeApplyDto itemChangeApplyDto, Long tenantId) {
        if (itemChangeApplyDto != null && CollectionUtils.isNotEmpty((Collection)itemChangeApplyDto.getSkus())) {
            ArrayList<String> codes = new ArrayList<String>();
            for (ItemBundleReqDto itemBundleReqDto : itemChangeApplyDto.getSkus()) {
                if (itemBundleReqDto.getCode() != null && codes.contains(itemBundleReqDto.getCode())) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg() + itemBundleReqDto.getCode());
                }
                codes.add(itemBundleReqDto.getCode());
            }
            for (ItemBundleReqDto itemBundleReqDto : itemChangeApplyDto.getSkus()) {
                if (!StringUtils.isNotBlank((CharSequence)itemBundleReqDto.getCode())) continue;
                ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
                itemSkuEo.setTenantId(tenantId);
                itemSkuEo.setCode(itemBundleReqDto.getCode());
                if ((itemSkuEo = (ItemSkuEo)this.itemSkuDas.selectOne((BaseEo)itemSkuEo)) == null) continue;
                if (itemBundleReqDto.getId() == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg() + itemBundleReqDto.getCode());
                }
                if (itemBundleReqDto.getId() == null || itemSkuEo.getId().equals(itemBundleReqDto.getId())) continue;
                throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg() + itemBundleReqDto.getCode());
            }
        }
    }

    @Override
    public List<ItemRespDto> queryItems(List<Long> ids) {
        List itemEoList = this.itemDas.selectByIds(ids);
        ArrayList itemRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemEoList, (Collection)itemRespDtoList, ItemRespDto.class);
        return itemRespDtoList;
    }

    @Override
    public PageInfo<Long> querySaleOut(ItemReqDto itemReq, int page, int size) {
        ItemEo query = ItemEo.newInstance();
        CubeBeanUtils.copyProperties((Object)query, (Object)itemReq, (String[])new String[0]);
        List<Object> dirIdList = new ArrayList();
        if (Objects.nonNull(query.getDirId())) {
            dirIdList = this.dirService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{query.getDirId()}), null, null);
        }
        return this.itemDas.querySaleOut(query, page, size, dirIdList);
    }

    @Override
    public void modifyItemStatus(ItemModifyStatusReqDto modifyStatusReqDto) {
        if (Objects.isNull(modifyStatusReqDto)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        ItemEo itemEo = new ItemEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)modifyStatusReqDto.getIds()));
        itemEo.setStatus(modifyStatusReqDto.getStatus());
        itemEo.setSqlFilters(sqlFilters);
        this.itemDas.updateSelectiveSqlFilter((BaseEo)itemEo);
    }

    @Override
    public Long queryCount(ItemReqDto itemDto) {
        ItemEo itemEo = new ItemEo();
        DtoHelper.dto2Eo((BaseVo)itemDto, (BaseEo)itemEo);
        return this.itemDas.count((BaseEo)itemEo);
    }

    @Override
    public PageInfo<ItemShelfRespDto> queryItemShelf(ShelfReqDto shelfReqDto, Integer pageNum, Integer pageSize) {
        IShelfIntegralService shelfIntegralService;
        ShelfEo shelfEo = ShelfEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfReqDto, (BaseEo)shelfEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)shelfReqDto.getSkuIds())) {
            sqlFilters.add(SqlFilter.in((String)"skuId", (Object)shelfReqDto.getSkuIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)shelfReqDto.getShopIds())) {
            sqlFilters.add(SqlFilter.in((String)"shopId", (Object)shelfReqDto.getShopIds()));
        }
        PageInfo pageInfo = this.shelfDas.selectPage((BaseEo)shelfEo, pageNum, pageSize);
        ArrayList shelfRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)shelfRespDtoList, ItemShelfRespDto.class);
        PageInfo resultPage = new PageInfo((List)shelfRespDtoList);
        CubeBeanUtils.copyProperties((Object)resultPage, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) && shelfReqDto.getBusType() != null && shelfReqDto.getBusType().equals(ItemBusTypeEnum.INTEGRAL.getType()) && null != (shelfIntegralService = (IShelfIntegralService)SpringBeanUtil.getBean(IShelfIntegralService.class))) {
            for (ItemShelfRespDto itemShelfRespDto : shelfRespDtoList) {
                ShelfIntegralRespDto shelfIntegralRespDto = shelfIntegralService.queryByShelfId(itemShelfRespDto.getId());
                itemShelfRespDto.setShelfIntegral(shelfIntegralRespDto);
            }
        }
        return resultPage;
    }

    @Override
    public List<ItemShelfRespDto> queryItemShelfList(ShelfReqDto shelfReqDto) {
        IShelfIntegralService shelfIntegralService;
        ShelfEo shelfEo = ShelfEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfReqDto, (BaseEo)shelfEo);
        List list = this.shelfDas.select((BaseEo)shelfEo);
        ArrayList shelfRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)list, (Collection)shelfRespDtoList, ItemShelfRespDto.class);
        if (CollectionUtils.isNotEmpty((Collection)list) && shelfReqDto.getBusType() != null && shelfReqDto.getBusType().equals(ItemBusTypeEnum.INTEGRAL.getType()) && null != (shelfIntegralService = (IShelfIntegralService)SpringBeanUtil.getBean(IShelfIntegralService.class))) {
            for (ItemShelfRespDto itemShelfRespDto : shelfRespDtoList) {
                ShelfIntegralRespDto shelfIntegralRespDto = shelfIntegralService.queryByShelfId(itemShelfRespDto.getId());
                itemShelfRespDto.setShelfIntegral(shelfIntegralRespDto);
            }
        }
        return shelfRespDtoList;
    }

    @Override
    public List<Long> queryItemIds(ItemReqDto itemReqDto) {
        ArrayList itemIds = Lists.newArrayList();
        ItemEo itemEo = new ItemEo();
        DtoHelper.dto2Eo((BaseVo)itemReqDto, (BaseEo)itemEo);
        PageInfo pageInfo = this.itemDas.selectPage((BaseEo)itemEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return itemIds;
        }
        itemIds.addAll(pageInfo.getList().stream().map(BaseEo::getId).collect(Collectors.toList()));
        for (int pageNum = 2; pageNum <= pageInfo.getPages(); ++pageNum) {
            pageInfo = this.itemDas.selectPage((BaseEo)itemEo, Integer.valueOf(pageNum), Integer.valueOf(1000));
            if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
            itemIds.addAll(pageInfo.getList().stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
        return itemIds;
    }

    @Override
    public ItemRespDto queryItemAndSku(Long itemId, Long skuId) {
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
        if (null == itemEo) {
            return null;
        }
        ItemRespDto itemRespDto = new ItemRespDto();
        DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)itemRespDto);
        ItemSkuEo itemSkuEo = (ItemSkuEo)this.itemSkuDas.selectByPrimaryKey(skuId);
        if (null == itemSkuEo) {
            return itemRespDto;
        }
        ItemSkuRespDto itemSkuRespDto = new ItemSkuRespDto();
        DtoHelper.eo2Dto((BaseEo)itemSkuEo, (BaseVo)itemSkuRespDto);
        itemRespDto.setItemSkuList((List)Lists.newArrayList((Object[])new ItemSkuRespDto[]{itemSkuRespDto}));
        return itemRespDto;
    }

    @Override
    @Cacheable(value={"center_item_item_detail"}, key="#itemId+'_'+#shopId", unless="#result == null")
    public ItemDetailBaseInfoRespDto queryItemDetail(long itemId, long shopId) {
        ItemSearchQueryReqDto queryReqDto = new ItemSearchQueryReqDto();
        queryReqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        queryReqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        queryReqDto.setItemIds((List)Lists.newArrayList((Object[])new Long[]{itemId}));
        ItemSearchRespDto searchRespDto = this.queryByKeyword(queryReqDto, 1, 1);
        if (null == searchRespDto || null == searchRespDto.getPageInfo() || CollectionUtils.isEmpty((Collection)searchRespDto.getPageInfo().getList())) {
            return null;
        }
        ItemRespDto itemRespDto = (ItemRespDto)searchRespDto.getPageInfo().getList().get(0);
        ItemDetailBaseInfoRespDto itemBaseInfo = new ItemDetailBaseInfoRespDto();
        CubeBeanUtils.copyProperties((Object)itemBaseInfo, (Object)itemRespDto, (String[])new String[0]);
        itemBaseInfo.setItemMediasList(itemRespDto.getItemMediasList());
        itemBaseInfo.setSaleCount(itemRespDto.getSalesCount());
        itemBaseInfo.setAttrs(((ItemAttributesRespDto)searchRespDto.getAttributesList().get(0)).getAttrs());
        this.filterOnSelfSkuAndModify(itemBaseInfo, itemRespDto, shopId);
        return itemBaseInfo;
    }

    private void filterOnSelfSkuAndModify(ItemDetailBaseInfoRespDto itemBaseInfo, ItemRespDto itemRespDto, long shopId) {
        IItemCycleBuyService itemCycleBuyService;
        long itemId = itemBaseInfo.getId();
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(Long.valueOf(itemId));
        if (shopId > 0L) {
            shelfReqDto.setShopId(Long.valueOf(shopId));
        }
        shelfReqDto.setStatus(Integer.valueOf(1));
        List<ItemShelfRespDto> itemShelfRespDtos = this.queryItemShelfList(shelfReqDto);
        if (CollectionUtils.isEmpty(itemShelfRespDtos)) {
            logger.error("\u65e0\u4e0a\u67b6\u4fe1\u606f{}\uff0c{}", (Object)itemId, (Object)shopId);
            return;
        }
        ArrayList itemSkuList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemSkuList, (Collection)itemRespDto.getItemSkuList(), ItemSkuInfoRespDto.class);
        boolean hasCycleBuy = itemShelfRespDtos.parallelStream().anyMatch(t -> Objects.equals(t.getType(), ShelfTypeEnum.PERIOD.getType()));
        if (hasCycleBuy && null != (itemCycleBuyService = (IItemCycleBuyService)SpringBeanUtil.getBean(IItemCycleBuyService.class))) {
            itemBaseInfo.setCycleBuyByShopItem(itemCycleBuyService.getCycleBuyByShopItem(shopId, itemId));
        }
        Map<Long, ItemShelfRespDto> itemShelfRespDtoMap = itemShelfRespDtos.stream().collect(Collectors.toMap(ItemShelfRespDto::getSkuId, itemShelfRespDto -> itemShelfRespDto, (e1, e2) -> e1));
        itemBaseInfo.setItemSkuList(itemSkuList.stream().filter(itemSkuInfoRespDto -> itemShelfRespDtoMap.get(itemSkuInfoRespDto.getId()) != null).peek(itemSkuInfoRespDto -> {
            ItemShelfRespDto itemShelfRespDto = (ItemShelfRespDto)itemShelfRespDtoMap.get(itemSkuInfoRespDto.getId());
            itemSkuInfoRespDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
            if (CollectionUtils.isNotEmpty((Collection)itemSkuInfoRespDto.getItemPriceList())) {
                for (ItemPriceRespDto itemPriceRespDto : itemSkuInfoRespDto.getItemPriceList()) {
                    if (!ItemPriceEnum.SALE_PRICE.getType().equals(itemPriceRespDto.getPriceType())) continue;
                    itemPriceRespDto.setPrice(itemShelfRespDto.getPrice());
                }
            }
        }).collect(Collectors.toList()));
    }

    @Override
    public List<DirsItemsRespDto> queryDirsItems(Long shopId, Long itemId) {
        DirItemRelationEo dirItemRelationEo = DirItemRelationEo.newInstance();
        dirItemRelationEo.setShopId(shopId);
        dirItemRelationEo.setItemId(itemId);
        List dirsItemsEoList = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)dirsItemsEoList, (Collection)list, DirsItemsRespDto.class);
        return list;
    }
}

