/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ValidateException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTaskStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTaskTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.ItemMessage;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.AllowOrderTimeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemCycleBuyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemOnShelfReqListDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.OffItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfIntegralAddReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfIntegralModifyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfTaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfTimeDetailReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfIntegralRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.ItemShelfProducer;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDistributionSetService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemCycleBuyService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfIntegralService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfSchedulerService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.dto.ShelfItemDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.ItemStorageUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemBundleRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfTaskDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemBundleRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfTaskEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdShelfEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemShelfServiceImpl
implements IItemShelfService {
    private static Logger logger = LoggerFactory.getLogger(ItemShelfServiceImpl.class);
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private IItemAttributesService itemAttributesService;
    @Resource
    private IDirItemAttributesService dirItemAttributesService;
    @Resource
    private IItemService itemService;
    @Resource
    private IShelfService shelfService;
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private DirDas dirDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private IShelfSchedulerService shelfSchedulerService;
    @Resource
    private ShelfTaskDas shelfTaskDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private IItemSkuService itemSkuService;
    @Resource
    private ItemStorageDas itemStorageDas;
    @Resource
    private ItemStorageUtils itemStorageUtils;
    @Resource
    private ItemBundleRelationDas itemBundleRelationDas;
    @Resource
    private IItemSearchService itemSearchService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ItemShelfProducer itemShelfProducer;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void onShelfItem(List<ItemShelfReqDto> itemShelfReqDtoList) {
        ArrayList<ItemShelfReqDto> onShelfDtos = new ArrayList<ItemShelfReqDto>();
        for (ItemShelfReqDto itemShelfReqDto : itemShelfReqDtoList) {
            if (itemShelfReqDto.getTiming()) {
                this.autoShelfProcess(itemShelfReqDto);
                continue;
            }
            ShelfItemDto shelfItemDto = new ShelfItemDto();
            CubeBeanUtils.copyProperties((Object)((Object)shelfItemDto), (Object)itemShelfReqDto, (String[])new String[0]);
            this.updateShelfTaskStatus(shelfItemDto, ShelfTaskStatusEnum.UNPROCESSED.getStatus(), ShelfTaskTypeEnum.ON.getType(), ShelfTaskStatusEnum.CANCEL.getStatus());
            onShelfDtos.add(itemShelfReqDto);
        }
        if (CollectionUtils.isNotEmpty(onShelfDtos)) {
            this.onShelfOperation(onShelfDtos, true, null);
        }
    }

    @Override
    public void onShelfItemList(ItemOnShelfReqListDto itemOnShelfReqListDto) {
        List itemShelfReqDtoList = itemOnShelfReqListDto.getItemShelfReqDtos();
        if (CollectionUtils.isNotEmpty((Collection)itemShelfReqDtoList)) {
            this.onShelfItem(itemShelfReqDtoList);
            IItemCycleBuyService itemCycleBuyService = (IItemCycleBuyService)SpringBeanUtil.getBean(IItemCycleBuyService.class);
            if (null != itemCycleBuyService) {
                List cycleBuyReqDtoList = itemOnShelfReqListDto.getCycleBuyReqDtos();
                if (CollectionUtils.isEmpty((Collection)cycleBuyReqDtoList)) {
                    itemShelfReqDtoList.forEach(shelfItem -> itemCycleBuyService.removeCycleBuyByShopItem(shelfItem.getShopId(), shelfItem.getItemId()));
                } else {
                    cycleBuyReqDtoList.forEach(itemCycleBuyReqDto -> itemCycleBuyService.removeCycleBuyByShopItem(itemCycleBuyReqDto.getShopId(), itemCycleBuyReqDto.getItemId()));
                    cycleBuyReqDtoList.forEach(buyReqDto -> itemCycleBuyService.addItemCycleBuy((ItemCycleBuyReqDto)buyReqDto));
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void onShelfOperation(List<ItemShelfReqDto> onShelfDtoList, boolean isManual, Long taskId) {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u4e0a\u67b6\u64cd\u4f5c\u2026\u2026");
        this.onShelfCheckSubItemStatus(onShelfDtoList);
        ArrayList shelfDirItems = Lists.newArrayList();
        List<DirItemRelationEo> dirsItemsEos = new ArrayList<DirItemRelationEo>();
        for (ItemShelfReqDto dto : onShelfDtoList) {
            DirItemRelationEo dirItemRelationEo = DirItemRelationEo.newInstance();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)dirItemRelationEo);
            if (dto.getShelfTimeReqDto() == null) {
                dirsItemsEos.add(dirItemRelationEo);
                continue;
            }
            if (CollectionUtils.isNotEmpty(this.getAllowOrderTime(dto))) {
                dirItemRelationEo.setAllowOrderTime(this.Date2JsonString(this.getAllowOrderTime(dto), "yyyy-MM-dd HH:mm:ss"));
            }
            dirsItemsEos.add(dirItemRelationEo);
        }
        this.verifyDirItems(dirsItemsEos);
        dirsItemsEos = this.removeReply(dirsItemsEos);
        HashSet itemIds = new HashSet();
        HashSet dirIds = new HashSet();
        HashSet skuIds = new HashSet();
        dirsItemsEos.forEach(dirItem -> {
            itemIds.add(dirItem.getItemId());
            dirIds.add(dirItem.getDirId());
            skuIds.add(dirItem.getSkuId());
        });
        this.verifyItemIds(Lists.newArrayList(itemIds), Lists.newArrayList(dirIds), Lists.newArrayList(skuIds), taskId, ShelfTaskTypeEnum.ON.getType());
        ArrayList<DirItemRelationEo> insertEos = new ArrayList<DirItemRelationEo>();
        ArrayList<DirItemRelationEo> updateEos = new ArrayList<DirItemRelationEo>();
        for (DirItemRelationEo dirsItemsEo2 : dirsItemsEos) {
            DirItemRelationEo result = this.queryDirItemRelationInfo(dirsItemsEo2);
            if (result == null) {
                dirsItemsEo2.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
                insertEos.add(dirsItemsEo2);
                continue;
            }
            dirsItemsEo2.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
            dirsItemsEo2.setId(result.getId());
            updateEos.add(dirsItemsEo2);
        }
        if (CollectionUtils.isNotEmpty(updateEos)) {
            updateEos.forEach(dirsItemsEo -> this.dirItemRelationDas.updateSelective((BaseEo)dirsItemsEo));
            shelfDirItems.addAll(updateEos);
        }
        if (CollectionUtils.isNotEmpty(insertEos)) {
            this.dirItemRelationDas.insertBatch(insertEos);
            shelfDirItems.addAll(insertEos);
        }
        logger.info("\u4fdd\u5b58\u4e0a\u67b6\u8bb0\u5f55");
        ArrayList shelfReqDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfReqDtos, onShelfDtoList, ShelfReqDto.class);
        this.saveShelf(shelfReqDtos, ItemStatus.ITEM_ONSHELF.getStatus());
        logger.info("\u4fdd\u5b58\u5546\u54c1\u5206\u9500\u8bbe\u7f6e");
        this.saveDistribution(onShelfDtoList);
        List<ItemAttributesEo> allItemAttributes = this.itemAttributesService.queryByItemIds(Lists.newArrayList(itemIds));
        Map<Long, List<ItemAttributesEo>> groupItemIdAttributes = this.getGroupItemIdAttributes(Lists.newArrayList(itemIds), allItemAttributes);
        for (DirItemRelationEo dirsItemsEo3 : dirsItemsEos) {
            List<ItemAttributesEo> attributesList = groupItemIdAttributes.get(dirsItemsEo3.getItemId());
            if (!CollectionUtils.isNotEmpty(attributesList)) continue;
            this.dirItemAttributesService.addSearchAttrsAttributes(dirsItemsEo3.getDirId(), attributesList);
        }
        shelfDirItems.forEach(dirItem -> {
            this.itemSearchService.index(dirItem.getSellerId(), dirItem.getItemId(), ((ItemShelfReqDto)onShelfDtoList.get(0)).getItemType(), ((ItemShelfReqDto)onShelfDtoList.get(0)).getBusType(), "ON_SHELF");
            ItemMessage message = new ItemMessage(dirItem.getItemId(), dirItem.getShopId(), Integer.valueOf(1));
            this.itemShelfProducer.sendMqMessage(message);
        });
        if (!isManual) {
            for (ItemShelfReqDto dto : onShelfDtoList) {
                ShelfItemDto shelfItemDto = new ShelfItemDto();
                CubeBeanUtils.copyProperties((Object)((Object)shelfItemDto), (Object)dto, (String[])new String[0]);
                shelfItemDto.setTaskId(taskId);
                this.updateShelfTaskStatus(shelfItemDto, ShelfTaskStatusEnum.UNPROCESSED.getStatus(), ShelfTaskTypeEnum.ON.getType(), ShelfTaskStatusEnum.SUCCESS.getStatus());
            }
        }
    }

    private void saveDistribution(List<ItemShelfReqDto> onShelfDtoList) {
        IDistributionSetService distributionSetService = (IDistributionSetService)SpringBeanUtil.getBean(IDistributionSetService.class);
        if (null != distributionSetService) {
            HashSet distributionSets = Sets.newHashSet();
            onShelfDtoList.forEach(itemShelfReqDto -> {
                if (itemShelfReqDto.getDistribution() == 1 && null != itemShelfReqDto.getDistribution()) {
                    distributionSets.add(itemShelfReqDto.getDistributionSet());
                }
            });
            distributionSetService.saveBatch(distributionSets.stream().collect(Collectors.toList()));
        }
    }

    private void saveShelf(List<ShelfReqDto> shelfReqDtos, Integer itemStatus) {
        IShelfIntegralService shelfIntegralService;
        Map<String, ShelfReqDto> shelfMap = shelfReqDtos.stream().collect(Collectors.toMap(shelfReqDto -> shelfReqDto.getShopId() + shelfReqDto.getItemId() + shelfReqDto.getSkuId().toString(), e -> e, (e1, e2) -> e1));
        ArrayList<ShelfEo> shelfEoList = new ArrayList<ShelfEo>();
        Date shelfTime = new Date();
        for (ShelfReqDto shelfReqDto2 : shelfMap.values()) {
            ItemEo itemEo = this.itemService.queryById(shelfReqDto2.getItemId());
            ShelfEo shelfEo = new ShelfEo();
            shelfEo.setItemId(shelfReqDto2.getItemId());
            shelfEo.setSkuId(shelfReqDto2.getSkuId());
            shelfEo.setShopId(shelfReqDto2.getShopId());
            shelfEo.setInstanceId(itemEo.getInstanceId());
            shelfEo.setTenantId(itemEo.getTenantId());
            shelfEo.setSellerId(shelfReqDto2.getSellerId());
            shelfEo.setDistribution(shelfReqDto2.getDistribution());
            shelfEo.setItemType(shelfReqDto2.getItemType());
            shelfEo.setBusType(shelfReqDto2.getBusType());
            ShelfEo update = (ShelfEo)this.shelfDas.selectOne((BaseEo)shelfEo);
            if (null != update) {
                update.setShelfTime(shelfTime);
                update.setStatus(itemStatus);
                update.setType(update.getType());
                update.setPrice(shelfReqDto2.getPrice());
                update.setVersionId(itemEo.getVersion());
                this.shelfDas.updateSelective((BaseEo)update);
                continue;
            }
            shelfEo.setOrganizationId(shelfReqDto2.getOrganizationId());
            shelfEo.setOrganizationName(shelfReqDto2.getOrganizationName());
            shelfEo.setShelfTime(shelfTime);
            shelfEo.setStatus(itemStatus);
            shelfEo.setPrice(shelfReqDto2.getPrice());
            shelfEo.setType(shelfReqDto2.getType());
            shelfEo.setVersionId(itemEo.getVersion());
            shelfEo.setSellerId(shelfReqDto2.getSellerId());
            shelfEoList.add(shelfEo);
        }
        if (CollectionUtils.isNotEmpty(shelfEoList)) {
            this.shelfDas.insertBatch(shelfEoList);
        }
        if (null != (shelfIntegralService = (IShelfIntegralService)SpringBeanUtil.getBean(IShelfIntegralService.class)) && ItemBusTypeEnum.INTEGRAL.getType().equals(shelfReqDtos.get(0).getBusType())) {
            for (ShelfReqDto shelfReqDto3 : shelfMap.values()) {
                ShelfEo shelfQuery = new ShelfEo();
                shelfQuery.setItemType(shelfReqDto3.getItemType());
                shelfQuery.setSkuId(shelfReqDto3.getSkuId());
                shelfQuery.setBusType(shelfReqDto3.getBusType());
                shelfQuery.setItemId(shelfReqDto3.getItemId());
                shelfQuery.setShopId(shelfReqDto3.getShopId());
                ShelfEo result = (ShelfEo)this.shelfDas.selectOne((BaseEo)shelfQuery);
                ShelfIntegralRespDto shelfIntegralRespDto = shelfIntegralService.queryBySkuInfo(shelfReqDto3.getSkuId(), shelfReqDto3.getShopId());
                if (shelfIntegralRespDto == null) {
                    ShelfIntegralAddReqDto shelfIntegralAddReqDto = new ShelfIntegralAddReqDto();
                    shelfIntegralAddReqDto.setCashAmount(shelfReqDto3.getCashAmount());
                    shelfIntegralAddReqDto.setShelfId(result.getId());
                    shelfIntegralAddReqDto.setCashType(shelfReqDto3.getCashType());
                    shelfIntegralAddReqDto.setCashLimit(shelfReqDto3.getCashLimit());
                    shelfIntegralAddReqDto.setCashIntegral(shelfReqDto3.getCashIntegral());
                    shelfIntegralAddReqDto.setRuleRemark(shelfReqDto3.getRuleRemark());
                    shelfIntegralAddReqDto.setSkuId(shelfReqDto3.getSkuId());
                    shelfIntegralAddReqDto.setItemId(shelfReqDto3.getItemId());
                    shelfIntegralAddReqDto.setShopId(shelfReqDto3.getShopId());
                    shelfIntegralService.add(shelfIntegralAddReqDto);
                    continue;
                }
                ShelfIntegralModifyReqDto shelfIntegralModifyReqDto = new ShelfIntegralModifyReqDto();
                shelfIntegralModifyReqDto.setCashAmount(shelfReqDto3.getCashAmount());
                shelfIntegralModifyReqDto.setShelfId(result.getId());
                shelfIntegralModifyReqDto.setCashType(shelfReqDto3.getCashType());
                shelfIntegralModifyReqDto.setId(shelfIntegralRespDto.getId());
                shelfIntegralModifyReqDto.setCashLimit(shelfReqDto3.getCashLimit());
                shelfIntegralModifyReqDto.setCashIntegral(shelfReqDto3.getCashIntegral());
                shelfIntegralModifyReqDto.setItemId(shelfReqDto3.getItemId());
                shelfIntegralModifyReqDto.setRuleRemark(shelfReqDto3.getRuleRemark());
                shelfIntegralModifyReqDto.setShopId(shelfReqDto3.getShopId());
                shelfIntegralModifyReqDto.setSkuId(shelfReqDto3.getSkuId());
                if (ItemStatus.ITEM_ONSHELF.getStatus().equals(itemStatus)) {
                    shelfIntegralService.modify(shelfIntegralModifyReqDto);
                    continue;
                }
                shelfIntegralService.modifySelective(shelfIntegralModifyReqDto);
            }
        }
        for (ShelfReqDto shelfReqDto3 : shelfMap.values()) {
            this.shelfService.clearItemShelfCache(shelfReqDto3);
        }
    }

    private boolean firstOnShelf(Long itemId) {
        ShelfEo shelfEo = ShelfEo.newInstance();
        shelfEo.setItemId(itemId);
        shelfEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        int count = this.shelfDas.count((BaseEo)shelfEo);
        return count == 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"center_item_item_detail"}, key="#offItemReqDtos[0].itemId+'_'+#offItemReqDtos[0].shopId")
    public void offShelfItem(List<OffItemReqDto> offItemReqDtos) {
        ArrayList<OffItemReqDto> offDtos = new ArrayList<OffItemReqDto>();
        for (OffItemReqDto dto : offItemReqDtos) {
            if (dto.isTiming()) {
                if (dto.getOffTime() != null) {
                    this.saveShelfTask(null, null, dto);
                    continue;
                }
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":" + dto.getItemId() + "\u5b9a\u65f6\u4e0b\u67b6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ShelfItemDto shelfItemDto = new ShelfItemDto();
            CubeBeanUtils.copyProperties((Object)((Object)shelfItemDto), (Object)dto, (String[])new String[0]);
            this.updateShelfTaskStatus(shelfItemDto, ShelfTaskStatusEnum.UNPROCESSED.getStatus(), ShelfTaskTypeEnum.OFF.getType(), ShelfTaskStatusEnum.CANCEL.getStatus());
            offDtos.add(dto);
        }
        if (CollectionUtils.isNotEmpty(offDtos)) {
            this.offShelfOperation(offDtos, true, null);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void offShelfOperation(List<OffItemReqDto> offItemReqDtos, boolean isManual, Long taskId) {
        this.offShelfCheckItemStatus(offItemReqDtos);
        HashSet itemIds = Sets.newHashSet();
        ArrayList offDirItems = Lists.newArrayList();
        for (OffItemReqDto offItemReqDto : offItemReqDtos) {
            if (offItemReqDto.getItemId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
            }
            itemIds.add(offItemReqDto.getItemId());
            ItemEo itemEo = this.itemService.queryById(offItemReqDto.getItemId());
            if (itemEo != null) {
                if (offItemReqDto.getSkuId() != null) {
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    skuIds.add(offItemReqDto.getSkuId());
                    this.verifyItemIds(null, null, skuIds, taskId, ShelfTaskTypeEnum.OFF.getType());
                }
                if (offItemReqDto.getDirId() != null) {
                    ArrayList<Long> dirIds = new ArrayList<Long>();
                    dirIds.add(offItemReqDto.getDirId());
                    this.verifyItemIds(null, dirIds, null, taskId, ShelfTaskTypeEnum.OFF.getType());
                }
                DirItemRelationEo dirItemRelationEo = DirItemRelationEo.newInstance();
                dirItemRelationEo.setItemId(itemEo.getId());
                dirItemRelationEo.setSkuId(offItemReqDto.getSkuId());
                dirItemRelationEo.setShopId(offItemReqDto.getShopId());
                dirItemRelationEo.setDirId(offItemReqDto.getDirId());
                dirItemRelationEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
                dirItemRelationEo.setTenantId(offItemReqDto.getTenantId());
                dirItemRelationEo.setInstanceId(offItemReqDto.getInstanceId());
                dirItemRelationEo.setBusType(offItemReqDto.getBusType());
                List relations = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
                for (DirItemRelationEo e3 : relations) {
                    DirItemRelationEo updateEo = DirItemRelationEo.newInstance();
                    updateEo.setId(e3.getId());
                    updateEo.setStatus(ItemStatus.ITEM_OFFSHELF.getStatus());
                    this.dirItemRelationDas.updateSelective((BaseEo)updateEo);
                    this.dirItemRelationDas.logicDeleteById(e3.getId());
                    offDirItems.add(e3);
                }
                if (isManual) continue;
                ShelfItemDto shelfItemDto = new ShelfItemDto();
                CubeBeanUtils.copyProperties((Object)((Object)shelfItemDto), (Object)offItemReqDto, (String[])new String[0]);
                shelfItemDto.setTaskId(taskId);
                this.updateShelfTaskStatus(shelfItemDto, ShelfTaskStatusEnum.UNPROCESSED.getStatus(), ShelfTaskTypeEnum.OFF.getType(), ShelfTaskStatusEnum.SUCCESS.getStatus());
                continue;
            }
            if (taskId == null) continue;
            ShelfItemDto shelfItemDto = new ShelfItemDto();
            shelfItemDto.setItemId(offItemReqDto.getItemId());
            shelfItemDto.setTaskId(taskId);
            this.updateShelfTaskStatus(shelfItemDto, ShelfTaskStatusEnum.UNPROCESSED.getStatus(), ShelfTaskTypeEnum.OFF.getType(), ShelfTaskStatusEnum.FAIL.getStatus());
        }
        ArrayList shelfReqDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfReqDtos, offItemReqDtos, ShelfReqDto.class);
        this.saveShelf(shelfReqDtos, ItemStatus.ITEM_OFFSHELF.getStatus());
        Map<String, DirItemRelationEo> offDirItemMap = offDirItems.stream().collect(Collectors.toMap(dirItem -> dirItem.getItemId().toString() + dirItem.getShopId(), e -> e, (e1, e2) -> e1));
        offDirItemMap.forEach((k, dirItem) -> {
            ItemMessage itemMessage = new ItemMessage(dirItem.getItemId(), dirItem.getShopId(), Integer.valueOf(0));
            this.itemShelfProducer.sendMqMessage(itemMessage);
            this.itemSearchService.index(dirItem.getSellerId(), dirItem.getItemId(), ((OffItemReqDto)offItemReqDtos.get(0)).getItemType(), ((OffItemReqDto)offItemReqDtos.get(0)).getBusType(), "OFF_SHELF");
        });
    }

    @Override
    public void removeShelf(List<Long> skuIds) {
        ShelfEo shelfEo = new ShelfEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"sku_id", skuIds));
        shelfEo.setSqlFilters(sqlFilters);
        this.shelfDas.delete((BaseEo)shelfEo);
    }

    @Override
    public void batchAddShelf(List<ShelfEo> shelfEos) {
        if (CollectionUtils.isEmpty(shelfEos)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        this.shelfDas.insertBatch(shelfEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteDirItemByIds(List<Long> dirItemIds) {
        if (CollectionUtils.isEmpty(dirItemIds)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        List dirsItemsEos = this.dirItemRelationDas.selectByIds(dirItemIds);
        for (DirItemRelationEo dirsItemsEo : dirsItemsEos) {
            this.dirItemRelationDas.deleteById(dirsItemsEo.getId());
            ShelfEo shelfEo = new ShelfEo();
            shelfEo.setItemId(dirsItemsEo.getItemId());
            this.shelfDas.delete((BaseEo)shelfEo);
        }
    }

    @Override
    public PageInfo<DirItemRelationEo> queryByItemId(Long instanceId, Long itemId, Integer pageNum, Integer pageSize) {
        DirItemRelationEo dirsItemsEo = DirItemRelationEo.newInstance();
        dirsItemsEo.setItemId(itemId);
        dirsItemsEo.setInstanceId(instanceId);
        return this.dirItemRelationDas.selectPage((BaseEo)dirsItemsEo, pageNum, pageSize);
    }

    @Override
    public PageInfo<DirItemRelationEo> queryByDirId(Long instanceId, Long dirId, Integer pageNum, Integer pageSize) {
        DirItemRelationEo dirsItemsEo = DirItemRelationEo.newInstance();
        dirsItemsEo.setInstanceId(instanceId);
        dirsItemsEo.setDirId(dirId);
        return this.dirItemRelationDas.selectPage((BaseEo)dirsItemsEo, pageNum, pageSize);
    }

    @Override
    public int countByDirId(Long instanceId, Long tenantId, Long dirId) {
        DirItemRelationEo dirsItemsEo = DirItemRelationEo.newInstance();
        dirsItemsEo.setDirId(dirId);
        dirsItemsEo.setInstanceId(instanceId);
        dirsItemsEo.setTenantId(tenantId);
        return this.dirItemRelationDas.count((BaseEo)dirsItemsEo);
    }

    @Override
    public PageInfo<DirItemRelationEo> queryByDirIds(Long tenantId, Long instanceId, List<Long> dirIds, Integer pageNum, Integer pageSize) {
        DirItemRelationEo dirsItemsEo = DirItemRelationEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        dirsItemsEo.setInstanceId(instanceId);
        dirsItemsEo.setTenantId(tenantId);
        if (CollectionUtils.isNotEmpty(dirIds)) {
            sqlFilters.add(SqlFilter.in((String)"dir_id", (Object)StringUtils.join(dirIds, (String)",")));
        }
        dirsItemsEo.setSqlFilters((List)sqlFilters);
        return this.dirItemRelationDas.selectPage((BaseEo)dirsItemsEo, pageNum, pageSize);
    }

    @Override
    public void offShelfByDirId(Long dirId) {
        DirItemRelationEo example = DirItemRelationEo.newInstance();
        example.setDirId(dirId);
        this.dirItemRelationDas.logicDelete((BaseEo)example);
    }

    @Override
    public void offShelfByBrandId(Long brandId) {
        ItemEo itemEo = ItemEo.newInstance();
        itemEo.setBrandId(brandId);
        List<ItemEo> itemEos = this.itemService.queryItems(itemEo);
        if (CollectionUtils.isEmpty(itemEos)) {
            return;
        }
        ArrayList<OffItemReqDto> dtos = new ArrayList<OffItemReqDto>();
        for (ItemEo eo : itemEos) {
            OffItemReqDto offItemReqDto = new OffItemReqDto();
            offItemReqDto.setItemId(eo.getId());
            offItemReqDto.setTiming(false);
            dtos.add(offItemReqDto);
        }
        this.offShelfItem(dtos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addItemDir(Long itemId, String dirIds, Long shopId, Long channelId) {
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
        if (!(itemEo != null && ItemStatus.ITEM_ONSHELF.getStatus().equals(itemEo.getStatus()) && itemEo.getInstanceId().equals(ServiceContext.getContext().getRequestInstanceId()) && itemEo.getTenantId().equals(ServiceContext.getContext().getRequestTenantId()))) {
            return;
        }
        String[] dirIdsStr = dirIds.split(",");
        if (dirIdsStr != null && dirIdsStr.length != 0) {
            for (String dirIdStr : dirIdsStr) {
                if (!NumberUtils.isDigits((String)dirIdStr)) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
                }
                Long dirId = Long.valueOf(dirIdStr);
                DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(dirId);
                if (dirEo == null || !dirEo.getInstanceId().equals(ServiceContext.getContext().getRequestInstanceId()) || !dirEo.getTenantId().equals(ServiceContext.getContext().getRequestTenantId())) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
                }
                DirItemRelationEo dirItemRelationEo = new DirItemRelationEo();
                dirItemRelationEo.setItemId(itemId);
                dirItemRelationEo.setDirId(dirId);
                dirItemRelationEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
                dirItemRelationEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
                if (this.dirItemRelationDas.count((BaseEo)dirItemRelationEo) > 0) continue;
                dirItemRelationEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
                this.dirItemRelationDas.insert((BaseEo)dirItemRelationEo);
            }
        }
    }

    @Override
    public void modifyShelfTask(List<ShelfTaskUpdateReqDto> shelfTaskUpdateReqDtos) {
        if (CollectionUtils.isEmpty(shelfTaskUpdateReqDtos)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":\u5b9a\u65f6\u4efb\u52a1dto\u5217\u8868\u65e0\u6570\u636e");
        }
        for (ShelfTaskUpdateReqDto dto : shelfTaskUpdateReqDtos) {
            ShelfTaskEo eo = (ShelfTaskEo)this.shelfTaskDas.selectByPrimaryKey(dto.getId());
            if (eo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg() + ":" + dto.getId() + "\u5bf9\u5e94\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            if (ShelfTaskStatusEnum.UNPROCESSED.getStatus().equals(eo.getStatus())) {
                ShelfTaskEo shelfTaskEo = ShelfTaskEo.newInstance();
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)shelfTaskEo);
                this.shelfTaskDas.updateSelective((BaseEo)shelfTaskEo);
                continue;
            }
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + "\u8bf7\u68c0\u67e5:" + dto.getId() + "\u7684\u4efb\u52a1\u72b6\u6001");
        }
    }

    @Override
    public void removeShelfTask(List<Long> ids, Long instanceId, Long tenantId) {
        for (Long id : ids) {
            if (!ShelfTaskStatusEnum.UNPROCESSED.getStatus().equals(((ShelfTaskEo)this.shelfTaskDas.selectByPrimaryKey(id)).getStatus())) continue;
            ShelfTaskEo shelfTaskEo = ShelfTaskEo.newInstance();
            shelfTaskEo.setId(id);
            shelfTaskEo.setInstanceId(instanceId);
            shelfTaskEo.setTenantId(tenantId);
            this.shelfTaskDas.logicDelete((BaseEo)shelfTaskEo);
        }
    }

    private List<DirItemRelationEo> removeReply(List<DirItemRelationEo> dirItemRelationEoList) {
        HashMap<String, DirItemRelationEo> dirsItemsEoMap = new HashMap<String, DirItemRelationEo>();
        for (DirItemRelationEo dirsItemsEo : dirItemRelationEoList) {
            StringBuilder sb = new StringBuilder();
            sb.append(dirsItemsEo.getDirId()).append("_");
            sb.append(dirsItemsEo.getItemId()).append("_");
            sb.append(dirsItemsEo.getSkuId()).append("_");
            sb.append(dirsItemsEo.getShopId()).append("_");
            sb.append(dirsItemsEo.getBusType());
            dirsItemsEoMap.put(sb.toString(), dirsItemsEo);
        }
        ArrayList<DirItemRelationEo> resultEos = new ArrayList<DirItemRelationEo>();
        resultEos.addAll(dirsItemsEoMap.values());
        return resultEos;
    }

    private Map<Long, List<Long>> getItemSkuRelationMap(List<DirItemRelationEo> dirItemRelationEoList) {
        HashMap<Long, List<Long>> itemSkuRelationMap = new HashMap<Long, List<Long>>();
        for (DirItemRelationEo dirItemRelationEo : dirItemRelationEoList) {
            ArrayList<Long> skuIdList = (ArrayList<Long>)itemSkuRelationMap.get(dirItemRelationEo.getItemId());
            if (skuIdList == null) {
                skuIdList = new ArrayList<Long>();
                itemSkuRelationMap.put(dirItemRelationEo.getItemId(), skuIdList);
            }
            if (dirItemRelationEo.getSkuId() == null) continue;
            skuIdList.add(dirItemRelationEo.getSkuId());
        }
        return itemSkuRelationMap;
    }

    private List<Long> getDirIds(List<DirItemRelationEo> dirItemRelationEoList) {
        HashMap<Long, DirItemRelationEo> dirsItemsEoMap = new HashMap<Long, DirItemRelationEo>();
        for (DirItemRelationEo dirsItemsEo : dirItemRelationEoList) {
            if (dirsItemsEo.getDirId() == null) continue;
            dirsItemsEoMap.put(dirsItemsEo.getDirId(), dirsItemsEo);
        }
        ArrayList<Long> resultEos = new ArrayList<Long>();
        resultEos.addAll(dirsItemsEoMap.keySet());
        return resultEos;
    }

    private DirItemRelationEo queryDirItemRelationInfo(DirItemRelationEo dirItemRelationEo) {
        if (dirItemRelationEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        if (dirItemRelationEo.getItemId() == null && dirItemRelationEo.getSkuId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        return (DirItemRelationEo)this.dirItemRelationDas.selectOne((BaseEo)dirItemRelationEo);
    }

    private void saveShelfTask(ShelfTaskEo shelfTaskEo, ItemShelfReqDto itemShelfReqDto, OffItemReqDto offItemReqDto) {
        if (itemShelfReqDto != null && offItemReqDto == null) {
            ShelfTaskEo onQueryEos = this.getSameTimeEo(shelfTaskEo.getShelfTime());
            List eos = this.shelfTaskDas.select((BaseEo)onQueryEos);
            if (CollectionUtils.isEmpty((Collection)eos)) {
                ShelfTaskEo insertEo = this.getShelfTaskInsertEo(shelfTaskEo, itemShelfReqDto, null);
                JSONObject priceJson = new JSONObject();
                if (itemShelfReqDto.getPrice() != null || itemShelfReqDto.getPriceId() != null) {
                    priceJson.put("price", (Object)itemShelfReqDto.getPrice());
                    priceJson.put("priceId", (Object)itemShelfReqDto.getPriceId());
                }
                Long taskId = this.shelfSchedulerService.createShelfTask(insertEo, "\u5b9a\u65f6\u4e0a\u4e0b\u67b6\u4efb\u52a1\u521b\u5efa", "shelfTask", priceJson);
                insertEo.setTaskId(taskId);
                this.shelfTaskDas.insert((BaseEo)insertEo);
            } else {
                DtoHelper.dto2Eo((BaseVo)itemShelfReqDto, (BaseEo)onQueryEos);
                this.checkExistTask(onQueryEos);
                ShelfTaskEo insertEo = this.getShelfTaskInsertEo(shelfTaskEo, itemShelfReqDto, null);
                insertEo.setTaskId(((ShelfTaskEo)eos.get(0)).getTaskId());
                if (CollectionUtils.isNotEmpty(this.getAllowOrderTime(itemShelfReqDto))) {
                    insertEo.setAllowOrderTime(this.Date2JsonString(this.getAllowOrderTime(itemShelfReqDto), "yyyy-MM-dd HH:mm:ss"));
                }
                this.shelfTaskDas.insert((BaseEo)insertEo);
            }
        } else if (itemShelfReqDto == null && offItemReqDto != null) {
            ShelfTaskEo offQueryEos = this.getSameTimeEo(offItemReqDto.getOffTime());
            List eos = this.shelfTaskDas.select((BaseEo)offQueryEos);
            if (CollectionUtils.isEmpty((Collection)eos)) {
                ShelfTaskEo insertEo = this.getShelfTaskInsertEo(null, null, offItemReqDto);
                Long taskId = this.shelfSchedulerService.createShelfTask(insertEo, "\u5b9a\u65f6\u4e0a\u4e0b\u67b6\u4efb\u52a1\u521b\u5efa", "shelfTask", new JSONObject());
                insertEo.setTaskId(taskId);
                this.shelfTaskDas.insert((BaseEo)insertEo);
            } else {
                DtoHelper.dto2Eo((BaseVo)offItemReqDto, (BaseEo)offQueryEos);
                this.checkExistTask(offQueryEos);
                ShelfTaskEo insertEo = this.getShelfTaskInsertEo(null, null, offItemReqDto);
                insertEo.setTaskId(((ShelfTaskEo)eos.get(0)).getTaskId());
                this.shelfTaskDas.insert((BaseEo)insertEo);
            }
        }
    }

    private void updateItemStatus(List<Long> itemIds, Integer itemStatus) {
        for (Long id : itemIds) {
            ItemEo itemEo = ItemEo.newInstance();
            itemEo.setStatus(itemStatus);
            itemEo.setId(id);
            this.itemService.updateItem(itemEo);
        }
    }

    private void updateItemSkuStatus(Map<Long, List<Long>> itemSkuRelationMap, Integer status) {
        if (itemSkuRelationMap == null || itemSkuRelationMap.isEmpty()) {
            return;
        }
        List<Long> skuIdList = null;
        for (Long itemId : itemSkuRelationMap.keySet()) {
            skuIdList = itemSkuRelationMap.get(itemId);
            if (CollectionUtils.isEmpty(skuIdList)) {
                ItemSkuEo itemSkuEo = new ItemSkuEo();
                itemSkuEo.setItemId(itemId);
                itemSkuEo.setStatus(status);
                this.itemSkuDas.updateSelective((BaseEo)itemSkuEo);
                continue;
            }
            for (Long skuId : skuIdList) {
                ItemSkuEo itemSkuEo = new ItemSkuEo();
                itemSkuEo.setId(skuId);
                itemSkuEo.setStatus(status);
                this.itemSkuDas.updateSelective((BaseEo)itemSkuEo);
            }
        }
    }

    private void verifyDirItems(List<DirItemRelationEo> dirsItemsEos) {
        if (CollectionUtils.isEmpty(dirsItemsEos)) {
            ValidateException validateException = new ValidateException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
            validateException.addError("dirsItemsEos", "dirsItemsEos \u4e0d\u80fd\u4e3a\u7a7a");
            throw validateException;
        }
        for (DirItemRelationEo dirsItemsEo : dirsItemsEos) {
            ValidateException validateException = new ValidateException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
            if (dirsItemsEo == null) {
                validateException.addError("itemId", "itemId \u4e0d\u80fd\u4e3a\u7a7a");
                throw validateException;
            }
            if (dirsItemsEo.getItemId() != null && dirsItemsEo.getItemId() != 0L) continue;
            validateException.addError("itemId", "itemId \u4e0d\u80fd\u4e3a\u7a7a");
            throw validateException;
        }
    }

    private void verifyItemIds(List<Long> itemIds, List<Long> dirIds, List<Long> skuIds, Long taskId, String type) {
        List<ItemSkuEo> itemSkuEos;
        List<DirEo> directoryItemEos;
        Object shelfItemDto;
        boolean isExist;
        List<ItemEo> itemEos;
        if (CollectionUtils.isNotEmpty(itemIds) && (itemEos = this.itemService.queryItemByIds(itemIds)).size() != itemIds.size()) {
            for (Long id : itemIds) {
                isExist = false;
                for (ItemEo itemEo : itemEos) {
                    if (!id.equals(itemEo.getId())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                shelfItemDto = new ShelfItemDto();
                ((ShelfItemDto)((Object)shelfItemDto)).setItemId(id);
                ((ShelfItemDto)((Object)shelfItemDto)).setTaskId(taskId);
                this.updateShelfTaskStatus((ShelfItemDto)((Object)shelfItemDto), ShelfTaskStatusEnum.UNPROCESSED.getStatus(), type, ShelfTaskStatusEnum.FAIL.getStatus());
                throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), "itemId=" + id + "\u4e0d\u5b58\u5728");
            }
        }
        if (CollectionUtils.isNotEmpty(dirIds) && (directoryItemEos = this.directoryItemService.queryByIds(dirIds)).size() != dirIds.size()) {
            for (Long id : dirIds) {
                isExist = false;
                for (DirEo directoryItemEo : directoryItemEos) {
                    if (!id.equals(directoryItemEo.getId())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                shelfItemDto = new ShelfItemDto();
                ((ShelfItemDto)((Object)shelfItemDto)).setDirId(id);
                ((ShelfItemDto)((Object)shelfItemDto)).setTaskId(taskId);
                this.updateShelfTaskStatus((ShelfItemDto)((Object)shelfItemDto), ShelfTaskStatusEnum.UNPROCESSED.getStatus(), type, ShelfTaskStatusEnum.FAIL.getStatus());
                throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), "dirId=" + id + "\u4e0d\u5b58\u5728");
            }
        }
        if (CollectionUtils.isNotEmpty(skuIds) && (itemSkuEos = this.itemSkuService.queryItemSkuByIds(skuIds)).size() != skuIds.size()) {
            for (Long skuId : skuIds) {
                isExist = false;
                for (ItemSkuEo eo : itemSkuEos) {
                    if (!skuId.equals(eo.getId())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                shelfItemDto = new ShelfItemDto();
                ((ShelfItemDto)((Object)shelfItemDto)).setSkuId(skuId);
                ((ShelfItemDto)((Object)shelfItemDto)).setTaskId(taskId);
                this.updateShelfTaskStatus((ShelfItemDto)((Object)shelfItemDto), ShelfTaskStatusEnum.UNPROCESSED.getStatus(), type, ShelfTaskStatusEnum.FAIL.getStatus());
                throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), "skuId=" + skuId + "\u4e0d\u5b58\u5728");
            }
        }
    }

    private Map<Long, List<ItemAttributesEo>> getGroupItemIdAttributes(List<Long> itemIds, List<ItemAttributesEo> itemAttributesEos) {
        HashMap<Long, List<ItemAttributesEo>> divisionItemAttributesMap = new HashMap<Long, List<ItemAttributesEo>>();
        for (Long itemId : itemIds) {
            ArrayList<ItemAttributesEo> itemAttributes = new ArrayList<ItemAttributesEo>();
            for (ItemAttributesEo itemAttributesEo : itemAttributesEos) {
                if (!itemAttributesEo.getItemId().equals(itemId)) continue;
                itemAttributes.add(itemAttributesEo);
            }
            divisionItemAttributesMap.put(itemId, itemAttributes);
        }
        return divisionItemAttributesMap;
    }

    private void autoShelfProcess(ItemShelfReqDto itemShelfReqDto) {
        List shelfTimeDetailDtoList = itemShelfReqDto.getShelfTimeReqDto().getShelfTimeDetailReqDtoList();
        ShelfTaskEo shelfTaskEo = ShelfTaskEo.newInstance();
        for (ShelfTimeDetailReqDto dto : shelfTimeDetailDtoList) {
            Calendar calendar;
            if (dto.getOnShelfTime() != null) {
                calendar = Calendar.getInstance();
                calendar.setTime(dto.getOnShelfTime());
                calendar.set(14, 0);
                dto.setOnShelfTime(calendar.getTime());
                if (CollectionUtils.isNotEmpty((Collection)dto.getAllowOrderTimeReqDtoList()) && dto.getOnShelfTime().after(((AllowOrderTimeReqDto)dto.getAllowOrderTimeReqDtoList().get(0)).getStartTime())) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":\u8bf7\u68c0\u67e5\u5b9a\u65f6\u4efb\u52a1\u4e0a\u67b6\u65f6\u95f4\u4e0e\u5f00\u59cb\u4e0b\u5355\u65f6\u95f4" + itemShelfReqDto.getItemId());
                }
                shelfTaskEo.setShelfTime(dto.getOnShelfTime());
                shelfTaskEo.setStatus(ShelfTaskStatusEnum.UNPROCESSED.getStatus());
                shelfTaskEo.setType(ShelfTaskTypeEnum.ON.getType());
                this.saveShelfTask(shelfTaskEo, itemShelfReqDto, null);
            } else if (CollectionUtils.isNotEmpty((Collection)dto.getAllowOrderTimeReqDtoList())) {
                shelfTaskEo.setShelfTime(DateUtil.addMinutes((Date)((AllowOrderTimeReqDto)dto.getAllowOrderTimeReqDtoList().get(0)).getStartTime(), (int)-1));
                shelfTaskEo.setStatus(ShelfTaskStatusEnum.UNPROCESSED.getStatus());
                shelfTaskEo.setType(ShelfTaskTypeEnum.ON.getType());
                this.saveShelfTask(shelfTaskEo, itemShelfReqDto, null);
            } else {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":\u8bf7\u68c0\u67e5\u5b9a\u65f6\u4efb\u52a1\u4e0a\u67b6\u65f6\u95f4" + itemShelfReqDto.getItemId());
            }
            if (dto.getOffShelfTime() != null) {
                calendar = Calendar.getInstance();
                calendar.setTime(dto.getOffShelfTime());
                calendar.set(14, 0);
                dto.setOffShelfTime(calendar.getTime());
                if (CollectionUtils.isNotEmpty((Collection)dto.getAllowOrderTimeReqDtoList())) {
                    List allowOrderTimeReqDtos = dto.getAllowOrderTimeReqDtoList();
                    if (dto.getOffShelfTime().before(((AllowOrderTimeReqDto)allowOrderTimeReqDtos.get(allowOrderTimeReqDtos.size() - 1)).getEndTime())) {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":\u8bf7\u68c0\u67e5\u5b9a\u65f6\u4efb\u52a1\u4e0b\u67b6\u65f6\u95f4\u4e0e\u7ed3\u675f\u4e0b\u5355\u65f6\u95f4" + itemShelfReqDto.getItemId());
                    }
                }
                shelfTaskEo.setShelfTime(dto.getOffShelfTime());
                shelfTaskEo.setStatus(ShelfTaskStatusEnum.UNPROCESSED.getStatus());
                shelfTaskEo.setType(ShelfTaskTypeEnum.OFF.getType());
                this.saveShelfTask(shelfTaskEo, itemShelfReqDto, null);
                continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)dto.getAllowOrderTimeReqDtoList())) continue;
            List allowOrderTimeReqDtos = dto.getAllowOrderTimeReqDtoList();
            shelfTaskEo.setShelfTime(DateUtil.addMinutes((Date)((AllowOrderTimeReqDto)allowOrderTimeReqDtos.get(allowOrderTimeReqDtos.size() - 1)).getEndTime(), (int)1));
            shelfTaskEo.setStatus(ShelfTaskStatusEnum.UNPROCESSED.getStatus());
            shelfTaskEo.setType(ShelfTaskTypeEnum.OFF.getType());
            this.saveShelfTask(shelfTaskEo, itemShelfReqDto, null);
        }
    }

    private void updateShelfTaskStatus(ShelfItemDto shelfItemDto, Integer oldStatus, String type, Integer newStatus) {
        ShelfTaskEo shelfTaskEo = ShelfTaskEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfItemDto, (BaseEo)shelfTaskEo);
        shelfTaskEo.setStatus(oldStatus);
        shelfTaskEo.setType(type);
        List shelfTaskEoList = this.shelfTaskDas.select((BaseEo)shelfTaskEo);
        if (CollectionUtils.isNotEmpty((Collection)shelfTaskEoList)) {
            for (ShelfTaskEo eo : shelfTaskEoList) {
                eo.setStatus(newStatus);
                this.shelfTaskDas.updateSelective((BaseEo)eo);
            }
        }
    }

    private List<AllowOrderTimeReqDto> getAllowOrderTime(ItemShelfReqDto itemShelfReqDto) {
        List shelfTimeDetailReqDtos = itemShelfReqDto.getShelfTimeReqDto().getShelfTimeDetailReqDtoList();
        ArrayList<AllowOrderTimeReqDto> allowOrderTimeReqDtoList = new ArrayList<AllowOrderTimeReqDto>();
        for (ShelfTimeDetailReqDto shelfTimeDetailReqDto : shelfTimeDetailReqDtos) {
            if (!CollectionUtils.isNotEmpty((Collection)shelfTimeDetailReqDto.getAllowOrderTimeReqDtoList())) continue;
            allowOrderTimeReqDtoList.addAll(shelfTimeDetailReqDto.getAllowOrderTimeReqDtoList());
        }
        return allowOrderTimeReqDtoList;
    }

    private String Date2JsonString(Object object, String format) {
        return JSON.toJSONStringWithDateFormat((Object)object, (String)format, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    private void checkExistTask(ShelfTaskEo shelfTaskEo) {
        if (this.shelfTaskDas.count((BaseEo)shelfTaskEo) > 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.TASK_EXISTS.getCode(), ItemExceptionCode.TASK_EXISTS.getMsg());
        }
    }

    private ShelfTaskEo getSameTimeEo(Date shelfTime) {
        ShelfTaskEo queryEos = ShelfTaskEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"shelf_time", (Object)new DateTime((Object)shelfTime).toString("yyyy-MM-dd HH:mm:ss")));
        queryEos.setSqlFilters(sqlFilters);
        return queryEos;
    }

    private ShelfTaskEo getShelfTaskInsertEo(ShelfTaskEo shelfTaskEo, ItemShelfReqDto itemShelfReqDto, OffItemReqDto offItemReqDto) {
        ShelfTaskEo insertEo = ShelfTaskEo.newInstance();
        if (itemShelfReqDto != null && offItemReqDto == null) {
            DtoHelper.dto2Eo((BaseVo)itemShelfReqDto, (BaseEo)insertEo);
            insertEo.setShelfTime(shelfTaskEo.getShelfTime());
            insertEo.setStatus(shelfTaskEo.getStatus());
            insertEo.setType(shelfTaskEo.getType());
            if (CollectionUtils.isNotEmpty(this.getAllowOrderTime(itemShelfReqDto))) {
                insertEo.setAllowOrderTime(this.Date2JsonString(this.getAllowOrderTime(itemShelfReqDto), "yyyy-MM-dd HH:mm:ss"));
            }
        } else if (itemShelfReqDto == null && offItemReqDto != null) {
            DtoHelper.dto2Eo((BaseVo)offItemReqDto, (BaseEo)insertEo);
            insertEo.setShelfTime(offItemReqDto.getOffTime());
            insertEo.setStatus(ShelfTaskStatusEnum.UNPROCESSED.getStatus());
            insertEo.setType(ShelfTaskTypeEnum.OFF.getType());
        }
        return insertEo;
    }

    private void onShelfCheckSubItemStatus(List<ItemShelfReqDto> onShelfDtoList) {
        if (CollectionUtils.isEmpty(onShelfDtoList)) {
            return;
        }
        LinkedHashSet<Long> itemIdList = new LinkedHashSet<Long>();
        for (ItemShelfReqDto itemShelfReqDto : onShelfDtoList) {
            itemIdList.add(itemShelfReqDto.getItemId());
        }
        for (Long itemId : itemIdList) {
            List itemBundleRelationEoList;
            ItemBundleRelationEo itemBundleRelationEo = new ItemBundleRelationEo();
            itemBundleRelationEo.setItemId(itemId);
            if (this.itemBundleRelationDas.count((BaseEo)itemBundleRelationEo) == 0 || CollectionUtils.isEmpty((Collection)(itemBundleRelationEoList = this.itemBundleRelationDas.select((BaseEo)itemBundleRelationEo)))) continue;
            for (ItemBundleRelationEo bundleRelationEo : itemBundleRelationEoList) {
                ItemEo itemEo;
                if (bundleRelationEo.getSubItemId() == null || (itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(bundleRelationEo.getSubItemId())) != null && ItemStatus.ITEM_ONSHELF.getStatus().equals(itemEo.getStatus())) continue;
                throw new ItemBusinessRuntimeException("10000", "\u7ec4\u5408\u5546\u54c1\u4e0a\u67b6\u5931\u8d25\uff0c\u5173\u8054\u7684\u5b50\u5546\u54c1\u672a\u4e0a\u67b6");
            }
        }
    }

    private void offShelfCheckItemStatus(List<OffItemReqDto> offItemReqDtoList) {
        if (CollectionUtils.isEmpty(offItemReqDtoList)) {
            return;
        }
        for (OffItemReqDto offItemReqDto : offItemReqDtoList) {
            List itemBundleRelationEoList;
            ItemBundleRelationEo itemBundleRelationEo = new ItemBundleRelationEo();
            itemBundleRelationEo.setSubItemId(offItemReqDto.getItemId());
            itemBundleRelationEo.setSubSkuId(offItemReqDto.getSkuId());
            if (this.itemBundleRelationDas.count((BaseEo)itemBundleRelationEo) == 0 || CollectionUtils.isEmpty((Collection)(itemBundleRelationEoList = this.itemBundleRelationDas.select((BaseEo)itemBundleRelationEo)))) continue;
            for (ItemBundleRelationEo bundleRelationEo : itemBundleRelationEoList) {
                ItemEo itemEo;
                if (bundleRelationEo.getItemId() == null || (itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(bundleRelationEo.getItemId())) == null || !ItemStatus.ITEM_ONSHELF.getStatus().equals(itemEo.getStatus())) continue;
                throw new ItemBusinessRuntimeException("10000", "\u5b50\u5546\u54c1\u4e0b\u67b6\u5931\u8d25\uff0c\u7ec4\u5408\u5546\u54c1\u662f\u4e0a\u67b6\u72b6\u6001");
            }
        }
    }

    @Override
    public boolean allOffShelf(Long itemId, Long sellerId) {
        return this.countShelf(itemId, sellerId) == 0;
    }

    @Override
    public boolean hasOnShelf(Long itemId) {
        return this.countShelf(itemId, null) > 0;
    }

    private int countShelf(Long itemId, Long sellerId) {
        ShelfEo shelfEo = ShelfEo.newInstance();
        shelfEo.setItemId(itemId);
        shelfEo.setSellerId(sellerId);
        shelfEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        return this.shelfDas.count((BaseEo)shelfEo);
    }

    @Override
    public void offAndDrop(List<ItemShelfReqDto> itemShelfReqDtoList) {
        ArrayList allShelfEos = Lists.newArrayList();
        itemShelfReqDtoList.forEach(itemShelfReqDto -> {
            ShelfEo shelfEo = new ShelfEo();
            shelfEo.setItemId(itemShelfReqDto.getItemId());
            shelfEo.setShopId(itemShelfReqDto.getShopId());
            shelfEo.setItemType(itemShelfReqDto.getItemType());
            shelfEo.setBusType(itemShelfReqDto.getBusType());
            List shelfEos = this.shelfDas.select((BaseEo)shelfEo);
            allShelfEos.addAll(shelfEos);
        });
        List<OffItemReqDto> offItemReqDtos = allShelfEos.stream().filter(shelfEo -> ItemStatus.ITEM_ONSHELF.getStatus().equals(shelfEo.getStatus())).map(shelfEo -> {
            OffItemReqDto offItemReqDto = new OffItemReqDto();
            offItemReqDto.setShopId(shelfEo.getShopId());
            offItemReqDto.setSkuId(shelfEo.getSkuId());
            offItemReqDto.setItemId(shelfEo.getItemId());
            offItemReqDto.setItemType(shelfEo.getItemType());
            offItemReqDto.setBusType(shelfEo.getBusType());
            return offItemReqDto;
        }).collect(Collectors.toList());
        this.offShelfItem(offItemReqDtos);
        logger.info("\u903b\u8f91\u5220\u9664\u4e0b\u67b6\u5546\u54c1={}", (Object)JSON.toJSONString((Object)allShelfEos));
        allShelfEos.forEach(shelfEo -> this.shelfDas.logicDelete((BaseEo)shelfEo));
    }

    @Override
    public void updateIndex(Long itemId) {
        ShelfEo shelfEo = ShelfEo.newInstance();
        shelfEo.setItemId(itemId);
        shelfEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        List shelfEos = this.shelfDas.select((BaseEo)shelfEo);
        if (CollectionUtils.isEmpty((Collection)shelfEos)) {
            logger.info("\u65e0\u4e0a\u67b6\u4e2d\u5546\u54c1\uff0c\u4e0d\u9700\u8981\u66f4\u65b0ES\u6570\u636e");
            return;
        }
        Map<Long, List<ShelfEo>> shelfMaps = shelfEos.stream().collect(Collectors.groupingBy(StdShelfEo::getSellerId));
    }
}

