/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemPriceEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemMediasReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemRelationSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRelationSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuCodeQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IBundleItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemMediasService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemPriceService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemTagService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemVersionService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemTagRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.doc.ItemSkuDoc;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemRelationSkuVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemBundleRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemTagRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemSkuServiceImpl
implements IItemSkuService {
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemTagRelationDas itemTagRelationDas;
    @Resource
    private ItemPriceDas itemPriceDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private IItemMediasService itemMediasService;
    @Resource
    private IItemPriceService itemPriceService;
    @Resource
    private IBundleItemService bundleItemService;
    @Resource
    private IItemVersionService iItemVersionService;
    @Resource
    private IItemTagService itemTagService;
    @Resource
    private IItemSearchService itemSearchService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer removeItemSku(ItemSkuEo itemSkuEo) {
        List itemSkuEoList = this.itemSkuDas.select((BaseEo)itemSkuEo);
        if (CollectionUtils.isEmpty((Collection)itemSkuEoList)) {
            return 0;
        }
        LinkedHashSet<Long> itemIdList = new LinkedHashSet<Long>();
        for (ItemSkuEo skuEo : itemSkuEoList) {
            this.itemSkuDas.delete((BaseEo)skuEo);
            ItemPriceEo itemPriceEo = ItemPriceEo.newInstance();
            itemPriceEo.setSkuId(skuEo.getId());
            this.itemPriceService.deleteItemPrice(itemPriceEo);
            ItemMediasEo itemMediasEo = ItemMediasEo.newInstance();
            itemMediasEo.setSkuId(skuEo.getId());
            this.itemMediasService.removeItemMedias(itemMediasEo);
            ItemTagRelationEo itemTagRelationEo = ItemTagRelationEo.newInstance();
            itemTagRelationEo.setSkuId(skuEo.getId());
            this.itemTagRelationDas.delete((BaseEo)itemTagRelationEo);
            itemIdList.add(skuEo.getItemId());
        }
        for (Long itemId : itemIdList) {
            this.iItemVersionService.addItemVersion(itemId);
        }
        return itemSkuEoList.size();
    }

    @Override
    @Transactional
    public void modifySku(ItemSkuEo itemSkuEo) {
        this.itemSkuDas.updateSelective((BaseEo)itemSkuEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBatchItemSku(List<ItemBundleReqDto> itemBundleReqDtos) {
        LinkedHashSet<Long> itemIdList = new LinkedHashSet<Long>();
        for (ItemBundleReqDto itemBundleReqDto : itemBundleReqDtos) {
            boolean exists;
            Long itemId;
            if (itemBundleReqDto.getId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":\u89c4\u683cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ItemSkuEo eo = (ItemSkuEo)this.itemSkuDas.selectByPrimaryKey(itemBundleReqDto.getId());
            if (eo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg() + "\u89c4\u683c\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isNotBlank((CharSequence)itemBundleReqDto.getCode())) {
                ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
                itemSkuEo.setCode(itemBundleReqDto.getCode());
                itemSkuEo.setTenantId(itemBundleReqDto.getTenantId());
                List itemSkuEos = this.itemSkuDas.select((BaseEo)itemSkuEo);
                if (CollectionUtils.isNotEmpty((Collection)itemSkuEos)) {
                    if (itemSkuEos.size() > 1) {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg());
                    }
                    if (itemBundleReqDto.getId() == null) {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg());
                    }
                    if (!((ItemSkuEo)itemSkuEos.get(0)).getId().equals(itemBundleReqDto.getId())) {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg());
                    }
                }
            }
            if ((itemId = eo.getItemId()) == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
            }
            if (this.itemDas.selectByPrimaryKey(itemId) == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg() + ":\u8be5\u89c4\u683c\u7684\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            itemIdList.add(itemId);
            ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
            DtoHelper.dto2Eo((BaseVo)itemBundleReqDto, (BaseEo)itemSkuEo);
            this.itemSkuDas.updateSelective((BaseEo)itemSkuEo);
            if (CollectionUtils.isNotEmpty((Collection)itemBundleReqDto.getPrices())) {
                ArrayList<Long> priceIdList = new ArrayList<Long>();
                for (ItemPriceReqDto itemPriceReqDto : itemBundleReqDto.getPrices()) {
                    ItemPriceEo itemPriceEo = ItemPriceEo.newInstance();
                    DtoHelper.dto2Eo((BaseVo)itemPriceReqDto, (BaseEo)itemPriceEo);
                    itemPriceEo.setSkuId(itemBundleReqDto.getId());
                    itemPriceEo.setItemId(itemId);
                    itemPriceEo.setInstanceId(eo.getInstanceId());
                    itemPriceEo.setTenantId(eo.getTenantId());
                    if (itemPriceReqDto.getId() == null) {
                        this.itemPriceDas.insert((BaseEo)itemPriceEo);
                    } else {
                        this.itemPriceDas.updateSelective((BaseEo)itemPriceEo);
                    }
                    priceIdList.add(itemPriceEo.getId());
                }
                ItemPriceEo queryPriceEo = new ItemPriceEo();
                queryPriceEo.setItemId(itemId);
                queryPriceEo.setSkuId(itemBundleReqDto.getId());
                queryPriceEo.setInstanceId(eo.getInstanceId());
                queryPriceEo.setTenantId(eo.getTenantId());
                List itemPriceEoList = this.itemPriceDas.select((BaseEo)queryPriceEo);
                for (ItemPriceEo priceEo : itemPriceEoList) {
                    exists = false;
                    for (Long priceId : priceIdList) {
                        if (!priceId.equals(priceEo.getId())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    this.itemPriceDas.delete((BaseEo)priceEo);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)itemBundleReqDto.getMedias())) {
                ArrayList<Long> mediaIdList = new ArrayList<Long>();
                for (ItemMediasReqDto itemMediasReqDto : itemBundleReqDto.getMedias()) {
                    ItemMediasEo itemMediasEo = ItemMediasEo.newInstance();
                    DtoHelper.dto2Eo((BaseVo)itemMediasReqDto, (BaseEo)itemMediasEo);
                    itemMediasEo.setSkuId(itemBundleReqDto.getId());
                    itemMediasEo.setItemId(itemId);
                    itemMediasEo.setInstanceId(eo.getInstanceId());
                    itemMediasEo.setTenantId(eo.getTenantId());
                    if (itemMediasReqDto.getId() == null) {
                        this.itemMediasDas.insert((BaseEo)itemMediasEo);
                    } else {
                        this.itemMediasDas.updateSelective((BaseEo)itemMediasEo);
                    }
                    mediaIdList.add(itemMediasEo.getId());
                }
                ItemMediasEo queryMediasEo = new ItemMediasEo();
                queryMediasEo.setItemId(itemId);
                queryMediasEo.setSkuId(itemBundleReqDto.getId());
                queryMediasEo.setInstanceId(eo.getInstanceId());
                queryMediasEo.setTenantId(eo.getTenantId());
                List itemMediasEoList = this.itemMediasDas.select((BaseEo)queryMediasEo);
                for (ItemMediasEo mediasEo : itemMediasEoList) {
                    exists = false;
                    for (Long mediaId : mediaIdList) {
                        if (!mediaId.equals(mediasEo.getId())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    this.itemMediasDas.delete((BaseEo)mediasEo);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)itemBundleReqDto.getTags())) continue;
            ArrayList<ItemTagRelationEo> itemTagRelationEos = new ArrayList<ItemTagRelationEo>();
            ItemTagRelationEo itemTagRelationEo = ItemTagRelationEo.newInstance();
            itemTagRelationEo.setSkuId(itemBundleReqDto.getId());
            List queryEos = this.itemTagRelationDas.select((BaseEo)itemTagRelationEo);
            if (CollectionUtils.isNotEmpty((Collection)queryEos)) {
                this.itemTagService.removeRelation(queryEos);
            }
            for (Long tag : itemBundleReqDto.getTags()) {
                ItemTagRelationEo itemTagEo = ItemTagRelationEo.newInstance();
                itemTagEo.setTagId(tag);
                itemTagEo.setItemId(itemId);
                itemTagEo.setSkuId(itemBundleReqDto.getId());
                itemTagEo.setInstanceId(eo.getInstanceId());
                itemTagEo.setTenantId(eo.getTenantId());
                itemTagRelationEos.add(itemTagEo);
            }
            this.itemTagService.relateToItem(itemTagRelationEos);
        }
        for (Long itemId : itemIdList) {
            this.iItemVersionService.addItemVersion(itemId);
        }
    }

    @Override
    @Transactional
    public Long saveSku(ItemSkuEo itemSkuEo) {
        if (itemSkuEo == null) {
            throw new ItemBusinessRuntimeException("\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.itemSkuDas.insert((BaseEo)itemSkuEo);
        return itemSkuEo.getId();
    }

    @Override
    @Transactional
    public List<ItemSkuEo> queryItemSku(ItemSkuEo itemSkuEo) {
        if (itemSkuEo != null) {
            return this.itemSkuDas.select((BaseEo)itemSkuEo);
        }
        return null;
    }

    @Override
    public ItemSkuEo getBySkuCode(String skuCode) {
        ItemSkuEo select = ItemSkuEo.newInstance();
        select.setCode(skuCode);
        return (ItemSkuEo)this.itemSkuDas.selectOne((BaseEo)select);
    }

    @Override
    public List<ItemSkuEo> queryByItemIds(List<Long> itemIds) {
        return this.itemSkuDas.selectByItemIds(itemIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchItemSku(List<ItemBundleReqDto> itemBundleReqDtos) {
        if (CollectionUtils.isEmpty(itemBundleReqDtos)) {
            throw new ItemBusinessRuntimeException("\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LinkedHashSet<Long> itemIdList = new LinkedHashSet<Long>();
        for (ItemBundleReqDto itemBundleReqDto : itemBundleReqDtos) {
            Long itemId;
            if (itemBundleReqDto.getInstanceId() == null || itemBundleReqDto.getTenantId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":instanceId\u6216tenantId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)itemBundleReqDto.getCode())) {
                ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
                itemSkuEo.setCode(itemBundleReqDto.getCode());
                itemSkuEo.setTenantId(itemBundleReqDto.getTenantId());
                List itemSkuEos = this.itemSkuDas.select((BaseEo)itemSkuEo);
                if (CollectionUtils.isNotEmpty((Collection)itemSkuEos)) {
                    if (itemSkuEos.size() > 1) {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg());
                    }
                    if (itemBundleReqDto.getId() == null) {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg());
                    }
                    if (!((ItemSkuEo)itemSkuEos.get(0)).getId().equals(itemBundleReqDto.getId())) {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg());
                    }
                }
            }
            if ((itemId = itemBundleReqDto.getItemId()) == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":itemId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
            DtoHelper.dto2Eo((BaseVo)itemBundleReqDto, (BaseEo)itemSkuEo);
            this.itemSkuDas.insert((BaseEo)itemSkuEo);
            itemIdList.add(itemId);
            if (CollectionUtils.isNotEmpty((Collection)itemBundleReqDto.getPrices())) {
                ArrayList<ItemPriceEo> itemPriceEoList = new ArrayList<ItemPriceEo>();
                for (ItemPriceReqDto itemPriceReqDto : itemBundleReqDto.getPrices()) {
                    ItemPriceEo itemPriceEo = ItemPriceEo.newInstance();
                    DtoHelper.dto2Eo((BaseVo)itemPriceReqDto, (BaseEo)itemPriceEo);
                    itemPriceEo.setSkuId(itemSkuEo.getId());
                    itemPriceEo.setItemId(itemId);
                    itemPriceEo.setInstanceId(itemBundleReqDto.getInstanceId());
                    itemPriceEo.setTenantId(itemBundleReqDto.getTenantId());
                    itemPriceEoList.add(itemPriceEo);
                }
                this.itemPriceService.addBatchItemPrice(itemPriceEoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)itemBundleReqDto.getMedias())) {
                ArrayList<ItemMediasEo> itemMediasEos = new ArrayList<ItemMediasEo>();
                for (ItemMediasReqDto itemMediasReqDto : itemBundleReqDto.getMedias()) {
                    ItemMediasEo itemMediasEo = ItemMediasEo.newInstance();
                    DtoHelper.dto2Eo((BaseVo)itemMediasReqDto, (BaseEo)itemMediasEo);
                    itemMediasEo.setSkuId(itemSkuEo.getId());
                    itemMediasEo.setItemId(itemId);
                    itemMediasEo.setInstanceId(itemBundleReqDto.getInstanceId());
                    itemMediasEo.setTenantId(itemBundleReqDto.getTenantId());
                    itemMediasEos.add(itemMediasEo);
                }
                this.itemMediasService.addBatchItemMedias(itemMediasEos);
            }
            if (!CollectionUtils.isNotEmpty((Collection)itemBundleReqDto.getTags())) continue;
            ArrayList<ItemTagRelationEo> itemTagRelationEos = new ArrayList<ItemTagRelationEo>();
            for (Long tag : itemBundleReqDto.getTags()) {
                ItemTagRelationEo itemTagEo = ItemTagRelationEo.newInstance();
                itemTagEo.setTagId(tag);
                itemTagEo.setItemId(itemId);
                itemTagEo.setSkuId(itemSkuEo.getId());
                itemTagEo.setInstanceId(itemBundleReqDto.getInstanceId());
                itemTagEo.setTenantId(itemBundleReqDto.getTenantId());
                itemTagRelationEos.add(itemTagEo);
            }
            this.itemTagService.relateToItem(itemTagRelationEos);
        }
        for (Long itemId : itemIdList) {
            this.iItemVersionService.addItemVersion(itemId);
        }
    }

    @Override
    public void removeItemSku(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.itemSkuDas.deleteBatchItemSku(ids);
    }

    @Override
    public List<ItemSkuEo> queryItemSkuByIds(List<Long> skuIds) {
        return this.itemSkuDas.selectItemSkuByIds(skuIds);
    }

    @Override
    public ItemSkuCodeQueryRespDto querySkuByCode(List<String> codes) {
        ItemSkuCodeQueryRespDto dto = new ItemSkuCodeQueryRespDto();
        if (CollectionUtils.isEmpty(codes)) {
            return dto;
        }
        HashSet<String> codeSet = new HashSet<String>(codes);
        ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(codeSet, (String)",")));
        itemSkuEo.setSqlFilters(sqlFilters);
        List itemSkuEos = this.itemSkuDas.select((BaseEo)itemSkuEo);
        ArrayList skuRepDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)itemSkuEos)) {
            DtoHelper.eoList2DtoList((Collection)itemSkuEos, (Collection)skuRepDtos, ItemSkuRespDto.class);
        }
        dto.setItemSkuRespDtos((List)skuRepDtos);
        List itemIds = itemSkuEos.stream().map(StdItemSkuEo::getItemId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemIds)) {
            HashSet itemIdSet = new HashSet(itemIds);
            ArrayList itemIdList = new ArrayList(itemIdSet);
            List itemEos = this.itemDas.selectByIds(itemIdList);
            ArrayList itemRespDtos = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)itemEos)) {
                DtoHelper.eoList2DtoList((Collection)itemEos, (Collection)itemRespDtos, ItemRespDto.class);
            }
            dto.setItemRespDtos((List)itemRespDtos);
        }
        return dto;
    }

    @Override
    public List<ItemSkuDoc> queryItemSku(Long itemId) {
        ArrayList<ItemSkuDoc> itemSkuDtos = new ArrayList<ItemSkuDoc>();
        ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
        itemSkuEo.setItemId(itemId);
        List itemSkuEos = this.itemSkuDas.select((BaseEo)itemSkuEo);
        CubeBeanUtils.copyCollection(itemSkuDtos, (Collection)itemSkuEos, ItemSkuDoc.class);
        for (ItemSkuDoc itemSkuDto : itemSkuDtos) {
            ItemMediasEo mediasEo = ItemMediasEo.newInstance();
            mediasEo.setItemId(itemId);
            mediasEo.setSkuId(itemSkuDto.getId());
            List<ItemMediasEo> itemMediasEos = this.itemMediasService.queryItemMedias(mediasEo);
            itemSkuDto.setItemMediasEos(itemMediasEos);
            ItemPriceEo priceEo = ItemPriceEo.newInstance();
            priceEo.setItemId(itemId);
            priceEo.setSkuId(itemSkuDto.getId());
            List<ItemPriceEo> itemPriceEos = this.itemPriceService.queryItemPrice(priceEo);
            itemSkuDto.setItemMediasEos(itemMediasEos);
            itemSkuDto.setItemPriceEos(itemPriceEos);
            ItemBundleRelationEo bundleItemEo = ItemBundleRelationEo.newInstance();
            bundleItemEo.setItemId(itemId);
            bundleItemEo.setSkuId(itemSkuDto.getId());
            List<ItemBundleRelationEo> bundleItemEos = this.bundleItemService.queryByList(bundleItemEo);
            itemSkuDto.setBundleItemEos(bundleItemEos);
        }
        return itemSkuDtos;
    }

    @Override
    public void updateAvailableOffline(Long skuId, Integer ifAvailableOffline) {
        ItemSkuEo itemSkuEo = (ItemSkuEo)this.itemSkuDas.selectByPrimaryKey(skuId);
        if (null == itemSkuEo) {
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u5546\u54c1sku\u4fe1\u606f");
        }
        ItemSkuEo itemSkuEoUpdate = new ItemSkuEo();
        itemSkuEoUpdate.setId(skuId);
        itemSkuEoUpdate.setIfAvailableOffline(ifAvailableOffline);
        this.itemSkuDas.updateSelective((BaseEo)itemSkuEoUpdate);
    }

    @Override
    public ItemSkuDetailRespDto getSkuDetail(ItemSkuReqDto itemSkuReqDto) {
        ItemSkuEo selectEo = ItemSkuEo.newInstance();
        BeanUtils.copyProperties((Object)itemSkuReqDto, (Object)selectEo);
        ItemSkuEo skuEo = (ItemSkuEo)this.itemSkuDas.selectOne((BaseEo)selectEo);
        if (null == skuEo) {
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u5546\u54c1sku\u4fe1\u606f");
        }
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(skuEo.getItemId());
        if (null == itemEo) {
            throw new BizException("\u627e\u4e0d\u5230sku\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f");
        }
        ItemSkuDetailRespDto itemSkuDetailRespDto = new ItemSkuDetailRespDto();
        itemSkuDetailRespDto.setSkuId(skuEo.getId());
        itemSkuDetailRespDto.setItemId(skuEo.getItemId());
        itemSkuDetailRespDto.setItemCode(itemEo.getCode());
        itemSkuDetailRespDto.setSkuCode(skuEo.getCode());
        itemSkuDetailRespDto.setBarCode(skuEo.getBarCode());
        return itemSkuDetailRespDto;
    }

    @Override
    public List<ItemSkuRespDto> queryBySkuCode(List<String> skuCodes) {
        ItemSkuEo selectEo = ItemSkuEo.newInstance();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"code", skuCodes));
        selectEo.setSqlFilters(sqlFilterList);
        List list = this.itemSkuDas.select((BaseEo)selectEo, Integer.valueOf(1), Integer.valueOf(skuCodes.size()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList<ItemSkuRespDto> dtos = new ArrayList<ItemSkuRespDto>();
            DtoHelper.eoList2DtoList((Collection)list, dtos, ItemSkuRespDto.class);
            return dtos;
        }
        return null;
    }

    @Override
    public List<ItemSkuRespDto> queryBySkuId(List<Long> skuIds) {
        ItemSkuEo selectEo = ItemSkuEo.newInstance();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", skuIds));
        selectEo.setSqlFilters(sqlFilterList);
        List list = this.itemSkuDas.select((BaseEo)selectEo, Integer.valueOf(1), Integer.valueOf(skuIds.size()));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<ItemSkuRespDto> dtos = new ArrayList<ItemSkuRespDto>();
            DtoHelper.eoList2DtoList((Collection)list, dtos, ItemSkuRespDto.class);
            return dtos;
        }
        return null;
    }

    @Override
    public PageInfo<ItemRelationSkuRespDto> queryItemRelationSku(ItemRelationSkuReqDto itemRelationSkuReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        PageHelper.startPage((int)pageNum, (int)pageSize, (boolean)true);
        ArrayList itemRelationSkuRespDtos = new ArrayList();
        ItemRelationSkuVo itemRelationSkuVo = new ItemRelationSkuVo();
        List itemRelationSkuVos = this.itemSkuDas.queryItemRelationSku(itemRelationSkuVo);
        CubeBeanUtils.copyCollection(itemRelationSkuRespDtos, (Collection)itemRelationSkuVos, ItemRelationSkuRespDto.class);
        String skuIdArr = itemRelationSkuRespDtos.stream().map(dto -> String.valueOf(dto.getSkuId())).collect(Collectors.joining(","));
        ItemPriceEo itemPriceEo = ItemPriceEo.newInstance();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)skuIdArr)) {
            sqlFilterList.add(SqlFilter.in((String)"skuId", (Object)skuIdArr.split(",")));
        }
        itemPriceEo.setSqlFilters(sqlFilterList);
        List itemPriceEos = this.itemPriceDas.select((BaseEo)itemPriceEo);
        Map<String, ItemPriceEo> map = itemPriceEos.stream().collect(Collectors.toMap(eo -> eo.getItemId() + "_" + eo.getSkuId() + "_" + eo.getPriceType(), n -> n));
        itemRelationSkuRespDtos.forEach(n -> {
            ItemPriceEo salePriceEo;
            ItemPriceEo priceEo = (ItemPriceEo)map.get(n.getItemCode() + "_" + n.getSkuId() + "_" + ItemPriceEnum.PRICE);
            if (null != priceEo) {
                n.setUnitPrice(priceEo.getPrice());
            }
            if (null != (salePriceEo = (ItemPriceEo)map.get(n.getItemCode() + "_" + n.getSkuId() + "_" + ItemPriceEnum.SALE_PRICE))) {
                n.setRetailPrice(salePriceEo.getPrice());
            }
        });
        pageInfo.setList(itemRelationSkuRespDtos);
        return pageInfo;
    }
}

