/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.ds.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.StorageChangeLogStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.StorageChangeLogTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageBranchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageInfoReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReturnReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageSubReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageDetailQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.vo.StorageChangeLogMessageVo;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemStorageService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.ItemStorageUtils;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.RedisLockUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.StorageChangeLogDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemStorageEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StorageChangeLogEo;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemStorageServiceImpl
implements IItemStorageService {
    private Logger logger = LoggerFactory.getLogger(ItemStorageServiceImpl.class);
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private ItemStorageDas itemStorageDas;
    @Resource
    private ItemStorageUtils itemStorageUtils;
    @Resource
    private StorageChangeLogDas storageChangeLogDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private RedisLockUtils redisLockUtils;
    @Resource
    private IShelfService shelfService;
    private String todo = "todo";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long operatingItemStorage(ItemStorageReqDto itemStorageReqDto) {
        return this.operatingItemStorageNoValidSelf(itemStorageReqDto);
    }

    Long operatingItemStorageNoValidSelf(ItemStorageReqDto itemStorageReqDto) {
        boolean redisResult;
        this.logger.info("\u5e93\u5b58\u53c2\u6570{}", JSON.toJSON((Object)itemStorageReqDto));
        this.checkInstanceIdAndTenantId((BaseReqDto)itemStorageReqDto);
        if (itemStorageReqDto == null || itemStorageReqDto.getSkuId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        if (itemStorageReqDto.getBalance() == null || itemStorageReqDto.getBalance().equals(0L)) {
            return null;
        }
        ItemStorageEo itemInsertEo = ItemStorageEo.newInstance((Map)itemStorageReqDto.getExtFields());
        ItemStorageEo itemStorageEo = ItemStorageEo.newInstance((Map)itemStorageReqDto.getExtFields());
        ItemSkuEo itemSkuEo = (ItemSkuEo)this.itemSkuDas.selectByPrimaryKey(itemStorageReqDto.getSkuId());
        itemStorageEo.setItemId(itemSkuEo.getItemId());
        itemStorageEo.setShelfId(Long.valueOf(0L));
        itemStorageEo.setShopId(itemStorageReqDto.getShopId());
        itemStorageEo.setSkuId(itemStorageReqDto.getSkuId());
        BeanUtils.copyProperties((Object)itemStorageEo, (Object)itemInsertEo);
        ItemStorageEo result = (ItemStorageEo)this.itemStorageDas.selectOne((BaseEo)itemStorageEo);
        if (result == null) {
            if (itemStorageReqDto.getBalance() < 0L) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
            itemInsertEo.setAppending(Long.valueOf(0L));
            itemInsertEo.setAllocated(Long.valueOf(0L));
            itemInsertEo.setBalance(Long.valueOf(0L));
            itemInsertEo.setInstanceId(itemStorageReqDto.getInstanceId());
            itemInsertEo.setTenantId(itemStorageReqDto.getTenantId());
            this.itemStorageDas.insert((BaseEo)itemInsertEo);
            result = (ItemStorageEo)this.itemStorageDas.selectOne((BaseEo)itemStorageEo);
            redisResult = this.itemStorageUtils.addItemStorage(itemStorageReqDto.getShopId(), itemStorageReqDto.getSkuId(), itemStorageReqDto.getBalance());
        } else {
            Long balance = itemStorageReqDto.getBalance();
            if (balance < 0L) {
                redisResult = this.itemStorageUtils.subItemStorage(result.getShopId(), result.getSkuId(), balance);
                if (!redisResult) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
                }
            } else {
                redisResult = this.itemStorageUtils.addItemStorage(result.getShopId(), result.getSkuId(), balance);
            }
        }
        if (!redisResult) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_OPERATING_ERROR);
        }
        StorageChangeLogEo changeLogEo = new StorageChangeLogEo();
        changeLogEo.setShelfId(Long.valueOf(0L));
        changeLogEo.setShopId(itemStorageReqDto.getShopId());
        changeLogEo.setItemId(itemSkuEo.getItemId());
        changeLogEo.setSkuId(itemSkuEo.getId());
        if (StringUtils.isEmpty((CharSequence)itemStorageReqDto.getOrderNo())) {
            changeLogEo.setOrderNo("ST" + IdGenrator.nextId((long)0L, (long)0L));
        }
        changeLogEo.setStatus(StorageChangeLogStatusEnum.CHANGE_BALANCE.getStatus());
        changeLogEo.setPreemptionTime(new Date());
        changeLogEo.setActivity(itemStorageReqDto.getActivity());
        itemStorageEo.setPresell(itemStorageReqDto.getPresell());
        changeLogEo.setInstanceId(itemStorageReqDto.getInstanceId());
        changeLogEo.setTenantId(itemStorageReqDto.getTenantId());
        HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
        if (itemStorageReqDto.getInventoryEffectiveDate() != null) {
            map.put("inventory_effective_date", itemStorageReqDto.getInventoryEffectiveDate());
        }
        map.put("balance", itemStorageReqDto.getBalance());
        changeLogEo.setExtension(JSON.toJSONString(map));
        this.storageChangeLogDas.insert((BaseEo)changeLogEo);
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Long, String> params = new HashMap<Long, String>();
        params.put(changeLogEo.getId(), "");
        if (itemStorageReqDto.getInventoryEffectiveDate() != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            params.put(changeLogEo.getId(), simpleDateFormat.format(itemStorageReqDto.getInventoryEffectiveDate()));
        }
        ids.add(changeLogEo.getId());
        StorageChangeLogMessageVo storageChangeLogMessageVo = new StorageChangeLogMessageVo();
        storageChangeLogMessageVo.setChangeLogIdList(ids);
        storageChangeLogMessageVo.setChangType(StorageChangeLogTypeEnum.PREEMPTION_STORAGE.getStatus());
        storageChangeLogMessageVo.setParams(params);
        String messageStr = JSON.toJSONString((Object)storageChangeLogMessageVo);
        this.logger.info("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55mq\u53d1\u9001:{}", (Object)messageStr);
        this.commonsMqService.sendDelaySingleMessage("ITEM_STORAGE_CHANGE_LOG", (Object)messageStr, Long.valueOf(1L));
        return result.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subItemStorage(ItemStorageSubReqDto itemStorageSubReqDto) {
        this.checkInstanceIdAndTenantId((BaseReqDto)itemStorageSubReqDto);
        if (itemStorageSubReqDto == null || StringUtils.isBlank((CharSequence)itemStorageSubReqDto.getOrderNo()) || CollectionUtils.isEmpty((Collection)itemStorageSubReqDto.getItemList())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        for (ItemStorageInfoReqDto itemStorageInfoReqDto : itemStorageSubReqDto.getItemList()) {
            if (itemStorageInfoReqDto != null && itemStorageInfoReqDto.getSkuId() != null && itemStorageInfoReqDto.getNum() != null && itemStorageInfoReqDto.getNum() >= 0L) continue;
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(itemStorageSubReqDto.getOrderNo());
        storageChangeLogEo.setInstanceId(itemStorageSubReqDto.getInstanceId());
        storageChangeLogEo.setTenantId(itemStorageSubReqDto.getTenantId());
        if (this.storageChangeLogDas.count((BaseEo)storageChangeLogEo) > 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.ORDER_EXISTS);
        }
        ArrayList<Long> changeLogIdList = new ArrayList<Long>();
        HashMap<Long, String> params = new HashMap<Long, String>();
        for (ItemStorageInfoReqDto itemStorageInfoReqDto : itemStorageSubReqDto.getItemList()) {
            boolean subResult;
            ShelfEo shelfEo = new ShelfEo();
            shelfEo.setShopId(itemStorageInfoReqDto.getShopId());
            shelfEo.setSkuId(itemStorageInfoReqDto.getSkuId());
            shelfEo.setInstanceId(itemStorageSubReqDto.getInstanceId());
            shelfEo.setTenantId(itemStorageSubReqDto.getTenantId());
            shelfEo = (ShelfEo)this.shelfDas.selectOne((BaseEo)shelfEo);
            if (shelfEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.ITEM_OFF_SHELF);
            }
            ItemStorageEo itemStorageEo = new ItemStorageEo();
            itemStorageEo.setShelfId(shelfEo.getId());
            this.validDateFormat(itemStorageInfoReqDto, itemStorageEo);
            itemStorageEo.setInstanceId(shelfEo.getInstanceId());
            itemStorageEo.setTenantId(shelfEo.getTenantId());
            itemStorageEo = (ItemStorageEo)this.itemStorageDas.selectOne((BaseEo)itemStorageEo);
            if (itemStorageEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
            }
            if (StringUtils.isEmpty((CharSequence)itemStorageInfoReqDto.getInventoryEffectiveDate())) {
                subResult = this.itemStorageUtils.subItemStorage(shelfEo.getShopId(), shelfEo.getSkuId(), -itemStorageInfoReqDto.getNum().longValue());
            } else {
                ItemStorageServiceImpl.isValidDate(itemStorageInfoReqDto.getInventoryEffectiveDate());
                subResult = this.itemStorageUtils.subItemStorage(itemStorageInfoReqDto.getInventoryEffectiveDate(), shelfEo.getShopId(), shelfEo.getSkuId(), -itemStorageInfoReqDto.getNum().longValue());
            }
            if (!subResult) {
                this.rollbackItemStorage(itemStorageSubReqDto.getOrderNo(), itemStorageSubReqDto.getInstanceId(), itemStorageSubReqDto.getTenantId());
                throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
            }
            StorageChangeLogEo changeLogEo = new StorageChangeLogEo();
            changeLogEo.setShelfId(shelfEo.getId());
            changeLogEo.setShopId(itemStorageInfoReqDto.getShopId());
            changeLogEo.setChannelId(shelfEo.getChannelId());
            changeLogEo.setItemId(shelfEo.getItemId());
            changeLogEo.setSkuId(itemStorageInfoReqDto.getSkuId());
            changeLogEo.setOrderNo(itemStorageSubReqDto.getOrderNo());
            changeLogEo.setAppending(itemStorageInfoReqDto.getNum());
            changeLogEo.setStatus(StorageChangeLogStatusEnum.PREEMPTION.getStatus());
            changeLogEo.setPreemptionTime(new Date());
            changeLogEo.setInstanceId(itemStorageSubReqDto.getInstanceId());
            changeLogEo.setTenantId(itemStorageSubReqDto.getTenantId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("inventory_effective_date", itemStorageInfoReqDto.getInventoryEffectiveDate());
            changeLogEo.setExtension(JSON.toJSONString(map));
            this.storageChangeLogDas.insert((BaseEo)changeLogEo);
            changeLogIdList.add(changeLogEo.getId());
            params.put(changeLogEo.getId(), itemStorageInfoReqDto.getInventoryEffectiveDate());
        }
        if (CollectionUtils.isNotEmpty(changeLogIdList)) {
            StorageChangeLogMessageVo storageChangeLogMessageVo = new StorageChangeLogMessageVo();
            storageChangeLogMessageVo.setChangeLogIdList(changeLogIdList);
            storageChangeLogMessageVo.setChangType(StorageChangeLogTypeEnum.PREEMPTION_STORAGE.getStatus());
            storageChangeLogMessageVo.setParams(params);
            String messageStr = JSON.toJSONString((Object)storageChangeLogMessageVo);
            this.logger.info("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55mq\u53d1\u9001:{}", (Object)messageStr);
            this.commonsMqService.sendDelaySingleMessage("ITEM_STORAGE_CHANGE_LOG", (Object)messageStr, Long.valueOf(1L));
        }
    }

    private void validDateFormat(ItemStorageInfoReqDto itemStorageInfoReqDto, ItemStorageEo itemStorageEo) {
        if (StringUtils.isNotEmpty((CharSequence)itemStorageInfoReqDto.getInventoryEffectiveDate())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                itemStorageEo.setInventoryEffectiveDate(sdf.parse(itemStorageInfoReqDto.getInventoryEffectiveDate()));
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new ItemBusinessRuntimeException(e.getMessage(), e.getMessage());
            }
        } else {
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.isNull((String)"inventory_effective_date"));
            itemStorageEo.setSqlFilters(sqlFilterList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnItemStorage(ItemStorageReturnReqDto itemStorageReturnReqDto) {
        this.checkInstanceIdAndTenantId((BaseReqDto)itemStorageReturnReqDto);
        if (itemStorageReturnReqDto == null || StringUtils.isBlank((CharSequence)itemStorageReturnReqDto.getOrderNo()) || CollectionUtils.isEmpty((Collection)itemStorageReturnReqDto.getItemList())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        for (ItemStorageInfoReqDto itemStorageInfoReqDto : itemStorageReturnReqDto.getItemList()) {
            if (itemStorageInfoReqDto == null || itemStorageInfoReqDto.getSkuId() == null || itemStorageInfoReqDto.getNum() == null || itemStorageInfoReqDto.getNum() < 0L) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
            if (!StringUtils.isNotEmpty((CharSequence)itemStorageInfoReqDto.getInventoryEffectiveDate())) continue;
            ItemStorageServiceImpl.isValidDate(itemStorageInfoReqDto.getInventoryEffectiveDate());
        }
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(itemStorageReturnReqDto.getOrderNo());
        storageChangeLogEo.setInstanceId(itemStorageReturnReqDto.getInstanceId());
        storageChangeLogEo.setTenantId(itemStorageReturnReqDto.getTenantId());
        if (this.storageChangeLogDas.count((BaseEo)storageChangeLogEo) == 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.ORDER_NOT_EXISTS);
        }
        ArrayList<Long> changeLogIdList = new ArrayList<Long>();
        HashMap<Long, String> params = new HashMap<Long, String>();
        for (ItemStorageInfoReqDto itemStorageInfoReqDto : itemStorageReturnReqDto.getItemList()) {
            ShelfEo shelfEo = new ShelfEo();
            shelfEo.setShopId(itemStorageInfoReqDto.getShopId());
            shelfEo.setSkuId(itemStorageInfoReqDto.getSkuId());
            shelfEo.setInstanceId(itemStorageReturnReqDto.getInstanceId());
            shelfEo.setTenantId(itemStorageReturnReqDto.getTenantId());
            shelfEo = (ShelfEo)this.shelfDas.selectOne((BaseEo)shelfEo);
            if (shelfEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.ITEM_OFF_SHELF);
            }
            ItemStorageEo itemStorageEo = new ItemStorageEo();
            itemStorageEo.setShelfId(shelfEo.getId());
            this.validDateFormat(itemStorageInfoReqDto, itemStorageEo);
            itemStorageEo.setInstanceId(shelfEo.getInstanceId());
            itemStorageEo.setTenantId(shelfEo.getTenantId());
            itemStorageEo = (ItemStorageEo)this.itemStorageDas.selectOne((BaseEo)itemStorageEo);
            if (itemStorageEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
            }
            StorageChangeLogEo queryEo = new StorageChangeLogEo();
            queryEo.setOrderNo(itemStorageReturnReqDto.getOrderNo());
            queryEo.setInstanceId(itemStorageReturnReqDto.getInstanceId());
            queryEo.setTenantId(itemStorageReturnReqDto.getTenantId());
            try {
                Object map;
                StorageChangeLogEo changeLogEo = (StorageChangeLogEo)this.storageChangeLogDas.selectOne((BaseEo)queryEo);
                if (changeLogEo == null) {
                    throw new BizException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg());
                }
                changeLogEo.setAppending(Long.valueOf(-itemStorageInfoReqDto.getNum().longValue()));
                changeLogEo.setStatus(StorageChangeLogStatusEnum.CANCEL.getStatus());
                changeLogEo.setPreemptionTime(new Date());
                if (StringUtils.isNotEmpty((CharSequence)changeLogEo.getExtension())) {
                    map = JSON.parseObject((String)changeLogEo.getExtension());
                    map.put("stage", this.todo);
                    changeLogEo.setExtension(JSON.toJSONString((Object)map));
                } else {
                    map = new HashMap();
                    map.put("stage", this.todo);
                    changeLogEo.setExtension(JSON.toJSONString((Object)map));
                }
                this.storageChangeLogDas.updateSelective((BaseEo)changeLogEo);
                changeLogIdList.add(changeLogEo.getId());
                params.put(changeLogEo.getId(), itemStorageInfoReqDto.getInventoryEffectiveDate());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        if (CollectionUtils.isNotEmpty(changeLogIdList)) {
            StorageChangeLogMessageVo storageChangeLogMessageVo = new StorageChangeLogMessageVo();
            storageChangeLogMessageVo.setChangeLogIdList(changeLogIdList);
            storageChangeLogMessageVo.setChangType(StorageChangeLogTypeEnum.RETURN_STORAGE.getStatus());
            storageChangeLogMessageVo.setParams(params);
            String messageStr = JSON.toJSONString((Object)storageChangeLogMessageVo);
            this.logger.info("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55mq\u53d1\u9001:{}", (Object)messageStr);
            this.commonsMqService.sendDelaySingleMessage("ITEM_STORAGE_CHANGE_LOG", (Object)messageStr, Long.valueOf(1L));
        }
        for (ItemStorageInfoReqDto itemStorageInfoReqDto : itemStorageReturnReqDto.getItemList()) {
            this.itemStorageUtils.addItemStorage(itemStorageInfoReqDto.getInventoryEffectiveDate(), itemStorageInfoReqDto.getShopId(), itemStorageInfoReqDto.getSkuId(), itemStorageInfoReqDto.getNum());
        }
    }

    @Override
    public List<ItemStorageQueryRespDto> queryBranchItemStorage(ItemStorageBranchQueryReqDto itemStorageBranchQueryReqDto) {
        if (CollectionUtils.isEmpty((Collection)itemStorageBranchQueryReqDto.getShelfList())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<ItemStorageQueryRespDto> itemStorageQueryRespDtoList = new ArrayList<ItemStorageQueryRespDto>();
        for (ShelfReqDto shelfReqDto : itemStorageBranchQueryReqDto.getShelfList()) {
            ItemStorageQueryRespDto itemStorageQueryRespDto = new ItemStorageQueryRespDto();
            itemStorageQueryRespDto.setShopId(shelfReqDto.getShopId());
            itemStorageQueryRespDto.setSkuId(shelfReqDto.getSkuId());
            ItemShelfRespDto itemShelfSkuRespDto = this.shelfService.queryItemShelf(shelfReqDto);
            if (itemShelfSkuRespDto != null && itemShelfSkuRespDto.getStatus().equals(ItemStatus.ITEM_ONSHELF.getStatus())) {
                itemStorageQueryRespDto.setItemShelfRespDto(itemShelfSkuRespDto);
                Long avaNum = this.itemStorageUtils.queryItemStorage(shelfReqDto.getShopId(), shelfReqDto.getSkuId());
                itemStorageQueryRespDto.setAvaNum(avaNum);
                itemStorageQueryRespDto.setItemShelfRespDto(itemShelfSkuRespDto);
            } else {
                itemShelfSkuRespDto = new ItemShelfRespDto();
                itemShelfSkuRespDto.setShopId(shelfReqDto.getShopId());
                itemShelfSkuRespDto.setSkuId(shelfReqDto.getSkuId());
                itemShelfSkuRespDto.setItemId(shelfReqDto.getItemId());
                itemShelfSkuRespDto.setBusType(shelfReqDto.getBusType());
                itemShelfSkuRespDto.setStatus(ItemStatus.ITEM_OFFSHELF.getStatus());
                itemStorageQueryRespDto.setAvaNum(Long.valueOf(0L));
            }
            itemStorageQueryRespDtoList.add(itemStorageQueryRespDto);
        }
        return itemStorageQueryRespDtoList;
    }

    @Override
    public List<ItemStorageQueryRespDto> queryItemStorage(List<ItemStorageQueryReqDto> itemStorageQueryReqDtoList, Long instanceId, Long tenantId) {
        if (CollectionUtils.isEmpty(itemStorageQueryReqDtoList)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<ItemStorageQueryRespDto> itemStorageQueryRespDtoList = new ArrayList<ItemStorageQueryRespDto>();
        Integer advanceSale = 1;
        for (ItemStorageQueryReqDto itemStorageQueryReqDto : itemStorageQueryReqDtoList) {
            if (CollectionUtils.isEmpty((Collection)itemStorageQueryReqDto.getSkuIds())) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_QUERY_SKU);
            }
            if (StringUtils.isNotEmpty((CharSequence)itemStorageQueryReqDto.getInventoryEffectiveDate())) {
                ItemStorageServiceImpl.isValidDate(itemStorageQueryReqDto.getInventoryEffectiveDate());
            }
            Long shopId = itemStorageQueryReqDto.getShopId();
            for (Long skuId : itemStorageQueryReqDto.getSkuIds()) {
                ItemStorageQueryRespDto itemStorageQueryRespDto = new ItemStorageQueryRespDto();
                itemStorageQueryRespDto.setShopId(shopId);
                itemStorageQueryRespDto.setSkuId(skuId);
                Long avaNum = this.itemStorageUtils.queryItemStorage(itemStorageQueryReqDto.getInventoryEffectiveDate(), shopId, skuId);
                if (avaNum == null) {
                    boolean lock = this.redisLockUtils.lock(shopId + "_" + skuId);
                    int cycle = 0;
                    while (!lock) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                        }
                        lock = this.redisLockUtils.lock(shopId + "_" + skuId);
                        if (cycle++ != 5) continue;
                    }
                    if (lock) {
                        ItemEo itemEo;
                        ItemSkuEo itemSkuEo;
                        avaNum = this.itemStorageUtils.queryItemStorage(itemStorageQueryReqDto.getInventoryEffectiveDate(), shopId, skuId);
                        if (avaNum == null && (itemSkuEo = (ItemSkuEo)this.itemSkuDas.selectByPrimaryKey(skuId)) != null && advanceSale.equals(itemSkuEo.getAdvanceSale()) && (StringUtils.isEmpty((CharSequence)itemSkuEo.getDiscontinuationDate()) || !itemSkuEo.getDiscontinuationDate().contains(itemStorageQueryReqDto.getInventoryEffectiveDate())) && (itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemSkuEo.getItemId())) != null && ItemStatus.ITEM_ONSHELF.getStatus().equals(itemEo.getStatus()) && itemSkuEo.getInventoryQuantity() > 0L) {
                            avaNum = itemSkuEo.getInventoryQuantity();
                            ItemStorageEo itemStorageEo = new ItemStorageEo();
                            itemStorageEo.setShopId(shopId);
                            itemStorageEo.setSkuId(skuId);
                            List itemStorageEoList = this.itemStorageDas.selectPage((BaseEo)itemStorageEo, Integer.valueOf(1), Integer.valueOf(1)).getList();
                            if (CollectionUtils.isNotEmpty((Collection)itemStorageEoList)) {
                                itemStorageEo = (ItemStorageEo)itemStorageEoList.get(0);
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                try {
                                    itemStorageEo.setInventoryEffectiveDate(sdf.parse(itemStorageQueryReqDto.getInventoryEffectiveDate()));
                                }
                                catch (ParseException e) {
                                    throw new ItemBusinessRuntimeException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef(yyyy-MM-dd)");
                                }
                                itemStorageEo.setBalance(itemSkuEo.getInventoryQuantity());
                                itemStorageEo.setId(null);
                                this.itemStorageDas.insert((BaseEo)itemStorageEo);
                                this.itemStorageUtils.addItemStorage(itemStorageEo.getInventoryEffectiveDate(), shopId, skuId, itemSkuEo.getInventoryQuantity());
                            }
                        }
                        this.redisLockUtils.releaseLock(shopId + "_" + skuId);
                    }
                }
                itemStorageQueryRespDto.setAvaNum(Long.valueOf(avaNum == null ? 0L : avaNum));
                itemStorageQueryRespDtoList.add(itemStorageQueryRespDto);
                itemStorageQueryRespDto.setInventoryEffectiveDate(itemStorageQueryReqDto.getInventoryEffectiveDate());
            }
        }
        return itemStorageQueryRespDtoList;
    }

    @Override
    public PageInfo<ItemStorageDetailQueryRespDto> queryItemStorageDetail(ItemStorageDetailQueryReqDto itemStorageDetailQueryReqDto, Integer pageNum, Integer pageSize) {
        if (itemStorageDetailQueryReqDto == null || itemStorageDetailQueryReqDto.getInstanceId() == null || itemStorageDetailQueryReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ItemStorageEo itemStorageEo = ItemStorageEo.newInstance((Map)itemStorageDetailQueryReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)itemStorageDetailQueryReqDto, (BaseEo)itemStorageEo);
        QueryParamUtils.fillQueryCreateStartTime(itemStorageDetailQueryReqDto.getCreateBeginTime(), (BaseEo)itemStorageEo);
        QueryParamUtils.fillQueryCreateEndTime(itemStorageDetailQueryReqDto.getCreateEndTime(), (BaseEo)itemStorageEo);
        QueryParamUtils.fillQueryUpdateStartTime(itemStorageDetailQueryReqDto.getUpdateBeginTime(), (BaseEo)itemStorageEo);
        QueryParamUtils.fillQueryUpdateEndTime(itemStorageDetailQueryReqDto.getUpdateEndTime(), (BaseEo)itemStorageEo);
        PageInfo eoPageInfo = this.itemStorageDas.selectPage((BaseEo)itemStorageEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList itemStorageDetailQueryRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), itemStorageDetailQueryRespDtoList, ItemStorageDetailQueryRespDto.class);
        for (ItemStorageDetailQueryRespDto detailDto : itemStorageDetailQueryRespDtoList) {
            detailDto.setAvaNum(this.itemStorageUtils.queryItemStorage(detailDto.getShopId(), detailDto.getSkuId()));
        }
        dtoPageInfo.setList(itemStorageDetailQueryRespDtoList);
        return dtoPageInfo;
    }

    @Override
    public ItemStorageDetailQueryRespDto queryItemStorageDetail(Long id, Long instanceId, Long tenantId) {
        if (instanceId == null || tenantId == null || id == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ItemStorageEo itemStorageEo = (ItemStorageEo)this.itemStorageDas.selectByPrimaryKey(id);
        ItemStorageDetailQueryRespDto itemStorageDetailQueryRespDto = new ItemStorageDetailQueryRespDto();
        if (itemStorageEo == null || !instanceId.equals(itemStorageEo.getInstanceId()) || !tenantId.equals(itemStorageEo.getTenantId())) {
            return itemStorageDetailQueryRespDto;
        }
        DtoHelper.eo2Dto((BaseEo)itemStorageEo, (BaseVo)itemStorageDetailQueryRespDto);
        itemStorageDetailQueryRespDto.setAvaNum(this.itemStorageUtils.queryItemStorage(itemStorageEo.getShopId(), itemStorageEo.getSkuId()));
        return itemStorageDetailQueryRespDto;
    }

    private void rollbackItemStorage(String orderNo, Long instanceId, Long tenantId) {
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(orderNo);
        storageChangeLogEo.setInstanceId(instanceId);
        storageChangeLogEo.setTenantId(tenantId);
        List storageChangeLogEoList = this.storageChangeLogDas.select((BaseEo)storageChangeLogEo);
        if (CollectionUtils.isEmpty((Collection)storageChangeLogEoList)) {
            return;
        }
        this.logger.info("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u56de\u6eda\u64cd\u4f5c\u5f00\u59cb");
        for (StorageChangeLogEo changeLogEo : storageChangeLogEoList) {
            this.itemStorageUtils.addItemStorage(changeLogEo.getShopId(), changeLogEo.getSkuId(), changeLogEo.getAppending());
        }
        this.logger.info("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u56de\u6eda\u64cd\u4f5c\u7ed3\u675f");
    }

    private void checkInstanceIdAndTenantId(BaseReqDto baseReqDto) {
        if (baseReqDto.getInstanceId() == null || baseReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
    }

    private static void isValidDate(String dateStr) {
        if (StringUtils.isEmpty((CharSequence)dateStr) || dateStr.length() > "yyyy-MM-dd".length()) {
            throw new ItemBusinessRuntimeException("\u9519\u8bef\u7684\u65e5\u671f\u683c\u5f0f(yyyy-MM-dd)");
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setLenient(false);
            simpleDateFormat.parse(dateStr);
        }
        catch (Exception e) {
            throw new ItemBusinessRuntimeException("\u9519\u8bef\u7684\u65e5\u671f\u683c\u5f0f(yyyy-MM-dd)");
        }
    }
}

