/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.distribution.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.DistributionFeeDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DistributionSetReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DistributionSetRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDistributionSetService;
import com.dtyunxi.yundt.cube.center.item.dao.distribution.das.DistributionSetDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.distribution.DistributionSetEo;
import com.google.api.client.util.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DistributionSetServiceImpl
implements IDistributionSetService {
    private Logger logger = LoggerFactory.getLogger(DistributionSetServiceImpl.class);
    @Resource
    private DistributionSetDas distributionSetDas;

    @Override
    public void saveBatch(List<DistributionSetReqDto> distributionSets) {
        if (CollectionUtils.isEmpty(distributionSets)) {
            this.logger.info("\u5206\u9500\u8bbe\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u7528\u4fdd\u5b58");
        }
        ArrayList news = Lists.newArrayList();
        Map<String, DistributionSetReqDto> dtoMap = distributionSets.stream().collect(Collectors.toMap(reqDto -> String.valueOf(reqDto.getShopId()) + reqDto.getSkuId(), e -> e, (e1, e2) -> e1));
        for (DistributionSetReqDto reqDto2 : dtoMap.values()) {
            DistributionSetEo distributionSetEo = new DistributionSetEo();
            distributionSetEo.setSkuId(reqDto2.getSkuId());
            distributionSetEo.setShopId(reqDto2.getShopId());
            List updates = this.distributionSetDas.select((BaseEo)distributionSetEo);
            if (CollectionUtils.isNotEmpty((Collection)updates)) {
                updates.forEach(updateEo -> {
                    CubeBeanUtils.copyProperties((Object)updateEo, (Object)reqDto2, (String[])new String[0]);
                    this.distributionSetDas.update((BaseEo)updateEo);
                });
                continue;
            }
            CubeBeanUtils.copyProperties((Object)distributionSetEo, (Object)reqDto2, (String[])new String[0]);
            news.add(distributionSetEo);
        }
        this.distributionSetDas.insertBatch((List)news);
    }

    @Override
    public void remove(Long itemId, Long shopId) {
        if (itemId == null && shopId == null) {
            return;
        }
        DistributionSetEo distributionSetEo = DistributionSetEo.newInstance();
        this.distributionSetDas.logicDelete((BaseEo)distributionSetEo);
    }

    @Override
    public List<DistributionFeeDto> calculateFee(List<ItemShelfRespDto> itemShelfDtos) {
        ArrayList feeDtos = Lists.newArrayList();
        itemShelfDtos.forEach(shelfDto -> {
            DistributionFeeDto feeDto;
            if (Integer.valueOf(1).equals(shelfDto.getDistribution()) && null != (feeDto = this.calculate(shelfDto.getShopId(), shelfDto.getItemId(), shelfDto.getSkuId(), shelfDto.getPrice()))) {
                feeDtos.add(feeDto);
            }
        });
        return feeDtos;
    }

    private DistributionFeeDto calculate(Long shopId, Long itemId, Long skuId, BigDecimal targetValue) {
        Integer point;
        BigDecimal amount;
        DistributionFeeDto distributionFeeDto = new DistributionFeeDto();
        DistributionSetEo distributionSetEo = DistributionSetEo.newInstance();
        distributionSetEo.setShopId(shopId);
        distributionSetEo.setSkuId(skuId);
        List list = this.distributionSetDas.select((BaseEo)distributionSetEo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.logger.info("shopId={},skuId={}\u5546\u54c1\u65e0\u5206\u9500\u914d\u7f6e\uff0c\u4e0d\u7528\u8ba1\u7b97\u5206\u9500\u4f63\u91d1", (Object)shopId, (Object)skuId);
            return null;
        }
        distributionSetEo = (DistributionSetEo)list.get(0);
        if (distributionSetEo.getValueType() == 1) {
            amount = distributionSetEo.getFirstLevelAmount().divide(BigDecimal.valueOf(100L)).multiply(targetValue).setScale(2, 1);
            point = distributionSetEo.getFirstLevelPoint().divide(BigDecimal.valueOf(100L)).multiply(targetValue).intValue();
        } else {
            amount = distributionSetEo.getFirstLevelAmount().setScale(2, 1);
            point = distributionSetEo.getFirstLevelPoint().intValue();
        }
        distributionFeeDto.setAmount(amount);
        distributionFeeDto.setPoint(point);
        distributionFeeDto.setItemId(itemId);
        distributionFeeDto.setShopId(shopId);
        distributionFeeDto.setSkuId(skuId);
        this.logger.info("\u5206\u9500\u4f63\u91d1\u8ba1\u7b97\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)distributionFeeDto));
        return distributionFeeDto;
    }

    @Override
    public List<DistributionSetRespDto> queryList(DistributionSetReqDto distributionSetReqDto) {
        DistributionSetEo distributionSetEo = DistributionSetEo.newInstance();
        CubeBeanUtils.copyProperties((Object)distributionSetEo, (Object)distributionSetReqDto, (String[])new String[0]);
        List distributionSetEos = this.distributionSetDas.select((BaseEo)distributionSetEo);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)distributionSetEos, DistributionSetRespDto.class);
        return list;
    }
}

