/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.point.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfIntegralAddReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfIntegralModifyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfIntegralReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfIntegralRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfIntegralService;
import com.dtyunxi.yundt.cube.center.item.dao.eo.point.ShelfIntegralEo;
import com.dtyunxi.yundt.cube.center.item.dao.point.das.ShelfIntegralDas;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="shelfIntegralService")
public class ShelfIntegralServiceImpl
implements IShelfIntegralService {
    private static Logger logger = LoggerFactory.getLogger(ShelfIntegralServiceImpl.class);
    @Resource
    private ShelfIntegralDas shelfIntegralDas;

    @Override
    public Long add(ShelfIntegralAddReqDto shelfIntegralReqDto) {
        ShelfIntegralEo shelfIntegralEo = ShelfIntegralEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfIntegralReqDto, (BaseEo)shelfIntegralEo);
        this.shelfIntegralDas.insert((BaseEo)shelfIntegralEo);
        return shelfIntegralEo.getId();
    }

    @Override
    public void modify(ShelfIntegralModifyReqDto shelfIntegralReqDto) {
        ShelfIntegralEo shelfIntegralEo = ShelfIntegralEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfIntegralReqDto, (BaseEo)shelfIntegralEo);
        this.shelfIntegralDas.update((BaseEo)shelfIntegralEo);
    }

    @Override
    public void modifySelective(ShelfIntegralModifyReqDto modifyReqDto) {
        ShelfIntegralEo shelfIntegralEo = ShelfIntegralEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)shelfIntegralEo);
        this.shelfIntegralDas.updateSelective((BaseEo)shelfIntegralEo);
    }

    @Override
    public PageInfo<ShelfIntegralRespDto> queryList(ShelfIntegralReqDto shelfIntegralReqDto, Integer pageNum, Integer pageSize) {
        ShelfIntegralEo shelfIntegralEo = ShelfIntegralEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfIntegralReqDto, (BaseEo)shelfIntegralEo);
        PageInfo pageInfo = this.shelfIntegralDas.selectPage((BaseEo)shelfIntegralEo, pageNum, pageSize);
        List resultList = pageInfo.getList();
        ArrayList shelfIntegralRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, shelfIntegralRespDtos, ShelfIntegralRespDto.class);
        }
        PageInfo pageInfoDto = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoDto);
        pageInfoDto.setList(shelfIntegralRespDtos);
        return pageInfoDto;
    }

    @Override
    public ShelfIntegralRespDto queryByShelfId(Long shelfId) {
        ShelfIntegralEo shelfIntegralEo = ShelfIntegralEo.newInstance();
        shelfIntegralEo.setShelfId(shelfId);
        ShelfIntegralEo result = (ShelfIntegralEo)this.shelfIntegralDas.selectOne((BaseEo)shelfIntegralEo);
        if (result == null) {
            return null;
        }
        ShelfIntegralRespDto shelfIntegralRespDto = new ShelfIntegralRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)shelfIntegralRespDto);
        return shelfIntegralRespDto;
    }

    @Override
    public ShelfIntegralRespDto queryBySkuInfo(Long skuId, Long shopId) {
        ShelfIntegralEo shelfIntegralEo = ShelfIntegralEo.newInstance();
        shelfIntegralEo.setSkuId(skuId);
        shelfIntegralEo.setShopId(shopId);
        ShelfIntegralEo result = (ShelfIntegralEo)this.shelfIntegralDas.selectOne((BaseEo)shelfIntegralEo);
        if (result == null) {
            return null;
        }
        ShelfIntegralRespDto shelfIntegralRespDto = new ShelfIntegralRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)shelfIntegralRespDto);
        return shelfIntegralRespDto;
    }

    @Override
    public List<ShelfIntegralRespDto> queryList(ShelfIntegralReqDto shelfIntegralReqDto) {
        ShelfIntegralEo shelfIntegralEo = ShelfIntegralEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfIntegralReqDto, (BaseEo)shelfIntegralEo);
        List resultList = this.shelfIntegralDas.select((BaseEo)shelfIntegralEo);
        ArrayList<ShelfIntegralRespDto> shelfIntegralRespDtos = new ArrayList<ShelfIntegralRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, shelfIntegralRespDtos, ShelfIntegralRespDto.class);
            return shelfIntegralRespDtos;
        }
        return null;
    }

    @Override
    public ShelfIntegralRespDto queryById(Long id, String filter) {
        ShelfIntegralEo shelfIntegralEo = ShelfIntegralEo.newInstance();
        shelfIntegralEo.setId(id);
        ShelfIntegralEo result = (ShelfIntegralEo)this.shelfIntegralDas.selectOne((BaseEo)shelfIntegralEo);
        ShelfIntegralRespDto shelfIntegralRespDto = new ShelfIntegralRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)shelfIntegralRespDto);
        return shelfIntegralRespDto;
    }
}

