/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.meta.api.dto.EntityDetailDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.AttributeDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.JavaCodeReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.response.JavaCodeRespDto;
import com.dtyunxi.yundt.cube.center.meta.biz.service.ICodeGenerationService;
import com.dtyunxi.yundt.cube.center.meta.biz.utils.FileUtil;
import com.dtyunxi.yundt.cube.center.meta.biz.utils.StringUtil;
import com.dtyunxi.yundt.cube.center.meta.dao.das.AttributeDas;
import com.dtyunxi.yundt.cube.center.meta.dao.das.DomainDas;
import com.dtyunxi.yundt.cube.center.meta.dao.das.EntityDas;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.AttributeEo;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.DomainEo;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.EntityEo;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Resource;
import org.apache.commons.io.output.StringBuilderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CodeGenerationServiceImpl
implements ICodeGenerationService {
    private static final Logger logger = LoggerFactory.getLogger(CodeGenerationServiceImpl.class);
    private String[] ftlList = new String[]{"api.ftl", "das.ftl", "addreqdto.ftl", "queryreqdto.ftl", "modifyreqdto.ftl", "respdto.ftl", "eo.ftl", "stdeo.ftl", "iapi.ftl", "iqueryapi.ftl", "iservice.ftl", "mapper.ftl", "queryapi.ftl", "rest.ftl", "service.ftl"};
    private String ftlDirectoryPath = null;
    private static final String[] excludeFiled = new String[]{"id", "instance_id", "update_time", "update_person", "create_time", "create_person", "dr", "tenant_id", "extension"};
    @Resource
    private EntityDas entityDas;
    @Resource
    private DomainDas domainDas;
    @Resource
    private AttributeDas attributeDas;

    @Override
    public List<JavaCodeRespDto> doGeneration(JavaCodeReqDto javaCodeReqDto) {
        return this.processExecParams(javaCodeReqDto);
    }

    @Override
    public List<JavaCodeRespDto> doGeneration(List<EntityDetailDto> entityDetailDtos) {
        return this.codeGenerationByExecParams(entityDetailDtos, true);
    }

    private List<JavaCodeRespDto> processExecParams(JavaCodeReqDto javaCodeReqDto) {
        List<EntityDetailDto> entityDetailDtos = this.getEntityDetail(javaCodeReqDto.getEntityIds());
        if (CollectionUtils.isEmpty(entityDetailDtos)) {
            throw new BizException("entity param error!");
        }
        if (this.ftlDirectoryPath == null) {
            this.ftlDirectoryPath = CodeGenerationServiceImpl.class.getClassLoader().getResource("templates/api.ftl").getPath();
        }
        Boolean isCutTableNamePrefix = false;
        if (javaCodeReqDto.getCutEntityPrefix() == null || !javaCodeReqDto.getCutEntityPrefix().equals(Boolean.TRUE) || !javaCodeReqDto.getCutEntityPrefix().equals(Boolean.FALSE)) {
            isCutTableNamePrefix = true;
        }
        return this.codeGenerationByExecParams(entityDetailDtos, isCutTableNamePrefix);
    }

    private List<EntityDetailDto> getEntityDetail(List<Long> entityIds) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return new ArrayList<EntityDetailDto>();
        }
        ArrayList<EntityDetailDto> entityDetailDtos = new ArrayList<EntityDetailDto>();
        for (Long entityId : entityIds) {
            EntityEo entityEo = (EntityEo)this.entityDas.selectByPrimaryKey(entityId);
            logger.info("\u67e5\u8be2\u5230\u7684\u5b9e\u4f53\u4fe1\u606f\uff1a" + entityEo.getCode());
            if (entityEo != null) {
                DomainEo domainEo = (DomainEo)this.domainDas.selectByPrimaryKey(entityEo.getDomainId());
                AttributeEo attributeEo = AttributeEo.newInstance();
                attributeEo.setEntityId(entityId);
                List attributeEos = this.attributeDas.select((BaseEo)attributeEo);
                if (domainEo != null && !CollectionUtils.isEmpty((Collection)attributeEos)) {
                    EntityDetailDto entityDetailDto = new EntityDetailDto();
                    DtoHelper.eo2Dto((BaseEo)entityEo, (BaseVo)entityDetailDto);
                    entityDetailDto.setDomainCode(domainEo.getCode());
                    entityDetailDto.setDomainName(domainEo.getName());
                    entityDetailDtos.add(entityDetailDto);
                    ArrayList attributeDtos = new ArrayList();
                    DtoHelper.eoList2DtoList((Collection)attributeEos, attributeDtos, AttributeDto.class);
                    entityDetailDto.setAttributeDtoList(attributeDtos);
                    continue;
                }
                throw new BizException("domain or attr is not exist!");
            }
            throw new BizException("entity is not exist!");
        }
        return entityDetailDtos;
    }

    private void init(String ftlDirectoryPath) {
        List<String> ftlNameList = this.getFtlNameList(ftlDirectoryPath);
        logger.info("jar\u6a21\u677f\u5217\u8868\u5927\u5c0f\uff1a" + ftlNameList.size());
    }

    private List<JavaCodeRespDto> codeGenerationByExecParams(List<EntityDetailDto> entityDetailDtos, Boolean isCutTableNamePrefix) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList dataList = new ArrayList();
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
        try {
            cfg.setClassForTemplateLoading(CodeGenerationServiceImpl.class, File.separator + "templates");
        }
        catch (Exception e) {
            resultMap.put("resultCode", 1);
            resultMap.put("resultMsg", "\u751f\u6210\u5931\u8d25");
            resultMap.put("data", dataList);
            throw new BizException(e.getMessage() + ":" + JSONObject.toJSONString(resultMap));
        }
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        ArrayList<JavaCodeRespDto> javaCodeRespDtos = new ArrayList<JavaCodeRespDto>();
        for (EntityDetailDto entityDetailDto : entityDetailDtos) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String projectName = entityDetailDto.getDomainCode();
            String basePackage = "src.main.java.com.dtyunxi." + projectName.replaceAll("-", ".");
            Map<String, String> commonParams = this.setCommonParams(projectName, basePackage);
            params.putAll(commonParams);
            String tableName = entityDetailDto.getCode();
            try {
                String tableComment = this.setEntityParams(params, entityDetailDto, isCutTableNamePrefix);
                logger.info("\u5f53\u524d\u5b9e\u4f53\u4e3a" + tableComment);
                Date currentTime = new Date();
                for (String ftlName : this.ftlList) {
                    Template temp = cfg.getTemplate(ftlName);
                    String sourceDir = this.getTlfAbsolutePath(ftlName, projectName, basePackage);
                    String classPath = this.getClassNameByTableName(ftlName, tableName, isCutTableNamePrefix);
                    JavaCodeRespDto javaCodeRespDto = new JavaCodeRespDto();
                    StringBuilderWriter bos = new StringBuilderWriter();
                    try {
                        SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");
                        SimpleDateFormat sdfFullTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        params.put("generateTime", sdfFullTime.format(currentTime));
                        params.put("generateYear", sdfYear.format(currentTime));
                        temp.process(params, (Writer)bos);
                        javaCodeRespDto.setContent(bos.toString());
                        javaCodeRespDto.setClassName(classPath);
                        javaCodeRespDto.setProjectName(projectName);
                        javaCodeRespDto.setPackagePath(sourceDir);
                        javaCodeRespDtos.add(javaCodeRespDto);
                    }
                    catch (TemplateException | IOException e) {
                        logger.info(" [Error] ReferenceError: " + e.getMessage());
                    }
                    bos.close();
                }
                logger.info("generate code success, tableName is: [" + tableName + "]");
            }
            catch (Exception e) {
                throw new BizException("generate code error, tableName is: [" + tableName + "]");
            }
        }
        return javaCodeRespDtos;
    }

    private String setEntityParams(Map<String, Object> params, EntityDetailDto entityDetailDto, Boolean isCutTableNamePrefix) {
        List<String> columnList = Arrays.asList(excludeFiled);
        String tableName = entityDetailDto.getCode();
        String tableComment = entityDetailDto.getName();
        String projectName = entityDetailDto.getDomainName();
        if (!params.containsKey("projectName")) {
            params.put("projectName", projectName);
        }
        if (tableComment == null) {
            tableComment = tableName;
        }
        if (!params.containsKey("tableComment")) {
            params.put("tableComment", tableComment);
        }
        String className = this.getClassName(tableName, isCutTableNamePrefix);
        if (!params.containsKey("className")) {
            params.put("className", className);
        }
        String resourceName = className.substring(0, 1).toLowerCase() + className.substring(1);
        if (!params.containsKey("resourceName")) {
            params.put("resourceName", resourceName);
        }
        if (!params.containsKey("tableName")) {
            params.put("tableName", tableName);
        }
        if (!params.containsKey("path")) {
            params.put("path", "/v1/" + className.toLowerCase() + "");
        }
        ArrayList<HashMap<String, Object>> newAttrsList = new ArrayList<HashMap<String, Object>>();
        for (AttributeDto attr : entityDetailDto.getAttributeDtoList()) {
            String name;
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            attrMap.put("column", attr.getCode());
            attrMap.put("name", attr.getCode());
            attrMap.put("comment", attr.getName());
            attrMap.put("value", attr.getDataType());
            if ("code".equals(attr.getCode())) {
                Integer attrLength = attr.getLength();
                String pattern = "^[\\u4e00-\\u9fa5]{1," + attrLength + "}$";
                attrMap.put("pattern", pattern);
            }
            if ((name = StringUtil.getStringValue(attrMap, "column")) != null && columnList.contains(name)) continue;
            newAttrsList.add(attrMap);
        }
        params.put("attrs", newAttrsList);
        return tableComment;
    }

    private Map<String, String> setCommonParams(String projectName, String basePackage) {
        HashMap<String, String> commonParams = new HashMap<String, String>();
        String packageName = basePackage.replaceAll("src\\.main\\.java\\.", "");
        String contextPrefix = packageName.replaceAll("\\.", "-");
        commonParams.put("contextPrefix", contextPrefix);
        commonParams.put("packageName", packageName.replaceAll("-", "\\."));
        commonParams.put("feignName", "${" + projectName.replaceAll("-", ".") + ".name:" + projectName + "}");
        commonParams.put("feignUrl", "${" + projectName.replaceAll("-", ".") + ".api:}");
        return commonParams;
    }

    private String getTlfAbsolutePath(String ftlName, String projectName, String basePackage) {
        String path = "";
        if ((ftlName = ftlName.substring(0, ftlName.indexOf("."))).equals("das") || ftlName.equals("mapper")) {
            path = path + projectName + "dao";
        } else if (ftlName.equals("eo")) {
            if (StringUtils.isEmpty((Object)projectName)) {
                path = path + projectName + "eo";
            } else {
                String cutCenter = projectName.replace("center", "");
                path = path + cutCenter + "eo";
            }
        } else if (ftlName.equals("stdeo")) {
            if (StringUtils.isEmpty((Object)projectName)) {
                path = path + projectName + "stdeo";
            } else {
                String cutCenter = projectName.replace("center", "");
                path = path + cutCenter + "stdeo";
            }
        } else {
            path = ftlName.equals("iapi") || ftlName.equals("addreqdto") || ftlName.equals("modifyreqdto") || ftlName.equals("queryreqdto") || ftlName.equals("respdto") || ftlName.equals("iqueryapi") ? path + projectName + "api" : (ftlName.equals("rest") ? path + projectName + "service" : path + projectName + "biz");
        }
        path = basePackage.startsWith("src") ? path + File.separator + basePackage.replaceAll("\\.", "\\" + File.separator) : path + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + basePackage.replaceAll("\\.", "\\" + File.separator);
        path = path + this.getPath(ftlName);
        return path;
    }

    private String getPath(String ftlName) {
        if (ftlName.equals("das")) {
            return File.separator + "dao" + File.separator + "das";
        }
        if (ftlName.equals("eo")) {
            return File.separator + "dao" + File.separator + "eo";
        }
        if (ftlName.equals("stdeo")) {
            return File.separator + "dao" + File.separator + "stdeo";
        }
        if (ftlName.equals("mapper")) {
            return File.separator + "dao" + File.separator + "mapper";
        }
        if (ftlName.equals("iservice")) {
            return File.separator + "biz" + File.separator + "service";
        }
        if (ftlName.equals("service")) {
            return File.separator + "biz" + File.separator + "service" + File.separator + "impl";
        }
        if (ftlName.equals("api")) {
            return File.separator + "biz" + File.separator + "apiimpl";
        }
        if (ftlName.equals("iapi")) {
            return File.separator + "api";
        }
        if (ftlName.equals("addreqdto")) {
            return File.separator + "api" + File.separator + "dto" + File.separator + "request";
        }
        if (ftlName.equals("modifyreqdto")) {
            return File.separator + "api" + File.separator + "dto" + File.separator + "request";
        }
        if (ftlName.equals("queryreqdto")) {
            return File.separator + "api" + File.separator + "dto" + File.separator + "request";
        }
        if (ftlName.equals("respdto")) {
            return File.separator + "api" + File.separator + "dto" + File.separator + "response";
        }
        if (ftlName.equals("iqueryapi")) {
            return File.separator + "api" + File.separator + "query";
        }
        if (ftlName.equals("queryapi")) {
            return File.separator + "biz" + File.separator + "apiimpl" + File.separator + "query";
        }
        if (ftlName.equals("rest")) {
            return File.separator + "svr" + File.separator + "rest";
        }
        return null;
    }

    private String getClassName(String tableName, Boolean isCutTableNamePrefix) {
        if (isCutTableNamePrefix.booleanValue()) {
            tableName = tableName.substring(tableName.indexOf("_") + 1);
        }
        String className = StringUtil.getCamelString(tableName);
        return className;
    }

    private String getClassNameByTableName(String ftlName, String tableName, Boolean isCutTableNamePrefix) {
        String className = this.getClassName(tableName, isCutTableNamePrefix);
        if ((ftlName = ftlName.substring(0, ftlName.indexOf("."))).equals("das")) {
            className = className + "Das.java";
        } else if (ftlName.equals("eo")) {
            className = className + "Eo.java";
        } else if (ftlName.equals("stdeo")) {
            className = className + "StdEo.java";
        } else if (ftlName.equals("mapper")) {
            className = className + "Mapper.java";
        } else if (ftlName.equals("iservice")) {
            className = "I" + className;
            className = className + "Service.java";
        } else if (ftlName.equals("service")) {
            className = className + "ServiceImpl.java";
        } else if (ftlName.equals("api")) {
            className = className + "ApiImpl.java";
        } else if (ftlName.equals("iapi")) {
            className = "I" + className;
            className = className + "Api.java";
        } else if (ftlName.equals("addreqdto")) {
            className = className + "AddReqDto.java";
        } else if (ftlName.equals("modifyreqdto")) {
            className = className + "ModifyReqDto.java";
        } else if (ftlName.equals("queryreqdto")) {
            className = className + "QueryReqDto.java";
        } else if (ftlName.equals("respdto")) {
            className = className + "RespDto.java";
        } else if (ftlName.equals("iqueryapi")) {
            className = "I" + className;
            className = className + "QueryApi.java";
        } else if (ftlName.equals("queryapi")) {
            className = className + "QueryApiImpl.java";
        } else if (ftlName.equals("rest")) {
            className = className + "Rest.java";
        } else {
            throw new RuntimeException("\u672a\u77e5\u7684ftl\u6587\u4ef6");
        }
        return className;
    }

    private List<String> getFtlNameList(String ftlDirectoryPath) {
        logger.info("ftl template file path is " + ftlDirectoryPath);
        ArrayList<String> fileNameList = new ArrayList();
        try {
            File ftlFilePath = new File(ftlDirectoryPath);
            if (ftlFilePath.isDirectory()) {
                List<String> fileList = FileUtil.getAllFileName(ftlDirectoryPath, new ArrayList<String>());
                if (!CollectionUtils.isEmpty(fileList)) {
                    int size = fileList.size();
                    for (int i = 0; i < size; ++i) {
                        String filePath = fileList.get(i);
                        if (!filePath.endsWith(".ftl")) continue;
                        String str = filePath.contains("/") ? "/" : "\\";
                        if (ftlDirectoryPath == null) {
                            ftlDirectoryPath = filePath.substring(0, filePath.lastIndexOf(str));
                            logger.info("ftlDirectoryPath is " + ftlDirectoryPath);
                        }
                        fileNameList.add(filePath.substring(filePath.lastIndexOf(str) + 1));
                    }
                }
            } else {
                fileNameList = this.getFtlNameByJar(ftlDirectoryPath);
            }
        }
        catch (Exception e) {
            throw new BizException(e.getMessage());
        }
        return fileNameList;
    }

    private List<String> getFtlNameByJar(String jarPath) {
        logger.info("\u901a\u8fc7jar\u83b7\u53d6ftlName" + jarPath);
        ArrayList<String> ftlNameList = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (entryName.contains("yundt-cube-center-metabiz") && entryName.endsWith(".jar")) {
                    this.getFtlNameList(jarFilePath + entryName);
                }
                if (!entryName.endsWith(".ftl")) continue;
                ftlNameList.add(entryName.substring(entryName.indexOf("/") + 1, entryName.length()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
        return ftlNameList;
    }
}

