/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.FuncDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.response.FuncRespDto;
import com.dtyunxi.yundt.cube.center.meta.biz.service.IFuncService;
import com.dtyunxi.yundt.cube.center.meta.dao.das.FuncDas;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.FuncEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FuncServiceImpl
implements IFuncService {
    @Resource
    private FuncDas funcDas;

    @Override
    public Long addFunc(FuncDto addReqDto) {
        FuncEo funcEo = new FuncEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)funcEo);
        this.funcDas.insert((BaseEo)funcEo);
        return funcEo.getId();
    }

    @Override
    public void modifyFunc(FuncDto modifyReqDto) {
        FuncEo funcEo = new FuncEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)funcEo);
        this.funcDas.updateSelective((BaseEo)funcEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeFunc(Long ids) {
        this.funcDas.logicDeleteById(ids);
    }

    @Override
    public FuncDto queryById(Long id) {
        FuncEo funcEo = (FuncEo)this.funcDas.selectByPrimaryKey(id);
        FuncDto funcDto = new FuncDto();
        DtoHelper.eo2Dto((BaseEo)funcEo, (BaseVo)funcDto);
        return funcDto;
    }

    @Override
    public PageInfo<FuncRespDto> queryByPage(FuncDto reqDto, Integer pageNum, Integer pageSize) {
        FuncEo funcEo = new FuncEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)funcEo);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getFuncName())) {
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.like((String)"func_name", (Object)("%" + reqDto.getFuncName() + "%")));
            funcEo.setSqlFilters((List)sqlFilters);
            funcEo.setFuncDesc(null);
        }
        PageInfo eoPageInfo = this.funcDas.selectPage((BaseEo)funcEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, FuncRespDto.class);
        dtoPageInfo.setList(dtoList);
        for (FuncRespDto funcRespDto : dtoList) {
            funcRespDto.setRequestParams(JSONObject.parseArray((String)funcRespDto.getRequestParam(), FuncRespDto.Param.class));
        }
        return dtoPageInfo;
    }
}

