/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.service.impl;

import com.dtyunxi.yundt.cube.center.meta.api.dto.FileDownloadDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.JavaCodeReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.JavaFileDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.response.JavaCodeRespDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.response.JavaFileGenerationResultDto;
import com.dtyunxi.yundt.cube.center.meta.biz.service.ICodeGenerationService;
import com.dtyunxi.yundt.cube.center.meta.biz.service.IFileDownloadService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="javaFileDownloadService")
public class JavaFileDownloadServiceImpl
implements IFileDownloadService<JavaFileDto> {
    @Autowired
    private ICodeGenerationService codeGenerationService;

    @Override
    public String fileType() {
        return ".zip";
    }

    @Override
    public void process(JavaFileDto javaFileDto, HttpServletResponse response, HttpServletRequest request) {
        FileDownloadDto fileDownloadDto = new FileDownloadDto();
        fileDownloadDto.setFileName(String.format("java%s", this.fileType()));
        fileDownloadDto.setJavaFileDto(javaFileDto);
        JavaCodeReqDto javaCodeReqDto = new JavaCodeReqDto();
        javaCodeReqDto.setEntityIds(javaFileDto.getEntityIds());
        List<JavaCodeRespDto> list = this.codeGenerationService.doGeneration(javaCodeReqDto);
        this.download(fileDownloadDto, response, request, () -> {
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
                for (JavaCodeRespDto javaFileGenerationResultDto : list) {
                    zipOutputStream.putNextEntry(new ZipEntry(this.getEntryName(javaFileGenerationResultDto)));
                    zipOutputStream.write(javaFileGenerationResultDto.getContent().getBytes());
                }
                zipOutputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn("\u538b\u7f29\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    private void testZipContents(List<JavaFileGenerationResultDto> list) {
        list.add(new JavaFileGenerationResultDto("user", "com.dtyunxi.a", "A.java", "public class A {\n    private String className;\n\n    private List<String> lines;\n\n    \n}"));
        list.add(new JavaFileGenerationResultDto("user", "com.dtyunxi.b", "B.java", "public class B {\n    private String className;\n\n    private List<String> lines;\n\n    \n}"));
        list.add(new JavaFileGenerationResultDto("user", "com.dtyunxi.b.a", "BA.java", "public class BA {\n    private String className;\n\n    private List<String> lines;\n\n    \n}"));
        list.add(new JavaFileGenerationResultDto("data", "com.dtyunxi.b", "B.java", "public class B {\n    private String className;\n\n    private List<String> lines;\n\n    \n}"));
        list.add(new JavaFileGenerationResultDto("data", "com.dtyunxi.b.a", "BA.java", "public class BA {\n    private String className;\n\n    private List<String> lines;\n\n    \n}"));
    }

    private String getEntryName(JavaCodeRespDto javaFileGenerationResultDto) {
        return String.format("%s%s%s%s%s", javaFileGenerationResultDto.getProjectName(), File.separator, javaFileGenerationResultDto.getPackagePath().replaceAll("\\.", String.format("\\%s", File.separator)), File.separator, javaFileGenerationResultDto.getClassName());
    }
}

