/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.service.impl;

import com.dtyunxi.yundt.cube.center.meta.api.dto.FileDownloadDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.MetaFileDto;
import com.dtyunxi.yundt.cube.center.meta.biz.service.ICodeBuilderService;
import com.dtyunxi.yundt.cube.center.meta.biz.service.IFileDownloadService;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="metaFileDownloadService")
public class MetaFileDownloadServiceImpl
implements IFileDownloadService<MetaFileDto> {
    @Autowired
    private ICodeBuilderService codeBuilderService;

    @Override
    public String fileType() {
        return ".json";
    }

    @Override
    public void process(MetaFileDto metaFileDto, HttpServletResponse response, HttpServletRequest request) {
        FileDownloadDto fileDownloadDto = new FileDownloadDto();
        fileDownloadDto.setFileName(String.format("meta%s", this.fileType()));
        fileDownloadDto.setMetaFileDto(metaFileDto);
        String metaFileResult = this.codeBuilderService.buildMeta(metaFileDto.getDomainId());
        this.download(fileDownloadDto, response, request, () -> {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                bufferedOutputStream.write(metaFileResult.getBytes());
                bufferedOutputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn("\u5143\u6570\u636e\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    private String testMetaContents() {
        return "[\n  {\n    \"ageSex\": {\n      \"age\": 0,\n      \"sex\": \"string\"\n    },\n    \"birthDay\": \"2020-02-04T04:02:57.911Z\",\n    \"id\": 0,\n    \"name\": \"string\",\n    \"priceList\": [\n      0\n    ],\n    \"prices\": [\n      0\n    ],\n    \"remarkList\": [\n      \"string\"\n    ],\n    \"remarks\": [\n      \"string\"\n    ],\n    \"testListDtoList\": [\n      {\n        \"address\": \"string\",\n        \"code\": 0\n      }\n    ],\n    \"testListDtos\": [\n      {\n        \"address\": \"string\",\n        \"code\": 0\n      }\n    ]\n  }\n]";
    }
}

