/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.DataExportReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.DataQueryReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.FilterDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.TableRelationDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.response.ColumnRespDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.response.TableRespDto;
import com.dtyunxi.yundt.cube.center.meta.biz.constants.FileConfig;
import com.dtyunxi.yundt.cube.center.meta.biz.service.ITableRelationService;
import com.dtyunxi.yundt.cube.center.meta.biz.service.ITableService;
import com.dtyunxi.yundt.cube.center.meta.biz.utils.FileUtil;
import com.dtyunxi.yundt.cube.center.meta.dao.ScriptGenerator;
import com.dtyunxi.yundt.cube.center.meta.dao.das.TableDas;
import com.dtyunxi.yundt.cube.center.meta.dao.db.DbConn;
import com.dtyunxi.yundt.cube.center.meta.dao.db.IDatabase;
import com.dtyunxi.yundt.cube.center.meta.dao.db.TableDao;
import com.dtyunxi.yundt.cube.center.meta.dao.vo2.TableDataVo;
import com.dtyunxi.yundt.cube.center.meta.dao.vo2.TableGroupVo;
import com.dtyunxi.yundt.cube.center.meta.dao.vo2.TableVo;
import com.dtyunxi.yundt.cube.center.meta.dao.xml.DataConfigXmlParser;
import com.github.pagehelper.PageInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TableServiceImpl
implements ITableService {
    private static Logger logger = LoggerFactory.getLogger(TableServiceImpl.class);
    @Resource
    private FileConfig fileConfig;
    @Resource
    private ITableRelationService tableRelationService;
    @Resource
    private TableDas tableDas;

    @Override
    public List<TableRespDto> queryByList() {
        List voList = this.tableDas.listTable();
        ArrayList<TableRespDto> dtoList = new ArrayList<TableRespDto>();
        voList.stream().forEach(vo -> {
            TableRespDto dto = new TableRespDto();
            CubeBeanUtils.copyProperties((Object)dto, (Object)vo, (String[])new String[0]);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public List<ColumnRespDto> queryColumnByTable(String tableName) {
        List voList = this.tableDas.listTableColumn(tableName);
        ArrayList<ColumnRespDto> dtoList = new ArrayList<ColumnRespDto>();
        voList.stream().forEach(vo -> {
            ColumnRespDto dto = new ColumnRespDto();
            CubeBeanUtils.copyProperties((Object)dto, (Object)vo, (String[])new String[0]);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public PageInfo<Map<String, Object>> queryDataByPage(DataQueryReqDto dataQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        try {
            Connection conn = DbConn.getConnection();
            IDatabase database = DbConn.getDatabase();
            TableDao tableDao = new TableDao();
            String tableName = dataQueryReqDto.getTableName();
            TableVo tableVo = tableDao.getTable(conn, database, tableName);
            if (tableVo == null) {
                throw new BizException("10002", "\u8868\u5173\u7cfb\u5b9a\u4e49\u53c2\u6570\u7f3a\u5931");
            }
            String whereCondition = null;
            List filters = dataQueryReqDto.getFilters();
            if (CollectionUtils.isNotEmpty((Collection)filters)) {
                StringBuilder sb = new StringBuilder().append("1=1");
                for (FilterDto filterDto : filters) {
                    String condition = filterDto.getColumn() + "='" + filterDto.getValue() + "'";
                    sb.append(" and ").append(condition);
                }
                whereCondition = sb.toString();
            }
            Integer startRow = (pageNum - 1) * pageSize;
            String limit = " limit " + startRow + ", " + pageSize;
            TableDataVo tableDataVo = tableDao.getTableData(conn, tableVo, whereCondition, limit);
            if (tableDataVo != null) {
                tableDataVo.dump2();
                pageInfo.setTotal((long)tableDataVo.totalCount);
                pageInfo.setList(tableDataVo.dataMapList);
                return pageInfo;
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return pageInfo;
    }

    @Override
    public List<Long> queryDataIdByList(DataQueryReqDto dataQueryReqDto) {
        List dataIdList = null;
        try {
            TableDataVo tableDataVo;
            Connection conn = DbConn.getConnection();
            IDatabase database = DbConn.getDatabase();
            TableDao tableDao = new TableDao();
            String tableName = dataQueryReqDto.getTableName();
            TableVo tableVo = tableDao.getTable(conn, database, tableName);
            if (tableVo == null) {
                throw new BizException("10002", "\u8868\u5173\u7cfb\u5b9a\u4e49\u53c2\u6570\u7f3a\u5931");
            }
            String whereCondition = null;
            List filters = dataQueryReqDto.getFilters();
            if (CollectionUtils.isNotEmpty((Collection)filters)) {
                StringBuilder sb = new StringBuilder().append("1=1");
                for (FilterDto filterDto : filters) {
                    String condition = filterDto.getColumn() + "='" + filterDto.getValue() + "'";
                    sb.append(" and ").append(condition);
                }
                whereCondition = sb.toString();
            }
            if ((tableDataVo = tableDao.getTableData(conn, tableVo, whereCondition, null)) != null) {
                tableDataVo.dump2();
                dataIdList = tableDataVo.dataIdList;
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return dataIdList;
    }

    @Override
    public void exportData(DataExportReqDto dataExportReqDto, HttpServletRequest request, HttpServletResponse response) {
        try {
            TableGroupVo tableGroup = null;
            String tableName = dataExportReqDto.getTableName();
            List dataIds = dataExportReqDto.getDataIds();
            TableRelationDto dto = this.tableRelationService.queryAll();
            if (dto != null) {
                try {
                    String content = dto.getRelationDef();
                    ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
                    DataConfigXmlParser parser = new DataConfigXmlParser();
                    Map tableGroupMap = parser.parseDoc((InputStream)in);
                    tableGroup = (TableGroupVo)tableGroupMap.get(tableName);
                }
                catch (Exception e) {
                    logger.error("\u89e3\u6790\u5173\u8054\u8868\u914d\u7f6e\u5931\u8d25", (Throwable)e);
                }
            }
            if (tableGroup == null) {
                tableGroup = new TableGroupVo();
                tableGroup.name = tableName;
            }
            ArrayList keyList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)dataIds)) {
                dataIds.stream().forEach(id -> keyList.add("" + id));
            } else {
                DataQueryReqDto dataQueryReqDto = new DataQueryReqDto();
                dataQueryReqDto.setTableName(tableName);
                List<Long> result = this.queryDataIdByList(dataQueryReqDto);
                if (CollectionUtils.isNotEmpty(result)) {
                    result.stream().forEach(id -> keyList.add("" + id));
                }
            }
            tableGroup.listKey = keyList;
            ScriptGenerator scriptGenerator = new ScriptGenerator();
            String scriptDelimiter = ";";
            String outputDir = this.fileConfig.DML_DIR;
            scriptGenerator.geneInsertScript(new TableGroupVo[]{tableGroup}, scriptDelimiter, outputDir);
            System.out.println("===> testing start..");
            System.out.println(scriptGenerator.insertSql);
            System.out.println("===> testing end");
            String fileName = tableGroup.name + ".sql";
            String sqlFilePath = this.fileConfig.DML_DIR + "/" + fileName;
            FileUtil.writeTxt(scriptGenerator.insertSql, sqlFilePath);
            File sqlFile = new File(sqlFilePath);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(sqlFilePath));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes()));
            response.addHeader("Content-Length", "" + sqlFile.length());
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.addHeader("Cache-Control", "no-cache");
            response.setContentType("application/octet-stream");
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }
}

