/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.utils;

import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.meta.biz.constants.FileConfig;
import com.dtyunxi.yundt.cube.center.meta.biz.utils.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OssUtil {
    private static Logger logger = LoggerFactory.getLogger(OssUtil.class);
    @Autowired(required=false)
    private IObjectStorageService objectStorageService;
    @Resource
    private FileConfig fileConfig;

    public String upload2OSS(File file, String fileName) {
        String url = "";
        try {
            byte[] buf = FileUtil.getBytesByFile(file.getAbsolutePath());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
            this.objectStorageService.put(this.fileConfig.OSS_BUCKET_NAME, fileName, (InputStream)byteArrayInputStream);
            url = this.fileConfig.OOS_DOWNLOAD_FILE_URL + "/" + fileName;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessRuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
        return url;
    }

    public String upload2OSS(File file, String subDir, String fileName) {
        String url = "";
        try {
            byte[] buf = FileUtil.getBytesByFile(file.getAbsolutePath());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
            String relativePath = subDir + "_" + fileName;
            String result = this.objectStorageService.put(this.fileConfig.OSS_BUCKET_NAME, subDir + "_" + fileName, (InputStream)byteArrayInputStream);
            url = this.fileConfig.OOS_DOWNLOAD_FILE_URL + "/" + relativePath;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessRuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
        return url;
    }
}

