/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.utils;

import com.dtyunxi.yundt.cube.center.meta.biz.utils.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUitl {
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);
    private static final int BUFFER = 512;
    private static final String SUFFIX = ".zip";

    public static List<File> getAllFile(File dirFile) {
        File[] files;
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : files = dirFile.listFiles()) {
            if (file.isFile()) {
                fileList.add(file);
                System.out.println("add file:" + file.getName());
                continue;
            }
            if (file.listFiles().length != 0) {
                fileList.addAll(ZipUitl.getAllFile(file));
                continue;
            }
            fileList.add(file);
            System.out.println("add empty dir:" + file.getName());
        }
        return fileList;
    }

    public static String getRelativePath(String dirPath, File file) {
        File dirFile = new File(dirPath);
        String relativePath = file.getName();
        while ((file = file.getParentFile()) != null && !file.equals(dirFile)) {
            relativePath = file.getName() + "/" + relativePath;
        }
        return relativePath;
    }

    public static File createFile(String destPath, String fileName) {
        String[] dirs = fileName.split("/");
        File file = new File(destPath);
        if (dirs.length > 1) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                file = new File(file, dirs[i]);
            }
            if (!file.exists()) {
                file.mkdirs();
                try {
                    System.out.println("mkdirs: " + file.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            file = new File(file, dirs[dirs.length - 1]);
            return file;
        }
        if (!file.exists()) {
            file.mkdirs();
            try {
                System.out.println("mkdirs: " + file.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        file = new File(file, dirs[0]);
        return file;
    }

    public static void compress(String dirPath) {
        int firstIndex = dirPath.indexOf("/");
        int lastIndex = dirPath.lastIndexOf("/");
        String zipFileName = dirPath.substring(0, firstIndex + 1) + dirPath.substring(lastIndex + 1);
        ZipUitl.compress(dirPath, zipFileName);
    }

    public static void compress(String dirPath, String zipFileName) {
        File dirFile = new File(dirPath);
        List<File> fileList = ZipUitl.getAllFile(dirFile);
        byte[] buffer = new byte[512];
        ZipEntry zipEntry = null;
        int readLength = 0;
        try {
            CheckedOutputStream cos = new CheckedOutputStream(new FileOutputStream(zipFileName), new CRC32());
            ZipOutputStream zos = new ZipOutputStream(cos);
            for (File file : fileList) {
                if (file.isFile()) {
                    zipEntry = new ZipEntry(ZipUitl.getRelativePath(dirPath, file));
                    zipEntry.setSize(file.length());
                    zipEntry.setTime(file.lastModified());
                    zos.putNextEntry(zipEntry);
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                    while ((readLength = ((InputStream)is).read(buffer, 0, 512)) != -1) {
                        zos.write(buffer, 0, readLength);
                    }
                    ((InputStream)is).close();
                    System.out.println("file compress:" + file.getCanonicalPath());
                    continue;
                }
                zipEntry = new ZipEntry(ZipUitl.getRelativePath(dirPath, file));
                zos.putNextEntry(zipEntry);
                System.out.println("dir compress: " + file.getCanonicalPath() + "/");
            }
            zos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void decompress(String zipFileName, String destPath) {
        try {
            zipFileName = zipFileName + SUFFIX;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFileName));
            ZipEntry zipEntry = null;
            byte[] buffer = new byte[512];
            int readLength = 0;
            while ((zipEntry = zis.getNextEntry()) != null) {
                File file;
                if (zipEntry.isDirectory() && !(file = new File(destPath + "/" + zipEntry.getName())).exists()) {
                    file.mkdirs();
                    System.out.println("mkdirs:" + file.getCanonicalPath());
                    continue;
                }
                file = ZipUitl.createFile(destPath, zipEntry.getName());
                System.out.println("file created: " + file.getCanonicalPath());
                FileOutputStream os = new FileOutputStream(file);
                while ((readLength = zis.read(buffer, 0, 512)) != -1) {
                    ((OutputStream)os).write(buffer, 0, readLength);
                }
                ((OutputStream)os).close();
                System.out.println("file uncompressed: " + file.getCanonicalPath());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

