/*
 * Decompiled with CFR 0.152.
 */
package com.fr.graph.g2d.canvas;

import com.fr.graph.g2d.canvas.ColorsAdapter;
import com.fr.graph.g2d.canvas.ContextAdapter;
import com.fr.graph.g2d.canvas.ImageProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class CanvasAdapter
implements ImageProvider {
    public static int RESOLUTION = 2;
    private BufferedImage canvas;
    private ContextAdapter contextAdapter;

    public CanvasAdapter() {
        this(5, 5);
    }

    public CanvasAdapter(int n, int n2) {
        this.canvas = new BufferedImage(n * RESOLUTION, n2 * RESOLUTION, 2);
    }

    public BufferedImage getCanvas() {
        return this.canvas;
    }

    public int getWidth() {
        return this.canvas.getWidth() / RESOLUTION;
    }

    public int getHeight() {
        return this.canvas.getHeight() / RESOLUTION;
    }

    public void setAttribute(String string, int n) {
        if ("width".equals(string)) {
            this.setWidth(n);
        } else if ("height".equals(string)) {
            this.setHeight(n);
        }
    }

    public void setWidth(int n) {
        int n2 = this.canvas.getHeight();
        this.canvas = new BufferedImage(n * RESOLUTION, n2, 2);
        this.initContextAdapter();
    }

    public void setHeight(int n) {
        int n2 = this.canvas.getWidth();
        this.canvas = new BufferedImage(n2, n * RESOLUTION, 2);
        this.initContextAdapter();
    }

    public ContextAdapter getContext() {
        if (this.contextAdapter == null) {
            this.initContextAdapter();
        }
        return this.contextAdapter;
    }

    public void initContextAdapter() {
        Graphics2D graphics2D = this.canvas.createGraphics();
        graphics2D.setBackground(ColorsAdapter.TRANSPARENT);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f));
        graphics2D.scale(RESOLUTION, RESOLUTION);
        if (this.contextAdapter == null) {
            this.contextAdapter = this.createContextAdapter(graphics2D, this.canvas);
        } else {
            this.contextAdapter.reset(graphics2D, this.canvas);
        }
    }

    public ContextAdapter createContextAdapter(Graphics2D graphics2D, BufferedImage bufferedImage) {
        return new ContextAdapter(graphics2D, bufferedImage);
    }

    @Override
    public void dispose() {
        this.canvas = null;
        if (this.contextAdapter != null) {
            this.contextAdapter.dispose();
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public BufferedImage getImage() {
        return this.canvas;
    }

    @Override
    public boolean isCanvas() {
        return true;
    }
}

