/*
 * Decompiled with CFR 0.152.
 */
package com.fr.graph.g2d.canvas;

import com.fr.general.IOUtils;
import com.fr.graph.g2d.canvas.JsEngineType;
import com.fr.graph.g2d.canvas.j2v8.V8Painter;
import com.fr.graph.g2d.canvas.nashorn.NashornPainter;
import com.fr.log.FineLoggerFactory;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public abstract class CanvasPainter
implements Closeable {
    public static final boolean SUPPORT_J2V8 = CanvasPainter.isSupportJ2v8();
    public static final boolean SUPPORT_NASHORN = CanvasPainter.isSupportNashorn();
    private StringBuilder sb = new StringBuilder();
    private static ConcurrentHashMap<String, Font> loadedFonts = new ConcurrentHashMap();
    public static final String SCRIPT_ENGINE_NAME = "NashornScriptEngine";
    public static final String JVM_ENGINE_OPTION = "script-runtime";
    public static final String NASHORN = "nashorn";

    public static Builder newBuilder() {
        return new Builder(JsEngineType.J2V8_ENGINE);
    }

    public static Builder newBuilder(JsEngineType jsEngineType) {
        return new Builder(jsEngineType);
    }

    public static Builder newDefaultBuilder() throws Exception {
        if (NASHORN.equals(System.getProperty(JVM_ENGINE_OPTION))) {
            return new Builder(JsEngineType.NASHORN_ENGINE).prepare("/com/fr/graph/g2d/canvas/js/nashorn-adapter.js");
        }
        if (SUPPORT_J2V8) {
            return new Builder(JsEngineType.J2V8_ENGINE).prepare("/com/fr/graph/g2d/canvas/js/fx-adapter.js");
        }
        if (SUPPORT_NASHORN) {
            return new Builder(JsEngineType.NASHORN_ENGINE).prepare("/com/fr/graph/g2d/canvas/js/nashorn-adapter.js");
        }
        throw new RuntimeException("C library and JDK version do not meet the requirements, Please upgrade GBLIC to 2.17 And GLIBCXX to 3.4.19 or JDK to 1.8");
    }

    public static boolean isSupportJ2v8() {
        try {
            Class<?> clazz = Class.forName("com.eclipsesource.v8.V8");
            Object object = clazz.getMethod("createV8Runtime", new Class[0]).invoke(null, new Object[0]);
            object.getClass().getMethod("close", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            FineLoggerFactory.getLogger().error(exception.getMessage(), (Throwable)exception);
            return false;
        }
        return true;
    }

    public static boolean isSupportNashorn() {
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        return scriptEngine != null && SCRIPT_ENGINE_NAME.equals(scriptEngine.getClass().getSimpleName());
    }

    public static Font loadFont(String string, File file) {
        Font font = null;
        try {
            font = Font.createFont(0, file);
            loadedFonts.put(string.toLowerCase(), font);
        }
        catch (Exception exception) {
            FineLoggerFactory.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        return font;
    }

    public static Font loadFont(String string, InputStream inputStream) {
        Font font = null;
        try {
            font = Font.createFont(0, inputStream);
            loadedFonts.put(string.toLowerCase(), font);
        }
        catch (Exception exception) {
            FineLoggerFactory.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        return font;
    }

    public static Font getFont(String string) {
        return loadedFonts.get(string.toLowerCase());
    }

    public static boolean hasFont(String string) {
        return loadedFonts.containsKey(string.toLowerCase());
    }

    public StringBuilder getSb() {
        return this.sb;
    }

    public void add(String string) {
        this.sb.append(string);
        this.sb.append(";");
    }

    public abstract void initCanvas();

    public abstract void execute(String var1) throws Exception;

    public abstract BufferedImage paint() throws Exception;

    public abstract Object executeFunction(String var1, Object ... var2) throws Exception;

    public abstract BufferedImage paint(String var1, Object ... var2) throws Exception;

    @Override
    public void close() {
    }

    public static class Builder {
        private CanvasPainter painter;

        public Builder(JsEngineType jsEngineType) {
            switch (jsEngineType) {
                case NASHORN_ENGINE: {
                    this.painter = new NashornPainter();
                    break;
                }
                default: {
                    this.painter = new V8Painter();
                }
            }
        }

        public Builder prepare(String string) throws Exception {
            String string2 = this.readFileBody(string);
            this.painter.execute(string2);
            this.painter.initCanvas();
            return this;
        }

        public Builder loadAndExecute(String ... stringArray) throws Exception {
            for (String string : stringArray) {
                String string2 = this.readFileBody(string);
                this.painter.execute(string2);
            }
            return this;
        }

        public Builder loadTextAndExecute(String ... stringArray) throws Exception {
            for (String string : stringArray) {
                this.painter.execute(string);
            }
            return this;
        }

        public Builder loadFile(String ... stringArray) {
            for (String string : stringArray) {
                this.painter.add(this.readFileBody(string));
            }
            return this;
        }

        public Builder loadText(String ... stringArray) {
            for (String string : stringArray) {
                this.painter.add(string);
            }
            return this;
        }

        private String readFileBody(String string) {
            InputStream inputStream = Builder.class.getResourceAsStream(string);
            String string2 = "";
            try {
                string2 = IOUtils.inputStream2String((InputStream)inputStream);
            }
            catch (Exception exception) {
                FineLoggerFactory.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
            return string2;
        }

        public CanvasPainter build() {
            return this.painter;
        }
    }
}

