/*
 * Decompiled with CFR 0.152.
 */
package com.fr.graph.g2d.canvas;

import com.fr.graph.g2d.canvas.CanvasAdapter;
import com.fr.graph.g2d.canvas.CanvasState;
import com.fr.graph.g2d.canvas.CanvasUtils;
import com.fr.graph.g2d.canvas.ColorsAdapter;
import com.fr.graph.g2d.canvas.CompositeAdapter;
import com.fr.graph.g2d.canvas.FontAdapter;
import com.fr.graph.g2d.canvas.ImageData;
import com.fr.graph.g2d.canvas.LineCapAdapter;
import com.fr.graph.g2d.canvas.LineJoinAdapter;
import com.fr.graph.g2d.canvas.LinearGradientAdapter;
import com.fr.graph.g2d.canvas.RadialGradientAdapter;
import com.fr.graph.g2d.canvas.TextAlignAdapter;
import com.fr.graph.g2d.canvas.TextBaselineAdapter;
import com.fr.graph.g2d.canvas.TextMetrics;
import com.fr.log.FineLoggerFactory;
import com.fr.stable.StringUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.ImageIO;
import sun.font.FontDesignMetrics;

public class ContextAdapter {
    public static final int MISMATCH = -1;
    private static Font DEFAULT_FONT;
    protected Graphics2D context;
    private BufferedImage canvas;
    private Path2D path;
    private boolean moved;
    private Paint fillPaint;
    private Paint strokePaint;
    private TextAlignAdapter textAlign;
    private TextBaselineAdapter textBaseline;
    private LinkedList<CanvasState> stateStack;
    private float[] coords = new float[6];
    private Color SHADOW = new Color(0, 0, 0, 64);

    public ContextAdapter(Graphics2D graphics2D, BufferedImage bufferedImage) {
        this.init(graphics2D, bufferedImage);
    }

    public void reset(Graphics2D graphics2D, BufferedImage bufferedImage) {
        this.init(graphics2D, bufferedImage);
    }

    private void init(Graphics2D graphics2D, BufferedImage bufferedImage) {
        this.canvas = bufferedImage;
        this.context = graphics2D;
        this.fillPaint = Color.BLACK;
        this.strokePaint = Color.BLACK;
        this.textAlign = TextAlignAdapter.LEFT;
        this.textBaseline = TextBaselineAdapter.ALPHABETIC;
        this.path = new Path2D.Float();
        this.stateStack = new LinkedList();
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    public void setStrokePaint(Paint paint) {
        this.strokePaint = paint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public Paint setFillStyle(String string) {
        this.setStyle(string, true);
        return this.fillPaint;
    }

    public Paint setStrokeStyle(String string) {
        this.setStyle(string, false);
        return this.strokePaint;
    }

    private void setStyle(String string, boolean bl) {
        Paint paint = ColorsAdapter.parsePaint(string);
        if (paint != null) {
            if (bl) {
                this.fillPaint = paint;
            } else {
                this.strokePaint = paint;
            }
        }
    }

    public String createPattern(String string, double d, double d2) {
        return string + "&&" + d + "&&" + d2;
    }

    public String createPattern(String string, double d, double d2, double d3, double d4) {
        return string + "&&" + d + "&&" + d2 + "&&" + d3 + "&&" + d4;
    }

    public LinearGradientAdapter createLinearGradient(float f, float f2, float f3, float f4) {
        return new LinearGradientAdapter(f, f2, f3, f4);
    }

    public RadialGradientAdapter createRadialGradient(float f, float f2, float f3, float f4, float f5, float f6) {
        return new RadialGradientAdapter(f, f2, f3, f4, f5, f6);
    }

    public void moveTo(double d, double d2) {
        this.coords[0] = (float)d;
        this.coords[1] = (float)d2;
        this.context.getTransform().transform(this.coords, 0, this.coords, 0, 1);
        this.path.moveTo(this.coords[0], this.coords[1]);
        this.moved = true;
    }

    public void lineTo(double d, double d2) {
        if (!this.moved) {
            this.moveTo(d, d2);
        }
        this.coords[0] = (float)d;
        this.coords[1] = (float)d2;
        this.context.getTransform().transform(this.coords, 0, this.coords, 0, 1);
        this.path.lineTo(this.coords[0], this.coords[1]);
    }

    public void rect(double d, double d2, double d3, double d4) {
        this.moveTo(d, d2);
        this.lineTo(d + d3, d2);
        this.lineTo(d + d3, d2 + d4);
        this.lineTo(d, d2 + d4);
        this.closePath();
    }

    public void strokeRect(double d, double d2, double d3, double d4) {
        this.beforeStroke();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        this.context.draw(double_);
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        this.beforeFill();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        this.context.fill(double_);
    }

    public void clearRect(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        Composite composite = this.context.getComposite();
        Paint paint = this.context.getPaint();
        this.context.setComposite(AlphaComposite.Src);
        this.context.setColor(this.context.getBackground());
        this.context.fill(double_);
        this.context.setPaint(paint);
        this.context.setComposite(composite);
    }

    public void arc(double d, double d2, double d3, double d4, double d5) {
        this.arc(d, d2, d3, d4, d5, false);
    }

    public void arc(double d, double d2, double d3, double d4, double d5, boolean bl) {
        Arc2D.Double double_ = new Arc2D.Double(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3, CanvasUtils.toArc2DAngle(d4), CanvasUtils.toArc2DLength(d4, d5, bl), 0);
        this.path.append(double_.getPathIterator(this.context.getTransform()), true);
        this.moved = true;
    }

    public void arcTo(double d, double d2, double d3, double d4, double d5) {
        if (!this.moved) {
            this.moveTo(d, d2);
        } else if (!this.tryArcTo((float)d, (float)d2, (float)d3, (float)d4, (float)d5)) {
            this.lineTo(d, d2);
        }
    }

    private boolean tryArcTo(float f, float f2, float f3, float f4, float f5) {
        boolean bl;
        double d;
        double d2;
        double d3;
        double d4;
        this.coords[0] = (float)this.path.getCurrentPoint().getX();
        this.coords[1] = (float)this.path.getCurrentPoint().getY();
        double[] dArray = new double[]{this.coords[0], this.coords[1]};
        try {
            this.context.getTransform().inverseTransform(dArray, 0, dArray, 0, 1);
        }
        catch (Exception exception) {
            return false;
        }
        float f6 = (float)dArray[0];
        float f7 = (float)dArray[1];
        double d5 = ContextAdapter.lenSq(f6, f7, f, f2);
        double d6 = ContextAdapter.lenSq(f, f2, f3, f4);
        double d7 = ContextAdapter.lenSq(f6, f7, f3, f4);
        double d8 = Math.sqrt(d5);
        double d9 = Math.sqrt(d6);
        double d10 = d5 + d6 - d7;
        double d11 = 2.0 * d8 * d9;
        if (d11 == 0.0 || f5 <= 0.0f) {
            return false;
        }
        double d12 = d10 / d11;
        double d13 = 1.0 + d12;
        if (d13 == 0.0) {
            return false;
        }
        double d14 = (1.0 - d12) / d13;
        double d15 = (double)f5 / Math.sqrt(d14);
        double d16 = (double)f + d15 / d8 * (double)(f6 - f);
        double d17 = (d16 + (d4 = (double)f + d15 / d9 * (double)(f3 - f))) / 2.0;
        double d18 = ContextAdapter.lenSq(d17, d3 = ((d2 = (double)f2 + d15 / d8 * (double)(f7 - f2)) + (d = (double)f2 + d15 / d9 * (double)(f4 - f2))) / 2.0, f, f2);
        if (d18 == 0.0) {
            return false;
        }
        double d19 = ContextAdapter.lenSq(d17, d3, d16, d2) / d18;
        double d20 = d17 + (d17 - (double)f) * d19;
        double d21 = d3 + (d3 - (double)f2) * d19;
        if (d20 != d20 || d21 != d21) {
            return false;
        }
        if (d16 != (double)f6 || d2 != (double)f7) {
            this.lineTo(d16, d2);
        }
        double d22 = Math.sqrt((1.0 - d12) / 2.0);
        boolean bl2 = bl = (d2 - d21) * (d4 - d20) > (d - d21) * (d16 - d20);
        if (d12 <= 0.0) {
            double d23 = Math.sqrt((1.0 + d12) / 2.0);
            double d24 = 1.3333333333333333 * d23 / (1.0 + d22);
            if (bl) {
                d24 = -d24;
            }
            double d25 = d16 - d24 * (d2 - d21);
            double d26 = d2 + d24 * (d16 - d20);
            double d27 = d4 + d24 * (d - d21);
            double d28 = d - d24 * (d4 - d20);
            this.bezierCurveTo(d25, d26, d27, d28, d4, d);
        } else {
            double d29 = Math.sqrt((1.0 - d22) / 2.0);
            double d30 = Math.sqrt((1.0 + d22) / 2.0);
            double d31 = 1.3333333333333333 * d29 / (1.0 + d30);
            if (bl) {
                d31 = -d31;
            }
            double d32 = (double)f5 / Math.sqrt(d18);
            double d33 = d20 + ((double)f - d17) * d32;
            double d34 = d21 + ((double)f2 - d3) * d32;
            double d35 = d16 - d31 * (d2 - d21);
            double d36 = d2 + d31 * (d16 - d20);
            double d37 = d33 + d31 * (d34 - d21);
            double d38 = d34 - d31 * (d33 - d20);
            this.bezierCurveTo(d35, d36, d37, d38, d33, d34);
            d35 = d33 - d31 * (d34 - d21);
            d36 = d34 + d31 * (d33 - d20);
            d37 = d4 + d31 * (d - d21);
            d38 = d - d31 * (d4 - d20);
            this.bezierCurveTo(d35, d36, d37, d38, d4, d);
        }
        return true;
    }

    private static double lenSq(double d, double d2, double d3, double d4) {
        return (d3 -= d) * d3 + (d4 -= d2) * d4;
    }

    public void quadraticCurveTo(double d, double d2, double d3, double d4) {
        this.coords[0] = (float)d;
        this.coords[1] = (float)d2;
        this.coords[2] = (float)d3;
        this.coords[3] = (float)d4;
        this.context.getTransform().transform(this.coords, 0, this.coords, 0, 2);
        if (!this.moved) {
            this.path.moveTo(this.coords[0], this.coords[1]);
            this.moved = true;
        }
        this.path.quadTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3]);
    }

    public void bezierCurveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.coords[0] = (float)d;
        this.coords[1] = (float)d2;
        this.coords[2] = (float)d3;
        this.coords[3] = (float)d4;
        this.coords[4] = (float)d5;
        this.coords[5] = (float)d6;
        this.context.getTransform().transform(this.coords, 0, this.coords, 0, 3);
        if (!this.moved) {
            this.path.moveTo(this.coords[0], this.coords[1]);
            this.moved = true;
        }
        this.path.curveTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3], this.coords[4], this.coords[5]);
    }

    public void closePath() {
        if (this.moved) {
            this.path.closePath();
        }
    }

    public boolean isPointInPath(double d, double d2) {
        return this.path.contains(d, d2);
    }

    public void beginPath() {
        this.path.reset();
        this.moved = false;
    }

    public void stroke() {
        if (this.moved) {
            this.beforeStroke();
            this.draw(false);
        }
    }

    public void fill() {
        if (this.moved) {
            this.beforeFill();
            this.draw(true);
        }
    }

    private void draw(boolean bl) {
        try {
            AffineTransform affineTransform = this.context.getTransform().createInverse();
            Path2D.Double double_ = new Path2D.Double();
            ((Path2D)double_).append(this.path.getPathIterator(affineTransform), false);
            if (bl) {
                this.context.fill(double_);
            } else {
                this.context.draw(double_);
            }
        }
        catch (Exception exception) {
            FineLoggerFactory.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public void clip() {
        AffineTransform affineTransform = this.context.getTransform();
        this.context.setTransform(new AffineTransform());
        this.context.clip(this.path);
        this.context.setTransform(affineTransform);
    }

    public String setLineCap(String string) {
        BasicStroke basicStroke;
        int n = LineCapAdapter.parse(string);
        if (n != -1) {
            basicStroke = (BasicStroke)this.context.getStroke();
            this.context.setStroke(new BasicStroke(basicStroke.getLineWidth(), n, basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
        }
        basicStroke = (BasicStroke)this.context.getStroke();
        return LineJoinAdapter.valueOf(basicStroke.getLineJoin());
    }

    public String setLineJoin(String string) {
        BasicStroke basicStroke;
        int n = LineJoinAdapter.parse(string);
        if (n != -1) {
            basicStroke = (BasicStroke)this.context.getStroke();
            this.context.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), n, basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
        }
        basicStroke = (BasicStroke)this.context.getStroke();
        return LineJoinAdapter.valueOf(basicStroke.getLineJoin());
    }

    public double setLineWidth(double d) {
        BasicStroke basicStroke;
        if (d > 0.0) {
            basicStroke = (BasicStroke)this.context.getStroke();
            this.context.setStroke(new BasicStroke((float)d, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
        }
        basicStroke = (BasicStroke)this.context.getStroke();
        return basicStroke.getLineWidth();
    }

    public double setMiterLimit(double d) {
        BasicStroke basicStroke;
        if (d > 0.0) {
            basicStroke = (BasicStroke)this.context.getStroke();
            this.context.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), (float)d, basicStroke.getDashArray(), basicStroke.getDashPhase()));
        }
        basicStroke = (BasicStroke)this.context.getStroke();
        return basicStroke.getMiterLimit();
    }

    public void setLineDash(float[] fArray) {
        fArray = (float[])(fArray.length > 0 ? fArray : null);
        BasicStroke basicStroke = (BasicStroke)this.context.getStroke();
        this.context.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), fArray, 0.0f));
    }

    public void scale(double d, double d2) {
        this.context.scale(d, d2);
    }

    public void rotate(double d) {
        this.context.rotate(d);
    }

    public void translate(double d, double d2) {
        this.context.translate(d, d2);
    }

    public void transform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.context.transform(new AffineTransform(d, d2, d3, d4, d5, d6));
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.context.setTransform(new AffineTransform(d, d2, d3, d4, d5 * (double)CanvasAdapter.RESOLUTION, d6 * (double)CanvasAdapter.RESOLUTION));
        this.scale(CanvasAdapter.RESOLUTION, CanvasAdapter.RESOLUTION);
    }

    public String setFont(String string) {
        if (this.context == null) {
            this.initGraphics();
        }
        if (!StringUtils.isEmpty((String)string)) {
            this.context.setFont(FontAdapter.processFont(string));
        }
        Font font = this.context.getFont();
        return FontAdapter.font2String(font);
    }

    private void initGraphics() {
        this.context = new CanvasAdapter().getContext().context;
    }

    public String setTextAlign(String string) {
        TextAlignAdapter textAlignAdapter = TextAlignAdapter.get(string);
        if (textAlignAdapter != null) {
            this.textAlign = textAlignAdapter;
        }
        return this.textAlign.getTextAlign();
    }

    public String setTextBaseline(String string) {
        TextBaselineAdapter textBaselineAdapter = TextBaselineAdapter.get(string);
        if (string != null) {
            this.textBaseline = textBaselineAdapter;
        }
        return this.textBaseline.getTextBaseline();
    }

    public void fillText(String string, double d, double d2) {
        Map<String, Boolean> map = this.distinctText(string);
        if (this.fillPaint instanceof Color && ((Color)this.fillPaint).getAlpha() == 255) {
            this.context.setPaint(this.SHADOW);
            this.drawTextWithTextAttr(string, map, (float)d, (float)d2, true);
        }
        this.beforeFill();
        this.drawTextWithTextAttr(string, map, (float)d, (float)d2, true);
    }

    public void strokeText(String string, double d, double d2) {
        Map<String, Boolean> map = this.distinctText(string);
        this.beforeStroke();
        this.drawTextWithTextAttr(string, map, (float)d, (float)d2, false);
    }

    private Map<String, Boolean> distinctText(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return new LinkedHashMap<String, Boolean>();
        }
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        int n = 0;
        int n2 = string.length();
        Font font = this.context.getFont();
        boolean bl = font.canDisplay(string.charAt(0));
        for (int i = 1; i < n2; ++i) {
            if (bl == font.canDisplay(string.charAt(i))) continue;
            linkedHashMap.put(string.substring(n, i), bl);
            n = i;
            bl = !bl;
        }
        linkedHashMap.put(string.substring(n, n2), bl);
        return linkedHashMap;
    }

    private void drawTextWithTextAttr(String string, Map<String, Boolean> map, float f, float f2, boolean bl) {
        Font font = this.context.getFont();
        Font font2 = DEFAULT_FONT.deriveFont(font.getStyle(), font.getSize());
        f = this.calAlign(string, f);
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            this.context.setFont(entry.getValue() != false ? font : font2);
            this.drawText(entry.getKey(), f, f2, bl);
            f += (float)this.context.getFontMetrics().stringWidth(entry.getKey());
        }
        this.context.setFont(font);
    }

    private void drawText(String string, float f, float f2, boolean bl) {
        String string2;
        f2 = this.calBaseline(f2);
        boolean bl2 = string.indexOf(".") > 0;
        String string3 = bl2 ? string.substring(0, string.indexOf(".")) : string;
        String string4 = string2 = bl2 ? string.substring(string.indexOf(".")) : "";
        if (bl) {
            this.context.drawString(string3, f, f2);
            if (StringUtils.isNotEmpty((String)string2)) {
                TextMetrics textMetrics = this.measureText(string3);
                this.context.drawString(string2, f + (float)textMetrics.getWidth(), f2);
            }
        } else {
            GlyphVector glyphVector = this.context.getFont().createGlyphVector(this.context.getFontMetrics().getFontRenderContext(), string3);
            GlyphVector glyphVector2 = this.context.getFont().createGlyphVector(this.context.getFontMetrics().getFontRenderContext(), string2);
            Shape shape = glyphVector.getOutline(f, f2);
            TextMetrics textMetrics = this.measureText(string3);
            Shape shape2 = glyphVector2.getOutline(f + (float)textMetrics.getWidth(), f2);
            this.context.draw(shape);
            this.context.draw(shape2);
        }
    }

    private float calAlign(String string, float f) {
        TextMetrics textMetrics = this.measureText(string);
        switch (this.textAlign) {
            case CENTER: {
                f -= (float)(textMetrics.getWidth() / 2);
                break;
            }
            case RIGHT: {
                f -= (float)textMetrics.getWidth();
                break;
            }
        }
        return f;
    }

    private float calBaseline(float f) {
        FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(this.context.getFont());
        float f2 = fontDesignMetrics.getAscent();
        float f3 = fontDesignMetrics.getDescent();
        switch (this.textBaseline) {
            case TOP: {
                f += f2 / 4.0f * 3.0f;
                break;
            }
            case BOTTOM: {
                f -= f3;
                break;
            }
            case CENTER: {
                f += (f2 - f3) / 2.0f;
            }
        }
        return f;
    }

    public TextMetrics measureText(String string) {
        if (this.context == null) {
            this.initGraphics();
        }
        if (!StringUtils.isEmpty((String)string)) {
            int n = 0;
            Map<String, Boolean> map = this.distinctText(string);
            Font font = this.context.getFont();
            Font font2 = DEFAULT_FONT.deriveFont(font.getStyle(), font.getSize());
            for (Map.Entry<String, Boolean> entry : map.entrySet()) {
                this.context.setFont(entry.getValue() != false ? font : font2);
                n += this.context.getFontMetrics().stringWidth(entry.getKey());
            }
            this.context.setFont(font);
            return new TextMetrics(n);
        }
        return new TextMetrics(0);
    }

    public String setGlobalCompositeOperation(String string) {
        AlphaComposite alphaComposite;
        int n = CompositeAdapter.parse(string);
        if (n != -1) {
            alphaComposite = (AlphaComposite)this.context.getComposite();
            this.context.setComposite(AlphaComposite.getInstance(n, alphaComposite.getAlpha()));
        }
        alphaComposite = (AlphaComposite)this.context.getComposite();
        return CompositeAdapter.valueOf(alphaComposite.getRule());
    }

    public double setGlobalAlpha(String string) {
        return this.setGlobalAlpha(Double.parseDouble(string));
    }

    public double setGlobalAlpha(double d) {
        AlphaComposite alphaComposite;
        if (d <= 1.0 || d >= 0.0) {
            alphaComposite = (AlphaComposite)this.context.getComposite();
            this.context.setComposite(AlphaComposite.getInstance(alphaComposite.getRule(), (float)d));
        }
        alphaComposite = (AlphaComposite)this.context.getComposite();
        return alphaComposite.getAlpha();
    }

    public void drawImage(BufferedImage bufferedImage, int n, int n2) {
        this.context.drawImage((Image)bufferedImage, n, n2, null);
    }

    public void drawImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        this.context.drawImage(bufferedImage, n, n2, n3, n4, null);
    }

    public void drawImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (bufferedImage == null) {
            return;
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n == 0 && n2 == 0 && n3 * n9 == bufferedImage.getWidth() && n4 * n9 == bufferedImage.getHeight()) {
            this.drawImage(bufferedImage, n5, n6, n7, n8);
            return;
        }
        ImageData imageData = this.getImageData(bufferedImage, n, n2, n3, n4, n9);
        BufferedImage bufferedImage2 = new BufferedImage(n3 * CanvasAdapter.RESOLUTION, n4 * CanvasAdapter.RESOLUTION, 2);
        this.putImageData(bufferedImage2, imageData, 0, 0, 0, 0, n3, n4);
        this.drawImage(bufferedImage2, n5, n6, n7, n8);
    }

    public ImageData createImageData(int n, int n2) {
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        int[] nArray = new int[n * n2 * 4];
        return new ImageData(n, n2, nArray);
    }

    public ImageData getImageData(int n, int n2, int n3, int n4) {
        return this.getImageData(this.canvas, n, n2, n3, n4);
    }

    public void putImageData(ImageData imageData, int n, int n2) {
        this.putImageData(imageData, n, n2, 0, 0, imageData.getWidth(), imageData.getHeight());
    }

    public void putImageData(ImageData imageData, int n, int n2, int n3, int n4, int n5, int n6) {
        this.putImageData(this.canvas, imageData, n, n2, n3, n4, n5, n6);
    }

    public void save() {
        AffineTransform affineTransform = this.context.getTransform();
        this.context.setTransform(new AffineTransform());
        Shape shape = this.context.getClip();
        this.context.setTransform(affineTransform);
        CanvasState canvasState = new CanvasState(this.fillPaint, this.strokePaint, this.textAlign, this.textBaseline, shape, this.context.getStroke(), affineTransform, this.context.getComposite(), this.context.getFont());
        this.stateStack.push(canvasState);
    }

    public void restore() {
        if (!this.stateStack.isEmpty()) {
            CanvasState canvasState = this.stateStack.pop();
            this.context.setTransform(new AffineTransform());
            this.context.setClip(canvasState.getClip());
            this.context.setTransform(canvasState.getTransform());
            this.context.setStroke(canvasState.getStroke());
            this.context.setComposite(canvasState.getComposite());
            this.context.setFont(canvasState.getFont());
            this.fillPaint = canvasState.getFillPaint();
            this.strokePaint = canvasState.getStrokePaint();
            this.textAlign = canvasState.getTextAlign();
            this.textBaseline = canvasState.getTextBaseline();
        }
    }

    public void out(String string) {
        try {
            ImageIO.write((RenderedImage)this.canvas, "PNG", new File(string));
            this.context.dispose();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void dispose() {
        this.context.dispose();
        this.context = null;
        this.canvas = null;
    }

    private ImageData getImageData(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        return this.getImageData(bufferedImage, n, n2, n3, n4, CanvasAdapter.RESOLUTION);
    }

    private ImageData getImageData(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5) {
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        int n6 = Math.max(n * n5, 0);
        int n7 = Math.max(n2 * n5, 0);
        int n8 = Math.min((n + n3) * n5, bufferedImage.getWidth());
        int n9 = Math.min((n2 + n4) * n5, bufferedImage.getHeight());
        int[] nArray = new int[n3 * n4 * 4];
        for (int i = n7; i < n9; i += n5) {
            for (int j = n6; j < n8; j += n5) {
                int n10 = ((i - n2 * n5) * n3 / n5 + (j - n * n5) / n5) * 4;
                int[] nArray2 = CanvasUtils.intColorToRGBA(bufferedImage.getRGB(j, i));
                nArray[n10] = nArray2[0];
                nArray[n10 + 1] = nArray2[1];
                nArray[n10 + 2] = nArray2[2];
                nArray[n10 + 3] = nArray2[3];
            }
        }
        return new ImageData(n3, n4, nArray);
    }

    private void putImageData(BufferedImage bufferedImage, ImageData imageData, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = Math.max(n * CanvasAdapter.RESOLUTION, 0);
        int n9 = Math.max(n2 * CanvasAdapter.RESOLUTION, 0);
        int n10 = Math.min((n + imageData.getWidth()) * CanvasAdapter.RESOLUTION, bufferedImage.getWidth());
        int n11 = Math.min((n2 + imageData.getHeight()) * CanvasAdapter.RESOLUTION, bufferedImage.getHeight());
        n3 += n;
        n4 += n2;
        if (n5 < 0) {
            n3 += n5;
            n5 = -n5;
        }
        if (n6 < 0) {
            n4 += n6;
            n6 = -n6;
        }
        n8 = Math.max(n8, n3 * CanvasAdapter.RESOLUTION);
        n9 = Math.max(n9, n4 * CanvasAdapter.RESOLUTION);
        n10 = Math.min(n10, (n3 + n5) * CanvasAdapter.RESOLUTION);
        n11 = Math.min(n11, (n4 + n6) * CanvasAdapter.RESOLUTION);
        int[] nArray = imageData.getData();
        for (n7 = 0; n7 < nArray.length; ++n7) {
            if (nArray[n7] > 255) {
                nArray[n7] = 255;
                continue;
            }
            if (nArray[n7] >= 0) continue;
            nArray[n7] = 0;
        }
        for (n7 = n9; n7 < n11; n7 += CanvasAdapter.RESOLUTION) {
            for (int i = n8; i < n10; i += CanvasAdapter.RESOLUTION) {
                int n12 = ((n7 - n2 * CanvasAdapter.RESOLUTION) * imageData.getWidth() / CanvasAdapter.RESOLUTION + (i - n * CanvasAdapter.RESOLUTION) / CanvasAdapter.RESOLUTION) * 4;
                int n13 = CanvasUtils.RGBAToIntColor(nArray[n12], nArray[n12 + 1], nArray[n12 + 2], nArray[n12 + 3]);
                this.setRGB(bufferedImage, n13, i, n7, 1);
            }
        }
    }

    private void setRGB(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        if (n4 > CanvasAdapter.RESOLUTION) {
            return;
        }
        int n5 = n2 + n4 - 1;
        int n6 = n3 + n4 - 1;
        for (int i = 0; i < n4; ++i) {
            if (i == n4 - 1) {
                bufferedImage.setRGB(n5, n6, n);
                continue;
            }
            bufferedImage.setRGB(n5, n3 + i, n);
            bufferedImage.setRGB(n2 + i, n6, n);
        }
        this.setRGB(bufferedImage, n, n2, n3, n4 + 1);
    }

    private void beforeFill() {
        this.context.setPaint(this.fillPaint);
    }

    private void beforeStroke() {
        this.context.setPaint(this.strokePaint);
    }

    static {
        InputStream inputStream = ContextAdapter.class.getResourceAsStream("/com/fr/graph/g2d/canvas/font/NotoSansHans-Regular.otf");
        try {
            DEFAULT_FONT = Font.createFont(0, inputStream);
        }
        catch (Exception exception) {
            DEFAULT_FONT = new Font("Dialog", 0, 1);
        }
    }
}

