/*
 * Decompiled with CFR 0.152.
 */
package com.fr.graph.g2d.canvas;

import com.fr.graph.g2d.canvas.CanvasPainter;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FontAdapter {
    public static final String BOLD = "bold";
    public static final String ITALIC = "italic";
    public static final String OBLIQUE = "oblique";
    public static final int DEFAULT_SIZE = 12;
    public static Map<String, Integer> fontStyle;
    public static Map<String, Font> fontMap;
    public static Set<String> availableFontFamilyNames;

    public static Font processFont(String string) {
        if (fontMap.containsKey(string)) {
            return fontMap.get(string);
        }
        String[] stringArray = string.split("\\s");
        int n = 0;
        int n2 = 12;
        String string2 = "DIALOG";
        Font font = null;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            String string3 = stringArray[i];
            if (string3.equalsIgnoreCase(ITALIC) || string3.equalsIgnoreCase(OBLIQUE) || string3.equalsIgnoreCase(BOLD)) {
                n |= fontStyle.get(string3.toLowerCase()).intValue();
                continue;
            }
            if (!FontAdapter.isMetricValue(string3) && !FontAdapter.isNumericValue(string3)) continue;
            n2 = (int)(Double.parseDouble(FontAdapter.isMetricValue(string3) ? string3.substring(0, string3.length() - 2) : string3) + 0.5);
            int n3 = n2 = n2 < 0 ? 12 : n2;
            if (i == stringArray.length - 1) break;
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = i + 1; j < stringArray.length; ++j) {
                String[] stringArray3 = stringArray[j];
                stringArray3 = stringArray3.replaceAll("\"", "");
                stringArray3 = stringArray3.replaceAll("'", "");
                stringBuilder.append((String)stringArray3).append(" ");
            }
            for (String string4 : stringArray2 = stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length()).toString().split(",")) {
                if (CanvasPainter.hasFont(string4 = string4.trim())) {
                    font = CanvasPainter.getFont(string4);
                    break block0;
                }
                if (!availableFontFamilyNames.contains(string4.toLowerCase())) continue;
                string2 = string4;
                break block0;
            }
            break;
        }
        font = font == null ? new Font(string2, n, n2) : font.deriveFont(n, n2);
        fontMap.put(string, font);
        return font;
    }

    public static String font2String(Font font) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((font.getStyle() & 1) > 0 ? "bold " : "").append((font.getStyle() & 2) > 0 ? "italic " : "").append(font.getSize()).append(" ").append(font.getFamily());
        return stringBuilder.toString();
    }

    public static boolean isMetricValue(String string) {
        return string.contains("px") || string.contains("in") || string.contains("cm") || string.contains("mm") || string.contains("pc") || string.contains("pt");
    }

    public static boolean isNumericValue(String string) {
        return string.matches("^-?\\d\\d*\\.\\d*$") || string.matches("^-?\\d\\d*$") || string.matches("^-?\\.\\d\\d*$");
    }

    static {
        int n;
        fontMap = new ConcurrentHashMap<String, Font>();
        fontStyle = new HashMap<String, Integer>();
        fontStyle.put(BOLD, new Integer(1));
        fontStyle.put(OBLIQUE, new Integer(2));
        fontStyle.put(ITALIC, new Integer(2));
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.ENGLISH);
        String[] stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringArray[n].toLowerCase();
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = stringArray2[n].toLowerCase();
        }
        availableFontFamilyNames = new HashSet<String>(Arrays.asList(stringArray2));
        availableFontFamilyNames.addAll(Arrays.asList(stringArray));
    }
}

