/*
 * Decompiled with CFR 0.152.
 */
package com.fr.graph.g2d.canvas;

import com.fr.general.IOUtils;
import com.fr.graph.g2d.canvas.CustomImageProvider;
import com.fr.log.FineLoggerFactory;
import com.fr.stable.StringUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static Map<String, BufferedImage> cache;
    private static List<CustomImageProvider> customImageProviders;
    private static final int READ_TIME_OUT = 10000;

    public static void registerCustomImageProvider(CustomImageProvider customImageProvider) {
        customImageProviders.add(customImageProvider);
    }

    public static BufferedImage getOrCreate(String string) {
        BufferedImage bufferedImage = ImageUtils.create(string);
        return bufferedImage;
    }

    public static BufferedImage create(String string) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            for (CustomImageProvider customImageProvider : customImageProviders) {
                if (!customImageProvider.isCustom(string)) continue;
                return customImageProvider.getImage(string);
            }
            return string.startsWith("data:") ? ImageUtils.createByBase64(string) : ImageUtils.createByUrl(string);
        }
        catch (IOException iOException) {
            FineLoggerFactory.getLogger().error(iOException.getMessage(), (Throwable)iOException);
            return null;
        }
    }

    public static BufferedImage createByBase64(String string) throws IOException {
        BufferedImage bufferedImage = cache.get(string);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        String string2 = string.split("base64,")[1];
        byte[] byArray = IOUtils.base64Decode((String)string2);
        BufferedImage bufferedImage2 = ImageIO.read(new ByteArrayInputStream(byArray));
        cache.put(string, bufferedImage2);
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createByUrl(String string) throws IOException {
        BufferedImage bufferedImage = null;
        InputStream inputStream = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                inputStream = httpURLConnection.getInputStream();
                bufferedImage = ImageIO.read(inputStream);
            }
        }
        catch (IOException iOException) {
            FineLoggerFactory.getLogger().error(iOException.getMessage(), (Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return bufferedImage;
    }

    static {
        customImageProviders = new ArrayList<CustomImageProvider>();
        cache = Collections.synchronizedMap(new WeakHashMap());
    }
}

