/*
 * Decompiled with CFR 0.152.
 */
package com.fr.graph.g2d.canvas;

import com.fr.graph.g2d.canvas.ColorsAdapter;
import com.fr.graph.g2d.canvas.Stop;
import com.fr.log.FineLoggerFactory;
import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class RadialGradientAdapter {
    private float x0;
    private float y0;
    private float r0;
    private float x1;
    private float y1;
    private float r1;
    private List<Stop> stops;

    public RadialGradientAdapter(float f, float f2, float f3, float f4, float f5, float f6) {
        this.x0 = f;
        this.y0 = f2;
        this.r0 = f3;
        this.x1 = f4;
        this.y1 = f5;
        this.r1 = f6;
        this.stops = new ArrayList<Stop>();
    }

    public void addColorStop(double d, String string) {
        try {
            Color color = ColorsAdapter.web(string);
            this.stops.add(new Stop(d, color));
        }
        catch (Exception exception) {
            FineLoggerFactory.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public void addColorStop(String string, String string2) {
        double d = Double.parseDouble(string);
        this.addColorStop(d, string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("radial-gradient(").append(this.x0).append("|").append(this.y0).append("|").append(this.r0).append("|").append(this.x1).append("|").append(this.y1).append("|").append(this.r1).append("|");
        this.stops = Stop.normalize(this.stops);
        for (Stop stop : this.stops) {
            stringBuilder.append(stop).append(",");
        }
        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static RadialGradientPaint valueOf(String string) {
        if (string == null) {
            throw new NullPointerException("gradient must be specified");
        }
        String string2 = "radial-gradient(";
        String string3 = ")";
        if (!string.startsWith(string2) || !string.endsWith(string3)) {
            throw new IllegalArgumentException("Invalid linear-gradient specification, must begin with \"" + string2 + '\"' + " and end with \"" + string3 + '\"');
        }
        string = string.substring(string2.length(), string.length() - string3.length());
        String[] stringArray = string.split("\\|");
        float f = Float.parseFloat(stringArray[0]);
        float f2 = Float.parseFloat(stringArray[1]);
        float f3 = Float.parseFloat(stringArray[3]);
        float f4 = Float.parseFloat(stringArray[4]);
        float f5 = Float.parseFloat(stringArray[5]);
        ArrayList<Stop> arrayList = new ArrayList<Stop>();
        for (String string4 : stringArray[6].split(",")) {
            String[] stringArray2 = string4.split("&");
            arrayList.add(new Stop(Double.parseDouble(stringArray2[0]), new Color(Integer.parseInt(stringArray2[1]), true)));
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Color> arrayList3 = new ArrayList<Color>();
        Stop.transStops(arrayList, arrayList3, arrayList2);
        float[] fArray = new float[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            fArray[i] = ((Float)arrayList2.get(i)).floatValue();
        }
        return new RadialGradientPaint(new Point2D.Double(f3, f4), f5, new Point2D.Double(f, f2), fArray, arrayList3.toArray(new Color[arrayList3.size()]), MultipleGradientPaint.CycleMethod.NO_CYCLE);
    }

    public static RadialGradientAdapter Paint2Adapter(RadialGradientPaint radialGradientPaint) {
        if (radialGradientPaint == null) {
            throw new NullPointerException("paint must be specified");
        }
        RadialGradientAdapter radialGradientAdapter = new RadialGradientAdapter((float)radialGradientPaint.getFocusPoint().getX(), (float)radialGradientPaint.getFocusPoint().getY(), 0.0f, (float)radialGradientPaint.getCenterPoint().getX(), (float)radialGradientPaint.getCenterPoint().getY(), radialGradientPaint.getRadius());
        float[] fArray = radialGradientPaint.getFractions();
        Color[] colorArray = radialGradientPaint.getColors();
        for (int i = 0; i < fArray.length; ++i) {
            radialGradientAdapter.stops.add(new Stop(fArray[i], colorArray[i]));
        }
        return radialGradientAdapter;
    }
}

