/*
 * Decompiled with CFR 0.152.
 */
package com.fr.graph.g2d.canvas;

import com.fr.graph.g2d.canvas.ColorsAdapter;
import com.fr.stable.AssistUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Stop {
    public static final List<Stop> NO_STOP = Arrays.asList(new Stop(0.0, ColorsAdapter.TRANSPARENT), new Stop(1.0, ColorsAdapter.TRANSPARENT));
    private Color color;
    private double offset;
    public static final float ACCURACY = 1.0E-6f;

    public Stop(double d, Color color) {
        this.offset = d;
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public double getOffset() {
        return this.offset;
    }

    public static List<Stop> normalize(List<Stop> list) {
        if (list == null) {
            return NO_STOP;
        }
        Object var1_1 = null;
        Object var2_2 = null;
        ArrayList<Stop> arrayList = new ArrayList<Stop>(list.size());
        for (Stop stop : list) {
            double d;
            if (stop == null || stop.getColor() == null || (d = stop.getOffset()) < 0.0 || d > 1.0) continue;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Stop stop2 = (Stop)arrayList.get(i);
                if (!(stop2.getOffset() <= d)) continue;
                if (stop2.getOffset() == d) {
                    if (i > 0 && ((Stop)arrayList.get(i - 1)).getOffset() == d || d == 0.0) {
                        arrayList.set(i, stop);
                    } else {
                        if (d == 1.0) {
                            stop = null;
                            break;
                        }
                        arrayList.add(i + 1, stop);
                    }
                } else {
                    arrayList.add(i + 1, stop);
                }
                stop = null;
                break;
            }
            if (stop == null) continue;
            arrayList.add(0, stop);
        }
        if (arrayList.isEmpty()) {
            return NO_STOP;
        }
        if (arrayList.size() == 1) {
            return Arrays.asList(new Stop(0.0, ((Stop)arrayList.get((int)0)).color), new Stop(1.0, ((Stop)arrayList.get((int)0)).color));
        }
        return arrayList;
    }

    public static void transStops(List<Stop> list, List<Color> list2, List<Float> list3) {
        list = Stop.normalize(list);
        for (int i = 0; i < list.size(); ++i) {
            list2.add(list.get(i).getColor());
            float f = (float)list.get(i).getOffset();
            if (i > 1 && f == list3.get(i - 1).floatValue()) {
                f += 1.0E-6f;
            }
            list3.add(Float.valueOf(f));
        }
    }

    public String toString() {
        return this.offset + "&" + this.color.getRGB();
    }

    public boolean equals(Object object) {
        return object instanceof Stop && AssistUtils.equals((double)this.offset, (double)((Stop)object).offset) && AssistUtils.equals((Object)this.color, (Object)((Stop)object).color);
    }

    public int hashCode() {
        return AssistUtils.hashCode((Object[])new Object[]{this.offset, this.color});
    }
}

