/*
 * Decompiled with CFR 0.152.
 */
package com.fr.graph.g2d.canvas.j2v8;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8ArrayBuffer;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8TypedArray;
import com.fr.graph.g2d.canvas.CanvasAdapter;
import com.fr.graph.g2d.canvas.CanvasUtils;
import com.fr.graph.g2d.canvas.ContextAdapter;
import com.fr.graph.g2d.canvas.ImageData;
import com.fr.graph.g2d.canvas.ImageProvider;
import com.fr.graph.g2d.canvas.ImageUtils;
import com.fr.graph.g2d.canvas.LinearGradientAdapter;
import com.fr.graph.g2d.canvas.RadialGradientAdapter;
import com.fr.graph.g2d.canvas.TextMetrics;
import com.fr.graph.g2d.canvas.j2v8.V8ImageData;
import com.fr.graph.g2d.canvas.j2v8.V8LinearGradient;
import com.fr.graph.g2d.canvas.j2v8.V8Painter;
import com.fr.graph.g2d.canvas.j2v8.V8RadialGradient;
import com.fr.log.FineLoggerFactory;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class V8Context
extends V8Object {
    private ContextAdapter context;
    private V8Painter v8Painter;

    public V8Context(V8Painter v8Painter, V8 v8, ContextAdapter contextAdapter) {
        super(v8);
        this.context = contextAdapter;
        this.v8Painter = v8Painter;
        this.initPrototype();
        this.initSelfMethod();
        this.initAdapterMethod();
    }

    private void initPrototype() {
        V8Object v8Object = this.v8.getObject("NativeContextPrototype");
        this.setPrototype(v8Object);
        v8Object.release();
    }

    private void initSelfMethod() {
        this.registerJavaMethod(this.context, "out", "out", new Class[]{String.class});
        this.registerJavaMethod(this.context, "dispose", "dispose", new Class[0]);
        this.registerJavaMethod(this.context, "save", "save", new Class[0]);
        this.registerJavaMethod(this.context, "fill", "fill", new Class[0]);
        this.registerJavaMethod(this.context, "rotate", "rotate", new Class[]{Double.TYPE});
        this.registerJavaMethod(this.context, "scale", "scale", new Class[]{Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "moveTo", "moveTo", new Class[]{Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "lineTo", "lineTo", new Class[]{Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "rect", "rect", new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "strokeRect", "strokeRect", new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "fillRect", "fillRect", new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "clearRect", "clearRect", new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "arcTo", "arcTo", new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "quadraticCurveTo", "quadraticCurveTo", new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "bezierCurveTo", "bezierCurveTo", new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "closePath", "closePath", new Class[0]);
        this.registerJavaMethod(this.context, "isPointInPath", "isPointInPath", new Class[]{Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "beginPath", "beginPath", new Class[0]);
        this.registerJavaMethod(this.context, "stroke", "stroke", new Class[0]);
        this.registerJavaMethod(this.context, "clip", "clip", new Class[0]);
        this.registerJavaMethod(this.context, "setLineCap", "setLineCap", new Class[]{String.class});
        this.registerJavaMethod(this.context, "setLineJoin", "setLineJoin", new Class[]{String.class});
        this.registerJavaMethod(this.context, "setLineWidth", "setLineWidth", new Class[]{Double.TYPE});
        this.registerJavaMethod(this.context, "setMiterLimit", "setMiterLimit", new Class[]{Double.TYPE});
        this.registerJavaMethod(this.context, "translate", "translate", new Class[]{Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "setTransform", "setTransform", new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "setFont", "setFont", new Class[]{String.class});
        this.registerJavaMethod(this.context, "setTextAlign", "setTextAlign", new Class[]{String.class});
        this.registerJavaMethod(this.context, "setTextBaseline", "setTextBaseline", new Class[]{String.class});
        this.registerJavaMethod(this.context, "fillText", "fillText", new Class[]{String.class, Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "strokeText", "strokeText", new Class[]{String.class, Double.TYPE, Double.TYPE});
        this.registerJavaMethod(this.context, "setGlobalCompositeOperation", "setGlobalCompositeOperation", new Class[]{String.class});
        this.registerJavaMethod(this.context, "restore", "restore", new Class[0]);
        this.registerJavaMethod(this.context, "transform", "transform", new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
    }

    private void initAdapterMethod() {
        this.registerJavaMethod(new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() > 0) {
                    int n = v8Array.getType(0);
                    if (n == 1 || n == 2) {
                        return V8Context.this.context.setGlobalAlpha(v8Array.getDouble(0));
                    }
                    if (n == 4) {
                        return V8Context.this.context.setGlobalAlpha(v8Array.getString(0));
                    }
                    throw new IllegalArgumentException("Wrong Parameter Type");
                }
                throw new IllegalArgumentException("Failed to execute 'setGlobalAlpha': 1 arguments required, but only " + v8Array.length() + " present.");
            }
        }, "setGlobalAlpha");
        this.registerJavaMethod(new JavaVoidCallback(){

            public void invoke(V8Object v8Object, V8Array v8Array) {
                boolean bl;
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                if (v8Array.length() > 4) {
                    d5 = v8Array.getDouble(0);
                    d4 = v8Array.getDouble(1);
                    d3 = v8Array.getDouble(2);
                    d2 = v8Array.getDouble(3);
                    d = v8Array.getDouble(4);
                    if (Double.isNaN(d5) || Double.isNaN(d4) || Double.isNaN(d3) || Double.isNaN(d2) || Double.isNaN(d)) {
                        return;
                    }
                    bl = false;
                    if (v8Array.length() > 5) {
                        int n = v8Array.getType(5);
                        if (n == 1 || n == 2) {
                            bl = v8Array.getDouble(5) != 0.0;
                        } else if (n == 4) {
                            bl = !"".equals(v8Array.getString(5));
                        } else if (n == 6) {
                            bl = true;
                        } else if (n == 3) {
                            bl = v8Array.getBoolean(5);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Failed to execute 'arc': 5 arguments required, but only " + v8Array.length() + " present.");
                }
                V8Context.this.context.arc(d5, d4, d3, d2, d, bl);
            }
        }, "arc");
        this.registerJavaMethod(new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() > 0) {
                    TextMetrics textMetrics;
                    Object object = v8Array.get(0);
                    if (object == null) {
                        textMetrics = V8Context.this.context.measureText("null");
                    } else {
                        textMetrics = V8Context.this.context.measureText(object.toString());
                        if (object instanceof V8Object) {
                            ((V8Object)object).release();
                        }
                    }
                    V8Object v8Object2 = new V8Object(V8Context.this.v8);
                    v8Object2.add("width", textMetrics.getWidth());
                    return v8Object2;
                }
                throw new IllegalArgumentException("Failed to execute 'createLinearGradient': 4 arguments required, but only " + v8Array.length() + " present.");
            }
        }, "measureText");
        this.registerJavaMethod(new JavaCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() > 0) {
                    String string = "";
                    V8Object v8Object2 = null;
                    V8Object v8Object3 = null;
                    try {
                        v8Object2 = v8Array.getObject(0);
                        v8Object3 = v8Object2.getObject("imageAttr");
                        String string2 = v8Object2.getString("imageUrl");
                        double d = v8Object2.getDouble("transX");
                        double d2 = v8Object2.getDouble("transY");
                        if ("none".equals(v8Object3.get("preserveAspectRatio"))) {
                            double d3 = v8Object3.getDouble("width");
                            double d4 = v8Object3.getDouble("height");
                            string = V8Context.this.context.createPattern(string2, d, d2, d3, d4);
                        } else {
                            string = V8Context.this.context.createPattern(string2, d, d2);
                        }
                    }
                    catch (Exception exception) {
                        FineLoggerFactory.getLogger().error(exception.getMessage(), (Throwable)exception);
                    }
                    finally {
                        if (v8Object2 != null) {
                            v8Object2.close();
                        }
                        if (v8Object3 != null) {
                            v8Object3.close();
                        }
                    }
                    return string;
                }
                throw new IllegalArgumentException("Failed to execute 'createPattern': 1 arguments required, but only " + v8Array.length() + " present.");
            }
        }, "createPattern");
        this.registerJavaMethod(new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() > 3) {
                    float f = (float)v8Array.getDouble(0);
                    float f2 = (float)v8Array.getDouble(1);
                    float f3 = (float)v8Array.getDouble(2);
                    float f4 = (float)v8Array.getDouble(3);
                    LinearGradientAdapter linearGradientAdapter = V8Context.this.context.createLinearGradient(f, f2, f3, f4);
                    return new V8LinearGradient(V8Context.this.v8, linearGradientAdapter);
                }
                throw new IllegalArgumentException("Failed to execute 'createLinearGradient': 4 arguments required, but only " + v8Array.length() + " present.");
            }
        }, "createLinearGradient");
        this.registerJavaMethod(new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() > 5) {
                    float f = (float)v8Array.getDouble(0);
                    float f2 = (float)v8Array.getDouble(1);
                    float f3 = (float)v8Array.getDouble(2);
                    float f4 = (float)v8Array.getDouble(3);
                    float f5 = (float)v8Array.getDouble(4);
                    float f6 = (float)v8Array.getDouble(5);
                    RadialGradientAdapter radialGradientAdapter = V8Context.this.context.createRadialGradient(f, f2, f3, f4, f5, f6);
                    return new V8RadialGradient(V8Context.this.v8, radialGradientAdapter);
                }
                throw new IllegalArgumentException("Failed to execute 'createRadialGradient': 6 arguments required, but only " + v8Array.length() + " present.");
            }
        }, "createRadialGradient");
        this.registerJavaMethod(new JavaVoidCallback(){

            public void invoke(V8Object v8Object, V8Array v8Array) {
                float[] fArray;
                V8Array v8Array2;
                if (v8Array.length() > 0) {
                    v8Array2 = v8Array.getArray(0);
                    int n = v8Array2.length();
                    fArray = new float[n];
                    for (int i = 0; i < n; ++i) {
                        fArray[i] = (float)v8Array2.getDouble(i);
                    }
                } else {
                    throw new IllegalArgumentException("Failed to execute 'setLineDash': 1 arguments required, but only " + v8Array.length() + " present.");
                }
                V8Context.this.context.setLineDash(fArray);
                v8Array2.close();
            }
        }, "setLineDash");
        this.registerJavaMethod(new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() > 0) {
                    Paint paint;
                    Object object = v8Array.get(0);
                    if (object != null) {
                        String string = object.toString();
                        if (object instanceof V8Object) {
                            ((V8Object)object).release();
                        }
                        paint = V8Context.this.context.setFillStyle(string);
                    } else {
                        paint = V8Context.this.context.getFillPaint();
                    }
                    if (paint instanceof TexturePaint) {
                        if (object instanceof V8Object) {
                            return v8Object.get("_fillStyle");
                        }
                        return object;
                    }
                    return V8Context.this.paint2JSObject(paint);
                }
                throw new IllegalArgumentException("Failed to execute 'setFillStyle': 1 arguments required, but only " + v8Array.length() + " present.");
            }
        }, "setFillStyle");
        this.registerJavaMethod(new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() > 0) {
                    Paint paint;
                    Object object = v8Array.get(0);
                    if (object != null) {
                        String string = object.toString();
                        if (object instanceof V8Object) {
                            ((V8Object)object).release();
                        }
                        paint = V8Context.this.context.setStrokeStyle(string);
                    } else {
                        paint = V8Context.this.context.getStrokePaint();
                    }
                    return V8Context.this.paint2JSObject(paint);
                }
                throw new IllegalArgumentException("Failed to execute 'setStrokeStyle': 1 arguments required, but only " + v8Array.length() + " present.");
            }
        }, "setStrokeStyle");
        this.registerJavaMethod(new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() > 1) {
                    int n = v8Array.getInteger(0);
                    int n2 = v8Array.getInteger(1);
                    ImageData imageData = V8Context.this.context.createImageData(n, n2);
                    return new V8ImageData(V8Context.this.v8, imageData);
                }
                throw new IllegalArgumentException("Failed to execute 'createImageData': 2 arguments required, but only " + v8Array.length() + " present.");
            }
        }, "createImageData");
        this.registerJavaMethod(new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() > 3) {
                    int n = v8Array.getInteger(0);
                    int n2 = v8Array.getInteger(1);
                    int n3 = v8Array.getInteger(2);
                    int n4 = v8Array.getInteger(3);
                    ImageData imageData = V8Context.this.context.getImageData(n, n2, n3, n4);
                    return new V8ImageData(V8Context.this.v8, imageData);
                }
                throw new IllegalArgumentException("Failed to execute 'getImageData': 4 arguments required, but only " + v8Array.length() + " present.");
            }
        }, "getImageData");
        this.registerJavaMethod(new JavaVoidCallback(){

            public void invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() > 2) {
                    V8Object v8Object2 = v8Array.getObject(0);
                    int n = v8Array.getInteger(1);
                    int n2 = v8Array.getInteger(2);
                    int n3 = v8Object2.getInteger("width");
                    int n4 = v8Object2.getInteger("height");
                    V8TypedArray v8TypedArray = (V8TypedArray)v8Object2.getArray("data");
                    v8Object2.close();
                    V8ArrayBuffer v8ArrayBuffer = v8TypedArray.getBuffer();
                    int n5 = v8ArrayBuffer.limit() >> 2;
                    int[] nArray = new int[n5];
                    for (int i = 0; i < n5; ++i) {
                        nArray[i] = v8ArrayBuffer.getInt();
                    }
                    v8TypedArray.close();
                    v8ArrayBuffer.close();
                    ImageData imageData = new ImageData(n3, n4, nArray);
                    if (v8Array.length() > 6) {
                        int n6 = v8Array.getInteger(3);
                        int n7 = v8Array.getInteger(4);
                        int n8 = v8Array.getInteger(5);
                        int n9 = v8Array.getInteger(6);
                        V8Context.this.context.putImageData(imageData, n, n2, n6, n7, n8, n9);
                    } else {
                        V8Context.this.context.putImageData(imageData, n, n2);
                    }
                } else {
                    throw new IllegalArgumentException("Failed to execute 'getImageData': 3 arguments required, but only " + v8Array.length() + " present.");
                }
            }
        }, "putImageData");
        this.registerJavaMethod(new JavaVoidCallback(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void invoke(V8Object v8Object, V8Array v8Array) {
                BufferedImage bufferedImage;
                int n = v8Array.length();
                boolean bl = false;
                if (n < 3) {
                    throw new IllegalArgumentException("Failed to execute 'getImageData': 3 arguments required, but only " + v8Array.length() + " present.");
                }
                Object object = v8Array.get(0);
                if (object instanceof V8Object) {
                    V8Object v8Object2 = (V8Object)object;
                    ImageProvider imageProvider = (ImageProvider)V8Context.this.v8Painter.getImageMap().get((Object)v8Object2);
                    if (imageProvider == null) return;
                    bl = imageProvider.isCanvas();
                    bufferedImage = imageProvider.getImage();
                    imageProvider.reset();
                    v8Object2.release();
                } else {
                    String string = (String)object;
                    bufferedImage = ImageUtils.getOrCreate(string);
                }
                try {
                    if (n < 5) {
                        int n2 = v8Array.getInteger(1);
                        int n3 = v8Array.getInteger(2);
                        if (!bl) {
                            V8Context.this.context.drawImage(bufferedImage, n2, n3);
                            return;
                        } else {
                            V8Context.this.context.scale(1.0 / (double)CanvasAdapter.RESOLUTION, 1.0 / (double)CanvasAdapter.RESOLUTION);
                            V8Context.this.context.drawImage(bufferedImage, n2 * CanvasAdapter.RESOLUTION, n3 * CanvasAdapter.RESOLUTION);
                            V8Context.this.context.scale(CanvasAdapter.RESOLUTION, CanvasAdapter.RESOLUTION);
                        }
                        return;
                    } else if (n < 9) {
                        int n4 = v8Array.getInteger(1);
                        int n5 = v8Array.getInteger(2);
                        int n6 = v8Array.getInteger(3);
                        int n7 = v8Array.getInteger(4);
                        V8Context.this.context.drawImage(bufferedImage, n4, n5, n6, n7);
                        return;
                    } else {
                        int n8 = v8Array.getInteger(1);
                        int n9 = v8Array.getInteger(2);
                        int n10 = v8Array.getInteger(3);
                        int n11 = v8Array.getInteger(4);
                        int n12 = v8Array.getInteger(5);
                        int n13 = v8Array.getInteger(6);
                        int n14 = v8Array.getInteger(7);
                        int n15 = v8Array.getInteger(8);
                        int n16 = bl ? CanvasAdapter.RESOLUTION : 1;
                        V8Context.this.context.drawImage(bufferedImage, n8, n9, n10, n11, n12, n13, n14, n15, n16);
                    }
                    return;
                }
                catch (Exception exception) {
                    FineLoggerFactory.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
            }
        }, "drawImage");
    }

    private Object paint2JSObject(Paint paint) {
        if (paint instanceof LinearGradientPaint) {
            return new V8LinearGradient(this.v8, LinearGradientAdapter.Paint2Adapter((LinearGradientPaint)paint));
        }
        if (paint instanceof RadialGradientPaint) {
            return new V8RadialGradient(this.v8, RadialGradientAdapter.Paint2Adapter((RadialGradientPaint)paint));
        }
        return CanvasUtils.color2Hexadecimal((Color)paint);
    }
}

