/*
 * Decompiled with CFR 0.152.
 */
package com.fr.graph.g2d.canvas.j2v8;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.eclipsesource.v8.utils.V8Map;
import com.fr.graph.g2d.canvas.CanvasAdapter;
import com.fr.graph.g2d.canvas.CanvasPainter;
import com.fr.graph.g2d.canvas.Image;
import com.fr.graph.g2d.canvas.ImageProvider;
import com.fr.graph.g2d.canvas.j2v8.V8Canvas;
import com.fr.graph.g2d.canvas.j2v8.V8Image;
import java.awt.image.BufferedImage;

public class V8Painter
extends CanvasPainter {
    private V8 v8;
    private CanvasAdapter canvas = new CanvasAdapter();
    private V8Map<ImageProvider> imageMap = new V8Map();

    public V8Painter() {
        this.init();
    }

    public V8Map<ImageProvider> getImageMap() {
        return this.imageMap;
    }

    public void init() {
        this.v8 = V8.createV8Runtime();
        V8Function v8Function = new V8Function(this.v8, new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                if (v8Array.length() == 2) {
                    int n = v8Array.getInteger(0);
                    int n2 = v8Array.getInteger(1);
                    return new V8Canvas(V8Painter.this, V8Painter.this.v8, new CanvasAdapter(n, n2));
                }
                return new V8Canvas(V8Painter.this, V8Painter.this.v8, new CanvasAdapter());
            }
        });
        V8Function v8Function2 = new V8Function(this.v8, new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                return new V8Image(V8Painter.this, V8Painter.this.v8, new Image());
            }
        });
        this.v8.add("Canvas", (V8Value)v8Function);
        this.v8.add("Image", (V8Value)v8Function2);
        v8Function.release();
        v8Function2.release();
        this.release();
    }

    @Override
    public BufferedImage paint() {
        this.acquire();
        try {
            this.execute();
            BufferedImage bufferedImage = this.canvas.getCanvas();
            return bufferedImage;
        }
        finally {
            this.clear();
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeFunction(String string, Object ... objectArray) {
        this.acquire();
        try {
            Object object = this.v8.executeJSFunction(string, objectArray);
            return object;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage paint(String string, Object ... objectArray) {
        this.acquire();
        try {
            BufferedImage bufferedImage;
            Object object;
            CanvasAdapter canvasAdapter = new CanvasAdapter();
            V8Canvas v8Canvas = new V8Canvas(this, this.v8, canvasAdapter);
            Object[] objectArray2 = new Object[objectArray.length + 1];
            try {
                objectArray2[0] = v8Canvas;
                System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                object = this.v8.executeJSFunction(string, objectArray2);
                if (object instanceof V8Object) {
                    ((V8Object)object).release();
                }
                bufferedImage = canvasAdapter.getImage();
            }
            finally {
                this.clear();
                v8Canvas.release();
            }
            object = bufferedImage;
            return object;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void close() {
        this.acquire();
        this.clear();
        this.v8.release(true);
    }

    @Override
    public void initCanvas() {
        this.acquire();
        try {
            V8Canvas v8Canvas = new V8Canvas(this, this.v8, this.canvas);
            this.imageMap.remove((Object)v8Canvas);
            this.v8.add("canvas", (V8Value)v8Canvas);
            v8Canvas.release();
        }
        finally {
            this.release();
        }
    }

    @Override
    public void execute(String string) {
        this.acquire();
        try {
            this.v8.executeVoidScript(string);
        }
        finally {
            this.release();
        }
    }

    private void execute() {
        this.v8.executeVoidScript(this.getSb().toString());
        this.getSb().setLength(0);
    }

    private void acquire() {
        this.v8.getLocker().acquire();
    }

    private void release() {
        this.v8.getLocker().release();
    }

    private void clear() {
        for (ImageProvider imageProvider : this.imageMap.values()) {
            imageProvider.dispose();
        }
        this.imageMap.clear();
    }
}

