(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["VanCharts"] = factory();
	else
		root["VanCharts"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 107);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _vMap = _interopRequireDefault(__webpack_require__(38));

var _EnvUtils = __webpack_require__(3);

var _CoreUtils = __webpack_require__(2);

var _HtmlUtils = __webpack_require__(71);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/5/4.
 * 一些最常用的工具方法
 */
var templateRe = /\{ *([\w_\-]+) *\}/g;
var lastID = 0;
var DOUBLE_PI = 2 * Math.PI;
var decimalPlacesRegExp = /(?:\d+)(?:\.(\d+))?(?:[eE]-(\d+))?/; // ["0.111e-7", "111", "7"]

var decimalRegExp = /\.|[eE]-\d+/g; // (1.1e-7 + '').match(/\.|e-\d+/ig) -> [".", "e-7"]
//options中不需要合并起来的key

var skipKeys = {
  'minSize': true,
  'maxSize': true,
  'name': true
};
var SCALE = 1; //https://stackoverflow.com/questions/39079171/phantomjs-failing-to-parse-date-correctly

var DATE_DELIMITER = _Browser["default"].phantomjs ? "-" : "/";
var styleToCss = {
  color: 'fill',
  font: 'font',
  fontFamily: 'font-family',
  fontSize: 'font-size',
  fontStretch: 'font-stretch',
  fontStyle: 'font-style',
  fontVariant: 'font-variant',
  fontWeight: 'font-weight',
  letterSpacing: 'letter-spacing',
  lineHeight: 'line-height',
  quotes: 'quotes',
  textAlign: 'text-align',
  textDecoration: 'text-decoration',
  textIndent: 'text-indent',
  textShadow: 'text-shadow',
  textTransform: 'text-transform',
  whiteSpace: 'white-space',
  wordSpacing: 'word-spacing',
  padding: 'padding'
}; // Time related fns
// All time-related calls within our project
// should use the fns from this util.
// i.e., the following fns.
// First, get & save the prefixed original fns.

var $T = {
  setTimeout: window.setTimeout,
  clearTimeout: window.clearTimeout,
  setInterval: window.setInterval,
  clearInterval: window.clearInterval,
  requestAnimationFrame: window.requestAnimationFrame || getPrefixed('RequestAnimationFrame'),
  cancelAnimationFrame: window.cancelAnimationFrame || getPrefixed('CancelAnimationFrame') || getPrefixed('CancelRequestAnimationFrame')
};

for (var k in $T) {
  if ($T.hasOwnProperty(k) && $T[k] && $T[k].bind) {
    //IE低版本兼容
    $T[k] = $T[k].bind(window);
  }
} // 项目当中的时间相关函数都用 $T 中的
// setTimeout只影响递归调用的时候，所以setTimeout 和 clearTimeout 改不改都一样
// setInterval 使用raf 实现了，所以替换一定要成对: clearInterval
// When the chart is inside iframe, hack
//
// `requestAnimationFrame`,
// `setTimeout`,
// `setInterval`, `clearInterval`.
//
// Pause them when iframe is invisible.
// Another side effect:
// Overwrite `setInterval` by `requestAnimationFrame`
// Because we use it for animation, it's safe to pause.
//
// Caveat: assume iframes under the main top window & not cross-origin


(function () {
  var running = true; // Since the hack might confuse you,
  // All `$T.foo` here are deemed to be hacked.
  // Save the origin as `oFoo` if used.
  // save original ref

  var oSetTimeout = $T.setTimeout;
  var oRAF = $T.requestAnimationFrame; // we do not hack these two

  var oCAF = $T.cancelAnimationFrame;
  var oClearTimeout = $T.clearTimeout;
  var iframe;

  try {
    // @CHART-1933, CHART-3334
    // IE下iframe跨域时获取window.frameElement直接抛错access dined. 这里写在try..catch里面
    iframe = window.frameElement;
  } catch (e) {// window.frameElement拒绝访问
  } // Inner iframe keeps checking on parent container element <iframe>.
  // So we have to access it.
  // If not, skip.


  if (iframe) {
    var pause = function () {
      running = false;
    };

    var resume = function () {
      if (running) {
        return;
      }

      running = true;
      var i = -1;

      while (++i < rafFns.length) {
        rafFns[i].call();
      }

      rafFns = [];
      i = -1;

      while (++i < setTimeoutFns.length) {
        var fn = setTimeoutFns[i];
        $T.setTimeout(fn, fn.__$delay__);
      }

      setTimeoutFns = [];
    }; // use original raf to keep checking


    // store the handlers to resume
    var rafFns = [];
    var setTimeoutFns = []; // don't hack nonnative raf

    if (oRAF) {
      // we got prefix
      $T.requestAnimationFrame = function (fn) {
        if (running) {
          // return to get id
          return oRAF(fn);
        } else {
          // If we ask animations to stop,
          // shall we allow them to run one frame more?
          rafFns.push(fn);
        }
      };
    } // 除非递归调用，否则是一样的


    $T.setTimeout = function (fn, delay) {
      if (running) {
        // return to get id
        return oSetTimeout(fn, delay);
      } else {
        // 这里目标是那种16ms递归调用
        // 其实也可以不要delay
        fn.__$delay__ = delay;
        setTimeoutFns.push(fn);
      }
    };

    var raf = oRAF || function (callback) {
      return oSetTimeout(callback, 16);
    };

    raf(function check() {
      if ((iframe.style.display || '').toLowerCase() === 'none' // CHART-2298 cross-origin
      // || (window.top && window.top.__VAN_ANIM_STOP__) // for debug & test
      ) {
          pause();
        } else {
        resume();
      }

      raf(check);
    });
  }

  var requestAnimFrame = $T.requestAnimationFrame || function (callback) {
    return _Browser["default"].phantomjs ? window.setTimeout(callback, 16) : $T.setTimeout(callback, 16);
  }; // Implement `setInterval` by raf (or setTimeout).
  // Thus it is hacked version.


  $T.setInterval = function (fn, delay) {
    var start = new Date().getTime(),
        // id changed, make an object to keep id ref
    handle = {};

    function loop() {
      handle.value = requestAnimFrame(loop);
      var current = new Date().getTime(),
          delta = current - start;

      if (delta >= delay) {
        fn.call();
        start = new Date().getTime();
      }
    }

    handle.value = requestAnimFrame(loop);
    return handle;
  }; // additional hack for `clearInterval`


  $T.clearInterval = oCAF ? function (handle) {
    if (handle) {
      oCAF(handle.value);
    }
  } : function (handle) {
    if (handle) {
      oClearTimeout(handle.value);
    }
  };

  if (_Browser["default"].phantomjs) {
    $T.setTimeout = window.setTimeout;
  } // hack end
  // now all we need is $T.x instead of window.x

})();
/**
 * 存储间距缩放比例
 * @param scale
 * @returns {boolean} scale改变返回true
 */


function initPaddingScale(scale) {
  SCALE = scale || 1;
  return;
}
/**
 * pick参数里第一个不为null和undefined的值
 * @returns {*}
 */


function pick() {
  var arg,
      length = arguments.length;

  for (var i = 0; i < length; i++) {
    arg = arguments[i];

    if (typeof arg !== 'undefined' && arg !== null) {
      return arg;
    }
  }

  return null;
}
/**
 * 判断指定值是否在指定数组中(ie14以下不支持array.includes())
 * @param array
 * @param target
 * @returns {boolean}
 */


function includes(array, target) {
  for (var i = 0; i < array.length; i++) {
    if (array[i] === target) {
      return true;
    }
  }

  return false;
}
/**
 * 判断对象是否是数组
 * @param value 对象
 * @returns {boolean} 是否是数组
 */


function isArray(value) {
  return Object.prototype.toString.apply(value) === '[object Array]';
}
/**
 * 将具有length属性的对象转成数组
 * @param sequence 对象
 */


function toArray(sequence) {
  return Array.prototype.slice.call(sequence);
}

function setTextStyle(textS, style) {
  style = cssNormalization(style);

  for (var attr in style) {
    textS.style(attr, style[attr]);
  }
}
/**
 * get text dimension by html, svg or canvas
 * @param {string} text
 * @param {object} style
 * @param {boolean} useHtml
 */


function getTextDimension(text, style, useHtml) {
  return (0, _EnvUtils._getTextDimension)(text, style, useHtml);
}

function getTextWrapDimension(text, style, useHTML) {
  if (false) {}

  var newStyle = extend({
    'white-space': 'normal',
    'whiteSpace': 'normal',
    'word-wrap': 'break-word',
    'wordWrap': 'break-word'
  }, style);
  return (0, _EnvUtils._getHtmlTextDim)(text, newStyle, useHTML);
}

function getTextBBoxWithRotation(domWrapper, rotation) {
  rotation = toRadian(rotation);
  var node = domWrapper.node();
  var text = domWrapper.type === 'div' ? node.innerHTML : node.textContent;
  var style = domWrapper.styles;
  var useHtml = !(0, _EnvUtils.isSupportSVG)();
  var dim = (0, _EnvUtils._getTextDimension)(text, style, useHtml);
  var cos = Math.abs(Math.cos(rotation)),
      sin = Math.abs(Math.sin(rotation));
  var width = dim.width,
      height = dim.height;
  return {
    width: width * cos + height * sin,
    height: width * sin + height * cos
  };
}

function getGradientBackgroundCssText(color) {
  var cssText = [];
  var startColor = color.startColor;
  var endColor = color.endColor;
  var start = 'left';
  var startPos = 'left top';
  var endPos = 'right top';
  var type = 1;

  if (color.x1 === color.x2) {
    start = 'top';
    startPos = 'left top';
    endPos = 'left bottom';
    type = 0;
  }

  cssText.push('background: -ms-linear-gradient(' + start + ', ' + startColor + ', ' + endColor + ')');
  cssText.push('background-image: -moz-linear-gradient(' + start + ', ' + startColor + ', ' + endColor + ')');
  cssText.push('background-image: -webkit-gradient(linear, ' + startPos + ', ' + endPos + ', color-stop(0, ' + startColor + '), color-stop(1, ' + endColor + '))');
  cssText.push('filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=' + _ColorUtils["default"].colorToHexARGB(startColor) + ', endColorstr=' + _ColorUtils["default"].colorToHexARGB(endColor) + ', GradientType=' + type + ')');
  return cssText;
}

function getBorderCssText(opt) {
  var cssText = [];

  if (opt.borderWidth != null) {
    cssText.push('border-style:solid');
    cssText.push('border-width:' + opt.borderWidth + 'px');
  }

  if (opt.borderColor != null) {
    cssText.push('border-color:' + opt.borderColor);
  }

  if (opt.borderRadius != null) {
    cssText.push('border-radius:' + opt.borderRadius + 'px');
    cssText.push('-moz-border-radius:' + opt.borderRadius + 'px');
    cssText.push('-webkit-border-radius:' + opt.borderRadius + 'px');
    cssText.push('-o-border-radius:' + opt.borderRadius + 'px');
  }

  return cssText;
}

function setFullScreenDomBackground(dom, opt) {
  setDomBackground(dom, opt, true);
}

function setNormalScreenDomBackground(dom, opt) {
  setDomBackground(dom, opt, false);
}

function setDomBackground(dom, opt, isFullScreenChart) {
  var cssText = [];

  if (opt.backgroundColor) {
    var backgroundColor = isFullScreenChart ? getFullScreenBackgroundColor(opt.backgroundColor) : opt.backgroundColor;

    if (typeof backgroundColor == 'string') {
      if ((0, _EnvUtils.isSupportSVG)()) {
        cssText.push('background-Color:' + backgroundColor);
      } else {
        var hexAlpha = _ColorUtils["default"].colorToHexAlpha(backgroundColor);

        cssText.push('background-Color:' + hexAlpha.hex);
        cssText.push('filter:alpha(opacity=' + hexAlpha.alpha * 100 + ')');
      }
    } else if (typeof backgroundColor == 'object') {
      cssText = cssText.concat(getGradientBackgroundCssText(backgroundColor));
    }
  }

  if (opt.backgroundImage) {
    cssText.push('background-image:url(' + opt.backgroundImage + ')');
    cssText.push('background-size:100% 100%');
  }

  cssText = cssText.concat(getBorderCssText(opt));

  if (opt.shadow) {
    cssText.push('box-shadow:1px 1px 2px rgba(0,0,0,0.2)');
  }

  dom.style.cssText += ';' + cssText.join(';') + ';';
}

function getFullScreenBackgroundColor(backgroundColor) {
  if (backgroundColor == null) {
    return;
  }

  if (typeof backgroundColor == 'string') {
    return _ColorUtils["default"].colorToHex(backgroundColor);
  }

  if (typeof backgroundColor == 'object') {
    return {
      x1: backgroundColor.x1,
      y1: backgroundColor.y1,
      x2: backgroundColor.x2,
      y2: backgroundColor.y2,
      startColor: _ColorUtils["default"].colorToHex(backgroundColor.startColor),
      endColor: _ColorUtils["default"].colorToHex(backgroundColor.endColor)
    };
  }
}

function stamp(obj) {
  obj._vanchart_id = obj._vanchart_id || 'vancharts' + ++lastID;
  return obj._vanchart_id;
} //properties mix in


function extend(dest) {
  var i, j, len, src;

  for (j = 1, len = arguments.length; j < len; j++) {
    src = arguments[j];

    for (i in src) {
      dest[i] = src[i];
    }
  }

  return dest;
}

function domRotate(div, rotation) {
  var cssText = [];
  cssText.push('transform:rotate(' + rotation + 'deg)');
  cssText.push('-ms-transform:rotate(' + rotation + 'deg)');
  cssText.push('-webkit-transform:rotate(' + rotation + 'deg)');
  cssText.push('-moz-transform:rotate(' + rotation + 'deg)');
  cssText.push('-o-transform:rotate(' + rotation + 'deg)');
  var costheta = Math.cos(toRadian(rotation));
  var sintheta = Math.sin(toRadian(rotation)); //ie9的时候filter和ms-transform同时生效了

  if (!(0, _EnvUtils.isSupportSVG)()) {
    var filter = rotation ? ['progid:DXImageTransform.Microsoft.Matrix(M11=', costheta, ', M12=', -sintheta, ', M21=', sintheta, ', M22=', costheta, ', sizingMethod=\'auto expand\')'].join('') : 'none';
    cssText.push('filter:' + filter);
  }

  div.style.cssText += cssText.join(';') + ';';
} //breakWord == false:英文截断时用-连接。之后可能会考虑数字


function splitText(text, style, offeredSize, padding, breakWord) {
  if (!text) {
    return [];
  }

  text += '';
  padding = padding || 0;
  offeredSize -= 2 * padding;
  var result = [];
  var startIndex = 0;
  var textCount = text.length;

  while (startIndex < textCount) {
    var i = startIndex;

    while (getTextDimension(text.substring(i, startIndex + 1), style, false).width < offeredSize) {
      startIndex++;

      if (startIndex >= textCount) {
        break;
      }
    }

    if (i == startIndex) {
      //一个字符都放不下的时候显示。。。吧
      return ['...'];
    } else {
      var substring = text.substring(i, startIndex);

      if (breakWord == false && startIndex != textCount && startIndex - 1 > i) {
        var lastChar = text.charAt(startIndex - 1);
        var nextChar = text.charAt(startIndex); //本行最后一个&&下一行第一个字符都是英文，才考虑用"-"连接

        if (/[A-Za-z]/.test(lastChar) && /[A-Za-z]/.test(nextChar)) {
          var _char = text.charAt(startIndex - 2);

          substring = text.substring(i, startIndex - 1);
          startIndex--;

          if (_char !== ' ' && _char !== '-') {
            substring += '-';
          }
        } //数字换行，没考虑负数，没考虑下一行第一个不是数字
        // else if(/[0-9]/.test(lastChar)){
        //     var lastIndex = startIndex - 1;
        //
        //     while (lastIndex > i){
        //         var char = text.charAt(lastIndex - 1);
        //         lastIndex--;
        //         if(!/[0-9]/.test(char)){
        //             break;
        //         }
        //     }
        //     if(lastIndex == i){//数字本身一行放不下
        //         lastIndex = startIndex - 1;
        //     }
        //
        //     startIndex = lastIndex + 1;
        //     substring = text.substring(i, startIndex);
        // }

      }

      result.push(substring);
    }
  }

  return result;
}
/**
 * 文本显示不下时先换行显示，如果换行(最多两行)还显示不下，再缩小字体；
 * 字体最小为minSize还显示不下，再加缩略显示
 */


function splitAndShrinkText(text, minSize, style, offeredSize, useHtml, padding, breakWord) {
  var fontStyle = clone(style);
  var content = splitText(text, fontStyle, offeredSize, padding, breakWord);
  var fontSize = parseFloat(fontStyle.fontSize);

  while (content.length > 2) {
    fontSize = fontSize - 1;
    fontStyle.fontSize = fontSize;
    content = splitText(text, fontStyle, offeredSize, padding, breakWord);

    if (fontStyle.fontSize <= minSize && content.length > 2) {
      fontStyle.fontSize = minSize;
      var end = content[1] + content[2];
      content[1] = getEllipsisText(end, offeredSize, fontStyle, useHtml);
      content = [content[0], content[1]];
      fontSize = minSize;
      break;
    }
  }

  return {
    text: content,
    fontSize: fontSize + 'px'
  };
}
/**
 * 文本显示不下时，先缩小字体，字体最小为minSize还显示不下，再加缩略显示
 */


function shrinkText(text, minSize, fontHeight, limitWidth, style, useHtml) {
  var fontStyle = clone(style);
  fontStyle.fontSize = Math.max(fontHeight, minSize);
  var widthOrigin = getTextDimension(text, fontStyle, useHtml).width;

  if (limitWidth <= 0) {
    return {
      labelContent: '',
      fontSize: fontStyle.fontSize + 'px'
    };
  }

  while (widthOrigin >= limitWidth) {
    fontStyle.fontSize -= 1;

    if (fontStyle.fontSize <= minSize) {
      fontStyle.fontSize = minSize;
      text = getEllipsisText(text, limitWidth, fontStyle, useHtml);
      break;
    }

    widthOrigin = getTextDimension(text, fontStyle, useHtml).width;
  }

  return {
    labelContent: text,
    fontSize: fontStyle.fontSize + 'px'
  };
}

function getTextDimensionWithRotation(text, style, useHtml, rotation) {
  var dim = getTextDimension(text, style, useHtml);
  return getTextDimRotated(dim, rotation);
}

function getTextDimRotated(dim, rotation) {
  var angle = Math.abs(toRadian(rotation || 0));
  var width = dim.width * Math.cos(angle) + dim.height * Math.sin(angle);
  var height = dim.width * Math.sin(angle) + dim.height * Math.cos(angle);
  return {
    width: width,
    height: height
  };
}

function getDotCount(usableWidth, dotWidth) {
  if ((0, _CoreUtils.isNumberValue)(usableWidth) && (0, _CoreUtils.isNumberValue)(dotWidth) && Math.abs(dotWidth) > 1e-6) {
    return Math.floor(usableWidth / dotWidth);
  }

  return 0;
}

function getDotStr(count) {
  if (!(0, _CoreUtils.isNumberValue)(count) || Math.abs(count) < 1e-6) {
    return '';
  }

  var fillFun = function () {
    return '.';
  };

  var dotArray = getTargetFillArray(count, fillFun);
  return dotArray.join('');
}

function getEllipsisText(text, limit, style, useHtml) {
  var textString = text + '';
  var len = textString.length;
  var originWidth = getTextDimension(textString, style, useHtml).width;
  var dotWidth = getTextDimension('.', style, useHtml).width;

  if (originWidth <= limit) {
    return text;
  }

  var end = 0;

  while (++end <= len) {
    var content = textString.slice(0, end);
    var width = getTextDimension(content, style, useHtml).width;

    if (width > limit) {
      var ellipsis = '',
          left = textString.slice(0, Math.max(end - 1, 0));
      var count = getDotCount(limit - getTextDimension(left, style, useHtml).width, dotWidth);

      if (count > 0) {
        ellipsis = getDotStr(count);
      } else if (left) {
        left = left.slice(0, left.length - 1);
        count = getDotCount(limit - getTextDimension(left, style, useHtml).width, dotWidth);
        ellipsis = getDotStr(count);
      } else {
        ellipsis = '.';
      }

      return left + ellipsis;
    }
  }
} //style对象的表示方法转css表示


function cssNormalization(style) {
  var result = {};

  for (var attr in style) {
    if (styleToCss[attr]) {
      result[styleToCss[attr]] = style[attr];
    }

    if (attr == 'color') {
      result.color = style[attr];
    } //转px


    if (attr == 'fontSize') {
      var fontSize = style[attr];

      if (fontSize.indexOf('pt') != -1) {
        fontSize = parseFloat(fontSize) * 4 / 3;
        result['font-size'] = fontSize + 'px';
      }
    }
  }

  return result;
}
/**
 * css类属性数组补全，如padding，margin等~
 */


function reformCssArray(p) {
  if (p instanceof Array) {
    switch (p.length + '') {
      case '4':
        return p;

      case '3':
        return [p[0], p[1], p[2], p[1]];

      case '2':
        return [p[0], p[1], p[0], p[1]];

      case '1':
        return [p[0], p[0], p[0], p[0]];

      case '0':
        return [0, 0, 0, 0];
    }
  } else {
    return [p, p, p, p];
  }
}

function lineSubPixelOpt(pos, lineWidth) {
  return lineWidth % 2 === 0 ? Math.round(pos) : Math.round(pos - 0.5) + 0.5;
}

function rectSubPixelOpt() {
  var x, y, width, height, lineWidth;

  if (arguments.length === 2) {
    x = arguments[0].x;
    y = arguments[0].y;
    width = arguments[0].width;
    height = arguments[0].height;
    lineWidth = arguments[1];
  } else {
    x = arguments[0];
    y = arguments[1];
    width = arguments[2];
    height = arguments[3];
    lineWidth = arguments[4];
  }

  lineWidth = lineWidth || 0;
  var x1, y1, x2, y2;
  x1 = lineSubPixelOpt(x, lineWidth);
  y1 = lineSubPixelOpt(y, lineWidth);
  x2 = lineSubPixelOpt(x + width, lineWidth);
  y2 = lineSubPixelOpt(y + height, lineWidth); // @CHART-1509: (y1:(20.1->20.5)+height1:(19.9->20)=40.5) !=  (y2:(20.6->20.5)+height2(19.4->19) = 39.5)

  return {
    x: x1,
    y: y1,
    width: x2 - x1,
    height: y2 - y1
  };
}

function addArray(targetArray, sourceArray) {
  var result = [];

  if (targetArray && targetArray.length) {
    for (var i = 0, len = targetArray.length; i < len; i++) {
      result.push(targetArray[i]);
    }
  }

  if (sourceArray && sourceArray.length) {
    for (var i = 0, len = sourceArray.length; i < len; i++) {
      result.push(sourceArray[i]);
    }
  }

  return result;
}

function toFront(el) {
  if (el && el.parentNode) {
    el.parentNode.appendChild(el);
  }
}

function toBack(el) {
  if (el && el.parentNode) {
    el.parentNode.insertBefore(el, el.parentNode.firstChild);
  }
}

function toFrontOfAll(el) {
  el.ownerSVGElement.appendChild(el);
}

function toBackOfAll(el) {
  el.ownerSVGElement.appendChild(el, el.ownerSVGElement.firstChild);
} // 一定是在同一个坐标原点下


function containsRect(biggerOne, smallOne) {
  return biggerOne.x <= smallOne.x && biggerOne.y <= smallOne.y && biggerOne.x + biggerOne.width >= smallOne.x + smallOne.width && biggerOne.y + biggerOne.height >= smallOne.y + smallOne.height;
}

function rectangleOverlapped(aBounds, bBounds) {
  if (!aBounds || !bBounds) {
    return false;
  }

  var minx = Math.max(aBounds.x, bBounds.x);
  var miny = Math.max(aBounds.y, bBounds.y);
  var maxx = Math.min(aBounds.x + aBounds.width, bBounds.x + bBounds.width);
  var maxy = Math.min(aBounds.y + aBounds.height, bBounds.y + bBounds.height);
  return minx < maxx && miny < maxy;
}
/**
 * 测试线段与线段是否相交
 * @param a1 - The start point of the first line
 * @param a2 - The end point of the first line
 * @param b1 - The start point of the second line
 * @param b2 - The end point of the second line
 * @returns {boolean}
 */


function lineLine(a1, a2, b1, b2) {
  // b1->b2向量 与 a1->b1向量的向量积
  var ua_t = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x); // a1->a2向量 与 a1->b1向量的向量积

  var ub_t = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x); // a1->a2向量 与 b1->b2向量的向量积

  var u_b = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y); // u_b == 0时，角度为0或者180 平行或者共线不属于相交

  if (u_b !== 0) {
    var ua = ua_t / u_b;
    var ub = ub_t / u_b;

    if (0 <= ua && ua <= 1 && 0 <= ub && ub <= 1) {
      return true;
    }
  }

  return false;
}
/**
 * !#zh 测试线段与矩形是否相交
 * @param a1 - The start point of the line
 * @param a2 - The end point of the line
 * @param b - The rect
 * @return {boolean}
 */


function lineRect(a1, a2, b) {
  var r0 = {
    x: b.x,
    y: b.y
  };
  var r1 = {
    x: b.x,
    y: b.y + b.height
  };
  var r2 = {
    x: b.x + b.width,
    y: b.y + b.height
  };
  var r3 = {
    x: b.x + b.width,
    y: b.y
  };

  if (lineLine(a1, a2, r0, r1)) {
    return true;
  }

  if (lineLine(a1, a2, r1, r2)) {
    return true;
  }

  if (lineLine(a1, a2, r2, r3)) {
    return true;
  }

  return lineLine(a1, a2, r3, r0);
}

function outsideRect(biggerOne, smallOne) {
  return !containsRect(biggerOne, smallOne) && !rectangleOverlapped(biggerOne, smallOne);
}
/*
* @param {object} rect 检测区域，包含x,y,width,height
* @param {object/array} point 检测的点
* 用于检测某点是否在某个区域中
* */


function containsPoint(rect, point) {
  if (!rect || !point) {
    return false;
  }

  var x = pick(point.x || point[0]);
  var y = pick(point.y || point[1]);
  return rect.x < x && rect.x + rect.width > x && rect.y < y && rect.y + rect.height > y;
}

function isValidRect(bounds) {
  var width = bounds.width,
      height = bounds.height;
  return width > 0 && height > 0;
}

function makeValueInRange(min, max, value) {
  var rMin = Math.min(min, max);
  var rMax = Math.max(min, max);
  var gap = rMax - rMin;
  return ((value - rMin) % gap + gap) % gap + rMin;
}

function getValueInDomain(value, domain) {
  return Math.min(Math.max(value, domain[0]), domain[1]);
}

function toRadian(degree) {
  return Math.PI * (degree / 180);
}

function toDegree(radian) {
  return radian * 180 / Math.PI;
} // 设计器那边传过来的formatter函数是字符串


function getFormatterFunction(formatter) {
  if (formatter == null || formatter === '') {
    return null;
  }

  if (typeof formatter == 'string') {
    var formatterFunc = new Function("return " + formatter)(); //浙江农信的奇葩问题

    if (typeof formatterFunc == 'string') {
      eval("var _tmpFunc = " + formatterFunc);
      return _tmpFunc;
    }

    return formatterFunc;
  }

  return formatter;
}

function format(cv, fmt) {
  if (fmt && fmt.match && fmt.match(/D/)) {
    //在fmt为时间型或日期型时，若后台传过来的cv是字符串型毫秒数，将cv转为数值
    cv = (0, _CoreUtils.isEmpty)(cv) || isNaN(cv) ? cv : +cv;
  }

  fmt = getFormatterFunction(fmt);

  try {
    return typeof fmt === 'function' ? fmt.bind(cv)(cv) : cv;
  } catch (e) {
    //这边try catch 一下。很多自定义格式，很可能会抛错
    return cv;
  }
}

function endsWith(str, search, this_len) {
  if (str == null || search == null) {
    return false;
  }

  if (this_len === undefined || this_len > str.length) {
    this_len = str.length;
  }

  return str.substring(this_len - search.length, this_len) === search;
}

function startsWith(str, search, pos) {
  pos = !pos || pos < 0 ? 0 : +pos;
  return str.substring(pos, pos + search.length) === search;
}

function clone(obj) {
  // Handle the 3 simple types, and null or undefined
  if (null == obj || "object" != typeof obj) {
    return obj;
  } // Handle Date


  if (obj instanceof Date) {
    var copy = new Date();
    copy.setTime(obj.getTime());
    return copy;
  } // Handle Array


  if (obj instanceof Array) {
    var copy = [];

    for (var i = 0, len = obj.length; i < len; ++i) {
      copy[i] = clone(obj[i]);
    }

    return copy;
  }

  if (obj instanceof String) {
    // convert String 'object' to 'string'
    // do not use String object
    return obj + '';
  } // Handle Object


  if (obj instanceof Object) {
    var copy = {};

    for (var attr in obj) {
      if (obj.hasOwnProperty(attr)) {
        copy[attr] = clone(obj[attr]);
      }
    }

    return copy;
  }
}

function makeBounds() {
  var x = 0,
      y = 0,
      width = 0,
      height = 0;

  if (arguments.length === 2) {
    var pos = arguments[0];
    var dim = arguments[1];
    x = pick(pos.x, pos[0]);
    y = pick(pos.y, pos[1]);
    width = pick(dim.width, dim[0]);
    height = pick(dim.height, dim[1]);
  } else if (arguments.length === 4) {
    x = arguments[0];
    y = arguments[1];
    width = arguments[2];
    height = arguments[3];
  }

  return {
    x: x,
    y: y,
    width: width,
    height: height
  };
}

function distance(p1, p2) {
  var x1 = pick(p1.x, p1[0]);
  var y1 = pick(p1.y, p1[1]);
  var x2 = pick(p2.x, p2[0]);
  var y2 = pick(p2.y, p2[1]);
  var detX = x1 - x2;
  var detY = y1 - y2;
  return Math.sqrt(detX * detX + detY * detY);
}

function log(logBase, value) {
  return accDiv(newMathLog(value), newMathLog(logBase));
}
/**
 * Math.pow(Math.E, Math.log(0.1)) = 0.10000000000000003
 * 而 Math.pow(Math.E, Math.log(10)) = 10
 * @param value
 * @returns {number}
 */


function newMathLog(value) {
  return value < 1 ? -Math.log(accDiv(1, value)) : Math.log(value);
}

function getOrder(value) {
  var order = 0;

  if (value > 0 && value < 1) {
    while (value < 1) {
      value = accMul(value, 10);
      order--;
    }
  } else if (value >= 10) {
    while (value >= 10) {
      value = accDiv(value, 10);
      order++;
    }
  }

  return order;
} //用百分比表示或者数字表示的值


function getPercentValue(value, total) {
  if (value) {
    value += '';

    if (value.indexOf('%') != -1) {
      value = parseFloat(value) * total / 100;
    }

    return parseFloat(value);
  }

  return 0;
} // 1.1e-7 -> 8


function getDecimalPlaces(num) {
  var m = (num + '').match(decimalPlacesRegExp);
  return m ? (m[1] ? m[1].length : 0) + (+m[2] || 0) : 0;
}

function accAdd(arg1, arg2) {
  if (arg1 % 1 === 0 && arg2 % 1 === 0) {
    return arg1 + arg2;
  }

  var r1 = getDecimalPlaces(arg1);
  var r2 = getDecimalPlaces(arg2);
  var m = Math.pow(10, Math.max(r1, r2));
  return (accMul(arg1, m) + accMul(arg2, m)) / m;
}

function accDiv(arg1, arg2) {
  if (arg1 % 1 === 0 && arg2 % 1 === 0) {
    return arg1 / arg2;
  }

  var s1 = arg1 + '',
      s2 = arg2 + '';
  var m = -getDecimalPlaces(arg1);
  m += getDecimalPlaces(arg2);
  var a = s1.replace(decimalRegExp, '');
  var b = s2.replace(decimalRegExp, '');
  return m > 0 ? a / b * Math.pow(10, m) : a / b / Math.pow(10, -m);
}

function accMul(arg1, arg2) {
  if (arg1 % 1 === 0 && arg2 % 1 === 0) {
    return arg1 * arg2;
  }

  var s1 = arg1 + '',
      s2 = arg2 + '';
  var m = getDecimalPlaces(arg1);
  m += getDecimalPlaces(arg2);
  return s1.replace(decimalRegExp, '') * s2.replace(decimalRegExp, '') / Math.pow(10, m);
}
/**
 * 将value扩展成一个比较符合人类阅读习惯的数值。
 * @param value
 * @param count {Number} 刻度数量
 * @returns {*}
 */


function niceValue(value, count) {
  value = +value; // [0, value] 或者[value, 0]之间设定有count-1个区间，也就是count个刻度。

  count = count - 1 || 4;
  var step = value / count,
      isReversed = value < 0;
  step = Math.abs(step);
  value = Math.abs(value); // 获取当前step的数量级

  var magnitude = parseInt(Math.log(step) / Math.log(10)); // value === 0的时候

  if (!isFinite(magnitude)) {
    return value;
  } // 现在获取当前数量级的第一个值


  var nextOrderMagnitude = Math.pow(10, magnitude); // 如果这个时候step正好等于nextOrderMagnitute，
  // 我们就不要获取下一个数量级的第一个值了，因为step就很完美

  if (step !== nextOrderMagnitude) {
    magnitude += 1;
    nextOrderMagnitude = Math.pow(10, magnitude);
  } // 将step转化成(0, 1]之间的数值


  var newStep = step / nextOrderMagnitude;
  var arr = [0.1, 0.2, 0.25, 0.5, 1]; // 将newStep转化成符合人类阅读习惯的数值

  arr.some(function (item) {
    if (newStep < item) {
      newStep = item;
      return true;
    }
  });
  newStep = accMul(newStep, Math.pow(10, magnitude));
  var num = newStep * count;
  return isReversed ? num * -1 : num;
}

function objectToArray(object) {
  if (object.length) {
    return [].slice.call(object);
  }

  var result = [];

  for (var key in object) {
    result.push(object[key]);
  }

  return result;
}

function date2int(date) {
  if (date == null) {
    return null;
  }

  var baseDate = new Date("1970-01-01"); // @CHART-1496(😔😔😔😔😔😔)

  date = object2date(date);
  return date.getTime() - baseDate.getTime();
}

function int2date(milliseconds) {
  var baseDate = new Date("1970-01-01");
  milliseconds = milliseconds || 0;
  return new Date(milliseconds + baseDate.getTime());
}

function object2date(obj) {
  if (!obj) {
    return new Date(undefined);
  }

  var date = obj;

  if (typeof date == 'string' && isNaN(date)) {
    // 日期型
    date = new Date(Date.parse(date.replace(/[-/|\.]/g, DATE_DELIMITER)));

    if ((date == "Invalid Date" || date == "NaN") && FR && FR.str2Date) {
      date = FR.str2Date(obj, "yyyy-MM-dd HH:mm:ss");
    }
  } else if (!isNaN(date)) {
    // 毫秒数
    date = new Date(+date);
  }

  return date;
}

function makeTranslate(pos) {
  var x = pick(pos.x, pos[0]);
  var y = pick(pos.y, pos[1]);
  return 'translate(' + x + ',' + y + ')';
}

function makeTranslate3d(pos) {
  var x = pick(pos.x, pos[0]);
  var y = pick(pos.y, pos[1]);
  var z = pick(pos.z, pos[2], 0);
  return 'translate3d(' + x + 'px,' + y + 'px,' + z + 'px)';
}

function makeTranslateWithPX(pos) {
  var x = pick(pos.x, pos[0]);
  var y = pick(pos.y, pos[1]);
  return 'translate(' + x + 'px,' + y + 'px)';
}

function isImageMarker(markerType) {
  var ALL_SYMBOLS = _Constants["default"].LOCATION + _Constants["default"].STAR + _Constants["default"].CIRCLE + _Constants["default"].SQUARE + _Constants["default"].DIAMOND + _Constants["default"].TRIANGLE + _Constants["default"].CIRCLE_HOLLOW + _Constants["default"].SQUARE_HOLLOW + _Constants["default"].DIAMOND_HOLLOW + _Constants["default"].TRIANGLE_HOLLOW + _Constants["default"].SYMBOL_AUTO + _Constants["default"].ANCHOR_ICON;
  return ALL_SYMBOLS.indexOf(markerType) == -1 && (0, _CoreUtils.hasDefined)(markerType);
}

function isNullMarker(marker) {
  return (0, _CoreUtils.hasNotDefined)(marker.symbol);
}

function getDefaultMarkerSymbol(seriesIndex) {
  var ALL_SYMBOLS = [_Constants["default"].CIRCLE, _Constants["default"].CIRCLE_HOLLOW, _Constants["default"].SQUARE, _Constants["default"].SQUARE_HOLLOW, _Constants["default"].DIAMOND, _Constants["default"].DIAMOND_HOLLOW, _Constants["default"].TRIANGLE, _Constants["default"].TRIANGLE_HOLLOW];
  return ALL_SYMBOLS[seriesIndex % ALL_SYMBOLS.length];
}

function splitWords(str) {
  str = str.trim ? str.trim() : str.replace(/^\s+|\s+$/g, '');
  return str.split(/\s+/);
}

function trim(str) {
  return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g, '');
}

function removeEvent(el, type, fn) {
  if (el.removeEventListener) {
    el.removeEventListener(type, fn, false);
  } else if (el.attachEvent) {
    el.detachEvent('on' + type, fn);
  }
}

function dealFloatPrecision(v) {
  return Math.abs(v) < 1e-6 ? 0 : v;
}

function getDomWidth(root) {
  if (root.getWidth) {
    return root.getWidth();
  }

  var stl = root.currentStyle || document.defaultView.getComputedStyle(root);
  return ((root.clientWidth || parseInt(stl.width, 10)) - parseInt(stl.paddingLeft, 10) - parseInt(stl.paddingRight, 10)).toFixed(0) - 0;
}

function getDomHeight(root) {
  if (root.getHeight) {
    return root.getHeight();
  }

  var stl = root.currentStyle || document.defaultView.getComputedStyle(root);
  return ((root.clientHeight || parseInt(stl.height, 10)) - parseInt(stl.paddingTop, 10) - parseInt(stl.paddingBottom, 10)).toFixed(0) - 0;
}

function hasTouch() {
  var doc = window.document;
  return doc && doc.documentElement.ontouchstart !== undefined;
}

function getArcPoint(r, radian) {
  return [r * Math.sin(radian), -r * Math.cos(radian)];
}

function getArcByPoint(x, y) {
  return (2 * Math.PI - (Math.atan2(y, x) - Math.PI / 2)) % (2 * Math.PI);
}

function calculateAutoMinMaxAndGap(minValue, maxValue, splitNumber) {
  if (maxValue < minValue) {
    minValue = 0;
    maxValue = 100;
  }

  var increment = accAdd(maxValue, -minValue);
  var order = getOrder(increment);
  var pow = Math.pow(10, order);

  if (order <= 0) {
    minValue = accMul(minValue, Math.pow(10, 1 - order));
    minValue = accDiv(Math.floor(minValue), Math.pow(10, 1 - order));
  } else {
    minValue = Math.floor(minValue / pow) * pow;
  }

  var base = accMul(accDiv(splitNumber, 10), pow);
  var gap = 0;

  while (gap < increment) {
    gap = accAdd(base, gap);
  }

  var bd = accDiv(gap, splitNumber);

  while (minValue + bd * splitNumber < maxValue) {
    gap = accAdd(base, gap);
    bd = accDiv(gap, splitNumber);
  }

  gap = accDiv(gap, splitNumber);
  maxValue = accAdd(minValue, accMul(gap, splitNumber));
  return [minValue, maxValue, gap];
} //原因：FR重写了Array.prototype.indexOf，递归所有属性
//point-points-series-point


function indexOf(array, el) {
  for (var i = 0; i < array.length; i++) {
    if (array[i] === el) {
      return i;
    }
  }

  return -1;
}

function hasChn(str) {
  return /[\u4E00-\u9FA5]/.test(str);
}
/**
 * 根据缩放统一处理图表中各种间隙
 * @param  {Number} size 默认的间隙大小
 * @return {Number}      根据缩放参数Scale和默认间隙字体大小计算后的间隙大小
 */


function paddingConvertWithScale(size) {
  return Math.round((0, _EnvUtils.convertREMtoPX)(size) * SCALE);
}

function getComputedStyle(element, attr, accessor) {
  if (element.nodeType !== 1) {
    throw new Error("element is not a DOM element.");
  }

  if (typeof accessor !== 'function') {
    accessor = function (x) {
      return x;
    };
  }

  var computedStyle = function (node, attr) {
    var style = element.currentStyle ? element.currentStyle : window.getComputedStyle(element, null);
    var val = style[attr];
    var paddingLeft = parseFloat(style['padding-left']),
        borderWidth = parseFloat(style['border-left-width']);
    paddingLeft = isNaN(paddingLeft) ? 0 : paddingLeft;
    borderWidth = isNaN(borderWidth) ? 0 : borderWidth; // 有时获取到的style属性值是auto，这些个天杀的家伙。

    if (val === 'auto' && (attr === "width" || attr === "height")) {
      var rect = node.getBoundingClientRect();
      val = attr === 'width' ? rect.right - rect.left : rect.bottom - rect.top;
      val -= (paddingLeft + borderWidth) * 2;
      val += "px";
    }

    return val;
  },
      attributes = splitWords(attr),
      obj = {};

  attributes.forEach(function (attr) {
    obj[camelCase(attr)] = accessor(computedStyle(element, attr));
  });
  return obj;
} // JQuery camelCase func


function camelCase(string) {
  var rmsPrefix = /^-ms-/,
      rdashAlpha = /-([\da-z])/gi;
  return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, function fcamelCase(all, letter) {
    return letter.toUpperCase();
  });
}

function toPng(url) {
  window.location = url;
}

function computeArc(ax, ay, bx, by, c) {
  var th = Math.asin(c),
      absX = Math.abs(ax - bx),
      absY = Math.abs(ay - by),
      l = Math.sqrt(absX * absX + absY * absY) / 2,
      direction = ax > bx ? -1 : 1,
      d = direction * l / Math.tan(th),
      al = Math.atan((ay - by) / (bx - ax)),
      w = d * Math.sin(al),
      h = d * Math.cos(al),
      mx = (ax + bx) / 2,
      my = (ay + by) / 2,
      ox = mx + w,
      oy = my + h,
      sAngX = ax - ox,
      sAngY = ay - oy,
      eAngX = bx - ox,
      eAngY = by - oy,
      sAng = normalRadian(Math.atan2(sAngY, sAngX)),
      eAng = normalRadian(Math.atan2(eAngY, eAngX));

  if (sAng > eAng) {
    eAng += DOUBLE_PI;
  }

  return [ox, oy, l / c, sAng, eAng];
}

function normalRadian(angle) {
  angle %= DOUBLE_PI;

  if (angle < 0) {
    angle += DOUBLE_PI;
  }

  return angle;
} // @function formatNum(num: Number, digits?: Number): Number
// Returns the number `num` rounded to `digits` decimals, or to 5 decimals by default.


function formatNum(num, digits) {
  var pow = Math.pow(10, digits || 5);
  return Math.round(num * pow) / pow;
}

function wrapNum(x, range, includeMax) {
  var max = range[1],
      min = range[0],
      d = max - min;
  return x === max && includeMax ? x : ((x - min) % d + d) % d + min;
} // @function bind(fn: Function, …): Function
// Returns a new function bound to the arguments passed, like [Function.prototype.bind](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Function/bind).
// Has a `L.bind()` shortcut.


function bind(fn, obj) {
  var slice = Array.prototype.slice;

  if (fn.bind) {
    return fn.bind.apply(fn, slice.call(arguments, 1));
  }

  var args = slice.call(arguments, 2);
  return function () {
    return fn.apply(obj, args.length ? args.concat(slice.call(arguments)) : arguments);
  };
}

function getParamString(obj, existingUrl, uppercase) {
  var params = [];

  for (var i in obj) {
    params.push(encodeURIComponent(uppercase ? i.toUpperCase() : i) + '=' + encodeURIComponent(obj[i]));
  }

  return (!existingUrl || existingUrl.indexOf('?') === -1 ? '?' : '&') + params.join('&');
}

function template(str, data) {
  return str.replace(templateRe, function (str, key) {
    var value = data[key];

    if (value === undefined) {
      throw new Error('No value provided for variable ' + str);
    } else if (typeof value === 'function') {
      value = value(data);
    }

    return value;
  });
} // @function setOptions(obj: Object, options: Object): Object
// Merges the given properties to the `options` of the `obj` object, returning the resulting options. See `Class options`. Has an `BaseUtils.setOptions` shortcut.


function setOptions(obj, options) {
  if (!obj.hasOwnProperty('options')) {
    obj.options = obj.options ? Object.create(obj.options) : {};
  }

  for (var i in options) {
    obj.options[i] = options[i];
  }

  return obj.options;
}

function createOptions(options, optArray) {
  optArray.forEach(function (opt) {
    if (opt) {
      for (var i in opt) {
        if ((0, _CoreUtils.hasNotDefined)(options[i]) && !skipKeys[i]) {
          options[i] = opt[i];
        }
      }
    }
  });
  return options;
} // inspired by http://paulirish.com/2011/requestanimationframe-for-smart-animating/


function getPrefixed(name) {
  return window['webkit' + name] || window['moz' + name] || window['ms' + name];
}

var lastTime = 0; // fallback for IE 7-8

function timeoutDefer(fn) {
  var time = +new Date(),
      timeToCall = Math.max(0, 16 - (time - lastTime));
  lastTime = time + timeToCall;
  return _Browser["default"].phantomjs ? window.setTimeout(fn, timeToCall) : $T.setTimeout(fn, timeToCall);
}

var requestFn = $T.requestAnimationFrame || timeoutDefer,
    cancelFn = $T.cancelAnimationFrame || function (id) {
  $T.clearTimeout(id);
}; // @function requestAnimFrame(fn: Function, context?: Object, immediate?: Boolean): Number
// Schedules `fn` to be executed when the browser repaints. `fn` is bound to
// `context` if given. When `immediate` is set, `fn` is called immediately if
// the browser doesn't have native support for
// [`window.requestAnimationFrame`](https://developer.mozilla.org/docs/Web/API/window/requestAnimationFrame),
// otherwise it's delayed. Returns a request ID that can be used to cancel the request.


function requestAnimFrame(fn, context, immediate) {
  if (immediate && requestFn === timeoutDefer) {
    fn.call(context);
  } else {
    return requestFn.call(window, bind(fn, context));
  }
} // @function cancelAnimFrame(id: Number): undefined
// Cancels a previous `requestAnimFrame`. See also [window.cancelAnimationFrame](https://developer.mozilla.org/docs/Web/API/window/cancelAnimationFrame).


function cancelAnimFrame(id) {
  if (id) {
    cancelFn.call(window, id);
  }
} // @function throttle(fn: Function, time: Number, context: Object): Function
// Returns a function which executes function `fn` with the given scope `context`
// (so that the `this` keyword refers to `context` inside `fn`'s code). The function
// `fn` will be called no more than one time per given amount of `time`. The arguments
// received by the bound function will be any arguments passed when binding the
// function, followed by any arguments passed when invoking the bound function.
// Has an `L.bind` shortcut.


function throttle(fn, time, context) {
  var lock, args, wrapperFn, later, timeout;

  later = function () {
    // reset lock and call if queued
    lock = false;

    if (args) {
      wrapperFn.apply(context, args);
      args = false;
    }
  };

  wrapperFn = function () {
    if (lock) {
      // called too soon, queue to call later
      args = arguments;
    } else {
      // call and lock until later
      fn.apply(context, arguments);
      timeout = setTimeout(later, time);
      lock = true;
    }
  };

  wrapperFn.cancel = function () {
    clearTimeout(timeout);
    lock = args = false;
  };

  return wrapperFn;
}

function rebind(target, source) {
  var i = 1,
      n = arguments.length,
      method;

  while (++i < n) {
    target[method = arguments[i]] = _rebind(target, source, source[method]);
  }

  return target;
}

function _rebind(target, source, method) {
  return function () {
    var value = method.apply(source, arguments);
    return value === source ? target : value;
  };
}

function bindData(layers, dataArray, keyFunction) {
  var i,
      n = layers.length,
      m = dataArray.length,
      enterFeatures = [],
      exitLayers = [],
      updateLayers = [];
  var nodeByKeyValue = {},
      keyValues = [],
      keyValue,
      layer,
      datum;

  for (i = -1; ++i < n;) {
    layer = layers[i];
    keyValue = keyFunction ? keyFunction(layer.datum()) : i;
    nodeByKeyValue[keyValue] = layer;
    keyValues[i] = keyValue;
  }

  for (i = -1; ++i < m;) {
    datum = dataArray[i];
    keyValue = keyFunction ? keyFunction(datum) : i;
    layer = nodeByKeyValue[keyValue];

    if (!layer) {
      enterFeatures.push(datum);
    } else if (layer !== true) {
      layer.datum(datum);
      updateLayers.push(layer);
    }

    nodeByKeyValue[keyValue] = true;
  }

  for (i = -1; ++i < n;) {
    if (nodeByKeyValue[keyValues[i]] !== true) {
      exitLayers.push(layers[i]);
    }
  }

  return {
    update: updateLayers,
    enter: enterFeatures,
    exit: exitLayers
  };
}

function dispatch() {
  var dispatch = new d3_dispatch(),
      i = -1,
      n = arguments.length;

  while (++i < n) {
    dispatch[arguments[i]] = d3_dispatch_event(dispatch);
  }

  return dispatch;
}

;

function d3_dispatch() {}

d3_dispatch.prototype.on = function (type, listener) {
  var i = type.indexOf("."),
      name = "";

  if (i >= 0) {
    name = type.slice(i + 1);
    type = type.slice(0, i);
  }

  if (type) {
    return arguments.length < 2 ? this[type].on(name) : this[type].on(name, listener);
  }

  if (arguments.length === 2) {
    if (listener == null) {
      for (type in this) {
        if (this.hasOwnProperty(type)) {
          this[type].on(name, null);
        }
      }
    }

    return this;
  }
};

function d3_dispatch_event(dispatch) {
  var listeners = [],
      listenerByName = new _vMap["default"]();

  function event() {
    var z = listeners,
        i = -1,
        n = z.length,
        l;

    while (++i < n) {
      if (l = z[i].on) {
        l.apply(this, arguments);
      }
    }

    return dispatch;
  }

  event.on = function (name, listener) {
    var l = listenerByName.get(name),
        i;

    if (arguments.length < 2) {
      return l && l.on;
    }

    if (l) {
      l.on = null;
      listeners = listeners.slice(0, i = listeners.indexOf(l)).concat(listeners.slice(i + 1));
      listenerByName.remove(name);
    }

    if (listener) {
      listeners.push(listenerByName.set(name, {
        on: listener
      }));
    }

    ;
    return dispatch;
  };

  return event;
}

function falseFn() {
  return false;
}

function trueFn() {
  return true;
}

function emptyFn() {}
/**
 * 把数组形式的categoryArray转化为字符串
 * @param array
 * @returns {string}
 */


function encodeCategoryArray(categoryArray) {
  if (!isArray(categoryArray)) {
    return categoryArray;
  }

  if (window.JSON) {
    return JSON['stringify'](categoryArray);
  } else {
    var output = '[';

    for (var i = -1; ++i < categoryArray.length;) {
      output += (i > 0 ? ',' : '') + '"' + categoryArray[i] + '"';
    }

    return output + ']';
  }
}
/**
 * 把字符串化的categoryArray转换成数组
 * @param  {[string]} categoryArrayStr [description]
 * @return {[array]}                  [description]
 */


function decodeCategoryArray(categoryArrayStr) {
  if (window.JSON) {
    return JSON['parse'](categoryArrayStr);
  } else {
    return eval('(' + categoryArrayStr + ')');
  }
}

function getTargetFillArray(length, fillFun) {
  if (length == null) {
    return;
  }

  if (fillFun == null) {
    return Array.apply(null, Array(length));
  }

  var newArray = [];

  for (var i = 0; i < length; i++) {
    newArray.push('');
  }

  return newArray.map(fillFun);
}

function value2PX(value) {
  return value + 'px';
}

function CSSText(css) {
  return Object.keys(css).map(function (key) {
    return key + ':' + css[key];
  }).join(';') + ';';
}

function attrText(attr) {
  return ' ' + Object.keys(attr).map(function (key) {
    return key + '=' + attr[key];
  }).join(' ') + ' ';
}

function spliceText() {
  return Array.prototype.slice.apply(arguments).join('');
}

function stringify(val) {
  if (typeof JSON == 'object') {
    return JSON.stringify(val);
  }

  var str = '',
      curVal;

  if (val === null) {
    // null
    return String(val);
  }

  switch (typeof val) {
    case 'number': // number

    case 'boolean':
      // boolean
      return String(val);

    case 'string':
      // string
      return '"' + val + '"';

    case 'undefined': // undefined

    case 'function':
      // function
      return undefined;
  }

  switch (Object.prototype.toString.call(val)) {
    case '[object Array]':
      // array
      str += '[';

      for (var i = 0, len = val.length - 1; i < len; i++) {
        curVal = stringify(val[i]);
        str += (curVal === undefined ? null : curVal) + ",";
      }

      str += stringify(val[i]);
      str += ']';
      return str;

    case '[object Date]':
      // date
      return '"' + (val.toJSON ? val.toJSON() : val.toString()) + '"';

    case '[object RegExp]':
      // regular expression
      return "{}";

    case '[object Object]':
      // object
      str += '{';

      for (var i in val) {
        if (val.hasOwnProperty(i)) {
          curVal = stringify(val[i]);

          if (curVal !== undefined) {
            str += '"' + i + '":' + curVal + ',';
          }
        }
      }

      str = str.slice(0, -1);
      str += '}';
      return str;
  }
}

var BaseUtils = {
  dispatch: dispatch,
  rebind: rebind,
  throttle: throttle,
  requestAnimFrame: requestAnimFrame,
  cancelAnimFrame: cancelAnimFrame,
  getParamString: getParamString,
  template: template,
  setOptions: setOptions,
  createOptions: createOptions,
  formatNum: formatNum,
  wrapNum: wrapNum,
  bind: bind,
  initPaddingScale: initPaddingScale,
  toPng: toPng,
  getDomWidth: getDomWidth,
  getDomHeight: getDomHeight,
  makeTranslate: makeTranslate,
  makeTranslateWithPX: makeTranslateWithPX,
  makeTranslate3d: makeTranslate3d,
  clone: clone,
  date2int: date2int,
  int2date: int2date,
  object2date: object2date,
  log: log,
  getPercentValue: getPercentValue,
  accAdd: accAdd,
  accDiv: accDiv,
  accMul: accMul,
  dealFloatPrecision: dealFloatPrecision,
  niceValue: niceValue,
  objectToArray: objectToArray,
  toArray: toArray,
  pick: pick,
  includes: includes,
  getTextDimension: getTextDimension,
  splitText: splitText,
  splitAndShrinkText: splitAndShrinkText,
  shrinkText: shrinkText,
  getTextDimensionWithRotation: getTextDimensionWithRotation,
  getTextDimRotated: getTextDimRotated,
  getEllipsisText: getEllipsisText,
  isArray: isArray,
  indexOf: indexOf,
  startsWith: startsWith,
  endsWith: endsWith,
  cssNormalization: cssNormalization,
  reformCssArray: reformCssArray,
  rectSubPixelOpt: rectSubPixelOpt,
  lineSubPixelOpt: lineSubPixelOpt,
  toFront: toFront,
  toBack: toBack,
  containsRect: containsRect,
  rectangleOverlapped: rectangleOverlapped,
  outsideRect: outsideRect,
  isValidRect: isValidRect,
  lineRect: lineRect,
  containsPoint: containsPoint,
  setTextStyle: setTextStyle,
  domRotate: domRotate,
  makeValueInRange: makeValueInRange,
  getValueInDomain: getValueInDomain,
  toRadian: toRadian,
  toDegree: toDegree,
  getFormatterFunction: getFormatterFunction,
  format: format,
  hasTouch: hasTouch,
  distance: distance,
  makeBounds: makeBounds,
  isImageMarker: isImageMarker,
  isNullMarker: isNullMarker,
  getDefaultMarkerSymbol: getDefaultMarkerSymbol,
  getArcPoint: getArcPoint,
  getTextWrapDimension: getTextWrapDimension,
  stamp: stamp,
  splitWords: splitWords,
  trim: trim,
  extend: extend,
  getGradientBackgroundCssText: getGradientBackgroundCssText,
  getBorderCssText: getBorderCssText,
  setNormalScreenDomBackground: setNormalScreenDomBackground,
  setFullScreenDomBackground: setFullScreenDomBackground,
  getFullScreenBackgroundColor: getFullScreenBackgroundColor,
  getArcByPoint: getArcByPoint,
  calculateAutoMinMaxAndGap: calculateAutoMinMaxAndGap,
  hasChn: hasChn,
  paddingConvertWithScale: paddingConvertWithScale,
  getComputedStyle: getComputedStyle,
  computeArc: computeArc,
  normalRadian: normalRadian,
  bindData: bindData,
  falseFn: falseFn,
  trueFn: trueFn,
  emptyFn: emptyFn,
  decodeCategoryArray: decodeCategoryArray,
  encodeCategoryArray: encodeCategoryArray,
  getTextBBoxWithRotation: getTextBBoxWithRotation,
  getTargetFillArray: getTargetFillArray,
  value2PX: value2PX,
  CSSText: CSSText,
  attrText: attrText,
  spliceText: spliceText,
  stringify: stringify,
  // 用extend WS 认不出来真是烦
  setTimeout: $T.setTimeout,
  clearTimeout: $T.clearTimeout,
  setInterval: $T.setInterval,
  clearInterval: $T.clearInterval,
  requestAnimationFrame: $T.requestAnimationFrame,
  cancelAnimationFrame: $T.cancelAnimationFrame
};
var _default = BaseUtils;
exports["default"] = _default;

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

/**
 * Created by eason on 15/5/4.
 */
var _default = {
  // 深浅色主题
  DARK: 'dark',
  LIGHT: 'light',
  BLANK_VALUE_PERCENTAGE: '\x20\x20',
  INSTANCES_KEY: 'vancharts_index_',
  SELECT_ANIMATION: 'select',
  UPDATE_EXIT_ENTER_ANIMATION: 'update_exit_enter',
  // 选中样式动画
  SELECT_STYLE_ANIMATION: 'select_style',
  CHART_HIDE: 'vancharts-chart-hide',
  EXPORT_HIDE: 'vancharts-export-hide',
  // 区域类型闪烁动画类型
  SCALE_EXPAND_ANIMATION: "scale_expand",
  SCALE_MINIFY_ANIMATION: "scale_minify",
  // 坐标系类型
  GEO: 'geographic_co_sys',
  PLANE: 'plane_co_sys',
  // switch style
  BUTTON: 'button',
  CAROUSEL: 'carousel',
  NO_ARROW: 'no_arrow',
  // 图表类型
  BAR_CHART: 'bar',
  // 条形图
  COLUMN_CHART: 'column',
  // 柱形图
  LINE_CHART: 'line',
  // 折线图
  AREA_CHART: 'area',
  // 面积图
  PIE_CHART: 'pie',
  // 饼图
  MULTIPIE_CHART: 'multiPie',
  // 多层饼图
  TREEMAP_CHART: 'treeMap',
  // 矩形树图
  SCATTER_CHART: 'scatter',
  // 散点图
  BUBBLE_CHART: 'bubble',
  // 气泡图
  FORCE_BUBBLE_CHART: 'forceBubble',
  // 力学气泡图
  GANTT_CHART: 'gantt',
  // 甘特图
  GAUGE_CHART: 'gauge',
  // 仪表盘
  POINTER_GAUGE: 'pointer',
  // 指针仪表盘
  POINTER_SEMI_GAUGE: 'pointer_semi',
  SLOT_GAUGE: 'slot',
  // 刻度槽仪表盘
  THERMOMETER_GAUGE: 'thermometer',
  // 试管仪表盘
  RING_GAUGE: 'ring',
  // 圆环仪表盘
  RADAR_CHART: 'radar',
  // 雷达图
  COLUMN_RADAR: 'columnRadar',
  LINE_RADAR: 'lineRadar',
  POINT_MAP: 'pointMap',
  AREA_MAP: 'areaMap',
  HEAT_MAP: 'heatMap',
  LINE_MAP: 'lineMap',
  FUNNEL_CHART: 'funnel',
  // 漏斗图
  WORD_CLOUD_CHART: 'wordCloud',
  // 词云
  STRUCTURE_CHART: 'structure',
  // 框架图
  MULTI_CHARTS: 'multiCharts',
  // 组合图
  BOX_CHART: 'box',
  // 箱型图
  // 标记点的默认大小
  MARKER_RADIUS: 3.5,
  // 所有支持大数据模式的图表类型集合
  LARGE_CHART_TYPE: {
    line: true,
    area: true,
    scatter: true,
    bubble: true,
    gantt: true,
    pointMap: true,
    areaMap: true
  },
  VANCHART: 'vanchart',
  // 工具栏的icon类型
  FULL_SCREEN_ICON: 'fullScreen',
  EXPORT_ICON: 'toImage',
  SORT: 'sort',
  MENU_ICON: 'vancharts-icon-menu',
  REFRESH_ICON: 'vancharts-icon-refresh',
  TOOLBAR_ICON_SIZE: 32,
  AXIS_GROUP: 'vanchart-axis-group',
  // 位置相关的常量
  BOTTOM: 'bottom',
  TOP: 'top',
  LEFT: 'left',
  RIGHT: 'right',
  RIGHT_TOP: 'right-top',
  RIGHT_BOTTOM: 'right-bottom',
  LEFT_TOP: 'left-top',
  LEFT_BOTTOM: 'left-bottom',
  // 动画的方向
  LEFT_TO_RIGHT: 'left-to-right',
  RIGHT_TO_LEFT: 'right-to-left',
  BOTTOM_TO_TOP: 'bottom-to-top',
  TOP_TO_BOTTOM: 'top-to-bottom',
  // 图的排序的状态
  DISORDER: 'disorder',
  DESCENDING: 'descending',
  ASCENDING: 'ascending',
  // 标记点类型
  CIRCLE: 'circle',
  SQUARE: 'square',
  DIAMOND: 'diamond',
  TRIANGLE: 'triangle',
  STAR: 'star',
  LOCATION: 'location',
  SYMBOL_AUTO: 'auto',
  CIRCLE_HOLLOW: 'circle_hollow',
  SQUARE_HOLLOW: 'square_hollow',
  DIAMOND_HOLLOW: 'diamond_hollow',
  TRIANGLE_HOLLOW: 'triangle_hollow',
  // 图例的另外三种类型
  NORMAL_ICON: 'normal-legend-icon',
  // 一般的图例
  PIE_ICON: 'pie-legend-icon',
  DONUT_ICON: 'donut-legend-icon',
  BUBBLE_ICON: 'bubble-legend-icon',
  SCATTER_ICON: 'scatter-legend-icon',
  TREEMAP_ICON: 'treeMap-legend-icon',
  NULL_MARKER: 'null-marker-legend-icon',
  ANCHOR_ICON: 'anchor',
  ANCHOR_ICON_SIZE: 28,
  // 点地图定位点path路径的高度
  POINT_MAP_IMG_COLOR: 'rgb(99,178,238)',
  // 点地图默认图片颜色
  // 图例位于上下方时的排列方式
  FLOW: 'flow',
  // 流式
  // 图例默认不透明度
  DEFAULT_OPACITY: 1,
  // 鼠标悬浮，图例与图形的不透明度
  HOVER_OPACITY: 0.2,
  SOLID: 'solid',
  DASHED: 'dashed',
  DASH_ARRAY: {
    solid: 'none',
    // 0,0 bug IE9; 0 bug phantom;
    dashed: '6,6'
  },
  // 玫瑰图的不同形状
  SAME_ARC: 'sameArc',
  // 所有扇形弧长相同
  DIFFERENT_ARC: 'differentArc',
  // 所有扇形弧长不相等
  // 标签的位置
  AUTO: 'auto',
  OUTSIDE: 'outside',
  INSIDE: 'inside',
  CENTER: 'center',
  // 标签竖排判断标准
  OVERLAP_RATE: 0.15,
  EXCEED_RATE: 0.15,
  FONTSIZE_RATE: 2,
  // 渐变风格的名字
  STYLE_GRADUAL: 'gradual',
  // rgb渐变
  STYLE_NORMAL: 'normal',
  STYLE_CUSTOM: 'custom',
  // 自定义渐变
  // 仪表盘布局
  HORIZONTAL_LAYOUT: 'horizontal',
  VERTICAL_LAYOUT: 'vertical',
  // 雷达图底边
  POLYGON_RADAR: 'polygon',
  CIRCLE_RADAR: 'circle',
  // size是通过气泡的半径还是面积表现出来
  SIZE_BY_AREA: 'area',
  SIZE_BY_WIDTH: 'width',
  GRADUAL_LIGHTER: 'lighter',
  GRADUAL_DARKER: 'darker',
  // 系列的几个状态
  STATE_TO_DROP: 'to-drop',
  STATE_DROPPED: 'dropped',
  STATE_TO_SHOW: 'to-show',
  STATE_SHOW: 'show',
  // trend line
  EXPONENTIAL: 'exponential',
  LINEAR: 'linear',
  LOGARITHMIC: 'logarithmic',
  POLYNOMIAL: 'polynomial',
  // Axis arrow path map
  AXIS_ARROW_PATH: {
    // Towards the left
    left: "M-10, 0 L-2, 4 L-6, 0 L-2, -4 L-10, 0",
    // Towards the right
    right: "M2,-4 L10,0 L2,4 L6,0 L2,-4",
    // upwards
    up: "M-4,-2 L0,-10 L4,-2 L0,-6 L-4,-2",
    // downwards
    down: "M-4, 2 L0, 10, L4, 2 L0, 6 L-4, 2"
  },
  DIRECTION_LEFT: 2,
  DIRECTION_RIGHT: 4,
  DIRECTION_UP: 8,
  DIRECTION_DOWN: 16,
  STAGES: {
    NORMAL: 0,
    // init or canceled
    SELECT: 1,
    // touchMove to find target
    KEEP: 2,
    // no auto hide, keep showing specific target
    ZOOM: 3
  },
  EFFECT_KEY: "__effect__",
  AUTO_REFRESH: "auto_refresh",
  EMPTY_DATA_DOMAIN: [0, 100],
  DEFAULT_PERCENT_INTERVAL: 0.25,
  DEFAULT_LOG_INTERVAL: 1,
  MIN_TIME_AXIS_INTERVAL: 1000,
  // min date step = 1 second
  MAX_TICKS_NUM: 1000,
  MAX_MINOR_TICKS_NUM: 2000,
  GANTT_CANVAS_WIDTH: 4000,
  GANTT_MAX_CANVAS_NUM: 15,
  // 新数据过来的时候刷新的类型
  INCREMENT_REFRESH: 'increment',
  INCREMENT_TIP_REFRESH: 'tip_increment',
  OVERALL_REFRESH: 'overall',
  INTERVAL: 'interval',
  ELLIPSIS: 'ellipsis',
  MULTI_LINE: 'multiLine',
  MULTI_LINE_HEIGHT: 1.2
};
exports["default"] = _default;

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNumberValue = isNumberValue;
exports.isEmpty = isEmpty;
exports.isNull = isNull;
exports.isNumber = isNumber;
exports.hasNotDefined = hasNotDefined;
exports.hasDefined = hasDefined;
exports.isEmptyObj = isEmptyObj;
exports.fixDivisor = fixDivisor;
exports.assign = void 0;

function isNumberValue(value) {
  return !isEmpty(value) && !isNaN(value);
}

function isEmpty(value) {
  var result = value === "" || value === null || value === undefined;
  return result;
}

function isNull(v) {
  return v == undefined || v == null;
}

function isNumber(val) {
  return typeof val === 'number' && !isNaN(val);
} // null == undefined 为 true


function hasNotDefined(value) {
  return value === null || value === undefined;
}

function hasDefined(value) {
  return !hasNotDefined(value);
}

function isEmptyObj(obj) {
  return obj == null || Object.keys(obj).length === 0;
}

function fixDivisor(value) {
  return isNumber(value) && value !== 0 ? value : 1;
}

var assign = Object.assign || function (target) {
  if (target === undefined || target === null) {
    throw new TypeError('Cannot convert undefined or null to object');
  }

  var output = Object(target);

  for (var index = 1; index < arguments.length; index++) {
    var source = arguments[index];

    if (source !== undefined && source !== null) {
      for (var nextKey in source) {
        if (source.hasOwnProperty(nextKey)) {
          output[nextKey] = source[nextKey];
        }
      }
    }
  }

  return output;
};

exports.assign = assign;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._getSvgTextDim = _getSvgTextDim;
exports._getCanvasTextDim = _getCanvasTextDim;
exports.getTitleText = getTitleText;
exports._getTextDimension = _getTextDimension;
exports.isSupportSVG = isSupportSVG;
exports.supportFillFilter = supportFillFilter;
exports.convertREMtoPX = convertREMtoPX;
exports.getTextHeight = getTextHeight;
exports.getDefaultFontSize = getDefaultFontSize;
exports._getHtmlTextDim = _getHtmlTextDim;
exports.createCanvas = createCanvas;
exports.svg2zr = svg2zr;
exports.isSupportBracketStyleBrowser = isSupportBracketStyleBrowser;
exports.getTransPrefix = void 0;

var _CoreUtils = __webpack_require__(2);

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

var _HtmlUtils = __webpack_require__(71);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var getTransPrefix = function () {
  return "-webkit-transform" in document.body.style ? "-webkit-" : "-moz-transform" in document.body.style ? "-moz-" : "-ms-transform" in document.body.style ? "-ms-" : "";
};

exports.getTransPrefix = getTransPrefix;
var CANVAS_CTX, SVG_CONTAINER, DIV_CONTAINER;
var defaultFontSize;
var ie8 = !window.SVGSVGElement;

function _getSvgTextDim(text, style) {
  SVG_CONTAINER.style.display = "";
  var node = SVG_CONTAINER._textNode;
  node.textContent = text;
  node.style.cssText = '';

  for (var property in style) {
    if (typeof style[property] != "function" && property != 'color') {
      node.style[property] = style[property];
    }
  }

  !node.style.whiteSpace && (node.style.whiteSpace = 'pre');
  var box = node.getBBox();
  var size = {
    width: box.width,
    height: box.height
  };
  SVG_CONTAINER.style.display = "none";
  return size;
}

function _getCanvasTextDim(text, style) {
  _init();

  var fontSize = convertREMtoPX(style.fontSize) + 'px';
  var fontStyle = style['fontStyle'] || '';
  var fontWeight = style['fontWeight'] || '';
  var fontFamily = style['fontFamily'] || '';
  var det = fontStyle === 'italic' && !false ? 5 : 0; // @CHART-9301: .SF这样的特殊字体导致样式解析失败从而使用默认样式, 这边给fontFamily外包裹一层"", 保证可以正常解析

  if (fontFamily.indexOf(",") === -1) {
    fontFamily = '"' + fontFamily + '"';
  }

  CANVAS_CTX.font = fontStyle + ' ' + fontWeight + ' ' + fontSize + ' ' + fontFamily;
  var width = CANVAS_CTX.measureText(text).width + det || 0;
  var height = getTextHeight(style);
  var dims = {
    width: width,
    height: height
  };

  if (style['writing-mode'] && false) {
    dims = getTextDimRotated(dims, 90);
  }

  return dims;
} // todo 重复代码


function toRadian(degree) {
  return Math.PI * (degree / 180);
} // todo 重复代码


function getTextDimRotated(dim, rotation) {
  var angle = Math.abs(toRadian(rotation || 0));
  var width = dim.width * Math.cos(angle) + dim.height * Math.sin(angle);
  var height = dim.width * Math.sin(angle) + dim.height * Math.cos(angle);
  return {
    width: width,
    height: height
  };
}

function getPlainText(val) {
  _init();

  DIV_CONTAINER.style.cssText = 'visibility: hidden;';
  DIV_CONTAINER.innerHTML = val;

  if (DIV_CONTAINER.textContent) {
    return DIV_CONTAINER.textContent;
  }

  return DIV_CONTAINER.innerText;
}

function getTitleText(option) {
  var title = option.title;

  if (title.text && title.useHtml) {
    return getPlainText(title.text);
  }

  return title.text || '';
}

function _getTextDimension(text, style, useHtml) {
  _init();

  if ((0, _CoreUtils.isEmpty)(text)) {
    return {
      width: 0,
      height: 0
    };
  }

  if (false) {}

  if (useHtml || !isSupportSVG()) {
    return _getHtmlTextDim(text, style, useHtml);
  } // fixME: MOBILE-22247 IOS下默认字体, 使用canvas或者html计算得到的文字尺寸都比svg的偏小
  // FR-APP 中webview的ua没有safari, 这边改为判断设备


  return style['writing-mode'] ? _getSvgTextDim(text, style) : _getCanvasTextDim(text, style);
}

function isSupportSVG() {
  return !!window.SVGSVGElement;
}

function supportFillFilter() {
  return isSupportSVG() || false;
} //组件间距代码里写rem，然后根据浏览器的一倍字体行高转化成px，之后参与布局计算
//计算字体高度
//字体不需要计算缩放比例，前台拿到的就是缩放后的字体大小


function convertREMtoPX(size) {
  size += '';

  if (size.indexOf('pt') != -1) {
    size = parseFloat(size) * 4 / 3;
  } else {
    size = parseFloat(size);
  }

  return size;
}

function getTextHeight(style) {
  var fontSize = style.fontSize || '12px';
  return convertREMtoPX(fontSize);
}

function getDefaultFontSize() {
  if (false) {}

  if ((0, _CoreUtils.hasNotDefined)(defaultFontSize)) {
    var style = document.documentElement.currentStyle || document.defaultView.getComputedStyle(document.documentElement);
    defaultFontSize = _getDefaultFontSizeToPX(style.fontSize);
  }

  return defaultFontSize;
}

function _getDefaultFontSizeToPX(size) {
  if (size.indexOf('px') != -1) {
    return parseFloat(size);
  }

  if (size.indexOf('pt') != -1) {
    return parseFloat(size) * 4 / 3;
  }

  return 16;
}

function _getHtmlTextDim(text, style, useHtml, i) {
  if (i === void 0) {
    i = 0;
  }

  _init();

  if (isSupportSVG()) {
    DIV_CONTAINER.style.cssText = '';
    DIV_CONTAINER.style.visibility = "hidden";
    DIV_CONTAINER.style.display = '';
  } else {
    if (!DIV_CONTAINER._hide) {
      // CHART-1923:IE8下频繁修改DIV_CONTAINER的样式，导致渲染卡顿
      DIV_CONTAINER.style.cssText = 'visibility:hidden;';
      DIV_CONTAINER._hide = true;
    } // CHART-2111，CHART-3350
    // IE8下面由于重复设置visibility会导致重绘影响性能，再判断_hide后不设置visibility的同时，每次还要把旧的影响计算结果的属性去掉


    DIV_CONTAINER.style.writingMode = "";
    DIV_CONTAINER.style.width = "";
    DIV_CONTAINER.style.height = "";
  } // @CHART-1966 标题使用html渲染后，图表切换从第二个图表开始渲染错位，结合上面的1923来看：
  // 既要保证低版本下不频繁触发重绘，又要保证每次计算时的position为absolute让其脱离文档流(因为之前的某个ele的style:position会将其覆盖)，不然再算出的宽度就不对了


  DIV_CONTAINER.style.whiteSpace = "nowrap";
  DIV_CONTAINER.style.position = 'absolute';

  for (var property in style) {
    if (typeof style[property] != "function" && property != 'color') {
      DIV_CONTAINER.style[property] = style[property];
    }
  }

  if (useHtml) {
    DIV_CONTAINER.innerHTML = text;
  } else {
    DIV_CONTAINER.textContent ? DIV_CONTAINER.textContent = text : DIV_CONTAINER.innerText = text;
  } // offsetWidth和offsetHeight获取的是四舍五入后的元素宽高，
  // getBoundingClientRect返回的DomRect对象中width和offsetWidth内容一致，而且是更精确的小数值
  // 但是IE8浏览器中不支持width和height，因此使用Rect中的right、left来计算代替


  var rect = DIV_CONTAINER.getBoundingClientRect();
  var width = Math.ceil(rect.right - rect.left);
  var height = Math.ceil(rect.bottom - rect.top);
  var size = {
    width: width,
    height: height
  }; // 	CHART-18121 & CHART-17939 ie8的不知道什么机制，导致每测5-6个就会出现一个DomRect是0的情况，所以这里让变量一直存在引用数一下（ie8的垃圾回收是标记数法）
  // 	但是估计也不是因为被垃圾回收了，如果回收了后面应该都测不到，还需要再找资料看看ie8的机制，先这么补上坑吧
  // i是防止出现什么特殊状况一直算出来是0，出不来图直接崩溃L1/L2级bug就gg了

  if (text !== '' && (size.width === 0 || size.height === 0) && i < 2) {
    DIV_CONTAINER = DIV_CONTAINER;
    size = _getHtmlTextDim(text, style, useHtml, ++i);
  }

  if (isSupportSVG()) {
    DIV_CONTAINER.style.display = 'none';
  }

  return size;
}

function createCanvas() {
  if (false) {} else {
    var canvas = document.createElement(window.VAN_CANVAS || 'canvas');
    window.VanCanvasManager && VanCanvasManager.initElement(canvas);
    return canvas;
  }
}

var _inited = false;

function _init() {
  if (_inited) {
    return;
  }

  _inited = true;

  if (false) { var c; } else {
    DIV_CONTAINER = document.createElement("div");
    document.body.appendChild(DIV_CONTAINER);

    if (isSupportSVG()) {
      var _c = createCanvas();

      _c.style.cssText = 'position: absolute; top: -10000px; left: 0; visibility: hidden;';
      document.body.appendChild(_c);
      CANVAS_CTX = _c.getContext('2d');
      SVG_CONTAINER = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
      SVG_CONTAINER.style.width = 0;
      SVG_CONTAINER.style.height = 0;
      document.body.appendChild(SVG_CONTAINER);
      var node = document.createElementNS('http://www.w3.org/2000/svg', 'text');
      SVG_CONTAINER.appendChild(node);
      SVG_CONTAINER._textNode = node;
      SVG_CONTAINER.style.visibility = "hidden";
    }
  }
}

function svg2zr(svgStyle) {
  var style = {};

  var fillOpacity = _BaseUtils["default"].pick(svgStyle['fill-opacity'], 1);

  style.fill = svgStyle.fill && svgStyle.fill != 'none' ? _ColorUtils["default"].mixColorWithAlpha(svgStyle.fill, fillOpacity) : null;

  var strokeOpacity = _BaseUtils["default"].pick(svgStyle['stroke-opacity'], 1);

  style.stroke = svgStyle.stroke && svgStyle.stroke != 'none' ? _ColorUtils["default"].mixColorWithAlpha(svgStyle.stroke, strokeOpacity) : null;
  style.lineWidth = _BaseUtils["default"].pick(svgStyle['stroke-width'], 0);
  return style;
}

function isSupportBracketStyleBrowser() {
  var sUserAgent = navigator.userAgent;

  if (sUserAgent.indexOf("Windows NT 5.0") > -1 || sUserAgent.indexOf("Windows 2000") > -1 || sUserAgent.indexOf("Windows NT 5.1") > -1 || sUserAgent.indexOf("Windows XP") > -1 || sUserAgent.indexOf("Windows NT 5.2") > -1 || sUserAgent.indexOf("Windows 2003") > -1 || sUserAgent.indexOf("Windows NT 6.0") > -1 || sUserAgent.indexOf("Windows Vista") > -1 || sUserAgent.indexOf("Windows NT 6.1") > -1 || sUserAgent.indexOf("Windows 7") > -1) {
    return false;
  }

  return true;
}

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComponent = exports.getComponents = exports.register = exports.ComponentCst = exports.ComponentsRenderOrder = exports.ComponentsOrder = void 0;
var ComponentsOrder = ['tooltip', 'tools', 'title', 'dTools', 'geo', 'rangeLegend', 'legend', 'zoom', 'dataSheet', 'xAxis', 'yAxis', 'polar', 'angleAxis', 'radiusAxis', 'gaugeAxis', 'value', 'category', 'multiCategory', 'datetime', 'levelBar', 'processes', 'timeAxis', 'moreLabel', 'crossLine', 'plotScroll', 'pieIndicator'];
exports.ComponentsOrder = ComponentsOrder;
var ComponentsRenderOrder = ['tooltip', 'title', 'dTools', 'geo', 'rangeLegend', 'legend', 'zoom', 'dataSheet', 'xAxis', 'yAxis', 'polar', 'angleAxis', 'radiusAxis', 'gaugeAxis', 'value', 'category', 'multiCategory', 'datetime', 'levelBar', 'processes', 'timeAxis', 'moreLabel', 'crossLine', 'plotScroll', 'pieIndicator', 'tools'];
exports.ComponentsRenderOrder = ComponentsRenderOrder;
var ComponentCst = {
  TOOLTIP_COMPONENT: 'tooltip',
  TOOLBAR_COMPONENT: 'tools',
  GEO_COMPONENT: 'geo',
  DRILL_TOOLS: 'dTools',
  TITLE_COMPONENT: 'title',
  RANGE_LEGEND_COMPONENT: 'rangeLegend',
  INTERVAL_RANGE_LEGEND: 'intervalRangeLegend',
  GradientRangeLegend: 'gradientRangeLegend',
  LEGEND_COMPONENT: 'legend',
  DATA_SHEET_COMPONENT: 'dataSheet',
  ZOOM_COMPONENT: 'zoom',
  X_AXIS_COMPONENT: 'xAxis',
  Y_AXIS_COMPONENT: 'yAxis',
  POLAR_COMPONENT: 'polar',
  RADIUS_AXIS_COMPONENT: 'radiusAxis',
  ANGLE_AXIS_COMPONENT: 'angleAxis',
  GAUGE_AXIS_COMPONENT: 'gaugeAxis',
  VALUE_AXIS_COMPONENT: 'value',
  CATEGORY_AXIS_COMPONENT: 'category',
  DATE_AXIS_COMPONENT: 'datetime',
  LEVELBAR: 'levelBar',
  PROCESSES: 'processes',
  TIMEAXIS: 'timeAxis',
  MORELABEL_COMPONENT: 'moreLabel',
  MULTI_CATEGORY_AXIS_COMPONENT: 'multiCategory',
  CROSS_LINE: 'crossLine',
  PLOT_SCROLL: 'plotScroll',
  PIE_INDICATOR: 'pieIndicator'
};
exports.ComponentCst = ComponentCst;

var _registeredComponents = Object.create(null);

var register = function (name, Compo) {
  return _registeredComponents[name] = Compo;
};

exports.register = register;

var getComponents = function () {
  return _registeredComponents;
};

exports.getComponents = getComponents;

var getComponent = function (name) {
  return _registeredComponents[name];
};

exports.getComponent = getComponent;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _CoreUtils = __webpack_require__(2);

/**
 * Created by eason on 15/6/30.
 * some of the following methods are borrowed from zrender
 */
//Copyright (c) 2013, Baidu Inc.
//    All rights reserved.
//
//    Redistribution and use of this software in source and binary forms, with or
//    without modification, are permitted provided that the following conditions
//are met:
//
//    Redistributions of source code must retain the above copyright notice, this
//list of conditions and the following disclaimer.
//
//    Redistributions in binary form must reproduce the above copyright notice,
//    this list of conditions and the following disclaimer in the documentation
//and/or other materials provided with the distribution.
//
//    Neither the name of Baidu Inc. nor the names of its contributors may be used
//to endorse or promote products derived from this software without specific
//prior written permission of Baidu Inc.
//
//    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
//AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
//ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
//(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
//LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
//ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
var _nameColors = {
  aliceblue: '#f0f8ff',
  antiquewhite: '#faebd7',
  aqua: '#0ff',
  aquamarine: '#7fffd4',
  azure: '#f0ffff',
  beige: '#f5f5dc',
  bisque: '#ffe4c4',
  black: '#000',
  blanchedalmond: '#ffebcd',
  blue: '#00f',
  blueviolet: '#8a2be2',
  brown: '#a52a2a',
  burlywood: '#deb887',
  cadetblue: '#5f9ea0',
  chartreuse: '#7fff00',
  chocolate: '#d2691e',
  coral: '#ff7f50',
  cornflowerblue: '#6495ed',
  cornsilk: '#fff8dc',
  crimson: '#dc143c',
  cyan: '#0ff',
  darkblue: '#00008b',
  darkcyan: '#008b8b',
  darkgoldenrod: '#b8860b',
  darkgray: '#a9a9a9',
  darkgrey: '#a9a9a9',
  darkgreen: '#006400',
  darkkhaki: '#bdb76b',
  darkmagenta: '#8b008b',
  darkolivegreen: '#556b2f',
  darkorange: '#ff8c00',
  darkorchid: '#9932cc',
  darkred: '#8b0000',
  darksalmon: '#e9967a',
  darkseagreen: '#8fbc8f',
  darkslateblue: '#483d8b',
  darkslategray: '#2f4f4f',
  darkslategrey: '#2f4f4f',
  darkturquoise: '#00ced1',
  darkviolet: '#9400d3',
  deeppink: '#ff1493',
  deepskyblue: '#00bfff',
  dimgray: '#696969',
  dimgrey: '#696969',
  dodgerblue: '#1e90ff',
  firebrick: '#b22222',
  floralwhite: '#fffaf0',
  forestgreen: '#228b22',
  fuchsia: '#f0f',
  gainsboro: '#dcdcdc',
  ghostwhite: '#f8f8ff',
  gold: '#ffd700',
  goldenrod: '#daa520',
  gray: '#808080',
  grey: '#808080',
  green: '#008000',
  greenyellow: '#adff2f',
  honeydew: '#f0fff0',
  hotpink: '#ff69b4',
  indianred: '#cd5c5c',
  indigo: '#4b0082',
  ivory: '#fffff0',
  khaki: '#f0e68c',
  lavender: '#e6e6fa',
  lavenderblush: '#fff0f5',
  lawngreen: '#7cfc00',
  lemonchiffon: '#fffacd',
  lightblue: '#add8e6',
  lightcoral: '#f08080',
  lightcyan: '#e0ffff',
  lightgoldenrodyellow: '#fafad2',
  lightgray: '#d3d3d3',
  lightgrey: '#d3d3d3',
  lightgreen: '#90ee90',
  lightpink: '#ffb6c1',
  lightsalmon: '#ffa07a',
  lightseagreen: '#20b2aa',
  lightskyblue: '#87cefa',
  lightslategray: '#789',
  lightslategrey: '#789',
  lightsteelblue: '#b0c4de',
  lightyellow: '#ffffe0',
  lime: '#0f0',
  limegreen: '#32cd32',
  linen: '#faf0e6',
  magenta: '#f0f',
  maroon: '#800000',
  mediumaquamarine: '#66cdaa',
  mediumblue: '#0000cd',
  mediumorchid: '#ba55d3',
  mediumpurple: '#9370d8',
  mediumseagreen: '#3cb371',
  mediumslateblue: '#7b68ee',
  mediumspringgreen: '#00fa9a',
  mediumturquoise: '#48d1cc',
  mediumvioletred: '#c71585',
  midnightblue: '#191970',
  mintcream: '#f5fffa',
  mistyrose: '#ffe4e1',
  moccasin: '#ffe4b5',
  navajowhite: '#ffdead',
  navy: '#000080',
  oldlace: '#fdf5e6',
  olive: '#808000',
  olivedrab: '#6b8e23',
  orange: '#ffa500',
  orangered: '#ff4500',
  orchid: '#da70d6',
  palegoldenrod: '#eee8aa',
  palegreen: '#98fb98',
  paleturquoise: '#afeeee',
  palevioletred: '#d87093',
  papayawhip: '#ffefd5',
  peachpuff: '#ffdab9',
  peru: '#cd853f',
  pink: '#ffc0cb',
  plum: '#dda0dd',
  powderblue: '#b0e0e6',
  purple: '#800080',
  red: '#f00',
  rosybrown: '#bc8f8f',
  royalblue: '#4169e1',
  saddlebrown: '#8b4513',
  salmon: '#fa8072',
  sandybrown: '#f4a460',
  seagreen: '#2e8b57',
  seashell: '#fff5ee',
  sienna: '#a0522d',
  silver: '#c0c0c0',
  skyblue: '#87ceeb',
  slateblue: '#6a5acd',
  slategray: '#708090',
  slategrey: '#708090',
  snow: '#fffafa',
  springgreen: '#00ff7f',
  steelblue: '#4682b4',
  tan: '#d2b48c',
  teal: '#008080',
  thistle: '#d8bfd8',
  tomato: '#ff6347',
  turquoise: '#40e0d0',
  violet: '#ee82ee',
  wheat: '#f5deb3',
  white: '#fff',
  whitesmoke: '#f5f5f5',
  yellow: '#ff0',
  yellowgreen: '#9acd32'
};
var _cache = {};
var _emptyDefault = [0, 0, 0, 1];
var colorRegExp = /^\s*((#[a-f\d]{6})|(#[a-f\d]{3})|rgba?\(\s*([\d\.]+%?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+%?)?)\s*\)|hsba?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+)?)%?\s*\)|hsla?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+)?)%?\s*\))\s*$/i;

function trim(color) {
  return String(color).replace(/\s+/g, '');
} // 调整值区间


function adjust(value, region) {
  if (value <= region[0]) {
    value = region[0];
  } else if (value >= region[1]) {
    value = region[1];
  }

  return value;
} // 数组映射


function map(array, fun) {
  if (typeof fun !== 'function') {
    throw new TypeError();
  }

  var len = array ? array.length : 0;

  for (var i = 0; i < len; i++) {
    array[i] = fun(array[i]);
  }

  return array;
}
/**
 * 把颜色转化成数组数据，用于计算
 * @param color 颜色
 */


function getRGBAColorArray(color) {
  if (_nameColors[color]) {
    color = _nameColors[color];
  }

  if (_cache[color]) {
    return _cache[color].slice();
  }

  color = trim(color);

  if (/^#[\da-f]{3}$/i.test(color)) {
    color = parseInt(color.slice(1), 16);
    var r = (color & 0xf00) << 8;
    var g = (color & 0xf0) << 4;
    var b = color & 0xf;
    color = '#' + ((1 << 24) + (r << 4) + r + (g << 4) + g + (b << 4) + b).toString(16).slice(1);
  }

  var r = color.match(colorRegExp); // 2017.05.05 Jeffrey
  // to avoid "Cannot read property '2' of null" exception
  // default is black [0,0,0,1]
  // if anywhere's color is strangely black,
  // comment here, then you can trace the bug

  if (!r) {
    _cache[color] = _emptyDefault;
    return _emptyDefault.slice();
  }

  var d;
  var a;
  var data = [];
  var rgb;

  if (r[2]) {
    // #rrggbb
    d = r[2].replace('#', '').split('');
    rgb = [d[0] + d[1], d[2] + d[3], d[4] + d[5]];
    data = map(rgb, function (c) {
      return adjust(parseInt(c, 16), [0, 255]);
    });
  } else if (r[4]) {
    // rgb rgba
    var rgba = r[4].split(',');
    a = rgba[3];
    rgb = rgba.slice(0, 3);
    data = map(rgb, function (c) {
      c = Math.floor(c.indexOf('%') > 0 ? parseInt(c, 0) * 2.55 : c);
      return adjust(c, [0, 255]);
    });

    if (typeof a !== 'undefined') {
      data.push(adjust(parseFloat(a), [0, 1]));
    }
  } //统一rgba的格式


  if (data.length === 3) {
    data.push(1);
  }

  _cache[color] = data.slice();
  return data;
}

function toColor(data, format) {
  format = format || 'rgb';

  if (data && (data.length === 3 || data.length === 4)) {
    data = map(data, function (c) {
      return c > 1 ? Math.ceil(c) : c;
    });

    if (format.indexOf('hex') > -1) {
      return '#' + ((1 << 24) + (data[0] << 16) + (data[1] << 8) + +data[2]).toString(16).slice(1);
    } else if (format.indexOf('hs') > -1) {
      var sx = map(data.slice(1, 3), function (c) {
        return c + '%';
      });
      data[1] = sx[0];
      data[2] = sx[1];
    }

    if (format.indexOf('a') > -1) {
      if (data.length === 3) {
        data.push(1);
      }

      data[3] = adjust(data[3], [0, 1]);
      return format + '(' + data.slice(0, 4).join(', ') + ')';
    }

    return format + '(' + data.slice(0, 3).join(', ') + ')';
  }
}

function getHighLightColor(color) {
  var rgba = getRGBAColorArray(color);
  var tmp = [];

  for (var i = 0; i < 3; i++) {
    var x = rgba[i];

    if (x <= 128) {
      tmp.push(adjust(x - (255 - x) * (255 - 2 * x) / (2 * x), [0, 255]));
    } else {
      tmp.push(adjust(x + x * (2 * x - 255) / (2 * (255 - x)), [0, 255]));
    }
  }

  var result = [];

  for (i = 0; i < 3; i++) {
    result.push(Math.round(0.65 * rgba[i] + 0.35 * tmp[i]));
  }

  return toColor(result, 'rgb');
}

function getColorWithDivider(color, divider) {
  var rgba = getRGBAColorArray(color);
  rgba.length = 3;

  for (var i = 0; i < 3; i++) {
    rgba[i] = parseInt(rgba[i] / divider, 10);
  }

  return toColor(rgba, 'rgb');
}

function getClickColor(color) {
  var rgba = getRGBAColorArray(color);
  rgba.length = 3;

  for (var i = 0; i < 2; i++) {
    rgba[i] = parseInt(rgba[i] * 0.95, 10);
  }

  return toColor(rgba, 'rgb');
}

function mixColorWithAlpha(color, alpha) {
  var rgba = getRGBAColorArray(color);
  rgba[3] = alpha;
  return toColor(rgba, 'rgba');
}

function mixColorWithHSB(color, detH, detS, detB) {
  var rgba = getRGBAColorArray(color);
  var hsb = rgb2hsb(rgba[0], rgba[1], rgba[2]);
  hsb[0] += detH;
  hsb[1] += detS;
  hsb[2] += detB;
  var rgb = hsb2rgb(hsb[0], hsb[1], hsb[2]);
  return toColor(rgb, 'rgb');
}

function hsb2rgb(hue, saturation, brightness) {
  saturation = Math.min(1, Math.max(0, saturation));
  brightness = Math.min(1, Math.max(0, brightness));
  var r = 0,
      g = 0,
      b = 0;

  if (saturation === 0) {
    r = g = b = brightness * 255.0 + 0.5;
  } else {
    var h = (hue - Math.floor(hue)) * 6.0;
    var f = h - Math.floor(h);
    var p = brightness * (1.0 - saturation);
    var q = brightness * (1.0 - saturation * f);
    var t = brightness * (1.0 - saturation * (1.0 - f));

    switch (Math.floor(h)) {
      case 0:
        r = brightness * 255.0 + 0.5;
        g = t * 255.0 + 0.5;
        b = p * 255.0 + 0.5;
        break;

      case 1:
        r = q * 255.0 + 0.5;
        g = brightness * 255.0 + 0.5;
        b = p * 255.0 + 0.5;
        break;

      case 2:
        r = p * 255.0 + 0.5;
        g = brightness * 255.0 + 0.5;
        b = t * 255.0 + 0.5;
        break;

      case 3:
        r = p * 255.0 + 0.5;
        g = q * 255.0 + 0.5;
        b = brightness * 255.0 + 0.5;
        break;

      case 4:
        r = t * 255.0 + 0.5;
        g = p * 255.0 + 0.5;
        b = brightness * 255.0 + 0.5;
        break;

      case 5:
        r = brightness * 255.0 + 0.5;
        g = p * 255.0 + 0.5;
        b = q * 255.0 + 0.5;
        break;
    }
  }

  var rgb = [];
  rgb.push(Math.floor(r));
  rgb.push(Math.floor(g));
  rgb.push(Math.floor(b));
  return rgb;
}

function hsl2rgb(h, s, l) {
  var h = h / 360;
  var s = s / 100;
  var l = l / 100;
  var rgb = [];

  if (s == 0) {
    rgb = [Math.round(l * 255), Math.round(l * 255), Math.round(l * 255)];
  } else {
    var q = l >= 0.5 ? l + s - l * s : l * (1 + s);
    var p = 2 * l - q;
    var tr = rgb[0] = h + 1 / 3;
    var tg = rgb[1] = h;
    var tb = rgb[2] = h - 1 / 3;

    for (var i = 0; i < rgb.length; i++) {
      var tc = rgb[i];

      if (tc < 0) {
        tc = tc + 1;
      } else if (tc > 1) {
        tc = tc - 1;
      }

      switch (true) {
        case tc < 1 / 6:
          tc = p + (q - p) * 6 * tc;
          break;

        case 1 / 6 <= tc && tc < 0.5:
          tc = q;
          break;

        case 0.5 <= tc && tc < 2 / 3:
          tc = p + (q - p) * (4 - 6 * tc);
          break;

        default:
          tc = p;
          break;
      }

      rgb[i] = Math.round(tc * 255);
    }
  }

  return rgb;
}

function createColorsWithHsb(color, count) {
  color = color || 'blue';
  count = count || 1;
  var rgba = getRGBAColorArray(color);
  var hsb = rgb2hsb(rgba[0], rgba[1], rgba[2]);
  var result = [],
      h = hsb[0],
      s = hsb[1],
      b = hsb[2];

  for (var i = 0; i < count; i++) {
    var tmpS = s * (1 - i / count);
    var tmpB = b + i * (1 - b) / count;
    result.push(toColor(hsb2rgb(h, tmpS, tmpB)));
  }

  return result;
}

function rgb2hsb(r, g, b) {
  var hue, saturation, brightness;
  var hsbvals = [3];
  var cmax = r > g ? r : g;

  if (b > cmax) {
    cmax = b;
  }

  var cmin = r < g ? r : g;

  if (b < cmin) {
    cmin = b;
  }

  brightness = cmax / 255.0;

  if (cmax !== 0) {
    saturation = (cmax - cmin) / cmax;
  } else {
    saturation = 0;
  }

  if (saturation === 0) {
    hue = 0;
  } else {
    var redc = (cmax - r) / (cmax - cmin);
    var greenc = (cmax - g) / (cmax - cmin);
    var bluec = (cmax - b) / (cmax - cmin);

    if (r == cmax) {
      hue = bluec - greenc;
    } else if (g == cmax) {
      hue = 2.0 + redc - bluec;
    } else {
      hue = 4.0 + greenc - redc;
    }

    hue = hue / 6.0;

    if (hue < 0) {
      hue = hue + 1.0;
    }
  }

  hsbvals[0] = hue;
  hsbvals[1] = saturation;
  hsbvals[2] = brightness;
  return hsbvals;
}

function rgb2hsl(r, g, b) {
  r = r / 255;
  g = g / 255;
  b = b / 255;
  var min = Math.min(r, g, b);
  var max = Math.max(r, g, b);
  var l = (min + max) / 2;
  var difference = max - min;
  var h, s;

  if (max == min) {
    h = 0;
    s = 0;
  } else {
    s = l > 0.5 ? difference / (2.0 - max - min) : difference / (max + min);

    switch (max) {
      case r:
        h = (g - b) / difference + (g < b ? 6 : 0);
        break;

      case g:
        h = 2.0 + (b - r) / difference;
        break;

      case b:
        h = 4.0 + (r - g) / difference;
        break;
    }

    h = Math.round(h * 60);
  }

  s = Math.round(s * 100); // 转换成百分比的形式

  l = Math.round(l * 100);
  return [h, s, l];
}

function getColorOpacity(color) {
  return color && typeof color == 'string' && color.indexOf('rgba') != -1 ? getRGBAColorArray(color)[3] : 1;
} //没有a定义的话返回空


function getColorOpacityWithoutDefault(color) {
  return color && typeof color == 'string' && color.indexOf('rgba') != -1 ? getColorOpacity(color) : undefined;
}

function colorToHex(color) {
  return colorToHexAlpha(color).hex;
}

function colorToHexAlpha(color) {
  var rgb = toColor(getRGBAColorArray(color), 'rgba');
  var rRgba = /rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(,([.\d]+))?\)/,
      r,
      g,
      b,
      a,
      rsa = rgb.replace(/\s+/g, "").match(rRgba);
  r = (+rsa[1]).toString(16);
  r = r.length === 1 ? "0" + r : r;
  g = (+rsa[2]).toString(16);
  g = g.length === 1 ? "0" + g : g;
  b = (+rsa[3]).toString(16);
  b = b.length === 1 ? "0" + b : b;
  a = +(rsa[5] ? rsa[5] : 1);
  return {
    hex: "#" + r + g + b,
    alpha: a
  };
}

function colorToHexARGB(color) {
  var hexAlpha = colorToHexAlpha(color);
  return '#' + ('0' + (hexAlpha.alpha * 255 | 0).toString(16)).slice(-2) + hexAlpha.hex.replace('#', '');
}
/**
 * 返回十六进制颜色和透明度
 * @param color 各种形式color，rgb、gdba、red、#ffffff
 * @param alpha 透明度
 */


function getStandardColorAndOpacity(color, alpha) {
  if ((0, _CoreUtils.isEmpty)(color)) {
    return {
      hex: color,
      alpha: alpha
    };
  }

  if ((0, _CoreUtils.isEmpty)(alpha)) {
    alpha = 1;
  }

  alpha = adjust(parseFloat(alpha), [0, 1]);
  var hexAlpha = colorToHexAlpha(color);

  if (hexAlpha.alpha != null) {
    alpha *= hexAlpha.alpha;
  }

  return {
    hex: hexAlpha.hex,
    oriAlpha: hexAlpha.alpha,
    alpha: alpha
  };
}

function hasColorName(name) {
  return _nameColors[name];
}

var _default = {
  hasColorName: hasColorName,
  toColor: toColor,
  hsb2rgb: hsb2rgb,
  hsl2rgb: hsl2rgb,
  rgb2hsb: rgb2hsb,
  rgb2hsl: rgb2hsl,
  createColorsWithHsb: createColorsWithHsb,
  getRGBAColorArray: getRGBAColorArray,
  mixColorWithHSB: mixColorWithHSB,
  getHighLightColor: getHighLightColor,
  getColorWithDivider: getColorWithDivider,
  mixColorWithAlpha: mixColorWithAlpha,
  getColorOpacity: getColorOpacity,
  getColorOpacityWithoutDefault: getColorOpacityWithoutDefault,
  colorToHex: colorToHex,
  colorToHexAlpha: colorToHexAlpha,
  colorToHexARGB: colorToHexARGB,
  getClickColor: getClickColor,
  getStandardColorAndOpacity: getStandardColorAndOpacity
};
exports["default"] = _default;

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Point2D = _interopRequireDefault(__webpack_require__(15));

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 16/6/1.
 */
var DomUtils = {
  // @function get(id: String|HTMLElement): HTMLElement
  // Returns an element given its DOM id, or returns the element itself
  // if it was passed directly.
  get: function (id) {
    return typeof id === 'string' ? document.getElementById(id) : id;
  },
  // @function getStyle(el: HTMLElement, styleAttrib: String): String
  // Returns the value for a certain style attribute on an element,
  // including computed values or values set through CSS.
  getStyle: function (el, style) {
    var value = el.style[style] || el.currentStyle && el.currentStyle[style];

    if ((!value || value === 'auto') && document.defaultView) {
      var css = document.defaultView.getComputedStyle(el, null);
      value = css ? css[style] : null;
    }

    return value === 'auto' ? null : value;
  },
  // @function create(tagName: String, className?: String, container?: HTMLElement): HTMLElement
  // Creates an HTML element with `tagName`, sets its class to `className`, and optionally appends it to `container` element.
  create: function (tagName, className, container) {
    var el = document.createElement(tagName);
    el.className = className || '';

    if (container) {
      container.appendChild(el);
    }

    return el;
  },
  // @function remove(el: HTMLElement)
  // Removes `el` from its parent element
  remove: function (el) {
    if (el && el.parentNode) {
      el.parentNode.removeChild(el);
    }
  },
  // @function empty(el: HTMLElement)
  // Removes all of `el`'s children elements from `el`
  empty: function (el) {
    while (el.firstChild) {
      el.removeChild(el.firstChild);
    }
  },
  // @function toFront(el: HTMLElement)
  // Makes `el` the last children of its parent, so it renders in front of the other children.
  toFront: function (el) {
    if (el && el.parentNode) {
      el.parentNode.appendChild(el);
    }
  },
  // @function toBack(el: HTMLElement)
  // Makes `el` the first children of its parent, so it renders back from the other children.
  toBack: function (el) {
    if (el && el.parentNode) {
      var parent = el.parentNode;
      parent.insertBefore(el, parent.firstChild);
    }
  },
  // @function hasClass(el: HTMLElement, name: String): Boolean
  // Returns `true` if the element's class attribute contains `name`.
  hasClass: function (el, name) {
    if (el.classList !== undefined) {
      return el.classList.contains(name);
    }

    var className = DomUtils.getClass(el);
    return className.length > 0 && new RegExp('(^|\\s)' + name + '(\\s|$)').test(className);
  },
  // @function addClass(el: HTMLElement, name: String)
  // Adds `name` to the element's class attribute.
  addClass: function (el, name) {
    if (el.classList !== undefined) {
      var classes = _BaseUtils["default"].splitWords(name);

      for (var i = 0, len = classes.length; i < len; i++) {
        el.classList.add(classes[i]);
      }
    } else if (!DomUtils.hasClass(el, name)) {
      var className = DomUtils.getClass(el);
      DomUtils.setClass(el, (className ? className + ' ' : '') + name);
    }
  },
  // @function removeClass(el: HTMLElement, name: String)
  // Removes `name` from the element's class attribute.
  removeClass: function (el, name) {
    if (el.classList !== undefined) {
      el.classList.remove(name);
    } else {
      DomUtils.setClass(el, _BaseUtils["default"].trim((' ' + DomUtils.getClass(el) + ' ').replace(' ' + name + ' ', ' ')));
    }
  },
  // @function setClass(el: HTMLElement, name: String)
  // Sets the element's class.
  setClass: function (el, name) {
    if (el.className.baseVal === undefined) {
      el.className = name;
    } else {
      // in case of SVG element
      el.className.baseVal = name;
    }
  },
  // @function getClass(el: HTMLElement): String
  // Returns the element's class.
  getClass: function (el) {
    return el.className.baseVal === undefined ? el.className : el.className.baseVal;
  },
  // @function setOpacity(el: HTMLElement, opacity: Number)
  // Set the opacity of an element (including old IE support).
  // `opacity` must be a number from `0` to `1`.
  setOpacity: function (el, value) {
    if ('opacity' in el.style) {
      el.style.opacity = value;
    } else if ('filter' in el.style) {
      DomUtils._setOpacityIE(el, value);
    }
  },
  _setOpacityIE: function (el, value) {
    var filter = false,
        filterName = 'DXImageTransform.Microsoft.Alpha'; // filters collection throws an error if we try to retrieve a filter that doesn't exist

    try {
      filter = el.filters.item(filterName);
    } catch (e) {
      // don't set opacity to 1 if we haven't already set an opacity,
      // it isn't needed and breaks transparent pngs.
      if (value === 1) {
        return;
      }
    }

    value = Math.round(value * 100);

    if (filter) {
      filter.Enabled = value !== 100;
      filter.Opacity = value;
    } else {
      el.style.filter += ' progid:' + filterName + '(opacity=' + value + ')';
    }
  },
  // @function testProp(props: String[]): String|false
  // Goes through the array of style names and returns the first name
  // that is a valid style name for an element. If no such name is found,
  // it returns false. Useful for vendor-prefixed styles like `transform`.
  testProp: function (props) {
    var style = document.documentElement.style;

    for (var i = 0; i < props.length; i++) {
      if (props[i] in style) {
        return props[i];
      }
    }

    return false;
  },
  // @function setTransform(el: HTMLElement, offset: Point, scale?: Number)
  // Resets the 3D CSS transform of `el` so it is translated by `offset` pixels
  // and optionally scaled by `scale`. Does not have an effect if the
  // browser doesn't support 3D CSS transforms.
  setTransform: function (el, offset, scale) {
    var pos = offset || {
      x: 0,
      y: 0
    };
    el.style[DomUtils.TRANSFORM] = (_Browser["default"].ie3d ? 'translate(' + pos.x + 'px,' + pos.y + 'px)' : 'translate3d(' + pos.x + 'px,' + pos.y + 'px,0)') + (scale ? ' scale(' + scale + ')' : '');
  },
  // @function setPosition(el: HTMLElement, position: Point)
  // Sets the position of `el` to coordinates specified by `position`,
  // using CSS translate or top/left positioning depending on the browser
  // (used by Leaflet internally to position its layers).
  setPosition: function (el, point) {
    // (HTMLElement, Point[, Boolean])

    /*eslint-disable */
    el._leaflet_pos = point;
    /*eslint-enable */

    if (_Browser["default"].any3d) {
      DomUtils.setTransform(el, point);
    } else {
      el.style.left = point.x + 'px';
      el.style.top = point.y + 'px';
    }
  },
  // @function getPosition(el: HTMLElement): Point
  // Returns the coordinates of an element previously positioned with setPosition.
  getPosition: function (el) {
    // this method is only used for elements previously positioned using setPosition,
    // so it's safe to cache the position for performance
    return el._leaflet_pos || _Point2D["default"].create({
      x: 0,
      y: 0
    });
  },
  getMousePos: function (ev, el) {
    var event = ev.touches ? ev.touches.length ? ev.touches[0] : ev.changedTouches[0] : ev;
    var box = el.getBoundingClientRect(); // MOBILE-23926, CHART-12188
    // 处理 scale 后的位置

    var chartX, chartY;

    if (box.width == null) {
      // 如果没有 box.width，也没有translate scale
      // 不处理
      chartX = Math.round(event.clientX - box.left);
      chartY = Math.round(event.clientY - box.top);
    } else {
      // for scaled element
      // https://github.com/jquery/PEP/pull/233#issuecomment-364641197
      chartX = Math.round((event.clientX - box.left) * (el.offsetWidth / box.width));
      chartY = Math.round((event.clientY - box.top) * (el.offsetHeight / box.height));
    }

    return _Point2D["default"].create(chartX, chartY);
  },
  // Chrome on Win scrolls double the pixels as in other platforms (see #4538),
  // and Firefox scrolls device pixels, not CSS pixels
  _wheelPxFactor: _Browser["default"].win && _Browser["default"].chrome ? 2 : _Browser["default"].gecko ? window.devicePixelRatio : 1,
  // @function getWheelDelta(ev: DOMEvent): Number
  // Gets normalized wheel delta from a mousewheel DOM event, in vertical
  // pixels scrolled (negative if scrolling down).
  // Events from pointing devices without precise scrolling are mapped to
  // a best guess of 60 pixels.
  getWheelDelta: function (e) {
    return _Browser["default"].edge ? e.wheelDeltaY / 2 : // Don't trust window-geometry-based delta
    e.deltaY && e.deltaMode === 0 ? -e.deltaY / DomUtils._wheelPxFactor : // Pixels
    e.deltaY && e.deltaMode === 1 ? -e.deltaY * 20 : // Lines
    e.deltaY && e.deltaMode === 2 ? -e.deltaY * 60 : // Pages
    e.deltaX || e.deltaZ ? 0 : // Skip horizontal/depth wheel events
    e.wheelDelta ? (e.wheelDeltaY || e.wheelDelta) / 2 : // Legacy IE pixels
    e.detail && Math.abs(e.detail) < 32765 ? -e.detail * 20 : // Legacy Moz lines
    e.detail ? e.detail / -32765 * 60 : // Legacy Moz pages
    0;
  },
  preventDefault: function (e) {
    if (e.preventDefault) {
      e.preventDefault();
    } else {
      e.returnValue = false;
    }

    return this;
  },
  stopPropagation: function (e) {
    if (e.stopPropagation) {
      e.stopPropagation();
    } else {
      e.cancelBubble = true;
    }

    return this;
  },
  stop: function (e) {
    return DomUtils.preventDefault(e).stopPropagation(e);
  },

  /**
   * 这个方法不止设置，还有取，可以看看
   * @param {Object} dom 添加属性节点
   * @param {Object} attr 属性对象
   * @return {string} ret 这个自己看一下
   * */
  attr: function () {
    if (arguments.length < 2) {
      return;
    }

    var elem = arguments[0],
        prop = arguments[1],
        value = arguments[2];
    var key, ret;

    if (typeof prop == 'string') {
      // set the value
      if ((0, _CoreUtils.hasDefined)(value)) {
        elem.setAttribute(prop, value); // get the value
      } else if (elem && elem.getAttribute) {
        // elem not defined when printing pie demo...
        ret = elem.getAttribute(prop);
      } // else if prop is defined, it is a hash of key/value pairs

    } else if ((0, _CoreUtils.hasDefined)(prop) && typeof prop == 'object') {
      for (key in prop) {
        elem.setAttribute(key, prop[key]);
      }
    }

    return ret;
  },
  style: function (dom, css) {
    Object.keys(css).forEach(function (key) {
      dom.style[key] = css[key];
    });
  },
  createSvgDom: function (tarName, container) {
    var svgDom = document.createElementNS('http://www.w3.org/2000/svg', tarName);

    if (container) {
      container.appendChild(svgDom);
    }

    return svgDom;
  },

  /**
  * 用于将svg语句动态生成节点添加到目标节点中
  * @param {object} target 添加节点的dom
  * @param {string} str svg语句
  * */
  appendSvgStr2Dom: function (target, str) {
    var tmpDom = document.createElement('div');
    tmpDom.innerHTML = '<svg>' + str + '</svg>';
    var childNodes = tmpDom.childNodes[0].childNodes;

    for (var i = 0, len = childNodes.length; i < len; i++) {
      // 一直取第一个是因为前一个给append后数组就少了一个，也可以和最后一个开始取，但是有些有层级关系就不混淆逻辑了
      target.appendChild(childNodes[0]);
    }
  }
};

(function () {
  // prefix style property names
  // @property TRANSFORM: String
  // Vendor-prefixed fransform style name (e.g. `'webkitTransform'` for WebKit).
  DomUtils.TRANSFORM = DomUtils.testProp(['transform', 'WebkitTransform', 'OTransform', 'MozTransform', 'msTransform']);
  DomUtils.TRANSFORM_ORIGIN = DomUtils.testProp(['transformOrigin', 'WebkitTransformOrigin', 'OTransformOrigin', 'MozTransformOrigin', 'msTransformOrigin']); // webkitTransition comes first because some browser versions that drop vendor prefix don't do
  // the same for the transitionend event, in particular the Android 4.1 stock browser
  // @property TRANSITION: String
  // Vendor-prefixed transform style name.

  var transition = DomUtils.TRANSITION = DomUtils.testProp(['webkitTransition', 'transition', 'OTransition', 'MozTransition', 'msTransition']);
  DomUtils.TRANSITION_END = transition === 'webkitTransition' || transition === 'OTransition' ? transition + 'End' : 'transitionend';
})();

var _default = DomUtils;
exports["default"] = _default;

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

/**
 * Created by eason on 16/5/26.
 */
var ua = navigator.userAgent.toLowerCase(),
    doc = document.documentElement,
    ie = ('ActiveXObject' in window),
    webkit = ua.indexOf('webkit') !== -1,
    phantomjs = ua.indexOf('phantom') !== -1,
    android23 = ua.search('android [23]') !== -1,
    chrome = ua.indexOf('chrome') !== -1,
    gecko = ua.indexOf('gecko') !== -1 && !webkit && !window.opera && !ie,
    win = navigator.platform.indexOf('Win') === 0,
    mobile = typeof orientation !== 'undefined' || ua.indexOf('mobile') !== -1,
    msPointer = !window.PointerEvent && window.MSPointerEvent,
    pointer = window.PointerEvent || msPointer,
    ie3d = ie && 'transition' in doc.style,
    webkit3d = 'WebKitCSSMatrix' in window && 'm11' in new window.WebKitCSSMatrix() && !android23,
    gecko3d = ('MozPerspective' in doc.style),
    opera12 = ('OTransition' in doc.style),
    iPhone = /iphone/i.test(ua),
    iPad = /ipad/i.test(ua),
    iPod = /ipod/i.test(ua);
var touch = !window.L_NO_TOUCH && (pointer || 'ontouchstart' in window || window.DocumentTouch && document instanceof window.DocumentTouch);
var _default = {
  // @property ie: Boolean
  // `true` for all Internet Explorer versions (not Edge).
  ie: ie,
  // @property ielt9: Boolean
  // `true` for Internet Explorer versions less than 9.
  ielt9: ie && !document.addEventListener,
  ie9: ie && document.documentMode === 9,
  // @property edge: Boolean
  // `true` for the Edge web browser.
  edge: 'msLaunchUri' in navigator && !('documentMode' in document),
  // @property webkit: Boolean
  // `true` for webkit-based browsers like Chrome and Safari (including mobile versions).
  webkit: webkit,
  // @property gecko: Boolean
  // `true` for gecko-based browsers like Firefox.
  gecko: gecko,
  // @property android: Boolean
  // `true` for any browser running on an Android platform.
  android: ua.indexOf('android') !== -1,
  // @property android23: Boolean
  // `true` for browsers running on Android 2 or Android 3.
  android23: android23,
  // @property chrome: Boolean
  // `true` for the Chrome browser.
  chrome: chrome,
  // @property safari: Boolean
  // `true` for the Safari browser.
  safari: !chrome && ua.indexOf('safari') !== -1,
  // @property win: Boolean
  // `true` when the browser is running in a Windows platform
  win: win,
  // @property ie3d: Boolean
  // `true` for all Internet Explorer versions supporting CSS transforms.
  ie3d: ie3d,
  // @property webkit3d: Boolean
  // `true` for webkit-based browsers supporting CSS transforms.
  webkit3d: webkit3d,
  // @property gecko3d: Boolean
  // `true` for gecko-based browsers supporting CSS transforms.
  gecko3d: gecko3d,
  // @property opera12: Boolean
  // `true` for the Opera browser supporting CSS transforms (version 12 or later).
  opera12: opera12,
  // @property any3d: Boolean
  // `true` for all browsers supporting CSS transforms.
  any3d: (ie3d || webkit3d || gecko3d) && !opera12 && !phantomjs,
  // @property mobile: Boolean
  // `true` for all browsers running in a mobile device.
  mobile: mobile,
  // @property mobileWebkit: Boolean
  // `true` for all webkit-based browsers in a mobile device.
  mobileWebkit: mobile && webkit,
  // @property mobileWebkit3d: Boolean
  // `true` for all webkit-based browsers in a mobile device supporting CSS transforms.
  mobileWebkit3d: mobile && webkit3d,
  // @property mobileOpera: Boolean
  // `true` for the Opera browser in a mobile device.
  mobileOpera: mobile && window.opera,
  // @property mobileGecko: Boolean
  // `true` for gecko-based browsers running in a mobile device.
  mobileGecko: mobile && gecko,
  // @property touch: Boolean
  // `true` for all browsers supporting [touch events](https://developer.mozilla.org/docs/Web/API/Touch_events).
  touch: !!touch,
  // @property msPointer: Boolean
  // `true` for browsers implementing the Microsoft touch events model (notably IE10).
  msPointer: !!msPointer,
  // @property pointer: Boolean
  // `true` for all browsers supporting [pointer events](https://msdn.microsoft.com/en-us/library/dn433244%28v=vs.85%29.aspx).
  pointer: !!pointer,
  // @property retina: Boolean
  // `true` for browsers on a high-resolution "retina" screen.
  retina: (window.devicePixelRatio || window.screen.deviceXDPI / window.screen.logicalXDPI) > 1,
  // @property phantomjs: Boolean
  // `true` when the browser is running on phantomjs
  phantomjs: phantomjs,
  iPhone: iPhone,
  iPad: iPad,
  iPod: iPod,
  ios: iPhone || iPad || iPod
};
exports["default"] = _default;

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _vMap = _interopRequireDefault(__webpack_require__(38));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/6/24.
 */
//
//Copyright (c) 2014 Ga?tan Renaudeau
//
//Permission is hereby granted, free of charge, to any person
//obtaining a copy of this software and associated documentation
//files (the "Software"), to deal in the Software without
//restriction, including without limitation the rights to use,
//    copy, modify, merge, publish, distribute, sublicense, and/or sell
//copies of the Software, and to permit persons to whom the
//Software is furnished to do so, subject to the following
//conditions:
//
//    The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
//OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
//HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
//    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
//FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
//OTHER DEALINGS IN THE SOFTWARE.
var HALF_PI = Math.PI / 2;
var global = typeof window === 'object' ? window : global; // These values are established by empiricism with tests (tradeoff: performance VS precision)

var NEWTON_ITERATIONS = 4;
var NEWTON_MIN_SLOPE = 0.001;
var SUBDIVISION_PRECISION = 0.0000001;
var SUBDIVISION_MAX_ITERATIONS = 10;
var kSplineTableSize = 11;
var kSampleStepSize = 1.0 / (kSplineTableSize - 1.0);
var float32ArraySupported = ('Float32Array' in global);

function A(aA1, aA2) {
  return 1.0 - 3.0 * aA2 + 3.0 * aA1;
}

function B(aA1, aA2) {
  return 3.0 * aA2 - 6.0 * aA1;
}

function C(aA1) {
  return 3.0 * aA1;
} // Returns x(t) given t, x1, and x2, or y(t) given t, y1, and y2.


function calcBezier(aT, aA1, aA2) {
  return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT;
} // Returns dx/dt given t, x1, and x2, or dy/dt given t, y1, and y2.


function getSlope(aT, aA1, aA2) {
  return 3.0 * A(aA1, aA2) * aT * aT + 2.0 * B(aA1, aA2) * aT + C(aA1);
}

function binarySubdivide(aX, aA, aB, mX1, mX2) {
  var currentX,
      currentT,
      i = 0;

  do {
    currentT = aA + (aB - aA) / 2.0;
    currentX = calcBezier(currentT, mX1, mX2) - aX;

    if (currentX > 0.0) {
      aB = currentT;
    } else {
      aA = currentT;
    }
  } while (Math.abs(currentX) > SUBDIVISION_PRECISION && ++i < SUBDIVISION_MAX_ITERATIONS);

  return currentT;
}

function BezierEasing(mX1, mY1, mX2, mY2) {
  // Validate arguments
  if (arguments.length !== 4) {
    throw new Error("BezierEasing requires 4 arguments.");
  }

  for (var i = 0; i < 4; ++i) {
    if (typeof arguments[i] !== "number" || isNaN(arguments[i]) || !isFinite(arguments[i])) {
      throw new Error("BezierEasing arguments should be integers.");
    }
  }

  if (mX1 < 0 || mX1 > 1 || mX2 < 0 || mX2 > 1) {
    throw new Error("BezierEasing x values must be in [0, 1] range.");
  }

  var mSampleValues = float32ArraySupported ? new Float32Array(kSplineTableSize) : [];

  function newtonRaphsonIterate(aX, aGuessT) {
    for (var i = 0; i < NEWTON_ITERATIONS; ++i) {
      var currentSlope = getSlope(aGuessT, mX1, mX2);

      if (currentSlope === 0.0) {
        return aGuessT;
      }

      var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
      aGuessT -= currentX / currentSlope;
    }

    return aGuessT;
  }

  function calcSampleValues() {
    for (var i = 0; i < kSplineTableSize; ++i) {
      mSampleValues[i] = calcBezier(i * kSampleStepSize, mX1, mX2);
    }
  }

  function getTForX(aX) {
    var intervalStart = 0.0;
    var currentSample = 1;
    var lastSample = kSplineTableSize - 1;

    for (; currentSample != lastSample && mSampleValues[currentSample] <= aX; ++currentSample) {
      intervalStart += kSampleStepSize;
    }

    --currentSample; // Interpolate to provide an initial guess for t

    var dist = (aX - mSampleValues[currentSample]) / (mSampleValues[currentSample + 1] - mSampleValues[currentSample]);
    var guessForT = intervalStart + dist * kSampleStepSize;
    var initialSlope = getSlope(guessForT, mX1, mX2);

    if (initialSlope >= NEWTON_MIN_SLOPE) {
      return newtonRaphsonIterate(aX, guessForT);
    } else if (initialSlope === 0.0) {
      return guessForT;
    } else {
      return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize, mX1, mX2);
    }
  }

  var _precomputed = false;

  function precompute() {
    _precomputed = true;

    if (mX1 != mY1 || mX2 != mY2) {
      calcSampleValues();
    }
  }

  var f = function (aX) {
    if (!_precomputed) {
      precompute();
    }

    if (mX1 === mY1 && mX2 === mY2) {
      return aX;
    } // linear
    // Because JavaScript number are imprecise, we should guarantee the extremes are right.


    if (aX === 0) {
      return 0;
    }

    if (1 - aX < 0.001) {
      return 1;
    }

    return calcBezier(getTForX(aX), mY1, mY2);
  };

  f.getControlPoints = function () {
    return [{
      x: mX1,
      y: mY1
    }, {
      x: mX2,
      y: mY2
    }];
  };

  var args = [mX1, mY1, mX2, mY2];
  var str = "BezierEasing(" + args + ")";

  f.toString = function () {
    return str;
  }; //var css = "cubic-bezier("+args+")";
  //f.toCSS = function () {?return css; };


  return f;
} // CSS mapping


BezierEasing.css = {
  "ease": BezierEasing(0.25, 0.1, 0.25, 1.0),
  "linear": BezierEasing(0.00, 0.0, 1.00, 1.0),
  "ease-in": BezierEasing(0.42, 0.0, 1.00, 1.0),
  "ease-out": BezierEasing(0.00, 0.0, 0.58, 1.0),
  "ease-in-out": BezierEasing(0.42, 0.0, 0.58, 1.0),
  "swing": BezierEasing(0.02, 0.01, 0.47, 1.0),
  "ease-in-back": BezierEasing(0.6, -0.28, 0.735, 0.045),
  "ease-out-back": BezierEasing(0.175, 0.885, 0.32, 1.275),
  "ease-in-quart": BezierEasing(0.895, 0.03, 0.685, 0.22),
  "ease-out-quart": BezierEasing(0.165, 0.84, 0.44, 1),
  "ease-in-quint": BezierEasing(0.755, 0.05, 0.855, 0.06),
  "ease-out-quint": BezierEasing(0.23, 1, 0.32, 1),
  "ease-in-quad": BezierEasing(0.55, 0.085, 0.68, 0.53),
  "ease-out-quad": BezierEasing(0.25, 0.46, 0.45, 0.94),
  "ease-in-out-quad": BezierEasing(0.455, 0.03, 0.515, 0.955),
  "ease-out-cubic": BezierEasing(0.215, 0.61, 0.355, 1)
};
BezierEasing.custom = {
  "ease-out": BezierEasing(0.00, 0.0, 0.16, 1),
  "ease-out-quint": BezierEasing(0.19, 1, 0.22, 1),
  "ease-out-back": BezierEasing(0.18, 0.89, 0.32, 1.6)
};

BezierEasing.calculateCubicOutT = function (det) {
  return 1 - Math.pow(1 - det, 1 / 3);
};

BezierEasing.calculateQuadInT = function (det) {
  return Math.sqrt(det);
};

var DOUBLE_PI = 2 * Math.PI;

var d3_identity = function (d) {
  return d;
};

var d3_ease_default = function () {
  return d3_identity;
};

var d3_ease = new _vMap["default"]({
  linear: d3_ease_default,
  poly: d3_ease_poly,
  quad: function () {
    return d3_ease_quad;
  },
  cubic: function () {
    return d3_ease_cubic;
  },
  sin: function () {
    return d3_ease_sin;
  },
  exp: function () {
    return d3_ease_exp;
  },
  circle: function () {
    return d3_ease_circle;
  },
  elastic: d3_ease_elastic,
  back: d3_ease_back,
  bounce: function () {
    return d3_ease_bounce;
  }
});
var d3_ease_mode = new _vMap["default"]({
  "in": d3_identity,
  out: d3_ease_reverse,
  "in-out": d3_ease_reflect,
  "out-in": function (f) {
    return d3_ease_reflect(d3_ease_reverse(f));
  }
});

BezierEasing.ease = function (name) {
  var i = name.indexOf("-"),
      t = i >= 0 ? name.slice(0, i) : name,
      m = i >= 0 ? name.slice(i + 1) : "in";
  t = d3_ease.get(t) || d3_ease_default;
  m = d3_ease_mode.get(m) || d3_identity;
  return d3_ease_clamp(m(t.apply(null, Array.prototype.slice.call(arguments, 1))));
};

function d3_ease_clamp(f) {
  return function (t) {
    return t <= 0 ? 0 : t >= 1 ? 1 : f(t);
  };
}

function d3_ease_reverse(f) {
  return function (t) {
    return 1 - f(1 - t);
  };
}

function d3_ease_reflect(f) {
  return function (t) {
    return .5 * (t < .5 ? f(2 * t) : 2 - f(2 - 2 * t));
  };
}

function d3_ease_quad(t) {
  return t * t;
}

function d3_ease_cubic(t) {
  return t * t * t;
}

function d3_ease_cubicInOut(t) {
  if (t <= 0) {
    return 0;
  }

  if (t >= 1) {
    return 1;
  }

  var t2 = t * t,
      t3 = t2 * t;
  return 4 * (t < .5 ? t3 : 3 * (t - t2) + t3 - .75);
}

function d3_ease_poly(e) {
  return function (t) {
    return Math.pow(t, e);
  };
}

function d3_ease_sin(t) {
  return 1 - Math.cos(t * HALF_PI);
}

function d3_ease_exp(t) {
  return Math.pow(2, 10 * (t - 1));
}

function d3_ease_circle(t) {
  return 1 - Math.sqrt(1 - t * t);
}

function d3_ease_elastic(a, p) {
  var s;

  if (arguments.length < 2) {
    p = .45;
  }

  if (arguments.length) {
    s = p / DOUBLE_PI * Math.asin(1 / a);
  } else {
    a = 1, s = p / 4;
  }

  return function (t) {
    return 1 + a * Math.pow(2, -10 * t) * Math.sin((t - s) * DOUBLE_PI / p);
  };
}

function d3_ease_back(s) {
  if (!s) {
    s = 1.70158;
  }

  return function (t) {
    return t * t * ((s + 1) * t - s);
  };
}

function d3_ease_bounce(t) {
  return t < 1 / 2.75 ? 7.5625 * t * t : t < 2 / 2.75 ? 7.5625 * (t -= 1.5 / 2.75) * t + .75 : t < 2.5 / 2.75 ? 7.5625 * (t -= 2.25 / 2.75) * t + .9375 : 7.5625 * (t -= 2.625 / 2.75) * t + .984375;
}

var _default = BezierEasing;
exports["default"] = _default;

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _vMap = _interopRequireDefault(__webpack_require__(38));

var _Constants = _interopRequireDefault(__webpack_require__(1));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/2/14.
 */
var EPSILON = 1e-6,
    EPSILON2 = EPSILON * EPSILON,
    PI = Math.PI,
    DOUBLE_PI = 2 * PI,
    DOUBLE_PI_EPSILON = DOUBLE_PI - EPSILON,
    HALF_PI = PI / 2,
    d3_radians = PI / 180,
    d3_degrees = 180 / PI;
var abs = Math.abs;
var inverted;

function d3_asin(x) {
  return x > 1 ? HALF_PI : x < -1 ? -HALF_PI : Math.asin(x);
}

function d3_geom_pointX(d) {
  return d[0];
}

function d3_geom_pointY(d) {
  return d[1];
}

function d3_identity(d) {
  return d;
}

function d3_true() {
  return true;
}

var PathGenerator = {};

function d3_zero() {
  return 0;
}

PathGenerator.arc = function () {
  var toCenter = true;
  var closePath = true;
  var innerRadius = d3_svg_arcInnerRadius,
      outerRadius = d3_svg_arcOuterRadius,
      cornerRadius = d3_zero,
      padRadius = d3_svg_arcAuto,
      startAngle = d3_svg_arcStartAngle,
      endAngle = d3_svg_arcEndAngle,
      padAngle = d3_svg_arcPadAngle;

  function arc() {
    var r0 = Math.max(0, +innerRadius.apply(this, arguments)),
        r1 = Math.max(0, +outerRadius.apply(this, arguments)),
        a0 = startAngle.apply(this, arguments) - HALF_PI,
        a1 = endAngle.apply(this, arguments) - HALF_PI,
        da = Math.abs(a1 - a0),
        cw = a0 > a1 ? 0 : 1;

    if (r1 < r0) {
      rc = r1, r1 = r0, r0 = rc;
    }

    if (da >= DOUBLE_PI_EPSILON) {
      return circleSegment(r1, cw) + (r0 ? circleSegment(r0, 1 - cw) : "") + "Z";
    }

    var rc,
        cr,
        rp,
        ap,
        p0 = 0,
        p1 = 0,
        x0,
        y0,
        x1,
        y1,
        x2,
        y2,
        x3,
        y3,
        path = [];

    if (ap = (+padAngle.apply(this, arguments) || 0) / 2) {
      rp = padRadius === d3_svg_arcAuto ? Math.sqrt(r0 * r0 + r1 * r1) : +padRadius.apply(this, arguments);

      if (!cw) {
        p1 *= -1;
      }

      if (r1) {
        p1 = d3_asin(rp / r1 * Math.sin(ap));
      }

      if (r0) {
        p0 = d3_asin(rp / r0 * Math.sin(ap));
      }
    }

    if (r1) {
      x0 = r1 * Math.cos(a0 + p1);
      y0 = r1 * Math.sin(a0 + p1);
      x1 = r1 * Math.cos(a1 - p1);
      y1 = r1 * Math.sin(a1 - p1);
      var l1 = Math.abs(a1 - a0 - 2 * p1) <= PI ? 0 : 1;

      if (p1 && d3_svg_arcSweep(x0, y0, x1, y1) === cw ^ l1) {
        var h1 = (a0 + a1) / 2;
        x0 = r1 * Math.cos(h1);
        y0 = r1 * Math.sin(h1);
        x1 = y1 = null;
      }
    } else {
      x0 = y0 = 0;
    }

    if (r0) {
      x2 = r0 * Math.cos(a1 - p0);
      y2 = r0 * Math.sin(a1 - p0);
      x3 = r0 * Math.cos(a0 + p0);
      y3 = r0 * Math.sin(a0 + p0);
      var l0 = Math.abs(a0 - a1 + 2 * p0) <= PI ? 0 : 1;

      if (p0 && d3_svg_arcSweep(x2, y2, x3, y3) === 1 - cw ^ l0) {
        var h0 = (a0 + a1) / 2;
        x2 = r0 * Math.cos(h0);
        y2 = r0 * Math.sin(h0);
        x3 = y3 = null;
      }
    } else {
      x2 = y2 = 0;
    }

    if ((rc = Math.min(Math.abs(r1 - r0) / 2, +cornerRadius.apply(this, arguments))) > .001) {
      cr = r0 < r1 ^ cw ? 0 : 1;
      var oc = x3 == null ? [x2, y2] : x1 == null ? [x0, y0] : d3_geom_polygonIntersect([x0, y0], [x3, y3], [x1, y1], [x2, y2]),
          ax = x0 - oc[0],
          ay = y0 - oc[1],
          bx = x1 - oc[0],
          by = y1 - oc[1],
          kc = 1 / Math.sin(Math.acos((ax * bx + ay * by) / (Math.sqrt(ax * ax + ay * ay) * Math.sqrt(bx * bx + by * by))) / 2),
          lc = Math.sqrt(oc[0] * oc[0] + oc[1] * oc[1]);

      if (x1 != null) {
        var rc1 = Math.min(rc, (r1 - lc) / (kc + 1)),
            t30 = d3_svg_arcCornerTangents(x3 == null ? [x2, y2] : [x3, y3], [x0, y0], r1, rc1, cw),
            t12 = d3_svg_arcCornerTangents([x1, y1], [x2, y2], r1, rc1, cw);

        if (rc === rc1) {
          path.push("M", t30[0], "A", rc1, ",", rc1, " 0 0,", cr, " ", t30[1], "A", r1, ",", r1, " 0 ", 1 - cw ^ d3_svg_arcSweep(t30[1][0], t30[1][1], t12[1][0], t12[1][1]), ",", cw, " ", t12[1], "A", rc1, ",", rc1, " 0 0,", cr, " ", t12[0]);
        } else {
          path.push("M", t30[0], "A", rc1, ",", rc1, " 0 1,", cr, " ", t12[0]);
        }
      } else {
        path.push("M", x0, ",", y0);
      }

      if (x3 != null) {
        var rc0 = Math.min(rc, (r0 - lc) / (kc - 1)),
            t03 = d3_svg_arcCornerTangents([x0, y0], [x3, y3], r0, -rc0, cw),
            t21 = d3_svg_arcCornerTangents([x2, y2], x1 == null ? [x0, y0] : [x1, y1], r0, -rc0, cw);

        if (rc === rc0) {
          path.push("L", t21[0], "A", rc0, ",", rc0, " 0 0,", cr, " ", t21[1], "A", r0, ",", r0, " 0 ", cw ^ d3_svg_arcSweep(t21[1][0], t21[1][1], t03[1][0], t03[1][1]), ",", 1 - cw, " ", t03[1], "A", rc0, ",", rc0, " 0 0,", cr, " ", t03[0]);
        } else {
          path.push("L", t21[0], "A", rc0, ",", rc0, " 0 0,", cr, " ", t03[0]);
        }
      } else if (toCenter) {
        path.push("L", x2, ",", y2);
      }
    } else {
      path.push("M", x0, ",", y0);

      if (x1 != null) {
        path.push("A", r1, ",", r1, " 0 ", l1, ",", cw, " ", x1, ",", y1);
      }

      if (toCenter) {
        path.push("L", x2, ",", y2);
      }

      if (x3 != null) {
        path.push("A", r0, ",", r0, " 0 ", l0, ",", 1 - cw, " ", x3, ",", y3);
      }
    }

    if (closePath) {
      path.push("Z");
    }

    return path.join("");
  }

  function circleSegment(r1, cw) {
    return "M0," + r1 + "A" + r1 + "," + r1 + " 0 1," + cw + " 0," + -r1 + "A" + r1 + "," + r1 + " 0 1," + cw + " 0," + r1;
  }

  arc.toCenter = function (v) {
    if (!arguments.length) {
      return toCenter;
    }

    toCenter = !!v;
    return arc;
  };

  arc.closePath = function (v) {
    if (!arguments.length) {
      return closePath;
    }

    closePath = !!v;
    return arc;
  };

  arc.innerRadius = function (v) {
    if (!arguments.length) {
      return innerRadius;
    }

    innerRadius = d3_functor(v);
    return arc;
  };

  arc.outerRadius = function (v) {
    if (!arguments.length) {
      return outerRadius;
    }

    outerRadius = d3_functor(v);
    return arc;
  };

  arc.cornerRadius = function (v) {
    if (!arguments.length) {
      return cornerRadius;
    }

    cornerRadius = d3_functor(v);
    return arc;
  };

  arc.padRadius = function (v) {
    if (!arguments.length) {
      return padRadius;
    }

    padRadius = v == d3_svg_arcAuto ? d3_svg_arcAuto : d3_functor(v);
    return arc;
  };

  arc.startAngle = function (v) {
    if (!arguments.length) {
      return startAngle;
    }

    startAngle = d3_functor(v);
    return arc;
  };

  arc.endAngle = function (v) {
    if (!arguments.length) {
      return endAngle;
    }

    endAngle = d3_functor(v);
    return arc;
  };

  arc.padAngle = function (v) {
    if (!arguments.length) {
      return padAngle;
    }

    padAngle = d3_functor(v);
    return arc;
  };

  arc.centroid = function () {
    var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2,
        a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - HALF_PI;
    return [Math.cos(a) * r, Math.sin(a) * r];
  };

  return arc;
};

var d3_svg_arcAuto = "auto";

function d3_svg_arcInnerRadius(d) {
  return d.innerRadius;
}

function d3_svg_arcOuterRadius(d) {
  return d.outerRadius;
}

function d3_svg_arcStartAngle(d) {
  return d.startAngle;
}

function d3_svg_arcEndAngle(d) {
  return d.endAngle;
}

function d3_svg_arcPadAngle(d) {
  return d && d.padAngle;
}

function d3_svg_arcSweep(x0, y0, x1, y1) {
  return (x0 - x1) * y0 - (y0 - y1) * x0 > 0 ? 0 : 1;
}

function d3_svg_arcCornerTangents(p0, p1, r1, rc, cw) {
  var x01 = p0[0] - p1[0],
      y01 = p0[1] - p1[1],
      lo = (cw ? rc : -rc) / Math.sqrt(x01 * x01 + y01 * y01),
      ox = lo * y01,
      oy = -lo * x01,
      x1 = p0[0] + ox,
      y1 = p0[1] + oy,
      x2 = p1[0] + ox,
      y2 = p1[1] + oy,
      x3 = (x1 + x2) / 2,
      y3 = (y1 + y2) / 2,
      dx = x2 - x1,
      dy = y2 - y1,
      d2 = dx * dx + dy * dy,
      r = r1 - rc,
      D = x1 * y2 - x2 * y1,
      d = (dy < 0 ? -1 : 1) * Math.sqrt(r * r * d2 - D * D),
      cx0 = (D * dy - dx * d) / d2,
      cy0 = (-D * dx - dy * d) / d2,
      cx1 = (D * dy + dx * d) / d2,
      cy1 = (-D * dx + dy * d) / d2,
      dx0 = cx0 - x3,
      dy0 = cy0 - y3,
      dx1 = cx1 - x3,
      dy1 = cy1 - y3;

  if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) {
    cx0 = cx1, cy0 = cy1;
  }

  return [[cx0 - ox, cy0 - oy], [cx0 * r1 / r, cy0 * r1 / r]];
}

function d3_geom_polygonIntersect(c, d, a, b) {
  var x1 = c[0],
      x3 = a[0],
      x21 = d[0] - x1,
      x43 = b[0] - x3,
      y1 = c[1],
      y3 = a[1],
      y21 = d[1] - y1,
      y43 = b[1] - y3,
      ua = (x43 * (y1 - y3) - y43 * (x1 - x3)) / (y43 * x21 - x43 * y21);
  return [x1 + ua * x21, y1 + ua * y21];
}

function d3_functor(v) {
  return typeof v === "function" ? v : function () {
    return v;
  };
}

function d3_svg_line(projection) {
  var x = d3_geom_pointX,
      y = d3_geom_pointY,
      defined = d3_true,
      interpolate = d3_svg_lineLinear,
      interpolateKey = interpolate.key,
      tension = .7;

  function line(data, invert) {
    var segments = [],
        points = [],
        i = -1,
        n = data.length,
        d,
        fx = d3_functor(x),
        fy = d3_functor(y);

    function segment() {
      segments.push("M", interpolate(projection(points), tension));
    }

    while (++i < n) {
      if (defined.call(this, d = data[i], i)) {
        points.push([+fx.call(this, d, i), +fy.call(this, d, i)]);
      } else if (points.length) {
        segment();
        points = [];
      }
    }

    if (points.length) {
      segment();
    }

    return segments.length ? segments.join("") : null;
  }

  line.x = function (_) {
    if (!arguments.length) {
      return x;
    }

    x = _;
    return line;
  };

  line.y = function (_) {
    if (!arguments.length) {
      return y;
    }

    y = _;
    return line;
  };

  line.defined = function (_) {
    if (!arguments.length) {
      return defined;
    }

    defined = _;
    return line;
  };

  line.interpolate = function (_) {
    if (!arguments.length) {
      return interpolateKey;
    }

    if (typeof _ === "function") {
      interpolateKey = interpolate = _;
    } else {
      interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
    }

    return line;
  };

  line.tension = function (_) {
    if (!arguments.length) {
      return tension;
    }

    tension = _;
    return line;
  };

  return line;
}

PathGenerator.line = function (invert) {
  inverted = invert;
  return d3_svg_line(d3_identity);
};

var d3_svg_lineInterpolators = new _vMap["default"]({
  linear: d3_svg_lineLinear,
  "linear-closed": d3_svg_lineLinearClosed,
  step: d3_svg_lineStep,
  "step-before": d3_svg_lineStepBefore,
  "step-after": d3_svg_lineStepAfter,
  basis: d3_svg_lineBasis,
  "basis-open": d3_svg_lineBasisOpen,
  "basis-closed": d3_svg_lineBasisClosed,
  bundle: d3_svg_lineBundle,
  cardinal: d3_svg_lineCardinal,
  "cardinal-open": d3_svg_lineCardinalOpen,
  "cardinal-closed": d3_svg_lineCardinalClosed,
  monotone: d3_svg_lineMonotone
});
d3_svg_lineInterpolators.forEach(function (key, value) {
  value.key = key;
  value.closed = /-closed$/.test(key);
});

function d3_svg_lineLinear(points) {
  return points.join("L");
}

function d3_svg_lineLinearClosed(points) {
  return d3_svg_lineLinear(points) + "Z";
}

function d3_svg_lineStep(points) {
  var i = 0,
      n = points.length,
      p = points[0],
      path = [p[0], ",", p[1]];

  while (++i < n) {
    path.push("H", (p[0] + (p = points[i])[0]) / 2, "V", p[1]);
  }

  if (n > 1) {
    path.push("H", p[0]);
  }

  return path.join("");
}

function d3_svg_lineStepBefore(points) {
  var i = 0,
      n = points.length,
      p = points[0],
      path = [p[0], ",", p[1]];

  while (++i < n) {
    path.push("V", (p = points[i])[1], "H", p[0]);
  }

  return path.join("");
}

function d3_svg_lineStepAfter(points) {
  var i = 0,
      n = points.length,
      p = points[0],
      path = [p[0], ",", p[1]];

  while (++i < n) {
    path.push("H", (p = points[i])[0], "V", p[1]);
  }

  return path.join("");
}

function d3_svg_lineCardinalOpen(points, tension) {
  return points.length < 4 ? d3_svg_lineLinear(points) : points[1] + d3_svg_lineHermite(points.slice(1, -1), d3_svg_lineCardinalTangents(points, tension));
}

function d3_svg_lineCardinalClosed(points, tension) {
  return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite((points.push(points[0]), points), d3_svg_lineCardinalTangents([points[points.length - 2]].concat(points, [points[1]]), tension));
}

function d3_svg_lineCardinal(points, tension) {
  return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineCardinalHighCharts(points); // return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineCardinalTangents(points, tension));
}

PathGenerator.d3_svg_lineCardinalHighCharts = d3_svg_lineCardinalHighCharts;

function d3_svg_lineCardinalHighCharts(points) {
  if (points.length < 3) {
    return d3_svg_lineLinear(points);
  }

  var smoothing = 1.5,
      denom = smoothing + 1;

  var correction = 0,
      lastPoint,
      currPoint,
      nextPoint,
      lastX,
      lastY,
      currX,
      currY,
      nextX,
      nextY,
      leftContX,
      leftContY,
      rightContX,
      rightContY,
      _rightContX,
      _rightContY;

  var i = 0,
      len = points.length - 1,
      path = '';

  while (i++ < len) {
    lastPoint = points[i - 1];
    currPoint = points[i];

    if (i == len) {
      nextPoint = points[i];
    } else {
      nextPoint = points[i + 1];
    }

    if (inverted) {
      lastX = lastPoint[1] || 0;
      lastY = lastPoint[0] || 0;
      currX = currPoint[1] || 0;
      currY = currPoint[0] || 0;
      nextX = nextPoint[1] || 0;
      nextY = nextPoint[0] || 0;
    } else {
      lastX = lastPoint[0] || 0;
      lastY = lastPoint[1] || 0;
      currX = currPoint[0] || 0;
      currY = currPoint[1] || 0;
      nextX = nextPoint[0] || 0;
      nextY = nextPoint[1] || 0;
    }

    leftContX = (smoothing * currX + lastX) / denom;
    leftContY = (smoothing * currY + lastY) / denom;
    rightContX = (smoothing * currX + nextX) / denom;
    rightContY = (smoothing * currY + nextY) / denom;

    if (rightContX != leftContX) {
      correction = (rightContY - leftContY) * (rightContX - currX) / (rightContX - leftContX) + currY - rightContY;
    }

    leftContY += correction;
    rightContY += correction;

    if (leftContY > lastY && leftContY > currY) {
      leftContY = Math.max(lastY, currY);
      rightContY = 2 * currY - leftContY;
    } else if (leftContY < lastY && leftContY < currY) {
      leftContY = Math.min(lastY, currY);
      rightContY = 2 * currY - leftContY;
    }

    if (rightContY > nextY && rightContY > currY) {
      rightContY = Math.max(nextY, currY);
      leftContY = 2 * currY - rightContY;
    } else if (rightContY < nextY && rightContY < currY) {
      rightContY = Math.min(nextY, currY);
      leftContY = 2 * currY - rightContY;
    }

    if (inverted) {
      path += "C" + (_rightContY || lastY || 0) + "," + ((_rightContX || lastX || 0) + ",") + ((leftContY || currY || 0) + ",") + ((leftContX || currX || 0) + ",") + (currY + ",") + ("" + currX);
    } else {
      path += "C" + (_rightContX || lastX || 0) + "," + ((_rightContY || lastY || 0) + ",") + ((leftContX || currX || 0) + ",") + ((leftContY || currY || 0) + ",") + (currX + ",") + ("" + currY);
    }

    _rightContX = rightContX;
    _rightContY = rightContY;
  }

  return path;
}

function d3_svg_lineHermite(points, tangents) {
  if (tangents.length < 1 || points.length != tangents.length && points.length != tangents.length + 2) {
    return d3_svg_lineLinear(points);
  }

  var quad = points.length != tangents.length,
      path = "",
      p0 = points[0],
      p = points[1],
      t0 = tangents[0],
      t = t0,
      pi = 1;

  if (quad) {
    path += "Q" + (p[0] - t0[0] * 2 / 3) + "," + (p[1] - t0[1] * 2 / 3) + "," + p[0] + "," + p[1];
    p0 = points[1];
    pi = 2;
  }

  if (tangents.length > 1) {
    t = tangents[1];
    p = points[pi];
    pi++;
    path += "C" + (p0[0] + t0[0]) + "," + (p0[1] + t0[1]) + "," + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];

    for (var i = 2; i < tangents.length; i++, pi++) {
      p = points[pi];
      t = tangents[i];
      path += "S" + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];
    }
  }

  if (quad) {
    var lp = points[pi];
    path += "Q" + (p[0] + t[0] * 2 / 3) + "," + (p[1] + t[1] * 2 / 3) + "," + lp[0] + "," + lp[1];
  }

  return path;
}

function d3_svg_lineCardinalTangents(points, tension) {
  var tangents = [],
      a = (1 - tension) / 2,
      p0,
      p1 = points[0],
      p2 = points[1],
      i = 1,
      n = points.length;

  while (++i < n) {
    p0 = p1;
    p1 = p2;
    p2 = points[i];
    tangents.push([a * (p2[0] - p0[0]), a * (p2[1] - p0[1])]);
  }

  return tangents;
}

function d3_svg_lineBasis(points) {
  if (points.length < 3) {
    return d3_svg_lineLinear(points);
  }

  var i = 1,
      n = points.length,
      pi = points[0],
      x0 = pi[0],
      y0 = pi[1],
      px = [x0, x0, x0, (pi = points[1])[0]],
      py = [y0, y0, y0, pi[1]],
      path = [x0, ",", y0, "L", d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py)];
  points.push(points[n - 1]);

  while (++i <= n) {
    pi = points[i];
    px.shift();
    px.push(pi[0]);
    py.shift();
    py.push(pi[1]);
    d3_svg_lineBasisBezier(path, px, py);
  }

  points.pop();
  path.push("L", pi);
  return path.join("");
}

function d3_svg_lineBasisOpen(points) {
  if (points.length < 4) {
    return d3_svg_lineLinear(points);
  }

  var path = [],
      i = -1,
      n = points.length,
      pi,
      px = [0],
      py = [0];

  while (++i < 3) {
    pi = points[i];
    px.push(pi[0]);
    py.push(pi[1]);
  }

  path.push(d3_svg_lineDot4(d3_svg_lineBasisBezier3, px) + "," + d3_svg_lineDot4(d3_svg_lineBasisBezier3, py));
  --i;

  while (++i < n) {
    pi = points[i];
    px.shift();
    px.push(pi[0]);
    py.shift();
    py.push(pi[1]);
    d3_svg_lineBasisBezier(path, px, py);
  }

  return path.join("");
}

function d3_svg_lineBasisClosed(points) {
  var path,
      i = -1,
      n = points.length,
      m = n + 4,
      pi,
      px = [],
      py = [];

  while (++i < 4) {
    pi = points[i % n];
    px.push(pi[0]);
    py.push(pi[1]);
  }

  path = [d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py)];
  --i;

  while (++i < m) {
    pi = points[i % n];
    px.shift();
    px.push(pi[0]);
    py.shift();
    py.push(pi[1]);
    d3_svg_lineBasisBezier(path, px, py);
  }

  return path.join("");
}

function d3_svg_lineBundle(points, tension) {
  var n = points.length - 1;

  if (n) {
    var x0 = points[0][0],
        y0 = points[0][1],
        dx = points[n][0] - x0,
        dy = points[n][1] - y0,
        i = -1,
        p,
        t;

    while (++i <= n) {
      p = points[i];
      t = i / n;
      p[0] = tension * p[0] + (1 - tension) * (x0 + t * dx);
      p[1] = tension * p[1] + (1 - tension) * (y0 + t * dy);
    }
  }

  return d3_svg_lineBasis(points);
}

function d3_svg_lineDot4(a, b) {
  return a[0] * b[0] + a[1] * b[1] + a[2] * b[2] + a[3] * b[3];
}

var d3_svg_lineBasisBezier1 = [0, 2 / 3, 1 / 3, 0],
    d3_svg_lineBasisBezier2 = [0, 1 / 3, 2 / 3, 0],
    d3_svg_lineBasisBezier3 = [0, 1 / 6, 2 / 3, 1 / 6];

function d3_svg_lineBasisBezier(path, x, y) {
  path.push("C", d3_svg_lineDot4(d3_svg_lineBasisBezier1, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier1, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, y));
}

function d3_svg_lineSlope(p0, p1) {
  return (p1[1] - p0[1]) / (p1[0] - p0[0]);
}

function d3_svg_lineFiniteDifferences(points) {
  var i = 0,
      j = points.length - 1,
      m = [],
      p0 = points[0],
      p1 = points[1],
      d = m[0] = d3_svg_lineSlope(p0, p1);

  while (++i < j) {
    m[i] = (d + (d = d3_svg_lineSlope(p0 = p1, p1 = points[i + 1]))) / 2;
  }

  m[i] = d;
  return m;
}

function d3_svg_lineMonotoneTangents(points) {
  var tangents = [],
      d,
      a,
      b,
      s,
      m = d3_svg_lineFiniteDifferences(points),
      i = -1,
      j = points.length - 1;

  while (++i < j) {
    d = d3_svg_lineSlope(points[i], points[i + 1]);

    if (abs(d) < EPSILON) {
      m[i] = m[i + 1] = 0;
    } else {
      a = m[i] / d;
      b = m[i + 1] / d;
      s = a * a + b * b;

      if (s > 9) {
        s = d * 3 / Math.sqrt(s);
        m[i] = s * a;
        m[i + 1] = s * b;
      }
    }
  }

  i = -1;

  while (++i <= j) {
    s = (points[Math.min(j, i + 1)][0] - points[Math.max(0, i - 1)][0]) / (6 * (1 + m[i] * m[i]));
    tangents.push([s || 0, m[i] * s || 0]);
  }

  return tangents;
}

function d3_svg_lineMonotone(points) {
  return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineMonotoneTangents(points));
}

PathGenerator.line.radial = function () {
  var line = d3_svg_line(d3_svg_lineRadial);
  line.radius = line.x, delete line.x;
  line.angle = line.y, delete line.y;
  return line;
};

function d3_svg_lineRadial(points) {
  var point,
      i = -1,
      n = points.length,
      r,
      a;

  while (++i < n) {
    point = points[i];
    r = point[0];
    a = point[1] - HALF_PI;
    point[0] = r * Math.cos(a);
    point[1] = r * Math.sin(a);
  }

  return points;
}

function d3_svg_area(projection) {
  var x0 = d3_geom_pointX,
      x1 = d3_geom_pointX,
      y0 = 0,
      y1 = d3_geom_pointY,
      defined = d3_true,
      interpolate = d3_svg_lineLinear,
      interpolateKey = interpolate.key,
      interpolateReverse = interpolate,
      L = "L",
      tension = .7;

  function area(data) {
    var segments = [],
        points0 = [],
        points1 = [],
        i = -1,
        n = data.length,
        d,
        fx0 = d3_functor(x0),
        fy0 = d3_functor(y0),
        fx1 = x0 === x1 ? function () {
      return x;
    } : d3_functor(x1),
        fy1 = y0 === y1 ? function () {
      return y;
    } : d3_functor(y1),
        x,
        y;

    function segment() {
      segments.push("M", interpolate(projection(points1), tension), L, interpolateReverse(projection(points0.reverse()), tension), "Z");
    }

    while (++i < n) {
      if (defined.call(this, d = data[i], i)) {
        points0.push([x = +fx0.call(this, d, i), y = +fy0.call(this, d, i)]);
        points1.push([+fx1.call(this, d, i), +fy1.call(this, d, i)]);
      } else if (points0.length) {
        segment();
        points0 = [];
        points1 = [];
      }
    }

    if (points0.length) {
      segment();
    }

    return segments.length ? segments.join("") : null;
  }

  area.x = function (_) {
    if (!arguments.length) {
      return x1;
    }

    x0 = x1 = _;
    return area;
  };

  area.x0 = function (_) {
    if (!arguments.length) {
      return x0;
    }

    x0 = _;
    return area;
  };

  area.x1 = function (_) {
    if (!arguments.length) {
      return x1;
    }

    x1 = _;
    return area;
  };

  area.y = function (_) {
    if (!arguments.length) {
      return y1;
    }

    y0 = y1 = _;
    return area;
  };

  area.y0 = function (_) {
    if (!arguments.length) {
      return y0;
    }

    y0 = _;
    return area;
  };

  area.y1 = function (_) {
    if (!arguments.length) {
      return y1;
    }

    y1 = _;
    return area;
  };

  area.defined = function (_) {
    if (!arguments.length) {
      return defined;
    }

    defined = _;
    return area;
  };

  area.interpolate = function (_) {
    if (!arguments.length) {
      return interpolateKey;
    }

    if (typeof _ === "function") {
      interpolateKey = interpolate = _;
    } else {
      interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
    }

    interpolateReverse = interpolate.reverse || interpolate;
    L = interpolate.closed ? "M" : "L";
    return area;
  };

  area.tension = function (_) {
    if (!arguments.length) {
      return tension;
    }

    tension = _;
    return area;
  };

  return area;
}

d3_svg_lineStepBefore.reverse = d3_svg_lineStepAfter;
d3_svg_lineStepAfter.reverse = d3_svg_lineStepBefore;

PathGenerator.area = function () {
  return d3_svg_area(d3_identity);
};

PathGenerator.area.radial = function () {
  var area = d3_svg_area(d3_svg_lineRadial);
  area.radius = area.x, delete area.x;
  area.innerRadius = area.x0, delete area.x0;
  area.outerRadius = area.x1, delete area.x1;
  area.angle = area.y, delete area.y;
  area.startAngle = area.y0, delete area.y0;
  area.endAngle = area.y1, delete area.y1;
  return area;
};

PathGenerator.diagonal = function () {
  var source = d3_source,
      target = d3_target,
      projection = d3_svg_diagonalProjection;

  function diagonal(d, i) {
    var p0 = source.call(this, d, i),
        p3 = target.call(this, d, i),
        m = (p0.y + p3.y) / 2,
        p = [p0, {
      x: p0.x,
      y: m
    }, {
      x: p3.x,
      y: m
    }, p3];
    p = p.map(projection);
    return "M" + p[0] + "C" + p[1] + " " + p[2] + " " + p[3];
  }

  diagonal.source = function (x) {
    if (!arguments.length) {
      return source;
    }

    source = d3_functor(x);
    return diagonal;
  };

  diagonal.target = function (x) {
    if (!arguments.length) {
      return target;
    }

    target = d3_functor(x);
    return diagonal;
  };

  diagonal.projection = function (x) {
    if (!arguments.length) {
      return projection;
    }

    projection = x;
    return diagonal;
  };

  return diagonal;
};

function d3_source(d) {
  return d.source;
}

function d3_target(d) {
  return d.target;
}

function d3_svg_diagonalProjection(d) {
  return [d.x, d.y];
}

PathGenerator.getMarkerPath = function (markerType, radius) {
  switch (markerType) {
    case _Constants["default"].SYMBOL_AUTO:
    case _Constants["default"].CIRCLE:
    case _Constants["default"].CIRCLE_HOLLOW:
      return PathGenerator.arc().outerRadius(radius)({
        startAngle: 0,
        endAngle: 2 * Math.PI
      });

    case _Constants["default"].SQUARE:
    case _Constants["default"].SQUARE_HOLLOW:
      var leftTop = -radius + ',' + -radius;
      var rightTop = radius + ',' + -radius;
      var rightBottom = radius + ',' + radius;
      var leftBottom = -radius + ',' + radius;
      return 'M' + leftTop + 'L' + rightTop + 'L' + rightBottom + 'L' + leftBottom + 'Z';

    case _Constants["default"].DIAMOND:
    case _Constants["default"].DIAMOND_HOLLOW:
      var left = -radius + ',' + 0;
      var top = 0 + ',' + -radius;
      var right = radius + ',' + 0;
      var bottom = 0 + ',' + radius;
      return 'M' + left + 'L' + top + 'L' + right + 'L' + bottom + 'Z';

    case _Constants["default"].TRIANGLE:
    case _Constants["default"].TRIANGLE_HOLLOW:
      var sqrt3 = Math.sqrt(3);
      var left = -2 * radius / sqrt3 + ',' + radius;
      var top = 0 + ',' + -radius;
      var right = 2 * radius / sqrt3 + ',' + radius;
      return 'M' + left + 'L' + top + 'L' + right + 'Z';

    case _Constants["default"].STAR:
      radius *= 1.105; // magic num

      var r = getr(radius);
      var d = '';
      var i = -1;

      while (++i < 5) {
        var th = i * deg2rad(72),
            al = th + deg2rad(36);
        var a = getPos(th, radius, 3);
        var b = getPos(al, r, 3);
        var cmd = i ? 'L' : 'M';
        d += cmd + a[0] + ',' + a[1];
        d += 'L' + b[0] + ',' + b[1];
      }

      d += 'z';
      return d;

    case _Constants["default"].LOCATION:
      // todo,
      // (40 x 40)
      return 'M34.75,15.75A14.75,14.75,0,1,0,8.19,24.51L20,40,31.82,24.51h0A14.62,14.62,0,0,0,34.75,15.75ZM20,21.91a5.77,5.77,0,1,1,5.77-5.77A5.77,5.77,0,0,1,20,21.91Z';

    case _Constants["default"].ANCHOR_ICON:
      // (18 x 28)
      return 'M0,-28 C4.97056275,-28 9,-24.00634644 9,-19.07992512 C9,-17.8616986 8.75360187,-16.7005104 8.30750495,-15.642645 C7.4180692,-13.7976331 6.60280551,-12.1374788 5.86171387,-10.6522416 L5.49734905,-9.9241533 C2.09460285,-3.1449169 0.365363613,-0.2748662 0.309631348,-0.2486559 C0.152069092,0.0828853 -0.279388428,0.0828853 -0.451770485,-0.2486559 L-8.30750495,-15.642645 C-8.75360187,-16.7005104 -9,-17.8616986 -9,-19.07992512 C-9,-24.00634644 -4.97056275,-28 0,-28 Z M0,-22 C-1.65685425,-22 -3,-20.65685425 -3,-19 C-3,-17.3431458 -1.65685425,-16 0,-16 C1.65685425,-16 3,-17.3431458 3,-19 C3,-20.65685425 1.65685425,-22 0,-22 Z';

    default:
      return '';
  }
};

function deg2rad(deg) {
  return deg / 180 * Math.PI;
}

function getr(R) {
  return R * Math.sin(deg2rad(18)) / (Math.sin(deg2rad(36)) + Math.sin(deg2rad(18)) * Math.cos(deg2rad(36)));
}

function getPos(th, r, l) {
  return [(Math.sin(th) * r).toFixed(l), (-Math.cos(th) * r).toFixed(l)];
}

var _default = PathGenerator;
exports["default"] = _default;

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _interpolator = _interopRequireDefault(__webpack_require__(18));

var _vMap = _interopRequireDefault(__webpack_require__(38));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/2/14.
 */
function scaleExtent(domain) {
  var start = domain[0],
      stop = domain[domain.length - 1];
  return start < stop ? [start, stop] : [stop, start];
}

function d3_scale_bilinear(domain, range, uninterpolate, interpolate, minMax) {
  var u = uninterpolate(domain[0], domain[1]),
      i = interpolate(range[0], range[1]);
  return function (x) {
    var result = i(u(x));

    if (minMax && (0, _CoreUtils.hasDefined)(minMax[0])) {
      result = Math.max(result, minMax[0]);
    }

    if (minMax && (0, _CoreUtils.hasDefined)(minMax[1])) {
      result = Math.min(result, minMax[1]);
    }

    return result;
  };
}

function d3_scale_polylinear(domain, range, uninterpolate, interpolate) {
  var u = [],
      i = [],
      j = 0,
      k = Math.min(domain.length, range.length) - 1;

  if (domain[k] < domain[0]) {
    domain = domain.slice().reverse();
    range = range.slice().reverse();
  }

  while (++j <= k) {
    u.push(uninterpolate(domain[j - 1], domain[j]));
    i.push(interpolate(range[j - 1], range[j]));
  }

  return function (x) {
    var j = bisect(domain, x, 1, k) - 1;
    return i[j](u[j](x));
  };
}

function bisect(a, x, lo, hi) {
  if (arguments.length < 3) {
    lo = 0;
  }

  if (arguments.length < 4) {
    hi = a.length;
  }

  while (lo < hi) {
    var mid = lo + hi >>> 1;

    if (d3_ascending(a[mid], x) > 0) {
      hi = mid;
    } else {
      lo = mid + 1;
    }
  }

  return lo;
}

function d3_ascending(a, b) {
  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
}

function d3_scale_linearRebind(scale, linear) {
  return _BaseUtils["default"].rebind(scale, linear, "range", "rangeRound", "interpolate");
}

function d3_scale_linear(domain, range, interpolate, uninterpolate, minMax) {
  var output, input;

  function rescale() {
    var linear = Math.min(domain.length, range.length) > 2 ? d3_scale_polylinear : d3_scale_bilinear;
    output = linear(domain, range, uninterpolate, interpolate, minMax);
    input = linear(range, domain, uninterpolate, interpolate, minMax);
    return scale;
  }

  function scale(x) {
    return output(x);
  }

  scale.invert = function (y) {
    return input(y);
  };

  scale.domain = function (x) {
    if (!arguments.length) {
      return domain;
    }

    domain = x.map(Number);
    return rescale();
  };

  scale.range = function (x) {
    if (!arguments.length) {
      return range;
    }

    range = x;
    return rescale();
  };

  scale.minMax = function (x) {
    if (!arguments.length) {
      return minMax;
    }

    minMax = x;
    return rescale();
  };

  scale.rangeRound = function (x) {
    return scale.range(x).interpolate(_interpolator["default"].interpolateRound);
  };

  scale.interpolate = function (x) {
    if (!arguments.length) {
      return interpolate;
    }

    interpolate = x;
    return rescale();
  };

  scale.uninterpolate = function (x) {
    if (!arguments.length) {
      return uninterpolate;
    }

    uninterpolate = x;
    return rescale();
  };

  scale.copy = function () {
    return d3_scale_linear(domain, range, interpolate, uninterpolate, minMax);
  };

  return rescale();
}

function d3_scale_log(linear, base, positive, domain) {
  function log(x) {
    return (positive ? Math.log(x < 0 ? 0 : x) : -Math.log(x > 0 ? 0 : -x)) / Math.log(base);
  }

  function pow(x) {
    return positive ? Math.pow(base, x) : -Math.pow(base, -x);
  }

  function scale(x) {
    return linear(log(x));
  }

  scale.invert = function (x) {
    return pow(linear.invert(x));
  };

  scale.domain = function (x) {
    if (!arguments.length) {
      return domain;
    }

    positive = x[0] >= 0;
    linear.domain((domain = x.map(Number)).map(log));
    return scale;
  };

  scale.base = function (_) {
    if (!arguments.length) {
      return base;
    }

    base = +_;
    linear.domain(domain.map(log));
    return scale;
  };

  scale.copy = function () {
    return d3_scale_log(linear.copy(), base, positive, domain);
  };

  return d3_scale_linearRebind(scale, linear);
}

function d3_scale_ordinal(domain, ranger) {
  var index, range, rangeBand;

  function scale(x) {
    return range[((index.get(x) || (ranger.t === "range" ? index.set(x, domain.push(x)) : NaN)) - 1) % range.length];
  }

  function steps(start, step) {
    var range = [],
        length = domain.length;

    for (var i = 0; i < length; i++) {
      range.push(start + step * i);
    }

    return range;
  }

  scale.domain = function (x) {
    if (!arguments.length) {
      return domain;
    }

    domain = [];
    index = new _vMap["default"]();
    var i = -1,
        n = x.length,
        xi;

    while (++i < n) {
      if (!index.has(xi = x[i])) {
        index.set(xi, domain.push(xi));
      }
    }

    return scale[ranger.t].apply(scale, ranger.a);
  };

  scale.range = function (x) {
    if (!arguments.length) {
      return range;
    }

    range = x;
    rangeBand = 0;
    ranger = {
      t: "range",
      a: arguments
    };
    return scale;
  };

  scale.rangePoints = function (x, padding) {
    if (arguments.length < 2) {
      padding = 0;
    }

    var start = x[0],
        stop = x[1],
        step = domain.length < 2 ? (start = (start + stop) / 2, 0) : (stop - start) / (domain.length - 1 + padding);
    range = steps(start + step * padding / 2, step);
    rangeBand = 0;
    ranger = {
      t: "rangePoints",
      a: arguments
    };
    return scale;
  };

  scale.rangeRoundPoints = function (x, padding) {
    if (arguments.length < 2) {
      padding = 0;
    }

    var start = x[0],
        stop = x[1],
        step = domain.length < 2 ? (start = stop = Math.round((start + stop) / 2), 0) : (stop - start) / (domain.length - 1 + padding) | 0;
    range = steps(start + Math.round(step * padding / 2 + (stop - start - (domain.length - 1 + padding) * step) / 2), step);
    rangeBand = 0;
    ranger = {
      t: "rangeRoundPoints",
      a: arguments
    };
    return scale;
  };

  scale.rangeBands = function (x, padding, outerPadding) {
    if (arguments.length < 2) {
      padding = 0;
    }

    if (arguments.length < 3) {
      outerPadding = padding;
    }

    var reverse = x[1] < x[0],
        start = x[reverse - 0],
        stop = x[1 - reverse],
        step = (stop - start) / (domain.length - padding + 2 * outerPadding);
    range = steps(start + step * outerPadding, step);

    if (reverse) {
      range.reverse();
    }

    rangeBand = step * (1 - padding);
    ranger = {
      t: "rangeBands",
      a: arguments
    };
    return scale;
  };

  scale.rangeRoundBands = function (x, padding, outerPadding) {
    if (arguments.length < 2) {
      padding = 0;
    }

    if (arguments.length < 3) {
      outerPadding = padding;
    }

    var reverse = x[1] < x[0],
        start = x[reverse - 0],
        stop = x[1 - reverse],
        step = Math.floor((stop - start) / (domain.length - padding + 2 * outerPadding));
    range = steps(start + Math.round((stop - start - (domain.length - padding) * step) / 2), step);

    if (reverse) {
      range.reverse();
    }

    rangeBand = Math.round(step * (1 - padding));
    ranger = {
      t: "rangeRoundBands",
      a: arguments
    };
    return scale;
  };

  scale.rangeBand = function () {
    return rangeBand;
  };

  scale.rangeExtent = function () {
    return scaleExtent(ranger.a[0]);
  };

  scale.copy = function () {
    return d3_scale_ordinal(domain, ranger);
  };

  return scale.domain(domain);
}

function d3_scale_quantize(x0, x1, range) {
  var kx, i;

  function scale(x) {
    return range[Math.max(0, Math.min(i, Math.floor(kx * (x - x0))))];
  }

  function rescale() {
    kx = range.length / (x1 - x0);
    i = range.length - 1;
    return scale;
  }

  scale.domain = function (x) {
    if (!arguments.length) {
      return [x0, x1];
    }

    x0 = +x[0];
    x1 = +x[x.length - 1];
    return rescale();
  };

  scale.range = function (x) {
    if (!arguments.length) {
      return range;
    }

    range = x;
    return rescale();
  };

  scale.invertExtent = function (y) {
    y = range.indexOf(y);
    y = y < 0 ? NaN : y / kx + x0;
    return [y, y + 1 / kx];
  };

  scale.copy = function () {
    return d3_scale_quantize(x0, x1, range);
  };

  return rescale();
}

function linear() {
  return d3_scale_linear([0, 1], [0, 1], _interpolator["default"].interpolateNumber, _interpolator["default"].uninterpolateNumber);
}

function log() {
  return d3_scale_log(linear().domain([0, 1]), 10, true, [1, 10]);
}

function quantize() {
  return d3_scale_quantize(0, 1, [0, 1]);
}

function ordinal() {
  return d3_scale_ordinal([], {
    t: "range",
    a: [[]]
  });
}

var _default = {
  linear: linear,
  quantize: quantize,
  log: log,
  ordinal: ordinal
};
exports["default"] = _default;

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

var _AxisUtils = __webpack_require__(33);

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _Evented = _interopRequireDefault(__webpack_require__(13));

var _index = __webpack_require__(4);

var _EnvUtils = __webpack_require__(3);

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/5/4.
 * 图表中所有可以显现的内容都作为一个组件
 */
var DEFAULT_LEGEND_REGION = 0.3; // 图例区域自动时占整个图表高度或宽度的比例

var PADDING = 8;

var PADDING_FUN = function () {
  return _BaseUtils["default"].paddingConvertWithScale(PADDING);
};

var Base = _Evented["default"].extend({
  initialize: function (options, componentType, vanchart) {
    this.componentType = componentType;
    this.vanchart = vanchart;
    this.refresh(options);
  },
  refresh: function (options) {
    this.options = options || this.options;
    options = this.options;

    _BaseUtils["default"].extend(this, {
      isFloat: options.floating,
      _floatX: this._getPercentValue(options.x, this.vanchart.width),
      _floatY: this._getPercentValue(options.y, this.vanchart.height)
    });

    this._refresh && this._refresh(options);
  },
  createComponentGroup: function () {
    return this.vanchart.renderer.group().addTo(this.getComponentParentGroup());
  },
  getComponentParentGroup: function () {
    var isMapExport = this.vanchart.isMap() && false;

    return this.isFloat || isMapExport ? this.vanchart.frontGroup : this.vanchart.backGroup;
  },
  useHtmlLabel: function () {
    if (false) {}

    return this.options.useHtml || !(0, _EnvUtils.isSupportSVG)();
  },
  _getLegendType: function (sery) {
    var marker = sery.options.marker;
    var icon = '';

    switch (sery.type) {
      case _Constants["default"].MULTIPIE_CHART:
      case _Constants["default"].PIE_CHART:
        var innerRadius = sery.options.innerRadius;

        if (innerRadius && parseFloat(innerRadius) > 0) {
          return _Constants["default"].DONUT_ICON;
        } else {
          return _Constants["default"].PIE_ICON;
        }

      case _Constants["default"].RADAR_CHART:
        if (sery.options.columnType) {
          return _Constants["default"].NORMAL_ICON;
        }

        break;

      case _Constants["default"].FORCE_BUBBLE_CHART:
      case _Constants["default"].BUBBLE_CHART:
        return _Constants["default"].BUBBLE_ICON;

      case _Constants["default"].TREEMAP_CHART:
        return _Constants["default"].TREEMAP_ICON;

      case _Constants["default"].LINE_MAP:
        return _Constants["default"].NULL_MARKER;

      case _Constants["default"].POINT_MAP:
        return _Constants["default"].ANCHOR_ICON;

      default:
        icon = _Constants["default"].NORMAL_ICON;
    } // 有marker的图例,跟marker的类型一致,跟具体的图表类型无关
    // 优先读取image属性


    if (sery.options.image && (0, _EnvUtils.supportFillFilter)()) {
      // 图片类型的填充系列用图片作为图例标记
      icon = sery.options.image;
    } else if (marker) {
      icon = marker.symbol ? marker.symbol : _Constants["default"].NULL_MARKER;

      if (icon === _Constants["default"].SYMBOL_AUTO) {
        icon = sery.isMarkerDisplayable ? _Constants["default"].CIRCLE : _Constants["default"].NULL_MARKER;
      }

      if (sery.type == _Constants["default"].SCATTER_CHART && !_BaseUtils["default"].isImageMarker(icon)) {
        icon = _Constants["default"].SCATTER_ICON + icon;
      }
    }

    return icon;
  },
  //用百分比表示或者数字表示的值
  _getPercentValue: function (value, total) {
    if (value) {
      value += '';

      if (value.indexOf('%') != -1) {
        value = parseFloat(value) * total / 100;
      }

      return parseFloat(value);
    }

    return 0;
  },
  _setComponentBounds: function (position, usedSize) {
    if (this.isFloat || this.options && this.options.onZero) {
      this._updateFloatBounds(position, usedSize);
    } else {
      this._updateComponentBounds(position, usedSize);
    }
  },
  isHorizontal: function () {
    var position = this.getPosition();
    return position == _Constants["default"].TOP || position == _Constants["default"].BOTTOM;
  },
  isVertical: function () {
    return !this.isHorizontal();
  },
  getPosition: function () {
    return this.options.position;
  },
  _updateFloatBounds: function (position, usedSize) {
    usedSize = Math.ceil(usedSize);
    var originBounds = this.vanchart.bounds;
    var x = this._floatX;
    var y = this._floatY;
    var width = originBounds.x + originBounds.width - x;
    var height = originBounds.y + originBounds.height - y;

    switch (position) {
      case _Constants["default"].TOP:
        this.bounds = {
          x: x,
          y: y,
          width: width,
          height: usedSize
        };
        break;

      case _Constants["default"].BOTTOM:
        this.bounds = {
          x: x,
          y: y,
          width: width,
          height: usedSize
        };
        break;

      case _Constants["default"].LEFT:
        this.bounds = {
          x: x,
          y: y,
          width: usedSize,
          height: height
        };
        break;

      case _Constants["default"].RIGHT_TOP:
      case _Constants["default"].RIGHT_BOTTOM:
      case _Constants["default"].RIGHT:
        this.bounds = {
          x: x,
          y: y,
          width: usedSize,
          height: height
        };
        break;
    }
    /**
     * CHART-1543
     * 坐标轴设置了0值对齐，就有点儿像CSS布局中设置了position为fixed，它就不会挤占绘图区的空间了，
     * 所以如果this对应的坐标轴设置了0值对齐，那么就不去更新vanchart的plotBounds了。
     * 但是有一种情况比较特殊：this对应的坐标轴设置了0值对齐，而且它对齐的坐标轴的刻度值是从0开始计数的，
     * 那么就得在绘图区里显示this对应的坐标轴，就得去更新vanchart的plotBounds。
     */


    if (this.options.onZero) {
      var relyOn = this.getStandardAxis(); //判断relyOnAxis的刻度值是不是从0开始的

      if (relyOn && (0, _AxisUtils.isFromZeroAxis)(relyOn)) {
        this._clipPlotBounds(position, usedSize);
      } else {
        this._clipPlotBoundsWhileFloat(position);
      }
    }
  },

  /**
   * 获取当前值轴设置0值对齐对应的标准值轴。
   * @returns {*}
   */
  getStandardAxis: function () {
    var relyOn = this.componentType === _index.ComponentCst.X_AXIS_COMPONENT ? _index.ComponentCst.Y_AXIS_COMPONENT : _index.ComponentCst.X_AXIS_COMPONENT; //CHART-2130 axisIndex是undefined

    var axisIndex = 0;
    relyOn = this.vanchart.getComponent(relyOn);

    if (this.options.onZero === true) {
      var i = relyOn.getAxisCount();

      while (i--) {
        if (/^standard/.test(relyOn.getAxis(i).alignAxisId)) {
          axisIndex = i;
          break;
        }
      }
    } else {
      axisIndex = this.options.onZero;
    }

    return relyOn.getAxis(axisIndex);
  },

  /**
   * 从原始区域裁减出一块区域以后作为组件区域，并且更新原始区域
   * @param position{string} 位置
   * @para usedSize 占据的大小
   * @private
   */
  _updateComponentBounds: function (position, usedSize) {
    usedSize = Math.ceil(usedSize);
    var originBounds = this.vanchart.bounds;
    var x = originBounds.x;
    var y = originBounds.y;
    var width = originBounds.width;
    var height = originBounds.height;

    switch (position) {
      case _Constants["default"].TOP:
        this.bounds = {
          x: x,
          y: y,
          width: width,
          height: usedSize
        };
        break;

      case _Constants["default"].BOTTOM:
        this.bounds = {
          x: x,
          y: y + height - usedSize,
          width: width,
          height: usedSize
        };
        break;

      case _Constants["default"].LEFT:
        this.bounds = {
          x: x,
          y: y,
          width: usedSize,
          height: height
        };
        break;

      case _Constants["default"].RIGHT_TOP:
      case _Constants["default"].RIGHT_BOTTOM:
      case _Constants["default"].RIGHT:
        this.bounds = {
          x: x + width - usedSize,
          y: y,
          width: usedSize,
          height: height
        };
        break;
    }

    this.vanchart.setPlotBounds(originBounds);

    this._clipPlotBounds(position, usedSize);
  },
  _clipPlotBounds: function (position, usedSize) {
    usedSize = Math.ceil(usedSize);
    var originBounds = this.vanchart.bounds;
    var x = originBounds.x;
    var y = originBounds.y;
    var width = originBounds.width;
    var height = originBounds.height;

    switch (position) {
      case _Constants["default"].TOP:
        originBounds = {
          x: x,
          y: y + usedSize,
          width: width,
          height: height - usedSize
        };
        break;

      case _Constants["default"].BOTTOM:
        originBounds = {
          x: x,
          y: y,
          width: width,
          height: height - usedSize
        };
        break;

      case _Constants["default"].LEFT:
        originBounds = {
          x: x + usedSize,
          y: y,
          width: width - usedSize,
          height: height
        };
        break;

      case _Constants["default"].RIGHT_TOP:
      case _Constants["default"].RIGHT_BOTTOM:
      case _Constants["default"].RIGHT:
        originBounds = {
          x: x,
          y: y,
          width: width - usedSize,
          height: height
        };
        break;
    }

    this.vanchart.setPlotBounds(originBounds);
  },
  // 当坐标轴像CSS中的绝对定位那样不占据绘图区的实际空间的时候，
  // 将vanchart.bounds扩充成最初的大小。
  _clipPlotBoundsWhileFloat: function (position) {
    var originBounds = this.vanchart.bounds;
    var x = originBounds.x;
    var y = originBounds.y;
    var width = originBounds.width;
    var height = originBounds.height;

    switch (position) {
      case _Constants["default"].TOP:
        originBounds = {
          x: x,
          y: y,
          width: width,
          height: height
        };
        break;

      case _Constants["default"].BOTTOM:
        originBounds = {
          x: x,
          y: y,
          width: width,
          height: height - PADDING_FUN()
        };
        break;

      case _Constants["default"].LEFT:
        originBounds = {
          x: x + PADDING_FUN(),
          y: y,
          width: width - PADDING_FUN(),
          height: height
        };
        break;

      case _Constants["default"].RIGHT_TOP:
      case _Constants["default"].RIGHT_BOTTOM:
      case _Constants["default"].RIGHT:
        originBounds = {
          x: x + PADDING_FUN(),
          y: y,
          width: width - PADDING_FUN(),
          height: height
        };
        break;
    }

    this.vanchart.setPlotBounds(originBounds);
  },
  // cannot decide how to clip now
  // clip them in the end
  _recordForPlotBounds: function (position, usedSize) {
    usedSize = Math.ceil(usedSize);
    position === _Constants["default"].RIGHT_TOP && (position = _Constants["default"].RIGHT);
    position === _Constants["default"].RIGHT_BOTTOM && (position = _Constants["default"].RIGHT);
    this.vanchart.clipPool[position] = Math.max(this.vanchart.clipPool[position] || 0, usedSize);
  },
  _getBackgroundColor: function () {
    var opt = this.option;
    var plotColor = typeof opt.plotBackgroundColor == 'string';
    var chartColor = typeof opt.backgroundColor == 'string';
    var color = plotColor ? opt.plotBackgroundColor : chartColor ? opt.backgroundColor : 'white';
    return _ColorUtils["default"].colorToHex(color);
  },
  _maxHeight: function (max) {
    var maxHeight = this.vanchart.height;

    if (max || this.options.maxHeight) {
      return this._getPercentValue(max || this.options.maxHeight, maxHeight);
    }

    return maxHeight;
  },
  _maxLegendHeight: function () {
    return this.options.maxHeight ? this._maxHeight() : this._maxHeight() * DEFAULT_LEGEND_REGION;
  },
  _maxWidth: function (max) {
    var maxWidth = this.vanchart.width;

    if (max || this.options.maxWidth) {
      return this._getPercentValue(max || this.options.maxWidth, maxWidth);
    }

    return maxWidth;
  },
  _maxLegendWidth: function () {
    return this.options.maxWidth ? this._maxWidth() : this._maxWidth() * DEFAULT_LEGEND_REGION;
  },
  _getTickContent: function (tick, formatter) {
    if (!formatter) {
      return tick;
    }

    return _BaseUtils["default"].format(tick, formatter);
  },
  getPlotBounds: function () {
    return this.vanchart.bounds;
  },
  getChartBounds: function () {
    return this.vanchart.getChartBounds();
  },
  getParentDom: function () {
    return this.vanchart.getParentDom();
  },
  getDivParentDom: function () {
    return this.vanchart.getDivParentDom();
  },
  getTooltipComponent: function () {
    return this.vanchart.components.tooltip;
  },
  remove: function () {},
  _bindData: _BaseUtils["default"].bindData,
  invisible: function () {
    return (0, _CoreUtils.hasDefined)(this.options.visible) && this.options.visible === false;
  },
  _innerClip: function (group, bounds) {
    var comp = this,
        vanchart = comp.vanchart,
        renderer = vanchart.renderer;
    bounds = bounds || comp.bounds;

    var innerBounds = _BaseUtils["default"].makeBounds(0, 0, bounds.width, bounds.height);

    if (!this._clip) {
      this._clip = renderer.createClip(innerBounds);
    } else {
      renderer.updateClip(this._clip, innerBounds);
    }

    if (group.type === 'vgroup') {
      var top = 0,
          left = 0,
          right = left + innerBounds.width,
          bottom = top + innerBounds.height;
      group.divG.style({
        'clip': 'rect(' + top + 'px ' + right + 'px ' + bottom + 'px ' + left + 'px)'
      });
      renderer.clip(group.renderG, this._clip);
    } else {
      renderer.clip(group, this._clip);
    }
  }
});

var _default = Base;
exports["default"] = _default;

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

/**
 * Created by eason on 15/6/16.
 */
//从可能的属性列表里读optLocation的属性，前面的优先级高
function queryList(optList, optLocation) {
  if (!optList || !optList.length || !optLocation) {
    return undefined;
  }

  for (var i = 0; i < optList.length; i++) {
    var result = optList[i] && optList[i][optLocation];

    if (result != undefined) {
      return result;
    }
  }
}

function merge(target, source, overwrite) {
  for (var key in source) {
    if (source.hasOwnProperty(key)) {
      var targetProp = target[key]; // typeof null = 'object'

      if (typeof targetProp == 'object' && targetProp != null) {
        //target[key]不为对象时？
        merge(target[key], source[key], overwrite);
      } else if (overwrite || !(key in target) || targetProp == undefined) {
        target[key] = source[key];
      }
    }
  }

  return target;
}

var _default = {
  queryList: queryList,
  merge: merge
};
exports["default"] = _default;

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Class = _interopRequireDefault(__webpack_require__(29));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 16/5/26.
 */
var Evented = _Class["default"].extend({
  /* @method on(type: String, fn: Function, context?: Object): this
   * Adds a listener function (`fn`) to a particular event type of the object. You can optionally specify the context of the listener (object the this keyword will point to). You can also pass several space-separated types (e.g. `'click dblclick'`).
   *
   * @alternative
   * @method on(eventMap: Object): this
   * Adds a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`
   */
  on: function (types, fn, context) {
    // types can be a map of types/handlers
    if (typeof types === 'object') {
      for (var type in types) {
        // we don't process space-separated events here for performance;
        // it's a hot path since Layer uses the on(obj) syntax
        this._on(type, types[type], fn);
      }
    } else {
      // types can be a string of space-separated words
      types = _BaseUtils["default"].splitWords(types);

      for (var i = 0, len = types.length; i < len; i++) {
        this._on(types[i], fn, context);
      }
    }

    return this;
  },

  /* @method off(type: String, fn?: Function, context?: Object): this
   * Removes a previously added listener function. If no function is specified, it will remove all the listeners of that particular event from the object. Note that if you passed a custom context to `on`, you must pass the same context to `off` in order to remove the listener.
   *
   * @alternative
   * @method off(eventMap: Object): this
   * Removes a set of type/listener pairs.
   *
   * @alternative
   * @method off: this
   * Removes all listeners to all events on the object.
   */
  off: function (types, fn, context) {
    if (!types) {
      // clear all listeners if called without arguments
      delete this._events;
    } else if (typeof types === 'object') {
      for (var type in types) {
        this._off(type, types[type], fn);
      }
    } else {
      types = _BaseUtils["default"].splitWords(types);

      for (var i = 0, len = types.length; i < len; i++) {
        this._off(types[i], fn, context);
      }
    }

    return this;
  },
  // attach listener (without syntactic sugar now)
  _on: function (type, fn, context) {
    if (!type || !fn) {
      //跳过未定义的listener
      return;
    }

    this._events = this._events || {};
    /* get/init listeners for type */

    var typeListeners = this._events[type];

    if (!typeListeners) {
      typeListeners = [];
      this._events[type] = typeListeners;
    }

    if (context === this) {
      // Less memory footprint.
      context = undefined;
    }

    var newListener = {
      fn: fn,
      ctx: context
    },
        listeners = typeListeners; // check if fn already there

    for (var i = 0, len = listeners.length; i < len; i++) {
      if (listeners[i].fn === fn && listeners[i].ctx === context) {
        return;
      }
    }

    listeners.push(newListener);
    typeListeners.count++;
  },
  _off: function (type, fn, context) {
    var listeners, i, len;

    if (!this._events) {
      return;
    }

    listeners = this._events[type];

    if (!listeners) {
      return;
    }

    if (!fn) {
      // Set all removed listeners to noop so they are not called if remove happens in fire
      for (i = 0, len = listeners.length; i < len; i++) {
        listeners[i].fn = _BaseUtils["default"].falseFn;
      } // clear all listeners for a type if function isn't specified


      delete this._events[type];
      return;
    }

    if (context === this) {
      context = undefined;
    }

    if (listeners) {
      // find fn and remove it
      for (i = 0, len = listeners.length; i < len; i++) {
        var l = listeners[i];

        if (l.ctx !== context) {
          continue;
        }

        if (l.fn === fn) {
          // set the removed listener to noop so that's not called if remove happens in fire
          l.fn = _BaseUtils["default"].falseFn;

          if (this._firingCount) {
            /* copy array in case events are being fired */
            this._events[type] = listeners = listeners.slice();
          }

          listeners.splice(i, 1);
          return;
        }
      }
    }
  },
  // @method fire(type: String, data?: Object, propagate?: Boolean): this
  // Fires an event of the specified type. You can optionally provide an data
  // object — the first argument of the listener function will contain its
  // properties. The event can optionally be propagated to event parents.
  fire: function (type, data, propagate) {
    if (!this.listens(type, propagate)) {
      return this;
    } //todo 这个extend非常浪费性能，暂时屏蔽掉，应该不会有问题才对


    var event = data;

    if (this._events) {
      var listeners = this._events[type];

      if (listeners) {
        this._firingCount = this._firingCount + 1 || 1;

        for (var i = 0, len = listeners.length; i < len; i++) {
          var l = listeners[i];
          l.fn.call(l.ctx || this, event);
        }

        this._firingCount--;
      }
    }

    if (propagate) {
      // propagate the event to parents (set with addEventParent)
      this._propagateEvent(event);
    }

    return this;
  },
  // @method listens(type: String): Boolean
  // Returns `true` if a particular event type has any listeners attached to it.
  listens: function (type, propagate) {
    var listeners = this._events && this._events[type];

    if (listeners && listeners.length) {
      return true;
    }

    if (propagate) {
      // also check parents for listeners if event propagates
      for (var id in this._eventParents) {
        if (this._eventParents[id].listens(type, propagate)) {
          return true;
        }
      }
    }

    return false;
  },
  // @method once(…): this
  // Behaves as [`on(…)`](#evented-on), except the listener will only get fired once and then removed.
  once: function (types, fn, context) {
    if (typeof types === 'object') {
      for (var type in types) {
        this.once(type, types[type], fn);
      }

      return this;
    }

    var handler = _BaseUtils["default"].bind(function () {
      this.off(types, fn, context).off(types, handler, context);
    }, this); // add a listener that's executed once and removed after that


    return this.on(types, fn, context).on(types, handler, context);
  },
  // @method addEventParent(obj: Evented): this
  // Adds an event parent - an `Evented` that will receive propagated events
  addEventParent: function (obj) {
    this._eventParents = this._eventParents || {};
    this._eventParents[_BaseUtils["default"].stamp(obj)] = obj;
    return this;
  },
  // @method removeEventParent(obj: Evented): this
  // Removes an event parent, so it will stop receiving propagated events
  removeEventParent: function (obj) {
    if (this._eventParents) {
      delete this._eventParents[_BaseUtils["default"].stamp(obj)];
    }

    return this;
  },
  _propagateEvent: function (e) {
    for (var id in this._eventParents) {
      this._eventParents[id].fire(e.srcEvent.type, e, true);
    }
  }
});

var _default = Evented;
exports["default"] = _default;

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _QueryUtils = _interopRequireDefault(__webpack_require__(12));

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _Point = _interopRequireDefault(__webpack_require__(51));

var _Evented = _interopRequireDefault(__webpack_require__(13));

var _BezierEasing = _interopRequireDefault(__webpack_require__(8));

var _PathGenerator = _interopRequireDefault(__webpack_require__(9));

var _component = __webpack_require__(4);

var _dataLabelFormatter = _interopRequireDefault(__webpack_require__(26));

var _renderer = __webpack_require__(24);

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _EnvUtils = __webpack_require__(3);

var _CoreUtils = __webpack_require__(2);

var _VanChartAutoLabel = __webpack_require__(83);

var _richTextMount = __webpack_require__(46);

var _VanChartLabelBorder = __webpack_require__(40);

var _ThemeConfig = __webpack_require__(25);

var _StyleUtils = __webpack_require__(16);

var _AutoFitUtils = __webpack_require__(17);

var _KeyUtils = _interopRequireDefault(__webpack_require__(61));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 16/2/19.
 * 系列的抽象
 */
var OUTER_LINE_WIDTH = 1;
var ANIMATION_TIME = 600;
var EASE_TYPE = 'quad-out';
var DEFAULT_STROKE_WIDTH = 2;
var DEFAULT_LABEL_STROKE = 'rgba(255,255,255,0)';

var Series = _Evented["default"].extend({
  vanChartType: "series",
  initialize: function (options, vanchart, index) {
    this.vanchart = vanchart;
    this.points = [];
    this.refresh(options, index);
  },
  refresh: function (options, index) {
    var vanchart = this.vanchart,
        type = options.type || vanchart.options.chartType,
        plotOptions = vanchart.options.plotOptions,
        queryList = [options, plotOptions[type], plotOptions];
    this.minSize = _QueryUtils["default"].queryList(queryList, 'minSize');
    this.maxSize = _QueryUtils["default"].queryList(queryList, 'maxSize'); //标记点颜色确认需要

    this.originalColor = options.color;
    this.originalMarkerFillColor = options.marker && options.marker.fillColor;
    this.interpolate = this._getSeriesInterpolate(queryList);
    options = this.options = _BaseUtils["default"].createOptions(options, [plotOptions[type], plotOptions]);
    this.type = type; //不能写在prototype里，pointMap，heatMap，areaMap用的一个series

    this.stack = options.stack;
    this.index = index;
    this.className = 'vancharts-series-' + index;
    this.name = _BaseUtils["default"].pick(options.name, _Constants["default"].BLANK_VALUE_PERCENTAGE);
    this.visible = _BaseUtils["default"].pick(options.visible, true); // 理解有误，应该是默认就为true的，不应该使用之前的visible

    this.state = this.visible ? _Constants["default"].STATE_SHOW : _Constants["default"].STATE_DROPPED;
    this.isMarkerDisplayable = true; // 默认标记点是可见的

    var hexAlpha;

    if (!this.isSeriesAccumulated() && this.type !== _Constants["default"].STRUCTURE_CHART) {
      var color = this.options.color || vanchart.getDefaultSeriesColor(this.name),
          opacity = options.opacity,
          isSerHasColor = (0, _CoreUtils.hasDefined)(options.color),
          isSerHasFillColor = (0, _CoreUtils.hasDefined)(options.fillColor) && options.fillColor != true;
      hexAlpha = _ColorUtils["default"].getStandardColorAndOpacity(color, opacity);
      color = hexAlpha.hex;
      opacity = this.isGradualStyle() ? this._getGradualStyleOpacity() : hexAlpha.alpha;
      var fillColor = this.options.fillColor;
      fillColor = fillColor === true ? color : fillColor;
      var fillColorOpacity = +options.fillColorOpacity;
      fillColorOpacity = isNaN(fillColorOpacity) ? this._getDefaultFillColorOpacity() : fillColorOpacity;

      if (isSerHasColor && !isSerHasFillColor) {
        fillColorOpacity *= hexAlpha.oriAlpha;
      }

      hexAlpha = _ColorUtils["default"].getStandardColorAndOpacity(fillColor, fillColorOpacity);
      fillColor = hexAlpha.hex;
      fillColorOpacity = hexAlpha.alpha; // shine:clone原因：
      // 1.散点图标记点类型为自动时，各个系列循环不同标记点，需要clone一份，再改symbol。
      // 2.marker的color和alpha都会改变

      var marker = options.marker = _BaseUtils["default"].clone(options.marker);

      if ((0, _CoreUtils.hasDefined)(marker)) {
        var colorAlpha = this._getMarkerColorAlpha();

        marker.fillColor = colorAlpha.markerColor;
        marker.fillColorOpacity = colorAlpha.markerOpacity;

        if (this.type === _Constants["default"].SCATTER_CHART && marker.symbol === _Constants["default"].SYMBOL_AUTO) {
          options.marker.symbol = _BaseUtils["default"].getDefaultMarkerSymbol(index);
        }
      }

      this.color = color;
      this.opacity = opacity;
      this.fillColor = fillColor;
      this.fillColorOpacity = fillColorOpacity;
      this.marker = marker;
    }

    if ((0, _CoreUtils.hasDefined)(this.options.startAngle)) {
      var startAngle = this.options.startAngle,
          endAngle = this.options.endAngle;

      if (startAngle > endAngle) {
        startAngle -= 360;
      } // CHART-1207
      // if-else的用法在解决startAngle=360， endAngle=0的情况出现一些问题
      // 现在把if-else改成两个if


      if (startAngle === endAngle) {
        endAngle = startAngle + 360;
      }

      this.startAngle = _BaseUtils["default"].toRadian(startAngle);
      this.endAngle = _BaseUtils["default"].toRadian(endAngle);
    }

    if (type === _Constants["default"].PIE_CHART) {
      this.category = this.name;
    } // bind Axis


    this._bindAxis();

    var data = this._loadData ? this._loadData(options.data) : options.data || []; // so dirty...

    if (!this.isTreeSeries()) {
      this._dealData(data);
    }

    return this;
  },
  _getGradualStyleOpacity: function () {
    return (0, _CoreUtils.hasDefined)(this.options.opacity) ? this.options.opacity : 1;
  },
  isGradualStyle: function () {
    return this.options.gradualStyle === _Constants["default"].STYLE_CUSTOM;
  },

  /**
   * 处理系列下的数据点
   * @param data
   * @private
   */
  _dealData: function (data) {
    var newPoints = [],
        series = this,
        pointsMap = {};
    var vanchart = this.vanchart,
        type = this.type;
    this.points.forEach(function (point) {
      // todo
      // _getPointKey: point here, data[i] below?
      var key = series._getPointKey(point);

      pointsMap[key] = pointsMap[key] || [];
      pointsMap[key].push(point);
    });
    var i, len, key, pointArray;

    for (i = 0, len = data.length; i < len; i++) {
      key = series._getPointKey(data[i]), pointArray = pointsMap[key];
      var point = null;

      if (pointArray) {
        for (var j = 0, count = pointArray.length; j < count; j++) {
          if (point = pointArray[j]) {
            pointArray[j] = null;
            break;
          }
        }

        if (point) {
          //clear states
          point._lastValue = point.options[series.getTargetKey()];
          point._lastPercent = point.percentage;
          point._lastArrivalRate = point.arrivalRate;
          point.childSeries = null;
          point.geo = null; //set new data

          point.refresh(data[i]);
        }
      }

      if (!point) {
        point = new _Point["default"](data[i], this);
      }

      newPoints.push(point);
    }

    for (key in pointsMap) {
      pointsMap[key] && pointsMap[key].forEach(function (p) {
        vanchart.removePointGraphics(p, type);
      });
    }

    if (this.options.sort) {
      //漏斗图的数据是有序的
      //去掉filternullvalue原因：fr那边过滤条件可以设置显示系列为空数据，图例里面得有
      newPoints = newPoints.sort(function (pointA, pointB) {
        return Math.abs(pointB.getTargetValue()) - Math.abs(pointA.getTargetValue());
      });
    }

    var points = this.points = newPoints; // @CHART-1554  accumulatedSeries下的point.points应该在这里设置

    if (this.isSeriesAccumulated()) {
      for (i = -1, len = points.length; ++i < len;) {
        points[i].points = points;
      }
    }
  },
  _getPointKey: function (point) {
    // 系列基于多分类轴时，使用字符串格式的categoryArray
    if (this.isMultiCategoryAxisBased()) {
      return _BaseUtils["default"].encodeCategoryArray(point.categoryArray);
    }

    return point.x;
  },

  /**
   * @Cmen:判断系列是否基于多分类轴:
   * @returns {boolean}
   */
  isMultiCategoryAxisBased: function () {
    var axis = this[this.getBaseAxisType()]; //当前系列对应的基础轴

    return axis && axis.isMultiCateAxis && axis.isMultiCateAxis();
  },
  //不在options的原因：radar和columnRadar不同
  _getDefaultFillColorOpacity: function () {
    return 1;
  },
  getStackAxis: function () {
    return this[this.getTargetKey() + 'Axis'];
  },
  isNullValue: function (point) {
    var originValue = point.options[point.series.getTargetKey()];
    return originValue == '-' || (0, _CoreUtils.hasNotDefined)(originValue);
  },
  _getMarkerColorAlpha: function () {
    var vanchart = this.vanchart,
        options = this.options;
    var plotOptions = vanchart.options.plotOptions,
        _options = plotOptions[this.type];
    var plotOptionsMarker = _options && _options.marker || plotOptions.marker;
    var opacity = options.opacity,
        seriesMarker = options.marker;

    var _markerColor = seriesMarker && seriesMarker.fillColor || this.options.color || plotOptionsMarker && plotOptionsMarker.fillColor || vanchart.getDefaultSeriesColor(this.name);

    var _markerOpacity = opacity;

    if ((0, _CoreUtils.hasDefined)(_markerColor)) {
      var hexAlpha = _ColorUtils["default"].getStandardColorAndOpacity(_markerColor, opacity);

      _markerColor = hexAlpha.hex;
      _markerOpacity = hexAlpha.alpha;
    }

    return {
      markerColor: _markerColor,
      markerOpacity: _markerOpacity
    };
  },
  _bindAxis: function () {
    var series = this,
        seriesOptions = series.options,
        vanchart = series.vanchart;

    series._getAxisTypes().forEach(function (axisType) {
      if (vanchart[axisType]) {
        var targetAxis = vanchart[axisType](seriesOptions[axisType]);

        if (targetAxis) {
          targetAxis.series.push(series);
          series[axisType] = targetAxis;
        }
      }
    });
  },
  supportTooltipShared: function () {
    return this.xAxis || this.yAxis || this.angleAxis;
  },
  _getAxisTypes: function () {
    return ['xAxis', 'yAxis'];
  },
  //用来计算百分比的指标的名字,相当于value的含义
  getTargetKey: function () {
    return 'y';
  },
  //图形坐在的那个坐标轴的key
  getBaseAxisType: function () {
    return 'xAxis';
  },
  _calculateAutoLabelPos: function (point, pos, isVertical, manager, rightBottom, hide) {
    if (hide === void 0) {
      hide = false;
    }

    var step = 3; // 自动调整的时候每次3px
    // 先测试一下从上往下的效果

    var labelDim = point.labelDim,
        plotBounds = this.vanchart.bounds;
    var testPos;

    if (isVertical) {
      var startY, endY;

      if ((0, _CoreUtils.hasDefined)(rightBottom)) {
        if (rightBottom) {
          // 往下
          startY = Math.max(0, pos.y);
          endY = plotBounds.height - labelDim.height;
          testPos = (0, _VanChartAutoLabel.verticalPosFix)(startY, endY, step, labelDim, pos, manager);
        } else {
          endY = 0;
          startY = Math.min(pos.y, plotBounds.height - labelDim.height);
          testPos = (0, _VanChartAutoLabel.verticalPosFix)(startY, endY, -step, labelDim, pos, manager);
        }
      } else {
        // 往下
        startY = Math.max(0, pos.y);
        endY = plotBounds.height - labelDim.height;
        testPos = (0, _VanChartAutoLabel.verticalPosFix)(startY, endY, step, labelDim, pos, manager); // 往上

        if (!testPos) {
          endY = 0;
          startY = Math.min(pos.y, plotBounds.height - labelDim.height);
          testPos = (0, _VanChartAutoLabel.verticalPosFix)(startY, endY, -step, labelDim, pos, manager);
        }
      }
    } else {
      var startX, endX;

      if ((0, _CoreUtils.hasDefined)(rightBottom)) {
        if (rightBottom) {
          // 往右
          startX = Math.max(0, pos.x);
          endX = plotBounds.width - labelDim.width;
          testPos = (0, _VanChartAutoLabel.horizontalPosFix)(startX, endX, step, labelDim, pos, manager);
        } else {
          endX = 0;
          startX = Math.min(pos.x, plotBounds.width - labelDim.width);
          testPos = (0, _VanChartAutoLabel.horizontalPosFix)(startX, endX, -step, labelDim, pos, manager);
        }
      } else {
        // 往右
        startX = Math.max(0, pos.x);
        endX = plotBounds.width - labelDim.width;
        testPos = (0, _VanChartAutoLabel.horizontalPosFix)(startX, endX, step, labelDim, pos, manager); // 往左

        if (!testPos) {
          endX = 0;
          startX = Math.min(pos.x, plotBounds.width - labelDim.width);
          testPos = (0, _VanChartAutoLabel.horizontalPosFix)(startX, endX, -step, labelDim, pos, manager);
        }
      }
    }

    return testPos || (hide ? {} : pos);
  },
  _getArcPoint: function (r, radian) {
    return [this._dealWithFloat(r * Math.sin(radian)), this._dealWithFloat(-r * Math.cos(radian))];
  },
  _getNormalTrendLineXYValues: function (sery) {
    var xValues = [];
    var yValues = [];
    var key = this.vanchart.isInverted() ? 'posY' : 'posX';
    var location = this.vanchart.isInverted() ? _Constants["default"].LEFT : _Constants["default"].BOTTOM;
    sery.points.sort(function (p1, p2) {
      return p1[key] - p2[key];
    });
    sery.points.forEach(function (point) {
      if (!point.isNull) {
        xValues.push(point.posX);
        yValues.push(point.posY);
      }
    });
    return [xValues, yValues, location, sery.xAxis && sery.xAxis.isAxisReversed()];
  },
  _getSeriesInterpolate: function (queryList) {
    var step = _QueryUtils["default"].queryList(queryList, 'step');

    var curve = _QueryUtils["default"].queryList(queryList, 'curve');

    var options = queryList[0];
    var interpolate = 'linear';

    if (options.step || step && !options.curve) {
      interpolate = 'step-after';
    } else if (options.curve || curve && !options.step) {
      interpolate = 'cardinal';
    }

    return interpolate;
  },
  _getAngle: function (current, center) {
    center = center || {
      x: 0,
      y: 0
    };
    return Math.atan2(current.y - center.y, current.x - center.x) / (Math.PI / 180);
  },
  _getBackgroundColor: function () {
    var opt = this.vanchart.options;
    var plotColor = typeof opt.plotBackgroundColor === 'string';
    var chartColor = typeof opt.backgroundColor === 'string';
    var color = plotColor ? opt.plotBackgroundColor : chartColor ? opt.backgroundColor : 'white';
    return _ColorUtils["default"].colorToHex(color);
  },
  _getBackgroundColorWithAlpha: function () {
    var opt = this.vanchart.options;

    if (typeof opt.plotBackgroundColor === 'string') {
      return opt.plotBackgroundColor;
    }

    if (typeof opt.backgroundColor === 'string') {
      return opt.backgroundColor;
    }
  },
  getSeryTotalValue: function () {
    var total = 0;
    this.points.forEach(function (point) {
      total += point.getTargetValue();
    });
    return total;
  },
  getLegendKey: function (point) {
    return this.isSeriesAccumulated() ? point.name : this.name;
  },
  calculateLabelInfo: function (point) {
    (0, _dataLabelFormatter["default"])(point);
  },
  _getPercentValue: function (value, total) {
    if (value) {
      value += '';

      if (value.indexOf('%') !== -1) {
        value = parseFloat(value) * total / 100;
      }

      return parseFloat(value);
    }

    return 0;
  },
  isSupportLegendHighlight: function () {
    return true;
  },
  isSeriesAccumulated: function () {
    return false;
  },
  isTreeSeries: function () {
    return false;
  },

  /**
   * 增加新的point
   * @param {[type]} options [description]
   * @param {[type]} redraw  [description]
   */
  addPoint: function (options, redraw) {
    var data = this._getOriginSerData();

    var vanchart = this.vanchart; // todo 多分类轴下等情况下，需要重新计算dataDomain

    data.push(options);
    redraw && vanchart.update();
  },

  /**
   * 移除单个point
   * @param  {[type]} index  [description]
   * @param  {[type]} redraw [description]
   * @return {[type]}        [description]
   */
  removePoint: function (index, redraw) {
    if (index < 0) {
      return;
    }

    var series = this,
        vanchart = this.vanchart,
        data = this._getOriginSerData();

    var serIndex = vanchart.series.indexOf(series);
    data.splice(index, 1);
    series.options.data.splice(index, 1);

    if (vanchart._removeAllAndHasNoAdd(series.options, serIndex)) {
      series.remove();
      vanchart.series.splice(serIndex, 1);
      vanchart.options.series.splice(serIndex, 1);
    }

    redraw && vanchart.update();
  },

  /**
   * 更新单个point的数据信息
   * @param  {[type]} index  [description]
   * @param  {[type]} option [description]
   * @param  {[type]} redraw [description]
   * @return {[type]}        [description]
   */
  updatePoint: function (index, option, redraw) {
    if (index < 0) {
      return;
    }

    var vanchart = this.vanchart,
        data = this._getOriginSerData();

    data[index] = option;
    redraw && vanchart.update();
  },

  /**
   * 更新系列配置项
   * @param {Object} serData
   * */
  updateSeries: function (serData) {
    var series = this,
        vanchart = this.vanchart,
        originSeriesData = vanchart.options.series;
    var serIndex = vanchart.series.indexOf(series);
    serData = _BaseUtils["default"].clone(serData);
    serData.data = originSeriesData[serIndex].data;
    originSeriesData[serIndex] = serData;
  },

  /**
   * 计算数据点的option在对应的vanchart.series中具体series中的索引
   * 更具该索引，便可以更新和删除该数据点
   * @param option
   * @returns {number}
   */
  calculatePointIndex: function (option) {
    var series = this,
        vanchart = this.vanchart,
        pos = -1,
        index = 0;

    var data = this._getOriginSerData();

    var clone = _BaseUtils["default"].clone; // 计算坐标点

    var toLnglatPoint = function (option) {
      if (option.lnglat) {
        return option;
      }

      var geo = vanchart.getCurrentGeo();
      var features = geo.getFeaturesByName(option.name, series.type);
      var lnglat = geo.getDataPointLngLat({
        options: option,
        series: series
      }, features && features[0]);
      var newOption = clone(option); // 只用作判断依据，不修改原始数据

      newOption.lnglat = lnglat;
      return lnglat && newOption;
    };

    var isLineMap = series.type === _Constants["default"].LINE_MAP; // 这种坐标数据中不存在name的直接返回，不继续算了

    if (isLineMap && (!toLnglatPoint(option.from) || !toLnglatPoint(option.to))) {
      return -1;
    } // 重新构建一个新的option，用于_getPointKey


    var reBuildOption = function (option) {
      if (isLineMap) {
        var newOption = clone(option);
        newOption.from = toLnglatPoint(option.from);
        newOption.to = toLnglatPoint(option.to);
        return newOption.from && newOption.to && newOption;
      }

      return option;
    };

    var op1, op2;

    while (index < data.length) {
      op1 = reBuildOption(option);
      op2 = reBuildOption(data[index]);

      if (!op1 || !op2) {
        index++; // 这里不应该跳出，而是继续下一个while

        continue;
      }

      var key = series._getPointKey(op1);

      var pointKey = series._getPointKey(op2);

      if (key === pointKey) {
        pos = index;
        break;
      }

      index++;
    }

    return pos;
  },

  /**
   * @Cmen:监控刷新时，有个比较尴尬的问题：
   * 现在的图表绘制，都是直接使用初始的OriginOption，直接使用，这就导致第一次绘制结束，OriginOption里面的series已经被修改(扩展)了，
   * 而监控刷新时那些未发生值变化的数据，却依旧使用OriginOption.series，而此时的这个series已经被扩展了一些方法和属性，
   * 这就导致某些属性诸如markerFillColor等不能被更新,因此在监控刷新时，应该修改原始数据，
   * 而绘图的时候，使用原始数据的拷贝，不对原始的series进行属性和方法扩展
   */
  _getOriginSerData: function () {
    var series = this,
        vanchart = this.vanchart,
        originSeriesData = vanchart.options.series;
    var serIndex = vanchart.series.indexOf(series);
    return serIndex < 0 ? [] : originSeriesData[serIndex].data;
  }
}); //view related


Series.include({
  getClosestPoint: function () {
    return null;
  },
  getDefaultTooltipFormatter: function () {
    return {
      categoryFormat: "function(){return window.FR ? FR.contentFormat(arguments[0], '') : arguments[0]}",
      changedPercentFormat: "function(){return window.FR ? FR.contentFormat(arguments[0], '#.##%') : arguments[0]}",
      changedValueFormat: "function(){return window.FR ? FR.contentFormat(arguments[0], '') : arguments[0]}",
      identifier: "{CATEGORY}{SERIES}{VALUE}",
      percentFormat: "function(){return window.FR ? FR.contentFormat(arguments[0], '#.##%') : arguments[0]}",
      seriesFormat: "function(){return window.FR ? FR.contentFormat(arguments[0], '') : arguments[0]}",
      valueFormat: "function(){return window.FR ? FR.contentFormat(arguments[0], '') : arguments[0]}"
    };
  },
  isToolTipFollow: function (point) {
    return !this.vanchart.isMobile() && point.options.tooltip.follow;
  },
  getTooltipPos: function (point, divDim, event) {
    var leftTopPos;

    if (this.isToolTipFollow(point)) {
      var pos = event.containerPoint;
      leftTopPos = [pos.x + 10, pos.y + 10];
    } else {
      leftTopPos = this._getFixedPos(point, divDim);
    }

    if (!leftTopPos) {
      return;
    } //调整位置


    var chartBounds = this.vanchart.bounds;
    var top = chartBounds.y,
        left = chartBounds.x;
    var bottom = chartBounds.y + chartBounds.height;
    var right = chartBounds.x + chartBounds.width;
    var x = leftTopPos[0],
        y = leftTopPos[1];

    if (x < left) {
      x += left - x;
    } else if (x + divDim.width > right) {
      x -= x + divDim.width - right;
    }

    if (y < top) {
      y += top - y;
    } else if (y + divDim.height > bottom) {
      y -= y + divDim.height - bottom;
    }

    return [x, y];
  },
  //统一处理渐变色,图片填充,阴影等情况,默认就返回颜色
  getFillFilter: function (color) {
    return color;
  },
  filterRender: function () {
    this.useCanvas() ? this._canvasRender() : this._svgFilterRender();
  },
  render: function () {
    this.useCanvas() ? this._canvasRender() : this._svgRender();
  },
  useCanvas: _BaseUtils["default"].falseFn,
  _createGroup: function (renderer, vanchart) {
    return renderer.group().addTo(vanchart.clipSeriesGroup);
  },
  _svgRender: function () {
    //todo 这个临时变量应该可以规避
    this.initialAnimationMoving = !this.group;
    this.drawPolarAxis && this.drawPolarAxis();
    var vanchart = this.vanchart,
        renderer = vanchart.renderer;

    if (!this.group) {
      this.group = this._createGroup(renderer, vanchart).attr('transform', _BaseUtils["default"].makeTranslate(this._getTranslate())); // MOBILE-10912

      if (!vanchart.isMobile()) {
        this.group.style('cursor', this._pointerStyle());
      }
    }

    this.group.attr('class', this.className + ' ' + this.type); //对于可以自定义位置的如雷达图,仪表盘这边的translate不是绘图取

    if (this.type === _Constants["default"].GAUGE_CHART) {
      this.group.animate({
        duration: ANIMATION_TIME,
        ease: EASE_TYPE,
        attr: {
          transform: _BaseUtils["default"].makeTranslate(this._getTranslate())
        }
      });
    } else {
      this.group.attr('transform', _BaseUtils["default"].makeTranslate(this._getTranslate()));
    }

    this.drawSeries && this.drawSeries();
    this.drawPoints();
  },
  _svgFilterRender: function () {
    var series = this; //todo：@eason 拖拽范围图例filter一部分点后，缩放的时候visible==false的点会被remove掉

    series.getDataToDraw().forEach(function (point) {
      if (point.isVisible()) {
        point.graphic && point.graphic.style({
          'display': 'inline'
        });

        if (!point.textGraphic) {
          series._createTextGraphic(point);
        }

        if (!point.effectGraphic) {
          series.drawPointEffect(point);
        }
      } else {
        point.graphic && point.graphic.style({
          'display': 'none'
        });
        point.textGraphic && point.textGraphic.remove();
        point.textGraphic = null;
        series.clearPointEffect(point);
      }
    });
  },
  _canvasRender: function () {
    if (!this._canvas) {
      this._canvas = (0, _renderer.createCanvasRenderer)(this.vanchart.dom, this.vanchart);

      this._canvas.onAdd();
    }

    this._canvas.clearAll();

    this._canvas.addSeries(this);
  },
  _pointerStyle: function () {
    // point为null时，设计器导出时是没有hyperlink和onClick属性的，这里过滤一下
    var validPoints = this.points.filter(function (p) {
      return !p.isNull;
    });
    return validPoints[0] && (validPoints[0].options.onClick || this.vanchart.options.hyperLink) ? 'pointer' : '';
  },
  getDataToDraw: function () {
    return this.points;
  },
  getTextDataToDraw: function () {
    return this.getDataToDraw();
  },
  // updatePointGraphic:function(point){
  updatePointGraphic: function () {},
  // 标记点刷新直接删除重新画会导致移动端滚动至边缘后无法停止滚动
  _updateMarkerPointGraphic: function (point) {
    var group = point.graphic,
        options = point.options;

    if (!group) {
      return;
    }

    var marker = options.marker;
    var markerType = marker && marker.symbol;

    if (_BaseUtils["default"].isImageMarker(markerType)) {
      group.markerPath && group.markerPath.remove();
      group.markerPath = null;
    } else {
      group.image && group.image.remove();
      group.image = null;
    }
  },
  // 现在的处理方式是全部重新写一遍
  drawPoints: function () {
    var series = this,
        vanchart = series.vanchart;

    var graphicGroup = this._getPointGraphicGroup();

    graphicGroup && vanchart.registerInteractiveTarget(this, graphicGroup);

    if (this.initialAnimationMoving && this.initialAnimation) {
      this.initialAnimation();
    }

    var delay = this._calculateAnimationDelay();

    var points = series.getDataToDraw();

    for (var i = 0, len = points.length; i < len; i++) {
      series.drawPoint(points[i], delay);
    }
  },
  _drawEffectPoints: function () {
    var series = this;
    series.getTextDataToDraw().forEach(function (point) {
      series.drawPointEffect(point);
    });
  },
  drawPointEffect: function (point) {
    var series = point.series;
    series.clearPointEffect(point);
    var time = point.getEffectTime();

    if (time) {
      //shine:0秒没有effect动画
      series.effectAnimation(point);
      point.effectInterval = _BaseUtils["default"].setInterval(function () {
        series.effectAnimation(point);
      }, time);
    }
  },
  clearPointEffect: function (point) {
    point.clearPointEffect();
  },
  effectAnimation: function () {},
  _drawUpdatePoints: function (point, delay) {
    this._updatePointGraphicStyle(point); // 更新颜色
    // 大量数据情形下缩放，直接更新attr，不加动画了


    if (this.vanchart.isZoomingWithLargeModel()) {
      point.graphic.attr(this.getPointUpdateAnimationAttr(point, delay).attr);
    } else {
      point.graphic.animate(this.getPointUpdateAnimationAttr(point, delay));
    }

    this.vanchart.registerInteractiveTarget(point, point.graphic); // 更新映射关系
  },
  _drawEnterPoints: function (point) {
    var series = this,
        group = series._getPointGraphicGroup();

    var graphic = point.graphic = this._createPointGraphic(point);

    series._updatePointGraphicStyle(point);

    var reShow = series.reShowPoint(point);
    var attrFun = reShow && series.getPointReShowAttr ? series.getPointReShowAttr : series.getPointInitAttr;
    var styleFun = reShow && series.getPointReShowStyle ? series.getPointReShowStyle : series.getPointInitStyle;
    var animateFun = reShow && series.getPointReShowAnimationAttr ? series.getPointReShowAnimationAttr : series.getPointInitAnimationAttr; // todo 折线图这里会导致标记点在折线的前面

    point.hasEffect() || point.isPieZeroPoint() ? graphic.addTo(group) : graphic.addToBack(group);
    graphic.attr(attrFun ? attrFun.call(series, point) : {}).style(styleFun ? styleFun.call(series, point) : {}).animate(animateFun ? animateFun.call(series, point) : {});
    series.vanchart.registerInteractiveTarget(point, graphic);
  },
  _drawExitPoints: function (point) {
    var series = point.series;

    if (series.getPointDropAnimationAttr) {
      point.graphic.animate(series.getPointDropAnimationAttr(point)).remove();
    } else {
      point.graphic.remove();
    }
  },
  // todo
  // 范围图例导致复杂判断
  // TreeSeries 目前覆盖了这个方法
  // 理清逻辑 或者 加测试
  drawPoint: function (point, delay) {
    delay = delay || 0;
    var shouldBeVisible = point.isVisible();
    var currentVisibleState = point.graphic && point.graphic.isVisible(); // 清除闪烁动画, 绘制之后再重新绘制

    this.clearPointEffect(point);

    if (shouldBeVisible === currentVisibleState) {
      point.graphic && this._drawUpdatePoints(point, delay);
    } else if (shouldBeVisible && !currentVisibleState) {
      if (point.graphic && !point.graphic.removed()) {
        point.graphic.style('display', 'inline');

        this._drawUpdatePoints(point, delay);
      } else {
        this._drawEnterPoints(point);
      }
    } else if (!shouldBeVisible && currentVisibleState) {
      this._drawExitPoints(point);
    }
  },
  _getEffectTime: function (point) {
    // point.options.effect=undefined依然会走到这边的场景：
    // 一个没有闪烁动画的点刷新有闪烁动画的点。options更新之后，_drawEffectPoints(clear && create effect)之前，effectInterval还没被clear
    return (0, _CoreUtils.hasNotDefined)(point.options.effect) || isNaN(point.options.effect.period) ? point.series.getDefaultEffectTime() : point.options.effect.period;
  },
  _getPointEffectGroup: function (point) {
    var series = point.series,
        renderer = series.vanchart.renderer;
    return point.effectGraphic = point.effectGraphic || renderer.group().addTo(series._getPointGraphicGroup()).style('pointer-events', 'none');
  },
  _createPointGraphic: function (point) {
    var graphicKey = this.getPointGraphicKey(point),
        renderer = this.vanchart.renderer;
    return renderer[graphicKey]();
  },
  getStyle: function (p) {
    var options = p.options,
        series = p.series;
    var borderColor = p.getPointBorderColor(p.borderColor);
    return {
      // 现在的fill没有动画
      'fill': series.getFillFilter(p.color, p),
      'fill-opacity': options.image ? 1 : p.opacity,
      'stroke': borderColor,
      'stroke-opacity': p.borderOpacity,
      'stroke-width': options.borderWidth,
      'filter': 'none'
    };
  },
  _updateHighLightOpacity: function (point, style) {
    var target = this.vanchart.highlightTarget;

    if (target != null && this.isSupportLegendHighlight()) {
      // 理论上系列值为""也可以触发高亮
      var key = this.getLegendKey(point);
      var opacity = key == target || point._rangeItem == target ? 1 : _Constants["default"].HOVER_OPACITY;
      style['fill-opacity'] = style['stroke-opacity'] = opacity;
    }
  },
  _getDynamicStyle: function (point) {
    var style = this.getStyle(point);

    this._updateHighLightOpacity(point, style);

    style['pointer-events'] = "auto";
    return style;
  },
  _updatePointGraphicStyle: function (point, style) {
    style = style || point.series._getDynamicStyle(point);
    point.graphic && point.graphic.style(style);
  },
  _getPointLabelStyle: function (point, type) {
    var style;

    switch (type) {
      case 'label':
        style = {
          'fill-opacity': point.labelOpacity()
        };
        break;

      case 'labelBorder':
        style = {
          'stroke-opacity': point.labelBorderOpacity,
          'fill-opacity': 1
        };
        break;

      case 'leadLine':
        style = {
          'stroke-opacity': point.autoLabelOpacity()
        };
        break;
    }

    this._updateHighLightOpacity(point, style, type);

    if (type === 'label' && point.textGraphic && point.textGraphic.type === 'div') {
      style['opacity'] = style['fill-opacity'];
    }

    return style;
  },
  _updatePointLabelStyle: function (point) {
    var labelStyle = this._getPointLabelStyle(point, 'label'),
        labelBorderStyle = this._getPointLabelStyle(point, 'labelBorder'),
        leadLineStyle = this._getPointLabelStyle(point, 'leadLine');

    point.leadLine && point.leadLine.style(leadLineStyle);
    point.textGraphic && point.textGraphic.style(labelStyle);
    point.textBorderPath && point.textBorderPath.style(labelBorderStyle);
  },
  _createMarker: function (marker, group) {
    var markerType = marker.symbol,
        renderer = this.vanchart.renderer;
    group = group || renderer.group();

    if (_BaseUtils["default"].isImageMarker(markerType)) {
      var w = marker.width,
          h = marker.height;
      group.image = renderer.image({
        'preserveAspectRatio': 'none',
        'x': -w / 2,
        'y': -h / 2,
        'width': w,
        'height': h
      }).imageContent(markerType).addTo(group);
    } else {
      group.markerPath = renderer.path().addTo(group);
    }

    return group;
  },
  _updateImageMarker: function (marker, group) {
    var renderer = this.vanchart.renderer;
    var width = marker.width,
        height = marker.height,
        markerType = marker.symbol;
    group.image = group.image || renderer.image({
      'preserveAspectRatio': 'none'
    }).addTo(group);
    group.image.imageContent(markerType).attr({
      x: -width / 2,
      y: -height / 2,
      width: width,
      height: height
    });
  },
  _updateMarker: function (point, group, marker) {
    group = group || point.graphic;
    marker = marker || point.options.marker;
    var markerType = marker.symbol,
        vanchart = this.vanchart,
        backgroundColor = this._getBackgroundColorWithAlpha() || (0, _ThemeConfig.getThemeAutoValue)(_Constants["default"].AUTO, 'markerStrokeColor', vanchart.isDarkTheme());

    if (_BaseUtils["default"].isImageMarker(markerType)) {
      this._updateImageMarker(marker, group);

      return;
    } // CHART-16207 自定义标记点图片遗留，如果不满足要删掉image dom


    group.image && group.image.remove();
    var opacity = marker.fillColorOpacity;
    var target = this.vanchart.highlightTarget;

    if ((0, _CoreUtils.hasDefined)(target)) {
      var key = this.getLegendKey(point);
      opacity = key == target || point._rangeItem == target ? 1 : _Constants["default"].HOVER_OPACITY;
    }

    var isLine = this.type === _Constants["default"].LINE_CHART,
        isHollow = this._isHollowMarker(markerType),
        fillColor = marker.fillColor;

    var radius = this._getMarkerRadius(point, marker, false);

    var strokeWidth = radius > 0 ? this._defaultStrokeWidth(point.series.vanchart) : 0;
    group.markerPath = group.markerPath || this.vanchart.renderer.path().addTo(group);

    if (isHollow) {
      group.markerPath.attr({
        'd': _PathGenerator["default"].getMarkerPath(markerType, radius)
      }).style({
        'stroke': fillColor,
        'stroke-width': strokeWidth,
        'stroke-opacity': opacity,
        'fill': backgroundColor,
        'fill-opacity': opacity
      });
    } else if (isLine) {
      // 折线图的实心标记点有2px颜色为背景色的外描边
      group.markerPath.attr({
        'd': _PathGenerator["default"].getMarkerPath(markerType, radius)
      }).style({
        'fill': fillColor,
        'fill-opacity': opacity,
        'stroke': backgroundColor,
        'stroke-width': strokeWidth,
        'stroke-opacity': opacity
      });
    } else {
      group.markerPath.attr({
        'd': _PathGenerator["default"].getMarkerPath(markerType, radius)
      }).style({
        'fill': fillColor,
        'fill-opacity': opacity,
        'stroke': 'none',
        'stroke-width': 0
      });
    }
  },
  _getMarkerRadius: function (point, marker, isChosen) {
    var markerType = marker.symbol;
    var isMarkerDisplayable = point.series.isMarkerDisplayable;

    var isHollow = this._isHollowMarker(markerType);

    var isLine = this.type === _Constants["default"].LINE_CHART;
    var radius = (0, _StyleUtils.getMarkerRadius)(marker.radius);
    radius = isMarkerDisplayable || isChosen ? radius : 0; // 标记点为无时鼠标悬浮时标记点也会显示

    if (radius <= 0) {
      return radius;
    } // 空心标记点为居中描边，折线实心标记点为外描边


    radius = isHollow ? radius - this._defaultStrokeWidth(point.series.vanchart) / 2 : isLine ? radius + this._defaultStrokeWidth(point.series.vanchart) / 2 : radius;
    return radius + (isChosen ? 2 : 0);
  },
  _onMarkerPressed: function (point) {
    var marker = point.options && point.options.marker,
        markerType = marker.symbol;

    if (!point.graphic || _BaseUtils["default"].isImageMarker(markerType)) {
      return;
    }

    var isHollow = this._isHollowMarker(markerType),
        clickColor = point.clickColor,
        clickOpacity = point.clickOpacity;

    var style = isHollow ? {
      'stroke': clickColor,
      'stroke-opacity': clickOpacity
    } : {
      'fill': clickColor,
      'fill-opacity': clickOpacity
    };
    point.graphic.markerPath.style(style);
  },
  _onMarkerState: function (point, isChosen) {
    var marker = point.options.marker,
        markerType = marker.symbol,
        gap = 5,
        self = this;

    if (point.graphic) {
      gap = 2;

      if (_BaseUtils["default"].isImageMarker(markerType)) {
        var w = marker.width + (isChosen ? 4 : 0),
            h = marker.height + (isChosen ? 4 : 0);
        point.graphic.image && point.graphic.image.interrupt(_Constants["default"].SELECT_ANIMATION).transition(_Constants["default"].SELECT_ANIMATION).animate({
          duration: 300,
          ease: _BezierEasing["default"].custom["ease-out-back"],
          attr: {
            'x': -w / 2,
            'y': -h / 2,
            'width': w,
            'height': h
          }
        });
      } else {
        var pathAnimate = function (path, r, isLine) {
          // CHART-15766 报错interrupt of null
          if ((0, _CoreUtils.hasNotDefined)(path)) {
            return;
          }

          var animate = {
            duration: 300,
            ease: _BezierEasing["default"].custom["ease-out-back"],
            attr: {
              'd': _PathGenerator["default"].getMarkerPath(markerType, r)
            }
          }; // 折线图标记点自动显示为无时，鼠标悬浮会有带描边的实心标记点

          if (r > 0 && isLine) {
            animate.style = {
              "stroke-width": self._defaultStrokeWidth(point.series.vanchart)
            };
          }

          path.interrupt(_Constants["default"].SELECT_ANIMATION).transition(_Constants["default"].SELECT_ANIMATION).animate(animate);
        };

        var radius = this._getMarkerRadius(point, marker, isChosen);

        var isLine = this.type === _Constants["default"].LINE_CHART;
        pathAnimate(point.graphic.markerPath, radius, isLine);
      }
    }

    var series = point.series,
        diffX = 0,
        diffY = 0;

    if (series.type === _Constants["default"].RADAR_CHART) {
      var pos = series._getArcPoint(gap, point.radian);

      diffX = pos[0];
      diffY = pos[1];
    } else {
      diffY = -gap;
      var options = point.options,
          dataLabels = options.dataLabels,
          align = point.labelAlign || dataLabels.align;

      if (align === _Constants["default"].BOTTOM) {
        diffY = gap;
      }
    }

    series._labelTransformState(point, diffX, diffY, isChosen, 300, _BezierEasing["default"].custom["ease-out-back"]);
  },
  removeDefaultMarker: function () {
    var series = this;
    series.defaultMarker && series.defaultMarker.remove();
    series.defaultMarker = null;
  },
  _onMarkerMouseOver: function (point) {
    var series = point.series;

    series._onMarkerState(point, true);

    if (!point.graphic) {
      var marker = this._getDefaultMarker(point);

      series.defaultMarker = series.defaultMarker || this._createMarker(marker).addTo(this.group);
      series.defaultMarker.attr('transform', 'translate(' + point.posX + ',' + point.posY + ') scale(0.01)');

      this._updateMarker(point, series.defaultMarker, marker);

      series.defaultMarker.interrupt(_Constants["default"].SELECT_ANIMATION).transition(_Constants["default"].SELECT_ANIMATION).animate({
        duration: 300,
        ease: 'ease',
        attr: {
          'transform': 'translate(' + point.posX + ',' + point.posY + ') scale(1.5)'
        }
      });
    }
  },
  _onMarkerMouseOut: function (point) {
    var series = point.series;

    series._onMarkerState(point, false);

    if (!point.graphic && series.defaultMarker) {
      series.defaultMarker.animate({
        duration: 300,
        ease: 'ease',
        attr: {
          'transform': 'translate(' + point.posX + ',' + point.posY + ') scale(0.01)'
        }
      }).remove();
      series.defaultMarker = null;
    }
  },
  //当没有marker的时候默认加一个marker
  _getDefaultMarker: function (point) {
    return {
      'symbol': _Constants["default"].CIRCLE,
      'fillColor': point.options.marker.fillColor,
      'fillColorOpacity': point.options.marker.fillColorOpacity,
      "radius": _Constants["default"].MARKER_RADIUS,
      "enabled": true
    };
  },
  _calculateAnimationDelay: function () {
    return 0;
  },
  _isHollowMarker: function (markerType) {
    return markerType && markerType.indexOf('hollow') !== -1;
  },
  _animateEnd: function () {
    this._showLabels();

    this._drawEffectPoints();
  },
  _showLabels: function () {
    var series = this,
        vanchart = series.vanchart;

    series._updateDataLabels(); // 图表绘制结束就绘制标签，没有必要等MoreLabel了


    series._updateCateLabels && series._updateCateLabels();

    if (vanchart._needShowMoreLabel()) {
      series.getTextDataToDraw().forEach(function (point) {
        if (point.visible && series.visible) {
          series._showMoreLabel(point);
        }
      });
    }

    vanchart._removeChangeDataState(series);
  },

  /**
   * 统一显示MoreLabel:值变化提示
   * @param  {[type]} point           [point]
   * @param  {[type]} startX     [moreLabel缩放起始点X](非必填, 未传值的则使用series.calcMoreLabelPosition计算)
   * @param  {[type]} startY     [moreLabel缩放起始点Y](同上)
   */
  _showMoreLabel: function (point, startX, startY) {
    if (point.depth === 0 && this.type === _Constants["default"].MULTIPIE_CHART) {
      //框架图的根节点也需要有moreLabel
      //多层饼图
      return;
    }

    var series = this,
        vanchart = series.vanchart,
        points = point.points;
    var moreLabel = vanchart.getComponent(_component.ComponentCst.MORELABEL_COMPONENT);

    if (vanchart.isMobileFlow()) {
      return;
    }

    if (series.type === _Constants["default"].GANTT_CHART) {
      return; // 甘特图暂不支持MoreLabel
    }

    var lastValue = point._lastValue || 0,
        lastArrivalRate = point._lastArrivalRate || 0; // 判断是否需要一框对多点

    var morePointsOneTip = function (series) {
      var gaugeType = series.gaugeType;
      return gaugeType === _Constants["default"].POINTER_SEMI_GAUGE || gaugeType === _Constants["default"].POINTER_GAUGE || vanchart.isPointOrAreaOrHeatMap();
    }; // 计算变化值,用作判断是否需要显示moreLabel


    var changedValue = _BaseUtils["default"].accAdd(+point.options[series.getTargetKey()], -lastValue); // 最后一个点如果是未变化的且需要一框多点的时候，在这里触发渲染
    // 框架图points为undefined


    if (changedValue === 0 || isNaN(changedValue)) {
      if (points && point === points[points.length - 1] && morePointsOneTip(series)) {
        moreLabel.showWithPoint(point, startX, startY);
      }

      return;
    }

    point.changedValue = changedValue;
    var changedPercent = changedValue / lastValue;
    point.changedPercent = isFinite(changedPercent) ? changedPercent : changedPercent < 0 ? "-∞" : "∞"; // 漏斗图-转换率

    if (series.type === _Constants["default"].FUNNEL_CHART) {
      point.changedArrivalRate = _BaseUtils["default"].accAdd(point.arrivalRate, lastArrivalRate);
    } // 指针仪表盘这样的，需要一框多点显示，要特殊处理：
    // 先MoreLabelHelper.collectPoint(point)把点相关的提示保存起来，等到遍历到最后一个点的时候，再统一布局绘制
    // 注意：如果最后一个点未发生值变化，那么在判断changedValue的时候，就该触发渲染操作了。


    if (morePointsOneTip(series)) {
      moreLabel.collectPoint(point);

      if (point === points[points.length - 1]) {
        moreLabel.showWithPoint(point, startX, startY);
      }

      return;
    } // 普通的一框对一点的渲染方式


    moreLabel.collectPoint(point);
    moreLabel.showWithPoint(point, startX, startY);
  },

  /**
   * 计算MoreLabel的起始位置和缩放方向:具体图表要重写这个方法。
   * @param  {[type]} point        [description]
   * @param  {[type]} moreLabelDim [moreLabel尺寸大小]
   * @return {[type]}              [moreLabelPosition]
   */
  calcMoreLabelPosition: function (point, moreLabelDim) {
    return {
      startX: point.x + point.width / 2,
      centerY: point.y - moreLabelDim.height / 2,
      direction: "top"
    };
  },

  /**
   * 判断监控刷新状态下是否有数据点发生值变化：多用于渲染时，针对值变化的情况特殊处理。
   * @return {Boolean} [description]
   */
  hasChangedPointWithChangeDataState: function () {
    var validPoints = this.points.filter(function (point) {
      return !point.isNull;
    });
    var pointChanged = false,
        index = 0;

    while (index < validPoints.length) {
      var point = validPoints[index];

      if (point.value != point._lastValue) {
        pointChanged = true;
        break;
      }

      index++;
    } // 有值变化且 _changeDataState才算hasChangedPoint，诸如resize之类的不会更新point的value和_lastValue，因此，计算出的pointChanged为true，但是不算发生值变化


    return pointChanged && this.vanchart._changeDataState;
  },
  _updateDataLabels: function () {
    var series = this;
    series.getTextDataToDraw().forEach(function (point) {
      series._createTextGraphic(point);

      series._updatePointLabelStyle(point);
    });
  },
  _removeDataLabels: function () {
    var series = this;
    series.getTextDataToDraw().forEach(function (point) {
      point.removeTextGraphic();
      point.newMoreLabelG && point.newMoreLabelG.remove();
      point.newMoreLabelG = null;
    });
  },
  // labelPos是整个标签左上角，不使用垂直居中效果 writingMode: tb-rl 时，
  // text.tans(x+width/2, y+height/2).dx(dx-width/2).dy(dy-height/2),
  // 使用垂直居中效果时，text.tans(x+width/2, y+height/2).dx(dx).dy(dy-height/2),
  // 这样做的原因：选中放大，要trans到缩放中心
  _createTextGraphic: function (point) {
    if (point.hasValidDataLabel()) {
      // Ques 不是本来就有一些删除步骤了，要改这种bug尽量不要在这些地方添加一个莫名其妙的移除吧，尽量规范逻辑
      point.removeTextGraphic(); // @CHART-1982  饼图旋转加监控刷新标签重叠问题

      (0, _VanChartLabelBorder.createTextBorderPath)(point);

      if (point.options.dataLabels.useRichText) {
        (0, _richTextMount.createRichTextLabel)(point);
      } else {
        this.createCommonTextLabel(point);
      }

      if (point.labelPos.startPos) {
        // leadLine
        point.leadLine = this._getPointTextLabelGroup().append(this._getLeadLine(point));
      }
    }
  },
  createCommonTextLabel: function (point) {
    var series = this,
        vanchart = series.vanchart,
        renderer = vanchart.renderer,
        labelContent = point.labelContent,
        dataLabels = point.options.dataLabels;
    var useHtml = dataLabels.useHtml,
        labelWidth = dataLabels.labelWidth,
        labelHeight = dataLabels.labelHeight;

    var textLabelGroup = this._getPointTextLabelGroup();

    var text = renderer.vtext(useHtml).attr('transform', _BaseUtils["default"].makeTranslate(series._labelTrans(point))).style({
      'pointer-events': 'none',
      'white-space': 'pre',
      'word-wrap': 'normal' // 解决FR里继承问题

    });

    if (this._hasOuterLineFilter(dataLabels, point.labelAlign)) {
      text.attr('filter', this._getOuterLineFilter());
    }

    var startY = 0;
    var halfHeight = point.labelDim.height / 2,
        halfWidth = point.labelDim.width / 2;
    var sizeStyle = labelWidth != null || labelHeight != null ? {
      'width': labelWidth + 'px',
      'height': labelHeight + 'px',
      'overflow': "hidden"
    } : {}; // ie兼容：垂直居中效果 writingMode: tb-rl，应添加到text元素，添加到tspans时ie下排列显示有问题，
    // 添加到text上后，按照计算的居中位置（x, y）左对齐显示，因此实际中心会有0.5个宽度的右偏移，需要在dx中矫正回来

    if (labelContent && labelContent.length === 1 && this._isVerticalLabel(labelContent[0].style)) {
      var label = labelContent[0],
          labelText = label.text,
          labelStyle = label.style;

      if (useHtml) {
        halfWidth = -halfWidth;
      } else {
        halfWidth = _Browser["default"].ie ? -halfWidth * 0.5 : 0;
      }

      text.style({
        'margin-top': -halfHeight + 'px',
        'text-align': "center"
      }).style(sizeStyle).attr('dx', halfWidth).attr('dy', -halfHeight).style(labelStyle).textContent(labelText);
    } else {
      text.tspans = [];

      for (var i = 0, count = labelContent.length; i < count; i++) {
        var _label = labelContent[i],
            labelDim = _label.dim,
            _labelText = _label.text,
            _labelStyle = _label.style; // 在translate导致的坐标系原点偏移后，原始的label也需要相应的位置调整

        var xShift = -point.labelDim.width / 2,
            yShift = -point.labelDim.height / 2 + labelDim.height * 0.85; // todo 原始的dataLabels没有_align属性，只有多层饼图和矩形树图会生成这个属性，将来可以考虑放到point上，和labelAlign保持一致

        var alignShift = this._calculateLabelAlignShift(point.options.dataLabels._align, point.labelDim, labelDim);

        text.tspans.push(renderer.vtspan(useHtml).style({
          'margin-top': -halfHeight + 'px',
          'text-align': "center"
        }).style(sizeStyle).attr('y', startY).attr('x', 0).attr('dy', yShift).attr('dx', alignShift + xShift).style(_labelStyle).textContent(_labelText).addTo(text));
        startY += labelDim.height + 2;
      }
    }

    point.textGraphic = textLabelGroup.append(text);
  },
  _calculateLabelAlignShift: function (align, pointLabelDim, contentLabelDim) {
    switch (align) {
      case _Constants["default"].LEFT:
        return 0;

      case _Constants["default"].RIGHT:
        return pointLabelDim.width - contentLabelDim.width;

      case _Constants["default"].CENTER:
      default:
        return (pointLabelDim.width - contentLabelDim.width) / 2;
    }
  },
  _isVerticalLabel: function (style) {
    if (!style) {
      return false;
    }

    return style['writingMode'] === 'tb-rl' || style['writing-mode'] === 'tb-rl' || style['-webkit-writing-mode'] === 'vertical-rl';
  },

  /**
   * 标签优化后的图形的point会有labelAlign，目前柱形图、条形图、折线图、面积图具有该属性；
   * 字符样式为自定义样式无外描边，折线图、标签居外的柱形图和条形图标签有外描边
   * @param dataLabels
   * @param labelAlign
   * @returns {boolean|boolean}
   * @private
   */
  _hasOuterLineFilter: function (dataLabels, labelAlign) {
    if (!(0, _EnvUtils.isSupportSVG)() || dataLabels.style) {
      return false;
    }

    var chartType = this.type;
    return chartType === _Constants["default"].LINE_CHART || chartType === _Constants["default"].COLUMN_CHART && labelAlign === _Constants["default"].OUTSIDE || chartType === _Constants["default"].BAR_CHART && labelAlign === _Constants["default"].OUTSIDE;
  },
  _getOuterLineFilter: function () {
    var series = this,
        vanchart = series.vanchart,
        renderer = vanchart.renderer,
        color = this._getBackgroundColorWithAlpha() || DEFAULT_LABEL_STROKE;

    if (!vanchart.outerLineFilter) {
      vanchart.outerLineFilter = renderer.createOuterLineFilter(color, OUTER_LINE_WIDTH);
    } else {
      renderer.updateOuterLineFilter(vanchart.outerLineFilter, color, OUTER_LINE_WIDTH);
    }

    return renderer.toPatternProperty(vanchart.outerLineFilter);
  },
  _labelTrans: function (point) {
    if ((0, _VanChartLabelBorder.isNeedBorder)(point)) {
      return (0, _VanChartLabelBorder.labelTransWithBorder)(point);
    }

    return {
      x: point.labelPos.x + point.labelDim.width / 2,
      y: point.labelPos.y + point.labelDim.height / 2
    };
  },
  _labelFontSizeState: function (point, isChosen, duration, ease) {
    if (point.labelPos) {
      var pos = point.series._labelTrans(point),
          scale = isChosen ? 1.1 : 1;

      if (point.textGraphic) {
        var paras = point.textGraphic.type === 'div' ? {
          duration: duration,
          ease: ease,
          style: {
            'transform': 'translate(' + pos.x + 'px,' + pos.y + 'px)scale(' + scale + ')'
          }
        } : {
          duration: duration,
          ease: ease,
          attr: {
            'transform': 'translate(' + pos.x + ',' + pos.y + ')scale(' + scale + ')'
          }
        };
        point.textGraphic && point.textGraphic.interrupt(_Constants["default"].SELECT_ANIMATION).transition(_Constants["default"].SELECT_ANIMATION).animate(paras);
      }
    }
  },
  _labelTransformState: function (point, diffX, diffY, isChosen, duration, ease) {
    if (this.vanchart.onSeriesRendering()) {
      return;
    }

    if (point.labelPos) {
      var trans = point.series._labelTrans(point);

      if (isChosen) {
        trans = {
          x: trans.x + diffX,
          y: trans.y + diffY
        };
      }

      point.textGraphic && point.textGraphic.animate({
        duration: duration,
        ease: ease,
        attr: {
          'transform': _BaseUtils["default"].makeTranslate(trans)
        },
        style: {
          'transform': 'translate(' + trans.x + 'px,' + trans.y + 'px)'
        }
      });
      this.labelBorderTransformState(point, diffX, diffY, isChosen, duration, ease);
    }
  },
  labelBorderTransformState: function (point, diffX, diffY, isChosen, duration, ease) {
    if (!point.textBorderPath) {
      return;
    }

    var borderBounds = (0, _VanChartLabelBorder.getBorderBounds)(point);
    var textBorderPathTrans = {
      x: borderBounds.x,
      y: borderBounds.y
    };

    if (isChosen) {
      textBorderPathTrans = {
        x: textBorderPathTrans.x + diffX,
        y: textBorderPathTrans.y + diffY
      };
    }

    point.textBorderPath.animate({
      duration: duration,
      ease: ease,
      attr: {
        transform: _BaseUtils["default"].makeTranslate(textBorderPathTrans)
      }
    });
  },
  _outSideLabelColorState: function (point, isChosen, duration, ease) {
    var labelContent = point.labelContent,
        len = labelContent.length;

    if (point.textGraphic && point.textGraphic.tspans) {
      point.textGraphic.tspans.forEach(function (span, i) {
        if (i < len) {
          var style = span.styles;
          span.transition(_Constants["default"].SELECT_STYLE_ANIMATION).animate({
            duration: duration,
            ease: ease,
            style: {
              'color': style.color,
              'fill': style.color
            }
          });
        }
      });
    }
  },

  /**
   * 选中状态下的连接线path计算
   * @param point
   * @param diffX
   * @param diffY
   * @returns {*}
   * @private
   */
  _getChosenPointLeadLinePath: function (point, diffX, diffY) {
    function addDiff(pos) {
      return {
        x: pos.x + diffX,
        y: pos.y + diffY
      };
    }

    var labelPos = point.labelPos;
    var newLabelPos = {
      startPos: addDiff(labelPos.startPos),
      midPos: addDiff(labelPos.midPos),
      endPos: addDiff(labelPos.endPos)
    };
    return this._getLeadLinePathWithPos(newLabelPos);
  },
  _leadLineState: function (point, diffX, diffY, isChosen, duration, ease) {
    var series = point.series,
        labelPos = point.labelPos,
        options = point.options,
        dataLabels = options.dataLabels;

    if (!labelPos || !labelPos.startPos) {
      return;
    }

    var leadLinePos = labelPos,
        leadLineColor = dataLabels.connectorColor || point.color;

    if (isChosen) {
      leadLineColor = point.mouseOverColor;
    }

    if (point.leadLine) {
      point.leadLine.transition(_Constants["default"].SELECT_ANIMATION).animate({
        duration: duration || 100,
        ease: ease || 'ease',
        attr: {
          'd': isChosen ? this._getChosenPointLeadLinePath(point, diffX, diffY) : series._getLeadLinePathWithPos(leadLinePos)
        }
      });
      point.leadLine.transition(_Constants["default"].SELECT_STYLE_ANIMATION).animate({
        duration: duration || 100,
        ease: ease || 'ease',
        style: {
          'stroke': leadLineColor
        }
      });
    }
  },
  _getLeadLine: function (point) {
    return this.vanchart.renderer.path().attr('d', this._getLeadLinePath(point)).style({
      'fill': 'none',
      'stroke': point.options.dataLabels.connectorColor || point.color,
      'stroke-opacity': point.autoLabelOpacity(),
      'stroke-width': point.options.dataLabels.connectorWidth || 0
    });
  },
  _getLeadLinePath: function (point) {
    return this._getLeadLinePathWithPos(point.labelPos);
  },
  _getLeadLinePathWithPos: function (labelPos) {
    var startPos = labelPos.startPos,
        midPos = labelPos.midPos,
        endPos = labelPos.endPos;
    var F = this._dealWithFloat;
    return 'M' + F(startPos.x) + ',' + F(startPos.y) + 'L' + F(midPos.x) + ',' + F(midPos.y) + 'L' + F(endPos.x) + ',' + F(endPos.y);
  },
  _dealWithFloat: function (v) {
    return Math.abs(v) < 1e-6 ? 0 : v;
  },
  _getPointGraphicGroup: function () {
    return this.group;
  },
  _getPointTextLabelGroup: function () {
    if (!this.textGraphicGroup) {
      var vanchart = this.vanchart,
          textRenderGroup = vanchart.seriesTextRenderGroup,
          textDivGroup = vanchart.seriesTextDivGroup;
      this.textGraphicGroup = vanchart.renderer.vgroup();
      textRenderGroup.append(this.textGraphicGroup.renderG);
      textDivGroup.append(this.textGraphicGroup.divG);
      this.textGraphicGroup.attr('transform', _BaseUtils["default"].makeTranslate(this._getTranslate()));
    } else {
      this.textGraphicGroup.attr('transform', _BaseUtils["default"].makeTranslate(this._getTranslate()));
    }

    return this.textGraphicGroup;
  },
  _getTranslate: function () {
    return this.vanchart.bounds;
  },
  //seriesUnChosen:series.fire; mouseout:dom event。
  //原因：折线图鼠标移出线，线依然选中因为有选中点。折线图的mouseout不做任何事情，seriesUnChosen取消线的选中状态。
  getEvents: function () {
    return {
      'mouseover': this._onSeriesMouseOver,
      'mouseout': this._onSeriesMouseOut,
      'seriesUnChosen': this._seriesUnChosen,
      'pointMouseOver': this._onPointMouseOver,
      'pointMouseOut': this._onPointMouseOut,
      'tap': this._onSeriesTap
    };
  },
  // 对于词云框架图的超链鼠标悬浮变手统一处理
  _onPointMouseOver: function (point) {
    if (point.graphic) {
      point.graphic.style('cursor', point.onClick ? 'pointer' : '');
    }
  },
  _seriesUnChosen: function (ev) {
    this._onSeriesMouseOut && this._onSeriesMouseOut(ev);
  },
  _onSeriesMouseOver: function (ev) {
    var series = this,
        vanchart = series.vanchart,
        hoverSeries = vanchart.hoverSeries;
    var hoverPoint = vanchart.hoverPoint;

    if (hoverSeries != series) {
      hoverSeries && hoverSeries.fire('seriesUnChosen', ev);
      vanchart.hoverSeries = series;
    }

    var closestPoint = series.getClosestPoint(ev.containerPoint);

    if (closestPoint && closestPoint != hoverPoint) {
      hoverPoint && hoverPoint.fire('mouseout', ev);
      vanchart.registerInteractiveTarget(closestPoint, closestPoint.series.defaultMarker);
      closestPoint.fire('mouseover', ev);
      vanchart.registerInteractiveTarget(closestPoint, closestPoint.series.defaultMarker);
    }
  },
  // 只对移动端的tap事件做单独处理
  _onSeriesTap: function (ev) {
    this.vanchart && this.vanchart.isMobile() && this.fire('mouseover', ev);
  },
  getPressedStyle: function () {
    return null;
  },
  onPointPress: function () {
    var point = this,
        series = point.series,
        style = series.getPressedStyle(point);

    if (style && point.graphic) {
      point.graphic.style(style);
    }
  },
  onPointPressUp: function () {
    var point = this,
        series = point.series,
        style = series.getHighLightStyle && series.getHighLightStyle(point);

    if (style && point.graphic) {
      point.graphic.style(style);
    }
  },
  remove: function () {
    var series = this,
        vanchart = series.vanchart;
    this.points.forEach(function (point) {
      vanchart.removePointGraphics(point, series.type, false);
    });
    this._canvas && this._canvas.remove();
    this.textGraphicGroup && this.textGraphicGroup.remove();
    this.group && this.group.remove();
    this.textGraphicGroup = this._canvas = this.group = null;
  },
  reShowPoint: function (point) {
    var series = point.series,
        vanchart = series.vanchart,
        legend = vanchart.getComponent(_component.ComponentCst.LEGEND_COMPONENT);
    return legend && legend.items && legend.reShowPoint(point);
  },
  //等其他系列消失，此系列再动画
  updateDelay: function (delay) {
    var series = this,
        vanchart = series.vanchart,
        legend = vanchart.getComponent(_component.ComponentCst.LEGEND_COMPONENT);

    if (legend && legend.showSeries(series)) {
      var chartSeries = vanchart.seriesOfType(series.type);

      for (var i = 0, len = chartSeries.length; i < len; i++) {
        if (legend.toDropSeries(chartSeries[i])) {
          return delay || 150;
        }
      }
    }

    return 0;
  },
  _defaultStrokeWidth: function (vanchart) {
    return (0, _AutoFitUtils.autoFitFontScale)(vanchart) * DEFAULT_STROKE_WIDTH;
  },
  getKey: function () {
    var series = this,
        chartOption = series.vanchart.options;
    return _KeyUtils["default"].getSeriesKey(series.options, chartOption);
  }
}); // @CHART-9054: 面积图选中效果优化

Series.include({
  toFrontPosition: function () {
    var node = this.group.node();

    if (node && !this._toFront) {
      this._nextSibling = node.nextSibling;
      this._toFront = true;

      _BaseUtils["default"].toFront(node);
    }
  },
  resetPosition: function () {
    var node = this.group.node();

    if (node && this._nextSibling && this._toFront) {
      this._toFront = false; // CHART-15766 Failed to execute 'insertBefore' on 'Node
      // 这里用来置顶，在置顶过程中，nextSibling可能没数据被移除了，就会报错，得判断一下

      if (this._nextSibling && this._nextSibling.parentNode && this._nextSibling.parentNode == node.parentNode) {
        node.parentNode.insertBefore(node, this._nextSibling);
      }
    }
  },
  getGroupTrans: function () {
    return [0, 0];
  },
  getAbsoluteLabelPos: function (labelPos) {
    var lx = labelPos.x,
        ly = labelPos.y;
    var serTrans = this.getGroupTrans();
    return {
      x: lx + serTrans[0],
      y: ly + serTrans[1]
    };
  },
  isSupportVerticalLabel: function () {
    return false;
  }
});
var _default = Series;
exports["default"] = _default;

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/1/19.
 */
var Point2D = function (x, y, round) {
  // @property x: Number; The `x` coordinate of the point
  this.x = round ? Math.round(x) : x; // @property y: Number; The `y` coordinate of the point

  this.y = round ? Math.round(y) : y;
};

Point2D.prototype = {
  // @method clone(): Point
  // Returns a copy of the current point.
  clone: function () {
    return new Point2D(this.x, this.y);
  },
  // @method add(otherPoint: Point): Point
  // Returns the result of addition of the current and the given points.
  add: function (point) {
    // non-destructive, returns a new point
    return this.clone()._add(Point2D.create(point));
  },
  _add: function (point) {
    // destructive, used directly for performance in situations where it's safe to modify existing point
    this.x += point.x;
    this.y += point.y;
    return this;
  },
  // @method subtract(otherPoint: Point): Point
  // Returns the result of subtraction of the given point from the current.
  subtract: function (point) {
    return this.clone()._subtract(Point2D.create(point));
  },
  _subtract: function (point) {
    this.x -= point.x;
    this.y -= point.y;
    return this;
  },
  // @method divideBy(num: Number): Point
  // Returns the result of division of the current point by the given number.
  divideBy: function (num) {
    return this.clone()._divideBy(num);
  },
  _divideBy: function (num) {
    this.x /= num;
    this.y /= num;
    return this;
  },
  // @method multiplyBy(num: Number): Point
  // Returns the result of multiplication of the current point by the given number.
  multiplyBy: function (num) {
    return this.clone()._multiplyBy(num);
  },
  _multiplyBy: function (num) {
    this.x *= num;
    this.y *= num;
    return this;
  },
  // @method scaleBy(scale: Point): Point
  // Multiply each coordinate of the current point by each coordinate of
  // `scale`. In linear algebra terms, multiply the point by the
  // [scaling matrix](https://en.wikipedia.org/wiki/Scaling_%28geometry%29#Matrix_representation)
  // defined by `scale`.
  scaleBy: function (point) {
    return new Point2D(this.x * point.x, this.y * point.y);
  },
  // @method unscaleBy(scale: Point): Point
  // Inverse of `scaleBy`. Divide each coordinate of the current point by
  // each coordinate of `scale`.
  unscaleBy: function (point) {
    return new Point2D(this.x / point.x, this.y / point.y);
  },
  // @method round(): Point
  // Returns a copy of the current point with rounded coordinates.
  round: function () {
    return this.clone()._round();
  },
  _round: function () {
    this.x = Math.round(this.x);
    this.y = Math.round(this.y);
    return this;
  },
  // @method floor(): Point
  // Returns a copy of the current point with floored coordinates (rounded down).
  floor: function () {
    return this.clone()._floor();
  },
  _floor: function () {
    this.x = Math.floor(this.x);
    this.y = Math.floor(this.y);
    return this;
  },
  // @method ceil(): Point
  // Returns a copy of the current point with ceiled coordinates (rounded up).
  ceil: function () {
    return this.clone()._ceil();
  },
  _ceil: function () {
    this.x = Math.ceil(this.x);
    this.y = Math.ceil(this.y);
    return this;
  },
  // @method distanceTo(otherPoint: Point): Number
  // Returns the cartesian distance between the current and the given points.
  distanceTo: function (point) {
    point = Point2D.create(point);
    var x = point.x - this.x,
        y = point.y - this.y;
    return Math.sqrt(x * x + y * y);
  },
  // @method equals(otherPoint: Point): Boolean
  // Returns `true` if the given point has the same coordinates.
  equals: function (point) {
    point = Point2D.create(point);
    return point.x === this.x && point.y === this.y;
  },
  // @method contains(otherPoint: Point): Boolean
  // Returns `true` if both coordinates of the given point are less than the corresponding current point coordinates (in absolute values).
  contains: function (point) {
    point = Point2D.create(point);
    return Math.abs(point.x) <= Math.abs(this.x) && Math.abs(point.y) <= Math.abs(this.y);
  },
  // @method toString(): String
  // Returns a string representation of the point for debugging purposes.
  toString: function () {
    return 'Point(' + _BaseUtils["default"].formatNum(this.x) + ', ' + _BaseUtils["default"].formatNum(this.y) + ')';
  }
};

Point2D.create = function (x, y, round) {
  if (x instanceof Point2D) {
    return x;
  }

  if (_BaseUtils["default"].isArray(x)) {
    return new Point2D(x[0], x[1]);
  }

  if (x === undefined || x === null) {
    return x;
  }

  if (typeof x === 'object' && 'x' in x && 'y' in x) {
    return new Point2D(x.x, x.y);
  }

  return new Point2D(x, y, round);
};

var _default = Point2D;
exports["default"] = _default;

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLineStyle = getLineStyle;
exports.getMarkerRadius = getMarkerRadius;

var _Constants = _interopRequireDefault(__webpack_require__(1));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function getLineStyle(config) {
  var color = config.color,
      lineWidth = config.lineWidth,
      _config$lineType = config.lineType,
      lineType = _config$lineType === void 0 ? _Constants["default"].SOLID : _config$lineType,
      _config$opacity = config.opacity,
      opacity = _config$opacity === void 0 ? 1 : _config$opacity;
  lineWidth = _Constants["default"].DASH_ARRAY[lineType] == null ? 0 : lineWidth;
  return {
    'fill': 'none',
    'stroke': color,
    'stroke-width': lineWidth,
    'stroke-opacity': opacity,
    'stroke-dasharray': _Constants["default"].DASH_ARRAY[lineType]
  };
}

function getMarkerRadius(radius) {
  return isNaN(radius) ? _Constants["default"].MARKER_RADIUS : radius;
}

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OneTenthTextVerPadding = OneTenthTextVerPadding;
exports.QuarterTextVerPadding = QuarterTextVerPadding;
exports.autoFitFontScale = autoFitFontScale;
var QUARTER_TEXT_PADDING_RATIO = 0.25;
var ONE_TENTH_TEXT_PADDING_RATIO = 0.1;
/**
 * 计算文本垂直方向单边边距，行高为字体高度1.2倍
 * @param fontSize {Number/String} 字体大小
 * @return {Number} 字体单边边距
 * */

function OneTenthTextVerPadding(fontSize) {
  fontSize += '';
  return parseFloat(fontSize) * ONE_TENTH_TEXT_PADDING_RATIO;
}
/**
 * 计算文本垂直方向单边边距，行高为字体高度1.5倍
 * @param fontSize {Number/String} 字体大小
 * @return {Number} 字体单边边距
 * */
// 设计稿行高为字高的1.5倍，所以上下边距为0.25字高


function QuarterTextVerPadding(fontSize) {
  fontSize += '';
  return parseFloat(fontSize) * QUARTER_TEXT_PADDING_RATIO;
}

function autoFitFontScale(vanchart) {
  var chart = vanchart.vancharts.fullScreenFather || vanchart;
  chart = chart.vancharts;
  return chart.autoFitScale.fontScale || 1;
}

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/2/14.
 */
var d3_interpolate_numberA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,
    d3_interpolate_numberB = new RegExp(d3_interpolate_numberA.source, "g");

function interpolator(a, b) {
  var t = typeof b;

  if (isDifferentColorType(a, b)) {
    return function () {
      return b;
    };
  }

  return (t === "string" ? _ColorUtils["default"].hasColorName(b) || /^(#|rgb\(|hsl\()/.test(b) ? d3_interpolateRgb : d3_interpolateString : Array.isArray(b) ? d3_interpolateArray : t === "object" && isNaN(b) ? d3_interpolateObject : d3_interpolateNumber)(a, b);
}

function isDifferentColorType(a, b) {
  if (typeof a !== 'string' || typeof b !== 'string') {
    return false;
  }

  return b.indexOf('url') > -1 && a.indexOf('url') < 0 || a.indexOf('url') > -1 && b.indexOf('url') < 0;
}

function d3_rgb_hex(v) {
  return v < 16 ? "0" + Math.max(0, v).toString(16) : Math.min(255, v).toString(16);
}

function d3_interpolateRgb(a, b) {
  a = a == 'none' || a == '' ? b : a;
  a = _ColorUtils["default"].getRGBAColorArray(a);
  b = _ColorUtils["default"].getRGBAColorArray(b);
  var ar = a[0],
      ag = a[1],
      ab = a[2],
      br = b[0] - ar,
      bg = b[1] - ag,
      bb = b[2] - ab;
  return function (t) {
    return "#" + d3_rgb_hex(Math.round(ar + br * t)) + d3_rgb_hex(Math.round(ag + bg * t)) + d3_rgb_hex(Math.round(ab + bb * t));
  };
}

function checkMatrixTransform(string) {
  var trans = string.match(/matrix\((\d+\.?\d*|\.?\d+), 0, 0, (\d+\.?\d*|\.?\d+), ([-+]?\d+\.?\d*|\.?\d+), ([-+]?\d+\.?\d*|\.?\d+)\)/);
  return trans ? "translate(" + trans[3] + "px," + trans[4] + "px)scale(" + trans[1] + ")" : string;
}

function d3_interpolateString(a, b) {
  var bi = d3_interpolate_numberA.lastIndex = d3_interpolate_numberB.lastIndex = 0,
      am,
      bm,
      bs,
      i = -1,
      s = [],
      q = [];
  a = a + "";
  b = b + "";
  a = checkMatrixTransform(a);
  b = checkMatrixTransform(b);

  while ((am = d3_interpolate_numberA.exec(a)) && (bm = d3_interpolate_numberB.exec(b))) {
    if ((bs = bm.index) > bi) {
      bs = b.slice(bi, bs);

      if (s[i]) {
        s[i] += bs;
      } else {
        s[++i] = bs;
      }
    }

    if ((am = am[0]) === (bm = bm[0])) {
      if (s[i]) {
        s[i] += bm;
      } else {
        s[++i] = bm;
      }
    } else {
      s[++i] = null;
      q.push({
        i: i,
        x: d3_interpolateNumber(am, bm)
      });
    }

    bi = d3_interpolate_numberB.lastIndex;
  }

  if (bi < b.length) {
    bs = b.slice(bi);

    if (s[i]) {
      s[i] += bs;
    } else {
      s[++i] = bs;
    }
  }

  return s.length < 2 ? q[0] ? (b = q[0].x, function (t) {
    return b(t) + "";
  }) : function () {
    return b;
  } : (b = q.length, function (t) {
    for (var i = 0, o; i < b; ++i) {
      s[(o = q[i]).i] = o.x(t);
    }

    return s.join("");
  });
}

function d3_interpolateObject(a, b) {
  var i = {},
      c = {},
      k;

  for (k in a) {
    if (k in b) {
      i[k] = interpolator(a[k], b[k]);
    } else {
      c[k] = a[k];
    }
  }

  for (k in b) {
    if (!(k in a)) {
      c[k] = b[k];
    }
  }

  return function (t) {
    for (k in i) {
      c[k] = i[k](t);
    }

    return c;
  };
}

function d3_interpolateNumber(a, b) {
  a = +a, b = +b;
  return function (t) {
    return a * (1 - t) + b * t;
  };
}

function d3_interpolateArray(a, b) {
  var x = [],
      c = [],
      na = a.length,
      nb = b.length,
      n0 = Math.min(a.length, b.length),
      i;

  for (i = 0; i < n0; ++i) {
    x.push(interpolator(a[i], b[i]));
  }

  for (; i < na; ++i) {
    c[i] = a[i];
  }

  for (; i < nb; ++i) {
    c[i] = b[i];
  }

  return function (t) {
    for (i = 0; i < n0; ++i) {
      c[i] = x[i](t);
    }

    return c;
  };
}

function transform(string) {
  var g = document.createElementNS("http://www.w3.org/2000/svg", "g");
  return (transform = function (string) {
    if (string != null) {
      g.setAttribute("transform", string);
      var t = g.transform.baseVal.consolidate();
    }

    return new d3_transform(t ? t.matrix : d3_transformIdentity);
  })(string);
}

function d3_transform(m) {
  var r0 = [m.a, m.b],
      r1 = [m.c, m.d],
      kx = d3_transformNormalize(r0),
      kz = d3_transformDot(r0, r1),
      ky = d3_transformNormalize(d3_transformCombine(r1, r0, -kz)) || 0;

  if (r0[0] * r1[1] < r1[0] * r0[1]) {
    r0[0] *= -1;
    r0[1] *= -1;
    kx *= -1;
    kz *= -1;
  }

  this.rotate = (kx ? Math.atan2(r0[1], r0[0]) : Math.atan2(-r1[0], r1[1])) * 180 / Math.PI;
  this.translate = [m.e, m.f];
  this.scale = [kx, ky];
  this.skew = ky ? Math.atan2(kz, ky) * 180 / Math.PI : 0;
}

d3_transform.prototype.toString = function () {
  return "translate(" + this.translate + ")rotate(" + this.rotate + ")skewX(" + this.skew + ")scale(" + this.scale + ")";
};

function d3_transformDot(a, b) {
  return a[0] * b[0] + a[1] * b[1];
}

function d3_transformNormalize(a) {
  var k = Math.sqrt(d3_transformDot(a, a));

  if (k) {
    a[0] /= k;
    a[1] /= k;
  }

  return k;
}

function d3_transformCombine(a, b, k) {
  a[0] += k * b[0];
  a[1] += k * b[1];
  return a;
}

var d3_transformIdentity = {
  a: 1,
  b: 0,
  c: 0,
  d: 1,
  e: 0,
  f: 0
};

function d3_interpolateTransform(a, b) {
  var s = [],
      q = [],
      n,
      A = transform(a),
      B = transform(b),
      ta = A.translate,
      tb = B.translate,
      ra = A.rotate,
      rb = B.rotate,
      wa = A.skew,
      wb = B.skew,
      ka = A.scale,
      kb = B.scale;

  if (ta[0] != tb[0] || ta[1] != tb[1]) {
    s.push("translate(", null, ",", null, ")");
    q.push({
      i: 1,
      x: d3_interpolateNumber(ta[0], tb[0])
    }, {
      i: 3,
      x: d3_interpolateNumber(ta[1], tb[1])
    });
  } else if (tb[0] || tb[1]) {
    s.push("translate(" + tb + ")");
  } else {
    s.push("");
  }

  if (ra != rb) {
    if (ra - rb > 180) {
      rb += 360;
    } else if (rb - ra > 180) {
      ra += 360;
    }

    q.push({
      i: s.push(s.pop() + "rotate(", null, ")") - 2,
      x: d3_interpolateNumber(ra, rb)
    });
  } else if (rb) {
    s.push(s.pop() + "rotate(" + rb + ")");
  }

  if (wa != wb) {
    q.push({
      i: s.push(s.pop() + "skewX(", null, ")") - 2,
      x: d3_interpolateNumber(wa, wb)
    });
  } else if (wb) {
    s.push(s.pop() + "skewX(" + wb + ")");
  }

  if (ka[0] != kb[0] || ka[1] != kb[1]) {
    n = s.push(s.pop() + "scale(", null, ",", null, ")");
    q.push({
      i: n - 4,
      x: d3_interpolateNumber(ka[0], kb[0])
    }, {
      i: n - 2,
      x: d3_interpolateNumber(ka[1], kb[1])
    });
  } else if (kb[0] !== 1 || kb[1] !== 1) {
    s.push(s.pop() + "scale(" + kb + ")");
  }

  n = q.length;
  return function (t) {
    var i = -1,
        o;

    while (++i < n) {
      s[(o = q[i]).i] = o.x(t);
    }

    return s.join("");
  };
}

interpolator.identity = function (d) {
  return d;
};

interpolator.interpolateRound = function (a, b) {
  b -= a;
  return function (t) {
    return Math.round(a + b * t);
  };
};

interpolator.uninterpolateNumber = function (a, b) {
  b = (b -= a = +a) || 1 / b;
  return function (x) {
    return (x - a) / b;
  };
};

interpolator.interpolateNumber = function (a, b) {
  a = +a, b = +b;
  return function (t) {
    return a * (1 - t) + b * t;
  };
};

interpolator.interpolate = interpolator;
interpolator.interpolateRgb = d3_interpolateRgb;
interpolator.interpolateTransform = d3_interpolateTransform;
interpolator.interpolateArray = d3_interpolateArray;
var _default = interpolator;
exports["default"] = _default;

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _PathGenerator = _interopRequireDefault(__webpack_require__(9));

var _BezierEasing = _interopRequireDefault(__webpack_require__(8));

var _Transition = _interopRequireDefault(__webpack_require__(49));

var _Path = _interopRequireDefault(__webpack_require__(52));

var _LayerGroup = _interopRequireDefault(__webpack_require__(53));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by shine on 2016/12/19.
 */
var PATH = 'M-56,0a56,16 0 1,0 112,0a56,16 0 1,0 -112,0';

function pointMapEffectAnimation(layer, d) {
  var series = d.series,
      vanchart = series.vanchart;
  var options = d.options;
  var markerSize = options.markerType === _Constants["default"].ANCHOR_ICON ? options.markerSize : options.icon.iconSize[0],
      initCircleScale = markerSize / 90,
      // 90的原因，path是根据宽为90的图标画的
  initMarkerScale = options.markerType === _Constants["default"].ANCHOR_ICON ? markerSize / _Constants["default"].ANCHOR_ICON_SIZE : 1;

  var period = series._getEffectTime(d);

  var getPosition = function () {
    var latlng = d.getLatLng(),
        pixels = latlng && vanchart.latLngToLayerPoint(latlng) || {
      x: 0,
      y: 0
    };
    return {
      x: pixels.x,
      y: pixels.y
    };
  };

  function bottom_to_top() {
    return function (t) {
      var pos = getPosition(); // 这边动画的位置，每次都重新算吧，不然缩放的时候，动画用的位置还是上次的，就可能导致闪烁

      var trans = layer._icon ? _BaseUtils["default"].makeTranslate3d({
        x: pos.x,
        y: pos.y - 25 * t
      }) : _BaseUtils["default"].makeTranslate({
        x: pos.x,
        y: pos.y - 25 * t
      });
      return trans + ' scale(' + initMarkerScale + ')';
    };
  }

  function top_to_bottom() {
    // @CHART-12762: 地图缩放过程中, 点闪烁动画不好被暂停, 闪烁偏移根据当前缩放层级实时计算
    return function (t) {
      var pos = getPosition();
      var trans = layer._icon ? _BaseUtils["default"].makeTranslate3d({
        x: pos.x,
        y: pos.y - 25 * (1 - t)
      }) : _BaseUtils["default"].makeTranslate({
        x: pos.x,
        y: pos.y - 25 * (1 - t)
      });
      return trans + ' scale(' + initMarkerScale + ')';
    };
  }

  var nodeEle = layer._icon || layer._path.rawElement;
  new _Transition["default"]({
    node: function () {
      return nodeEle;
    }
  }, _Constants["default"].EFFECT_KEY) // .interrupt("point-map-effect")
  .ease(_BezierEasing["default"].css["ease-out-quint"]).duration(0.25 * period).styleTween('transform', bottom_to_top).attrTween('transform', bottom_to_top).transition().ease(_BezierEasing["default"].css["ease-in-quint"]).duration(0.25 * period).styleTween('transform', top_to_bottom).attrTween('transform', top_to_bottom).transition().ease(_BezierEasing["default"].css["ease-out-quint"]).duration(0.25 * period).styleTween('transform', bottom_to_top).attrTween('transform', bottom_to_top).transition().ease(_BezierEasing["default"].css["ease-in-quint"]).duration(0.25 * period).styleTween('transform', top_to_bottom).attrTween('transform', top_to_bottom);
  var initStyle = {
    'fill-opacity': 0,
    'fill': d.color
  };
  var layerGroup = d.effectGraphic = d.effectGraphic || new _LayerGroup["default"]().addTo(vanchart.getEffectLayer());

  function createEffectG() {
    return new _Path["default"]().addTo(layerGroup)._path.style(initStyle).attr('d', PATH);
  }

  var pos = getPosition();

  var trans = _BaseUtils["default"].makeTranslate({
    x: pos.x,
    y: pos.y
  }),
      initTrans = trans + ' scale(' + initCircleScale + ')';

  function ani(graphic, delay, time) {
    graphic.style(initStyle).attr('transform', initTrans);
    graphic.effectTransition().delay(delay).ease('linear').duration(time).attrTween('transform', function () {
      return function (t) {
        return trans + 'scale(' + (initCircleScale + initCircleScale * 1.4 * t) + ')';
      };
    }).styleTween('fill-opacity', function () {
      return function (t) {
        return 0.6 * (1 - t);
      };
    });
  }

  var firstG = layerGroup.firstG = layerGroup.firstG || createEffectG(),
      secondG = layerGroup.secondG = layerGroup.secondG || createEffectG(),
      thirdG = layerGroup.thirdG = layerGroup.thirdG || createEffectG();
  var scale = period / series.getDefaultEffectTime();
  ani(firstG, 0, 2000 * scale);
  ani(secondG, 600 * scale, 2000 * scale);
  ani(thirdG, 1200 * scale, 2000 * scale);
}

function isAreaStyleEffectChart(type) {
  return type === _Constants["default"].FUNNEL_CHART || type === _Constants["default"].MULTIPIE_CHART || type === _Constants["default"].PIE_CHART || type === _Constants["default"].COLUMN_RADAR || type === _Constants["default"].TREEMAP_CHART;
} //区域类型的，漏斗、饼、矩形树图


function areaStyleEffectAnimation(d, transX, transY) {
  var paras = _calculateParas(d, transX, transY);

  d.graphic //先注释掉,2017.2的代码一样的问题，应该和代码无关.
  //  .attr('transform-origin', 'center')
  .interrupt(_Constants["default"].SCALE_EXPAND_ANIMATION).interrupt(_Constants["default"].SCALE_MINIFY_ANIMATION);
  new _Transition["default"](d.graphic, _Constants["default"].SCALE_EXPAND_ANIMATION).ease(_BezierEasing["default"].css["ease-out-quad"]).duration(0.5 * paras.period).attrTween('filter', paras.firstTweenFun).attr('transform', paras.translate + 'scale(1.05)');
  new _Transition["default"](d.graphic, _Constants["default"].SCALE_MINIFY_ANIMATION).ease(_BezierEasing["default"].css["ease-in-quad"]).delay(0.5 * paras.period).duration(0.5 * paras.period).attrTween('filter', paras.secondTweenFun).attr('transform', paras.translate + 'scale(1)');
}

function areaMapEffectAnimation(layer, d) {
  var paras = _calculateParas(d);

  layer._path.style("filter", 'inherit') // 默认的style['filter']= "none"会导致阴影显示不出
  .effectTransition().ease(_BezierEasing["default"].css["ease-out-quad"]).duration(0.5 * paras.period).attrTween('filter', paras.firstTweenFun).style("fill-opacity", 0.5) // 也不是webkit才支持attr:,而是只有chrome和opera支持，见https://developer.mozilla.org/en-US/docs/Web/CSS/transform-origin
  .transition().ease(_BezierEasing["default"].css["ease-in-quad"]).duration(0.5 * paras.period).attrTween('filter', paras.secondTweenFun).style("fill-opacity", 1);
}

function _calculateParas(d, transX, transY) {
  var series = d.series,
      vanchart = series.vanchart,
      renderer = vanchart.renderer; // 排序的时候，直接更换的graphic，故这里的effectShadowFilter应该绑定在graphic上
  // 区域地图还是绑在d上

  var filterBind = d.graphic || d;
  filterBind.effectShadowFilter = filterBind.effectShadowFilter || renderer.createDropShadowFilter(3, 3, 0.75, 5, 91 / 255, 91 / 255, 91 / 255);
  var filterID = renderer.toPatternProperty(filterBind.effectShadowFilter);

  var period = series._getEffectTime(d);

  var translate = isNaN(transX) || isNaN(transY) ? '' : _BaseUtils["default"].makeTranslate({
    x: transX,
    y: transY
  });

  function firstTweenFun() {
    return function (t) {
      renderer && renderer.updateDropShadowFilter && renderer.updateDropShadowFilter(filterBind.effectShadowFilter, 3 * t, 3 * t, t * 0.75, t * 5, 91 / 255, 91 / 255, 91 / 255);
      return filterID;
    };
  }

  function secondTweenFun() {
    return function (t) {
      renderer && renderer.updateDropShadowFilter && renderer.updateDropShadowFilter(filterBind.effectShadowFilter, 3 * (1 - t), 3 * (1 - t), (1 - t) * 0.75, (1 - t) * 5, 91 / 255, 91 / 255, 91 / 255);
      return filterID;
    };
  }

  return {
    period: period,
    translate: translate,
    firstTweenFun: firstTweenFun,
    secondTweenFun: secondTweenFun
  };
}

function bubbleEffectAnimation(d, isMap) {
  forceBubbleEffectAnimation(d, null, isMap);
}

function forceBubbleEffectAnimation(d, trans, isMap) {
  var style = {
    'fill-opacity': 0,
    'stroke': 'none',
    'fill': d.color
  };

  var arc = _PathGenerator["default"].arc().innerRadius(d.radius).startAngle(0).endAngle(360);

  function path(t) {
    return arc({
      outerRadius: d.radius + t * d.radius * 1.5
    });
  }

  _markerStyleAnimation(d, {
    'isMap': isMap,
    'initStyle': style,
    'pathFun': path,
    'trans': trans
  });
}

function markerEffectAnimation(d, isMap) {
  var marker = d.options.marker;

  if (marker && marker.symbol) {
    var borderWidth = function (t) {
      return t * radius * 2.5;
    };

    var path = function (t) {
      return _PathGenerator["default"].getMarkerPath(markerType, radius + borderWidth(t) / 2 - 1);
    };

    var markerType = marker.symbol,
        radius = marker.radius;

    if (_BaseUtils["default"].isImageMarker(markerType)) {
      return;
    }

    var style = {
      'fill': 'none',
      'stroke': marker.fillColor,
      'stroke-width': 0,
      'stroke-opacity': 0
    };

    _markerStyleAnimation(d, {
      'isMap': isMap,
      'initStyle': style,
      'opacityKey': 'stroke-opacity',
      'pathFun': path,
      'borderFun': borderWidth
    });
  } else {
    _nullMarkerEffectAnimation(d, isMap);
  }
}

function _nullMarkerEffectAnimation(d, isMap) {
  var marker = d.options.marker,
      radius = marker.radius;
  var style = {
    'fill-opacity': 0,
    'stroke': 'none',
    'fill': marker.fillColor
  };

  var arc = _PathGenerator["default"].arc().innerRadius(0).startAngle(0).endAngle(360);

  function path(t) {
    return arc({
      outerRadius: t * radius * 3.5
    });
  }

  _markerStyleAnimation(d, {
    'isMap': isMap,
    'initStyle': style,
    'pathFun': path
  });
} //折线、气泡、散点等


function _markerStyleAnimation(d, options) {
  var series = d.series,
      vanchart = series.vanchart,
      renderer = vanchart.renderer;
  var initStyle = options.initStyle,
      trans = options.trans || {
    x: d.posX,
    y: d.posY
  };
  var group, createEffectGFun;

  if (options.isMap) {
    var latlng = d.getLatLng();
    trans = latlng && vanchart.latLngToLayerPoint(latlng) || {
      x: 0,
      y: 0
    };
    group = d.effectGraphic = d.effectGraphic || new _LayerGroup["default"]().addTo(vanchart.getEffectLayer());

    createEffectGFun = function createEffectG() {
      return new _Path["default"]().addTo(group)._path.style(initStyle).attr('transform', _BaseUtils["default"].makeTranslate(trans)).style('pointer-events', 'none');
    };
  } else {
    group = series._getPointEffectGroup(d).attr('transform', _BaseUtils["default"].makeTranslate(trans));

    createEffectGFun = function createEffectG() {
      return renderer.path().addTo(group).style(initStyle);
    };
  }

  function ani(graphic, delay, time) {
    graphic.style(initStyle).effectTransition().delay(delay).ease('linear').duration(time).styleTween('stroke-width', function () {
      return options.borderFun;
    }).styleTween(options.opacityKey || 'fill-opacity', function () {
      return function (t) {
        return 0.3 * (1 - t);
      };
    }).attrTween('d', function () {
      return options.pathFun;
    });
  }

  var firstG = group.firstG = group.firstG || createEffectGFun(),
      secondG = group.secondG = group.secondG || createEffectGFun(),
      thirdG = group.thirdG = group.thirdG || createEffectGFun();

  var period = series._getEffectTime(d),
      scale = period / series.getDefaultEffectTime();

  ani(firstG, 0, 1600 * scale);
  ani(secondG, 440 * scale, 1600 * scale);
  ani(thirdG, 880 * scale, 1600 * scale);
}

var _default = {
  MARKER_EFFECT_TIME: 2560,
  markerEffectAnimation: markerEffectAnimation,
  bubbleEffectAnimation: bubbleEffectAnimation,
  AREA_STYLE_EFFECT_TIME: 2000,
  areaStyleEffectAnimation: areaStyleEffectAnimation,
  isAreaStyleEffectChart: isAreaStyleEffectChart,
  areaMapEffectAnimation: areaMapEffectAnimation,
  POINT_MAP_EFFECT_TIME: 3200,
  pointMapEffectAnimation: pointMapEffectAnimation,
  forceBubbleEffectAnimation: forceBubbleEffectAnimation
};
exports["default"] = _default;

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Evented = _interopRequireDefault(__webpack_require__(13));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/1/20.
 */
var Layer = _Evented["default"].extend({
  options: {
    pane: 'overlayPane',
    nonBubblingEvents: []
  },
  addTo: function (map) {
    map.addLayer(this);
    return this;
  },
  remove: function () {
    return this.removeFrom(this._map || this._mapToAdd);
  },
  // @method removeFrom(map: Map): this
  // Removes the layer from the given map
  removeFrom: function (obj) {
    if (obj) {
      obj.removeLayer(this);
    }

    return this;
  },
  // 默认的移除layer的方法，需要移除动画的可以重写改方法
  exitAnimate: function (vanchart) {
    var layer = this,
        group = vanchart._pointLayer;
    group.remove(layer);
  },
  // @method getPane(name? : String): HTMLElement
  // Returns the `HTMLElement` representing the named pane on the map. If `name` is omitted, returns the pane for this layer.
  getPane: function (name) {
    return this._map.getPane(name ? this.options[name] || name : this.options.pane);
  },
  beforeAdd: function (map) {
    // Renderer is set here because we need to call renderer.getEvents
    // before this.getEvents.
    this._renderer = map.getMapRenderer(this);
  },
  _layerAdd: function (e) {
    var map = e.target; // check in case layer gets added and then removed before the map is ready

    if (!map.hasLayer(this)) {
      return;
    }

    this._map = map;
    this._zoomAnimated = map._zoomAnimated;

    if (this.getEvents) {
      var events = this.getEvents();
      map.on(events, this);
      this.once('remove', function () {
        map.off(events, this);
      }, this);
    }

    this.onAdd(map);
  },
  _reset: _BaseUtils["default"].falseFn,
  _project: _BaseUtils["default"].falseFn,
  _update: _BaseUtils["default"].falseFn,
  setAttr: _BaseUtils["default"].falseFn
});

var _default = Layer;
exports["default"] = _default;

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/1/19.
 */
var LatLng = function (lat, lng, alt) {
  if (isNaN(lat) || isNaN(lng)) {
    throw new Error('Invalid LatLng object: (' + lat + ', ' + lng + ')');
  }

  this.lat = +lat;
  this.lng = +lng;

  if (alt !== undefined) {
    this.alt = +alt;
  }
};

LatLng.prototype = {
  equals: function (obj, maxMargin) {
    if (!obj) {
      return false;
    }

    obj = LatLng.create(obj);
    var margin = Math.max(Math.abs(this.lat - obj.lat), Math.abs(this.lng - obj.lng));
    return margin <= (maxMargin === undefined ? 1.0E-9 : maxMargin);
  },
  toString: function (precision) {
    return 'LatLng(' + _BaseUtils["default"].formatNum(this.lat, precision) + ', ' + _BaseUtils["default"].formatNum(this.lng, precision) + ')';
  },
  distanceTo: function (other) {
    return L.CRS.Earth.distance(this, LatLng.create(other));
  },
  wrap: function () {
    return L.CRS.Earth.wrapLatLng(this);
  },
  clone: function () {
    return new LatLng(this.lat, this.lng, this.alt);
  }
};

LatLng.create = function (a, b, c) {
  if (a instanceof LatLng) {
    return a;
  }

  if (_BaseUtils["default"].isArray(a) && typeof a[0] !== 'object') {
    if (a.length === 3) {
      return new LatLng(a[0], a[1], a[2]);
    }

    if (a.length === 2) {
      return new LatLng(a[0], a[1]);
    }

    return null;
  }

  if (a === undefined || a === null) {
    return a;
  }

  if (typeof a === 'object' && 'lat' in a) {
    return new LatLng(a.lat, 'lng' in a ? a.lng : a.lon, a.alt);
  }

  if (b === undefined) {
    return null;
  }

  return new LatLng(a, b, c);
};

var _default = LatLng;
exports["default"] = _default;

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Point2D = _interopRequireDefault(__webpack_require__(15));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/1/19.
 */
var Bounds = function (a, b) {
  if (!a) {
    return;
  }

  var points = b ? [a, b] : a;

  for (var i = 0, len = points.length; i < len; i++) {
    this.extend(points[i]);
  }
};

Bounds.prototype = {
  // @method extend(point: Point): this
  // Extends the bounds to contain the given point.
  extend: function (point) {
    // (Point)
    point = _Point2D["default"].create(point); // @property min: Point
    // The top left corner of the rectangle.
    // @property max: Point
    // The bottom right corner of the rectangle.

    if (!this.min && !this.max) {
      this.min = point.clone();
      this.max = point.clone();
    } else {
      this.min.x = Math.min(point.x, this.min.x);
      this.max.x = Math.max(point.x, this.max.x);
      this.min.y = Math.min(point.y, this.min.y);
      this.max.y = Math.max(point.y, this.max.y);
    }

    return this;
  },
  // @method getCenter(round?: Boolean): Point
  // Returns the center point of the bounds.
  getCenter: function (round) {
    return new _Point2D["default"]((this.min.x + this.max.x) / 2, (this.min.y + this.max.y) / 2, round);
  },
  // @method getBottomLeft(): Point
  // Returns the bottom-left point of the bounds.
  getBottomLeft: function () {
    return new _Point2D["default"](this.min.x, this.max.y);
  },
  // @method getTopRight(): Point
  // Returns the top-right point of the bounds.
  getTopRight: function () {
    // -> Point
    return new _Point2D["default"](this.max.x, this.min.y);
  },
  // @method getSize(): Point
  // Returns the size of the given bounds
  getSize: function () {
    return this.max.subtract(this.min);
  },
  // @method contains(otherBounds: Bounds): Boolean
  // Returns `true` if the rectangle contains the given one.
  // @alternative
  // @method contains(point: Point): Boolean
  // Returns `true` if the rectangle contains the given point.
  contains: function (obj) {
    var min, max;

    if (typeof obj[0] === 'number' || obj instanceof _Point2D["default"]) {
      obj = _Point2D["default"].create(obj);
    } else {
      obj = Bounds.create(obj);
    }

    if (obj instanceof Bounds) {
      min = obj.min;
      max = obj.max;
    } else {
      min = max = obj;
    }

    return min.x >= this.min.x && max.x <= this.max.x && min.y >= this.min.y && max.y <= this.max.y;
  },
  // @method intersects(otherBounds: Bounds): Boolean
  // Returns `true` if the rectangle intersects the given bounds. Two bounds
  // intersect if they have at least one point in common.
  intersects: function (bounds) {
    // (Bounds) -> Boolean
    bounds = Bounds.create(bounds);
    var min = this.min,
        max = this.max,
        min2 = bounds.min,
        max2 = bounds.max,
        xIntersects = max2.x >= min.x && min2.x <= max.x,
        yIntersects = max2.y >= min.y && min2.y <= max.y;
    return xIntersects && yIntersects;
  },
  // @method overlaps(otherBounds: Bounds): Boolean
  // Returns `true` if the rectangle overlaps the given bounds. Two bounds
  // overlap if their intersection is an area.
  overlaps: function (bounds) {
    // (Bounds) -> Boolean
    bounds = Bounds.create(bounds);
    var min = this.min,
        max = this.max,
        min2 = bounds.min,
        max2 = bounds.max,
        xOverlaps = max2.x > min.x && min2.x < max.x,
        yOverlaps = max2.y > min.y && min2.y < max.y;
    return xOverlaps && yOverlaps;
  },
  isValid: function () {
    return !!(this.min && this.max);
  }
};

Bounds.create = function (a, b) {
  if (!a || a instanceof Bounds) {
    return a;
  }

  return new Bounds(a, b);
};

var _default = Bounds;
exports["default"] = _default;

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Class = _interopRequireDefault(__webpack_require__(29));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by Yuqian on 2017/7/12.
 */
var _default = _Class["default"].extend({
  initialize: function (renderer) {
    this.renderer = renderer;
    this.ctx = renderer.ctx;
    this.cut = null;

    this._initialize(renderer);
  },
  setStyle: function (style) {
    for (var prop in this.style) {
      if (style.hasOwnProperty(prop)) {
        this.style[prop] = style[prop];
      }
    }

    return this;
  },
  drawStyle: function () {
    var s = this.style;
    this.renderer.lineWidth(s.lineWidth);
    this.renderer.strokeStyle(s.strokeStyle);
    this.renderer.fillStyle(s.fillStyle);
    this.renderer.beginNewPath();
    return this;
  },
  contain: function () {},
  animate: function () {
    if (!this.cut) {
      this.cut = this.renderer.animation.animate(this.style);
    }

    return this;
  },
  // mixin ?
  delay: function (time) {
    this.cut.delay(time);
    return this;
  },
  duration: function (time) {
    this.cut.duration(time);
    return this;
  },
  tween: function (key, v) {
    this.cut.tween(key, v);
    return this;
  },
  end: function (f) {
    this.cut.end(f);
    return this;
  },
  stop: function () {
    this.cut.stop();
    return this;
  },
  ease: function (easing) {
    this.cut.ease(easing);
    return this;
  },
  remove: function () {
    this.cut && this.cut.stop();
    this.needToRemove = true;
  }
});

exports["default"] = _default;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.createCanvasRenderer = void 0;

var _SvgRenderer = _interopRequireDefault(__webpack_require__(121));

var _VmlRenderer = _interopRequireDefault(__webpack_require__(75));

var _CanvasRenderer = _interopRequireDefault(__webpack_require__(79));

var _EnvUtils = __webpack_require__(3);

var _ExportCanvasRenderer = __webpack_require__(134);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// import FineCanvasRenderer from "./FineCanvasRenderer";
var createRenderer = function (dom, chart) {
  // if(__export__) {
  //     return new FineCanvasRenderer(dom, chart);
  // }
  return (0, _EnvUtils.isSupportSVG)() ? new _SvgRenderer["default"](dom, chart) : new _VmlRenderer["default"](dom, chart);
};

var createCanvasRenderer = function (dom, chart, config) {
  return  false ? undefined : new _CanvasRenderer["default"](dom, chart, config);
};

exports.createCanvasRenderer = createCanvasRenderer;
var _default = createRenderer;
exports["default"] = _default;

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getThemeAutoValue = getThemeAutoValue;
exports.fixOptionsWithTheme = fixOptionsWithTheme;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _CoreUtils = __webpack_require__(2);

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _mapUtils = __webpack_require__(31);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var THEME_CONFIG = {
  // 地图
  mapTileLayer: {
    light: 'http://webrd01.is.autonavi.com/appmaptile?lang=zh_cn&size=1&scale=1&style=8&x={x}&y={y}&z={z}',
    dark: 'http://map.geoq.cn/ArcGIS/rest/services/ChinaOnlineStreetPurplishBlue/MapServer/tile/{z}/{y}/{x}'
  },
  mapTileLayerOptions: {
    light: {
      minZoom: 3,
      maxZoom: 18
    },
    dark: {
      minZoom: 0,
      maxZoom: 16
    }
  },
  nullColor: {
    light: 'rgba(204,204,204,0.75)',
    dark: 'rgba(168,168,168,0.75)'
  },
  mapBorderColor: {
    light: '#B2B2B2',
    dark: '#707070'
  },
  mapLegendBackgroundColor: {
    light: 'rgba(255,255,255,0.9)',
    dark: 'rgba(0,0,0,0.9)'
  },
  mapTitleBackgroundColor: {
    light: 'rgba(255,255,255,0.75)',
    dark: 'rgba(0,0,0,0.75)'
  },
  // 仪表盘
  hinge: {
    light: '#656B6D',
    dark: 'rgba(255,255,255,0)'
  },
  pointerPaneBackgroundColor: {
    light: '#FFFFFF',
    dark: 'rgba(255,255,255,0)'
  },
  paneBackgroundColor: {
    light: '#ECECEC',
    dark: '#48494F'
  },
  gaugeLabelColor: {
    light: '#444444',
    dark: '#E8E8E8'
  },
  pointBorderColor: {
    light: '#FFFFFF',
    dark: '#000000'
  },
  dToolItemBackground: {
    light: 'rgba(255,255,255,1)',
    dark: 'rgba(0,0,0,0.8)'
  },
  markerStrokeColor: {
    light: '#FFFFFF',
    dark: '#000000'
  }
};

function getThemeAutoValue(opt, name, isDarkTheme) {
  if (opt !== _Constants["default"].AUTO) {
    return opt;
  }

  return isDarkTheme ? THEME_CONFIG[name].dark : THEME_CONFIG[name].light;
}

function fixTileLayerOptions(geo, name, isDarkTheme) {
  if (geo.tileLayerOptions && !(0, _CoreUtils.isEmptyObj)(geo.tileLayerOptions)) {
    return geo.tileLayerOptions;
  }

  if (geo.tileLayer === _Constants["default"].AUTO) {
    return isDarkTheme ? THEME_CONFIG[name].dark : THEME_CONFIG[name].light;
  }

  if (geo.tileLayer === THEME_CONFIG['mapTileLayer'].dark) {
    return THEME_CONFIG[name].dark;
  } else if (geo.tileLayer === THEME_CONFIG['mapTileLayer'].light) {
    return THEME_CONFIG[name].light;
  }

  return {};
}

function _convertAMapLayer2TileLayerIElt10(geo, isDarkTheme) {
  var isIElt10 = _Browser["default"].ie9 || _Browser["default"].ielt9;

  if (isIElt10 && (0, _mapUtils.isAMapLayer)({
    geo: geo
  })) {
    geo.tileLayer = isDarkTheme ? THEME_CONFIG['mapTileLayer'].dark : THEME_CONFIG['mapTileLayer'].light;
    geo.tileLayerOptions = isDarkTheme ? THEME_CONFIG['mapTileLayerOptions'].dark : THEME_CONFIG['mapTileLayerOptions'].light;
    geo.attribution = "<a><img src=\"http://webapi.amap.com/theme/v1.3/mapinfo_05.png\" width=\"67\" height=\"16\">&copy; 2016 AutoNavi</a>";
    geo.aMapLayer = null;
  }
}

function fixMapOptionsWithTheme(options) {
  var isDarkTheme = options.theme === _Constants["default"].DARK;

  if ((0, _CoreUtils.hasDefined)(options.geo.tileLayer)) {
    options.geo.tileLayer = getThemeAutoValue(options.geo.tileLayer, 'mapTileLayer', isDarkTheme);
    options.geo.tileLayerOptions = fixTileLayerOptions(options.geo, 'mapTileLayerOptions', isDarkTheme);
  }

  if (options.legend && options.legend.backgroundColor) {
    options.legend.backgroundColor = getThemeAutoValue(options.legend.backgroundColor, 'mapLegendBackgroundColor', isDarkTheme);
  }

  if (options.rangeLegend && options.rangeLegend.backgroundColor) {
    options.rangeLegend.backgroundColor = getThemeAutoValue(options.rangeLegend.backgroundColor, 'mapLegendBackgroundColor', isDarkTheme);
  }

  if (options.title && options.title.backgroundColor) {
    options.title.backgroundColor = getThemeAutoValue(options.title.backgroundColor, 'mapTitleBackgroundColor', isDarkTheme);
  }

  if (options.dTools) {
    options.dTools.backgroundColor = getThemeAutoValue(options.dTools.backgroundColor, 'dToolItemBackground', isDarkTheme);
  }

  var plotOptions = options.plotOptions;
  var areaMap = plotOptions.areaMap || {};
  var nullColor = areaMap.nullColor || plotOptions.nullColor;
  var borderColor = areaMap.borderColor || plotOptions.borderColor;

  if (!(0, _CoreUtils.isEmptyObj)(areaMap)) {
    areaMap.nullColor = getThemeAutoValue(nullColor, 'nullColor', isDarkTheme);
    areaMap.borderColor = getThemeAutoValue(borderColor, 'mapBorderColor', isDarkTheme);
  } else if (nullColor || borderColor) {
    plotOptions.nullColor = getThemeAutoValue(nullColor, 'nullColor', isDarkTheme);
    plotOptions.borderColor = getThemeAutoValue(borderColor, 'mapBorderColor', isDarkTheme);
  }

  _convertAMapLayer2TileLayerIElt10(options.geo, isDarkTheme);

  return options;
}

function fixOptionsWithTheme(vanchart, options) {
  if (vanchart.isMap()) {
    return fixMapOptionsWithTheme(options);
  }
}

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateCustomLabel = calculateCustomLabel;
exports.defaultLabelContent = defaultLabelContent;
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _FormattedText = __webpack_require__(39);

var _dataLabelStyle = __webpack_require__(137);

var _richTextDetail = __webpack_require__(47);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function valid(point, dataLabels) {
  dataLabels = dataLabels || point && point.options && point.options.dataLabels;
  var hasDataLabels = dataLabels && dataLabels.enabled && dataLabels.formatter;
  return point.series.vanchart.isMap() ? hasDataLabels : hasDataLabels && point.isVisible();
}

function calculateDataLabel(point, dataLabels) {
  // 如果判断不通过直接return的话，那么图表里再计算的时候，都要判断过滤一下points，找了一下发现有点多，没敢那么改，怕出岔子
  if (!valid(point, dataLabels)) {
    point.labelDim = {
      width: 0,
      height: 0
    };
    point.labelContent = [];
    return;
  }

  dataLabels = dataLabels || point.options.dataLabels;
  var formatter = dataLabels.formatter;
  point.labelContent = typeof formatter == 'object' ? calculateNormalLabel(point, dataLabels) : calculateCustomLabel(point, dataLabels);
  var textDim = dataLabels.useRichText ? (0, _richTextDetail.getRichTextDim)(point.labelContent) : (0, _FormattedText.calculateTextDim)(point.labelContent, point);
  var width = textDim.width,
      height = textDim.height,
      _textDim$nameValueGap = textDim.nameValueGap,
      nameValueGap = _textDim$nameValueGap === void 0 ? 0 : _textDim$nameValueGap;
  point.labelDim = {
    width: width,
    height: height,
    nameValueGap: nameValueGap,
    innerTextDim: textDim
  };
}

function calculateCustomLabel(point, dataLabels) {
  dataLabels = dataLabels || point.options.dataLabels;
  var formatter = dataLabels.formatter;
  var text = "";

  try {
    // 用户自定义的，里面极有可能有抛错，如window.FR.contentFormat
    text += _BaseUtils["default"].getFormatterFunction(formatter).call(point);
  } catch (e) {}

  var style = fixCustomLabelsStyle(point, dataLabels);
  var useHtml = point.series.vanchart.isMap() ? true : dataLabels.useHtml;

  var dim = _BaseUtils["default"].getTextDimension(text, style, useHtml);

  if (dataLabels.useHtml) {
    dim.width = isNaN(parseFloat(dataLabels.labelWidth)) ? dim.width : parseFloat(dataLabels.labelWidth);
    dim.height = isNaN(parseFloat(dataLabels.labelHeight)) ? dim.height : parseFloat(dataLabels.labelHeight);
  }

  return [{
    text: text,
    style: style,
    dim: dim
  }];
}

function fixCustomLabelsStyle(point, dataLabels) {
  var style = dataLabels.style || (0, _dataLabelStyle.defaultValueStyle)(point);

  if (point.series.isSupportVerticalLabel() && dataLabels.orientation && dataLabels.orientation === _Constants["default"].VERTICAL_LAYOUT) {
    style = _BaseUtils["default"].extend({}, style, {
      'writingMode': 'tb-rl',
      'writing-mode': 'tb-rl',
      '-webkit-writing-mode': 'vertical-rl'
    });
  }

  return style;
}

function calculateNormalLabel(point, dataLabels) {
  var series = point.series,
      type = series.type;

  if (dataLabels && dataLabels.useRichText) {
    return (0, _richTextDetail.getLabelRichTextDetail)(point, dataLabels.richText, dataLabels.autoStyle, dataLabels.formatter);
  }

  if (series.vanchart.isMap()) {
    return calculateMapLabel(point, dataLabels);
  }

  if (type === _Constants["default"].BUBBLE_CHART || type === _Constants["default"].SCATTER_CHART) {
    return bubbleLabelContent(point);
  } else if (type === _Constants["default"].FUNNEL_CHART) {
    return funnelLabelContent(point);
  } else if (type === _Constants["default"].COLUMN_CHART) {
    return columnLabelContent(point);
  } else {
    return defaultLabelContent(point, dataLabels);
  }
}

function columnLabelContent(point) {
  var dataLabels = point.options.dataLabels;
  var formatter = dataLabels.formatter;
  var orientation = dataLabels.orientation;
  var identifier = formatter.identifier;

  if (orientation && orientation === _Constants["default"].VERTICAL_LAYOUT) {
    var style = _BaseUtils["default"].extend({
      'writingMode': 'tb-rl',
      'writing-mode': 'tb-rl',
      '-webkit-writing-mode': 'vertical-rl'
    }, (0, _dataLabelStyle.defaultValueStyle)(point, dataLabels));

    var fields = [];
    [_FormattedText.CATEGORY, _FormattedText.SERIES, _FormattedText.VALUE, _FormattedText.PERCENT].forEach(function (id) {
      if (identifier.indexOf(id) !== -1) {
        var prop = _FormattedText.propMap[id];

        if (prop && prop.length === 2) {
          var propKey = prop[0],
              fmtKey = prop[1];
          fields.push(_BaseUtils["default"].format(point[propKey], formatter[fmtKey]));
        }
      }
    });
    var text = fields.join(_Constants["default"].BLANK_VALUE_PERCENTAGE);

    var dim = _BaseUtils["default"].getTextDimension(text, style, false);

    return [{
      text: text,
      style: style,
      dim: dim
    }];
  }

  return defaultLabelContent(point, dataLabels);
}

function bubbleLabelContent(point) {
  var dataLabels = point.options.dataLabels,
      formatter = dataLabels.formatter,
      identifier = formatter.identifier;
  var content = [];

  if (identifier.indexOf(_FormattedText.DESCRIPTION) != -1) {
    var descriptionStyle = dataLabels.style || (0, _dataLabelStyle.defaultCategoryStyle)(point);

    var descriptionDim = _BaseUtils["default"].getTextDimension(point.options.description, descriptionStyle, dataLabels.useHtml);

    content.push({
      text: point.options.description,
      style: descriptionStyle,
      dim: descriptionDim
    });
  }

  if (identifier.indexOf(_FormattedText.SERIES) != -1) {
    var seriesString = _BaseUtils["default"].format(point.seriesName, formatter.seriesFormat);

    var seriesStyle = dataLabels.style || (0, _dataLabelStyle.defaultCategoryStyle)(point);

    var seriesDim = _BaseUtils["default"].getTextDimension(seriesString, seriesStyle, dataLabels.useHtml);

    content.push({
      text: seriesString,
      style: seriesStyle,
      dim: seriesDim
    });
  }

  if (identifier.indexOf(_FormattedText.X) != -1 || identifier.indexOf(_FormattedText.Y) != -1 || identifier.indexOf(_FormattedText.SIZE) != -1) {
    var text = (0, _FormattedText.getXYSizeString)(point, formatter, identifier);
    var style = dataLabels.style || (0, _dataLabelStyle.defaultValueStyle)(point);

    var dim = _BaseUtils["default"].getTextDimension(text, style, dataLabels.useHtml);

    content.push({
      text: text,
      style: style,
      dim: dim
    });
  }

  return content;
}

function funnelLabelContent(point) {
  var dataLabels = point.options.dataLabels,
      formatter = dataLabels.formatter,
      identifier = formatter.identifier;

  if (dataLabels.align == _Constants["default"].INSIDE) {
    return defaultLabelContent(point);
  }

  var funnel = point.series,
      content = [];

  if (identifier.indexOf(_FormattedText.NAME) != -1) {
    var nameString = _BaseUtils["default"].format(point.name, formatter.nameFormat);

    var nameStyle = (0, _dataLabelStyle.defaultCategoryStyle)(point);

    var nameDim = _BaseUtils["default"].getTextDimension(nameString, nameStyle, dataLabels.useHtml);

    content.nameLabelContent = {
      text: nameString,
      style: nameStyle,
      dim: nameDim
    };

    if (!funnel.maxNameLabelWidth) {
      funnel.maxNameLabelWidth = 0;
    }

    funnel.maxNameLabelWidth = Math.max(funnel.maxNameLabelWidth, nameDim.width);
  }

  if (identifier.indexOf(_FormattedText.VALUE) != -1 || identifier.indexOf(_FormattedText.PERCENT) != -1 || identifier.indexOf(_FormattedText.ARRIVALRATE) != -1) {
    var items = [];

    if (identifier.indexOf(_FormattedText.VALUE) != -1) {
      items.push(_BaseUtils["default"].format(point.originalValue, formatter.valueFormat));
    }

    if (identifier.indexOf(_FormattedText.PERCENT) != -1) {
      items.push(_BaseUtils["default"].format(point.percentage, formatter.percentFormat));
    }

    if (identifier.indexOf(_FormattedText.ARRIVALRATE) != -1) {
      items.push(_BaseUtils["default"].format(point.arrivalRate, formatter.arrivalRateFormat));
    }

    var text = items.join(_Constants["default"].BLANK_VALUE_PERCENTAGE);
    var style = (0, _dataLabelStyle.defaultValueStyle)(point);

    var dim = _BaseUtils["default"].getTextDimension(text, style, dataLabels.useHtml);

    content.valueLabelContent = {
      text: text,
      style: style,
      dim: dim
    };

    if (!funnel.maxValueLabelWidth) {
      funnel.maxValueLabelWidth = 0;
    }

    funnel.maxValueLabelWidth = Math.max(funnel.maxValueLabelWidth, dim.width);
  }

  return content;
}

function defaultLabelContent(point, dataLabels) {
  dataLabels = dataLabels || point.options.dataLabels;
  var series = point.series,
      formatter = dataLabels.formatter,
      identifier = formatter.identifier;
  var names = [_FormattedText.NAME, _FormattedText.CATEGORY, _FormattedText.SERIES],
      values = [_FormattedText.VALUE, _FormattedText.PERCENT, _FormattedText.ARRIVALRATE, _FormattedText.LEVEL];
  var cateStyleFun = _dataLabelStyle.defaultCategoryStyle,
      valueStyleFun = _dataLabelStyle.defaultValueStyle; // adjust the sequence and style here

  if (series.type === _Constants["default"].TREEMAP_CHART) {
    values.unshift(names.shift());
    valueStyleFun = cateStyleFun;
  } else if (series.type === _Constants["default"].GANTT_CHART) {
    names = [];
    values = [_FormattedText.PROCESSES, _FormattedText.SERIES, _FormattedText.STARTTIME, _FormattedText.FINISHTIME, _FormattedText.DURATION, _FormattedText.PROGRESS];
  } else if (series.type === _Constants["default"].BAR_CHART && dataLabels.align === _Constants["default"].AUTO) {
    names = names.filter(function (name) {
      return identifier.indexOf(name) !== -1;
    });
    values = values.filter(function (value) {
      return identifier.indexOf(value) !== -1;
    });

    if (names.length === 1 && values.length === 1) {
      names = [];
      values = [_FormattedText.CATEGORY, _FormattedText.SERIES, _FormattedText.VALUE, _FormattedText.PERCENT];
    }
  }

  var content = [];
  addContent(content, getContentItems(names), cateStyleFun);
  addContent(content, getContentItems(values), valueStyleFun);

  function getContentItems(items) {
    return items.map(fmtStr).filter(clean);
  }

  function fmtStr(item) {
    if (identifier.indexOf(item) !== -1) {
      var propKey = _FormattedText.propMap[item][0];
      var fmtKey = _FormattedText.propMap[item][1];
      var value = point[propKey];

      var fmt = formatter[fmtKey] || series._getLabelFormatFn && series._getLabelFormatFn(propKey);

      var str = _BaseUtils["default"].format(value, fmt);

      return series._postLabel ? series._postLabel(str, propKey) : str;
    }

    return null;
  }

  function clean(item) {
    return item !== null;
  }

  function addContent(content, items, styleFun) {
    if (!items.length) {
      return;
    }

    var text = items.join(_Constants["default"].BLANK_VALUE_PERCENTAGE);
    var style = styleFun(point, dataLabels);

    var dim = _BaseUtils["default"].getTextDimension(text, style, dataLabels.useHtml);

    content.push({
      text: text,
      style: style,
      dim: dim
    });
  }

  return content;
}

function calculateMapLabel(point, dataLabels) {
  if (!point || !dataLabels || !dataLabels.enabled) {
    return {};
  } // CHART-14818 地图的TextLayer默认为Html标签显示，为了统一计算与渲染时标签尺寸一致，所以在计算标签尺寸时useHtml也默认为true


  var formatter = dataLabels.formatter,
      useHtml = true;
  var content = [];

  if (typeof formatter == 'object') {
    var label = formatter.identifier;

    if (label.indexOf(_FormattedText.NAME) != -1) {
      var text = _BaseUtils["default"].format(point.name, formatter.areaNameFormat);

      var style = (0, _dataLabelStyle.defaultCategoryStyle)(point, dataLabels);

      var dim = _BaseUtils["default"].getTextDimension(text, style, useHtml);

      content.push({
        text: text,
        style: style,
        dim: dim
      });
    }

    var line = '';
    var hasSeries = label.indexOf(_FormattedText.SERIES) != -1,
        hasValue = label.indexOf(_FormattedText.VALUE) != -1 || label.indexOf(_FormattedText.SIZE) != -1,
        hasPercent = label.indexOf(_FormattedText.PERCENT) != -1;

    var seriesLabel = _BaseUtils["default"].format(point.seriesName, formatter.seriesFormat);

    var valueLabel = _BaseUtils["default"].format(point.originalValue, formatter.valueFormat);

    var percentLabel = _BaseUtils["default"].format(point.percentage, formatter.percentFormat);

    if (hasSeries) {
      line += seriesLabel;

      if (hasValue || hasPercent) {
        line += ':';
      }
    }

    if (hasValue) {
      line += valueLabel;

      if (hasPercent) {
        line += ' ';
      }
    }

    if (hasPercent) {
      line += percentLabel;
    }

    if (line) {
      var style = (0, _dataLabelStyle.defaultValueStyle)(point, dataLabels);

      var dim = _BaseUtils["default"].getTextDimension(line, style, useHtml);

      content.push({
        text: line,
        style: style,
        dim: dim
      });
    }
  }

  return content;
}

var _default = calculateDataLabel;
exports["default"] = _default;

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/8/7.
 */
//管理标签位置
function BoundsManager() {
  this.addedBounds = [];
}

BoundsManager.prototype = {
  constructor: BoundsManager,
  addBounds: function (bounds) {
    this.addedBounds.push(bounds);
  },
  isValidBounds: function (bounds) {
    return bounds.width > 0 && bounds.height > 0;
  },
  isOverlapped: function (bounds) {
    for (var i = 0, len = this.addedBounds.length; i < len; i++) {
      if (_BaseUtils["default"].rectangleOverlapped(bounds, this.addedBounds[i])) {
        return true;
      }
    }

    return false;
  },
  calculateOverlapRate: function () {
    var remaining = _BaseUtils["default"].clone(this.addedBounds),
        total = remaining.length,
        indexMap = {},
        i,
        j,
        len,
        max = 0,
        index = -1,
        remove = 0,
        target;

    for (i = 0, len = remaining.length; i < len; i++) {
      for (j = i + 1; j < len; j++) {
        if (_BaseUtils["default"].rectangleOverlapped(remaining[i], remaining[j])) {
          indexMap[i] = indexMap[i] || [];
          indexMap[j] = indexMap[j] || [];
          indexMap[i].push(j);
          indexMap[j].push(i);

          if (indexMap[i].length > max) {
            max = indexMap[i].length;
            index = i;
          }

          if (indexMap[j].length > max) {
            max = indexMap[j].length;
            index = j;
          }
        }
      }
    }

    while (max) {
      remove++;

      for (i = 0, len = indexMap[index].length; i < len; i++) {
        target = indexMap[indexMap[index][i]];
        target.splice(target.indexOf(index), 1);
      }

      indexMap[index] = [];
      max = 0;

      for (i in indexMap) {
        if (indexMap[i].length > max) {
          max = indexMap[i].length;
          index = i;
        }
      }
    }

    return total === 0 ? 0 : remove / total;
  },
  isEmpty: function () {
    return this.addedBounds.length === 0;
  }
};
var _default = BoundsManager;
exports["default"] = _default;

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Class = _interopRequireDefault(__webpack_require__(29));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by Jeffrey on 2018/7/5.
 */
var _default = _Class["default"].extend({
  z: 0,
  initialize: function (handler) {
    this.init(handler);
  },
  init: function (handler) {
    this.vanchart = handler.vanchart;
    this.handler = handler;
    this.parent = handler;
  },
  contain: function (p) {
    return _BaseUtils["default"].containsPoint(this.getBoundingRect(), p);
  },
  getBoundingRect: function () {},
  getActions: function () {
    return {};
  }
});

exports["default"] = _default;

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 16/5/26.
 *
 * try to use Behavior Delegation
 */
function Class() {}

;

Class.extend = function (props) {
  // @function extend(props: Object): Function
  // [Extends the current class](#class-inheritance) given the properties to be included.
  // Returns a Javascript function that is a class constructor (to be called with `new`).
  var NewClass = function () {
    // call the constructor
    if (this.initialize) {
      this.initialize.apply(this, arguments);
    } // call all constructor hooks


    this.callInitHooks();
  };

  var parentProto = NewClass.__super__ = this.prototype;
  var proto = Object.create(parentProto);
  proto.constructor = NewClass;
  NewClass.prototype = proto; // inherit parent's statics

  for (var i in this) {
    if (this.hasOwnProperty(i) && i !== 'prototype') {
      NewClass[i] = this[i];
    }
  } // // merge options


  if (proto.options) {
    props.options = _BaseUtils["default"].extend(Object.create(proto.options), props.options);
  } // mix given properties into the prototype


  _BaseUtils["default"].extend(proto, props);

  proto._initHooks = []; // add method for calling all hooks

  proto.callInitHooks = function () {
    if (this._initHooksCalled) {
      return;
    }

    if (parentProto.callInitHooks) {
      parentProto.callInitHooks.call(this);
    }

    this._initHooksCalled = true;

    for (var i = 0, len = proto._initHooks.length; i < len; i++) {
      proto._initHooks[i].call(this);
    }
  };

  return NewClass;
};

Class.include = function (props) {
  _BaseUtils["default"].extend(this.prototype, props);

  return this;
}; // @function addInitHook(fn: Function)
// Adds a [constructor hook](#class-constructor-hooks) to the class.


Class.addInitHook = function (fn) {
  // (Function) || (String, args...)
  var args = Array.prototype.slice.call(arguments, 1);
  var init = typeof fn === 'function' ? fn : function () {
    this[fn].apply(this, args);
  };
  this.prototype._initHooks = this.prototype._initHooks || [];

  this.prototype._initHooks.push(init);

  return this;
};

var _default = Class;
exports["default"] = _default;

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllMapPoints = getAllMapPoints;
exports.areaPointMapValidPoints = areaPointMapValidPoints;
exports.mapPointsWithRangeLegend = mapPointsWithRangeLegend;
exports.areaPointMapPointsWithRangeLegend = areaPointMapPointsWithRangeLegend;
exports.getHeatMapPoints = getHeatMapPoints;
exports.getLineMapPoints = getLineMapPoints;
exports.areaMapPointsWithNormalLegend = areaMapPointsWithNormalLegend;
exports.pointMapPointsWithNormalLegend = pointMapPointsWithNormalLegend;
exports.areaPointMapPointsWithNormalLegend = areaPointMapPointsWithNormalLegend;
exports.pointMapLargeModePoints = pointMapLargeModePoints;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _component = __webpack_require__(4);

var _mapUtils = __webpack_require__(31);

var _util = __webpack_require__(82);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function getAllMapPoints(vanchart) {
  var areaPointMapPoints = areaPointMapValidPoints(vanchart);
  var heatMapPoints = getHeatMapPoints(vanchart);
  var lineMapPoints = getLineMapPoints(vanchart);
  return areaPointMapPoints.concat(heatMapPoints).concat(lineMapPoints);
}

function areaPointMapValidPoints(vanchart) {
  var isNormalLegend = vanchart.getComponent(_component.ComponentCst.LEGEND_COMPONENT);
  return isNormalLegend ? areaPointMapPointsWithNormalLegend(vanchart) : areaPointMapPointsWithRangeLegend(vanchart).filter(function (point) {
    return point.visible;
  });
}
/**
 * 计算地图范围图例的最大最小值时需要的points:
 * 1、区域地图每个区域名的第一个系列中的点
 * 2、点地图、热力地图每个经纬度下的第一个系列中的点
 * 3、流向地图所有系列的点
 */


function mapPointsWithRangeLegend(geo, series) {
  var mapPoints = [],
      areaKeyMap = {},
      lngLatKeyMap = {};
  series.forEach(function (ser) {
    var type = ser.type;
    var isAreaMap = type === _Constants["default"].AREA_MAP;
    var isLineMap = type === _Constants["default"].LINE_MAP;
    ser.points.forEach(function (point) {
      var name = point.name;
      var features = geo.getFeaturesByName(name, type);

      if (isLineMap) {
        mapPoints.push(point);
      } else if (isAreaMap) {
        if (!areaKeyMap[name] && features) {
          mapPoints.push(point);
        }

        areaKeyMap[name] = true;
      } else {
        var lngLatArr = geo.getDataPointLngLat(point, features && features[0]);
        var lngLat = lngLatArr && lngLatArr.join('-');

        if (!lngLatKeyMap[lngLat] && lngLat) {
          mapPoints.push(point);
        }

        lngLatKeyMap[lngLat] = true;
      }
    });
  });
  return mapPoints;
}
/**
 * 范围图例：区域地图、点地图
 * @param vanchart
 * @returns {*[]}
 */


function areaPointMapPointsWithRangeLegend(vanchart) {
  var geo = vanchart.getCurrentGeo();
  var series = vanchart.series;
  return mapPointsWithRangeLegend(geo, series).filter(function (point) {
    var type = point.series.type;
    return type !== _Constants["default"].LINE_MAP && type !== _Constants["default"].HEAT_MAP;
  }).reverse();
}
/**
 * 热力地图
 * @param vanchart
 * @returns {*[]}
 */


function getHeatMapPoints(vanchart) {
  var geo = vanchart.getCurrentGeo();
  var series = vanchart.series;
  var heatMapPoints = mapPointsWithRangeLegend(geo, (0, _util.seriesOfType)(series, _Constants["default"].HEAT_MAP));
  return heatMapPoints;
}
/**
 * 流向地图
 * @param vanchart
 * @returns {*[]}
 */


function getLineMapPoints(vanchart) {
  var lineMapSeries = vanchart.seriesOfType(_Constants["default"].LINE_MAP);
  return lineMapSeries.reduce(function (accum, seriesItems) {
    return accum.concat(seriesItems.points);
  }, []);
}
/**
 * 普通图例：区域地图
 */


function areaMapPointsWithNormalLegend(geo, series) {
  var mapPoints = [],
      areaKeyMap = {};
  var showSeries = series.filter(function (ser) {
    return ser.type === _Constants["default"].AREA_MAP && ser.visible;
  });
  showSeries.forEach(function (ser) {
    var type = ser.type,
        points = ser.points;

    for (var i = 0; i < points.length; i++) {
      var point = points[i];
      var name = point.name;
      var features = geo.getFeaturesByName(name, type);

      if (point.isNull && !point.options.drilldown) {
        continue;
      }

      if (!areaKeyMap[name] && features) {
        mapPoints.push(point);
      }

      areaKeyMap[name] = true;
    }
  });
  return mapPoints.reverse();
}
/**
 * 普通图例：点地图
 */


function pointMapPointsWithNormalLegend(geo, series) {
  var mapPoints = [],
      lngLatKeyMap = {};
  var showPointSeries = series.filter(function (ser) {
    return (0, _mapUtils.isPointMap)(ser.type) && ser.visible;
  });
  showPointSeries.forEach(function (ser) {
    var type = ser.type,
        points = ser.points;

    for (var i = 0; i < points.length; i++) {
      var point = points[i];
      var name = point.name;
      var features = geo.getFeaturesByName(name, type);
      var lngLatArr = geo.getDataPointLngLat(point, features && features[0]);
      var lngLat = lngLatArr && lngLatArr.join('-');

      if (!lngLat) {
        continue;
      }

      if (type === _Constants["default"].BUBBLE_CHART) {
        !isNaN(point.radius) && mapPoints.push(point);
        continue;
      }

      if (!lngLatKeyMap[lngLat]) {
        mapPoints.push(point);
      }

      lngLatKeyMap[lngLat] = true;
    }
  }); // 加reverse()的原因是：气泡地图第一个系列的点应该在最上层

  return mapPoints.reverse();
}

function areaPointMapPointsWithNormalLegend(vanchart) {
  var series = vanchart.series;
  var geo = vanchart.getCurrentGeo();
  return areaMapPointsWithNormalLegend(geo, series).concat(pointMapPointsWithNormalLegend(geo, series));
}
/**
 * 获取大数据模式下散点、气泡类型地图的数据点
 * @param vanchart
 */


function pointMapLargeModePoints(vanchart) {
  var largeSeries = vanchart.largeSeries;
  areaPointMapValidPoints(vanchart).forEach(function (point) {
    var _point$series = point.series,
        options = _point$series.options,
        type = _point$series.type;

    if (options.large && largeSeries[type]) {
      largeSeries[type].points.push(point);
    }
  });
  return largeSeries;
}

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPointMap = isPointMap;
exports.isPointMapAnchorIcon = isPointMapAnchorIcon;
exports.isPointMapDefaultImgFn = isPointMapDefaultImgFn;
exports.isAMapLayer = isAMapLayer;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function isPointMap(type) {
  return type === _Constants["default"].POINT_MAP || type === _Constants["default"].SCATTER_CHART || type === _Constants["default"].BUBBLE_CHART;
}

function isPointMapAnchorIcon(chartType, markerType) {
  return chartType === _Constants["default"].POINT_MAP && markerType === _Constants["default"].ANCHOR_ICON;
}

function isPointMapDefaultImgFn(chartType, markerType) {
  return chartType === _Constants["default"].POINT_MAP && markerType !== _Constants["default"].ANCHOR_ICON;
}

function isAMapLayer(options) {
  return options && options.geo && (0, _CoreUtils.hasDefined)(options.geo.aMapLayer);
}

/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

/**
 * Created by Yuqian on 2017/1/22.
 */
function lineH(R, G, styles, x1, x2, y, old) {
  if (!old) {
    old = G.append(R.line().style(styles));
  }

  return old.attr({
    x1: x1,
    y1: y,
    x2: x2,
    y2: y
  });
}

function lineV(R, G, styles, y1, y2, x, old) {
  if (!old) {
    old = G.append(R.line().style(styles));
  }

  return old.attr({
    x1: x,
    y1: y1,
    x2: x,
    y2: y2
  });
}

function rect(R, G, styles, x, y, width, height, old) {
  if (!old) {
    old = G.append(R.rect().style(styles));
  }

  return old.attr({
    x: x,
    y: y,
    width: width,
    height: height
  });
}

function traverse(root, childName, before, after) {
  function dfs(node, depth, len, i, parent) {
    before && before(node, depth, len, i, parent);
    var c = node[childName],
        n;

    if (c && (n = c.length)) {
      c.map(function (d, i) {
        dfs(d, depth + 1, n, i, node);
      });
    }

    after && after(node, depth, len, i, parent);
  }

  dfs(root, 0, 0, 0, null);
}

function sum(arr) {
  return arr.reduce(function (a, b) {
    return a + b;
  }, 0);
} // calc new values according to old proportions


function distribValues(oldValues, newValue) {
  var old = sum(oldValues);
  return oldValues.map(function (v) {
    return v / old * newValue;
  });
}

function getValidProgress(v) {
  v = +v; // #CHART-2504
  // 限制在 0 - 1

  if (isNaN(v)) {
    return 0;
  } else if (v < 0) {
    return 0;
  } else if (v > 1) {
    return 1;
  }

  return v;
}

var _default = {
  lineH: lineH,
  lineV: lineV,
  rect: rect,
  traverse: traverse,
  sum: sum,
  distribValues: distribValues,
  getValidProgress: getValidProgress
};
exports["default"] = _default;

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinearFormatTicks = getLinearFormatTicks;
exports.getFormatFunc = getFormatFunc;
exports.getLogTicks = getLogTicks;
exports.getLinearTicks = getLinearTicks;
exports.getLinearTicksWithMin = getLinearTicksWithMin;
exports.getLinearTicksWithMax = getLinearTicksWithMax;
exports.getIntegerNiceDomain = getIntegerNiceDomain;
exports.isValidLinearInterval = isValidLinearInterval;
exports.getLinearNiceInterval = getLinearNiceInterval;
exports.getLinearValidInterval = getLinearValidInterval;
exports.getPercentValidInterval = getPercentValidInterval;
exports.getLogValidInterval = getLogValidInterval;
exports.getFixedDomain = getFixedDomain;
exports.getEmptyDataDomain = getEmptyDataDomain;
exports.isInDomainValue = isInDomainValue;
exports.hasVisibleSery = hasVisibleSery;
exports.getForecast = getForecast;
exports.isFromZeroAxis = isFromZeroAxis;
exports.isUseMaxHeight = isUseMaxHeight;
exports.isZeroArray = isZeroArray;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _component = __webpack_require__(4);

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function getLinearFormatTicks(props) {
  var formatFunc = getFormatFunc(props.formatObj);
  var ticks = getLinearTicks(props);
  return ticks.map(function (tick) {
    return formatFunc(tick);
  });
}

function getFormatFunc(formatObj) {
  return typeof formatObj === 'function' ? formatObj : function (value) {
    return value;
  };
}

function getLogTicks(min, max, logBase, interval) {
  var ticks = [];
  var step = Math.pow(logBase, interval);

  while (min <= max) {
    ticks.push(min);
    min = _BaseUtils["default"].accMul(min, step);
  }

  return ticks;
}

function getLinearTicks(props) {
  var options = props.options,
      min = props.min,
      max = props.max,
      interval = props.interval;

  if (interval === 0) {
    return [];
  }

  if ((0, _CoreUtils.hasDefined)(options.tickInterval)) {
    if ((0, _CoreUtils.hasDefined)(options.min)) {
      return getLinearTicksWithMin(options.min, max, interval);
    }

    if ((0, _CoreUtils.hasDefined)(options.max)) {
      return getLinearTicksWithMax(min, options.max, interval);
    }
  }

  return getLinearTicksWithMin(min, max, interval);
}

function getLinearTicksWithMin(min, max, interval) {
  var ticks = [];

  while (min <= max) {
    ticks.push(min);
    min = _BaseUtils["default"].accAdd(min, interval);
  }

  return ticks;
}

function getLinearTicksWithMax(min, max, interval) {
  var ticks = [];

  while (max >= min) {
    ticks.unshift(max);
    max = _BaseUtils["default"].accAdd(max, -interval);
  }

  return ticks;
}

function getIntegerNiceDomain(min, max, interval) {
  min = _BaseUtils["default"].accMul(Math.floor(min / interval), interval);
  max = _BaseUtils["default"].accMul(Math.ceil(max / interval), interval);
  return [min, max];
}

function isValidLinearInterval(min, max, interval) {
  if (interval == null) {
    return false;
  }

  return Math.abs((max - min) / interval) <= _Constants["default"].MAX_TICKS_NUM;
}

function getLinearNiceInterval(min, max, count, type) {
  var span = max - min;
  var step = Math.pow(10, Math.floor(Math.log(span / count) / Math.LN10));
  var err = count / span * step;

  if (err <= 0.15) {
    step *= 10;
  } else if (err <= 0.35) {
    step *= 5;
  } else if (err <= 0.75) {
    step *= 2;
  }

  if (type && type === _component.ComponentCst.DATE_AXIS_COMPONENT) {
    step = Math.max(step, _Constants["default"].MIN_TIME_AXIS_INTERVAL);
  }

  return step;
}

function getLinearValidInterval(props) {
  var min = props.min,
      max = props.max,
      interval = props.interval,
      count = props.count,
      type = props.type;

  if (isValidLinearInterval(min, max, interval)) {
    return interval;
  }

  return getLinearNiceInterval(min, max, count, type);
}

function getPercentValidInterval(min, max, interval) {
  if (interval == null) {
    return _Constants["default"].DEFAULT_PERCENT_INTERVAL;
  }

  if (Math.abs((max - min) / interval) > _Constants["default"].MAX_TICKS_NUM) {
    return (max - min) / _Constants["default"].MAX_TICKS_NUM;
  }

  return interval;
}

function getLogValidInterval(min, max, logBase, interval) {
  if (interval == null) {
    return _Constants["default"].DEFAULT_LOG_INTERVAL;
  }

  if (min * Math.pow(logBase, interval * _Constants["default"].MAX_TICKS_NUM) < max) {
    return _BaseUtils["default"].log(logBase, max / min) / _Constants["default"].MAX_TICKS_NUM;
  }

  return interval;
}

function getFixedDomain(customDomain, zoomDomain, isBaseAxis) {
  if (isBaseAxis && zoomDomain && zoomDomain.length === 2) {
    var min, max;
    min = parseFloat(zoomDomain[0] || customDomain[0]);
    max = parseFloat(zoomDomain[1] || customDomain[1]);
    min = isNaN(min) ? null : min;
    max = isNaN(max) ? null : max;

    if (min && max) {
      var tmp = min;
      min = Math.min(min, max);
      max = Math.max(tmp, max);
    }

    return [min, max];
  }

  return customDomain;
}

function getEmptyDataDomain(interval) {
  var _Constants$EMPTY_DATA = _Constants["default"].EMPTY_DATA_DOMAIN,
      min = _Constants$EMPTY_DATA[0],
      max = _Constants$EMPTY_DATA[1];

  if (interval && !isNaN(interval)) {
    max = max * Math.pow(10, Math.floor(Math.log(interval) / Math.LN10));
  }

  return [min, max];
}

function isInDomainValue(domain, value) {
  var min = Math.min.apply(Math, domain);
  var max = Math.max.apply(Math, domain);
  return value >= min && value <= max;
}

function hasVisibleSery(series) {
  for (var i = 0, len = series.length; i < len; i++) {
    if (series[i].visible) {
      return true;
    }
  }

  return false;
}

function getForecast(series) {
  var isVisibleSeries = hasVisibleSery(series);
  var forecast = [0, 0];

  for (var i = 0, len = series.length; i < len; i++) {
    if (series[i].visible || !isVisibleSeries) {
      var trendLine = series[i].options.trendLine;

      if (trendLine && trendLine.period && trendLine.period.length === 2) {
        var _trendLine$period = trendLine.period,
            prePeriod = _trendLine$period[0],
            afterPeriod = _trendLine$period[1];
        forecast[0] = Math.min(forecast[0] || 0, prePeriod);
        forecast[1] = Math.max(forecast[1] || 0, afterPeriod);
      }
    }
  }

  return forecast;
}

function isFromZeroAxis(axis) {
  if (axis.isLog()) {
    if (axis.isAxisReversed()) {
      return Math.abs(axis._domain[1] - 1) < 1e-6;
    }

    return Math.abs(axis._domain[0] - 1) < 1e-6;
  }

  if (axis.isAxisReversed()) {
    return Math.abs(axis._domain[1]) < 1e-6;
  }

  return Math.abs(axis._domain[0]) < 1e-6;
}

function isUseMaxHeight(isHorizontal, isInverted) {
  if (isInverted) {
    return !isHorizontal;
  }

  return isHorizontal;
}

function isZeroArray(data) {
  data = data || [];

  for (var i = 0, len = data.length; i < len; i++) {
    if (Math.abs(+data[i]) > 0) {
      return false;
    }
  }

  return true;
}

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeriesFillFilter = getSeriesFillFilter;
exports.notSupportGradualColor = notSupportGradualColor;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _GradualColorUtils = __webpack_require__(58);

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

var _EnvUtils = __webpack_require__(3);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function columnAxisGradientLocation(ser) {
  var options = ser.options,
      yAxis = ser.yAxis;
  var isInverted = options.inverted;
  var isAxisReversed = yAxis.options.reversed;

  if (isInverted) {
    return isAxisReversed ? _Constants["default"].RIGHT_TO_LEFT : _Constants["default"].LEFT_TO_RIGHT;
  }

  return isAxisReversed ? _Constants["default"].TOP_TO_BOTTOM : _Constants["default"].BOTTOM_TO_TOP;
}

function barAxisGradientLocation(ser) {
  var options = ser.options,
      xAxis = ser.xAxis;
  var isInverted = options.inverted;
  var isAxisReversed = xAxis.options.reversed;

  if (isInverted) {
    return isAxisReversed ? _Constants["default"].BOTTOM_TO_TOP : _Constants["default"].TOP_TO_BOTTOM;
  }

  return isAxisReversed ? _Constants["default"].RIGHT_TO_LEFT : _Constants["default"].LEFT_TO_RIGHT;
}

function getAxisGradientLocation(ser) {
  var options = ser.options;
  var type = options.type;
  return type === _Constants["default"].COLUMN_CHART ? columnAxisGradientLocation(ser) : barAxisGradientLocation(ser);
}

function isNotSupportGradual(type) {
  return !(0, _EnvUtils.supportFillFilter)() || type !== _Constants["default"].COLUMN_CHART && type !== _Constants["default"].BAR_CHART;
}

function getSeriesFillFilter(color, ser) {
  var options = ser.options,
      vanchart = ser.vanchart;
  var gradualStyle = options.gradualStyle,
      gradualColorsOpt = options.gradualColors,
      type = options.type;

  if (gradualStyle === _Constants["default"].STYLE_NORMAL) {
    return color;
  }

  if (isNotSupportGradual(type)) {
    return notSupportGradualColor(options, color);
  }

  var renderer = vanchart.renderer;
  var location = getAxisGradientLocation(ser);
  var attrs = (0, _GradualColorUtils.gradualLocation)(location);
  var gradualColors = gradualStyle === _Constants["default"].STYLE_CUSTOM ? gradualColorsOpt : [color, _ColorUtils["default"].getColorWithDivider(color, 0.9)];
  var stop1 = {
    'offset': '0%',
    'stop-color': gradualColors[0]
  };
  var stop2 = {
    'offset': '100%',
    'stop-color': gradualColors[1]
  };

  if (ser.colorGradient) {
    renderer.updateColorGradient(ser.colorGradient, attrs, [stop1, stop2]);
  } else {
    ser.colorGradient = renderer.colorGradient(attrs, [stop1, stop2]);
  }

  return renderer.toPatternProperty(ser.colorGradient);
}

function notSupportGradualColor(options, color) {
  var gradualStyle = options.gradualStyle,
      gradualColors = options.gradualColors;
  return gradualStyle === _Constants["default"].STYLE_CUSTOM ? gradualColors[1] : color;
}

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _index = _interopRequireDefault(__webpack_require__(115));

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by Yuqian on 2017/3/28.
 */
var _textMap = {}; // 默认使用英文

var _locale = '';

function localeText(key) {
  return _textMap[key] != null ? _textMap[key] : key;
}
/**
 * set locale by inner setting
 * @param {string} language - like 'zh-cn'
 */


localeText.setLocale = function (language) {
  var lan = localeText.normalizeLocale(language);
  localeText.setCustomLocale((0, _index["default"])(lan));
};
/**
 * extend textMap by another Map
 * @param {Object} map - Key-Value object
 *
 * a problem: may conflict if set again
 */


localeText.setCustomLocale = function (map) {
  if ((0, _CoreUtils.hasDefined)(map)) {
    _BaseUtils["default"].extend(_textMap, map);

    _locale = map._locale;
  }
};

localeText.getLocale = function () {
  return _locale;
};

localeText.getTextMap = function () {
  return _textMap;
};

localeText.i18nText = function (key) {
  return _textMap[key];
};

localeText.normalizeLocale = function (key) {
  return key ? key.toLowerCase().replace('_', '-') : key;
};

var _default = localeText;
exports["default"] = _default;

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _component = __webpack_require__(4);

var _chart = _interopRequireDefault(__webpack_require__(81));

var _VanChartLayout = _interopRequireDefault(__webpack_require__(44));

var _Evented = _interopRequireDefault(__webpack_require__(13));

var _QueryUtils = _interopRequireDefault(__webpack_require__(12));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _localeText = _interopRequireDefault(__webpack_require__(35));

var _Point2D = _interopRequireDefault(__webpack_require__(15));

var _MobileHandler = _interopRequireDefault(__webpack_require__(204));

var _HammerHandler = _interopRequireDefault(__webpack_require__(101));

var _config = _interopRequireWildcard(__webpack_require__(212));

var _showEmptyDataTip = _interopRequireDefault(__webpack_require__(78));

var _renderer = _interopRequireDefault(__webpack_require__(24));

var _CoreUtils = __webpack_require__(2);

var _validMapPoints = __webpack_require__(30);

var _util = __webpack_require__(82);

var _VanRefresh = _interopRequireDefault(__webpack_require__(213));

var _ThemeConfig = __webpack_require__(25);

var _AutoFit = __webpack_require__(102);

var _VanChartBackground = __webpack_require__(45);

var _KeyUtils = _interopRequireDefault(__webpack_require__(61));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var MOBILE_HOVER_HIDE_DELAY = 4000; // Cmen: 所有的默认间隙都是基于16px字体大小的,后期如果需要更改默认间隙,可以在BaseUtils里面设置DEFAULT_PADDING_FONTSIZE来调整
// 考虑到缩放的影响,所有关于间隙的尺寸计算,都从对应的_FUN函数中获取根据缩放SCALE计算后的值。

var PADDING = 4;
var INTERACTIVE_COMPONENTS = [_component.ComponentCst.X_AXIS_COMPONENT, _component.ComponentCst.Y_AXIS_COMPONENT, _component.ComponentCst.ANGLE_AXIS_COMPONENT];

var VanChart = _Evented["default"].extend({
  vanChartType: 'vanChart',
  initialize: function (option, dom, vancharts) {
    this.wrapDom = dom;
    this.width = _BaseUtils["default"].pick(option.width, _BaseUtils["default"].getDomWidth(dom));
    this.height = _BaseUtils["default"].pick(option.height, _BaseUtils["default"].getDomHeight(dom)); // touch pan & pinch zoom

    this._plotZoom = {
      x: 1,
      y: 1
    };
    this._plotOffset = {
      x: 0,
      y: 0
    };
    this._eventsConfig = {
      pinch: true,
      pan: true
    };
    this.vancharts = vancharts;
    this.series = [];
    this.components = {};
    this._targets = {};
    this.animationCount = 0;
    this._changeDataState = false;
    this.fullScreenChart = null; //关联全屏以后的图表

    this.setOptions(option); // @Cmen：CHART-1130: 开启自适应插件时，resize的时候，会移除旧的dom，并生成新dom用于initChart
    // 而这时如果resize的频率比较高，就导致前面的initialize的dom已经不存在了，同样的resize方法也存在这个问题

    if (!this._checkValidSize()) {
      return;
    } // MOBILE-21081
    // constructor _checkValidSize return 跳过初始步骤导致refresh失败
    // 考虑总要size valid才行，在resize里面判断初始化
    // 总在崩溃的边缘……


    this._init();
  },
  _init: function () {
    if (this.__inited) {
      return;
    }

    this.__inited = true;
    var dom = this.wrapDom;

    if (true) {
      // ---------------------------------- 10.0 mobile magic...
      if (this.isMobile()) {
        if (this.isMobileFlow()) {
          this.handler = new _MobileHandler["default"](this, dom);
          this.showTooltip = this.showTooltipMobileFlow;
        } else {
          this.handler = new _HammerHandler["default"](this, dom); // legacy mobile tooltip

          this.showTooltip = this.showTooltipMobile;
        }
      } else {
        this.handler = new _HammerHandler["default"](this, dom);
      } // ----------------------------------------------------

    }

    this._initDomLayout(this.wrapDom);

    this.update();
  },
  setOptions: function (option) {
    _localeText["default"].setLocale(option.language); // add and adjust components for mobile flow


    if (this.isMobileFlow()) {
      this._mutateOptions(option);
    }

    option.series = option.series || []; //保证series不为空

    option.series.forEach(function (sery) {
      sery.data = sery.data || [];
    }); //坐标轴可能是数组

    this._mergeThemeConfig(option);

    (0, _ThemeConfig.fixOptionsWithTheme)(this, option);
    var autoFitScale = this.vancharts.autoFitScale || {};

    if (!this._ganttResize) {
      (0, _AutoFit.autoFitOptions)(option, {
        _scale: autoFitScale.scale,
        _fontScale: autoFitScale.fontScale,
        _wScale: autoFitScale.wScale,
        _hScale: autoFitScale.hScale
      });
    }

    var plotOptions = option.plotOptions;

    if (plotOptions.inverted && option.dataSheet) {
      option.dataSheet.enabled = false;
    }

    this.options = option; // 当前图表不是组合图，且设置了大数据模式，所有系列的动画都取消掉

    this.isLargeMode() && _Constants["default"].LARGE_CHART_TYPE[this.chartType()] && (plotOptions.animation = false); // CHART-1378
    // 组合图中任意一个子图表设置大数据模式并且该子图表类型也支持大数据模式的情况下，
    // 将图表的初始动画去掉，如果原本animation设置的就是false，那就不要执行了，节省点儿时间。

    if (plotOptions.animation && this.chartType() === _Constants["default"].MULTI_CHARTS) {
      Object.keys(_Constants["default"].LARGE_CHART_TYPE).forEach(function (type) {
        if (plotOptions[type] && plotOptions[type].large) {
          plotOptions.animation = false;
        }
      });
    }

    if (this.fullScreenChart) {
      this.fullScreenChart.setData(option);
    }
  },
  _initDomLayout: function (dom) {
    this.dom = dom;
    this.renderer = (0, _renderer["default"])(dom, this);
    this.renderer.onAdd();
    this.on({
      'animationStart': this._animationStart,
      'animationEnd': this._animationEnd
    });
  },
  _animationStart: function () {
    // console.log('series ani start, count reset to 0');
    //锁住fire的'animationEnd'
    this._animationStarted = true;
    this.animationCount = 0;
    this.removeMoreLabel();
    this.series.forEach(function (ser) {
      ser._removeDataLabels();

      ser._removeCateLabels && ser._removeCateLabels();
      ser.render();
    });

    if (!this.animationCount) {
      this.fire('animationEnd');
    }

    if (false) {}
  },

  /**
   * 当前图表是否正在执行系列渲染操作
   * @returns {boolean}
   */
  onSeriesRendering: function () {
    return this._animationStarted;
  },

  /**
   * 移除所有的MoreLabel
   * @return {[type]} [description]
   */
  removeMoreLabel: function () {
    var moreLabel = this.getComponent(_component.ComponentCst.MORELABEL_COMPONENT);
    moreLabel && moreLabel.removeAllMoreLabels();
  },
  _animationEnd: function () {
    if (!this.renderer) {
      return; //has been removed
    }

    this._animationStarted = false;
    this.series.forEach(function (ser) {
      ser._animateEnd();
    });
  },
  _removeChangeDataState: function (series) {
    if (this._changeDataState) {
      this._changeDataSeries = this._changeDataSeries || [];

      this._changeDataSeries.push(series);

      if (this._changeDataSeries.length >= this.series.length) {
        // 所有系列的动画完成,changeData的状态给改回来
        this._changeDataState = false;
        this._changeDataSeries = [];
      }
    }
  },
  _needShowMoreLabel: function () {
    var moreLabel = this.options.moreLabel;
    return this._changeDataState && moreLabel && moreLabel.enabled && !this.isLargeMode();
  },
  _clearMoreLabels: function () {
    this.series.forEach(function (ser) {
      ser._clearMoreLabels();
    });
  },
  _initIntermediateState: function () {
    this.colorMap = {};
    this.orderMap = {};
    this.cateMap = {};
    this.scale = 1;
    this.timeQueue = this.clearTimeQueue();
    this.clipPool = {};
    this.axisSize = {
      'left': 0,
      'right': 0,
      'bottom': 0,
      'top': 0
    };
    this.layerMap = this.layerIndex = null;
    this.__contentBoundsInited = false;
  },
  // 外部调用接口，传入新的配置
  refresh: function (options) {
    if ((0, _util.isAutoRefreshChart)(options)) {
      this.autoRefresh(options);
    } else {
      this.setOptions(options);

      if (!this._checkValidSize()) {
        return;
      }

      this.update();
    }
  },
  // 刷新按钮在两个情况下会出现,1.排序以后 2.坐标轴缩放的时候
  // 所以刷新要做的是两件事,1.重新按照原来的顺序排布 2.使所有系列可见,并且刷新坐标轴
  refreshRestore: function () {
    var vanchart = this,
        components = vanchart.components;
    INTERACTIVE_COMPONENTS.forEach(function (cName) {
      components[cName] && vanchart._restoreCategoryAxisBasedSeries(components[cName]);
    }); //仪表盘恢复

    var gaugeSeries = this.seriesOfType(_Constants["default"].GAUGE_CHART);

    if (gaugeSeries.length == this.series.length) {
      this.series.sort(function (a, b) {
        return a.index - b.index;
      });
    } //饼图的排序恢复


    this.seriesOfType(_Constants["default"].PIE_CHART).forEach(function (sery) {
      var map = sery.points.map(function (point) {
        return point.graphic;
      });
      var orderMap = {};
      sery.options.data.forEach(function (datum, i) {
        orderMap[datum.x] = i;
      });
      sery.points.sort(function (sliceA, sliceB) {
        return orderMap[sliceA.x] - orderMap[sliceB.x];
      });
      sery.points.forEach(function (point, index) {
        point.graphic = map[index];
      });
    }); //多层饼图恢复

    var multipie = this.seriesOfType(_Constants["default"].MULTIPIE_CHART);

    if (multipie.length) {
      multipie[0].orderData(null);
    } //理论上来讲不用全部属性都刷新一遍，但是涉及到图例的交互，分别刷新就比较复杂
    //先保证效果对


    this.update();
  },
  //实现的思路应该是point的graphic的排序,而不应该去刷新属性
  orderData: function () {
    var vanchart = this,
        components = vanchart.components;

    if (vanchart.chartType() === _Constants["default"].BOX_CHART) {
      return;
    }

    INTERACTIVE_COMPONENTS.forEach(function (cName) {
      components[cName] && vanchart._orderCategoryAxisBasedSeries(components[cName]);
    });
    var increaseOrder = this.orderType == _Constants["default"].ASCENDING;
    var para = increaseOrder ? 1 : -1; //仪表盘排序

    var gaugeSeries = this.seriesOfType(_Constants["default"].GAUGE_CHART);

    if (gaugeSeries.length == this.series.length) {
      this.series.sort(function (serA, serB) {
        var totalA = serA.getSeryTotalValue();
        var totalB = serB.getSeryTotalValue();
        return (totalA - totalB) * para;
      });
    } //饼图的排序


    this.seriesOfType(_Constants["default"].PIE_CHART).forEach(function (sery) {
      var map = sery.points.filter(function (point) {
        return point.visible;
      }).map(function (point) {
        return point.graphic;
      });
      sery.points.sort(function (sliceA, sliceB) {
        return increaseOrder ? sliceA.y - sliceB.y : sliceB.y - sliceA.y;
      });
      var index = 0;
      sery.points.forEach(function (point) {
        if (point.visible) {
          point.graphic = map[index];
          ++index;
        }
      });
    }); //多层饼图排序

    var multipie = this.seriesOfType(_Constants["default"].MULTIPIE_CHART);

    if (multipie && multipie.length) {
      multipie[0].orderData(increaseOrder);
    }

    this.reRenderSeries(); //这里的顺序不能换，zoom那边用了_sortedPoints

    INTERACTIVE_COMPONENTS.concat([_component.ComponentCst.ZOOM_COMPONENT, _component.ComponentCst.DATA_SHEET_COMPONENT, _component.ComponentCst.POLAR_COMPONENT]).forEach(function (cName) {
      components[cName] && components[cName].render();
    });
  },

  /**
   * 分类轴刷新
   * @param  {[type]} axisComponent [description]
   * @return {[type]}               [description]
   */
  _restoreCategoryAxisBasedSeries: function (axisComponent) {
    for (var axisIndex = 0, count = axisComponent.getAxisCount(); axisIndex < count; axisIndex++) {
      var axis = axisComponent.getAxis(axisIndex),
          series = axis.series; //缩放之后刷新，没有orderMap

      if (axis._isBaseAxis() && axis.isCategory() && this.orderMap && Object.keys(this.orderMap).length) {
        var order = this.orderMap[axis.componentType][axisIndex];
        var keyIndexMap = {};
        order.forEach(function (p, i) {
          keyIndexMap[p] = i;
        });
        var lastOrder = axis._dataDomain;

        for (var i = 0, len = series.length; i < len; i++) {
          var lastOrderMap = [],
              sery = series[i],
              normalData = true;
          sery.points.forEach(function (point) {
            lastOrderMap[_BaseUtils["default"].indexOf(lastOrder, point.getCategory())] = point.graphic;

            if (!point.graphic) {
              normalData = false;
            }
          });
          sery.points.forEach(function (point) {
            point.graphic = normalData ? lastOrderMap[keyIndexMap[point.getCategory()]] : point.graphic; //折线图,雷达图，排序以后，图片标记点和形状的标记点不能兼容

            sery.updatePointGraphic(point);
          });
        }
      }
    }
  },

  /**
   * 分类轴排序
   * @param  {[type]} axisComponent [description]
   * @return {[type]}               [description]
   */
  _orderCategoryAxisBasedSeries: function (axisComponent) {
    var para = this.orderType == _Constants["default"].ASCENDING ? 1 : -1;

    for (var axisIndex = 0, count = axisComponent.getAxisCount(); axisIndex < count; axisIndex++) {
      //普通的单层轴排序
      var sortNormalCategoryAxis = function () {
        for (var i = 0, len = points.length; i < len; i++) {
          var point = points[i];
          var total = 0;
          point.points.forEach(function (point) {
            if (point.visible && point.series.visible) {
              total += point.getTargetValue();
            }
          });
          valueMap.push({
            key: point.category,
            value: total
          });
        }

        valueMap.sort(function (a, b) {
          return (a.value - b.value) * para;
        });
        valueMap.forEach(function (p, i) {
          keyIndexMap[p.key] = i;
          newCategories.push(p.key);
        });
      }; // 多分类轴排序，保证倒数第二层分类顺序不变，对倒数第一层进行排序


      var sortMultiCategoryAxis = function () {
        var valueArr = [];

        for (var i = -1; ++i < points.length;) {
          var point = points[i];
          var total = 0;
          point.points.forEach(function (p) {
            if (p.visible && p.series.visible) {
              total += p.getTargetValue();
            }
          });

          var categoryArray = point.options.categoryArray,
              keyString = _BaseUtils["default"].encodeCategoryArray(categoryArray.slice(0, categoryArray.length - 1)),
              cateString = _BaseUtils["default"].encodeCategoryArray(categoryArray);

          var datum = {
            key: keyString,
            cate: cateString,
            value: total
          };

          if (valueMap[keyString] == null) {
            valueMap[keyString] = valueArr.push([datum]) - 1;
          } else {
            valueArr[valueMap[keyString]].push(datum);
          }
        }

        valueArr.forEach(function (cateArr) {
          cateArr.sort(function (a, b) {
            return (a.value - b.value) * para;
          });
        });
        var keyIndex = 0;
        valueArr.forEach(function (cateArr) {
          cateArr.forEach(function (cate) {
            keyIndexMap[cate.cate] = keyIndex;
            newCategories.push(cate.cate);
            keyIndex++;
          });
        });
      };

      var axis = axisComponent.getAxis(axisIndex);
      this.orderMap[axis.componentType] = this.orderMap[axis.componentType] || [];

      if (!this.orderMap[axis.componentType][axisIndex]) {
        this.orderMap[axis.componentType][axisIndex] = axis._dataDomain;
      }

      var series,
          valueMap = [],
          points,
          keyIndexMap = {},
          newCategories = [];

      if (axis._isBaseAxis() && axis.isCategory()) {
        series = axis.series;
        points = series[0].points;
        var isMultiCateAxis = axis.isMultiCateAxis && axis.isMultiCateAxis();
        isMultiCateAxis ? sortMultiCategoryAxis() : sortNormalCategoryAxis();
        var lastOrder = axis.getOriginalCategories();

        for (var i = 0, len = series.length; i < len; i++) {
          var lastOrderMap = [],
              sery = series[i],
              normalData = true;
          sery.points.forEach(function (point) {
            lastOrderMap[_BaseUtils["default"].indexOf(lastOrder, point.getCategory())] = point.graphic;

            if (!point.graphic) {
              normalData = false;
            }
          });
          sery.points.forEach(function (point) {
            point.graphic = normalData ? lastOrderMap[keyIndexMap[point.getCategory()]] : point.graphic; //折线图,雷达图，排序以后，图片标记点和形状的标记点不能兼容

            sery.updatePointGraphic(point);
          });
        }

        axis.setCategories(newCategories); // 排序完成后更新坐标轴的domain
      }
    }
  },

  /**
   * 添加新系列
   * @param options
   */
  addSeries: function (serData) {
    // todo 某些情况下，肯定需要判断添加到中间的位置
    // 对于新增的Seres，还需要将其默认的PlotOptions与vanchart.options.plotOptions合并一下
    var type = serData.type,
        option = this.options;
    var config = (0, _config["default"])(option);
    var defaultPlotOptions = config[type].plotOptions;

    _QueryUtils["default"].merge(option, config[type].options, false);

    if (option.plotOptions[type]) {
      option.plotOptions[type] = _QueryUtils["default"].merge(option.plotOptions[type], defaultPlotOptions, false);
    } else {
      option.plotOptions = _QueryUtils["default"].merge(option.plotOptions, defaultPlotOptions, false);
    }

    option.series.push(serData);
  },
  _checkValidSize: function () {
    return this.width && this.height;
  },
  // /**
  //  * 监控刷新返回的变化数据处理：
  //  * 针对add, update, delete三个操作分别处理， 其中：
  //  *     1. add操作要分为vanChart.addSeries和series.addPoint
  //  *     2. delete和update，要先计算出其对应的索引，然后根据索引更新
  //  * @param  {[type]} options [变化的数据] example:{add:{...}, update:{...}, delete:{...}}
  //  * @return {[type]}         [description]
  //  */
  autoRefresh: function (options) {
    // add and adjust components for mobile flow
    if (this.isMobileFlow()) {
      this._mutateOptions(options);
    }

    this._mergeThemeConfig(options);

    (0, _ThemeConfig.fixOptionsWithTheme)(this, options);
    var autoFitScale = this.vancharts.autoFitScale || {};
    (0, _AutoFit.autoFitOptions)(options, {
      _scale: autoFitScale.scale,
      _fontScale: autoFitScale.fontScale,
      _wScale: autoFitScale.wScale,
      _hScale: autoFitScale.hScale
    });
    var result = (0, _VanRefresh["default"])(this.options, options); // resize + autoRefresh REPORT-12107

    if (!this._checkValidSize()) {
      return;
    }

    var addData = result.add || [],
        removeData = result.remove || [],
        updateData = result.update || [],
        additionalOption = result.option || {},
        isChange = result.isChange || false;
    var vanchart = this,
        oldOption = vanchart.options,
        chartType = oldOption.chartType;

    if (!isChange) {
      this._changeDataState = false;
      return;
    } //未发生数据变化时，不重绘


    this._addData = addData;
    this._removeData = removeData;
    this._updateData = updateData;
    var seriesMap = {};
    this.series.forEach(function (ser) {
      var key = ser.getKey();
      var sameNameArray = seriesMap[key];

      if (sameNameArray) {
        sameNameArray.push(ser);
      } else {
        sameNameArray = [ser];
        seriesMap[key] = sameNameArray;
      }
    }); // 移除数据

    removeData.forEach(function (serData, index) {
      var key = _KeyUtils["default"].getSeriesKey(serData, options);

      var sameNameArray = seriesMap[key];
      var ser = sameNameArray && sameNameArray.length ? sameNameArray[0] : null;

      if (ser) {
        if (serData.data) {
          serData.data.forEach(function (datum) {
            var pos = ser.calculatePointIndex(datum);
            (0, _CoreUtils.hasDefined)(pos) && ser.removePoint(pos, false);
          });
        } // 当已有系列的data的length为0时，series已移除，对应的sameNameArray也减1
        // 改正：data的length为0，且没有新增的，才删除。


        if (vanchart._removeAllAndHasNoAdd(ser.options, index)) {
          sameNameArray && sameNameArray.splice(0, 1);
        }
      }
    }); // 新增数据

    addData.forEach(function (serData, index) {
      var key = _KeyUtils["default"].getSeriesKey(serData, options);

      var sameNameArray = seriesMap[key];
      var ser = sameNameArray && sameNameArray.length ? sameNameArray[0] : null;

      if (ser) {
        serData.data.forEach(function (datum) {
          ser.addPoint(datum);
        });
      } else {
        vanchart.addSeries(serData);
      }
    }); // 更新数据

    updateData.forEach(function (serData, index) {
      var key = _KeyUtils["default"].getSeriesKey(serData, options);

      var sameNameArray = seriesMap[key];
      var ser = sameNameArray && sameNameArray.length ? sameNameArray[0] : null;

      if (ser) {
        ser.updateSeries(serData);
        serData.data.forEach(function (datum) {
          var pos = ser.calculatePointIndex(datum);
          (0, _CoreUtils.hasDefined)(pos) && ser.updatePoint(pos, datum, false);
        });
      }
    });
    var changeSeriesKeyOrder = result.changeSeriesKeyOrder || [];

    if (changeSeriesKeyOrder.length > 0) {
      //大于0代表系列顺序变了
      oldOption.series.sort(function (ser1, ser2) {
        return _BaseUtils["default"].indexOf(changeSeriesKeyOrder, _KeyUtils["default"].getSeriesKey(ser1, oldOption)) - _BaseUtils["default"].indexOf(changeSeriesKeyOrder, _KeyUtils["default"].getSeriesKey(ser2, oldOption));
      });
    }

    var changeCategoryKeyOrder = result.changeCategoryKeyOrder || [];
    oldOption.series.forEach(function (ser, i) {
      var type = ser.type || chartType; //适配改变后的系列顺序

      var serCateKeyOrder = changeCategoryKeyOrder[i] || [];
      var originalData = ser.data || [];

      if (serCateKeyOrder.length > 0) {
        //大于0代表分类顺序变了
        originalData.sort(function (p1, p2) {
          return _BaseUtils["default"].indexOf(serCateKeyOrder, _KeyUtils["default"].getPointKey(p1, type)) - _BaseUtils["default"].indexOf(serCateKeyOrder, _KeyUtils["default"].getPointKey(p2, type));
        });
      }
    }); // 监控刷新中，标题等数据可以会发生更新

    _QueryUtils["default"].merge(this.options, additionalOption, true); // CHART-16138 仪表盘刷新目标值


    if (this.isGauge()) {
      this._dealGaugeAxisOpt(options);

      this.options.gaugeAxis = options.gaugeAxis;
    }

    if (this.isMap()) {
      this.options.xAxis = this.options.yAxis = this.options.zoom = undefined;
    } // 变化的数据更新到options之后，update统一刷新图表


    this.autoRefreshRender();

    if (this.fullScreenChart) {
      // @CHART-9165  fullScreenChart has only one chart
      this.fullScreenChart.charts[0].autoRefreshRender();
    }

    this.fire(_Constants["default"].AUTO_REFRESH);
  },
  //该系列的数据都被删除，且没有添加，则删除。
  //CHART-4081 整个系列的值被删掉 且有添加 系列顺序不应该改变。如果这边被删除了，再新建，这个系列就在最后了，顺序就改变了。
  _removeAllAndHasNoAdd: function (serData, index) {
    if (serData.data.length === 0) {
      //全被删掉再看看有没有加的
      var vanchart = this,
          option = vanchart.options,
          chartType = option.chartType;

      var serKey = _KeyUtils["default"].getSeriesKey(serData, option);

      var addData = vanchart._addData;

      for (var i = 0, len = addData.length; i < len; i++) {
        var addSerData = addData[i],
            addSerKey = _KeyUtils["default"].getSeriesKey(addSerData, option);

        if (addSerKey === serKey) {
          //有加的
          return false;
        }
      }

      return true; //没有加的
    }

    return false; //没有全部删掉
  },

  /**
   * 监控刷新视图更新，为什么这么写：
   * 当chart和fullScreenChart关联起来之后，二者共用一个options，因此数据处理只需要在chart的autoRefresh里面进行
   * 而渲染则需要分开来，由于MoreLabel的渲染需要一些判断因此把这部分拿出来
   * @return {[type]} [description]
   */
  autoRefreshRender: function () {
    // 这里需要手动把这个属性设置成true
    if (this._changeDataState) {
      this._changeDataSeries = []; //对于刷新间隔小于或等于持续时间的值变化提示,再次刷新的时候,需要手动把_changeDataSeries置空
    }

    this._changeDataState = true;
    this.update();
  },
  //图表整个的属性有改变的时候,至上而下的刷新所有组件.图表的属性.
  update: function () {
    this.fire('update');

    this._initIntermediateState();

    var option = this.options,
        vanchart = this,
        seriesData = option.series,
        chartType = option.chartType;
    var name, Class; //构建坐标轴,范围图例等组件

    var Components = (0, _component.getComponents)();

    for (var index = 0, cCount = _component.ComponentsOrder.length; index < cCount; index++) {
      name = _component.ComponentsOrder[index];
      Class = Components[name];

      if (name == _component.ComponentCst.RANGE_LEGEND_COMPONENT && option[name]) {
        var rangeType = option[name].continuous ? _component.ComponentCst.GradientRangeLegend : _component.ComponentCst.INTERVAL_RANGE_LEGEND;

        if (this.components[name] && this.components[name].type != rangeType) {
          this.components[name].remove();
          this.components[name] = null;
        }

        Class = (0, _component.getComponent)(rangeType);
      }

      if (Class) {
        var enabled = option[name] && ((0, _CoreUtils.hasNotDefined)(option[name].enabled) || option[name].enabled);

        if (!enabled && name == _component.ComponentCst.TOOLBAR_COMPONENT && !false) {
          enabled = true;
          option[name] = {
            'enabled': true,
            'hidden': false
          };
        }

        if (option[name] && enabled) {
          if (this.components[name]) {
            this.components[name].refresh(option[name], vanchart);
          } else {
            this.components[name] = new Class(option[name], name, vanchart);
          }
        } else if (this.components[name]) {
          this.components[name].remove();
          this.components[name] = null;
          delete this.components[name];
        }
      }
    }

    var seriesMap = {},
        series = [],
        key,
        type;
    vanchart.series.forEach(function (ser) {
      key = ser.getKey();
      var sameNameArray = seriesMap[key];

      if (sameNameArray) {
        sameNameArray.push(ser);
      } else {
        sameNameArray = [ser];
        seriesMap[key] = sameNameArray;
      }
    });
    seriesData.forEach(function (serData, index) {
      // @Cmen 这里注明为什么使用克隆的SerData， 之前直接使用serData的时候，refresh的时候，会对series.option和point.option进行扩展，
      // 这些扩展就会被映射到初始的SerData上面， 而在数据更新的时候，第二次refreshOption的时候，处理一些诸如markerColor的属性的时候，
      // 则不好判断该属性是后期扩展的还是在最开始的数据里就有的，因此就导致了某些属性无法更新
      // 理论上，绘图的时候，不应该修改原始的series数据，因此这里使用serData的拷贝，而更新数据则是基于原始的series.data进行的
      serData = _BaseUtils["default"].clone(serData);
      type = serData.type || chartType;
      var Class = (0, _chart["default"])(type);

      if (type == _Constants["default"].GAUGE_CHART) {
        var style = serData.style || option.plotOptions.style;
        Class = (0, _chart["default"])(style);
      } else if (type == _Constants["default"].RADAR_CHART) {
        var columnType = serData.columnType || option.plotOptions.columnType;
        columnType = columnType ? _Constants["default"].COLUMN_RADAR : _Constants["default"].LINE_RADAR;
        Class = (0, _chart["default"])(columnType);
      } // 初始化的时候还没有series对象，这里不能直接用ser._getKey()


      key = _KeyUtils["default"].getSeriesKey(serData, vanchart.options);
      var sameNameArray = seriesMap[key];
      var ser = sameNameArray && sameNameArray.length ? sameNameArray[0] : null;
      ser = ser ? ser.refresh(serData, index) : new Class(serData, vanchart, index);
      series.push(ser);
      sameNameArray && sameNameArray.splice(0, 1);
    });

    for (var serKey in seriesMap) {
      var sameNameArray = seriesMap[serKey];
      sameNameArray && sameNameArray.forEach(function (ser) {
        ser && ser.remove();
      });
    }

    vanchart.series = series;
    var gaugeAxis = this.components[_component.ComponentCst.GAUGE_AXIS_COMPONENT];

    if (gaugeAxis) {
      gaugeAxis.initAttributesWithSeries();
    }

    var rangeLegend = this.components[_component.ComponentCst.RANGE_LEGEND_COMPONENT];

    if (rangeLegend) {
      rangeLegend.initAttributesWithSeries();
    }

    series.forEach(function (ser) {
      // try in large mode
      if (ser.type === _Constants["default"].LINE_MAP && ser.options.large) {
        return;
      }

      for (var i = 0, len = ser.points.length; i < len; i++) {
        ser.points[i].refreshPointColor();
      }
    });
    vanchart.layoutComponentsAndCharts(); // doc flow: may have to show cross line

    if (this.isMobileFlow()) {
      this.checkCrossLineFlag();
    }
  },
  layoutComponentsAndCharts: function () {
    //计算百分比和标签，百分比会因为系列是否可见而每次都变化，从而导致标签的变化
    //还有像气泡图的半径也能在具体布局之前就推算出来
    this.hoverPoint = this.hoverSeries = null;

    _VanChartLayout["default"].PLANE_SYSTEM_LAYOUT(this);

    this.render();
  },
  //考虑padding的影响
  _getDefaultBounds: function () {
    // CHART-1452
    // 简单点儿，只要是矩形树图，如果用户没有主动设置padding，
    // 就让矩形树图占满图表区，甭管它有没有标题和图例。
    var padding = this.options && this.options.padding || this.chartType() === _Constants["default"].TREEMAP_CHART ? 0 : PADDING;
    var borderWidth = this.options && this.options.borderWidth || 0;
    padding = borderWidth + padding;
    return _BaseUtils["default"].makeBounds(padding, padding, Math.max(this.width - 2 * padding, 0), Math.max(this.height - 2 * padding, 0));
  },
  reRenderWholePlot: function () {
    _VanChartLayout["default"].calculateSeries(this);

    _VanChartLayout["default"].reLayoutPlotBounds(this);

    _VanChartLayout["default"].calculateSeriesShapes(this);

    this.render();
  },
  dealAxisZoom: function (downPos, upPos) {
    var zoomType = this.options.zoom.zoomType,
        xAxis = this.components.xAxis,
        yAxis = this.components.yAxis;

    if (xAxis && zoomType.indexOf('x') !== -1) {
      xAxis.axisZoom(downPos, upPos);
    }

    if (yAxis && zoomType.indexOf('y') !== -1) {
      yAxis.axisZoom(downPos, upPos);
    }

    this.reRenderWholePlot();
  },

  /**
   * 当图表开启缩放且缩放方向仅限于基础轴上时：
   * 重新计算值轴的值域，这里有效的数据点应该为在基础轴domain内的点
   * @param baseAxisType
   */
  reCalcValueAxisDataDomain: function (baseAxisType) {
    var valueAxisType = baseAxisType === _component.ComponentCst.X_AXIS_COMPONENT ? _component.ComponentCst.Y_AXIS_COMPONENT : _component.ComponentCst.X_AXIS_COMPONENT;
    var valueAxisGroup = this.components[valueAxisType]._axisList;

    for (var i = -1; ++i < valueAxisGroup.length;) {
      valueAxisGroup[i].calculateDomainFromData(undefined, true);
    }
  },
  //缩放等交互，闪烁动画中断
  clearAllEffects: function () {
    this.series.forEach(function (ser) {
      ser.points.forEach(function (point) {
        ser.clearPointEffect(point);
      });
    });
  },
  drawAllEffects: function () {
    this.series.forEach(function (ser) {
      ser._drawEffectPoints();
    });
  },
  _calculateZoomParas: function (downPos, upPos) {
    var plotBounds = this.bounds;
    var minX = Math.min(downPos.x, upPos.x) - plotBounds.x;
    var minY = Math.min(downPos.y, upPos.y) - plotBounds.y;
    var detX = Math.abs(downPos.x - upPos.x);
    var detY = Math.abs(downPos.y - upPos.y);
    var scale = Math.min(plotBounds.width / detX, plotBounds.height / detY);
    var wWidth = plotBounds.width / scale;
    var wHeight = plotBounds.height / scale;
    var shiftX = (plotBounds.width - wWidth) / 2 - minX;
    var shiftY = (plotBounds.height - wHeight) / 2 - minY;
    return {
      bounds: plotBounds,
      shiftX: shiftX,
      shiftY: shiftY,
      scale: scale
    };
  },
  _dealGaugeAxisOpt: function (option) {
    if (option.chartType === _Constants["default"].GAUGE_CHART) {
      return this._expandGaugeAxisOpt(option);
    }

    var axisOptions = [];
    var series = option.series,
        originAxisOpt = option.gaugeAxis;

    for (var i = 0; i < series.length; i++) {
      var ser = series[i];

      if (ser.type !== _Constants["default"].GAUGE_CHART) {
        continue;
      }

      var axisIndex = ser.gaugeAxis;
      var axisOption = _BaseUtils["default"].isArray(originAxisOpt) ? _extends({}, originAxisOpt[axisIndex]) : _extends({}, originAxisOpt);

      if (ser.style.indexOf('pointer') !== -1) {
        axisOptions[axisIndex] = axisOption;
        continue;
      }

      var target = ser.data[0].target;

      if ((0, _CoreUtils.hasDefined)(target) && target !== '-') {
        axisOption.max = +target;
      }

      axisOptions[axisIndex] = axisOption;
    }

    option.gaugeAxis = axisOptions;
  },
  // 处理非组合图的仪表盘的option
  _expandGaugeAxisOpt: function (option) {
    var series = option.series,
        originAxisOpt = option.gaugeAxis;
    var axisOptions = [];

    if (option.plotOptions.style.indexOf('pointer') !== -1) {
      return;
    }

    series.forEach(function (ser, index) {
      var target = ser.data[0].target;

      var axisOption = _BaseUtils["default"].clone(_BaseUtils["default"].isArray(originAxisOpt) ? _extends({}, originAxisOpt[0]) : _extends({}, originAxisOpt));

      if ((0, _CoreUtils.hasDefined)(target) && target !== '-') {
        axisOption.max = +target;
      }

      ser.gaugeAxis = index;
      axisOptions.push(axisOption);
    });
    option.gaugeAxis = axisOptions;
  },
  //默认配置，主题配置的组合
  _mergeThemeConfig: function (option) {
    var config = (0, _config["default"])(option);
    var merged = {},
        vanchart = this;
    option.series.forEach(function (ser) {
      var type = ser.type || option.chartType;
      var defaultPlotOptions = config[type].plotOptions;

      if (type == _Constants["default"].GAUGE_CHART) {
        var style = ser.style || option.plotOptions.gauge && option.plotOptions.gauge.style || option.plotOptions.style;
        style = style == 'pointer_semi' ? 'pointer' : style;
        defaultPlotOptions = config.gauge[style];
        var gaugeLabelKey = ['seriesLabel', 'valueLabel', 'percentageLabel'];
        gaugeLabelKey.forEach(function (key) {
          if ((0, _CoreUtils.hasDefined)(ser[key])) {
            _QueryUtils["default"].merge(ser[key], defaultPlotOptions[key], false);
          }
        });
      }

      if (!merged[type]) {
        merged[type] = true;

        _QueryUtils["default"].merge(option, config[type].options, false);

        if (option.plotOptions[type]) {
          option.plotOptions[type] = _QueryUtils["default"].merge(option.plotOptions[type], defaultPlotOptions, false);
        } else {
          option.plotOptions = _QueryUtils["default"].merge(option.plotOptions, defaultPlotOptions, false);
        }
      }
    });

    if (option.gaugeAxis) {
      this._dealGaugeAxisOpt(option);
    }

    if (this.isMap()) {
      option.xAxis = option.yAxis = option.zoom = undefined;

      _BaseUtils["default"].extend(option, config.MAP_CONFIG);
    }

    if (option.chartType == _Constants["default"].RADAR_CHART) {
      option.polar = option.polar || {};
    }

    option.tooltip = option.tooltip || {};

    if (option.colors && option.colors.length == 0) {
      option.colors = (0, _config.DEFAULT_COLORS)();
    }
  },
  getChartMinMaxValue: function () {
    var min = Number.MAX_VALUE,
        max = -min;
    var allPoints = [];
    this.series.forEach(function (ser) {
      return allPoints = allPoints.concat(ser.points);
    });
    var hasMap = this.isMap();
    var points = hasMap ? (0, _validMapPoints.mapPointsWithRangeLegend)(this.getCurrentGeo(), this.series) : allPoints;
    points.filter(function (point) {
      var filterNegative = (point.series.type === _Constants["default"].BUBBLE_CHART || point.series.type === _Constants["default"].FORCE_BUBBLE_CHART) && !point.series.options.displayNegative;
      var value = point.getTargetValue();
      return !point.isNull && !isNaN(value) && !(filterNegative && value < 0);
    }).forEach(function (point) {
      var value = point.getTargetValue();
      max = Math.max(max, value);
      min = Math.min(min, value);
    });

    if (min > max) {
      min = 0;
      max = 100;
    }

    return [min, max];
  },
  getParentDom: function () {
    return this.dom;
  },
  getDivParentDom: function () {
    return this.wrapDom;
  },
  isInverted: function () {
    return !!this.options.plotOptions.inverted;
  },
  setPlotBounds: function (newBounds) {
    this.bounds = newBounds;
  },
  getPlotClipBounds: function () {
    var x = 0,
        y = 0,
        width = this.bounds.width,
        height = this.bounds.height;
    var all = [],
        padding = 0;

    if (this.components.xAxis) {
      all = all.concat(this.components.xAxis._axisList);
    }

    if (this.components.yAxis) {
      all = all.concat(this.components.yAxis._axisList);
    }

    all.forEach(function (axis) {
      if (axis.isPlotRangeWithMarker()) {
        padding = axis.getPlotRangePadding();
      }
    });

    if (this.isInverted()) {
      y -= padding;
      height += 2 * padding;
    } else {
      x -= padding;
      width += 2 * padding;
    } //加1的原因，最后一根网格线


    return {
      x: x + this.bounds.x,
      y: y + this.bounds.y,
      width: Math.max(width + 1, 0),
      height: Math.max(height + 1, 0)
    };
  },
  getChartBounds: function () {
    return _BaseUtils["default"].makeBounds(0, 0, this.width, this.height);
  },
  xAxis: function (axisIndex) {
    if (!axisIndex) {
      axisIndex = 0;
    }

    var axis = this.components.xAxis;
    return axis ? axis.getAxis(axisIndex) : null;
  },
  yAxis: function (axisIndex) {
    if (!axisIndex) {
      axisIndex = 0;
    }

    var axis = this.components.yAxis;
    return axis ? axis.getAxis(axisIndex) : null;
  },
  baseAxis: function () {
    return this.chartType() === _Constants["default"].BAR_CHART ? this.yAxis() : this.xAxis();
  },
  polar: function (axisIndex) {
    if (!axisIndex) {
      axisIndex = 0;
    }

    var axis = this.components.polar;
    return axis ? axis.getAxis(axisIndex) : null;
  },
  angleAxis: function (axisIndex) {
    if (!axisIndex) {
      axisIndex = 0;
    }

    var axis = this.components.angleAxis;
    return axis ? axis.getAxis(axisIndex) : null;
  },
  radiusAxis: function (axisIndex) {
    if (!axisIndex) {
      axisIndex = 0;
    }

    var axis = this.components.radiusAxis;
    return axis ? axis.getAxis(axisIndex) : null;
  },
  gaugeAxis: function (axisIndex) {
    if (!axisIndex) {
      axisIndex = 0;
    }

    var axis = this.components.gaugeAxis;
    return axis ? axis.getAxis(axisIndex) : null;
  },
  getSharedAxis: function () {
    var axes = [this.xAxis(), this.yAxis(), this.angleAxis()];

    for (var i = 0; i < axes.length; i++) {
      var axis = axes[i];

      if (axis && axis.isCategory()) {
        return axis;
      }
    }

    return null;
  },
  getComponent: function (type) {
    return this.components[type];
  },
  setComponent: function (component, type) {
    this.components[type] = component;
  },

  /**
   * return color of previous name
   * or set new color and return
   * @param {string} [name] series item (or pie point) name
   * @returns {*}
   */
  getDefaultSeriesColor: function (name) {
    name += '';

    if (!this.colorMap[name]) {
      var colors = this.options.colors;
      var length = 0;

      for (var item in this.colorMap) {
        ++length;
      } // return next color


      this.colorMap[name] = colors[length % colors.length];
    }

    return this.colorMap[name];
  },
  registerPointsPara: function (point) {
    if ((0, _CoreUtils.hasDefined)(point.category)) {
      var cateMap = this.cateMap;
      var cateString = point.getCategory();
      cateMap[cateString] = cateMap[cateString] || [];
      cateMap[cateString].push(point);
      return cateMap[cateString];
    }
  },
  getValidPointsPara: function (category) {
    var points = this.cateMap[category] || [];
    return points.filter(function (p) {
      return p.isVisible() && p.options.tooltip && p.options.tooltip.shared;
    });
  },
  getSharedPoints: function (category) {
    var points = this.cateMap[category] || [];

    if (points && points.length) {
      return points.filter(function (p) {
        return p.options.tooltip && p.options.tooltip.shared;
      });
    }

    return [];
  },
  showSharedTooltip: function (point, event) {
    if (!point) {
      return;
    }

    var vanchart = this,
        valid = vanchart.getValidPointsPara(point.getCategory());
    var max = valid.reduce(function (prev, curr) {
      if (!prev) {
        return curr;
      }

      return Math.abs(curr.getTargetValue()) > Math.abs(prev.getTargetValue()) ? curr : prev;
    }, 0); // CHART-823
    // get first point(include invisible) among shared points

    vanchart.showTooltip(max, event, vanchart.getSharedPoints(point.getCategory())[0]);
  },
  // set to default showTooltip or showTooltipMobile after loaded
  // 很混的tooltip...
  // 总之 pc = _showTooltip;
  // legacy mobile = showTooltipMobile;
  // 10.0 mobile flow = showTooltipMobileFlow;
  showTooltip: _BaseUtils["default"].emptyFn,
  _showTooltip: function (point, event, fmtPoint) {
    //缩放的时候不显示数据点提示
    if (this.handler.selectRect) {
      return;
    }

    var tooltip = this.components[_component.ComponentCst.TOOLTIP_COMPONENT];
    tooltip && tooltip.showWithPoint(point, event, fmtPoint);
  },
  // 移动端4s自动消失
  showTooltipMobile: function () {
    this._showTooltip.apply(this, arguments);

    var self = this;
    var ev = arguments[1];
    this.setTimeout('mobileTooltip', function () {
      self.handler.removeAllChosen(ev);
    }, MOBILE_HOVER_HIDE_DELAY);
  },
  // 10.0 mobile flow...
  showTooltipMobileFlow: function (point, event, fmtPoint) {
    var tooltip = this.components[_component.ComponentCst.TOOLTIP_COMPONENT];
    var text = tooltip && tooltip.getMobileTextArray(point, event, fmtPoint); // 移动端直接在point.onClick调用pointOptions.click，
    // 陈旧的逻辑很难修改了
    // 在这里存下要显示的文字，塞到pointOptions.click param里

    this.__tooltipText = text;
  },
  hideTooltip: function () {
    this.hoverPoint = null;
    var tooltip = this.components[_component.ComponentCst.TOOLTIP_COMPONENT];
    tooltip && tooltip.hide();
  },

  /**
   * 工具栏提示
   * @param  {Object} icon    计算tooltip位置时做参考的toolbarIcon
   * @param  {String} content 提示文字内容
   */
  showToolbarTooltip: function (icon, content) {
    var tooltip = this.components[_component.ComponentCst.TOOLTIP_COMPONENT];
    tooltip && tooltip.showWithToolbarIcon(icon, content);
  },
  // set this chart's state, like enable/disable dom event
  set: function (opt) {
    if ('enable' in opt && this.handler) {
      if (opt['enable']) {
        this.handler.hammer.set({
          enable: true
        });
      } else {
        this.handler.hammer.set({
          enable: false
        });
        this.handler.removeAllChosen({
          containerPoint: {
            x: 0,
            y: 0
          }
        });
      }
    }
  },
  isGauge: function () {
    return this.options.chartType === _Constants["default"].GAUGE_CHART || this.options.chartType === _Constants["default"].MULTI_CHARTS && this.options.series.some(function (series) {
      return series.type === _Constants["default"].GAUGE_CHART;
    });
  },
  isMap: function () {
    return this.vanChartType == 'vanChartMap';
  },
  chartType: function () {
    return this.options.chartType;
  },
  //考虑到 散点地图 所以判断是否是点地图应该用chart.type 而不是 series.type
  isPointOrAreaOrHeatMap: function () {
    return this.options.chartType === _Constants["default"].AREA_MAP || this.options.chartType === _Constants["default"].POINT_MAP || this.options.chartType === _Constants["default"].HEAT_MAP;
  },
  isHeatMap: function () {
    return this.options.chartType == _Constants["default"].HEAT_MAP;
  },
  isAreaMap: function () {
    return this.options.chartType == _Constants["default"].AREA_MAP;
  },
  isForceBubble: function () {
    return this.vanChartType == 'vanChartForceBubble';
  },
  isLargeMode: function () {
    var isLarge = false; // 调用isLargeMode函数的时候有可能就没有给系列赋值

    this.series && this.series.length && this.series.forEach(function (series) {
      isLarge = !!series.options.large || isLarge;
    });
    isLarge = !!this.options.plotOptions.large || isLarge;
    return isLarge;
  },
  hasRangeLegend: function () {
    return !!this.components[_component.ComponentCst.RANGE_LEGEND_COMPONENT];
  },
  seriesOfType: function (type) {
    return (0, _util.seriesOfType)(this.series, type);
  },
  pointsOfType: function (type) {
    var allPoints = [];
    this.series.forEach(function (ser) {
      if (ser.type == type) {
        allPoints = allPoints.concat(ser.points);
      }
    });
    return allPoints;
  },
  // ussage:
  // vanchart.setTimeout('foo', bar, 100);
  // setting new func for the same key will flush the previous func
  // vanchart.setTimeout('foo'); cancel the func
  //
  // attention: this function fire the delay=0 immediately, no setTimeout(fun, 0)
  //
  setTimeout: function (key, func, delay) {
    if (this.timeQueue[key]) {
      window.clearTimeout(this.timeQueue[key]);
    }

    if (delay) {
      this.timeQueue[key] = window.setTimeout(func, delay);
    } else {
      func && func();
      this.timeQueue[key] = null;
    }
  },
  // should remove all in the end
  clearTimeQueue: function () {
    var timeQueue = this.timeQueue || {};
    Object.keys(timeQueue).map(function (key) {
      window.clearTimeout(timeQueue[key]);
    });
    return {};
  },
  getSize: function () {
    if (!this._size || this._sizeChanged) {
      this._size = new _Point2D["default"](this.width, this.height);
      this._sizeChanged = false;
    }

    return this._size.clone();
  },

  /**
   * 判断是否在大数据的情况下进行缩放
   * @returns {boolean}
   */
  isZoomingWithLargeModel: function () {
    var totalDataLen = 0,
        series = this.options.series,
        i,
        data;

    for (i = -1; ++i < series.length;) {
      data = series[i].data;
      totalDataLen += data.length;
    }

    return totalDataLen > 100 && this._zooming;
  }
}); //view


VanChart.include({
  render: function () {
    this.vancharts.endLoading();
    var vanchart = this,
        renderer = this.renderer;
    var clipBounds = this.getPlotClipBounds();

    if (!this.plotClip) {
      this.plotClip = renderer.createClip(clipBounds);
    } else {
      renderer.updateClip(this.plotClip, clipBounds);
    }

    function createGroup(groupName) {
      if (!vanchart[groupName]) {
        vanchart[groupName] = renderer.group().addClass(groupName).add();

        if (vanchart.isMap()) {
          vanchart[groupName].addClass('map-component');
        }
      }
    }

    ['backGroup', 'clipSeriesGroup', 'seriesGroup', 'seriesTextRenderGroup', 'frontGroup'].forEach(createGroup);

    if (this.isMobileFlow()) {
      createGroup('crossLineGroup');
      vanchart.seriesTextRenderGroup.attr({
        'pointer-events': 'none',
        'touch-action': 'none'
      });
      vanchart.frontGroup.attr({
        'pointer-events': 'none',
        'touch-action': 'none'
      });
      vanchart.crossLineGroup.attr({
        'pointer-events': 'none',
        'touch-action': 'none'
      });
      createGroup('crossLineGroup');

      if (!this.isMap()) {
        renderer.clip(vanchart.crossLineGroup, vanchart.plotClip);
      }
    }

    renderer.clip(vanchart.clipSeriesGroup, vanchart.plotClip);
    renderer.clip(vanchart.seriesTextRenderGroup, vanchart.plotClip);

    this._addDivClipGroup(clipBounds);

    this.emptyDataRender && this.emptyDataRender.remove(); // 空数据时显示空数据提示，并且返回
    // 非空数据时移除存在的空数据提示，继续渲染操作

    if (this._isEmptyDataChart()) {
      this._showEmptyDataTip();

      return;
    }

    this._renderBackground();

    this.renderComponents();
    this.renderSeries();
  },
  _addDivClipGroup: function (clipBounds) {
    var vanchart = this;

    if (!vanchart.seriesTextDivGroup) {
      vanchart.seriesTextDivGroup = this.renderer.div().add();
    } // clip: rect(<top>, <right>, <bottom>, <left>);


    vanchart.seriesTextDivGroup.style({
      clip: 'rect(' + [clipBounds.y, clipBounds.x + clipBounds.width, clipBounds.y + clipBounds.height, clipBounds.x].join('px ') + 'px)'
    });
  },
  _renderBackground: function () {
    var chartBounds = _BaseUtils["default"].makeBounds(0, 0, this.width, this.height),
        plotBounds = this.bounds,
        options = this.options,
        renderer = this.renderer; // CHART-14372 全屏放大的图表的背景只使用backgroundColor的rgb，不使用opacity，包括纯色和渐变色背景


    var chartBackgroundColor = this.vancharts.fullScreenFather ? _BaseUtils["default"].getFullScreenBackgroundColor(options.backgroundColor) : options.backgroundColor;
    var chartConfig = {
      backgroundColor: chartBackgroundColor,
      backgroundImage: options.backgroundImage,
      borderColor: options.borderColor,
      borderWidth: options.borderWidth,
      borderRadius: options.borderRadius || 0,
      shadow: options.shadow
    };
    var plotConfig = {
      backgroundColor: options.plotBackgroundColor,
      backgroundImage: options.plotBackgroundImage,
      borderRadius: options.plotBorderRadius || 0,
      shadow: options.plotShadow
    };
    var plotBorderConfig = {
      borderWidth: options.plotBorderWidth,
      borderColor: options.plotBorderColor,
      borderRadius: options.plotBorderRadius || 0
    };

    if (chartConfig.shadow) {
      chartBounds.x += _VanChartBackground.BACKGROUND_SHADOW_FILTER.deviation;
      chartBounds.y += _VanChartBackground.BACKGROUND_SHADOW_FILTER.deviation;
      chartBounds.width -= _VanChartBackground.BACKGROUND_SHADOW_FILTER.deviation * 2;
      chartBounds.height -= _VanChartBackground.BACKGROUND_SHADOW_FILTER.deviation * 2;
    }

    if (chartConfig.backgroundColor || chartConfig.backgroundImage || chartConfig.borderColor) {
      this.chartBackgroundGroup = this.chartBackgroundGroup || renderer.group().addTo(this.backGroup);
    } else if (this.chartBackgroundGroup) {
      this.chartBackgroundGroup.remove();
      this.chartBackgroundGroup = null;
    }

    if (plotConfig.backgroundColor || plotConfig.backgroundImage) {
      this.plotBackgroundGroup = this.plotBackgroundGroup || this.renderer.group().addTo(this.backGroup);
    } else if (this.plotBackgroundGroup) {
      this.plotBackgroundGroup.remove();
      this.plotBackgroundGroup = null;
    }

    if (plotBorderConfig.borderWidth) {
      this.plotBackgroundBorder = this.plotBackgroundBorder || this.renderer.rect().addTo(this.frontGroup);
    } else if (this.plotBackgroundBorder) {
      this.plotBackgroundBorder.remove();
      this.plotBackgroundBorder = null;
    }

    if (!options.geo || false) {
      (0, _VanChartBackground.renderRectangleBackground)(this.chartBackgroundGroup, chartConfig, chartBounds, renderer);
    }

    (0, _VanChartBackground.renderRectangleBackground)(this.plotBackgroundGroup, plotConfig, plotBounds, renderer);

    this._renderPlotBackgroundBorder(this.plotBackgroundBorder, plotBorderConfig, plotBounds);
  },
  renderComponents: function () {
    var _this = this;

    _component.ComponentsRenderOrder.forEach(function (c) {
      if (c in _this.components) {
        c !== _component.ComponentCst.POLAR_COMPONENT && _this.components[c] && _this.components[c].render();
      }
    });

    var vanchart = this,
        renderer = vanchart.renderer;

    if (!vanchart.highlightGroup && vanchart.plotClip) {
      renderer.clip(vanchart.highlightGroup = renderer.group().addTo(vanchart.backGroup), vanchart.plotClip);
    }
  },
  renderSeries: function () {
    var tooltip = this.components[_component.ComponentCst.TOOLTIP_COMPONENT];
    tooltip && tooltip.immediateHide();
    this.clearAllEffects(); // MOBILE-6927

    var shareAxis = this.getSharedAxis();
    shareAxis && shareAxis.removeHighlightBackground && shareAxis.removeHighlightBackground();
    this.fire('animationStart');

    this._renderTrendLine();
  },

  /**
   * 判断是否为空数据图表
   * @return {Boolean} [description]
   */
  _isEmptyDataChart: function () {
    // 系列为空，就为空数据
    //emptyDataTip.enabled开启时显示空数据提示，不开启显示空白
    return !this.isMap() && this.series.length === 0; //地图没有空数据提示，数据为空时，依旧绘制底图等component
  },

  /**
   * Chart-925:空数据时图表显示提示
   * @private
   */
  _showEmptyDataTip: function () {
    this._removeAll();

    this.emptyDataRender = (0, _showEmptyDataTip["default"])({
      dom: this.wrapDom,
      emptyDataTip: this.options.emptyDataTip,
      chartWidth: this.width,
      chartHeight: this.height,
      chart: this
    });
  },

  /**
   * 移除所有的组件和背景等
   * @return {[type]} [description]
   */
  _removeAll: function () {
    // 如果把TOOLTIP_COMPONENT直接remove掉，
    // 目前已知的一个坑：在多图表场景下，生成空数据图表时会先将tooltip给immediateHide，
    // 由于remove时tooltip的_tDom=null，导致immediateHide报错，
    // 所以不知道其他地方还有什么坑，这里的TOOLTIP_COMPONENT还是先immediateHide吧……
    for (var c in this.components) {
      if (c !== _component.ComponentCst.TOOLTIP_COMPONENT) {
        this.components[c] && this.components[c].remove();
      } else {
        this.components[c] && this.components[c].immediateHide();
      }
    }

    this.trendLineGroup && this.trendLineGroup.remove(); // 框架图LinkLine移除

    this.linkGroup && this.linkGroup.remove(); // 移除背景

    this.chartBackgroundGroup && this.chartBackgroundGroup.remove();
    this.plotBackgroundGroup && this.plotBackgroundGroup.remove();
    this.plotBackgroundBorder && this.plotBackgroundBorder.remove();
    this.linkGroup = this.chartBackgroundGroup = this.plotBackgroundGroup = this.plotBackgroundBorder = this.trendLineGroup = null;
  },
  _renderPlotBackgroundBorder: function (borderElementWrapper, option, bounds) {
    if (borderElementWrapper == null) {
      return;
    }

    var borderBounds = _extends({}, bounds, {
      rx: option.borderRadius,
      ry: option.borderRadius
    });

    borderElementWrapper.attr(borderBounds).style({
      'fill': 'none',
      'stroke': option.borderColor,
      'stroke-width': option.borderWidth
    });
  },
  //渐变色图例，直接过滤，不用计算布局什么的
  filterRender: function () {
    for (var i = 0, len = this.series.length; i < len; i++) {
      this.series[i].filterRender();
    }
  },
  cancelLegendHighlight: function (containerPoint) {
    var legend = this.getComponent(_component.ComponentCst.LEGEND_COMPONENT);
    legend = legend || this.getComponent(_component.ComponentCst.RANGE_LEGEND_COMPONENT);

    if (legend) {
      if (legend.highlighted && !_BaseUtils["default"].containsPoint(legend.bounds, containerPoint)) {
        legend.highlighted = false;
        this.highlightTarget = null;

        this._updateSeriesStyle();

        this._updateLegendStyle();

        this._updateTrendLineStyle();
      }
    }
  },
  makeLegendHighlight: function (target) {
    this.highlightTarget = target;

    this._updateSeriesStyle();

    this._updateLegendStyle();

    this._updateTrendLineStyle();
  },
  _updateLegendStyle: function () {
    var legendGroup = this.getComponent(_component.ComponentCst.LEGEND_COMPONENT) || this.getComponent(_component.ComponentCst.RANGE_LEGEND_COMPONENT);
    legendGroup.items.forEach(function (legendItem) {
      legendItem.updateLegendItemGraphicStyle();
    });
  },
  _updateTrendLineStyle: function () {
    var target = this.highlightTarget;
    var trendLineOptions = this.trendLines;
    var trendLines = this.trendLineGroup && this.trendLineGroup.trendLines;

    if (!trendLineOptions || !trendLines) {
      return;
    }

    for (var i = 0; i < trendLineOptions.length; i++) {
      var options = trendLineOptions[i],
          attrs = {
        'd': options.d
      };
      var originStrokeOpacity = options.trendLine.opacity;
      var strokeOpacity = target == null || options.bindName === target ? originStrokeOpacity : _Constants["default"].HOVER_OPACITY;
      trendLines[i].attr(attrs).style({
        'stroke-opacity': strokeOpacity
      });
    }
  },
  _updateSeriesStyle: function () {
    this.series.forEach(function (ser) {
      if (ser.isSupportLegendHighlight()) {
        if (ser.useCanvas()) {
          ser._canvasRender();
        } else {
          // 对于折线图和雷达图这类的，不要忘了使系列高亮
          ser.drawSeries && ser.drawSeries();
          ser.getDataToDraw().filter(function (point) {
            return point.isVisible();
          }).forEach(function (point) {
            ser._updatePointGraphicStyle(point);
          });
          ser.points && ser.points.forEach(function (point) {
            point.hasValidDataLabel() && ser._updatePointLabelStyle(point);
          });
        }
      }
    });
  },
  // 坐标轴缩放,拖拽缩放,点击图例等任何会导致绘图区图形变化的操作由这步完成
  reRenderSeries: function () {
    _VanChartLayout["default"].calculateSeries(this, true);

    _VanChartLayout["default"].calculateSeriesShapes(this);

    this.renderSeries();
  },
  removePointGraphics: function (p) {
    var vanchart = this;
    p && p.children && p.children.forEach(function (child) {
      vanchart.removePointGraphics(child);
    });
    p && p.remove();
    p = null;
  },
  registerInteractiveTarget: function (data, elementWrapper) {
    if (elementWrapper) {
      this._targets[_BaseUtils["default"].stamp(elementWrapper.node())] = data;
    }

    this.activeDataEvents(data);
  },
  activeDataEvents: function (data) {
    data._events = null;
    data.getEvents && data.on(data.getEvents(), data);
  },
  removeInteractiveTarget: function (data, elementWrapper) {
    if (elementWrapper && elementWrapper.node()) {
      this._targets[_BaseUtils["default"].stamp(elementWrapper.node())] = null;
      delete this._targets[_BaseUtils["default"].stamp(elementWrapper.node())];
    }

    if (data) {
      data._events = null;
    }
  },
  findInteractiveTarget: function (rawElement) {
    return this._targets[_BaseUtils["default"].stamp(rawElement)];
  },
  //need resize when chart resize
  addCanvasRendererForResize: function (canvas) {
    this._canvasMap = this._canvasMap || [];

    this._canvasMap.push(canvas);
  },
  resize: function () {
    var dom = this.wrapDom;
    this.width = _BaseUtils["default"].getDomWidth(dom);
    this.height = _BaseUtils["default"].getDomHeight(dom); // @Cmen：CHART-1130:同initialize

    if (!this._checkValidSize()) {
      return;
    } // if not inited, init


    this._init();

    this._sizeChanged = true;
    this.clipPool = {};
    this.axisSize = {
      'left': 0,
      'right': 0,
      'bottom': 0,
      'top': 0
    };
    this.renderer.resize();
    this._canvasMap && this._canvasMap.forEach(function (canvas) {
      canvas.resize();
    });

    if (this.isMap()) {
      this.mapRenderer.resize();
      this.markerRenderer && this.markerRenderer.resize();

      this._onResize();

      this.components.geo.resize();
    } // BI-6380


    var multiPie = this.seriesOfType(_Constants["default"].MULTIPIE_CHART)[0];

    if (multiPie) {
      multiPie.chartInfo.radius = null;
    }

    var moreLabel = this.getComponent(_component.ComponentCst.MORELABEL_COMPONENT);
    moreLabel && moreLabel.resize(); // scale可能也对应改变

    this.update();

    if (this.isMobileFlow()) {
      this.flowResize();
    }

    if (this.fullScreenChart) {
      this.fullScreenChart.resize();
    }
  },
  remove: function () {
    // CHART-996
    // 框架图在label未画完时再次触发动态参数，render已经remove，抛bug
    // 那么问题来了，怎么就框架图发现了……框架图动画时间是不是最长的
    this._animationStarted = false;
    this.__inited = false;
    this.force && this.force.endTick(null).stop();
    this.force = null;
    this.clearAllEffects();
    this.clearTimeQueue();
    this.renderer && this.renderer.remove();
    this.handler && this.handler.destroy();
    var tooltip = this.getComponent(_component.ComponentCst.TOOLTIP_COMPONENT);
    tooltip && tooltip.remove();
    var moreLabel = this.getComponent(_component.ComponentCst.MORELABEL_COMPONENT);
    moreLabel && moreLabel.remove();
    this.series && this.series.forEach(function (series) {
      series && series.remove && series.remove();
    });
    this.emptyDataRender && this.emptyDataRender.remove();
    this.mainRenderer && this.mainRenderer.remove();
    this.markerRenderer && this.markerRenderer.remove();
    this.animationRenderer && this.animationRenderer.remove();
    this.emptyDataRender = null;
    this.mainRenderer = null;
    this.markerRenderer = null;
    this.animationRenderer = null;

    if (this.largeSeries) {
      Object.keys(this.largeSeries).map(function (key) {
        if (this.largeSeries[key]._canvas) {
          this.largeSeries[key]._canvas.remove();
        }

        this.largeSeries[key] = null;
      }, this);
    }

    this.largeSeries = null;
    this.renderer = this.plotClip = this._leaflet = this.handler = this.chartBackgroundGroup = this.trendLineGroup = this.seriesGroup = this.clipSeriesGroup = this.seriesTextRenderGroup = this.seriesTextDivGroup = null;
    this._animatingZoom = false; //下钻+参数刷新。刷新前停止下钻

    this.validPoints = [];
  },

  /**
   * 是否可以响应原生的PanMove
   * @returns {boolean}
   */
  canFireNativePanMove: function () {
    return true;
  },
  isMobile: function () {
    var op = this.options;
    return op && op.mobile != null ? op.mobile : _BaseUtils["default"].hasTouch();
  },
  showTooltip: function () {
    this._showTooltip.apply(this, arguments);
  },
  isDarkTheme: function () {
    var options = this.options;
    return options.theme === _Constants["default"].DARK;
  },
  useCanvas: _BaseUtils["default"].falseFn
});
var _default = VanChart;
exports["default"] = _default;

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _LatLng = _interopRequireDefault(__webpack_require__(21));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/1/19.
 */
var LatLngBounds = function (corner1, corner2) {
  // (LatLng, LatLng) or (LatLng[])
  if (!corner1) {
    return;
  }

  var latlngs = corner2 ? [corner1, corner2] : corner1;

  for (var i = 0, len = latlngs.length; i < len; i++) {
    this.extend(latlngs[i]);
  }
};

LatLngBounds.prototype = {
  extend: function (obj) {
    var sw = this._southWest,
        ne = this._northEast,
        sw2,
        ne2;

    if (obj instanceof _LatLng["default"]) {
      sw2 = obj;
      ne2 = obj;
    } else if (obj instanceof LatLngBounds) {
      sw2 = obj._southWest;
      ne2 = obj._northEast;

      if (!sw2 || !ne2) {
        return this;
      }
    } else {
      return obj ? this.extend(_LatLng["default"].create(obj) || LatLngBounds.create(obj)) : this;
    }

    if (!sw && !ne) {
      this._southWest = new _LatLng["default"](sw2.lat, sw2.lng);
      this._northEast = new _LatLng["default"](ne2.lat, ne2.lng);
    } else {
      sw.lat = Math.min(sw2.lat, sw.lat);
      sw.lng = Math.min(sw2.lng, sw.lng);
      ne.lat = Math.max(ne2.lat, ne.lat);
      ne.lng = Math.max(ne2.lng, ne.lng);
    }

    return this;
  },
  // @method pad(bufferRatio: Number): LatLngBounds
  // Returns bigger bounds created by extending the current bounds by a given percentage in each direction.
  pad: function (bufferRatio) {
    var sw = this._southWest,
        ne = this._northEast,
        heightBuffer = Math.abs(sw.lat - ne.lat) * bufferRatio,
        widthBuffer = Math.abs(sw.lng - ne.lng) * bufferRatio;
    return new LatLngBounds(new _LatLng["default"](sw.lat - heightBuffer, sw.lng - widthBuffer), new _LatLng["default"](ne.lat + heightBuffer, ne.lng + widthBuffer));
  },
  // @method getCenter(): LatLng
  // Returns the center point of the bounds.
  getCenter: function () {
    return new _LatLng["default"]((this._southWest.lat + this._northEast.lat) / 2, (this._southWest.lng + this._northEast.lng) / 2);
  },
  // @method getSouthWest(): LatLng
  // Returns the south-west point of the bounds.
  getSouthWest: function () {
    return this._southWest;
  },
  // @method getNorthEast(): LatLng
  // Returns the north-east point of the bounds.
  getNorthEast: function () {
    return this._northEast;
  },
  // @method getNorthWest(): LatLng
  // Returns the north-west point of the bounds.
  getNorthWest: function () {
    return new _LatLng["default"](this.getNorth(), this.getWest());
  },
  // @method getSouthEast(): LatLng
  // Returns the south-east point of the bounds.
  getSouthEast: function () {
    return new _LatLng["default"](this.getSouth(), this.getEast());
  },
  // @method getWest(): Number
  // Returns the west longitude of the bounds
  getWest: function () {
    return this._southWest.lng;
  },
  // @method getSouth(): Number
  // Returns the south latitude of the bounds
  getSouth: function () {
    return this._southWest.lat;
  },
  // @method getEast(): Number
  // Returns the east longitude of the bounds
  getEast: function () {
    return this._northEast.lng;
  },
  // @method getNorth(): Number
  // Returns the north latitude of the bounds
  getNorth: function () {
    return this._northEast.lat;
  },
  // @method contains(otherBounds: LatLngBounds): Boolean
  // Returns `true` if the rectangle contains the given one.
  // @alternative
  // @method contains (latlng: LatLng): Boolean
  // Returns `true` if the rectangle contains the given point.
  contains: function (obj) {
    // (LatLngBounds) or (LatLng) -> Boolean
    if (typeof obj[0] === 'number' || obj instanceof _LatLng["default"]) {
      obj = _LatLng["default"].create(obj);
    } else {
      obj = LatLngBounds.create(obj);
    }

    var sw = this._southWest,
        ne = this._northEast,
        sw2,
        ne2;

    if (obj instanceof LatLngBounds) {
      sw2 = obj.getSouthWest();
      ne2 = obj.getNorthEast();
    } else {
      sw2 = ne2 = obj;
    }

    return sw2.lat >= sw.lat && ne2.lat <= ne.lat && sw2.lng >= sw.lng && ne2.lng <= ne.lng;
  },
  // @method intersects(otherBounds: LatLngBounds): Boolean
  // Returns `true` if the rectangle intersects the given bounds. Two bounds intersect if they have at least one point in common.
  intersects: function (bounds) {
    bounds = LatLngBounds.create(bounds);
    var sw = this._southWest,
        ne = this._northEast,
        sw2 = bounds.getSouthWest(),
        ne2 = bounds.getNorthEast(),
        latIntersects = ne2.lat >= sw.lat && sw2.lat <= ne.lat,
        lngIntersects = ne2.lng >= sw.lng && sw2.lng <= ne.lng;
    return latIntersects && lngIntersects;
  },
  // @method overlaps(otherBounds: Bounds): Boolean
  // Returns `true` if the rectangle overlaps the given bounds. Two bounds overlap if their intersection is an area.
  overlaps: function (bounds) {
    bounds = LatLngBounds.create(bounds);
    var sw = this._southWest,
        ne = this._northEast,
        sw2 = bounds.getSouthWest(),
        ne2 = bounds.getNorthEast(),
        latOverlaps = ne2.lat > sw.lat && sw2.lat < ne.lat,
        lngOverlaps = ne2.lng > sw.lng && sw2.lng < ne.lng;
    return latOverlaps && lngOverlaps;
  },
  // @method toBBoxString(): String
  // Returns a string with bounding box coordinates in a 'southwest_lng,southwest_lat,northeast_lng,northeast_lat' format. Useful for sending requests to web services that return geo data.
  toBBoxString: function () {
    return [this.getWest(), this.getSouth(), this.getEast(), this.getNorth()].join(',');
  },
  // @method equals(otherBounds: LatLngBounds): Boolean
  // Returns `true` if the rectangle is equivalent (within a small margin of error) to the given bounds.
  equals: function (bounds) {
    if (!bounds) {
      return false;
    }

    bounds = LatLngBounds.create(bounds);
    return this._southWest.equals(bounds.getSouthWest()) && this._northEast.equals(bounds.getNorthEast());
  },
  // @method isValid(): Boolean
  // Returns `true` if the bounds are properly initialized.
  isValid: function () {
    return !!(this._southWest && this._northEast);
  },
  isSame: function () {
    var sw = this._southWest,
        ne = this._northEast;
    return sw.lat === ne.lat && sw.lng === ne.lng;
  }
};

LatLngBounds.create = function (a, b) {
  if (a instanceof LatLngBounds) {
    return a;
  }

  return new LatLngBounds(a, b);
};

var _default = LatLngBounds;
exports["default"] = _default;

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

/**
 * Created by eason on 2017/2/15.
 */
var d3_map_proto = "__proto__",
    d3_map_zero = "\x00";

function vMap(object, f) {
  this._ = Object.create(null);

  if (object) {
    var map = this;

    if (object instanceof vMap) {
      object.forEach(function (key, value) {
        map.set(key, value);
      });
    } else if (Array.isArray(object)) {
      var i = -1,
          n = object.length,
          o;

      if (arguments.length === 1) {
        while (++i < n) {
          map.set(i, object[i]);
        }
      } else {
        while (++i < n) {
          map.set(f.call(object, o = object[i], i), o);
        }
      }
    } else {
      for (var key in object) {
        map.set(key, object[key]);
      }
    }
  }
}

vMap.prototype = {
  has: d3_map_has,
  get: function (key) {
    return this._[d3_map_escape(key)];
  },
  set: function (key, value) {
    return this._[d3_map_escape(key)] = value;
  },
  remove: d3_map_remove,
  keys: d3_map_keys,
  values: function () {
    var values = [];

    for (var key in this._) {
      values.push(this._[key]);
    }

    return values;
  },
  entries: function () {
    var entries = [];

    for (var key in this._) {
      entries.push({
        key: d3_map_unescape(key),
        value: this._[key]
      });
    }

    return entries;
  },
  size: d3_map_size,
  empty: d3_map_empty,
  forEach: function (f) {
    for (var key in this._) {
      f.call(this, d3_map_unescape(key), this._[key]);
    }
  }
};

function d3_map_escape(key) {
  return (key += "") === d3_map_proto || key[0] === d3_map_zero ? d3_map_zero + key : key;
}

function d3_map_unescape(key) {
  return (key += "")[0] === d3_map_zero ? key.slice(1) : key;
}

function d3_map_has(key) {
  return d3_map_escape(key) in this._;
}

function d3_map_remove(key) {
  return (key = d3_map_escape(key)) in this._ && delete this._[key];
}

function d3_map_keys() {
  var keys = [];

  for (var key in this._) {
    keys.push(d3_map_unescape(key));
  }

  return keys;
}

function d3_map_size() {
  var size = 0;

  for (var key in this._) {
    ++size;
  }

  return size;
}

function d3_map_empty() {
  for (var key in this._) {
    return false;
  }

  return true;
}

var _default = vMap;
exports["default"] = _default;

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getXYSizeString = getXYSizeString;
exports.calculateTextDim = calculateTextDim;
exports.propMap = exports.SUMMARY_VALUE = exports.DATA_OUTLIER = exports.DATA_MIN = exports.DATA_Q1 = exports.DATA_MEDIAN = exports.DATA_Q3 = exports.DATA_MAX = exports.DATA_NUMBER = exports.LEVEL = exports.PROGRESS = exports.DURATION = exports.FINISHTIME = exports.STARTTIME = exports.PROCESSES = exports.TO = exports.FROM = exports.ARRIVALRATE = exports.PERCENT = exports.VALUE = exports.DESCRIPTION = exports.SIZE = exports.NAME = exports.Y = exports.X = exports.CATEGORY = exports.SERIES = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Constants = _interopRequireDefault(__webpack_require__(1));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/3/6.
 * 标签内容的计算，从series里拿出来
 */
var LABEL_NAME_VALUE_GAP = 0.02;
var LABEL_GAP = 2;
var SERIES = '{SERIES}';
exports.SERIES = SERIES;
var CATEGORY = '{CATEGORY}';
exports.CATEGORY = CATEGORY;
var X = '{X}';
exports.X = X;
var Y = '{Y}';
exports.Y = Y;
var NAME = '{NAME}';
exports.NAME = NAME;
var SIZE = '{SIZE}';
exports.SIZE = SIZE;
var DESCRIPTION = '{DESCRIPTION}';
exports.DESCRIPTION = DESCRIPTION;
var VALUE = '{VALUE}';
exports.VALUE = VALUE;
var PERCENT = '{PERCENT}';
exports.PERCENT = PERCENT;
var ARRIVALRATE = '{ARRIVALRATE}';
exports.ARRIVALRATE = ARRIVALRATE;
var FROM = '{FROM.NAME}';
exports.FROM = FROM;
var TO = '{TO.NAME}';
exports.TO = TO;
var PROCESSES = '{PROCESSES}';
exports.PROCESSES = PROCESSES;
var STARTTIME = '{STARTTIME}';
exports.STARTTIME = STARTTIME;
var FINISHTIME = '{FINISHTIME}';
exports.FINISHTIME = FINISHTIME;
var DURATION = '{DURATION}';
exports.DURATION = DURATION;
var PROGRESS = '{PROGRESS}';
exports.PROGRESS = PROGRESS;
var LEVEL = '{LEVEL}';
exports.LEVEL = LEVEL;
var DATA_NUMBER = '{DATA_NUMBER}';
exports.DATA_NUMBER = DATA_NUMBER;
var DATA_MAX = '{DATA_MAX}';
exports.DATA_MAX = DATA_MAX;
var DATA_Q3 = '{DATA_Q3}';
exports.DATA_Q3 = DATA_Q3;
var DATA_MEDIAN = '{DATA_MEDIAN}';
exports.DATA_MEDIAN = DATA_MEDIAN;
var DATA_Q1 = '{DATA_Q1}';
exports.DATA_Q1 = DATA_Q1;
var DATA_MIN = '{DATA_MIN}';
exports.DATA_MIN = DATA_MIN;
var DATA_OUTLIER = '{DATA_OUTLIER}';
exports.DATA_OUTLIER = DATA_OUTLIER;
var SUMMARY_VALUE = '{SUMMARY_VALUE}';
exports.SUMMARY_VALUE = SUMMARY_VALUE;
var propMap = {};
exports.propMap = propMap;
["name", "category", "processes", "startTime", "finishTime", "duration", "progress", "level", "arrivalRate"].map(function (prop) {
  var key = '{' + prop.toUpperCase() + '}';
  propMap[key] = [prop, prop + 'Format'];
});
propMap[VALUE] = ['originalValue', 'valueFormat'];
propMap[SERIES] = ['seriesName', 'seriesFormat'];
propMap[PERCENT] = ['percentage', 'percentFormat'];
propMap[SUMMARY_VALUE] = ['summaryValue', 'summaryValueFormat'];

function getXYSizeString(point, formatter, identifier) {
  var options = point.options;

  var xString = _BaseUtils["default"].format(options.x, formatter.XFormat);

  var yString = _BaseUtils["default"].format(options.y, formatter.YFormat);

  var sizeString = options.size == '-' ? '-' : _BaseUtils["default"].format(options.size, formatter.sizeFormat);
  var text = '';

  if (identifier.indexOf(X) != -1 || identifier.indexOf(Y) != -1) {
    text = '(';

    if (identifier.indexOf(X) != -1) {
      text += xString;

      if (identifier.indexOf(Y) != -1) {
        text = text + ',' + yString;
      }

      text += ')';
    } else {
      text += yString;
      text += ')';
    }

    text += _Constants["default"].BLANK_VALUE_PERCENTAGE;
  }

  if (identifier.indexOf(SIZE) != -1 && sizeString != '-') {
    text += sizeString;
  }

  return text;
}

function calculateTextDim(labelContent, point) {
  var outsideDim = labelContent && (labelContent.nameLabelContent || labelContent.valueLabelContent);

  if (outsideDim && point.series.type == 'funnel') {
    return _calculateFunnelOutSideTextDim(point, labelContent);
  } else {
    var width = 0,
        height = 0;

    if (labelContent && labelContent.length) {
      for (var i = 0, count = labelContent.length; i < count; i++) {
        var dim = labelContent[i].dim;
        width = Math.max(width, dim.width);
        height += dim.height;
      }

      height += (count - 1) * LABEL_GAP;
    }

    return {
      width: width,
      height: height
    };
  }
}

function _calculateFunnelOutSideTextDim(point, labelContent) {
  var width = 0;
  var height = 0;
  var gapWidth = 0;

  if (labelContent.nameLabelContent) {
    var dim = labelContent.nameLabelContent.dim;
    width += dim.width;
    height = Math.max(height, dim.height);
  }

  if (labelContent.valueLabelContent) {
    var dim = labelContent.valueLabelContent.dim;
    width += dim.width;
    height = Math.max(height, dim.height);
  }

  if (labelContent.nameLabelContent && labelContent.valueLabelContent) {
    var funnel = point.series,
        vanchart = funnel.vanchart,
        plotBounds = vanchart.bounds;
    gapWidth = plotBounds.width * LABEL_NAME_VALUE_GAP;
    width += gapWidth;
  }

  return {
    width: width,
    height: height,
    nameValueGap: gapWidth
  };
}

/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNeedBorder = isNeedBorder;
exports.getHorizontalPadding = getHorizontalPadding;
exports.getLabelPadding = getLabelPadding;
exports.fixLabelDimWithBorder = fixLabelDimWithBorder;
exports.getBorderBounds = getBorderBounds;
exports.getPathAndTransform = getPathAndTransform;
exports.createTextBorderPath = createTextBorderPath;
exports.labelTransWithBorder = labelTransWithBorder;
exports.borderPaddingFn = void 0;

var _BorderPathGeneretor = __webpack_require__(112);

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _GradualColorUtils = __webpack_require__(58);

var _GradualColor = __webpack_require__(34);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var DIALOG_BORDER = 'dialog';
var PARALLELOGRAM_BORDER = 'parallelogram';
var ELLIPSE_BORDER = 'ellipse';
var LINE_TRIANGLE_BORDER = 'lineTriangle';
var DEFAULT_TRIANGLE_SIZE = 3;
var PARALLELOGRAM_CONFIG = {
  radius: 2,
  paddingWidth: 4,
  offsetAngleTan: 0.175 // tan(10度)

};
var ELLIPSE_RADIUS_SCALE = 1.25;
var TRANSPARENT = "rgba(0,0,0,0)";

var DIRECTION = function (location) {
  switch (location) {
    case _Constants["default"].RIGHT_TO_LEFT:
      return 'left';

    case _Constants["default"].LEFT_TO_RIGHT:
      return 'right';

    case _Constants["default"].TOP_TO_BOTTOM:
      return 'bottom';

    default:
      return 'top';
  }
};

function isNeedBorder(point) {
  var labelContent = point.labelContent,
      options = point.options,
      series = point.series;
  var dataLabels = options.dataLabels;

  var _ref = dataLabels || {},
      backgroundColor = _ref.backgroundColor,
      borderWidth = _ref.borderWidth,
      orientation = _ref.orientation;

  var isHorizontalLabel = orientation !== _Constants["default"].VERTICAL_LAYOUT;
  var isNeedBorderChart = series && (series.type === _Constants["default"].PIE_CHART || series.type === _Constants["default"].LINE_CHART || series.type === _Constants["default"].AREA_CHART || series.type === _Constants["default"].BAR_CHART || series.type === _Constants["default"].COLUMN_CHART);
  return isHorizontalLabel && isNeedBorderChart && labelContent && labelContent.length !== 0 && (borderWidth || backgroundColor);
}

function getEllipseBorderPadding(labelTextDim) {
  var _labelTextDim$width = labelTextDim.width,
      width = _labelTextDim$width === void 0 ? 0 : _labelTextDim$width,
      _labelTextDim$height = labelTextDim.height,
      height = _labelTextDim$height === void 0 ? 0 : _labelTextDim$height;

  var paddingArr = function (l, s) {
    var longRadius = l * ELLIPSE_RADIUS_SCALE;
    var shortRadius = s * ELLIPSE_RADIUS_SCALE;
    return [(longRadius - l) * 2, (shortRadius - s) * 2];
  };

  return width > height ? paddingArr(width, height) : paddingArr(height, width).reverse();
}

var borderPaddingFn = function (borderType, isDelTriangleSize, labelTextDim) {
  var _ref2 = labelTextDim || {},
      width = _ref2.width,
      height = _ref2.height;

  var parallelogramOffsetWidth;

  switch (borderType) {
    case DIALOG_BORDER:
      return isDelTriangleSize ? [8, 5] : [8, 8];

    case PARALLELOGRAM_BORDER:
      parallelogramOffsetWidth = height ? 2 * PARALLELOGRAM_CONFIG.offsetAngleTan * (height + 5) + PARALLELOGRAM_CONFIG.paddingWidth : 8;
      return [parallelogramOffsetWidth, 5];

    case ELLIPSE_BORDER:
      return getEllipseBorderPadding(labelTextDim);

    case LINE_TRIANGLE_BORDER:
      return isDelTriangleSize ? [8, 5] : [8, 8];

    default:
      return [8, 5];
  }
};

exports.borderPaddingFn = borderPaddingFn;

function getHorizontalPadding(point) {
  var padding = getLabelPadding(point);

  if (padding && padding.length === 2) {
    return padding[0];
  }

  return 0;
}

function getLabelPadding(point) {
  if (!isNeedBorder(point)) {
    return [0, 0];
  }

  var options = point.options,
      labelDim = point.labelDim;
  var dataLabels = options.dataLabels;
  var borderType = dataLabels.borderType;
  return borderPaddingFn(borderType, false, labelDim.innerTextDim);
}

function fixLabelDimWithBorder(point) {
  var labelDim = point.labelDim;
  var borderPadding = getLabelPadding(point);
  labelDim.width += borderPadding[0];
  labelDim.height += borderPadding[1];
}

function getBorderBounds(point) {
  var options = point.options,
      labelDim = point.labelDim,
      labelPos = point.labelPos;
  var x = labelPos.x,
      y = labelPos.y;
  var width = labelDim.width,
      height = labelDim.height;
  var dataLabels = options.dataLabels;
  var borderType = dataLabels.borderType;
  var direction = DIRECTION(point.location);

  var dialogBorderBounds = function (direction) {
    switch (direction) {
      case 'left':
        return {
          width: width - DEFAULT_TRIANGLE_SIZE,
          height: height,
          x: x,
          y: y
        };

      case 'right':
        return {
          width: width - DEFAULT_TRIANGLE_SIZE,
          height: height,
          x: x + DEFAULT_TRIANGLE_SIZE,
          y: y
        };

      case 'bottom':
        return {
          width: width,
          height: height - DEFAULT_TRIANGLE_SIZE,
          x: x,
          y: y + DEFAULT_TRIANGLE_SIZE
        };

      default:
        return {
          width: width,
          height: height - DEFAULT_TRIANGLE_SIZE,
          x: x,
          y: y
        };
    }
  };

  var rectBounds = function () {
    return {
      width: width,
      height: height,
      x: x,
      y: y
    };
  };

  switch (borderType) {
    case DIALOG_BORDER:
    case LINE_TRIANGLE_BORDER:
      return dialogBorderBounds(direction);

    default:
      return rectBounds();
  }
}

function getPathAndTransform(point) {
  var path;
  var options = point.options;
  var dataLabels = options.dataLabels;
  var borderType = dataLabels.borderType,
      borderRadius = dataLabels.borderRadius;
  var direction = DIRECTION(point.location);

  var _getBorderBounds = getBorderBounds(point),
      width = _getBorderBounds.width,
      height = _getBorderBounds.height,
      x = _getBorderBounds.x,
      y = _getBorderBounds.y;

  var transform = _BaseUtils["default"].makeTranslate({
    x: x,
    y: y
  });

  switch (borderType) {
    case PARALLELOGRAM_BORDER:
      path = (0, _BorderPathGeneretor.parallelogramBorderGenerator)(width, height, PARALLELOGRAM_CONFIG.radius, PARALLELOGRAM_CONFIG.offsetAngleTan * height);
      break;

    case DIALOG_BORDER:
      path = (0, _BorderPathGeneretor.dialogBorderGenerator)(width, height, direction, 0, borderRadius, DEFAULT_TRIANGLE_SIZE);
      break;

    case ELLIPSE_BORDER:
      path = (0, _BorderPathGeneretor.ellipseBorderGenerator)(width, height);
      break;

    case LINE_TRIANGLE_BORDER:
      path = (0, _BorderPathGeneretor.lineTriangleGenerator)(width, height, direction);
      break;

    default:
      path = (0, _BorderPathGeneretor.rectBorderGenerator)(width, height, 0, borderRadius);
      break;
  }

  return {
    path: path,
    transform: transform
  };
}

function _createBorderGradientBackground(renderer, color, point) {
  return (0, _GradualColorUtils.createGradientBackground)(point, 'textBorderBackgroundColorGradient', renderer, color);
}

function createTextBorderPath(point) {
  if (!isNeedBorder(point)) {
    return;
  }

  var options = point.options,
      series = point.series;
  var renderer = series.vanchart.renderer;

  var textLabelGroup = series._getPointTextLabelGroup();

  var dataLabels = options.dataLabels;
  var backgroundColor = dataLabels.backgroundColor,
      borderWidth = dataLabels.borderWidth,
      borderType = dataLabels.borderType,
      borderColor = dataLabels.borderColor;
  var pathAndTransform = getPathAndTransform(point);
  var strokeColor = borderColor === _Constants["default"].AUTO ? (0, _GradualColor.notSupportGradualColor)(options, point.getSeriesColor()) : borderColor || TRANSPARENT;
  var fillColor = typeof backgroundColor === 'string' ? backgroundColor || TRANSPARENT : _createBorderGradientBackground(renderer, backgroundColor, point); // lineTriangle类型的边框stroke和fill需要对应不同的path

  if (borderType === LINE_TRIANGLE_BORDER) {
    point.textBorderPath = renderer.group().addTo(textLabelGroup).attr({
      transform: pathAndTransform.transform
    });
    point.lineTriangleBorder = renderer.path().addTo(point.textBorderPath).attr({
      d: pathAndTransform.path[0]
    }).style({
      stroke: strokeColor,
      'stroke-width': borderWidth
    });
    point.lineTriangleBorderRect = renderer.path().addTo(point.textBorderPath).attr({
      d: pathAndTransform.path[1]
    }).style({
      fill: fillColor,
      'stroke-width': 0
    });
    return;
  }

  point.textBorderPath = renderer.path().addTo(textLabelGroup).attr({
    d: pathAndTransform.path,
    transform: pathAndTransform.transform
  }).style({
    fill: fillColor,
    stroke: strokeColor,
    'stroke-width': borderWidth
  });
}

function labelPosWithBorder(point) {
  var options = point.options,
      location = point.location,
      labelDim = point.labelDim;
  var dataLabels = options.dataLabels;
  var borderType = dataLabels.borderType;
  var borderPadding = borderPaddingFn(borderType, false, labelDim.innerTextDim);

  var _getBorderBounds2 = getBorderBounds(point),
      x = _getBorderBounds2.x,
      y = _getBorderBounds2.y;

  var dialogPos = function (location) {
    if (location === _Constants["default"].LEFT_TO_RIGHT || location === _Constants["default"].RIGHT_TO_LEFT) {
      return {
        x: x - (borderPadding[0] - DEFAULT_TRIANGLE_SIZE) / 2,
        y: y + borderPadding[1] / 2
      };
    } else {
      return {
        x: point.labelPos.x,
        y: y + (borderPadding[1] - DEFAULT_TRIANGLE_SIZE) / 2
      };
    }
  };

  switch (borderType) {
    case DIALOG_BORDER:
    case LINE_TRIANGLE_BORDER:
      return dialogPos(location);

    case PARALLELOGRAM_BORDER:
      return {
        x: point.labelPos.x,
        y: y + borderPadding[1] / 2
      };

    default:
      return {
        x: point.labelPos.x,
        y: y + borderPadding[1] / 2
      };
  }
}

function labelTransWithBorder(point) {
  var _labelPosWithBorder = labelPosWithBorder(point),
      x = _labelPosWithBorder.x,
      y = _labelPosWithBorder.y;

  return {
    x: x + point.labelDim.width / 2,
    y: y + point.labelDim.height / 2
  };
}

/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _SvgElementWrapper = _interopRequireDefault(__webpack_require__(113));

var _VmlElementWrapper = _interopRequireDefault(__webpack_require__(114));

var _ElementWrapper = _interopRequireDefault(__webpack_require__(42));

var _types = __webpack_require__(50);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// import FineCanvasElementWrapper from "./FineCanvasElementWrapper";
var createElementWrapper = function (rawElement, renderer) {
  var type = renderer && renderer.type;

  switch (type) {
    case _types.SVG_RENDERER:
      return new _SvgElementWrapper["default"](rawElement, renderer);

    case _types.VML_RENDERER:
      return new _VmlElementWrapper["default"](rawElement, renderer);
    // case FINE_CANVAS_RENDERER:
    //     return new FineCanvasElementWrapper(rawElement, renderer);

    default:
      return new _ElementWrapper["default"](rawElement, renderer);
  }
};

var _default = createElementWrapper;
exports["default"] = _default;

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformParser = exports["default"] = void 0;

var _Class = _interopRequireDefault(__webpack_require__(29));

var _DomUtils = _interopRequireDefault(__webpack_require__(6));

var _Transition = _interopRequireDefault(__webpack_require__(49));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Constants = _interopRequireDefault(__webpack_require__(1));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 16/7/22.
 * ElementWrapper是一个元素包裹器, 统一了元素操作相关, 支持链式调用, 类似JQuery
 * Example:
 * 对于一个DomElement, 我们要修改其属性或者样式, 一般要这么写
 *      el.setAttribute("name", "小明");
 *      el.setAttribute("age", "22");
 *      el.style.color = "#f00";
 *
 * 使用EleWrapper, 则简单许多
 *  var elw = new ElementWrapper(el).style("color", "#f00").attr("name", "小明").attr("age", "22")
 *  对于同一类操作可以合并, 比如上面的attr("name", "xx").attr("age", "xx")就可以合并写成
 *  elw.attr({name: "小明", age: "22"});
 *
 *  除了DomElement之外, 构造ElementWrapper的时候, 还需指定renderer, 用于判断一些当前元素是基于Svg或者dom实现的
 *
 */
var isArray = _BaseUtils["default"].isArray;
var TRANSITION_PREFIX = '__transition_';

var ElementWrapper = _Class["default"].extend({
  /**
   * wrap the elements to hide implementation details
   * @param rawElement dom elements for svg and vml,and data object for canvas
   * @param renderer the renderer that the rawElement belongs to
   */
  initialize: function (rawElement, renderer) {
    this.rawElement = rawElement;
    this.renderer = renderer;
    return this;
  },
  node: function () {
    return this.rawElement;
  },

  /**
   * add the rawElement to the parent container
   * append to the container for svg and vml
   * or show for canvas
   * @param parentElementWrapper
   * @returns {ElementWrapper}
   */
  addTo: function (parent) {
    parent = parent || this.renderer._container;
    parent.append(this);
    return this;
  },
  addToBack: function (parent) {
    parent = parent || this.renderer._container;
    parent = parent.node();
    parent.firstChild ? parent.insertBefore(this.node(), parent.firstChild) : parent.appendChild(this.node());
    return this;
  },
  add: function () {
    if (this.type === 'div') {
      return this.addTo(this.renderer._divContainer);
    }

    return this.addTo(this.renderer._container);
  },
  append: function (child) {
    this.node().appendChild(child.node());
    return child;
  },
  //bind data to the elementWrapper
  datum: function () {
    if (arguments.length) {
      this._datum = arguments[0];
      return this;
    }

    return this._datum;
  },
  addClass: function (name) {
    _DomUtils["default"].addClass(this.node(), name);

    return this;
  },
  toBack: function () {
    _DomUtils["default"].toBack(this.node());
  },

  /**
   * remove from the renderer container
   * for canvas, we shall clear the context and redraw all
   * the other elements on the container
   */
  remove: function () {
    var vanchart = this.renderer.vanchart;
    var data = vanchart.findInteractiveTarget(this.node());
    data && vanchart.removeInteractiveTarget(data, this);

    _DomUtils["default"].remove(this.node());

    return this;
  },
  removed: function () {
    return !(this.node().parentNode && this.node().parentNode.tagName);
  },
  isVisible: function () {
    return !this.removed() && this.node().style.display != 'none';
  },
  //ie下面用vml path模拟所有的形状,所以需要记录一下形状的类型
  setType: function (type) {
    this.type = type;
    return this;
  },
  // rotate text(div, svg) according to center
  // for less dom operation, set textContent & style first
  // then rotate
  // delayMove for animation
  vRotate: function (deg, delayMove) {
    this.renderer.vRotate(this, deg, delayMove);
    return this;
  },
  vMiddle: function () {
    this.renderer.vMiddle(this);
  },
  vLeft: function () {
    this.renderer.vLeft(this);
  },
  vRight: function () {
    this.renderer.vRight(this);
  },
  // transition stuff
  animate: function (para) {
    if (!para) {
      throw new Error('animate para empty');
    } else if (isArray(para)) {
      var transition = this.transition().setAnimation(para[0]);

      for (var i = 1, len = para.length; i < len; i++) {
        transition = transition.transition(para[i]);
      }

      return this.setTransitionEnd(transition, para[len - 1].style);
    } else {
      return this.setTransitionEnd(this.transition().setAnimation(para), para.style);
    }
  },
  setTransitionEnd: function (transition, styles) {
    var el = this;
    var vanchart = this.renderer.vanchart;
    ++vanchart.animationCount; // 避免同一个Elw上调用多次animate后导致前面的transition不能正常end

    if (el._animating) {
      --vanchart.animationCount;
    }

    el._animating = true;
    return transition.each('end', function () {
      el._animating = false;
      styles && el.style(styles);

      if (vanchart._animationStarted) {
        if (! --vanchart.animationCount) {
          vanchart.animationCount = -1; // console.log('ani transition end');

          vanchart.fire('animationEnd');
        }
      }
    });
  },
  effectTransition: function () {
    this.interrupt(_Constants["default"].EFFECT_KEY); // for resize & effect, interrupt last effect transition

    return new _Transition["default"](this, _Constants["default"].EFFECT_KEY);
  },
  transition: function (name) {
    return new _Transition["default"](this, name, null, !this.renderer.isAnimation);
  },
  interrupt: function (name) {
    var node = this.node(),
        ns = _Transition["default"].d3_transitionNamespace(name);

    var lock;

    if ((lock = node[ns]) && lock[lock.active]) {
      if (--lock.count) {
        delete lock[lock.active];
      } else {
        delete node[ns];
      }

      lock.active += .5;
    }

    return this;
  },

  /**
   * interrupt target transition on node[ns]
   * @param name
   * @returns {ElementWrapper}
   */
  removeTransition: function (name) {
    var node = this.node();

    if (!node) {
      return this;
    }

    var ns = _Transition["default"].d3_transitionNamespace(name); // 点地图chart.clear() 先clear的icon 再clear effect。


    if (name && ns && node[ns]) {
      delete node[ns];
    }

    return this;
  },
  removeEffectTransition: function () {
    return this.removeTransition(_Constants["default"].EFFECT_KEY);
  }
});

var _default = ElementWrapper;
exports["default"] = _default;

var transformParser = function (transformStr) {
  var translate, rotate, scale;
  translate = transformStr.match(/translate\(\s*([\d|.|e|-]+)(?:[,\s]*)([\d|.|e|-]*)\s*\)/i);
  translate && translate.shift();
  rotate = transformStr.match(/rotate\(\s*([\d|.|e|-]+[degratun]*)(?:[,\s]*)([\d|.|e|-]*)(?:[,\s]*)([\d|.|e|-]*)\s*\)/i);
  rotate = rotate && rotate[1] || 0;
  scale = transformStr.match(/scale\(\s*([\d|.|e|-]+)\s*\)/i);
  scale = scale && +scale[1] || 1;
  return {
    translate: translate,
    rotate: rotate,
    scale: scale
  };
};

exports.transformParser = transformParser;

/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

/**
 * Created by Yuqian on 2017/2/7.
 */
var _default = {
  PADDING: 4,
  WEEKEND_COLOR: 'rgba(169, 195, 200, 0.1)',
  OUTLINE: {
    'fill': 'none',
    'stroke': 'rgba(207, 207, 207, 1)',
    'stroke-width': 1
  },
  TWEENLINE: {
    'fill': 'none',
    'stroke': 'rgba(207, 207, 207, 0.6)',
    // 'stroke': 'red',
    'stroke-width': 1
  },
  INNERLINE: {
    'fill': 'none',
    'stroke': 'rgba(207, 207, 207, 0.6)',
    // 'stroke': 'green',
    'stroke-width': 0.5
  },
  THUMB_WIDTH: 14,
  THUMB_FILTER: {
    dx: 0,
    dy: 0,
    opacity: 0.15,
    deviation: 3,
    r: 0 / 255,
    g: 0 / 255,
    b: 0 / 255
  },
  SLIDER_STYLE: {
    'fill': '#8E8E8E',
    'fill-opacity': 0.7,
    'height': 4,
    'rx': 3,
    'ry': 3
  },
  SLIDER_BACKGROUND_WIDTH: [18, 120],
  // sliderBackground的最大最小值
  SLIDER_BACKGROUND_STYLE: {
    'fill': '#9D9D9D',
    'fill-opacity': 0.2,
    'height': 4,
    'rx': 3,
    'ry': 3
  },
  MINUS_PATH: {
    size: [24, 24],
    graphic: {
      cursor: 'pointer',
      fill: '#8E8E8E',
      'fill-opacity': 0.7,
      d: 'M19,13 L19,11 L5,11 L5,13Z'
    }
  },
  PLUS_PATH: {
    size: [24, 24],
    graphic: {
      cursor: 'pointer',
      fill: '#8E8E8E',
      'fill-opacity': 0.7,
      d: 'M13,5 L13,11 L19,11 L19,13 L13,13 L13,19 L11,19 L11,13 L5,13 L5,11 L11,11 L11,5 L13,5 Z'
    }
  },
  MOUSE_EVENT_PATH: {
    size: [24, 24],
    graphic: {
      cursor: 'pointer',
      fill: '#FFFFFF',
      'fill-opacity': 0,
      d: 'M0,0 L0,24 L24,24 L24,0 L0,0Z'
    }
  }
};
exports["default"] = _default;

/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _component = __webpack_require__(4);

var _BoundsManager = _interopRequireDefault(__webpack_require__(27));

var _BezierEasing = _interopRequireDefault(__webpack_require__(8));

var _QueryUtils = _interopRequireDefault(__webpack_require__(12));

var _VanChartLabel = _interopRequireDefault(__webpack_require__(97));

var _CoreUtils = __webpack_require__(2);

var _VanChartAutoLabel = __webpack_require__(83);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2016/11/8.
 */
var MIN_POINTS_DISTANCE = 40; // 折线图与面积图标记点类型为自动时，标记点显示时的最小距离

var ADJUST_LABEL_GAP = 3; // 标签左右调整后距离边界的间隙

function calculateSeries(vanchart, reRender) {
  var init = !reRender;

  _calculateSerSummaryValue(vanchart);

  _calculatePercentageRelated(vanchart);

  _calculateTypePercentage(vanchart.seriesOfType(_Constants["default"].WORD_CLOUD_CHART));

  if (init) {
    calculateDelayTime(vanchart, vanchart.seriesOfType(_Constants["default"].BUBBLE_CHART), _Constants["default"].BUBBLE_CHART);
    calculateDelayTime(vanchart, vanchart.seriesOfType(_Constants["default"].SCATTER_CHART), _Constants["default"].SCATTER_CHART);
    calculateBubbleRadius(vanchart.seriesOfType(_Constants["default"].BUBBLE_CHART));
    calculateBubbleRadius(vanchart.seriesOfType(_Constants["default"].FORCE_BUBBLE_CHART));
  }
}

function calculateSeriesShapes(vanchart) {
  for (var i = 0, len = vanchart.series.length; i < len; i++) {
    var ser = vanchart.series[i];

    if (ser.visible) {
      ser.doLayout();
    }
  }

  (0, _VanChartLabel["default"])(vanchart);

  _adjustLabel4BaseAxis(vanchart);

  (0, _VanChartAutoLabel.adjustAutoChartLabel)(vanchart);

  _adjustMobileFlowLabel(vanchart);

  _adjustPieRadius(vanchart.seriesOfType(_Constants["default"].PIE_CHART));
}

function _adjustLabel4BaseAxis(vanchart) {
  var series = vanchart.series || [],
      bounds = vanchart.bounds,
      points,
      labelDim,
      labelPos,
      downBound,
      upBound,
      direct,
      coord,
      isHorizontal;
  series.forEach(function (ser) {
    if (!_isAdjustLabel4BaseAxis(ser.type)) {
      return;
    }

    isHorizontal = _isHorizontalBaseAxis(ser.type, vanchart.isInverted());
    points = ser.points || [];
    points.forEach(function (point) {
      if (!_hasValidLabel(point) || !_isPointAdjust(isHorizontal, bounds, point)) {
        return;
      } // 图形超出绘图区的标签隐藏


      if (_isPointOutOfBounds(bounds, point)) {
        point.labelPos = {};
        return;
      }

      labelDim = point.labelDim;
      labelPos = point.labelPos;
      isHorizontal ? (direct = 'width', coord = 'x') : (direct = 'height', coord = 'y');
      downBound = labelPos[coord];
      upBound = bounds[direct] - labelPos[coord] - labelDim[direct];

      if (downBound < 0 && upBound < 0) {
        labelPos[coord] = ADJUST_LABEL_GAP;
        return;
      }

      labelPos[coord] = downBound < 0 ? ADJUST_LABEL_GAP : labelPos[coord];
      labelPos[coord] = upBound < 0 ? bounds[direct] - labelDim[direct] - ADJUST_LABEL_GAP : labelPos[coord];
      labelPos[coord] = labelPos[coord] < 0 ? ADJUST_LABEL_GAP : labelPos[coord];
    });
  });
}

function _isHorizontalBaseAxis(chartType, inverted) {
  return chartType === _Constants["default"].BAR_CHART && inverted || chartType !== _Constants["default"].BAR_CHART && !inverted;
}

function _isAdjustLabel4BaseAxis(chartType) {
  return chartType === _Constants["default"].COLUMN_CHART || chartType === _Constants["default"].BAR_CHART || chartType === _Constants["default"].LINE_CHART || chartType === _Constants["default"].AREA_CHART;
}

function _isPointOutOfBounds(bounds, point) {
  var chartType = point.series.type;
  var relativeBounds = {
    x: 0,
    y: 0,
    width: bounds.width,
    height: bounds.height
  };

  if (chartType === _Constants["default"].COLUMN_CHART || chartType === _Constants["default"].BAR_CHART) {
    return _BaseUtils["default"].outsideRect(relativeBounds, point.rect);
  }

  if (chartType === _Constants["default"].AREA_CHART || chartType === _Constants["default"].LINE_CHART) {
    var wh;
    var posX = point.posX,
        posY = point.posY,
        options = point.options,
        series = point.series;
    var marker = options.marker;

    if (_BaseUtils["default"].isImageMarker(marker.symbol)) {
      wh = [marker.width, marker.height];
    } else if (series.isMarkerDisplayable && marker.symbol === _Constants["default"].SYMBOL_AUTO) {
      wh = [2 * _Constants["default"].MARKER_RADIUS, 2 * _Constants["default"].MARKER_RADIUS];
    } else {
      var radius = marker.radius || 0;
      wh = [2 * radius, 2 * radius];
    }

    var pointBounds = {
      x: posX - wh[0] / 2,
      y: posY - wh[1] / 2,
      width: wh[0],
      height: wh[1]
    };
    return _BaseUtils["default"].outsideRect(relativeBounds, pointBounds);
  }

  return false;
} // 设置了背景或者边框都不进行标签左右调整


function _isPointAdjust(isHorizontal, bounds, point) {
  var dataLabels = point.options && point.options.dataLabels;
  return !_outOfBound(isHorizontal, bounds, point) && !dataLabels.borderWidth && !dataLabels.backgroundColor;
}

function _hasValidLabel(point) {
  return point.labelDim && point.labelPos;
}

function setSeriesMarkerDisplayable(series, isMarkerDisplayable) {
  series.forEach(function (ser) {
    var symbol = ser.marker && ser.marker.symbol;

    if (symbol === _Constants["default"].SYMBOL_AUTO) {
      ser.isMarkerDisplayable = isMarkerDisplayable;
    }
  });
}
/**
 * 根据标记点类型自动规则判断标记点是否显示
 * @param vanchart
 * @param series
 * @param type
 * @private
 */


function _adjustMarkerDisplayable(vanchart, series, type) {
  if (series.length === 0) {
    return;
  }

  var plotOptions = vanchart.options.plotOptions,
      _options = plotOptions[type];
  var plotOptionsMarker = _options && _options.marker || plotOptions.marker;
  var symbol = plotOptionsMarker && plotOptionsMarker.symbol;

  if (symbol !== _Constants["default"].SYMBOL_AUTO) {
    return;
  }

  var isInverted = vanchart.isInverted();
  var plotBounds = vanchart.bounds,
      allDistance = isInverted ? plotBounds.height : plotBounds.width;
  var maxLimitNum = Math.round(allDistance / MIN_POINTS_DISTANCE);

  var validPoints = function (points) {
    return points.filter(function (point) {
      return !point.isNull;
    });
  };

  var maxPointsNum = Math.max.apply(Math, series.map(function (ser) {
    return validPoints(ser.points).length;
  }));

  if (maxLimitNum < maxPointsNum) {
    setSeriesMarkerDisplayable(series, false);
    return;
  }

  var serWidthMaxPoints = series.filter(function (ser) {
    return validPoints(ser.points).length === maxPointsNum;
  })[0];
  var axis = serWidthMaxPoints.xAxis;

  if (axis.type === 'category') {
    setSeriesMarkerDisplayable(series, true);
    return;
  }

  var key = 'x';

  var valueArr = _getAllPointsValue(series, axis, key);

  var min = Math.min.apply(Math, valueArr),
      max = Math.max.apply(Math, valueArr);
  var serValidPoints = validPoints(serWidthMaxPoints.points);
  var averageLimitNum = maxLimitNum / 4,
      averageValue = (max - min) / 4;
  var firstPart = [],
      secondPart = [],
      thirdPart = [],
      fourthPart = [];
  serValidPoints.forEach(function (point) {
    var options = point.options;
    var value = axis.getAxisValue(options[key], point) - min;

    if (0 <= value && value < averageValue) {
      firstPart.push(point);
    } else if (value >= averageValue && value < averageValue * 2) {
      secondPart.push(point);
    } else if (value >= averageValue * 2 && value < averageValue * 3) {
      thirdPart.push(point);
    } else {
      fourthPart.push(point);
    }
  });
  var isMarkerDisplayable = firstPart.length <= averageLimitNum && secondPart.length <= averageLimitNum && thirdPart.length <= averageLimitNum && fourthPart.length <= averageLimitNum;
  setSeriesMarkerDisplayable(series, isMarkerDisplayable);
}

function _getAllPointsValue(series, axis, key) {
  var valueArr = [];
  series.forEach(function (ser) {
    var valueOrigin = ser.points.map(function (point) {
      return axis.getAxisValue(point.options[key], point);
    });
    valueArr = valueArr.concat(valueOrigin);
  });
  return valueArr;
}

function _adjustMobileFlowLabel(vanchart) {
  if (vanchart.isMobileFlow()) {
    var manager = new _BoundsManager["default"]();

    for (var i = 0, len = vanchart.series.length; i < len; i++) {
      var ser = vanchart.series[i];

      if (ser.visible) {
        ser.points.forEach(function (point) {
          if (!point.labelPos) {
            return;
          }

          var absLabelPos = ser.getAbsoluteLabelPos(point.labelPos);

          var b = _BaseUtils["default"].makeBounds(absLabelPos, point.labelDim);

          if (manager.isOverlapped(b)) {
            point.labelPos = null;
          } else {
            manager.addBounds(b);
          }
        });
      }
    }
  }
}

function PLANE_SYSTEM_LAYOUT(vanchart) {
  calculateSeries(vanchart);
  coordinateSystemLayout(vanchart);
}

function _adjustPieRadius(series) {
  var _sCache = [];
  var minRadius = series.reduce(function (min, s) {
    if (!s.options.radius) {
      // if it's calculated by us
      _sCache.push(s);
    }

    return min ? Math.min(min, s.chartInfo.radius) : s.chartInfo.radius; // get min calculated radius
  }, 0);

  _sCache.map(function (s) {
    s.adjustRadius(minRadius);
  });
}
/**
 *计算百分比，然后堆积的值，然后标签
 * @private
 */


function _calculatePercentageRelated(vanchart) {
  var stackMap = {},
      series = vanchart.series;

  for (var i = 0, len = series.length; i < len; i++) {
    var ser = series[i],
        type = ser.type;

    if (ser.isTreeSeries() || type == _Constants["default"].WORD_CLOUD_CHART) {
      continue; //树图在内部计算
    }

    if (ser.isSeriesAccumulated()) {
      if (ser._calculatePercentage) {
        ser._calculatePercentage();
      } else {
        var key = ser.getTargetKey();

        _calculatePercentage(ser.points, key);

        _calculateStackedValue(ser.points, key);
      }
    } else {
      if (ser.visible) {
        ser.points.map(function (p) {
          var stackKey = [type, ser.stack, p.getCategory()].join('-');
          stackMap[stackKey] || (stackMap[stackKey] = []);
          stackMap[stackKey].push(p);
        });
      }
    }
  }

  for (var stackKey in stackMap) {
    var points = stackMap[stackKey],
        _series = points[0].series,
        _key = _series.getTargetKey();

    _calculatePercentage(points, _key);

    _calculateStackedValue(points, _key);
  } //百分比确定以后标签也确定了


  for (var i = 0, len = series.length; i < len; i++) {
    var sery = series[i];
    sery._calcCategoryLabel && sery._calcCategoryLabel();
    sery.points.forEach(function (p) {
      sery.calculateLabelInfo(p);
    });
  }

  _calcMaxCateLabelSize(series);
}

function _calcMaxCateLabelSize(series) {
  var maxHeight = -Number.MAX_VALUE;
  series.forEach(function (ser) {
    if (ser.cateLabelProp) {
      maxHeight = Math.max(ser.cateLabelProp.dim.height, maxHeight);
    }
  });
  series.forEach(function (ser) {
    if (ser.cateLabelProp) {
      ser.cateLabelProp.maxHeight = maxHeight;
    }
  });
}

function _calculateSerSummaryValue(vanchart) {
  var series = vanchart.series;
  series.forEach(function (ser) {
    ser.summaryValue = ser.points.filter(function (point) {
      return !point.isNull && point.visible;
    }).reduce(function (sum, point) {
      return sum + point.getTargetValue();
    }, 0);
  });
}

function _calculateTypePercentage(series) {
  if (series && series.length) {
    var allPoints = [];
    series.forEach(function (ser) {
      allPoints = allPoints.concat(ser.points);
    });

    _calculatePercentage(allPoints, series[0].getTargetKey());
  }
}

function calculateDelayTime(vanchart, series, type) {
  var sortFunc, easeFunc;

  if (type == _Constants["default"].BUBBLE_CHART) {
    easeFunc = 'swing';

    sortFunc = function (pointA, pointB) {
      return pointB.radius - pointA.radius;
    };
  } else if (type == _Constants["default"].SCATTER_CHART) {
    var isInverted = vanchart.isInverted();
    easeFunc = 'exp-in-out';

    sortFunc = function (pA, pB) {
      return isInverted ? pA.posY - pB.posY : pA.posX - pB.posX;
    };
  }

  var allPoints = [];
  series.forEach(function (sery) {
    allPoints = allPoints.concat(sery.points);
  });
  allPoints.sort(sortFunc);
  var len = allPoints.length;

  if (len > 0) {
    allPoints.forEach(function (point, i) {
      point.delayTime = _BezierEasing["default"].ease(easeFunc)(i / len) * 800;
    });
  }
}

function calculateBubbleRadius(bubbleSeries) {
  //要先把各个系列计算半径用的最大最小值算清楚，再去算各个点的半径
  bubbleSeries.forEach(function (sery) {
    sery._calculateMinMax4Radius();
  });
  bubbleSeries.forEach(function (sery) {
    sery._calculateBubbleRadius();
  });
}
/**
 * 计算数据点的y0属性，用于数据在值轴上的起始位置计算
 * @param points
 * @param key
 * @private
 */


function _calculateStackedValue(points, key) {
  if (points && points.length) {
    var preSumP, preSumN;
    points.forEach(function (point) {
      // @CHART-1604  这里的series应该是具体point的series.因为points下面的每个point可能不在同一个值轴上
      // 这时如果第一个值轴为对数轴，其他的值轴为普通轴，那么不是对数轴的数据点的y0也会变成1了
      var options = point.options,
          series = point.series;
      var byPercent = series.options.stackByPercent;
      var stack = series.stack || byPercent;
      var stackAxis = series.getStackAxis();
      var dividingLine = stackAxis && stackAxis.isLog() ? 1 : 0; //值轴起始

      if (!(0, _CoreUtils.hasDefined)(preSumP)) {
        preSumP = dividingLine;
      }

      if (!(0, _CoreUtils.hasDefined)(preSumN)) {
        preSumN = dividingLine;
      }

      if (stack) {
        // 堆积值轴
        var usedValue = byPercent ? point.percentage : point.getTargetValue();

        if (usedValue >= dividingLine) {
          options[key + '0'] = preSumP;
          preSumP += usedValue;
        } else {
          options[key + '0'] = preSumN;
          preSumN += usedValue;
        }
      } else {
        options[key + '0'] = dividingLine;
      }
    });
  }
}

function _outOfBound(isHorizontal, bounds, point) {
  var labelPos = point.labelPos,
      labelDim = point.labelDim;
  return isHorizontal ? labelPos.x + labelDim.width / 2 < 0 || labelPos.x - labelDim.width / 2 > bounds.width : labelPos.y + labelDim.height / 2 < 0 || labelPos.y - labelDim.height / 2 > bounds.height;
}

function _calculatePercentage(points, key) {
  var total = 0;
  points.filter(function (d) {
    return !d.isNull && d.visible;
  }).forEach(function (d) {
    total += Math.abs(d[key]) || 0;
  });
  total = total > 0 ? total : 1;
  points.forEach(function (point) {
    var series = point.series,
        key = series.getTargetKey(),
        baseAxis = series[series.getBaseAxisType()];
    var temp = !series.stack && baseAxis && baseAxis.type != _component.ComponentCst.CATEGORY_AXIS_COMPONENT; //不堆积，双值轴，百分比为1

    point.percentage = temp ? 1 : point.series.isNullValue(point) ? 0 : Math.abs(point[key]) / total;
  });
}

function coordinateSystemLayout(vanchart) {
  vanchart.bounds = vanchart._getDefaultBounds();

  _adjustMarkerDisplayable(vanchart, vanchart.seriesOfType(_Constants["default"].LINE_CHART), _Constants["default"].LINE_CHART); // 组件的布局只有在刷新属性的时候会发生


  _component.ComponentsOrder.map(function (c) {
    // axis layout的时候不去clip vanchart.bounds,这一步的时候认为坐标轴和绘图区是一起的
    if (c in vanchart.components) {
      vanchart.components[c] && vanchart.components[c].doLayout();
    }
  }, this); // _initPlotBounds包括坐标轴和绘图区


  vanchart._initPlotBounds = vanchart.bounds;
  calculateAxisComponentsSize(vanchart); // 先确定横向宽度, 再更新分类轴的自动旋转和数据表的高度

  [_component.ComponentCst.Y_AXIS_COMPONENT, _component.ComponentCst.X_AXIS_COMPONENT].forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].updateAxisClip();
  }); // only for axis bounds now

  _cutPlotBounds(vanchart); // 先确定横向宽度, 再更新分类轴的自动旋转和数据表的高度


  [_component.ComponentCst.Y_AXIS_COMPONENT, _component.ComponentCst.X_AXIS_COMPONENT, _component.ComponentCst.DATA_SHEET_COMPONENT].forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].updateAxisSizeAndBounds();
  });
  var adjusted = false; // 先确定横向宽度, 再更新分类轴的自动旋转

  [_component.ComponentCst.Y_AXIS_COMPONENT, _component.ComponentCst.X_AXIS_COMPONENT].forEach(function (cName) {
    adjusted = vanchart.components[cName] && vanchart.components[cName].adjustDomain4Radius() || adjusted;
  });
  [_component.ComponentCst.Y_AXIS_COMPONENT, _component.ComponentCst.X_AXIS_COMPONENT, _component.ComponentCst.DATA_SHEET_COMPONENT, _component.ComponentCst.ZOOM_COMPONENT].forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].fixBoundsByPlot();
  });
  [_component.ComponentCst.X_AXIS_COMPONENT, _component.ComponentCst.Y_AXIS_COMPONENT].forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].dealOnZero();
  }); // CHART-1450
  // 下一步的作用是在js处理值轴的0值对齐之后更新每一个值轴的bounds属性，为什么要提取到这里来写呢？
  // 因为由于CHART-1450我才发现原来散点图的两个轴都是type为value的值轴，
  // 而刚开始的思路是一个图表中的两种坐标轴类型只有一种是值轴，其他的可以是分类轴、时间轴，所以就有了散点图的问题
  // 现将updateAxisBounds提取到这里来调用也是为了避免js重复运算。

  [_component.ComponentCst.X_AXIS_COMPONENT, _component.ComponentCst.Y_AXIS_COMPONENT].forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].updateAxisBounds();
  }); // in case:
  // 'adjustDomain4Radius' adjust yAxis max label 800 -> 1000.
  // Thus yAxis width is changed;

  adjusted && reLayoutPlotBounds(vanchart);
  calculateSeriesShapes(vanchart);
} // todo 统一layout和reLayout的计算内容


function reLayoutPlotBounds(vanchart) {
  calculateAxisBoundsAndClip(vanchart);
  [_component.ComponentCst.X_AXIS_COMPONENT, _component.ComponentCst.Y_AXIS_COMPONENT].forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].dealOnZero();
  });
  [_component.ComponentCst.X_AXIS_COMPONENT, _component.ComponentCst.Y_AXIS_COMPONENT].forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].updateAxisBounds();
  });
} // CHART-1215 / 9.0-0值对齐
// 当处理分类轴对值轴0值对齐之后，改变了某些值轴的_domain和_step，
// 所以需要重新计算这些值轴的所占的宽度、位置以及重新计算在新的_domain和_step下的tickData


function calculateAxisBoundsAndClip(vanchart) {
  // tmp solution: map has no _initPlotBounds
  if (vanchart._initPlotBounds) {
    vanchart.bounds = _QueryUtils["default"].merge({}, vanchart._initPlotBounds);
  }

  vanchart.clipPool = {};
  vanchart.axisSize = {
    'left': 0,
    'right': 0,
    'bottom': 0,
    'top': 0
  }; // 先计算非分类轴的axis的size，再计算分类轴的换行

  calculateAxisComponentsSize(vanchart); // CHART-2118  数据表的布局放在前面，后面axisSize那边会更新clipPool去掉数据表对多计算的部分

  vanchart.components[_component.ComponentCst.DATA_SHEET_COMPONENT] && vanchart.components[_component.ComponentCst.DATA_SHEET_COMPONENT].reCalculateSize(); // 计算首尾标签对vanchart的clipPool的影响

  [_component.ComponentCst.Y_AXIS_COMPONENT, _component.ComponentCst.X_AXIS_COMPONENT].forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].updateAxisClip();
  }); // only for axis bounds now

  _cutPlotBounds(vanchart); // 先确定横向宽度, 再更新分类轴的自动旋转和数据表的高度


  [_component.ComponentCst.Y_AXIS_COMPONENT, _component.ComponentCst.DATA_SHEET_COMPONENT, _component.ComponentCst.X_AXIS_COMPONENT].forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].updateAxisSizeAndBounds();
  });
  [_component.ComponentCst.Y_AXIS_COMPONENT, _component.ComponentCst.X_AXIS_COMPONENT, _component.ComponentCst.ZOOM_COMPONENT, _component.ComponentCst.DATA_SHEET_COMPONENT].forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].fixBoundsByPlot();
  });
}

function calculateAxisComponentsSize(vanchart) {
  var axisComponentsOrder = [_component.ComponentCst.Y_AXIS_COMPONENT, _component.ComponentCst.X_AXIS_COMPONENT]; // 先计算值轴的size，再计算分类轴的size

  if (vanchart.components[_component.ComponentCst.Y_AXIS_COMPONENT]) {
    var _axisList = vanchart.components[_component.ComponentCst.Y_AXIS_COMPONENT]._axisList;

    for (var i = _axisList.length - 1; i >= 0; i--) {
      if (_axisList[i].isCategory()) {
        axisComponentsOrder = axisComponentsOrder.reverse();
        break;
      }
    }
  }

  axisComponentsOrder.forEach(function (cName) {
    vanchart.components[cName] && vanchart.components[cName].calculateAxisSize();
  });
} // compare bounds to check if we need cut more


function _cutPlotBounds(vanchart) {
  var chartBounds = vanchart.getChartBounds();
  var originBounds = vanchart.bounds;
  var x = originBounds.x;
  var y = originBounds.y;
  var width = originBounds.width;
  var height = originBounds.height;
  var left = Math.max(vanchart.clipPool[_Constants["default"].LEFT] || 0, x);
  var right = Math.max(vanchart.clipPool[_Constants["default"].RIGHT] || 0, chartBounds.width - (x + width));
  var top = Math.max(vanchart.clipPool[_Constants["default"].TOP] || 0, y);
  var bottom = Math.max(vanchart.clipPool[_Constants["default"].BOTTOM] || 0, chartBounds.height - (y + height));
  originBounds = {
    x: left,
    y: top,
    width: chartBounds.width - left - right,
    height: chartBounds.height - top - bottom
  };
  vanchart.setPlotBounds(originBounds);
}

var _default = {
  PLANE_SYSTEM_LAYOUT: PLANE_SYSTEM_LAYOUT,
  reLayoutPlotBounds: reLayoutPlotBounds,
  calculateBubbleRadius: calculateBubbleRadius,
  calculateDelayTime: calculateDelayTime,
  calculateSeries: calculateSeries,
  calculateSeriesShapes: calculateSeriesShapes,
  calculateAxisBoundsAndClip: calculateAxisBoundsAndClip
};
exports["default"] = _default;

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderRectangleBackground = renderRectangleBackground;
exports.BACKGROUND_SHADOW_FILTER = void 0;

var _EnvUtils = __webpack_require__(3);

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

var _Constants = _interopRequireDefault(__webpack_require__(1));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var BACKGROUND_SHADOW_FILTER = {
  dx: 0,
  dy: 0,
  opacity: 0.4,
  deviation: 3,
  r: 0 / 255,
  g: 0 / 255,
  b: 0 / 255
};
exports.BACKGROUND_SHADOW_FILTER = BACKGROUND_SHADOW_FILTER;

function getBackgroundImageFill(backgroundGroup, options, bounds, renderer) {
  var x = bounds.x,
      y = bounds.y,
      width = bounds.width,
      height = bounds.height;
  var patterAttr = {
    x: x,
    y: y,
    width: width,
    height: height,
    patternUnits: 'userSpaceOnUse'
  };
  var imageAttr = {
    x: 0,
    y: 0,
    width: width,
    height: height,
    preserveAspectRatio: 'none'
  };
  var p = {
    options: {
      imageHeight: height,
      imageWidth: width
    },
    rect: {
      x: x,
      y: y,
      width: width,
      height: height
    },
    location: _Constants["default"].BOTTOM_TO_TOP
  };

  if (backgroundGroup.imageFill) {
    renderer.updateImagePattern(backgroundGroup.imageFill, patterAttr, imageAttr, options.backgroundImage);
  } else {
    backgroundGroup.imageFill = renderer.imagePattern(patterAttr, imageAttr, options.backgroundImage, p);
  }

  return renderer.toPatternProperty(backgroundGroup.imageFill);
}

function getBackgroundColorGradientFill(backgroundGroup, options, bounds, renderer) {
  if (!(0, _EnvUtils.supportFillFilter)()) {
    return options.backgroundColor.startColor;
  }

  var gradualOption = options.backgroundColor;
  var attrs = {
    'x1': gradualOption.x1,
    'y1': gradualOption.y1,
    'x2': gradualOption.x2,
    'y2': gradualOption.y2
  };
  var stop1 = {
    'offset': '0%',
    'stop-color': gradualOption.startColor
  };
  var stop2 = {
    'offset': '100%',
    'stop-color': gradualOption.endColor
  };

  if (backgroundGroup.gradientFill) {
    renderer.updateColorGradient(backgroundGroup.gradientFill, attrs, [stop1, stop2]);
  } else {
    backgroundGroup.gradientFill = renderer.colorGradient(attrs, [stop1, stop2]);
  }

  return renderer.toPatternProperty(backgroundGroup.gradientFill);
}

function getBackgroundFill(backgroundGroup, options, bounds, renderer) {
  if (!options.backgroundColor && !options.backgroundImage) {
    return 'none';
  }

  if (options.backgroundImage) {
    return getBackgroundImageFill(backgroundGroup, options, bounds, renderer);
  }

  if (options.backgroundColor && typeof options.backgroundColor == 'object') {
    return getBackgroundColorGradientFill(backgroundGroup, options, bounds, renderer);
  }

  return options.backgroundColor;
}

function getBackgroundShadowFilter(backgroundGroup, renderer) {
  var dx = BACKGROUND_SHADOW_FILTER.dx,
      dy = BACKGROUND_SHADOW_FILTER.dy,
      opacity = BACKGROUND_SHADOW_FILTER.opacity,
      deviation = BACKGROUND_SHADOW_FILTER.deviation,
      r = BACKGROUND_SHADOW_FILTER.r,
      g = BACKGROUND_SHADOW_FILTER.g,
      b = BACKGROUND_SHADOW_FILTER.b;
  backgroundGroup.backgroundShadowFilter = backgroundGroup.backgroundShadowFilter || renderer.createDropShadowFilter(dx, dy, opacity, deviation, r, g, b);
  return renderer.toPatternProperty(backgroundGroup.backgroundShadowFilter);
}

function getBackgroundStyle(backgroundGroup, options, bounds, renderer) {
  var style = {
    fill: getBackgroundFill(backgroundGroup, options, bounds, renderer),
    stroke: options.borderColor || 'none',
    'stroke-width': options.borderWidth
  };

  if (options.shadow) {
    var noFillAndStroke = !options.backgroundImage && (!options.backgroundColor || _ColorUtils["default"].getColorOpacity(options.backgroundColor) === 0) && (!options.borderColor || _ColorUtils["default"].getColorOpacity(options.borderColor) === 0 || options.borderWidth === 0); // 没有填充图片没有填充颜色也没有边框颜色，却开启了阴影，需要给style加个stroke，不然filter会没有阴影效果

    if (noFillAndStroke) {
      style.stroke = 'rgb(238,238,238)';
      style['stroke-width'] = 1;
    }

    style.filter = getBackgroundShadowFilter(backgroundGroup, renderer);
  }

  return style;
}
/**
 * 绘制图表背景(颜色,背景图,阴影等)
 * @param backgroundGroup
 * @param options
 * @param bounds
 * @param renderer
 * @returns {*}
 */


function renderRectangleBackground(backgroundGroup, options, bounds, renderer) {
  if (!backgroundGroup) {
    return;
  }

  if (!options.backgroundImage) {
    backgroundGroup.imageFill && backgroundGroup.imageFill.remove();
    backgroundGroup.imageFill = null;
  }

  if (!options.backgroundColor || typeof options.backgroundColor != 'object') {
    backgroundGroup.gradientFill && backgroundGroup.gradientFill.remove();
    backgroundGroup.gradientFill = null;
  }

  if (!options.shadow) {
    backgroundGroup.backgroundShadowFilter && backgroundGroup.backgroundShadowFilter.remove();
    backgroundGroup.backgroundShadowFilter = null;
  }

  var borderWidth = options.borderWidth || 0;
  var det = borderWidth / 2;

  var borderBounds = _BaseUtils["default"].rectSubPixelOpt(bounds.x + det, bounds.y + det, Math.max(bounds.width - borderWidth, 0), Math.max(bounds.height - borderWidth, 0), borderWidth);

  borderBounds.rx = borderBounds.ry = options.borderRadius || 0;
  var style = getBackgroundStyle(backgroundGroup, options, bounds, renderer);
  backgroundGroup.backgroundRect = backgroundGroup.backgroundRect || renderer.rect().addTo(backgroundGroup);
  backgroundGroup.backgroundRect.attr(borderBounds).style(style);
  return backgroundGroup.backgroundRect;
}

/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.richTextSpanMount = richTextSpanMount;
exports.createRichTextLabel = createRichTextLabel;
exports.createDivRichTextWrapper = createDivRichTextWrapper;
exports.createRichTextTooltip = createRichTextTooltip;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _richTextDetail = __webpack_require__(47);

var _VanChartLabelBorder = __webpack_require__(40);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var DEFAULT_PADDING = 5; // fixme 参数有点多了

function richTextSpanMount(renderer, textWrapper, richTextContent, richTextDim, labelPadding, useHtml) {
  var halfHeight = richTextDim.height / 2;
  var halfWidth = richTextDim.width / 2;
  var horizontal = 0;
  var vertical = 0;

  if (labelPadding && labelPadding.length === 2) {
    horizontal = labelPadding[0] / 2;
    vertical = labelPadding[1] / 2;
  }

  var startY = 0;
  textWrapper.tspans = [];

  if (richTextContent && richTextContent.length) {
    var rowShift = (0, _richTextDetail.getAlignShift)(richTextContent, richTextDim, horizontal);
    var baseLineShift = (0, _richTextDetail.getBaseLineShift)(richTextContent);

    for (var rowIndex = 0, rowLen = richTextContent.length; rowIndex < rowLen; rowIndex++) {
      var row = richTextContent[rowIndex];
      var curRowBaseLineShift = baseLineShift[rowIndex];

      if (row && row.length) {
        var xShift = -halfWidth,
            yShift = -halfHeight;
        var alignShift = rowShift[rowIndex];
        var rowHeight = 0;

        for (var fieldIndex = 0, fieldLen = row.length; fieldIndex < fieldLen; fieldIndex++) {
          var _row$fieldIndex = row[fieldIndex],
              value = _row$fieldIndex.text,
              style = _row$fieldIndex.style,
              dim = _row$fieldIndex.dim;

          var _baseLineShift = dim.height * 0.85;

          textWrapper.tspans.push(renderer.vtspan(useHtml).style({
            'margin-top': -halfHeight + 'px',
            'text-align': "center",
            'white-space': "nowrap"
          }).attr('y', vertical + startY + curRowBaseLineShift[fieldIndex]).attr('x', 0).attr('dy', yShift + _baseLineShift).attr('dx', xShift + alignShift).style({
            color: style.color,
            fontFamily: style.fontFamily,
            fontSize: style.fontSize,
            fontStyle: style.fontStyle,
            fontWeight: style.fontWeight,
            textDecoration: style.textDecoration
          }).textContent(value).addTo(textWrapper));
          xShift += dim.width;
          rowHeight = Math.max(rowHeight, dim.height);
        }

        startY += rowHeight + _richTextDetail.LABEL_GAP;
      }
    }
  }
}

function createRichTextLabel(point) {
  var series = point.series,
      vanchart = series.vanchart,
      renderer = vanchart.renderer;

  var textLabelGroup = series._getPointTextLabelGroup();

  var textWrapper = renderer.text().attr('transform', _BaseUtils["default"].makeTranslate(series._labelTrans(point))).style({
    'pointer-events': 'none'
  });
  var labelPadding = [(0, _VanChartLabelBorder.getHorizontalPadding)(point), 0];
  richTextSpanMount(renderer, textWrapper, point.labelContent, point.labelDim, labelPadding, false);
  point.textGraphic = textLabelGroup.append(textWrapper);
}

function createDivRichTextWrapper(point, richTextContent, wrapperOffset, labelPadding) {
  if (wrapperOffset === void 0) {
    wrapperOffset = 0;
  }

  if (labelPadding === void 0) {
    labelPadding = [0, 0];
  }

  var series = point.series,
      vanchart = series.vanchart,
      renderer = vanchart.renderer;
  var richTextDim = (0, _richTextDetail.getRichTextDim)(richTextContent);
  var textWrapper = renderer.vtext(true).attr('transform', _BaseUtils["default"].makeTranslate({
    x: richTextDim.width / 2 + wrapperOffset,
    y: richTextDim.height / 2 + wrapperOffset
  })).style({
    'pointer-events': 'none'
  });
  richTextSpanMount(renderer, textWrapper, richTextContent, richTextDim, labelPadding, true);
  return textWrapper;
}

function createRichTextTooltip(point, richTextContent, dom, wrapperOffset) {
  if (wrapperOffset === void 0) {
    wrapperOffset = DEFAULT_PADDING;
  }

  var textWrapper = createDivRichTextWrapper(point, richTextContent, wrapperOffset);

  var _dom = document.createElement('div');

  _dom.appendChild(textWrapper.node());

  dom.innerHTML = _dom.innerHTML;
  point.richTextTooltip = textWrapper;
  _dom.innerHTML = "";
}

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRichTextDim = getRichTextDim;
exports.getBaseLineShift = getBaseLineShift;
exports.getAlignShift = getAlignShift;
exports.getLabelRichTextDetail = getLabelRichTextDetail;
exports.getTooltipRichTextDetail = getTooltipRichTextDetail;
exports.LABEL_GAP = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _CoreUtils = __webpack_require__(2);

var _richTextParser = __webpack_require__(74);

var _FormattedText = __webpack_require__(39);

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _AutoFitUtils = __webpack_require__(17);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var LABEL_COLOR = '#666666';
var TOOLTIP_COLOR = '#ffffff';
var LABEL_GAP = 2;
exports.LABEL_GAP = LABEL_GAP;

function getMapField(point, series, formatter, key) {
  if (key.indexOf(_FormattedText.VALUE) !== -1 || key.indexOf(_FormattedText.SIZE) !== -1) {
    return _BaseUtils["default"].format(point.originalValue, formatter.valueFormat);
  }

  return getDefaultField(point, series, formatter, key);
}

function getBubbleField(point, series, formatter, key) {
  var options = point.options;

  if (key === _FormattedText.X) {
    return _BaseUtils["default"].format(options.x, formatter.XFormat);
  } else if (key === _FormattedText.Y) {
    return _BaseUtils["default"].format(options.y, formatter.YFormat);
  } else if (key === _FormattedText.SIZE) {
    return _BaseUtils["default"].format(options.size, formatter.sizeFormat);
  }

  return getDefaultField(point, series, formatter, key);
}

function getLineMapField(point, series, formatter, key) {
  var options = point.options;

  if (key.indexOf(_FormattedText.FROM) !== -1 && key.indexOf(_FormattedText.TO) !== -1) {
    return options.from.name + '→' + options.to.name;
  }

  return getMapField(point, series, formatter, key);
}

function getBoxField(point, series, formatter, key) {
  var result = point.dataResult;

  if (result == null) {
    return '';
  }

  var valueGroup = [result.number, result.max, result.q3, result.median, result.q1, result.min];
  var formatterGroup = [formatter.dataNumberFormat, formatter.dataMaxFormat, formatter.dataQ3Format, formatter.dataMedianFormat, formatter.dataQ1Format, formatter.dataMinFormat];
  var identifier = [_FormattedText.DATA_NUMBER, _FormattedText.DATA_MAX, _FormattedText.DATA_Q3, _FormattedText.DATA_MEDIAN, _FormattedText.DATA_Q1, _FormattedText.DATA_MIN];
  var index = identifier.indexOf(key);

  if (index !== -1) {
    return _BaseUtils["default"].format(valueGroup[index], formatterGroup[index]);
  }

  if (key === _FormattedText.DATA_OUTLIER) {
    if ((0, _CoreUtils.hasDefined)(point.outlierData)) {
      var outlier = point.outlierData.outlier;

      if ((0, _CoreUtils.hasDefined)(outlier)) {
        return _BaseUtils["default"].format(outlier, formatter.dataOutlierFormat);
      }
    }

    return '';
  }

  return getDefaultField(point, series, formatter, key);
}

function getCustomField(point, series, formatter, field) {
  var formatKey = field.text;

  var _ref = formatter[formatKey] || {},
      format = _ref.format,
      formula = _ref.formula;

  var origin = point.options[formula];

  if (origin && format) {
    return _BaseUtils["default"].format(origin, format);
  }

  return '';
}

function getDefaultField(point, series, formatter, key) {
  var prop = _FormattedText.propMap[key];

  if (prop && prop.length === 2) {
    var propKey = prop[0],
        fmtKey = prop[1];
    var origin = point[propKey];

    var format = formatter[fmtKey] || series._getTooltipFormatFn && series._getTooltipFormatFn(propKey);

    return _BaseUtils["default"].format(origin, format);
  }

  return '';
}

function getFormattedText(point, series, formatter, field) {
  if ((0, _CoreUtils.isEmpty)(field)) {
    return '';
  }

  var text = field.text,
      isField = field.isField;

  if (isField) {
    // 富文本解析出来的text含有$
    var key = text.substring(1);
    var type = series.type;

    if (type === _Constants["default"].LINE_MAP) {
      return getLineMapField(point, series, formatter, key);
    }

    if (series.vanchart.isMap()) {
      return getMapField(point, series, formatter, key);
    }

    if (type === _Constants["default"].BUBBLE_CHART || type === _Constants["default"].SCATTER_CHART) {
      return getBubbleField(point, series, formatter, key);
    }

    if (type === _Constants["default"].BOX_CHART) {
      return getBoxField(point, series, formatter, key);
    }

    if ((0, _CoreUtils.hasNotDefined)(_FormattedText.propMap[key])) {
      return getCustomField(point, series, formatter, field);
    }

    return getDefaultField(point, series, formatter, key);
  }

  return text;
}

function getRichTextDim(richTextContent) {
  var width = 0,
      height = 0;

  if (richTextContent && richTextContent.length) {
    for (var rowIndex = 0, rowLen = richTextContent.length; rowIndex < rowLen; rowIndex++) {
      var row = richTextContent[rowIndex];
      var rowWidth = 0,
          rowHeight = 0;

      if (row && row.length) {
        for (var fieldIndex = 0, fieldLen = row.length; fieldIndex < fieldLen; fieldIndex++) {
          var dim = row[fieldIndex].dim;
          rowWidth += dim.width;
          rowHeight = Math.max(rowHeight, dim.height);
        }
      }

      width = Math.max(width, rowWidth);
      height += rowHeight + LABEL_GAP;
    }

    height -= LABEL_GAP;
  }

  return {
    width: width,
    height: height
  };
}

function getBaseLineShift(richTextContent) {
  if (richTextContent && richTextContent.length) {
    var baseLineShift = [];

    for (var rowIndex = 0, rowLen = richTextContent.length; rowIndex < rowLen; rowIndex++) {
      var row = richTextContent[rowIndex];

      if (row && row.length) {
        var curRowShift = [];
        var rowHeight = 0;

        for (var fieldIndex = 0, fieldLen = row.length; fieldIndex < fieldLen; fieldIndex++) {
          var dim = row[fieldIndex].dim;
          rowHeight = Math.max(rowHeight, dim.height);
        }

        for (var _fieldIndex = 0, _fieldLen = row.length; _fieldIndex < _fieldLen; _fieldIndex++) {
          var _dim = row[_fieldIndex].dim;
          var curFieldShift = (rowHeight - _dim.height) / 2;
          curRowShift.push(curFieldShift);
        }

        baseLineShift.push(curRowShift);
      }
    }

    return baseLineShift;
  }
}

function getAlignShift(richTextContent, labelDim, padding) {
  var width = labelDim.width;

  if (richTextContent && richTextContent.length) {
    var rowShift = [];

    for (var rowIndex = 0, rowLen = richTextContent.length; rowIndex < rowLen; rowIndex++) {
      var row = richTextContent[rowIndex];
      var alignShift = padding;
      var align = '';
      var rowWidth = 0;

      if (row && row.length) {
        rowWidth = 0;
        align = '';

        for (var fieldIndex = 0, fieldLen = row.length; fieldIndex < fieldLen; fieldIndex++) {
          var _row$fieldIndex = row[fieldIndex],
              dim = _row$fieldIndex.dim,
              style = _row$fieldIndex.style;
          rowWidth += dim.width;
          align = align || style.textAlign;
        }
      }

      if (align.trim() === 'center') {
        alignShift = (width - rowWidth) / 2;
      }

      if (align.trim() === 'right') {
        alignShift = width - rowWidth - padding;
      }

      rowShift.push(alignShift);
    }

    return rowShift;
  }
}

function getAutoStyle(point, isTooltip) {
  var fontScale = (0, _AutoFitUtils.autoFitFontScale)(point.series.vanchart);
  var color = isTooltip ? TOOLTIP_COLOR : point.autoLabelColor();
  return {
    fontSize: 12 * fontScale + 'px',
    fontFamily: 'Verdana',
    color: color,
    textAlign: "left"
  };
}

function getFieldStyle(point, fieldStyle, autoStyle, useAutoStyle, customColor) {
  if (fieldStyle == null) {
    return autoStyle;
  }

  var fontScale = (0, _AutoFitUtils.autoFitFontScale)(point.series.vanchart);

  if ((0, _CoreUtils.isEmpty)(fieldStyle.fontSize)) {
    fieldStyle.fontSize = autoStyle.fontSize;
  } else {
    fieldStyle.fontSize = parseFloat(fieldStyle.fontSize) * fontScale + 'px';
  }

  if ((0, _CoreUtils.isEmpty)(fieldStyle.fontFamily)) {
    fieldStyle.fontFamily = autoStyle.fontFamily;
  }

  if ((0, _CoreUtils.isEmpty)(fieldStyle.color)) {
    fieldStyle.color = useAutoStyle ? autoStyle.color : customColor;
  }

  return fieldStyle;
}

function getLabelRichTextDetail(point, richTextStr, useAutoStyle, formatter) {
  return _getRichTextDetail(point, richTextStr, useAutoStyle, formatter, false);
}

function getTooltipRichTextDetail(point, richTextStr, useAutoStyle, formatter) {
  return _getRichTextDetail(point, richTextStr, useAutoStyle, formatter, true);
}

function _getRichTextDetail(point, richTextStr, useAutoStyle, formatter, isTooltip) {
  var series = point.series;

  if ((0, _CoreUtils.isEmpty)(richTextStr)) {
    return [];
  }

  var result = [];
  var isMap = series && series.vanchart.isMap();
  var content = (0, _richTextParser.richTextParse)(richTextStr);

  for (var rowIndex = 0, rowLen = content.length; rowIndex < rowLen; rowIndex++) {
    var row = content[rowIndex];

    if (row && row.length) {
      var line = [];

      for (var fieldIndex = 0, fieldLen = row.length; fieldIndex < fieldLen; fieldIndex++) {
        var field = row[fieldIndex];
        var customColor = isTooltip ? TOOLTIP_COLOR : LABEL_COLOR;
        var style = getFieldStyle(point, field.style, getAutoStyle(point, isTooltip), useAutoStyle, customColor);
        var text = getFormattedText(point, series, formatter, field) || '';

        var dim = _BaseUtils["default"].getTextDimension(text, style, isTooltip || isMap);

        line.push({
          text: text,
          style: style,
          dim: dim
        });
      }

      result.push(line);
    }
  }

  return result;
}

/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/*! Hammer.JS - v2.0.7 - 2016-04-22
 * http://hammerjs.github.io/
 *
 * Copyright (c) 2016 Jorik Tangelder;
 * Licensed under the MIT license */


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
var TEST_ELEMENT = document.createElement('div');
var TYPE_FUNCTION = 'function';
var MOUSE_UP_DOWN = 'mousedown mouseup pointerdown pointerup MSPointerDown MSPointerUp';

var _preventDefault = function (e) {
  if (e.type && MOUSE_UP_DOWN.indexOf(e.type) != -1) {
    //bi那边不能prevent
    return;
  }

  if (e.preventDefault) {
    e.preventDefault();
  } else {
    e.returnValue = false;
  }

  return this;
};

var ie8 = !window.SVGSVGElement;
var round = Math.round;
var abs = Math.abs;
var now = Date.now;
/**
 * set a timeout with a given scope
 * @param {Function} fn
 * @param {Number} timeout
 * @param {Object} context
 * @returns {number}
 */

function setTimeoutContext(fn, timeout, context) {
  return setTimeout(bindFn(fn, context), timeout);
}
/**
 * if the argument is an array, we want to execute the fn on each entry
 * if it aint an array we don't want to do a thing.
 * this is used by all the methods that accept a single and array argument.
 * @param {*|Array} arg
 * @param {String} fn
 * @param {Object} [context]
 * @returns {Boolean}
 */


function invokeArrayArg(arg, fn, context) {
  if (Array.isArray(arg)) {
    each(arg, context[fn], context);
    return true;
  }

  return false;
}
/**
 * walk objects and arrays
 * @param {Object} obj
 * @param {Function} iterator
 * @param {Object} context
 */


function each(obj, iterator, context) {
  var i;

  if (!obj) {
    return;
  }

  if (obj.forEach) {
    obj.forEach(iterator, context);
  } else if (obj.length !== undefined) {
    i = 0;

    while (i < obj.length) {
      iterator.call(context, obj[i], i, obj);
      i++;
    }
  } else {
    for (i in obj) {
      obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
    }
  }
}
/**
 * wrap a method with a deprecation warning and stack trace
 * @param {Function} method
 * @param {String} name
 * @param {String} message
 * @returns {Function} A new function wrapping the supplied method.
 */


function deprecate(method, name, message) {
  var deprecationMessage = 'DEPRECATED METHOD: ' + name + '\n' + message + ' AT \n';
  return function () {
    var e = new Error('get-stack-trace');
    var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '').replace(/^\s+at\s+/gm, '').replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace'; // var log = window.console && (window.console.warn || window.console.log);
    // if (log) {
    //     log.call(window.console, deprecationMessage, stack);
    // }

    return method.apply(this, arguments);
  };
}
/**
 * extend object.
 * means that properties in dest will be overwritten by the ones in src.
 * @param {Object} dest
 * @param {Object} src
 * @param {Boolean} [merge=false]
 * @returns {Object} dest
 */


var extend = deprecate(function extend(dest, src, merge) {
  var keys = Object.keys(src);
  var i = 0;

  while (i < keys.length) {
    if (!merge || merge && dest[keys[i]] === undefined) {
      dest[keys[i]] = src[keys[i]];
    }

    i++;
  }

  return dest;
}, 'extend', 'Use `assign`.');
/**
 * merge the values from src in the dest.
 * means that properties that exist in dest will not be overwritten by src
 * @param {Object} dest
 * @param {Object} src
 * @returns {Object} dest
 */

var merge = deprecate(function merge2(dest, src) {
  // CHART-13227 如果命名为merge，IE8下会将原有merge代替这个fn
  return extend(dest, src, true);
}, 'merge', 'Use `assign`.');
/**
 * simple class inheritance
 * @param {Function} child
 * @param {Function} base
 * @param {Object} [properties]
 */

function inherit(child, base, properties) {
  var baseP = base.prototype,
      childP;
  childP = child.prototype = Object.create(baseP);
  childP.constructor = child;
  childP._super = baseP;

  if (properties) {
    (0, _CoreUtils.assign)(childP, properties);
  }
}
/**
 * simple function bind
 * @param {Function} fn
 * @param {Object} context
 * @returns {Function}
 */


function bindFn(fn, context) {
  return function boundFn() {
    return fn.apply(context, arguments);
  };
}
/**
 * let a boolean value also be a function that must return a boolean
 * this first item in args will be used as the context
 * @param {Boolean|Function} val
 * @param {Array} [args]
 * @returns {Boolean}
 */


function boolOrFn(val, args) {
  if (typeof val == TYPE_FUNCTION) {
    return val.apply(args ? args[0] || undefined : undefined, args);
  }

  return val;
}
/**
 * use the val2 when val1 is undefined
 * @param {*} val1
 * @param {*} val2
 * @returns {*}
 */


function ifUndefined(val1, val2) {
  return val1 === undefined ? val2 : val1;
}
/**
 * addEventListener with multiple events at once
 * @param {EventTarget} target
 * @param {String} types
 * @param {Function} handler
 */


function addEventListeners(target, types, handler) {
  each(splitStr(types), function (type) {
    if (target.addEventListener) {
      // IE9开始支持addEventListener和wheel，同时保留了非标准的事件mousewheel
      // IE9-IE11中"onwheel" in target返回false,为BUG,在Edge中已修复:https://connect.microsoft.com/IE/Feedback/Details/768199
      target.addEventListener(type, handler, false);
    } else if (target.attachEvent) {
      if (type == 'wheel') {
        type = 'mousewheel';
      }

      target.attachEvent('on' + type, handler);
    }
  });
  return this;
}
/**
 * removeEventListener with multiple events at once
 * @param {EventTarget} target
 * @param {String} types
 * @param {Function} handler
 */


function removeEventListeners(target, types, handler) {
  each(splitStr(types), function (type) {
    if (target.removeEventListener) {
      target.removeEventListener(type, handler, false);
    } else if (target.detachEvent) {
      if (type == 'wheel') {
        type = 'mousewheel';
      }

      target.detachEvent('on' + type, handler);
    }
  });
}
/**
 * find if a node is in the given parent
 * @method hasParent
 * @param {HTMLElement} node
 * @param {HTMLElement} parent
 * @return {Boolean} found
 */


function hasParent(node, parent) {
  while (node) {
    if (node == parent) {
      return true;
    }

    node = node.parentNode;
  }

  return false;
}
/**
 * small indexOf wrapper
 * @param {String} str
 * @param {String} find
 * @returns {Boolean} found
 */


function inStr(str, find) {
  return str.indexOf(find) > -1;
}
/**
 * split string on whitespace
 * @param {String} str
 * @returns {Array} words
 */


function splitStr(str) {
  return str.trim().split(/\s+/g);
}
/**
 * find if a array contains the object using indexOf or a simple polyFill
 * @param {Array} src
 * @param {String} find
 * @param {String} [findByKey]
 * @return {Boolean|Number} false when not found, or the index
 */


function inArray(src, find, findByKey) {
  if (src.indexOf && !findByKey) {
    return src.indexOf(find);
  } else {
    var i = 0;

    while (i < src.length) {
      if (findByKey && src[i][findByKey] == find || !findByKey && src[i] === find) {
        return i;
      }

      i++;
    }

    return -1;
  }
}
/**
 * convert array-like objects to real arrays
 * @param {Object} obj
 * @returns {Array}
 */


function toArray(obj) {
  return Array.prototype.slice.call(obj, 0);
}
/**
 * unique array with objects based on a key (like 'id') or just by the array's value
 * @param {Array} src [{id:1},{id:2},{id:1}]
 * @param {String} [key]
 * @param {Boolean} [sort=False]
 * @returns {Array} [{id:1},{id:2}]
 */


function uniqueArray(src, key, sort) {
  var results = [];
  var values = [];
  var i = 0;

  while (i < src.length) {
    var val = key ? src[i][key] : src[i];

    if (inArray(values, val) < 0) {
      results.push(src[i]);
    }

    values[i] = val;
    i++;
  }

  if (sort) {
    if (!key) {
      results = results.sort();
    } else {
      results = results.sort(function sortUniqueArray(a, b) {
        return a[key] > b[key];
      });
    }
  }

  return results;
}
/**
 * get the prefixed property
 * @param {Object} obj
 * @param {String} property
 * @returns {String|Undefined} prefixed
 */


function prefixed(obj, property) {
  if (false) {}

  var prefix, prop;
  var camelProp = property.charAt(0).toUpperCase() + property.slice(1);
  var i = 0;

  while (i < VENDOR_PREFIXES.length) {
    prefix = VENDOR_PREFIXES[i];
    prop = prefix ? prefix + camelProp : property;

    if (prop in obj) {
      return prop;
    }

    i++;
  }

  return undefined;
}
/**
 * get a unique id
 * @returns {number} uniqueId
 */


var _uniqueId = 1;

function uniqueId() {
  return _uniqueId++;
}
/**
 * get the window object of an element
 * @param {HTMLElement} element
 * @returns {DocumentView|Window}
 */


function getWindowForElement(element) {
  var doc = element.ownerDocument || element;
  return doc.defaultView || doc.parentWindow || window;
}

var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
var SUPPORT_TOUCH = ('ontouchstart' in window);
var SUPPORT_POINTER_EVENTS = prefixed(window, 'PointerEvent') !== undefined && !_Browser["default"].ios;
var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
var INPUT_TYPE_TOUCH = 'touch';
var INPUT_TYPE_PEN = 'pen';
var INPUT_TYPE_MOUSE = 'mouse';
var INPUT_TYPE_KINECT = 'kinect';
var COMPUTE_INTERVAL = 25;
var INPUT_START = 1;
var INPUT_MOVE = 2;
var INPUT_END = 4;
var INPUT_CANCEL = 8;
var DIRECTION_NONE = 1;
var DIRECTION_LEFT = 2;
var DIRECTION_RIGHT = 4;
var DIRECTION_UP = 8;
var DIRECTION_DOWN = 16;
var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
var PROPS_XY = ['x', 'y'];
var PROPS_CLIENT_XY = ['clientX', 'clientY'];
/**
 * create new input type manager
 * @param {Manager} manager
 * @param {Function} callback
 * @returns {Input}
 * @constructor
 */

function Input(manager, callback) {
  var self = this;
  this.manager = manager;
  this.callback = callback;
  this.element = manager.element;
  this.target = manager.options.inputTarget; // smaller wrapper around the handler, for the scope and the enabled state of the manager,
  // so when disabled the input events are completely bypassed.

  this.domHandler = function (ev) {
    if (boolOrFn(manager.options.enable, [manager])) {
      self.handler(ev);
    }
  };

  this.init();
}

Input.prototype = {
  /**
   * should handle the inputEvent data and trigger the callback
   * @virtual
   */
  handler: function () {},

  /**
   * bind the events
   */
  init: function () {
    this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
    this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
    this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler); //TODO CHART-1238
  },

  /**
   * unbind the events
   */
  destroy: function () {
    this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
    this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
    this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
  }
};
/**
 * create new input type manager
 * called by the Manager constructor
 * @param {VanHammer} manager
 * @returns {Input}
 */

function createInputInstance(manager) {
  var Type;
  var inputClass = manager.options.inputClass;

  if (inputClass) {
    Type = inputClass;
  } else if (SUPPORT_POINTER_EVENTS) {
    Type = PointerEventInput;
  } else if (SUPPORT_ONLY_TOUCH) {
    Type = TouchInput;
  } else if (!SUPPORT_TOUCH) {
    Type = MouseInput;
  } else {
    Type = TouchMouseInput;
  }

  return new Type(manager, inputHandler);
}
/**
 * handle input events
 * @param {Manager} manager
 * @param {String} eventType
 * @param {Object} input
 */


function inputHandler(manager, eventType, input) {
  var pointersLen = input.pointers.length;
  var changedPointersLen = input.changedPointers.length;
  var isFirst = eventType & INPUT_START && pointersLen - changedPointersLen === 0;
  var isFinal = eventType & (INPUT_END | INPUT_CANCEL) && pointersLen - changedPointersLen === 0;
  input.isFirst = !!isFirst;
  input.isFinal = !!isFinal;

  if (isFirst) {
    manager.session = {};
  } // source event is the normalized value of the domEvents
  // like 'touchstart, mouseup, pointerdown'


  input.eventType = eventType; // compute scale, rotation etc

  computeInputData(manager, input); // emit secret event

  manager.emit('hammer.input', input);
  manager.recognize(input);
  manager.session.prevInput = input;
}
/**
 * extend the data with some usable properties like scale, rotate, velocity etc
 * @param {Object} manager
 * @param {Object} input
 */


function computeInputData(manager, input) {
  var session = manager.session;
  var pointers = input.pointers;
  var pointersLength = pointers.length; // store the first input to calculate the distance and direction

  if (!session.firstInput) {
    session.firstInput = simpleCloneInputData(input);
  } // to compute scale and rotation we need to store the multiple touches


  if (pointersLength > 1 && !session.firstMultiple) {
    session.firstMultiple = simpleCloneInputData(input);
  } else if (pointersLength === 1) {
    session.firstMultiple = false;
  }

  var firstInput = session.firstInput;
  var firstMultiple = session.firstMultiple;
  var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;
  var center = input.center = getCenter(pointers);
  input.timeStamp = now();
  input.deltaTime = input.timeStamp - firstInput.timeStamp;
  input.angle = getAngle(offsetCenter, center);
  input.distance = getDistance(offsetCenter, center);
  computeDeltaXY(session, input);
  input.offsetDirection = getDirection(input.deltaX, input.deltaY);
  var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
  input.overallVelocityX = overallVelocity.x;
  input.overallVelocityY = overallVelocity.y;
  input.overallVelocity = abs(overallVelocity.x) > abs(overallVelocity.y) ? overallVelocity.x : overallVelocity.y;
  input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
  input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;
  input.maxPointers = !session.prevInput ? input.pointers.length : input.pointers.length > session.prevInput.maxPointers ? input.pointers.length : session.prevInput.maxPointers;
  computeIntervalInputData(session, input); // find the correct target

  var target = manager.element;

  if (hasParent(input.srcEvent.target, target)) {
    target = input.srcEvent.target;
  }

  input.target = target;
}

function computeDeltaXY(session, input) {
  var center = input.center;
  var offset = session.offsetDelta || {};
  var prevDelta = session.prevDelta || {};
  var prevInput = session.prevInput || {};

  if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
    prevDelta = session.prevDelta = {
      x: prevInput.deltaX || 0,
      y: prevInput.deltaY || 0
    };
    offset = session.offsetDelta = {
      x: center.x,
      y: center.y
    };
  }

  input.deltaX = prevDelta.x + (center.x - offset.x);
  input.deltaY = prevDelta.y + (center.y - offset.y);
}
/**
 * velocity is calculated every x ms
 * @param {Object} session
 * @param {Object} input
 */


function computeIntervalInputData(session, input) {
  var last = session.lastInterval || input,
      deltaTime = input.timeStamp - last.timeStamp,
      velocity,
      velocityX,
      velocityY,
      direction;

  if (input.eventType != INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {
    var deltaX = input.deltaX - last.deltaX;
    var deltaY = input.deltaY - last.deltaY;
    var v = getVelocity(deltaTime, deltaX, deltaY);
    velocityX = v.x;
    velocityY = v.y;
    velocity = abs(v.x) > abs(v.y) ? v.x : v.y;
    direction = getDirection(deltaX, deltaY);
    session.lastInterval = input;
  } else {
    // use latest velocity info if it doesn't overtake a minimum period
    velocity = last.velocity;
    velocityX = last.velocityX;
    velocityY = last.velocityY;
    direction = last.direction;
  }

  input.velocity = velocity;
  input.velocityX = velocityX;
  input.velocityY = velocityY;
  input.direction = direction;
}
/**
 * create a simple clone from the input used for storage of firstInput and firstMultiple
 * @param {Object} input
 * @returns {Object} clonedInputData
 */


function simpleCloneInputData(input) {
  // make a simple copy of the pointers because we will get a reference if we don't
  // we only need clientXY for the calculations
  var pointers = [];
  var i = 0;

  while (i < input.pointers.length) {
    pointers[i] = {
      clientX: round(input.pointers[i].clientX),
      clientY: round(input.pointers[i].clientY)
    };
    i++;
  }

  return {
    timeStamp: now(),
    pointers: pointers,
    center: getCenter(pointers),
    deltaX: input.deltaX,
    deltaY: input.deltaY
  };
}
/**
 * get the center of all the pointers
 * @param {Array} pointers
 * @return {Object} center contains `x` and `y` properties
 */


function getCenter(pointers) {
  var pointersLength = pointers.length; // no need to loop when only one touch

  if (pointersLength === 1) {
    return {
      x: round(pointers[0].clientX),
      y: round(pointers[0].clientY)
    };
  }

  var x = 0,
      y = 0,
      i = 0;

  while (i < pointersLength) {
    x += pointers[i].clientX;
    y += pointers[i].clientY;
    i++;
  }

  return {
    x: round(x / pointersLength),
    y: round(y / pointersLength)
  };
}
/**
 * calculate the velocity between two points. unit is in px per ms.
 * @param {Number} deltaTime
 * @param {Number} x
 * @param {Number} y
 * @return {Object} velocity `x` and `y`
 */


function getVelocity(deltaTime, x, y) {
  return {
    x: x / deltaTime || 0,
    y: y / deltaTime || 0
  };
}
/**
 * get the direction between two points
 * @param {Number} x
 * @param {Number} y
 * @return {Number} direction
 */


function getDirection(x, y) {
  if (x === y) {
    return DIRECTION_NONE;
  }

  if (abs(x) >= abs(y)) {
    return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
  }

  return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
}
/**
 * calculate the absolute distance between two points
 * @param {Object} p1 {x, y}
 * @param {Object} p2 {x, y}
 * @param {Array} [props] containing x and y keys
 * @return {Number} distance
 */


function getDistance(p1, p2, props) {
  if (!props) {
    props = PROPS_XY;
  }

  var x = p2[props[0]] - p1[props[0]],
      y = p2[props[1]] - p1[props[1]];
  return Math.sqrt(x * x + y * y);
}
/**
 * calculate the angle between two coordinates
 * @param {Object} p1
 * @param {Object} p2
 * @param {Array} [props] containing x and y keys
 * @return {Number} angle
 */


function getAngle(p1, p2, props) {
  if (!props) {
    props = PROPS_XY;
  }

  var x = p2[props[0]] - p1[props[0]],
      y = p2[props[1]] - p1[props[1]];
  return Math.atan2(y, x) * 180 / Math.PI;
}
/**
 * calculate the rotation degrees between two pointersets
 * @param {Array} start array of pointers
 * @param {Array} end array of pointers
 * @return {Number} rotation
 */


function getRotation(start, end) {
  return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
}
/**
 * calculate the scale factor between two pointersets
 * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
 * @param {Array} start array of pointers
 * @param {Array} end array of pointers
 * @return {Number} scale
 */


function getScale(start, end) {
  return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
}

var MOUSE_INPUT_MAP = {
  mousedown: INPUT_START,
  mousemove: INPUT_MOVE,
  mouseup: INPUT_END
};
var MOUSE_ELEMENT_EVENTS = 'mousedown mousemove mouseout mouseover wheel';
var MOUSE_WINDOW_EVENTS = 'mousemove mouseup'; //ie8的bug,在document上mouseup不相应

if (ie8) {
  MOUSE_ELEMENT_EVENTS = 'mousedown mousemove mouseout mouseover mouseup wheel';
  MOUSE_WINDOW_EVENTS = 'mousemove';
}
/**
 * Mouse events input
 * @constructor
 * @extends Input
 */


function MouseInput() {
  this.evEl = MOUSE_ELEMENT_EVENTS;
  this.evWin = MOUSE_WINDOW_EVENTS;
  this.pressed = false; // mousedown state

  Input.apply(this, arguments);
}

inherit(MouseInput, Input, {
  /**
   * handle mouse events
   * @param {Object} ev
   */
  handler: function MEhandler(ev) {
    var data = {
      pointers: [ev],
      changedPointers: [ev],
      pointerType: INPUT_TYPE_MOUSE,
      srcEvent: ev
    };
    var eventType = MOUSE_INPUT_MAP[ev.type];
    var isLeftButton = ie8 ? ev.button === 1 : ev.button === 0; // on start we want to have the left mouse button down

    if (eventType & INPUT_START && isLeftButton) {
      this.pressed = true;
    }

    if (eventType & INPUT_MOVE && (ie8 ? !this.pressed : ev.which !== 1)) {
      eventType = INPUT_END;
    } // mouse must be down


    if (!this.pressed) {
      var eventType = ev.type;

      if (eventType.indexOf('wheel') != -1) {
        eventType = 'wheel';
      }

      var handlers = this.manager.handlers[eventType] && this.manager.handlers[eventType].slice();

      if (handlers && handlers.length) {
        var i = 0;

        while (i < handlers.length) {
          handlers[i](data);
          i++;
        }
      }

      return;
    }

    if (eventType & INPUT_END) {
      this.pressed = false;
    }

    this.callback(this.manager, eventType, data);
  }
});
var POINTER_INPUT_MAP = {
  pointerdown: INPUT_START,
  pointermove: INPUT_MOVE,
  pointerup: INPUT_END,
  pointercancel: INPUT_CANCEL,
  pointerout: INPUT_CANCEL
}; // in IE10 the pointer types is defined as an enum

var IE10_POINTER_TYPE_ENUM = {
  2: INPUT_TYPE_TOUCH,
  3: INPUT_TYPE_PEN,
  4: INPUT_TYPE_MOUSE,
  5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816

};
var _MOUSE_EVENTS = 'mousemove mouseout mouseover wheel';
var POINTER_ELEMENT_EVENTS = 'pointerdown wheel';
var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel mousemove mouseout mouseover'; // IE10 has prefixed support, and case-sensitive

if (window.MSPointerEvent && !window.PointerEvent) {
  POINTER_ELEMENT_EVENTS = 'MSPointerDown mousemove mouseout mouseover wheel';
  POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
}
/**
 * Pointer events input
 * @constructor
 * @extends Input
 */


function PointerEventInput() {
  this.evEl = POINTER_ELEMENT_EVENTS;
  this.evWin = POINTER_WINDOW_EVENTS;
  Input.apply(this, arguments);
  this.store = this.manager.session.pointerEvents = [];
}

inherit(PointerEventInput, Input, {
  /**
   * handle mouse events
   * @param {Object} ev
   */
  handler: function PEhandler(ev) {
    var store = this.store;
    var removePointer = false;
    var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
    var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
    var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;
    var isTouch = pointerType == INPUT_TYPE_TOUCH; // get index of the event in the store

    var storeIndex = inArray(store, ev.pointerId, 'pointerId'); // start and mouse must be down

    if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
      if (storeIndex < 0) {
        store.push(ev);
        storeIndex = store.length - 1;
      }
    } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
      removePointer = true;
    }

    var data = {
      pointers: store,
      changedPointers: [ev],
      pointerType: pointerType,
      srcEvent: ev
    }; // it not found, so the pointer hasn't been down (so it's probably a hover)

    if (storeIndex < 0) {
      var _evType = ev.type;
      _evType = _evType.indexOf("wheel") >= 0 ? "wheel" : _evType; // @chart-1112 IE下触发mousewheel需要替换成wheel才能被识别

      if (_MOUSE_EVENTS.indexOf(_evType) != -1) {
        var handlers = this.manager.handlers[_evType] && this.manager.handlers[_evType].slice();

        if (handlers && handlers.length) {
          var i = 0;

          while (i < handlers.length) {
            handlers[i](data);
            i++;
          }
        }
      }

      return;
    } // update the event in the store


    store[storeIndex] = ev;
    this.callback(this.manager, eventType, data);

    if (removePointer) {
      // remove from the store
      store.splice(storeIndex, 1);
    }
  }
});
var SINGLE_TOUCH_INPUT_MAP = {
  touchstart: INPUT_START,
  touchmove: INPUT_MOVE,
  touchend: INPUT_END,
  touchcancel: INPUT_CANCEL
};
var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';
/**
 * Touch events input
 * @constructor
 * @extends Input
 */

function SingleTouchInput() {
  this.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
  this.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
  this.started = false;
  Input.apply(this, arguments);
}

inherit(SingleTouchInput, Input, {
  handler: function TEhandler(ev) {
    var type = SINGLE_TOUCH_INPUT_MAP[ev.type]; // should we handle the touch events?

    if (type === INPUT_START) {
      this.started = true;
    }

    if (!this.started) {
      return;
    }

    var touches = normalizeSingleTouches.call(this, ev, type); // when done, reset the started state

    if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
      this.started = false;
    }

    this.callback(this.manager, type, {
      pointers: touches[0],
      changedPointers: touches[1],
      pointerType: INPUT_TYPE_TOUCH,
      srcEvent: ev
    });
  }
});
/**
 * @this {TouchInput}
 * @param {Object} ev
 * @param {Number} type flag
 * @returns {undefined|Array} [all, changed]
 */

function normalizeSingleTouches(ev, type) {
  var all = toArray(ev.touches);
  var changed = toArray(ev.changedTouches);

  if (type & (INPUT_END | INPUT_CANCEL)) {
    all = uniqueArray(all.concat(changed), 'identifier', true);
  }

  return [all, changed];
}

var TOUCH_INPUT_MAP = {
  touchstart: INPUT_START,
  touchmove: INPUT_MOVE,
  touchend: INPUT_END,
  touchcancel: INPUT_CANCEL
};
var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';
/**
 * Multi-user touch events input
 * @constructor
 * @extends Input
 */

function TouchInput() {
  this.evTarget = TOUCH_TARGET_EVENTS;
  this.targetIds = {};
  Input.apply(this, arguments);
}

inherit(TouchInput, Input, {
  handler: function MTEhandler(ev) {
    var type = TOUCH_INPUT_MAP[ev.type];
    var touches = getTouches.call(this, ev, type);

    if (!touches) {
      return;
    }

    this.callback(this.manager, type, {
      pointers: touches[0],
      changedPointers: touches[1],
      pointerType: INPUT_TYPE_TOUCH,
      srcEvent: ev
    });
  }
});
/**
 * @this {TouchInput}
 * @param {Object} ev
 * @param {Number} type flag
 * @returns {undefined|Array} [all, changed]
 */

function getTouches(ev, type) {
  var allTouches = toArray(ev.touches);
  var targetIds = this.targetIds; // when there is only one touch, the process can be simplified

  if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
    targetIds[allTouches[0].identifier] = true;
    return [allTouches, allTouches];
  }

  var i,
      targetTouches,
      changedTouches = toArray(ev.changedTouches),
      changedTargetTouches = [],
      target = this.target; // get target touches from touches

  targetTouches = allTouches.filter(function (touch) {
    return hasParent(touch.target, target);
  }); // collect touches

  if (type === INPUT_START) {
    i = 0;

    while (i < targetTouches.length) {
      targetIds[targetTouches[i].identifier] = true;
      i++;
    }
  } // filter changed touches to only contain touches that exist in the collected target ids


  i = 0;

  while (i < changedTouches.length) {
    if (targetIds[changedTouches[i].identifier]) {
      changedTargetTouches.push(changedTouches[i]);
    } // cleanup removed touches


    if (type & (INPUT_END | INPUT_CANCEL)) {
      delete targetIds[changedTouches[i].identifier];
    }

    i++;
  }

  if (!changedTargetTouches.length) {
    return;
  }

  return [// merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
  uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true), changedTargetTouches];
}
/**
 * Combined touch and mouse input
 *
 * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
 * This because touch devices also emit mouse events while doing a touch.
 *
 * @constructor
 * @extends Input
 */


var DEDUP_TIMEOUT = 2500;
var DEDUP_DISTANCE = 25;

function TouchMouseInput() {
  Input.apply(this, arguments);
  var handler = bindFn(this.handler, this);
  this.touch = new TouchInput(this.manager, handler);
  this.mouse = new MouseInput(this.manager, handler);
  this.primaryTouch = null;
  this.lastTouches = [];
}

inherit(TouchMouseInput, Input, {
  /**
   * handle mouse and touch events
   * @param {VanHammer} manager
   * @param {String} inputEvent
   * @param {Object} inputData
   */
  handler: function TMEhandler(manager, inputEvent, inputData) {
    var isTouch = inputData.pointerType == INPUT_TYPE_TOUCH,
        isMouse = inputData.pointerType == INPUT_TYPE_MOUSE;

    if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
      return;
    } // when we're in a touch event, record touches to  de-dupe synthetic mouse event


    if (isTouch) {
      recordTouches.call(this, inputEvent, inputData);
    } else if (isMouse && isSyntheticEvent.call(this, inputData)) {
      return;
    }

    this.callback(manager, inputEvent, inputData);
  },

  /**
   * remove the event listeners
   */
  destroy: function destroy() {
    this.touch.destroy();
    this.mouse.destroy();
  }
});

function recordTouches(eventType, eventData) {
  if (eventType & INPUT_START) {
    this.primaryTouch = eventData.changedPointers[0].identifier;
    setLastTouch.call(this, eventData);
  } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
    setLastTouch.call(this, eventData);
  }
}

function setLastTouch(eventData) {
  var touch = eventData.changedPointers[0];

  if (touch.identifier === this.primaryTouch) {
    var lastTouch = {
      x: touch.clientX,
      y: touch.clientY
    };
    this.lastTouches.push(lastTouch);
    var lts = this.lastTouches;

    var removeLastTouch = function () {
      var i = lts.indexOf(lastTouch);

      if (i > -1) {
        lts.splice(i, 1);
      }
    };

    setTimeout(removeLastTouch, DEDUP_TIMEOUT);
  }
}

function isSyntheticEvent(eventData) {
  var x = eventData.srcEvent.clientX,
      y = eventData.srcEvent.clientY;

  for (var i = 0; i < this.lastTouches.length; i++) {
    var t = this.lastTouches[i];
    var dx = Math.abs(x - t.x),
        dy = Math.abs(y - t.y);

    if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
      return true;
    }
  }

  return false;
}

var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined; // magical touchAction value

var TOUCH_ACTION_COMPUTE = 'compute';
var TOUCH_ACTION_AUTO = 'auto';
var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented

var TOUCH_ACTION_NONE = 'none';
var TOUCH_ACTION_PAN_X = 'pan-x';
var TOUCH_ACTION_PAN_Y = 'pan-y';
var TOUCH_ACTION_MAP = getTouchActionProps();
/**
 * Touch Action
 * sets the touchAction property or uses the js alternative
 * @param {Manager} manager
 * @param {String} value
 * @constructor
 */

function TouchAction(manager, value) {
  this.manager = manager;
  this.set(value);
}

TouchAction.prototype = {
  /**
   * set the touchAction value on the element or enable the polyfill
   * @param {String} value
   */
  set: function (value) {
    // find out the touch-action by the event handlers
    if (value == TOUCH_ACTION_COMPUTE) {
      value = this.compute();
    }

    if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
      // #touchActionAndriod
      this._shouldChangeTouchAction = value === TOUCH_ACTION_MANIPULATION;
      this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
    }

    this.actions = value.toLowerCase().trim();
  },

  /**
   * by Jeffrey
   * #touchActionAndriod
   */
  setTouchActionNone: function () {
    if (this._shouldChangeTouchAction) {
      // set to none
      // enable the pan event
      this.manager.element.style[PREFIXED_TOUCH_ACTION] = TOUCH_ACTION_NONE;
    }
  },
  recoverTouchAction: function () {
    if (this._shouldChangeTouchAction) {
      // recover to origin
      // enable scroll
      this.manager.element.style[PREFIXED_TOUCH_ACTION] = TOUCH_ACTION_MANIPULATION;
    }
  },

  /**
   * just re-set the touchAction value
   */
  update: function () {
    this.set(this.manager.options.touchAction);
  },

  /**
   * compute the value for the touchAction property based on the recognizer's settings
   * @returns {String} value
   */
  compute: function () {
    var actions = [];
    each(this.manager.recognizers, function (recognizer) {
      if (boolOrFn(recognizer.options.enable, [recognizer])) {
        actions = actions.concat(recognizer.getTouchAction());
      }
    });
    return cleanTouchActions(actions.join(' '));
  },

  /**
   * this method is called on each input cycle and provides the preventing of the browser behavior
   * @param {Object} input
   */
  preventDefaults: function (input) {
    var srcEvent = input.srcEvent;
    var hammerHandler = this.manager.options._handler; // @CHART-2281  ios端不支持touch-action:none，这边力学气泡图如果不preventDefault就导致长按时页面和气泡一起滑动的尴尬现象
    // 之前为什么对力学气泡图做特殊处理也因代码过于久远，不得而知了，这边先这么改，后面要是出现别的问题就再说吧

    var _prevent = hammerHandler && hammerHandler.preventDefault(input);

    if (_prevent || this.manager.session.prevented) {
      _preventDefault(srcEvent);

      return;
    }

    var actions = this.actions;
    var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
    var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
    var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];

    if (hasNone) {
      //do not prevent defaults if this is a tap gesture
      var isTapPointer = input.pointers.length === 1;
      var isTapMovement = input.distance < 2;
      var isTapTouchTime = input.deltaTime < 250;

      if (isTapPointer && isTapMovement && isTapTouchTime) {
        return;
      }
    }

    if (hasPanX && hasPanY) {
      return;
    } // if (hasNone ||
    //     (hasPanY && direction & DIRECTION_HORIZONTAL) ||
    //     (hasPanX && direction & DIRECTION_VERTICAL)) {
    //     return this.preventSrc(srcEvent);
    // }

  },

  /**
   * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
   * @param {Object} srcEvent
   */
  preventSrc: function (srcEvent) {
    this.manager.session.prevented = true;

    _preventDefault(srcEvent);
  }
};
/**
 * when the touchActions are collected they are not a valid value, so we need to clean things up. *
 * @param {String} actions
 * @returns {*}
 */

function cleanTouchActions(actions) {
  // none
  if (inStr(actions, TOUCH_ACTION_NONE)) {
    return TOUCH_ACTION_NONE;
  }

  var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
  var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y); // if both pan-x and pan-y are set (different recognizers
  // for different directions, e.g. horizontal pan but vertical swipe?)
  // we need none (as otherwise with pan-x pan-y combined none of these
  // recognizers will work, since the browser would handle all panning
  //部分的安卓机型，如果返回TOUCH_ACTION_NONE，页面滚动就没了。。。。
  //
  // 2017-04-27 Jeffrey:
  // 但是返回manipulation会导致blink上pan事件失效……
  // 只好要pan 的时候改回none试试→_→
  // 见上 setTouchActionNone / recoverTouchAction
  // #touchActionAndriod

  if (hasPanX && hasPanY) {
    return TOUCH_ACTION_MANIPULATION; // return TOUCH_ACTION_NONE;
  } // pan-x OR pan-y


  if (hasPanX || hasPanY) {
    return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
  } // manipulation


  if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
    return TOUCH_ACTION_MANIPULATION;
  }

  return TOUCH_ACTION_AUTO;
}

function getTouchActionProps() {
  if (!NATIVE_TOUCH_ACTION) {
    return false;
  }

  var touchMap = {};
  var cssSupports = window.CSS && window.CSS.supports;
  ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function (val) {
    // If css.supports is not supported but there is native touch-action assume it supports
    // all values. This is the case for IE 10 and 11.
    touchMap[val] = cssSupports ? window.CSS.supports('touch-action', val) : true;
  });
  return touchMap;
}
/**
 * Recognizer flow explained; *
 * All recognizers have the initial state of POSSIBLE when a input session starts.
 * The definition of a input session is from the first input until the last input, with all it's movement in it. *
 * Example session for mouse-input: mousedown -> mousemove -> mouseup
 *
 * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
 * which determines with state it should be.
 *
 * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
 * POSSIBLE to give it another change on the next cycle.
 *
 *               Possible
 *                  |
 *            +-----+---------------+
 *            |                     |
 *      +-----+-----+               |
 *      |           |               |
 *   Failed      Cancelled          |
 *                          +-------+------+
 *                          |              |
 *                      Recognized       Began
 *                                         |
 *                                      Changed
 *                                         |
 *                                  Ended/Recognized
 */


var STATE_POSSIBLE = 1;
var STATE_BEGAN = 2;
var STATE_CHANGED = 4;
var STATE_ENDED = 8;
var STATE_RECOGNIZED = STATE_ENDED;
var STATE_CANCELLED = 16;
var STATE_FAILED = 32;
/**
 * Recognizer
 * Every recognizer needs to extend from this class.
 * @constructor
 * @param {Object} options
 */

function Recognizer(options) {
  this.options = (0, _CoreUtils.assign)({}, this.defaults, options || {});
  this.id = uniqueId();
  this.manager = null; // default is enable true

  this.options.enable = ifUndefined(this.options.enable, true);
  this.state = STATE_POSSIBLE;
  this.simultaneous = {};
  this.requireFail = [];
}

Recognizer.prototype = {
  /**
   * @virtual
   * @type {Object}
   */
  defaults: {},

  /**
   * set options
   * @param {Object} options
   * @return {Recognizer}
   */
  set: function (options) {
    (0, _CoreUtils.assign)(this.options, options); // also update the touchAction, in case something changed about the directions/enabled state

    this.manager && this.manager.touchAction.update();
    return this;
  },

  /**
   * recognize simultaneous with an other recognizer.
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */
  recognizeWith: function (otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
      return this;
    }

    var simultaneous = this.simultaneous;
    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

    if (!simultaneous[otherRecognizer.id]) {
      simultaneous[otherRecognizer.id] = otherRecognizer;
      otherRecognizer.recognizeWith(this);
    }

    return this;
  },

  /**
   * drop the simultaneous link. it doesnt remove the link on the other recognizer.
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */
  dropRecognizeWith: function (otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
      return this;
    }

    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
    delete this.simultaneous[otherRecognizer.id];
    return this;
  },

  /**
   * recognizer can only run when an other is failing
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */
  requireFailure: function (otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
      return this;
    }

    var requireFail = this.requireFail;
    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

    if (inArray(requireFail, otherRecognizer) === -1) {
      requireFail.push(otherRecognizer);
      otherRecognizer.requireFailure(this);
    }

    return this;
  },

  /**
   * drop the requireFailure link. it does not remove the link on the other recognizer.
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */
  dropRequireFailure: function (otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
      return this;
    }

    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
    var index = inArray(this.requireFail, otherRecognizer);

    if (index > -1) {
      this.requireFail.splice(index, 1);
    }

    return this;
  },

  /**
   * has require failures boolean
   * @returns {boolean}
   */
  hasRequireFailures: function () {
    return this.requireFail.length > 0;
  },

  /**
   * if the recognizer can recognize simultaneous with an other recognizer
   * @param {Recognizer} otherRecognizer
   * @returns {Boolean}
   */
  canRecognizeWith: function (otherRecognizer) {
    return !!this.simultaneous[otherRecognizer.id];
  },

  /**
   * You should use `tryEmit` instead of `emit` directly to check
   * that all the needed recognizers has failed before emitting.
   * @param {Object} input
   */
  emit: function (input) {
    var self = this;
    var state = this.state;

    function emit(event) {
      self.manager.emit(event, input);
    } // 'panstart' and 'panmove'


    if (state < STATE_ENDED) {
      emit(self.options.event + stateStr(state));
    }

    emit(self.options.event); // simple 'eventName' events

    if (input.additionalEvent) {
      // additional event(panleft, panright, pinchin, pinchout...)
      emit(input.additionalEvent);
    } // panend and pancancel


    if (state >= STATE_ENDED) {
      emit(self.options.event + stateStr(state));
    }
  },

  /**
   * Check that all the require failure recognizers has failed,
   * if true, it emits a gesture event,
   * otherwise, setup the state to FAILED.
   * @param {Object} input
   */
  tryEmit: function (input) {
    if (this.canEmit()) {
      return this.emit(input);
    } // it's failing anyway


    this.state = STATE_FAILED;
  },

  /**
   * can we emit?
   * @returns {boolean}
   */
  canEmit: function () {
    var i = 0;

    while (i < this.requireFail.length) {
      if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
        return false;
      }

      i++;
    }

    return true;
  },

  /**
   * update the recognizer
   * @param {Object} inputData
   */
  recognize: function (inputData) {
    // make a new copy of the inputData
    // so we can change the inputData without messing up the other recognizers
    var inputDataClone = (0, _CoreUtils.assign)({}, inputData); // is is enabled and allow recognizing?

    if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
      this.reset();
      this.state = STATE_FAILED;
      return;
    } // reset when we've reached the end


    if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
      this.state = STATE_POSSIBLE;
    }

    this.state = this.process(inputDataClone); // the recognizer has recognized a gesture
    // so trigger an event

    if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
      this.tryEmit(inputDataClone);
    }
  },

  /**
   * return the state of the recognizer
   * the actual recognizing happens in this method
   * @virtual
   * @param {Object} inputData
   * @returns {Const} STATE
   */
  process: function (inputData) {},
  // jshint ignore:line

  /**
   * return the preferred touch-action
   * @virtual
   * @returns {Array}
   */
  getTouchAction: function () {},

  /**
   * called when the gesture isn't allowed to recognize
   * like when another is being recognized or it is disabled
   * @virtual
   */
  reset: function () {}
};
/**
 * get a usable string, used as event postfix
 * @param {Const} state
 * @returns {String} state
 */

function stateStr(state) {
  if (state & STATE_CANCELLED) {
    return 'cancel';
  } else if (state & STATE_ENDED) {
    return 'end';
  } else if (state & STATE_CHANGED) {
    return 'move';
  } else if (state & STATE_BEGAN) {
    return 'start';
  }

  return '';
}
/**
 * direction cons to string
 * @param {Const} direction
 * @returns {String}
 */


function directionStr(direction) {
  if (direction == DIRECTION_DOWN) {
    return 'down';
  } else if (direction == DIRECTION_UP) {
    return 'up';
  } else if (direction == DIRECTION_LEFT) {
    return 'left';
  } else if (direction == DIRECTION_RIGHT) {
    return 'right';
  }

  return '';
}
/**
 * get a recognizer by name if it is bound to a manager
 * @param {Recognizer|String} otherRecognizer
 * @param {Recognizer} recognizer
 * @returns {Recognizer}
 */


function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
  var manager = recognizer.manager;

  if (manager) {
    return manager.get(otherRecognizer);
  }

  return otherRecognizer;
}
/**
 * This recognizer is just used as a base for the simple attribute recognizers.
 * @constructor
 * @extends Recognizer
 */


function AttrRecognizer() {
  Recognizer.apply(this, arguments);
}

inherit(AttrRecognizer, Recognizer, {
  /**
   * @namespace
   * @memberof AttrRecognizer
   */
  defaults: {
    /**
     * @type {Number}
     * @default 1
     */
    pointers: 1
  },

  /**
   * Used to check if it the recognizer receives valid input, like input.distance > 10.
   * @memberof AttrRecognizer
   * @param {Object} input
   * @returns {Boolean} recognized
   */
  attrTest: function (input) {
    var optionPointers = this.options.pointers;
    return optionPointers === 0 || input.pointers.length === optionPointers;
  },

  /**
   * Process the input and return the state for the recognizer
   * @memberof AttrRecognizer
   * @param {Object} input
   * @returns {*} State
   */
  process: function (input) {
    var state = this.state;
    var eventType = input.eventType;
    var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
    var isValid = this.attrTest(input); // on cancel input and we've recognized before, return STATE_CANCELLED

    if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
      return state | STATE_CANCELLED;
    } else if (isRecognized || isValid) {
      if (eventType & INPUT_END) {
        return state | STATE_ENDED;
      } else if (!(state & STATE_BEGAN)) {
        return STATE_BEGAN;
      }

      return state | STATE_CHANGED;
    }

    return STATE_FAILED;
  }
});
/**
 * Pan
 * Recognized when the pointer is down and moved in the allowed direction.
 * @constructor
 * @extends AttrRecognizer
 */

function PanRecognizer() {
  AttrRecognizer.apply(this, arguments);
  this.pX = null;
  this.pY = null;
}

inherit(PanRecognizer, AttrRecognizer, {
  /**
   * @namespace
   * @memberof PanRecognizer
   */
  defaults: {
    event: 'pan',
    threshold: 10,
    pointers: 1,
    direction: DIRECTION_ALL
  },
  getTouchAction: function () {
    var direction = this.options.direction;
    var actions = [];

    if (direction & DIRECTION_HORIZONTAL) {
      actions.push(TOUCH_ACTION_PAN_Y);
    }

    if (direction & DIRECTION_VERTICAL) {
      actions.push(TOUCH_ACTION_PAN_X);
    }

    return actions;
  },
  directionTest: function (input) {
    var options = this.options;
    var hasMoved = true;
    var distance = input.distance;
    var direction = input.direction;
    var x = input.deltaX;
    var y = input.deltaY; //点击以后响应拖拽

    var _handler = this.manager.options._handler;

    var _pressed = _handler && _handler.preventDefault(input); // lock to axis?


    if (!(direction & options.direction)) {
      if (options.direction & DIRECTION_HORIZONTAL) {
        direction = x === 0 ? DIRECTION_NONE : x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
        hasMoved = x != this.pX;
        distance = Math.abs(input.deltaX);
      } else {
        direction = y === 0 ? DIRECTION_NONE : y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
        hasMoved = y != this.pY;
        distance = Math.abs(input.deltaY);
      }
    }

    input.direction = direction;
    return _pressed && hasMoved && distance > options.threshold && direction & options.direction;
  },
  attrTest: function (input) {
    return AttrRecognizer.prototype.attrTest.call(this, input) && (this.state & STATE_BEGAN || !(this.state & STATE_BEGAN) && this.directionTest(input));
  },
  emit: function (input) {
    this.pX = input.deltaX;
    this.pY = input.deltaY;
    var direction = directionStr(input.direction);

    if (direction) {
      input.additionalEvent = this.options.event + direction;
    }

    this._super.emit.call(this, input);
  }
});
/**
 * Pinch
 * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
 * @constructor
 * @extends AttrRecognizer
 */

function PinchRecognizer() {
  AttrRecognizer.apply(this, arguments);
}

inherit(PinchRecognizer, AttrRecognizer, {
  /**
   * @namespace
   * @memberof PinchRecognizer
   */
  defaults: {
    event: 'pinch',
    threshold: 0,
    pointers: 2
  },
  getTouchAction: function () {
    return [TOUCH_ACTION_NONE];
  },
  attrTest: function (input) {
    return this._super.attrTest.call(this, input) && (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
  },
  emit: function (input) {
    if (input.scale !== 1) {
      var inOut = input.scale < 1 ? 'in' : 'out';
      input.additionalEvent = this.options.event + inOut;
    }

    this._super.emit.call(this, input);
  }
});
/**
 * Press
 * Recognized when the pointer is down for x ms without any movement.
 * @constructor
 * @extends Recognizer
 */

function PressRecognizer() {
  Recognizer.apply(this, arguments);
  this._timer = null;
  this._input = null;
}

inherit(PressRecognizer, Recognizer, {
  /**
   * @namespace
   * @memberof PressRecognizer
   */
  defaults: {
    event: 'press',
    pointers: 1,
    time: 251,
    // minimal time of the pointer to be pressed
    threshold: 9 // a minimal movement is ok, but keep it low

  },
  getTouchAction: function () {
    return [TOUCH_ACTION_AUTO];
  },
  process: function (input) {
    var options = this.options;
    var validPointers = input.pointers.length === options.pointers;
    var validMovement = input.distance < options.threshold;
    var validTime = input.deltaTime > options.time;
    this._input = input; // we only allow little movement
    // and we've reached an end event, so a tap is possible

    if (!validMovement || !validPointers || input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime) {
      this.reset();
    } else if (input.eventType & INPUT_START) {
      this.reset();
      this._timer = setTimeoutContext(function () {
        this.state = STATE_RECOGNIZED;
        this.tryEmit();
      }, options.time, this);
    } else if (input.eventType & INPUT_END) {
      return STATE_RECOGNIZED;
    }

    return STATE_FAILED;
  },
  reset: function () {
    clearTimeout(this._timer);
  },
  emit: function (input) {
    if (this.state !== STATE_RECOGNIZED) {
      return;
    }

    if (input && input.eventType & INPUT_END) {
      this.manager.emit(this.options.event + 'up', input);
    } else {
      this._input.timeStamp = now();
      this.manager.emit(this.options.event, this._input);
    }
  }
});
/**
 * Rotate
 * Recognized when two or more pointer are moving in a circular motion.
 * @constructor
 * @extends AttrRecognizer
 */

function RotateRecognizer() {
  AttrRecognizer.apply(this, arguments);
}

inherit(RotateRecognizer, AttrRecognizer, {
  /**
   * @namespace
   * @memberof RotateRecognizer
   */
  defaults: {
    event: 'rotate',
    threshold: 0,
    pointers: 2
  },
  getTouchAction: function () {
    return [TOUCH_ACTION_NONE];
  },
  attrTest: function (input) {
    return this._super.attrTest.call(this, input) && (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
  }
});
/**
 * Swipe
 * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
 * @constructor
 * @extends AttrRecognizer
 */

function SwipeRecognizer() {
  AttrRecognizer.apply(this, arguments);
}

inherit(SwipeRecognizer, AttrRecognizer, {
  /**
   * @namespace
   * @memberof SwipeRecognizer
   */
  defaults: {
    event: 'swipe',
    threshold: 10,
    velocity: 0.3,
    direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
    pointers: 1
  },
  getTouchAction: function () {
    return PanRecognizer.prototype.getTouchAction.call(this);
  },
  attrTest: function (input) {
    var direction = this.options.direction;
    var velocity;

    if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
      velocity = input.overallVelocity;
    } else if (direction & DIRECTION_HORIZONTAL) {
      velocity = input.overallVelocityX;
    } else if (direction & DIRECTION_VERTICAL) {
      velocity = input.overallVelocityY;
    }

    return this._super.attrTest.call(this, input) && direction & input.offsetDirection && input.distance > this.options.threshold && input.maxPointers == this.options.pointers && abs(velocity) > this.options.velocity && input.eventType & INPUT_END;
  },
  emit: function (input) {
    var direction = directionStr(input.offsetDirection);

    if (direction) {
      this.manager.emit(this.options.event + direction, input);
    }

    this.manager.emit(this.options.event, input);
  }
});
/**
 * A tap is ecognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
 * between the given interval and position. The delay option can be used to recognize multi-taps without firing
 * a single tap.
 *
 * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
 * multi-taps being recognized.
 * @constructor
 * @extends Recognizer
 */

function TapRecognizer() {
  Recognizer.apply(this, arguments); // previous time and center,
  // used for tap counting

  this.pTime = false;
  this.pCenter = false;
  this._timer = null;
  this._input = null;
  this.count = 0;
}

inherit(TapRecognizer, Recognizer, {
  /**
   * @namespace
   * @memberof PinchRecognizer
   */
  defaults: {
    event: 'tap',
    pointers: 1,
    taps: 1,
    interval: 300,
    // max time between the multi-tap taps
    time: 250,
    // max time of the pointer to be down (like finger on the screen)
    threshold: 9,
    // a minimal movement is ok, but keep it low
    posThreshold: 10 // a multi-tap can be a bit off the initial position

  },
  getTouchAction: function () {
    return [TOUCH_ACTION_MANIPULATION];
  },
  process: function (input) {
    var options = this.options;
    var validPointers = input.pointers.length === options.pointers;
    var validMovement = input.distance < options.threshold;
    var validTouchTime = input.deltaTime < options.time;
    this.reset();

    if (input.eventType & INPUT_START && this.count === 0) {
      return this.failTimeout();
    } // we only allow little movement
    // and we've reached an end event, so a tap is possible


    if (validMovement && validTouchTime && validPointers) {
      if (input.eventType != INPUT_END) {
        return this.failTimeout();
      }

      var validInterval = this.pTime ? input.timeStamp - this.pTime < options.interval : true;
      var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;
      this.pTime = input.timeStamp;
      this.pCenter = input.center;

      if (!validMultiTap || !validInterval) {
        this.count = 1;
      } else {
        this.count += 1;
      }

      this._input = input; // if tap count matches we have recognized it,
      // else it has began recognizing...

      var tapCount = this.count % options.taps;

      if (tapCount === 0) {
        // no failing requirements, immediately trigger the tap event
        // or wait as long as the multitap interval to trigger
        if (!this.hasRequireFailures()) {
          return STATE_RECOGNIZED;
        } else {
          this._timer = setTimeoutContext(function () {
            this.state = STATE_RECOGNIZED;
            this.tryEmit();
          }, options.interval, this);
          return STATE_BEGAN;
        }
      }
    }

    return STATE_FAILED;
  },
  failTimeout: function () {
    this._timer = setTimeoutContext(function () {
      this.state = STATE_FAILED;
    }, this.options.interval, this);
    return STATE_FAILED;
  },
  reset: function () {
    clearTimeout(this._timer);
  },
  emit: function () {
    if (this.state == STATE_RECOGNIZED) {
      this._input.tapCount = this.count;
      this.manager.emit(this.options.event, this._input);
    }
  }
});
/**
 * Simple way to create a manager with a default set of recognizers.
 * @param {HTMLElement} element
 * @param {Object} [options]
 * @constructor
 */

function VanHammer(element, options) {
  options = options || {};
  options.recognizers = ifUndefined(options.recognizers, VanHammer.defaults.preset);
  return new Manager(element, options);
}
/**
 * @const {string}
 */


VanHammer.VERSION = '2.0.7';
/**
 * default settings
 * @namespace
 */

VanHammer.defaults = {
  /**
   * set if DOM events are being triggered.
   * But this is slower and unused by simple implementations, so disabled by default.
   * @type {Boolean}
   * @default false
   */
  domEvents: false,

  /**
   * The value for the touchAction property/fallback.
   * When set to `compute` it will magically set the correct value based on the added recognizers.
   * @type {String}
   * @default compute
   */
  touchAction: TOUCH_ACTION_COMPUTE,

  /**
   * @type {Boolean}
   * @default true
   */
  enable: true,

  /**
   * EXPERIMENTAL FEATURE -- can be removed/changed
   * Change the parent input target element.
   * If Null, then it is being set the to main element.
   * @type {Null|EventTarget}
   * @default null
   */
  inputTarget: null,

  /**
   * force an input class
   * @type {Null|Function}
   * @default null
   */
  inputClass: null,

  /**
   * Default recognizer setup when calling `Hammer()`
   * When creating a new Manager these will be skipped.
   * @type {Array}
   */
  preset: [// RecognizerClass, options, [recognizeWith, ...], [requireFailure, ...]
  [RotateRecognizer, {
    enable: false
  }], [PinchRecognizer, {
    enable: false
  }, ['rotate']], [SwipeRecognizer, {
    direction: DIRECTION_HORIZONTAL
  }], [PanRecognizer, {
    direction: DIRECTION_HORIZONTAL
  }, ['swipe']], [TapRecognizer], [TapRecognizer, {
    event: 'doubletap',
    taps: 2
  }, ['tap']], [PressRecognizer]],

  /**
   * Some CSS properties can be used to improve the working of Hammer.
   * Add them to this method and they will be set when creating a new Manager.
   * @namespace
   */
  cssProps: {
    /**
     * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
     * @type {String}
     * @default 'none'
     */
    userSelect: 'none',

    /**
     * Disable the Windows Phone grippers when pressing an element.
     * @type {String}
     * @default 'none'
     */
    touchSelect: 'none',

    /**
     * Disables the default callout shown when you touch and hold a touch target.
     * On iOS, when you touch and hold a touch target such as a link, Safari displays
     * a callout containing information about the link. This property allows you to disable that callout.
     * @type {String}
     * @default 'none'
     */
    touchCallout: 'none',

    /**
     * Specifies whether zooming is enabled. Used by IE10>
     * @type {String}
     * @default 'none'
     */
    contentZooming: 'none',

    /**
     * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
     * @type {String}
     * @default 'none'
     */
    userDrag: 'none',

    /**
     * Overrides the highlight color shown when the user taps a link or a JavaScript
     * clickable element in iOS. This property obeys the alpha value, if specified.
     * @type {String}
     * @default 'rgba(0,0,0,0)'
     */
    tapHighlightColor: 'rgba(0,0,0,0)'
  }
};
var STOP = 1;
var FORCED_STOP = 2;
/**
 * Manager
 * @param {HTMLElement} element
 * @param {Object} [options]
 * @constructor
 */

function Manager(element, options) {
  this.options = (0, _CoreUtils.assign)({}, VanHammer.defaults, options || {});
  this.options.inputTarget = this.options.inputTarget || element;
  this.handlers = {};
  this.session = {};
  this.recognizers = [];
  this.oldCssProps = {};
  this.element = element;
  this.input = createInputInstance(this);
  this.touchAction = new TouchAction(this, this.options.touchAction);
  toggleCssProps(this, true);
  each(this.options.recognizers, function (item) {
    var recognizer = this.add(new item[0](item[1]));
    item[2] && recognizer.recognizeWith(item[2]);
    item[3] && recognizer.requireFailure(item[3]);
  }, this);
}

Manager.prototype = {
  /**
   * set options
   * @param {Object} options
   * @returns {Manager}
   */
  set: function (options) {
    (0, _CoreUtils.assign)(this.options, options); // Options that need a little more setup

    if (options.touchAction) {
      this.touchAction.update();
    }

    if (options.inputTarget) {
      // Clean up existing event listeners and reinitialize
      this.input.destroy();
      this.input.target = options.inputTarget;
      this.input.init();
    }

    return this;
  },

  /**
   * stop recognizing for this session.
   * This session will be discarded, when a new [input]start event is fired.
   * When forced, the recognizer cycle is stopped immediately.
   * @param {Boolean} [force]
   */
  stop: function (force) {
    this.session.stopped = force ? FORCED_STOP : STOP;
  },

  /**
   * run the recognizers!
   * called by the inputHandler function on every movement of the pointers (touches)
   * it walks through all the recognizers and tries to detect the gesture that is being made
   * @param {Object} inputData
   */
  recognize: function (inputData) {
    var session = this.session;

    if (session.stopped) {
      return;
    } // run the touch-action polyfill


    this.touchAction.preventDefaults(inputData);
    var recognizer;
    var recognizers = this.recognizers; // this holds the recognizer that is being recognized.
    // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
    // if no recognizer is detecting a thing, it is set to `null`

    var curRecognizer = session.curRecognizer; // reset when the last recognizer is recognized
    // or when we're in a new session

    if (!curRecognizer || curRecognizer && curRecognizer.state & STATE_RECOGNIZED) {
      curRecognizer = session.curRecognizer = null;
    }

    var i = 0;

    while (i < recognizers.length) {
      recognizer = recognizers[i]; // find out if we are allowed try to recognize the input for this one.
      // 1.   allow if the session is NOT forced stopped (see the .stop() method)
      // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
      //      that is being recognized.
      // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
      //      this can be setup with the `recognizeWith()` method on the recognizer.

      if (session.stopped !== FORCED_STOP && ( // 1
      !curRecognizer || recognizer == curRecognizer || // 2
      recognizer.canRecognizeWith(curRecognizer))) {
        // 3
        recognizer.recognize(inputData);
      } else {
        recognizer.reset();
      } // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
      // current active recognizer. but only if we don't already have an active recognizer


      if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
        curRecognizer = session.curRecognizer = recognizer;
      }

      i++;
    }
  },

  /**
   * get a recognizer by its event name.
   * @param {Recognizer|String} recognizer
   * @returns {Recognizer|Null}
   */
  get: function (recognizer) {
    if (recognizer instanceof Recognizer) {
      return recognizer;
    }

    var recognizers = this.recognizers;

    for (var i = 0; i < recognizers.length; i++) {
      if (recognizers[i].options.event == recognizer) {
        return recognizers[i];
      }
    }

    return null;
  },

  /**
   * add a recognizer to the manager
   * existing recognizers with the same event name will be removed
   * @param {Recognizer} recognizer
   * @returns {Recognizer|Manager}
   */
  add: function (recognizer) {
    if (invokeArrayArg(recognizer, 'add', this)) {
      return this;
    } // remove existing


    var existing = this.get(recognizer.options.event);

    if (existing) {
      this.remove(existing);
    }

    this.recognizers.push(recognizer);
    recognizer.manager = this;
    this.touchAction.update();
    return recognizer;
  },

  /**
   * remove a recognizer by name or instance
   * @param {Recognizer|String} recognizer
   * @returns {Manager}
   */
  remove: function (recognizer) {
    if (invokeArrayArg(recognizer, 'remove', this)) {
      return this;
    }

    recognizer = this.get(recognizer); // let's make sure this recognizer exists

    if (recognizer) {
      var recognizers = this.recognizers;
      var index = inArray(recognizers, recognizer);

      if (index !== -1) {
        recognizers.splice(index, 1);
        this.touchAction.update();
      }
    }

    return this;
  },

  /**
   * bind event
   * @param {String} events
   * @param {Function} handler
   * @returns {EventEmitter} this
   */
  on: function (events, handler) {
    if (events === undefined) {
      return;
    }

    if (handler === undefined) {
      return;
    }

    var handlers = this.handlers;
    each(splitStr(events), function (event) {
      handlers[event] = handlers[event] || [];
      handlers[event].push(handler);
    });
    return this;
  },

  /**
   * unbind event, leave emit blank to remove all handlers
   * @param {String} events
   * @param {Function} [handler]
   * @returns {EventEmitter} this
   */
  off: function (events, handler) {
    if (events === undefined) {
      return;
    }

    var handlers = this.handlers;
    each(splitStr(events), function (event) {
      if (!handler) {
        delete handlers[event];
      } else {
        handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
      }
    });
    return this;
  },

  /**
   * emit event to the listeners
   * @param {String} event
   * @param {Object} data
   */
  emit: function (event, data) {
    // we also want to trigger dom events
    if (this.options.domEvents) {
      triggerDomEvent(event, data);
    } // no handlers, so skip it all


    var handlers = this.handlers[event] && this.handlers[event].slice();

    if (!handlers || !handlers.length) {
      return;
    }

    data.type = event;

    data.preventDefault = function () {
      _preventDefault(data.srcEvent);
    };

    var i = 0;

    while (i < handlers.length) {
      handlers[i](data);
      i++;
    }
  },

  /**
   * destroy the manager and unbinds all events
   * it doesn't unbind dom events, that is the user own responsibility
   */
  destroy: function () {
    this.element && toggleCssProps(this, false);
    this.handlers = {};
    this.session = {};
    this.input.destroy();
    this.element = null;
  }
};
/**
 * add/remove the css properties as defined in manager.options.cssProps
 * @param {Manager} manager
 * @param {Boolean} add
 */

function toggleCssProps(manager, add) {
  var element = manager.element;

  if (!element.style) {
    return;
  }

  var prop;
  each(manager.options.cssProps, function (value, name) {
    prop = prefixed(element.style, name);

    if (add) {
      manager.oldCssProps[prop] = element.style[prop];
      element.style[prop] = value;
    } else {
      element.style[prop] = manager.oldCssProps[prop] || '';
    }
  });

  if (!add) {
    manager.oldCssProps = {};
  }
}
/**
 * trigger dom event
 * @param {String} event
 * @param {Object} data
 */


function triggerDomEvent(event, data) {
  var gestureEvent = document.createEvent('Event');
  gestureEvent.initEvent(event, true, true);
  gestureEvent.gesture = data;
  data.target.dispatchEvent(gestureEvent);
}

(0, _CoreUtils.assign)(VanHammer, {
  INPUT_START: INPUT_START,
  INPUT_MOVE: INPUT_MOVE,
  INPUT_END: INPUT_END,
  INPUT_CANCEL: INPUT_CANCEL,
  STATE_POSSIBLE: STATE_POSSIBLE,
  STATE_BEGAN: STATE_BEGAN,
  STATE_CHANGED: STATE_CHANGED,
  STATE_ENDED: STATE_ENDED,
  STATE_RECOGNIZED: STATE_RECOGNIZED,
  STATE_CANCELLED: STATE_CANCELLED,
  STATE_FAILED: STATE_FAILED,
  DIRECTION_NONE: DIRECTION_NONE,
  DIRECTION_LEFT: DIRECTION_LEFT,
  DIRECTION_RIGHT: DIRECTION_RIGHT,
  DIRECTION_UP: DIRECTION_UP,
  DIRECTION_DOWN: DIRECTION_DOWN,
  DIRECTION_HORIZONTAL: DIRECTION_HORIZONTAL,
  DIRECTION_VERTICAL: DIRECTION_VERTICAL,
  DIRECTION_ALL: DIRECTION_ALL,
  Manager: Manager,
  Input: Input,
  TouchAction: TouchAction,
  TouchInput: TouchInput,
  MouseInput: MouseInput,
  PointerEventInput: PointerEventInput,
  TouchMouseInput: TouchMouseInput,
  SingleTouchInput: SingleTouchInput,
  Recognizer: Recognizer,
  AttrRecognizer: AttrRecognizer,
  Tap: TapRecognizer,
  Pan: PanRecognizer,
  Swipe: SwipeRecognizer,
  Pinch: PinchRecognizer,
  Rotate: RotateRecognizer,
  Press: PressRecognizer,
  on: addEventListeners,
  off: removeEventListeners,
  each: each,
  merge: merge,
  extend: extend,
  assign: _CoreUtils.assign,
  inherit: inherit,
  bindFn: bindFn,
  prefixed: prefixed
});
var _default = VanHammer;
exports["default"] = _default;

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Timer = _interopRequireDefault(__webpack_require__(76));

var _vMap = _interopRequireDefault(__webpack_require__(38));

var _interpolator = _interopRequireDefault(__webpack_require__(18));

var _BezierEasing = _interopRequireDefault(__webpack_require__(8));

var _EnvUtils = __webpack_require__(3);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/2/15.
 * NOTE 简要概述一下Transition的原理
 * 首先Transition用来实现动画,
 * 构造Transition需要指定:
 *  1. 对应的Elw(ElementWrapper), 用户动画过程中更新的元素包裹器,
 *  2. 动画名称name, 用于生成transition对应的唯一标识namespace  (用于生成transition对应的唯一标识namespace = d3_transitionNamespace(name))
 *  3. 动画过渡的属性transition(ease, delay, duration)
 *
 *  当创建一个transition之后, 会生成一个transition对象, 然后交给d3_transitionNode去处理:
 *      这一步主要将transition添加到node[ns]中, 这里值得注意的是, 一个node可以同时保留很多个ns, 每个ns上可以有可以保留多个transition
 *  transition生成之后可以通过指定方法修改transition对应的ease, delay, duration,
 *  也可以指定style, attr的目标值, 此时会自动生成插值函数添加到transition.tween中, 然后使用d3Timer生成一个计时器来定时刷新, 计算当前动画帧, 然后判断从tween里面取回调函数更新元素节点
 *
 */
var d3_transitionId = 0;

var Transition = function (elW, name, transition, noAnimation) {
  var id = nextTransitionID(),
      ns = d3_transitionNamespace(name);
  transition = transition || {
    time: Date.now(),
    // do not know why, css.linear is wrong
    ease: _BezierEasing["default"].ease('linear'),
    delay: 0,
    duration: 250
  };

  if (!elW.node) {
    //for elw not elementWrapper but element
    elW.node = function () {
      return elW;
    };
  }

  this.noAnimation = noAnimation || !(0, _EnvUtils.isSupportSVG)() || false;

  if (noAnimation) {
    transition.time = 0;
  }

  d3_transitionNode(elW.node(), ns, id, transition);
  this.elW = elW;
  this.namespace = ns;
  this.id = id;
  this.name = name;
};

_BaseUtils["default"].extend(Transition.prototype, {
  setAnimation: function (para) {
    for (var key in para) {
      this[key] && this[key](para[key]);
    }

    return this;
  },

  /**
   * !!!consider VML
   * @param name
   * @param tween !!!consider VML
   * @returns {*}
   */
  tween: function (name, tween) {
    var id = this.id,
        ns = this.namespace,
        node = this.elW.node();

    if (arguments.length < 2) {
      return node[ns][id].tween.get(name);
    }

    tween == null ? node[ns][id].tween.remove(name) : node[ns][id].tween.set(name, tween);
    return this;
  },
  attr: function (nameNS, value) {
    if (arguments.length < 2) {
      for (value in nameNS) {
        this.attr(value, nameNS[value]);
      }

      return this;
    }

    if (this.noAnimation) {
      this.elW.attr(nameNS, value);
      return this;
    }

    var interpolate = nameNS == "transform" ? _interpolator["default"].interpolateTransform : _interpolator["default"],
        name = nameNS;

    function attrNull() {
      this.removeAttribute(name);
    }

    function attrNullNS() {
      this.removeAttributeNS(name.space, name.local);
    }

    function attrTween(b) {
      return b == null ? attrNull : (b += "", function () {
        var a = this.getAttribute(name),
            i;
        return a !== b && (i = interpolate(a, b), function (t) {
          this.setAttribute(name, i(t));
        });
      });
    }

    function attrTweenNS(b) {
      return b == null ? attrNullNS : (b += "", function () {
        var a = this.getAttributeNS(name.space, name.local),
            i;
        return a !== b && (i = interpolate(a, b), function (t) {
          this.setAttributeNS(name.space, name.local, i(t));
        });
      });
    }

    return d3_transition_tween(this, "attr." + nameNS, value, name.local ? attrTweenNS : attrTween);
  },
  attrTween: function (nameNS, tween) {
    if (arguments.length < 2) {
      for (tween in nameNS) {
        this.attrTween(tween, nameNS[tween]);
      }

      return this;
    }

    var name = nameNS;

    if (this.noAnimation) {
      var f = tween.call(this.elW.node());
      this.elW.attr(name, f(1));
      return this;
    }

    function attrTween(d, i) {
      var f = tween.call(this, d, i, this.getAttribute(name));
      return f && function (t) {
        this.setAttribute(name, f(t));
      };
    }

    function attrTweenNS(d, i) {
      var f = tween.call(this, d, i, this.getAttributeNS(name.space, name.local));
      return f && function (t) {
        this.setAttributeNS(name.space, name.local, f(t));
      };
    }

    return this.tween("attr." + nameNS, name.local ? attrTweenNS : attrTween);
  },
  style: function (name, value, priority) {
    var n = arguments.length;

    if (n < 3) {
      if (typeof name !== "string") {
        if (n < 2) {
          value = "";
        }

        for (priority in name) {
          this.style(priority, name[priority], value);
        }

        return this;
      }

      priority = "";
    }

    if (this.noAnimation) {
      this.elW.style && this.elW.style(name, value);
      return this;
    }

    function styleNull() {
      this.style.removeProperty(name);
    }

    function styleString(b) {
      return b == null ? styleNull : (b += "", function () {
        var a = d3_window(this).getComputedStyle(this, null).getPropertyValue(name),
            i;
        return a !== b && (i = (0, _interpolator["default"])(a, b), function (t) {
          // FixME IE9 throw error when pass an illegal style param
          try {
            this.style.setProperty(name, i(t), priority);
          } catch (e) {// console.warn("unValid style param!!")
          }
        });
      });
    }

    return d3_transition_tween(this, "style." + name, value, styleString);
  },
  styleTween: function (name, tween, priority) {
    if (arguments.length < 3) {
      priority = "";
    }

    if (this.noAnimation) {
      var f = tween.call(this.elW.node());
      this.elW.style(name, f(1));
      return this;
    }

    function styleTween(d, i) {
      var f = tween.call(this, d, i, d3_window(this).getComputedStyle(this, null).getPropertyValue(name));
      return f && function (t) {
        try {
          this.style.setProperty(name, f(t), priority);
        } catch (e) {}
      };
    }

    return this.tween("style." + name, styleTween);
  },
  remove: function () {
    var ns = this.namespace;
    return this.each("end.transition", function () {
      var p;

      if (this[ns].count < 2 && (p = this.parentNode)) {
        p.removeChild(this);
      }
    });
  },
  each: function (type, listener) {
    var node = this.elW.node(),
        id = this.id,
        ns = this.namespace;
    var transition = node[ns][id];

    (transition.event || (transition.event = _BaseUtils["default"].dispatch("start", "end", "interrupt"))).on(type, listener);

    return this;
  },
  ease: function (value) {
    var id = this.id,
        ns = this.namespace,
        node = this.elW.node();

    if (arguments.length < 1) {
      return node[ns][id].ease;
    }

    if (typeof value !== "function") {
      value = _BezierEasing["default"].ease.apply(null, arguments);
    }

    node[ns][id].ease = value;
    return this;
  },
  delay: function (value) {
    var id = this.id,
        ns = this.namespace,
        node = this.elW.node();

    if (arguments.length < 1) {
      return node[ns][id].delay;
    }

    value = +value;
    node[ns][id].delay = value;
    return this;
  },
  duration: function (value) {
    var id = this.id,
        ns = this.namespace,
        node = this.elW.node();

    if (arguments.length < 1) {
      return node[ns][id].duration;
    }

    value = Math.max(1, value);
    node[ns][id].duration = value;
    return this;
  },
  transition: function (para) {
    var id0 = this.id,
        ns = this.namespace,
        node = this.elW.node();
    var transition = node[ns][id0]; // 这里返回的transition 与当前transition应该属于同一个namespace

    return new Transition(this.elW, this.name, {
      time: transition.time,
      ease: transition.ease,
      delay: transition.delay + transition.duration,
      duration: transition.duration
    }, this.noAnimation).setAnimation(para);
  },
  animate: function (para) {
    return this.setAnimation(para);
  }
});

function d3_transition_tween(transition, name, value, tween) {
  var id = transition.id,
      ns = transition.namespace,
      value = tween(value);
  transition.elW.node()[ns][id].tween.set(name, value);
  return transition;
}

function d3_transitionNode(node, ns, id, inherit) {
  var lock = node[ns] || (node[ns] = {
    active: 0,
    count: 0
  }),
      transition = lock[id];

  if (!transition) {
    var time = inherit.time;
    transition = lock[id] = {
      tween: new _vMap["default"](),
      time: time,
      delay: inherit.delay,
      duration: inherit.duration,
      ease: inherit.ease
    };
    inherit = null;
    ++lock.count;
    (0, _Timer["default"])(function (elapsed) {
      var delay = transition.delay,
          duration,
          ease,
          timer = _Timer["default"].getActiveTimer(),
          tweened = [];

      timer.t = delay + time;

      if (delay <= elapsed) {
        return start(elapsed - delay);
      }

      timer.c = start;

      function start(elapsed) {
        if (lock.active > id) {
          return stop();
        }

        var active = lock[lock.active];

        if (active) {
          --lock.count;
          delete lock[lock.active];
          active.event && active.event.interrupt.call(node);
        }

        lock.active = id;
        transition.event && transition.event.start.call(node);
        transition.tween.forEach(function (key, value) {
          if (value = value.call(node)) {
            tweened.push(value);
          }
        });
        ease = transition.ease;
        duration = transition.duration;
        (0, _Timer["default"])(function () {
          timer.c = tick(elapsed || 1) ? _BaseUtils["default"].trueFn : tick;
          return 1;
        }, 0, time);
      }

      function tick(elapsed) {
        if (lock.active !== id || !node[ns]) {
          return 1;
        }

        var t = elapsed / duration,
            e = ease(t),
            n = tweened.length;

        while (n > 0) {
          tweened[--n].call(node, e);
        }

        if (t >= 1) {
          transition.event && transition.event.end.call(node);
          return stop();
        }
      }

      function stop() {
        if (--lock.count) {
          lock[id] = undefined; // delete lock[id];
        } else {
          node[ns] = undefined; // IE 11 兼容7下抛错: "对象不支持此操作"
          // delete node[ns]
        }

        return 1;
      }
    }, 0, time);
  }
}

function nextTransitionID() {
  return ++d3_transitionId;
}

function d3_transitionNamespace(name) {
  return name == null ? "__transition__" : "__transition_" + name + "__";
}

function d3_window(node) {
  return node && (node.ownerDocument && node.ownerDocument.defaultView || node.document && node || node.defaultView);
}

Transition.d3_transitionNamespace = d3_transitionNamespace;
Transition.nextTransitionID = nextTransitionID;
var _default = Transition;
exports["default"] = _default;

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FINE_CANVAS_RENDERER = exports.CANVAS_RENDERER = exports.VML_RENDERER = exports.SVG_RENDERER = void 0;
var SVG_RENDERER = "svg-renderer";
exports.SVG_RENDERER = SVG_RENDERER;
var VML_RENDERER = "vml-renderer";
exports.VML_RENDERER = VML_RENDERER;
var CANVAS_RENDERER = "canvas-renderer";
exports.CANVAS_RENDERER = CANVAS_RENDERER;
var FINE_CANVAS_RENDERER = "fine-canvas-renderer";
exports.FINE_CANVAS_RENDERER = FINE_CANVAS_RENDERER;

/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUseSeriesColorPoint = isUseSeriesColorPoint;
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _EffectHelper = _interopRequireDefault(__webpack_require__(19));

var _component = __webpack_require__(4);

var _Evented = _interopRequireDefault(__webpack_require__(13));

var _EnvUtils = __webpack_require__(3);

var _VanChartInterface = __webpack_require__(60);

var _helper = __webpack_require__(54);

var _CoreUtils = __webpack_require__(2);

var _ThemeConfig = __webpack_require__(25);

var _StyleUtils = __webpack_require__(16);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 16/2/19.
 * 数据点的抽象
 */
var NEGATIVE_COLOR = 'rgb(138, 138, 138)';

var Point = _Evented["default"].extend({
  vanChartType: 'point',
  initialize: function (options, series) {
    this.series = series;
    this.refresh(options || {});
  },
  refresh: function (options) {
    var series = this.series,
        vanchart = series.vanchart; //确定标记点颜色用

    this.originalColor = options.color;
    this.originalMarkerFillColor = options.marker && options.marker.fillColor;
    options = this.options = _BaseUtils["default"].createOptions(options, [series.options]);
    var isSeriesAcc = series.isSeriesAccumulated();
    var category = series.type === _Constants["default"].BAR_CHART ? options.y : options.x;
    var seriesName = series.name;
    this.category = isSeriesAcc ? seriesName : category;
    this.seriesName = isSeriesAcc ? category : seriesName;
    this.value = this.getTargetValue();
    this.originalValue = this.options[this.series.getTargetKey()];
    this.name = _BaseUtils["default"].pick(this.options.x, this.options.name);
    this.nodeId = this.options.nodeId || null; // point.categoryArray为数组

    this.categoryArray = _BaseUtils["default"].isArray(options.categoryArray) ? options.categoryArray.map(function (cate) {
      return cate;
    }) : [this.category];
    this.categoryArrayStr = _BaseUtils["default"].encodeCategoryArray(this.categoryArray); // 缓存起来，不用每次都重新算了

    if (series.type === _Constants["default"].LINE_MAP) {
      this.from = {
        name: options.from.name
      };
      this.to = {
        name: options.to.name
      };
    } //shine:y不能用value，因为value有可能是size（bubble chart）


    this.x = options.x;
    this.y = options.y; // 之前的版本计算百分比之类的都是用的y作为targetKey取值，现在 把y去掉，导致百分比之类的计算出错

    this.size = options.size;
    this.target = options.target; // 百分比圆环、滑槽仪表盘、试管仪表盘的目标值

    this.visible = true;
    this.isNull = series.isNullValue(this);
    this.points = isSeriesAcc ? series.points : vanchart.registerPointsPara(this); // try to eliminate properties in large mode
    // if (series.options.large) {
    //     return;
    // }
    // 点地图大数据模式需要geo

    if (options.drilldown && options.drilldown.geo) {
      var Geo = (0, _component.getComponent)(_component.ComponentCst.GEO_COMPONENT);
      this.geo = new Geo(options.drilldown.geo, _component.ComponentCst.GEO_COMPONENT, vanchart);
    } //@deprecated H5兼容,暂时不能删


    this.jsonHyperlink = options.jsonHyperlink;
    this.drillUpLink = options.drillUpLink; //todo 下周移动端发布以后删掉，暂时需要兼容

    this.hyperlink = options.hyperlink;
    this.location = _Constants["default"].BOTTOM_TO_TOP; // 图形的增长方向
  },
  // todo 重构这个方法 根据范围图例的值来计算颜色
  refreshPointColor: function () {
    var point = this,
        options = point.options,
        series = point.series,
        vanchart = series.vanchart;

    if (!series.isTreeSeries()) {
      // 点的颜色：colors，范围图例，系列条件属性配色，点条件属性配色
      // 标记点的颜色取的顺序：colors配色、plotOptions的标记点的颜色、范围图例、条件属性系列配色、条件属性系列标记点颜色、条件属性数据点的配色、条件属性数据点的标记点的配色
      var _opacity = options.opacity,
          _markerOpacity = options.opacity,
          _originOpacity = 1;
      var colorKey;

      if (series.type === _Constants["default"].STRUCTURE_CHART) {
        colorKey = this.level;
      } else {
        // 这边的options.name再createOptions的时候就跳过了？
        colorKey = series.isSeriesAccumulated() ? _BaseUtils["default"].pick(options.x, options.name, series.options.name) : series.name;
      } // 默认配色


      var _color = vanchart.getDefaultSeriesColor(colorKey);

      var _markerColor = _color;

      if (options.marker) {
        options.marker = _BaseUtils["default"].clone(options.marker);
        _markerColor = options.marker.fillColor || _markerColor;
      } // 范围图例
      // large lineMap cannot use range


      if (!(series.type === _Constants["default"].LINE_MAP && series.options.large)) {
        var rangeLegend = vanchart.getComponent(_component.ComponentCst.RANGE_LEGEND_COMPONENT);

        if (rangeLegend) {
          _color = rangeLegend.getColorWithSize(this.getTargetValue(), series.options.large);
          _markerColor = _color;
          this.visible = !!_color;
        }
      } // 系列条件属性配色


      _markerColor = series.originalColor || _markerColor;
      _markerColor = series.originalMarkerFillColor || _markerColor; // 点条件属性配色

      _color = this.originalColor || series.originalColor || _color;
      _markerColor = this.originalColor || _markerColor;
      _markerColor = this.originalMarkerFillColor || _markerColor; // 负气泡、bands等特殊的。

      if ((series.type === _Constants["default"].BUBBLE_CHART || series.type === _Constants["default"].FORCE_BUBBLE_CHART) && !rangeLegend) {
        if (point.getTargetValue() < 0 && point.options.displayNegative) {
          _color = options.color || NEGATIVE_COLOR;
        } else if (point.getTargetValue() < 0) {
          _color = null;
        }
      }

      var hexAlpha;

      if (_color) {
        hexAlpha = _ColorUtils["default"].getStandardColorAndOpacity(_color, _opacity);
        _color = hexAlpha.hex;
        _opacity = hexAlpha.alpha;
        _originOpacity = hexAlpha.oriAlpha;
      }

      if (_markerColor) {
        hexAlpha = _ColorUtils["default"].getStandardColorAndOpacity(_markerColor, _markerOpacity);
        _markerColor = hexAlpha.hex;
        _markerOpacity = hexAlpha.alpha;
      }

      var marker = options.marker;

      if (marker) {
        marker.fillColor = _markerColor;
        marker.fillColorOpacity = _markerOpacity;
        marker.radius = (0, _StyleUtils.getMarkerRadius)(marker.radius);
      }

      (0, _helper.refreshBoxMarkerColor)(options, _markerColor);
      _opacity = this.isGradualStyle() ? this._getGradualStyleOpacity() : _opacity;

      if (options.fillColorOpacity) {
        options.fillColorOpacity *= _originOpacity;
      } // _color会出现空只有在范围图例除第一个系列外的点不在范围内的时候为空，范围图例情况下开启共享提示，应该每一个的透明度都根据自身的条件计算，所以没颜色也要记录下来


      if (_color) {
        this.color = _color;
        this.mouseOverColor = this.options.mouseOverColor || _ColorUtils["default"].getHighLightColor(_color);
        this.clickColor = _ColorUtils["default"].getClickColor(_color);
      }

      this.opacity = _opacity;
      this.originOpacity = _originOpacity;
      this.clickOpacity = _opacity * 0.95;

      var _borderColor = _ColorUtils["default"].getStandardColorAndOpacity(this.options.borderColor, (0, _CoreUtils.hasDefined)(this.options.borderOpacity) ? this.options.borderOpacity : 1);

      this.borderColor = _borderColor.hex;

      if (this.options.borderColor) {
        this.borderOpacity = _borderColor.alpha;
      } else {
        this.borderOpacity = (0, _CoreUtils.hasDefined)(this.options.borderOpacity) ? this.options.borderOpacity * _originOpacity : _originOpacity;
      }

      var dataLabels = this.options.dataLabels || {},
          _labelBorderColor = dataLabels.borderColor;
      this.labelBorderOpacity = 1;

      if ((0, _CoreUtils.hasDefined)(_labelBorderColor)) {
        this.labelBorderOpacity = _labelBorderColor === _Constants["default"].AUTO ? point.autoLabelOpacity() : _ColorUtils["default"].getStandardColorAndOpacity(_labelBorderColor, 1).alpha;
      }

      (0, _helper.refreshBoxBorderColor)(point, this.color);
    }
  },
  _getGradualStyleOpacity: function () {
    return (0, _CoreUtils.hasDefined)(this.options.opacity) ? this.options.opacity : 1;
  },
  isGradualStyle: function () {
    return this.options.gradualStyle === _Constants["default"].STYLE_CUSTOM || this.series.isGradualStyle();
  },
  getTargetValue: function () {
    //兼容值可能是字符串的情况
    var value = this.options[this.series.getTargetKey()];
    var vanchart = this.series.vanchart;
    var geo = vanchart.getComponent(_component.ComponentCst.GEO_COMPONENT);

    if (geo) {
      return this.getMapTargetValue(value);
    }

    return this.getNumberValue(value);
  },
  getNumberValue: function (value) {
    // +'' = 0; isNaN('') = false
    if (isNaN(+value) || value == '') {
      if (this.series.isNullValue(this)) {
        return 0;
      }

      if (_BaseUtils["default"].isArray(value) || value && (0, _CoreUtils.hasDefined)(value.min) && (0, _CoreUtils.hasDefined)(value.max)) {
        var domain = (0, _helper.getPointDomain)(value, this.options.isDetailed);
        var total = 0;

        for (var i = 0, len = domain.length; i < len; i++) {
          if ((0, _CoreUtils.isNumberValue)(domain[i])) {
            total = +domain[i] + total;
          }
        }

        return total / domain.length;
      }

      return value;
    } else {
      return +value;
    }
  },
  getMapTargetValue: function (value) {
    var _this$series = this.series,
        vanchart = _this$series.vanchart,
        options = _this$series.options;
    var geo = vanchart.getComponent(_component.ComponentCst.GEO_COMPONENT);
    var isBubbleMap = geo || options.type === _Constants["default"].BUBBLE_CHART;
    var isRangeLegend = vanchart.getComponent(_component.ComponentCst.RANGE_LEGEND_COMPONENT); // 数据为''时，因为''== 0，
    // 1、导致范围图例计算数据范围时，将''当作0处理visible为true，
    // 2、气泡计算半径时，将''当作0处理了，但实际值为字符串类型的气泡不该画出来

    return (isRangeLegend || isBubbleMap) && value === '' ? '-' : value;
  },
  getLatLng: function (feature) {
    var geo = this.series.vanchart.getCurrentGeo();
    var lnglat = geo.getScaledLnglat(this.options.lnglat);

    if (!lnglat) {
      if (!feature) {
        feature = geo.getFeaturesByName(this.name, this.series.type);
        feature = feature && feature[0];
      }

      if (feature) {
        lnglat = geo.getDataPointLngLat(this, feature);
      }
    }

    return lnglat ? [lnglat[1], lnglat[0]] : null;
  },
  getStackPointPreSufPoint: function (point) {
    var series = point.series;
    var stackKey = [series.type, series.stack, point.category].join('-');
    var preP,
        sufP,
        find = false;

    for (var dataIndex = 0, dataCount = point.points.length; dataIndex < dataCount; dataIndex++) {
      var p = point.points[dataIndex];
      var ser = p.series;
      var key = [ser.type, series.stack, p.category].join('-');

      if (p == point) {
        find = true;
      } else if (key == stackKey && p.isVisible()) {
        if (find) {
          sufP = p;
          break;
        } else {
          preP = p;
        }
      }
    }

    return {
      pre: preP,
      suf: sufP
    };
  },
  _mapPointOnMouseState: function (isChosen, duration, ease, style) {
    var point = this,
        series = point.series,
        vanchart = series.vanchart;

    if (point.layers) {
      point.layers && point.layers.forEach(function (layer) {
        layer._onMouseState(isChosen, duration, ease, style);
      });
    }
  },

  /**
   * 获取point的分类，这里的分类指的是其对应的id，用于识别这个点，同时也是分类轴上的domain的取值。
   * !!!注意，使用tooltip的时候，其分类仍旧是point.category
   * @return {[type]} [description]
   */
  getCategory: function () {
    var series = this.series,
        isMultiCategoryBased = series.isMultiCategoryAxisBased();
    return isMultiCategoryBased ? this.categoryArrayStr : this.category;
  },
  isLogAxisValidValue: function () {
    var x = true,
        y = true;
    var xAxisOpt = this.series.xAxis.options,
        yAxisOpt = this.series.yAxis.options,
        options = this.options;

    if (xAxisOpt.log && options.x <= 0) {
      x = false;
    }

    if (yAxisOpt.log && options.y <= 0) {
      y = false;
    }

    return x && y;
  }
});

Point.include({
  /**
   * 判断数据点是否支持数据提示共享
   * @returns {options.tooltip|{formatter, enabled}|boolean|*}
   */
  isPointSupportTooltipShared: function () {
    var point = this,
        options = point.options,
        tooltip = options.tooltip,
        series = this.series,
        vanchart = series.vanchart,
        sharedAxis = vanchart.getSharedAxis();
    return tooltip && tooltip.shared && point.points && sharedAxis && series.supportTooltipShared();
  },
  _onPointMouseOver: function (ev) {
    var point = this,
        options = point.options,
        series = this.series,
        vanchart = series.vanchart;
    var hoverPoint = vanchart.hoverPoint,
        hoverSeries = vanchart.hoverSeries,
        hoverPoints = vanchart.hoverPoints,
        sharedAxis = vanchart.getSharedAxis();

    if (hoverPoint === point) {
      return;
    }

    var share = this.isPointSupportTooltipShared();
    var hoverSameCategory = hoverPoints && hoverPoints.length && point.getCategory() == hoverPoints[0].getCategory();

    if (share && hoverSameCategory && series.defaultMarker) {
      // 折线图默认标记点 数据点提示共享 同一个分类里鼠标移动。
      // 不return掉，会一直over-create-default-marker then out-delete-default-marker
      return;
    }

    if (series.isTreeSeries()) {
      series.fire('pointMouseOver', point); //@MOBILE-6474

      series.vanchart.showTooltip(point, ev);
      return;
    }

    hoverPoint && hoverPoint.fire('mouseout', ev);

    if (share) {
      var valid = vanchart.getValidPointsPara(point.getCategory()); //out要在over之前。否则，over series.createDefaultMarker then out delete
      // todo 共享数据点提示时，鼠标移至另一个分类下是，要将之前的hoverPoints的高亮去掉

      if (hoverPoints && hoverPoints.length && hoverPoints[0] != valid[0]) {
        hoverPoints[0]._onPointMouseOut.call(hoverPoints[0], ev); // 折线图无标记点的时候移到柱形图上 || 移到另一个分类上，之前选中点的标签得回到非选中状态


        hoverPoints[0].points.forEach(function (p) {
          p.series.defaultMarker && p.series.fire('pointMouseOut', p);
        });
      } // var max = valid   暂未用到


      valid.reduce(function (prev, curr) {
        curr.series._onPointMouseOver(curr); //  这里的作用是让同类别的所有点触发mouseOver事件，因此传入的应该是对应的curr点！


        if (!prev) {
          return curr;
        }

        return curr.getTargetValue() > prev.getTargetValue() ? curr : prev;
      }, 0);

      if (sharedAxis && valid.length) {
        sharedAxis.drawHighlightBackground(valid);
      }

      series.vanchart.showSharedTooltip(point, ev);
      vanchart.hoverPoints = valid; // todo 这里记得更新一下hoverPoints，鼠标移除绘图区时清除highLight时会用到
    } else {
      vanchart.handler._removeHighlight(ev); //@CHART-1597:组合图中柱形图的鼠标悬浮不会移除折线图共享的高亮选中效果


      if (series.type === _Constants["default"].BOX_CHART) {
        point.outlierData = (0, _helper.selectOutlierData)(point, ev);
      }

      series.vanchart.showTooltip(point, ev);
      series.fire('pointMouseOver', point);

      if (hoverSeries != point.series) {
        hoverSeries && hoverSeries.fire('seriesUnChosen', ev);
        point.series.fire('mouseover', ev);
      }

      vanchart.hoverSeries = point.series;
      vanchart.hoverPoint = point;
    }
  },
  _onPointMouseMove: function (ev) {
    var point = this,
        options = point.options,
        series = this.series,
        vanchart = series.vanchart,
        sharedAxis = vanchart.getSharedAxis();
    var share = options.tooltip && options.tooltip.shared && point.points && sharedAxis && point.series.supportTooltipShared();
    share ? vanchart.showSharedTooltip(vanchart.hoverPoints && vanchart.hoverPoints[0], ev) : vanchart.showTooltip(vanchart.hoverPoint, ev);
  },
  _onPointMouseOut: function (ev) {
    var point = this,
        tooltip = point.options.tooltip;
    var series = this.series,
        vanchart = series.vanchart,
        sharedAxis = vanchart.getSharedAxis(),
        hoverPoint = vanchart.hoverPoint;

    if (series.isTreeSeries()) {
      series.fire('pointMouseOut', point);
      return;
    }

    if (tooltip && tooltip.shared && point.points && point.points.length && sharedAxis) {
      point.points.forEach(function (point) {
        //有图形||折线图无标记点时移除绘图区
        // PC端为了避免数据点提示共享情况下鼠标在数据点上移动出现point.mouseout后又mouseover的无聊举措，只有鼠标位置在vanchart.bounds之外才响应mouseout，
        // 移动端则不必考虑该问题
        var noCategoryPoints = ev && sharedAxis.getPointsInCategory(ev.containerPoint).length === 0;
        var notInPlotBounds = ev && !_BaseUtils["default"].containsPoint(vanchart.bounds, ev.containerPoint);
        var canFireMouseout = notInPlotBounds || noCategoryPoints || vanchart.isMobile();
        var fire = point.graphic || point.series.defaultMarker && canFireMouseout;
        fire && point.series.fire('pointMouseOut', point); // CHART-9090 与当前的面积图选中设计冲突, 先注释掉
        // point.series.fire('seriesUnChosen', ev);
      });
    } else {
      point.series.fire('pointMouseOut', point);
    } // @10418: 普通的事件中当前点即hoverPoint,
    // 但是存在特殊情况如页面刷新时鼠标悬浮点A, 然后自动数据提示, 触发点B的mouseover后, 此时点A mouseout导致点B的高亮不能被移除.


    if (hoverPoint && hoverPoint !== this) {
      hoverPoint.fire('mouseout', ev);
    }

    series.vanchart.hideTooltip();
  },
  _onPointTap: function (ev) {
    var point = this,
        series = this.series,
        vanchart = series.vanchart,
        hoverPoint = vanchart.hoverPoint;
    var visible = vanchart.isMap() && point.options.drilldown ? true : point.isVisible();

    if (!visible) {
      return;
    }

    if (vanchart.isMobileFlow) {
      // 防止流转到dom manager，然后fire hide
      ev.stop && ev.stop();
    } // mpie & treemap have no drill down in flow


    if (!vanchart.isMobileFlow() && series.isTreeSeries() && series.allowDrillDown(point)) {
      series.onPointTap(point);
    } //触发超链


    var srcEvent = ev.srcEvent;
    var touch = srcEvent.touches && (srcEvent.touches.length ? srcEvent.touches[0] : srcEvent.changedTouches[0]);

    if (touch) {
      //移动端clientY，clientX不在event上
      srcEvent.clientX = touch.clientX;
      srcEvent.clientY = touch.clientY;
    } //移动端的时候触发选中效果


    if (vanchart.isMobile()) {
      point.fire('mouseover', ev);
      point === hoverPoint && point.fire("mousemove", ev); //@CHART-1680 移动端数据点提示鼠标跟随
    }

    point.onClick(srcEvent);

    if (vanchart.allowDrillDown && vanchart.allowDrillDown(point)) {
      if (vanchart.isMobileFlow()) {
        vanchart.vancharts.holdDrillDownPoint(point);
      } else {
        vanchart.drillDown(point);
      }
    }
  },
  hasValidDataLabel: function () {
    var point = this;
    var hasLabel = point.labelPos && !isNaN(point.labelPos.x) && !isNaN(point.labelPos.y) && point.options.dataLabels && point.options.dataLabels.enabled;
    return point.series.visible && !point.isNull && point.visible && hasLabel;
  },
  clearPointEffect: function () {
    var point = this;

    _BaseUtils["default"].clearInterval(point.effectInterval);

    point.effectGraphic && point.effectGraphic.remove();
    point.effectGraphic = null;
    point.effectInterval = null;

    if (point.series && point.graphic && _EffectHelper["default"].isAreaStyleEffectChart(point.series.type)) {
      point.graphic.removeTransition(_Constants["default"].SCALE_EXPAND_ANIMATION).removeTransition(_Constants["default"].SCALE_MINIFY_ANIMATION);
    }

    point.children && point.children.forEach(function (childPoint) {
      childPoint.clearPointEffect();
    });
  },
  isVisible: function () {
    var point = this;
    return point && point.visible && point.series.visible && !point.isNull;
  },
  getEffectTime: function () {
    var point = this; // 地图在进入这个方法前就处理了point是否为visible，并且地图的visible也不是简单的通过isVisible()方法来判断的，所以地图point无须再判断是否为visible

    var isVisiblePoint = point.series.vanchart.isMap() ? true : point.isVisible();

    if ((0, _EnvUtils.isSupportSVG)() && isVisiblePoint && point.options.effect && point.options.effect.enabled) {
      return point.series._getEffectTime(point);
    }

    return 0;
  },
  hasEffect: function () {
    return this.getEffectTime() > 0;
  },
  isPieZeroPoint: function () {
    return this.series.type === _Constants["default"].PIE_CHART && this.getTargetValue() === 0;
  },
  autoLabelColor: function (dataLabels) {
    if (dataLabels === void 0) {
      dataLabels = {};
    }

    var point = this;
    var series = point.series;
    var pointDataLabels = (0, _CoreUtils.isEmptyObj)(dataLabels) ? point.options.dataLabels : dataLabels;
    var isUseSeriesColor = pointDataLabels && isUseSeriesColorPoint(pointDataLabels.align, series.type, series.columnType);
    var seriesColor = this.getSeriesColor();
    return isUseSeriesColor ? seriesColor : '#ffffff';
  },
  autoLabelOpacity: function (dataLabels) {
    if (dataLabels === void 0) {
      dataLabels = {};
    }

    var point = this;
    var series = point.series;
    var pointDataLabels = (0, _CoreUtils.isEmptyObj)(dataLabels) ? point.options.dataLabels : dataLabels;
    var isUseSeriesOpacity = pointDataLabels && isUseSeriesOpacityPoint(pointDataLabels.align, point.labelAlign || null, series.type, series.columnType);
    return (0, _CoreUtils.hasDefined)(this.originOpacity) && isUseSeriesOpacity ? this.originOpacity : 1;
  },
  labelOpacity: function (dataLabels) {
    if (dataLabels === void 0) {
      dataLabels = {};
    }

    var point = this,
        pointDataLabels = (0, _CoreUtils.isEmptyObj)(dataLabels) ? point.options.dataLabels : dataLabels,
        style;
    pointDataLabels && (style = pointDataLabels.style);
    return style ? _ColorUtils["default"].getStandardColorAndOpacity(style.color, 1).alpha : this.autoLabelOpacity();
  },
  getSeriesColor: function () {
    var point = this;

    if (point.options && point.options.marker && point.options.marker.fillColor) {
      return point.options.marker.fillColor;
    }

    return point.color;
  },
  _onPointPress: function (ev) {
    var point = this,
        series = this.series,
        vanchart = series.vanchart;
    var hoverPoint = vanchart.hoverPoint;

    if (hoverPoint) {
      series.onPointPress.call(point, ev);
    }
  },
  _onPointPressUp: function (ev) {
    var point = this,
        series = this.series,
        vanchart = series.vanchart;
    var hoverPoint = vanchart.hoverPoint;

    if (hoverPoint) {
      series.onPointPressUp.call(point, ev);

      hoverPoint._onPointTap(ev);
    }
  },
  onClick: function (ev) {
    var point = this,
        series = point.series,
        vanchart = series.vanchart,
        vancharts = vanchart.vancharts;
    var hyperlinkFunc = vancharts.doHyperlink;

    if (hyperlinkFunc) {
      var params = _BaseUtils["default"].extend({
        event: ev
      }, point);

      _BaseUtils["default"].getFormatterFunction(hyperlinkFunc)(params);

      window.top.Dec && vanchart.options.hyperLink && (0, _VanChartInterface.hideFullScreenChart)();
    }

    var pointOptions = point.options;
    var clickFunc = pointOptions.click || pointOptions.onClick;

    if (clickFunc) {
      var extendedPoint = _BaseUtils["default"].extend({
        tooltipText: vanchart.__tooltipText,
        event: ev
      }, point);

      if (vanchart.allowDrillDown && vanchart.allowDrillDown(point)) {
        extendedPoint.allowDrillType = 'down';
      }

      _BaseUtils["default"].getFormatterFunction(clickFunc).call(extendedPoint, ev);
    }
  },
  getEvents: function () {
    return {
      'mouseover': this._onPointMouseOver,
      'mouseout': this._onPointMouseOut,
      'mousemove': this._onPointMouseMove,
      'tap': this._onPointTap,
      'press': this._onPointPress,
      'pressup': this._onPointPressUp
    };
  },
  remove: function () {
    this.visible = false;
    this.graphic && this.graphic.remove();
    this.removeTextGraphic();
    this.moreLabelG && this.moreLabelG.remove();
    this.clearPointEffect();
    this.graphic = this.textGraphic = this.moreLabelG = this.leadLine = null;
  },

  /**
   * 数据点标签移除
   */
  removeTextGraphic: function () {
    if (this.textGraphic) {
      this.textGraphic.remove();
      this.textGraphic = null;
    }

    if (this.leadLine) {
      this.leadLine.remove();
      this.leadLine = null;
    }

    if (this.textBorderPath) {
      this.lineTriangleBorder && this.lineTriangleBorder.remove();
      this.lineTriangleBorderRect && this.lineTriangleBorderRect.remove();
      this.textBorderPath.remove();
      this.textBorderPath = this.lineTriangleBorder = this.lineTriangleBorderRect = null;
    }
  },
  // FIXME
  // itself is removed from parent.children
  // thus the name 'clearChild' is confused
  clearChild: function () {
    var point = this;

    if (point.parent) {
      var childs = point.parent.children;
      childs && childs.splice(_BaseUtils["default"].indexOf(childs, point), 1);
    }

    if (point.children) {
      var len = point.children.length;

      while (--len > -1) {
        point.children[len].clearChild();
      }
    }

    point.remove();
  },
  getPointBorderColor: function (borderColorOpt) {
    var point = this;
    var series = point.series;
    var vanchart = series.vanchart;

    if (borderColorOpt === _Constants["default"].AUTO) {
      return series._getBackgroundColorWithAlpha() || (0, _ThemeConfig.getThemeAutoValue)(borderColorOpt, 'pointBorderColor', vanchart.isDarkTheme());
    }

    return borderColorOpt;
  }
});

function isUseSeriesColorPoint(align, chartType, isColumnType) {
  // 气泡图、矩形树图、力学气泡图、堆积柱形雷达图中的point的标签不使用系列色，
  // 散点图和点地图中的point的标签使用系列色，其他图形的标签是否使用系列色根据align来判断
  var useSeriesColor = align === _Constants["default"].TOP || align === _Constants["default"].BOTTOM || align === _Constants["default"].OUTSIDE;

  if (isUnusedSeriesColorChart(chartType) || isColumnType) {
    useSeriesColor = false;
  } else if (isUseSeriesColorChart(chartType)) {
    useSeriesColor = true;
  }

  return useSeriesColor;
}

function isUseSeriesOpacityPoint(cusAlign, autoAlign, chartType, isColumnType) {
  if (isUseSeriesOpacityChart(chartType)) {
    return true;
  } // 标签位置自动的时候，柱形图、条形图等还要看根据位置计算结果是否用系列色（即要看是否用系列透明度）


  if (cusAlign === _Constants["default"].AUTO) {
    // 目前标签位置自动基本都是使用系列色，除了条形图特殊一点要判断计算结果
    return autoAlign !== _Constants["default"].INSIDE ? true : false;
  } else {
    return isUseSeriesColorPoint(cusAlign, chartType, isColumnType);
  }
}

function isUseSeriesOpacityChart(chartType) {
  return chartType === _Constants["default"].AREA_MAP;
}

function isUseSeriesColorChart(chartType) {
  return chartType === _Constants["default"].SCATTER_CHART || chartType === _Constants["default"].POINT_MAP || chartType === _Constants["default"].LINE_CHART || chartType === _Constants["default"].AREA_CHART || chartType === _Constants["default"].RADAR_CHART;
}

function isUnusedSeriesColorChart(chartType) {
  return chartType === _Constants["default"].BUBBLE_CHART || chartType === _Constants["default"].TREEMAP_CHART || chartType === _Constants["default"].FORCE_BUBBLE_CHART;
}

var _default = Point;
exports["default"] = _default;

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Layer = _interopRequireDefault(__webpack_require__(20));

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Constants = _interopRequireDefault(__webpack_require__(1));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/2/8.
 */
var INIT_TIME = 1200;
var INIT_EASE = 'cubic-out';
var EXIT_TIME = 300;
var EXIT_EASE = 'ease';
var RESHOW_TIME = 1000;
var RESHOW_EASE = INIT_EASE;
var INIT_TRANSITION = 'init';

var Path = _Layer["default"].extend({
  onAdd: function () {
    this._path = this._renderer.path().style(this.options);

    this._reset();

    this._path.add();
  },
  onRemove: function () {
    this._path.remove();
  },
  // @method redraw(): this
  // Redraws the layer. Sometimes useful after you changed the coordinates that the path uses.
  redraw: function () {
    if (this._map) {
      this._reset();
    }

    return this;
  },
  // @method setStyle(style: Path options): this
  // Changes the appearance of a Path based on the options in the `Path options` object.
  setStyle: function (style) {
    this._path.interrupt(INIT_TRANSITION); //path 只存样式信息


    this.options = style || this.options;

    if (this._renderer) {
      this._path.style(this.options);
    }

    return this;
  },
  initAnimate: function () {
    this._path.style({
      'fill-opacity': 0
    }).interrupt(INIT_TRANSITION).transition(INIT_TRANSITION).ease(INIT_EASE).style(this.options).duration(INIT_TIME);
  },
  exitAnimate: function (vanchart, animate) {
    var geo = vanchart.getCurrentGeo();

    if (animate) {
      this._path.interrupt(INIT_TRANSITION).transition(INIT_TRANSITION).ease(EXIT_EASE).style(geo.defaultAreaStyle()).duration(EXIT_TIME);
    } else {
      this._path.removeTransition(_Constants["default"].SELECT_ANIMATION).removeTransition(INIT_TRANSITION).style(geo.defaultAreaStyle());
    }
  },
  reShowAnimate: function () {
    this._path.style({
      'fill-opacity': 0
    }).animate({
      style: this.options,
      duration: RESHOW_TIME,
      ease: RESHOW_EASE
    });
  },
  _onMouseState: function (isChosen, duration, ease, style) {
    // 以前把闪烁的原因直接是吧filter给none了，这样会导致很多关于filter的交互都没效果了，闪烁的根本原因是从没有filter到设置了一个filter，那么让一直都有filter就好了
    this._path.transition(_Constants["default"].SELECT_ANIMATION).animate({
      duration: duration,
      ease: ease,
      style: style
    });
  },
  _reset: function () {
    // defined in children classes
    this._project();

    this._update();
  },
  _clickTolerance: function () {
    // used when doing hit detection for Canvas layers
    return (this.options['stroke-width'] ? this.options['stroke-width'] / 2 : 0) + (_Browser["default"].touch ? 10 : 0);
  },
  node: function () {
    return this._path.node();
  }
});

var _default = Path;
exports["default"] = _default;

/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Layer = _interopRequireDefault(__webpack_require__(20));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/1/20.
 */
var LayerGroup = _Layer["default"].extend({
  initialize: function (layers) {
    this._layers = {};
    var i, len;

    if (layers) {
      for (i = 0, len = layers.length; i < len; i++) {
        this.addLayer(layers[i]);
      }
    }
  },
  // @method addLayer(layer: Layer): this
  // Adds the given layer to the group.
  addLayer: function (layer) {
    var id = this.getLayerId(layer);
    this._layers[id] = layer;

    if (this._map) {
      this._map.addLayer(layer);
    }

    return this;
  },
  // @method removeLayer(layer: Layer): this
  // Removes the given layer from the group.
  // @alternative
  // @method removeLayer(id: Number): this
  // Removes the layer with the given internal ID from the group.
  removeLayer: function (layer) {
    var id = layer in this._layers ? layer : this.getLayerId(layer);

    if (this._map && this._layers[id]) {
      this._map.removeLayer(this._layers[id]);
    }

    delete this._layers[id];
    return this;
  },
  // @method hasLayer(layer: Layer): Boolean
  // Returns `true` if the given layer is currently added to the group.
  hasLayer: function (layer) {
    return !!layer && (layer in this._layers || this.getLayerId(layer) in this._layers);
  },
  // @method clearLayers(): this
  // Removes all the layers from the group.
  clearLayers: function () {
    for (var i in this._layers) {
      this.removeLayer(this._layers[i]);
    }

    return this;
  },
  // @method invoke(methodName: String, …): this
  // Calls `methodName` on every layer contained in this group, passing any
  // additional parameters. Has no effect if the layers contained do not
  // implement `methodName`.
  invoke: function (methodName) {
    var args = Array.prototype.slice.call(arguments, 1),
        i,
        layer;

    for (i in this._layers) {
      layer = this._layers[i];

      if (layer[methodName]) {
        layer[methodName].apply(layer, args);
      }
    }

    return this;
  },
  onAdd: function (map) {
    for (var i in this._layers) {
      map.addLayer(this._layers[i]);
    }
  },
  onRemove: function (map) {
    for (var i in this._layers) {
      map.removeLayer(this._layers[i]);
    }
  },
  // @method eachLayer(fn: Function, context?: Object): this
  // Iterates over the layers of the group, optionally specifying context of the iterator function.
  // ```js
  // group.eachLayer(function (layer) {
  // 	layer.bindPopup('Hello');
  // });
  // ```
  eachLayer: function (method, context) {
    for (var i in this._layers) {
      method.call(context, this._layers[i]);
    }

    return this;
  },
  // @method getLayer(id: Number): Layer
  // Returns the layer with the given internal ID.
  getLayer: function (id) {
    return this._layers[id];
  },
  // @method getLayers(): Layer[]
  // Returns an array of all the layers added to the group.
  getLayers: function () {
    var layers = [];

    for (var i in this._layers) {
      layers.push(this._layers[i]);
    }

    return layers;
  },
  // @method setZIndex(zIndex: Number): this
  // Calls `setZIndex` on every layer contained in this group, passing the z-index.
  setZIndex: function (zIndex) {
    return this.invoke('setZIndex', zIndex);
  },
  // @method getLayerId(layer: Layer): Number
  // Returns the internal ID for a layer
  getLayerId: function (layer) {
    return _BaseUtils["default"].stamp(layer);
  }
});

var _default = LayerGroup;
exports["default"] = _default;

/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBoxBounds = getBoxBounds;
exports.getBoxRect = getBoxRect;
exports.getBoxInitRect = getBoxInitRect;
exports.getBoxLine = getBoxLine;
exports.getLinkLine = getLinkLine;
exports.getPointDomain = getPointDomain;
exports.getBoxDataResult = getBoxDataResult;
exports.refreshBoxMarkerColor = refreshBoxMarkerColor;
exports.refreshBoxBorderColor = refreshBoxBorderColor;
exports.findInteractiveMarker = findInteractiveMarker;
exports.hasValidNormalMarker = hasValidNormalMarker;
exports.hasValidOutlierMarker = hasValidOutlierMarker;
exports.selectOutlierData = selectOutlierData;
exports.clearMarker = clearMarker;
exports.updateMarker = updateMarker;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _CoreUtils = __webpack_require__(2);

var _StyleUtils = __webpack_require__(16);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var NORMAL_MARKER_OPACITY = 0.6;
var OUTLIER_MARKER_OPACITY = 1;

function getBoxBounds(props) {
  var offset = props.offset,
      width = props.width,
      startPos = props.startPos,
      scale = props.scale,
      result = props.result,
      isInverted = props.isInverted;
  var maxPos = scale(result.max);
  var minPos = scale(result.min);

  if (isInverted) {
    return {
      x: minPos,
      y: startPos + offset - width / 2,
      width: Math.abs(maxPos - minPos),
      height: +width
    };
  } else {
    return {
      x: startPos + offset - width / 2,
      y: maxPos,
      width: width,
      height: Math.abs(maxPos - minPos)
    };
  }
}

function getBoxRect(props) {
  var offset = props.offset,
      width = props.width,
      startPos = props.startPos,
      scale = props.scale,
      result = props.result,
      isInverted = props.isInverted;
  var q3Pos = scale(result.q3);
  var q1Pos = scale(result.q1);

  if (isInverted) {
    return {
      x: Math.min(q1Pos, q3Pos),
      y: startPos + offset - width / 2,
      width: Math.abs(q1Pos - q3Pos),
      height: +width
    };
  }

  return {
    x: startPos + offset - width / 2,
    y: Math.min(q1Pos, q3Pos),
    width: width,
    height: Math.abs(q1Pos - q3Pos)
  };
}

function getBoxInitRect(props) {
  var offset = props.offset,
      width = props.width,
      startPos = props.startPos,
      midPos = props.midPos,
      isInverted = props.isInverted;

  if (isInverted) {
    return {
      x: midPos,
      y: startPos + offset - width / 2,
      width: 0,
      height: +width
    };
  }

  return {
    x: startPos + offset - width / 2,
    y: midPos,
    width: width,
    height: 0
  };
}

function getBoxLine(props) {
  var offset = props.offset,
      width = props.width,
      startPos = props.startPos,
      valuePos = props.valuePos,
      isInverted = props.isInverted;

  if (isInverted) {
    return {
      x1: valuePos,
      y1: startPos + offset - width / 2,
      x2: valuePos,
      y2: startPos + offset + width / 2
    };
  }

  return {
    x1: startPos + offset - width / 2,
    y1: valuePos,
    x2: startPos + offset + width / 2,
    y2: valuePos
  };
}

function getLinkLine(props) {
  var offset = props.offset,
      startPos = props.startPos,
      downPos = props.downPos,
      upPos = props.upPos,
      isInverted = props.isInverted;

  if (isInverted) {
    return {
      x1: downPos,
      y1: startPos + offset,
      x2: upPos,
      y2: startPos + offset
    };
  }

  return {
    x1: startPos + offset,
    y1: downPos,
    x2: startPos + offset,
    y2: upPos
  };
}

function getMedian(sorted) {
  if (_BaseUtils["default"].isArray(sorted) && sorted.length) {
    if (sorted.length % 2 === 0) {
      return (sorted[sorted.length / 2 - 1] + sorted[sorted.length / 2]) / 2;
    } else {
      return sorted[(sorted.length + 1) / 2 - 1];
    }
  }
}

function getBoxDataResult(originValue, isDetailed) {
  var max, q3, median, q1, min, mid;
  var normal = [];
  var outlier = [];

  if (originValue == null) {
    return;
  }

  if (isDetailed) {
    var filtered = filterNotNumber(originValue);
    var numerical = convertToNumber(filtered);
    var sorted = sortDetailedData(numerical);

    if (sorted.length === 0) {
      return {};
    }

    if (sorted.length === 1) {
      median = q3 = q1 = sorted[0];
    } else {
      median = getMedian(sorted);

      if (sorted.length % 2 === 0) {
        q1 = getMedian(sorted.slice(0, Math.ceil(sorted.length / 2)));
        q3 = getMedian(sorted.slice(Math.floor(sorted.length / 2)));
      } else {
        q1 = getMedian(sorted.slice(0, Math.ceil(sorted.length / 2) - 1));
        q3 = getMedian(sorted.slice(Math.floor(sorted.length / 2) + 1));
      }
    }

    var link = _BaseUtils["default"].accMul(_BaseUtils["default"].accAdd(q3, -q1), 1.5);

    max = _BaseUtils["default"].accAdd(q3, link);
    min = _BaseUtils["default"].accAdd(q1, -link);

    for (var i = 0, len = sorted.length; i < len; i++) {
      if (sorted[i] < min || sorted[i] > max) {
        outlier.push(sorted[i]);
      } else {
        normal.push(sorted[i]);
      }
    }

    mid = (min + max) / 2;
    return {
      number: filtered.length,
      max: max,
      q3: q3,
      median: median,
      min: min,
      q1: q1,
      outlier: outlier,
      normal: normal,
      mid: mid
    };
  } // 兼容结果数据缺失的情况，max向下取，min向上取，median不做调整


  max = adjustOriginMax(originValue);
  min = adjustOriginMin(originValue);
  mid = (min + max) / 2;
  q3 = (0, _CoreUtils.isNumberValue)(originValue.q3) ? +originValue.q3 : (max + mid) / 2;
  q1 = (0, _CoreUtils.isNumberValue)(originValue.q1) ? +originValue.q1 : (min + mid) / 2;
  median = originValue.median;
  return {
    max: max,
    q3: q3,
    median: median,
    q1: q1,
    min: min,
    mid: mid,
    outlier: outlier
  };
}

function adjustOriginMax(originResult) {
  var max = originResult.max,
      q3 = originResult.q3,
      median = originResult.median,
      q1 = originResult.q1,
      min = originResult.min;
  return getNumberValue([max, q3, median, q1, min, 0]);
}

function adjustOriginMin(originResult) {
  var max = originResult.max,
      q3 = originResult.q3,
      median = originResult.median,
      q1 = originResult.q1,
      min = originResult.min;
  return getNumberValue([min, q1, median, q3, max, 0]);
}

function getNumberValue(valueGroup) {
  // IE不支持Array.find
  for (var i = 0, len = valueGroup.length; i < len; i++) {
    var temp = valueGroup[i];

    if ((0, _CoreUtils.isNumberValue)(temp)) {
      return +temp;
    }
  }

  return 0;
}

function filterNotNumber(originValue) {
  // 先过滤无效数据 "-" ，再过滤数据中非数值类型的value
  if (_BaseUtils["default"].isArray(originValue) && originValue.length) {
    return originValue.filter(function (value) {
      return (0, _CoreUtils.isNumberValue)(value);
    });
  }

  return [];
}

function convertToNumber(originValue) {
  if (originValue == null || originValue.length === 0) {
    return [];
  }

  return originValue.map(function (v) {
    return +v;
  });
}

function sortDetailedData(originValue) {
  if (originValue == null || originValue.length === 0) {
    return [];
  }

  var result = [originValue[0]];

  for (var i = 1, len = originValue.length; i < len; i++) {
    result.push(originValue[i]);

    if (result[i] < result[i - 1]) {
      var temp = result[i];
      var j = i - 1;

      for (; j > -1 && temp < result[j]; j--) {
        result[j + 1] = result[j];
      }

      result[j + 1] = temp;
    }
  }

  return result;
}

function getPointDomain(originValue, isDetailed) {
  if (isDetailed === void 0) {
    isDetailed = true;
  }

  if (originValue == null) {
    return;
  }

  var result = isDetailed ? getBoxDataResult(originValue, true) : originValue;
  var max = result.max,
      q3 = result.q3,
      median = result.median,
      q1 = result.q1,
      min = result.min,
      outlier = result.outlier;
  return [max, q3, median, q1, min].concat(outlier);
}

function refreshBoxMarkerColor(options, fillColor) {
  var normalMarker = options.normalMarker,
      outlierMarker = options.outlierMarker;

  if (normalMarker) {
    var clonedNormalMarker = _BaseUtils["default"].clone(normalMarker);

    clonedNormalMarker.fillColor = normalMarker.fillColor || fillColor;
    clonedNormalMarker.fillColorOpacity = NORMAL_MARKER_OPACITY;
    clonedNormalMarker.radius = (0, _StyleUtils.getMarkerRadius)(normalMarker.radius);
    options.normalMarker = clonedNormalMarker;
  }

  if (outlierMarker) {
    var clonedOutlierMarker = _BaseUtils["default"].clone(outlierMarker);

    clonedOutlierMarker.fillColor = outlierMarker.fillColor || fillColor;
    clonedOutlierMarker.fillColorOpacity = OUTLIER_MARKER_OPACITY;
    clonedOutlierMarker.radius = (0, _StyleUtils.getMarkerRadius)(outlierMarker.radius);
    options.outlierMarker = clonedOutlierMarker;
  }
}

function refreshBoxBorderColor(point, seriesColor) {
  point.borderColor = point.borderColor || seriesColor;
}

function findInteractiveMarker(vanchart, event) {
  if (event.srcEvent) {
    var rowElement = event.srcEvent.target || event.srcEvent.srcElement;
    return vanchart.findInteractiveTarget(rowElement);
  }
}

function selectOutlierData(point, event) {
  var vanchart = point.series.vanchart; // 自动数据点提示时，模拟的event只有containerPoint属性

  if (event.containerPoint && point.contains(event.containerPoint)) {
    return null;
  }

  return findInteractiveMarker(vanchart, event);
} // CHART-15791 没有进行marker更新


function updateMarker(point) {
  var markerGroupDomObj = point.graphic.markerGroup,
      normalMarkerDataArr = point.normalMarkerGroup || [],
      outlierMarkerDataArr = point.outlierMarkerGroup || [],
      _point$options = point.options,
      normalMarker = _point$options.normalMarker,
      outlierMarker = _point$options.outlierMarker;

  _updateMarkerGroup(markerGroupDomObj, normalMarkerDataArr, point, 'normalMarker_', normalMarker);

  _updateMarkerGroup(markerGroupDomObj, outlierMarkerDataArr, point, 'outlierMarker_', outlierMarker);
}
/*
* markerGroup是Dom节点对象，里面存储的格式是normalMarker_1或者oulierMarker_1等，两种可能都存在在同一个点中
* markerData是对应的marker的数据数组，数组多长就有多少个对应marker
* */


function _updateMarkerGroup(markerGroup, markerData, point, prefix, markerConstruct) {
  var index, marker; // remove

  index = markerData.length;

  while (markerGroup[prefix + index]) {
    clearMarker(markerGroup[prefix + index]);
    delete markerGroup[prefix + index];
    index++;
  } // add


  index = markerData.length - 1;

  if (index >= 0) {
    while (!markerGroup[prefix + index] && markerData[index]) {
      marker = point.series._createMarker(markerConstruct);
      marker.attr({
        'transform': 'translate(' + markerData[index].x + ',' + markerData[index].y + ') scale(1)'
      });
      markerGroup[prefix + index] = marker.addTo(markerGroup);
      index--;
    }
  }
}

function clearMarker(group) {
  group.image && group.image.remove();
  group.markerPath && group.markerPath.remove();
  group.remove();
}

function hasValidNormalMarker(point) {
  if (point == null || point.options == null) {
    return false;
  }

  var normalMarker = point.options.normalMarker;
  return (0, _CoreUtils.hasDefined)(normalMarker) && (0, _CoreUtils.hasDefined)(normalMarker.symbol);
}

function hasValidOutlierMarker(point) {
  if (point == null || point.options == null) {
    return false;
  }

  var outlierMarker = point.options.outlierMarker;
  return (0, _CoreUtils.hasDefined)(outlierMarker) && (0, _CoreUtils.hasDefined)(outlierMarker.symbol);
}

/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Series = _interopRequireDefault(__webpack_require__(14));

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

var _BezierEasing = _interopRequireDefault(__webpack_require__(8));

var _EnvUtils = __webpack_require__(3);

var _CoreUtils = __webpack_require__(2);

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _ThemeConfig = __webpack_require__(25);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/12/2.
 */
var MIN_FONTSIZE = 10;
var LINE_HEIGHT = 1.2; // 字体行高

var PERCENT_VALUE_LABEL_GAP = 0.13; // 百分比标签与值标签间隔占百分比字体高度的比例

var Gauge = _Series["default"].extend({
  DEFAULT_PADDING: 5,
  LINE_GAP: 0.3,
  VERTICAL_GAP: 0.3,
  HORIZONTAL_GAP: 0.5,
  LABEL_AUTO_FONTSIZE: '12px',
  DEFAULT_LABEL_WIDTH: 0.25,
  // vertical试管型仪表盘的标签宽度默认占绘图区宽度的比例
  ANIMATION_TIME: 1200,
  EASE_TYPE: 'cubic-out',
  CHOSEN_EASE: _BezierEasing["default"].css['ease'],
  CHOSEN_TIME: 200,
  OUT_EASE: _BezierEasing["default"].css['ease-out'],
  OUT_TIME: 900,
  LABEL_BACKGROUND_COLOR: 'rgba(255,255,255,0)',
  refresh: function (options, index) {
    _Series["default"].prototype.refresh.call(this, options, index);

    options = this.options;
    this.gaugeType = options.style;
    this.center = null;

    if (options.center) {
      this.center = [this._getPercentValue(options.center[0], this.vanchart.width), this._getPercentValue(options.center[1], this.vanchart.height)];
    }

    return this;
  },
  getBaseAxisType: function () {
    return 'gaugeAxis';
  },
  doLayout: function () {
    var seriesBounds = this._calculateGaugeBounds(),
        series = this,
        options = series.options;

    if (!seriesBounds && !options.radius && !series.center) {
      throw new Error('gauge has no bounds');
    }

    this.bounds = seriesBounds;

    this._calculatePercentage(); //bands和color这两个属性放在doLayout原因：default bands depend on gauge axis domain.


    series.defaultBands = (options.bands || []).concat(series._getDefaultBands(series.gaugeAxis.scale.domain()));
    series.points.forEach(function (point) {
      var bandsColor = series._getColorFromBands(point.getTargetValue(), series.defaultBands);

      if (bandsColor) {
        bandsColor = _ColorUtils["default"].getStandardColorAndOpacity(bandsColor);
        point.color = bandsColor.hex;
        point.opacity = bandsColor.alpha;
      }

      point.mouseOverColor = _ColorUtils["default"].getHighLightColor(point.color);
      point.clickColor = _ColorUtils["default"].getClickColor(point.color);
    });

    this._doLayout();
  },
  _doLayout: function () {},
  // 槽型、圆环仪表盘
  _fixCenterAndRadius: function (paddingPercent) {
    var gauge = this,
        options = gauge.options,
        radius = options.radius,
        centerX,
        circleWidth = options.circleWidth,
        centerY,
        startY,
        totalHeight,
        lineGap,
        labelCount;

    if (gauge.center) {
      centerX = gauge.center[0];
      centerY = gauge.center[1];
    } else {
      var bounds = gauge.bounds;
      radius = radius || Math.min(bounds.width / 2, bounds.height / 2) / (1 + paddingPercent);
      centerX = bounds.x + bounds.width / 2;
      centerY = bounds.y + bounds.height / 2;
    }

    gauge.centerX = centerX;
    gauge.centerY = centerY;
    gauge.radius = radius;

    if (gauge.percentageLabelContent && gauge.valueLabelContent && gauge.valueLabelContent.length > 0) {
      var valueLabelTotalHeight = this.calculateLabelTotalHeight(gauge.valueLabelContent);
      labelCount = gauge.valueLabelContent.length;
      var valueLabelLineGap = valueLabelTotalHeight * (LINE_HEIGHT - 1) / labelCount;
      totalHeight = valueLabelTotalHeight + gauge.percentageLabelDim.height * (1 + PERCENT_VALUE_LABEL_GAP);
      startY = -totalHeight / 2;
      gauge.percentageLabelPos = {
        x: -gauge.percentageLabelDim.width / 2,
        y: startY
      };
      startY += gauge.percentageLabelDim.height * (1 + PERCENT_VALUE_LABEL_GAP);

      for (var i = 0, count = gauge.valueLabelContent.length; i < count; i++) {
        var valueLabel = gauge.valueLabelContent[i];
        valueLabel.labelPos = {
          x: -valueLabel.labelDim.width / 2,
          y: startY
        };
        startY += valueLabel.labelDim.height + valueLabelLineGap;
      }
    } else if (gauge.percentageLabelContent) {
      gauge.percentageLabelPos = {
        x: -gauge.percentageLabelDim.width / 2,
        y: -gauge.percentageLabelDim.height / 2
      };
    } else if (gauge.valueLabelContent && gauge.valueLabelContent.length > 0) {
      labelCount = gauge.valueLabelContent.length;
      totalHeight = this.calculateLabelTotalHeight(gauge.valueLabelContent);
      lineGap = totalHeight * (LINE_HEIGHT - 1) / labelCount;
      startY = -(totalHeight / 2 - lineGap / 2);

      for (var i = 0; i < labelCount; i++) {
        var valueLabel = gauge.valueLabelContent[i];
        valueLabel.labelPos = {
          x: -valueLabel.labelDim.width / 2,
          y: startY
        };
        startY += valueLabel.labelDim.height + lineGap;
      }
    }
  },
  calculateLabelTotalHeight: function (labelContent) {
    var totalHeight = 0;
    var labelCount = labelContent.length;

    for (var i = 0; i < labelCount; i++) {
      totalHeight += labelContent[i].labelDim.height;
    }

    return totalHeight * LINE_HEIGHT;
  },
  calculateLabelInfo: function (point) {},
  _createGroup: function (renderer, vanchart) {
    return renderer.group().addTo(vanchart.seriesGroup);
  },
  _getAxisTypes: function () {
    return ['gaugeAxis'];
  },
  getDataToDraw: function () {
    return [];
  },
  _calculatePercentage: function () {
    if (this.points.length) {
      var gaugeAxis = this.gaugeAxis,
          minMax = gaugeAxis.scale.domain();
      var points = this.points;
      points.forEach(function (point) {
        point.points = points;
        point.percentage = (point.value - minMax[0]) / (minMax[1] - minMax[0]);
      });
    }
  },
  _calculateLabelPos: function () {},
  _getTranslate: function () {
    return [Math.round(this.centerX), Math.round(this.centerY)];
  },
  _validPoint: function () {
    var validPoints = this.points.filter(function (point) {
      return !point.isNull;
    });
    return validPoints[0] || this.points[0];
  },
  isValidDataLabel: function (point, dataLabels) {
    return point && !point.isNull && dataLabels && dataLabels.enabled;
  },
  getThemeLabelColor: function (labelStyle) {
    var isDarkTheme = this.vanchart.isDarkTheme();
    var autoColor = labelStyle.autoColor;

    if (autoColor) {
      return (0, _ThemeConfig.getThemeAutoValue)(_Constants["default"].AUTO, 'gaugeLabelColor', isDarkTheme);
    }

    return labelStyle.color;
  },
  _autoValueLabelWithPercent: function (labelContents, valueLabel, fontHeight, limitWidth, series) {
    var valueString = labelContents.value;
    var categoryString = labelContents.category;
    var valueLabelContent = [];
    var useHtml = valueLabel.useHtml;

    var labelStyle = _BaseUtils["default"].clone(valueLabel.style);

    labelStyle.fontSize = fontHeight;

    if (labelContents.category && labelContents.value) {
      valueLabelContent = this._categoryAndValue(labelContents, valueLabel, fontHeight, limitWidth);
    } else if (labelContents.category) {
      var categoryLabel = _BaseUtils["default"].splitAndShrinkText(categoryString, MIN_FONTSIZE, labelStyle, limitWidth, useHtml);

      labelContents = categoryLabel.text;
      labelStyle.fontSize = categoryLabel.fontSize;

      for (var i = 0, len = labelContents.length; i < len; i++) {
        var labelContent = labelContents[i];
        valueLabelContent.push({
          labelContent: labelContent,
          labelStyle: labelStyle,
          labelDim: _BaseUtils["default"].getTextDimension(labelContent, labelStyle, useHtml)
        });
      }
    } else {
      var label = valueString || labelContents.text;
      label = _BaseUtils["default"].shrinkText(label, MIN_FONTSIZE, fontHeight, limitWidth, labelStyle, useHtml);
      labelStyle.fontSize = label.fontSize;
      valueLabelContent.push({
        labelContent: label.labelContent,
        labelStyle: labelStyle,
        labelDim: _BaseUtils["default"].getTextDimension(label.labelContent, labelStyle, useHtml)
      });
    }

    series.valueLabelContent = valueLabelContent;
  },
  _categoryAndValue: function (labelContents, valueLabel, fontHeight, limitWidth) {
    var valueString = labelContents.value;
    var categoryString = labelContents.category;
    var valueLabelContent = [];
    var useHtml = valueLabel.useHtml;

    var labelStyle = _BaseUtils["default"].clone(valueLabel.style);

    labelStyle.fontSize = Math.max(fontHeight, MIN_FONTSIZE) + 'px';
    var singleLineText = categoryString + ' ' + valueString;

    var singleLineWidth = _BaseUtils["default"].getTextDimension(singleLineText, labelStyle, useHtml).width;

    if (singleLineWidth <= limitWidth) {
      valueLabelContent.push({
        labelContent: singleLineText,
        labelStyle: labelStyle,
        labelDim: _BaseUtils["default"].getTextDimension(singleLineText, labelStyle, useHtml)
      });
    } else {
      labelContents = _BaseUtils["default"].objectToArray(labelContents);

      for (var i = 0, len = labelContents.length; i < len; i++) {
        var labelContent = labelContents[i];

        var labelStyle = _BaseUtils["default"].clone(valueLabel.style);

        var autoSizeLabel = _BaseUtils["default"].shrinkText(labelContent, MIN_FONTSIZE, fontHeight, limitWidth, labelStyle, useHtml);

        labelContent = autoSizeLabel.labelContent;
        labelStyle.fontSize = autoSizeLabel.fontSize;
        valueLabelContent.push({
          labelContent: labelContent,
          labelStyle: labelStyle,
          labelDim: _BaseUtils["default"].getTextDimension(labelContent, labelStyle, useHtml)
        });
      }
    }

    return valueLabelContent;
  },
  // 勾选百分比，分类、值非自动调整情况下的显示
  _valueLabelWithPercent: function (labelContents, valueLabel, limitWidth, series, isThermometer) {
    var separator = isThermometer ? ':' : ' ';
    var valueString = (0, _CoreUtils.isEmpty)(labelContents.value) ? '' : labelContents.value;
    var categoryString = (0, _CoreUtils.isEmpty)(labelContents.category) ? '' : labelContents.category;
    var connectionSymbol = (0, _CoreUtils.isEmpty)(labelContents.category) || (0, _CoreUtils.isEmpty)(valueString) ? '' : separator;
    var singleLineText = categoryString + connectionSymbol + valueString;

    var labelStyle = _BaseUtils["default"].clone(valueLabel.style);

    var valueLabelContent = [];
    var useHtml = valueLabel.useHtml;

    var singleLineWidth = _BaseUtils["default"].getTextDimension(singleLineText, labelStyle, useHtml).width;

    var percentageLabel = series.options.percentageLabel;

    if (isThermometer && series.percentageLabelContent && valueLabel.align === percentageLabel.align) {
      singleLineWidth += series.percentageLabelDim.width;
    } // 内容设置为通用的情况


    if (singleLineWidth >= limitWidth) {
      labelContents = _BaseUtils["default"].objectToArray(labelContents);

      for (var i = 0, len = labelContents.length; i < len; i++) {
        var labelContent = _BaseUtils["default"].getEllipsisText(labelContents[i], limitWidth, labelStyle, useHtml);

        valueLabelContent.push({
          labelContent: labelContent,
          labelStyle: labelStyle,
          labelDim: _BaseUtils["default"].getTextDimension(labelContent, labelStyle, useHtml)
        });
      }
    } else {
      valueLabelContent.push({
        labelContent: singleLineText,
        labelStyle: labelStyle,
        labelDim: _BaseUtils["default"].getTextDimension(singleLineText, labelStyle, useHtml)
      });
    }

    series.valueLabelContent = valueLabelContent;
  },
  _getDefaultBands: function (domain) {
    var color = this.options.color,
        bands = [];

    if (color) {
      bands.push({
        from: domain[0],
        to: domain[1],
        color: color
      });
    } else {
      var min = domain[0],
          max = domain[1];

      var band = _BaseUtils["default"].accDiv(max - min, 3);

      var fStop = _BaseUtils["default"].accAdd(min, band);

      var sStop = _BaseUtils["default"].accAdd(fStop, band);

      var colors = this.vanchart.options.colors;
      bands = [{
        from: min,
        to: fStop,
        color: colors[0]
      }, {
        from: fStop,
        to: sStop,
        color: colors[1]
      }, {
        from: sStop,
        to: max,
        color: colors[2]
      }];
    }

    return bands;
  },

  /**
   * 仪表盘会取配色方案中前三种颜色，分配适配刻度0~1/3, 1/3~2/3, 2/3~1的区间色
   * 0以下的配色取0～1/3的区间色，1以上的取2/3～1的区间色
   * @param value
   * @param bands
   * @returns {*}
   * @private
   */
  _getColorFromBands: function (value, bands) {
    if (bands && bands.length) {
      var bandValues = [];

      for (var i = 0, len = bands.length; i < len; i++) {
        var band = bands[i];
        var min = Math.min(band.from, band.to);
        var max = Math.max(band.from, band.to);
        bandValues.push(min, max);

        if (value >= min && value <= max) {
          return band.color;
        }
      }

      var minBandValues = Math.min.apply(Math, bandValues);
      var maxBandValues = Math.max.apply(Math, bandValues);

      if (value < minBandValues) {
        return bands[0].color;
      }

      if (value > maxBandValues) {
        return bands[bands.length - 1].color;
      }
    }
  },
  //计算每个系列的边界,要么定义了圆心和半径,作为悬浮元素处理,要么两者都不定义,自定平分区域
  //只定义半径没定义圆心,或者只定义了圆心没有定义半径,效果都是未知的
  _calculateGaugeBounds: function () {
    var series = this.vanchart.seriesOfType(_Constants["default"].GAUGE_CHART);
    var plotBounds = this.vanchart.bounds;
    var GAUGE_PLOT_RATE = 0.9;
    var gaugePlotBounds = {
      width: GAUGE_PLOT_RATE * plotBounds.width,
      height: GAUGE_PLOT_RATE * plotBounds.height,
      x: plotBounds.x + _BaseUtils["default"].accDiv(1 - GAUGE_PLOT_RATE, 2) * plotBounds.width,
      y: plotBounds.y + _BaseUtils["default"].accDiv(1 - GAUGE_PLOT_RATE, 2) * plotBounds.height
    };
    var fixedSize = 0;

    for (var i = 0, len = series.length; i < len; i++) {
      if (series[i].center && series[i].options.radius) {
        fixedSize++;
      }
    } //平均半径


    var isHorizontalLayout = this.options.layout == _Constants["default"].HORIZONTAL_LAYOUT;
    var divideDimKey = isHorizontalLayout ? 'width' : 'height';
    var averageSize = gaugePlotBounds[divideDimKey] / Math.max(1, series.length - fixedSize);

    for (var i = 0, len = series.length; i < len; i++) {
      if (series[i] == this) {
        if (!this.center) {
          if (isHorizontalLayout) {
            return {
              x: gaugePlotBounds.x + i * averageSize,
              y: gaugePlotBounds.y,
              width: averageSize,
              height: gaugePlotBounds.height
            };
          } else {
            return {
              x: gaugePlotBounds.x,
              y: gaugePlotBounds.y + i * averageSize,
              width: gaugePlotBounds.width,
              height: averageSize
            };
          }
        }
      }
    }

    return {
      x: 0,
      y: 0,
      width: 0,
      height: 0
    };
  },
  //试管的重写了
  _getFixedPos: function (datum, divDim) {
    var gauge = datum.series,
        style = gauge.gaugeType;
    var x, y;

    if (style == 'pointer_semi') {
      x = gauge.centerX - divDim.width / 2;
      y = gauge.centerY + 0.14 * gauge.radius + 10;
    } else {
      x = gauge.centerX + gauge.radius + 10;
      y = gauge.centerY - divDim.height / 2;
    }

    return [x, y];
  },
  _animateEnd: function () {},
  _getPointTextLabelGroup: function () {
    if (!this.textGraphicGroup) {
      var vanchart = this.vanchart,
          textDivGroup = vanchart.seriesTextDivGroup;
      this.textGraphicGroup = vanchart.renderer.vgroup();
      this.textGraphicGroup.renderG.addTo(this.group);
      textDivGroup.append(this.textGraphicGroup.divG);
    }

    this.textGraphicGroup.divG.attr('transform', _BaseUtils["default"].makeTranslate(this._getTranslate()));
    return this.textGraphicGroup;
  },
  _getPointAxisGroup: function () {
    if (!this.axisGraphicGroup) {
      var vanchart = this.vanchart,
          textDivGroup = vanchart.seriesTextDivGroup;
      this.axisGraphicGroup = vanchart.renderer.vgroup();
      this.axisGraphicGroup.renderG.addTo(this.group);
      textDivGroup.append(this.axisGraphicGroup.divG);
    }

    this.axisGraphicGroup.divG.attr('transform', _BaseUtils["default"].makeTranslate(this._getTranslate()));
    return this.axisGraphicGroup;
  },
  _drawGaugeLabels: function (labelG) {
    var series = this,
        vanchart = series.vanchart;

    series._removeNormalLabels(labelG);

    series._drawNormalLabels(labelG); // 试管仪表盘更新一下标签动画Init的偏移，
    // 下一次标签绘制时动画应从上一次的位置开始


    series.updateLastLabelPos && series.updateLastLabelPos(); // 标签和系列绘制完成再绘制MoreLabel

    if (vanchart._needShowMoreLabel() && series.visible) {
      series._drawDiffMoreLabels();
    } // 改回vanchart._changeDataState


    vanchart._removeChangeDataState(series);
  },
  //默认的是ring and slot 其他要重写这个方法
  _drawDiffMoreLabels: function () {
    var series = this,
        point = this.points[0];

    if (!point || point.isNull) {
      return;
    }

    this._showMoreLabel(point, series.centerX, series.centerY);
  },
  _removeNormalLabels: function (labelG) {
    //简化代码,标签每次都重画
    var labels = labelG.labels || [];

    for (var i = 0, len = labels.length; i < len; i++) {
      labels[i] && labels[i].remove();
      labels[i] = null;
    }

    this._drawExitValueLabel && this._drawExitValueLabel(); // 仪表盘的valueLabel单独拿出来画了，因此也要单独移除
  },
  _drawNormalLabels: function (labelG) {
    var series = this,
        options = series.options,
        vanchart = series.vanchart,
        renderer = vanchart.renderer;
    labelG.labels = [];

    if (series.seriesLabelContent) {
      var seriesLabel = {
        labelContent: series.seriesLabelContent,
        labelDim: series.seriesLabelDim,
        labelPos: series.seriesLabelPos,
        labelStyle: series.seriesLabelStyle
      };

      series._drawLabel(labelG, seriesLabel, options.seriesLabel.useHtml);
    }

    if (series.percentageLabelContent) {
      var percentageLabel = {
        labelContent: series.percentageLabelContent,
        labelDim: series.percentageLabelDim,
        labelPos: series.percentageLabelPos,
        labelStyle: series.percentageLabelStyle
      };

      series._drawLabel(labelG, percentageLabel, options.percentageLabel.useHtml, series.animateLabelPara());
    }

    if (series.valueLabelContent && series.valueLabelContent.length) {
      // 指针类型的仪表盘值标签后面有背景
      if (series.valueLabelBackground) {
        var valueLabelBackground = series.valueLabelBackground;

        var background = _BaseUtils["default"].rectSubPixelOpt(series.valueLabelBackground, 0);

        background.rx = background.rx = series.radius * 0.02;
        var valueLabelCfg = series.options.valueLabel;
        var valueLabelBackgroundColor = valueLabelCfg.backgroundColor || this.LABEL_BACKGROUND_COLOR; // @Cmen:这里注明一下，仪表盘刷新的时候，旧的ValueLabel和新的ValueLabel要同时存在，且应该在backgroundRect上面，因此这里只更新，不重绘

        series.valueLabelBackgroundRect = series.valueLabelBackgroundRect || renderer.rect().addTo(labelG);
        series.valueLabelBackgroundRect.attr(background).style({
          'fill': valueLabelBackgroundColor,
          'fill-opacity': _ColorUtils["default"].getColorOpacity(valueLabelBackgroundColor),
          'filter': renderer.toPatternProperty(series.innerFilter)
        });
        series.labelGroups = series.labelGroups || [];
        series.labelGroups.push(series.valueLabelG); // 把旧的存起来,移除的时候可能需要等到动画结束后

        var valueLabelG = series.valueLabelG = renderer.group().addTo(labelG);

        if (!series.clipRect) {
          series.clipRect = renderer.createClip(series.valueLabelBackground);
        } else {
          renderer.updateClip(series.clipRect, series.valueLabelBackground);
        }

        renderer.clip(valueLabelG, series.clipRect);
        labelG.valueLabelDivG = renderer.vtext(true).style({
          clip: 'rect(' + [valueLabelBackground.y, valueLabelBackground.x + valueLabelBackground.width, valueLabelBackground.y + valueLabelBackground.height, valueLabelBackground.x].join('px ') + 'px)'
        }).addTo(labelG);
      }

      var isPointerGaugeValueLabel = series.isPointerGauge();

      for (var i = 0, len = series.valueLabelContent.length; i < len; i++) {
        var valueLabel = series.valueLabelContent[i];

        series._drawLabel(labelG, valueLabel, options.valueLabel.useHtml, series.animateLabelPara(), valueLabelG, isPointerGaugeValueLabel);
      }
    } else {
      series.valueLabelBackgroundRect && series.valueLabelBackgroundRect.remove();
      series.valueLabelBackgroundRect = null; //@CHART-1747
    }
  },
  animateLabelPara: function () {},
  _getGaugeLabelG: function (labelG, parentG, useHtml, isPointerGaugeValueLabel) {
    var parentDivG = isPointerGaugeValueLabel ? labelG.valueLabelDivG : labelG;
    return (useHtml ? parentDivG : parentG) || labelG;
  },
  _drawLabel: function (labelG, label, useHtml, animatePara, parentG, isPointerGaugeValueLabel) {
    var labelContent = label.labelContent,
        labelDim = label.labelDim,
        labelPos = label.labelPos,
        labelStyle = label.labelStyle;

    if (!labelPos) {
      return;
    }

    var series = this,
        vanchart = series.vanchart,
        renderer = vanchart.renderer;

    var gaugeLabelG = this._getGaugeLabelG(labelG, parentG, useHtml, isPointerGaugeValueLabel);

    var textAttr = {
      'x': labelPos.x,
      'y': labelPos.y,
      'width': labelDim.width + 'px',
      'height': labelDim.height + 'px',
      'text-align': 'center',
      'overflow': 'hidden'
    };
    var textG = renderer.vtext(useHtml).attr(textAttr).style(labelStyle).textContent(labelContent).addTo(gaugeLabelG);

    var offsetAttr = this._textOffset(labelDim, useHtml);

    textG = textG.attr(offsetAttr); // 指针仪表盘的ValueLabel要单独对待

    if (isPointerGaugeValueLabel) {
      series.valueLabels = series.valueLabels || [];
      series.valueLabels.push(textG);
    } else {
      labelG.labels.push(textG);
    } // IE8及以下有动画也不执行


    if ((0, _EnvUtils.isSupportSVG)() && animatePara && animatePara.enabled) {
      if (!series.hasChangedPointWithChangeDataState() && !series.initialAnimationMoving) {
        return;
      } // 未发生值变化，不执行动画


      textG.attr(animatePara.initAttr || {}).style(animatePara.initStyle || {}).animate({
        ease: series.EASE_TYPE,
        duration: series.ANIMATION_TIME,
        style: {
          'opacity': 1,
          'transform': _BaseUtils["default"].makeTranslateWithPX({
            x: 0,
            y: 0
          })
        },
        attr: {
          'transform': _BaseUtils["default"].makeTranslate({
            x: 0,
            y: 0
          })
        }
      });
    }
  },
  // ie浏览器不支持dominant-baseline，其他浏览器以及移动端直接使用{'dy': '.85em'}会出现偏移
  _textOffset: function (labelDim, useHtml) {
    var offset; // vmlRenderer会将dx、dy解析成margin-left、margin-top导致标签位置不对，所以使用html解析的无需添加dx、dy

    if (useHtml) {
      return {};
    }

    if (this.isSupportVerticalLabel()) {
      offset = 0.5 * labelDim.width;
      return _Browser["default"].ie ? {
        dx: '.15em'
      } : {
        dx: offset,
        'dominant-baseline': 'central'
      };
    }

    offset = 0.5 * labelDim.height;
    return _Browser["default"].ie ? {
      dy: '.85em'
    } : {
      dy: offset,
      'dominant-baseline': 'central'
    };
  },
  _onState: function (graphic, isChosen, style) {
    var series = this;
    graphic && graphic.interrupt(_Constants["default"].SELECT_ANIMATION).transition(_Constants["default"].SELECT_ANIMATION).animate({
      ease: isChosen ? series.CHOSEN_EASE : series.OUT_EASE,
      duration: isChosen ? series.CHOSEN_TIME : series.OUT_TIME,
      style: style
    });
  },
  isPointerGauge: function () {
    return false;
  },
  _onSinglePointerTap: function (ev) {
    if (this.vanchart.isMobileFlow()) {
      // todo, which point?
      var p = this.points[0];
      this.vanchart.showTooltip(p, ev);

      p._onPointTap(ev);
    } else {
      this.vanchart && this.vanchart.isMobile() && this.fire("mousemove", ev); // MOBILE-4762
      //单个指针的时候点击触发超链

      if (this.points && this.points.length === 1) {
        this.points[0].onClick(ev.srcEvent);
      }
    }
  },
  _onSeriesMouseOver: function (ev) {
    if (this.points && this.points.length === 1 || this.isSupportSharedTooltip()) {
      this.vanchart.showTooltip(this.points[0], ev);
    }
  },
  _onSeriesMouseOut: function () {
    this.vanchart.hideTooltip();
  },
  getClosestPoint: function () {
    return this.points.length === 1 ? this.points[0] : null;
  },
  //一个点一个系列
  getEvents: function () {
    return {
      'pointMouseOver': this._onPointMouseOver,
      'pointMouseOut': this._onPointMouseOut,
      'mousemove': this._onSeriesMouseOver,
      'mouseout': this._onSeriesMouseOut,
      'tap': this._onSinglePointerTap,
      'press': this.onSeriesPress,
      'pressup': this.onSeriesPressUp
    };
  },
  isSupportLegendHighlight: function () {
    return false;
  },
  isSeriesAccumulated: function () {
    return true;
  },
  isSupportSharedTooltip: function () {
    var tooltip = this.vanchart.options.plotOptions.tooltip || {};
    return !!this.options.tooltip.shared || !!tooltip.shared;
  },
  isSupportVerticalLabel: function () {
    var options = this.options,
        gaugeType = this.gaugeType;
    var _options$percentageLa = options.percentageLabel,
        percentageLabel = _options$percentageLa === void 0 ? {} : _options$percentageLa,
        _options$valueLabel = options.valueLabel,
        valueLabel = _options$valueLabel === void 0 ? {} : _options$valueLabel;
    var isVerticalThermometerGauge = gaugeType === _Constants["default"].THERMOMETER_GAUGE && options.thermometerLayout === _Constants["default"].VERTICAL_LAYOUT;
    return isVerticalThermometerGauge && (percentageLabel.orientation === _Constants["default"].VERTICAL_LAYOUT || valueLabel.orientation === _Constants["default"].VERTICAL_LAYOUT);
  }
});

var _default = Gauge;
exports["default"] = _default;

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseAxis = _interopRequireDefault(__webpack_require__(67));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _Scale = _interopRequireDefault(__webpack_require__(10));

var _BezierEasing = _interopRequireDefault(__webpack_require__(8));

var _component = __webpack_require__(4);

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/5/18.
 * 分类轴的定义
 */
var LABEL_PADDING = 2;
var LABEL_LINE_GAP = 2.5;

var LABEL_LINE_GAP_FUN = function () {
  return _BaseUtils["default"].paddingConvertWithScale(LABEL_LINE_GAP);
};

var CategoryAxis = _BaseAxis["default"].extend({
  type: _component.ComponentCst.CATEGORY_AXIS_COMPONENT,
  initScale: function () {
    this.lastScale = this.scale;
    this.scale = _Scale["default"].ordinal();
  },
  calculateDomainFromData: function () {
    this._dataDomain = this._getDomainFromData();
    var zoomTool = this.vanchart.getComponent(_component.ComponentCst.ZOOM_COMPONENT);
    this._zoomDomain = this._zoomDomain || zoomTool && zoomTool.getZoomDomain(this);
    this._domain = this._zoomDomain || this._dataDomain;
  },
  calculateDomainFromZoom: function () {
    this._domain = this._zoomDomain;
    this.isBaseAxisOnZoomOnly() && this.vanchart.reCalcValueAxisDataDomain(this.componentType); //缩放控件方向只有一个且在baseAxis上时，重新计算值轴值域
  },
  _getStartAndEndTick: function () {
    return [this._domain[0], this._domain[this._domain.length - 1]];
  },
  _getDomainFromData: function () {
    var axisOption = this.options,
        series = this.series,
        axis = this,
        stored = {};
    var categories = axisOption.categories || [];
    categories.forEach(function (category) {
      stored[category] = true;
    });
    series.forEach(function (sery) {
      this.getTrendLineForecast(sery);

      for (var i = 0, len = sery.points.length; i < len; i++) {
        var tickLabel = sery.points[i].getCategory();

        if (!stored[tickLabel]) {
          stored[tickLabel] = true;
          categories.push(tickLabel);
        }
      } // 多分类轴下面积图isRangePoints也是false


      if (sery.type !== _Constants["default"].AREA_CHART || this.isMultiCateAxis()) {
        axis.isRangePoints = false;
      }
    }, this); // 多分类轴下，需要将_dataDomain格式一下，保证相同父层级的分类在一起

    if (this.isMultiCateAxis() && categories.length) {
      categories = this.resortDataDomain(categories);
    }

    return this.addTrendLineCategories(categories);
  },
  _getCategoryWidth: function () {
    if (this.isHorizontal()) {
      var vanchart = this.vanchart;

      var _ref = vanchart._initPlotBounds || vanchart.bounds,
          _ref$width = _ref.width,
          width = _ref$width === void 0 ? 0 : _ref$width;

      var _this$vanchart$axisSi = this.vanchart.axisSize,
          _this$vanchart$axisSi2 = _this$vanchart$axisSi.left,
          left = _this$vanchart$axisSi2 === void 0 ? 0 : _this$vanchart$axisSi2,
          _this$vanchart$axisSi3 = _this$vanchart$axisSi.right,
          right = _this$vanchart$axisSi3 === void 0 ? 0 : _this$vanchart$axisSi3; // todo 水平方向的分类宽度与scale时的rangeBands统一

      return (width - left - right) / this._domain.length;
    }

    return this._getVerticalLabelMaxSize();
  },
  _getVerticalLabelMaxSize: function () {
    var _this$options = this.options,
        maxHeight = _this$options.maxHeight,
        maxWidth = _this$options.maxWidth;

    var _ref2 = this.vanchart._initPlotBounds || this.vanchart.bounds,
        width = _ref2.width;

    var max = width;

    if (this.vanchart.isInverted() && maxHeight) {
      max = this._maxWidth(maxHeight);
    }

    if (!this.vanchart.isInverted() && maxWidth) {
      max = this._maxWidth(maxWidth);
    }

    max -= this._getLabelTitleAndTickSize();
    return Math.max(max, 0);
  },
  _getLabelAlign: function () {
    var position = this.getPosition();

    if (position === _Constants["default"].LEFT) {
      return _Constants["default"].RIGHT;
    }

    if (position === _Constants["default"].RIGHT) {
      return _Constants["default"].LEFT;
    }

    return _Constants["default"].CENTER;
  },
  _calculateAlignShift: function (maxWidth, textWidth) {
    var align = this._getLabelAlign();

    switch (align) {
      case _Constants["default"].LEFT:
        return 0;

      case _Constants["default"].RIGHT:
        return maxWidth - textWidth;

      case _Constants["default"].CENTER:
      default:
        return (maxWidth - textWidth) / 2;
    }
  },
  _calcTickLabelDim: function (tickContent, usableWidth) {
    if (tickContent === void 0) {
      tickContent = '';
    }

    var labelDisplay = this.options.labelDisplay;
    usableWidth = usableWidth || this._getCategoryWidth();

    if (labelDisplay === _Constants["default"].MULTI_LINE) {
      return this._calcMultiLineLabelDim(tickContent, usableWidth);
    }

    if (labelDisplay === _Constants["default"].ELLIPSIS) {
      return this._calcEllipsisLabelDim(tickContent, usableWidth);
    }

    return _BaseAxis["default"].prototype._calcTickLabelDim.call(this, tickContent);
  },
  _calcEllipsisLabelDim: function (tickContent, usableWidth) {
    var options = this.options,
        useHtml = options.useHtml,
        style = options.labelStyle || {};

    if (this.isHorizontal()) {
      usableWidth -= LABEL_PADDING * 2;
    }

    tickContent = _BaseUtils["default"].getEllipsisText(tickContent, usableWidth, style, useHtml);

    var rectDim = _BaseUtils["default"].getTextDimension(tickContent, style, useHtml);

    var labelDim = {
      width: rectDim.width,
      height: rectDim.height
    };

    if (useHtml) {
      var labelWidth = parseFloat(options.labelWidth);
      var labelHeight = parseFloat(options.labelHeight);
      labelDim.width = isNaN(labelWidth) ? labelDim.width : labelWidth;
      labelDim.height = isNaN(labelHeight) ? labelDim.height : labelHeight;
    }

    return {
      rectDim: rectDim,
      labelDim: labelDim,
      tickContent: tickContent,
      labelRotation: 0
    };
  },
  _calcMultiLineLabelDim: function (tickContent, usableWidth) {
    var options = this.options,
        useHtml = options.useHtml,
        style = options.labelStyle || {};
    var padding = this.isHorizontal() ? LABEL_PADDING : 0;

    var tickGroup = _BaseUtils["default"].splitText(tickContent, style, usableWidth, padding);

    var width = 0;
    var height = 0;
    var widthGroup = [];
    var shiftGroup = [];

    for (var i = 0, len = tickGroup.length; i < len; i++) {
      var dim = _BaseUtils["default"].getTextDimension(tickGroup[i], style, useHtml);

      width = Math.max(width, dim.width);
      height += dim.height * _Constants["default"].MULTI_LINE_HEIGHT;
      widthGroup.push(dim.width);
    } // 根据最宽的标签和标签对齐方式计算偏移


    for (var _i = 0, _len = widthGroup.length; _i < _len; _i++) {
      var shift = this._calculateAlignShift(width, widthGroup[_i]);

      shiftGroup.push(shift);
    }

    var rectDim = {
      width: width,
      height: height
    };
    var labelDim = {
      width: width,
      height: height
    };

    if (useHtml) {
      var labelWidth = parseFloat(options.labelWidth);
      var labelHeight = parseFloat(options.labelHeight);
      labelDim.width = isNaN(labelWidth) ? labelDim.width : labelWidth;
      labelDim.height = isNaN(labelHeight) ? labelDim.height : labelHeight;
    }

    return {
      rectDim: rectDim,
      labelDim: labelDim,
      tickContent: tickContent,
      labelRotation: 0,
      tickGroup: tickGroup,
      shiftGroup: shiftGroup
    };
  },
  setCategories: function (categories) {
    var lastDomain = this._dataDomain;
    this._dataDomain = this.addTrendLineCategories(categories);
    var zoomTool = this.vanchart.getComponent(_component.ComponentCst.ZOOM_COMPONENT);

    if (this._isBaseAxis() && zoomTool && zoomTool.zoomToolEnabled()) {
      zoomTool.updateRangeLeftAndRight(this, lastDomain, categories);
      var zoomDomain = zoomTool && zoomTool.getZoomDomain(this);
      this._zoomDomain = zoomDomain;
      this.calculateDomainFromZoom();
    } else {
      this._domain = this._dataDomain;
      this._zoomDomain = null;
    }

    this.fixScaleAndTickData();
  },
  addTrendLineCategories: function (categories) {
    var newArray = _BaseUtils["default"].getTargetFillArray;

    if (this.forecast && (this.forecast[0] || this.forecast[1])) {
      var emptyL = 0;
      categories = newArray(-this.forecast[0], function () {
        return Array(2 + emptyL++).join(' ');
      }).concat(categories).concat(newArray(this.forecast[1], function () {
        return Array(2 + emptyL++).join(' ');
      }));
    }

    return categories;
  },
  getOriginalCategories: function () {
    if (this.forecast && (this.forecast[0] || this.forecast[1])) {
      return this._dataDomain.slice(-this.forecast[0], this._dataDomain.length - this.forecast[1]);
    }

    return this._dataDomain;
  },
  //处理自动旋转的情况
  updateAxisSizeAndBounds: function () {
    this._updateOriginTickData();

    this._calculateSize(this.tickData);

    this._setComponentBounds(this.getPosition(), this._size);
  },
  _getTickValuesWithEndValue: function () {
    return this._getTickValues();
  },
  fixScaleAndTickData: function () {
    this.scale.domain(this._dataDomain);
    this.isRangePoints ? this.scale.rangePoints(this._getRange()) : this.scale.rangeBands(this._getRange());

    this._updateOriginTickData();

    this._calculateTickPosAndStep();
  },
  _getRange: function () {
    var plotRange = this._getPlotRange(); //没有缩放的时候直接返回


    if (this._dataDomain.length == this._domain.length) {
      return plotRange;
    }

    var rangeBands,
        rangeLength = Math.abs(plotRange[1] - plotRange[0]);

    if (this.isRangePoints) {
      rangeBands = rangeLength / Math.max(this._domain.length - 1, 1);
    } else {
      rangeBands = rangeLength / this._domain.length;
    }

    var startIndex = _BaseUtils["default"].indexOf(this._dataDomain, this._domain[0]);

    var endIndex = this._dataDomain.length - _BaseUtils["default"].indexOf(this._dataDomain, this._domain[this._domain.length - 1]) - 1;

    if (!(this.isAxisReversed() ^ this.isHorizontal())) {
      var tmp = startIndex;
      startIndex = endIndex;
      endIndex = tmp;
    }

    var min = -startIndex * rangeBands,
        max = rangeLength + endIndex * rangeBands;

    if (this.isHorizontal()) {
      return this.isAxisReversed() ? [max, min] : [min, max];
    } else {
      return this.isAxisReversed() ? [min, max] : [max, min];
    }
  },
  _getRangeFromDomain: function (domain) {
    var plotRange = this._getPlotRange();

    var rangeBands,
        rangeLength = Math.abs(plotRange[1] - plotRange[0]);

    if (this.isRangePoints) {
      rangeBands = rangeLength / Math.max(domain.length - 1, 1);
    } else {
      rangeBands = rangeLength / domain.length;
    }

    var startIndex = _BaseUtils["default"].indexOf(this._dataDomain, domain[0]);

    var endIndex = this._dataDomain.length - _BaseUtils["default"].indexOf(this._dataDomain, domain[domain.length - 1]) - 1;

    if (!(this.isAxisReversed() ^ this.isHorizontal())) {
      var tmp = startIndex;
      startIndex = endIndex;
      endIndex = tmp;
    }

    var min = -startIndex * rangeBands,
        max = rangeLength + endIndex * rangeBands;

    if (this.isHorizontal()) {
      return this.isAxisReversed() ? [max, min] : [min, max];
    } else {
      return this.isAxisReversed() ? [min, max] : [max, min];
    }
  },
  _getPlotRange: function () {
    return this.vanchart.isMobileFlow() ? this.getWholeRange() : _BaseAxis["default"].prototype._getPlotRange.call(this);
  },
  getLabelAutoRotation: function (labels, axisOption, formatter) {
    if (axisOption.autoRotate && !axisOption.labelRotation) {
      var isInverted = this.vanchart.isInverted();
      var longLabel = labels.reduce(function (a, b) {
        return _BaseUtils["default"].getTextDimension(a).width > _BaseUtils["default"].getTextDimension(b).width ? a : b;
      });

      var longContent = this._getTickContent(longLabel, formatter);

      var longDim = _BaseUtils["default"].getTextDimensionWithRotation(longContent, axisOption.labelStyle, axisOption.useHtml, axisOption.labelRotation);

      var gap = Math.max.apply(null, this._getPlotRange()) / this._domain.length - LABEL_LINE_GAP_FUN();
      var w, h;

      if (isInverted) {
        w = longDim.height;
        h = longDim.width;
      } else {
        w = longDim.width;
        h = longDim.height;
      }

      var l = Math.sqrt(w * w + h * h);

      if (h > gap) {
        return -90;
      } else if (w > gap) {
        var alpha = Math.acos(gap / l);
        var beta = Math.atan(h / w);
        var theta = alpha + beta;
        return -_BaseUtils["default"].toDegree(theta);
      }
    }
  },
  getCategoryCount: function () {
    return this._dataDomain.length;
  },
  indexOfLabel: function (label) {
    return _BaseUtils["default"].indexOf(this._dataDomain, label);
  },
  getTickLength: function () {
    var domain = this.scale.domain();
    var range = this.scale.rangeExtent();
    var cateLength = Math.abs(range[1] - range[0]);

    if (this.isRangePoints && domain.length <= 1) {
      return cateLength;
    }

    return this.isRangePoints ? cateLength / (domain.length - 1) : this.scale.rangeBand();
  },
  _getTickValues: function () {
    return this._domain;
  },
  getCategories: function () {
    return this._dataDomain;
  },
  axisZoom: function (downPos, upPos) {
    var startPos, endPos;
    var plotBounds = this.vanchart.bounds; //坐标轴是横向的

    if (this.isHorizontal()) {
      startPos = Math.min(downPos.x, upPos.x) - plotBounds.x;
      endPos = Math.max(downPos.x, upPos.x) - plotBounds.x;
    } else {
      startPos = Math.min(downPos.y, upPos.y) - plotBounds.y;
      endPos = Math.max(downPos.y, upPos.y) - plotBounds.y;
    }

    var domain = this.scale.domain();

    var range = this._getRange();

    var tmpScale = _Scale["default"].quantize().domain(range).range(domain);

    var start = _BaseUtils["default"].indexOf(this._dataDomain, tmpScale(startPos));

    var end = _BaseUtils["default"].indexOf(this._dataDomain, tmpScale(endPos));

    this.zoomRefresh(this._dataDomain.slice(Math.min(start, end), Math.max(start, end) + 1));
  },
  getIndexByPosition: function (pos) {
    return this._getIndexByXYCoordinate(pos);
  },
  _getIndexByXYCoordinate: function (pos) {
    var plotBounds = this.getPlotBounds();
    var scale = this.scale;
    var isHorizontal = this.isHorizontal();
    var isReversed = this.isAxisReversed() ^ !isHorizontal;
    var startX = scale(isReversed ? scale.domain()[scale.domain().length - 1] : scale.domain()[0]);
    var x;

    if (isHorizontal) {
      x = pos[0] - plotBounds.x - startX;
    } else {
      x = pos[1] - plotBounds.y - startX;
    }

    var index;
    var categories = this.getCategories();

    if (categories.length > 1) {
      var unitLength = Math.abs(scale(scale.domain()[1]) - scale(scale.domain()[0]));
      index = isReversed ? categories.length - 1 - x / unitLength : x / unitLength;
    } else {
      index = 0;
    }

    if (this.isRangePoints) {
      index = Math.round(index);
    } else {
      index = isReversed ? Math.ceil(index) : Math.floor(index);
    }

    return index;
  },
  getPointsInCategory: function (containerPoint) {
    var plotBounds = this.vanchart.bounds;

    var domain = this.scale.domain(),
        range = this._getRange();

    var tmpScale = _Scale["default"].quantize().domain(range).range(domain);

    var category = tmpScale(this.isHorizontal() ? containerPoint.x - plotBounds.x : containerPoint.y - plotBounds.y);
    return this.vanchart.getValidPointsPara(category);
  },
  drawHighlightBackground: function (sharedPoints) {
    if (this.vanchart.onSeriesRendering()) {
      return;
    } // TODO 当所有的动画执行完成的时候，animationCount应该归为0，否则将无法触发animationEnd


    var category = sharedPoints[0].getCategory();
    var highlightType = 'line';
    sharedPoints.map(function (point) {
      var series = point.series;

      if (series.type === _Constants["default"].BAR_CHART || series.type === _Constants["default"].COLUMN_CHART) {
        highlightType = 'band';
      }
    }); // 缓存下这一次的sharedPoints，在图表resize的时候，重新绘制坐标轴会用上。

    this._lastSharedPoints = sharedPoints;
    var plotBounds = this.getPlotBounds(),
        isHorizontal = this.isHorizontal();
    var scale = this.scale,
        rangeBand = scale.rangeBand ? scale.rangeBand() : 0;
    var from = scale(category),
        to = from + rangeBand,
        renderer = this.vanchart.renderer;

    if ((0, _CoreUtils.isNull)(from)) {
      //监控刷新 改变坐标轴的scale，这边from为undefined
      return;
    }

    var x = 'x',
        y = 'y',
        width = 'width',
        height = 'height',
        size = plotBounds.height;
    var x1 = 'x1',
        x2 = 'x2',
        y1 = 'y1',
        y2 = 'y2';

    if (!isHorizontal) {
      x = 'y';
      y = 'x';
      width = 'height';
      height = 'width';
      size = plotBounds.width;
      x1 = 'y1';
      x2 = 'y2';
      y1 = 'x1';
      y2 = 'x2';
    }

    switch (highlightType) {
      case 'band':
        var bandAttr = {};
        bandAttr[x] = from;
        bandAttr[y] = 0;
        bandAttr[width] = Math.abs(from - to);
        bandAttr[height] = size;

        if (!this.highlightBand) {
          this.highlightBand = renderer.rect().attr(bandAttr).style({
            'fill': 'rgb(98,179,240)',
            'fill-opacity': 0.2,
            'pointer-events': 'none'
          }).addTo(this.vanchart.highlightGroup);
        }

        this.highlightBand.attr('transform', _BaseUtils["default"].makeTranslate(plotBounds)).animate({
          duration: 250,
          ease: _BezierEasing["default"].css['ease'],
          attr: bandAttr
        });
        this.highlightLine && this.highlightLine.remove();
        this.highlightLine = null;
        break;

      case 'line':
      default:
        if (rangeBand) {
          from = (from + to) / 2;
        }

        var attr = {};
        attr[x1] = from;
        attr[y1] = 0;
        attr[x2] = from;
        attr[y2] = size;

        if (!this.highlightLine) {
          this.highlightLine = renderer.line().attr(attr).style({
            'stroke': 'rgb(140,140,140)',
            'stroke-width': 1
          }).addTo(this.vanchart.highlightGroup);
        }

        this.highlightLine.attr('transform', _BaseUtils["default"].makeTranslate(plotBounds)).animate({
          duration: 250,
          ease: _BezierEasing["default"].css['ease'],
          attr: attr
        });
        this.highlightBand && this.highlightBand.remove();
        this.highlightBand = null;
    }
  },
  removeHighlightBackground: function () {
    this.highlightBand && this.highlightBand.remove();
    this.highlightLine && this.highlightLine.remove();
    this.highlightBand = null;
    this.highlightLine = null;
  },
  isMultiCateAxis: function () {
    return false;
  }
});

var _default = CategoryAxis;
exports["default"] = _default;

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _VanChartBackground = __webpack_require__(45);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/8/17.
 */
var LegendPath = {};
var LegendSize = {};
var ICON_TEXT_SCALE = 0.85; // 圆形方形占字体大小的比例

var rectAndCircleIcon = [_Constants["default"].NORMAL_ICON, _Constants["default"].BUBBLE_ICON, _Constants["default"].SCATTER_ICON + _Constants["default"].CIRCLE, _Constants["default"].SCATTER_ICON + _Constants["default"].CIRCLE_HOLLOW, _Constants["default"].SCATTER_ICON + _Constants["default"].SQUARE, _Constants["default"].SCATTER_ICON + _Constants["default"].SQUARE_HOLLOW];
LegendPath[_Constants["default"].PIE_ICON] = "M16.1711539,7 C22.882066,7 28.7582496,10.4779063 32.0002511,15.682597 L15.492372,25 L0.00021052449,16.2548919 C3.15945315,10.7344266 9.21715568,7 16.1711539,7 Z";
LegendSize[_Constants["default"].PIE_ICON] = {
  width: 32,
  height: 32
};
LegendPath[_Constants["default"].TREEMAP_ICON] = 'M9,12H3c-1.6,0-3-1.4-3-3l0-6c0-1.6,1.3-3,3-3l6,0c1.7,0,3,1.4,3,3v6C12,10.6,10.6,12,9,12z';
LegendSize[_Constants["default"].TREEMAP_ICON] = {
  width: 12,
  height: 12
};
LegendPath[_Constants["default"].ANCHOR_ICON] = 'M14,0 C18.9705627,0 23,3.99365356 23,8.92007488 C23,10.1383014 22.7536019,11.2994896 22.3075049,12.357355 C21.4180692,14.2023669 20.6028055,15.8625212 19.8617139,17.3477584 L19.4973491,18.0758467 C16.0946028,24.8550831 14.3653636,27.7251338 14.3096313,27.7513441 C14.1520691,28.0828853 13.7206116,28.0828853 13.5482295,27.7513441 L5.69249505,12.357355 C5.24639813,11.2994896 5,10.1383014 5,8.92007488 C5,3.99365356 9.02943725,0 14,0 Z M14,6 C12.3431458,6 11,7.34314575 11,9 C11,10.6568542 12.3431458,12 14,12 C15.6568542,12 17,10.6568542 17,9 C17,7.34314575 15.6568542,6 14,6 Z';
LegendSize[_Constants["default"].ANCHOR_ICON] = {
  width: 28,
  height: 28
};
LegendPath[_Constants["default"].DONUT_ICON] = "M16.1709434,8 C22.8819622,8 28.7582258,11.4603001 32.0001952,16.6386156 L21.5039708,22.5334633 C20.579905,20.4209885 18.4632188,18.9439669 15.9997895,18.9439669 C13.3586911,18.9439669 11.1161556,20.6417249 10.3145981,23.0001357 L-0.000152222903,17.2080129 C3.15904804,11.7155231 9.21683346,8 16.1709434,8 Z";
LegendSize[_Constants["default"].DONUT_ICON] = {
  width: 32,
  height: 32
};
LegendPath[_Constants["default"].NORMAL_ICON] = 'M0,0L12,0L12,12L0,12Z';
LegendSize[_Constants["default"].NORMAL_ICON] = {
  width: 12,
  height: 12
};
LegendPath[_Constants["default"].BUBBLE_ICON] = "M6,11.5c-1.47,0-2.851-0.572-3.889-1.611C1.072,8.851,0.5,7.47,0.5,6s0.572-2.851,1.611-3.889C3.149,1.072,4.53,0.5,6,0.5s2.851,0.572,3.889,1.611C10.928,3.149,11.5,4.53,11.5,6s-0.572,2.851-1.611,3.889C8.851,10.928,7.47,11.5,6,11.5z";
LegendSize[_Constants["default"].BUBBLE_ICON] = {
  width: 11,
  height: 11
};
LegendPath[_Constants["default"].NULL_MARKER] = "M29.5,13.5 C30.8807119,13.5 32,14.6192881 32,16 C32,17.3254834 30.9684641,18.4100387 29.6643757,18.4946823 L29.5,18.5 L2.5,18.5 C1.11928813,18.5 0,17.3807119 0,16 C0,14.6745166 1.03153594,13.5899613 2.33562431,13.5053177 L2.5,13.5 L29.5,13.5 Z";
LegendSize[_Constants["default"].NULL_MARKER] = {
  width: 32,
  height: 32
};
LegendPath[_Constants["default"].CIRCLE] = "M16,8 C19.5449966,8 22.5514499,10.3057777 23.6014229,13.499396 L23.6015963,13.4999235 L23.6167542,13.5465233 C23.6794628,13.741351 23.7349038,13.9394393 23.7827579,14.1404689 C23.7899489,14.1706765 23.7969842,14.2010193 23.8038463,14.2314277 C23.8497915,14.435015 23.8879903,14.641655 23.9180904,14.8509119 C23.9229126,14.8844344 23.9275355,14.9180889 23.9319484,14.9518094 C23.9586369,15.1557661 23.9776373,15.3620364 23.9886632,15.5704214 C23.9903758,15.6027909 23.9918939,15.6351629 23.993219,15.6675847 C23.997724,15.7777783 24,15.8886233 24,16 C24,16.1090141 23.9978195,16.217519 23.9934998,16.3254733 L24,16 C24,16.1417048 23.9963157,16.2825491 23.9890377,16.4224424 C23.9781504,16.6316396 23.9592447,16.8385728 23.9326156,17.0430797 C23.927786,17.0801933 23.922611,17.1178568 23.9171747,17.1554359 C23.8871888,17.3626011 23.8494053,17.5665752 23.8040476,17.7676797 C23.797382,17.7972309 23.7905887,17.8265688 23.7836345,17.8558445 C23.7356361,18.0579429 23.6798772,18.2573617 23.6167542,18.4534767 C23.6115923,18.4695107 23.6065308,18.4850679 23.6014229,18.500604 C22.5514499,21.6942223 19.5449966,24 16,24 C12.4550034,24 9.44855013,21.6942223 8.39857709,18.500604 L8.39857709,18.500604 L8.38324583,18.4534767 C8.32012283,18.2573617 8.26436385,18.0579429 8.21629457,17.855546 C8.2094113,17.8265688 8.20261802,17.7972309 8.19598662,17.7678316 C8.15059467,17.5665752 8.11281122,17.3626011 8.08291749,17.1560731 C8.07738904,17.1178568 8.072214,17.0801933 8.06730206,17.042447 C8.04075528,16.8385728 8.02184959,16.6316396 8.01096962,16.4225824 C8.00928221,16.3901483 8.00779361,16.3578034 8.00649762,16.3254091 C8.00218048,16.217519 8,16.1090141 8,16 C8,15.8872733 8.00233152,15.7750912 8.00694897,15.6634992 L8,16 C8,15.8559017 8.00380981,15.7126932 8.01133421,15.5704698 C8.02236272,15.3620364 8.04136312,15.1557661 8.06803842,14.9519101 C8.07246447,14.9180889 8.07708736,14.8844344 8.08191889,14.8508474 C8.11200967,14.641655 8.15020846,14.435015 8.19617811,14.2313197 C8.20301581,14.2010193 8.21005106,14.1706765 8.21725841,14.1404005 C8.26509616,13.9394393 8.32053716,13.741351 8.38324583,13.5465233 C8.38826834,13.5309195 8.393313,13.5154111 8.39840368,13.4999235 C9.44855013,10.3057777 12.4550034,8 16,8 Z M6.3149723,13.5002775 C6.10935719,14.2992437 6,15.136851 6,16 C6,16.8634306 6.10942855,17.7013028 6.31517356,18.5005044 L2.5,18.5 C1.11928813,18.5 1.69088438e-16,17.3807119 0,16 C-1.69088438e-16,14.6192881 1.11928813,13.5 2.5,13.5 L6.3149723,13.5002775 Z M29.5,13.5 C30.8807119,13.5 32,14.6192881 32,16 C32,17.3807119 30.8807119,18.5 29.5,18.5 L25.6848264,18.5005044 C25.8905715,17.7013028 26,16.8634306 26,16 C26,15.136851 25.8906428,14.2992437 25.6850277,13.5002775 L29.5,13.5 Z";
LegendSize[_Constants["default"].CIRCLE] = {
  width: 32,
  height: 32
};
LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].NULL_MARKER] = 'M0,0L12,0L12,12L0,12Z';
LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].NULL_MARKER] = {
  width: 12,
  height: 12
};
LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].NORMAL_ICON] = 'M0,0L12,0L12,12L0,12Z';
LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].NORMAL_ICON] = {
  width: 12,
  height: 12
};
LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].CIRCLE] = "M4,8C2.897,8,1.897,7.551,1.173,6.827S0,5.103,0,4s0.449-2.103,1.173-2.827S2.897,0,4,0s2.103,0.449,2.827,1.173S8,2.897,8,4S7.551,6.103,6.827,6.827S5.103,8,4,8";
LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].CIRCLE] = {
  width: 8,
  height: 8
};
LegendPath[_Constants["default"].SQUARE] = 'M24,24 L8,24 L8,8 L24,8 L24,24 Z M6,13.5 L6,18.5 L2.5,18.5 C1.11928813,18.5 1.69088438e-16,17.3807119 0,16 C-1.69088438e-16,14.6192881 1.11928813,13.5 2.5,13.5 L6,13.5 Z M29.5,13.5 C30.8807119,13.5 32,14.6192881 32,16 C32,17.3807119 30.8807119,18.5 29.5,18.5 L26,18.5 L26,13.5 L29.5,13.5 Z';
LegendSize[_Constants["default"].SQUARE] = {
  width: 32,
  height: 32
};
LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].SQUARE] = "M0,0h8c0,0,0,3.889,0,8C4,8,0,8,0,8V0z";
LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].SQUARE] = {
  width: 8,
  height: 8
};
LegendPath[_Constants["default"].DIAMOND] = "M15.9903066,23.9806133 L8,15.9903066 L9.208,14.782 L10.49,13.5 L10.491,13.499 L15.9903066,8 L21.489,13.499 L21.49,13.5 L23.9806133,15.9903066 L15.9903066,23.9806133 Z M7.661,13.5 L5.17157288,15.9903066 L7.681,18.5 L2.5,18.5 C1.11928813,18.5 1.69088438e-16,17.3807119 0,16 C-1.69088438e-16,14.6192881 1.11928813,13.5 2.5,13.5 L7.661,13.5 Z M29.5,13.5 C30.8807119,13.5 32,14.6192881 32,16 C32,17.3807119 30.8807119,18.5 29.5,18.5 L24.299,18.5 L26.8090404,15.9903066 L24.319,13.5 L29.5,13.5 Z";
LegendSize[_Constants["default"].DIAMOND] = {
  width: 32,
  height: 32
};
LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].DIAMOND] = "M0,4.5L4.502,0l4.5,4.5c0,0,0,0-4.5,4.5C0,4.5,0,4.5,0,4.5z";
LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].DIAMOND] = {
  width: 9,
  height: 9
};
LegendPath[_Constants["default"].TRIANGLE] = "M16.0378418,0 L19.117,5.499 L19.118,5.5 L21.919,10.5 L25,16 L7,16 L10.106,10.5 L12.93,5.5 L12.931,5.499 L16.0378418,0 Z M10.634,5.5 L7.809,10.5 L2.5,10.5 C1.11928813,10.5 1.69088438e-16,9.38071187 0,8 C-1.69088438e-16,6.61928813 1.11928813,5.5 2.5,5.5 L10.634,5.5 Z M29.5,5.5 C30.8807119,5.5 32,6.61928813 32,8 C32,9.38071187 30.8807119,10.5 29.5,10.5 L24.211,10.5 L21.411,5.5 L29.5,5.5 Z";
LegendSize[_Constants["default"].TRIANGLE] = {
  width: 32,
  height: 16
};
LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].TRIANGLE] = "M4.5,0L9,8c0,0-4.617,0-9,0L4.5,0z";
LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].TRIANGLE] = {
  width: 9,
  height: 8
};
LegendPath[_Constants["default"].CIRCLE_HOLLOW] = "M16,8 C19.5449966,8 22.5514499,10.3057777 23.6014229,13.499396 L23.6015963,13.4999235 L23.6167542,13.5465233 C23.6777019,13.7358801 23.7317845,13.928317 23.7787086,14.1235407 C23.7872882,14.1592297 23.7956896,14.1952824 23.8038463,14.2314277 C23.8497915,14.435015 23.8879903,14.641655 23.9180904,14.8509119 C23.9229126,14.8844344 23.9275355,14.9180889 23.9319484,14.9518094 C23.9586369,15.1557661 23.9776373,15.3620364 23.9886632,15.5704214 C23.9903776,15.6028264 23.9918972,15.635234 23.9932234,15.6676915 C23.997724,15.7777783 24,15.8886233 24,16 C24,16.1090141 23.9978195,16.217519 23.9934998,16.3254733 L24,16 C24,16.1376367 23.9965242,16.2744617 23.9896556,16.4103918 C23.9794061,16.6131334 23.9616331,16.8136946 23.9366014,17.0119943 C23.9305879,17.059654 23.9240928,17.1076134 23.9171747,17.1554359 C23.8871888,17.3626011 23.8494053,17.5665752 23.8040476,17.7676797 C23.797382,17.7972309 23.7905887,17.8265688 23.7836345,17.8558445 C23.7356361,18.0579429 23.6798772,18.2573617 23.6167542,18.4534767 C23.6115923,18.4695107 23.6065308,18.4850679 23.6014229,18.500604 C22.5514499,21.6942223 19.5449966,24 16,24 C12.4550034,24 9.44855013,21.6942223 8.39857709,18.500604 L8.39857709,18.500604 L8.38324583,18.4534767 C8.32012283,18.2573617 8.26436385,18.0579429 8.21629457,17.855546 C8.2094113,17.8265688 8.20261802,17.7972309 8.19598662,17.7678316 C8.15059467,17.5665752 8.11281122,17.3626011 8.08291749,17.1560731 C8.0759072,17.1076134 8.06941213,17.059654 8.063344,17.0115615 C8.03836689,16.8136946 8.02059389,16.6131334 8.01035419,16.4105853 C8.00891706,16.3821445 8.00763622,16.3538585 8.00650265,16.3255346 C8.00218048,16.217519 8,16.1090141 8,16 C8,15.8828858 8.00251655,15.7663593 8.00749852,15.6504717 L8,16 C8,15.8559017 8.00380981,15.7126932 8.01133421,15.5704698 C8.02236272,15.3620364 8.04136312,15.1557661 8.06803842,14.9519101 C8.07246447,14.9180889 8.07708736,14.8844344 8.08191889,14.8508474 C8.11200967,14.641655 8.15020846,14.435015 8.19617811,14.2313197 C8.20431043,14.1952824 8.21271182,14.1592297 8.22135606,14.1232717 C8.26821552,13.928317 8.32229806,13.7358801 8.38324583,13.5465233 C8.38826834,13.5309195 8.393313,13.5154111 8.39840368,13.4999235 C9.44855013,10.3057777 12.4550034,8 16,8 Z M16,13 C15.3111497,13 14.6765255,13.232169 14.1701084,13.6225257 C14.1362044,13.6486674 14.1032121,13.675235 14.0708045,13.7024756 L14.1701084,13.6225257 C14.1165669,13.6637965 14.0644586,13.7068356 14.0138709,13.7515554 L14.0708045,13.7024756 C14.0277118,13.7386977 13.9856529,13.7761098 13.9446782,13.8146614 L14.0138709,13.7515554 C13.9699051,13.7904213 13.9270879,13.8305567 13.8854766,13.8719043 L13.9446782,13.8146614 C13.8378985,13.9151265 13.7384824,14.0233298 13.6473258,14.1383756 C13.6368951,14.1515401 13.6265907,14.1647705 13.6163955,14.1780888 L13.6473258,14.1383756 C13.6090135,14.1867283 13.5721602,14.2362897 13.5368324,14.2869932 L13.6163955,14.1780888 C13.5743585,14.2330025 13.5341763,14.2894111 13.4959425,14.3472212 L13.5368324,14.2869932 C13.5027613,14.3358931 13.4701091,14.3858553 13.4389354,14.4368202 L13.4959425,14.3472212 C13.4626638,14.3975389 13.4308612,14.4489183 13.4005963,14.5012977 L13.4389354,14.4368202 C13.4033853,14.4949401 13.369758,14.554364 13.3381421,14.6150034 L13.4005963,14.5012977 C13.3723903,14.5501138 13.3455199,14.5997986 13.3200351,14.6503019 L13.3381421,14.6150034 C13.2473225,14.7891954 13.1730999,14.9734175 13.1175715,15.1655725 C13.1073093,15.2010618 13.0975615,15.2373171 13.0884828,15.2738368 L13.1175715,15.1655725 C13.1012458,15.2220675 13.086536,15.2792482 13.0734954,15.3370614 L13.0884828,15.2738368 C13.0754205,15.3263804 13.0637434,15.3794713 13.0534925,15.4330686 L13.0734954,15.3370614 C13.0585643,15.4032557 13.0458216,15.470279 13.0353471,15.5380514 L13.0534925,15.4330686 C13.0413244,15.4966897 13.0311658,15.5610243 13.0230852,15.6260037 L13.0353471,15.5380514 C13.0253363,15.6028242 13.0173974,15.6682813 13.0116003,15.7343527 L13.0230852,15.6260037 C13.0157079,15.6853277 13.0100626,15.7451891 13.0062016,15.8055359 L13.0116003,15.7343527 C13.0039209,15.8218778 13,15.910481 13,16 L13.0062016,16.1944641 C13.0073861,16.2129774 13.0087385,16.231445 13.0102573,16.2498654 C13.013632,16.2908481 13.0178705,16.3319203 13.022929,16.3727383 L13.0102573,16.2498654 C13.0161479,16.3213064 13.0245416,16.3920378 13.0353507,16.4619715 L13.022929,16.3727383 C13.0310364,16.4381585 13.04125,16.5029257 13.0534998,16.5669698 L13.0353507,16.4619715 C13.0458294,16.5297683 13.0585781,16.5968154 13.0735166,16.6630328 L13.0534998,16.5669698 C13.0637294,16.6204516 13.075379,16.6734291 13.0884078,16.7258617 L13.0735166,16.6630328 C13.0865895,16.7209803 13.1013393,16.7782923 13.1177125,16.8349153 L13.0884078,16.7258617 C13.1423026,16.9427533 13.2197982,17.1503204 13.3180108,17.3456792 C13.3246022,17.3587906 13.3312971,17.3718666 13.3380847,17.3848865 L13.3180108,17.3456792 C13.3441457,17.3976651 13.3717476,17.4487866 13.4007621,17.4989892 L13.3380847,17.3848865 C13.3696522,17.4454392 13.4032253,17.50478 13.4387159,17.5628208 L13.4007621,17.4989892 C13.4310644,17.5514199 13.4629075,17.6028484 13.4962296,17.6532128 L13.4387159,17.5628208 C13.4698686,17.6137675 13.5024986,17.6637125 13.5365465,17.7125963 L13.4962296,17.6532128 C13.5318401,17.707036 13.5691396,17.759644 13.6080526,17.8109611 L13.5365465,17.7125963 C13.5719556,17.7634347 13.6088982,17.8131252 13.6473073,17.861601 L13.6080526,17.8109611 C13.6931837,17.9232288 13.7860372,18.0293185 13.885822,18.1284389 C13.8964986,18.1390479 13.9076052,18.149915 13.9187954,18.160696 L13.885822,18.1284389 C13.9274271,18.1697669 13.9702371,18.2098833 14.0141947,18.2487309 L13.9187954,18.160696 C13.9678609,18.2079674 14.0185326,18.2535833 14.0707205,18.2974537 L14.0141947,18.2487309 C14.0629696,18.2918356 14.1131575,18.3333782 14.16468,18.3732801 L14.0707205,18.2974537 C14.1103221,18.3307438 14.1507968,18.3630288 14.1921052,18.3942694 L14.16468,18.3732801 C14.2121928,18.4100768 14.2608407,18.4454783 14.3105621,18.4794232 L14.1921052,18.3942694 C14.6948472,18.7744814 15.3210873,19 16,19 C16.6911088,19 17.3276354,18.7663061 17.8348687,18.3736296 C17.8671266,18.3486473 17.8984246,18.3233892 17.9291955,18.2975244 L17.8348687,18.3736296 C17.8866635,18.3335325 17.9371101,18.2917776 17.9861291,18.2484446 L17.9291955,18.2975244 C17.9813387,18.2536948 18.0319684,18.2081227 18.080995,18.1608979 L17.9861291,18.2484446 C18.0300949,18.2095787 18.0729121,18.1694433 18.1145234,18.1280957 L18.080995,18.1608979 C18.1780724,18.0673882 18.2688642,17.9673983 18.3526742,17.8616244 C18.3659682,17.8448461 18.3790685,17.8279461 18.3919909,17.8109037 L18.3526742,17.8616244 C18.3909865,17.8132717 18.4278398,17.7637103 18.4631676,17.7130068 L18.3919909,17.8109037 C18.4309928,17.7594668 18.4683737,17.7067332 18.5040575,17.6527788 L18.4631676,17.7130068 C18.4972387,17.6641069 18.5298909,17.6141447 18.5610646,17.5631798 L18.5040575,17.6527788 C18.5373362,17.6024611 18.5691388,17.5510817 18.5994037,17.4987023 L18.5610646,17.5631798 C18.5966147,17.5050599 18.630242,17.445636 18.6618579,17.3849966 L18.5994037,17.4987023 C18.6283612,17.4485855 18.655911,17.3975532 18.6819991,17.3456595 L18.6618579,17.3849966 C18.7526775,17.2108046 18.8269001,17.0265825 18.8824285,16.8344275 C18.8926907,16.7989382 18.9024385,16.7626829 18.9115172,16.7261632 L18.8824285,16.8344275 C18.8987542,16.7779325 18.913464,16.7207518 18.9265046,16.6629386 L18.9115172,16.7261632 C18.9245795,16.6736196 18.9362566,16.6205287 18.9465075,16.5669314 L18.9265046,16.6629386 C18.9414357,16.5967443 18.9541784,16.529721 18.9646529,16.4619486 L18.9465075,16.5669314 C18.9587383,16.5029825 18.9689389,16.4383128 18.9770396,16.3729919 L18.9646529,16.4619486 C18.9754767,16.3919157 18.9838783,16.321083 18.9897696,16.2495386 L18.9770396,16.3729919 C18.9843968,16.3136658 18.990022,16.2538025 18.9938628,16.1934542 L18.9897696,16.2495386 C18.9965451,16.1672556 19,16.0840312 19,16 L18.9938628,15.8065458 C18.9923202,15.782308 18.9904898,15.7581485 18.9883749,15.7340706 C18.985222,15.6981354 18.9814008,15.6621027 18.9769475,15.6262662 L18.9883749,15.7340706 C18.9825793,15.6680872 18.9746476,15.6027166 18.9646493,15.5380285 L18.9769475,15.6262662 C18.96886,15.5611844 18.9586879,15.4967495 18.9465002,15.4330302 L18.9646493,15.5380285 C18.9541706,15.4702317 18.9414219,15.4031846 18.9264834,15.3369672 L18.9465002,15.4330302 C18.9362706,15.3795484 18.924621,15.3265709 18.9115922,15.2741383 L18.9264834,15.3369672 C18.9134105,15.2790197 18.8986607,15.2217077 18.8822875,15.1650847 L18.9115922,15.2741383 C18.8573364,15.0557938 18.7791625,14.8468991 18.6800126,14.6503964 C18.6740235,14.6385277 18.6680068,14.6267981 18.6619153,14.6151135 L18.6800126,14.6503964 C18.6544637,14.5997616 18.627522,14.5499496 18.5992379,14.5010108 L18.6619153,14.6151135 C18.6303478,14.5545608 18.5967747,14.49522 18.5612841,14.4371792 L18.5992379,14.5010108 C18.5689356,14.4485801 18.5370925,14.3971516 18.5037704,14.3467872 L18.5612841,14.4371792 C18.5301314,14.3862325 18.4975014,14.3362875 18.4634535,14.2874037 L18.5037704,14.3467872 C18.4656557,14.2891789 18.425606,14.2329629 18.383714,14.1782318 L18.4634535,14.2874037 C18.4280444,14.2365653 18.3911018,14.1868748 18.3526927,14.138399 L18.383714,14.1782318 C18.3008397,14.069958 18.2107553,13.9674954 18.114178,13.8715611 C18.0950728,13.852577 18.0753587,13.8335145 18.055387,13.8147227 L18.114178,13.8715611 C18.0725729,13.8302331 18.0297629,13.7901167 17.9858053,13.7512691 L18.055387,13.8147227 C18.0144184,13.7761746 17.9723657,13.7387655 17.9292795,13.7025463 L17.9858053,13.7512691 C17.9354288,13.7067489 17.883545,13.6638953 17.8302402,13.6227944 L17.9292795,13.7025463 C17.8874332,13.6673692 17.844612,13.6333145 17.8008624,13.6004283 L17.8302402,13.6227944 C17.7830456,13.5864048 17.7347371,13.5513893 17.6853746,13.5178077 L17.8008624,13.6004283 C17.2993184,13.2234229 16.6757508,13 16,13 Z M2.5,13.5 L6.3149723,13.5002775 C6.10935719,14.2992437 6,15.136851 6,16 C6,16.8634306 6.10942855,17.7013028 6.31517356,18.5005044 L2.5,18.5 C1.11928813,18.5 1.69088438e-16,17.3807119 0,16 C-1.69088438e-16,14.6192881 1.11928813,13.5 2.5,13.5 Z M29.5,13.5 C30.8807119,13.5 32,14.6192881 32,16 C32,17.3807119 30.8807119,18.5 29.5,18.5 L25.6848264,18.5005044 C25.8905715,17.7013028 26,16.8634306 26,16 C26,15.136851 25.8906428,14.2992437 25.6850277,13.5002775 L29.5,13.5 Z";
LegendSize[_Constants["default"].CIRCLE_HOLLOW] = {
  width: 32,
  height: 32
};
LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].CIRCLE_HOLLOW] = "M4,2c1.102,0,2,0.898,2,2S5.102,6,4,6S2,5.102,2,4S2.898,2,4,2 M4,0C1.791,0,0,1.791,0,4s1.791,4,4,4s4-1.791,4-4S6.209,0,4,0";
LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].CIRCLE_HOLLOW] = {
  width: 8,
  height: 8
};
LegendPath[_Constants["default"].SQUARE_HOLLOW] = "M24,16 L8,16 L8,0 L24,0 L24,16 Z M13,11 L19,11 L19,5 L13,5 L13,11 Z M6,5.5 L6,10.5 L2.5,10.5 C1.11928813,10.5 1.69088438e-16,9.38071187 0,8 C-1.69088438e-16,6.61928813 1.11928813,5.5 2.5,5.5 L6,5.5 Z M29.5,5.5 C30.8807119,5.5 32,6.61928813 32,8 C32,9.38071187 30.8807119,10.5 29.5,10.5 L26,10.5 L26,5.5 L29.5,5.5 Z";
LegendSize[_Constants["default"].SQUARE_HOLLOW] = {
  width: 32,
  height: 16
};
LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].SQUARE_HOLLOW] = "M6,6H2V2h4V6z M8,0H0v8h8V0z";
LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].SQUARE_HOLLOW] = {
  width: 8,
  height: 8
};
LegendPath[_Constants["default"].DIAMOND_HOLLOW] = "M24.1403066,15.9903066 L16.15,23.9806133 L8.15969337,15.9903066 L16.15,8 L24.1403066,15.9903066 Z M16.1952273,12.5 L15.254,13.44 L15.255,13.4403066 L12.6596934,16.0355339 L15.065,18.4403066 L15.064,18.44 L16.1952273,19.5710678 L17.326,18.44 L17.325,18.4403066 L19.7307612,16.0355339 L17.135,13.4403066 L17.136,13.44 L16.1952273,12.5 Z M7.881,13.4403066 L5.33126625,15.9903066 L7.781,18.4403066 L2.5,18.4403066 C1.11928813,18.4403066 1.69088438e-16,17.3210185 0,15.9403066 C-1.69088438e-16,14.5595948 1.11928813,13.4403066 2.5,13.4403066 L7.881,13.4403066 Z M29.5,13.4403066 C30.8807119,13.4403066 32,14.5595948 32,15.9403066 C32,17.3210185 30.8807119,18.4403066 29.5,18.4403066 L24.518,18.4403066 L26.9687338,15.9903066 L24.418,13.4403066 L29.5,13.4403066 Z";
LegendSize[_Constants["default"].DIAMOND_HOLLOW] = {
  width: 32,
  height: 32
};
LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].DIAMOND_HOLLOW] = "M2.121,4.999L5,2.121l2.878,2.878L5,7.879L2.121,4.999z M5,0L0,4.999L5,10l4.999-5.001L5,0z";
LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].DIAMOND_HOLLOW] = {
  width: 10,
  height: 10
};
LegendPath[_Constants["default"].TRIANGLE_HOLLOW] = "M16.0378418,8 L19.117,13.499 L19.118,13.5 L21.919,18.5 L21.918,18.499 L25,24 L7,24 L10.49,17.821 L12.931,13.5 L16.0378418,8 Z M16.0126139,14.5555556 L13,20.5555556 L19,20.5555556 L16.0126139,14.5555556 Z M10.634,13.5 L7.81,18.5 L2.5,18.5 C1.11928813,18.5 1.69088438e-16,17.3807119 0,16 C-1.69088438e-16,14.6192881 1.11928813,13.5 2.5,13.5 L10.634,13.5 Z M29.5,13.5 C30.8807119,13.5 32,14.6192881 32,16 C32,17.3807119 30.8807119,18.5 29.5,18.5 L24.211,18.5 L21.41,13.5 L29.5,13.5 Z";
LegendSize[_Constants["default"].TRIANGLE_HOLLOW] = {
  width: 32,
  height: 32
};
LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].TRIANGLE_HOLLOW] = "M5.001,3.34L7.402,7.5H2.598L5.001,3.34z M5.001,0.34L0,9h10L5.001,0.34z";
LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].TRIANGLE_HOLLOW] = {
  width: 10,
  height: 9
};
var ie8LegendPath = {};
var ie8LegendSize = {};
ie8LegendPath[_Constants["default"].PIE_ICON] = 'M15.795,7.943L7.909,12.5L0.205,8.052C1.756,5.333,4.68,3.5,8.032,3.5C11.338,3.5,14.23,5.287,15.795,7.943z';
ie8LegendSize[_Constants["default"].PIE_ICON] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].TREEMAP_ICON] = 'M9,12H3c-1.6,0-3-1.4-3-3l0-6c0-1.6,1.3-3,3-3l6,0c1.7,0,3,1.4,3,3v6C12,10.6,10.6,12,9,12z';
ie8LegendSize[_Constants["default"].TREEMAP_ICON] = {
  width: 12,
  height: 12
};
ie8LegendPath[_Constants["default"].ANCHOR_ICON] = 'M8.14285714,0 C10.9831787,0 13.2857143,2.28208775 13.2857143,5.09718564 C13.2857143,5.79331509 13.1449154,6.45685123 12.8900028,7.0613457 C12.4273659,8.02102223 11.999847,8.89317483 11.6074461,9.68208765 L11.31973,10.2582317 C9.77350714,13.3419196 8.82483893,15.0274547 8.4737254,15.6155379 L8.4164712,15.710436 C8.3573567,15.8071979 8.32512941,15.8553995 8.31978934,15.8579109 C8.22975377,16.047363 7.98320661,16.047363 7.88470258,15.8579109 L3.39571146,7.0613457 C3.14079893,6.45685123 3,5.79331509 3,5.09718564 C3,2.28208775 5.30253557,0 8.14285714,0 Z M8.14285714,3.42857143 C7.19608329,3.42857143 6.42857143,4.19608329 6.42857143,5.14285714 C6.42857143,6.089631 7.19608329,6.85714286 8.14285714,6.85714286 C9.089631,6.85714286 9.85714286,6.089631 9.85714286,5.14285714 C9.85714286,4.19608329 9.089631,3.42857143 8.14285714,3.42857143 Z';
ie8LegendSize[_Constants["default"].ANCHOR_ICON] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].DONUT_ICON] = 'M8.945,11.107c1.671,0,3.181,0.684,4.269,1.786l4.271-4.271c-4.686-4.686-12.284-4.686-16.971,0l4.216,4.216C5.815,11.768,7.302,11.107,8.945,11.107z';
ie8LegendSize[_Constants["default"].DONUT_ICON] = {
  width: 18,
  height: 18
};
ie8LegendPath[_Constants["default"].NORMAL_ICON] = 'M0,0L12,0L12,12L0,12Z';
ie8LegendSize[_Constants["default"].NORMAL_ICON] = {
  width: 12,
  height: 12
};
ie8LegendPath[_Constants["default"].BUBBLE_ICON] = "M6,11.5c-1.47,0-2.851-0.572-3.889-1.611C1.072,8.851,0.5,7.47,0.5,6s0.572-2.851,1.611-3.889C3.149,1.072,4.53,0.5,6,0.5s2.851,0.572,3.889,1.611C10.928,3.149,11.5,4.53,11.5,6s-0.572,2.851-1.611,3.889C8.851,10.928,7.47,11.5,6,11.5z";
ie8LegendSize[_Constants["default"].BUBBLE_ICON] = {
  width: 11,
  height: 11
};
ie8LegendPath[_Constants["default"].NULL_MARKER] = 'M1,8L1,8c0-0.552,0.448-1,1-1h12c0.552,0,1,0.448,1,1v0c0,0.552-0.448,1-1,1H2C1.448,9,1,8.552,1,8z';
ie8LegendSize[_Constants["default"].NULL_MARKER] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].CIRCLE] = 'M11,8c0,1.657-1.343,3-3,3S5,9.657,5,8s1.343-3,3-3S11,6.343,11,8z M14,7h-2.142C11.942,7.322,12,7.653,12,8s-0.058,0.678-0.142,1H14c0.552,0,1-0.448,1-1C15,7.448,14.552,7,14,7z M4,8c0-0.347,0.058-0.678,0.142-1H2C1.448,7,1,7.448,1,8c0,0.552,0.448,1,1,1h2.142C4.058,8.678,4,8.347,4,8z';
ie8LegendSize[_Constants["default"].CIRCLE] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].NULL_MARKER] = 'M0,0L12,0L12,12L0,12Z';
ie8LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].NULL_MARKER] = {
  width: 12,
  height: 12
};
ie8LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].NORMAL_ICON] = 'M0,0L12,0L12,12L0,12Z';
ie8LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].NORMAL_ICON] = {
  width: 12,
  height: 12
};
ie8LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].CIRCLE] = "M4,8C2.897,8,1.897,7.551,1.173,6.827S0,5.103,0,4s0.449-2.103,1.173-2.827S2.897,0,4,0s2.103,0.449,2.827,1.173S8,2.897,8,4S7.551,6.103,6.827,6.827S5.103,8,4,8";
ie8LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].CIRCLE] = {
  width: 8,
  height: 8
};
ie8LegendPath[_Constants["default"].SQUARE] = 'M11,11H5V5h6V11z M14,7h-2v2h2c0.552,0,1-0.448,1-1C15,7.448,14.552,7,14,7z M4,7H2C1.448,7,1,7.448,1,8c0,0.552,0.448,1,1,1h2V7z';
ie8LegendSize[_Constants["default"].SQUARE] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].SQUARE] = "M0,0h8c0,0,0,3.889,0,8C4,8,0,8,0,8V0z";
ie8LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].SQUARE] = {
  width: 8,
  height: 8
};
ie8LegendPath[_Constants["default"].DIAMOND] = 'M8,11L5,8l3-3l3,3L8,11z M14,7h-2.586l1,1l-1,1H14c0.552,0,1-0.448,1-1C15,7.448,14.552,7,14,7z M3.586,8l1-1H2C1.448,7,1,7.448,1,8c0,0.552,0.448,1,1,1h2.586L3.586,8z';
ie8LegendSize[_Constants["default"].DIAMOND] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].DIAMOND] = "M0,4.5L4.502,0l4.5,4.5c0,0,0,0-4.5,4.5C0,4.5,0,4.5,0,4.5z";
ie8LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].DIAMOND] = {
  width: 9,
  height: 9
};
ie8LegendPath[_Constants["default"].TRIANGLE] = 'M5,10l3-5.196L11,10H5z M14,7h-3.577l1.155,2H14c0.552,0,1-0.448,1-1C15,7.448,14.552,7,14,7z M5.577,7H2C1.448,7,1,7.448,1,8c0,0.552,0.448,1,1,1h2.423L5.577,7z';
ie8LegendSize[_Constants["default"].TRIANGLE] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].TRIANGLE] = "M4.5,0L9,8c0,0-4.617,0-9,0L4.5,0z";
ie8LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].TRIANGLE] = {
  width: 9,
  height: 8
};
ie8LegendPath[_Constants["default"].CIRCLE_HOLLOW] = 'M4.142,9H2C1.448,9,1,8.552,1,8c0-0.552,0.448-1,1-1h2.142C4.058,7.322,4,7.653,4,8S4.058,8.678,4.142,9zM14,7h-2.142C11.942,7.322,12,7.653,12,8s-0.058,0.678-0.142,1H14c0.552,0,1-0.448,1-1C15,7.448,14.552,7,14,7z M8,7C7.449,7,7,7.449,7,8s0.449,1,1,1s1-0.449,1-1S8.551,7,8,7 M8,5c1.657,0,3,1.343,3,3s-1.343,3-3,3S5,9.657,5,8S6.343,5,8,5L8,5z';
ie8LegendSize[_Constants["default"].CIRCLE_HOLLOW] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].CIRCLE_HOLLOW] = "M4,2c1.102,0,2,0.898,2,2S5.102,6,4,6S2,5.102,2,4S2.898,2,4,2 M4,0C1.791,0,0,1.791,0,4s1.791,4,4,4s4-1.791,4-4S6.209,0,4,0";
ie8LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].CIRCLE_HOLLOW] = {
  width: 8,
  height: 8
};
ie8LegendPath[_Constants["default"].SQUARE_HOLLOW] = 'M4,9H2C1.448,9,1,8.552,1,8c0-0.552,0.448-1,1-1h2V9z M14,7h-2v2h2c0.552,0,1-0.448,1-1C15,7.448,14.552,7,14,7z M9,7H7v2h2V7 M11,5v6H5V5H11L11,5z';
ie8LegendSize[_Constants["default"].SQUARE_HOLLOW] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].SQUARE_HOLLOW] = "M6,6H2V2h4V6z M8,0H0v8h8V0z";
ie8LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].SQUARE_HOLLOW] = {
  width: 8,
  height: 8
};
ie8LegendPath[_Constants["default"].DIAMOND_HOLLOW] = 'M4.157,9H2C1.448,9,1,8.552,1,8c0-0.552,0.448-1,1-1h2.157l-1,1L4.157,9z M14,7h-2.157l1,1l-1,1H14c0.552,0,1-0.448,1-1C15,7.448,14.552,7,14,7z M8,5.986L5.986,8L8,10.014L10.014,8L8,5.986 M8,4.571L11.429,8L8,11.429L4.571,8L8,4.571L8,4.571z';
ie8LegendSize[_Constants["default"].DIAMOND_HOLLOW] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].DIAMOND_HOLLOW] = "M2.121,4.999L5,2.121l2.878,2.878L5,7.879L2.121,4.999z M5,0L0,4.999L5,10l4.999-5.001L5,0z";
ie8LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].DIAMOND_HOLLOW] = {
  width: 10,
  height: 10
};
ie8LegendPath[_Constants["default"].TRIANGLE_HOLLOW] = 'M4.5,9H2C1.448,9,1,8.552,1,8s0.448-1,1-1h3.655L4.5,9z M14,7h-3.655L11.5,9H14c0.552,0,1-0.448,1-1S14.552,7,14,7z M8,6.938L6.232,10h3.536L8,6.938 M8,4.938L11.5,11h-7L8,4.938L8,4.938z';
ie8LegendSize[_Constants["default"].TRIANGLE_HOLLOW] = {
  width: 16,
  height: 16
};
ie8LegendPath[_Constants["default"].SCATTER_ICON + _Constants["default"].TRIANGLE_HOLLOW] = "M5.001,3.34L7.402,7.5H2.598L5.001,3.34z M5.001,0.34L0,9h10L5.001,0.34z";
ie8LegendSize[_Constants["default"].SCATTER_ICON + _Constants["default"].TRIANGLE_HOLLOW] = {
  width: 10,
  height: 9
}; // ie8及以下浏览器不支持图例Icon跟随图例字体大小变化：原因是ie8不支持transform，并且固定path路径也无法调整宽高

function getLegendIconSizeAndScale(name, textSize) {
  if (_Browser["default"].ielt9) {
    return getIe8LegendIconSize(name);
  }

  var originIconSize = getLegendIconSize(name);
  var iconSize = _BaseUtils["default"].includes(rectAndCircleIcon, name) || !LegendSize[name] ? ICON_TEXT_SCALE * textSize : textSize;
  var scale = iconSize / originIconSize.width;
  return {
    scale: scale,
    iconWidth: iconSize,
    // icon的实际宽度
    width: textSize,
    // icon所占位置的宽度：icon的实际宽度 + 左右边距
    height: scale * originIconSize.height
  };
}

function getLegendIconPath(name) {
  return _Browser["default"].ielt9 ? ie8LegendPath[name] : LegendPath[name];
}

function getLegendIconSize(name) {
  return LegendSize[name] ? LegendSize[name] : LegendSize[_Constants["default"].NORMAL_ICON];
}

function getIe8LegendIconSize(name) {
  var iconSize = ie8LegendSize[name] ? ie8LegendSize[name] : ie8LegendSize[_Constants["default"].NORMAL_ICON];
  return {
    scale: 1,
    iconWidth: iconSize.width,
    width: iconSize.width,
    height: iconSize.height
  };
}

function hasIcon(name) {
  return LegendPath[name];
}

function getLegendOuterBounds(innerBounds, options) {
  var borderWidth = options.borderWidth || 0;
  var shadowWidth = options.shadow ? _VanChartBackground.BACKGROUND_SHADOW_FILTER.deviation : 0;
  return {
    x: innerBounds.x - borderWidth / 2 - shadowWidth,
    y: innerBounds.y - borderWidth / 2 - shadowWidth,
    width: innerBounds.width + borderWidth + 2 * shadowWidth,
    height: innerBounds.height + borderWidth + 2 * shadowWidth
  };
}

var _default = {
  getLegendIconSizeAndScale: getLegendIconSizeAndScale,
  getLegendIconPath: getLegendIconPath,
  hasIcon: hasIcon,
  getLegendOuterBounds: getLegendOuterBounds,
  maxIconSize: 18
};
exports["default"] = _default;

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gradualLocation = gradualLocation;
exports.createGradientBackground = createGradientBackground;

var _Constants = _interopRequireDefault(__webpack_require__(1));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function gradualLocation(location) {
  var x1, y1, x2, y2;
  x1 = y1 = x2 = y2 = '0%';

  switch (location) {
    case _Constants["default"].BOTTOM_TO_TOP:
      y1 = '100%';
      break;

    case _Constants["default"].TOP_TO_BOTTOM:
      y2 = '100%';
      break;

    case _Constants["default"].LEFT_TO_RIGHT:
      x2 = '100%';
      break;

    case _Constants["default"].RIGHT_TO_LEFT:
      x1 = '100%';
      break;
  }

  return {
    x1: x1,
    y1: y1,
    x2: x2,
    y2: y2
  };
}

function createGradientBackground(target, key, renderer, color) {
  var toPercent = function (n) {
    return n * 100 + '%';
  };

  var x1 = toPercent(color.x1),
      x2 = toPercent(color.x2),
      y1 = toPercent(color.y1),
      y2 = toPercent(color.y2);
  var attrs = {
    'x1': x1,
    'y1': y1,
    'x2': x2,
    'y2': y2
  };
  var stop1 = {
    'offset': '0%',
    'stop-color': color.startColor
  };
  var stop2 = {
    'offset': '100%',
    'stop-color': color.endColor
  };
  target[key] = target[key] || renderer.colorGradient(attrs, [stop1, stop2]);
  return renderer.toPatternProperty(target[key]);
}

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Layer = _interopRequireDefault(__webpack_require__(20));

var _DomUtils = _interopRequireDefault(__webpack_require__(6));

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _Bounds = _interopRequireDefault(__webpack_require__(22));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _wrapper = _interopRequireDefault(__webpack_require__(41));

var _EnvUtils = __webpack_require__(3);

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 16/6/1.
 * 这个js做成类似接口的东西吧
 */
var PADDING = 0;

var Renderer = _Layer["default"].extend({
  /**
   * this._container may be svg,canvas,dom
   */
  initialize: function (dom, vanchart, config) {
    this.dom = dom;
    this.vanchart = vanchart;
    this.config = config;
    this.isSupportSVG = (0, _EnvUtils.isSupportSVG)();
    this.isAnimation = this.isSupportSVG && _BaseUtils["default"].pick(this.vanchart.options.plotOptions.animation, true);
  },
  resize: function () {},
  getActualImageUrl: function (src) {
    var imageMapping = this.vanchart.options.imageMapping || {};
    return (0, _CoreUtils.hasDefined)(imageMapping[src]) ? imageMapping[src] : src;
  },
  remove: function () {
    _DomUtils["default"].remove(this._container.node());

    _DomUtils["default"].remove(this._divContainer.node());

    this.off('update', this._updatePaths, this);
  },
  div: function (isHtml) {
    var d = (0, _wrapper["default"])(document.createElement('div'), this).setType('div').style({
      position: 'absolute',
      left: 0,
      top: 0
    });
    d.isHtml = isHtml; // log for IE8

    return d;
  },
  vgroup: function () {
    var divG = this.div();
    var renderG = this.group();
    return {
      divG: divG,
      renderG: renderG,
      type: 'vgroup',
      attr: function () {
        this.divG.attr.apply(this.divG, arguments);
        this.renderG.attr.apply(this.renderG, arguments);
        return this;
      },
      style: function () {
        this.divG.style.apply(this.divG, arguments);
        this.renderG.style.apply(this.renderG, arguments);
        return this;
      },
      append: function (ele) {
        if (ele.type === 'div' && ele.isHtml) {
          divG.append(ele);
        } else if (ele.type === 'vgroup') {
          divG.append(ele.divG);
          renderG.append(ele.renderG);
        } else {
          renderG.append(ele);
        }

        return ele;
      },
      add: function (parentG) {
        parentG ? this.renderG.addTo(parentG) : this.renderG.add();
        this.divG.add();
        return this;
      },
      remove: function () {
        this.divG.node() && this.divG.remove();
        this.renderG.node() && this.renderG.remove();
      },
      node: function () {
        return renderG.node();
      },
      vRotate: function (deg) {
        if (isNaN(deg)) {
          return;
        }

        this.divG.vRotate(deg);
        this.renderG.vRotate(deg);
      }
    };
  },
  vtext: function (isHtml) {
    if (isHtml || !this.isSupportSVG) {
      return this.div(isHtml); // for IE8, innerText or innerHtml
    }

    return this.text();
  },
  vtspan: function (isHtml) {
    if (isHtml || !this.isSupportSVG) {
      return this.div(isHtml);
    }

    return this.tspan();
  },
  onAdd: function () {
    if (!this._container) {
      this._initContainer(); // defined by renderer implementations


      if (this._zoomAnimated) {
        _DomUtils["default"].addClass(this._container.node(), 'leaflet-zoom-animated');
      }
    }

    this.dom.appendChild(this._container.node());
    this._divContainer && this.dom.appendChild(this._divContainer.node());

    this._update();

    this.on('update', this._updatePaths, this);
  },
  _update: function () {
    var size = this.vanchart.getSize();
    this._bounds = new _Bounds["default"]([0, 0], size);

    if (this._map) {
      var p = PADDING,
          min = this._map.containerPointToLayerPoint(size.multiplyBy(-p)).round();

      this._bounds = new _Bounds["default"](min, min.add(size.multiplyBy(1 + p * 2)).round());
      this._center = this._map.getCenter();
      this._zoom = this._map.getZoom();
    }
  },
  getEvents: function () {
    var events = {
      viewreset: this._reset,
      zoom: this._onZoom,
      moveend: this._update,
      zoomend: this._onZoomEnd
    };

    if (this._zoomAnimated) {
      events.zoomanim = this._onAnimZoom;
    }

    return events;
  },
  _onAnimZoom: function (ev) {
    this._updateTransform(ev.center, ev.zoom);
  },
  _onZoom: function () {
    this._updateTransform(this._map.getCenter(), this._map.getZoom());
  },
  _reset: function () {
    this._update();

    this._updateTransform(this._center, this._zoom);

    var layers = this.vanchart._layers;

    for (var id in layers) {
      layers[id]._path && layers[id]._reset();
    }
  },
  _onZoomEnd: function () {
    var layers = this.vanchart._layers;

    for (var id in layers) {
      layers[id]._path && layers[id]._project();
    }
  },
  _updatePaths: function () {
    var layers = this.vanchart._layers;

    for (var id in layers) {
      layers[id]._path && layers[id]._update();
    }
  },
  _updateTransform: function (center, zoom) {
    var container = this._container.node();

    var scale = this._map.getZoomScale(zoom, this._zoom),
        position = _DomUtils["default"].getPosition(container),
        viewHalf = this._map.getSize().multiplyBy(0.5 + PADDING),
        currentCenterPoint = this._map.project(this._center, zoom),
        destCenterPoint = this._map.project(center, zoom),
        centerOffset = destCenterPoint.subtract(currentCenterPoint),
        topLeftOffset = viewHalf.multiplyBy(-scale).add(position).add(viewHalf).subtract(centerOffset);

    if (_Browser["default"].any3d) {
      _DomUtils["default"].setTransform(container, topLeftOffset, scale);
    } else if ((0, _EnvUtils.isSupportSVG)()) {
      _DomUtils["default"].setPosition(container, topLeftOffset);
    } else {
      container.style.left = 0 + 'px';
      container.style.top = 0 + 'px';
    }
  },
  _updateGradientFill: function () {}
});

var _default = Renderer;
exports["default"] = _default;

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hideFullScreenChart = hideFullScreenChart;
exports.hideLightBox = hideLightBox;
exports.hideLightBoxWithReInit = hideLightBoxWithReInit;
exports.showLightBox = showLightBox;
exports["default"] = void 0;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _component = __webpack_require__(4);

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _validMapPoints = __webpack_require__(30);

var _EnvUtils = __webpack_require__(3);

var _QueryUtils = _interopRequireDefault(__webpack_require__(12));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * VanChart接口相关
 */
var _default = {
  /**
   * 设置地图缩放等级&中心点
   * @param option
   */
  setMapZoom: function (option) {
    var chart = this,
        geo = chart.getComponent(_component.ComponentCst.GEO_COMPONENT);
    var validOption = {}; //目前只开了这两个接口，这边控制下，以防option里面传过来其他属性。

    validOption.zoomLevel = option.zoomLevel;
    validOption.viewCenter = option.viewCenter;

    var oldOptions = _BaseUtils["default"].clone(geo.options);

    _BaseUtils["default"].extend(geo.options, validOption);

    geo.doLayout();
    geo.options = oldOptions;
  },

  /**
   * 开启数据点提示自动轮播
   * @param delay
   * @param initPoints
   * @returns {{stop: stop}}
   */
  openAutoTooltip: function (delay, initPoints) {
    delay = delay || 3000;
    var chart = this,
        chartType = chart.chartType();
    var option = chart.options;
    var shared = option && option.plotOptions && option.plotOptions.tooltip && option.plotOptions.shared; // 获取node节点下所有层级的所有节点

    var getTreeNodeChildrenPoint = function (node, container) {
      if (!node.children) {
        return;
      }

      node.children.forEach(function (child) {
        container.push(child);
        getTreeNodeChildrenPoint(child, container);
      });
    };

    var getAllChartPoints = function () {
      var points = [];
      var series = chart.series;

      if (shared) {
        points = series[0].points;
      } else if (chartType === _Constants["default"].TREEMAP_CHART || chartType === _Constants["default"].MULTIPIE_CHART) {
        series[0].points.forEach(function (point) {
          points.push(point);
          getTreeNodeChildrenPoint(point, points);
        });
      } else if (chart.isMap()) {
        points = (0, _validMapPoints.getAllMapPoints)(chart);
      } else {
        series.forEach(function (ser) {
          points = points.concat(ser.points);
        });
      } // 指显示展示点的提示


      return points.filter(function (point) {
        return point && point.isVisible();
      });
    }; // 没有指定轮播点集合则默认轮播所有点
    // 否则使用全部数据点, 考虑监控刷新时数据增减, 这边使用动态的方法获取


    var points = initPoints && initPoints.length ? initPoints : getAllChartPoints;
    this.autoTooltipController = this.autoTooltipController || autoTooltip();
    this.autoTooltipController.chart(chart).delay(delay).points(points).restart(); // @CHART-11774
    // 开启数据点提示轮播的过程中, 图表监控刷新了新数据, 需要隐藏数据点提示(当前提示的数据可能已经被移除了)

    var removeFn = chart.__removeAutoTooltip;

    if (!removeFn) {
      removeFn = chart.__removeAutoTooltip = function () {
        chart.hideTooltip();
      };
    } // remove & set listener .


    chart.off('update', removeFn);
    chart.on('update', removeFn); // 返回一个可以关闭自动数据点提示的控制器

    return {
      stop: function () {
        chart.autoTooltipController.sleep();
        chart.autoTooltipController.status('custom_sleep');
        chart.handler.removeAllChosen({
          containerPoint: {
            x: 0,
            y: 0
          }
        });
      },
      moveOn: function () {
        chart.autoTooltipController.wake();
      }
    };
  },

  /**
   * 显示自动数据点提示并触发数据点mouseover效果
   * @param point
   */
  showAutoTooltip: function (point) {
    if (!point.isVisible()) {
      return;
    } // 用series._getFixedPos来模拟鼠标位置


    var series = point.series,
        vanchart = series.vanchart;

    var pos = series._getFixedPos(point, {
      width: 0,
      height: 0
    }),
        chartType = this.chartType();

    var x = pos[0],
        y = pos[1];
    x = Math.max(1, Math.min(x, this.width - 1));
    y = Math.max(1, Math.min(y, this.height - 1)); // make sure containerPoint inside chartBounds

    var simulateEv = {
      containerPoint: {
        x: x,
        y: y
      }
    }; // trigger highlight

    if (chartType === _Constants["default"].HEAT_MAP || chartType === _Constants["default"].LINE_MAP) {
      this.fire("mousemove", simulateEv);
    } else {
      point.listens("mouseover") ? point.fire("mouseover", simulateEv) : point.series.fire("mouseover", simulateEv);
    } // trigger tooltip
    // @CHART-9748: 被隐藏的系列, fireMouseOver触发不了高亮和数据点提示, 这里需要手动触发一下


    point.isPointSupportTooltipShared() ? vanchart.showSharedTooltip(point, simulateEv) : vanchart.showTooltip(point, simulateEv);
  },
  switchAutoTooltipStatus: function (eventType) {
    var autoTooltipController = this.autoTooltipController;

    if (!autoTooltipController || autoTooltipController.status() === 'custom_sleep') {
      return;
    }

    eventType === "mouseover" ? autoTooltipController.sleep() : autoTooltipController.wake();
  },

  /**
   * 设置图表排序
   * @param sortType 排序类型,1为正序,-1为逆序
   */
  sortChart: function (sortType) {
    var vanchart = this,
        tools = this.getComponent("tools"),
        sortIcon;
    var ascending = _Constants["default"].ASCENDING,
        descending = _Constants["default"].DESCENDING;
    vanchart.orderType = sortType != null ? sortType > 0 ? ascending : descending : vanchart.orderType === ascending ? descending : ascending;
    vanchart.orderData(); // 存在工具栏的时候，修改工具栏内排序按钮的形态

    tools && (sortIcon = tools.getIcon(_Constants["default"].SORT)) && sortIcon.updateSortIconPath();
  },

  /**
   * 设置图表显示系列
   * @param showItems  展示系列对应的下标数组
   * 例：setSeriesVisible([0,1,3])则系列1，2，4显示，其他不显示；隐藏的系列图例也同样灰化。
   */
  setSeriesVisible: function (showItems) {
    showItems = showItems || [];
    var series = this.series,
        isSeriesAccumulated = series[0].isSeriesAccumulated();
    var legend = this.getComponent(_component.ComponentCst.LEGEND_COMPONENT);
    var legendItems = legend.items;
    var len = isSeriesAccumulated ? series[0].points.length : series.length; //1、switch series visibility and LegendItem state  2、reRender  3、LegendItem reset state

    var seriesNames = [],
        repeatSeriesNum = 0; //组合图中，不同类型图表系列可能系列名相同，重复的系列不重复处理。

    for (var i = 0; i < len; i++) {
      var visible = isSeriesAccumulated ? series[0].points[i].visible : series[i].visible,
          name = isSeriesAccumulated ? series[0].points[i].name : series[i].name;

      if (seriesNames.indexOf(name) !== -1) {
        repeatSeriesNum++;
        continue;
      }

      var item,
          itemIndex = i - repeatSeriesNum;

      if (legendItems.length >= itemIndex) {
        item = legendItems[itemIndex];
      }

      showItems.indexOf(itemIndex) !== -1 ? !visible && legend.switchSeriesItemVisible(name, item) : visible && legend.switchSeriesItemVisible(name, item);
      seriesNames.push(name);
    }

    this.reRenderWholePlot();
    legendItems.forEach(function (item) {
      item.resetState();
    });
  }
};
exports["default"] = _default;

function autoTooltip() {
  var chart,
      delay,
      points,
      pointIndex = 0,
      interval = 0,
      status = 0,
      layerIndex = 0;

  function loopTooltip(autoStart) {
    if (status === 'loop') {
      return;
    }

    interval && clearInterval(interval);

    function switchTooltip() {
      if (layerIndex !== chart.layerIndex) {
        chart.fire(_Constants["default"].AUTO_REFRESH);
        layerIndex = chart.layerIndex;
        pointIndex = 0;
      }

      points[pointIndex] && chart.showAutoTooltip(points[pointIndex]);
      pointIndex = pointIndex >= points.length - 1 ? 0 : pointIndex + 1;
    }

    interval = setInterval(switchTooltip, delay);
    status = 'loop'; // auto start

    autoStart && switchTooltip();
  }

  var controller = {
    points: function (_points) {
      // dynamic update points.
      if (typeof _points === 'function') {
        points = _points();
        chart.off(_Constants["default"].AUTO_REFRESH);
        chart.on(_Constants["default"].AUTO_REFRESH, function () {
          points = _points();
        });
      } else {
        points = _points || [];
      }

      return controller;
    },
    chart: function (_chart) {
      chart = _chart;
      return controller;
    },
    delay: function (_delay) {
      delay = _delay || 3000;
      return controller;
    },
    restart: function () {
      pointIndex = 0;
      !interval && loopTooltip(true);
    },
    sleep: function () {
      if (interval) {
        interval = clearInterval(interval);
      }

      status = 'mouse_sleep';
      return controller;
    },
    status: function (_) {
      return _ ? status = _ : status;
    },
    wake: function () {
      loopTooltip();
    },
    destroy: function () {
      clearInterval(interval);
      points = chart = null;
    }
  };
  return controller;
}

function getTopWindow() {
  var w, d;

  try {
    d = window.top.document;
    w = window.top; // 在最上层document中判断是否存在全屏元素，存在则在全屏元素内寻找合适的window&document，
    // 关于document.fullscreenElement:
    // https://developer.mozilla.org/en-US/docs/Web/API/Document/fullscreenElement
    // https://bobscript.com/archives/423/

    var fullScreenElement = d.fullscreenElement || d.mozFullScreenElement || d.webkitFullscreenElement || d.msFullscreenElement; // @CHART-2003
    // 存在全屏元素, 则向上寻找直到全屏元素下第一层iFrame(此时的图表肯定在全屏元素里面的某一个iFrame里面)

    if (fullScreenElement) {
      w = window;
      d = w.document;

      var isParentFs = function (w) {
        return w.parent && w !== w.parent && !w.parent.document.fullscreenElement && !w.parent.document.mozFullScreenElement && !w.parent.document.webkitFullscreenElement && !w.parent.document.msFullscreenElement;
      };

      while (isParentFs(w)) {
        w = w.parent;
        d = w.document;
      }
    }
  } catch (e) {
    w = window;
    d = w.document;
  }

  return {
    w: w,
    d: d
  };
}

function hideFullScreenChart() {
  if (VanCharts.fullScreenChart) {
    var fullScrVanCharts = VanCharts.fullScreenChart;
    hideLightBox(fullScrVanCharts.dom, fullScrVanCharts.fullScreenFather);
  }
}

function hideLightBox(container, fullScreenFather) {
  var parent = container.parentNode;

  if (parent) {
    parent.removeChild(container);

    if (container.boxDiv) {
      parent.removeChild(container.boxDiv);
    }
  }

  fullScreenFather.set({
    enable: true
  });
  fullScreenFather.fullScreenChart = null;
  VanCharts.fullScreenChart = null;
  fullScreenFather.fire("fullScreenOff");
} // @Mango  Chart-1675 中第二种情况
//图表全屏展示后，点击超链动态参数，原图重新初始化
//原图重新初始化时，全屏展示应该关闭


function hideLightBoxWithReInit() {
  if (VanCharts.fullScreenChart) {
    var fullScrVanCharts = VanCharts.fullScreenChart,
        fullScreenFather = fullScrVanCharts.fullScreenFather,
        fatherChartDom = fullScreenFather.getDivParentDom();

    if (!fatherChartDom || !document.body.contains(fatherChartDom)) {
      hideLightBox(fullScrVanCharts.dom, fullScrVanCharts.fullScreenFather);
    }
  }
}

function showLightBox(vanchart, zIndex) {
  var options = _QueryUtils["default"].merge({}, vanchart.options);

  options.width = options.height = null; // 默认放在window.top，当存在全屏元素时，需要判断特殊处理一下

  var wd = getTopWindow(),
      w = wd.w,
      d = wd.d;
  var body = d.body; //todo FR的zIndex没有一个统一的逻辑,3000,8000都是写死的值
  //var currentMaxZ = 7998;  留着以后做参考，这里改成3330是为了全屏之后超链能显示

  var currentMaxZ = 3330;

  if (zIndex == null) {
    var el,
        i = -1,
        len = document.body.children.length;

    while (++i < len) {
      el = document.body.children[i];

      if ((el.style.display || '').toLowerCase() !== 'none') {
        currentMaxZ = Math.max(currentMaxZ, el.style.zIndex);
      }
    }
  } else {
    currentMaxZ = zIndex - 1;
  }

  var boxDiv = d.createElement('div');
  boxDiv.style.cssText = 'position: fixed;' + 'top:0;' + 'left:0;' + 'width:100%;' + 'height:100%;' + 'z-index:' + (currentMaxZ + 1) + ';';

  if ((0, _EnvUtils.isSupportSVG)()) {
    boxDiv.style.background = 'rgba(0,0,0,0.3)';
  } else {
    boxDiv.style.background = '#000000';
    boxDiv.style.filter = 'alpha(opacity=30)';
  }

  body.appendChild(boxDiv);
  var container = d.createElement('div');
  container.style.cssText = 'position: fixed;' + 'top:5%;' + 'left:10%;' + 'width:80%;' + 'height:90%;' + 'z-index:' + (currentMaxZ + 2) + ';' + 'background:#ffffff;' + 'box-shadow:0px 4px 50px rgba(0,0,0,0.5);' + _BaseUtils["default"].getBorderCssText({
    'borderRadius': options.borderRadius + options.borderWidth
  }).join(';') + ';'; // for ie quirks mode

  try {
    container.style.setExpression("top", "( ignoreMe = document.body.scrollTop + this.previousSibling.clientHeight * 0.05) + 'px' ");
    boxDiv.style.setExpression("top", "( ignoreMe = document.body.scrollTop ) + 'px' ");
    container.style.position = 'absolute';
    boxDiv.style.position = 'absolute';
  } catch (e) {}

  body.appendChild(container);
  var fullScrVanCharts = VanCharts.init(container); // It's a little strange that
  // the VanChart[S] instance's father is a VanChart instance
  // 'cause we have only one chart in full screen mode

  fullScrVanCharts.fullScreenFather = vanchart;
  fullScrVanCharts.setOptions(options);
  fullScrVanCharts.doHyperlink = vanchart.vancharts.doHyperlink;
  vanchart.set({
    enable: false
  });
  vanchart.fullScreenChart = fullScrVanCharts;
  VanCharts.fullScreenChart = fullScrVanCharts;
  container.boxDiv = boxDiv;

  boxDiv.onclick = function () {
    hideLightBox(container, vanchart);
  };

  container.onclick = function (e) {
    e = e || w.event;

    if (e.stopPropagation) {
      e.stopPropagation();
    } else {
      e.cancelBubble = true;
    }
  };

  vanchart.fire("fullScreenOn");
}

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _default = {
  getSeriesKey: function (serData, chartOption) {
    if (!serData) {
      return '';
    }

    var type = serData.type || chartOption.chartType,
        key = serData.name + type;

    if (type === _Constants["default"].PIE_CHART) {
      key += serData.roseType || chartOption.plotOptions.roseType || '';
    }

    if (type === _Constants["default"].GAUGE_CHART) {
      var style = serData.style || chartOption.plotOptions.style,
          layout = serData.thermometerLayout || chartOption.plotOptions.thermometerLayout || '';
      key += style + layout;
    }

    if (type === _Constants["default"].RADAR_CHART) {
      var columnType = serData.columnType || chartOption.plotOptions.columnType;
      key += columnType ? _Constants["default"].COLUMN_RADAR : _Constants["default"].LINE_RADAR;
    }

    return key;
  },
  getPointKey: function (pointData, type) {
    if (!pointData) {
      return '';
    }
    /*
    * 饼图、柱形图、折线图、面积图、仪表盘、雷达图、箱型图、力学气泡图
    * */


    if (type == _Constants["default"].PIE_CHART || type == _Constants["default"].COLUMN_CHART || type == _Constants["default"].LINE_CHART || type == _Constants["default"].AREA_CHART || type == _Constants["default"].RADAR_CHART || type == _Constants["default"].GAUGE_CHART || type == _Constants["default"].BOX_CHART || type == _Constants["default"].FORCE_BUBBLE_CHART) {
      return pointData.categoryArray ? pointData.x + "-" + _BaseUtils["default"].stringify(pointData.categoryArray) : pointData.x;
    }
    /*
    * 条形图
    * */


    if (type == _Constants["default"].BAR_CHART) {
      return pointData.categoryArray ? pointData.y + "-" + _BaseUtils["default"].stringify(pointData.categoryArray) : pointData.y;
    }
    /*
    * 气泡图、散点图
    * */


    if (type == _Constants["default"].BUBBLE_CHART || type == _Constants["default"].SCATTER_CHART) {
      return pointData.x + "-" + pointData.y;
    }
    /*
    * 多层饼图、矩形树图、漏斗图、词云、框架图、区域地图、点地图、热力地图
    * */


    if (type == _Constants["default"].MULTIPIE_CHART || type == _Constants["default"].TREEMAP_CHART || type == _Constants["default"].FUNNEL_CHART || type == _Constants["default"].WORD_CLOUD_CHART || type == _Constants["default"].STRUCTURE_CHART || type == _Constants["default"].AREA_MAP) {
      return pointData.name;
    }

    if (type == _Constants["default"].POINT_MAP || type == _Constants["default"].HEAT_MAP) {
      return pointData.name + "-" + _BaseUtils["default"].stringify(pointData.lnglat);
    }
    /*
    * 流向地图
    * */


    if (type == _Constants["default"].LINE_MAP) {
      return _BaseUtils["default"].stringify(pointData.from) + "-" + _BaseUtils["default"].stringify(pointData.to);
    }
    /*
    * 甘特图
    * */


    if (type == _Constants["default"].GANTT_CHART) {
      return pointData.processesId;
    }

    return '';
  }
};
exports["default"] = _default;

/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCustomLabel = isCustomLabel;
exports.customLabel = customLabel;
exports.customDataLabel = customDataLabel;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _dataLabelFormatter = __webpack_require__(26);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var LABEL_MIN_FONTSIZE = 10;

function isCustomLabel(formatter) {
  return typeof formatter != 'object';
}

function customLabel(point, dataLabelsOpt, autoSize) {
  var dataLabels = _BaseUtils["default"].clone(dataLabelsOpt);

  var style = dataLabels.style;

  if (style.autoSize) {
    style.fontSize = Math.max(autoSize, LABEL_MIN_FONTSIZE) + 'px';
  }

  var customLabel = (0, _dataLabelFormatter.calculateCustomLabel)(point, dataLabels)[0];
  return {
    labelContent: customLabel.text,
    labelStyle: customLabel.style,
    labelDim: customLabel.dim
  };
}

function customDataLabel(series, labelOpt, autoSize, fixColor) {
  var point = series.points[0];
  var label = customLabel(point, labelOpt, autoSize);
  var labelStyle = label.labelStyle,
      labelContent = label.labelContent,
      labelDim = label.labelDim;

  if (fixColor) {
    labelStyle.color = point.color;
  }

  return {
    labelContent: labelContent,
    labelStyle: labelStyle,
    labelDim: labelDim
  };
}

/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMultiLineLabelContent = createMultiLineLabelContent;
exports.calculateSingleLineLabelContent = calculateSingleLineLabelContent;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _FormattedText = __webpack_require__(39);

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function createMultiLineLabelContent(formatter, data) {
  if (!formatter) {
    return {};
  }

  if (typeof formatter == 'object') {
    var content = {};
    var label = formatter.identifier;

    var categoryString = _BaseUtils["default"].format(data.category, formatter.categoryFormat);

    var seriesString = _BaseUtils["default"].format(data.seriesName, formatter.seriesFormat);

    var valueString = _BaseUtils["default"].format(data.originalValue, formatter.valueFormat);

    var percentString = _BaseUtils["default"].format(data.percentage, formatter.percentFormat);

    if (label.indexOf(_FormattedText.CATEGORY) != -1) {
      content.category = categoryString;
    }

    if (label.indexOf(_FormattedText.SERIES) != -1) {
      content.series = seriesString;
    }

    if (label.indexOf(_FormattedText.VALUE) != -1) {
      content.value = valueString;
    }

    if (label.indexOf(_FormattedText.PERCENT) != -1) {
      content.percent = percentString;
    }

    return content;
  } else {
    return {
      text: _BaseUtils["default"].getFormatterFunction(formatter).call(data)
    };
  }
}

function calculateSingleLineLabelContent(formatter, data) {
  if (!formatter) {
    return '';
  }

  if (typeof formatter == 'object') {
    var content = '';
    var label = formatter.identifier;

    var categoryString = _BaseUtils["default"].format(_BaseUtils["default"].pick(data.category, ''), formatter.categoryFormat);

    var seriesString = _BaseUtils["default"].format(_BaseUtils["default"].pick(data.seriesName, ''), formatter.seriesFormat);

    if (label.indexOf(_FormattedText.CATEGORY) != -1 || label.indexOf(_FormattedText.SERIES) != -1) {
      if (label.indexOf(_FormattedText.CATEGORY) != -1 && label.indexOf(_FormattedText.SERIES) != -1) {
        content += categoryString + ' ' + seriesString;
      } else if (label.indexOf(_FormattedText.CATEGORY) != -1) {
        content += categoryString;
      } else {
        content += seriesString;
      }
    }

    if (!data.isNull && label.indexOf(_FormattedText.VALUE) != -1 || label.indexOf(_FormattedText.PERCENT) != -1) {
      if (!(0, _CoreUtils.isEmpty)(content)) {
        content += ':';
      }

      var valueString = _BaseUtils["default"].format(data[data.series.getTargetKey()], formatter.valueFormat);

      var percentString = _BaseUtils["default"].format(data.percentage, formatter.percentFormat);

      if (label.indexOf(_FormattedText.VALUE) != -1 && label.indexOf(_FormattedText.PERCENT) != -1) {
        content += valueString + ' ' + percentString;
      } else if (label.indexOf(_FormattedText.VALUE) != -1) {
        content += valueString;
      } else {
        content += percentString;
      }
    }

    return content;
  } else {
    return _BaseUtils["default"].getFormatterFunction(formatter).call(data);
  }
}

/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Evented = _interopRequireDefault(__webpack_require__(13));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _QueryUtils = _interopRequireDefault(__webpack_require__(12));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by Yuqian on 2017/2/27.
 */
// todo, need a transform util
var transReg = /translate\(\s*([\d|.|e|-]+)(?:[,\s]*)([\d|.|e|-]*)\s*\)/i;
var BG_SIZE = 10;
var BG_COLOR = 'rgba(200, 200,200, 0.2)';
var BAR_SIZE = 6;
var BAR_COLOR = 'rgba(173, 173, 173, 0.35)';
var BAR_HOVER_COLOR = 'rgba(173, 173, 173, 0.6)';

var ScrollbarItem = _Evented["default"].extend({
  mergeOpt: function (cfg) {
    return _QueryUtils["default"].merge(cfg, {
      backgroundSize: BG_SIZE,
      backgroundColor: BG_COLOR,
      backgroundSizeRadius: 0,
      barColor: BAR_COLOR,
      barHoverColor: BAR_HOVER_COLOR,
      barSize: BAR_SIZE
    });
  },
  initialize: function (cfg) {
    var opt = this.opt = this.mergeOpt(cfg);
    opt.length = Math.max(0, opt.length);
    opt.barLength = Math.max(0, opt.barLength);
    var backgroundSize = opt.backgroundSize;
    var backgroundSizeRadius = opt.backgroundSizeRadius;
    var barSize = opt.barSize;
    var barRound = opt.barSize / 2;
    this.pos = {
      x: 0,
      y: 0
    };
    var vanchart = opt.manager.vanchart,
        R = opt.manager.renderer;
    this.group = opt.group.append(R.group());
    this.group.style('transition', 'opacity 0.3s');
    this.group.attr('transform', _BaseUtils["default"].makeTranslate([opt.x, opt.y]));
    var width, height, barWidth, barHeight, offsetDir;

    if (opt.dir === 'x') {
      width = this.opt.length;
      height = backgroundSize;
      barWidth = this.opt.barLength;
      barHeight = barSize;
      offsetDir = 'y';
    } else {
      width = backgroundSize;
      height = this.opt.length;
      barWidth = barSize;
      barHeight = this.opt.barLength;
      offsetDir = 'x';
    }

    this.background = this.group.append(R.rect().attr({
      'width': width,
      'height': height,
      'rx': backgroundSizeRadius,
      'ry': backgroundSizeRadius
    }).style({
      'fill': opt.backgroundColor
    }));
    var barAttrs = {
      'rx': barRound,
      'ry': barRound,
      'width': barWidth,
      'height': barHeight
    };
    barAttrs[offsetDir] = (backgroundSize - barSize) / 2;
    this.bar = this.group.append(R.rect().attr(barAttrs).style('fill', opt.barColor));
    vanchart.registerInteractiveTarget(this, this.bar);
  },
  show: function (d) {
    d = this._over || d;

    if (this.opt.length <= this.opt.barLength) {
      d = false;
    }

    if (d !== this._showed) {
      this._showed = d;
      this.group.style('display', d ? '' : 'none');
    }
  },
  remove: function () {
    this.group.remove();
    this.bar.remove();
  },
  setPos: function (x, y) {
    if (x !== this.opt.x || y !== this.opt.y) {
      this.group.attr('transform', _BaseUtils["default"].makeTranslate([x, y]));
      this.opt.x = x;
      this.opt.y = y;
    }
  },
  setSize: function (length, barLength) {
    if (length !== this.opt.length || barLength !== this.opt.barLength) {
      // 这些size啊看上去就像个bug
      if (length < barLength || length < 0 || barLength < 0) {
        length = barLength = 0;
      }

      this.opt.length = length;
      this.opt.barLength = barLength;

      if (length === 0) {
        this.show(false);
      } else {
        var key = this.opt.dir === 'x' ? 'width' : 'height';
        this.background.attr(key, length);
        this.bar.attr(key, barLength);
      }
    }
  },
  setPct: function (pct) {
    this.setBarPos(this._getRemainLength() * pct);
  },
  getBarPos: function () {
    return this.pos[this.opt.dir];
  },
  setBarPos: function (value) {
    value = Math.max(0, Math.min(value, this._getRemainLength()));

    if (this.getBarPos() !== value) {
      this.pos[this.opt.dir] = value;
      this.bar.attr('transform', _BaseUtils["default"].makeTranslate(this.pos));
    }
  },
  _getRemainLength: function () {
    return this.opt.length - this.opt.barLength;
  },
  // _getBarPos: function () {
  //     var translate;
  //     if (isSupportSVG) {
  //         translate = this.bar.attr('transform').match(transReg);
  //         translate && translate.shift();
  //
  //     } else {
  //         var style = this.bar.node().style;
  //         translate = [parseFloat(style.left), parseFloat(style.top)];
  //     }
  // },
  getEvents: function () {
    return {
      'mouseover': this.onMouseOver,
      'mouseout': this.onMouseOut,
      'panstart': this.onPanStart,
      'panmove': this.onPanMove,
      'panend': this.onPanEnd
    };
  },
  onMouseOver: function () {
    this._over = true;
    this.bar.style({
      fill: this.opt.barHoverColor
    });
  },
  onMouseOut: function () {
    this._over = false;
    this.bar.style({
      fill: this.opt.barColor
    });
  },
  onPanStart: function (ev) {
    this.initPos = this.getBarPos();
    this.initPointPos = ev.containerPoint;
  },
  onPanMove: function (ev) {
    var delta = ev.containerPoint[this.opt.dir] - this.initPointPos[this.opt.dir]; // this.setBarPos(this.initPos + delta); // 不改变自己, 避免重复事件还要加判断

    this.opt.manager['on' + this.opt.dir]((this.initPos + delta) / this._getRemainLength());
  },
  onPanEnd: function () {
    this.opt.manager.vanchart.handler.panTarget = null;
  }
});

ScrollbarItem.SIZE = BG_SIZE;
var _default = ScrollbarItem;
exports["default"] = _default;

/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.T_SCROLLBAR_NAME = exports.P_SCROLLBAR_NAME = void 0;

var _ScrollbarItem = _interopRequireDefault(__webpack_require__(64));

var _renderer = __webpack_require__(24);

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var P_SCROLLBAR_NAME = 'processesScrollbar';
exports.P_SCROLLBAR_NAME = P_SCROLLBAR_NAME;
var T_SCROLLBAR_NAME = 'timeAxisScrollbar';
exports.T_SCROLLBAR_NAME = T_SCROLLBAR_NAME;

var ScrollbarItemCanvas = _ScrollbarItem["default"].extend({
  initialize: function (cfg) {
    var opt = this.opt = this.mergeOpt(cfg);
    opt.length = Math.max(0, opt.length);
    opt.barLength = Math.max(0, opt.barLength);

    var name = this._scrollbarName();

    var allBounds = this._getAllBounds(opt);

    return this._initScrollBar(opt, name, allBounds);
  },
  _isProcessesScrollBar: function () {
    return this.opt.manager.view._getGroup('processesGroup');
  },
  _initScrollBar: function (opt, name, allBounds) {
    var vanchart = opt.manager.vanchart;
    var backgroundBounds = allBounds.backgroundBounds,
        barBounds = allBounds.barBounds,
        canvasBounds = allBounds.canvasBounds,
        eventBounds = allBounds.eventBounds;

    if (!vanchart[name]) {
      vanchart[name] = (0, _renderer.createCanvasRenderer)(vanchart.dom, vanchart, canvasBounds);
      vanchart[name].onAdd();
      vanchart[name]._panState = null;
    }

    this.barBounds = barBounds;
    this.backgroundBounds = backgroundBounds;
    vanchart[name]['bar' + opt.dir + 'Bounds'] = eventBounds;
    this.renderScrollBar();
  },
  _getAllBounds: function (opt) {
    var canvasBounds = this._getCanvasBounds(opt);

    var otherBounds = this._getOtherBounds(opt, canvasBounds);

    return _extends({
      canvasBounds: canvasBounds
    }, otherBounds);
  },
  _getCanvasBounds: function (opt) {
    var vanchart = opt.manager.vanchart;
    var realCanvasBounds = vanchart.realCanvasBounds;

    if (this._isProcessesScrollBar()) {
      var processesAxisBounds = vanchart.getProcesses().bounds;
      return {
        x: processesAxisBounds.x,
        y: realCanvasBounds.y,
        width: processesAxisBounds.width,
        height: realCanvasBounds.height
      };
    } else {
      return realCanvasBounds;
    }
  },
  _getOtherBounds: function (opt, canvasBounds) {
    var barAndBgBounds = this._barAndBgBounds(opt, canvasBounds);

    var backgroundBounds = barAndBgBounds.backgroundBounds,
        barBounds = barAndBgBounds.barBounds;
    var eventBounds = {
      x: barBounds.x + canvasBounds.x,
      y: barBounds.y + canvasBounds.y,
      width: barBounds.width,
      height: barBounds.height
    };
    return {
      backgroundBounds: backgroundBounds,
      barBounds: barBounds,
      eventBounds: eventBounds
    };
  },
  _barAndBgBounds: function (opt, canvasBounds) {
    var width, height, barWidth, barHeight, bgPos, barPos;

    if (opt.dir === 'x') {
      width = opt.length;
      height = opt.backgroundSize;
      barWidth = opt.barLength;
      barHeight = opt.barSize;
      bgPos = {
        x: 0,
        y: canvasBounds.height - height
      };
      barPos = {
        x: 0,
        y: canvasBounds.height - height + (height - barHeight) / 2
      };
    } else {
      width = opt.backgroundSize;
      height = opt.length;
      barWidth = opt.barSize;
      barHeight = opt.barLength;
      bgPos = {
        x: canvasBounds.width - width,
        y: 0
      };
      barPos = {
        x: canvasBounds.width - width + (width - barWidth) / 2,
        y: 0
      };
    }

    return {
      barBounds: _extends({}, barPos, {
        width: barWidth,
        height: barHeight
      }),
      backgroundBounds: _extends({}, bgPos, {
        width: width,
        height: height
      })
    };
  },
  _scrollbarName: function () {
    if (this._isProcessesScrollBar()) {
      return P_SCROLLBAR_NAME;
    } else {
      return T_SCROLLBAR_NAME;
    }
  },
  renderScrollBar: function () {
    var _this$opt = this.opt,
        manager = _this$opt.manager,
        barColor = _this$opt.barColor,
        barSize = _this$opt.barSize,
        backgroundColor = _this$opt.backgroundColor;
    var vanchart = manager.vanchart;

    var name = this._scrollbarName();

    var ctx = vanchart[name].ctx;
    var backgroundBounds = this.backgroundBounds,
        barBounds = this.barBounds;
    var x = backgroundBounds.x,
        y = backgroundBounds.y,
        width = backgroundBounds.width,
        height = backgroundBounds.height;
    ctx.save();
    ctx.fillStyle = backgroundColor;
    ctx.fillRect(x, y, width, height);
    this.drawBarShape(ctx, _extends({}, barBounds, {
      r: barSize / 2,
      barColor: barColor
    }));
    ctx.restore();
  },
  drawBarShape: function (ctx, style) {
    var x = style.x,
        y = style.y,
        w = style.width,
        h = style.height,
        r = style.r,
        barColor = style.barColor;
    ctx.beginPath();
    ctx.moveTo(x + r, y);
    ctx.arcTo(x + w, y, x + w, y + h, r);
    ctx.arcTo(x + w, y + h, x, y + h, r);
    ctx.arcTo(x, y + h, x, y, r);
    ctx.arcTo(x, y, x + w, y, r);
    ctx.closePath();
    ctx.fillStyle = barColor;
    ctx.fill();
  },
  updateScrollBar: function () {
    var vanchart = this.opt.manager.vanchart;

    var name = this._scrollbarName();

    var ctx = vanchart[name].ctx;
    var backgroundBounds = this.backgroundBounds;
    var x = backgroundBounds.x,
        y = backgroundBounds.y,
        width = backgroundBounds.width,
        height = backgroundBounds.height;
    ctx.clearRect(x, y, width, height);
    this.renderScrollBar();
  },
  show: function (d) {
    var name = this._scrollbarName();

    var vanchart = this.opt.manager.vanchart;

    if (d !== this._showed) {
      this._showed = d;
      vanchart[name].ctx.canvas.style.display = d ? '' : 'none';
    }
  },
  remove: function () {
    var name = this._scrollbarName();

    var vanchart = this.opt.manager.vanchart;
    vanchart[name] && vanchart[name].remove();
    vanchart[name] = null;
  },
  getBarPos: function () {
    return this.barBounds[this.opt.dir];
  },
  setBarPos: function (value) {
    value = _BaseUtils["default"].getValueInDomain(this._getRemainLength(), [0, value]);

    if (this.getBarPos() === value) {
      return;
    }

    var dir = this.opt.dir;
    this.barBounds[dir] = value;
    var vanchart = this.opt.manager.vanchart;

    var name = this._scrollbarName();

    var canvasBounds = this._getCanvasBounds(this.opt);

    vanchart[name]['bar' + dir + 'Bounds'][dir] = canvasBounds[dir] + value;
    this.updateScrollBar();
  },
  setPos: function (x, y) {},
  setSize: function (length, barLength) {
    if (length === this.opt.length && barLength === this.opt.barLength) {
      return;
    }

    if (length < barLength || length < 0 || barLength < 0) {
      length = barLength = 0;
    }

    this.opt.length = length;
    this.opt.barLength = barLength;

    if (length === 0) {
      this.show(false);
    } else {
      var key = this.opt.dir === 'x' ? 'width' : 'height';
      this.backgroundBounds[key] = length;
      this.barBounds[key] = barLength;
      this.updateScrollBar();
    }
  }
});

var _default = ScrollbarItemCanvas;
exports["default"] = _default;

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Base = _interopRequireDefault(__webpack_require__(11));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _CategoryAxis = _interopRequireDefault(__webpack_require__(56));

var _ValueAxis = _interopRequireDefault(__webpack_require__(68));

var _DateAxis = _interopRequireDefault(__webpack_require__(98));

var _MultiCategoryAxis = _interopRequireDefault(__webpack_require__(99));

var _component = __webpack_require__(4);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/5/15.
 * 坐标轴组建的定义
 */
var Axis = _Base["default"].extend({
  _refresh: function () {
    this._axisList = this._axisList || [];
    var options = this.options;
    options = _BaseUtils["default"].isArray(options) ? options : [options]; //最终生成的坐标轴数应该和新的option一样

    var len = options.length;

    for (var axisIndex = len; axisIndex < this._axisList.length; axisIndex++) {
      this._axisList[axisIndex].remove();

      this._axisList[axisIndex] = null;
    }

    this._axisList.length = len;

    for (var axisIndex = len - 1; axisIndex >= 0; axisIndex--) {
      //增加一个坐标轴序号的标记
      options[axisIndex].axisIndex = axisIndex;

      if (this._axisList[axisIndex] && this._axisList[axisIndex].type != options[axisIndex].type) {
        this._axisList[axisIndex].remove();

        this._axisList[axisIndex] = null;
      }

      if (this._axisList[axisIndex]) {
        this._axisList[axisIndex].refresh(options[axisIndex]);
      } else {
        var AxisClass;
        var axisType = options[axisIndex].type || _component.ComponentCst.VALUE_AXIS_COMPONENT;

        if (axisType == _component.ComponentCst.VALUE_AXIS_COMPONENT) {
          AxisClass = _ValueAxis["default"];
        } else if (axisType == _component.ComponentCst.CATEGORY_AXIS_COMPONENT) {
          AxisClass = _CategoryAxis["default"];
        } else if (axisType == _component.ComponentCst.DATE_AXIS_COMPONENT) {
          AxisClass = _DateAxis["default"];
        } else if (axisType === _component.ComponentCst.MULTI_CATEGORY_AXIS_COMPONENT) {
          AxisClass = _MultiCategoryAxis["default"];
        }

        this._axisList[axisIndex] = new AxisClass(options[axisIndex], this.componentType, this.vanchart);
      }
    }
  },
  doLayout: function () {
    var axisCount = this._axisList.length;

    for (var i = axisCount - 1; i >= 0; i--) {
      this._axisList[i].calculateDomainFromData();
    }
  },
  calculateAxisSize: function () {
    var axisCount = this._axisList.length;

    for (var i = axisCount - 1; i >= 0; i--) {
      this._axisList[i]._calculateSize();

      this._axisList[i]._recordAxisSize();
    }
  },
  updateAxisClip: function () {
    var clipBounds = {};
    var axisCount = this._axisList.length;

    for (var i = axisCount - 1; i >= 0; i--) {
      this._axisList[i].updateClipBounds(clipBounds);
    }

    this._recordForPlotBounds(_Constants["default"].LEFT, clipBounds[_Constants["default"].LEFT] || 0);

    this._recordForPlotBounds(_Constants["default"].RIGHT, clipBounds[_Constants["default"].RIGHT] || 0);

    this._recordForPlotBounds(_Constants["default"].TOP, clipBounds[_Constants["default"].TOP] || 0);

    this._recordForPlotBounds(_Constants["default"].BOTTOM, clipBounds[_Constants["default"].BOTTOM] || 0);
  },
  updateAxisSizeAndBounds: function () {
    var axisCount = this._axisList.length;

    for (var i = axisCount - 1; i >= 0; i--) {
      this._axisList[i].updateAxisSizeAndBounds();
    }
  },
  adjustDomain4Radius: function () {
    var adjusted = false;
    var axisCount = this._axisList.length;

    for (var i = axisCount - 1; i >= 0; i--) {
      adjusted = this._axisList[i].adjustDomain4Radius() || adjusted;
    }

    return adjusted;
  },
  fixBoundsByPlot: function () {
    var plotBounds = this.vanchart.bounds;
    var map = {};

    for (var i = 0, axisCount = this._axisList.length; i < axisCount; i++) {
      var axis = this._axisList[i],
          position = axis.getPosition();

      if (axis.isOnZero()) {
        if (position == _Constants["default"].TOP || position == _Constants["default"].BOTTOM) {
          axis.bounds.width = plotBounds.width;
        } else {
          axis.bounds.height = plotBounds.height;
        } //计算坐标轴的scale和tickData


        axis.fixScaleAndTickData();
      } else {
        map[position] = map[position] || [];
        map[position].push(axis);
      }
    }

    for (var position in map) {
      var axisList = map[position];
      var isHorizontal = position == _Constants["default"].TOP || position == _Constants["default"].BOTTOM;

      for (var i = 0, count = axisList.length; i < count; i++) {
        var axis = axisList[i],
            axisBounds = axis.bounds;
        var baseBounds = axisList[i - 1] && axisList[i - 1].bounds || plotBounds;

        if (isHorizontal) {
          var y = position == _Constants["default"].TOP ? baseBounds.y - axisBounds.height : baseBounds.y + baseBounds.height;
          axis.bounds = _BaseUtils["default"].makeBounds(baseBounds.x, y, baseBounds.width, axisBounds.height);
        } else {
          var x = position == _Constants["default"].LEFT ? baseBounds.x - axisBounds.width : baseBounds.x + baseBounds.width;
          axis.bounds = _BaseUtils["default"].makeBounds(x, baseBounds.y, axisBounds.width, baseBounds.height);
        } //计算坐标轴的scale和tickData


        axis.fixScaleAndTickData();
      }
    }
  },
  getAxis: function (axisIndex) {
    if (axisIndex >= this._axisList.length) {
      axisIndex = 0;
    }

    return this._axisList[axisIndex];
  },
  getAxisCount: function () {
    return this._axisList.length;
  },
  axisZoom: function (downPos, upPos) {
    this._axisList.forEach(function (axis) {
      axis.axisZoom(downPos, upPos);
    });
  },
  //处理0值对齐
  dealOnZero: function () {
    this._axisList.forEach(function (axis) {
      axis.dealOnZero();
    });
  },
  updateAxisBounds: function () {
    // 处理0值对齐之后会改变当前值轴的bounds属性，现在将其改回来
    this._axisList.forEach(function (axis) {
      axis.updateAxisBounds();
    });
  },
  render: function () {
    for (var i = 0, len = this._axisList.length; i < len; i++) {
      this._axisList[i].render();
    }
  },

  /**
   * 移除Axis组件下所有细分的axis
   * @return {[type]} [description]
   */
  remove: function () {
    for (var i = 0, len = this._axisList.length; i < len; i++) {
      this._axisList[i].remove();
    }
  }
});

var _default = Axis;
exports["default"] = _default;

/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _QueryUtils = _interopRequireDefault(__webpack_require__(12));

var _Scale = _interopRequireDefault(__webpack_require__(10));

var _VanChartLayout = _interopRequireDefault(__webpack_require__(44));

var _Base = _interopRequireDefault(__webpack_require__(11));

var _BezierEasing = _interopRequireDefault(__webpack_require__(8));

var _component = __webpack_require__(4);

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _EnvUtils = __webpack_require__(3);

var _CoreUtils = __webpack_require__(2);

var _StyleUtils = __webpack_require__(16);

var _AxisUtils = __webpack_require__(33);

var _AutoFitUtils = __webpack_require__(17);

var _VanChartLabel = _interopRequireDefault(__webpack_require__(97));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/6/18.
 */
var TIME = 400;
var EASE = _BezierEasing["default"].css.swing;
var LABEL_LINE_GAP = 4;

var LABEL_LINE_GAP_FUN = function () {
  return _BaseUtils["default"].paddingConvertWithScale(LABEL_LINE_GAP);
};

var TICK_LENGTH = 4;
var TITLE_LABEL_GAP = 4;

var TITLE_LABEL_GAP_FUN = function () {
  return _BaseUtils["default"].paddingConvertWithScale(TITLE_LABEL_GAP);
};

var PADDING = 4;
var TICK_COUNT = 5;
var POINTER_GAUGE_COUNT = 8;
var RADAR_TICK_COUNT = 4;
var MIN_MAX_GAP = 100;
var MAIN_TICK = 'main';
var MINOR_TICKS = 'minor';
var ARROW_SIZE = 15;

var BaseAxis = _Base["default"].extend({
  labelRotation: 0,
  _refresh: function () {
    this.series = []; //for category axis

    this.isRangePoints = true;
    this.piece = null;
    this.forecast = [0, 0]; // trendline period

    this._zoomDomain = this._dataDomain = this._domain = this._tickStart = this._step = 0;

    if (this._firstCalcDomain) {
      this._firstCalcDomain = null;
    }

    this.initScale();
    var options = this.options;
    options.tickPadding = isNaN(options.tickPadding) ? 6 : options.tickPadding;
    options.tickLength = options.enableTick ? isNaN(options.tickLength) ? 4 : options.tickLength : 0;
    options.minorTickLength = options.enableMinorTick ? isNaN(options.minorTickLength) ? 2 : options.minorTickLength : 0;
  },
  //计算坐标轴挤占绘图区的空间
  _calculateSize: function (tickData) {
    var axisOption = this.options;
    this.tickLabelLength = this._getTickLabelLength(tickData);

    var axisTitleLength = this.labelLength = this._getAxisTitleLength();

    axisTitleLength += axisTitleLength > 0 ? TITLE_LABEL_GAP : 0;
    var usedSize = this.tickLabelLength + axisTitleLength;
    var isHorizontal = this.isHorizontal();
    var isInverted = this.vanchart.isInverted();
    var useMaxHeight = (0, _AxisUtils.isUseMaxHeight)(isHorizontal, isInverted);
    !isHorizontal && (usedSize += PADDING);
    /**
     * CHART-1275 解决坐标轴翻转之后设置maxWidth或者maxHeight导致坐标轴消失的问题。
     * 给变量isHorizontal赋值的时候程序已经判断了当前坐标轴最终在屏幕上绘制的方向了，
     * 所以我们只需判断当前轴最终的方向，如果是横向的话，那么计算该轴挤占空间应该使用绘图区的height，
     * 反之使用绘图区的width。
     */

    var calcMaxFunc = isHorizontal ? this._maxHeight : this._maxWidth,
        max = useMaxHeight ? axisOption.maxHeight : axisOption.maxWidth;
    usedSize = max ? Math.min(calcMaxFunc.call(this, max), usedSize) : usedSize;
    this._size = this.series.length === 0 ? 0 : Math.round(usedSize);
  },

  /**
   * 抵消VanChartPool数据表中所占的有待裁剪区域，避免多裁剪了尺寸
   */
  offsetDataSheetClipPoolSize: function () {
    var position = this.getPosition(),
        vanchart = this.vanchart,
        clipPool = vanchart.clipPool;
    var isValueAxis = this.isValue(),
        hasDataSheet = vanchart.getComponent(_component.ComponentCst.DATA_SHEET_COMPONENT);

    if (isValueAxis && hasDataSheet && position === _Constants["default"].LEFT && clipPool[position]) {
      clipPool[position] -= this._size;
    }
  },
  _recordAxisSize: function () {
    if (!this.isOnZero()) {
      this.vanchart.axisSize[this.getPosition()] += this._size;
    }
  },

  /**
   * 计算出当前坐标轴的_dataDomain
   * @param dataDomain  给定的值域
   * @param needConsiderBaseAxisDataDomain 是否需要考虑基础轴的值域：布尔值
   */
  calculateDomainFromData: function (dataDomain, needConsiderBaseAxisDataDomain) {
    if (!dataDomain) {
      this.byPercent = !this._isBaseAxis() && this.isPercentAxis();
      dataDomain = this._getDomainFromData(needConsiderBaseAxisDataDomain);
    } // 为什么要在这里写：排序的时候doLayout不执行，就先放这里了


    if (this.indicator) {
      this._calculateCateDomainData();
    }

    this._dataDomain = dataDomain;
    var zoomTool = this.vanchart.getComponent(_component.ComponentCst.ZOOM_COMPONENT);
    var zoomDomain = this._zoomDomain || zoomTool && zoomTool.getZoomInitDomain(this);
    var customDomain = [this.options.min, this.options.max];
    var fixedDomain = (0, _AxisUtils.getFixedDomain)(customDomain, zoomDomain, this._isBaseAxis());

    this._calculateNiceDomain(this._dataDomain[0], this._dataDomain[1], fixedDomain[0], fixedDomain[1]);

    if (this._isAdjustTopDomain()) {
      this._adjustDomain4TopValue(fixedDomain);
    } // 日期轴计算默认格式


    this._calculateDateFormat && this._calculateDateFormat();
  },
  _calculateNiceDomain: function (minValue, maxValue, fixedMin, fixedMax) {
    var axisOption = this.options;

    if (axisOption.log) {
      return this._calculateLogNiceDomain(minValue, maxValue, fixedMin, fixedMax);
    } else if (this.byPercent) {
      return this._calculatePercentValueDomain(minValue, maxValue, fixedMin, fixedMax);
    } else {
      return this._calculateValueNiceDomain(minValue, maxValue, fixedMin, fixedMax);
    }
  },
  _adjustDomain4TopValue: function (fixedDomain) {
    var minData = this._dataDomain[0],
        maxData = this._dataDomain[1];
    minData = minData < this._domain[0] * 0.95 ? minData * 1.1 : minData;
    maxData = maxData > this._domain[1] * 0.95 ? maxData * 1.1 : maxData;

    if (minData !== this._dataDomain[0] || maxData !== this._dataDomain[1]) {
      this._calculateNiceDomain(minData, maxData, fixedDomain[0], fixedDomain[1]);
    }
  },
  _isAdjustTopDomain: function () {
    return !this._isBaseAxis() && this.series.some(function (ser) {
      return ser.type === _Constants["default"].COLUMN_CHART || ser.type === _Constants["default"].BAR_CHART || ser.type === _Constants["default"].LINE_CHART || ser.type === _Constants["default"].AREA_CHART;
    });
  },
  // todo 先把属性的计算都抽出来，然后再考虑能不能简化属性
  isPercentAxis: function () {
    var series = this.series;
    var isPercent = false;

    for (var i = 0, len = series.length; i < len; i++) {
      isPercent = isPercent || series[i].options.stackByPercent;
    }

    return isPercent;
  },

  /**
   * 图表缩放时判断是否只开启了baseAxis所在的方向的缩放
   * @returns {*|boolean}
   */
  isBaseAxisOnZoomOnly: function () {
    var chartOption = this.vanchart.options,
        zoomType = chartOption.zoom && chartOption.zoom.zoomType;
    return this._isBaseAxis() && zoomType === this.componentType.substr(0, 1);
  },
  calculateDomainFromZoom: function () {
    var zoomDomain = this._zoomDomain,
        cfg = this.options;

    if (this._isBaseAxis()) {
      this._calculateNiceDomain(this._dataDomain[0], this._dataDomain[1], zoomDomain[0], zoomDomain[1]);

      this.isBaseAxisOnZoomOnly() && this.vanchart.reCalcValueAxisDataDomain(this.componentType);
    } else {
      var min = (0, _CoreUtils.hasDefined)(cfg.min) ? Math.max(cfg.min, zoomDomain[0]) : zoomDomain[0];
      var max = (0, _CoreUtils.hasDefined)(cfg.max) ? Math.min(cfg.max, zoomDomain[1]) : zoomDomain[1];

      if (min > max) {
        return;
      }

      var fromZero = this.type === _component.ComponentCst.VALUE_AXIS_COMPONENT && (0, _CoreUtils.hasNotDefined)(cfg.min);
      var baseValue = this.isLog() ? 1 : 0;
      min = fromZero ? Math.min(baseValue, min) : min;
      /**
       * 缩放的时候，对于设置了0值对齐，存在基准轴，且该值轴不是标准轴的情况，就不需要调用_calculateNiceDomain了，
       * 因为当前值轴的domain会在dealOnZero中进行最后显示之前的更新，这里就不做多余的事情了。
       * 由于在上一次的dealOnZero中，为了保证坐标轴的刻度是一个符合人类阅读习惯的数值，就把domain扩展了，
       * 比如[0, 1900]可能会扩展成[0, 2000]，现在获取的zoomDomain是按照[0, 2000]这个区间来获取的，
       * 现在要把它转化成[0, 1900]对应的区间段，这样获得最终区间才不会太离谱！！！
       */

      if (this.alignAxisId && !/^standard/.test(this.alignAxisId) && this._firstCalcDomain) {
        var t = (zoomDomain[0] - this._domain[0]) / (this._domain[1] - this._domain[0]);
        var t1 = (zoomDomain[1] - this._domain[0]) / (this._domain[1] - this._domain[0]);
        min = this._firstCalcDomain[0] + (this._firstCalcDomain[1] - this._firstCalcDomain[0]) * t;
        max = this._firstCalcDomain[0] + (this._firstCalcDomain[1] - this._firstCalcDomain[0]) * t1;
        this._domain = [min, max];
      } else {
        this._calculateNiceDomain.apply(this, [zoomDomain[0], zoomDomain[1], min, max]);
      }
    }
  },
  isCategory: function () {
    return this.type === _component.ComponentCst.CATEGORY_AXIS_COMPONENT;
  },
  isValue: function () {
    return this.type === _component.ComponentCst.VALUE_AXIS_COMPONENT;
  },
  isDate: function () {
    return this.type === _component.ComponentCst.DATE_AXIS_COMPONENT;
  },
  zoomRefresh: function (zoom) {
    this._zoomDomain = zoom;
    this.calculateDomainFromZoom();
  },
  axisZoom: function (downPos, upPos) {
    var startPos,
        endPos,
        isDateAxis = this.type === _component.ComponentCst.DATE_AXIS_COMPONENT,
        det = isDateAxis ? 1000 : 1e-11;
    var plotBounds = this.vanchart.bounds; //坐标轴是横向的

    if (this.isHorizontal()) {
      startPos = Math.min(downPos.x, upPos.x) - plotBounds.x;
      endPos = Math.max(downPos.x, upPos.x) - plotBounds.x;
      startPos = Math.max(startPos, 0);
      endPos = Math.min(endPos, plotBounds.width);
    } else {
      startPos = Math.min(downPos.y, upPos.y) - plotBounds.y;
      endPos = Math.max(downPos.y, upPos.y) - plotBounds.y;
      startPos = Math.max(startPos, 0);
      endPos = Math.min(endPos, plotBounds.height);
    }

    var startValue = this.scale.invert(startPos);
    var endValue = this.scale.invert(endPos);

    if (isDateAxis) {
      startValue = _BaseUtils["default"].date2int(startValue);
      endValue = _BaseUtils["default"].date2int(endValue);
    }

    if (Math.abs(startValue - endValue) < det) {
      return;
    }

    this.zoomRefresh([Math.min(startValue, endValue), Math.max(startValue, endValue)]);
  },
  getAxisValue: function (value) {
    return value;
  },
  getTrendLineForecast: function (sery) {
    var trendLine = sery.options.trendLine;

    if (trendLine && trendLine.period && trendLine.period.length === 2) {
      var period = trendLine.period;
      this.forecast[0] = Math.min(this.forecast[0] || 0, period[0]);
      this.forecast[1] = Math.max(this.forecast[1] || 0, period[1]);
    }
  },
  _getStartAndEndTick: function () {
    return this._domain;
  },
  //即使自动旋转，也能保证这里clip出来的边界够用
  updateClipBounds: function (clipBounds) {
    if (this.series.length === 0) {
      return;
    }

    var startSize, endSize, t_s, t_e;
    var isHorizontal = this.isHorizontal(),
        isReversed = this.isAxisReversed(),
        cfg = this.options;

    if (this.options.showLabel) {
      var tick = this._getStartAndEndTick();

      var tick_0 = tick[0];
      var tick_1 = tick[1];

      if (this.isMultiCateAxis && this.isMultiCateAxis()) {
        var tickArray_0 = _BaseUtils["default"].decodeCategoryArray(tick_0);

        var tickArray_1 = _BaseUtils["default"].decodeCategoryArray(tick_1);

        tick_0 = tickArray_0.length ? tickArray_0[tickArray_0.length - 1] : '';
        tick_1 = tickArray_1.length ? tickArray_1[tickArray_1.length - 1] : '';
      }

      var startDim = this._getTickDim(this._getTickContent(tick_0, cfg.formatter));

      var endDim = this._getTickDim(this._getTickContent(tick_1, cfg.formatter));

      if (isReversed) {
        t_s = endDim;
        t_e = startDim;
      } else {
        t_s = startDim;
        t_e = endDim;
      }

      startSize = isHorizontal ? t_s.width : t_s.height;
      endSize = isHorizontal ? t_e.width : t_e.height; //标签与四周保证有个边距

      startSize = Math.round(startSize / 2) + PADDING;
      endSize = Math.round(endSize / 2) + PADDING;

      if (this.showArrow()) {
        endSize = Math.max(endSize, ARROW_SIZE);
      }
    } else {
      startSize = 0;
      endSize = this.showArrow() ? ARROW_SIZE : 0;
    }

    var plotBounds = this.vanchart.bounds;

    if (isHorizontal) {
      var axisSize = this.vanchart.axisSize;
      var leftDis = axisSize.left + PADDING;
      var rightDis = axisSize.right + PADDING;

      if (this.isCategory() && !this.isRangePoints) {
        var domain = this._zoomDomain || this._dataDomain;
        var rangeBand = (plotBounds.width - axisSize.left - axisSize.right) / domain.length;
        leftDis += Math.round(rangeBand / 2);
        rightDis += Math.round(rangeBand / 2);
      }

      if (this.options.labelRotation <= -15) {
        startSize = Math.round((startSize - PADDING) * 2);
      } else if (this.options.labelRotation >= 15) {
        endSize = Math.round((endSize - PADDING) * 2);
      }

      startSize = Math.max(startSize - leftDis, 0) + PADDING;
      endSize = Math.max(endSize - rightDis, 0) + PADDING + (this.showArrow() ? ARROW_SIZE : 0);
      clipBounds[_Constants["default"].LEFT] = Math.max(clipBounds[_Constants["default"].LEFT] || 0, startSize);
      clipBounds[_Constants["default"].RIGHT] = Math.max(clipBounds[_Constants["default"].RIGHT] || 0, endSize);
    } else {
      clipBounds[_Constants["default"].TOP] = Math.max(clipBounds[_Constants["default"].TOP] || 0, endSize);
      clipBounds[_Constants["default"].BOTTOM] = Math.max(clipBounds[_Constants["default"].BOTTOM] || 0, startSize);
    } //CHART-917 && CHART-2071 && CHART-2118
    // 问题在于裁剪了两次(数据表和左侧值轴:存在重复区域)，之前的计算逻辑是修改dataSheet和yAxis的layout顺序，目的也是在cutPlotBounds之前，就把重复的这部分给剔除，但是那样写会导致
    // dataSheet的unitLength计算过大，从而导致数据表内系列高度计算偏小进而导致系列内容显示不完全，这边不改变布局的顺序，但是在cutPlotBounds之前，判断是否为左侧值轴，然后去除重复的那部分


    this.offsetDataSheetClipPoolSize();
  },
  updateAxisSizeAndBounds: function () {
    this._setComponentBounds(this.getPosition(), this._size);
  },
  fixScaleAndTickData: function () {
    // 留着注释做参考:  使用rangeRound的话，zoom时invert算出的domain只能为整数，在坐标轴极值差 < 1的情况下会出问题
    // this.scale.domain(this._domain).rangeRound(this._getRange());
    this.scale.domain(this._domain).range(this._getRange());

    this._updateOriginTickData();

    this._calculateTickPosAndStep();
  },

  /**
   * FR9.0 的0值对齐的问题处理
   * @param axisList {array} 所有的值轴的数组
   * @returns {array} 处理之后的所有值轴的数组
   * @private
   */
  _alignByZeroValue: function (axisList) {
    var alignId = Date.now() + "" + Math.random() * 100000; // 在这里给每一个值轴做上标记

    axisList.forEach(function (obj, index) {
      index === 0 ? obj.axis.alignAxisId = 'standard' + alignId : obj.axis.alignAxisId = alignId;
    }); // 值轴小于两个直接返回

    if (axisList.length < 2) {
      return axisList;
    } // 现在默认axisList里面的第一个元素就是标准轴


    var standard = axisList[0].axis; // Note: 小夫以前的逻辑是, 从需要对齐的值轴中，找一个作为标准轴, 然后其他的轴和标准轴进行对齐, 而标准轴本身不会发生变化,
    // Note: 这个逻辑应该只适用于存在自定义大小的值轴时, 而对于所有值轴都为设置自定义时, 所有的值轴都应该是可以自动调整对齐的
    // Note: 比如[0, 100]和[-200, 0], 在调整后应该是[-100, 100], [-200, 200]这样, 即满足0值对齐，又能使图形显示完全
    // Note: 这里我们判断一下, 标准轴为自定义大小时, 使用原有逻辑调整, 否则按照自动Domain处理

    if (standard && (standard.options.max != null || standard.options.min != null)) {
      // 更新非标准轴之外的值轴的domain、_step
      return this._forceUpdateAxisDomain(axisList);
    } else {
      return this._dealAutoDomainOnZero(axisList);
    }
  },

  /**
   * 处理0值对齐时自动值轴区间
   * @param axisList
   * @returns {*}
   * @private
   */
  _dealAutoDomainOnZero: function (axisList) {
    var maxNegativeRatio = 0,
        maxPositiveRatio = 0;

    function getAxisDomain(axis) {
      var dataDomain = axis._dataDomain;

      if (dataDomain[0] === dataDomain[1]) {
        return axis._domain;
      }

      return dataDomain;
    } // 第一步, 先计算出每个值轴的正负值占比, 以及最大的正值占比和负值占比


    var npRatios = axisList.map(function (axisObject) {
      var domain = getAxisDomain(axisObject.axis);
      var min = domain[0],
          max = domain[1]; // 同号时, from zero or to zero

      if (max * min >= 0) {
        max = Math.max(0, max);
        min = Math.min(0, min);
      }

      var dis = max - min;
      var negativeRatio = Math.abs(min / dis);
      var positiveRatio = Math.abs(max / dis);
      maxNegativeRatio = Math.max(maxNegativeRatio, negativeRatio);
      maxPositiveRatio = Math.max(maxPositiveRatio, positiveRatio);
      return [negativeRatio, positiveRatio];
    }); // 计算正负值最优比例

    maxPositiveRatio = maxPositiveRatio / (maxPositiveRatio + maxNegativeRatio);
    maxNegativeRatio = maxNegativeRatio / (maxPositiveRatio + maxNegativeRatio);
    var maxPositiveTickCount = 0,
        maxNegativeTickCount = 0; // 要想全部显示且对齐，那么调整后的所有的值轴的区间正负比应该是一致的, 即[maxNegativeRatio, maxPositiveRatio]
    // 我们根据这个比例去从dataDomain中计算出理想的niceDomain和tickInterval

    var preCached = npRatios.map(function (ratio, index) {
      var axis = axisList[index].axis;
      var axisDomain = getAxisDomain(axis);
      var min = axisDomain[0],
          max = axisDomain[1];
      var negativeRatio = ratio[0],
          positiveRatio = ratio[1]; // 同号

      if (max * min >= 0) {
        max = Math.max(0, max);
        min = Math.min(0, min);
      }

      var newMax = max,
          newMin = min; // 调整newMax, newMax / (newMax - newMin) = maxPositiveRatio

      if (negativeRatio > maxNegativeRatio) {
        newMax = newMin * maxPositiveRatio / (maxPositiveRatio - 1);
      } // 调整newMin, -newMin / (newMax - newMin) = maxNegativeRatio


      if (positiveRatio > maxPositiveRatio) {
        newMin = newMax * maxNegativeRatio / (maxNegativeRatio - 1);
      }

      var interval = (0, _AxisUtils.getLinearValidInterval)({
        min: newMin,
        max: newMax,
        interval: axis.options.tickInterval,
        count: axis._getDefaultTickCount(),
        type: axis.type
      }); // Note: 考虑到_linearTickInterval的差异性, 如[-200, 100]和[-12, 6]对应的interval可能为50 & 2, 和domain比例不一致
      // Note: 从而导致了某一侧的默认刻度会比另一侧多, 甚至会跳过0值刻度, 这里我们手动从0开始去向上和向下构造ticks
      // Note: 并记录最大的正值tickCount和最大的负值tickCount, 用以后面强制对齐

      var niceMax = 0,
          niceMin = 0,
          positiveTickCount = 0,
          negativeTickCount = 0; // niceMax >= domain.max

      while (niceMax <= max) {
        niceMax += interval;
        positiveTickCount++;
      } // niceMin <= domain.min


      while (niceMin >= min) {
        niceMin -= interval;
        negativeTickCount++;
      }

      maxPositiveTickCount = Math.max(positiveTickCount, maxPositiveTickCount);
      maxNegativeTickCount = Math.max(negativeTickCount, maxNegativeTickCount); // 这里缓存一下预期的计算结果

      return {
        domain: [niceMin, niceMax],
        tickInterval: interval,
        positiveTickCount: positiveTickCount,
        negativeTickCount: negativeTickCount,
        axis: axis
      };
    }); // 根据maxPositiveTickCount&maxNegativeTickCount, 将不足的值轴标签继续补充, 得出最终的domain & start

    preCached.map(function (cached) {
      var domain = cached.domain,
          tickInterval = cached.tickInterval,
          positiveTickCount = cached.positiveTickCount,
          negativeTickCount = cached.negativeTickCount,
          axis = cached.axis;
      var min = domain[0],
          max = domain[1];
      var i;

      for (i = positiveTickCount; i < maxPositiveTickCount; i++) {
        max += tickInterval;
      }

      for (i = negativeTickCount; i < maxNegativeTickCount; i++) {
        min -= tickInterval;
      } // 这里直接赋值使用, 不走默认的计算逻辑


      axis._domain = [min, max];
      axis._tickStart = min;
      axis._step = tickInterval;
      axis.scale.domain([min, max]);
    });
    return axisList;
  },

  /**
   * 计算出每一个值轴要与标准轴的0刻度对齐需要移动的距离，
   * 然后更新当前值轴的domain、_step、_tickInterval
   * @param axisList
   * @returns {*}
   * @private
   */
  _forceUpdateAxisDomain: function (axisList) {
    var standardAxis = axisList[0].axis;
    var zeroPos = standardAxis.getZeroPos();

    var ticks = standardAxis._getTickValues();

    var self = this;
    axisList.forEach(function (obj, index) {
      if (index === 0) {
        return;
      }

      var axis = obj.axis;
      var max = axis._domain[1],
          min = axis._domain[0],
          originMin = axis._firstCalcDomain ? axis._firstCalcDomain[2] : min,
          originMax = axis._firstCalcDomain ? axis._firstCalcDomain[3] : max;
      var greaterThanZeroTicks = ticks.filter(function (tick) {
        //标准轴上所有大于等于0的刻度
        return tick >= 0;
      });
      var lessThanZeroTicks = ticks.filter(function (tick) {
        // 标准轴上所有小于等于0的刻度
        return tick <= 0;
      });
      calcRatio();
      calcNewMinMax(); // 这里保存下第一次更新值轴的domain使之与标准轴0值对齐之后的domain，
      // 在缩放时，从zoomDomain中计算domain的时候会用上

      if (!axis._firstCalcDomain) {
        axis._firstCalcDomain = [min, max, originMin, originMax];
      } // 这一步重新计算出一个比较好的domain、tickInterval


      axis._calculateNiceDomain(min, max, min, max);

      axis.scale.domain([min, max]).range(axis._getRange()); // 提取出重新计算domain的min和max的部分，要不然太长了

      function calcNewMinMax() {
        if (min === 0) {
          // 使用niceValue函数获取到一个比较符合人类阅读习惯的数值。
          max = _BaseUtils["default"].niceValue(originMax || max, greaterThanZeroTicks.length);
        } else if (max === 0) {
          /**
           * 现在max为0，将min赋值为一个小于0的数值，如果原先没有更新domain之前的min不为0的话，使用它就很好，
           * 但是如果为0的话，就需要重新计算一个符合人类阅读习惯的数值了。
           */
          min = _BaseUtils["default"].niceValue(originMin || min, lessThanZeroTicks.length);
        } else {
          //CHART-1995没有考虑originMax为零的情况，originMax为零时，用originMin计算multiple
          // 坐标轴原始min为0时，使用原始max进行缩放；
          // 坐标轴原始max为0时，使用原始min进行缩放；
          // 坐标轴原始min和原始max都不为0时，以占比较大的原始值为基准进行缩放
          // 保证缩放之后，区域不会减小
          var multiple = originMin === 0 || originMax !== 0 && originMin / originMax > min / max ? _BaseUtils["default"].niceValue(originMax / standardAxis._domain[1], greaterThanZeroTicks.length) : _BaseUtils["default"].niceValue(originMin / standardAxis._domain[0], lessThanZeroTicks.length);
          max = _BaseUtils["default"].accMul(standardAxis._domain[1], multiple);
          min = _BaseUtils["default"].accMul(standardAxis._domain[0], multiple);
        }
      }

      function calcRatio() {
        var innerZeroPos = axis.scale(0),
            // 当前值轴的0刻度与标准轴的0刻度在真实距离上的差值
        distance = innerZeroPos - zeroPos,
            minMaxRange = max - min,
            // 当前值轴在绘图区的范围
        visibleRange = axis._getRange(),
            changeDistance;

        visibleRange = Math.abs(visibleRange[0] - visibleRange[1]); // 计算出当前值轴要让0值与标准轴的0值对齐需要移动的距离

        changeDistance = distance * minMaxRange / visibleRange; // 太多的if，使用真值表来简化

        var sign = 1,
            Y,
            A = axis.vanchart.options.chartType !== _Constants["default"].BAR_CHART,
            B = self.vanchart.isInverted(),
            // 在options的reversed的值
        C = axis.options.reversed;
        Y = A && !B && C || B && !C || !A && !C;
        sign = Y ? sign : -sign; // 下面的注释是未简化之前的代码，还是别删除了，要不然下一个要看懂的话那就太难了。

        /*// 条形图的情况与柱形图、折线图正好相反
        if (axis.vanchart.options.chartType !== Constants.BAR_CHART){
            if( (self.vanchart.isInverted() && !axis.options.reversed)
                || (!self.vanchart.isInverted() && axis.options.reversed)) {
                sign = 1;
            }else {
                sign = -1;
            }
        }else {
            if( (self.vanchart.isInverted() && axis.options.reversed)
                || (!self.vanchart.isInverted() && axis.options.reversed) ) {
                sign = -1;
            }else {
                sign = 1;
            }
        }
        */

        max = _BaseUtils["default"].accAdd(max, changeDistance * sign);
        min = _BaseUtils["default"].accAdd(min, changeDistance * sign);
        /**
         * CHART-1344
         * 上一步的操作在绝大多数的情况下会导致原先的图表超出了图表可视区，
         * 所以下一步的操作就是保证当前值轴能够显示数据点的最高点或者最低点。有的时候不能两者兼顾，
         * 比如标准轴设定了min>=0,那么当前值轴0以下的部分就不能显示了，但是这个时候可以显示所有大于0的数据点。
         *
         */

        Math.abs(min - 0) < 1e-6 && (min = 0);
        Math.abs(max - 0) < 1e-6 && (max = 0);
      }
    });
    return axisList;
  },

  /**
   * 将值轴分类，分为有自定义的，未自定义的以及没有数据挂载的三个类别，
   * 将每一个值轴分类的同时将它们各自的下标也记录下来，最后处理完0值对齐需要将它们重新组合，
   * 新的组合值轴数组要与原来的值轴数组的排列顺序一致
   * @param axisList
   * @returns {{preset: Array, nonPreset: Array, nonSeries: Array}}
   * @private
   */
  _classifyAxis: function (axisList) {
    // 将值轴分成三个部分——有自定义的：preset，未自定义的——nonPreset，没有数据挂载的——nonSeries
    var preset = [],
        nonPreset = [],
        nonSeries = [],
        self = this; // 各种for个if，要缩进不少代码，看起来很困难，就把它们提取到各个函数中去了

    classifyAxisWhileRefresh(axisList);

    if (!preset.length && !nonPreset.length) {
      nonSeries = [];
      classifyAxisWhileInitial(axisList);
    }

    return {
      preset: preset,
      nonPreset: nonPreset,
      nonSeries: nonSeries
    };
    /**
     * 现在只是刷新图表，而不是重绘整个图表的各个组件的时候，这个时候0值对齐的标准轴不会改变，
     * 所以选取classifyAxisWhileInitial函数中得到的标准轴即可。
     * @param axisList
     */

    function classifyAxisWhileRefresh(axisList) {
      var axisObj;

      for (var i = 0, len = axisList.length; i < len; i++) {
        axisObj = {
          axis: axisList[i],
          index: i
        };

        if (axisList[i].alignAxisId) {
          if (/^stand/.test(axisList[i].alignAxisId)) {
            preset.push(axisObj);
          } else {
            nonPreset.push(axisObj);
          }
        } else {
          nonSeries.push(axisObj);
        }
      }
    }
    /**
     * 第一次绘制图表，还没有选取过标准轴，在这里对值轴进行分类。
     * @param axisList
     */


    function classifyAxisWhileInitial(axisList) {
      var onZeroAttr = self.options.onZero,
          axisIndex = onZeroAttr === true ? 0 : onZeroAttr; // options中有onZero: number这样的设置的时候

      onZeroAttr !== true && axisList.forEach(function (axis, i) {
        var obj = {
          axis: axis,
          index: i
        };

        if (i === axisIndex) {
          preset.unshift(obj);
          return;
        }

        if (axis.series.length === 0) {
          nonSeries.push(obj);
        } else {
          nonPreset.push(obj);
        }
      }); // 没有指定需要与哪一个值轴0值对齐的时候

      onZeroAttr === true && axisList.forEach(function (axis, i) {
        var obj = {
          axis: axis,
          index: i
        };
        var options = axis.options;

        if (axis.series.length === 0) {
          nonSeries.push(obj);
        } else if ((0, _CoreUtils.hasDefined)(options.tickInterval) || (0, _CoreUtils.hasDefined)(options.min) || (0, _CoreUtils.hasDefined)(options.max) || (0, _CoreUtils.hasDefined)(options.log)) {
          preset.push(obj);
        } else {
          nonPreset.push(obj);
        }
      }); // 如果所有的值轴中都没有进行自定义，也就时preset.length等于0的时候，
      // 需要从nonPreset里面的之后中寻找一个最适合的值轴作为标准轴。

      if (!preset.length) {
        nonPreset = getStandardAxis(nonPreset);
      }
    } // 根据domain的范围来从axisArray中寻找最合适的之后作为标准轴，
    // 优先顺序是：(min < 0 && max > 0) > (max <= 0, domain小于等于0) > (min >= 0，domain大于等于0)，
    // 如果需要从同一个优先级中筛选出最合适的那一个值轴，就选择tick刻度数量最少的那一个。


    function getStandardAxis(axisArray) {
      if (!axisArray.length) {
        return axisArray;
      } // 根据值轴的domain来划分，如果domain是min<0 && max > 0，则axis属于both，
      // 推算下去，domain的min>=0的时候axis属于pos……


      var both = [],
          pos = [],
          nag = [];

      for (var i = 0, len = axisArray.length; i < len; i++) {
        if (Math.abs(0 - axisArray[i].axis._domain[0]) < 1e-6) {
          pos.push(axisArray[i]);
        } else if (Math.abs(0 - axisArray[i].axis._domain[1]) < 1e-6) {
          nag.push(axisArray[i]);
        } else {
          both.push(axisArray[i]);
        }
      }

      both.sort(sortByTicksNum);
      pos.sort(sortByTicksNum);
      nag.sort(sortByTicksNum);
      return both.concat(nag.concat(pos));

      function sortByTicksNum(a, b) {
        return a.axis.tickData.length - b.axis.tickData.length;
      }
    }
  },

  /**
   * 将已经分类的值轴按照原来的排列顺序重新排列
   * @param classifiedAxis
   * @returns {Array}
   * @private
   */
  _reassembleAxis: function (classifiedAxis) {
    var axisList = classifiedAxis.nonPreset.concat(classifiedAxis.preset.concat(classifiedAxis.nonSeries)); // 按照原来的值轴数组排列顺序重新排序一下

    axisList.sort(function (a, b) {
      return a.index - b.index;
    });
    return axisList.map(function (item) {
      return item.axis;
    });
  },

  /**
   * 具体处理多个值轴0值对齐
   * @param relyOn
   * @private
   */
  _dealOnZeroDetail: function (relyOn) {
    var axisList = this.vanchart.getComponent(relyOn)._axisList; // 0值对齐只能是值轴，分类轴不行


    if (axisList[0].options.type !== 'value') {
      return;
    }

    var classifiedAxis = this._classifyAxis(axisList); // 如果有多个自定义的值轴，那么所有未自定义的值轴与第一个自定义的值轴0值对齐
    // 所以这里将第一个自定义的值轴放到未自定义的值轴数组的首位，在后面的处理中将以它作为标准轴


    if (classifiedAxis.preset.length > 0) {
      var standard = this.findStandardAxisProp(classifiedAxis.preset);

      if ((0, _CoreUtils.hasDefined)(standard)) {
        classifiedAxis.preset.splice(standard.index, 1);
        classifiedAxis.nonPreset.unshift(standard.axisProp);
      }
    } // 现在开始从nonPreset中筛选出与nonPreset[0]有着相同reverse属性的值轴


    classifiedAxis.nonPreset = classifiedAxis.nonPreset.filter(function (obj) {
      var thisReverse = !!obj.axis.options.reversed,
          standardReverse = !!classifiedAxis.nonPreset[0].axis.options.reversed;

      if (thisReverse !== standardReverse) {
        // reversed属性不同则不要进行0值对齐的操作
        classifiedAxis.preset.push(obj);
        return false;
      }

      return true;
    }); // 现在nonPreset数组里面存储的值轴都是0值对齐的值轴，只让它们显示一条gridLine就可以了
    // 要不然有可能绘制出重影的线儿
    // classifiedAxis.nonPreset.forEach(function (obj, index) {
    //     var thisOpt = obj.axis.options,
    //         standardAxisOpt = classifiedAxis.nonPreset[0].axis.options;
    //
    //     if (thisOpt.gridLineWidth !== 0 && index !== 0) {
    //         standardAxisOpt.gridLineWidth = standardAxisOpt.gridLineWidth || 1;
    //         standardAxisOpt.gridLineColor = standardAxisOpt.gridLineColor || thisOpt.gridLineColor;
    //         thisOpt.gridLineWidth = 0;
    //     }
    // });
    // 处理0所有未自定义的值轴0值对齐

    classifiedAxis.nonPreset = this._alignByZeroValue(classifiedAxis.nonPreset);
    axisList = this._reassembleAxis(classifiedAxis); // 对值轴们重新赋值

    this.vanchart.getComponent(relyOn)._axisList = axisList; // 重新计算一下每一个轴的位置、label的大小之类的信息

    _VanChartLayout["default"].calculateAxisBoundsAndClip(this.vanchart);
  },
  dealOnZero: function () {
    var cfg = this.options;
    var relyOn = this.componentType === _component.ComponentCst.X_AXIS_COMPONENT ? _component.ComponentCst.Y_AXIS_COMPONENT : _component.ComponentCst.X_AXIS_COMPONENT;
    cfg.onZero && this._dealOnZeroDetail(relyOn);
  },
  findStandardAxisProp: function (presetAxis) {
    if (presetAxis && presetAxis.length) {
      for (var i = 0, len = presetAxis.length; i < len; i++) {
        var axis = presetAxis[i].axis; // 从基准轴数组中找到第一个非对数的坐标轴和在基准轴数组中的序号

        if ((0, _CoreUtils.hasNotDefined)(axis.options.log)) {
          return {
            axisProp: presetAxis[i],
            index: i
          };
        }
      }
    }
  },

  /**
   * 原本这个函数里面的内容是在dealOnZero函数里面的，但是由于0值对齐为了适应多分类轴的情况，
   * 把它们提出来作为一个单独的函数，减少重复执行的代码。
   * 该函数的作用是更新当前Axis的bounds属性
   * @returns {boolean}
   */
  updateAxisBounds: function () {
    var cfg = this.options;

    if (!cfg.onZero) {
      return false;
    }

    var relyOn = this.getStandardAxis();
    var isFromZero = relyOn && (0, _AxisUtils.isFromZeroAxis)(relyOn);
    var pos = relyOn.getZeroPos();
    var plotBounds = this.vanchart.bounds;
    var x, y, width, height, exceed;

    if (this.isHorizontal()) {
      x = plotBounds.x;
      y = pos + plotBounds.y - (this.getPosition() === _Constants["default"].TOP ? this.bounds.height : 0);
      width = plotBounds.width;
      height = this.bounds.height;
      exceed = y + height > plotBounds.y + plotBounds.height;

      if (!isFromZero && exceed) {
        height = plotBounds.y + plotBounds.height - y;
      }
    } else {
      x = pos + plotBounds.x - (this.getPosition() === _Constants["default"].LEFT ? this.bounds.width : 0);
      y = plotBounds.y;
      width = this.bounds.width;
      height = plotBounds.height;
      exceed = x + width > plotBounds.x + plotBounds.width;

      if (!isFromZero && exceed) {
        width = plotBounds.x + plotBounds.width - x;
      }
    }

    height < 0 && (height = 0);
    width < 0 && (width = 0);
    this.bounds = {
      x: x,
      y: y,
      width: width,
      height: height
    };
  },
  //坐标轴的标签占据的大小
  _getTickLabelLength: function (tickData) {
    var axisOption = this.options; // todo 20/11/2 这里面有个tickPadding用来计算label和line之间的间距（现在设计稿应该是label和tick之间是固定4px），得看看是怎么得到的，看看会不会影响这部分计算

    var tickLength = this._getLabelTickSize(),
        maxLabelLength = 0,
        isHorizontal = this.isHorizontal();

    var textSize = axisOption.labelStyle.fontSize ? axisOption.labelStyle.fontSize : 0; // todo 20/11/2 什么时候才会传入tickData

    if (tickData) {
      tickData.forEach(function (t) {
        var labelDim = t.tickDim;
        maxLabelLength = Math.max(maxLabelLength, isHorizontal ? labelDim.height + (0, _AutoFitUtils.QuarterTextVerPadding)(textSize) * 2 : labelDim.width);
      });
    } else {
      // dim calc duplicated
      // CHART-1454 0值对齐之后的坐标轴的标签显示不全，
      // 是因为_getTickValues函数获取到的是原来的坐标轴的标签，而不是0值对齐之后的标签
      var ticks = this.alignAxisId ? this._getTickValuesAlignByAxis() : this._getTickValues();

      for (var i = 0, len = ticks.length; i < len; i++) {
        var textDim = this._getTickDim(this._getTickContent(ticks[i], axisOption.formatter));

        maxLabelLength = Math.max(maxLabelLength, isHorizontal ? textDim.height + (0, _AutoFitUtils.QuarterTextVerPadding)(textSize) * 2 : textDim.width);
      }
    }

    return tickLength + (axisOption.showLabel ? maxLabelLength : 0);
  },
  _getLabelTitleAndTickSize: function () {
    var size = this._getAxisTitleLength();

    size += size > 0 ? TITLE_LABEL_GAP_FUN() : 0;
    size += this._getLabelTickSize();
    return size;
  },
  _getLabelTickSize: function () {
    var _this$options = this.options,
        showLabel = _this$options.showLabel,
        enableTick = _this$options.enableTick,
        tickPadding = _this$options.tickPadding,
        tickLength = _this$options.tickLength;
    var size = 0;

    if (showLabel) {
      size += isNaN(+tickPadding) ? LABEL_LINE_GAP : tickPadding;
    }

    if (enableTick) {
      size += isNaN(+tickLength) ? TICK_LENGTH : tickLength;
    }

    return size;
  },
  _getTickDim: function (tickContent, usableWidth) {
    // @CHART-10873: 考虑竖直得文字, 需要更改style['writing-mode'], 这里使用统一得方法计算
    return this._calcTickLabelDim(tickContent, usableWidth).labelDim;
  },
  //不考虑step和自动间隔
  _updateOriginTickData: function () {
    var labels = this.alignAxisId ? this._getTickValuesAlignByAxis() : this._getTickValues(),
        axis = this;

    this._calculateLabelRotation(labels);

    this.tickData = [];

    for (var i = 0, len = labels.length; i < len; i++) {
      var tickValue = labels[i];
      this.tickData.push(axis._calculateSingleTickData(tickValue, tickValue));
    }

    this._setPeriod();
  },

  /**
   * 设置初始周期,这边一旦设置，后期的缩放等其他操作，不会对其修改
   * CHART-15773 删除了如果有initperiod就返回的代码，因为监控刷新坐标轴可能变化，导致period不对应
   * @private
   */
  _setPeriod: function () {
    var tickData = this.tickData;

    if (this.isMultiCateAxis && this.isMultiCateAxis()) {
      this._initPeriod = tickData.length > 1 && tickData[0].length > 1 ? [tickData[0][0].tickValue, tickData[0][1].tickValue] : 0;
    } else {
      this._initPeriod = tickData.length > 1 ? [tickData[0].tickValue, tickData[1].tickValue] : 0;
    }
  },

  /**
   * 获取周期的大小(px)
   */
  getPeriodSize: function () {
    var scale = this.scale;
    var period = this._initPeriod;

    if (_BaseUtils["default"].isArray(period)) {
      return Math.abs(scale(period[0]) - scale(period[1]));
    } else {
      // 初始只有一个标签的只可能为rangeBand
      return scale.rangeBand();
    }
  },

  /**
   * 计算标签旋转角度
   * @param  {[type]} labels [description]
   * @return {[type]}        [description]
   */
  _calculateLabelRotation: function (labels) {
    var option = this.options,
        formatter = option.formatter;

    if (!isNaN(option.labelRotation)) {
      this.labelRotation = option.labelRotation;
    } else if (option.autoRotate) {
      this.labelRotation = this.getLabelAutoRotation(labels, option, formatter);
    } else {
      this.labelRotation = 0;
    }
  },

  /**
   * 计算单个tickData
   * @return {[type]} [description]
   */
  _calculateSingleTickData: function (value, content, option, usableWidth) {
    option = option || {};
    var axisOption = this.options,
        formatter = axisOption.formatter,
        rectDim,
        labelDim,
        labelRotation,
        tickGroup,
        shiftGroup;

    var tickContent = this._getTickContent(content, formatter);

    var computed = this._calcTickLabelDim(tickContent, usableWidth);

    rectDim = computed.rectDim;
    labelDim = computed.labelDim;
    tickContent = computed.tickContent;
    labelRotation = computed.labelRotation;
    tickGroup = computed.tickGroup || [];
    shiftGroup = computed.shiftGroup || [];
    return _QueryUtils["default"].merge({
      tickValue: value,
      tickContent: tickContent,
      tickDim: labelDim,
      tickRectDim: rectDim,
      labelRotation: labelRotation,
      tickGroup: tickGroup,
      shiftGroup: shiftGroup
    }, option);
  },

  /**
   * 计算单行显示的标签实际占用尺寸, 需要考虑旋转角度(90度时文字竖直排版), 以及html显示
   */
  _calcTickLabelDim: function (tickContent) {
    var axisOption = this.options,
        useHtml = axisOption.useHtml;
    var style = axisOption.labelStyle || {};

    var tbStyle = _BaseUtils["default"].extend({
      'writingMode': 'tb-rl',
      'writing-mode': 'tb-rl',
      '-webkit-writing-mode': 'vertical-rl'
    }, style);

    if (this.type === _component.ComponentCst.CATEGORY_AXIS_COMPONENT && tickContent) {
      tickContent = (tickContent + '').trim();
    }

    var rectDim,
        labelDim,
        tmpStyle = style; // @CHART-12643：坐标轴标签旋转统一从options上获取

    var labelRotation = axisOption.labelRotation;

    if (Math.abs(labelRotation) === 90 && _BaseUtils["default"].hasChn(tickContent)) {
      labelRotation = 360; // as a log

      tmpStyle = tbStyle;
    }

    rectDim = _BaseUtils["default"].getTextDimension(tickContent, tmpStyle, useHtml);
    labelDim = _BaseUtils["default"].getTextDimRotated(rectDim, labelRotation);

    if (useHtml) {
      labelDim.width = isNaN(parseFloat(axisOption.labelWidth)) ? labelDim.width : parseFloat(axisOption.labelWidth);
      labelDim.height = isNaN(parseFloat(axisOption.labelHeight)) ? labelDim.height : parseFloat(axisOption.labelHeight);
    }

    return {
      rectDim: rectDim,
      labelDim: labelDim,
      tickContent: tickContent,
      labelRotation: labelRotation
    };
  },
  _isBaseAxis: function () {
    if (this.series.length) {
      return this.componentType === this.series[0].getBaseAxisType();
    }

    return false;
  },
  getLabelAutoRotation: function () {
    return 0;
  },
  _getAxisTitleLength: function () {
    var title = this.options.title;

    if (!title || (0, _CoreUtils.isEmpty)(title.text)) {
      return 0;
    }

    var rectDim, dim;
    this.titleRotation = title.rotation;
    var isVerticalText = _BaseUtils["default"].hasChn(title.text) && Math.abs(title.rotation) === 90;

    if (isVerticalText) {
      this.titleRotation = 360;
      title.style = _BaseUtils["default"].extend({
        'writingMode': 'tb-rl',
        'writing-mode': 'tb-rl',
        '-webkit-writing-mode': 'vertical-rl'
      }, title.style);
    }

    rectDim = _BaseUtils["default"].getTextDimension(title.text, title.style, title.useHtml); // 前后台的canvas算位置相差了大概3px，现在前台处理，避免扩大影响

    isVerticalText && (rectDim.height += 3);
    dim = _BaseUtils["default"].getTextDimRotated(rectDim, this.titleRotation);
    this.titleRectDim = rectDim;
    this.titleDim = dim; // todo 20/11/4 这里不应该用title.style.fontSize判断吧

    return this.isHorizontal() ? dim.height + (title.style.fontSize ? (0, _AutoFitUtils.QuarterTextVerPadding)(title.style.fontSize) * 2 : 0) : dim.width;
  },
  //坐标轴占据的空间
  getAxisTitleBounds: function () {
    var bounds = this.bounds;
    var tickLength = this.tickLabelLength + TITLE_LABEL_GAP;
    var labelLength = this.labelLength;
    var position = this.getPosition();
    var x = bounds.x;
    var y = bounds.y;
    var width = bounds.width;
    var height = bounds.height;

    switch (position) {
      case _Constants["default"].LEFT:
        x += width - tickLength - labelLength; // 限制坐标轴尺寸时，标题与标签不应该重叠

        width -= tickLength;
        break;

      case _Constants["default"].BOTTOM:
        y += tickLength;
        height -= tickLength;
        break;

      case _Constants["default"].RIGHT:
        x += tickLength;
        width -= tickLength;
        break;

      case _Constants["default"].TOP:
        y += height - tickLength - labelLength; // 同Left时x计算

        height -= tickLength;
        break;
    }

    return {
      x: x,
      y: y,
      width: Math.max(width, 0),
      height: Math.max(height, 0)
    };
  },
  getTickLength: function () {
    var range = this.scale.range();
    return Math.abs(range[0] - range[1]) / Math.max(this.tickData.length, 1);
  },
  // fixme 100行的function。。有空整理下
  // 这个调整是有条件的，没有缩放，没有自定义的最大最小值
  adjustDomain4Radius: function () {
    if (this.type === _component.ComponentCst.VALUE_AXIS_COMPONENT || this.type === _component.ComponentCst.DATE_AXIS_COMPONENT) {
      var domain = this._getDomain(),
          range = this._getRange(),
          minMax = this._dataDomain,
          isDate = this.type === _component.ComponentCst.DATE_AXIS_COMPONENT,
          bounds = this.vanchart.bounds;

      var originTickWidths = this._getMinMaxTickWidths(domain); // 要考虑对数坐标轴的情况


      var scale = this.options.log ? _Scale["default"].log().base(this.options.log) : _Scale["default"].linear();
      scale.domain(domain).range(range);

      var axis = this,
          isBaseAxis = this._isBaseAxis();

      var downBound = Number.MAX_VALUE,
          upBound = -Number.MAX_VALUE,
          isAdjust = false,
          reversed = axis.isAxisReversed(),
          maxLabelSize = -Number.MAX_VALUE,
          minLabelSize = -Number.MAX_VALUE,
          leftBound = Math.min(scale(domain[0]), scale(domain[1])),
          rightBound = Math.max(scale(domain[0]), scale(domain[1])),
          maxValue = -Number.MAX_VALUE,
          minValue = Number.MAX_VALUE,
          chartSize = Number.MAX_VALUE,
          tmpUpBound,
          tmpDownBound; // fixme 20/11/30 还有自定义图，这个因为有多个值轴，要看看每一个是不是都会走这个adjustdomain4radius去调整，调整完后0值对齐有没有问题

      this.series.map(function (item) {
        if (!item.visible) {
          return;
        } // 这里双值轴指：气泡图、散点图


        if (axis._isDoubleValueAxisChart(item.type)) {
          item.points.map(function (point) {
            var key = axis.componentType === _component.ComponentCst.X_AXIS_COMPONENT ? 'x' : 'y';
            var pos = scale(axis.getAxisValue(point[key], point));

            if (point.isVisible() && !isNaN(pos)) {
              var radius = _BaseUtils["default"].pick(point.radius, point.options.marker && point.options.marker.radius);

              downBound = Math.min(downBound, pos - radius);
              upBound = Math.max(upBound, pos + radius);
            }
          });
        }

        if (axis._isSingleValueAxisChart(item.type)) {
          var points = item.points;

          if (!points.length) {
            return;
          }

          var space = 0; // 做基轴为数值类型轴时调整，图形本身自带宽度可能超出基轴范围情况，如柱子超出x轴最左侧被截断

          if (item.type === _Constants["default"].COLUMN_CHART || item.type === _Constants["default"].BAR_CHART || item.type === _Constants["default"].BOX_CHART) {
            // bar/column/box
            space = isBaseAxis ? item.getSeriesOffsetAndWidth().width / 2 : 0;
          } else if (points[0]) {
            // line/area
            // fixme 不是CHART-16734做的，这么取也是有问题的 如果设置了条件属性第一个options的偏大呢，就会造成误差（主要还是之前标记点没有考虑自定义
            space = points[0].options.marker && points[0].options.marker.radius || item.options.lineWidth;
          }

          var range1 = scale(minMax[0]),
              range2 = scale(minMax[1]);
          var left = Math.min(range1, range2);
          var right = Math.max(range1, range2);

          if (!isNaN(left)) {
            downBound = Math.min(downBound, left - space);
          }

          if (!isNaN(right)) {
            upBound = Math.max(upBound, right + space);
          } // 值轴标签上下截断时扩大范围，不扩大基轴左右的范围，基轴做标签左右调整


          if (!isBaseAxis) {
            var inverted = item.vanchart.isInverted(),
                // todo 20/11/30 checked 组合图也只能统一设置翻转，翻转不用确认了
            isHorValueAxis = axis._isHorizontalValueAxis(item.type, inverted),
                isBar = item.type === _Constants["default"].BAR_CHART;

            var isStack = item.stack || false,
                stackKey = isBar ? 'x' : 'y';
            chartSize = isHorValueAxis ? bounds.width * 0.4 : bounds.height * 0.4;

            if ((0, _CoreUtils.isEmpty)(tmpUpBound) && (0, _CoreUtils.isEmpty)(tmpDownBound)) {
              tmpUpBound = upBound;
              tmpDownBound = downBound;
            }

            points.forEach(function (point) {
              var dataLabels = point.options.dataLabels || {},
                  options = point.options || {},
                  pointValue = isStack ? axis.getAxisValue(options[stackKey], point) + options[stackKey + '0'] - (axis.isLog() ? 1 : 0) : point.value,
                  posPosValue = pointValue >= 0 && !reversed || pointValue < 0 && reversed,
                  labelSize = isHorValueAxis ? point.labelDim.width : point.labelDim.height,
                  gap = isHorValueAxis ? 3 : 2,
                  totalLabelSize = labelSize,
                  borderWidth = options.borderWidth || 0,
                  lineWidth = options.lineWidth || 0,
                  marker = options.marker || {},
                  markerWidth = marker.width || 0,
                  markerHeight = marker.height || 0,
                  markerRadius;
              markerRadius = (markerWidth !== 0 || markerHeight !== 0 ? 0 : marker.radius) || 0; // fixme 这个计算还是有问题的 看看线宽什么的什么时候要加上去，应该算到哪一个情况

              totalLabelSize += borderWidth + markerRadius + (isHorValueAxis ? markerWidth / 2 : markerHeight / 2) + lineWidth + gap;

              if (!axis._isAutoAdjustAxis4Label(dataLabels, item.type)) {
                return;
              }

              if (dataLabels.align === _Constants["default"].AUTO) {
                if (item.type === _Constants["default"].BAR_CHART) {
                  // 产品确认：条形图标签自动不调整值域
                  totalLabelSize = 0;
                }

                if (item.type === _Constants["default"].COLUMN_CHART) {
                  if (isHorValueAxis) {
                    totalLabelSize = posPosValue ? totalLabelSize : -totalLabelSize;
                  } else {
                    totalLabelSize = posPosValue ? -totalLabelSize : totalLabelSize;
                  }
                }

                if (item.type === _Constants["default"].LINE_CHART || item.type === _Constants["default"].AREA_CHART) {
                  totalLabelSize = isHorValueAxis ? totalLabelSize : -totalLabelSize;
                }
              } else if (dataLabels.align === _Constants["default"].TOP) {
                totalLabelSize = isHorValueAxis ? totalLabelSize : -totalLabelSize;
              } else if (dataLabels.align === _Constants["default"].BOTTOM) {
                totalLabelSize = isHorValueAxis ? -totalLabelSize : totalLabelSize;
              } else {
                if (isHorValueAxis) {
                  totalLabelSize = posPosValue ? totalLabelSize : -totalLabelSize;
                } else {
                  totalLabelSize = posPosValue ? -totalLabelSize : totalLabelSize;
                }
              } // 设置最大最小值不用在这里过滤，calculateNiceDomain里面会使用设置的最大最小值


              if (!isNaN(left)) {
                downBound = Math.min(downBound, isNaN(scale(pointValue) + totalLabelSize) ? Number.MAX_VALUE : scale(pointValue) + totalLabelSize);

                if (!isAdjust) {
                  isAdjust = downBound <= leftBound ? true : false;
                }
              }

              if (!isNaN(right)) {
                upBound = Math.max(upBound, isNaN(scale(pointValue) + totalLabelSize) ? -Number.MAX_VALUE : scale(pointValue) + totalLabelSize);

                if (!isAdjust) {
                  isAdjust = upBound >= rightBound ? true : false;
                }
              }

              pointValue <= minValue ? (minValue = pointValue, minLabelSize = labelSize) : '';
              pointValue >= maxValue ? (maxValue = pointValue, maxLabelSize = labelSize) : '';
            });
          }
        }
      });

      if (isAdjust) {
        minValue < 0 && minLabelSize > chartSize ? (downBound = tmpDownBound, upBound = tmpUpBound) : '';
        maxLabelSize > chartSize ? (downBound = tmpDownBound, upBound = tmpUpBound) : '';
      }

      if (downBound === Number.MAX_VALUE || upBound === -Number.MAX_VALUE) {
        return;
      }

      var b1 = scale.invert(downBound),
          b2 = scale.invert(upBound);

      if (isDate) {
        b1 = _BaseUtils["default"].date2int(b1);
        b2 = _BaseUtils["default"].date2int(b2);
      }

      if ((0, _AxisUtils.isInDomainValue)(this._domain, b1) && (0, _AxisUtils.isInDomainValue)(this._domain, b2)) {
        return;
      }

      this.calculateDomainFromData([Math.min(Math.min(b1, b2), minMax[0]), Math.max(Math.max(b1, b2), minMax[1])]);

      var tickWidths = this._getMinMaxTickWidths(this._getDomain());

      if (tickWidths[0] !== originTickWidths[0] || tickWidths[1] !== originTickWidths[1]) {
        return true;
      }
    }
  },
  _getMinMaxTickWidths: function (domain) {
    var formatter = this.options.formatter;

    var content1 = this._getTickContent(domain[0], formatter);

    var content2 = this._getTickContent(domain[1], formatter);

    return [this._getTickDim(content1), this._getTickDim(content2)];
  },
  _isDoubleValueAxisChart: function (chartType) {
    return chartType === _Constants["default"].BUBBLE_CHART || chartType === _Constants["default"].SCATTER_CHART;
  },
  _isSingleValueAxisChart: function (chartType) {
    return chartType === _Constants["default"].COLUMN_CHART || chartType === _Constants["default"].BAR_CHART || chartType === _Constants["default"].BOX_CHART || chartType === _Constants["default"].LINE_CHART || chartType === _Constants["default"].AREA_CHART;
  },
  _isAutoAdjustAxis4Label: function (dataLabels, chartType) {
    return (dataLabels.align === _Constants["default"].OUTSIDE || dataLabels.align === _Constants["default"].AUTO || dataLabels.align === _Constants["default"].TOP || dataLabels.align === _Constants["default"].BOTTOM) && chartType !== _Constants["default"].BOX_CHART && dataLabels.enabled;
  },
  _isHorizontalValueAxis: function (chartType, inverted) {
    return chartType === _Constants["default"].BAR_CHART && !inverted || chartType !== _Constants["default"].BAR_CHART && inverted;
  },
  // 为了搞缩放、平移，axis采取了不同的策略：
  // 分类轴是离散的，domain的变化只能一个一个category变，所以要变动range大小；tick是确定的。
  // 值轴是连续的，可以看作是domain一直在变，range保持可视区域大小；并且要重新算可视区域内tick，只能变domain。
  // For pinch zoom, get the whole range even exceed the visible area.
  // Used by category axis `_getPlotRange`.
  getWholeRange: function () {
    var plotBounds = this.vanchart.getPlotContentBounds();
    var left = plotBounds.x,
        right = plotBounds.x + plotBounds.width,
        top = plotBounds.y,
        bottom = plotBounds.y + plotBounds.height;

    if (this.isHorizontal()) {
      return this.isAxisReversed() ? [right, left] : [left, right];
    } else {
      return this.isAxisReversed() ? [top, bottom] : [bottom, top];
    }
  },
  _getDomain: function () {
    return this.type === _component.ComponentCst.DATE_AXIS_COMPONENT ? [_BaseUtils["default"].date2int(this._domain[0]), _BaseUtils["default"].date2int(this._domain[1])] : this._domain;
  },
  _getRange: function () {
    return this._getPlotRange();
  },
  // It's visible range.
  // Used by value axis `_getPlotRange`.
  _getPlotRange: function () {
    var plotBounds = this.vanchart.bounds;
    var left = 0,
        right = plotBounds.width,
        top = 0,
        bottom = plotBounds.height;

    if (this.isHorizontal()) {
      return this.isAxisReversed() ? [right, left] : [left, right];
    } else {
      return this.isAxisReversed() ? [top, bottom] : [bottom, top];
    }
  },
  isPlotRangeWithMarker: function () {
    return this.vanchart.seriesOfType(_Constants["default"].AREA_CHART).length > 0 && this.options.type === _component.ComponentCst.CATEGORY_AXIS_COMPONENT;
  },
  getPlotRangePadding: function () {
    return this.isPlotRangeWithMarker() ? this._getMaxMarkerRadius(this.vanchart, _Constants["default"].AREA_CHART) : 0;
  },
  _getMaxMarkerRadius: function (vanchart, type) {
    var plotOptions = vanchart.options.plotOptions,
        _options = plotOptions[type];
    var plotOptionsMarker = _options && _options.marker || plotOptions.marker;

    var markerRadius = function (marker) {
      if ((0, _CoreUtils.hasNotDefined)(marker)) {
        return 0;
      }

      var symbol = marker.symbol;

      if (_BaseUtils["default"].isImageMarker(symbol) && marker.width) {
        return marker.width / 2;
      }

      if (symbol === _Constants["default"].SYMBOL_AUTO) {
        return _Constants["default"].MARKER_RADIUS;
      }

      return symbol && marker.radius || 0;
    };

    var maxRadius = markerRadius(plotOptionsMarker);
    var _vanchart$options$ser = vanchart.options.series,
        series = _vanchart$options$ser === void 0 ? [] : _vanchart$options$ser;

    for (var i = 0; i < series.length; i++) {
      var ser = series[i];

      if (ser.type !== type) {
        continue;
      }

      var data = ser.data || [];
      data.forEach(function (item) {
        maxRadius = Math.max(maxRadius, markerRadius(item.marker));
      });
      maxRadius = Math.max(maxRadius, markerRadius(ser.marker));
    }

    return (maxRadius || _Constants["default"].MARKER_RADIUS) + 2; // 预留鼠标悬浮选中增加的2px
  },
  _getPlotBands: function () {
    var plotBands = this.options.plotBands;
    var scale = this.scale;
    var isRangeBand = !!(scale.rangeBand && scale.rangeBand());
    var multiCategory = this.isMultiCateAxis();

    if (typeof plotBands === 'string') {
      var color = plotBands;
      plotBands = [];

      var labels = this._getTickValuesWithEndValue();

      labels = multiCategory ? labels[0].map(function (label) {
        return label.tickValue;
      }) : labels;
      var endIndex = isRangeBand ? -1 : 0;

      for (var index = labels.length - 1; index > endIndex; index -= 2) {
        plotBands.push({
          color: color,
          from: isRangeBand ? labels[index] : labels[index - 1],
          to: labels[index]
        });
      }
    } else {
      plotBands = plotBands || [];
      var result = [];

      for (var i = 0, count = plotBands.length; i < count; i++) {
        var t_bands = plotBands[i];

        if (multiCategory) {
          t_bands.from = _BaseUtils["default"].encodeCategoryArray(t_bands.from);
          t_bands.to = _BaseUtils["default"].encodeCategoryArray(t_bands.to);
        }

        if ((0, _CoreUtils.hasDefined)(t_bands.from) && (0, _CoreUtils.hasDefined)(t_bands.to)) {
          result.push(t_bands);
        }
      }

      plotBands = result;
    }

    return plotBands;
  },
  _getTickValuesWithEndValue: function () {
    var result = this._getTickValues();

    var max = this._domain[1],
        isDate = this.type === _component.ComponentCst.DATE_AXIS_COMPONENT;

    if (result.length) {
      var maxInList = result[result.length - 1];

      if (isDate) {
        if (_BaseUtils["default"].date2int(maxInList) < max) {
          result.push(_BaseUtils["default"].int2date(max));
        }
      } else {
        if (maxInList < max) {
          result.push(max);
        }
      }
    }

    return result;
  },
  //画的时候计算自定义标签间隔等
  getTickData: function () {
    return this.tickData;
  },
  // 获取次要刻度数据
  getMinorTickData: function (ticksNum) {
    if (this.options.enableMinorTick && this.tickData.length) {
      if (this.isCategory()) {
        return this._getCategoryMinorTickData(ticksNum);
      }

      return this._getValueMinorTickData(ticksNum);
    }

    return [];
  },
  _getCategoryMinorTickData: function (ticksNum) {
    var minorTickData = [];
    var mainTickData = this.getTickData();
    var mainTickSize = this.getTickLength();
    var minorTicksNum = ticksNum || TICK_COUNT;
    var minorTickLength = Math.round(mainTickSize / minorTicksNum);
    var sortedTickData = mainTickData.sort(function (a, b) {
      return a.tickPos - b.tickPos;
    });
    var endIndex = this.isRangePoints ? mainTickData.length - 1 : mainTickData.length;

    for (var i = 0; i < endIndex; i++) {
      var startPos = sortedTickData[i].tickPos;

      for (var j = 1; j < minorTicksNum; j++) {
        minorTickData.push(startPos + minorTickLength * j);
      }
    }

    return minorTickData;
  },
  _getValueMinorTickData: function (ticksNum) {
    var cfg = this.options;
    var interval = this._step;
    var minorTicksNum = ticksNum || TICK_COUNT;
    var minorInterval = cfg.minorTickInterval ? +cfg.minorTickInterval : interval / minorTicksNum;

    if (!this._isValidMinorTickInterval(minorInterval)) {
      return [];
    }

    var preMinorTickData = this._getPreValueMinorTickData(minorInterval);

    var midMinorTickData = this._getMidValueMinorTickData(minorInterval);

    var sufMinorTickData = this._getSufValueMinorTickData(minorInterval);

    return preMinorTickData.concat(midMinorTickData).concat(sufMinorTickData);
  },
  _isValidMinorTickInterval: function (minorInterval) {
    var _this$scale$domain = this.scale.domain(),
        start = _this$scale$domain[0],
        end = _this$scale$domain[1];

    if ((0, _CoreUtils.isNumberValue)(minorInterval) && Math.abs(minorInterval) > 1e-6) {
      return Math.abs(end - start) / minorInterval < _Constants["default"].MAX_MINOR_TICKS_NUM;
    }
  },
  // 计算主刻度之间的次刻度
  _getMidValueMinorTickData: function (minorInterval) {
    var minorTickData = [];
    var mainTickData = this.getTickData();

    for (var i = 0, len = mainTickData.length - 1; i < len; i++) {
      var start = mainTickData[i].tickValue;
      var end = mainTickData[i + 1].tickValue;
      var isDate = start instanceof Date && end instanceof Date;
      start = isDate ? _BaseUtils["default"].date2int(start) : start;
      end = isDate ? _BaseUtils["default"].date2int(end) : end; // 次刻度标签中不包含两边的主刻度

      for (var value = _BaseUtils["default"].accAdd(start, minorInterval); value < end; value = _BaseUtils["default"].accAdd(value, minorInterval)) {
        minorTickData.push(isDate ? _BaseUtils["default"].int2date(value) : value);
      }
    }

    return minorTickData;
  },
  // 计算最后一个主刻度之后的次刻度
  _getSufValueMinorTickData: function (minorInterval) {
    var minorTickData = [];
    var mainTickData = this.getTickData();
    var endValue = mainTickData[mainTickData.length - 1].tickValue;
    var maxValue = this.scale.domain()[1];
    var isDate = endValue instanceof Date && maxValue instanceof Date;
    endValue = isDate ? _BaseUtils["default"].date2int(endValue) : endValue;
    maxValue = isDate ? _BaseUtils["default"].date2int(maxValue) : maxValue;

    if (endValue < maxValue) {
      // 次刻度包含右边界
      for (var value = endValue + minorInterval; value <= maxValue; value += minorInterval) {
        minorTickData.push(isDate ? _BaseUtils["default"].int2date(value) : value);
      }
    }

    return minorTickData;
  },
  // 计算第一个主刻度之前的次刻度
  _getPreValueMinorTickData: function (minorInterval) {
    var minorTickData = [];
    var mainTickData = this.getTickData();
    var startValue = mainTickData[0].tickValue;
    var minValue = this.scale.domain()[0];
    var isDate = startValue instanceof Date && minValue instanceof Date;
    startValue = isDate ? _BaseUtils["default"].date2int(startValue) : startValue;
    minValue = isDate ? _BaseUtils["default"].date2int(minValue) : minValue;

    if (startValue > minValue) {
      // 次刻度包含左边界
      for (var value = startValue - minorInterval; value >= minValue; value -= minorInterval) {
        minorTickData.push(isDate ? _BaseUtils["default"].int2date(value) : value);
      }
    }

    return minorTickData;
  },
  getMaxTickWidth: function () {
    var maxWidth = 0; // CHART-1141
    // options中设置了不显示tickLabel，但是仍然会占位，
    // 这里判断一下，如果不显示tickLabel的话，直接返回0吧。

    if (!this.options.showLabel) {
      return maxWidth;
    }

    this.tickData.forEach(function (data) {
      maxWidth = Math.max(maxWidth, data.tickDim.width);
    });
    return maxWidth;
  },
  getTickHeight: function () {
    if (this.options.labelStyle && this.options.showLabel) {
      return (0, _EnvUtils.getTextHeight)(this.options.labelStyle);
    }

    return 0;
  },
  _calculateTickPosAndStep: function () {
    var axisOption = this.options,
        scale = this.scale,
        tickInterval = this.getTickLength();
    var isInterval = axisOption.labelDisplay === _Constants["default"].INTERVAL;
    var det = scale.rangeBand ? scale.rangeBand() / 2 : 0;
    var tickData = this.getTickData(),
        index;
    tickData.forEach(function (t) {
      t.tickPos = scale(t.tickValue);
      t.tickLabelPos = t.tickPos + det;
    }); // 标签显示共五种情况：隐藏标签、标签固定间隔、标签自动间隔、缩略显示、换行显示

    if (!axisOption.showLabel) {
      tickData.forEach(function (t) {
        t.tickContent = '';
      });
      return;
    } // 间隔显示


    if (isInterval) {
      // 固定间隔
      if (axisOption.step) {
        index = 0;
        tickData.forEach(function (t) {
          if (index++ % axisOption.step) {
            t.tickContent = '';
          }
        });
      } else {
        // 自动间隔
        var isHorizontal = this.isHorizontal(),
            testStep = 1,
            longestStep = 1; // label rotated [15-90) can as long as it can
        // otherwise check the dim

        var labelRotation = Math.abs(Math.abs(this.labelRotation) - (isHorizontal ? 0 : 90)),
            isRotated = labelRotation >= 15 && labelRotation !== 90,
            labelRadian;
        labelRadian = _BaseUtils["default"].toRadian(labelRotation);
        var lastTickPos,
            lastH = -1,
            gap,
            l,
            h,
            sin = Math.sin(labelRadian);
        tickData.forEach(function (t) {
          if (t.tickContent === '') {
            return;
          }

          if (isRotated) {
            h = t.tickRectDim.height;
            gap = Math.abs(t.tickPos - lastTickPos);
            l = (h + lastH) / 2;

            if (l < gap * sin || lastH === -1) {
              testStep = 1;
              lastTickPos = t.tickPos;
              lastH = h;
            } else {
              testStep++;
              longestStep = Math.max(longestStep, testStep);
            }
          } else {
            var testLength = isHorizontal ? t.tickDim.width : t.tickDim.height;

            if (tickInterval) {
              longestStep = Math.max(longestStep, Math.ceil(testLength / tickInterval));
            }
          }
        });
        index = 0;
        tickData.forEach(function (t) {
          if (index++ % longestStep) {
            t.tickContent = '';
          }
        });
      }
    }
  },
  _getAxisOriginPoint: function () {
    var axisBounds = this.bounds;
    var position = this.getPosition();
    var x, y;

    switch (position) {
      case _Constants["default"].TOP:
        x = axisBounds.x;
        y = axisBounds.y + axisBounds.height;
        break;

      case _Constants["default"].BOTTOM:
        x = axisBounds.x;
        y = axisBounds.y;
        break;

      case _Constants["default"].LEFT:
        x = axisBounds.x + axisBounds.width;
        y = axisBounds.y;
        break;

      case _Constants["default"].RIGHT:
        x = axisBounds.x;
        y = axisBounds.y;
        break;
    }

    return {
      x: x,
      y: y
    };
  },
  getPosition: function () {
    var defaultPosition = this.componentType === _component.ComponentCst.X_AXIS_COMPONENT ? 'bottom' : 'left';
    var position = this.options.position || defaultPosition;

    if (this.vanchart.isInverted()) {
      switch (position) {
        case _Constants["default"].TOP:
          return _Constants["default"].RIGHT;

        case _Constants["default"].RIGHT:
          return _Constants["default"].BOTTOM;

        case _Constants["default"].BOTTOM:
          return _Constants["default"].LEFT;

        case _Constants["default"].LEFT:
          return _Constants["default"].TOP;
      }
    } else {
      return position;
    }
  },
  isAxisReversed: function () {
    if (this.componentType === _component.ComponentCst.X_AXIS_COMPONENT && this.vanchart.isInverted()) {
      return !this.options.reversed;
    }

    return this.options.reversed;
  },
  isOnZero: function () {
    return this.options.onZero;
  },
  getLineWidth: function () {
    return this.options.lineWidth;
  },
  showArrow: function () {
    return this.options.showArrow;
  },
  getTitleAlign: function () {
    var title = this.options.title;

    if (!title) {
      return null;
    }

    var align = title.align || 'center';

    if (this.vanchart.isInverted()) {
      switch (align) {
        case _Constants["default"].TOP:
          return _Constants["default"].RIGHT;

        case _Constants["default"].RIGHT:
          return _Constants["default"].BOTTOM;

        case _Constants["default"].BOTTOM:
          return _Constants["default"].LEFT;

        case _Constants["default"].LEFT:
          return _Constants["default"].TOP;
      }
    }

    return align;
  },
  _calculateLogNiceDomain: function (minValue, maxValue, fixedMin, fixedMax) {
    var axisOption = this.options,
        logBase = axisOption.log;
    minValue = minValue >= 1 ? 1 : minValue;
    minValue = minValue <= 0 ? 1 : minValue;
    /**
     * CHART-1250
     * fixedMin在(0, 1)区间的时候会被保留下来，而fixedMax如果小于fixedMin的话，
     * 直接设置为undefined，计算domain的时候使用maxValue好了，因为maxValue一定是存在的，
     * 除非options的数据有问题。
     */
    //改正：大于等于1的保留

    fixedMin = fixedMin <= 0 ? 1 : fixedMin;
    fixedMax = fixedMax <= fixedMin ? undefined : fixedMax;
    minValue = _BaseUtils["default"].pick(fixedMin, minValue);
    maxValue = _BaseUtils["default"].pick(fixedMax, maxValue);
    minValue = Math.pow(logBase, Math.floor(_BaseUtils["default"].log(logBase, minValue)));
    maxValue = Math.pow(logBase, Math.ceil(_BaseUtils["default"].log(logBase, maxValue)));
    this._domain = [minValue, maxValue];
    this._tickStart = minValue;
    this._step = (0, _AxisUtils.getLogValidInterval)(minValue, maxValue, logBase, axisOption.tickInterval);
  },
  _calculatePercentValueDomain: function (minValue, maxValue, fixedMin, fixedMax) {
    var axisOption = this.options,
        min = _BaseUtils["default"].pick(fixedMin, 0),
        max = _BaseUtils["default"].pick(fixedMax, 1);

    var interval = (0, _AxisUtils.getPercentValidInterval)(min, max, axisOption.tickInterval);
    this._domain = [min, max];

    if (this.vanchart.isMobileFlow()) {
      this._tickStart = 0;
      this._step = interval;
    } else {
      this._tickStart = min;
      this._step = interval;
    }
  },
  //普通的值轴
  _calculateValueNiceDomain: function (minValue, maxValue, fixedMin, fixedMax) {
    // CHART-1382
    // 仪表盘的数据如果没有自定义并且都是正数的话，fromZero也应该为true，
    // 但是gaugeAxis.isBaseAxis()函数返回的是true，结果就GG了
    var fromZero = this.type === _component.ComponentCst.VALUE_AXIS_COMPONENT && !this._isBaseAxis() || this.componentType === 'gaugeAxis';
    var axisOption = this.options; // 缓存一下

    var isDefinedMin = (0, _CoreUtils.hasDefined)(fixedMin),
        isDefinedMax = (0, _CoreUtils.hasDefined)(fixedMax);

    if (fromZero) {
      if (minValue > 0) {
        minValue = 0;
      } else if (maxValue < 0) {
        maxValue = 0;
      }
    }

    minValue = isDefinedMin ? fixedMin : minValue;
    maxValue = isDefinedMax ? fixedMax : maxValue; // if any exceeded min, adjust max to min + 100

    if (minValue >= maxValue) {
      maxValue = minValue + MIN_MAX_GAP * (this.type === _component.ComponentCst.DATE_AXIS_COMPONENT ? 1000 : 1);
    }

    var tickInterval = (0, _AxisUtils.getLinearValidInterval)({
      min: minValue,
      max: maxValue,
      interval: axisOption.tickInterval,
      count: this._getDefaultTickCount(),
      type: this.type
    });
    var domain = (0, _AxisUtils.getIntegerNiceDomain)(minValue, maxValue, tickInterval);
    minValue = isDefinedMin ? fixedMin : domain[0];
    maxValue = isDefinedMax ? fixedMax : domain[1];

    if (minValue >= maxValue) {
      maxValue = minValue + MIN_MAX_GAP * (this.type === _component.ComponentCst.DATE_AXIS_COMPONENT ? 1000 : 1);
    }

    var start = domain[0];

    if (isDefinedMin) {
      // ceil( (fixedMin - start) / tickInterval ) * tickInterval
      var diff = _BaseUtils["default"].accMul(Math.ceil(_BaseUtils["default"].accDiv(_BaseUtils["default"].accAdd(fixedMin, -start), tickInterval)), tickInterval);

      start = _BaseUtils["default"].accAdd(start, diff);
    }

    this._domain = [minValue, maxValue];
    this._tickStart = start;
    this._step = tickInterval; // CHART-1142
    // 值轴在开启趋势线之后同时也应该更新定义域domain

    this._extendDomainWithForecastRange(isDefinedMin, isDefinedMax);
  },

  /**
   * 开启趋势线之后，同时更新轴的定义域。
   * @param isDefinedMin
   * @param isDefinedMax
   * @returns {boolean}
   * @private
   */
  _extendDomainWithForecastRange: function (isDefinedMin, isDefinedMax) {
    var isBaseAxis = this._isBaseAxis(),
        isCategoryAxis = this.options.type === 'category',
        isSupportForecast = function (series) {
      // 如果检测到系列开启了趋势线，那么就会立即返回true
      return series.some(function (sery) {
        var trendLine = sery.options.trendLine;
        return trendLine && trendLine.period && trendLine.period.length === 2;
      });
    }(this.series);
    /**
     * 三种情况下不更新定义域
     * 1、不是基础轴，
     * 2、没有设置开启趋势线，
     * 3、不是值轴或者时间轴
     */


    if (!isBaseAxis || !isSupportForecast || isCategoryAxis) {
      return false;
    } // 只有在定义域中没有主动设置最大值和最小值的时候才去更新domain


    if (!isDefinedMin) {
      this._domain[0] = _BaseUtils["default"].accAdd(this._domain[0], _BaseUtils["default"].accMul(this.forecast[0], this._step));
      this._tickStart = _BaseUtils["default"].accAdd(this._tickStart, _BaseUtils["default"].accMul(this.forecast[0], this._step));
    }

    if (!isDefinedMax) {
      this._domain[1] = _BaseUtils["default"].accAdd(this._domain[1], _BaseUtils["default"].accMul(this.forecast[1], this._step));
    }
  },
  _getDefaultTickCount: function () {
    var options = this.vanchart.options;
    return options.chartType === _Constants["default"].RADAR_CHART ? RADAR_TICK_COUNT : this.series[0] && this.series[0].gaugeType === _Constants["default"].POINTER_GAUGE ? POINTER_GAUGE_COUNT : TICK_COUNT;
  },
  getIndexByPosition: function (pos) {
    var plotBounds = this.getPlotBounds();
    var scale = this.scale;
    var startX = scale(this.isAxisReversed() ? scale.domain()[scale.domain().length - 1] : scale.domain()[0]);
    var x;

    if (this.isHorizontal()) {
      x = pos[0] - plotBounds.x - startX;
    } else {
      x = pos[1] - plotBounds.y - startX;
    }

    var index;

    switch (this.type) {
      case _component.ComponentCst.DATE_AXIS_COMPONENT:
        index = _BaseUtils["default"].date2int(scale.invert(x));
        break;

      default:
        index = scale.invert(x);
    }

    index = Math.round(index);
    return index;
  },
  _valueInDomain: function () {
    return true;
  },
  render: function () {
    this.lastScale = this.scale && this.scale.copy();
    var vanchart = this.vanchart,
        renderer = vanchart.renderer;

    if (!this.axisGroup) {
      renderer.clip(this.clipAxisGroup = this.createComponentGroup(), vanchart.plotClip);
      this.axisGroup = this.createComponentGroup();
    } //clip的显示区域


    var b = this.bounds;
    var clipBounds = {
      x: b.x,
      y: b.y,
      width: b.width,
      height: b.height
    };

    if (this.isHorizontal()) {
      clipBounds.x = 0;
      clipBounds.width = vanchart.width;

      if (clipBounds.y < vanchart.bounds.y && this.options.onZero) {
        clipBounds.y = vanchart.bounds.y;
      }
    } else {
      clipBounds.y = 0;
      clipBounds.height = vanchart.height;

      if (clipBounds.x + clipBounds.width > vanchart.bounds.x + vanchart.bounds.width && this.options.onZero) {
        clipBounds.width = vanchart.bounds.x + vanchart.bounds.width - clipBounds.x;
      }

      clipBounds.width < 0 && (clipBounds.width = 0);
    }

    if (!this.axisGroupClip) {
      this.axisGroupClip = renderer.createClip(clipBounds);
      renderer.clip(this.axisGroup, this.axisGroupClip);
    } else {
      renderer.updateClip(this.axisGroupClip, clipBounds);
    } // 缓存下裁剪的位置


    this.clipBounds = clipBounds;

    if (!this.axisLineGroup) {
      this.axisLineGroup = renderer.group().addTo(vanchart.seriesGroup);
    } // 没有数据时，不绘制任何轴线


    if (this.series.length === 0) {
      this.remove();
      return;
    }

    this._drawPlotBands();

    this._drawGridLine();

    if (this.isNeedDrawAxis()) {
      this._drawTickLine();

      this._drawTickLabel();

      this._drawAxisLine();

      this._drawAxisTitle();

      this._drawPlotLines();
    } // CHART-1164
    // 图表设置了tootip shared===true,每当resize、重新绘制坐标轴的时候都检查一下resize之前图表是否还在显示系列高亮背景，
    // 是的话就在resize之后也绘制这个高亮背景。


    this._lastSharedPoints && this.drawHighlightBackground(this._lastSharedPoints);
  },
  isLog: function () {
    return this.options.log;
  },

  /**
   * CHART-1543
   * 判断是否需要绘制坐标轴，这个判断逻辑不是判断坐标轴是否在绘图区，
   * 而是判断在当前轴是否设置了0值对齐，如果它对齐的值轴设置了min>0或者max<0，那么就不显示坐标轴了。
   */
  isNeedDrawAxis: function () {
    var onZero = this.options.onZero,
        index = onZero === true ? 0 : onZero,
        relyOnAxis = this.componentType === _component.ComponentCst.X_AXIS_COMPONENT ? _component.ComponentCst.Y_AXIS_COMPONENT : _component.ComponentCst.X_AXIS_COMPONENT,
        // 默认是显示坐标轴的
    result = true; // 没有设置0值对齐，直接返回true

    if (!onZero) {
      return result;
    }

    relyOnAxis = this.vanchart[relyOnAxis](index); // 判断relyOnAxis的是否有min>0 或者 max < 0

    if (relyOnAxis.options.min > 0 || relyOnAxis.options.max < 0) {
      result = false;
    }

    return result;
  },
  getZeroPos: function () {
    switch (this.type) {
      case _component.ComponentCst.VALUE_AXIS_COMPONENT:
        return this.isLog() ? this.scale(1) : this.scale(0);

      case _component.ComponentCst.DATE_AXIS_COMPONENT:
        return this.scale(_BaseUtils["default"].int2date(0));

      case _component.ComponentCst.CATEGORY_AXIS_COMPONENT:
        return 0;
    }
  },
  _drawPlotBands: function () {
    var plotBands = this._getPlotBands(),
        scale = this.scale,
        isRangeBand = scale.rangeBand;

    var rangeBand = isRangeBand ? scale.rangeBand() : 0;
    var renderer = this.vanchart.renderer;
    var plotBounds = this.vanchart.bounds,
        axis = this,
        isHorizontal = axis.isHorizontal();
    var i, len, from, to, rect;
    var x = 0,
        y = 0,
        width = plotBounds.width,
        height = plotBounds.height;

    if (!this.plotBandsGroup) {
      this.plotBandsGroup = renderer.group().addTo(this.clipAxisGroup);
      this.plotBands = [];
    }

    this.plotBandsGroup.attr({
      'transform': _BaseUtils["default"].makeTranslate(plotBounds)
    });

    for (i = plotBands.length; i < this.plotBands.length; i++) {
      this.plotBands[i] && this.plotBands[i].remove();
      this.plotBands[i] = null;
    }

    this.plotBands.length = plotBands.length;

    for (i = 0, len = plotBands.length; i < len; i++) {
      var d = plotBands[i];
      var t_f = scale(d.from),
          t_t = scale(d.to);
      from = Math.min(t_f, t_t);
      to = Math.max(t_f + rangeBand, t_t + rangeBand);
      from = Math.max(isHorizontal ? x : y, from);
      to = Math.min(isHorizontal ? width : height, to);

      if (isNaN(from) || isNaN(to)) {
        from = to = 0;
      }

      rect = isHorizontal ? {
        x: from,
        y: y,
        width: Math.max(to - from, 0),
        height: height
      } : {
        x: x,
        y: from,
        width: width,
        height: Math.max(to - from, 0)
      };
      this.plotBands[i] = this.plotBands[i] || renderer.rect(rect).addTo(this.plotBandsGroup);
      this.plotBands[i].style({
        'fill': d.color
      }).animate({
        'duration': TIME,
        'ease': EASE,
        attr: rect
      });
    }
  },
  _drawAxisLine: function () {
    var cfg = this.options;
    var lineColor = cfg.lineColor || 'rgba(255,255,255,0)';
    var lineWidth = cfg.lineColor ? cfg.lineWidth : 0;

    var plotBounds = this.getPlotBounds(),
        axisOrigin = this._getAxisOriginPoint();

    var x1 = 'x1',
        y1 = 'y1',
        x2 = 'x2',
        y2 = 'y2';
    var size = plotBounds.width,
        renderer = this.vanchart.renderer;

    if (!this.isHorizontal()) {
      x1 = 'y1';
      y1 = 'x1';
      x2 = 'y2';
      y2 = 'x2';
      size = plotBounds.height;
    }

    if (axisOrigin.y <= plotBounds.y && this.isHorizontal() && this.options.onZero || axisOrigin.x >= plotBounds.x + plotBounds.width && this.isVertical() && this.options.onZero) {
      this.axisLine && this.axisLine.remove();
      this.arrowGroup && this.arrowGroup.remove();
      this.axisLine = null;
      this.arrowGroup = null;
      return false;
    }

    var det = _BaseUtils["default"].lineSubPixelOpt(0, lineWidth);

    if (!this.axisLine) {
      this.axisLine = renderer.line().addTo(this.axisLineGroup);
    }

    var attrs = {};
    attrs[x1] = 0;
    attrs[x2] = size;
    attrs[y1] = attrs[y2] = det;
    attrs.transform = _BaseUtils["default"].makeTranslate(axisOrigin);
    this.axisLine.attr(attrs).style({
      stroke: lineColor,
      'stroke-width': lineWidth
    });

    if (this.showArrow()) {
      if (!this.arrowGroup) {
        this.arrowGroup = renderer.group().addTo(this.axisLineGroup);
      }

      var line = this.arrowGroup.line || renderer.line().addTo(this.arrowGroup);
      var path = this.arrowGroup.path || renderer.path().addTo(this.arrowGroup);
      this.arrowGroup.line = line;
      this.arrowGroup.path = path;
      var isReversed = this.isAxisReversed(),
          translateParam,
          // 箭柄的长度是固定的
      arrowHandleLength = 6,
          arrowType;

      if (this.isHorizontal()) {
        isReversed ? (translateParam = [axisOrigin.x, axisOrigin.y], arrowHandleLength *= -1, arrowType = 'left') : (translateParam = [axisOrigin.x + plotBounds.width, axisOrigin.y], arrowType = 'right');
        this.arrowGroup.attr('transform', _BaseUtils["default"].makeTranslate(translateParam));
        line.attr({
          'x1': 0,
          'y1': det,
          'x2': arrowHandleLength,
          'y2': det
        }).style({
          stroke: lineColor,
          'stroke-width': lineWidth
        });
        path.attr({
          'd': _Constants["default"].AXIS_ARROW_PATH[arrowType]
        }).style({
          'fill': lineColor
        });
      } else {
        isReversed ? (translateParam = [axisOrigin.x, axisOrigin.y + plotBounds.height], arrowHandleLength *= -1, arrowType = 'down') : (translateParam = axisOrigin, arrowType = 'up');
        this.arrowGroup.attr('transform', _BaseUtils["default"].makeTranslate(translateParam));
        line.attr({
          'x1': det,
          'y1': 0,
          'x2': det,
          'y2': -arrowHandleLength
        }).style({
          stroke: lineColor,
          'stroke-width': lineWidth
        });
        path.attr({
          'd': _Constants["default"].AXIS_ARROW_PATH[arrowType]
        }).style({
          'fill': lineColor
        });
      }
    } else {
      this.arrowGroup && this.arrowGroup.remove();
    }
  },
  _drawGridLine: function () {
    var cfg = this.options,
        plotBounds = this.getPlotBounds();
    var ticks = this.getTickData(),
        scale = this.scale,
        lastScale = this.lastScale || scale;
    var gridLineColor = cfg.gridLineColor,
        gridLineWidth = cfg.gridLineWidth,
        gridLineType = cfg.gridLineType;

    if (cfg.axisIndex > 0) {
      return;
    } // phantomjs 1.9,
    // svg 'stroke-width' has a default value 1
    // 0 is still 1 (→_→ maybe "value || 1" in apple's webkit...)


    if (gridLineWidth === 0) {
      gridLineColor = '';
    }

    var det = _BaseUtils["default"].lineSubPixelOpt(0, gridLineWidth),
        renderer = this.vanchart.renderer;

    var x1 = 'x1',
        y1 = 'y1',
        x2 = 'x2',
        y2 = 'y2',
        lineSize = plotBounds.height;

    if (!this.isHorizontal()) {
      x1 = 'y1';
      y1 = 'x1';
      x2 = 'y2';
      y2 = 'x2';
      lineSize = plotBounds.width;
    }

    if (!this.gridLinesGroup) {
      this.gridLinesGroup = renderer.group().addTo(this.clipAxisGroup);
      this.gridLines = [];
    }

    this.gridLinesGroup.attr('transform', _BaseUtils["default"].makeTranslate(plotBounds));
    var pos = this.getPosition(),
        isBottomOrTop = pos === _Constants["default"].TOP || pos === _Constants["default"].BOTTOM; // 当轴在上方或者下方时，需要在最右侧加一个边界线，在左方或者右方是，在最下方加

    var concatArray = this.type === _component.ComponentCst.CATEGORY_AXIS_COMPONENT ? [{
      tickPos: isBottomOrTop ? plotBounds.width : plotBounds.height - 1
    }] : [];

    var selection = this._bindData(this.gridLines, ticks.concat(concatArray), function (d) {
      return d.tickValue;
    });

    var currentGridLines = [];
    var i, len, attr, d, gridLine;

    for (i = 0, len = selection.exit.length; i < len; i++) {
      d = selection.exit[i].datum();
      pos = scale(d.tickValue); // CHART-18184 联动刷新对数轴0这条会计算出NaN，||0是兼容写法，不清楚有什么情况tickPos有没有可能undefined

      pos = isNaN(pos) ? d.tickPos || 0 : pos;
      attr = {};
      attr[x1] = pos;
      attr[x2] = pos;
      selection.exit[i].animate({
        'duration': TIME,
        'ease': EASE,
        'attr': attr,
        'style': {
          'opacity': 0
        }
      }).remove();
    }

    var lineConfig = {
      color: gridLineColor,
      lineWidth: gridLineWidth,
      lineType: gridLineType
    };

    for (i = 0, len = selection.enter.length; i < len; i++) {
      d = selection.enter[i];
      gridLine = renderer.line().style((0, _StyleUtils.getLineStyle)(lineConfig)).addTo(this.gridLinesGroup);
      var lastPos = lastScale(d.tickValue) + det;
      pos = d.tickPos + det;
      lastPos = isNaN(lastPos) ? pos : lastPos;
      gridLine.attr(x1, lastPos).attr(x2, lastPos).attr(y1, 0).attr(y2, lineSize);
      attr = {};
      attr[x1] = attr[x2] = pos;
      attr[y1] = 0;
      attr[y2] = lineSize;
      gridLine.animate({
        'attr': attr,
        'duration': TIME,
        'ease': EASE
      });
      gridLine.datum(d);
      currentGridLines.push(gridLine);
    }

    currentGridLines = currentGridLines.concat(selection.update);

    for (i = 0, len = currentGridLines.length; i < len; i++) {
      gridLine = currentGridLines[i].style((0, _StyleUtils.getLineStyle)(lineConfig));
      d = gridLine.datum();
      pos = d.tickPos + det;
      attr = {};
      attr[x1] = attr[x2] = _BaseUtils["default"].lineSubPixelOpt(pos);
      attr[y1] = 0;
      attr[y2] = lineSize;
      gridLine.animate({
        'attr': attr,
        'duration': TIME,
        'ease': EASE
      });
    }

    this.gridLines = currentGridLines;
  },
  //包括主要刻度线和次要刻度线,不加动画了
  _drawTickLine: function () {
    var renderer = this.vanchart.renderer,
        cfg = this.options;

    if (!this.tickLinesGroup) {
      this.tickLinesGroup = renderer.group().addTo(this.axisGroup);
      this.tickLines = {};
      this.tickLines[MAIN_TICK] = [];
      this.tickLines[MINOR_TICKS] = [];
    }

    var tickLength = cfg.enableTick ? cfg.tickLength || 0 : 0;
    var tickWidth = cfg.tickWidth || 1,
        tickColor = cfg.tickColor;

    var detMain = _BaseUtils["default"].lineSubPixelOpt(0, tickWidth);

    var minorTickLength = cfg.enableMinorTick ? cfg.minorTickLength || 0 : 0;
    var minorTickColor = cfg.minorTickColor,
        minorTickWidth = cfg.minorTickWidth || 1;

    var detMinor = _BaseUtils["default"].lineSubPixelOpt(0, minorTickWidth); // 绘制主要间隔线


    this._drawMainTickLine({
      det: detMain,
      tickWidth: tickWidth,
      tickLength: tickColor ? tickLength : 0,
      tickColor: tickColor
    }); // 绘制次要间隔线


    this._drawMinorTickLine({
      det: detMinor,
      tickWidth: minorTickWidth,
      tickLength: minorTickColor ? minorTickLength : 0,
      tickColor: minorTickColor
    });
  },

  /**
   * 绘制主要刻度线，多分类轴时重写该方法
   * @param  {[type]} option [description]
   * @return {[type]}        [description]
   */
  _drawMainTickLine: function (option) {
    var tickData = this.getTickData(); // rangeBand 即非面积图时，主要刻度比tickLabel数多一个

    if (this.isCategory() && !this.isRangePoints) {
      var reversed = this.options.reversed;

      var range = this._getRange();

      var extraTick = [{
        tickPos: range[reversed ? 0 : 1]
      }]; // reverse时在前面

      tickData = reversed ? extraTick.concat(tickData) : tickData.concat(extraTick);
    }

    this.tickLines[MAIN_TICK] = this._drawTickLineWithData(this.tickLines[MAIN_TICK], tickData, option);
  },

  /**
   * 绘制次要刻度线
   * @param  {[type]} option [description]
   * @return {[type]}        [description]
   */
  _drawMinorTickLine: function (option) {
    var minorTickData = this.getMinorTickData();
    this.tickLines[MINOR_TICKS] = this._drawTickLineWithData(this.tickLines[MINOR_TICKS], minorTickData, option);
  },

  /**
   * 根据给定的数据绘制标签间隔线
   * @param  {[type]} tickLines [存放tickLine的数组，方便以后更新tickLine]
   * @param  {[type]} tickData  [刻度线数据：包括文字内容，位置等]
   * @param  {[type]} options   [刻度线的样式等]
   * @return {[type]}           [description]
   */
  _drawTickLineWithData: function (tickLines, tickData, options) {
    // #scroll zoom 隐藏过界tick
    var shouldHideOutside = this.vanchart.isMobileFlow() && this.isCategory();
    var isH = this.isHorizontal();

    if (shouldHideOutside) {
      var plotBounds = this.vanchart.bounds;
      tickData = tickData.filter(function (t) {
        if (isH) {
          return t.tickPos >= 0 && t.tickPos <= plotBounds.width;
        } else {
          return t.tickPos >= 0 && t.tickPos <= plotBounds.height;
        }
      });
    }

    var axisOrigin = this._getAxisOriginPoint(),
        orient = this.getPosition();

    var renderer = this.vanchart.renderer,
        axis = this;
    var axisLineWidth = axis.options.lineWidth || 0;
    var sign = orient === _Constants["default"].TOP || orient === _Constants["default"].LEFT ? -1 : 1;
    var x1 = 'x1',
        y1 = 'y1',
        x2 = 'x2',
        y2 = 'y2';

    if (!this.isHorizontal()) {
      x1 = 'y1';
      y1 = 'x1';
      x2 = 'y2';
      y2 = 'x2';
    }

    var selection = axis._bindData(tickLines, tickData, options.keyFunction);

    var currentTickLines = [],
        i,
        len;

    for (i = 0, len = selection.exit.length; i < len; i++) {
      selection.exit[i].remove();
    }

    for (i = 0, len = selection.enter.length; i < len; i++) {
      currentTickLines.push(renderer.line().datum(selection.enter[i]).addTo(axis.tickLinesGroup));
    }

    currentTickLines = currentTickLines.concat(selection.update);

    for (i = 0, len = currentTickLines.length; i < len; i++) {
      var datum = currentTickLines[i].datum(),
          attrs = {};
      var tickPos;

      if ((0, _CoreUtils.hasDefined)(datum.tickPos)) {
        tickPos = datum.tickPos;
      } else {
        tickPos = axis.type === _component.ComponentCst.CATEGORY_AXIS_COMPONENT ? datum : axis.scale(datum);
      }

      var detX = axisOrigin.x,
          detY = axisOrigin.y;

      if (!axis.isHorizontal()) {
        detX = axisOrigin.y;
        detY = axisOrigin.x;
      } // 多分类轴的时候，其主要刻度线的高度应该根据其categoryKey来计算


      var tickLength = typeof options.tickLengthFuc === "function" ? options.tickLengthFuc(datum) : options.tickLength; // 给刻度的长度加上axis的lineWidth的一半，防止axis的lineWidth较大把刻度线覆盖的情况

      tickLength += tickLength > 0 ? axisLineWidth / 2 : 0;
      attrs[x1] = tickPos + options.det + detX;
      attrs[x2] = attrs[x1];
      attrs[y1] = detY;
      attrs[y2] = (sign * tickLength || 0) + detY;
      currentTickLines[i].attr(attrs).style({
        'stroke': options.tickColor,
        'stroke-width': options.tickWidth
      });
    }

    return currentTickLines;
  },
  _drawPlotLines: function () {
    var plotLines = this.options.plotLines || [];
    var plotBounds = this.vanchart.bounds;
    var scale = this.scale,
        isDate = this.type === _component.ComponentCst.DATE_AXIS_COMPONENT,
        isMultiCategory = this.isMultiCateAxis();
    var result = [],
        axis = this,
        renderer = this.vanchart.renderer;
    plotLines.forEach(function (d) {
      if ((0, _CoreUtils.isEmpty)(d.value)) {
        return;
      }

      var originPos = scale(getPlotLineValue(d.value)) + (scale.rangeBand ? scale.rangeBand() / 2 : 0);

      if (isNaN(originPos)) {
        return;
      }

      var pos = _BaseUtils["default"].lineSubPixelOpt(originPos, d.width);

      var x1, x2, y1, y2;

      if (axis.isHorizontal()) {
        if (originPos < 0 || originPos > plotBounds.width) {
          return;
        }

        x1 = x2 = pos;
        y1 = 0;
        y2 = plotBounds.height;
      } else {
        if (originPos < 0 || originPos > plotBounds.height) {
          return;
        }

        x1 = 0;
        x2 = plotBounds.width;
        y1 = y2 = pos;
      }

      var textX, textY, text, style;
      var lineWidth = _Constants["default"].DASH_ARRAY[d.lineType] == null ? 0 : d.lineWidth;

      if (d.label && d.label.text && d.label.style) {
        style = d.label.style;
        text = d.label.text;
        var align = d.label.align;

        var textDim = _BaseUtils["default"].getTextDimension(text, style, d.label.useHtml);

        switch (align) {
          case _Constants["default"].TOP:
            textX = x1 - textDim.width;
            textY = y1;
            break;

          case _Constants["default"].BOTTOM:
            textX = x1 - textDim.width;
            textY = y2 - textDim.height;
            break;

          case _Constants["default"].LEFT:
            textX = x1;
            textY = y1 - textDim.height - LABEL_LINE_GAP_FUN();
            break;

          case _Constants["default"].RIGHT:
            textX = x2 - textDim.width;
            textY = y2 - textDim.height - LABEL_LINE_GAP_FUN();
            break;
        }
      }

      result.push({
        color: d.color,
        line: {
          x1: x1,
          y1: y1,
          x2: x2,
          y2: y2
        },
        width: lineWidth,
        dataArray: _Constants["default"].DASH_ARRAY[d.lineType],
        text: text,
        textDim: textDim,
        style: style,
        textX: textX,
        textY: textY
      });
    });

    function getPlotLineValue(value) {
      if (isDate) {
        return _BaseUtils["default"].object2date(value);
      }

      if (isMultiCategory) {
        return _BaseUtils["default"].encodeCategoryArray(value);
      }

      return value;
    }

    function _getPlotLineStyle(datum) {
      return {
        'stroke': datum.color,
        'stroke-width': datum.width,
        'stroke-dasharray': datum.dataArray
      };
    }

    function _getLabelGraphic(datum) {
      return renderer.text().style(datum.style).attr({
        'x': datum.textX,
        'y': datum.textY,
        'text-anchor': 'left',
        'dy': datum.textDim.height * .85
      }).textContent(datum.text);
    }

    function _createLabelGraphic(datum, g) {
      if (g._textG) {
        g._textG.remove();

        g._textG = null;
      }

      if (datum.text && datum.textDim) {
        g._textG = _getLabelGraphic(datum).addTo(g);
      }
    }

    if (!this.plotLinesGroup) {
      this.plotLinesGroup = renderer.group().addTo(this.vanchart.frontGroup); // plotLines需要显示在最其前面，放在新添加的frontGroup中

      this.plotLines = [];
    }

    this.plotLinesGroup.attr('transform', _BaseUtils["default"].makeTranslate(plotBounds));

    var selection = this._bindData(this.plotLines, result),
        i,
        len,
        datum;

    this.plotLines = [];

    for (i = 0, len = selection.exit.length; i < len; i++) {
      selection.exit[i].remove();
    }

    for (i = 0, len = selection.enter.length; i < len; i++) {
      datum = selection.enter[i];
      g = renderer.group();
      this.plotLines.push(g);
      g._lineG = g.append(renderer.line(datum.line).style(_getPlotLineStyle(datum)));

      _createLabelGraphic(datum, g);

      g.addTo(this.plotLinesGroup);
    }

    for (i = 0, len = selection.update.length; i < len; i++) {
      var g = selection.update[i];
      datum = g.datum();

      g._lineG.attr(datum.line).style(_getPlotLineStyle(datum));

      _createLabelGraphic(datum, g);

      this.plotLines.push(g);
    }
  },
  _drawTickLabel: function () {
    this._drawSvgTickLabel();
  },

  /**
   * 使用SVG绘制轴标签：多分类轴下，需要重写这个方法
   * @return {[type]} [description]
   */
  _drawSvgTickLabel: function () {
    var vanchart = this.vanchart,
        renderer = vanchart.renderer;
    var ticks = this.getTickData().filter(function (tick) {
      return tick.tickContent !== '';
    });

    if (!this.tickLabelsGroup) {
      this.tickLabelsGroup = renderer.vgroup().add();
      this.axisGroup.append(this.tickLabelsGroup.renderG);
      this.tickLabels = [];
    }
    /**
     * CHART-1182
     * 使用HTML元素来显示标签的时候，svg元素的clipPath对这些标签元素不齐作用，
     * 所以要给这些标签的父元素设置clip属性，才能保证在设置坐标轴最大占比的时候能够隐藏超出的部分。
     */


    if (this.options.useHtml) {
      this.tickLabelsGroup.style({
        width: this.vanchart.width + "px",
        height: this.vanchart.height + "px"
      });
      var clipRect = "rect(" + this.clipBounds.y + "px, " + (this.clipBounds.x + this.clipBounds.width) + "px, " + (this.clipBounds.y + this.clipBounds.height) + "px, " + this.clipBounds.x + "px )";
      this.tickLabelsGroup.attr("clip", clipRect);
    }

    this.tickLabels = this._drawSvgTickLabelWithData(this.tickLabels, ticks);
  },

  /**
   * 绘制单行的svg标签
   * @param  {[type]} tickLabels [description]
   * @param  {[type]} ticks      [description]
   * @param  {[type]} level      [description]
   * @return {[type]}            [description]
   */
  _drawSvgTickLabelWithData: function (tickLabels, ticks, level) {
    var axis = this,
        vanchart = this.vanchart,
        renderer = vanchart.renderer;
    var startPos = level ? this._getLabelStartPos(level) : 0;
    var scale = this.scale,
        lastScale = this.lastScale || scale;
    var cfg = this.options,
        labelStyle = cfg.labelStyle,
        useHtml = cfg.useHtml;
    var shouldHideOutside = this.vanchart.isMobileFlow() && this.isCategory();
    var isH = this.isHorizontal();
    var self = this; // #scroll zoom 隐藏过界tickLabel

    if (shouldHideOutside) {
      var plotBounds = this.vanchart.bounds;
      ticks = ticks.filter(function (d) {
        var transform = self._getLabelAttr(scale, d, startPos);

        if (isH) {
          var x = transform._x + d.tickRectDim.width / 2 - d.tickDim.width / 2 - plotBounds.x;
          var width = d.tickDim.width;
          return x + width >= 0 && x <= plotBounds.width;
        } else {
          var y = transform._y + d.tickRectDim.height / 2 - d.tickDim.height / 2 - plotBounds.y;
          var height = d.tickDim.height;
          return y + height >= 0 && y <= plotBounds.height;
        }
      });
    }

    var selection = this._bindData(tickLabels, ticks, function (d) {
      return d.tickValue;
    }),
        i,
        len,
        d,
        pos;

    var currentTickLabels = [],
        para = {
      'duration': TIME,
      'ease': EASE,
      'style': {
        'opacity': 0
      }
    };

    for (i = 0, len = selection.exit.length; i < len; i++) {
      d = selection.exit[i].datum();
      pos = scale(d.tickValue);
      selection.exit[i].animate(_BaseUtils["default"].extend({}, para, axis.isHorizontal() ? {
        'x': pos
      } : {
        'y': pos
      })).remove();
    }

    var transform, tickLabel, rotateStr;

    for (i = 0, len = selection.enter.length; i < len; i++) {
      d = selection.enter[i];
      transform = this._getLabelAttr(lastScale, d, startPos);
      tickLabel = this.tickLabelsGroup.append(renderer.vtext(useHtml).style({
        'opacity': 0
      }));

      this._updateTickContent(renderer, tickLabel, d, useHtml, labelStyle);

      rotateStr = d.labelRotation % 360 ? tickLabel.vRotate(d.labelRotation, true
      /* delay */
      ).rotateStr : '';
      transform.transform += rotateStr;
      tickLabel.attr(transform);
      tickLabel.datum(d);
      currentTickLabels.push(tickLabel);
    }

    currentTickLabels = currentTickLabels.concat(selection.update);

    for (i = 0, len = currentTickLabels.length; i < len; i++) {
      tickLabel = currentTickLabels[i];
      d = tickLabel.datum();
      tickLabel.style(labelStyle);

      this._updateTickContent(renderer, tickLabel, d, useHtml, labelStyle);

      transform = this._getLabelAttr(scale, d, startPos);
      var opacity = this._valueInDomain(d.tickValue) ? 1 : 0; // 0值对齐的时候为了让刻度与标准轴对齐，得到的tickValue可能不在domain范围内，
      // 所以这里稍稍修改一下,alignAxisId属性是在处理0值对齐的函数中添加上的

      opacity = this.alignAxisId ? 1 : opacity;

      if (this.useHtmlLabel()) {
        tickLabel.attr(transform).style({
          'opacity': opacity
        });
        tickLabel.vRotate(d.labelRotation);
      } else {
        rotateStr = d.labelRotation % 360 ? tickLabel.vRotate(d.labelRotation, true
        /* delay */
        ).rotateStr : '';
        transform.transform += rotateStr;
        tickLabel.animate({
          'ease': EASE,
          'duration': TIME,
          'attr': transform,
          'style': {
            'opacity': opacity
          }
        });
      }
    }

    return currentTickLabels;
  },
  _updateTickContent: function (renderer, text, datum, useHtml, style) {
    if (datum && datum.tickGroup && datum.tickGroup.length) {
      text.textContent('');
      text.tspans = [];
      var y = 0;

      for (var i = 0, len = datum.tickGroup.length; i < len; i++) {
        var content = datum.tickGroup[i];
        var shift = datum.shiftGroup[i];

        var _BaseUtils$getTextDim = _BaseUtils["default"].getTextDimension(content, style, useHtml),
            height = _BaseUtils$getTextDim.height;

        var padding = height * (_Constants["default"].MULTI_LINE_HEIGHT - 1) / 2; // 字高为height的1.2倍，文字上面放0.1，下面放0.1

        y += padding;
        text.tspans.push(renderer.vtspan(useHtml).attr('x', 0).attr('y', y).attr('dx', shift).attr('dy', height * 0.85).textContent(content).addTo(text));
        y += height + padding;
      }
    } else {
      text.textContent(datum.tickContent);
    }

    return text;
  },
  // todo 20/11/2 这么修改有一个问题就是多系列的时候

  /**
   * 计算标签的位置属性,当为多分类轴是，需要传入startPos表示标签的位置偏移
   * @param  {[type]} scale    [description]
   * @param  {[type]} d        [description]
   * @param  {[type]} startPos [description]
   * @return {[type]}          [description]
   */
  _getLabelAttr: function (scale, d, startPos) {
    var origin = this._getAxisOriginPoint();

    var det = scale.rangeBand ? scale.rangeBand() / 2 * (d.length || 1) : 0;
    var tickLabelPos = scale(d.tickValue) + det;
    var cfg = this.options,
        isHorizontal = this.isHorizontal();
    var tickLength = cfg.enableTick ? cfg.tickLength : 0,
        tickPadding = cfg.tickPadding + tickLength || 0;
    var labelRotation = d.labelRotation || 0,
        useHtml = this.useHtmlLabel();
    var position = this.getPosition(),
        sign = position === _Constants["default"].TOP || position === _Constants["default"].LEFT ? -1 : 1;
    var rectDim = d.tickRectDim,
        labelDim = d.tickDim; // 90 degree has no rotation
    // rotation represents in writing-mode;

    var textX = 0,
        textY = 0,
        dx = 0,
        dy = rectDim.height * 0.85,
        rotationRadian = _BaseUtils["default"].toRadian(labelRotation),
        direction,
        writingMode;

    if (labelRotation === 360) {
      dx = useHtml || _Browser["default"].ie ? 0 : rectDim.width * 0.85 / 2;
      dy = 0;
      writingMode = 'tb-rl';
    }

    direction = this._getLabelDirection(labelRotation, isHorizontal);

    if (isHorizontal) {
      textY += sign * (labelDim.height - rectDim.height) / 2;
      textY += sign * (this.options.labelStyle.fontSize ? (0, _AutoFitUtils.QuarterTextVerPadding)(parseFloat(this.options.labelStyle.fontSize)) : 0);
      textX += sign * direction * (labelDim.width - Math.abs(rectDim.height * Math.sin(rotationRadian))) / 2;

      if (position === _Constants["default"].TOP) {
        textY -= rectDim.height;
        textY -= startPos;
      } else {
        textY += startPos;
      }

      textY += sign * tickPadding;
      textX += origin.x + tickLabelPos - rectDim.width / 2;
      textY += origin.y;
    } else {
      textX += sign * (labelDim.width - rectDim.width) / 2;
      textY += sign * direction * (labelDim.height - rectDim.height * Math.cos(rotationRadian)) / 2;

      if (position === _Constants["default"].LEFT) {
        textX -= rectDim.width;
        textX -= startPos;
      } else {
        textX += startPos;
      }

      textX += sign * tickPadding;
      textX += origin.x;
      textY += origin.y + tickLabelPos - rectDim.height / 2;
    }

    var px = useHtml ? 'px' : '';
    var transform = 'translate(' + textX + px + ' ' + textY + px + ')';
    var result = {
      _x: textX,
      // for boundary check after zoom/scroll
      _y: textY,
      transform: transform,
      dy: dy,
      dx: dx,
      'writingMode': writingMode,
      'writing-mode': writingMode
    }; // phantomjs bug

    if (useHtml && writingMode) {
      result['-webkit-writing-mode'] = 'vertical-rl';
    }

    return result;
  },
  // todo add test
  _getLabelDirection: function (rotation, isHorizontal) {
    if (isHorizontal) {
      if (Math.abs(rotation % 90) < 15) {
        return 0;
      }

      return rotation > 0 ? 1 : -1;
    } // 标签旋转90度时，如果含有中文，则tickDate中的labelRotation为360，否则为90
    // 360度的标签旋转使用css属性tb-rl来实现，90度的标签使用rotate属性来实现


    if (Math.abs(rotation % 90) > 85 || rotation === 90) {
      return 0;
    }

    return rotation > 0 ? 1 : -1;
  },
  _drawAxisTitle: function () {
    var cfg = this.options,
        title = cfg.title;

    if (!title || (0, _CoreUtils.isEmpty)(title.text)) {
      this.titleGroup && this.titleGroup.remove();
      this.titleGroup = null;
      return;
    }

    var R = this.vanchart.renderer,
        axisGroup = this.axisGroup;
    var useHtml = title.useHtml,
        rotation = this.titleRotation,
        align = this.getTitleAlign(),
        text = title.text,
        style = title.style;
    var textDim = this.titleDim,
        rectDim = this.titleRectDim;
    var titleBounds = this.getAxisTitleBounds();

    if (!this.titleGroup) {
      this.titleGroup = R.vgroup().add();
      axisGroup.append(this.titleGroup.renderG);
    }

    this.titleGroup.attr({
      'transform': _BaseUtils["default"].makeTranslate(titleBounds)
    });
    var titleGroup = this.titleGroup; //标题每次刷新重新添加，原因：用中文的刷新没有中文的，中文应该没有rotate(deg,x,y)类似东西

    if (titleGroup.text) {
      titleGroup.text.remove();
    }

    titleGroup.text = titleGroup.append(R.vtext(useHtml));
    var x = 0,
        y = 0,
        dx = 0,
        dy = rectDim.height * 0.85;

    switch (align) {
      case _Constants["default"].TOP:
        y = 0;
        break;

      case _Constants["default"].BOTTOM:
        y = titleBounds.height - textDim.height;
        break;

      case _Constants["default"].LEFT:
        x = 0;
        break;

      case _Constants["default"].RIGHT:
        x = titleBounds.width - textDim.width;
        break;

      case _Constants["default"].CENTER:
      default:
        if (this.isHorizontal()) {
          x = (titleBounds.width - textDim.width) / 2;
          y += title.style.fontSize ? (0, _AutoFitUtils.QuarterTextVerPadding)(parseFloat(title.style.fontSize)) + TITLE_LABEL_GAP : 0;
        } else {
          y = (titleBounds.height - textDim.height) / 2;
        }

    }

    if (this.titleRotation === 360) {
      dx = useHtml ? 0 : _Browser["default"].ie ? '0.2ex' : rectDim.width * 0.85 / 2; // @CHART-769 IE下面竖直排版某些中文会往左边缩一点.

      dy = 0;
    } else {
      x += (textDim.width - rectDim.width) / 2;
      y += (textDim.height - rectDim.height) / 2;
    }

    titleGroup.text.style(style).attr({
      x: x,
      y: y,
      dy: dy,
      dx: dx
    }).textContent(text);
    rotation % 360 && titleGroup.text.vRotate(rotation);
  },
  remove: function () {
    this.axisGroup && this.axisGroup.remove();
    this.clipAxisGroup && this.clipAxisGroup.remove();
    this.axisGroup = this.clipAxisGroup = null;
    this.axisLineGroup && this.axisLineGroup.remove();
    this.axisLineGroup = null;
    this.axisLine && this.axisLine.remove();
    this.axisLine = null;
    this.gridLinesGroup && this.gridLinesGroup.remove();
    this.gridLinesGroup = null;
    this.gridLines && this.gridLines.forEach(function (gridLine) {
      gridLine && gridLine.remove();
      gridLine = null;
    });
    this.gridLines = null;
    this.plotLinesGroup && this.plotLinesGroup.remove();
    this.plotLinesGroup = null;
    this.plotLines && this.plotLines.forEach(function (plotLine) {
      plotLine && plotLine.remove();
      plotLine = null;
    });
    this.plotLines = null; // remove vgroup

    this.tickLabelsGroup && this.tickLabelsGroup.remove();
    this.tickLabelsGroup = null;
    this.tickLabels = null;
    this.cateTickLabelsGroup && this.cateTickLabelsGroup.remove();
    this.cateTickLabelsGroup = null;
    this.cateTickLabels = null;
    this.titleGroup && this.titleGroup.remove();
    this.titleGroup = null;
    this.removeHighlightBackground && this.removeHighlightBackground();
  },

  /**
   * 判断数据点是否在其基础轴的值域范围内
   * @param point
   * @returns {boolean}
   */
  isPointWithinDataDomain: function (point) {
    var axisType = this.options.type;
    var domain = this._domain;

    switch (axisType) {
      // 基础轴为时间轴
      case _component.ComponentCst.DATE_AXIS_COMPONENT:
        return _BaseUtils["default"].date2int(point.category) >= domain[0] && _BaseUtils["default"].date2int(point.category) <= domain[1];
      // 基础轴为值轴

      case _component.ComponentCst.VALUE_AXIS_COMPONENT:
        return parseFloat(point.category) >= domain[0] && parseFloat(point.category) <= domain[1];
      // 默认的分类轴或者多分类轴

      default:
        return domain.indexOf(point.getCategory()) >= 0;
    }
  },
  isMultiCateAxis: function () {
    return false;
  }
});

var _default = BaseAxis;
exports["default"] = _default;

/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseAxis = _interopRequireDefault(__webpack_require__(67));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Scale = _interopRequireDefault(__webpack_require__(10));

var _component = __webpack_require__(4);

var _CoreUtils = __webpack_require__(2);

var _AxisUtils = __webpack_require__(33);

var _helper = __webpack_require__(54);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/5/18.
 * 值轴的定义
 */
var ValueAxis = _BaseAxis["default"].extend({
  type: _component.ComponentCst.VALUE_AXIS_COMPONENT,
  initScale: function () {
    this.lastScale = this.scale;
    this.scale = this.options.log ? _Scale["default"].log().base(this.options.log) : _Scale["default"].linear();
  },
  getAxisValue: function (value, point) {
    //布局用到， value === "-"时返回0
    return value === "-" ? 0 : this.byPercent ? point.percentage : +value;
  },
  _valueInDomain: function (value) {
    var domain = this.scale.domain();
    return value >= Math.min(domain[0], domain[1]) && value <= Math.max(domain[0], domain[1]);
  },

  /**
   * 从给定的数据中计算出最大值最小值
   * @param needConsiderBaseAxisDataDomain boolean  是否需要考虑基础坐标轴的值域范围
   * @returns {[min,max]} 返回所有有效数据中最小和最大的值
   * @private
   */
  _getDomainFromData: function (needConsiderBaseAxisDataDomain) {
    var minValue = Number.MAX_VALUE,
        maxValue = -minValue,
        emptyData = true;
    var series = this.series,
        dataMap = {};
    var isVisibleSeries = (0, _AxisUtils.hasVisibleSery)(series);
    this.forecast = (0, _AxisUtils.getForecast)(series);

    for (var i = 0, len = series.length; i < len; i++) {
      if (series[i].visible || !isVisibleSeries) {
        this._getSeriesValue(dataMap, series[i], needConsiderBaseAxisDataDomain);
      }
    }

    for (var key in dataMap) {
      var data = dataMap[key];

      for (var j = 0, count = data.length; j < count; j++) {
        if (!isNaN(data[j]) && !(this.options.log && data[j] <= 0)) {
          minValue = Math.min(minValue, data[j]);
          maxValue = Math.max(maxValue, data[j]);
          emptyData = false;
        }
      }
    }

    if (emptyData) {
      return (0, _AxisUtils.getEmptyDataDomain)(this.options.tickInterval);
    }

    return [minValue, maxValue];
  },
  //获取系列的值，如果是堆积的话获取系列的和
  _getSeriesValue: function (dataMap, sery, needConsiderBaseAxisDataDomain) {
    var seriesName = sery.name || '';
    var seryBaseAxisType = sery.getBaseAxisType(),
        baseAxis = this.vanchart.components[seryBaseAxisType]._axisList[sery.options[seryBaseAxisType] || 0];
    var key = this.componentType == _component.ComponentCst.X_AXIS_COMPONENT ? 'x' : 'y';

    var unstack = (0, _CoreUtils.hasNotDefined)(sery.stack) || sery.stack === false || this._isBaseAxis();

    if (unstack) {
      dataMap[seriesName] = dataMap[seriesName] || [];
      sery.points.forEach(function (point) {
        // 没有指定需要考虑baseAxisDomain的时候，默认全部的点都有效
        var isPointInBaseAxisDataDomain = !needConsiderBaseAxisDataDomain ? true : baseAxis.isPointWithinDataDomain(point);

        if (!point.isNull && point.visible && isPointInBaseAxisDataDomain) {
          var value = point.options[key];

          if (_BaseUtils["default"].isArray(value) || (0, _CoreUtils.hasDefined)(value.min) && (0, _CoreUtils.hasDefined)(value.max)) {
            dataMap[seriesName] = dataMap[seriesName].concat((0, _helper.getPointDomain)(value, point.options.isDetailed));
          } else {
            dataMap[seriesName].push(value);
          }
        }
      });
    } else {
      var PK = sery.stack + sery.type + 'STACK_POSITIVE';
      var NK = sery.stack + sery.type + 'STACK_NEGATIVE';
      dataMap[PK] = dataMap[PK] || [];
      dataMap[NK] = dataMap[NK] || [];
      sery.points.forEach(function (point, i) {
        // 没有指定需要考虑baseAxisDomain的时候，默认全部的点都有效
        var isPointInBaseAxisDataDomain = !needConsiderBaseAxisDataDomain ? true : baseAxis.isPointWithinDataDomain(point);

        if (!point.isNull && point.visible && isPointInBaseAxisDataDomain) {
          var value = +point.options[key];

          if (value > 0) {
            dataMap[PK][i] = dataMap[PK][i] || 0;
            dataMap[PK][i] += value;
          }

          if (value < 0) {
            dataMap[NK][i] = dataMap[NK][i] || 0;
            dataMap[NK][i] += value;
          } // 0值对于堆积来讲，当且仅当为第一条数据的时候才有用


          if (value == 0) {
            (0, _CoreUtils.hasNotDefined)(dataMap[PK][i]) && (dataMap[PK][i] = 0);
            (0, _CoreUtils.hasNotDefined)(dataMap[NK][i]) && (dataMap[NK][i] = 0);
          }
        }
      });
      (0, _AxisUtils.isZeroArray)(dataMap[PK]) && (dataMap[PK] = []);
      (0, _AxisUtils.isZeroArray)(dataMap[NK]) && (dataMap[NK] = []);
    }
  },
  //考虑有正负值的时候的0值对齐的功能
  getStartPos: function () {
    return this.scale(this.getStartPosValue());
  },
  getStartPosValue: function () {
    var axisOption = this.options;
    return axisOption.log && axisOption.log !== 1 ? 1 : 0;
  },
  _getTickValues: function () {
    if (this.options.log) {
      return (0, _AxisUtils.getLogTicks)(this._tickStart, this._domain[1], this.options.log, this._step);
    } else {
      var _this$options = this.options,
          min = _this$options.min,
          max = _this$options.max,
          tickInterval = _this$options.tickInterval;
      return (0, _AxisUtils.getLinearTicks)({
        options: {
          min: min,
          max: max,
          tickInterval: tickInterval
        },
        min: this._tickStart,
        max: this._domain[1],
        interval: this._step
      });
    }
  },

  /**
   * CHART-1256
   * 根据某一个值轴的标签位置来返回当前值轴相对应位置的标签
   * 当存在0值对齐设置的时候，为了让某一个值轴的刻度与标准轴的刻度相对应，只能来点儿硬的：
   * 获取每一个标准轴刻度在绘图区的位置，然后再求解这个位置上当前值轴的刻度值，
   * 这样最后得到的当前值轴的刻度就会与标准值轴的刻度处于差不多的位置。
   * @private
   */
  _getTickValuesAlignByAxis: function () {
    var componentType = this.componentType;
    var relyOnAxis;

    this.vanchart.getComponent(componentType)._axisList.forEach(function (axis) {
      // BaseAxis.js --- _alignByZeroValue函数里面定义了alignAxisId
      if (/^standard/.exec(axis.alignAxisId)) {
        relyOnAxis = axis;
      }
    });

    var range = relyOnAxis._getRange(); //更新relyOnAxis scale range


    relyOnAxis.scale.range(range);

    if (relyOnAxis == this) {
      return this._getTickValues();
    }

    var ticks = relyOnAxis._getTickValues();

    var valueList = [];
    var value;
    this.scale.range(range);

    for (var i = 0, len = ticks.length; i < len; i++) {
      value = this.scale.invert(relyOnAxis.scale(ticks[i])); // 接近于0的情况

      if (Math.abs(0 - value) < 1e-6 || Math.abs(0 - ticks[i]) < 1e-6) {
        value = 0;
      } // 如果value是绝对值大于1的小数，直接四舍五入
      // 但是这可能导致一些小的显示问题……


      if (Math.abs(value) > 1 && value % 1 !== 0) {
        // value = Math.round(value);
        value = Math.floor(value * 100) / 100;
      }

      valueList.push(value);
    } // 返回规范化之后的刻度值


    return this._normalizeTicks(valueList);
  },

  /**
   * CHART-1514
   * 规范化刻度值。
   *
   * Q：为什么要再写这么一个函数呢？
   * A：因为在_getTickValuesAlignByAxis函数中获取到0值对齐的刻度很有可能是这样的——0.0000……1、5.9999……6、11999.99999……6，
   * 这个问题在测试人员以及产品大佬的意识里是有问题的，所以最后受伤的还是开发！！！所以在这里单独写一个函数来解决这个问题。
   *
   * Q：那么获取到这些小数是因为什么呢？
   * A：因为所有的刻度值都是通过比例尺反转（invert）求解得到的，在反转的过程很大概率会出现小数的计算，
   * 由于js在计算一些小数的时候会出现不精确的问题，所以才导致了获取到的刻度值也出现很长的小数。
   * @param ticks
   * @returns {Array|[null]}
   * @private
   */
  _normalizeTicks: function (ticks) {
    var i = -1,
        len = ticks.length - 1,
        diff; // 差值
    // 如果ticks.length < 3， if语句之后的逻辑是多余的，最终还是会返回ticks，所以这里处理一下这种情况

    if (ticks.length < 3) {
      return ticks.map(function (tick) {
        return Math.abs(tick) > 1 ? Math.round(tick) : tick;
      });
    } // 找到第一个差值是整数的时候就break出来


    while (++i < len) {
      diff = _BaseUtils["default"].accAdd(ticks[i + 1], -ticks[i]);

      if ((diff | 0) === diff) {
        break;
      }
    }

    var index, value;
    len = ticks.length;
    i = -1; // 找到第一个刻度值是整数的时候就break出来

    while (++i < len) {
      value = ticks[i];
      index = i;

      if ((value | 0) === value) {
        break;
      }
    }

    len = ticks.length;
    ticks = [value];
    i = index; // 现在得到了差值diff、刻度值value以及知道了value在ticks的下标，
    // 下一步的操作是重新构造ticks数组，从value的位置开始，往前添加刻度值，然后再往后添加刻度值

    while (--i >= 0) {
      ticks.unshift(_BaseUtils["default"].accAdd(value, _BaseUtils["default"].accMul(index - i, -diff)));
    }

    i = index;

    while (++i < len) {
      ticks.push(_BaseUtils["default"].accAdd(value, _BaseUtils["default"].accMul(i - index, diff)));
    }

    return ticks;
  }
});

var _default = ValueAxis;
exports["default"] = _default;

/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Bounds = _interopRequireDefault(__webpack_require__(22));

var _LatLng = _interopRequireDefault(__webpack_require__(21));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Projection = _interopRequireDefault(__webpack_require__(175));

var _Transformation = _interopRequireDefault(__webpack_require__(176));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/1/19.
 */
var CRS = {
  // @method latLngToPoint(latlng: LatLng, zoom: Number): Point
  // Projects geographical coordinates into pixel coordinates for a given zoom.
  latLngToPoint: function (latlng, zoom) {
    var projectedPoint = this.projection.project(latlng),
        scale = this.scale(zoom);
    return this.transformation._transform(projectedPoint, scale);
  },
  // @method pointToLatLng(point: Point, zoom: Number): LatLng
  // The inverse of `latLngToPoint`. Projects pixel coordinates on a given
  // zoom into geographical coordinates.
  pointToLatLng: function (point, zoom) {
    var scale = this.scale(zoom),
        untransformedPoint = this.transformation.untransform(point, scale);
    return this.projection.unproject(untransformedPoint);
  },
  // @method project(latlng: LatLng): Point
  // Projects geographical coordinates into coordinates in units accepted for
  // this CRS (e.g. meters for EPSG:3857, for passing it to WMS services).
  project: function (latlng) {
    return this.projection.project(latlng);
  },
  // @method unproject(point: Point): LatLng
  // Given a projected coordinate returns the corresponding LatLng.
  // The inverse of `project`.
  unproject: function (point) {
    return this.projection.unproject(point);
  },
  // @method scale(zoom: Number): Number
  // Returns the scale used when transforming projected coordinates into
  // pixel coordinates for a particular zoom. For example, it returns
  // `256 * 2^zoom` for Mercator-based CRS.
  scale: function (zoom) {
    return 256 * Math.pow(2, zoom);
  },
  // @method zoom(scale: Number): Number
  // Inverse of `scale()`, returns the zoom level corresponding to a scale
  // factor of `scale`.
  zoom: function (scale) {
    return Math.log(scale / 256) / Math.LN2;
  },
  // @method getProjectedBounds(zoom: Number): Bounds
  // Returns the projection's bounds scaled and transformed for the provided `zoom`.
  getProjectedBounds: function (zoom) {
    if (this.infinite) {
      return null;
    }

    var b = this.projection.bounds,
        s = this.scale(zoom),
        min = this.transformation.transform(b.min, s),
        max = this.transformation.transform(b.max, s);
    return _Bounds["default"].create(min, max);
  },
  // @method distance(latlng1: LatLng, latlng2: LatLng): Number
  // Returns the distance between two geographical coordinates.
  // @property code: String
  // Standard code name of the CRS passed into WMS services (e.g. `'EPSG:3857'`)
  //
  // @property wrapLng: Number[]
  // An array of two numbers defining whether the longitude (horizontal) coordinate
  // axis wraps around a given range and how. Defaults to `[-180, 180]` in most
  // geographical CRSs. If `undefined`, the longitude axis does not wrap around.
  //
  // @property wrapLat: Number[]
  // Like `wrapLng`, but for the latitude (vertical) axis.
  // wrapLng: [min, max],
  // wrapLat: [min, max],
  // @property infinite: Boolean
  // If true, the coordinate space will be unbounded (infinite in both axes)
  infinite: false,
  // @method wrapLatLng(latlng: LatLng): LatLng
  // Returns a `LatLng` where lat and lng has been wrapped according to the
  // CRS's `wrapLat` and `wrapLng` properties, if they are outside the CRS's bounds.
  wrapLatLng: function (latlng) {
    var lng = this.wrapLng ? _BaseUtils["default"].wrapNum(latlng.lng, this.wrapLng, true) : latlng.lng,
        lat = this.wrapLat ? _BaseUtils["default"].wrapNum(latlng.lat, this.wrapLat, true) : latlng.lat,
        alt = latlng.alt;
    return new _LatLng["default"](lat, lng, alt);
  }
};
CRS.Simple = _BaseUtils["default"].extend({}, CRS, {
  projection: _Projection["default"].LonLat,
  transformation: new _Transformation["default"](1, 0, -1, 0),
  scale: function (zoom) {
    return Math.pow(2, zoom);
  },
  zoom: function (scale) {
    return Math.log(scale) / Math.LN2;
  },
  distance: function (latlng1, latlng2) {
    var dx = latlng2.lng - latlng1.lng,
        dy = latlng2.lat - latlng1.lat;
    return Math.sqrt(dx * dx + dy * dy);
  },
  infinite: true
});
CRS.Earth = _BaseUtils["default"].extend({}, CRS, {
  wrapLng: [-180, 180],
  // Mean Earth Radius, as recommended for use by
  // the International Union of Geodesy and Geophysics,
  // see http://rosettacode.org/wiki/Haversine_formula
  R: 6371000,
  // distance between two geographical points using spherical law of cosines approximation
  distance: function (latlng1, latlng2) {
    var rad = Math.PI / 180,
        lat1 = latlng1.lat * rad,
        lat2 = latlng2.lat * rad,
        a = Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos((latlng2.lng - latlng1.lng) * rad);
    return this.R * Math.acos(Math.min(a, 1));
  }
});
CRS.EPSG3857 = _BaseUtils["default"].extend({}, CRS.Earth, {
  code: 'EPSG:3857',
  projection: _Projection["default"].SphericalMercator,
  transformation: function () {
    var scale = 0.5 / (Math.PI * _Projection["default"].SphericalMercator.R);
    return new _Transformation["default"](scale, 0.5, -scale, 0.5);
  }()
});
CRS.EPSG900913 = _BaseUtils["default"].extend({}, CRS.EPSG3857, {
  code: 'EPSG:900913'
});
CRS.EPSG4326 = _BaseUtils["default"].extend({}, CRS.Earth, {
  code: 'EPSG:4326',
  projection: _Projection["default"].LonLat,
  transformation: new _Transformation["default"](1 / 180, 1, -1 / 180, 0.5)
});
CRS.EPSG4490 = _BaseUtils["default"].extend({}, CRS.Earth, {
  code: 'EPSG:4490',
  projection: _Projection["default"].LonLat,
  transformation: new _Transformation["default"](1 / 180, 1, -1 / 180, 0.5)
});
CRS.EPSG4480 = _BaseUtils["default"].extend({}, CRS.EPSG4490, {
  code: 'EPSG:4480'
});
CRS.EPSG4479 = _BaseUtils["default"].extend({}, CRS.EPSG4490, {
  code: 'EPSG:4479'
});
CRS.EPSG3395 = _BaseUtils["default"].extend({}, CRS.Earth, {
  code: 'EPSG:3395',
  projection: _Projection["default"].Mercator,
  transformation: function () {
    var scale = 0.5 / (Math.PI * _Projection["default"].Mercator.R);
    return new _Transformation["default"](scale, 0.5, -scale, 0.5);
  }()
});
var _default = CRS;
exports["default"] = _default;

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.PADDING = exports.MARGIN = void 0;

var _Base = _interopRequireDefault(__webpack_require__(11));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _LegendIconFactory = _interopRequireDefault(__webpack_require__(57));

var _LegendItem = _interopRequireDefault(__webpack_require__(100));

var _Scrollbar = _interopRequireDefault(__webpack_require__(94));

var _DomUtils = _interopRequireDefault(__webpack_require__(6));

var _component = __webpack_require__(4);

var _EnvUtils = __webpack_require__(3);

var _AutoFitUtils = __webpack_require__(17);

var _VanChartLayout = _interopRequireDefault(__webpack_require__(44));

var _mapUtils = __webpack_require__(31);

var _VanChartBackground = __webpack_require__(45);

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/5/4.
 * 图例
 */
// 图例换行行高，1.2倍字高
var LINE_HEIGHT = 1.2; // 图例外边距，5px

var MARGIN = 5; // 图例内边距，4px

exports.MARGIN = MARGIN;
var PADDING = 4; // 图例图标和文本的间距，8px

exports.PADDING = PADDING;

var ICON_LABEL_GAP = function (fontSize) {
  return fontSize * 0.4;
}; // 垂直图例项间距，2px


var VER_LEGEND_ITEMS_GAP = 2; // 水平图例项间距，12px

var HOR_LEGEND_ITEMS_GAP = 12; // 滚动轴宽度，12px

var SCROLLBAR_WIDTH = 12; // 水平图例最小宽度，ICON.width + ICON_LABEL_GAP + TEXT.width >= 84

var MIN_WIDTH = 120;

var Legend = _Base["default"].extend({
  isFlowBottom: function () {
    return this.vanchart.isMobileFlow() && this.options.position === 'bottom';
  },
  doLayout: function () {
    this.items = this.items || [];

    if (this.invisible()) {
      this.remove();
      return;
    }

    this.yPanEnabled = false;

    this._updateLegendItems();

    this._layoutLegendItemBounds();
  },
  _updateLegendItems: function () {
    var series = this.vanchart.series,
        namedSeries = {},
        namedTrendLine = {},
        legend = this,
        vanchart = this.vanchart;
    var legendItemOptions = [],
        i,
        len;
    var opacityMap = {}; // @Cmen-Chart-687
    // 饼图这一类图形，只有当条件属性设置系列透明度时，才对图例对应的透明度
    // 之前的问题是使用的第一个point的透明度来作为图例的透明度，理论上说是不正确的
    // 这里在生成legendItem之前，先遍历一边points，当具有相同bindName的point的opacity相同，才可以证明开启了系列透明

    for (i = -1; ++i < series.length;) {
      var ser = series[i];

      if (ser.type === _Constants["default"].GAUGE_CHART) {
        continue; // 测量类图表不支持图例，故no need
      }

      if (ser.isSeriesAccumulated()) {
        ser.points.forEach(function (point) {
          var bindName = legend._itemBindName(point);

          if (!opacityMap[bindName]) {
            opacityMap[bindName] = {
              opacity: (0, _CoreUtils.hasDefined)(point.opacity) ? point.opacity : 1,
              useSerOpacity: true
            };
          } else {
            if (opacityMap[bindName].opacity != point.opacity) {
              opacityMap[bindName].useSerOpacity = false;
            }
          }
        });
      }
    }

    for (i = 0, len = series.length; i < len; i++) {
      var sery = series[i],
          chartType = sery.type;

      if (chartType == _Constants["default"].GAUGE_CHART) {
        continue;
      }

      if (sery.isSeriesAccumulated()) {
        // BI-7057
        var ovk = chartType === _Constants["default"].PIE_CHART ? 'x' : 'name';
        var orderMap = {};
        sery.options.data.forEach(function (datum, i) {
          orderMap[datum[ovk]] = i;
        });
        var tmp = sery.type === _Constants["default"].FUNNEL_CHART ? sery.points : sery.points.slice().sort(function (a, b) {
          return orderMap[a[ovk]] - orderMap[b[ovk]];
        });
        tmp.map(function (point) {
          var bindName = legend._itemBindName(point);

          if (!namedSeries[bindName]) {
            var item = {
              color: vanchart.getDefaultSeriesColor(bindName),
              opacity: opacityMap[bindName].useSerOpacity ? opacityMap[bindName].opacity : 1,
              bindName: bindName,
              itemName: bindName,
              visible: point.visible
            };

            legend._mergeCommonLegendAttr(sery, item);

            namedSeries[bindName] = true;
            legendItemOptions.push(item);
          }
        });
      } else {
        var item;

        if (!namedSeries[sery.name]) {
          var isPointMapDefaultImg = (0, _mapUtils.isPointMapDefaultImgFn)(sery.type, sery.options.markerType);
          item = {
            color: isPointMapDefaultImg ? _Constants["default"].POINT_MAP_IMG_COLOR : sery.color,
            opacity: sery.type === _Constants["default"].BOX_CHART || isPointMapDefaultImg ? _Constants["default"].DEFAULT_OPACITY : sery.opacity,
            bindName: sery.name,
            itemName: sery.name,
            visible: sery.visible
          };

          legend._mergeCommonLegendAttr(sery, item);

          namedSeries[sery.name] = item;
          legendItemOptions.push(item);
        }

        var isValidTrendLine = sery.options.trendLine && _Constants["default"].DASH_ARRAY[sery.options.trendLine.lineType] && !namedTrendLine[sery.name];

        if (isValidTrendLine) {
          item = {
            isTrendLine: true,
            color: sery.options.trendLine.color,
            opacity: sery.opacity,
            bindName: sery.name,
            itemName: sery.options.trendLine.name,
            visible: sery.visible
          };

          legend._mergeCommonLegendAttr(sery, item);

          item.legendIconType = _Constants["default"].NULL_MARKER; // log both legends

          namedSeries[sery.name].pairLegendOpt = item;
          item.pairLegendOpt = namedSeries[sery.name];
          namedTrendLine[sery.name] = item;
          legendItemOptions.push(item);
        }
      }
    }

    for (i = legendItemOptions.length, len = this.items.length; i < len; i++) {
      this.items[i].remove();
      this.items[i] = null;
    }

    for (i = 0, len = legendItemOptions.length; i < len; i++) {
      if (this.items[i]) {
        this.items[i].refresh(legendItemOptions[i]);
      } else {
        this.items[i] = new _LegendItem["default"](legend, legendItemOptions[i]);
      }
    }

    this.items.length = legendItemOptions.length;
  },
  _mergeCommonLegendAttr: function (sery, item) {
    var cfg = this.options;
    var hiddenColor = cfg.hiddenColor;
    var hoverColor = cfg.hoverColor || cfg.style.color;

    _BaseUtils["default"].extend(item, {
      series: sery,
      hiddenColor: hiddenColor,
      hoverColor: hoverColor,
      legendIconType: this._getLegendType(sery),
      lineIndex: 0 //记录下如果换行的行号

    });
  },
  _layoutLegendItemBounds: function () {
    //这边的padding是整个图例和别的组件的间隙
    var cfg = this.options,
        position = cfg.position || _Constants["default"].RIGHT;

    if (!this.items.length) {
      return;
    }

    if (position === _Constants["default"].TOP || position === _Constants["default"].BOTTOM) {
      this._layoutHorizontalLegendItemBounds(position);
    } else {
      //考虑不和工具栏&&标题重叠
      //更改:不考虑标题,因为标题已经裁剪过了，this.vanchart.bounds.y已经是考虑了标题的了
      var toolbarHeight = 0;

      if ((position === _Constants["default"].RIGHT || position === _Constants["default"].RIGHT_TOP) && !this.isFloat) {
        var tools = this.vanchart.getComponent(_component.ComponentCst.TOOLBAR_COMPONENT);
        tools && tools.options.hidden != false && (toolbarHeight = tools.getToolBarInitHeight());
      }

      this._layoutVerticalLegendItemBounds(position, toolbarHeight);
    }
  },
  _layoutVerticalLegendItemBounds: function (position, startY) {
    var maxWidth = this._maxLegendWidth() - MARGIN * 2,
        style = this.options.style,
        useHtml = this.options.useHtml;
    var totalUsedWidth = 0,
        legendY = PADDING;

    for (var i = 0, len = this.items.length; i < len; i++) {
      var item = this.items[i];
      var options = item.options; // fixme textSize和labels都可以作为item的属性，在init的时候计算，doLayout的时候使用

      var textSize = this._getTextHeight(options.itemName, style, useHtml);

      var iconLabelGap = ICON_LABEL_GAP(textSize);

      var iconDim = _LegendIconFactory["default"].getLegendIconSizeAndScale(options.legendIconType, textSize);

      var remainWidth = maxWidth - iconDim.width - iconLabelGap - 2 * PADDING;

      var textUsedWidth = this._getTextUsedWidth(options.itemName, style, remainWidth);

      totalUsedWidth = Math.max(iconDim.width + iconLabelGap + textUsedWidth, totalUsedWidth); // 使用html解析时单行显示

      item.labels = useHtml ? [options.itemName] : _BaseUtils["default"].splitText(options.itemName, style, remainWidth, 0, false);
      item.legendX = PADDING; // 行高为字高1.5倍，所以y需要把0.25倍的字高间距加上

      legendY += (0, _AutoFitUtils.QuarterTextVerPadding)(textSize);
      item.legendY = legendY;
      legendY += Math.max(textSize * item.labels.length * LINE_HEIGHT - (0, _AutoFitUtils.OneTenthTextVerPadding)(textSize) * 2, iconDim.height) + (0, _AutoFitUtils.QuarterTextVerPadding)(textSize) + VER_LEGEND_ITEMS_GAP;
    } // 最后一行下面不用固定间距


    legendY -= VER_LEGEND_ITEMS_GAP;
    var legendSize = PADDING * 2 + totalUsedWidth,
        needHeight = legendY + PADDING;
    var offeredHeight = this.vanchart.bounds.height - MARGIN * 2; //但是要考虑标题高度小于37的时候，减去tools高度才是可用高度

    offeredHeight -= Math.max(0, startY - this.vanchart.bounds.y); //todo 这里有种期限的情况,比如256, 255,理论上算的话应该有翻页,但是因为太小了基本看不出来

    /**
     * CHART-1144
     * 图例竖直排列的时候，设置了maxWidth为0的时候，就没有必要显示这些翻页按钮了，
     * 但是，老实说，都设置maxWidth为0了，为什么不直接设置不显示图例呢？
     * 这是一个令人深思的问题。
     */
    // todo 20/10/30 这里的needHeight如果不减去PADDING就表示把PADDING也考虑到是否显示滚动条的情况（20/11/2 还未和视觉确认最终效果）

    this.yPanEnabled = Math.abs(0 - maxWidth) < 1e-6 ? false : needHeight - PADDING > offeredHeight;
    this.maxYPan = Math.min(0, offeredHeight - (needHeight - PADDING)); // 非浮动下图例占用的实际宽度要再加上外边距

    var actualWidth = (legendSize > maxWidth ? maxWidth : legendSize) + MARGIN * 2;

    this._setComponentBounds(position, actualWidth);

    var x = this.bounds.x + MARGIN;
    var y = this.bounds.y;
    var width = this.bounds.width - MARGIN * 2;
    var height = this.bounds.height - MARGIN * 2; //但是要考虑标题高度小于37的时候，减去tools高度才是可用高度

    height -= Math.max(0, startY - this.vanchart.bounds.y);
    var usedHeight = Math.min(needHeight, height); // 实际使用高度需要加上2倍的边框宽度
    // 即使是相对于startY进行偏移，也要有外边距

    y = Math.max(startY, y); // todo 图例不能设置右下为什么要有这个呢？

    if (!this.isFloat && position == _Constants["default"].RIGHT_BOTTOM) {
      //右下
      y = Math.round(this.bounds.y + this.bounds.height - usedHeight - MARGIN * 2);
    } else if (!this.isFloat && (position == _Constants["default"].RIGHT || position == _Constants["default"].LEFT)) {
      // 垂直居中
      y += Math.round((this.bounds.y + this.bounds.height - y - usedHeight - MARGIN * 2) / 2);
    }

    y += MARGIN;
    this.bounds = {
      x: x,
      y: y,
      width: Math.max(0, width),
      height: Math.max(0, usedHeight)
    };
  },
  _getTextUsedWidth: function (text, style, maxWidth) {
    var dim = _BaseUtils["default"].getTextDimension(text, style, this.options.useHtml);

    if (maxWidth && maxWidth < dim.width) {
      return maxWidth;
    }

    return dim.width;
  },
  _getTextHeight: function (text, style, useHtml) {
    if (useHtml) {
      var _BaseUtils$getTextDim = _BaseUtils["default"].getTextDimension(text, style, true),
          height = _BaseUtils$getTextDim.height;

      return height;
    }

    return parseFloat(style.fontSize);
  },
  _layoutHorizontalLegendItemBounds: function (position) {
    var plotBounds = this.vanchart.bounds;
    var style = this.options.style;
    var useHtml = this.options.useHtml;
    var visibleWidth = plotBounds.width - 2 * (MARGIN + PADDING);
    var offeredWidth = visibleWidth; // non-flow default

    var itemNeedMinWidth = 0,
        // 单个图例需要的最小宽度：itemNeedMinWidth = icon + icon_text_gap + text
    legendTotalWidth = 0; // legend至少需要的总宽度

    var i, len, item, options, iconSize, textSize, textDim;

    for (i = 0, len = this.items.length; i < len; i++) {
      options = this.items[i].options;
      textSize = this._getTextHeight(options.itemName, style, useHtml);
      iconSize = _LegendIconFactory["default"].getLegendIconSizeAndScale(options.legendIconType, textSize);
      textDim = _BaseUtils["default"].getTextDimension(options.itemName, style, this.options.useHtml);
      var itemWidth = iconSize.width + ICON_LABEL_GAP(textSize) + textDim.width;
      itemNeedMinWidth = Math.max(itemNeedMinWidth, itemWidth); // todo 20/10/29 用不用把paading加上（起始padding）

      legendTotalWidth += itemWidth + HOR_LEGEND_ITEMS_GAP;
    }

    legendTotalWidth -= HOR_LEGEND_ITEMS_GAP; // 最后一个图例后面不用gap
    // todo, 好混乱的逻辑……

    var shouldFlowCenter = false; // flow, only one line
    // 用于移动端重布局，移动端选了重布局只能居中显示

    if (this.isFlowBottom()) {
      shouldFlowCenter = legendTotalWidth <= visibleWidth;
      offeredWidth = legendTotalWidth;
    }

    var multiLine = !this.isFlowBottom() && legendTotalWidth >= offeredWidth; // 是否多行显示ZQWX

    this.lineHeightMap = {};
    var currentLineMaxHeight = 0;
    var legendY = PADDING;
    var usedHeight = 0; // legend单行和多行显示方式不同
    // 单行可以显示：不限制单个图例宽度，按照实际需要宽度展示
    // 单行显示不下：单个图例宽度为Math.min(itemNeedMinWidth, MIN_WIDTH)

    if (!multiLine) {
      var currentLegendX = PADDING;

      for (i = 0, len = this.items.length; i < len; i++) {
        item = this.items[i];
        options = item.options;
        textSize = this._getTextHeight(options.itemName, style, useHtml);
        iconSize = _LegendIconFactory["default"].getLegendIconSizeAndScale(options.legendIconType, textSize);
        textDim = _BaseUtils["default"].getTextDimension(options.itemName, style, this.options.useHtml);
        item.labels = [options.itemName]; // 一行显示，直接将单个图例的options.itemName放入item.labels。

        item.legendX = currentLegendX;
        item.legendY = legendY + (0, _AutoFitUtils.QuarterTextVerPadding)(textSize);
        item.lineIndex = 0;
        currentLegendX = item.legendX + iconSize.width + ICON_LABEL_GAP(textSize) + textDim.width + HOR_LEGEND_ITEMS_GAP;
        currentLineMaxHeight = Math.max(currentLineMaxHeight, Math.max(textSize * item.labels.length * LINE_HEIGHT - (0, _AutoFitUtils.OneTenthTextVerPadding)(textSize) * 2, iconSize.height) + (0, _AutoFitUtils.QuarterTextVerPadding)(textSize) * 2);
        this.lineHeightMap[0] = Math.max(this.lineHeightMap[0] || 0, textSize, iconSize.height);
      }

      usedHeight = currentLineMaxHeight; // only used by flow

      this._innerWidth = currentLegendX - HOR_LEGEND_ITEMS_GAP + PADDING;
    } else {
      if (this.options.layout === _Constants["default"].FLOW) {
        var streamLayout = this._horizontalStreamLayout(offeredWidth);

        usedHeight = streamLayout.usedHeight;
      } else {
        // todo 20/10/31 这里的offeredWidth应该加上的是HOR_LEGEND_ITEMS_GAP * this.items.length吧
        // 视觉稿最小宽度为84px，ICON.width + ICON_LABEL_GAP + text.width为84
        // 84*n+12(n-1) = offeredWidth。itemMaxWidth = icon + icon_text_gap + text + item_item_gap
        var niceNum = Math.floor((offeredWidth + HOR_LEGEND_ITEMS_GAP) / (Math.min(itemNeedMinWidth, MIN_WIDTH) + HOR_LEGEND_ITEMS_GAP));
        niceNum = Math.min(niceNum, this.items.length) !== 0 ? Math.min(niceNum, this.items.length) : 1;
        var itemMaxWidth = Math.round((offeredWidth + HOR_LEGEND_ITEMS_GAP) / niceNum);
        var hasWrap = false;
        multiLine = this.items.length > niceNum;
        var lineIndex = -1;

        for (i = 0, len = this.items.length; i < len; i++) {
          item = this.items[i], options = item.options;
          textSize = this._getTextHeight(options.itemName, style, useHtml);
          iconSize = _LegendIconFactory["default"].getLegendIconSizeAndScale(options.legendIconType, textSize);
          var textMaxWidth = itemMaxWidth - iconSize.width - ICON_LABEL_GAP(textSize) - HOR_LEGEND_ITEMS_GAP;
          item.labels = _BaseUtils["default"].splitText(options.itemName, style, textMaxWidth, 0, false);
          hasWrap = hasWrap || item.labels.length > 1;

          if (i % niceNum === 0) {
            // 换行
            legendY += currentLineMaxHeight;
            currentLineMaxHeight = 0;
            lineIndex++;
            this.lineHeightMap[lineIndex] = 0;
          }

          item.legendX = PADDING + i % niceNum * itemMaxWidth;
          item.legendY = legendY + (0, _AutoFitUtils.QuarterTextVerPadding)(textSize);
          item.lineIndex = lineIndex;
          currentLineMaxHeight = Math.max(currentLineMaxHeight, Math.max(textSize * item.labels.length * LINE_HEIGHT - (0, _AutoFitUtils.OneTenthTextVerPadding)(textSize), iconSize.height) + (0, _AutoFitUtils.QuarterTextVerPadding)(textSize) * 2 + VER_LEGEND_ITEMS_GAP);
          this.lineHeightMap[lineIndex] = Math.max(this.lineHeightMap[lineIndex] || 0, textSize, iconSize.height);
        }

        usedHeight = legendY - PADDING + currentLineMaxHeight - VER_LEGEND_ITEMS_GAP;
      }
    }

    var legendSize = Math.round(usedHeight) + PADDING * 2;
    var maxHeight = this._maxLegendHeight() - MARGIN * 2; // todo 20/10/30 这里legendSize和垂直方向时不一样，这里把下面的padding也算上了，如果padding不够也会显示滚动轴，需要确认一下然后统一垂直和水平的
    // CHART-1399 将maxHeight设置为0%的时候不生效

    this.yPanEnabled = maxHeight >= 0 && legendSize > maxHeight;
    this.maxYPan = -legendSize + maxHeight; // yPanEnabled = true时，这个才有用
    // 当计算组件占用的实际高度时，需要加上外间距值

    var actualHeight = (this.yPanEnabled ? maxHeight : legendSize) + MARGIN * 2;

    this._setComponentBounds(position, actualHeight);

    var x = this.bounds.x + MARGIN;
    var y = this.bounds.y + MARGIN;
    var height = this.bounds.height - MARGIN * 2;
    var width = this.bounds.width - MARGIN * 2;
    var usedWidth = offeredWidth + 2 * PADDING;

    if (this.isFlowBottom()) {
      // 情愿多写2遍也不要搅和到原来的逻辑……
      if (shouldFlowCenter) {
        // 图例水平居中
        usedWidth = this._horizontalCenterLayout(style);
        x += (width - usedWidth) / 2;
      } else {
        usedWidth = visibleWidth + 2 * PADDING;
      }
    } else if (!hasWrap && !multiLine) {
      // 图例水平居中
      usedWidth = this._horizontalCenterLayout(style);
      x += (width - usedWidth) / 2;
    } // 历史遗留问题：x、y是指减去边框宽度后bounds的x、y，而width、height是加上了边框宽度的bounds的宽高，现在都改成减去边框后的x、y、height、width


    this.bounds = {
      x: x,
      y: y,
      width: Math.max(0, usedWidth),
      height: Math.max(0, height)
    };
  },
  // 图例位于上下方时的排列方式：流式排列——不限制单个图例宽度，按照实际需要宽度展示，从左到右，从上到下，逐步累加item的位置，一行摆放不下就换行显示
  _horizontalStreamLayout: function (offeredWidth) {
    var legendY = PADDING,
        currentLegendX = PADDING,
        style = this.options.style;
    var lineIndex = 0,
        textSingleLineWidth = 0,
        currentLineMaxHeight = 0;

    for (var i = 0, len = this.items.length; i < len; i++) {
      var item = this.items[i],
          options = item.options,
          textSize = this._getTextHeight(options.itemName, style, this.options.useHtml),
          iconSize = _LegendIconFactory["default"].getLegendIconSizeAndScale(options.legendIconType, textSize),
          textDim = _BaseUtils["default"].getTextDimension(options.itemName, style, this.options.useHtml),
          itemWidth = iconSize.width + ICON_LABEL_GAP(textSize) + textDim.width;

      textSingleLineWidth = currentLegendX + itemWidth;

      if (textSingleLineWidth > offeredWidth) {
        legendY += currentLineMaxHeight;
        currentLegendX = PADDING;
        currentLineMaxHeight = 0;
        textSingleLineWidth = 0;
        lineIndex++;
        this.lineHeightMap[lineIndex] = 0;
      }

      item.labels = [options.itemName];
      item.legendX = currentLegendX;
      item.legendY = legendY + (0, _AutoFitUtils.QuarterTextVerPadding)(textSize);
      item.lineIndex = lineIndex;
      currentLegendX = item.legendX + itemWidth + HOR_LEGEND_ITEMS_GAP;
      currentLineMaxHeight = Math.max(currentLineMaxHeight, Math.max(textSize * item.labels.length * LINE_HEIGHT - (0, _AutoFitUtils.OneTenthTextVerPadding)(textSize) * 2, iconSize.height) + (0, _AutoFitUtils.QuarterTextVerPadding)(textSize) * 2 + VER_LEGEND_ITEMS_GAP);
      this.lineHeightMap[lineIndex] = Math.max(this.lineHeightMap[lineIndex] || 0, textSize, iconSize.height);
    }

    return {
      usedHeight: legendY - PADDING + currentLineMaxHeight - VER_LEGEND_ITEMS_GAP
    };
  },
  // 图例水平居中用的宽度
  _horizontalCenterLayout: function (style) {
    var legendX = PADDING;

    for (var i = 0, len = this.items.length; i < len; i++) {
      var item = this.items[i],
          options = item.options,
          textSize = this._getTextHeight(options.itemName, style, this.options.useHtml); // todo 20/10/30 这里和前面的计算不是重复了吗，为什么又要算一次


      item.legendX = legendX;
      legendX += _LegendIconFactory["default"].getLegendIconSizeAndScale(options.legendIconType, textSize).width;
      legendX += ICON_LABEL_GAP(textSize);
      legendX += _BaseUtils["default"].getTextDimension(options.itemName, style, this.options.useHtml).width;
      legendX += HOR_LEGEND_ITEMS_GAP;
    }

    return legendX + PADDING - HOR_LEGEND_ITEMS_GAP;
  },
  render: function () {
    if (this.invisible() || !this.items.length) {
      this.remove();
      return;
    }

    var bounds = this.bounds,
        legend = this,
        vanchart = legend.vanchart,
        renderer = vanchart.renderer,
        legendWidth = bounds.width,
        legendHeight = bounds.height;

    if (!this.legendGroup) {
      // 图例的边框在bounds内部，阴影在bounds外部，阴影会占用图例和别的组件之间的间距
      // 为了clip时只clip图例本身的元素，不影响阴影的显示，所以将背景和图例调整为同级元素，
      // 都作为vanchart.backGroup的子元素,先绘制背景，再绘制图例项
      this.backgroundGroup = renderer.group().addTo(this.getComponentParentGroup());
      this.legendGroup = renderer.vgroup().add(this.getComponentParentGroup());
      this.legendItemsGroup = this.legendGroup.append(renderer.vgroup());
      vanchart.registerInteractiveTarget(this, this.legendGroup);
      vanchart.registerInteractiveTarget(this, this.backgroundGroup);
    }

    this.legendGroup.attr('transform', _BaseUtils["default"].makeTranslate(bounds)); // 图例设置的最大展示区域为0%的时候，整个图例的背景还是会绘制出背景的边框，
    // 但是如果在vanchart._renderRectangleBackground中改代码的话影响到的地方比较多，
    // 所以现在在这里将borderWidth设置为0

    var position = this.options.position;

    if (position === _Constants["default"].TOP || position === _Constants["default"].BOTTOM) {
      parseFloat(this.options.maxHeight) === 0 && (this.options.borderWidth = 0);
    } else {
      parseFloat(this.options.maxWidth) === 0 && (this.options.borderWidth = 0);
    }

    (0, _VanChartBackground.renderRectangleBackground)(this.backgroundGroup, this.options, _LegendIconFactory["default"].getLegendOuterBounds(bounds, this.options), renderer);

    for (var i = 0, len = this.items.length; i < len; i++) {
      this.items[i].render();
    }

    var clip = {
      x: 0,
      y: 0,
      width: legendWidth,
      height: legendHeight
    };

    legend._buildScrollbar();

    if (this._clip) {
      // #MOBILE-18902
      // 可能晕倒有滚动到没滚动的resize
      // 狗皮膏药
      if ((0, _EnvUtils.isSupportSVG)() && this._clip.rect.rawElement.height.baseVal.value !== clip.height) {
        this.resetLegendScroll();
      }
    }

    this._innerClip(this.legendGroup, clip); // 数据刷新的时候，重置图例的scrollTop


    if (vanchart._changeDataState) {
      this.resetLegendScroll();
    }
  },
  _buildScrollbar: function () {
    if (false) {}

    var legend = this;
    var legendWidth = legend.bounds.width;
    var legendHeight = legend.bounds.height;
    legend.scrollbar && legend.scrollbar.off();
    legend.scrollbar && legend.scrollbar.remove();

    if (this.vanchart.isMobileFlow()) {
      var BAR_SIZE = 4; // the same as BI

      var ON_THUMB_COLOR = 'rgba(61,77,102,0.3)',
          ON_TRACK_COLOR = 'rgba(61,77,102,0.05)',
          THUMB_COLOR = 'rgba(61,77,102,0.1)',
          TRACK_COLOR = 'rgba(61,77,102,0.03)';
      var barStyle = {
        backgroundSize: BAR_SIZE,
        backgroundColor: TRACK_COLOR,
        backgroundStroke: 'none',
        barColor: THUMB_COLOR,
        barHoverColor: ON_THUMB_COLOR,
        barSize: BAR_SIZE
      };

      if (this.isFlowBottom() && this._innerWidth > legendWidth) {
        legend.scrollbar = new _Scrollbar["default"]({
          scrollX: true,
          scrollY: false,
          view: legend,
          group: legend.legendGroup,
          width: legendWidth,
          height: legendHeight + BAR_SIZE,
          innerWidth: this._innerWidth,
          barStyle: barStyle
        });
      } else if (legend.yPanEnabled && legend.maxYPan) {
        legend.scrollbar = new _Scrollbar["default"]({
          scrollX: false,
          scrollY: true,
          view: legend,
          group: legend.legendGroup,
          width: legendWidth + BAR_SIZE,
          height: legendHeight,
          innerHeight: legendHeight - legend.maxYPan,
          barStyle: barStyle
        });
      }
    } else if (legend.yPanEnabled && legend.maxYPan) {
      legend.scrollbar = new _Scrollbar["default"]({
        scrollX: false,
        scrollY: true,
        view: legend,
        group: legend.legendGroup,
        width: legendWidth,
        height: legendHeight,
        innerHeight: legendHeight - legend.maxYPan,
        barStyle: {
          backgroundSizeRadius: 5
        }
      });
      legend.scrollbar.on('scrollY', this.onScrollY, this);
    }
  },
  getEvents: function () {
    return {
      'wheel': this.onWheel,
      'mouseout': this.mouseOut,
      'mouseover': this.mouseOver,
      'panstart': this.onPanStart,
      'panmove': this.onPanMove,
      'panend': this.onPanEnd
    };
  },
  mouseOut: function () {
    if (this.highlighted) {
      this.vanchart.cancelLegendHighlight();
    }
  },
  mouseOver: function () {},
  onWheel: function (ev) {
    var e = ev.srcEvent;

    _DomUtils["default"].stopPropagation(e);

    _DomUtils["default"].preventDefault(e);

    this.moveLegendY(_DomUtils["default"].getWheelDelta(e));
  },
  onPanStart: function (ev) {
    this.currentX = ev.containerPoint.x;
    this.currentY = ev.containerPoint.y;

    if (this.vanchart.isMobileFlow() && this.scrollbar) {
      this.scrollbar.show(true);
    }
  },
  onPanMove: function (ev) {
    var deltaX = ev.containerPoint.x - this.currentX;
    var deltaY = ev.containerPoint.y - this.currentY;

    if (this.isFlowBottom()) {
      this.moveLegendX(deltaX);
    } else {
      this.moveLegendY(deltaY);
    }

    this.currentX = ev.containerPoint.x;
    this.currentY = ev.containerPoint.y;
  },
  onPanEnd: function () {
    this.vanchart.handler.panTarget = null;

    if (this.vanchart.isMobileFlow() && this.scrollbar) {
      this.scrollbar.show(false);
    }
  },
  onScrollY: function (data) {
    var deltaY = data.y - (this.legendItemsGroup.currentY || 0);
    this.moveLegendY(deltaY);
  },
  moveLegendX: function (deltaX) {
    if (this._innerWidth > this.bounds.width) {
      var movedX = this.legendItemsGroup.__movedX || 0;
      movedX += deltaX;
      movedX = Math.max(this.bounds.width - this._innerWidth, Math.min(movedX, 0));
      this.legendItemsGroup.__movedX = movedX;
      this.legendItemsGroup.attr('transform', _BaseUtils["default"].makeTranslate([movedX, 0]));
      this.fire('innerChange', {
        x: movedX,
        y: 0
      });
    }
  },
  moveLegendY: function (deltaY) {
    var transY = 0;

    if (this.yPanEnabled) {
      transY = deltaY + (this.legendItemsGroup.currentY || 0);
      transY = Math.max(this.maxYPan, Math.min(0, transY));
    }

    this.legendItemsGroup.currentY = transY;
    this.legendItemsGroup.attr('transform', _BaseUtils["default"].makeTranslate([0, this.legendItemsGroup.currentY]));
    this.fire('innerChange', {
      x: 0,
      y: transY
    });
  },

  /**
   * 图表刷新时，重置legend的滚轮位移
   */
  resetLegendScroll: function () {
    this.legendItemsGroup.currentY = 0;
    this.legendItemsGroup.attr('transform', 'translate(0,0)');
  },
  remove: function () {
    this.legendGroup && this.legendGroup.remove();
    this.backgroundGroup && this.backgroundGroup.remove();
    this._clip && this._clip.remove && this._clip.remove();
    this.legendGroup = this.backgroundGroup = this._clip = null;
    this.items && (this.items.length = 0);
  },
  _itemBindName: function (point) {
    var sery = point.series;
    return sery.isSeriesAccumulated() ? point.name : sery.name;
  },
  reShowPoint: function (point) {
    var name = this._itemBindName(point);

    return this._stateName(name, _Constants["default"].STATE_TO_SHOW);
  },
  showSeries: function (series) {
    return this._stateName(series.name, _Constants["default"].STATE_SHOW);
  },
  toDropSeries: function (series) {
    return this._stateName(series.name, _Constants["default"].STATE_TO_DROP);
  },
  _stateName: function (name, state) {
    for (var i = 0, len = this.items.length; i < len; i++) {
      var item = this.items[i];

      if (item.state == state && item.options.bindName == name) {
        return true;
      }
    }

    return false;
  },

  /**
   * 图例在拖拽方向上是否到达边界
   * @param ev
   * @returns {boolean}
   */
  isPanMovingAtTheBoundary: function (ev) {
    return false;
  },
  // 用于检测事件对象是否位于图例上，含有滚动条时，检测区域宽度需要减去滚动条宽度
  contains: function (containerPoint) {
    var bounds = this.bounds;
    return bounds && _BaseUtils["default"].containsPoint(this.scrollbar ? {
      x: bounds.x,
      y: bounds.y,
      width: bounds.width - SCROLLBAR_WIDTH,
      height: bounds.height
    } : bounds, containerPoint);
  },
  switchSeriesItemVisible: function (name, item) {
    /**
     * 多层饼图下更新point.children里面的point的visible
     * @param parent
     * @param visible
     */
    var setMultiPieChildrenPointVisible = function (parent, visible) {
      var children = parent.children;

      if (children && children.length) {
        for (var i = 0, len = children.length; i < len; i++) {
          children[i].visible = visible;
          setMultiPieChildrenPointVisible(children[i], visible);
        }
      }
    };

    var legend = this;
    var series = this.vanchart.series;
    var calculatedMap = {};

    for (var i = 0, len = series.length; i < len; i++) {
      var sery = series[i];

      if (sery.isSeriesAccumulated()) {
        sery.points.map(function (point) {
          if (legend._itemBindName(point) == name) {
            point.visible = !point.visible;
            sery.type === _Constants["default"].MULTIPIE_CHART && setMultiPieChildrenPointVisible(point, point.visible); // @CHART-1561

            if (item) {
              item.state = point.visible ? _Constants["default"].STATE_TO_SHOW : _Constants["default"].STATE_TO_DROP;
            }
          }
        });
      } else if (sery.name === name) {
        sery.visible = !sery.visible;

        if (item) {
          item.state = sery.visible ? _Constants["default"].STATE_TO_SHOW : _Constants["default"].STATE_TO_DROP;
        }
      }
    }

    _VanChartLayout["default"].calculateSeries(this.vanchart); //如果有同名系列，值轴的计算要等所有的系列状态更新之后计算


    for (var i = 0, len = series.length; i < len; i++) {
      var sery = series[i];

      if (!sery.isSeriesAccumulated() && sery.name === name) {
        sery._getAxisTypes().forEach(function (type) {
          var axis = sery[type]; // update value/date axis

          if (axis && !axis._isBaseAxis() && !calculatedMap[_BaseUtils["default"].stamp(axis)]) {
            calculatedMap[_BaseUtils["default"].stamp(axis)] = true;
            axis.calculateDomainFromData();

            if (axis.componentType === _component.ComponentCst.X_AXIS_COMPONENT || axis.componentType === _component.ComponentCst.Y_AXIS_COMPONENT) {
              axis.adjustDomain4Radius();
            } else {
              //radiusAxis等
              axis.fixScaleAndTickData();
            }
          }
        });
      }
    }

    if (item) {
      item.options.visible = !item.options.visible;

      if (item.options.pairLegendOpt) {
        item.options.pairLegendOpt.visible = item.options.visible;
        item.options.pairLegendOpt.renderItem.render();
        item.options.pairLegendOpt.renderItem.onMouseOut();
      }
    }
  }
});

var _default = Legend;
exports["default"] = _default;

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unescapeEntities = unescapeEntities;
exports.parseInlineStr = parseInlineStr;
exports.getInlineStyle = getInlineStyle;
exports.removeUnSupportTag = removeUnSupportTag;
exports.splitTspans = splitTspans;
exports.splitStr = splitStr;
exports.getRowHeight = getRowHeight;
exports.getRowWidth = getRowWidth;
exports.addTranslate = addTranslate;
exports.toLowerTag = toLowerTag;
exports.replaceTag = replaceTag;
exports.getTspansProp = getTspansProp;
exports.mergeTspansProps = mergeTspansProps;
exports.buildSvgTspansGroup = buildSvgTspansGroup;
exports.getSvgTransSize = getSvgTransSize;
exports.getSvgTspans = getSvgTspans;

var _EnvUtils = __webpack_require__(3);

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var LINE_HEIGHT = 1.2;
var DEFAULT_FONT = {
  fontSize: "12px",
  fontStyle: "",
  fontWeight: "",
  fontFamily: ""
};
var ESCAPES = {
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;',
  "'": '&#39;',
  '"': '&quot;'
};
var KEY_MAP = {
  'font-size': 'fontSize',
  'font-family': 'fontFamily',
  'font-style': 'fontStyle',
  'font-weight': 'fontWeight',
  'color': 'color'
};

function unescapeEntities(inputStr, except) {
  for (var key in ESCAPES) {
    var value = ESCAPES[key];

    if (!except || except.indexOf(key) === -1) {
      inputStr = inputStr.toString().replace(new RegExp(value, 'g'), key);
    }
  }

  return inputStr;
}

function parseInlineStr(str, attr) {
  var start, delimiter;
  start = str.indexOf('<');
  str = str.substring(start, str.indexOf('>') - start);
  start = str.indexOf(attr + '=');

  if (start !== -1) {
    start = start + attr.length + 1;
    delimiter = str.charAt(start);

    if (delimiter === '"' || delimiter === "'") {
      // eslint-disable-line quotes
      str = str.substring(start + 1);
      return str.substring(0, str.indexOf(delimiter));
    }
  }
}

function getInlineStyle(inlineStr) {
  inlineStr = inlineStr || '';
  var inlineStyle = {};
  inlineStr.split(';').forEach(function (str) {
    var keyAndValue = str.split(':');

    if (keyAndValue && keyAndValue.length === 2) {
      var key = KEY_MAP[keyAndValue[0].trim()];
      inlineStyle[key] = keyAndValue[1];
    }
  });
  return inlineStyle;
}

function removeUnSupportTag(span) {
  if (span == null || span === "") {
    return "";
  }

  return span.replace(/<[a-zA-Z\/](.|\n)*?>/g, '') || ' ';
}

function splitTspans(span) {
  // 第二次分行：以span内部的换行符来分割出tspan
  return span.split(/<br.*?>/g);
}

function splitStr(str) {
  var lines = [];
  var line = [];
  var spans = str.replace(/^\s+|\s+$/g, '').replace(/<span/g, '|||<span').replace(/<\/span>/g, '</span>|||').split('|||').filter(function (span) {
    return span !== '';
  });
  spans.forEach(function (span) {
    if (span.trim() === '<br>') {
      lines.push(line);
      line = [];
    } else {
      line.push(span);
    }
  });

  if (line.length > 0) {
    lines.push(line);
  }

  return lines;
}

function getRowHeight(rowTspans) {
  if (rowTspans == null || rowTspans.length < 1) {
    return 0;
  }

  var maxHeight = 0;
  rowTspans.forEach(function (tspan) {
    maxHeight = Math.max(maxHeight, tspan.height);
  });
  return maxHeight * LINE_HEIGHT;
}

function getRowWidth(rowTspans) {
  if (rowTspans == null || rowTspans.length < 1) {
    return 0;
  }

  var width = 0;
  rowTspans.forEach(function (tspan) {
    width += tspan.width;
  });
  return width;
}

function addTranslate(rowTspansGroup) {
  var x = 0,
      y = 0;
  rowTspansGroup.forEach(function (rowTspans) {
    var height = getRowHeight(rowTspans);
    rowTspans.forEach(function (tspan) {
      tspan.translate = [x, y];
      x += tspan.width;
    });
    x = 0;
    y += height;
  });
}

function toLowerTag(textStr) {
  return textStr.replace(/<(B|STRONG)>/ig, '<b>').replace(/<(I|EM)>/ig, '<i>').replace(/<\/(B|STRONG)>/ig, '</b>').replace(/<\/(I|EM)>/ig, '</i>').replace(/<\/A>/ig, '</a>').replace(/<SPAN/ig, '<span').replace(/<\/SPAN>/ig, '</span>').replace(/<BR.*?>/ig, '<br>');
}

function replaceTag(textStr) {
  return textStr.replace(/<(b|strong)>/g, '<span style="font-weight:bold">').replace(/<(i|em)>/g, '<span style="font-style:italic">').replace(/<\/(b|strong|i|em|a)>/g, '</span>');
}

function getTspansProp(span, style) {
  var inlineStyle = getInlineStyle(parseInlineStr(span, 'style'));
  var tspans = splitTspans(span);
  return tspans.map(function (tspan) {
    var textContent = unescapeEntities(removeUnSupportTag(tspan));

    var textStyle = _BaseUtils["default"].extend({}, style, inlineStyle);

    var _getCanvasTextDim2 = (0, _EnvUtils._getCanvasTextDim)(textContent, textStyle),
        width = _getCanvasTextDim2.width,
        height = _getCanvasTextDim2.height;

    return {
      text: textContent,
      inlineStyle: inlineStyle,
      width: width,
      height: height
    };
  });
}

function mergeTspansProps(transPropGroup) {
  var lines = [];
  var line = []; // 首尾合并：上一个span的最后一个tspan和下一个span的第一个tspan在一行
  // 1、如果span中只有一个tspan，则tspan和上一个span的尾tspan、下一个span的首tspan位于一行
  // 2、如果span中含有多个tspan，则首tspan和上一个span的尾tspan位于一行，中间的tspan独占一行

  transPropGroup.forEach(function (transProp) {
    for (var i = 0, len = transProp.length; i < len; i++) {
      if (transProp.length === 1) {
        line.push(transProp[i]);
      } else if (i === 0) {
        line.push(transProp[i]);
        lines.push(line);
        line = [];
      } else if (i < len - 1) {
        lines.push([transProp[i]]);
      } else if (i === len - 1) {
        line = [transProp[i]];
      }
    }
  }); // 添加最后一个span的最后一个tspan

  if (line.length > 0) {
    lines.push(line);
  }

  return lines;
}

function buildSvgTspansGroup(textStr, style) {
  var lowerStr = toLowerTag(textStr + '');
  var replacedDStr = replaceTag(lowerStr);
  var spansGroup = splitStr(replacedDStr);
  var svgTspansGroup = [];
  spansGroup.forEach(function (spans) {
    var tspansPropGroup = spans.map(function (span) {
      return getTspansProp(span, style);
    });
    var mergedTspansProps = mergeTspansProps(tspansPropGroup);
    svgTspansGroup = svgTspansGroup.concat(mergedTspansProps);
  });
  return svgTspansGroup;
} // 获取textStr对应的trans的尺寸


function getSvgTransSize(textStr, style) {
  if (style === void 0) {
    style = DEFAULT_FONT;
  }

  var svgTspansGroup = buildSvgTspansGroup(textStr + '', style);
  var width = 0,
      height = 0;
  svgTspansGroup.forEach(function (rowTspans) {
    width = Math.max(width, getRowWidth(rowTspans));
    height += getRowHeight(rowTspans);
  });
  return {
    width: width,
    height: height
  };
} // 获取含有tspan的二维数组


function getSvgTspans(textStr, style) {
  if (style === void 0) {
    style = DEFAULT_FONT;
  }

  var svgTspansGroup = buildSvgTspansGroup(textStr + '', style);
  addTranslate(svgTspansGroup);
  return svgTspansGroup;
}

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

/**
 * Created by eason on 16/6/20.
 */

/**
 * Created by eason on 16/6/7.
 * vml下面用path来构造所有的形状,输出vml的path
 */
var pathCommand = /([achlmrqstvz])[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029,]*((-?\d*\.?\d*(?:e[\-+]?\d+)?[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*,?[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*)+)/ig;
var pathValues = /(-?\d*\.?\d*(?:e[\-+]?\d+)?)[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*,?[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*/ig;
var concat = "concat",
    apply = "apply",
    upperCase = String.prototype.toUpperCase,
    mmax = Math.max,
    math = Math,
    round = math.round;
var PI = math.PI,
    abs = Math.abs,
    split = "split";
var p2s = /,?([achlmqrstvxz]),?/gi,
    val = /-?\d*\.?\d+(?:[eE][\-+]?\d+)?/g;
var S = " ",
    E = "",
    fillString = "fill",
    zoom = 1;

function path2vml(path) {
  var bites = /([clmz]),?([^clmz]*)/gi;
  var map = {
    M: "m",
    L: "l",
    C: "c",
    Z: "x",
    m: "t",
    l: "r",
    c: "v",
    z: "x"
  };
  var total = /[ahqstv]/ig,
      command = pathToAbsolute;
  String(path).match(total) && (command = path2curve);
  total = /[clmz]/g;

  if (command == pathToAbsolute && !String(path).match(total)) {
    var res = String(path).replace(bites, function (all, command, args) {
      var vals = [],
          isMove = command.toLowerCase() == "m",
          res = map[command];
      args.replace(val, function (value) {
        if (isMove && vals.length === 2) {
          res += vals + map[command == "m" ? "l" : "L"];
          vals = [];
        }

        vals.push(round(value * zoom));
      });
      return res + vals;
    });
    return res;
  }

  var pa = command(path),
      p,
      r;
  res = [];

  for (var i = 0, ii = pa.length; i < ii; i++) {
    p = pa[i];
    r = pa[i][0].toLowerCase();
    r == "z" && (r = "x");

    for (var j = 1, jj = p.length; j < jj; j++) {
      r += round(p[j] * zoom) + (j != jj - 1 ? "," : E);
    }

    res.push(r);
  }

  return res.join(S);
}

function parsePathString(pathString) {
  if (!pathString && typeof pathString != 'string') {
    return null;
  }

  var paramCounts = {
    a: 7,
    c: 6,
    h: 1,
    l: 2,
    m: 2,
    r: 4,
    q: 4,
    s: 4,
    t: 2,
    v: 1,
    z: 0
  },
      data = [];
  String(pathString).replace(pathCommand, function (a, b, c) {
    var params = [],
        name = b.toLowerCase();
    c.replace(pathValues, function (a, b) {
      b && params.push(+b);
    });

    if (name == "m" && params.length > 2) {
      data.push([b][concat](params.splice(0, 2)));
      name = "l";
      b = b == "m" ? "l" : "L";
    }

    if (name == "r") {
      data.push([b][concat](params));
    } else while (params.length >= paramCounts[name]) {
      data.push([b][concat](params.splice(0, paramCounts[name])));

      if (!paramCounts[name]) {
        break;
      }
    }
  });
  data.toString = path2string;
  return data;
}

function path2string() {
  return this.join(",").replace(p2s, "$1");
}

function path2curve(path, path2) {
  var p = pathToAbsolute(path),
      p2 = path2 && pathToAbsolute(path2),
      attrs = {
    x: 0,
    y: 0,
    bx: 0,
    by: 0,
    X: 0,
    Y: 0,
    qx: null,
    qy: null
  },
      attrs2 = {
    x: 0,
    y: 0,
    bx: 0,
    by: 0,
    X: 0,
    Y: 0,
    qx: null,
    qy: null
  },
      processPath = function (path, d, pcom) {
    var nx,
        ny,
        tq = {
      T: 1,
      Q: 1
    };

    if (!path) {
      return ["C", d.x, d.y, d.x, d.y, d.x, d.y];
    }

    !(path[0] in tq) && (d.qx = d.qy = null);

    switch (path[0]) {
      case "M":
        d.X = path[1];
        d.Y = path[2];
        break;

      case "A":
        path = ["C"][concat](a2c[apply](0, [d.x, d.y][concat](path.slice(1))));
        break;

      case "S":
        if (pcom == "C" || pcom == "S") {
          // In "S" case we have to take into account, if the previous command is C/S.
          nx = d.x * 2 - d.bx; // And reflect the previous

          ny = d.y * 2 - d.by; // command's control point relative to the current point.
        } else {
          // or some else or nothing
          nx = d.x;
          ny = d.y;
        }

        path = ["C", nx, ny][concat](path.slice(1));
        break;

      case "T":
        if (pcom == "Q" || pcom == "T") {
          // In "T" case we have to take into account, if the previous command is Q/T.
          d.qx = d.x * 2 - d.qx; // And make a reflection similar

          d.qy = d.y * 2 - d.qy; // to case "S".
        } else {
          // or something else or nothing
          d.qx = d.x;
          d.qy = d.y;
        }

        path = ["C"][concat](q2c(d.x, d.y, d.qx, d.qy, path[1], path[2]));
        break;

      case "Q":
        d.qx = path[1];
        d.qy = path[2];
        path = ["C"][concat](q2c(d.x, d.y, path[1], path[2], path[3], path[4]));
        break;

      case "L":
        path = ["C"][concat](l2c(d.x, d.y, path[1], path[2]));
        break;

      case "H":
        path = ["C"][concat](l2c(d.x, d.y, path[1], d.y));
        break;

      case "V":
        path = ["C"][concat](l2c(d.x, d.y, d.x, path[1]));
        break;

      case "Z":
        path = ["C"][concat](l2c(d.x, d.y, d.X, d.Y));
        break;
    }

    return path;
  },
      fixArc = function (pp, i) {
    if (pp[i].length > 7) {
      pp[i].shift();
      var pi = pp[i];

      while (pi.length) {
        pcoms1[i] = "A"; // if created multiple C:s, their original seg is saved

        p2 && (pcoms2[i] = "A"); // the same as above

        pp.splice(i++, 0, ["C"][concat](pi.splice(0, 6)));
      }

      pp.splice(i, 1);
      ii = mmax(p.length, p2 && p2.length || 0);
    }
  },
      fixM = function (path1, path2, a1, a2, i) {
    if (path1 && path2 && path1[i][0] == "M" && path2[i][0] != "M") {
      path2.splice(i, 0, ["M", a2.x, a2.y]);
      a1.bx = 0;
      a1.by = 0;
      a1.x = path1[i][1];
      a1.y = path1[i][2];
      ii = mmax(p.length, p2 && p2.length || 0);
    }
  },
      pcoms1 = [],
      // path commands of original path p
  pcoms2 = [],
      // path commands of original path p2
  pfirst = "",
      // temporary holder for original path command
  pcom = ""; // holder for previous path command of original path


  for (var i = 0, ii = Math.max(p.length, p2 && p2.length || 0); i < ii; i++) {
    p[i] && (pfirst = p[i][0]); // save current path command

    if (pfirst != "C") // C is not saved yet, because it may be result of conversion
      {
        pcoms1[i] = pfirst; // Save current path command

        i && (pcom = pcoms1[i - 1]); // Get previous path command pcom
      }

    p[i] = processPath(p[i], attrs, pcom); // Previous path command is inputted to processPath

    if (pcoms1[i] != "A" && pfirst == "C") {
      pcoms1[i] = "C";
    }

    ; // A is the only command
    // which may produce multiple C:s
    // so we have to make sure that C is also C in original path

    fixArc(p, i); // fixArc adds also the right amount of A:s to pcoms1

    if (p2) {
      // the same procedures is done to p2
      p2[i] && (pfirst = p2[i][0]);

      if (pfirst != "C") {
        pcoms2[i] = pfirst;
        i && (pcom = pcoms2[i - 1]);
      }

      p2[i] = processPath(p2[i], attrs2, pcom);

      if (pcoms2[i] != "A" && pfirst == "C") {
        pcoms2[i] = "C";
      }

      fixArc(p2, i);
    }

    fixM(p, p2, attrs, attrs2, i);
    fixM(p2, p, attrs2, attrs, i);
    var seg = p[i],
        seg2 = p2 && p2[i],
        seglen = seg.length,
        seg2len = p2 && seg2.length;
    attrs.x = seg[seglen - 2];
    attrs.y = seg[seglen - 1];
    attrs.bx = parseFloat(seg[seglen - 4]) || attrs.x;
    attrs.by = parseFloat(seg[seglen - 3]) || attrs.y;
    attrs2.bx = p2 && (parseFloat(seg2[seg2len - 4]) || attrs2.x);
    attrs2.by = p2 && (parseFloat(seg2[seg2len - 3]) || attrs2.y);
    attrs2.x = p2 && seg2[seg2len - 2];
    attrs2.y = p2 && seg2[seg2len - 1];
  }

  return p2 ? [p, p2] : p;
}

function q2c(x1, y1, ax, ay, x2, y2) {
  var _13 = 1 / 3,
      _23 = 2 / 3;

  return [_13 * x1 + _23 * ax, _13 * y1 + _23 * ay, _13 * x2 + _23 * ax, _13 * y2 + _23 * ay, x2, y2];
}

function l2c(x1, y1, x2, y2) {
  return [x1, y1, x2, y2, x2, y2];
}

function a2c(x1, y1, rx, ry, angle, large_arc_flag, sweep_flag, x2, y2, recursive) {
  // for more information of where this math came from visit:
  // http://www.w3.org/TR/SVG11/implnote.html#ArcImplementationNotes
  var _120 = PI * 120 / 180,
      rad = PI / 180 * (+angle || 0),
      res = [],
      xy,
      rotate = function (x, y, rad) {
    var X = x * math.cos(rad) - y * math.sin(rad),
        Y = x * math.sin(rad) + y * math.cos(rad);
    return {
      x: X,
      y: Y
    };
  };

  if (!recursive) {
    xy = rotate(x1, y1, -rad);
    x1 = xy.x;
    y1 = xy.y;
    xy = rotate(x2, y2, -rad);
    x2 = xy.x;
    y2 = xy.y;
    var cos = math.cos(PI / 180 * angle),
        sin = math.sin(PI / 180 * angle),
        x = (x1 - x2) / 2,
        y = (y1 - y2) / 2;
    var h = x * x / (rx * rx) + y * y / (ry * ry);

    if (h > 1) {
      h = math.sqrt(h);
      rx = h * rx;
      ry = h * ry;
    }

    var rx2 = rx * rx,
        ry2 = ry * ry,
        k = (large_arc_flag == sweep_flag ? -1 : 1) * math.sqrt(abs((rx2 * ry2 - rx2 * y * y - ry2 * x * x) / (rx2 * y * y + ry2 * x * x))),
        cx = k * rx * y / ry + (x1 + x2) / 2,
        cy = k * -ry * x / rx + (y1 + y2) / 2,
        f1 = math.asin(((y1 - cy) / ry).toFixed(9)),
        f2 = math.asin(((y2 - cy) / ry).toFixed(9));
    f1 = x1 < cx ? PI - f1 : f1;
    f2 = x2 < cx ? PI - f2 : f2;
    f1 < 0 && (f1 = PI * 2 + f1);
    f2 < 0 && (f2 = PI * 2 + f2);

    if (sweep_flag && f1 > f2) {
      f1 = f1 - PI * 2;
    }

    if (!sweep_flag && f2 > f1) {
      f2 = f2 - PI * 2;
    }
  } else {
    f1 = recursive[0];
    f2 = recursive[1];
    cx = recursive[2];
    cy = recursive[3];
  }

  var df = f2 - f1;

  if (abs(df) > _120) {
    var f2old = f2,
        x2old = x2,
        y2old = y2;
    f2 = f1 + _120 * (sweep_flag && f2 > f1 ? 1 : -1);
    x2 = cx + rx * math.cos(f2);
    y2 = cy + ry * math.sin(f2);
    res = a2c(x2, y2, rx, ry, angle, 0, sweep_flag, x2old, y2old, [f2, f2old, cx, cy]);
  }

  df = f2 - f1;
  var c1 = math.cos(f1),
      s1 = math.sin(f1),
      c2 = math.cos(f2),
      s2 = math.sin(f2),
      t = math.tan(df / 4),
      hx = 4 / 3 * rx * t,
      hy = 4 / 3 * ry * t,
      m1 = [x1, y1],
      m2 = [x1 + hx * s1, y1 - hy * c1],
      m3 = [x2 + hx * s2, y2 - hy * c2],
      m4 = [x2, y2];
  m2[0] = 2 * m1[0] - m2[0];
  m2[1] = 2 * m1[1] - m2[1];

  if (recursive) {
    return [m2, m3, m4][concat](res);
  } else {
    res = [m2, m3, m4][concat](res).join()[split](",");
    var newres = [];

    for (var i = 0, ii = res.length; i < ii; i++) {
      newres[i] = i % 2 ? rotate(res[i - 1], res[i], rad).y : rotate(res[i], res[i + 1], rad).x;
    }

    return newres;
  }
}

function pathToAbsolute(pathArray) {
  if (typeof pathArray == 'string') {
    pathArray = parsePathString(pathArray);
  }

  if (!pathArray || !pathArray.length) {
    return [["M", 0, 0]];
  }

  var res = [],
      x = 0,
      y = 0,
      mx = 0,
      my = 0,
      start = 0;

  if (pathArray[0][0] == "M") {
    x = +pathArray[0][1];
    y = +pathArray[0][2];
    mx = x;
    my = y;
    start++;
    res[0] = ["M", x, y];
  }

  var crz = pathArray.length === 3 && pathArray[0][0] === "M" && pathArray[1][0].toUpperCase() === "R" && pathArray[2][0].toUpperCase() === "Z";

  for (var r, pa, i = start, ii = pathArray.length; i < ii; i++) {
    res.push(r = []);
    pa = pathArray[i];

    if (pa[0] != upperCase.call(pa[0])) {
      r[0] = upperCase.call(pa[0]);

      switch (r[0]) {
        case "A":
          r[1] = pa[1];
          r[2] = pa[2];
          r[3] = pa[3];
          r[4] = pa[4];
          r[5] = pa[5];
          r[6] = +(pa[6] + x);
          r[7] = +(pa[7] + y);
          break;

        case "V":
          r[1] = +pa[1] + y;
          break;

        case "H":
          r[1] = +pa[1] + x;
          break;

        case "R":
          var dots = [x, y][concat](pa.slice(1));

          for (var j = 2, jj = dots.length; j < jj; j++) {
            dots[j] = +dots[j] + x;
            dots[++j] = +dots[j] + y;
          }

          res.pop();
          res = res[concat](catmullRom2bezier(dots, crz));
          break;

        case "M":
          mx = +pa[1] + x;
          my = +pa[2] + y;

        default:
          for (j = 1, jj = pa.length; j < jj; j++) {
            r[j] = +pa[j] + (j % 2 ? x : y);
          }

      }
    } else if (pa[0] == "R") {
      dots = [x, y][concat](pa.slice(1));
      res.pop();
      res = res[concat](catmullRom2bezier(dots, crz));
      r = ["R"][concat](pa.slice(-2));
    } else {
      for (var k = 0, kk = pa.length; k < kk; k++) {
        r[k] = pa[k];
      }
    }

    switch (r[0]) {
      case "Z":
        x = mx;
        y = my;
        break;

      case "H":
        x = r[1];
        break;

      case "V":
        y = r[1];
        break;

      case "M":
        mx = r[r.length - 2];
        my = r[r.length - 1];

      default:
        x = r[r.length - 2];
        y = r[r.length - 1];
    }
  }

  res.toString = path2string;
  return res;
}

function catmullRom2bezier(crp, z) {
  var d = [];

  for (var i = 0, iLen = crp.length; iLen - 2 * !z > i; i += 2) {
    var p = [{
      x: +crp[i - 2],
      y: +crp[i - 1]
    }, {
      x: +crp[i],
      y: +crp[i + 1]
    }, {
      x: +crp[i + 2],
      y: +crp[i + 3]
    }, {
      x: +crp[i + 4],
      y: +crp[i + 5]
    }];

    if (z) {
      if (!i) {
        p[0] = {
          x: +crp[iLen - 2],
          y: +crp[iLen - 1]
        };
      } else if (iLen - 4 == i) {
        p[3] = {
          x: +crp[0],
          y: +crp[1]
        };
      } else if (iLen - 2 == i) {
        p[2] = {
          x: +crp[0],
          y: +crp[1]
        };
        p[3] = {
          x: +crp[2],
          y: +crp[3]
        };
      }
    } else {
      if (iLen - 4 == i) {
        p[3] = p[2];
      } else if (!i) {
        p[0] = {
          x: +crp[i],
          y: +crp[i + 1]
        };
      }
    }

    d.push(["C", (-p[0].x + 6 * p[1].x + p[2].x) / 6, (-p[0].y + 6 * p[1].y + p[2].y) / 6, (p[1].x + 6 * p[2].x - p[3].x) / 6, (p[1].y + 6 * p[2].y - p[3].y) / 6, p[2].x, p[2].y]);
  }

  return d;
}

function rectPath(x, y, w, h, r) {
  var path;

  if (r) {
    var rx = r > w / 2 ? w / 2 : r;
    var ry = r > h / 2 ? h / 2 : r;
    path = [["M", x, y + ry], ["a", rx, ry, 0, 0, 1, rx, -ry], ["h", w - rx - rx], ["a", rx, ry, 0, 0, 1, rx, ry], ["v", h - ry - ry], ["a", rx, ry, 0, 0, 1, -rx, ry], ["h", rx + rx - w], ["a", rx, ry, 0, 0, 1, -rx, -ry], ["z"]];
  } else {
    path = [["M", x, y], ["l", w, 0], ["l", 0, h], ["l", -w, 0], ["z"]];
  }

  return path2vml(path);
}

function circlePath(x, y, r) {
  return path2vml([["M", x, y], ["m", 0, -r], ["a", r, r, 0, 1, 1, 0, 2 * r], ["a", r, r, 0, 1, 1, 0, -2 * r], ["z"]]);
}

function linePath(x1, y1, x2, y2) {
  return path2vml([["M", x1, y1], ["L", x2, y2]]);
}

var _default = {
  path2vml: path2vml,
  rectPath: rectPath,
  linePath: linePath,
  circlePath: circlePath
};
exports["default"] = _default;

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Base = _interopRequireDefault(__webpack_require__(11));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

var _tooltipFormatter = _interopRequireDefault(__webpack_require__(111));

var _EnvUtils = __webpack_require__(3);

var _richTextMount = __webpack_require__(46);

var _richTextDetail = __webpack_require__(47);

var _AutoFitUtils = __webpack_require__(17);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 15/7/3.
 * reused and modified tooltip component from echarts
 */
//Copyright (c) 2013, Baidu Inc.
//    All rights reserved.
//
//    Redistribution and use of this software in source and binary forms, with or
//    without modification, are permitted provided that the following conditions
//are met:
//
//    Redistributions of source code must retain the above copyright notice, this
//list of conditions and the following disclaimer.
//
//    Redistributions in binary form must reproduce the above copyright notice,
//    this list of conditions and the following disclaimer in the documentation
//and/or other materials provided with the distribution.
//
//    Neither the name of Baidu Inc. nor the names of its contributors may be used
//to endorse or promote products derived from this software without specific
//prior written permission of Baidu Inc.
//
//    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
//AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
//ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
//(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
//LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
//ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
var DEFAULT_DURATION = 0.4;
var WIDTH_MAGIC_NUMBER = 2;

var Tooltip = _Base["default"].extend({
  _gCssText: 'position:absolute;display:block;border-style:solid;white-space:nowrap;z-index:2000;transform:translate3d(0px,0px,0px);text-align:left;-webkit-user-select:none;-moz-user-select:none;-o-user-select:none;user-select:none;pointer-events:none;',
  _defaultCustomContentStyle: function () {
    var scale = (0, _AutoFitUtils.autoFitFontScale)(this.vanchart);
    return {
      color: 'rgba(255, 255, 255 ,1)',
      fontSize: 14 * scale + 'px',
      fontFamily: 'Verdana'
    };
  },
  _style: function (opt) {
    if (!opt) {
      return '';
    }

    var cssText = [];

    if (opt.animation && !opt.follow) {
      var transitionText = 'left ' + DEFAULT_DURATION + 's,' + 'top ' + DEFAULT_DURATION + 's';
      cssText.push('transition:' + transitionText);
      cssText.push('-moz-transition:' + transitionText);
      cssText.push('-webkit-transition:' + transitionText);
      cssText.push('-o-transition:' + transitionText);
    }

    var style = typeof opt.formatter !== 'object' ? opt.style || this._defaultCustomContentStyle() : opt.style;

    if (style && !opt.useRichText) {
      var fontStyle = _BaseUtils["default"].cssNormalization(style);

      for (var styleName in fontStyle) {
        if (styleName == 'color') {
          cssText.push(styleName + ':' + _ColorUtils["default"].colorToHex(fontStyle[styleName]));
        } else {
          cssText.push(styleName + ':' + fontStyle[styleName]);
        }
      }
    }

    if (opt.backgroundColor) {
      if (typeof opt.backgroundColor == 'string') {
        if ((0, _EnvUtils.isSupportSVG)()) {
          cssText.push('background-Color:' + opt.backgroundColor);
        } else {
          var msColor = _ColorUtils["default"].colorToHexARGB(opt.backgroundColor); // ms: #alpha+hex


          cssText.push('filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=' + msColor + ', endColorstr=' + msColor + ', GradientType=0)');
        }
      } else if (typeof opt.backgroundColor == 'object') {
        cssText = cssText.concat(_BaseUtils["default"].getGradientBackgroundCssText(opt.backgroundColor));
      }
    }

    cssText = cssText.concat(_BaseUtils["default"].getBorderCssText(opt));

    if (opt.shadow) {
      cssText.push('box-shadow:1px 1px 2px rgba(0,0,0,0.2)');
    }

    var padding = opt.padding;

    if (padding != null && padding != undefined) {
      padding = _BaseUtils["default"].reformCssArray(padding);
      cssText.push('padding:' + padding[0] + 'px ' + padding[1] + 'px ' + padding[2] + 'px ' + padding[3] + 'px');
    }

    cssText = cssText.join(';') + ';';
    return cssText;
  },
  doLayout: function (dom) {
    if (false) {}

    if (!this._tDom) {
      dom = dom || this.vanchart.getDivParentDom();
      this._tDom = document.createElement('div');
      this._hiddenDom = document.createElement('div');

      this._tDom.onselectstart = function () {
        return false;
      };

      this._tDom.style.position = 'absolute';
      this._hiddenDom.style.visibility = 'hidden';
      dom.appendChild(this._tDom);
      dom.appendChild(this._hiddenDom);
      this._tooltipHideTick = null;
    }
  },
  remove: function () {
    var dom = this.vanchart.getDivParentDom();

    if (this._tDom && dom && dom.contains(this._tDom)) {
      //@CHART-2024, IE11
      dom.removeChild(this._tDom);
      dom.removeChild(this._hiddenDom);
    }

    this._tDom = null;
  },

  /**
   * 根据toolbarIcon和提示内容，显示工具栏提示
   * @param  {Obejct} icon 触发mouseover的toolbarIcon
   * @param  {String} text 对应的提示内容
   */
  showWithToolbarIcon: function (icon, text) {
    var toolbar = icon.toolbar,
        opt = toolbar.options.tooltip;
    var tooltipDim = this.calculateTooltipDivDim(opt, text);
    var pos = icon.toolbar.calcToolbarTipPos(icon, tooltipDim);

    this._show(pos, opt, text);
  },
  showWithPoint: function (point, event, formatPoint) {
    var vanchartDim = this.vanchart.getChartBounds();

    if (point && point.options.tooltip && point.series.vanchart.renderer && (event ? _BaseUtils["default"].containsPoint(vanchartDim, event.containerPoint) : true)) {
      //todo 自动数据提示可能还需要触发鼠标悬浮效果，等王军回来再找他确认吧
      var fmtPoint = formatPoint || point,
          opt = fmtPoint.options.tooltip,
          // use formatPoint's style
      seriesChart = point.series;

      if (opt.useRichText) {
        this.showRichTextPoint(point, event, fmtPoint);
        return;
      }

      var tooltipText = (0, _tooltipFormatter["default"])(fmtPoint);
      var tooltipDim = this.calculateTooltipDivDim(opt, tooltipText); // 优先从地图那边取数据点提示的位置

      var pos = seriesChart.getTooltipPos(point, tooltipDim, event);
      pos && this._show(pos, opt, tooltipText);
    }
  },
  showRichTextPoint: function (point, event, fmtPoint) {
    var series = point.series;
    var tooltip = fmtPoint.options.tooltip;
    var formatter = tooltip.formatter;

    if (this.vanchart.isMouseDown) {
      return;
    }

    var richTextContent = (0, _richTextDetail.getTooltipRichTextDetail)(fmtPoint, tooltip.richText, tooltip.autoStyle, formatter);
    var richTextDim = (0, _richTextDetail.getRichTextDim)(richTextContent);
    var tooltipDivDim = this.calculateRichTextTooltipDivDim(tooltip, richTextDim);
    var pos = series.getTooltipPos(point, tooltipDivDim, event);
    clearTimeout(this._tooltipHideTick);
    (0, _richTextMount.createRichTextTooltip)(fmtPoint, richTextContent, this._tDom, tooltip.padding);
    this._tDom.style.cssText = this._gCssText + this._style(tooltip) + 'width:' + richTextDim.width + 'px;height:' + richTextDim.height + 'px;' + 'left:' + pos[0] + 'px;top:' + pos[1] + 'px;';
  },
  calculateRichTextTooltipDivDim: function (opt, richTextDim) {
    var padding = opt.padding,
        borderWidth = opt.borderWidth;
    return {
      width: richTextDim.width + padding * 2 + borderWidth * 2 + WIDTH_MAGIC_NUMBER,
      // CHART-1401
      height: richTextDim.height + padding * 2 + borderWidth * 2
    };
  },
  // 很脏地从原始html里返回字符串数组
  getMobileTextArray: function (point, event, formatPoint) {
    if (point && point.options.tooltip && point.series.vanchart.renderer) {
      var fmtPoint = formatPoint || point;
      var style = fmtPoint.options.tooltip.style;
      var tooltip = fmtPoint.options.tooltip;

      if (tooltip.useRichText) {
        var richText = tooltip.richText,
            autoStyle = tooltip.autoStyle,
            _formatter = tooltip.formatter;
        return (0, _richTextDetail.getTooltipRichTextDetail)(fmtPoint, richText, autoStyle, _formatter);
      } // 居然3个if (捂眼睛


      if (style) {
        style = _BaseUtils["default"].extend({}, style);
        var fontSize = style.fontSize;

        if (fontSize) {
          if (fontSize.indexOf('pt') !== -1) {
            fontSize = parseFloat(fontSize) * 4 / 3;
          }

          style.fontSize = parseFloat(fontSize) | 0;
        }

        if (style.color) {
          style.textFill = style.color;
        }
      }

      var formatter = tooltip.formatter,
          useHtml = tooltip.useHtml;

      if (typeof formatter !== 'object') {
        if (!useHtml) {
          var mobileFlowText = function (formatter, point) {
            try {
              // 用户自定义的，里面极有可能有抛错，如window.FR.contentFormat
              return _BaseUtils["default"].getFormatterFunction(formatter).call(point);
            } catch (e) {
              return '';
            }
          };

          return [[{
            text: mobileFlowText(formatter, fmtPoint),
            style: style
          }]];
        }

        fmtPoint.options.tooltip.formatter = fmtPoint.series.getDefaultTooltipFormatter();
      }

      var text = (0, _tooltipFormatter["default"])(fmtPoint);
      text = text.replace(/&lt/g, "<").replace(/&gt/g, ">"); // MOBILE-24221

      text = text.replace(/<br>|<br \/>/g, '\n');
      text = text.replace(/<[^<>]+>/g, '');
      text = text.replace(/&nbsp;/g, ' ');
      return text.split('\n').filter(function (line) {
        return line;
      }).map(function (line) {
        return [{
          style: style,
          text: line
        }];
      });
    }
  },
  // replace '-' with '&#150;' in ie 10, 11, edge;
  // innerHTML '-' will lead to repaint
  _getTooltipText: function () {
    // todo
    // browser detail version function
    // ie 10, 11, edge
    var ua = navigator.userAgent;
    var msie = ua.indexOf('MSIE ');

    if (ua.indexOf('Trident/7.0') > 0 || ua.indexOf('Edge/') > 0 || msie > 0 && parseInt(ua.substring(msie + 5, ua.indexOf('.', msie)), 10) === 10) {
      return function (text) {
        text += '';
        var replaced = '';
        var isContent = true;
        var i = -1;
        var len = text.length;
        var t;

        while (++i < len) {
          t = text.charAt(i);

          if (isContent && t === '-') {
            t = '&#150;';
          } else if (t === '<') {
            isContent = false;
          } else if (t === '>') {
            isContent = true;
          }

          replaced += t;
        }

        return replaced;
      };
    } else {
      return function (text) {
        return text;
      };
    }
  }(),
  _show: function (pos, opt, tooltipText) {
    if (pos && opt && tooltipText && !this.vanchart.isMouseDown) {
      clearTimeout(this._tooltipHideTick);
      this._tDom.innerHTML = this._getTooltipText(tooltipText);
      this._tDom.style.cssText = this._gCssText + this._style(opt) + 'left:' + pos[0] + 'px;top:' + pos[1] + 'px;';
    }
  },
  hide: function () {
    clearTimeout(this._tooltipHideTick);
    this._tooltipHideTick = setTimeout(function () {
      this.immediateHide();
    }.bind(this), 400);
  },
  immediateHide: function () {
    if (this._tDom) {
      this._tDom.style.display = 'none';
    }
  },
  calculateTooltipDivDim: function (opt, tooltipText) {
    opt = opt || '';
    var testDiv = this._hiddenDom;
    testDiv.innerHTML = this._getTooltipText(tooltipText);
    testDiv.style.cssText = this._gCssText + this._style(opt) + 'visibility:hidden;';

    var widthAndHeight = _BaseUtils["default"].getComputedStyle(testDiv, 'width height border-left-width padding-left', function (x) {
      x = Math.ceil(window.parseFloat(x));
      return isNaN(x) ? 0 : x;
    });

    var width = widthAndHeight.width + widthAndHeight.borderLeftWidth * 2 + widthAndHeight.paddingLeft * 2;
    var height = widthAndHeight.height + widthAndHeight.borderLeftWidth * 2 + widthAndHeight.paddingLeft * 2; // CHART-1401
    // 不适用offsetHeight和offsetWidth，转而使用computedStyle的原因是：
    // offsetHeight得到的值是经过四舍五入计算之后的值，而真实绘制出来的DOM元素的width或者height是一个浮点数，
    // 网上说的浏览器绘制元素的最小单位是1px都是童话。

    return {
      // CHART-1401
      // 不管了，tooltip超出边界现在已经肯定不是图表的锅，调试模板的js又太麻烦了，
      // 而且这个问题也不大，来个快刀斩乱麻，直接给宽度加上2px，我看它还会不会超出来。
      width: width + WIDTH_MAGIC_NUMBER,
      height: height
    };
  },
  render: function () {//do nothing
  }
});

var _default = Tooltip;
exports["default"] = _default;

/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initState = initState;
exports.htmlDecode = htmlDecode;
exports.getFontStyle = getFontStyle;
exports.parseCssText = parseCssText;
exports.matchCssStyle = matchCssStyle;
exports.matchFontTag = matchFontTag;
exports.matchStyleAttr = matchStyleAttr;
exports.matchColorAttr = matchColorAttr;
exports.matchFontWeightTag = matchFontWeightTag;
exports.parseEndTag = parseEndTag;
exports.convert = convert;
exports.richTextParse = richTextParse;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var START_TAG_PATTERN = /<([-\w\d_]+)\s*([^>]*)\s*(\/?)>/;
var END_TAG_PATTERN = /^<\/([-\w\d_]+)[^>]*>/;
var ATTR_PATTERN = /([-\w\d_]+)\s*=[\s\\"']*([^\\"']*)[\\"']*/g;
var FILED_PATTERN = /([-\w\d_]+)\s*=[\s\\"']*([^\\"']*)[\\"']*/g;
var COLOR_PATTERN = /rgb\s*\(\s*([0-9]+),\s*([0-9]+),\s*([0-9]+)\)/;
var END_TAG = "</";
var START_TAG = "<";
var PARAMETER = "data-id";
var SIZE_MAP = {
  "1": 10,
  "2": 13,
  "3": 16,
  "4": 18,
  "5": 24,
  "6": 32
};
var INITIAL_STYLE = {
  textAlign: '',
  textDecoration: '',
  fontFamily: '',
  fontSize: '',
  fontWeight: '',
  fontStyle: '',
  color: ''
};
var rowIndex = 0;
var styleId = 0;
var tags = [];
var styleList = [];
var content = [];
var styleMap = {};

var defaultFont = _BaseUtils["default"].extend({}, INITIAL_STYLE);

function initState() {
  rowIndex = 0;
  styleId = 0;
  content = [];
  tags = [];
  styleList = [];
  styleMap = {};
  defaultFont = _BaseUtils["default"].extend({}, INITIAL_STYLE);
}

function getFontStyle() {
  var style = _BaseUtils["default"].extend({}, defaultFont);

  for (var i = 0, len = styleList.length; i < len; i++) {
    var _styleList$i = styleList[i],
        textAlign = _styleList$i.textAlign,
        textDecoration = _styleList$i.textDecoration,
        fontFamily = _styleList$i.fontFamily,
        fontSize = _styleList$i.fontSize,
        fontWeight = _styleList$i.fontWeight,
        fontStyle = _styleList$i.fontStyle,
        color = _styleList$i.color;

    if (!(0, _CoreUtils.isEmpty)(textAlign)) {
      style.textAlign = textAlign;
    }

    if (!(0, _CoreUtils.isEmpty)(textDecoration)) {
      style.textDecoration = textDecoration;
    }

    if (!(0, _CoreUtils.isEmpty)(fontFamily)) {
      style.fontFamily = fontFamily;
    }

    if (!(0, _CoreUtils.isEmpty)(fontSize)) {
      style.fontSize = fontSize;
    }

    if (!(0, _CoreUtils.isEmpty)(fontWeight)) {
      style.fontWeight = fontWeight;
    }

    if (!(0, _CoreUtils.isEmpty)(fontStyle)) {
      style.fontStyle = fontStyle;
    }

    if (!(0, _CoreUtils.isEmpty)(color)) {
      style.color = parseTextFill(color);
    }
  }

  return style;
}

function dealTagStart(tagName, attr) {
  var isRowElement = false;

  if (tagName === "img") {
    parseField(attr);
  } else {
    isRowElement = tagName === "div" || tagName === "p" || tagName === "br";

    if (isRowElement && content && content.length) {
      autoAddLineIndex();
    }

    parseStartTag(tagName, attr);
  }
}

function parseField(attr) {
  var prop = {};
  var match = FILED_PATTERN.exec(attr);

  while (match && match.length) {
    prop[match[1]] = match[2];
    match = FILED_PATTERN.exec(attr);
  }

  autoAddStyleId();
  styleMap[styleId + ""] = getFontStyle();
  content.push({
    rowIndex: rowIndex,
    styleId: styleId,
    text: prop[PARAMETER] || '',
    isField: true
  });
}

function parseTextFill(color) {
  if (color === "" || color === "inherit") {
    return "";
  }

  return color;
}

function parseCssText(cssText, style) {
  if (cssText === "") {
    return;
  }

  cssText = cssText.toLowerCase().replace(/&apos;/g, "'").replace(/&quot;/g, "\"").replace(/\\s/g, "");
  var cssStyleGroup = cssText.split(";");

  for (var i = 0, len = cssStyleGroup.length; i < len; i++) {
    var cssStyle = cssStyleGroup[i].split(":");

    if (cssStyle && cssStyle.length === 2) {
      matchCssStyle(cssStyle[0], cssStyle[1], style);
    }
  }
}

function matchCssStyle(key, value, style) {
  if (key == null || value == null) {
    return;
  }

  key = _BaseUtils["default"].trim(key);
  value = _BaseUtils["default"].trim(value);

  if (key === "text-align") {
    style.textAlign = value;
  }

  if (key === "font-family") {
    style.fontFamily = value;
  }

  if (key === "font-size") {
    style.fontSize = value;
  }

  if (key === "font-weight") {
    if (value === "italic") {
      style.fontStyle = value;
    } else if (value === "bold") {
      style.fontWeight = value;
    }
  }

  if (key === "color") {
    style.color = value;
  }
}

function matchFontTag(tagName, attr, style) {
  if (tagName === "font") {
    var match = ATTR_PATTERN.exec(attr);

    while (match && match.length) {
      if (match[1] === "face") {
        style.fontFamily = match[2];
      }

      if (match[1] === "size") {
        style.fontSize = SIZE_MAP[match[2]] + 'px';
      }

      if (match[1] === "color") {
        style.color = match[2];
      }

      match = ATTR_PATTERN.exec(attr);
    }
  }
}

function matchStyleAttr(attr, style) {
  var match = ATTR_PATTERN.exec(attr);

  while (match && match.length) {
    if (match[1] === "style") {
      var cssText = match[2];
      parseCssText(cssText, style);
    }

    match = ATTR_PATTERN.exec(attr);
  }
}

function matchColorAttr(attr, style) {
  var match = attr.match(COLOR_PATTERN);

  if (!(match && match.length)) {
    return;
  }

  style.color = "rgb(" + match[1] + ', ' + match[2] + ', ' + match[3] + ')';
}

function matchFontWeightTag(tagName, style) {
  if (tagName === "i" || tagName === "em") {
    style.fontStyle = "italic";
  }

  if (tagName === "b" || tagName === "strong") {
    style.fontWeight = "bold";
  }
}

function matchDecorationTag(tagName, style) {
  if (tagName === "u") {
    style.textDecoration = "underline";
  }
}

function parseStartTag(tagName, attr) {
  tags.push(tagName);

  var style = _BaseUtils["default"].extend({}, INITIAL_STYLE);

  matchFontTag(tagName, attr, style);
  matchStyleAttr(attr, style);
  matchColorAttr(attr, style);
  matchFontWeightTag(tagName, style);
  matchDecorationTag(tagName, style);
  styleList.push(style);
}

function parseEndTag(tagName) {
  if (styleList.length === 0) {
    return;
  }

  var newTags = [];
  var newStyles = [];
  var matched = false;

  for (var i = tags.length - 1; i >= 0; i--) {
    var curTagName = tags[i];

    if (!matched) {
      if (curTagName === tagName) {
        matched = true;
      }
    } else {
      newTags.unshift(curTagName);
      newStyles.unshift(styleList[i]);
    }
  }

  tags = newTags;
  styleList = newStyles;
}

function parseText(text) {
  autoAddStyleId();
  styleMap[styleId + ""] = getFontStyle();
  content.push({
    rowIndex: rowIndex,
    styleId: styleId,
    text: htmlDecode(text),
    isField: false
  });
}

function htmlDecode(text) {
  if (text === "") {
    return text;
  }

  return text.replace(/&amp;/g, "&").replace(/&dollar;/g, "$").replace(/&lcub;/g, "{").replace(/&rcub;/g, "}").replace(/&quot;/g, '"').replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/&nbsp;/g, " ");
}

function autoAddLineIndex() {
  ++rowIndex;
}

function autoAddStyleId() {
  ++styleId;
}

function convert(content, styleMap) {
  var result = [];

  if (content && content.length) {
    for (var i = 0, len = content.length; i < len; i++) {
      var _content$i = content[i],
          _rowIndex = _content$i.rowIndex,
          _styleId = _content$i.styleId,
          text = _content$i.text,
          isField = _content$i.isField;
      var style = styleMap[_styleId];
      var row = result[_rowIndex] || [];

      if (style && style.textAlign === '') {
        style.textAlign = 'left';
      }

      row.push({
        text: text,
        isField: isField,
        style: style
      });
      result[_rowIndex] = row;
    }
  }

  return result.filter(function (row) {
    return !(0, _CoreUtils.isEmpty)(row) && row.length;
  });
}

function richTextParse(richText) {
  if (richText === void 0) {
    richText = "";
  }

  initState();

  while (richText !== "") {
    var isTextNode = true;

    if (richText.length > 1 && richText.substring(0, 2) === END_TAG) {
      var match = richText.match(END_TAG_PATTERN);

      if (match && match.length) {
        isTextNode = false;
        parseEndTag(match[1]);
        richText = richText.substring(match.index + match[0].length);
      }
    } else if (richText.substring(0, 1) === START_TAG) {
      var _match = richText.match(START_TAG_PATTERN);

      if (_match && _match.length) {
        isTextNode = false;
        dealTagStart(_match[1], _match[2]);
        richText = richText.substring(_match.index + _match[0].length);
      }
    }

    if (isTextNode) {
      var index = richText.indexOf(START_TAG);
      var textNode = index < 0 ? richText : richText.substring(0, index);
      parseText(textNode);
      richText = index < 0 ? "" : richText.substring(index);
    }
  }

  return convert(content, styleMap);
}

/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Renderer = _interopRequireDefault(__webpack_require__(59));

var _PathUtils = _interopRequireDefault(__webpack_require__(72));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _ColorUtils = _interopRequireDefault(__webpack_require__(5));

var _DomUtils = _interopRequireDefault(__webpack_require__(6));

var _wrapper = _interopRequireDefault(__webpack_require__(41));

var _types = __webpack_require__(50);

var _ElementWrapper = __webpack_require__(42);

var _CoreUtils = __webpack_require__(2);

var _EnvUtils = __webpack_require__(3);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 16/6/1.
 */
var CSS = "position:absolute;left:0px;top:0px;width:1px;height:1px;behavior:url(#default#VML);display:inline-block;";
var SubCss = "position:absolute;behavior:url(#default#VML);display:inline-block;";

var VmlRenderer = _Renderer["default"].extend({
  type: _types.VML_RENDERER,
  _initContainer: function () {
    var root = this.div().style({
      'white-space': 'nowrap',
      'display': 'inline-block'
    });

    _DomUtils["default"].addClass(root.node(), 'van-vml');

    this.dom.appendChild(root.node()); //vml可以和div混合

    this._divContainer = root;
    this._container = root;
    return root;
  },
  line: function (attrs) {
    return this._shapeWithPath(attrs, 'line');
  },
  rect: function (attrs) {
    return this._shapeWithPath(attrs, 'rect');
  },
  circle: function (attrs) {
    return this._shapeWithPath(attrs, 'circle');
  },
  path: function (attrs) {
    return this._shapeWithPath(attrs, 'path');
  },
  image: function (attrs) {
    var image = (0, _wrapper["default"])(document.createElement('image'), this).setType('image');
    image.attr(attrs);
    return image;
  },
  //ie8 group套group就显示不出了,奇葩
  group: function (attrs) {
    var group = this.div().style({
      'white-space': 'nowrap',
      'pointer-events': 'none'
    });
    return group.attr(attrs);
  },
  colorGradient: function (attrs, stops, type) {
    type = type || 'linearGradient';
    return {
      type: type,
      attrs: attrs,
      stops: stops,
      elements: []
    };
  },
  toPatternProperty: function (patternEl) {
    return "url(#" + _BaseUtils["default"].stamp(patternEl) + ")";
  },
  updateColorGradient: function (gradient, attrs, stops) {
    gradient.attrs = attrs;
    gradient.stops = stops;
  },
  //todo 怎样和svg的效果统一
  _updateGradientFill: function (elementWrapper, colorGradient) {
    var node = elementWrapper.node(),
        fill = elementWrapper._fill;
    var stops = colorGradient.stops,
        attrs = colorGradient.attrs;

    if (fill) {
      node.removeChild(fill);
      fill.on = true;
      fill.method = "none";
      fill.color = stops[0]['stop-color'];
      fill.color2 = stops[stops.length - 1]['stop-color'];
      var clrs = [];

      for (var i = 0, ii = stops.length; i < ii; i++) {
        var offset = stops[i].offset * 100 + '%';
        clrs.push(offset + ' ' + stops[i]['stop-color']);
      } // fill.colors = clrs.length ? clrs.join() : "0% " + fill.color;


      fill.type = "gradient";
      fill.angle = attrs.x1 == attrs.x2 ? 0 : 270;
      node.appendChild(fill);
    }
  },
  textContent: function (elementW, text) {},
  text: function () {
    return this.vtext(false);
  },
  tspan: function () {
    return this.vtspan(false);
  },
  _shapeWithPath: function (attrs, type) {
    var shape = (0, _wrapper["default"])(this.create('shape'), this).setType(type),
        container = shape.rawElement;
    container.style.cssText = CSS;
    container.coordsize = '1 1';
    return shape.attr(attrs);
  },
  create: function () {
    try {
      document.namespaces.add('lvml', 'urn:schemas-microsoft-com:vml');
      return function (name) {
        return document.createElement('<lvml:' + name + ' class="lvml">');
      };
    } catch (e) {
      return function (name) {
        return document.createElement('<' + name + ' xmlns="urn:schemas-microsoft.com:vml" class="lvml">');
      };
    }
  }(),
  createClip: function (attrs, type) {
    if (type && type != 'rect') {
      return;
    }

    return {
      'x': attrs.x,
      'y': attrs.y,
      'width': attrs.width,
      'height': attrs.height,
      'clipped': []
    };
  },
  _getClipStr: function (elementWrapper, attrs) {
    var top = attrs.y || 0,
        left = attrs.x || 0;

    if (elementWrapper.type != 'div') {
      var node = elementWrapper.isLineChart ? elementWrapper.node().parentNode.firstChild : elementWrapper.node(); // @CHART-1968 VML-Clip  这里我们通过修改visibility去强制浏览器重绘从而更新clip
      // @CHART-2557 之前的报表tab的切换用的是display:none，导致的我们拿到的domSize不对，后来那边统一改成了visibility:hidden
      // 那么这里在触发重绘之后，重置visibility属性，不然父元素visibility:hidden之后这个node还是可以看得见的

      var lastVisibilityValue = node.style.visibility;
      node.style.visibility = 'hidden';
      node.style.visibility = 'visible';
      node.style.visibility = lastVisibilityValue;
      top -= node.offsetTop;
      left -= node.offsetLeft;
    }

    var right = left + attrs.width,
        bottom = top + attrs.height;
    return 'rect(' + top + 'px ' + right + 'px ' + bottom + 'px ' + left + 'px)';
  },
  clip: function (elementWrapper, clipWrapper) {
    if (clipWrapper) {
      var node;

      if (elementWrapper.node && (node = elementWrapper.node())) {
        node.style.clip = this._getClipStr(elementWrapper, clipWrapper);
        node.clip = "True";
        clipWrapper.clipped.indexOf(elementWrapper) < 0 && clipWrapper.clipped.push(elementWrapper);
      }
    }
  },
  updateClip: function (clipWrapper, attrs) {
    var renderer = this;

    if (clipWrapper) {
      _BaseUtils["default"].extend(clipWrapper, attrs);

      clipWrapper.clipped.forEach(function (elementWrapper) {
        var node = elementWrapper.node();

        if (node) {
          node.style.clip = renderer._getClipStr(elementWrapper, clipWrapper);
        }
      });
    }
  },
  _update: function () {
    if (this._map && this._map._animatingZoom && this._bounds) {
      return;
    }

    _Renderer["default"].prototype._update.call(this);

    this.fire('update');
  },
  imagePattern: function (p, attrs) {},
  createDropShadowFilter: function () {
    return {};
  },
  createInnerShadowFilter: function () {
    return {};
  },
  attr: function (domWrapper, args) {
    if (!args || args.length <= 0 || !args[0]) {
      return;
    }

    var attrs = {},
        elem = domWrapper.rawElement;

    if (args.length === 2) {
      attrs[args[0]] = args[1];
    } else {
      attrs = args[0];
    }

    var oldAttrs = domWrapper.attrs,
        type = domWrapper.type;

    if (oldAttrs) {
      attrs = _BaseUtils["default"].extend(oldAttrs, attrs);
    } else {
      // avoid revising original attr obj
      attrs = _BaseUtils["default"].extend({}, attrs);
    }

    domWrapper.attrs = attrs; // transform属性先屏蔽掉,暂时只更新矩形

    if (attrs.transform) {
      var transform = (0, _ElementWrapper.transformParser)(attrs.transform);

      try {
        if (transform.translate) {
          elem.style.left = transform.translate[0] + 'px';
          elem.style.top = transform.translate[1] + 'px';
        }
      } catch (e) {}

      if (transform.rotate) {}
    }

    if (type == 'image') {
      elem.style.position = 'absolute';
      elem.style.left = attrs.x + 'px';
      elem.style.top = attrs.y + 'px';
      elem.style.width = attrs.width + 'px';
      elem.style.height = attrs.height + 'px';
    } else if (type != 'group') {
      var pathStr = '';

      if (type == 'rect') {
        pathStr = _PathUtils["default"].rectPath(attrs.x || 0, attrs.y || 0, attrs.width, attrs.height, attrs.rx);
      } else if (type == 'line') {
        pathStr = _PathUtils["default"].linePath(attrs.x1, attrs.y1, attrs.x2, attrs.y2);
      } else if (type == 'path') {
        pathStr = _PathUtils["default"].path2vml(attrs.d);
      } else if (type == 'circle') {
        pathStr = _PathUtils["default"].circlePath(attrs.cx || 0, attrs.cy || 0, attrs.r);
      }

      elem.path = pathStr;
    }
  },
  style: function (domWrapper, styles) {
    var oldStyles = domWrapper.styles,
        newStyles = {},
        elem = domWrapper.rawElement,
        styleName; // convert legacy

    if (styles && styles.color) {
      styles.fill = styles.color;
    }

    if (styles && styles.fill && domWrapper.type === 'div') {
      styles.color = styles.fill;
    } // Filter out existing styles to increase performance (#2640)


    if (oldStyles) {
      for (styleName in styles) {
        if (styles[styleName] !== oldStyles[styleName]) {
          newStyles[styleName] = styles[styleName];
        }
      }
    }

    if (domWrapper.type === 'div') {
      if (newStyles['transform']) {
        var trans = (0, _ElementWrapper.transformParser)(newStyles['transform'].replace(/px/gi, ''));

        if (trans.translate) {
          newStyles['transform'] = '';
          newStyles['x'] = trans.translate[0];
          newStyles['y'] = trans.translate[1];
        }
      }

      var map = {
        'x': 'left',
        'y': 'top',
        'dx': 'margin-left' // 'dy': 'margin-top'

      };

      for (var name in map) {
        var s;

        if ((s = newStyles[name]) != null) {
          // em or +'px' suffix
          newStyles[map[name]] = /em/gi.test(s) ? s : s + 'px';
          delete newStyles[name];
        }
      }
    } // Merge the new styles with the old ones


    if (oldStyles) {
      styles = _BaseUtils["default"].extend(oldStyles, newStyles);
    }

    domWrapper.styles = styles;

    if (domWrapper.type === 'div') {
      var hyphenate = function (a, b) {
        return '-' + b.toLowerCase();
      };

      var alpha;

      if (/rgba/i.test(styles.color)) {
        var c = _ColorUtils["default"].colorToHexAlpha(styles.color);

        styles.color = c.hex;
        alpha = c.alpha;
      }

      if (/rgb/i.test(styles.color)) {
        styles.color = _ColorUtils["default"].colorToHex(styles.color);
      }

      if ((0, _CoreUtils.hasDefined)(styles['fill-opacity'])) {
        alpha = (0, _CoreUtils.hasDefined)(alpha) ? alpha : 1;
        alpha *= styles['fill-opacity'];
      } // winserver下的ie8无法正确解析filter，修改的这个bug是把外层错误加上的filter给去掉让图表能出来


      if (alpha < 1 + 1e-6) {
        styles['filter'] = "progid:DXImageTransform.Microsoft.Alpha(Opacity=" + alpha * 100 + ")";
      }

      var serializedCss = '';

      for (styleName in styles) {
        if (styleName === 'filter' && !(0, _EnvUtils.isSupportBracketStyleBrowser)()) {
          continue;
        }

        serializedCss += styleName.replace(/([A-Z])/g, hyphenate) + ':' + styles[styleName] + ';';
      }

      elem.style.cssText = serializedCss;
    } else if (domWrapper.type != 'group') {
      if (domWrapper.type == 'image') {
        domWrapper.node().src = styles.src;
      } else {
        var stroke = domWrapper._stroke,
            fill = domWrapper._fill,
            container = domWrapper.node();
        container.stroked = true; //默认的样式

        container.filled = !!(styles.fill && styles.fill != 'none' || domWrapper.type == 'image');

        if (!stroke) {
          stroke = domWrapper._stroke = this.create('stroke');
          stroke.style.cssText = SubCss;
        }

        container.appendChild(stroke);
        stroke.weight = (styles['stroke-width'] || 0) + 'px';
        var strokeColor = styles.stroke;
        var strokeOpacity = (0, _CoreUtils.hasDefined)(styles['stroke-opacity']) ? styles['stroke-opacity'] : 1; //兼容rgba的写法

        if (strokeColor && strokeColor.indexOf('rgba') != -1) {
          strokeColor = _ColorUtils["default"].colorToHexAlpha(strokeColor);
          strokeOpacity *= strokeColor.alpha;
          strokeColor = strokeColor.hex;
        }

        stroke.color = strokeColor;
        stroke.opacity = styles['stroke-width'] ? strokeOpacity : 0;

        if (styles['stroke-dasharray']) {
          stroke.dashStyle = styles['stroke-dasharray'].replace(/( *, *)/g, ' ');
        } else {
          stroke.dashStyle = '';
        }

        if (styles['stroke-linecap'] == 'round') {
          stroke.endcap = 'round';
        }

        if (container.filled) {
          if (!fill) {
            fill = domWrapper._fill = this.create('fill');
            fill.style.cssText = SubCss;
          }

          container.appendChild(fill);
          var fillColor = styles.fill;
          var fillOpacity = (0, _CoreUtils.hasDefined)(styles['fill-opacity']) ? styles['fill-opacity'] : 1; //兼容rgba的写法

          if (fillColor.indexOf('rgba') != -1) {
            fillColor = _ColorUtils["default"].colorToHexAlpha(fillColor);
            fillOpacity *= fillColor.alpha;
            fillColor = fillColor.hex;
          }

          fill.color = fillColor;
          fill.opacity = Math.min(1, Math.max(fillOpacity, 0)); // todo 这之前肯定有操作导致的fillOpacity>1，从而在IE8下面报错，有时间在慢慢找吧
        } else if (fill) {
          container.removeChild(fill);
          domWrapper._fill = null;
        }
      }
    }

    if ('display' in styles) {
      domWrapper.node().style.display = styles.display;
    }

    if ('cursor' in styles) {
      domWrapper.node().style.cursor = styles.cursor;
    }
  },
  // assume there's no margin
  // if margin(as offset) is needed,
  // revise this func, record offset to other attr
  // then combine the offset and the rotate adjustment to margin.
  vRotate: function (domWrapper, deg) {
    deg = deg % 360;
    var dom = domWrapper.node();

    var originDim = _BaseUtils["default"].getTextBBoxWithRotation(domWrapper, 0);

    var rotatedDim = _BaseUtils["default"].getTextBBoxWithRotation(domWrapper, deg);

    var ow = originDim.width,
        oh = originDim.height;
    var rw = rotatedDim.width,
        rh = rotatedDim.height;

    _BaseUtils["default"].domRotate(dom, deg);

    dom.style.marginLeft = (ow - rw) / 2 + 'px';
    dom.style.marginTop = (oh - rh) / 2 + 'px';
  },
  // again, no dx/margin-left used,
  // or revise it
  vMiddle: function (domWrapper) {
    var dom = domWrapper.node();
    var ow = dom.offsetWidth;
    dom.style.marginLeft = -ow / 2 + 'px';
  },
  vLeft: function (domWrapper) {},
  vRight: function (domWrapper) {
    var dom = domWrapper.node();
    var ow = dom.offsetWidth;
    dom.style.marginLeft = -ow + 'px';
  }
});

var _default = VmlRenderer;
exports["default"] = _default;

/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 2017/2/15.
 */
//timer的定义
var d3_timer_queueHead,
    d3_timer_queueTail,
    d3_timer_interval,
    d3_timer_timeout,
    d3_timer_active,
    d3_timer_frame = _BaseUtils["default"].requestAnimFrame;

var Timer = function (callback, delay, then) {
  var n = arguments.length;

  if (n < 2) {
    delay = 0;
  }

  if (n < 3) {
    then = Date.now();
  }

  var time = then + delay,
      timer = {
    c: callback,
    t: time,
    f: false,
    n: null
  };

  if (d3_timer_queueTail) {
    d3_timer_queueTail.n = timer;
  } else {
    d3_timer_queueHead = timer;
  }

  d3_timer_queueTail = timer;

  if (!d3_timer_interval) {
    d3_timer_timeout = clearTimeout(d3_timer_timeout);
    d3_timer_interval = 1;
    d3_timer_frame(d3_timer_step);
  }
};

function d3_timer_step() {
  var now = d3_timer_mark(),
      delay = d3_timer_sweep() - now;

  if (delay > 24) {
    if (isFinite(delay)) {
      clearTimeout(d3_timer_timeout);
      d3_timer_timeout = _BaseUtils["default"].setTimeout(d3_timer_step, delay);
    }

    d3_timer_interval = 0;
  } else {
    d3_timer_interval = 1;
    d3_timer_frame(d3_timer_step);
  }
}

Timer.flush = function () {
  d3_timer_mark();
  d3_timer_sweep();
};

function d3_timer_mark() {
  var now = Date.now();
  d3_timer_active = d3_timer_queueHead;

  while (d3_timer_active) {
    if (now >= d3_timer_active.t) {
      d3_timer_active.f = d3_timer_active.c(now - d3_timer_active.t);
    }

    d3_timer_active = d3_timer_active.n;
  }

  return now;
}

function d3_timer_sweep() {
  var t0,
      t1 = d3_timer_queueHead,
      time = Infinity;

  while (t1) {
    if (t1.f) {
      t1 = t0 ? t0.n = t1.n : d3_timer_queueHead = t1.n;
    } else {
      if (t1.t < time) {
        time = t1.t;
      }

      t1 = (t0 = t1).n;
    }
  }

  d3_timer_queueTail = t0;
  return time;
}

;

Timer.getActiveTimer = function () {
  return d3_timer_active;
};

var _default = Timer;
exports["default"] = _default;

/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

/**
 * 移动端事件助手
 */
var touchEventConfig = {};

function setConfig(cfg) {
  touchEventConfig = cfg;
}

function getConfig(key) {
  return key != null ? touchEventConfig[key] : touchEventConfig;
}

var _default = {
  setConfig: setConfig,
  getConfig: getConfig
};
exports["default"] = _default;

/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _localeText = _interopRequireDefault(__webpack_require__(35));

var _DomUtils = _interopRequireDefault(__webpack_require__(6));

var _renderer = _interopRequireDefault(__webpack_require__(24));

var _Browser = _interopRequireDefault(__webpack_require__(7));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by shine on 2018/12/10.
 */
// 空数据提示的图案-尺寸120px * 125px
var patternPathArrayIe8 = [{
  d: "M108.5,47.4l-7.7,57.2c-10.7,9.4-25.9,15-41.4,15c-14.1,0.1-27.7-4.8-38.5-13.8l11.8-86.5c0.7-5.3,5.6-9,11-8.3c0,0,0.1,0,0.1,0L85.5,17L108.5,47.4z",
  fill: "#fff"
}, {
  d: "M108.5,47.4l-16.4-2c-5.6-0.8-9.4-5.9-8.6-11.4L85.7,17L108.5,47.4z",
  fill: "#F4F4F4"
}, {
  d: "M6.2,29.7C1.6,31.5-0.7,36.6,1,41.2L2.1,44l20,52.8l10.5-77L8.7,28.8L6.2,29.7z",
  fill: "#979797"
}, {
  d: "M71.4,14.5C69.7,9.9,64.6,7.6,60,9.3l-7.6,2.9l19.3,2.7L71.4,14.5z",
  fill: "#979797"
}, {
  d: "M53,74.6c-1.2,3.4-1,7.2,0.6,10.4l2.9-1.4c-0.9-2.5-0.8-5.3,0.1-7.8c1.6-4.2,4.2-5.2,4.2-5.2l-2.2-2.9C58.7,67.6,55,69.1,53,74.6z",
  fill: "#DDDDDD"
}, {
  d: "M91.4,79.2c0-13.2-10.7-23.9-24-23.9c-13.2,0-24,10.7-24,23.9c0,13.2,10.7,23.9,24,23.9c4.7,0,9.2-1.4,13.2-3.9l6.4,7.6l2.7-2.2l-6.3-7.5C88.4,92.5,91.3,86,91.4,79.2z M67.4,98c-10.4,0-18.9-8.4-18.9-18.8s8.5-18.8,18.9-18.8s18.9,8.4,18.9,18.8C86.3,89.6,77.9,98,67.4,98C67.4,98,67.4,98,67.4,98z",
  fill: "#DDDDDD"
}, {
  d: "M105.3,118.4l-8.9-10.2l-0.6-0.7l-2-2.4c-0.8-1-2.3-1.1-3.3-0.2c0,0,0,0,0,0l-3.1,2.7c-1,0.8-1.1,2.3-0.2,3.3c0,0,0,0,0,0l0.9,1.1l0.7,0.8l10,11.4c0.8,1,2.3,1.1,3.3,0.2c0,0,0,0,0,0l3.1-2.7C106,120.8,106.1,119.4,105.3,118.4z",
  fill: "#DDDDDD"
}, {
  d: "M59.9,0c-21,0-40.6,10.9-51.5,28.8l24.3-9.2v-0.1c0.8-5.4,5.8-9.2,11.2-8.4l8.4,1.2l7.6-2.9c4.6-1.7,9.7,0.6,11.5,5.1l0.1,0.4l13,1.8l0.8,0.1l23.1,30.6l-0.1,0.9l-7.4,55c-1.7,1.4-3.5,2.8-5.3,4.1l0.6,0.7c1.6-1.2,3.1-2.3,4.6-3.6l0,0C113.1,93.1,120.1,77,120,60.1c0.2-33-26.5-60-59.7-60.1C60.2,0,60,0,59.9,0z",
  fill: "#DDDDDD"
}, {
  d: "M59.5,118.2c-14,0.1-27.5-4.6-38.4-13.4c0.1-0.4,0.1-0.7,0.2-1.3l0.9-6.6l-20-52.5C0.7,49.6,0,55,0,60.4c-0.2,17.5,7.5,34.2,20.9,45.4l0,0c10.8,9,24.4,13.8,38.4,13.7c10.1,0,20.1-2.4,29.2-6.8l-0.7-0.8C79,116,69.3,118.2,59.5,118.2z",
  fill: "#DDDDDD"
}];
var patternPathArray = [{
  d: "M21.6861532,105.868125 C8.56232631,94.8838731 0.212429854,78.359709 0.212429854,59.880479 C0.212429854,54.1840955 1.00586564,48.6734891 2.48799073,43.4536664 L22.649,98.9938826 L29.8304299,47.755 Z M59.9445727,2.27373675e-13 C92.9337243,2.27373675e-13 119.676716,26.8094036 119.676716,59.880479 C119.676716,77.3491812 112.21507,93.0707947 100.31259,104.017006 C101.601855,101.431409 101.93585,98.3020432 100.982765,95.6764616 L100.982765,95.6764616 L100.728,94.9798826 L107.347001,47.7557915 L85.4660013,18.6387915 L72.346,16.7888826 L71.4610072,14.3492268 C69.9550861,10.2006797 65.3654552,8.05535596 61.2144051,9.57025436 L61.2144051,9.57025436 L50.042,13.6468826 L42.8305214,12.6314795 C38.4498159,12.0141653 34.4135621,15.0621991 33.8003155,19.4373425 L33.8003155,19.4373425 L33.78,19.5818826 L8.98152276,28.6307416 C19.4824442,11.4570476 38.3788544,2.27373675e-13 59.9445727,2.27373675e-13 Z",
  fill: "#9D9D9D",
  opacity: 0.3
}, {
  d: "M100.728,94.9768826 L100.982765,95.6764616 C101.997482,98.4718299 101.553276,101.838245 100.051207,104.510569 C98.3525075,106.035263 96.5661693,107.464069 94.7006853,108.788491 C96.298204,107.635324 97.8364558,106.405043 99.3099089,105.102972 L99.3099089,105.102972 L100.728,94.9768826 Z M33.78,19.5818826 L22.649,98.9938826 L1.22819621,39.9802288 C-0.279795786,35.8259768 1.86154843,31.2306887 6.01387621,29.715324 L33.78,19.5818826 Z M71.4610072,14.3492268 L72.347,16.7898826 L50.042,13.6468826 L61.2144051,9.57025436 C65.3654552,8.05535596 69.9550861,10.2006797 71.4610072,14.3492268 Z",
  fill: "#8E8E8E",
  opacity: 0.69938151
}, {
  d: "M85.8592018,19.448828 L107.46743,48.2007765 L90.0638031,45.7485946 C85.6930747,45.1326864 82.6471655,41.0857006 83.2597822,36.7150512 L85.4496228,21.0918641 C85.5298171,20.5197267 85.6686523,19.9703052 85.8592018,19.448828 Z",
  fill: "#A7A7A7",
  opacity: 0.1
}, {
  d: "M95.3748961,104.873902 L105.633766,117.132637 C106.696782,118.402877 106.527565,120.300004 105.261031,121.365594 L102.868981,123.378128 C101.600109,124.445685 99.7101798,124.281903 98.6467241,123.011137 L88.3878545,110.752402 C87.3248384,109.482162 87.4940556,107.585035 88.7605896,106.519445 L91.152639,104.506911 C92.421511,103.439354 94.3114404,103.603136 95.3748961,104.873902 Z M68.7838584,55.3155994 C81.801999,55.3155994 92.355287,65.895095 92.355287,78.9455642 C92.355287,85.761736 89.4764532,91.9038503 84.8711975,96.2166335 L91.2729565,103.86633 L88.4003636,106.283167 L81.935358,98.5585057 C78.1787435,101.095028 73.6537675,102.575529 68.7838584,102.575529 C55.7657179,102.575529 45.2124299,91.9960334 45.2124299,78.9455642 C45.2124299,65.895095 55.7657179,55.3155994 68.7838584,55.3155994 Z M68.7838584,60.686046 C58.7243862,60.686046 50.5695727,68.8611108 50.5695727,78.9455642 C50.5695727,89.0300177 58.7243862,97.2050825 68.7838584,97.2050825 C78.8433307,97.2050825 86.9981441,89.0300177 86.9981441,78.9455642 C86.9981441,68.8611108 78.8433307,60.686046 68.7838584,60.686046 Z M59.8827396,66.9250971 L62.0152487,69.4938832 C59.2320766,71.8167394 57.5933822,75.2452735 57.5933822,78.9455642 C57.5933822,80.4102854 57.8482896,81.8374574 58.3403299,83.1812251 L58.3403299,83.1812251 L55.211225,84.3331282 C54.5845843,82.6217653 54.2600489,80.804761 54.2600489,78.9455642 C54.2600489,74.2419962 56.3466436,69.8763492 59.8827396,66.9250971 L59.8827396,66.9250971 Z",
  fill: "#B7B7B7",
  opacity: 0.496744792
}];
patternPathArray = _Browser["default"].ielt9 ? patternPathArrayIe8 : patternPathArray;
/**
 * 图片在组件内宽高等比例缩放，一旦图片的任意一条边等于组件的相应边，停止缩放：
 * 先判断图片的宽等于组件的宽时，图片的高进行等比例缩放时是否大于组件的高，
 * 如果大于，则根据图片的高等于组件的高来进行等比例缩放计算宽高；
 * 反之，返回图片的宽等于组件的宽时计算出的宽高
 */

function calculateTipSize(chartSize, imageSize) {
  var width = imageSize.width,
      height = imageSize.height;
  var chartWidth = chartSize.chartWidth,
      chartHeight = chartSize.chartHeight;
  var heightWithWidthScale = height * chartWidth / width;

  if (heightWithWidthScale <= chartHeight) {
    return {
      width: chartWidth,
      height: heightWithWidthScale
    };
  }

  var widthWithHeightScale = width * chartHeight / height;
  return {
    width: widthWithHeightScale,
    height: chartHeight
  };
}

function getEmptyDataImageSize(emptyDataImage, chartSize) {
  var width = emptyDataImage.width,
      height = emptyDataImage.height;

  if (!emptyDataImage.auto) {
    return {
      width: width,
      height: height
    };
  }

  var imageSize = calculateTipSize(chartSize, emptyDataImage);
  return {
    width: imageSize.width,
    height: imageSize.height
  };
}

function getEmptyDataImage(renderer, emptyDataGroup, emptyDataImage, chartSize) {
  var chartWidth = chartSize.chartWidth,
      chartHeight = chartSize.chartHeight;
  var src = emptyDataImage.src;
  var preloadImage = new Image();

  preloadImage.onload = function () {
    // @CHART-17355: 浏览器传递过来的宽高可能不准确, 这边使用图片自身宽高.
    emptyDataImage.width = preloadImage.width;
    emptyDataImage.height = preloadImage.height;
    var emptyDataImageSize = getEmptyDataImageSize(emptyDataImage, chartSize);
    var width = emptyDataImageSize.width,
        height = emptyDataImageSize.height;
    renderer.image().addTo(emptyDataGroup).attr({
      "width": width,
      "height": height,
      "x": (chartWidth - width) / 2,
      "y": (chartHeight - height) / 2,
      "preserveAspectRatio": "none"
    }).imageContent(src);
  };

  preloadImage.src = src;
  return {
    remove: function () {
      renderer && renderer.remove();
      renderer = null;
    },
    renderer: renderer
  };
} // ie8及以下浏览器不支持图案跟随图表区域自适应


function getEmptyDataTipTrans(chartSize, size) {
  if (_Browser["default"].ielt9) {
    return getEmptyDataTipTransIe8(chartSize, size);
  }

  var chartWidth = chartSize.chartWidth,
      chartHeight = chartSize.chartHeight;
  var width = size.tipWidth,
      height = size.tipHeight;
  var imageSize = calculateTipSize(chartSize, {
    width: width,
    height: height
  });
  var imageWidth = imageSize.width,
      imageHeight = imageSize.height;
  var scale = imageWidth / width;
  var translateX = (chartWidth - imageWidth) / 2,
      translateY = (chartHeight - imageHeight) / 2;
  return "translate(" + translateX + "," + translateY + ") scale(" + scale + ")";
}

function getEmptyDataTipTransIe8(chartSize, tipSize) {
  var chartWidth = chartSize.chartWidth,
      chartHeight = chartSize.chartHeight;
  var tipWidth = tipSize.tipWidth,
      tipHeight = tipSize.tipHeight;
  var translateX = (chartWidth - tipWidth) / 2,
      translateY = (chartHeight - tipHeight) / 2;
  return "translate(" + translateX + ", " + translateY + ")";
}

function showEmptyDataTip(attrs) {
  var dom = attrs.dom,
      emptyDataTip = attrs.emptyDataTip,
      chartWidth = attrs.chartWidth || 200,
      chartHeight = attrs.chartHeight || 200,
      chart = attrs.chart;

  if (!dom) {
    return;
  }

  if (!emptyDataTip || !emptyDataTip.enabled) {
    //空数据没有开启，直接返回
    return;
  }

  if (!chart) {
    chart = {
      options: {
        plotOptions: {
          animation: true
        }
      }
    };

    chart.getSize = function () {
      return [chartWidth, chartHeight];
    };
  }

  if (attrs.language) {
    _localeText["default"].setLocale(attrs.language);
  }

  var wrapDiv = dom;

  if (true) {
    wrapDiv = document.createElement('div');
    wrapDiv.style.cssText += ';position:absolute;width:100%;height:100%;left:0;top:0;pointer-events:none';
    wrapDiv.onselectstart = wrapDiv.onmousemove = wrapDiv.ondrag = _BaseUtils["default"].falseFn;
    dom.appendChild(wrapDiv);
  }

  var renderer = (0, _renderer["default"])(wrapDiv, chart);
  renderer.onAdd();
  var PATTERN_GAP = 10,
      TEXT_GAP = 5;
  var emptyDataClipGroup = renderer.group().add();
  renderer.clip(emptyDataClipGroup, renderer.createClip({
    x: 0,
    y: 0,
    width: chartWidth,
    height: chartHeight
  }));
  var emptyDataGroup = renderer.group().addTo(emptyDataClipGroup);
  var emptyDataImage = emptyDataTip.emptyDataImage;

  if (emptyDataImage) {
    return getEmptyDataImage(renderer, emptyDataGroup, emptyDataImage, {
      chartWidth: chartWidth,
      chartHeight: chartHeight
    });
  }

  var patternWidth = 120,
      patternHeight = 125;
  var tipWidth = patternWidth,
      tipHeight = patternHeight + PATTERN_GAP;
  emptyDataTip.content = emptyDataTip.content || []; // 先计算宽高，然后再排版绘制

  var contentArray = emptyDataTip.content.map(function (contentObj) {
    var text = _localeText["default"].i18nText("emptyDataTip"),
        style = contentObj.style;

    var textDim = _BaseUtils["default"].getTextDimension(text, style, false);

    tipWidth = Math.max(tipWidth, textDim.width);
    return {
      text: text,
      style: style,
      width: textDim.width,
      height: textDim.height
    };
  }); // 绘制图案并设置水平居中

  var patternGroup = renderer.group().attr("transform", "translate(" + (tipWidth - patternWidth) / 2 + ",0)").addTo(emptyDataGroup);
  patternPathArray.forEach(function (pathData) {
    var path = renderer.path().addTo(patternGroup);
    path.attr({
      "d": pathData.d
    }).style({
      "fill": pathData.fill,
      "opacity": pathData.opacity
    });
  }); // 绘制文字并设置偏移

  contentArray.forEach(function (contentObj, index, arr) {
    var x = (tipWidth - contentObj.width) / 2,
        y = tipHeight;
    tipHeight += contentObj.height + (index === arr.length - 1 ? 0 : TEXT_GAP);
    var text = renderer.text().addTo(emptyDataGroup);
    text.style(contentObj.style).attr({
      "dy": 0.85 * contentObj.height,
      "transform": "translate(" + x + "," + y + ")"
    }).textContent(contentObj.text);
  });
  var emptyDataTipTrans = getEmptyDataTipTrans({
    chartWidth: chartWidth,
    chartHeight: chartHeight
  }, {
    tipWidth: tipWidth,
    tipHeight: tipHeight
  });
  emptyDataGroup.attr("transform", emptyDataTipTrans);
  return {
    remove: function () {
      renderer && renderer.remove();
      wrapDiv && _DomUtils["default"].remove(wrapDiv);
      wrapDiv = null;
    },
    renderer: renderer
  };
}

var _default = showEmptyDataTip;
exports["default"] = _default;

/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Renderer = _interopRequireDefault(__webpack_require__(59));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _Animation = _interopRequireDefault(__webpack_require__(122));

var _canvasShape = _interopRequireDefault(__webpack_require__(80));

var _wrapper = _interopRequireDefault(__webpack_require__(41));

var _types = __webpack_require__(50);

var _EnvUtils = __webpack_require__(3);

var _StyleUtils = __webpack_require__(16);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by eason on 16/6/1.
 */
var count = 0;
var FILTER_SIZE = 2;
var BATCH = 4000;
var BATCH_TIME = 50; // ms

var ARRAY_CONSTRUCTOR = window['Uint8Array'] || window['Array'];

var CanvasRenderer = _Renderer["default"].extend({
  type: _types.CANVAS_RENDERER,
  _initContainer: function () {
    var dom = this.dom;
    var vanchart = this.vanchart;
    var config = this.config;
    var plotBounds = config || vanchart.bounds;
    this.dpr = config && config.dpr || 1;
    this._container = (0, _wrapper["default"])(this._createCanvas(dom, plotBounds), this);
    this.ctx = this._container.node().getContext("2d");
    this.ctx.scale(this.dpr, this.dpr);
    this.elements = [];
    this.ctx.lineCap = "round"; // todo,

    this.resetFilter();
    this.animation = new _Animation["default"]().frame(this.flush.bind(this)); // if (config.frameAlpha) {
    //     this.frameAlpha = config.frameAlpha;
    //     this.backContainer = new ElementWrapper(this._createCanvas(dom, plotBounds, dpr), this);
    //     this.backCtx = this.backContainer.node().getContext("2d");
    //     this.backCtx.scale(dpr, dpr);
    //     this.backCtx.globalCompositeOperation = 'copy';
    //     this.clearAll = this._clearWithAlpha;
    // }

    this._needToPaint = false;
    this._nowFillStyle = null;
    this._nowStrokeStyle = null;
    this._nowLineWidth = null;
    this._nextFillStyle = null;
    this._nextStrokeStyle = null;
    this._nextLineWidth = null;
  },
  resize: function () {
    this._setSize({
      x: this.left,
      y: this.top,
      width: this.vanchart.width,
      height: this.vanchart.height
    }, this._container.node());

    this.ctx.scale(this.dpr, this.dpr);
    this.needFill = this.needStroke = true;
  },
  marker: function (name, s) {
    switch (name) {
      case _Constants["default"].LOCATION:
        return this.iconLocation({
          x: s.x,
          y: s.y,
          size: s.radius * 2,
          fillStyle: s.color
        });

      case _Constants["default"].SQUARE_HOLLOW:
        return this.rect({
          x: s.x - s.radius,
          y: s.y - s.radius,
          width: s.radius * 2,
          height: s.radius * 2,
          fillStyle: null,
          lineWidth: 2,
          strokeStyle: s.color
        });

      case _Constants["default"].SQUARE:
        return this.rect({
          x: s.x - s.radius,
          y: s.y - s.radius,
          width: s.radius * 2,
          height: s.radius * 2,
          fillStyle: s.color
        });

      case _Constants["default"].DIAMOND_HOLLOW:
        return this.diamond({
          x: s.x,
          y: s.y,
          size: s.radius,
          fillStyle: null,
          lineWidth: 2,
          strokeStyle: s.color
        });

      case _Constants["default"].DIAMOND:
        return this.diamond({
          x: s.x,
          y: s.y,
          size: s.radius,
          fillStyle: s.color
        });

      case _Constants["default"].TRIANGLE_HOLLOW:
        return this.triangle({
          x: s.x,
          y: s.y,
          size: s.radius,
          fillStyle: null,
          lineWidth: 2,
          strokeStyle: s.color
        });

      case _Constants["default"].TRIANGLE:
        return this.triangle({
          x: s.x,
          y: s.y,
          size: s.radius,
          fillStyle: s.color
        });

      case _Constants["default"].CIRCLE_HOLLOW:
        return this.circle({
          x: s.x,
          y: s.y,
          r: s.radius,
          fillStyle: null,
          lineWidth: 2,
          strokeStyle: s.color
        });

      default:
      case _Constants["default"].CIRCLE:
        return this.circle({
          x: s.x,
          y: s.y,
          r: s.radius,
          fillStyle: s.color
        });
    }
  },
  _create: function (Shape, style) {
    var el = new Shape(this); // el.point = style; // tmp for hover event

    el.rawElement = el; // tmp for hover event

    this.elements.push(el);
    style && el.setStyle(style);
    return el;
  },
  _setSize: function (plotBounds, canvas) {
    var left = this.left = plotBounds.x,
        top = this.top = plotBounds.y,
        width = this.width = plotBounds.width,
        height = this.height = plotBounds.height,
        dpr = this.dpr;
    canvas.style.position = 'absolute';
    canvas.style.left = left + 'px';
    canvas.style.top = top + 'px';
    canvas.style.width = width + 'px';
    canvas.style.height = height + 'px';
    canvas.width = width * dpr;
    canvas.height = height * dpr;
  },
  _createCanvas: function (dom, plotBounds) {
    var canvas = (0, _EnvUtils.createCanvas)();

    this._setSize(plotBounds, canvas);

    canvas.onselectstart = function () {
      return false;
    };

    canvas.style['-webkit-user-select'] = 'none';
    canvas.style['user-select'] = 'none';
    canvas.style['pointer-events'] = 'none';
    canvas.style['-webkit-touch-callout'] = 'none';
    canvas.style['transform'] = 'translateZ(0)';
    dom.appendChild(canvas); //excanvas

    window.VanCanvasManager && VanCanvasManager.initElement(canvas);
    return canvas;
  },
  shouldFilter: function (x, y) {
    if (x < 0 || this.width < x || y < 0 || this.height < y) {
      ++count;
      return true;
    }

    x = x / FILTER_SIZE | 0;
    y = y / FILTER_SIZE | 0;
    var pos = y * this.width / FILTER_SIZE + x;

    if (this._cache[pos]) {
      ++count;
      return true;
    }

    this._cache[pos] = 1;
    return false;
  },
  resetFilter: function () {
    // console.log('filtered:', count);
    count = 0;
    this._cache = new ARRAY_CONSTRUCTOR(Math.floor(this.width / FILTER_SIZE * this.height / FILTER_SIZE)); // IE下面用Array需要传整数
  },
  flush: function () {
    _BaseUtils["default"].cancelAnimFrame(this._frame);

    this.clearAll();
    var elements = this.elements;
    var len = elements.length;
    var exists = [];

    for (var i = 0; i < len; i++) {
      if (!elements[i].needToRemove) {
        exists.push(elements[i]); // elements[i].drawStyle().draw();
      }
    }

    this.elements = exists; // console.log('to draw:', exists.length);

    this.flushIdx = 0;

    this._adaptFlush();
  },
  _nextBatch: function () {
    if (this.flushIdx < this.elements.length) {
      this._frame = _BaseUtils["default"].requestAnimFrame(this._adaptFlush, this);
    }
  },
  // @deprecated
  _flush: function () {
    // console.time('flush');
    this.ctx.beginPath();
    var elements = this.elements;
    var len = elements.length;
    var i = this.flushIdx;
    var to = Math.min(this.flushIdx + BATCH, len);

    for (; i < to; i++) {
      elements[i].drawStyle().draw();
    }

    this._fillStyle && this.ctx.fill();
    this._strokeStyle && this.ctx.stroke();
    this.flushIdx = i;

    this._nextBatch(); // console.timeEnd('flush');

  },
  _adaptFlush: function () {
    // console.time('flush');
    this._time = +new Date();
    this.ctx.beginPath();
    var elements = this.elements;
    var len = elements.length;
    var i = this.flushIdx - 1;

    while (++i < len) {
      elements[i].drawStyle().draw();

      if (i && !(i % 500)) {
        var t = +new Date();

        if (t - this._time > BATCH_TIME) {
          break;
        }
      }
    }

    this._fill();

    this._stroke();

    this.flushIdx = i;

    this._nextBatch(); // console.timeEnd('flush');

  },
  _clearWithAlpha: function () {
    var width = this.width,
        height = this.height;
    this.backCtx.drawImage(this._container.node(), 0, 0, width, height);
    this.ctx.clearRect(0, 0, width, height);
    var domBack = this.backContainer.node();
    var ctx = this.ctx;
    ctx.save();
    ctx.globalAlpha = this.frameAlpha;
    ctx.drawImage(domBack, 0, 0, width, height);
    ctx.restore();
  },
  clearAll: function () {
    this.ctx.clearRect(0, 0, this.width, this.height);
  },
  beginNewPath: function () {
    if (this._needToPaint) {
      this._fill();

      this._stroke();

      this.ctx.beginPath();
      this._needToPaint = false;
    }
  },
  // 直接拿ctx.fillStyle对比
  // 会因为小数点不一样得到错误的结果
  // 不获取ctx.fillStyle，而获取缓存的_nowFillStyle对比
  // 也不设置ctx.fillStyle，而存入将被读取的_nextFillStyle
  _fill: function () {
    if (this._nowFillStyle) {
      this.ctx.fillStyle = this._nowFillStyle;
      this.ctx.fill();
    }

    this._nowFillStyle = this._nextFillStyle;
  },
  _stroke: function () {
    if (this._nowStrokeStyle) {
      this.ctx.strokeStyle = this._nowStrokeStyle;
      this.ctx.lineWidth = this._nowLineWidth;
      this.ctx.stroke();
    }

    this._nowStrokeStyle = this._nextStrokeStyle;
    this._nowLineWidth = this._nextLineWidth;
  },
  lineWidth: function (lineWidth) {
    // lineWidth: Zero, negative, Infinity and NaN values are ignored.
    if (lineWidth && lineWidth !== this._nowLineWidth) {
      this._nextLineWidth = lineWidth;
      this._needToPaint = true;
    }
  },
  strokeStyle: function (strokeStyle) {
    if (strokeStyle !== this._nowStrokeStyle) {
      this._nextStrokeStyle = strokeStyle;
      this._needToPaint = true;
    }
  },
  fillStyle: function (fillStyle) {
    if (fillStyle !== this._nowFillStyle) {
      this._nextFillStyle = fillStyle;
      this._needToPaint = true;
    }
  },
  remove: function () {
    this.animation.clear();
    this.ctx = null;

    this._container.remove();
  },
  addBubbleSeries: function (series) {
    var ctx = this.ctx;
    ctx.save();

    for (var i = 0, len = series.points.length; i < len; i++) {
      var point = series.points[i];

      if (point.visible && !point.isNull) {
        ctx.fillStyle = point.color;
        ctx.globalAlpha = this.getPointOpacity(point);
        ctx.beginPath();
        ctx.arc(point.posX, point.posY, point.radius, 0, 2 * Math.PI);
        ctx.fill();
      }
    }

    ctx.restore();
  },
  getPointOpacity: function (point) {
    var series = point.series,
        target = series.vanchart.highlightTarget;

    if (target) {
      var key = series.name;
      return key == target || point._rangeItem == target ? 1 : _Constants["default"].HOVER_OPACITY;
    }

    return point.opacity;
  },
  addScatterSeries: function (series) {
    var ctx = this.ctx;
    ctx.save();

    for (var i = 0, len = series.points.length; i < len; i++) {
      var point = series.points[i];

      if (point.visible && !point.isNull) {
        var marker = point.options.marker,
            markerType = marker.symbol;
        var radius = (0, _StyleUtils.getMarkerRadius)(marker.radius);
        var color = marker.fillColor || point.color;
        ctx.translate(point.posX, point.posY);
        ctx.fillStyle = color;
        ctx.strokeStyle = color;
        ctx.globalAlpha = this.getPointOpacity(point);

        this._drawMarker(ctx, markerType, radius);

        ctx.translate(-point.posX, -point.posY);
      }
    }

    ctx.restore();
  },
  addSeries: function (series, canvasIndex) {
    if (series.visible) {
      switch (series.type) {
        case _Constants["default"].SCATTER_CHART:
          return this.addScatterSeries(series);

        case _Constants["default"].GANTT_CHART:
          return this.addGanttSeries(series, canvasIndex);

        default:
          return this.addBubbleSeries(series);
      }
    }
  },
  addGanttSeries: function (series, canvasIndex) {
    var render = this;
    var ctx = this.ctx;
    var startX = _Constants["default"].GANTT_CANVAS_WIDTH * canvasIndex;
    var endX = startX + _Constants["default"].GANTT_CANVAS_WIDTH;
    var pointsToDraw = series.getCanvasPointsToDraw(startX, endX);

    var rectBounds = function (rect) {
      var rectEndX = rect.x + rect.width;

      if (rect.x > endX) {
        return {
          x: 0,
          width: 0
        };
      }

      if (rect.x > startX) {
        return {
          x: rect.x % _Constants["default"].GANTT_CANVAS_WIDTH,
          width: rectEndX > endX ? endX - rect.x : rect.width
        };
      }

      return {
        x: 0,
        width: rectEndX > endX ? _Constants["default"].GANTT_CANVAS_WIDTH : rectEndX - startX
      };
    };

    ctx.save();
    pointsToDraw.forEach(function (point) {
      var leftRect = point.leftRect,
          rightRect = point.rightRect;
      var opacity = render.getPointOpacity(point);
      var leftBounds = rectBounds(leftRect);
      var rightBounds = rectBounds(rightRect);
      ctx.fillStyle = point.color;
      ctx.globalAlpha = opacity;
      ctx.fillRect(leftBounds.x, leftRect.y, leftBounds.width, leftRect.height);
      ctx.fillStyle = point.color;
      ctx.globalAlpha = opacity * 0.5;
      ctx.fillRect(rightBounds.x, rightRect.y, rightBounds.width, rightRect.height);
    });
    ctx.restore();
  },
  _drawMarker: function (ctx, markerType, R) {
    if (markerType.indexOf(_Constants["default"].CIRCLE) != -1) {
      ctx.beginPath();
      ctx.arc(0, 0, R, 0, 2 * Math.PI);
    } else if (markerType.indexOf(_Constants["default"].SQUARE) != -1) {
      ctx.beginPath();
      ctx.moveTo(-R, -R);
      ctx.lineTo(R, -R);
      ctx.lineTo(R, R);
      ctx.lineTo(-R, R);
      ctx.closePath();
    } else if (markerType.indexOf(_Constants["default"].DIAMOND) != -1) {
      R = R * 2 / Math.sqrt(2);
      ctx.beginPath();
      ctx.moveTo(-R, 0);
      ctx.lineTo(0, -R);
      ctx.lineTo(R, 0);
      ctx.lineTo(0, R);
      ctx.closePath();
    } else if (markerType.indexOf(_Constants["default"].TRIANGLE) != -1) {
      ctx.beginPath();
      ctx.moveTo(-R, R / Math.sqrt(3));
      ctx.lineTo(0, -(2 * Math.sqrt(3) / 3) * R);
      ctx.lineTo(R, R / Math.sqrt(3));
      ctx.closePath();
    } else {
      ctx.beginPath();
      ctx.arc(0, 0, R, 0, 2 * Math.PI);
    }

    if (markerType.indexOf('hollow') == -1) {
      //满填充
      ctx.fill();
    } else {
      ctx.fillStyle = 'white';
      ctx.lineWidth = 2;
      ctx.fill();
      ctx.stroke();
    }
  },

  /**
   * 根据鼠标位置寻找目标元素
   * @param pos
   * @returns {*}
   */
  findTargetByMousePosition: function (pos) {
    var elements = this.elements,
        len = elements.length,
        el;

    while (el = elements[--len]) {
      if (el.contain(pos)) {
        return el;
      }
    }
  }
});

CanvasRenderer.addShape = function (name, Shape) {
  CanvasRenderer.prototype[name] = function (style) {
    return this._create(Shape, style);
  };
};

for (var name in _canvasShape["default"]) {
  if (_canvasShape["default"].hasOwnProperty(name)) {
    CanvasRenderer.addShape(name, _canvasShape["default"][name]);
  }
}

var _default = CanvasRenderer;
exports["default"] = _default;

/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Arc = _interopRequireDefault(__webpack_require__(124));

var _Circle = _interopRequireDefault(__webpack_require__(125));

var _Diamond = _interopRequireDefault(__webpack_require__(126));

var _Image = _interopRequireDefault(__webpack_require__(127));

var _LineEffect = _interopRequireDefault(__webpack_require__(129));

var _Rect = _interopRequireDefault(__webpack_require__(130));

var _Triangle = _interopRequireDefault(__webpack_require__(131));

var _IconLocation = _interopRequireDefault(__webpack_require__(132));

var _Anchor = _interopRequireDefault(__webpack_require__(133));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var shapes = {};
shapes['arc'] = _Arc["default"];
shapes['circle'] = _Circle["default"];
shapes['diamond'] = _Diamond["default"];
shapes['iconLocation'] = _IconLocation["default"];
shapes['image'] = _Image["default"];
shapes['lineEffect'] = _LineEffect["default"];
shapes['rect'] = _Rect["default"];
shapes['triangle'] = _Triangle["default"];
shapes['anchor'] = _Anchor["default"];
var _default = shapes;
exports["default"] = _default;

/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _Bar = _interopRequireDefault(__webpack_require__(136));

var _Box = _interopRequireDefault(__webpack_require__(138));

var _Bubble = _interopRequireDefault(__webpack_require__(84));

var _ColumnRadar = _interopRequireDefault(__webpack_require__(141));

var _ForceBubble = _interopRequireDefault(__webpack_require__(142));

var _Funnel = _interopRequireDefault(__webpack_require__(143));

var _Line = _interopRequireDefault(__webpack_require__(144));

var _LineMap = _interopRequireDefault(__webpack_require__(145));

var _LineRadar = _interopRequireDefault(__webpack_require__(147));

var _Map = _interopRequireDefault(__webpack_require__(148));

var _MultiPie = _interopRequireDefault(__webpack_require__(149));

var _Pie = _interopRequireDefault(__webpack_require__(150));

var _PointerGauge = _interopRequireDefault(__webpack_require__(151));

var _WordCloud = _interopRequireDefault(__webpack_require__(153));

var _TreeMap = _interopRequireDefault(__webpack_require__(154));

var _ThermometerGauge = _interopRequireDefault(__webpack_require__(155));

var _RingGauge = _interopRequireDefault(__webpack_require__(157));

var _GanttSeries = _interopRequireDefault(__webpack_require__(158));

var _LevelBar = _interopRequireDefault(__webpack_require__(159));

var _Processes = _interopRequireDefault(__webpack_require__(160));

var _TimeAxis = _interopRequireDefault(__webpack_require__(162));

var _Axis = _interopRequireDefault(__webpack_require__(66));

var _CategoryAxis = _interopRequireDefault(__webpack_require__(56));

var _DataSheet = _interopRequireDefault(__webpack_require__(166));

var _DateAxis = _interopRequireDefault(__webpack_require__(98));

var _DrillTools = _interopRequireDefault(__webpack_require__(167));

var _GaugeAxis = _interopRequireDefault(__webpack_require__(168));

var _Geo = _interopRequireDefault(__webpack_require__(169));

var _GradientRangeLegend = _interopRequireDefault(__webpack_require__(185));

var _IntervalRangeLegend = _interopRequireDefault(__webpack_require__(187));

var _Legend = _interopRequireDefault(__webpack_require__(70));

var _AutoTip = _interopRequireDefault(__webpack_require__(188));

var _MultiCategoryAxis = _interopRequireDefault(__webpack_require__(99));

var _PolarAxis = _interopRequireDefault(__webpack_require__(189));

var _Title = _interopRequireDefault(__webpack_require__(193));

var _ToolBar = _interopRequireDefault(__webpack_require__(194));

var _Tooltip = _interopRequireDefault(__webpack_require__(73));

var _ValueAxis = _interopRequireDefault(__webpack_require__(68));

var _Zoom = _interopRequireDefault(__webpack_require__(196));

var _CrossLine = _interopRequireDefault(__webpack_require__(197));

var _PieIndicator = _interopRequireDefault(__webpack_require__(198));

var _PlotScroll = _interopRequireDefault(__webpack_require__(200));

var _component = __webpack_require__(4);

var _SlotGauge = _interopRequireDefault(__webpack_require__(201));

var _Scatter = _interopRequireDefault(__webpack_require__(202));

var _Structure = _interopRequireDefault(__webpack_require__(203));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// import GeoExport from "../map/geo/GeoExport";
var _registeredCharts = {};
_registeredCharts[_Constants["default"].COLUMN_CHART] = _Bar["default"];
_registeredCharts[_Constants["default"].BAR_CHART] = _Bar["default"];
_registeredCharts[_Constants["default"].BOX_CHART] = _Box["default"];
_registeredCharts[_Constants["default"].BUBBLE_CHART] = _Bubble["default"];
_registeredCharts[_Constants["default"].SCATTER_CHART] = _Scatter["default"];
_registeredCharts[_Constants["default"].COLUMN_RADAR] = _ColumnRadar["default"];
_registeredCharts[_Constants["default"].FORCE_BUBBLE_CHART] = _ForceBubble["default"];
_registeredCharts[_Constants["default"].FUNNEL_CHART] = _Funnel["default"];
_registeredCharts[_Constants["default"].LINE_CHART] = _Line["default"];
_registeredCharts[_Constants["default"].AREA_CHART] = _Line["default"];
_registeredCharts[_Constants["default"].STRUCTURE_CHART] = _Structure["default"];
_registeredCharts[_Constants["default"].LINE_MAP] = _LineMap["default"];
_registeredCharts[_Constants["default"].LINE_RADAR] = _LineRadar["default"];
_registeredCharts[_Constants["default"].POINT_MAP] = _Map["default"];
_registeredCharts[_Constants["default"].AREA_MAP] = _Map["default"];
_registeredCharts[_Constants["default"].HEAT_MAP] = _Map["default"];
_registeredCharts[_Constants["default"].MULTIPIE_CHART] = _MultiPie["default"];
_registeredCharts[_Constants["default"].PIE_CHART] = _Pie["default"];
_registeredCharts[_Constants["default"].POINTER_GAUGE] = _PointerGauge["default"];
_registeredCharts[_Constants["default"].POINTER_SEMI_GAUGE] = _PointerGauge["default"];
_registeredCharts[_Constants["default"].WORD_CLOUD_CHART] = _WordCloud["default"];
_registeredCharts[_Constants["default"].TREEMAP_CHART] = _TreeMap["default"];
_registeredCharts[_Constants["default"].THERMOMETER_GAUGE] = _ThermometerGauge["default"];
_registeredCharts[_Constants["default"].RING_GAUGE] = _RingGauge["default"];
_registeredCharts[_Constants["default"].SLOT_GAUGE] = _SlotGauge["default"];
_registeredCharts[_Constants["default"].GANTT_CHART] = _GanttSeries["default"]; //components

(0, _component.register)(_component.ComponentCst.LEVELBAR, _LevelBar["default"]);
(0, _component.register)(_component.ComponentCst.PROCESSES, _Processes["default"]);
(0, _component.register)(_component.ComponentCst.TIMEAXIS, _TimeAxis["default"]);
(0, _component.register)(_component.ComponentCst.X_AXIS_COMPONENT, _Axis["default"]);
(0, _component.register)(_component.ComponentCst.Y_AXIS_COMPONENT, _Axis["default"]);
(0, _component.register)(_component.ComponentCst.CATEGORY_AXIS_COMPONENT, _CategoryAxis["default"]);
(0, _component.register)(_component.ComponentCst.DATA_SHEET_COMPONENT, _DataSheet["default"]);
(0, _component.register)(_component.ComponentCst.DATE_AXIS_COMPONENT, _DateAxis["default"]);
(0, _component.register)(_component.ComponentCst.DRILL_TOOLS, _DrillTools["default"]);
(0, _component.register)(_component.ComponentCst.GAUGE_AXIS_COMPONENT, _GaugeAxis["default"]); // if(__export__) {
//     register(ComponentCst.GEO_COMPONENT, GeoExport);
// }else{

(0, _component.register)(_component.ComponentCst.GEO_COMPONENT, _Geo["default"]); // }

(0, _component.register)(_component.ComponentCst.GradientRangeLegend, _GradientRangeLegend["default"]);
(0, _component.register)(_component.ComponentCst.INTERVAL_RANGE_LEGEND, _IntervalRangeLegend["default"]);
(0, _component.register)(_component.ComponentCst.LEGEND_COMPONENT, _Legend["default"]);
(0, _component.register)(_component.ComponentCst.MORELABEL_COMPONENT, _AutoTip["default"]);
(0, _component.register)(_component.ComponentCst.MULTI_CATEGORY_AXIS_COMPONENT, _MultiCategoryAxis["default"]);
(0, _component.register)(_component.ComponentCst.RADIUS_AXIS_COMPONENT, _PolarAxis["default"]);
(0, _component.register)(_component.ComponentCst.ANGLE_AXIS_COMPONENT, _PolarAxis["default"]);
(0, _component.register)(_component.ComponentCst.POLAR_COMPONENT, _PolarAxis["default"]);
(0, _component.register)(_component.ComponentCst.TITLE_COMPONENT, _Title["default"]);
(0, _component.register)(_component.ComponentCst.TOOLBAR_COMPONENT, _ToolBar["default"]);
(0, _component.register)(_component.ComponentCst.TOOLTIP_COMPONENT, _Tooltip["default"]);
(0, _component.register)(_component.ComponentCst.VALUE_AXIS_COMPONENT, _ValueAxis["default"]);
(0, _component.register)(_component.ComponentCst.ZOOM_COMPONENT, _Zoom["default"]);
(0, _component.register)(_component.ComponentCst.CROSS_LINE, _CrossLine["default"]);
(0, _component.register)(_component.ComponentCst.PIE_INDICATOR, _PieIndicator["default"]);
(0, _component.register)(_component.ComponentCst.PLOT_SCROLL, _PlotScroll["default"]);

var _default = function _default(name) {
  return _registeredCharts[name];
};

exports["default"] = _default;

/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.seriesOfType = seriesOfType;
exports.isAutoRefreshChart = isAutoRefreshChart;

var _Constants = _interopRequireDefault(__webpack_require__(1));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function seriesOfType(series, type) {
  series = series || [];
  return series.filter(function (ser) {
    return ser.type == type;
  });
} // 树形结构系列或者钻取地图的监控刷新走全局刷新


function isAutoRefreshChart(options) {
  return options.refreshType == _Constants["default"].INCREMENT_TIP_REFRESH && options.chartType != _Constants["default"].MULTIPIE_CHART && options.chartType != _Constants["default"].TREEMAP_CHART && options.chartType != _Constants["default"].STRUCTURE_CHART && !_isDrillDownChart(options);
}

function _isDrillDownChart(options) {
  var seriess = options.series,
      series,
      data;

  if (seriess.length) {
    // 之前看过性能文章，用forEach等方法都没有原生for循环性能好，还是少写forEach啥的了，而且也不好退出
    for (var i = 0, len = seriess.length; i < len; i++) {
      series = seriess[i];
      data = series.data || [];

      if (data.length) {
        for (var j = 0, dataLen = data.length; j < dataLen; j++) {
          if (data[j].drilldown) {
            return true;
          }
        }
      }
    }
  }

  return false;
}

/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.verticalPosFix = verticalPosFix;
exports.horizontalPosFix = horizontalPosFix;
exports.adjustAutoChartLabel = adjustAutoChartLabel;

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _CoreUtils = __webpack_require__(2);

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _BoundsManager = _interopRequireDefault(__webpack_require__(27));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function verticalPosFix(start, end, step, labelDim, labelPos, manager) {
  for (var y = start; step < 0 ? y > end : y < end; y += step) {
    var pos = {
      x: labelPos.x,
      y: y
    };

    if (!manager.isOverlapped(_BaseUtils["default"].makeBounds(pos, labelDim))) {
      return pos;
    }
  }
}

function horizontalPosFix(start, end, step, labelDim, labelPos, manager) {
  for (var x = start; step < 0 ? x > end : x < end; x += step) {
    var pos = {
      x: x,
      y: labelPos.y
    };

    if (!manager.isOverlapped(_BaseUtils["default"].makeBounds(pos, labelDim))) {
      return pos;
    }
  }
}
/**
 * 根据category获取需要标签自动调整的points
 * @param category
 * @param vanchart
 * @returns {*}
 */


function getAutoLabelPointsWithCate(category, vanchart) {
  return vanchart.cateMap[category].filter(function (p) {
    // 柱形图自动时若竖排居内显示，无需重叠调整
    var isVerticalColumnLabel = p.options.dataLabels && vanchart.options.chartType !== _Constants["default"].MULTI_CHARTS && !p.options.dataLabels.useHtml && p.options.dataLabels.align === _Constants["default"].AUTO && p.series.type === _Constants["default"].COLUMN_CHART && p.labelAlign === _Constants["default"].INSIDE; // 折线图x轴为数值轴时，存在labelContent为空的point，无需考虑这样的point

    var isNotEmptyLabelContent = p.labelContent.length !== 0;
    return p.labelPos && !isVerticalColumnLabel && p.options.dataLabels.autoAdjust && isCategoryAxisChart(p.series.type) && isNotEmptyLabelContent;
  });
}

function isCategoryAxisChart(chartType) {
  return chartType === _Constants["default"].BAR_CHART || chartType === _Constants["default"].COLUMN_CHART || chartType === _Constants["default"].AREA_CHART || chartType === _Constants["default"].LINE_CHART;
}

function getAutoLabelPos(points, isHorizontalBaseAxis, toRightBottom) {
  var manager = new _BoundsManager["default"](),
      labelPosArr = [];

  for (var i = 0; i < points.length; i++) {
    var point = points[i];

    var labelPos = point.series._calculateAutoLabelPos(point, point.labelPos, isHorizontalBaseAxis, manager, toRightBottom, true);

    manager.addBounds(_BaseUtils["default"].makeBounds(labelPos, point.labelDim));
    labelPosArr.push(labelPos);
  }

  return labelPosArr;
}

function sortPoints(points, key, isOriginalPos, isDesc) {
  return points.sort(function (a, b) {
    var aLabelPos = isOriginalPos ? a.originalLabelPos : a.labelPos;
    var bLabelPos = isOriginalPos ? b.originalLabelPos : b.labelPos;
    var aPos = key === 'y' ? aLabelPos[key] + a.labelDim.height : aLabelPos[key];
    var bPos = key === 'y' ? bLabelPos[key] + b.labelDim.height : bLabelPos[key];
    return isDesc ? bPos - aPos : aPos - bPos;
  });
}
/**
 * 当标签超出边界时，根据分类将标签位置往中间调整
 * @param vanchart
 * @param isVertical
 * @private
 */


function adjustAutoLabelToMiddle(vanchart, isVertical) {
  var manager = new _BoundsManager["default"]();
  var needAdjustCatePoints = {};

  for (var category in vanchart.cateMap) {
    var points = getAutoLabelPointsWithCate(category, vanchart);
    var isNeedAdjust = points.filter(function (point) {
      return (0, _CoreUtils.isEmptyObj)(point.labelPos);
    }).length !== 0;

    if (isNeedAdjust) {
      needAdjustCatePoints[category] = points;
    } else {
      points.forEach(function (point) {
        manager.addBounds(_BaseUtils["default"].makeBounds(point.labelPos, point.labelDim));
      });
    }
  }

  if ((0, _CoreUtils.isEmptyObj)(needAdjustCatePoints)) {
    return;
  }

  var plotBounds = vanchart.bounds;
  var key = isVertical ? 'y' : 'x';
  var end = isVertical ? plotBounds.height : plotBounds.width;

  for (var cate in needAdjustCatePoints) {
    var catePoints = needAdjustCatePoints[cate];
    var leftTopPoints = [],
        rightBottomPoints = [];
    catePoints.forEach(function (point) {
      var pos = key === 'y' ? point.originalLabelPos[key] + point.labelDim.height : point.originalLabelPos[key];
      pos < end / 2 ? leftTopPoints.push(point) : rightBottomPoints.push(point);
    });
    leftTopPoints = sortPoints(leftTopPoints, key, true);
    rightBottomPoints = sortPoints(rightBottomPoints, key, true, true);
    fixPointLabelPos(leftTopPoints, manager, end, isVertical, true);
    fixPointLabelPos(rightBottomPoints, manager, end, isVertical, false);
  }
}

function fixPointLabelPos(points, manager, end, isVertical, toRightBottom) {
  var step = toRightBottom ? 3 : -3;
  var key = isVertical ? 'y' : 'x';
  points.forEach(function (point) {
    var labelDim = point.labelDim;
    var labelDistance = isVertical ? labelDim.height : labelDim.width;
    var posEnd = toRightBottom ? end - labelDistance : 0;
    var originalLabelPos = point.originalLabelPos;
    var startPos = toRightBottom ? Math.max(0, originalLabelPos[key]) : Math.min(end - labelDistance, originalLabelPos[key]);
    var testPos = isVertical ? verticalPosFix(startPos, posEnd, step, labelDim, originalLabelPos, manager) : horizontalPosFix(startPos, posEnd, step, labelDim, originalLabelPos, manager);
    point.labelPos = testPos || {};

    if (testPos) {
      manager.addBounds(_BaseUtils["default"].makeBounds(testPos, labelDim));
    }
  });
}
/**
 * 对柱形图，条形图，面积图，折线图的标签，开启标签重叠自动调整后进行位置调整
 * 先将所有标签按照原位置排序，然后获取向上调整后的标签和向下调整后的标签，
 * 向上向下调整后哪种方式标签显示的多，就选择哪种方式调整；
 * 再当标签超出边界时，根据分类将标签位置往中间调整
 * @param vanchart
 * @private
 */


function adjustAutoChartLabel(vanchart) {
  var allPoints = [];

  for (var category in vanchart.cateMap) {
    var points = getAutoLabelPointsWithCate(category, vanchart);
    allPoints = allPoints.concat(points);
  }
  /**
   * CHART-1532
   * 在所有包含x、y轴的图表类型当中，就条形图最特殊，它的基础轴是y轴，
   * 所以在这里将xAxis函数换成baseAxis函数
   */


  var isHorizontalBaseAxis = vanchart.baseAxis() && vanchart.baseAxis().isHorizontal();
  var key = isHorizontalBaseAxis ? 'y' : 'x';
  allPoints = sortPoints(allPoints, key); // 往下调整(条形图往右调整)

  var labelPosToRightBottom = getAutoLabelPos(allPoints, isHorizontalBaseAxis, true);
  var unVisibleLabelPosToRightBottom = labelPosToRightBottom.filter(function (labelPos) {
    return (0, _CoreUtils.isEmptyObj)(labelPos);
  }); // 往上调整(条形图往左调整)

  allPoints.reverse();
  var labelPosToLeftTop = getAutoLabelPos(allPoints, isHorizontalBaseAxis, false);
  var unVisibleLabelPosToLeftTop = labelPosToLeftTop.filter(function (labelPos) {
    return (0, _CoreUtils.isEmptyObj)(labelPos);
  });
  var isToRightBottom = unVisibleLabelPosToLeftTop.length > unVisibleLabelPosToRightBottom.length;
  var labelPosArr = isToRightBottom ? labelPosToRightBottom.reverse() : labelPosToLeftTop;
  allPoints.forEach(function (point, index) {
    point.originalLabelPos = point.labelPos;
    point.labelPos = labelPosArr[index];
  });
  adjustAutoLabelToMiddle(vanchart, isHorizontalBaseAxis);
}

/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Series = _interopRequireDefault(__webpack_require__(14));

var _BaseUtils = _interopRequireDefault(__webpack_require__(0));

var _Constants = _interopRequireDefault(__webpack_require__(1));

var _EffectHelper = _interopRequireDefault(__webpack_require__(19));

var _BezierEasing = _interopRequireDefault(__webpack_require__(8));

var _Browser = _interopRequireDefault(__webpack_require__(7));

var _CoreUtils = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Created by Mitisky on 16/3/14.
 */
var BUBBLE_INIT_TIME = 500;
var BUBBLE_UPDATE_TIME = 500;
var BUBBLE_EXIT_TIME = 300;
var BUBBLE_RE_SHOW_TIME = 300;
var CHOSEN_TIME = 200;
var CHOSEN_EASE = _BezierEasing["default"].custom["ease-out-back"];
var OUT_EASE = _BezierEasing["default"].css["ease-out"];

var Bubble = _Series["default"].extend({
  doLayout: function () {
    this._calculateBubblePosition();
  },
  useCanvas: function () {
    // 力学气泡图在渲染系列之前也使用当前的方法来判断是否需要使用canvas来渲染，
    // 但是力学气泡图可没有canvas的绘制逻辑，然后就会报错……
    return this.vanchart.chartType() !== _Constants["default"].FORCE_BUBBLE_CHART && this.options.large;
  },
  //用来计算百分比的指标的名字,相当于value的含义
  getTargetKey: function () {
    return 'size';
  },
  isNullValue: function (point) {
    var options = point.options;

    if (this.vanchart.isMap()) {
      return options.size == '-' || (0, _CoreUtils.hasNotDefined)(options.size);
    } else {
      return options.x == '-' || options.y == '-' || options.size == '-' || (0, _CoreUtils.hasNotDefined)(options.size) || !point.isLogAxisValidValue();
    }
  },
  _getPointKey: function (point) {
    var option = point.options || point;
    return this.vanchart.isMap() ? point.name : '' + option.x + option.y;
  },
  //计算位置的时候 顺道儿就给了
  _calculateLabelPos: function () {},
  //shine:这边的系列最大最小值用来算气泡半径，特殊：绝对值等
  _calculateMinMax4Radius: function () {
    var series = this,
        points = series.points;
    var seriesMinSize = Number.MAX_VALUE,
        seriesMaxSize = -Number.MAX_VALUE;

    for (var index = 0, len = points.length; index < len; index++) {
      var point = points[index];
      var value = point.getTargetValue();

      if (!point.visible || point.isNull) {
        continue;
      } //shine:这个就是当前点要不要展示负气泡，拿系列的属性做什么
      //过滤 是负气泡且不展示负气泡的点


      if (value < 0 && !point.options.displayNegative) {
        continue;
      } //过滤 设置了直径，不参与计算的点


      if (point.options.minSize || point.options.maxSize) {
        continue;
      } //todo:这个0目测有问题，可能因为这个奇怪的点把100-200扩展成0-200


      seriesMaxSize = Math.max(seriesMaxSize, isNaN(value) ? 0 : Math.abs(value));
      seriesMinSize = Math.min(seriesMinSize, isNaN(value) ? 0 : Math.abs(value));
    }

    series.seriesAbsMinValue = seriesMinSize;
    series.seriesAbsMaxValue = seriesMaxSize;
  },
  _calculateBubbleRadius: function () {
    var series = this,
        options = series.options; //这边需要的是合并后的属性

    var seriesMaxDiameter = Math.max(series.maxSize, series.minSize);
    var seriesMinDiameter = Math.min(series.minSize, series.maxSize);
    var sizeByArea = options.sizeBy == _Constants["default"].SIZE_BY_AREA; //系列条件属性设置最大最小半径，则气泡半径根据该系列最大最小size计算

    var max = this.seriesAbsMaxValue,
        min = this.seriesAbsMinValue;

    if (!this._sizeByCurrentSeries()) {
      //系列没有单独设置最大最小值，去算整个图表的。
      var minMax = this._calculateChartMinMax();

      max = _BaseUtils["default"].pick(minMax.max, minMax[1]);
      min = _BaseUtils["default"].pick(minMax.min, minMax[0]);
    }

    var denominator = max - min;
    var unit = sizeByArea ? (seriesMaxDiameter * seriesMaxDiameter - seriesMinDiameter * seriesMinDiameter) / denominator : (seriesMaxDiameter - seriesMinDiameter) / denominator;
    unit = isFinite(unit) ? unit : 0;

    var scale = _BaseUtils["default"].pick(this.vanchart.scale, 1);

    this.points.forEach(function (point) {
      var temp = unit * (Math.abs(point.value) - min);
      var diameter = sizeByArea ? Math.sqrt(seriesMinDiameter * seriesMinDiameter + temp) : seriesMinDiameter + temp;

      if (point.options.minSize || point.options.maxSize) {
        //shine:这个判断的意思是如果气泡图的某个点里面设置了最大最小半径，就用它自己的，不用和其他点一起算半径了
        //所以不要乱改逻辑
        var _tmp = isNaN(point.options.minSize) ? point.options.maxSize : point.options.minSize;

        diameter = sizeByArea ? Math.sqrt(_tmp) * 2 : _tmp;
      }

      diameter = point.getTargetValue() < 0 && !point.options.displayNegative ? 0 : diameter;
      point.radius = diameter / 2 * scale;
    });
  },
  //这边需要的是合并属性前的原始属性
  _sizeByCurrentSeries: function () {
    return (0, _CoreUtils.hasDefined)(this.options.minSize) && (0, _CoreUtils.hasDefined)(this.options.maxSize);
  },
  //这个是用来算半径的，特殊：绝对值&不包含自定义直径的系列
  _calculateChartMinMax: function () {
    var series = this.vanchart.seriesOfType(this.type);
    var minSize = Number.MAX_VALUE; //所有数据的最大最小值

    var maxSize = -minSize;
    series.forEach(function (sery) {
      if (!sery._sizeByCurrentSeries()) {
        minSize = Math.min(minSize, sery.seriesAbsMinValue);
        maxSize = Math.max(maxSize, sery.seriesAbsMaxValue);
      }
    });
    return {
      min: minSize,
      max: maxSize
    };
  },
  _calculateBubblePosition: function () {
    var isInverted = this.vanchart.isInverted();
    var xAxis = this.xAxis,
        yAxis = this.yAxis;
    this.points.forEach(function (point) {
      var options = point.options;
      var det = xAxis.scale.rangeBand ? xAxis.scale.rangeBand() / 2 : 0;
      var t1 = xAxis.scale(xAxis.getAxisValue(options.x)) + det;
      var t2 = yAxis.scale(yAxis.getAxisValue(options.y));
      point.posX = isInverted ? t2 : t1;
      point.posY = isInverted ? t1 : t2;
      var valid = point.labelDim && !point.isNull && !(point.getTargetValue() < 0 && !options.displayNegative);

      if (valid && options.dataLabels && options.dataLabels.enabled) {
        point.labelPos = {
          x: point.posX - point.labelDim.width / 2,
          y: point.posY - point.labelDim.height / 2
        };
      }
    });
  },
  getTrendLineXYValues: function (sery) {
    return this._getNormalTrendLineXYValues(sery);
  },
  _getFixedPos: function (point) {
    var vanchart = this.vanchart,
        plotBounds = vanchart.bounds,
        radius = point.radius || 0;
    var pos;

    if (vanchart.isMap()) {
      var latlng = point.getLatLng();

      if (!latlng) {
        return;
      }

      pos = vanchart.latLngToContainerPoint(latlng);
    } else {
      pos = {
        x: plotBounds.x + point.posX,
        y: plotBounds.y + point.posY
      };
    }

    radius = (radius + 1) / 1.414;
    return [pos.x + radius, pos.y + radius];
  },

  /**
   * @override Series.calcMoreLabelPosition
   * @param  {[type]} point [description]
   * @return {[type]}       [description]
   */
  calcMoreLabelPosition: function (point, moreLabelDim) {
    var chartBounds = this.vanchart.bounds;
    var startX = point.posX,
        startY = point.posY;
    return {
      startX: startX + chartBounds.x,
      startY: startY + chartBounds.y,
      direction: "top"
    };
  },
  getPointGraphicKey: function () {
    return 'circle';
  },
  effectAnimation: function (d) {
    _EffectHelper["default"].bubbleEffectAnimation(d, this.vanchart.isMap());
  },
  getDefaultEffectTime: function () {
    return _EffectHelper["default"].MARKER_EFFECT_TIME;
  },
  getPointInitAttr: function (point) {
    return {
      'transform': _BaseUtils["default"].makeTranslate([point.posX, point.posY]),
      'r': 0
    };
  },
  getPointInitAnimationAttr: function (point) {
    return {
      delay: point.delayTime || 0,
      ease: 'bounce',
      duration: BUBBLE_INIT_TIME,
      attr: {
        'r': point.radius
      }
    };
  },
  getPointReShowAnimationAttr: function (point) {
    return {
      ease: 'bounce',
      duration: BUBBLE_RE_SHOW_TIME,
      attr: {
        'r': point.radius
      }
    };
  },
  getPointUpdateAnimationAttr: function (point) {
    return {
      ease: 'back-out',
      duration: BUBBLE_UPDATE_TIME,
      attr: {
        'r': point.radius,
        'transform': _BaseUtils["default"].makeTranslate({
          x: point.posX,
          y: point.posY
        })
      }
    };
  },
  getPointDropAnimationAttr: function () {
    return {
      ease: 'back-in',
      duration: BUBBLE_EXIT_TIME,
      attr: {
        'r': 0
      }
    };
  },
  _getShadowFilter: function () {
    var series = this,
        vanchart = series.vanchart,
        renderer = vanchart.renderer;
    vanchart.bubbleShadowFilter = vanchart.bubbleShadowFilter || renderer.createDropShadowFilter(0, 0, 0.2, 2);
    return renderer.toPatternProperty(vanchart.bubbleShadowFilter);
  },
  getStyle: function (p) {
    var series = p.series;
    var style = {
      'stroke': p.mouseOverColor,
      'stroke-opacity': 0,
      'stroke-width': 0,
      'fill': p.color,
      'fill-opacity': p.opacity
    }; //todo ie10加阴影报错

    if (p.options.shadow && !_Browser["default"].ie) {
      style.filter = series._getShadowFilter();
    }

    return style;
  },
  getHighLightStyle: function (p) {
    return {
      'stroke': p.mouseOverColor,
      'stroke-opacity': 0.35,
      'stroke-width': 6,
      'fill': p.mouseOverColor,
      'fill-opacity': p.opacity + 0.35
    };
  },
  getPressedStyle: function (p) {
    return {
      'stroke': p.mouseOverColor,
      'stroke-opacity': 0.35,
      'stroke-width': 6,
      'fill': p.clickColor,
      'fill-opacity': p.clickOpacity
    };
  },
  _onPointMouseOver: function (point) {
    var series = point.series,
        style = series.getHighLightStyle(point);

    series._onState(point, true, CHOSEN_EASE, style);
  },
  _onPointMouseOut: function (point) {
    var series = point.series,
        style = series.getStyle(point);

    series._onState(point, false, OUT_EASE, style);
  },
  _onState: function (point, isChosen, ease, style) {
    point._isChosen = isChosen;
    var series = point.series,
        vanchart = series.vanchart;

    if (series.vanchart.isLargeMod