/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.jodd;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.bean.result.WxMinishopImageUploadResult;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.MinishopUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoddHttpMinishopMediaUploadRequestExecutor
extends MinishopUploadRequestExecutor<HttpConnectionProvider, ProxyInfo> {
    private static final Logger log = LoggerFactory.getLogger(JoddHttpMinishopMediaUploadRequestExecutor.class);

    public JoddHttpMinishopMediaUploadRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    @Override
    public WxMinishopImageUploadResult execute(String uri, File file, WxType wxType) throws WxErrorException, IOException {
        HttpRequest request = HttpRequest.post((String)uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            ((HttpConnectionProvider)this.requestHttp.getRequestHttpClient()).useProxy((ProxyInfo)this.requestHttp.getRequestHttpProxy());
        }
        request.withConnectionProvider((HttpConnectionProvider)this.requestHttp.getRequestHttpClient());
        request.form("media", (Object)file);
        HttpResponse response = request.send();
        response.charset(StandardCharsets.UTF_8.name());
        String responseContent = response.bodyText();
        WxError error = WxError.fromJson(responseContent, wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        log.info("responseContent: " + responseContent);
        return WxMinishopImageUploadResult.fromJson(responseContent);
    }
}

