/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhonnymertz.wkhtmltopdf.wrapper.objects;

import com.github.jhonnymertz.wkhtmltopdf.wrapper.Pdf;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.objects.BaseObject;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.objects.SourceType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class Page
extends BaseObject {
    private String source;
    private String filePath;
    private SourceType type;

    public Page(String source, SourceType type) {
        this.source = source;
        this.type = type;
    }

    @Override
    public String SetObjectIdentifier() {
        return "";
    }

    @Override
    public List<String> getCommandAsList(Pdf pdf) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.objectIdentifier)) {
            commands.add(this.objectIdentifier);
        }
        if (this.getType().equals((Object)SourceType.htmlAsString)) {
            if (this.getFilePath() != null) {
                Files.deleteIfExists(Paths.get(this.getFilePath(), new String[0]));
            }
            File temp = File.createTempFile(Pdf.TEMPORARY_FILE_PREFIX + UUID.randomUUID().toString(), ".html", pdf.getTempDirectory());
            FileUtils.writeStringToFile((File)temp, (String)this.getSource(), (String)"UTF-8");
            this.setFilePath(temp.getAbsolutePath());
            commands.add(temp.getAbsolutePath());
        } else {
            commands.add(this.getSource());
        }
        commands.addAll(this.params.getParamsAsStringList());
        return commands;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SourceType getType() {
        return this.type;
    }

    public void setType(SourceType type) {
        this.type = type;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

