/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.okr.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.okr.v1.model.BatchGetOkrReq;
import com.lark.oapi.service.okr.v1.model.BatchGetOkrResp;
import com.lark.oapi.service.okr.v1.model.CreateProgressRecordReq;
import com.lark.oapi.service.okr.v1.model.CreateProgressRecordResp;
import com.lark.oapi.service.okr.v1.model.DeleteProgressRecordReq;
import com.lark.oapi.service.okr.v1.model.DeleteProgressRecordResp;
import com.lark.oapi.service.okr.v1.model.GetProgressRecordReq;
import com.lark.oapi.service.okr.v1.model.GetProgressRecordResp;
import com.lark.oapi.service.okr.v1.model.ListPeriodReq;
import com.lark.oapi.service.okr.v1.model.ListPeriodResp;
import com.lark.oapi.service.okr.v1.model.ListUserOkrReq;
import com.lark.oapi.service.okr.v1.model.ListUserOkrResp;
import com.lark.oapi.service.okr.v1.model.UpdateProgressRecordReq;
import com.lark.oapi.service.okr.v1.model.UpdateProgressRecordResp;
import com.lark.oapi.service.okr.v1.model.UploadImageReq;
import com.lark.oapi.service.okr.v1.model.UploadImageResp;

public class OkrService {
    private final Image image;
    private final Okr okr;
    private final Period period;
    private final ProgressRecord progressRecord;
    private final UserOkr userOkr;

    public OkrService(Config config) {
        this.image = new Image(config);
        this.okr = new Okr(config);
        this.period = new Period(config);
        this.progressRecord = new ProgressRecord(config);
        this.userOkr = new UserOkr(config);
    }

    public Image image() {
        return this.image;
    }

    public Okr okr() {
        return this.okr;
    }

    public Period period() {
        return this.period;
    }

    public ProgressRecord progressRecord() {
        return this.progressRecord;
    }

    public UserOkr userOkr() {
        return this.userOkr;
    }

    public static class UserOkr {
        private final Config config;

        public UserOkr(Config config) {
            this.config = config;
        }

        public ListUserOkrResp list(ListUserOkrReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/users/:user_id/okrs", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListUserOkrResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListUserOkrResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListUserOkrResp list(ListUserOkrReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/users/:user_id/okrs", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListUserOkrResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListUserOkrResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ProgressRecord {
        private final Config config;

        public ProgressRecord(Config config) {
            this.config = config;
        }

        public CreateProgressRecordResp create(CreateProgressRecordReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/okr/v1/progress_records", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateProgressRecordResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateProgressRecordResp create(CreateProgressRecordReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/okr/v1/progress_records", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateProgressRecordResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteProgressRecordResp delete(DeleteProgressRecordReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteProgressRecordResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteProgressRecordResp delete(DeleteProgressRecordReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteProgressRecordResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetProgressRecordResp get(GetProgressRecordReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetProgressRecordResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetProgressRecordResp get(GetProgressRecordReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetProgressRecordResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateProgressRecordResp update(UpdateProgressRecordReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdateProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateProgressRecordResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateProgressRecordResp update(UpdateProgressRecordReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdateProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateProgressRecordResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Period {
        private final Config config;

        public Period(Config config) {
            this.config = config;
        }

        public ListPeriodResp list(ListPeriodReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/periods", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListPeriodResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListPeriodResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListPeriodResp list(ListPeriodReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/periods", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListPeriodResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListPeriodResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Okr {
        private final Config config;

        public Okr(Config config) {
            this.config = config;
        }

        public BatchGetOkrResp batchGet(BatchGetOkrReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/okrs/batch_get", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            BatchGetOkrResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchGetOkrResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public BatchGetOkrResp batchGet(BatchGetOkrReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/okrs/batch_get", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            BatchGetOkrResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchGetOkrResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Image {
        private final Config config;

        public Image(Config config) {
            this.config = config;
        }

        public UploadImageResp upload(UploadImageReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/okr/v1/images/upload", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UploadImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadImageResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadImageResp upload(UploadImageReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/okr/v1/images/upload", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UploadImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadImageResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

