/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.task.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.task.v1.model.BatchDeleteCollaboratorTaskReq;
import com.lark.oapi.service.task.v1.model.BatchDeleteCollaboratorTaskResp;
import com.lark.oapi.service.task.v1.model.BatchDeleteFollowerTaskReq;
import com.lark.oapi.service.task.v1.model.BatchDeleteFollowerTaskResp;
import com.lark.oapi.service.task.v1.model.CompleteTaskReq;
import com.lark.oapi.service.task.v1.model.CompleteTaskResp;
import com.lark.oapi.service.task.v1.model.CreateTaskCollaboratorReq;
import com.lark.oapi.service.task.v1.model.CreateTaskCollaboratorResp;
import com.lark.oapi.service.task.v1.model.CreateTaskCommentReq;
import com.lark.oapi.service.task.v1.model.CreateTaskCommentResp;
import com.lark.oapi.service.task.v1.model.CreateTaskFollowerReq;
import com.lark.oapi.service.task.v1.model.CreateTaskFollowerResp;
import com.lark.oapi.service.task.v1.model.CreateTaskReminderReq;
import com.lark.oapi.service.task.v1.model.CreateTaskReminderResp;
import com.lark.oapi.service.task.v1.model.CreateTaskReq;
import com.lark.oapi.service.task.v1.model.CreateTaskResp;
import com.lark.oapi.service.task.v1.model.DeleteTaskCollaboratorReq;
import com.lark.oapi.service.task.v1.model.DeleteTaskCollaboratorResp;
import com.lark.oapi.service.task.v1.model.DeleteTaskCommentReq;
import com.lark.oapi.service.task.v1.model.DeleteTaskCommentResp;
import com.lark.oapi.service.task.v1.model.DeleteTaskFollowerReq;
import com.lark.oapi.service.task.v1.model.DeleteTaskFollowerResp;
import com.lark.oapi.service.task.v1.model.DeleteTaskReminderReq;
import com.lark.oapi.service.task.v1.model.DeleteTaskReminderResp;
import com.lark.oapi.service.task.v1.model.DeleteTaskReq;
import com.lark.oapi.service.task.v1.model.DeleteTaskResp;
import com.lark.oapi.service.task.v1.model.GetTaskCommentReq;
import com.lark.oapi.service.task.v1.model.GetTaskCommentResp;
import com.lark.oapi.service.task.v1.model.GetTaskReq;
import com.lark.oapi.service.task.v1.model.GetTaskResp;
import com.lark.oapi.service.task.v1.model.ListTaskCollaboratorReq;
import com.lark.oapi.service.task.v1.model.ListTaskCollaboratorResp;
import com.lark.oapi.service.task.v1.model.ListTaskCommentReq;
import com.lark.oapi.service.task.v1.model.ListTaskCommentResp;
import com.lark.oapi.service.task.v1.model.ListTaskFollowerReq;
import com.lark.oapi.service.task.v1.model.ListTaskFollowerResp;
import com.lark.oapi.service.task.v1.model.ListTaskReminderReq;
import com.lark.oapi.service.task.v1.model.ListTaskReminderResp;
import com.lark.oapi.service.task.v1.model.ListTaskReq;
import com.lark.oapi.service.task.v1.model.ListTaskResp;
import com.lark.oapi.service.task.v1.model.P2TaskCommentUpdatedV1;
import com.lark.oapi.service.task.v1.model.P2TaskUpdateTenantV1;
import com.lark.oapi.service.task.v1.model.P2TaskUpdatedV1;
import com.lark.oapi.service.task.v1.model.PatchTaskReq;
import com.lark.oapi.service.task.v1.model.PatchTaskResp;
import com.lark.oapi.service.task.v1.model.UncompleteTaskReq;
import com.lark.oapi.service.task.v1.model.UncompleteTaskResp;
import com.lark.oapi.service.task.v1.model.UpdateTaskCommentReq;
import com.lark.oapi.service.task.v1.model.UpdateTaskCommentResp;

public class TaskService {
    private final Task task;
    private final TaskCollaborator taskCollaborator;
    private final TaskComment taskComment;
    private final TaskFollower taskFollower;
    private final TaskReminder taskReminder;

    public TaskService(Config config) {
        this.task = new Task(config);
        this.taskCollaborator = new TaskCollaborator(config);
        this.taskComment = new TaskComment(config);
        this.taskFollower = new TaskFollower(config);
        this.taskReminder = new TaskReminder(config);
    }

    public Task task() {
        return this.task;
    }

    public TaskCollaborator taskCollaborator() {
        return this.taskCollaborator;
    }

    public TaskComment taskComment() {
        return this.taskComment;
    }

    public TaskFollower taskFollower() {
        return this.taskFollower;
    }

    public TaskReminder taskReminder() {
        return this.taskReminder;
    }

    public static abstract class P2TaskCommentUpdatedV1Handler
    implements IEventHandler<P2TaskCommentUpdatedV1> {
        @Override
        public P2TaskCommentUpdatedV1 getEvent() {
            return new P2TaskCommentUpdatedV1();
        }
    }

    public static abstract class P2TaskUpdatedV1Handler
    implements IEventHandler<P2TaskUpdatedV1> {
        @Override
        public P2TaskUpdatedV1 getEvent() {
            return new P2TaskUpdatedV1();
        }
    }

    public static abstract class P2TaskUpdateTenantV1Handler
    implements IEventHandler<P2TaskUpdateTenantV1> {
        @Override
        public P2TaskUpdateTenantV1 getEvent() {
            return new P2TaskUpdateTenantV1();
        }
    }

    public static class TaskReminder {
        private final Config config;

        public TaskReminder(Config config) {
            this.config = config;
        }

        public CreateTaskReminderResp create(CreateTaskReminderReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/reminders", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateTaskReminderResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTaskReminderResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateTaskReminderResp create(CreateTaskReminderReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/reminders", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateTaskReminderResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTaskReminderResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTaskReminderResp delete(DeleteTaskReminderReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/task/v1/tasks/:task_id/reminders/:reminder_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteTaskReminderResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTaskReminderResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTaskReminderResp delete(DeleteTaskReminderReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/task/v1/tasks/:task_id/reminders/:reminder_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteTaskReminderResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTaskReminderResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTaskReminderResp list(ListTaskReminderReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id/reminders", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListTaskReminderResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTaskReminderResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTaskReminderResp list(ListTaskReminderReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id/reminders", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListTaskReminderResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTaskReminderResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class TaskFollower {
        private final Config config;

        public TaskFollower(Config config) {
            this.config = config;
        }

        public CreateTaskFollowerResp create(CreateTaskFollowerReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/followers", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateTaskFollowerResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTaskFollowerResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateTaskFollowerResp create(CreateTaskFollowerReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/followers", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateTaskFollowerResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTaskFollowerResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTaskFollowerResp delete(DeleteTaskFollowerReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/task/v1/tasks/:task_id/followers/:follower_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteTaskFollowerResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTaskFollowerResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTaskFollowerResp delete(DeleteTaskFollowerReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/task/v1/tasks/:task_id/followers/:follower_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteTaskFollowerResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTaskFollowerResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTaskFollowerResp list(ListTaskFollowerReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id/followers", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListTaskFollowerResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTaskFollowerResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTaskFollowerResp list(ListTaskFollowerReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id/followers", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListTaskFollowerResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTaskFollowerResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class TaskComment {
        private final Config config;

        public TaskComment(Config config) {
            this.config = config;
        }

        public CreateTaskCommentResp create(CreateTaskCommentReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/comments", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateTaskCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTaskCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateTaskCommentResp create(CreateTaskCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/comments", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateTaskCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTaskCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTaskCommentResp delete(DeleteTaskCommentReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/task/v1/tasks/:task_id/comments/:comment_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteTaskCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTaskCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTaskCommentResp delete(DeleteTaskCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/task/v1/tasks/:task_id/comments/:comment_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteTaskCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTaskCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTaskCommentResp get(GetTaskCommentReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id/comments/:comment_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetTaskCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTaskCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTaskCommentResp get(GetTaskCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id/comments/:comment_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetTaskCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTaskCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTaskCommentResp list(ListTaskCommentReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id/comments", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListTaskCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTaskCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTaskCommentResp list(ListTaskCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id/comments", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListTaskCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTaskCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateTaskCommentResp update(UpdateTaskCommentReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/task/v1/tasks/:task_id/comments/:comment_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdateTaskCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateTaskCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateTaskCommentResp update(UpdateTaskCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/task/v1/tasks/:task_id/comments/:comment_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdateTaskCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateTaskCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class TaskCollaborator {
        private final Config config;

        public TaskCollaborator(Config config) {
            this.config = config;
        }

        public CreateTaskCollaboratorResp create(CreateTaskCollaboratorReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/collaborators", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateTaskCollaboratorResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTaskCollaboratorResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateTaskCollaboratorResp create(CreateTaskCollaboratorReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/collaborators", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateTaskCollaboratorResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTaskCollaboratorResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTaskCollaboratorResp delete(DeleteTaskCollaboratorReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/task/v1/tasks/:task_id/collaborators/:collaborator_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteTaskCollaboratorResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTaskCollaboratorResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTaskCollaboratorResp delete(DeleteTaskCollaboratorReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/task/v1/tasks/:task_id/collaborators/:collaborator_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteTaskCollaboratorResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTaskCollaboratorResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTaskCollaboratorResp list(ListTaskCollaboratorReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id/collaborators", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListTaskCollaboratorResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTaskCollaboratorResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTaskCollaboratorResp list(ListTaskCollaboratorReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id/collaborators", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListTaskCollaboratorResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTaskCollaboratorResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Task {
        private final Config config;

        public Task(Config config) {
            this.config = config;
        }

        public BatchDeleteCollaboratorTaskResp batchDeleteCollaborator(BatchDeleteCollaboratorTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/batch_delete_collaborator", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            BatchDeleteCollaboratorTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchDeleteCollaboratorTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public BatchDeleteCollaboratorTaskResp batchDeleteCollaborator(BatchDeleteCollaboratorTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/batch_delete_collaborator", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            BatchDeleteCollaboratorTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchDeleteCollaboratorTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public BatchDeleteFollowerTaskResp batchDeleteFollower(BatchDeleteFollowerTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/batch_delete_follower", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            BatchDeleteFollowerTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchDeleteFollowerTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public BatchDeleteFollowerTaskResp batchDeleteFollower(BatchDeleteFollowerTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/batch_delete_follower", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            BatchDeleteFollowerTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchDeleteFollowerTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CompleteTaskResp complete(CompleteTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/complete", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CompleteTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CompleteTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CompleteTaskResp complete(CompleteTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/complete", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CompleteTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CompleteTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateTaskResp create(CreateTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateTaskResp create(CreateTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTaskResp delete(DeleteTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/task/v1/tasks/:task_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteTaskResp delete(DeleteTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/task/v1/tasks/:task_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTaskResp get(GetTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTaskResp get(GetTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks/:task_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTaskResp list(ListTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListTaskResp list(ListTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/task/v1/tasks", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchTaskResp patch(PatchTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/task/v1/tasks/:task_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            PatchTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchTaskResp patch(PatchTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/task/v1/tasks/:task_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            PatchTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UncompleteTaskResp uncomplete(UncompleteTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/uncomplete", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UncompleteTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UncompleteTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UncompleteTaskResp uncomplete(UncompleteTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/task/v1/tasks/:task_id/uncomplete", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UncompleteTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UncompleteTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

