/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Wrapper;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonParser;

public class JsonpParserWrapper
implements Wrapper,
JsonParser {
    OracleJsonParser wrapped;

    public JsonpParserWrapper(OracleJsonParser wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public <T> T unwrap(Class<T> wrapped) throws SQLException {
        if (wrapped.isInstance(this.wrapped)) {
            return (T)this.wrapped;
        }
        throw new SQLException(OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, wrapped.getName()).getMessage());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.wrapped);
    }

    public void close() {
        try {
            this.wrapped.close();
        }
        catch (OracleJsonException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }

    public BigDecimal getBigDecimal() {
        return this.wrapped.getBigDecimal();
    }

    public int getInt() {
        return this.wrapped.getInt();
    }

    public JsonLocation getLocation() {
        JsonLocation NO_LOCATION = new JsonLocation(){

            public long getColumnNumber() {
                return -1L;
            }

            public long getLineNumber() {
                return -1L;
            }

            public long getStreamOffset() {
                if (JsonpParserWrapper.this.wrapped instanceof OsonParserImpl) {
                    return ((OsonParserImpl)JsonpParserWrapper.this.wrapped).getStreamOffset();
                }
                return -1L;
            }
        };
        return NO_LOCATION;
    }

    public long getLong() {
        return this.wrapped.getLong();
    }

    public String getString() {
        return this.wrapped.getString();
    }

    public boolean hasNext() {
        try {
            return this.wrapped.hasNext();
        }
        catch (OracleJsonException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isIntegralNumber() {
        return this.wrapped.isIntegralNumber();
    }

    public JsonParser.Event next() {
        OracleJsonParser.Event event;
        try {
            event = this.wrapped.next();
        }
        catch (OracleJsonException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
        switch (event) {
            case END_ARRAY: {
                return JsonParser.Event.END_ARRAY;
            }
            case END_OBJECT: {
                return JsonParser.Event.END_OBJECT;
            }
            case KEY_NAME: {
                return JsonParser.Event.KEY_NAME;
            }
            case START_ARRAY: {
                return JsonParser.Event.START_ARRAY;
            }
            case START_OBJECT: {
                return JsonParser.Event.START_OBJECT;
            }
            case VALUE_BINARY: 
            case VALUE_TIMESTAMP: 
            case VALUE_TIMESTAMPTZ: 
            case VALUE_DATE: 
            case VALUE_INTERVALDS: 
            case VALUE_INTERVALYM: 
            case VALUE_STRING: {
                return JsonParser.Event.VALUE_STRING;
            }
            case VALUE_DOUBLE: 
            case VALUE_FLOAT: 
            case VALUE_DECIMAL: {
                return JsonParser.Event.VALUE_NUMBER;
            }
            case VALUE_FALSE: {
                return JsonParser.Event.VALUE_FALSE;
            }
            case VALUE_TRUE: {
                return JsonParser.Event.VALUE_TRUE;
            }
        }
        return JsonParser.Event.VALUE_NULL;
    }

    public JsonValue getValue() {
        try {
            return this.wrapped.getValue().wrap(JsonValue.class);
        }
        catch (OracleJsonException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }

    public JsonObject getObject() {
        try {
            return this.wrapped.getObject().wrap(JsonObject.class);
        }
        catch (OracleJsonException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }

    public JsonArray getArray() {
        try {
            return this.wrapped.getArray().wrap(JsonArray.class);
        }
        catch (OracleJsonException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }

    public void skipObject() {
        try {
            this.wrapped.skipObject();
        }
        catch (OracleJsonException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }

    public void skipArray() {
        try {
            this.wrapped.skipArray();
        }
        catch (OracleJsonException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }
}

