/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.spec.InvalidKeySpecException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.transaction.xa.XAResource;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OracleSQLPermission;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.SwitchableBugFix;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.TraceKey;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.aq.AQNotificationRegistration;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.clio.annotations.Trace;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.DefaultTraceEventListenerProvider;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.diagnostics.OracleDiagnosticsMXBean;
import oracle.jdbc.diagnostics.OracleTraceKey;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.ArrayLocatorResultSet;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BlockSource;
import oracle.jdbc.driver.BufferCache;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ConnectionDiagnosable;
import oracle.jdbc.driver.ConnectionTraceContext;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DefaultOsonProvider;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.HAManager;
import oracle.jdbc.driver.JMSMessagePropertiesI;
import oracle.jdbc.driver.LRUStatementCache;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.NTFAQRegistration;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.NTFPDBChangeEvent;
import oracle.jdbc.driver.NoSupportHAManager;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleCallableStatementWrapper;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.PropertiesFileUtil;
import oracle.jdbc.driver.ReplayContext;
import oracle.jdbc.driver.ResultSetCache;
import oracle.jdbc.driver.StructMetaData;
import oracle.jdbc.driver.VectorAccessor;
import oracle.jdbc.driver.resource.DriverResources;
import oracle.jdbc.driver.resource.ProviderProperties;
import oracle.jdbc.driver.resource.ResourceType;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.DatabaseSessionState;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSFactory;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.PDBChangeEventListener;
import oracle.jdbc.internal.XSEventListener;
import oracle.jdbc.internal.XSKeyval;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.internal.XSSessionParameters;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.spi.OsonConverter;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.resolver.TNSNamesNamingAdapter;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.TypeDescriptor;
import oracle.sql.json.OracleJsonFactory;
import oracle.xdb.XMLType;

abstract class PhysicalConnection
extends GeneratedPhysicalConnection
implements Diagnosable {
    public static final String SECRET_STORE_CONNECT = "oracle.security.client.connect_string";
    public static final String SECRET_STORE_USERNAME = "oracle.security.client.username";
    public static final String SECRET_STORE_PASSWORD = "oracle.security.client.password";
    public static final String SECRET_STORE_DEFAULT_USERNAME = "oracle.security.client.default_username";
    public static final String SECRET_STORE_DEFAULT_PASSWORD = "oracle.security.client.default_password";
    static final CRC64 CHECKSUM = new CRC64();
    public static final char slash_character = '/';
    public static final char at_sign_character = '@';
    public static final char left_square_bracket_character = '[';
    public static final char right_square_bracket_character = ']';
    public static final char left_round_bracket_character = '(';
    public static final char right_round_bracket_character = ')';
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final char[] EMPTY_CHAR_ARRAY = new char[0];
    static final int STREAM_CHUNK_SIZE = 32768;
    private static final boolean DEBUG = false;
    private static final String DEFAULT_CONNECTION_VALIDATION_QUERY = "SELECT 'x' FROM DUAL";
    private static final String CLASS_NAME = PhysicalConnection.class.getName();
    private long connCreationStartTime;
    private static final String VALID_PROXY_USERNAME = "\\[[a-zA-Z][a-zA-Z0-9\\-_\\.]+\\]";
    static final int DEFAULT_JSON_PREFETCH_SIZE = 0x2000000;
    static final int DEFAULT_VECTOR_PREFETCH_SIZE = 524308;
    long outScn = 0L;
    char[][] charOutput = new char[1][];
    byte[][] byteOutput = new byte[1][];
    short[][] shortOutput = new short[1][];
    byte[] methodTempLittleByteBuffer = new byte[128];
    byte[] methodTempLargeByteBuffer = new byte[4096];
    byte[] tmpByteBuf = null;
    char[] tmpCharBuf = null;
    static final int[] TempCharLengths = new int[]{4000, 32768};
    static final int[] TempByteLengths = new int[]{8000, 98304};
    NTFEventListener pdbChangeListener = null;
    Properties sessionProperties = null;
    private Properties sessionPropertiesCopy = null;
    private Properties sessionPropertiesDelta = null;
    private boolean startTrackingDelta = false;
    private static final String[] END_TO_END_CLIENTINFO_KEYS = new String[]{"OCSID.ACTION", "OCSID.CLIENTID", "OCSID.ECID", "OCSID.MODULE", "OCSID.DBOP", "OCSID.CLIENT_INFO"};
    private static final String END_TO_END_CLIENTINFO_KEY_SEQ_NO = "OCSID.SEQUENCE_NUMBER";
    public OracleConnection.ChecksumMode checksumMode;
    boolean isPDBChanged;
    String url;
    String savedUser;
    String currentSchema = null;
    static NTFManager ntfManager = new NTFManager();
    public int protocolId = -3;
    OracleTimeout timeout;
    DBConversion conversion;
    boolean xaWantsError;
    boolean usingXA;
    int txnMode = 0;
    byte[] fdo;
    Boolean bigEndian;
    OracleStatement statements;
    private int lifecycle;
    static final int OPEN = 1;
    static final int CLOSING = 2;
    static final int CLOSED = 4;
    static final int ABORTED = 8;
    static final int BLOCKED = 16;
    boolean cancelInProgressFlag = false;
    boolean isRowPrefetchSetExplicitly = false;
    int txnLevel = 2;
    Map<String, Class<?>> sqlTypeToJavaClassMap = null;
    Map<String, String> javaClassNameToSqlTypeMap = null;
    Map<String, Class<?>> javaObjectMap = new Hashtable(10);
    final Hashtable<String, Object>[] descriptorCacheStack = new Hashtable[2];
    int descriptorCacheTop = 0;
    OracleStatement statementHoldingLine;
    oracle.jdbc.OracleDatabaseMetaData databaseMetaData = null;
    LogicalConnection logicalConnectionAttached = null;
    boolean isProxy = false;
    OracleSql sqlObj = null;
    SQLWarning sqlWarning = null;
    boolean readOnly = false;
    LRUStatementCache statementCache = null;
    boolean clearStatementMetaData = false;
    OracleCloseCallback closeCallback = null;
    Object privateData = null;
    boolean isUsable = true;
    TimeZone defaultTimeZone = null;
    static final String DMS_ROOT_NAME = "JDBC";
    static final String DMS_DEFAULT_PARENT_NAME = "Driver";
    static final String DMS_DEFAULT_PARENT_TYPE = "JDBC_Driver";
    static final String DMS_CONNECTION_PREFIX = "CONNECTION_";
    static final String DMS_CONNECTION_TYPE = "JDBC_Connection";
    public static final String DMS_CONNECTION_URL = "JDBC_Connection_Url";
    public static final String DMS_CONNECTION_USER_NAME = "JDBC_Connection_Username";
    static final String DMS_OPEN_COUNT_NAME = "ConnectionOpenCount";
    static final String DMS_OPEN_COUNT_DESCRIPTION = "number of connections that have been opened";
    static final String DMS_CLOSE_COUNT_NAME = "ConnectionCloseCount";
    static final String DMS_CLOSE_COUNT_DESCRIPTION = "number of connections that have been closed";
    static final String DMS_GETCONNECTION_NAME = "ConnectionCreate";
    static final String DMS_GETCONNECTION_DESCRIPTION = "time spent creating a connection";
    static final String DMS_LOGICAL_CONNECTION_NAME = "LogicalConnection";
    static final String DMS_LOGICAL_CONNECTION_DESCRIPTION = "logical connection holding this physical connection";
    static final String DMS_EMPTY_UNITS = "";
    static final String DMS_LOGICAL_CONNECTION_UNITS = "";
    static final String DMS_NEW_STATEMENT_NAME = "CreateNewStatement";
    static final String DMS_NEW_STATEMENT_DESCRIPTION = "time spent creating a new statement";
    static final String DMS_GET_STATEMENT_NAME = "CreateStatement";
    static final String DMS_GET_STATEMENT_DESCRIPTION = "time spent retrieving a statement from cache or creating it anew";
    static final String DMS_CONNECTION_URL_DESCRIPTION = "url specified for the connection";
    static final String DMS_CONNECTION_USER_DESCRIPTION = "user name used for the connection";
    static final String DMS_STATEMENT_PARENT_NAME = "Statement";
    static final String DMS_STATEMENT_PARENT_TYPE = "JDBC_Statement";
    static final String DMS_SQLTEXT_NAME = "SQLText";
    static final String DMS_SQLTEXT_DESCRIPTION = "current SQL text";
    static final String DMS_SQLTEXT_UNITS = "";
    static final String DMS_EXECUTE_NAME = "Execute";
    static final String DMS_EXECUTE_DESCRIPTION = "the time required for all executions of this statement";
    static final String DMS_FETCH_NAME = "Fetch";
    static final String DMS_FETCH_DESCRIPTION = "the time required for all fetches by this statement";
    static AtomicLong DMS_CONNECTION_COUNT = new AtomicLong(0L);
    DMSFactory.DMSNoun dmsParent = null;
    DMSFactory.DMSEvent dmsOpenCount = null;
    DMSFactory.DMSEvent dmsCloseCount = null;
    DMSFactory.DMSPhase dmsGetConnection = null;
    DMSFactory.DMSState dmsLogicalConnection = null;
    DMSFactory.DMSPhase dmsCreateNewStatement = null;
    DMSFactory.DMSPhase dmsCreateStatement = null;
    DMSFactory.DMSNoun commonDmsParent = null;
    DMSFactory.DMSState commonDmsSqlText = null;
    DMSFactory.DMSPhase commonDmsExecute = null;
    DMSFactory.DMSPhase commonDmsFetch = null;
    DMSFactory.DMSState dmsUrl;
    DMSFactory.DMSState dmsUser;
    static final int END_TO_END_DBOP_INDEX = 4;
    static final int END_TO_END_CLIENTINFO_INDEX = 5;
    static final int END_TO_END_STATE_INDEX_MAX_POST_1200 = 6;
    final int[] endToEndMaxLength = new int[6];
    boolean endToEndAnyChanged = false;
    final boolean[] endToEndHasChanged = new boolean[6];
    short endToEndECIDSequenceNumber = Short.MIN_VALUE;
    final String[] arrayOfNullStrings = new String[6];
    String[] endToEndValues = this.arrayOfNullStrings;
    final DMSFactory.DMSVersion dmsVersion;
    Map<String, Map<String, String>> currentSystemContext = new IdentityHashMap<String, Map<String, String>>();
    private static final String[] e2eKeys = new String[]{DMSFactory.Context.ECForJDBC.ACTION, DMSFactory.Context.ECForJDBC.CLIENTID, DMSFactory.Context.ECForJDBC.ECID, DMSFactory.Context.ECForJDBC.MODULE};
    oracle.jdbc.OracleConnection wrapper = null;
    int minVcsBindSize;
    int maxRawBytesSql;
    int maxRawBytesPlsql;
    int maxVcsCharsSql;
    int maxVcsNCharsSql;
    int maxVcsBytesPlsql;
    int maxVcsBytesPlsqlOut;
    int maxIbtVarcharElementLength;
    int maxVarcharLength;
    int maxNVarcharLength;
    int maxRawLength;
    String instanceName = null;
    String dbName = null;
    OracleDriverExtension driverExtension;
    static final String uninitializedMarker = "";
    String databaseProductVersion = "";
    short versionNumber = (short)-1;
    int namedTypeAccessorByteLen;
    int refTypeAccessorByteLen;
    protected final Monitor cancelInProgressLockForThin = Monitor.newInstance();
    boolean plsqlCompilerWarnings = false;
    private boolean savedAutoCommitFlag;
    private int savedTxnMode;
    private BlockSource blockSource;
    int thinACLastLtxidHash = 0;
    oracle.jdbc.driver.LogicalTransactionId thinACCurrentLTXID;
    ReplayContext[] thinACReplayContextReceived = new ReplayContext[10];
    int thinACReplayContextReceivedCurrent = 0;
    ReplayContext thinACLastReplayContextReceived = null;
    OracleConnection.DRCPState drcpState = OracleConnection.DRCPState.DETACHED;
    boolean currentlyInTransaction = false;
    boolean drcpEnabled = false;
    HAManager haManager = NoSupportHAManager.getInstance();
    protected boolean safelyClosed = false;
    private String cachedCompatibleString = null;
    private static final String TNS_ADMIN = "TNS_ADMIN";
    private static final Pattern URL_PATTERN = Pattern.compile("(?i)jdbc:(oracle|default):(thin|oci[8]?|kprb|sharding|connection)(?-i)(:(((([\\w\\[\\]$#]*)|(\"[^\u0000\"]+\"))/(([\\w$#\\+%\\^\\&\\*_~=\\;\\:\\<\\>\\[\\]\\(\\)\\!\\p{L}]*)|(\"[^\u0000\"]+\")))?@(.*)?)?)?", 40);
    private static final Pattern USERNAME_PATTERN = Pattern.compile("(?iU)(([\\w$#]+)|(\"[^\u0000\"]+\"))?(\\[(([\\w$#]+)|(\"[^\u0000\"]+\"))\\])?((\\s+AS\\s+)(SYSDBA|SYSOPER|SYSASM|SYSBACKUP|SYSDG|SYSKM))?");
    private static final AtomicLong CONNECTIONID_SEQ = new AtomicLong();
    private Executor asyncExecutor;
    protected boolean isSepsCredentials = false;
    private boolean isInRequest = false;
    private DriverResources driverResources;
    private static final boolean IS_BUG_11891661_DISABLED = SwitchableBugFix.isDisabled(SwitchableBugFix.BugNumber.BUG_11891661);
    private OsonConverter osonConverter = null;
    private static final Pattern driverNameAttributePattern = Pattern.compile("[\\x20-\\x7e]{0,30}");
    private static final OracleSQLPermission CALL_ORACLE_ABORT_PERMISSION = new OracleSQLPermission("callAbort");
    Hashtable<Object, Object> clientData;
    private BufferCacheStore connectionBufferCacheStore;
    private static ThreadLocal<BufferCacheStore> threadLocalBufferCacheStore;
    private int pingResult;
    String sessionTimeZone = null;
    String databaseTimeZone = null;
    ZoneId databaseZoneId = null;
    ZoneId sessionZoneId = null;
    Calendar dbTzCalendar = null;
    private volatile OracleJsonFactory jsonFactory;
    private static final boolean IS_JSON_JAR_LOADED;
    private static final boolean IS_JAKARTA_JAR_LOADED;
    static final String SETCLIENTINFO_PERMISSION_NAME = "clientInfo.";
    static final List<String> RESERVED_NAMESPACES;
    static final Pattern SUPPORTED_NAME_PATTERN;
    protected final Properties clientInfo = new Properties();
    private short lastEndToEndSequenceNumber = (short)-1;
    static final String RAW_STR = "RAW";
    static final String SYS_RAW_STR = "SYS.RAW";
    static final String SYS_ANYDATA_STR = "SYS.ANYDATA";
    static final String SYS_XMLTYPE_STR = "SYS.XMLTYPE";
    static final String JSON_STR = "JSON";
    int timeZoneVersionNumber = -1;
    TIMEZONETAB timeZoneTab = null;
    private static final SQLPermission CALL_ABORT_PERMISSION;
    private static final SQLPermission CALL_SETNETWORKTIMEOUT_PERMISSION;
    private Executor closeExecutor = null;
    int varTypeMaxLenCompat = 0;
    private boolean isAutoONSConfigUpdated = false;
    private static final String AUTH_ONS_CONFIG = "AUTH_ONS_CONFIG";
    static final String DATABASE_NAME = "DATABASE_NAME";
    static final String SERVER_HOST = "SERVER_HOST";
    static final String INSTANCE_NAME = "INSTANCE_NAME";
    static final String SERVICE_NAME = "SERVICE_NAME";
    static final String TENANT_NAME = "TENANT_NAME";
    private static final String ONS_WALLET_CONFIG = "\nwalletfile=";
    private static final String ONS_WALLET_PASSWD_CONFIG = "\nwalletpassword=";
    private static final Pattern nonQuotedIdentifierPattern;
    protected AtomicLong lobCount = new AtomicLong();
    protected AtomicLong bfileCount = new AtomicLong();
    protected HashMap<OracleLargeObject, String> temporaryLobs = new HashMap();
    private static final String DUMMY_VAL = "xyzzy";
    boolean isServerBigSCN = false;
    private static final Predicate<String> IS_SIMPLE_IDENTIFIER;
    private static final Predicate<String> IS_QUOTED_IDENTIFIER;
    private static final Predicate<String> IS_VALID_IDENTIFIER;
    private static final TraceKey[] TRACEKEY_AT_END_TO_END_INDEX;
    protected final ConnectionDiagnosable connectionDiagnosable = new ConnectionDiagnosable(this);
    private String tenantName = null;
    private String executingRpcFunctionCodeDescription = "";
    private Boolean isLastRpcCompletedExceptionally = false;
    private TraceEventListener traceEventListener = DefaultTraceEventListenerProvider.NO_OP_TRACE_EVENT_LISTENER;
    protected Object traceUserContext = null;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;

    char[] getMethodTempCharBuffer(int length) {
        int newLength = 0;
        if (this.tmpCharBuf == null || this.tmpCharBuf.length < length) {
            for (int l : TempCharLengths) {
                if (l >= length) {
                    newLength = l;
                    break;
                }
                newLength = length;
            }
            this.tmpCharBuf = new char[newLength];
            int newByteLength = newLength * (this.conversion.sMaxCharSize > this.conversion.maxNCharSize ? this.conversion.sMaxCharSize : this.conversion.maxNCharSize);
            this.tmpByteBuf = new byte[newByteLength];
        }
        return this.tmpCharBuf;
    }

    byte[] getMethodTempByteBuffer(int length) {
        int newLength = 0;
        if (this.tmpByteBuf == null || this.tmpByteBuf.length < length) {
            for (int l : TempByteLengths) {
                if (l >= length) {
                    newLength = l;
                    break;
                }
                newLength = length;
            }
            this.tmpByteBuf = new byte[newLength];
        }
        return this.tmpByteBuf;
    }

    protected BlockSource setBlockSource() {
        return BlockSource.createBlockSource(this.useThreadLocalBufferCache, BlockSource.Implementation.THREADED);
    }

    protected PhysicalConnection() {
        this.dmsVersion = DMSFactory.DMSVersion.NONE;
    }

    PhysicalConnection(String ur, @Blind(value=PropertiesBlinder.class) Properties info, OracleDriverExtension ext) throws SQLException {
        this.connCreationStartTime = System.currentTimeMillis();
        this.begin(Metrics.ConnectionEvent.CONNECT);
        this.readConnectionProperties(ur, info);
        this.connectionDiagnosable.init();
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "PhysicalConnection", "Connection Properties={0}. ", (String)null, null, (Object)new PropertiesBlinder().blind(info));
        this.createDMSSensors();
        this.dmsUrl.update(this.url);
        this.dmsUser.update(this.userName);
        this.dmsVersion = DMSFactory.getDMSVersion();
        this.driverExtension = ext;
        this.blockSource = this.setBlockSource();
        this.descriptorCacheStack[this.descriptorCacheTop] = new Hashtable(10);
    }

    private TraceEventListener getTraceEventListener(AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        TraceEventListener traceEventListener = builder.getTraceEventListener();
        if (traceEventListener != null) {
            return traceEventListener;
        }
        return this.driverResources.getResource(ResourceType.TRACE_EVENT_LISTENER);
    }

    private String readExplicitlySetProperty(Properties connProperties, Hashtable<String, ?> urlProperties, Properties propertiesFromFile, final String property) {
        String propertyValue = null;
        if (connProperties != null) {
            propertyValue = connProperties.getProperty(property);
        }
        if (propertyValue == null) {
            Supplier<String> systemProperty = () -> AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(property, null);
                }
            });
            propertyValue = systemProperty.get();
        }
        if (propertyValue == null && urlProperties != null) {
            propertyValue = (String)urlProperties.get(property);
        }
        if (propertyValue == null && propertiesFromFile != null) {
            propertyValue = propertiesFromFile.getProperty(property);
        }
        return propertyValue;
    }

    void setDriverSpecificAutoCommit(boolean on) throws SQLException {
    }

    boolean isShardingDriverMode() {
        return false;
    }

    boolean isTrueCacheDriverMode() {
        return false;
    }

    @Override
    public boolean isConnectionBigTZTC() throws SQLException {
        return false;
    }

    @Override
    public boolean serverSupportsRequestBoundaries() throws SQLException {
        return false;
    }

    @Override
    public boolean serverSupportsExplicitBoundaryBit() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Trace(level=Trace.Level.INFO)
    void connect(AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) throws SQLException {
        try {
            void builder;
            this.trace(Level.INFO, SecurityLabel.INTERNAL, "oracle.jdbc.driver.PhysicalConnection", "connect", "entering args ({0})", null, null, abstractConnectionBuilder);
            this.setTraceEventListener(this.getTraceEventListener((AbstractConnectionBuilder<?, ?>)builder));
            boolean connectionFailed = true;
            long startToken = this.dmsGetConnection.start();
            try {
                try {
                    this.setLifecycle(1);
                    this.needLine();
                    this.initializeAsyncExecutor((AbstractConnectionBuilder<?, ?>)builder);
                    if (this.isDRCPConnection(this.url)) {
                        this.drcpEnabled = true;
                        if (this.drcpConnectionClass != null) {
                            this.drcpConnectionClass = this.drcpConnectionClass.trim();
                        }
                    }
                    this.logon((AbstractConnectionBuilder<?, ?>)builder);
                    this.tenantName = this.getCurrentTenantName();
                    this.updateSessionProperties(TENANT_NAME, this.tenantName);
                    this.connectionDiagnosable.enableDebugTenant(this.tenantName);
                    this.connectionDiagnosable.setTraceAttribute(OracleTraceKey.CONNECTION_ID, this.getNetConnectionId());
                    String realDbUniqueName = this.sessionProperties.getProperty("AUTH_SC_REAL_DBUNIQUE_NAME", "");
                    if (this.getVersionNumber() > 19000) {
                        String authDbName = this.sessionProperties.getProperty("AUTH_DBNAME", "");
                        int index = authDbName.indexOf(".");
                        String containerName = index == -1 ? authDbName : authDbName.substring(0, index);
                        String shardName = realDbUniqueName + "_" + containerName;
                        this.updateSessionProperties("SHARD_NAME", shardName.toLowerCase());
                    } else {
                        this.updateSessionProperties("SHARD_NAME", realDbUniqueName.toLowerCase());
                    }
                    this.setAutoCommit(this.autocommit);
                    this.setDriverSpecificAutoCommit(this.autocommit);
                    this.versionDependentInit(this.getVersionNumber());
                    if (this.implicitStatementCacheSize > 0) {
                        this.setStatementCacheSize(this.implicitStatementCacheSize);
                        this.setImplicitCachingEnabled(true);
                    }
                    this.dmsOpenCount.occurred();
                    connectionFailed = false;
                    if (this.fanEnabled) {
                        HAManager.enableHAIfNecessary(this.url, this);
                    } else {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "connect", "HA is explicitly disabled for {0}. ", (String)null, (Throwable)null, (Object)this.getNetConnectionIdForLogging());
                    }
                    this.end(Metrics.ConnectionEvent.CONNECT);
                    this.debug(Level.INFO, SecurityLabel.INTERNAL, CLASS_NAME, "connect", "Time taken to establish connection={0}ms", (String)null, null, (Object)(System.currentTimeMillis() - this.connCreationStartTime));
                }
                catch (SQLException ea) {
                    this.setLifecycle(2);
                    try {
                        this.logoff();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.setLifecycle(4);
                    throw ea;
                }
                this.txnMode = 0;
            }
            finally {
                this.dmsGetConnection.stop(startToken);
                if (connectionFailed) {
                    this.dmsParent.destroy();
                    this.dmsParent = null;
                    this.setLifecycle(4);
                }
            }
            this.trace(Level.INFO, SecurityLabel.INTERNAL, "oracle.jdbc.driver.PhysicalConnection", "connect", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.trace(Level.INFO, SecurityLabel.INTERNAL, "oracle.jdbc.driver.PhysicalConnection", "connect", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private String getCurrentTenantName() throws SQLException {
        String authDBName = this.getServerSessionInfo().getProperty("AUTH_DBNAME", "");
        String authDBDomainName = this.getServerSessionInfo().getProperty("AUTH_SC_DB_DOMAIN", "");
        String tenantName = "";
        if (!"".equals(authDBDomainName)) {
            int index = authDBName.toLowerCase().lastIndexOf(authDBDomainName.toLowerCase());
            if (index > 0) {
                tenantName = authDBName.substring(0, index - 1);
            }
        } else {
            tenantName = authDBName;
        }
        return tenantName;
    }

    final CompletionStage<Void> connectAsync(AbstractConnectionBuilder<?, ?> builder) {
        try {
            this.setTraceEventListener(this.getTraceEventListener(builder));
        }
        catch (SQLException sqlException) {
            return CompletionStageUtil.failedStage(sqlException);
        }
        long startToken = this.dmsGetConnection.start();
        try {
            this.initializeAsyncExecutor(builder);
            this.setLifecycle(1);
            this.needLine();
            if (this.isDRCPConnection(this.url)) {
                this.drcpEnabled = true;
                if (this.drcpConnectionClass != null) {
                    this.drcpConnectionClass = this.drcpConnectionClass.trim();
                }
            }
        }
        catch (SQLException preConnectFailure) {
            return CompletionStageUtil.failedStage(preConnectFailure);
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            CompletionStage<Void> logonStage = this.logonAsync(builder).thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
                this.setAutoCommit(this.autocommit);
                this.setDriverSpecificAutoCommit(this.autocommit);
                this.versionDependentInit(this.getVersionNumber());
                if (this.implicitStatementCacheSize > 0) {
                    this.setStatementCacheSize(this.implicitStatementCacheSize);
                    this.setImplicitCachingEnabled(true);
                }
                this.dmsOpenCount.occurred();
                if (this.fanEnabled) {
                    HAManager.enableHAIfNecessary(this.url, this);
                } else {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "connectAsync", "HA is explicitly disabled for {0}. ", (String)null, (Throwable)null, (Object)this.getNetConnectionIdForLogging());
                }
                this.txnMode = 0;
                return null;
            })).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(SQLException.class, sqlE -> {
                Monitor.CloseableLock exceptionLock = this.acquireCloseableLock();
                Throwable throwable = null;
                try {
                    try {
                        this.setLifecycle(2);
                        try {
                            this.logoff();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this.setLifecycle(4);
                        throw sqlE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (exceptionLock != null) {
                        if (throwable != null) {
                            try {
                                exceptionLock.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            exceptionLock.close();
                        }
                    }
                    throw throwable3;
                }
            })).handle((nil, e) -> {
                this.dmsGetConnection.stop(startToken);
                if (e != null) {
                    this.dmsParent.destroy();
                    this.dmsParent = null;
                    if (e instanceof CompletionException) {
                        throw (CompletionException)e;
                    }
                    throw new CompletionException((Throwable)e);
                }
                return nil;
            });
            CompletionStage<Void> completionStage = logonStage.whenCompleteAsync((connection, error) -> {}, this.getAsyncExecutor());
            return completionStage;
        }
    }

    private final void initializeAsyncExecutor(AbstractConnectionBuilder<?, ?> builder) {
        Executor configuredExecutor = builder == null ? null : builder.getExecutor();
        this.asyncExecutor = configuredExecutor == null ? ForkJoinPool.commonPool() : configuredExecutor;
    }

    protected void versionDependentInit(short versionNumber) {
        if (versionNumber >= 12100) {
            this.endToEndMaxLength[0] = 64;
            this.endToEndMaxLength[1] = 64;
            this.endToEndMaxLength[2] = 64;
            this.endToEndMaxLength[3] = 64;
            this.endToEndMaxLength[4] = 64;
            this.endToEndMaxLength[5] = 64;
        } else if (versionNumber >= 11202) {
            this.endToEndMaxLength[0] = 64;
            this.endToEndMaxLength[1] = 64;
            this.endToEndMaxLength[2] = 64;
            this.endToEndMaxLength[3] = 64;
            this.endToEndMaxLength[4] = 64;
            this.endToEndMaxLength[5] = 64;
        } else if (versionNumber >= 11000) {
            this.endToEndMaxLength[0] = 32;
            this.endToEndMaxLength[1] = 64;
            this.endToEndMaxLength[2] = 64;
            this.endToEndMaxLength[3] = 48;
            this.endToEndMaxLength[4] = 64;
            this.endToEndMaxLength[5] = 64;
        } else if (versionNumber >= 10000) {
            this.endToEndMaxLength[0] = 32;
            this.endToEndMaxLength[1] = 64;
            this.endToEndMaxLength[2] = 64;
            this.endToEndMaxLength[3] = 48;
            this.endToEndMaxLength[4] = 64;
            this.endToEndMaxLength[5] = 64;
        } else {
            this.endToEndMaxLength[0] = 32;
            this.endToEndMaxLength[1] = 64;
            this.endToEndMaxLength[2] = 64;
            this.endToEndMaxLength[3] = 48;
            this.endToEndMaxLength[4] = 64;
            this.endToEndMaxLength[5] = 64;
        }
        if (versionNumber >= 12000 & this.varTypeMaxLenCompat == 2) {
            this.minVcsBindSize = 32766;
            this.maxRawBytesSql = 32766;
            this.maxRawBytesPlsql = 32766;
            this.maxVcsCharsSql = 32766;
            this.maxVcsNCharsSql = 32766;
            this.maxVcsBytesPlsql = 32766;
            this.maxVcsBytesPlsqlOut = Short.MAX_VALUE;
            this.maxIbtVarcharElementLength = 32766;
            this.maxVarcharLength = Short.MAX_VALUE;
            this.maxNVarcharLength = 32766;
            this.maxRawLength = Short.MAX_VALUE;
        } else if (versionNumber >= 11202) {
            this.minVcsBindSize = 4001;
            this.maxRawBytesSql = 4000;
            this.maxRawBytesPlsql = 32766;
            this.maxVcsCharsSql = 32766;
            this.maxVcsNCharsSql = 32766;
            this.maxVcsBytesPlsql = 32766;
            this.maxVcsBytesPlsqlOut = Short.MAX_VALUE;
            this.maxIbtVarcharElementLength = 32766;
            this.maxVarcharLength = 4000;
            this.maxNVarcharLength = 4000;
            this.maxRawLength = 2000;
        } else if (versionNumber >= 11000) {
            this.minVcsBindSize = 4001;
            this.maxRawBytesSql = 4000;
            this.maxRawBytesPlsql = 32766;
            this.maxVcsCharsSql = 32766;
            this.maxVcsNCharsSql = 32766;
            this.maxVcsBytesPlsql = 32766;
            this.maxVcsBytesPlsqlOut = Short.MAX_VALUE;
            this.maxIbtVarcharElementLength = 32766;
            this.maxVarcharLength = 4000;
            this.maxNVarcharLength = 4000;
            this.maxRawLength = 2000;
        } else if (versionNumber >= 10000) {
            this.minVcsBindSize = 4001;
            this.maxRawBytesSql = 4000;
            this.maxRawBytesPlsql = 32512;
            this.maxVcsCharsSql = 32766;
            this.maxVcsNCharsSql = 32766;
            this.maxVcsBytesPlsql = 32512;
            this.maxVcsBytesPlsqlOut = 32512;
            this.maxIbtVarcharElementLength = 32766;
            this.maxVarcharLength = 4000;
            this.maxNVarcharLength = 4000;
            this.maxRawLength = 2000;
        }
    }

    int getMaxSizeForVarchar(OracleStatement.SqlKind sqlKind, int maxLength, boolean _psqlVarcharParameter4KOnly) throws SQLException {
        int returnMaxLength = 0;
        returnMaxLength = sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK ? (maxLength > 0 ? Math.max(this.maxVcsBytesPlsql, maxLength) : (_psqlVarcharParameter4KOnly ? 4000 : this.maxVcsBytesPlsqlOut)) : this.maxVarcharLength;
        return returnMaxLength;
    }

    private static final String propertyVariableName(String fieldName) {
        if (fieldName.equals("commitOptionProperty")) {
            return "COMMIT_OPTION";
        }
        if (fieldName.equals("calculateChecksumProperty")) {
            return "CALCULATE_CHECKSUM";
        }
        if (fieldName.equals("isResultSetCacheEnabled")) {
            return "ENABLE_QUERY_RESULT_CACHE";
        }
        char[] fieldNameInChars = new char[fieldName.length()];
        fieldName.getChars(0, fieldName.length(), fieldNameInChars, 0);
        String propertyVariableName = "";
        for (int i = 0; i < fieldNameInChars.length; ++i) {
            if (Character.isUpperCase(fieldNameInChars[i])) {
                propertyVariableName = propertyVariableName + "_";
            }
            propertyVariableName = propertyVariableName + Character.toUpperCase(fieldNameInChars[i]);
        }
        return propertyVariableName;
    }

    private void initializeUserDefaults(@Blind(value=PropertiesBlinder.class) Properties info) {
        for (String k : OracleDriver.DEFAULT_CONNECTION_PROPERTIES.stringPropertyNames()) {
            if (info.containsKey(k)) continue;
            info.setProperty(k, OracleDriver.DEFAULT_CONNECTION_PROPERTIES.getProperty(k));
            this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initializeUserDefaults", "setting default connection property. key={0}, value={1}. ", null, null, () -> new Object[]{k, OracleDriver.DEFAULT_CONNECTION_PROPERTIES.getProperty(k)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readConnectionProperties(String ul, @Blind(value=PropertiesBlinder.class) Properties info) throws SQLException {
        int login_timeout_value;
        boolean tnsAdminFromEnv;
        this.initializeUserDefaults(info);
        this.url = ul;
        Hashtable<String, String> url_properties = PhysicalConnection.parseUrl(this.url);
        String tempTnsAdmin = info.getProperty("oracle.net.tns_admin");
        if (tempTnsAdmin == null) {
            tempTnsAdmin = PhysicalConnection.getSystemPropertyTnsAdmin(null);
        }
        boolean bl = tnsAdminFromEnv = tempTnsAdmin == null;
        if (tnsAdminFromEnv) {
            tempTnsAdmin = PhysicalConnection.getTnsAdminFromEnv();
        }
        Properties propertiesFromFile = this.getConnectionPropertiesFromFile(info, url_properties, tempTnsAdmin, tnsAdminFromEnv);
        super.readConnectionProperties(this.url, info, propertiesFromFile);
        this.driverResources = new DriverResources(ProviderProperties.create(info, propertiesFromFile, OracleDriver.getProviderSystemProperties()));
        this.connectionDiagnosable.isLoggingExplicitlyDisabled = "false".equalsIgnoreCase(this.readExplicitlySetProperty(info, url_properties, propertiesFromFile, "oracle.jdbc.diagnostic.enableLogging"));
        this.isRowPrefetchSetExplicitly = this.readExplicitlySetProperty(info, url_properties, propertiesFromFile, "defaultRowPrefetch") != null || this.readExplicitlySetProperty(info, url_properties, propertiesFromFile, "oracle.jdbc.defaultRowPrefetch") != null;
        if (this.tnsAdmin == null && tempTnsAdmin != null) {
            this.tnsAdmin = tempTnsAdmin;
        }
        if (this.commitOptionProperty != null) {
            this.commitOption = 0;
            String[] values = this.commitOptionProperty.split(",");
            if (values != null && values.length > 0) {
                for (String opt : values) {
                    if (opt.trim() == "") continue;
                    this.commitOption |= OracleConnection.CommitOption.valueOf(opt.trim()).getCode();
                }
            }
        }
        this.checksumMode = this.calculateChecksumProperty == null ? OracleConnection.ChecksumMode.NO_CHECKSUM : OracleConnection.ChecksumMode.valueOf(this.calculateChecksumProperty);
        if (this.defaultRowPrefetch <= 0) {
            this.defaultRowPrefetch = Integer.parseInt("10");
        }
        if (this.defaultLobPrefetchSize < -1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 267).fillInStackTrace();
        }
        if (this.thinVsessionOsuser == null) {
            this.thinVsessionOsuser = PhysicalConnection.getSystemPropertyUserName();
            if (this.thinVsessionOsuser == null) {
                this.thinVsessionOsuser = "jdbcuser";
            }
        }
        if (this.thinNetConnectTimeout == "0" && (login_timeout_value = DriverManager.getLoginTimeout()) != 0) {
            this.thinNetConnectTimeout = "" + login_timeout_value * 1000;
        }
        this.autocommit = this.defaultautocommit;
        if (this.userName == null) {
            this.userName = url_properties.get("user");
        }
        CharSequence password = null;
        try {
            char[] providedPassword;
            String providedUserName;
            String[] tmpCreds;
            boolean noPassword;
            String providedDatabase;
            password = info.getProperty("password");
            if (password == null) {
                password = info.getProperty("oracle.jdbc.password");
            }
            if (password == null && propertiesFromFile != null && (password = propertiesFromFile.getProperty("password")) == null) {
                password = propertiesFromFile.getProperty("oracle.jdbc.password");
            }
            if (password == null) {
                password = url_properties.get("password");
            }
            if (this.database == null) {
                this.database = info.getProperty("server", CONNECTION_PROPERTY_DATABASE_DEFAULT);
            }
            if (this.database == null) {
                this.database = url_properties.get("database");
            }
            if ((this.database == null || this.database.isEmpty()) && (providedDatabase = this.driverResources.getResource(ResourceType.CONNECTION_STRING)) != null) {
                this.database = providedDatabase;
            }
            boolean noUser = this.userName == null || this.userName.length() == 0;
            boolean bl2 = noPassword = password == null || password.length() == 0;
            if ((noUser || noPassword) && !"TCPS".equalsIgnoreCase(this.thinNetAuthenticationServices) && this.database != null && this.database.length() > 0 && (this.isSepsCredentials = (tmpCreds = PhysicalConnection.getSecretStoreCredentials(this.database, this.walletLocation, this.walletPassword))[0] != null || tmpCreds[1] != null)) {
                if (noUser) {
                    this.userName = tmpCreds[0];
                } else if (noPassword && this.userName.matches(VALID_PROXY_USERNAME)) {
                    this.userName = tmpCreds[0] + this.userName;
                }
                if (noPassword) {
                    password = tmpCreds[1];
                }
            }
            if ((this.userName == null || this.isSepsCredentials) && (providedUserName = this.driverResources.getResource(ResourceType.USERNAME)) != null) {
                this.userName = providedUserName;
            }
            if ((password == null || this.isSepsCredentials) && (providedPassword = this.driverResources.getResource(ResourceType.PASSWORD)) != null) {
                password = CharBuffer.wrap(providedPassword);
            }
            this.initializePassword(OpaqueString.newOpaqueString(password));
        }
        finally {
            if (password instanceof CharBuffer) {
                CharBuffer passwordBuffer = (CharBuffer)password;
                passwordBuffer.clear();
                passwordBuffer.put(new char[passwordBuffer.capacity()]);
            }
        }
        String[] loginModeOUT = new String[1];
        String[] proxyClientNameOUT = new String[1];
        this.userName = PhysicalConnection.parseLoginOption(this.userName, info, loginModeOUT, proxyClientNameOUT);
        if (loginModeOUT[0] != null) {
            this.internalLogon = loginModeOUT[0];
        }
        if (proxyClientNameOUT[0] != null) {
            this.proxyClientName = proxyClientNameOUT[0];
        }
        this.protocol = url_properties.get("protocol");
        if (this.protocol == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 40, "Protocol is not specified in URL").fillInStackTrace();
        }
        if (info.getProperty("is_connection_pooling") == "true" && this.database == null) {
            this.database = "";
        }
        if (!(this.thinNetAuthenticationServices != null && "KERBEROS5".equalsIgnoreCase(this.thinNetAuthenticationServices) || this.userName == null || this.userName.startsWith("\""))) {
            char[] srcChars = this.userName.toCharArray();
            for (int i = 0; i < srcChars.length; ++i) {
                srcChars[i] = Character.toUpperCase(srcChars[i]);
            }
            this.userName = String.copyValueOf(srcChars);
        }
        this.xaWantsError = false;
        this.usingXA = false;
        if (this.networkCompression != null) {
            this.networkCompression = this.networkCompression.toLowerCase();
        }
        if (this.drcpTagName != null && this.drcpTagName.isEmpty()) {
            this.drcpTagName = null;
        }
        if (IS_BUG_11891661_DISABLED) {
            this.autoCommitSpecCompliant = false;
            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, "PhysicalConnection", "readConnectionProperties", "autoCommitSpecCompliant is set to false", "bug fix for BUG_11891661 is disabled ", null);
        }
        this.loadOsonConverter();
        this.validateConnectionProperties();
    }

    void validateConnectionProperties() throws SQLException {
        Class<?> configuredClass;
        if (this.driverNameAttribute != null && !driverNameAttributePattern.matcher(this.driverNameAttribute).matches()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 257).fillInStackTrace();
        }
        if (this.loginTimeout < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "oracle.jdbc.loginTimeout is less than 0: " + this.loginTimeout).fillInStackTrace();
        }
        if (this.maxBatchMemory < 0L) {
            throw (SQLException)DatabaseError.formatSqlException(this.getConnectionDuringExceptionHandling(), 1721, null, null, this.maxBatchMemory, "oracle.jdbc.maxBatchMemory").fillInStackTrace();
        }
        if (this.vectorDefaultGetObjectType != null && (configuredClass = VectorAccessor.getDefaultConversion(this.vectorDefaultGetObjectType, double[].class)) == null) {
            throw (SQLException)DatabaseError.formatSqlException(this.getConnectionDuringExceptionHandling(), 1721, null, null, this.vectorDefaultGetObjectType, "oracle.jdbc.vectorDefaultGetObjectType").fillInStackTrace();
        }
    }

    private static String parseLoginOption(String _user, @Blind(value=PropertiesBlinder.class) Properties info, String[] loginModeOUT, String[] proxyClientNameOUT) {
        String userOnly;
        if (_user == null || _user.length() == 0) {
            return null;
        }
        String localUser = _user.trim();
        Matcher m = USERNAME_PATTERN.matcher(localUser);
        if (m.matches()) {
            String loginMode;
            userOnly = m.group(1);
            String proxyClient = m.group(5);
            if (proxyClient != null && proxyClient.length() != 0) {
                proxyClientNameOUT[0] = proxyClient;
            }
            if ((loginMode = m.group(10)) != null && loginMode.length() != 0) {
                loginModeOUT[0] = loginMode.toLowerCase();
            }
        } else {
            userOnly = localUser;
        }
        return userOnly;
    }

    static final Hashtable<String, String> parseUrl(String url) throws SQLException {
        Hashtable<String, String> result = new Hashtable<String, String>(5);
        if (url == null || url.length() == 0) {
            return result;
        }
        Matcher m = URL_PATTERN.matcher(url);
        if (m.matches()) {
            String preamble = m.group(1);
            String driver = m.group(2);
            result.put("protocol", driver);
            String user = m.group(6);
            String passwd = m.group(9);
            String tns = m.group(12);
            if (user != null && user.length() > 0) {
                result.put("user", user);
            }
            if (passwd != null && passwd.length() > 0) {
                result.put("password", passwd);
            }
            if (tns != null) {
                result.put("database", tns);
            }
        } else {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String[] getSecretStoreCredentials(String connectString, String wallet_location, OpaqueString wallet_password) throws SQLException {
        String[] userPwd;
        block15: {
            userPwd = new String[]{null, null};
            if (wallet_location == null) {
                return userPwd;
            }
            try {
                OracleSecretStore secretStore;
                OracleWallet wallet;
                block16: {
                    if (wallet_location.startsWith("(")) {
                        wallet_location = "file:" + CustomSSLSocketFactory.processWalletLocation(wallet_location);
                    }
                    if (!(wallet = new OracleWallet()).exists(wallet_location)) break block15;
                    char[] walletPasswordInChars = null;
                    if (wallet_password != null && wallet_password != OpaqueString.NULL) {
                        walletPasswordInChars = wallet_password.getChars();
                    }
                    try {
                        wallet.open(wallet_location, walletPasswordInChars);
                        if (walletPasswordInChars == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (walletPasswordInChars == null) throw throwable;
                        int i = 0;
                        while (i < walletPasswordInChars.length) {
                            walletPasswordInChars[i] = '\u0000';
                            ++i;
                        }
                        throw throwable;
                    }
                    for (int i = 0; i < walletPasswordInChars.length; ++i) {
                        walletPasswordInChars[i] = '\u0000';
                    }
                }
                if ((secretStore = wallet.getSecretStore()).containsAlias(SECRET_STORE_DEFAULT_USERNAME)) {
                    userPwd[0] = new String(secretStore.getSecret(SECRET_STORE_DEFAULT_USERNAME));
                }
                if (secretStore.containsAlias(SECRET_STORE_DEFAULT_PASSWORD)) {
                    userPwd[1] = new String(secretStore.getSecret(SECRET_STORE_DEFAULT_PASSWORD));
                }
                Enumeration list = wallet.getSecretStore().internalAliases();
                String alias = null;
                while (list.hasMoreElements()) {
                    alias = (String)list.nextElement();
                    if (!alias.startsWith(SECRET_STORE_CONNECT) || !connectString.equalsIgnoreCase(new String(secretStore.getSecret(alias)))) continue;
                    String idx = alias.substring(SECRET_STORE_CONNECT.length());
                    userPwd[0] = new String(secretStore.getSecret(SECRET_STORE_USERNAME + idx));
                    userPwd[1] = new String(secretStore.getSecret(SECRET_STORE_PASSWORD + idx));
                    break;
                }
            }
            catch (NoClassDefFoundError ndef) {
                try {
                    throw (SQLException)DatabaseError.createSqlException(167, ndef).fillInStackTrace();
                    catch (Exception s) {
                        if (!(s instanceof RuntimeException)) throw (SQLException)DatabaseError.createSqlException(168, (Object)s).fillInStackTrace();
                        throw (RuntimeException)s;
                    }
                }
                catch (Throwable throwable) {
                    CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getSecretStoreCredentials", "Searched {0} for SEPS credentials keyed to connection string {1}. Found username? {2}. Found password? {3}.", (String)null, null, (Object)wallet_location, (Object)connectString, (Object)(userPwd[0] == null ? "NO" : "YES"), (Object)(userPwd[1] == null ? "NO" : "YES"));
                    throw throwable;
                }
            }
        }
        CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getSecretStoreCredentials", "Searched {0} for SEPS credentials keyed to connection string {1}. Found username? {2}. Found password? {3}.", (String)null, null, (Object)wallet_location, (Object)connectString, (Object)(userPwd[0] == null ? "NO" : "YES"), (Object)(userPwd[1] == null ? "NO" : "YES"));
        return userPwd;
    }

    abstract void initializePassword(OpaqueString var1) throws SQLException;

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getProperties() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Properties props = new Properties();
            try {
                Class<oracle.jdbc.OracleConnection> connectionclass = oracle.jdbc.OracleConnection.class;
                Class<GeneratedPhysicalConnection> physicalConnectionClass = GeneratedPhysicalConnection.class;
                Field[] physicalConnectionFields = physicalConnectionClass.getDeclaredFields();
                for (int i = 0; i < physicalConnectionFields.length; ++i) {
                    String propertyValue;
                    int modifier = physicalConnectionFields[i].getModifiers();
                    if (Modifier.isStatic(modifier)) continue;
                    String fieldName = physicalConnectionFields[i].getName();
                    String propertyConstantName = "CONNECTION_PROPERTY_" + PhysicalConnection.propertyVariableName(fieldName);
                    Field connectionPropertyField = null;
                    try {
                        connectionPropertyField = connectionclass.getField(propertyConstantName);
                    }
                    catch (NoSuchFieldException ex) {
                        continue;
                    }
                    if (propertyConstantName.matches(".*PASSWORD.*") && !propertyConstantName.equals("CONNECTION_PROPERTY_PASSWORD_AUTHENTICATION") || propertyConstantName.equals("CONNECTION_PROPERTY_ACCESS_TOKEN") || propertyConstantName.equals("CONNECTION_PROPERTY_CLIENT_SECRET")) continue;
                    String propertyName = (String)connectionPropertyField.get(null);
                    String typeName = physicalConnectionFields[i].getType().getName();
                    if (typeName.equals("boolean")) {
                        boolean propertyValue2 = physicalConnectionFields[i].getBoolean(this);
                        if (propertyValue2) {
                            props.setProperty(propertyName, "true");
                            continue;
                        }
                        props.setProperty(propertyName, "false");
                        continue;
                    }
                    if (typeName.equals("int")) {
                        int propertyValue3 = physicalConnectionFields[i].getInt(this);
                        props.setProperty(propertyName, Integer.toString(propertyValue3));
                        continue;
                    }
                    if (typeName.equals("long")) {
                        long propertyValue4 = physicalConnectionFields[i].getLong(this);
                        props.setProperty(propertyName, Long.toString(propertyValue4));
                        continue;
                    }
                    if (!typeName.equals("java.lang.String") || (propertyValue = (String)physicalConnectionFields[i].get(this)) == null) continue;
                    props.setProperty(propertyName, propertyValue);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            Properties properties = props;
            return properties;
        }
    }

    @Override
    @Deprecated
    public Connection _getPC() {
        return null;
    }

    @Override
    public oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        return this;
    }

    @Override
    public boolean isLogicalConnection() {
        return false;
    }

    void createDMSSensors() {
        DMSFactory dmsInstance = DMSFactory.getInstance();
        this.dmsParent = dmsInstance.createNoun(null, DMS_ROOT_NAME, null);
        this.dmsParent = dmsInstance.createNoun(this.dmsParent, this.dmsParentName, this.dmsParentType);
        this.dmsOpenCount = dmsInstance.createEvent(this.dmsParent, DMS_OPEN_COUNT_NAME, DMS_OPEN_COUNT_DESCRIPTION);
        this.dmsCloseCount = dmsInstance.createEvent(this.dmsParent, DMS_CLOSE_COUNT_NAME, DMS_CLOSE_COUNT_DESCRIPTION);
        this.dmsGetConnection = dmsInstance.createPhaseEvent(this.dmsParent, DMS_GETCONNECTION_NAME, DMS_GETCONNECTION_DESCRIPTION);
        this.dmsGetConnection.deriveMetric(DMSFactory.SensorIntf_all);
        this.dmsParent = dmsInstance.createNoun(this.dmsParent, DMS_CONNECTION_PREFIX + DMS_CONNECTION_COUNT.incrementAndGet(), DMS_CONNECTION_TYPE);
        this.dmsUrl = dmsInstance.createState(this.dmsParent, DMS_CONNECTION_URL, "", DMS_CONNECTION_URL_DESCRIPTION, null);
        this.dmsUser = dmsInstance.createState(this.dmsParent, DMS_CONNECTION_USER_NAME, "", DMS_CONNECTION_USER_DESCRIPTION, null);
        this.dmsLogicalConnection = dmsInstance.createState(this.dmsParent, DMS_LOGICAL_CONNECTION_NAME, "", DMS_LOGICAL_CONNECTION_DESCRIPTION, null);
        this.dmsCreateNewStatement = dmsInstance.createPhaseEvent(this.dmsParent, DMS_NEW_STATEMENT_NAME, DMS_NEW_STATEMENT_DESCRIPTION);
        this.dmsCreateNewStatement.deriveMetric(DMSFactory.SensorIntf_all - DMSFactory.SensorIntf_active);
        this.dmsCreateStatement = dmsInstance.createPhaseEvent(this.dmsParent, DMS_GET_STATEMENT_NAME, DMS_GET_STATEMENT_DESCRIPTION);
        this.dmsCreateStatement.deriveMetric(DMSFactory.SensorIntf_all - DMSFactory.SensorIntf_active);
        this.commonDmsParent = dmsInstance.createNoun(this.dmsParent, DMS_STATEMENT_PARENT_NAME, DMS_STATEMENT_PARENT_TYPE);
        this.commonDmsSqlText = dmsInstance.createState(this.commonDmsParent, DMS_SQLTEXT_NAME, "", DMS_SQLTEXT_DESCRIPTION, null);
        this.commonDmsExecute = dmsInstance.createPhaseEvent(this.commonDmsParent, DMS_EXECUTE_NAME, DMS_EXECUTE_DESCRIPTION);
        this.commonDmsExecute.deriveMetric(DMSFactory.PhaseEventIntf_all);
        this.commonDmsFetch = dmsInstance.createPhaseEvent(this.commonDmsParent, DMS_FETCH_NAME, DMS_FETCH_DESCRIPTION);
        this.commonDmsFetch.deriveMetric(DMSFactory.PhaseEventIntf_all);
    }

    boolean dmsUpdateSqlText() {
        if (this.dmsVersion.equals((Object)DMSFactory.DMSVersion.v11)) {
            return DMSFactory.Context.getECForJDBC().updateSqlText();
        }
        return this.dmsStmtMetrics;
    }

    OracleTimeout getTimeout() throws SQLException {
        if (this.timeout == null) {
            this.timeout = OracleTimeout.newTimeout(this.url);
        }
        return this.timeout;
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return this.createStatement(-1, -1);
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            OracleResultSet.ResultSetType resultSetTypeEnum = OracleResultSet.ResultSetType.typeFor(resultSetType, resultSetConcurrency);
            OracleStatement internalStatement = this.createStatementInternal(resultSetTypeEnum);
            OracleStatementWrapper oracleStatementWrapper = new OracleStatementWrapper(internalStatement);
            return oracleStatementWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final OracleStatement createStatementInternal(OracleResultSet.ResultSetType resultSetType) throws SQLException {
        long startToken = this.dmsCreateNewStatement.start();
        try {
            OracleStatement internalStatement;
            OracleStatement oracleStatement = internalStatement = (OracleStatement)this.driverExtension.allocateStatement(this, resultSetType);
            return oracleStatement;
        }
        finally {
            this.dmsCreateNewStatement.stop(startToken);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, -1, -1);
    }

    @Override
    @Deprecated
    public PreparedStatement prepareStatementWithKey(String key) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (key == null) {
                PreparedStatement preparedStatement = null;
                return preparedStatement;
            }
            if (!this.isStatementCacheInitialized()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 95).fillInStackTrace();
            }
            long startToken = DMSFactory.getInstance().getToken();
            DMSFactory.DMSPhase dmsSensor = this.dmsCreateNewStatement;
            oracle.jdbc.internal.OraclePreparedStatement pstmt = null;
            pstmt = (OraclePreparedStatement)this.statementCache.searchExplicitCache(key);
            if (pstmt != null) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareStatementWithKey", "retrieved statement from cache for key={0}. ", (String)null, null, (Object)key);
                dmsSensor = this.dmsCreateStatement;
            }
            dmsSensor.start(startToken);
            dmsSensor.stop(startToken);
            if (pstmt != null) {
                pstmt = new OraclePreparedStatementWrapper(pstmt);
            }
            OraclePreparedStatement oraclePreparedStatement = pstmt;
            return oraclePreparedStatement;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            this.requireNonNullSql(sql);
            OracleResultSet.ResultSetType resultSetTypeEnum = OracleResultSet.ResultSetType.typeFor(resultSetType, resultSetConcurrency);
            OraclePreparedStatement internalStatement = this.prepareStatementInternal(sql, resultSetTypeEnum);
            OraclePreparedStatementWrapper oraclePreparedStatementWrapper = new OraclePreparedStatementWrapper(internalStatement);
            return oraclePreparedStatementWrapper;
        }
    }

    final OraclePreparedStatement prepareStatementInternal(String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        long startToken = DMSFactory.getInstance().getToken();
        DMSFactory.DMSPhase dmsSensor = this.dmsCreateNewStatement;
        OraclePreparedStatement internalStatement = (OraclePreparedStatement)this.getCachedStatement(sql, 1, resultSetType);
        if (internalStatement == null) {
            OraclePreparedStatement allocatedStatement;
            internalStatement = allocatedStatement = (OraclePreparedStatement)this.driverExtension.allocatePreparedStatement((oracle.jdbc.internal.OracleConnection)this, sql, resultSetType);
        } else {
            dmsSensor = this.dmsCreateStatement;
        }
        dmsSensor.start(startToken);
        dmsSensor.stop(startToken);
        return internalStatement;
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, -1, -1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINER)
    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            OracleCallableStatementWrapper oracleCallableStatementWrapper;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.PhysicalConnection", "prepareCall", "entering args ({0}, {1}, {2})", (String)null, null, new Object[]{string, n, n2});
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                void resultSetConcurrency;
                void resultSetType;
                void sql;
                this.requireOpenConnection();
                this.requireNonNullSql((String)sql);
                OracleResultSet.ResultSetType resultSetTypeEnum = OracleResultSet.ResultSetType.typeFor((int)resultSetType, (int)resultSetConcurrency);
                OracleCallableStatement internalStatement = this.prepareCallInternal((String)sql, resultSetTypeEnum);
                OracleCallableStatementWrapper oracleCallableStatementWrapper2 = new OracleCallableStatementWrapper(internalStatement);
                oracleCallableStatementWrapper = oracleCallableStatementWrapper2;
            }
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.PhysicalConnection", "prepareCall", "returning {0}", (String)null, null, new Object[]{oracleCallableStatementWrapper});
            return oracleCallableStatementWrapper;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.PhysicalConnection", "prepareCall", "throwing", (String)null, throwable, new Object[0]);
            throw throwable;
        }
    }

    final OracleCallableStatement prepareCallInternal(String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        long startToken = DMSFactory.getInstance().getToken();
        DMSFactory.DMSPhase dmsSensor = this.dmsCreateNewStatement;
        OracleCallableStatement internalStatement = (OracleCallableStatement)this.getCachedStatement(sql, 2, resultSetType);
        if (internalStatement == null) {
            OracleCallableStatement allocatedStatement;
            internalStatement = allocatedStatement = (OracleCallableStatement)this.driverExtension.allocateCallableStatement(this, sql, resultSetType);
        } else {
            dmsSensor = this.dmsCreateStatement;
        }
        dmsSensor.start(startToken);
        dmsSensor.stop(startToken);
        return internalStatement;
    }

    private void requireNonNullSql(String sql) throws SQLException {
        if (sql == null || sql.length() == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 104).fillInStackTrace();
        }
    }

    private OracleStatement getCachedStatement(String sql, int statementType, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        if (this.statementCache == null) {
            return null;
        }
        int resultSetTypeOrdinal = resultSetType == OracleResultSet.ResultSetType.UNKNOWN ? OracleStatement.DEFAULT_RESULT_SET_TYPE.ordinal() : resultSetType.ordinal();
        OracleStatement statement = this.statementCache.searchImplicitCache(sql, statementType, resultSetTypeOrdinal, this);
        if (statement != null) {
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getCachedStatement", "retrieved from implicit cache. sql={0}.", (String)null, null, (Object)sql);
        }
        return statement;
    }

    @Override
    public CallableStatement prepareCallWithKey(String key) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (key == null) {
                CallableStatement callableStatement = null;
                return callableStatement;
            }
            if (!this.isStatementCacheInitialized()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 95).fillInStackTrace();
            }
            long startToken = DMSFactory.getInstance().getToken();
            DMSFactory.DMSPhase dmsSensor = this.dmsCreateNewStatement;
            oracle.jdbc.internal.OracleCallableStatement cstmt = null;
            cstmt = (OracleCallableStatement)this.statementCache.searchExplicitCache(key);
            if (cstmt != null) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareCallWithKey", "retrieved statement from cache for key={0}. ", (String)null, null, (Object)key);
                dmsSensor = this.dmsCreateStatement;
            }
            dmsSensor.start(startToken);
            dmsSensor.stop(startToken);
            if (cstmt != null) {
                cstmt = new OracleCallableStatementWrapper(cstmt);
            }
            OracleCallableStatement oracleCallableStatement = cstmt;
            return oracleCallableStatement;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        if (this.sqlObj == null) {
            this.sqlObj = new OracleSql(this.conversion, this.allowMixingJdbcAndNamedBinds);
        }
        this.sqlObj.initialize(sql);
        String osql = this.sqlObj.getSql(this.processEscapes, this.convertNcharLiterals);
        return osql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (this.autocommit == autoCommit) {
                return;
            }
            if (autoCommit) {
                this.disallowGlobalTxnMode(116);
            }
            this.needLine();
            this.doSetAutoCommit(autoCommit);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.requireOpenConnection();
        return this.autocommit;
    }

    @Override
    public boolean getAutoCommitInternal() throws SQLException {
        return this.autocommit;
    }

    @Override
    public void cancel() throws SQLException {
        OracleStatement stmt = this.statements;
        if (this.lifecycle != 1 && this.lifecycle != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        boolean connectionHasBeenCancelled = false;
        while (stmt != null) {
            try {
                if (stmt.doCancel()) {
                    connectionHasBeenCancelled = true;
                }
            }
            catch (SQLException e) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "cancel", null, null, e);
            }
            stmt = stmt.next;
        }
        if (!connectionHasBeenCancelled) {
            this.cancelOperationOnServer(false);
        }
    }

    @Override
    public void commit(EnumSet<OracleConnection.CommitOption> options) throws SQLException {
        int optionsAsInt = 0;
        if (options != null) {
            if (options.contains((Object)OracleConnection.CommitOption.WRITEBATCH) && options.contains((Object)OracleConnection.CommitOption.WRITEIMMED) || options.contains((Object)OracleConnection.CommitOption.WAIT) && options.contains((Object)OracleConnection.CommitOption.NOWAIT)) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 191).fillInStackTrace();
            }
            for (OracleConnection.CommitOption option : options) {
                optionsAsInt |= option.getCode();
            }
        }
        this.commit(optionsAsInt);
    }

    void commit(int flags) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "commit(int)", "flags={0}. ", (String)null, null, (Object)flags);
            this.disallowGlobalTxnMode(114);
            if (this.autoCommitSpecCompliant && this.getAutoCommit()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 273).fillInStackTrace();
            }
            this.requireOpenConnection();
            this.validateCommitOptionFlags(flags);
            this.needLine();
            this.doCommit(flags);
        }
    }

    private final void validateCommitOptionFlags(int optionFlags) throws SQLException {
        if ((optionFlags & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0 && (optionFlags & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0 || (optionFlags & OracleConnection.CommitOption.WAIT.getCode()) != 0 && (optionFlags & OracleConnection.CommitOption.NOWAIT.getCode()) != 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 191).fillInStackTrace();
        }
    }

    @Override
    public void commit() throws SQLException {
        this.commit(this.commitOption);
    }

    @Override
    public void rollback() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "rollback", null, null, null);
            this.disallowGlobalTxnMode(115);
            if (this.autoCommitSpecCompliant && this.getAutoCommit()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 274).fillInStackTrace();
            }
            this.requireOpenConnection();
            this.needLine();
            this.doRollback();
        }
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.doClose();
        }
    }

    protected void doClose() throws SQLException {
        this.assertLockHeldByCurrentThread();
        if (this.lifecycle == 2 || this.lifecycle == 4) {
            return;
        }
        this.needLineUnchecked();
        try {
            this.prepareForLogoff();
            this.logoff();
            this.cleanup();
            if (this.timeout != null) {
                this.timeout.close();
            }
            if (this.closeCallback != null) {
                this.closeCallback.afterClose(this.privateData);
            }
        }
        finally {
            this.setLifecycle(4);
            this.isUsable = false;
            this.dmsCloseCount.occurred();
            this.dmsParent.destroy();
            this.dmsParent = null;
        }
    }

    private void prepareForLogoff() throws SQLException {
        this.prepareForLogoff(true);
    }

    private void prepareForLogoff(boolean isClosingDependents) throws SQLException {
        if (this.lifecycle != 8) {
            this.getHAManager().dropConnection(this);
        }
        if (this.closeCallback != null) {
            this.closeCallback.beforeClose(this, this.privateData);
        }
        if (isClosingDependents) {
            this.closeDependents();
        }
        if (this.isProxy) {
            this.close(1);
        }
        if (this.lifecycle == 1) {
            this.setLifecycle(2);
        }
    }

    private void closeDependents() throws SQLException {
        SQLException closeException = null;
        try {
            this.closeStatementCache();
        }
        catch (SQLException sqlException) {
            closeException = sqlException;
        }
        try {
            this.closeStatements(false);
        }
        catch (SQLException sqlException) {
            if (closeException == null) {
                closeException = sqlException;
            }
            closeException.addSuppressed(sqlException);
        }
        try {
            this.freeTemporaryBlobsAndClobs();
        }
        catch (SQLException sqlException) {
            if (closeException == null) {
                closeException = sqlException;
            }
            closeException.addSuppressed(sqlException);
        }
        try {
            if (this.timeZoneTab != null) {
                this.timeZoneTab.freeInstance();
            }
        }
        catch (SQLException sqlException) {
            if (closeException == null) {
                closeException = sqlException;
            }
            closeException.addSuppressed(sqlException);
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    @Override
    public String getDataIntegrityAlgorithmName() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getDataIntegrityAlgorithmName").fillInStackTrace();
    }

    @Override
    public String getEncryptionAlgorithmName() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getEncryptionAlgorithmName").fillInStackTrace();
    }

    @Override
    public String getAuthenticationAdaptorName() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getAuthenticationAdaptorName").fillInStackTrace();
    }

    @Override
    public void closeInternal(boolean putPhysicalConnBackInCache) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("closeInternal").fillInStackTrace();
    }

    @Override
    public void cleanupAndClose(boolean putPhysicalConnBackInCache) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("cleanupAndClose").fillInStackTrace();
    }

    @Override
    public void cleanupAndClose() throws SQLException {
        if (this.lifecycle != 1) {
            return;
        }
        this.setLifecycle(16);
        this.cancel();
    }

    @Override
    public void closeLogicalConnection() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.lifecycle == 1 || this.lifecycle == 16 || this.lifecycle == 2) {
                this.closeStatements(true);
                this.freeTemporaryBlobsAndClobs();
                this.logicalConnectionAttached = null;
                this.setLifecycle(1);
                this.dmsLogicalConnection.update(null);
            }
        }
    }

    @Override
    public void close(int opt) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.lifecycle == 2 || this.lifecycle == 4) {
                return;
            }
            if ((opt & 0x1000) != 0) {
                this.close();
                return;
            }
            if ((opt & 1) != 0 && this.isProxy) {
                this.purgeStatementCache();
                this.closeStatements(false);
                this.descriptorCacheStack[this.descriptorCacheTop--] = null;
                this.closeProxySession();
                this.isProxy = false;
                this.autocommit = this.savedAutoCommitFlag;
                this.txnMode = this.savedTxnMode;
            }
            return;
        }
    }

    @Override
    public void abort() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(CALL_ORACLE_ABORT_PERMISSION);
            }
            if (this.lifecycle == 4 || this.lifecycle == 8) {
                return;
            }
            this.setLifecycle(8);
            this.doAbort();
            this.isUsable = false;
        }
    }

    @Override
    public Set<String> getProviderAllowedProperties() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Set<String> set = super.getProviderAllowedProperties();
            return set;
        }
    }

    abstract void doAbort() throws SQLException;

    void closeProxySession() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("closeProxySession").fillInStackTrace();
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("prepareDirectPath").fillInStackTrace();
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames, String partitionName) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("prepareDirectPath").fillInStackTrace();
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames, @Blind(value=PropertiesBlinder.class) Properties dpStmtProps) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("prepareDirectPath").fillInStackTrace();
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames, String partitionName, @Blind(value=PropertiesBlinder.class) Properties dpStmtProps) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("prepareDirectPath").fillInStackTrace();
    }

    @Override
    public final boolean isClosed() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.isClosedInternal();
            return bl;
        }
    }

    final boolean isClosedInternal() {
        this.assertLockHeldByCurrentThread();
        return this.lifecycle != 1;
    }

    @Override
    public boolean isProxySession() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.isProxy;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openProxySession(int type, @Blind(value=PropertiesBlinder.class) Properties prop) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean proxyError = true;
            if (this.isProxy) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 149).fillInStackTrace();
            }
            prop = (Properties)prop.clone();
            if (type == 1) {
                String user = prop.getProperty("PROXY_USER_NAME");
                if (user == null || user.length() == 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150, "PROXY_USER_NAME cannot be null or empty.").fillInStackTrace();
                }
                Matcher userMatcher = USERNAME_PATTERN.matcher(user);
                if (!userMatcher.lookingAt()) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150, "Unrecognized format for PROXY_USER_NAME").fillInStackTrace();
                }
                int afterUser = userMatcher.end();
                if (afterUser < user.length()) {
                    if (!user.substring(afterUser, afterUser + 1).equals("/")) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150, "Unrecognized format for PROXY_USER_NAME").fillInStackTrace();
                    }
                    String passwd = prop.getProperty("PROXY_USER_PASSWORD");
                    if (passwd != null && passwd.length() > 0) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150, "Password cannot be specified in both PROXY_USER_NAME and PROXY_USER_PASSWORD").fillInStackTrace();
                    }
                    prop.setProperty("PROXY_USER_NAME", user.substring(0, afterUser));
                    prop.setProperty("PROXY_USER_PASSWORD", user.substring(afterUser + 1));
                }
            } else if (type == 2) {
                String distName = prop.getProperty("PROXY_DISTINGUISHED_NAME");
                if (distName == null || distName.length() == 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150, "PROXY_DISTINGUISHED_NAME cannot be null or empty.").fillInStackTrace();
                }
            } else if (type == 3) {
                Object certif = prop.get("PROXY_CERTIFICATE");
                if (!(certif instanceof byte[])) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150, "PROXY_CERTIFICATE must be a provided as a byte[]").fillInStackTrace();
                }
                prop.put("PROXY_CERTIFICATE", ((byte[])certif).clone());
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150, "Unrecognized type argument: " + type).fillInStackTrace();
            }
            Object roles = prop.get("PROXY_ROLES");
            if (roles instanceof String[]) {
                prop.put("PROXY_ROLES", ((String[])roles).clone());
            } else if (roles != null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150, "PROXY_ROLES must be provided as a String[]").fillInStackTrace();
            }
            this.purgeStatementCache();
            this.closeStatements(false);
            try {
                this.doProxySession(type, prop);
                ++this.descriptorCacheTop;
                this.savedAutoCommitFlag = this.autocommit;
                this.autocommit = this.defaultautocommit;
                this.savedTxnMode = this.txnMode;
                this.txnMode = 0;
                proxyError = false;
                this.currentSchema = null;
            }
            finally {
                if (proxyError && !this.isClosed()) {
                    this.closeProxySession();
                }
            }
        }
    }

    void doProxySession(int type, @Blind(value=PropertiesBlinder.class) Properties prop) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doProxySession").fillInStackTrace();
    }

    void cleanup() {
        this.fdo = null;
        this.conversion = null;
        this.statements = null;
        this.descriptorCacheStack[this.descriptorCacheTop] = null;
        this.sqlTypeToJavaClassMap = null;
        this.javaClassNameToSqlTypeMap = null;
        this.javaObjectMap = null;
        this.statementHoldingLine = null;
        this.sqlObj = null;
        this.isProxy = false;
        this.blockSource = null;
        this.connectionBufferCacheStore = null;
        threadLocalBufferCacheStore = null;
        this.tmpByteBuf = null;
        this.tmpCharBuf = null;
        this.currentSchema = null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            DatabaseMetaData databaseMetaData = this.doGetMetaData();
            return databaseMetaData;
        }
    }

    protected DatabaseMetaData doGetMetaData() throws SQLException {
        this.requireOpenConnection();
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new OracleDatabaseMetaData(this);
        }
        return this.databaseMetaData;
    }

    @Override
    public void setReadOnly(boolean value) throws SQLException {
        this.requireOpenConnection();
        this.readOnly = value;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.requireOpenConnection();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.requireOpenConnection();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.requireOpenConnection();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (this.txnLevel == level) {
                return;
            }
            try (Statement ostmt = this.createStatement();){
                switch (level) {
                    case 2: {
                        ostmt.execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
                        this.txnLevel = 2;
                        return;
                    }
                    case 8: {
                        this.isResultSetCacheEnabled = false;
                        ostmt.execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
                        this.txnLevel = 8;
                        return;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 30).fillInStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.requireOpenConnection();
        return this.txnLevel;
    }

    @Override
    public void setAutoClose(boolean autoClose) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (!autoClose) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 31).fillInStackTrace();
            }
        }
    }

    @Override
    public boolean getAutoClose() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.requireOpenConnection();
        return this.sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.requireOpenConnection();
        this.sqlWarning = null;
    }

    void setWarnings(SQLWarning warn) {
        this.sqlWarning = warn;
    }

    @Override
    public void setDefaultRowPrefetch(int value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (value <= 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 20).fillInStackTrace();
            }
            this.defaultRowPrefetch = value;
        }
    }

    @Override
    public int getDefaultRowPrefetch() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int n = this.defaultRowPrefetch;
            return n;
        }
    }

    @Override
    public boolean getTimestamptzInGmt() {
        return this.timestamptzInGmt;
    }

    @Override
    public boolean getUse1900AsYearForTime() {
        return this.use1900AsYearForTime;
    }

    @Override
    public void setDefaultExecuteBatch(int batch) throws SQLException {
    }

    @Override
    public int getDefaultExecuteBatch() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int n = 1;
            return n;
        }
    }

    @Override
    public void setRemarksReporting(boolean _reportRemarks) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.reportRemarks = _reportRemarks;
        }
    }

    @Override
    public boolean getRemarksReporting() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.reportRemarks;
            return bl;
        }
    }

    @Override
    public void setIncludeSynonyms(boolean synonyms) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.includeSynonyms = synonyms;
        }
    }

    @Override
    public String[] getEndToEndMetrics() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String[] result;
            if (this.endToEndValues == null) {
                result = null;
            } else {
                result = new String[4];
                System.arraycopy(this.endToEndValues, 0, result, 0, 4);
            }
            String[] stringArray = result;
            return stringArray;
        }
    }

    @Override
    public short getEndToEndECIDSequenceNumber() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            short s = this.endToEndECIDSequenceNumber;
            return s;
        }
    }

    @Override
    public void setEndToEndMetrics(String[] metrics, short sequenceNumber) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.dmsVersion.equals((Object)DMSFactory.DMSVersion.NONE)) {
                String[] copyMetrics = new String[metrics.length];
                System.arraycopy(metrics, 0, copyMetrics, 0, metrics.length);
                this.setEndToEndMetricsInternal(copyMetrics, sequenceNumber);
            }
        }
    }

    void setEndToEndMetricsInternal(String[] metrics, short sequenceNumber) throws SQLException {
        if (metrics != this.endToEndValues) {
            String s;
            int i;
            if (metrics.length != 4) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 156).fillInStackTrace();
            }
            for (i = 0; i < 4; ++i) {
                s = metrics[i];
                if (s == null || s.length() <= this.endToEndMaxLength[i]) continue;
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 159, s).fillInStackTrace();
            }
            if (this.endToEndValues != null) {
                for (i = 0; i < 4; ++i) {
                    s = metrics[i];
                    if ((s != null || this.endToEndValues[i] == null) && (s == null || s.equals(this.endToEndValues[i]))) continue;
                    this.endToEndHasChanged[i] = true;
                    this.endToEndAnyChanged = true;
                }
                this.endToEndHasChanged[0] = this.endToEndHasChanged[0] | this.endToEndHasChanged[3];
            } else {
                for (i = 0; i < 4; ++i) {
                    this.endToEndHasChanged[i] = true;
                }
                this.endToEndAnyChanged = true;
            }
            System.arraycopy(metrics, 0, this.endToEndValues, 0, 4);
            for (i = 0; i < 4; ++i) {
                if (metrics[i] == null) {
                    this.clientInfo.remove(END_TO_END_CLIENTINFO_KEYS[i]);
                    continue;
                }
                this.clientInfo.put(END_TO_END_CLIENTINFO_KEYS[i], metrics[i]);
            }
        }
        this.endToEndECIDSequenceNumber = sequenceNumber;
        this.clientInfo.put(END_TO_END_CLIENTINFO_KEY_SEQ_NO, Short.toString(sequenceNumber));
        this.updateTraceAttributes();
    }

    void updateSystemContext() throws SQLException {
        if (this.dmsVersion.equals((Object)DMSFactory.DMSVersion.v10G)) {
            String[] metrics = DMSFactory.getExecutionContextForJDBC().getExecutionContextState();
            if (metrics != null) {
                this.setEndToEndMetricsInternal(metrics, (short)DMSFactory.getExecutionContextForJDBC().getECIDSequenceNumber());
            }
        } else if (this.dmsVersion.equals((Object)DMSFactory.DMSVersion.v11)) {
            if (this.getVersionNumber() >= 11000) {
                this.updateSystemContext11();
            } else {
                Map<String, Map<String, String>> desired = DMSFactory.Context.getECForJDBC().getMap();
                Map<String, String> m = desired.get("E2E_CONTEXT");
                if (m != null && m.size() != 0) {
                    String[] metrics = new String[4];
                    for (int i = 0; i < e2eKeys.length; ++i) {
                        metrics[i] = m.get(e2eKeys[i]);
                    }
                    boolean sequenceNumber = false;
                    this.setEndToEndMetricsInternal(metrics, (short)0);
                }
            }
        }
    }

    void resetSystemContext() {
        for (Map.Entry<String, Map<String, String>> nsEntry : this.currentSystemContext.entrySet()) {
            String namespace = nsEntry.getKey();
            if (namespace == null || namespace.isEmpty()) continue;
            try {
                this.doClearAllApplicationContext(namespace);
            }
            catch (SQLException sQLException) {}
        }
        this.currentSystemContext = new IdentityHashMap<String, Map<String, String>>();
    }

    void updateSystemContext11() throws SQLException {
        IdentityHashMap<String, Map<String, String>> desired = new IdentityHashMap<String, Map<String, String>>(DMSFactory.Context.getECForJDBC().getMap());
        IdentityHashMap<String, Map<String, String>> current = new IdentityHashMap<String, Map<String, String>>(this.currentSystemContext);
        for (Map.Entry desiredEntry : desired.entrySet()) {
            String namespace = (String)desiredEntry.getKey();
            Map d = (Map)desiredEntry.getValue();
            IdentityHashMap<String, String> cur = (IdentityHashMap<String, String>)current.remove(namespace);
            if (cur == null) {
                if (d != null && !d.isEmpty()) {
                    cur = new IdentityHashMap<String, String>();
                    for (Map.Entry de : d.entrySet()) {
                        String k = (String)de.getKey();
                        String dv = (String)de.getValue();
                        this.doSetApplicationContext(namespace, k, dv);
                        cur.put(k, dv);
                    }
                }
            } else {
                IdentityHashMap c = new IdentityHashMap(cur);
                for (Map.Entry de : d.entrySet()) {
                    String cv;
                    String k = (String)de.getKey();
                    String dv = (String)de.getValue();
                    if (dv == (cv = (String)c.remove(k))) continue;
                    this.doSetApplicationContext(namespace, k, dv);
                    cur.put(k, dv);
                }
                if (d.isEmpty()) {
                    this.doClearAllApplicationContext(namespace);
                    this.currentSystemContext.remove(namespace);
                } else {
                    for (String k : c.keySet()) {
                        this.doSetApplicationContext(namespace, k, "");
                        cur.remove(k);
                    }
                }
            }
            if (cur == null || cur.isEmpty()) continue;
            this.currentSystemContext.put(namespace, cur);
        }
        for (String n : current.keySet()) {
            this.doClearAllApplicationContext(n);
            this.currentSystemContext.remove(n);
        }
    }

    @Override
    public boolean getIncludeSynonyms() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.includeSynonyms;
            return bl;
        }
    }

    @Override
    public void setRestrictGetTables(boolean restrict) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.restrictGettables = restrict;
        }
    }

    @Override
    public boolean getRestrictGetTables() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.restrictGettables;
            return bl;
        }
    }

    @Override
    public void setDefaultFixedString(boolean fixed) {
        this.fixedString = fixed;
    }

    void setDefaultNChar(boolean defnchar) {
        this.defaultnchar = defnchar;
    }

    @Override
    public boolean getDefaultFixedString() {
        return this.fixedString;
    }

    int getNlsRatio() {
        return 1;
    }

    @Override
    public int getC2SNlsRatio() {
        return 1;
    }

    void addStatement(OracleStatement os) {
        this.assertLockHeldByCurrentThread();
        if (os.next != null) {
            throw new Error("add_statement called twice on " + os);
        }
        os.next = this.statements;
        if (this.statements != null) {
            this.statements.prev = os;
        }
        this.statements = os;
    }

    void removeStatement(OracleStatement os) {
        this.assertLockHeldByCurrentThread();
        OracleStatement p = os.prev;
        OracleStatement n = os.next;
        if (p == null) {
            if (this.statements != os) {
                return;
            }
            this.statements = n;
        } else {
            p.next = n;
        }
        if (n != null) {
            n.prev = p;
        }
        os.next = null;
        os.prev = null;
    }

    void closeStatements(boolean needToCache) throws SQLException {
        this.assertLockHeldByCurrentThread();
        this.closeStatements(needToCache, true);
    }

    void closeStatements(boolean needToCache, boolean removeAll) throws SQLException {
        OracleStatement n;
        this.assertLockHeldByCurrentThread();
        OracleStatement s = this.statements;
        while (s != null) {
            n = s.nextChild;
            if (s.serverCursor) {
                s.closeOrCache(null);
                if (removeAll) {
                    this.removeStatement(s);
                }
            }
            s = n;
        }
        s = this.statements;
        while (s != null) {
            n = s.next;
            if (needToCache) {
                s.closeWrapper(this.isClosedInternal());
                s.closeOrCache(null);
            } else {
                s.hardClose();
                s.closeWrapper(this.isClosedInternal());
            }
            if (removeAll) {
                this.removeStatement(s);
            }
            s = n;
        }
    }

    final void purgeStatementCache() throws SQLException {
        if (this.isStatementCacheInitialized()) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "purgeStatementCache", null, null, null);
            this.statementCache.purgeImplicitCache();
            this.statementCache.purgeExplicitCache();
        }
    }

    final void closeStatementCache() throws SQLException {
        if (this.isStatementCacheInitialized()) {
            this.statementCache.close();
            this.statementCache = null;
            this.clearStatementMetaData = true;
        }
    }

    void needLine() throws SQLException {
        this.requireOpenConnection();
        this.needLineUnchecked();
    }

    void needLineUnchecked() throws SQLException {
        if (this.statementHoldingLine != null) {
            this.statementHoldingLine.freeLine();
        }
    }

    void holdLine(oracle.jdbc.internal.OracleStatement stmt) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.holdLine((OracleStatement)stmt);
        }
    }

    void holdLine(OracleStatement statement) {
        this.statementHoldingLine = statement;
    }

    void releaseLine() {
        this.assertLockHeldByCurrentThread();
        this.releaseLineForCancel();
    }

    void releaseLineForCancel() {
        this.statementHoldingLine = null;
    }

    @Override
    public void startup(String startup_str, int mode) throws SQLException {
        Monitor.CloseableLock lock = this.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                this.requireOpenConnection();
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("startup").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
            throw throwable3;
        }
    }

    @Override
    public void startup(OracleConnection.DatabaseStartupMode mode) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (mode == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            this.needLine();
            this.doStartup(mode.getMode());
        }
    }

    @Override
    public void startup(OracleConnection.DatabaseStartupMode mode, String pfileName) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (mode == null || pfileName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            this.needLine();
            this.doStartup(mode.getMode(), pfileName);
        }
    }

    void doStartup(int mode) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doStartup").fillInStackTrace();
    }

    void doStartup(int mode, String pfileName) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doStartup").fillInStackTrace();
    }

    @Override
    public void shutdown(OracleConnection.DatabaseShutdownMode mode) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (mode == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            this.needLine();
            this.doShutdown(mode.getMode());
        }
    }

    void doShutdown(int mode) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doShutdown").fillInStackTrace();
    }

    @Override
    public void archive(int mode, int aseq, String acstext) throws SQLException {
        Monitor.CloseableLock lock = this.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                this.requireOpenConnection();
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("archive").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
            throw throwable3;
        }
    }

    @Override
    public void registerSQLType(String sql_name, String java_class_name) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (sql_name == null || java_class_name == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            try {
                this.registerSQLType(sql_name, Class.forName(java_class_name));
            }
            catch (ClassNotFoundException e) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Class not found: " + java_class_name).fillInStackTrace();
            }
        }
    }

    @Override
    public void registerSQLType(String sql_name, Class<?> java_class) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (sql_name == null || java_class == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            if (this.sqlTypeToJavaClassMap == null) {
                this.sqlTypeToJavaClassMap = new Hashtable(10);
            }
            this.sqlTypeToJavaClassMap.put(sql_name, java_class);
            if (this.javaClassNameToSqlTypeMap == null) {
                this.javaClassNameToSqlTypeMap = new Hashtable<String, String>(10);
            }
            this.javaClassNameToSqlTypeMap.put(java_class.getName(), sql_name);
        }
    }

    @Override
    public String getSQLType(Object obj) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (obj != null && this.javaClassNameToSqlTypeMap != null) {
                String java_class_name = obj.getClass().getName();
                String string = this.javaClassNameToSqlTypeMap.get(java_class_name);
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Override
    public Object getJavaObject(String sql_name) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Object obj = null;
            try {
                if (sql_name != null && this.sqlTypeToJavaClassMap != null) {
                    Class<?> java_class = this.sqlTypeToJavaClassMap.get(sql_name);
                    obj = java_class.newInstance();
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            Object var5_6 = obj;
            return var5_6;
        }
    }

    @Override
    public void putDescriptor(String sql_name, Object desc) throws SQLException {
        block14: {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                if (sql_name != null && desc != null) {
                    if (this.descriptorCacheStack[this.descriptorCacheTop] == null) {
                        this.descriptorCacheStack[this.descriptorCacheTop] = new Hashtable(10);
                    }
                    ((TypeDescriptor)desc).fixupConnection(this);
                    this.descriptorCacheStack[this.descriptorCacheTop].put(sql_name, desc);
                    break block14;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
        }
    }

    @Override
    public Object getDescriptor(String sql_name) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Object object = this.doGetDescriptor(sql_name);
            return object;
        }
    }

    @Override
    public Object doGetDescriptor(String sql_name) {
        Object desc = null;
        if (sql_name != null) {
            if (this.descriptorCacheStack[this.descriptorCacheTop] != null) {
                desc = this.descriptorCacheStack[this.descriptorCacheTop].get(sql_name);
            }
            if (desc == null && this.descriptorCacheTop == 1 && this.descriptorCacheStack[0] != null) {
                desc = this.descriptorCacheStack[0].get(sql_name);
            }
        }
        return desc;
    }

    @Override
    public void removeDescriptor(String sql_name) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (sql_name != null && this.descriptorCacheStack[this.descriptorCacheTop] != null) {
                this.descriptorCacheStack[this.descriptorCacheTop].remove(sql_name);
            }
            if (sql_name != null && this.descriptorCacheTop == 1 && this.descriptorCacheStack[0] != null) {
                this.descriptorCacheStack[0].remove(sql_name);
            }
        }
    }

    @Override
    public void removeDescriptor(byte[] toid) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (toid != null) {
                String k = PhysicalConnection.toidToString(toid);
                if (this.descriptorCacheStack[this.descriptorCacheTop] != null) {
                    this.descriptorCacheStack[this.descriptorCacheTop].remove(k);
                }
                if (this.descriptorCacheTop == 1 && this.descriptorCacheStack[0] != null) {
                    this.descriptorCacheStack[0].remove(k);
                }
            }
        }
    }

    @Override
    public void removeAllDescriptor() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            for (int i = 0; i <= this.descriptorCacheTop; ++i) {
                if (this.descriptorCacheStack[i] == null) continue;
                this.descriptorCacheStack[i].clear();
            }
        }
    }

    @Override
    public int numberOfDescriptorCacheEntries() {
        int result = 0;
        for (int i = 0; i <= this.descriptorCacheTop; ++i) {
            if (this.descriptorCacheStack[i] == null) continue;
            result += this.descriptorCacheStack[i].size();
        }
        return result;
    }

    @Override
    public Enumeration<String> descriptorCacheKeys() {
        if (this.descriptorCacheTop == 0) {
            if (this.descriptorCacheStack[this.descriptorCacheTop] != null) {
                return this.descriptorCacheStack[this.descriptorCacheTop].keys();
            }
            return null;
        }
        if (this.descriptorCacheStack[0] == null && this.descriptorCacheStack[1] != null) {
            return this.descriptorCacheStack[1].keys();
        }
        if (this.descriptorCacheStack[1] == null && this.descriptorCacheStack[0] != null) {
            return this.descriptorCacheStack[0].keys();
        }
        if (this.descriptorCacheStack[0] == null && this.descriptorCacheStack[1] == null) {
            return null;
        }
        Vector<String> v = new Vector<String>(this.descriptorCacheStack[1].keySet());
        v.addAll(this.descriptorCacheStack[0].keySet());
        return v.elements();
    }

    @Override
    public void putDescriptor(byte[] toid, Object desc) throws SQLException {
        block14: {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                if (toid != null && desc != null) {
                    if (this.descriptorCacheStack[this.descriptorCacheTop] == null) {
                        this.descriptorCacheStack[this.descriptorCacheTop] = new Hashtable(10);
                    }
                    this.descriptorCacheStack[this.descriptorCacheTop].put(PhysicalConnection.toidToString(toid), desc);
                    break block14;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
        }
    }

    private static final String toidToString(byte[] toid) {
        return "TOID\u0000" + new String(toid, 0);
    }

    @Override
    public Object getDescriptor(byte[] toid) {
        this.assertLockHeldByCurrentThread();
        Object desc = null;
        if (toid != null) {
            String k = PhysicalConnection.toidToString(toid);
            if (this.descriptorCacheStack[this.descriptorCacheTop] != null) {
                desc = this.descriptorCacheStack[this.descriptorCacheTop].get(k);
            }
            if (desc == null && this.descriptorCacheTop == 1 && this.descriptorCacheStack[0] != null) {
                desc = this.descriptorCacheStack[0].get(k);
            }
        }
        return desc;
    }

    @Override
    public short getJdbcCsId() throws SQLException {
        if (this.conversion == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 65).fillInStackTrace();
        }
        return this.conversion.getClientCharSet();
    }

    @Override
    public short getDbCsId() throws SQLException {
        if (this.conversion == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 65).fillInStackTrace();
        }
        return this.conversion.getServerCharSetId();
    }

    short getNCsId() throws SQLException {
        if (this.conversion == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 65).fillInStackTrace();
        }
        return this.conversion.getNCharSetId();
    }

    @Override
    public short getStructAttrCsId() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            short s = this.getDbCsId();
            return s;
        }
    }

    @Override
    public short getStructAttrNCsId() throws SQLException {
        return this.getNCsId();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (this.sqlTypeToJavaClassMap == null) {
                this.sqlTypeToJavaClassMap = new Hashtable(10);
            }
            Map<String, Class<?>> map = this.sqlTypeToJavaClassMap;
            return map;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            this.sqlTypeToJavaClassMap = map;
        }
    }

    @Override
    public void setUsingXAFlag(boolean value) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.usingXA = value;
        }
    }

    @Override
    public boolean getUsingXAFlag() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.usingXA;
            return bl;
        }
    }

    @Override
    public void setXAErrorFlag(boolean value) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.xaWantsError = value;
        }
    }

    @Override
    public boolean getXAErrorFlag() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.xaWantsError;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPropertyFromDatabase(String sql) throws SQLException {
        String returnValue = null;
        Statement stmt = null;
        ResultSet rs = null;
        this.beginNonRequestCalls();
        try {
            stmt = this.createStatement();
            stmt.setFetchSize(1);
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                returnValue = rs.getString(1);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            this.endNonRequestCalls();
        }
        return returnValue;
    }

    @Override
    public String getUserName() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.doGetUserName();
            return string;
        }
    }

    protected String doGetUserName() throws SQLException {
        this.assertLockHeldByCurrentThread();
        if (this.proxyClientName != null) {
            return this.proxyClientName;
        }
        if (this.userName == null) {
            this.userName = this.getPropertyFromDatabase("SELECT USER FROM DUAL");
        }
        return this.userName;
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.currentSchema = this.getPropertyFromDatabase("SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL");
            return string;
        }
    }

    @Override
    public String getDefaultSchemaNameForNamedTypes() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String returnValue = null;
            returnValue = this.createDescriptorUseCurrentSchemaForSchemaName ? this.getCurrentSchema() : this.doGetUserName();
            String string = returnValue;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getFDO(boolean init) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.fdo == null && init) {
                CallableStatement cstmt = null;
                this.beginNonRequestCalls();
                try {
                    cstmt = this.prepareCall("begin :1 := sys.dbms_pickler.get_format (:2); end;");
                    cstmt.registerOutParameter(1, 2);
                    cstmt.registerOutParameter(2, -4);
                    cstmt.execute();
                    this.fdo = cstmt.getBytes(2);
                }
                finally {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                    cstmt = null;
                    this.endNonRequestCalls();
                }
            }
            byte[] byArray = this.fdo;
            return byArray;
        }
    }

    @Override
    public void setFDO(byte[] fdo) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.fdo = fdo;
        }
    }

    @Override
    public boolean getBigEndian() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.bigEndian == null) {
                int[] ub1fdo = Util.toJavaUnsignedBytes(this.getFDO(true));
                int kopfdo_auxinfo = ub1fdo[6 + ub1fdo[5] + ub1fdo[6] + 5];
                int offset = kopfdo_auxinfo & 0x10;
                if (offset < 0) {
                    offset += 256;
                }
                this.bigEndian = offset > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            boolean bl = this.bigEndian;
            return bl;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.requireOpenConnection();
        if (!this.getMetaData().supportsResultSetHoldability(holdability)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 162).fillInStackTrace();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.requireOpenConnection();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleSavepoint oracleSavepoint = this.oracleSetSavepoint();
            return oracleSavepoint;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleSavepoint oracleSavepoint = this.oracleSetSavepoint(name);
            return oracleSavepoint;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "rollback(Savepoint)", null, null, null);
            this.disallowGlobalTxnMode(115);
            if (this.autocommit) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 121).fillInStackTrace();
            }
            String _svptName = null;
            if (savepoint != null) {
                try {
                    _svptName = savepoint.getSavepointName();
                }
                catch (SQLException exc) {
                    _svptName = "ORACLE_SVPT_" + savepoint.getSavepointId();
                }
            }
            try (Statement stmt = this.createStatement();){
                stmt.executeUpdate("ROLLBACK TO " + _svptName);
            }
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("releaseSavepoint").fillInStackTrace();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.getMetaData().supportsResultSetHoldability(resultSetHoldability)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 162).fillInStackTrace();
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.getMetaData().supportsResultSetHoldability(resultSetHoldability)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 162).fillInStackTrace();
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.getMetaData().supportsResultSetHoldability(resultSetHoldability)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 162).fillInStackTrace();
        }
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            AutoKeyInfo info = AutoKeyInfo.create(sql, autoGeneratedKeys);
            if (info == null) {
                PreparedStatement preparedStatement = this.prepareStatement(sql);
                return preparedStatement;
            }
            OraclePreparedStatement internalStatement = this.prepareStatementInternal(info);
            OraclePreparedStatementWrapper oraclePreparedStatementWrapper = new OraclePreparedStatementWrapper(internalStatement);
            return oraclePreparedStatementWrapper;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            AutoKeyInfo info = AutoKeyInfo.create(sql, columnIndexes);
            if (info == null) {
                PreparedStatement preparedStatement = this.prepareStatement(sql);
                return preparedStatement;
            }
            info.initialize(this);
            OraclePreparedStatement internalStatement = this.prepareStatementInternal(info);
            OraclePreparedStatementWrapper oraclePreparedStatementWrapper = new OraclePreparedStatementWrapper(internalStatement);
            return oraclePreparedStatementWrapper;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            AutoKeyInfo info = AutoKeyInfo.create(sql, columnNames);
            if (info == null) {
                PreparedStatement preparedStatement = this.prepareStatement(sql);
                return preparedStatement;
            }
            info.getTableName();
            OraclePreparedStatement internalStatement = this.prepareStatementInternal(info);
            OraclePreparedStatementWrapper oraclePreparedStatementWrapper = new OraclePreparedStatementWrapper(internalStatement);
            return oraclePreparedStatementWrapper;
        }
    }

    final OraclePreparedStatement prepareStatementInternal(AutoKeyInfo autoKeyInfo) throws SQLException {
        long startToken = DMSFactory.getInstance().getToken();
        DMSFactory.DMSPhase dmsSensor = this.dmsCreateNewStatement;
        String sql = autoKeyInfo.getNewSql();
        OraclePreparedStatement internalStatement = (OraclePreparedStatement)this.getCachedStatement(sql, 1, OracleResultSet.ResultSetType.UNKNOWN);
        if (internalStatement == null) {
            OraclePreparedStatement allocatedStatement;
            internalStatement = allocatedStatement = (OraclePreparedStatement)this.driverExtension.allocatePreparedStatement((oracle.jdbc.internal.OracleConnection)this, sql, autoKeyInfo);
        } else {
            dmsSensor = this.dmsCreateStatement;
        }
        dmsSensor.start(startToken);
        dmsSensor.stop(startToken);
        return internalStatement;
    }

    @Override
    public OracleSavepoint oracleSetSavepoint() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.disallowGlobalTxnMode(117);
            if (this.autocommit) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 120).fillInStackTrace();
            }
            oracle.jdbc.driver.OracleSavepoint _osvpt = new oracle.jdbc.driver.OracleSavepoint();
            String _svptSqlString = "SAVEPOINT ORACLE_SVPT_" + _osvpt.getSavepointId();
            try (Statement stmt = this.createStatement();){
                stmt.executeUpdate(_svptSqlString);
            }
            oracle.jdbc.driver.OracleSavepoint oracleSavepoint = _osvpt;
            return oracleSavepoint;
        }
    }

    @Override
    public OracleSavepoint oracleSetSavepoint(String name) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.disallowGlobalTxnMode(117);
            if (this.autocommit) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 120).fillInStackTrace();
            }
            oracle.jdbc.driver.OracleSavepoint _osvpt = new oracle.jdbc.driver.OracleSavepoint(name);
            String _svptSqlString = _osvpt.getType() == 1 ? "SAVEPOINT ORACLE_SVPT_" + _osvpt.getSavepointId() : "SAVEPOINT " + _osvpt.getSavepointName();
            try (Statement stmt = this.createStatement();){
                stmt.executeUpdate(_svptSqlString);
            }
            oracle.jdbc.driver.OracleSavepoint oracleSavepoint = _osvpt;
            return oracleSavepoint;
        }
    }

    @Override
    public void oracleRollback(OracleSavepoint savepoint) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.disallowGlobalTxnMode(115);
            if (this.autocommit) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 121).fillInStackTrace();
            }
            String _svptName = null;
            if (savepoint != null) {
                try {
                    _svptName = savepoint.getSavepointName();
                }
                catch (SQLException exc) {
                    _svptName = "ORACLE_SVPT_" + savepoint.getSavepointId();
                }
            }
            try (Statement stmt = this.createStatement();){
                stmt.executeUpdate("ROLLBACK TO " + _svptName);
            }
        }
    }

    @Override
    public void oracleReleaseSavepoint(OracleSavepoint savepoint) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("oracleReleaseSavepoint").fillInStackTrace();
    }

    void disallowGlobalTxnMode(int errorCode) throws SQLException {
        if (this.txnMode == 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), errorCode).fillInStackTrace();
        }
    }

    @Override
    public void setTxnMode(int mode) {
        this.txnMode = mode;
    }

    @Override
    public int getTxnMode() {
        return this.txnMode;
    }

    @Override
    public Object getClientData(Object key) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.clientData == null) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = this.clientData.get(key);
            return object;
        }
    }

    @Override
    public Object setClientData(Object key, Object value) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.clientData == null) {
                this.clientData = new Hashtable();
            }
            Object object = this.clientData.put(key, value);
            return object;
        }
    }

    @Override
    public Object removeClientData(Object key) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.clientData == null) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = this.clientData.remove(key);
            return object;
        }
    }

    @Override
    public BlobDBAccess createBlobDBAccess() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("createBlobDBAccess").fillInStackTrace();
    }

    @Override
    public ClobDBAccess createClobDBAccess() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("createClobDBAccess").fillInStackTrace();
    }

    @Override
    public BfileDBAccess createBfileDBAccess() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("createBfileDBAccess").fillInStackTrace();
    }

    void printState() {
        try {
            short jdbc_cs_id = this.getJdbcCsId();
            short db_cs_id = this.getDbCsId();
            short struct_cs_id = this.getStructAttrCsId();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getProtocolType() {
        return this.protocol;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    @Deprecated
    public void setStmtCacheSize(int size) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.setStatementCacheSize(size);
            this.setImplicitCachingEnabled(true);
            this.setExplicitCachingEnabled(true);
        }
    }

    @Override
    @Deprecated
    public void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.setStatementCacheSize(size);
            this.setImplicitCachingEnabled(true);
            this.setExplicitCachingEnabled(true);
            this.clearStatementMetaData = clearMetaData;
        }
    }

    @Override
    @Deprecated
    public int getStmtCacheSize() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int returnValue = 0;
            try {
                returnValue = this.getStatementCacheSize();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (returnValue == -1) {
                returnValue = 0;
            }
            int n = returnValue;
            return n;
        }
    }

    @Override
    public void setStatementCacheSize(int size) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache == null) {
                this.statementCache = new LRUStatementCache(size);
                this.statementCache.createDMSSensors(this.dmsParent);
            } else {
                this.statementCache.resize(size);
            }
        }
    }

    @Override
    public int getStatementCacheSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache == null) {
                int n = -1;
                return n;
            }
            int n = this.statementCache.getCacheSize();
            return n;
        }
    }

    @Override
    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache == null) {
                this.statementCache = new LRUStatementCache(0);
                this.statementCache.createDMSSensors(this.dmsParent);
            }
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "setImplicitCachingEnabled", "implicitCacheEnabled={0}. ", null, null, cache);
            this.statementCache.setImplicitCachingEnabled(cache);
        }
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.statementCache.getImplicitCachingEnabled();
            return bl;
        }
    }

    @Override
    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache == null) {
                this.statementCache = new LRUStatementCache(0);
                this.statementCache.createDMSSensors(this.dmsParent);
            }
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "setExplicitCachingEnabled", "explicitCacheEnabled={0}. ", null, null, cache);
            this.statementCache.setExplicitCachingEnabled(cache);
        }
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.statementCache.getExplicitCachingEnabled();
            return bl;
        }
    }

    @Override
    public void purgeImplicitCache() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache != null) {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "purgeImplicitCache", null, null, null, new Object[0]);
                this.statementCache.purgeImplicitCache();
            }
        }
    }

    @Override
    public void purgeExplicitCache() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache != null) {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "purgeExplicitCache", null, null, null, new Object[0]);
                this.statementCache.purgeExplicitCache();
            }
        }
    }

    @Override
    public final PreparedStatement getStatementWithKey(String key) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleStatement cachedStatement = this.getCachedStatementWithKey(key, 1);
            if (cachedStatement == null) {
                PreparedStatement preparedStatement = null;
                return preparedStatement;
            }
            OraclePreparedStatement preparedStatement = (OraclePreparedStatement)cachedStatement;
            OraclePreparedStatementWrapper oraclePreparedStatementWrapper = new OraclePreparedStatementWrapper(preparedStatement);
            return oraclePreparedStatementWrapper;
        }
    }

    @Override
    public final CallableStatement getCallWithKey(String key) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleStatement cachedStatement = this.getCachedStatementWithKey(key, 2);
            if (cachedStatement == null) {
                CallableStatement callableStatement = null;
                return callableStatement;
            }
            OracleCallableStatement callableStatement = (OracleCallableStatement)cachedStatement;
            OracleCallableStatementWrapper oracleCallableStatementWrapper = new OracleCallableStatementWrapper(callableStatement);
            return oracleCallableStatementWrapper;
        }
    }

    protected OracleStatement getCachedStatementWithKey(String key, int statementType) throws SQLException {
        if (this.statementCache == null) {
            return null;
        }
        OracleStatement cachedStatement = this.statementCache.searchExplicitCache(key);
        if (cachedStatement == null) {
            return null;
        }
        if (cachedStatement.statementType != statementType) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 125).fillInStackTrace();
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getCachedStatementWithKey", "statement is active. key={0}, state={1}. ", (String)null, (Throwable)null, (Object)key, (Object)cachedStatement.cacheState);
        return cachedStatement;
    }

    void cacheImplicitStatement(OraclePreparedStatement stmt, String sql, int statementType, OracleResultSet.ResultSetType scrollType) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 95).fillInStackTrace();
            }
            this.statementCache.addToImplicitCache(stmt, sql, statementType, scrollType.ordinal());
        }
    }

    void cacheExplicitStatement(OraclePreparedStatement stmt, String key) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 95).fillInStackTrace();
            }
            this.statementCache.addToExplicitCache(stmt, key);
        }
    }

    @Override
    public boolean isStatementCacheInitialized() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.statementCache == null) {
                boolean bl = false;
                return bl;
            }
            if (this.statementCache.getCacheSize() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    BlockSource getBlockSource() {
        return this.blockSource;
    }

    private BufferCacheStore getBufferCacheStore() {
        if (this.useThreadLocalBufferCache) {
            if (threadLocalBufferCacheStore == null) {
                BufferCacheStore.MAX_CACHED_BUFFER_SIZE = this.maxCachedBufferSize;
                threadLocalBufferCacheStore = new ThreadLocal<BufferCacheStore>(){

                    @Override
                    protected BufferCacheStore initialValue() {
                        return new BufferCacheStore();
                    }
                };
            }
            return threadLocalBufferCacheStore.get();
        }
        if (this.connectionBufferCacheStore == null) {
            this.assertLockHeldByCurrentThread();
            if (this.connectionBufferCacheStore == null) {
                this.connectionBufferCacheStore = new BufferCacheStore(this.maxCachedBufferSize);
            }
        }
        return this.connectionBufferCacheStore;
    }

    void cacheBuffer(byte[] buffer) {
        this.assertLockHeldByCurrentThread();
        if (buffer != null) {
            BufferCacheStore s = this.getBufferCacheStore();
            s.byteBufferCache.put(buffer);
        }
    }

    void cacheBufferSync(byte[] buffer) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.cacheBuffer(buffer);
        }
    }

    void cacheBuffer(char[] buffer) {
        this.assertLockHeldByCurrentThread();
        if (buffer != null) {
            BufferCacheStore s = this.getBufferCacheStore();
            s.charBufferCache.put(buffer);
        }
    }

    public void cacheBufferSync(char[] buffer) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.cacheBuffer(buffer);
        }
    }

    byte[] getByteBuffer(int length) {
        this.assertLockHeldByCurrentThread();
        BufferCacheStore s = this.getBufferCacheStore();
        return s.byteBufferCache.get(Byte.TYPE, length);
    }

    byte[] getByteBufferSync(int length) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] byArray = this.getByteBuffer(length);
            return byArray;
        }
    }

    char[] getCharBuffer(int length) {
        this.assertLockHeldByCurrentThread();
        BufferCacheStore s = this.getBufferCacheStore();
        return s.charBufferCache.get(Character.TYPE, length);
    }

    public char[] getCharBufferSync(int length) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            char[] cArray = this.getCharBuffer(length);
            return cArray;
        }
    }

    @Override
    public OracleConnection.BufferCacheStatistics getByteBufferCacheStatistics() {
        BufferCacheStore s = this.getBufferCacheStore();
        return s.byteBufferCache.getStatistics();
    }

    @Override
    public OracleConnection.BufferCacheStatistics getCharBufferCacheStatistics() {
        BufferCacheStore s = this.getBufferCacheStore();
        return s.charBufferCache.getStatistics();
    }

    @Override
    public void registerTAFCallback(OracleOCIFailover cbk, Object obj) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("registerTAFCallback").fillInStackTrace();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (this.databaseProductVersion == "") {
            this.needLine();
            this.databaseProductVersion = this.doGetDatabaseProductVersion();
        }
        return this.databaseProductVersion;
    }

    boolean getReportRemarks() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.reportRemarks;
            return bl;
        }
    }

    @Override
    public short getVersionNumber() throws SQLException {
        if (this.versionNumber == -1) {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                if (this.versionNumber == -1) {
                    this.needLine();
                    this.versionNumber = this.doGetVersionNumber();
                }
            }
        }
        return this.versionNumber;
    }

    @Override
    public int getMajorVersionNumber() throws SQLException {
        return this.doGetMajorVersionNumber();
    }

    @Override
    public int getMinorVersionNumber() throws SQLException {
        return this.doGetMinorVersionNumber();
    }

    void registerCloseCallback(OracleCloseCallback occ, Object privData) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.closeCallback = occ;
            this.privateData = privData;
        }
    }

    @Override
    public void setCreateStatementAsRefCursor(boolean value) {
    }

    @Override
    public boolean getCreateStatementAsRefCursor() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public int pingDatabase() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.lifecycle != 1) {
                int n = -1;
                return n;
            }
            if (this.checkAndDrain()) {
                int n = -1;
                return n;
            }
            int n = this.doPingDatabase();
            return n;
        }
    }

    @Override
    public int pingDatabase(int timeOut) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.lifecycle != 1) {
                int n = -1;
                return n;
            }
            if (timeOut < 0) {
                throw new SQLException("connection validation timeout cannot be negative.");
            }
            if (this.checkAndDrain()) {
                int n = -1;
                return n;
            }
        }
        if (timeOut == 0) {
            lock = this.acquireCloseableLock();
            var3_4 = null;
            try {
                int n = this.doPingDatabase();
                return n;
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (lock != null) {
                    if (var3_4 != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
        }
        try {
            this.pingResult = -2;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try (Monitor.CloseableLock lock = PhysicalConnection.this.acquireCloseableLock();){
                        PhysicalConnection.this.pingResult = PhysicalConnection.this.doPingDatabase();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            t.start();
            t.join(TimeUnit.SECONDS.toMillis(timeOut));
            t.interrupt();
            return this.pingResult;
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            return -3;
        }
    }

    int doPingDatabase() throws SQLException {
        return this.executeDefaultConnectionValidationQuery(0);
    }

    @Override
    public Map<String, Class<?>> getJavaObjectTypeMap() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Map<String, Class<?>> map = this.javaObjectMap;
            return map;
        }
    }

    @Override
    public void setJavaObjectTypeMap(Map<String, Class<?>> map) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.javaObjectMap = map;
        }
    }

    @Override
    @Deprecated
    public void clearClientIdentifier(String clientId) throws SQLException {
        String[] metrics;
        if (this.dmsVersion.equals((Object)DMSFactory.DMSVersion.NONE) && clientId != null && clientId.length() != 0 && (metrics = this.getEndToEndMetrics()) != null && clientId.equals(metrics[1])) {
            metrics[1] = null;
            this.setEndToEndMetrics(metrics, this.getEndToEndECIDSequenceNumber());
        }
    }

    @Override
    @Deprecated
    public void setClientIdentifier(String clientId) throws SQLException {
        if (this.dmsVersion.equals((Object)DMSFactory.DMSVersion.NONE)) {
            String[] metrics = this.getEndToEndMetrics();
            if (metrics == null) {
                metrics = new String[4];
            }
            metrics[1] = clientId;
            this.setEndToEndMetrics(metrics, this.getEndToEndECIDSequenceNumber());
        }
    }

    @Override
    public void setSessionTimeZone(String regionName) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try (Statement stmt = null;){
                stmt = this.createStatement();
                stmt.executeUpdate("ALTER SESSION SET TIME_ZONE = '" + regionName + "'");
                if (this.dbTzCalendar == null) {
                    this.setDbTzCalendar(this.getDatabaseTimeZone());
                }
            }
            this.sessionTimeZone = regionName;
            this.sessionZoneId = ZoneId.of(regionName, ZoneId.SHORT_IDS);
        }
    }

    @Override
    public String getDatabaseTimeZone() throws SQLException {
        if (this.databaseTimeZone == null) {
            this.databaseTimeZone = this.getPropertyFromDatabase("SELECT DBTIMEZONE FROM DUAL");
            this.databaseZoneId = ZoneId.of(this.databaseTimeZone);
        }
        return this.databaseTimeZone;
    }

    @Override
    public ZoneId getDatabaseZoneId() throws SQLException {
        if (this.databaseZoneId == null) {
            this.getDatabaseTimeZone();
        }
        return this.databaseZoneId;
    }

    @Override
    public String getSessionTimeZone() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.sessionTimeZone;
            return string;
        }
    }

    @Override
    public ZoneId getSessionZoneId() {
        return this.sessionZoneId;
    }

    private static String to2DigitString(int number) {
        String twoDigit = number < 10 ? "0" + number : "" + number;
        return twoDigit;
    }

    String tzToOffset(String sessiontzhours) {
        if (sessiontzhours == null) {
            return sessiontzhours;
        }
        char sign = sessiontzhours.charAt(0);
        if (sign != '-' && sign != '+') {
            TimeZone tz = TimeZone.getTimeZone(sessiontzhours);
            int sessTZOffsetMillis = tz.getOffset(System.currentTimeMillis());
            if (sessTZOffsetMillis != 0) {
                int sessTZOffsetMinutes = sessTZOffsetMillis / 60000;
                int sessTZOffsetHours = sessTZOffsetMinutes / 60;
                sessiontzhours = sessTZOffsetMillis > 0 ? "+" + PhysicalConnection.to2DigitString(sessTZOffsetHours) + ":" + PhysicalConnection.to2DigitString(sessTZOffsetMinutes) : "-" + PhysicalConnection.to2DigitString(-sessTZOffsetHours) + ":" + PhysicalConnection.to2DigitString(-(sessTZOffsetMinutes -= sessTZOffsetHours * 60));
            } else {
                sessiontzhours = "+00:00";
            }
        }
        return sessiontzhours;
    }

    @Override
    public String getSessionTimeZoneOffset() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String sessiontzhours = this.getPropertyFromDatabase("SELECT SESSIONTIMEZONE FROM DUAL");
            if (sessiontzhours != null) {
                sessiontzhours = this.tzToOffset(sessiontzhours.trim());
            }
            String string = sessiontzhours;
            return string;
        }
    }

    private void setDbTzCalendar(String dbTzStr) {
        char sign = dbTzStr.charAt(0);
        if (sign == '-' || sign == '+') {
            dbTzStr = "GMT" + dbTzStr;
        }
        TimeZone tz = TimeZone.getTimeZone(dbTzStr);
        this.dbTzCalendar = new GregorianCalendar(tz);
    }

    Calendar getDbTzCalendar() throws SQLException {
        if (this.dbTzCalendar == null) {
            this.setDbTzCalendar(this.getDatabaseTimeZone());
        }
        Calendar result = null;
        if (this.dbTzCalendar != null) {
            result = (Calendar)this.dbTzCalendar.clone();
        }
        return result;
    }

    void setAccumulateBatchResult(boolean val) {
        this.accumulateBatchResult = val;
    }

    boolean isAccumulateBatchResult() {
        return this.accumulateBatchResult;
    }

    void setJ2EE13Compliant(boolean val) {
        this.j2ee13Compliant = val;
    }

    boolean getJ2EE13Compliant() {
        return this.j2ee13Compliant;
    }

    @Override
    public boolean getJDBCStandardBehavior() {
        return this.jdbcStandardBehavior;
    }

    @Override
    public Class<?> classForNameAndSchema(String name, String schemaName) throws ClassNotFoundException {
        return Class.forName(name);
    }

    Class<?> safelyGetClassForName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    static boolean isJsonJarPresent() {
        return IS_JSON_JAR_LOADED;
    }

    static boolean isJakartaJarPresent() {
        return IS_JAKARTA_JAR_LOADED;
    }

    @Override
    public int getHeapAllocSize() throws SQLException {
        this.requireOpenConnection();
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getHeapAllocSize").fillInStackTrace();
    }

    @Override
    public int getOCIEnvHeapAllocSize() throws SQLException {
        this.requireOpenConnection();
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getOCIEnvHeapAllocSize").fillInStackTrace();
    }

    static OracleConnection unwrapCompletely(oracle.jdbc.OracleConnection wrappedConnection) {
        oracle.jdbc.OracleConnection previous;
        oracle.jdbc.OracleConnection next = previous = wrappedConnection;
        while (next != null) {
            previous = next;
            next = previous.unwrap();
        }
        return (OracleConnection)previous;
    }

    @Override
    public void setWrapper(oracle.jdbc.OracleConnection w) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.wrapper = w;
        }
    }

    @Override
    public oracle.jdbc.OracleConnection unwrap() {
        return null;
    }

    @Override
    public oracle.jdbc.OracleConnection getWrapper() {
        if (this.wrapper != null) {
            return this.wrapper;
        }
        return this;
    }

    static oracle.jdbc.internal.OracleConnection _physicalConnectionWithin(Connection possiblyWrappedPossiblyLogicalConnection) {
        OracleConnection unwrappedConnection = null;
        if (possiblyWrappedPossiblyLogicalConnection != null) {
            unwrappedConnection = PhysicalConnection.unwrapCompletely((oracle.jdbc.OracleConnection)possiblyWrappedPossiblyLogicalConnection);
        }
        return unwrappedConnection;
    }

    @Override
    public oracle.jdbc.internal.OracleConnection physicalConnectionWithin() {
        return this;
    }

    @Override
    public long getTdoCState(String schemaName, String typeName) throws SQLException {
        return 0L;
    }

    @Override
    public long getTdoCState(String typeNameByUser) throws SQLException {
        return 0L;
    }

    void getOracleTypeADT(OracleTypeADT otype) throws SQLException {
    }

    @Override
    public Datum toDatum(CustomDatum inObject) throws SQLException {
        return inObject.toDatum(this);
    }

    @Override
    public short getNCharSet() {
        return this.conversion.getNCharSetId();
    }

    @Override
    public ResultSet newArrayDataResultSet(Datum[] data, long index, int count, Map<String, Class<?>> map) throws SQLException {
        return new ArrayDataResultSet(this, data, index, count, map);
    }

    @Override
    public ResultSet newArrayDataResultSet(OracleArray array, long index, int count, Map<String, Class<?>> map) throws SQLException {
        return new ArrayDataResultSet(this, array, index, count, map);
    }

    @Override
    public ResultSet newArrayLocatorResultSet(ArrayDescriptor desc, byte[] locator, long index, int count, Map<String, Class<?>> map) throws SQLException {
        return ArrayLocatorResultSet.create(this, desc, locator, index, count, map);
    }

    @Override
    public ResultSetMetaData newStructMetaData(StructDescriptor desc) throws SQLException {
        return new StructMetaData(desc);
    }

    @Override
    public int CHARBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        int[] nBytes = new int[]{nbytes};
        return this.conversion.CHARBytesToJavaChars(bytes, 0, chars, 0, nBytes, chars.length);
    }

    @Override
    public int NCHARBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        int[] nBytes = new int[1];
        return this.conversion.NCHARBytesToJavaChars(bytes, 0, chars, 0, nBytes, chars.length);
    }

    @Override
    public boolean IsNCharFixedWith() {
        return this.conversion.IsNCharFixedWith();
    }

    @Override
    public short getDriverCharSet() {
        return this.conversion.getClientCharSet();
    }

    @Override
    public CharacterSet getDbCharSet() {
        return this.conversion.getDbCharSetObj();
    }

    @Override
    public int getMaxCharSize() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 58).fillInStackTrace();
    }

    @Override
    public int getMaxCharbyteSize() {
        return this.conversion.getMaxCharbyteSize();
    }

    @Override
    public int getMaxNCharbyteSize() {
        return this.conversion.getMaxNCharbyteSize();
    }

    @Override
    public boolean isCharSetMultibyte(short charSet) {
        return DBConversion.isCharSetMultibyte(charSet);
    }

    @Override
    public int javaCharsToCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        return this.conversion.javaCharsToCHARBytes(chars, nchars, bytes);
    }

    @Override
    public int javaCharsToNCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        return this.conversion.javaCharsToNCHARBytes(chars, nchars, bytes);
    }

    @Override
    public abstract void getPropertyForPooledConnection(OraclePooledConnection var1) throws SQLException;

    final void getPropertyForPooledConnection(OraclePooledConnection pc, @Blind String password) throws SQLException {
        Hashtable hashTable = new Hashtable();
        hashTable.put("obj_type_map", this.javaObjectMap);
        Properties prop = new Properties();
        prop.put("user", this.userName);
        prop.put("password", password);
        prop.put("connection_url", this.url);
        prop.put("connect_auto_commit", "" + this.autocommit);
        prop.put("trans_isolation", "" + this.txnLevel);
        if (this.getStatementCacheSize() != -1) {
            prop.put("stmt_cache_size", "" + this.getStatementCacheSize());
            prop.put("implicit_cache_enabled", "" + this.getImplicitCachingEnabled());
            prop.put("explict_cache_enabled", "" + this.getExplicitCachingEnabled());
        }
        prop.put("defaultRowPrefetch", "" + this.defaultRowPrefetch);
        prop.put("remarksReporting", "" + this.reportRemarks);
        prop.put("AccumulateBatchResult", "" + this.accumulateBatchResult);
        prop.put("oracle.jdbc.J2EE13Compliant", "" + this.j2ee13Compliant);
        prop.put("processEscapes", "" + this.processEscapes);
        prop.put("restrictGetTables", "" + this.restrictGettables);
        prop.put("includeSynonyms", "" + this.includeSynonyms);
        prop.put("fixedString", "" + this.fixedString);
        hashTable.put("connection_properties", prop);
        pc.setProperties(hashTable);
    }

    @Override
    public Properties getDBAccessProperties() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getDBAccessProperties").fillInStackTrace();
    }

    @Override
    public Properties getOCIHandles() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getOCIHandles").fillInStackTrace();
    }

    abstract void logon(AbstractConnectionBuilder<?, ?> var1) throws SQLException;

    abstract CompletionStage<Void> logonAsync(AbstractConnectionBuilder<?, ?> var1);

    void logoff() throws SQLException {
    }

    abstract void open(OracleStatement var1) throws SQLException;

    abstract void cancelOperationOnServer(boolean var1) throws SQLException;

    abstract void doSetAutoCommit(boolean var1) throws SQLException;

    abstract void doCommit(int var1) throws SQLException;

    abstract void doRollback() throws SQLException;

    abstract String doGetDatabaseProductVersion() throws SQLException;

    abstract short doGetVersionNumber() throws SQLException;

    abstract int doGetMajorVersionNumber() throws SQLException;

    abstract int doGetMinorVersionNumber() throws SQLException;

    int getDefaultStreamChunkSize() {
        return 32768;
    }

    abstract OracleStatement RefCursorBytesToStatement(byte[] var1, OracleStatement var2) throws SQLException;

    abstract OracleStatement createImplicitResultSetStatement(OracleStatement var1) throws SQLException;

    @Override
    public oracle.jdbc.internal.OracleStatement refCursorCursorToStatement(int cursorNumber) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("refCursorCursorToStatement").fillInStackTrace();
    }

    @Override
    public Connection getLogicalConnection(OraclePooledConnection pc, boolean autoCommit) throws SQLException {
        if (this.logicalConnectionAttached != null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 143).fillInStackTrace();
        }
        LogicalConnection logicalConn = new LogicalConnection(pc, this, autoCommit);
        this.dmsLogicalConnection.update(logicalConn);
        this.logicalConnectionAttached = logicalConn;
        return logicalConn;
    }

    @Override
    public void getForm(OracleTypeADT otypeADT, OracleTypeCLOB otype, int attrIndex) throws SQLException {
    }

    @Override
    public CLOB createClob(byte[] locator_bytes) throws SQLException {
        CLOB result = new CLOB(this, locator_bytes);
        if (result.isNCLOB()) {
            result = new NCLOB(result);
        }
        return result;
    }

    @Override
    public CLOB createClobWithUnpickledBytes(byte[] locator_bytes) throws SQLException {
        CLOB result = new CLOB((oracle.jdbc.OracleConnection)this, locator_bytes, true);
        if (result.isNCLOB()) {
            result = new NCLOB(result);
        }
        return result;
    }

    @Override
    public CLOB createClob(byte[] locator_bytes, short csform) throws SQLException {
        if (csform == 2) {
            return new NCLOB(this, locator_bytes);
        }
        return new CLOB((oracle.jdbc.OracleConnection)this, locator_bytes, csform);
    }

    @Override
    public BLOB createBlob(byte[] locator_bytes) throws SQLException {
        return new BLOB(this, locator_bytes);
    }

    @Override
    public BLOB createBlobWithUnpickledBytes(byte[] locator_bytes) throws SQLException {
        return new BLOB(this, locator_bytes, true);
    }

    @Override
    public BFILE createBfile(byte[] locator_bytes) throws SQLException {
        return new BFILE(this, locator_bytes);
    }

    @Override
    public ARRAY createARRAY(String typeName, Object elements) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor(typeName, (Connection)this);
            ARRAY aRRAY = new ARRAY(descriptor, this, elements);
            return aRRAY;
        }
    }

    @Override
    public Array createOracleArray(String arrayTypeName, Object elements) throws SQLException {
        return this.createARRAY(arrayTypeName, elements);
    }

    @Override
    public BINARY_DOUBLE createBINARY_DOUBLE(double value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            BINARY_DOUBLE bINARY_DOUBLE = new BINARY_DOUBLE(value);
            return bINARY_DOUBLE;
        }
    }

    @Override
    public BINARY_FLOAT createBINARY_FLOAT(float value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            BINARY_FLOAT bINARY_FLOAT = new BINARY_FLOAT(value);
            return bINARY_FLOAT;
        }
    }

    @Override
    public DATE createDATE(Date value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            DATE dATE = new DATE(value);
            return dATE;
        }
    }

    @Override
    public DATE createDATE(Time value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            DATE dATE = new DATE(value);
            return dATE;
        }
    }

    @Override
    public DATE createDATE(Timestamp value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            DATE dATE = new DATE(value);
            return dATE;
        }
    }

    @Override
    public DATE createDATE(Date value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            DATE dATE = new DATE(value, cal);
            return dATE;
        }
    }

    @Override
    public DATE createDATE(Time value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            DATE dATE = new DATE(value, cal);
            return dATE;
        }
    }

    @Override
    public DATE createDATE(Timestamp value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            DATE dATE = new DATE(value, cal);
            return dATE;
        }
    }

    @Override
    public DATE createDATE(String value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            DATE dATE = new DATE(value);
            return dATE;
        }
    }

    @Override
    public INTERVALDS createINTERVALDS(String value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            INTERVALDS iNTERVALDS = new INTERVALDS(value);
            return iNTERVALDS;
        }
    }

    @Override
    public INTERVALYM createINTERVALYM(String value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            INTERVALYM iNTERVALYM = new INTERVALYM(value);
            return iNTERVALYM;
        }
    }

    @Override
    public NUMBER createNUMBER(boolean value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NUMBER nUMBER = new NUMBER(value);
            return nUMBER;
        }
    }

    @Override
    public NUMBER createNUMBER(byte value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NUMBER nUMBER = new NUMBER(value);
            return nUMBER;
        }
    }

    @Override
    public NUMBER createNUMBER(short value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NUMBER nUMBER = new NUMBER(value);
            return nUMBER;
        }
    }

    @Override
    public NUMBER createNUMBER(int value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NUMBER nUMBER = new NUMBER(value);
            return nUMBER;
        }
    }

    @Override
    public NUMBER createNUMBER(long value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NUMBER nUMBER = new NUMBER(value);
            return nUMBER;
        }
    }

    @Override
    public NUMBER createNUMBER(float value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NUMBER nUMBER = new NUMBER(value);
            return nUMBER;
        }
    }

    @Override
    public NUMBER createNUMBER(double value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NUMBER nUMBER = new NUMBER(value);
            return nUMBER;
        }
    }

    @Override
    public NUMBER createNUMBER(BigDecimal value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NUMBER nUMBER = new NUMBER(value);
            return nUMBER;
        }
    }

    @Override
    public NUMBER createNUMBER(BigInteger value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NUMBER nUMBER = new NUMBER(value);
            return nUMBER;
        }
    }

    @Override
    public NUMBER createNUMBER(String value, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NUMBER nUMBER = new NUMBER(value, scale);
            return nUMBER;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("createArrayOf").fillInStackTrace();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            StructDescriptor descriptor = StructDescriptor.createDescriptor(typeName, (Connection)this);
            STRUCT sTRUCT = new STRUCT(descriptor, (Connection)this, attributes);
            return sTRUCT;
        }
        catch (SQLException ex) {
            try {
                if (ex.getErrorCode() == 17049) {
                    this.removeAllDescriptor();
                }
                throw ex;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public TIMESTAMP createTIMESTAMP(Date value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMP tIMESTAMP = new TIMESTAMP(value);
            return tIMESTAMP;
        }
    }

    @Override
    public TIMESTAMP createTIMESTAMP(DATE value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMP tIMESTAMP = new TIMESTAMP(value);
            return tIMESTAMP;
        }
    }

    @Override
    public TIMESTAMP createTIMESTAMP(Time value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMP tIMESTAMP = new TIMESTAMP(value);
            return tIMESTAMP;
        }
    }

    @Override
    public TIMESTAMP createTIMESTAMP(Timestamp value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMP tIMESTAMP = new TIMESTAMP(value);
            return tIMESTAMP;
        }
    }

    @Override
    public TIMESTAMP createTIMESTAMP(Timestamp value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMP tIMESTAMP = new TIMESTAMP(value, cal);
            return tIMESTAMP;
        }
    }

    @Override
    public TIMESTAMP createTIMESTAMP(String value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMP tIMESTAMP = new TIMESTAMP(value);
            return tIMESTAMP;
        }
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Date value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this, value);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Date value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this, value, cal);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Time value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this, value);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Time value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this, value, cal);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this, value);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this, value, cal);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value, ZoneId tzid) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this, value, tzid);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(String value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this, value);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(String value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this, value, cal);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(DATE value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this, value);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Date value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPLTZ tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)this, cal, value);
            return tIMESTAMPLTZ;
        }
    }

    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Time value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPLTZ tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)this, cal, value);
            return tIMESTAMPLTZ;
        }
    }

    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Timestamp value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPLTZ tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)this, cal, value);
            return tIMESTAMPLTZ;
        }
    }

    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(String value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPLTZ tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)this, cal, value);
            return tIMESTAMPLTZ;
        }
    }

    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(DATE value, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TIMESTAMPLTZ tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)this, cal, value);
            return tIMESTAMPLTZ;
        }
    }

    public abstract BLOB createTemporaryBlob(Connection var1, boolean var2, int var3) throws SQLException;

    public abstract CLOB createTemporaryClob(Connection var1, boolean var2, int var3, short var4) throws SQLException;

    @Override
    public Blob createBlob() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            BLOB bLOB = this.createTemporaryBlob(this, true, 10);
            return bLOB;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            CLOB cLOB = this.createTemporaryClob(this, true, 10, (short)1);
            return cLOB;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            NClob nClob = (NClob)((Object)this.createTemporaryClob(this, true, 10, (short)2));
            return nClob;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            XMLType xMLType = new XMLType((Connection)this, (String)null);
            return xMLType;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean useLittleEndianSetCHARBinder() throws SQLException {
        return false;
    }

    @Override
    public void setPlsqlWarnings(String setting) throws SQLException {
        if (setting == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        if (setting != null && (setting = setting.trim()).length() > 0 && !OracleSql.isValidPlsqlWarning(setting)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        try (Statement stmt = this.createStatement(-1, -1);){
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "setPlsqlWarnings", "setting={0}. ", (String)null, (Throwable)null, (Object)setting);
            stmt.execute("ALTER SESSION SET PLSQL_WARNINGS=" + setting);
            boolean bl = this.plsqlCompilerWarnings = !setting.equals("'DISABLE:ALL'");
            if (this.plsqlCompilerWarnings) {
                try {
                    stmt.executeQuery("ALTER SESSION SET EVENTS='10933 TRACE NAME CONTEXT LEVEL 32768'");
                }
                catch (SQLException sqlE) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "setPlsqlWarnings", "Failed to relax PLSQL Compiler Warnings with event 10933. ", null, sqlE);
                }
            }
        }
    }

    void internalClose() throws SQLException {
        OracleStatement n;
        this.setLifecycle(4);
        OracleStatement s = this.statements;
        while (s != null) {
            n = s.nextChild;
            if (s.serverCursor) {
                s.internalClose();
                this.removeStatement(s);
            }
            s = n;
        }
        s = this.statements;
        while (s != null) {
            n = s.next;
            s.internalClose();
            s = n;
        }
        this.statements = null;
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 164).fillInStackTrace();
    }

    protected void doDescribeTable(AutoKeyInfo info) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doDescribeTable").fillInStackTrace();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.lifecycle != 1) {
            throw (SQLClientInfoException)DatabaseError.createSQLClientInfoException(8, null, null).fillInStackTrace();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            OracleSQLPermission permission = new OracleSQLPermission(SETCLIENTINFO_PERMISSION_NAME + name);
            security.checkPermission(permission);
        }
        this.setClientInfoInternal(name, value);
    }

    @Override
    public void setClientInfo(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLClientInfoException {
        if (this.lifecycle != 1) {
            throw (SQLClientInfoException)DatabaseError.createSQLClientInfoException(8, null, null).fillInStackTrace();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            OracleSQLPermission permission = new OracleSQLPermission("clientInfo.*");
            security.checkPermission(permission);
        }
        this.clientInfo.clear();
        HashMap<String, ClientInfoStatus> failed = new HashMap<String, ClientInfoStatus>();
        for (String k : properties.stringPropertyNames()) {
            String v = properties.getProperty(k);
            try {
                this.setClientInfoInternal(k, v);
            }
            catch (SQLClientInfoException ex) {
                failed.put(k, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            }
        }
        if (!failed.isEmpty()) {
            throw (SQLClientInfoException)DatabaseError.createSQLClientInfoException(253, failed, null).fillInStackTrace();
        }
    }

    void setClientInfoInternal(String name, String value) throws SQLClientInfoException {
        if (!SUPPORTED_NAME_PATTERN.matcher(name).matches()) {
            throw (SQLClientInfoException)DatabaseError.createSQLClientInfoException(253, null, null).fillInStackTrace();
        }
        String[] nameKeyPair = name.split("\\.", 2);
        if (RESERVED_NAMESPACES.contains(nameKeyPair[0])) {
            throw (SQLClientInfoException)DatabaseError.createSQLClientInfoException(276, null, null).fillInStackTrace();
        }
        String nameSpace = nameKeyPair[0];
        String attribute = nameKeyPair[1];
        try {
            if (nameSpace.equals("OCSID")) {
                if (attribute.equals("ACTION")) {
                    if (value != null && value.length() > this.endToEndMaxLength[0]) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 159, value).fillInStackTrace();
                    }
                    if (value == null && this.endToEndValues[0] != null || value != null) {
                        this.endToEndValues[0] = value;
                        this.endToEndHasChanged[0] = true;
                        this.endToEndAnyChanged = true;
                    }
                } else if (attribute.equals("CLIENTID")) {
                    if (value != null && value.length() > this.endToEndMaxLength[1]) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 159, value).fillInStackTrace();
                    }
                    if (value == null && this.endToEndValues[1] != null || value != null) {
                        this.endToEndValues[1] = value;
                        this.endToEndHasChanged[1] = true;
                        this.endToEndAnyChanged = true;
                    }
                } else if (attribute.equals("ECID")) {
                    if (value != null && value.length() > this.endToEndMaxLength[2]) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 159, value).fillInStackTrace();
                    }
                    if (value == null && this.endToEndValues[2] != null || value != null) {
                        this.endToEndValues[2] = value;
                        this.endToEndHasChanged[2] = true;
                        this.endToEndAnyChanged = true;
                    }
                } else if (attribute.equals("MODULE")) {
                    if (value != null && value.length() > this.endToEndMaxLength[3]) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 159, value).fillInStackTrace();
                    }
                    if (value == null && this.endToEndValues[3] != null || value != null) {
                        this.endToEndValues[3] = value;
                        this.endToEndHasChanged[3] = true;
                        this.endToEndHasChanged[0] = true;
                        this.endToEndAnyChanged = true;
                    }
                } else if (attribute.equals("SEQUENCE_NUMBER")) {
                    short seq = 0;
                    if (value != null) {
                        try {
                            seq = Short.valueOf(value);
                        }
                        catch (NumberFormatException ex) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 160, value).fillInStackTrace();
                        }
                    }
                    this.endToEndECIDSequenceNumber = seq;
                    this.endToEndAnyChanged = true;
                } else if (attribute.equals("DBOP")) {
                    if (value != null && value.length() > this.endToEndMaxLength[4]) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 159, value).fillInStackTrace();
                    }
                    if (value == null && this.endToEndValues[4] != null || value != null) {
                        this.endToEndValues[4] = value;
                        this.endToEndHasChanged[4] = true;
                        this.endToEndAnyChanged = true;
                    }
                } else if (attribute.equals("CLIENT_INFO")) {
                    if (value != null && value.length() > this.endToEndMaxLength[5]) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 159, value).fillInStackTrace();
                    }
                    if (value == null && this.endToEndValues[5] != null || value != null) {
                        this.endToEndValues[5] = value;
                        this.endToEndHasChanged[5] = true;
                        this.endToEndAnyChanged = true;
                    }
                } else {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 253, "OCSID." + attribute).fillInStackTrace();
                }
                this.updateTraceAttributes();
            } else {
                if (attribute.length() > 30) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 171).fillInStackTrace();
                }
                if (value != null && value.length() > 4000) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 172).fillInStackTrace();
                }
                this.doSetApplicationContext(nameSpace, attribute, value == null ? "" : value);
            }
            if (value == null) {
                this.clientInfo.remove(name);
            } else {
                this.clientInfo.put(name, value);
            }
        }
        catch (SQLException ex) {
            throw (SQLClientInfoException)DatabaseError.createSQLClientInfoException(1, null, ex).fillInStackTrace();
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.requireOpenConnection();
        if (name == null) {
            return null;
        }
        if (!SUPPORTED_NAME_PATTERN.matcher(name).matches()) {
            throw (SQLClientInfoException)DatabaseError.createSQLClientInfoException(253, null, null).fillInStackTrace();
        }
        return this.clientInfo.getProperty(name);
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getClientInfo() throws SQLException {
        this.requireOpenConnection();
        return (Properties)this.clientInfo.clone();
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getClientInfoInternal() throws SQLException {
        return (Properties)this.clientInfo.clone();
    }

    @Override
    public void setApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (attribute == null) {
                throw new NullPointerException();
            }
            if (nameSpace == null || nameSpace.equals("")) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 170).fillInStackTrace();
            }
            this.setClientInfoInternal(nameSpace + "." + attribute, value);
        }
    }

    void doSetApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doSetApplicationContext").fillInStackTrace();
    }

    @Override
    public void clearAllApplicationContext(String nameSpace) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (nameSpace == null) {
                throw new NullPointerException();
            }
            if (nameSpace.equals("")) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 170).fillInStackTrace();
            }
            this.doClearAllApplicationContext(nameSpace);
            if (!nameSpace.equals("OCSID")) {
                for (String key : this.clientInfo.stringPropertyNames()) {
                    if (!key.startsWith(nameSpace + ".")) continue;
                    this.clientInfo.remove(key);
                }
            }
        }
    }

    void doClearAllApplicationContext(String nameSpace) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doClearAllApplicationContext").fillInStackTrace();
    }

    @Override
    public byte[] createLightweightSession(String userName, KeywordValueLong[] inKeyVal, int inFlags, KeywordValueLong[][] outKeyVal, int[] outFlags) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("createLightweightSession").fillInStackTrace();
    }

    void executeLightweightSessionRoundtrip(int functionId, byte[] sessionId, KeywordValueLong[] inKeyVal, int inFlags, KeywordValueLong[][] outKeyVal, int[] outFlags) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("executeLightweightSessionRoundtrip").fillInStackTrace();
    }

    @Override
    public void executeLightweightSessionPiggyback(int functionId, byte[] sessionId, KeywordValueLong[] inKeyVal, int inFlags) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("executeLightweightSessionPiggyback").fillInStackTrace();
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces, XSNamespace[][] returnedNamespaces, XSSecureId secureId) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doXSNamespaceOp").fillInStackTrace();
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces, XSSecureId secureId) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doXSNamespaceOp").fillInStackTrace();
    }

    @Override
    public byte[] doXSSessionCreateOp(OracleConnection.XSSessionOperationCode opcode, XSSecureId sidp, byte[] cookie, XSPrincipal username, String tenant, XSNamespace[] namespaces, OracleConnection.XSSessionModeFlag mode, XSKeyval Kv) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doXSSessionCreateOp").fillInStackTrace();
    }

    @Override
    public void doXSSessionDestroyOp(byte[] sessionId, XSSecureId sidp, byte[] cookie) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doXSSessionDestroyOp").fillInStackTrace();
    }

    @Override
    public void doXSSessionDetachOp(int opcode, byte[] sessionId, XSSecureId sidp, boolean roundTripRPC) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doXSSessionDetachOp").fillInStackTrace();
    }

    @Override
    public void doXSSessionChangeOp(OracleConnection.XSSessionSetOperationCode opCode, byte[] sessionId, XSSecureId sidp, XSSessionParameters sessParam) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doXSSessionChangeOp").fillInStackTrace();
    }

    @Override
    public void doXSSessionAttachOp(int opCode, byte[] sessionId, XSSecureId sidp, byte[] cookie, XSPrincipal username, String[] disabledRoles, String[] enabledRoles, String[] externalRoles, XSNamespace[] namespaces, XSNamespace[] cacheNamespace, XSNamespace[] deleteNamespace, TIMESTAMPTZ midTierTimestamp, TIMESTAMPTZ authtime, int roleVersion, long inputFlag, XSKeyval Kv, int[] roleVersionOutput) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doXSSessionAttachOp").fillInStackTrace();
    }

    @Override
    public void enqueue(String queueName, AQEnqueueOptions opt, AQMessage mesg) throws SQLException {
        AQMessageI imesg = (AQMessageI)mesg;
        byte[][] msgId = new byte[1][];
        try {
            this.updateSystemContext();
            this.doEnqueue(queueName, opt, imesg.getMessagePropertiesI(), imesg.getPayloadTOID(), imesg.getPayloadVersion(), imesg.getPayload(), msgId, imesg.isRAWPayload());
        }
        catch (SQLException e) {
            this.resetSystemContext();
            throw e;
        }
        if (msgId[0] != null) {
            imesg.setMessageId(msgId[0]);
        }
    }

    @Override
    public AQMessage dequeue(String queueName, AQDequeueOptions opt, byte[] toid) throws SQLException {
        String typeName = OracleTypeADT.toid2typename(this, toid);
        return this.dequeue(queueName, opt, typeName);
    }

    @Override
    public AQMessage dequeue(String queueName, AQDequeueOptions opt, byte[] toid, int version) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[][] msgId = new byte[1][];
            AQMessagePropertiesI prop = new AQMessagePropertiesI();
            byte[][] payload = new byte[1][];
            boolean hasAMessageBeenDequeued = false;
            try {
                this.updateSystemContext();
                hasAMessageBeenDequeued = this.doDequeue(queueName, opt, prop, toid, version, payload, msgId, AQMessageI.compareToid(toid, TypeDescriptor.RAWTOID));
            }
            catch (SQLException e) {
                this.resetSystemContext();
                throw e;
            }
            AQMessageI msg = null;
            if (hasAMessageBeenDequeued) {
                msg = new AQMessageI(prop, this);
                msg.setPayload(payload[0], toid);
                msg.setMessageId(msgId[0]);
            }
            AQMessageI aQMessageI = msg;
            return aQMessageI;
        }
    }

    @Override
    public AQMessage dequeue(String queueName, AQDequeueOptions opt, String typeName) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] toid = null;
            int version = 1;
            TypeDescriptor sd = null;
            if (RAW_STR.equals(typeName) || SYS_RAW_STR.equals(typeName)) {
                toid = TypeDescriptor.RAWTOID;
            } else if (SYS_ANYDATA_STR.equals(typeName)) {
                toid = TypeDescriptor.ANYDATATOID;
            } else if (SYS_XMLTYPE_STR.equals(typeName)) {
                toid = TypeDescriptor.XMLTYPETOID;
            } else if (JSON_STR.equals(typeName)) {
                toid = TypeDescriptor.JSONTOID;
            } else {
                sd = TypeDescriptor.getTypeDescriptor(typeName, this);
                toid = ((OracleTypeADT)sd.getPickler()).getTOID();
                version = ((OracleTypeADT)sd.getPickler()).getTypeVersion();
            }
            AQMessageI msg = (AQMessageI)this.dequeue(queueName, opt, toid, version);
            if (msg != null) {
                msg.setTypeName(typeName);
                msg.setTypeDescriptor(sd);
            }
            AQMessageI aQMessageI = msg;
            return aQMessageI;
        }
    }

    @Override
    public int enqueue(String queueName, AQEnqueueOptions opt, AQMessage[] mesgs) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("enqueue[]").fillInStackTrace();
    }

    @Override
    public AQMessage[] dequeue(String queueName, AQDequeueOptions opt, String typeName, int deqSize) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("dequeue[]").fillInStackTrace();
    }

    @Override
    public AQMessage[] dequeue(String queueName, AQDequeueOptions opt, byte[] tdo, int version, int deqsize) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("dequeue[]").fillInStackTrace();
    }

    void doEnqueue(String queueName, AQEnqueueOptions enqueueOptions, AQMessagePropertiesI prop, byte[] payloadTDO, int payloadVersion, byte[] payload, byte[][] msgId, boolean isRawPayload) throws SQLException {
        Monitor.CloseableLock lock = this.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doEnqueue").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
            throw throwable3;
        }
    }

    boolean doDequeue(String queueName, AQDequeueOptions dequeueOptions, AQMessagePropertiesI msgProp, byte[] payloadTDO, int payloadVersion, byte[][] payload, byte[][] msgid, boolean isRawQueue) throws SQLException {
        Monitor.CloseableLock lock = this.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doDequeue").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
            throw throwable3;
        }
    }

    @Override
    public void jmsEnqueue(String queueName, JMSEnqueueOptions jmsEnqueueOpt, JMSMessage mesg, AQMessageProperties aqMesgProp) throws SQLException {
        byte[][] msgId = new byte[1][];
        AQMessagePropertiesI aqMesgPropI = (AQMessagePropertiesI)aqMesgProp;
        if (mesg.getStreamPayload() != null) {
            this.doJMSEnqueue(queueName, jmsEnqueueOpt, aqMesgPropI, mesg.getJMSMessageProperties(), mesg.getToid(), mesg.getStreamPayload(), msgId, mesg.getChunkSize());
        } else {
            this.doJMSEnqueue(queueName, jmsEnqueueOpt, aqMesgPropI, mesg.getJMSMessageProperties(), mesg.getToid(), mesg.getPayload(), msgId);
        }
        if (msgId[0] != null) {
            mesg.setMessageId(msgId[0]);
        }
    }

    @Override
    public void jmsEnqueue(String queueName, JMSEnqueueOptions jmsEnqueueOpt, JMSMessage[] mesgs, AQMessageProperties[] aqMesgProps) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("jmsEnqueue").fillInStackTrace();
    }

    void doJMSEnqueue(String queueName, JMSEnqueueOptions jmsEnqueueOpt, AQMessagePropertiesI prop, JMSMessageProperties jmsProp, byte[] payloadTDO, InputStream payload, byte[][] msgId, int bBlockSize) throws SQLException {
        Monitor.CloseableLock lock = this.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doJMSEnqueue").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
            throw throwable3;
        }
    }

    void doJMSEnqueue(String queueName, JMSEnqueueOptions jmsEnqueueOpt, AQMessagePropertiesI prop, JMSMessageProperties jmsProp, byte[] payloadTDO, byte[] payload, byte[][] msgId) throws SQLException {
        Monitor.CloseableLock lock = this.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doJMSEnqueue").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
            throw throwable3;
        }
    }

    @Override
    public JMSMessage jmsDequeue(String queueName, JMSDequeueOptions opt, String typeName) throws SQLException {
        JMSMessage msg = this.jmsDequeue(queueName, opt);
        return msg;
    }

    @Override
    public JMSMessage jmsDequeue(String queueName, JMSDequeueOptions opt) throws SQLException {
        byte[] toid = TypeDescriptor.RAWTOID;
        byte[][] msgId = new byte[1][];
        AQMessagePropertiesI prop = new AQMessagePropertiesI();
        JMSMessagePropertiesI jmsProp = new JMSMessagePropertiesI();
        byte[][] payload = new byte[1][];
        boolean hasAMessageBeenDequeued = false;
        hasAMessageBeenDequeued = this.doJmsDequeue(queueName, opt, prop, jmsProp, toid, payload, (byte[][])msgId);
        JMSMessage msg = null;
        if (hasAMessageBeenDequeued) {
            msg = JMSFactory.createJMSMessage(jmsProp);
            msg.setPayload(payload[0]);
            msg.setMessageId(msgId[0]);
            msg.setJMSMessageProperties(jmsProp);
            msg.setAQMessageProperties(prop);
        }
        return msg;
    }

    @Override
    public JMSMessage[] jmsDequeue(String queueName, JMSDequeueOptions opt, int size) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("jmsDequeue").fillInStackTrace();
    }

    @Override
    public JMSMessage jmsDequeue(String queueName, JMSDequeueOptions opt, OutputStream payload) throws SQLException {
        byte[] toid = TypeDescriptor.RAWTOID;
        byte[][] msgId = new byte[1][];
        AQMessagePropertiesI prop = new AQMessagePropertiesI();
        JMSMessagePropertiesI jmsProp = new JMSMessagePropertiesI();
        boolean hasAMessageBeenDequeued = false;
        hasAMessageBeenDequeued = this.doJmsDequeue(queueName, opt, prop, jmsProp, toid, payload, (byte[][])msgId);
        JMSMessage msg = null;
        if (hasAMessageBeenDequeued) {
            msg = JMSFactory.createJMSMessage(jmsProp);
            msg.setMessageId(msgId[0]);
            msg.setJMSMessageProperties(jmsProp);
            msg.setAQMessageProperties(prop);
        }
        return msg;
    }

    boolean doJmsDequeue(String queueName, JMSDequeueOptions dequeueOptions, AQMessagePropertiesI msgProp, JMSMessagePropertiesI jmsProp, byte[] payloadTDO, OutputStream payload, byte[][] msgid) throws SQLException {
        Monitor.CloseableLock lock = this.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doJmsDequeue").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
            throw throwable3;
        }
    }

    boolean doJmsDequeue(String queueName, JMSDequeueOptions dequeueOptions, AQMessagePropertiesI msgProp, JMSMessagePropertiesI jmsProp, byte[] payloadTDO, byte[][] payload, byte[][] msgid) throws SQLException {
        Monitor.CloseableLock lock = this.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doJmsDequeue").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
            throw throwable3;
        }
    }

    @Override
    public byte[] beginSaga(String initiatorName, int timeout, String currentUser, int version, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        byte[] sagaId;
        try {
            this.updateSystemContext();
            sagaId = this.doBeginSaga(initiatorName, timeout, currentUser, version, opcode, flags, spareNumeric, spareText);
        }
        catch (SQLException e) {
            this.resetSystemContext();
            throw e;
        }
        return sagaId;
    }

    public byte[] doBeginSaga(String initiatorName, int timeout, String currentUser, int version, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doBeginSaga").fillInStackTrace();
    }

    @Override
    public Integer joinSaga(String participantName, byte[] sagaId, String coordinatorName, String initiatorName, int timeout, int version, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        int joinStatus;
        try {
            this.updateSystemContext();
            joinStatus = this.doJoinSaga(participantName, sagaId, coordinatorName, initiatorName, timeout, version, opcode, flags, spareNumeric, spareText);
        }
        catch (SQLException e) {
            this.resetSystemContext();
            throw e;
        }
        return joinStatus;
    }

    public Integer doJoinSaga(String participantName, byte[] sagaId, String coordinatorName, String initiatorName, int timeout, int version, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doJoinSaga").fillInStackTrace();
    }

    @Override
    public Integer commitRollbackSaga(String participantName, byte[] sagaId, String currentUser, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        int sagaStatus;
        try {
            this.updateSystemContext();
            sagaStatus = this.doCommitRollbackSaga(participantName, sagaId, currentUser, opcode, flags, spareNumeric, spareText);
        }
        catch (SQLException e) {
            this.resetSystemContext();
            throw e;
        }
        return sagaStatus;
    }

    public Integer doCommitRollbackSaga(String participantName, byte[] sagaId, String currentUser, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doCommitRollbackSaga").fillInStackTrace();
    }

    @Override
    @Deprecated
    public boolean isV8Compatible() throws SQLException {
        return this.mapDateToTimestamp;
    }

    @Override
    public boolean getMapDateToTimestamp() {
        return this.mapDateToTimestamp;
    }

    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty whatProperty) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getInstanceProperty").fillInStackTrace();
    }

    @Override
    public Map<String, JMSNotificationRegistration> registerJMSNotification(String[] name, Map<String, Properties> options, String selector) throws SQLException {
        if (name == null || options == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "name and options cannot be null").fillInStackTrace();
        }
        Map<String, JMSNotificationRegistration> registrations = this.doRegisterJMSNotification(name, options, selector);
        return registrations;
    }

    @Override
    public Map<String, JMSNotificationRegistration> registerJMSNotification(String[] name, Map<String, Properties> options) throws SQLException {
        if (name == null || options == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "name and options cannot be null").fillInStackTrace();
        }
        Map<String, JMSNotificationRegistration> registrations = this.doRegisterJMSNotification(name, options, null);
        return registrations;
    }

    Map<String, JMSNotificationRegistration> doRegisterJMSNotification(String[] name, Map<String, Properties> options, String selector) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("JMSNotificationRegistration").fillInStackTrace();
    }

    @Override
    public void unregisterJMSNotification(JMSNotificationRegistration registration) throws SQLException {
        if (registration == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "registration cannot be null").fillInStackTrace();
        }
        NTFJMSRegistration jmsRegistration = (NTFJMSRegistration)registration;
        this.doUnregisterJMSNotification(jmsRegistration);
    }

    @Override
    public void startJMSNotification(JMSNotificationRegistration registration) throws SQLException {
        if (registration == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "registration cannot be null").fillInStackTrace();
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NTFJMSRegistration jmsRegistration = (NTFJMSRegistration)registration;
            this.doStartJMSNotification(jmsRegistration);
        }
    }

    @Override
    public void stopJMSNotification(JMSNotificationRegistration registration) throws SQLException {
        if (registration == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "registration cannot be null").fillInStackTrace();
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NTFJMSRegistration jmsRegistration = (NTFJMSRegistration)registration;
            this.doStopJMSNotification(jmsRegistration);
        }
    }

    void doUnregisterJMSNotification(NTFJMSRegistration registration) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doUnregisterJMSNotification").fillInStackTrace();
    }

    void doStartJMSNotification(NTFJMSRegistration registration) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doStartJMSNotification").fillInStackTrace();
    }

    void doStopJMSNotification(NTFJMSRegistration registration) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doStopJMSNotification").fillInStackTrace();
    }

    @Override
    public void ackJMSNotification(JMSNotificationRegistration registration, byte[] lastMessageId, JMSNotificationRegistration.Directive directive) throws SQLException {
        if (directive == null || registration == null || lastMessageId == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "directive,registration or lastMessageID cannot be null").fillInStackTrace();
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            short directiveValue = directive.getCode();
            ArrayList<JMSNotificationRegistration> regList = new ArrayList<JMSNotificationRegistration>(1);
            regList.add(registration);
            byte[][] lastMessageIds = new byte[][]{lastMessageId};
            this.doAckJMSNtfn(regList, lastMessageIds, directiveValue);
        }
    }

    @Override
    public void ackJMSNotification(ArrayList<JMSNotificationRegistration> regList, byte[][] lastMessageIds, JMSNotificationRegistration.Directive directive) throws SQLException {
        if (directive == null || regList == null || lastMessageIds == null) {
            throw (SQLException)DatabaseError.createSqlException(68, "directive,registration or lastMessageID cannot be null").fillInStackTrace();
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            short directiveValue = directive.getCode();
            this.doAckJMSNtfn(regList, lastMessageIds, directiveValue);
        }
    }

    void doAckJMSNtfn(ArrayList<JMSNotificationRegistration> regList, byte[][] lastMessageIds, short directiveValue) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doAckJMSNtfn").fillInStackTrace();
    }

    @Override
    public AQNotificationRegistration[] registerAQNotification(String[] name, Properties[] options, @Blind(value=PropertiesBlinder.class) Properties globalOptions) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String dcnhost = this.readNTFlocalhost(globalOptions);
            int tcpport = this.readNTFtcpport(globalOptions);
            boolean useSSL = this.readNTFuseSSL(globalOptions);
            NTFAQRegistration[] registrations = this.doRegisterAQNotification(name, dcnhost, tcpport, useSSL, options);
            AQNotificationRegistration[] aQNotificationRegistrationArray = registrations;
            return aQNotificationRegistrationArray;
        }
    }

    NTFAQRegistration[] doRegisterAQNotification(String[] name, String dcnhost, int tcpport, boolean useSSL, Properties[] options) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doRegisterAQNotification").fillInStackTrace();
    }

    @Override
    public void unregisterAQNotification(AQNotificationRegistration registration) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NTFAQRegistration aqregistration = (NTFAQRegistration)registration;
            this.doUnregisterAQNotification(aqregistration);
        }
    }

    void doUnregisterAQNotification(NTFAQRegistration registration) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doUnregisterAQNotification").fillInStackTrace();
    }

    private String readNTFlocalhost(@Blind(value=PropertiesBlinder.class) Properties options) throws SQLException {
        String dcnhost = null;
        try {
            dcnhost = options.getProperty("NTF_LOCAL_HOST", InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException optionsExcep1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 240).fillInStackTrace();
        }
        catch (SecurityException optionsExcep2) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 241).fillInStackTrace();
        }
        return dcnhost;
    }

    private int readNTFtcpport(@Blind(value=PropertiesBlinder.class) Properties options) throws SQLException {
        int tcpport = 0;
        try {
            tcpport = Integer.parseInt(options.getProperty("NTF_LOCAL_TCP_PORT", "0"));
            if (tcpport < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 242).fillInStackTrace();
            }
        }
        catch (NumberFormatException optionsExcep3) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 242).fillInStackTrace();
        }
        return tcpport;
    }

    int readNTFtimeout(@Blind(value=PropertiesBlinder.class) Properties options) throws SQLException {
        int timeout = 0;
        try {
            timeout = Integer.parseInt(options.getProperty("NTF_TIMEOUT", "0"));
        }
        catch (NumberFormatException optionsExcep4) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 243).fillInStackTrace();
        }
        return timeout;
    }

    boolean readNTFuseSSL(@Blind(value=PropertiesBlinder.class) Properties options) throws SQLException {
        boolean useSSL = false;
        useSSL = Boolean.parseBoolean(options.getProperty("NTF_USE_SSL", "false"));
        return useSSL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.CONFIG)
    public DatabaseChangeRegistration registerDatabaseChangeNotification(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        try {
            NTFDCNRegistration nTFDCNRegistration;
            this.debug(Level.CONFIG, SecurityLabel.INTERNAL, "oracle.jdbc.driver.PhysicalConnection", "registerDatabaseChangeNotification", "entering args ({0})", (String)null, null, new Object[]{new PropertiesBlinder().blind(properties)});
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                void options;
                String dcnhost = this.readNTFlocalhost((Properties)options);
                int tcpport = this.readNTFtcpport((Properties)options);
                int timeout = this.readNTFtimeout((Properties)options);
                int txnlag = 0;
                try {
                    txnlag = Integer.parseInt(options.getProperty("DCN_NOTIFY_CHANGELAG", "0"));
                }
                catch (NumberFormatException optionsExcep5) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 244).fillInStackTrace();
                }
                NTFDCNRegistration registration = this.doRegisterDatabaseChangeNotification(dcnhost, tcpport, (Properties)options, timeout, txnlag);
                ntfManager.addRegistration(registration);
                NTFDCNRegistration nTFDCNRegistration2 = registration;
                nTFDCNRegistration = nTFDCNRegistration2;
            }
            this.debug(Level.CONFIG, SecurityLabel.INTERNAL, "oracle.jdbc.driver.PhysicalConnection", "registerDatabaseChangeNotification", "returning {0}", (String)null, null, new Object[]{nTFDCNRegistration});
            return nTFDCNRegistration;
        }
        catch (Throwable throwable) {
            this.debug(Level.CONFIG, SecurityLabel.INTERNAL, "oracle.jdbc.driver.PhysicalConnection", "registerDatabaseChangeNotification", "throwing", (String)null, throwable, new Object[0]);
            throw throwable;
        }
    }

    NTFDCNRegistration doRegisterDatabaseChangeNotification(String dcnhost, int tcpport, @Blind(value=PropertiesBlinder.class) Properties options, int timeout, int txnlag) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doRegisterDatabaseChangeNotification").fillInStackTrace();
    }

    @Override
    public DatabaseChangeRegistration getDatabaseChangeRegistration(int regid) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NTFDCNRegistration registration;
            NTFDCNRegistration nTFDCNRegistration = registration = new NTFDCNRegistration(this.dbName, regid, this.userName, this.versionNumber);
            return nTFDCNRegistration;
        }
    }

    @Override
    public void unregisterDatabaseChangeNotification(DatabaseChangeRegistration registration) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NTFDCNRegistration dcnregistration = (NTFDCNRegistration)registration;
            if (dcnregistration.getDatabaseName().compareToIgnoreCase(this.dbName) != 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 245).fillInStackTrace();
            }
            this.doUnregisterDatabaseChangeNotification(dcnregistration);
        }
    }

    void doUnregisterDatabaseChangeNotification(NTFDCNRegistration registration) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doUnregisterDatabaseChangeNotification").fillInStackTrace();
    }

    @Override
    public void unregisterDatabaseChangeNotification(int registrationId) throws SQLException {
        String dcnhost = null;
        try {
            dcnhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unregisterDatabaseChangeNotification(registrationId, dcnhost, 47632);
    }

    @Override
    public void unregisterDatabaseChangeNotification(int registrationId, String host, int tcpport) throws SQLException {
        String location = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + host + ")(PORT=" + tcpport + "))?PR=0";
        this.unregisterDatabaseChangeNotification(registrationId, location);
    }

    @Override
    public void unregisterDatabaseChangeNotification(long registrationId, String callback) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.doUnregisterDatabaseChangeNotification(registrationId, callback);
        }
    }

    void doUnregisterDatabaseChangeNotification(long registrationId, String callback) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doUnregisterDatabaseChangeNotification").fillInStackTrace();
    }

    @Override
    public void addXSEventListener(XSEventListener listener) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("addXSEventListener").fillInStackTrace();
    }

    @Override
    public void addXSEventListener(XSEventListener listener, Executor executor) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("addXSEventListener").fillInStackTrace();
    }

    @Override
    public void removeXSEventListener(XSEventListener listener) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("removeXSEventListener").fillInStackTrace();
    }

    @Override
    public void removeAllXSEventListener() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("removeAllXSEventListener").fillInStackTrace();
    }

    @Override
    public void setPDBChangeEventListener(PDBChangeEventListener l, Executor e) throws SQLException {
        this.requireOpenConnection();
        NTFEventListener listener = new NTFEventListener(l);
        listener.setExecutor(e);
        if (this.pdbChangeListener != null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248).fillInStackTrace();
        }
        this.pdbChangeListener = listener;
    }

    @Override
    public void setPDBChangeEventListener(PDBChangeEventListener l) throws SQLException {
        this.setPDBChangeEventListener(l, null);
    }

    void notify(final NTFPDBChangeEvent event) {
        if (this.pdbChangeListener != null) {
            Executor exec = this.pdbChangeListener.getExecutor();
            if (exec != null) {
                final PDBChangeEventListener l = this.pdbChangeListener.getPDBChangeEventListener();
                exec.execute(new Runnable(){

                    @Override
                    public void run() {
                        l.pdbChanged(event);
                    }
                });
            } else {
                this.pdbChangeListener.getPDBChangeEventListener().pdbChanged(event);
            }
        }
    }

    @Override
    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("addLogicalTransactionIdEventListener").fillInStackTrace();
    }

    @Override
    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener, Executor executor) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("addLogicalTransactionIdEventListener").fillInStackTrace();
    }

    @Override
    public void removeLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("removeLogicalTransactionIdEventListener").fillInStackTrace();
    }

    @Override
    public LogicalTransactionId getLogicalTransactionId() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getLogicalTransactionId").fillInStackTrace();
    }

    @Override
    public TypeDescriptor[] getAllTypeDescriptorsInCurrentSchema() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TypeDescriptor[] result = null;
            Statement stmt = null;
            this.beginNonRequestCalls();
            try {
                stmt = this.createStatement();
                ResultSet rst = stmt.executeQuery("SELECT schema_name, typename, typoid, typecode, version, tds  FROM TABLE(private_jdbc.Get_Type_Shape_Info())");
                result = this.getTypeDescriptorsFromResultSet(rst);
                rst.close();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 904) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 165).fillInStackTrace();
                }
                throw ex;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                this.endNonRequestCalls();
            }
            TypeDescriptor[] typeDescriptorArray = result;
            return typeDescriptorArray;
        }
    }

    @Override
    public TypeDescriptor[] getTypeDescriptorsFromListInCurrentSchema(String[] typeNames) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String sql = "SELECT schema_name, typename, typoid, typecode, version, tds  FROM TABLE(private_jdbc.Get_Type_Shape_Info(?))";
            TypeDescriptor[] result = null;
            PreparedStatement stmt = null;
            this.beginNonRequestCalls();
            try {
                stmt = this.prepareStatement(sql);
                int typeNamesLength = typeNames.length;
                StringBuffer sb = new StringBuffer(typeNamesLength * 8);
                for (int i = 0; i < typeNamesLength; ++i) {
                    sb.append(typeNames[i]);
                    if (i >= typeNamesLength - 1) continue;
                    sb.append(',');
                }
                stmt.setString(1, sb.toString());
                ResultSet rst = stmt.executeQuery();
                result = this.getTypeDescriptorsFromResultSet(rst);
                rst.close();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 904) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 165).fillInStackTrace();
                }
                throw ex;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                this.endNonRequestCalls();
            }
            TypeDescriptor[] typeDescriptorArray = result;
            return typeDescriptorArray;
        }
    }

    @Override
    public TypeDescriptor[] getTypeDescriptorsFromList(String[][] schemaAndTypeNamePairs) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TypeDescriptor[] result = null;
            PreparedStatement stmt = null;
            int length = schemaAndTypeNamePairs.length;
            StringBuffer schemaNames = new StringBuffer(length * 8);
            StringBuffer typeNames = new StringBuffer(length * 8);
            for (int i = 0; i < length; ++i) {
                schemaNames.append(schemaAndTypeNamePairs[i][0]);
                typeNames.append(schemaAndTypeNamePairs[i][1]);
                if (i >= length - 1) continue;
                schemaNames.append(',');
                typeNames.append(',');
            }
            this.beginNonRequestCalls();
            try {
                String sql = "SELECT schema_name, typename, typoid, typecode, version, tds FROM TABLE(private_jdbc.Get_All_Type_Shape_Info(?,?))";
                stmt = this.prepareStatement(sql);
                stmt.setString(1, schemaNames.toString());
                stmt.setString(2, typeNames.toString());
                ResultSet rst = stmt.executeQuery();
                result = this.getTypeDescriptorsFromResultSet(rst);
                rst.close();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 904) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 165).fillInStackTrace();
                }
                throw ex;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                this.endNonRequestCalls();
            }
            TypeDescriptor[] typeDescriptorArray = result;
            return typeDescriptorArray;
        }
    }

    TypeDescriptor[] getTypeDescriptorsFromResultSet(ResultSet rst) throws SQLException {
        ArrayList<TypeDescriptor> list = new ArrayList<TypeDescriptor>();
        while (rst.next()) {
            TypeDescriptor desc;
            String schema = rst.getString(1);
            String typename = rst.getString(2);
            byte[] typoid = rst.getBytes(3);
            String typecode = rst.getString(4);
            int version = rst.getInt(5);
            byte[] tds = rst.getBytes(6);
            SQLName sqlName = new SQLName(schema, typename, this);
            if (typecode.equals("OBJECT")) {
                desc = StructDescriptor.createDescriptor(sqlName, typoid, version, tds, this);
                this.putDescriptor(typoid, (Object)desc);
                this.putDescriptor(desc.getName(), (Object)desc);
                list.add(desc);
                continue;
            }
            if (!typecode.equals("COLLECTION")) continue;
            desc = ArrayDescriptor.createDescriptor(sqlName, typoid, version, tds, this);
            this.putDescriptor(typoid, (Object)desc);
            this.putDescriptor(desc.getName(), (Object)desc);
            list.add(desc);
        }
        TypeDescriptor[] result = new TypeDescriptor[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            TypeDescriptor desc;
            result[i] = desc = (TypeDescriptor)list.get(i);
        }
        return result;
    }

    @Override
    public boolean isUsable() {
        return this.isUsable(true);
    }

    @Override
    public boolean isUsable(boolean draining) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.isUsable && draining) {
                try {
                    if (this.checkAndDrain()) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (SQLException sqlexc) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "isUsable", null, null, sqlexc);
                }
            }
            boolean bl = this.isUsable;
            return bl;
        }
    }

    @Override
    public void setUsable(boolean isUsable) {
        this.isUsable = isUsable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queryFCFProperties() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String query = "select sys_context('userenv', 'instance_name'),sys_context('userenv', 'server_host'),sys_context('userenv', 'service_name'),sys_context('userenv', 'db_unique_name') from dual";
        try {
            stmt = this.createStatement();
            stmt.setFetchSize(1);
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String val = null;
                val = rs.getString(1);
                if (val != null) {
                    this.updateSessionProperties(INSTANCE_NAME, val.trim());
                }
                if ((val = rs.getString(2)) != null) {
                    this.updateSessionProperties(SERVER_HOST, val.trim());
                }
                if ((val = rs.getString(3)) != null) {
                    this.updateSessionProperties(SERVICE_NAME, val.trim());
                }
                if ((val = rs.getString(4)) == null) continue;
                this.updateSessionProperties(DATABASE_NAME, val.trim());
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public void setDefaultTimeZone(TimeZone tz) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.defaultTimeZone = tz;
        }
    }

    @Override
    public TimeZone getDefaultTimeZone() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TimeZone timeZone = this.defaultTimeZone;
            return timeZone;
        }
    }

    @Override
    public int getTimezoneVersionNumber() throws SQLException {
        return this.timeZoneVersionNumber;
    }

    @Override
    public TIMEZONETAB getTIMEZONETAB() throws SQLException {
        if (this.timeZoneTab == null) {
            this.timeZoneTab = TIMEZONETAB.getInstance(this.getTimezoneVersionNumber());
        }
        return this.timeZoneTab;
    }

    @Override
    public boolean isDataInLocatorEnabled() throws SQLException {
        return this.getVersionNumber() >= 10200 & this.getVersionNumber() < 11000 & this.enableReadDataInLocator | this.overrideEnableReadDataInLocator;
    }

    @Override
    public boolean isLobStreamPosStandardCompliant() throws SQLException {
        return this.lobStreamPosStandardCompliant;
    }

    @Override
    public long getCurrentSCN() throws SQLException {
        return this.doGetCurrentSCN();
    }

    long doGetCurrentSCN() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doGetCurrentSCN").fillInStackTrace();
    }

    void doSetSnapshotSCN(long scn) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doSetSnapshotSCN").fillInStackTrace();
    }

    @Override
    public EnumSet<OracleConnection.TransactionState> getTransactionState() throws SQLException {
        return this.doGetTransactionState();
    }

    EnumSet<OracleConnection.TransactionState> doGetTransactionState() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doGetTransactionState").fillInStackTrace();
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException, SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("isConnectionSocketKeepAlive").fillInStackTrace();
    }

    @Override
    public void setReplayOperations(EnumSet<OracleConnection.ReplayOperation> ops) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setReplayOperations").fillInStackTrace();
    }

    @Override
    public void beginNonRequestCalls() throws SQLException {
    }

    @Override
    public void endNonRequestCalls() throws SQLException {
    }

    @Override
    public void setReplayContext(oracle.jdbc.internal.ReplayContext[] context) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setReplayContext").fillInStackTrace();
    }

    @Override
    public void setReplayingMode(boolean isReplaying) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setReplayingMode").fillInStackTrace();
    }

    @Override
    public void registerEndReplayCallback(OracleConnection.EndReplayCallback callback) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("registerEndReplayCallback").fillInStackTrace();
    }

    @Override
    public int getEOC() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getEOC").fillInStackTrace();
    }

    @Override
    public oracle.jdbc.internal.ReplayContext[] getReplayContext() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getReplayContext").fillInStackTrace();
    }

    @Override
    public oracle.jdbc.internal.ReplayContext getLastReplayContext() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getLastReplayContext").fillInStackTrace();
    }

    @Override
    public void setLastReplayContext(oracle.jdbc.internal.ReplayContext cxt) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setLastReplayContext").fillInStackTrace();
    }

    @Override
    public byte[] getDerivedKeyInternal(byte[] dhKey, int mode) throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getDerivedKeyInternal").fillInStackTrace();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(CALL_ABORT_PERMISSION);
        }
        if (executor == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 284).fillInStackTrace();
        }
        if (this.lifecycle == 4 || this.lifecycle == 8) {
            return;
        }
        this.setLifecycle(8);
        this.doAbort();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PhysicalConnection.this.close();
                }
                catch (Exception exception) {
                }
                finally {
                    PhysicalConnection.this.setLifecycle(4);
                }
            }
        });
    }

    @Override
    public String getSchema() throws SQLException {
        return this.getCurrentSchema();
    }

    @Override
    public final void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(CALL_SETNETWORKTIMEOUT_PERMISSION);
        }
        if (milliseconds < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 285).fillInStackTrace();
        }
        if (milliseconds > 0 && executor == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 284).fillInStackTrace();
        }
        this.closeExecutor = milliseconds == 0 ? null : executor;
        this.doSetNetworkTimeout(milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getNetworkTimeout").fillInStackTrace();
    }

    protected void doSetNetworkTimeout(int milliseconds) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doSetNetworkTimeout").fillInStackTrace();
    }

    void doAsynchronousClose() {
        if (this.closeExecutor != null) {
            final PhysicalConnection pc = this;
            this.closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        pc.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String schema) throws SQLException {
        if (schema == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String quoted = "\"[^\u0000\"]*\"";
        String unquoted = "(\\p{javaLowerCase}|\\p{javaUpperCase})(\\p{javaLowerCase}|\\p{javaUpperCase}|\\d|_|\\$|#)*";
        String idPat = "(\"[^\u0000\"]*\")|((\\p{javaLowerCase}|\\p{javaUpperCase})(\\p{javaLowerCase}|\\p{javaUpperCase}|\\d|_|\\$|#)*)";
        if (!schema.matches(idPat)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String sql = "alter session set current_schema = " + schema;
        try (Statement stmt = null;){
            stmt = this.createStatement();
            stmt.execute(sql);
        }
    }

    void releaseConnectionToPool() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("releaseConnectionToPool").fillInStackTrace();
    }

    boolean reusePooledConnection() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("reusePooledConnection").fillInStackTrace();
    }

    void resetAfterReusePooledConnection() throws SQLException {
        if (this.needToPurgeStatementCache()) {
            this.purgeStatementCache();
            this.closeStatements(false);
        }
    }

    @Override
    public boolean attachServerConnection() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (!this.drcpEnabled) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.reusePooledConnection();
            return bl;
        }
    }

    @Override
    public boolean isDRCPEnabled() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.drcpEnabled;
            return bl;
        }
    }

    @Override
    public boolean isDRCPMultitagEnabled() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public String getDRCPReturnTag() throws SQLException {
        return null;
    }

    @Override
    public String getDRCPPLSQLCallbackName() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.drcpPLSQLCallback;
            return string;
        }
    }

    private boolean isDRCPConnection(String url) throws SQLException {
        boolean retVal = false;
        if (this.getProtocolType().equals("kprb")) {
            return false;
        }
        if (url.matches("(?i:.*:POOLED)")) {
            retVal = true;
        } else {
            int end = url.length();
            int at_sign = url.indexOf(64);
            if (at_sign < end) {
                String tnsString = at_sign >= 0 ? url.substring(at_sign + 1) : url;
                int bracket = tnsString.indexOf(40);
                if (bracket < 0 && this.tnsAdmin != null) {
                    TNSNamesNamingAdapter tnna = new TNSNamesNamingAdapter(this.tnsAdmin);
                    try {
                        String tmpTnsString = tnna.resolve(tnsString);
                        if (tmpTnsString != null) {
                            tnsString = tmpTnsString;
                        }
                    }
                    catch (NetException tmpTnsString) {
                        // empty catch block
                    }
                }
                if (tnsString.matches("(?i:.*:POOLED)\\s*((\\?)(.*))*")) {
                    retVal = true;
                }
                NVFactory nvf = new NVFactory();
                NVNavigator nvn = new NVNavigator();
                NVPair cdata = null;
                try {
                    cdata = nvn.findNVPairRecurse(nvf.createNVPair(tnsString), "connect_data");
                }
                catch (NLException nLException) {
                    // empty catch block
                }
                if (cdata != null) {
                    String sType;
                    NVPair server = null;
                    server = nvn.findNVPair(cdata, "SERVER");
                    if (server != null && (sType = server.getAtom()) != null && (sType.equalsIgnoreCase("POOLED") || sType.equalsIgnoreCase("EMON"))) {
                        retVal = true;
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public void detachServerConnection(String tag) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (!this.drcpEnabled) {
                return;
            }
            this.drcpTagName = tag != null && !tag.isEmpty() ? tag : null;
            this.releaseConnectionToPool();
        }
    }

    @Override
    public boolean needToPurgeStatementCache() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("needToPurgeStatementCache").fillInStackTrace();
    }

    @Override
    public short getExecutingRPCFunctionCode() {
        return 0;
    }

    @Override
    public String getExecutingRPCSQL() {
        return "";
    }

    @Override
    public oracle.jdbc.internal.ResultSetCache getResultSetCache() throws SQLException {
        return this.getResultSetCacheInternal();
    }

    ResultSetCache getResultSetCacheInternal() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getResultSetCacheInternal").fillInStackTrace();
    }

    @Override
    public int getNegotiatedSDU() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getNegotiatedSDU").fillInStackTrace();
    }

    @Override
    public byte getNegotiatedTTCVersion() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getNegotiatedTTCVersion").fillInStackTrace();
    }

    @Override
    public void setChecksumMode(OracleConnection.ChecksumMode mode) throws SQLException {
        this.checksumMode = mode;
    }

    @Override
    public int getVarTypeMaxLenCompat() throws SQLException {
        return this.varTypeMaxLenCompat;
    }

    static final boolean bit(long flag, long mask) {
        return (flag & mask) == mask;
    }

    static final boolean bit(int flag, int mask) {
        return (flag & mask) == mask;
    }

    ArrayList<Long> getResultSetCacheLocalInvalidations() {
        return null;
    }

    void onPDBChange(OracleStatement catalyst) throws SQLException {
        this.debugp(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "onPDBChange", "Pluggable database has changed. Connection is now connected to PDB. AUTH_DB_ID={0}. ", null, null, () -> new Object[]{this.sessionProperties.getProperty("AUTH_DB_ID")});
        this.removeAllDescriptor();
        this.closeResultsets(catalyst);
        this.cachedCompatibleString = null;
        this.tenantName = this.getCurrentTenantName();
        this.updateSessionProperties(TENANT_NAME, this.tenantName);
        this.connectionDiagnosable.enableDebugTenant(this.tenantName);
    }

    void updateSessionProperties(String propertyName, String propertyValue) {
        if (this.sessionProperties == null) {
            this.sessionProperties = new Properties();
        }
        if (this.sessionPropertiesCopy == null) {
            this.sessionPropertiesCopy = new Properties();
        }
        if (this.sessionPropertiesDelta == null) {
            this.sessionPropertiesDelta = new Properties();
        }
        if (!this.isAutoONSConfigUpdated && AUTH_ONS_CONFIG.equals(propertyName)) {
            String newValue = this.getUpdatedAutoONSConfig(propertyValue);
            if (newValue != null && newValue.length() > 0) {
                this.sessionProperties.setProperty(AUTH_ONS_CONFIG, newValue);
                if (this.startTrackingDelta) {
                    this.sessionPropertiesDelta.setProperty(AUTH_ONS_CONFIG, newValue);
                } else {
                    this.sessionPropertiesCopy.setProperty(AUTH_ONS_CONFIG, newValue);
                }
            }
            this.isAutoONSConfigUpdated = true;
        } else {
            this.sessionProperties.setProperty(propertyName, propertyValue);
            if (this.startTrackingDelta) {
                this.sessionPropertiesDelta.setProperty(propertyName, propertyValue);
            } else {
                this.sessionPropertiesCopy.setProperty(propertyName, propertyValue);
            }
        }
    }

    void updateSessionProperties(Properties props) {
        if (this.sessionProperties == null) {
            this.sessionProperties = new Properties();
        }
        if (this.sessionPropertiesCopy == null) {
            this.sessionPropertiesCopy = new Properties();
        }
        if (this.sessionPropertiesDelta == null) {
            this.sessionPropertiesDelta = new Properties();
        }
        this.sessionProperties.putAll((Map<?, ?>)props);
        if (this.startTrackingDelta) {
            this.sessionPropertiesDelta.putAll((Map<?, ?>)props);
        } else {
            this.sessionPropertiesCopy.putAll((Map<?, ?>)props);
        }
        if (!this.isAutoONSConfigUpdated) {
            String onsConfig = this.sessionProperties.getProperty(AUTH_ONS_CONFIG);
            String newValue = this.getUpdatedAutoONSConfig(onsConfig);
            if (newValue != null && newValue.length() > 0) {
                this.sessionProperties.setProperty(AUTH_ONS_CONFIG, newValue);
                if (this.startTrackingDelta) {
                    this.sessionPropertiesDelta.setProperty(AUTH_ONS_CONFIG, newValue);
                } else {
                    this.sessionPropertiesCopy.setProperty(AUTH_ONS_CONFIG, newValue);
                }
            }
            this.isAutoONSConfigUpdated = true;
        }
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getServerSessionInfo() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Properties properties = this.sessionProperties;
            return properties;
        }
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getSessionInfoInternal() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (!this.startTrackingDelta) {
                this.startTrackingDelta = true;
                Properties properties = this.sessionPropertiesCopy;
                return properties;
            }
            if (this.sessionPropertiesDelta == null || this.sessionPropertiesDelta.isEmpty()) {
                Properties properties = this.sessionPropertiesCopy;
                return properties;
            }
            Properties newCopy = new Properties();
            newCopy.putAll((Map<?, ?>)this.sessionPropertiesCopy);
            newCopy.putAll((Map<?, ?>)this.sessionPropertiesDelta);
            this.sessionPropertiesDelta.clear();
            this.sessionPropertiesCopy = newCopy;
            Properties properties = newCopy;
            return properties;
        }
    }

    @Override
    @Blind
    public String getServerSessionInfo(String key) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.sessionProperties == null ? null : this.sessionProperties.getProperty(key);
            return string;
        }
    }

    @Blind
    private String getUpdatedAutoONSConfig(@Blind String autoONSConfig) {
        if (autoONSConfig == null || autoONSConfig.isEmpty()) {
            return autoONSConfig;
        }
        StringBuilder onsConfigBuilder = new StringBuilder(autoONSConfig);
        String _wfile = null;
        OpaqueString _wpwd = OpaqueString.NULL;
        if (this.onsWalletFile != null && !"".equals(this.onsWalletFile)) {
            _wfile = this.onsWalletFile;
            if (this.onsWalletPassword != null && this.onsWalletPassword != OpaqueString.NULL && this.onsWalletPassword != OpaqueString.EMPTY) {
                _wpwd = this.onsWalletPassword;
            }
        } else if (this.onsProtocol != null && "TCPS".equalsIgnoreCase(this.onsProtocol) && this.walletLocation != null && !"".equals(this.walletLocation)) {
            _wfile = this.walletLocation;
            if (this.walletPassword != null && this.walletPassword != OpaqueString.NULL && this.walletPassword != OpaqueString.EMPTY) {
                _wpwd = this.walletPassword;
            }
        }
        if (_wfile != null) {
            if (_wfile.startsWith("(")) {
                try {
                    _wfile = "file:" + CustomSSLSocketFactory.processWalletLocation(_wfile);
                }
                catch (NetException nexc) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "updateAutoONSConfig", "Failure when processing wallet location/file. ", null, nexc);
                    _wfile = null;
                }
            }
            if (_wfile != null) {
                onsConfigBuilder.append(ONS_WALLET_CONFIG).append(_wfile);
                if (_wpwd != null && _wpwd != OpaqueString.NULL) {
                    onsConfigBuilder.append(ONS_WALLET_PASSWD_CONFIG).append(_wpwd.get());
                }
            }
        }
        return onsConfigBuilder.toString();
    }

    public boolean isValidCursorId(int cursorId) {
        return cursorId != 0;
    }

    private void closeResultsets(OracleStatement exempt) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            ResultSet resultSet;
            OracleStatement n;
            OracleStatement s = this.statements;
            while (s != null) {
                n = s.nextChild;
                if (!s.isClosed() && s != exempt && this.isValidCursorId(s.cursorId) && (resultSet = s.getResultSet()) != null && !resultSet.isClosed()) {
                    resultSet.close();
                }
                s = n;
            }
            s = this.statements;
            while (s != null) {
                n = s.next;
                if (!s.isClosed() && s != exempt && this.isValidCursorId(s.cursorId) && (resultSet = s.getResultSet()) != null && !resultSet.isClosed()) {
                    resultSet.close();
                }
                s = n;
            }
        }
    }

    static final boolean needToQuoteIdentifier(String identifier) {
        return !nonQuotedIdentifierPattern.matcher(identifier).matches();
    }

    @Override
    public boolean isLifecycleOpen() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.lifecycle == 1;
            return bl;
        }
    }

    protected void setLifecycle(int lifecycle) {
        this.lifecycle = lifecycle;
        if (lifecycle == 1) {
            OracleDiagnosticsMXBean.addPropertyChangeListener(this.getDiagnosable());
        } else if (lifecycle != 2) {
            OracleDiagnosticsMXBean.removePropertyChangeListener(this.getDiagnosable());
            this.connectionDiagnosable.onClose();
        }
    }

    protected int getLifecycle() {
        return this.lifecycle;
    }

    @Override
    public void clearDrcpTagName() throws SQLException {
        this.drcpTagName = null;
    }

    @Override
    public void beginRequest() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.isInRequest) {
                return;
            }
            this.isInRequest = true;
            if (this.drcpMultiplexingInRequestAPIs && this.lifecycle == 1 && this.isDRCPEnabled() && this.drcpState == OracleConnection.DRCPState.DETACHED) {
                this.attachServerConnection();
            }
        }
    }

    @Override
    public void endRequest(boolean implicit) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (!this.isInRequest) {
                return;
            }
            this.isInRequest = false;
            if (this.lifecycle == 1 && !implicit) {
                this.checkAndDrain();
            }
            if (!implicit && this.drcpMultiplexingInRequestAPIs && this.lifecycle == 1 && this.isDRCPEnabled() && this.drcpState != OracleConnection.DRCPState.DETACHED) {
                this.detachServerConnection(this.getDRCPReturnTag());
            }
        }
    }

    @Override
    public final void endRequest() throws SQLException {
        this.endRequest(false);
    }

    protected final boolean isInRequest() {
        return this.isInRequest;
    }

    @Override
    public void sendRequestFlags() throws SQLException {
    }

    String getAuditBanner() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getAuditBanner").fillInStackTrace();
    }

    String getAccessBanner() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getAccessBanner").fillInStackTrace();
    }

    @Override
    public void addLargeObject(OracleLargeObject lob) throws SQLException {
    }

    @Override
    public void removeLargeObject(OracleLargeObject lob) throws SQLException {
    }

    @Override
    public void addBfile(OracleBfile bfile) throws SQLException {
    }

    @Override
    public void removeBfile(OracleBfile bfile) throws SQLException {
    }

    void addTemporaryLob(OracleLargeObject lob) {
        this.temporaryLobs.put(lob, DUMMY_VAL);
    }

    @Override
    public int freeTemporaryBlobsAndClobs() throws SQLException {
        if (this.lifecycle == 8) {
            return 0;
        }
        int numberOfLobsFreed = 0;
        HashMap<OracleLargeObject, String> lobsToFree = this.temporaryLobs;
        this.temporaryLobs = new HashMap();
        for (OracleLargeObject freeMe : lobsToFree.keySet()) {
            freeMe.freeLOB();
            ++numberOfLobsFreed;
        }
        return numberOfLobsFreed;
    }

    public void removeFromTemporaryLobs(OracleLargeObject lob) {
        this.temporaryLobs.remove(lob);
    }

    public boolean isServerBigSCN() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public void setChunkInfo(OracleShardingKey key, OracleShardingKey group, String chunkName) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setChunkInfo").fillInStackTrace();
    }

    @Override
    public void setShardingKey(OracleShardingKey key, OracleShardingKey group) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setShardingKey(key, group)").fillInStackTrace();
    }

    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey key, OracleShardingKey group, int timeout) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setShardingKeyIfValid(key, group, timeout)").fillInStackTrace();
    }

    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey key, int timeout) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setShardingKeyIfValid(key, timeout)").fillInStackTrace();
    }

    @Override
    public void setShardingKey(OracleShardingKey key) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setShardingKey(key)").fillInStackTrace();
    }

    @Override
    public HAManager getHAManager() {
        return this.haManager;
    }

    @Override
    public void setHAManager(HAManager mngr) throws SQLException {
        if (this.haManager != null && this.haManager != NoSupportHAManager.getInstance()) {
            throw new SQLException("Invalid HAManager in connection");
        }
        this.haManager = mngr;
    }

    protected String getCompatibleString() throws SQLException {
        String result;
        block25: {
            result = this.cachedCompatibleString;
            if (result == null) {
                try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                    result = this.cachedCompatibleString;
                    if (result != null) break block25;
                    try (CallableStatement cstmt = this.prepareCall("begin ? := private_jdbc.get_compatible(); end;");){
                        cstmt.registerOutParameter(1, 12);
                        cstmt.execute();
                        this.cachedCompatibleString = result = cstmt.getString(1);
                    }
                }
            }
        }
        return result;
    }

    boolean isCompatible122OrGreater() throws SQLException {
        return this.getVersionNumber() >= 12200 && this.getCompatible() >= 12200;
    }

    protected int getCompatible() throws SQLException {
        return this.decodeCompatibleDottedString(this.getCompatibleString());
    }

    protected int decodeCompatibleDottedString(String dottedString) throws SQLException {
        int decodedValue = 0;
        StringTokenizer st = new StringTokenizer(dottedString.trim(), " .", false);
        for (int ct = 0; ct < 4; ++ct) {
            int num = 0;
            try {
                if (st.hasMoreTokens()) {
                    String tk = st.nextToken();
                    try {
                        num = Integer.decode(tk);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    num = 0;
                }
                decodedValue = decodedValue * 10 + num;
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return decodedValue;
    }

    protected void cleanStatementCache() {
        if (!this.isStatementCacheInitialized()) {
            return;
        }
        this.statementCache.clearCursorIds();
    }

    @Override
    public OracleConnection.DRCPState getDRCPState() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleConnection.DRCPState dRCPState = this.drcpState;
            return dRCPState;
        }
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return false;
    }

    @Override
    public int getOutboundConnectTimeout() {
        return 0;
    }

    @Override
    public NetStat getNetworkStat() {
        return null;
    }

    @Override
    public boolean hasNoOpenHandles() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("hasNoOpenHandles").fillInStackTrace();
    }

    @Override
    public DatabaseSessionState getDatabaseSessionState() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getDatabaseSessionState").fillInStackTrace();
    }

    @Override
    public void setDatabaseSessionState(DatabaseSessionState obj) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setDatabaseSessionState").fillInStackTrace();
    }

    @Override
    public boolean isSafelyClosed() throws SQLException {
        return this.safelyClosed;
    }

    @Override
    public void flushRemoteDatabaseTTCCookieCache() {
    }

    @Override
    public void setSafelyClosed(boolean closed) throws SQLException {
        this.safelyClosed = closed;
    }

    @Blind(value=PropertiesBlinder.class)
    private Properties getConnectionPropertiesFromFile(@Blind(value=PropertiesBlinder.class) Properties info, Hashtable<String, ?> url_properties, String tnsAdmin, boolean tnsAdminFromEnv) throws SQLException {
        boolean fileOverridesConnectIdentifier;
        String connectIdentifier;
        String userDefinedFile = info.getProperty("oracle.jdbc.config.file");
        if (userDefinedFile == null) {
            userDefinedFile = PhysicalConnection.getSystemPropertyConfigFile(null);
        }
        if ((connectIdentifier = info.getProperty("database")) == null) {
            connectIdentifier = info.getProperty("oracle.jdbc.database");
        }
        if (connectIdentifier == null) {
            connectIdentifier = PhysicalConnection.getSystemPropertyDatabase(CONNECTION_PROPERTY_DATABASE_DEFAULT);
        }
        if (connectIdentifier == null) {
            fileOverridesConnectIdentifier = true;
            connectIdentifier = info.getProperty("server");
            if (connectIdentifier == null) {
                connectIdentifier = (String)url_properties.get("database");
            }
        } else {
            fileOverridesConnectIdentifier = false;
        }
        return PropertiesFileUtil.loadPropertiesFromFile(userDefinedFile, tnsAdmin, tnsAdminFromEnv, connectIdentifier, fileOverridesConnectIdentifier);
    }

    boolean checkAndDrain() throws SQLException {
        if (this.inbandNotification && this.drainOnInbandNotification()) {
            return true;
        }
        if (this.fanEnabled) {
            return this.getHAManager().checkAndDrain(this);
        }
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.isValid(this.defaultConnectionValidation, timeout);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isValid(OracleConnection.ConnectionValidation effort, int timeout) throws SQLException {
        lock = this.acquireCloseableLock();
        var4_5 = null;
        try {
            if (this.lifecycle != 1) {
                var5_6 = false;
                return var5_6;
            }
            if (timeout < 0) {
                throw (SQLException)DatabaseError.createSqlException(68, "Timeout is negative " + timeout).fillInStackTrace();
            }
            if (effort == null) {
                throw (SQLException)DatabaseError.createSqlException(68, "ConnectionValidation effort is null").fillInStackTrace();
            }
        }
        catch (Throwable var5_8) {
            var4_5 = var5_8;
            throw var5_8;
        }
        finally {
            if (lock != null) {
                if (var4_5 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable var6_14) {
                        var4_5.addSuppressed(var6_14);
                    }
                } else {
                    lock.close();
                }
            }
        }
        isValid = false;
        switch (7.$SwitchMap$oracle$jdbc$OracleConnection$ConnectionValidation[effort.ordinal()]) {
            case 1: {
                lock = this.acquireCloseableLock();
                var5_9 = null;
                v0 = isValid = this.lifecycle == 1;
                if (lock == null) break;
                if (var5_9 == null) ** GOTO lbl42
                try {
                    lock.close();
                }
                catch (Throwable var6_15) {
                    var5_9.addSuppressed(var6_15);
                }
                break;
lbl42:
                // 1 sources

                lock.close();
                break;
                catch (Throwable var6_16) {
                    try {
                        var5_9 = var6_16;
                        throw var6_16;
                    }
                    catch (Throwable var9_27) {
                        if (lock != null) {
                            if (var5_9 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable var10_28) {
                                    var5_9.addSuppressed(var10_28);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        throw var9_27;
                    }
                }
            }
            case 2: {
                lock = this.acquireCloseableLock();
                var5_10 = null;
                isValid = this.isUsable();
                if (lock == null) break;
                if (var5_10 == null) ** GOTO lbl72
                try {
                    lock.close();
                }
                catch (Throwable var6_17) {
                    var5_10.addSuppressed(var6_17);
                }
                break;
lbl72:
                // 1 sources

                lock.close();
                break;
                catch (Throwable var6_18) {
                    try {
                        var5_10 = var6_18;
                        throw var6_18;
                    }
                    catch (Throwable var11_29) {
                        if (lock != null) {
                            if (var5_10 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable var12_30) {
                                    var5_10.addSuppressed(var12_30);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        throw var11_29;
                    }
                }
            }
            case 3: {
                lock = this.acquireCloseableLock();
                var5_11 = null;
                v1 = this.inbandNotification ? !this.readInbandDownNotification() : (isValid = true);
                if (lock == null) break;
                if (var5_11 == null) ** GOTO lbl102
                try {
                    lock.close();
                }
                catch (Throwable var6_19) {
                    var5_11.addSuppressed(var6_19);
                }
                break;
lbl102:
                // 1 sources

                lock.close();
                break;
                catch (Throwable var6_20) {
                    try {
                        var5_11 = var6_20;
                        throw var6_20;
                    }
                    catch (Throwable var13_31) {
                        if (lock != null) {
                            if (var5_11 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable var14_32) {
                                    var5_11.addSuppressed(var14_32);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        throw var13_31;
                    }
                }
            }
            case 4: {
                lock = this.acquireCloseableLock();
                var5_12 = null;
                isValid = this.isValidLight(timeout);
                if (lock == null) break;
                if (var5_12 == null) ** GOTO lbl132
                try {
                    lock.close();
                }
                catch (Throwable var6_21) {
                    var5_12.addSuppressed(var6_21);
                }
                break;
lbl132:
                // 1 sources

                lock.close();
                break;
                catch (Throwable var6_22) {
                    try {
                        var5_12 = var6_22;
                        throw var6_22;
                    }
                    catch (Throwable var15_33) {
                        if (lock != null) {
                            if (var5_12 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable var16_34) {
                                    var5_12.addSuppressed(var16_34);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        throw var15_33;
                    }
                }
            }
            case 5: {
                isValid = this.pingDatabase(timeout) == 0;
                break;
            }
            case 6: 
            case 7: {
                lock = this.acquireCloseableLock();
                var5_13 = null;
                v2 = isValid = this.checkSQLEngineStatus(timeout) == 0;
                if (lock == null) break;
                if (var5_13 == null) ** GOTO lbl165
                try {
                    lock.close();
                }
                catch (Throwable var6_23) {
                    var5_13.addSuppressed(var6_23);
                }
                break;
lbl165:
                // 1 sources

                lock.close();
                break;
                catch (Throwable var6_24) {
                    try {
                        var5_13 = var6_24;
                        throw var6_24;
                    }
                    catch (Throwable var17_35) {
                        if (lock != null) {
                            if (var5_13 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable var18_36) {
                                    var5_13.addSuppressed(var18_36);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        throw var17_35;
                    }
                }
            }
        }
        return isValid;
    }

    int checkSQLEngineStatus(int timeout) throws SQLException {
        if (this.checkAndDrain()) {
            return -1;
        }
        return this.executeDefaultConnectionValidationQuery(timeout);
    }

    private int executeDefaultConnectionValidationQuery(int timeout) throws SQLException {
        this.assertLockHeldByCurrentThread();
        try (Statement stmt = this.createStatement();){
            stmt.setQueryTimeout(timeout);
            ((oracle.jdbc.OracleStatement)stmt).defineColumnType(1, 12, 1);
            stmt.executeQuery(DEFAULT_CONNECTION_VALIDATION_QUERY);
        }
        catch (SQLException ea) {
            return -1;
        }
        return 0;
    }

    boolean isValidLight(int timeout) throws SQLException {
        return this.pingDatabase(timeout) == 0;
    }

    boolean drainOnInbandNotification() throws SQLException {
        return false;
    }

    void closeConnectionSafely() throws SQLException {
        try {
            this.abort();
            this.close();
        }
        catch (SQLRecoverableException exception) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "closeConnectionSafely", null, null, exception);
        }
        finally {
            this.setSafelyClosed(true);
        }
    }

    static final String getTnsAdminFromEnv() {
        String tnsAdmin = AccessController.doPrivileged(() -> {
            String sysProp = System.getProperty(TNS_ADMIN);
            return sysProp == null ? System.getenv(TNS_ADMIN) : sysProp;
        });
        return tnsAdmin;
    }

    @Override
    public String getEncryptionProviderName() throws SQLException {
        return null;
    }

    @Override
    public String getChecksumProviderName() throws SQLException {
        return null;
    }

    @Override
    public String getNetConnectionId() throws SQLException {
        return null;
    }

    private String getNetConnectionIdForLogging() {
        try {
            return this.getNetConnectionId();
        }
        catch (SQLException e) {
            return e.getMessage();
        }
    }

    protected String getNetConnectionIdPrefix() throws SQLException {
        if (this.getNetConnectionId().length() > 24) {
            return this.getNetConnectionId().substring(0, 8);
        }
        return null;
    }

    @Override
    public Properties getJavaNetProperties() throws SQLException {
        return null;
    }

    boolean readInbandDownNotification() {
        return false;
    }

    private String throughDbCharset(String val) throws SQLException {
        byte[] dbCharSetBytes = this.conversion.getDbCharSetObj().convert(val);
        return this.conversion.getDbCharSetObj().toString(dbCharSetBytes, 0, dbCharSetBytes.length);
    }

    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        if (identifier == null) {
            throw new NullPointerException();
        }
        String ok = this.throughDbCharset(identifier);
        return IS_SIMPLE_IDENTIFIER.test(ok) || IS_QUOTED_IDENTIFIER.test(ok);
    }

    public String enquoteLiteral(String val) throws SQLException {
        if (val == null) {
            throw new NullPointerException();
        }
        String ok = this.throughDbCharset(val);
        return "'" + ok.replace("'", "''") + "'";
    }

    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        if (identifier == null) {
            throw new NullPointerException();
        }
        String ok = this.throughDbCharset(identifier);
        if (IS_SIMPLE_IDENTIFIER.test(ok)) {
            return alwaysQuote ? "\"" + ok + "\"" : this.throughDbCharset(ok.toUpperCase());
        }
        if (IS_QUOTED_IDENTIFIER.test(ok)) {
            return ok;
        }
        if (IS_VALID_IDENTIFIER.test(ok)) {
            return "\"" + ok + "\"";
        }
        throw (SQLException)DatabaseError.createSqlException(133).fillInStackTrace();
    }

    OracleJsonFactory getOracleJsonFactory() {
        if (this.jsonFactory == null) {
            this.jsonFactory = new OracleJsonFactory();
        }
        return this.jsonFactory;
    }

    @Override
    public double getPercentageQueryExecutionOnDirectShard() {
        return 0.0;
    }

    private void loadOsonConverter() {
        try {
            this.osonConverter = this.driverResources.getResource(ResourceType.OSON_PROVIDER);
            this.trace(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "loadOsonConverter", this.osonConverter.equals(DefaultOsonProvider.NO_OP_OSON_CONVERTER) ? "Oson provider not registered or oson provider matching with the registered provider name not found in the classpath" : "Oson provider: " + this.osonConverter.getClass() + " registered", null, null, new Object[0]);
        }
        catch (SQLException e) {
            this.trace(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "loadOsonConverter", "failed loading the provider with error: " + e.getMessage(), null, null, new Object[0]);
        }
    }

    protected OsonConverter getOsonConverter() {
        return this.osonConverter;
    }

    @Override
    public void addFeature(OracleConnection.ClientFeature cf) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("addFeature").fillInStackTrace();
    }

    ByteBuffer convertClobDataInNetworkCharSet(OracleClob clob, char[] clobData, int length) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    static boolean isValueBasedLocator(byte[] lobLocator) {
        if (lobLocator == null) {
            return false;
        }
        return (lobLocator[4] & 0x20) == 32;
    }

    static boolean isQuasiLocator(byte[] lobLocator) {
        if (lobLocator == null) {
            return false;
        }
        return lobLocator[3] == 4;
    }

    static boolean isReadOnly(byte[] lobLocator) {
        if (lobLocator == null) {
            return false;
        }
        return (lobLocator[6] & 1) == 1;
    }

    static boolean isTemporary(byte[] locator) {
        if (locator == null) {
            return false;
        }
        return (locator[7] & 1) > 0 || (locator[4] & 0x40) > 0 || PhysicalConnection.isValueBasedLocator(locator) || PhysicalConnection.isQuasiLocator(locator);
    }

    static boolean isMemoryLocator(byte[] locator) {
        if (locator == null) {
            return false;
        }
        return (locator[6] & 2) != 0;
    }

    @Override
    public final Executor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    void requireOpenConnection() throws SQLException {
        if (this.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
    }

    void assertNotNull(byte[] bytes, String caller) throws NullPointerException {
        if (bytes == null) {
            throw new NullPointerException("bytes are null");
        }
    }

    private void updateTraceAttributes() {
        if (this.endToEndAnyChanged) {
            for (int i = 0; i < 4; ++i) {
                if (!this.endToEndHasChanged[i]) continue;
                this.connectionDiagnosable.setTraceAttribute(TRACEKEY_AT_END_TO_END_INDEX[i], this.endToEndValues[i]);
            }
            this.connectionDiagnosable.setTraceAttribute(OracleTraceKey.SEQUENCE_NUMBER, Short.toString(this.endToEndECIDSequenceNumber));
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.connectionDiagnosable;
    }

    @Override
    public void disableLogging() throws SQLException {
        this.connectionDiagnosable.setDebugEnabled(false);
    }

    @Override
    public void enableLogging() throws SQLException {
        this.connectionDiagnosable.setDebugEnabled(true);
    }

    @Override
    public void dumpLog() throws SQLException {
        this.connectionDiagnosable.dumpDiagnoseFirstFailure();
    }

    @Override
    public void enableDiagnoseFirstFailureDump(boolean enableDump) throws SQLException {
        this.connectionDiagnosable.enableDiagnoseFirstFailureDump(enableDump);
    }

    protected boolean isTraceEventListenerEnabled() {
        return this.traceEventListener != DefaultTraceEventListenerProvider.NO_OP_TRACE_EVENT_LISTENER;
    }

    @Override
    public TraceEventListener getTraceEventListener() {
        return this.traceEventListener;
    }

    private void setTraceEventListener(TraceEventListener traceEventListener) {
        if (traceEventListener != null) {
            this.traceEventListener = traceEventListener;
        }
    }

    private void trace(TraceEventListener.Sequence sequence) {
        if (this.isTraceEventListenerEnabled()) {
            ConnectionTraceContext traceContext = new ConnectionTraceContext(this);
            this.traceUserContext = this.traceEventListener.roundTrip(sequence, traceContext, this.traceUserContext);
            traceContext.reset();
        }
    }

    protected String getTenantName() {
        return this.tenantName;
    }

    protected String getExecutingRpcFunctionCodeDescription() {
        return this.executingRpcFunctionCodeDescription;
    }

    protected Boolean isLastRpcCompletedExceptionally() {
        return this.isLastRpcCompletedExceptionally;
    }

    protected void beforeRoundTrip(String description) {
        this.isLastRpcCompletedExceptionally = false;
        this.executingRpcFunctionCodeDescription = description;
        this.trace(TraceEventListener.Sequence.BEFORE);
    }

    protected void afterRoundTrip(Boolean isCompletedExceptionally) {
        this.isLastRpcCompletedExceptionally = isCompletedExceptionally;
        this.trace(TraceEventListener.Sequence.AFTER);
        this.executingRpcFunctionCodeDescription = "";
    }

    protected DriverResources getDriverResources() {
        return this.driverResources;
    }

    protected void awaitPipeline() throws SQLException {
    }

    static {
        boolean isJsonJarLoaded = false;
        try {
            Class.forName("javax.json.JsonValue");
            isJsonJarLoaded = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        boolean isJakartaJarLoaded = false;
        try {
            Class.forName("jakarta.json.JsonValue");
            isJakartaJarLoaded = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_JAKARTA_JAR_LOADED = isJakartaJarLoaded;
        IS_JSON_JAR_LOADED = isJsonJarLoaded;
        RESERVED_NAMESPACES = Arrays.asList("SYS");
        SUPPORTED_NAME_PATTERN = Pattern.compile("\\w+\\.[a-zA-Z0-9_$]+");
        CALL_ABORT_PERMISSION = new SQLPermission("callAbort");
        CALL_SETNETWORKTIMEOUT_PERMISSION = new SQLPermission("setNetworkTimeout");
        nonQuotedIdentifierPattern = Pattern.compile("[a-zA-Z]\\w*");
        IS_SIMPLE_IDENTIFIER = Pattern.compile("\\A\\p{IsAlphabetic}[\\p{IsAlphabetic}\\p{IsDigit}_$#]*\\z").asPredicate();
        IS_QUOTED_IDENTIFIER = Pattern.compile("\\A\"[^\"\\u0000]+\"\\z").asPredicate();
        IS_VALID_IDENTIFIER = Pattern.compile("\\A[^\"\\u0000]+\\z").asPredicate();
        TRACEKEY_AT_END_TO_END_INDEX = new TraceKey[6];
        PhysicalConnection.TRACEKEY_AT_END_TO_END_INDEX[0] = OracleTraceKey.ACTION;
        PhysicalConnection.TRACEKEY_AT_END_TO_END_INDEX[1] = OracleTraceKey.CLIENTID;
        PhysicalConnection.TRACEKEY_AT_END_TO_END_INDEX[2] = OracleTraceKey.ECID;
        PhysicalConnection.TRACEKEY_AT_END_TO_END_INDEX[3] = OracleTraceKey.MODULE;
        PhysicalConnection.TRACEKEY_AT_END_TO_END_INDEX[4] = OracleTraceKey.DBOP;
        PhysicalConnection.TRACEKEY_AT_END_TO_END_INDEX[5] = OracleTraceKey.CLIENTINFO;
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    }

    private static final class BufferCacheStore {
        static int MAX_CACHED_BUFFER_SIZE = Integer.MAX_VALUE;
        final BufferCache<byte[]> byteBufferCache;
        final BufferCache<char[]> charBufferCache;

        BufferCacheStore() {
            this(MAX_CACHED_BUFFER_SIZE);
        }

        BufferCacheStore(int maxCachedBufferSize) {
            this.byteBufferCache = new BufferCache(maxCachedBufferSize);
            this.charBufferCache = new BufferCache(maxCachedBufferSize);
        }
    }
}

