/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.event.COSProgressListener;
import com.qcloud.cos.event.COSProgressListenerChain;
import com.qcloud.cos.event.MultipleFileTransferProgressUpdatingListener;
import com.qcloud.cos.event.MultipleFileTransferStateChangeListener;
import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.TransferCompletionFilter;
import com.qcloud.cos.event.TransferProgressUpdatingListener;
import com.qcloud.cos.event.TransferStateChangeListener;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.FileLockException;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.FileLocks;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.GetObjectMetadataRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListMultipartUploadsRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.MultipartUpload;
import com.qcloud.cos.model.MultipartUploadListing;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.transfer.Download;
import com.qcloud.cos.transfer.DownloadCallable;
import com.qcloud.cos.transfer.DownloadImpl;
import com.qcloud.cos.transfer.DownloadMonitor;
import com.qcloud.cos.transfer.MultipleFileDownload;
import com.qcloud.cos.transfer.MultipleFileDownloadImpl;
import com.qcloud.cos.transfer.MultipleFileTransferMonitor;
import com.qcloud.cos.transfer.MultipleFileUpload;
import com.qcloud.cos.transfer.MultipleFileUploadImpl;
import com.qcloud.cos.transfer.ObjectMetadataProvider;
import com.qcloud.cos.transfer.PersistableDownload;
import com.qcloud.cos.transfer.PersistableUpload;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.TransferManagerUtils;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.transfer.Upload;
import com.qcloud.cos.transfer.UploadCallable;
import com.qcloud.cos.transfer.UploadImpl;
import com.qcloud.cos.transfer.UploadMonitor;
import com.qcloud.cos.utils.VersionInfoUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferManager {
    private final COS cos;
    private TransferManagerConfiguration configuration;
    private final ExecutorService threadPool;
    private final ScheduledExecutorService timedThreadPool = new ScheduledThreadPoolExecutor(1, daemonThreadFactory);
    private static final Logger log = LoggerFactory.getLogger(TransferManager.class);
    private final boolean shutDownThreadPools;
    private static final String USER_AGENT = TransferManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String USER_AGENT_MULTIPART = TransferManager.class.getName() + "_multipart/" + VersionInfoUtils.getVersion();
    private static final String DEFAULT_DELIMITER = "/";
    private static final ThreadFactory daemonThreadFactory = new ThreadFactory(){
        final AtomicInteger threadCount = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            int threadNumber = this.threadCount.incrementAndGet();
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("COSTransferManagerTimedThread-" + threadNumber);
            return thread;
        }
    };

    public TransferManager(COS cos) {
        this(cos, TransferManagerUtils.createDefaultExecutorService());
    }

    public TransferManager(COS cos, ExecutorService threadPool) {
        this(cos, threadPool, true);
    }

    public TransferManager(COS cos, ExecutorService threadPool, boolean shutDownThreadPools) {
        this.cos = cos;
        this.threadPool = threadPool;
        this.configuration = new TransferManagerConfiguration();
        this.shutDownThreadPools = shutDownThreadPools;
    }

    public void setConfiguration(TransferManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    public TransferManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public COS getCOSClient() {
        return this.cos;
    }

    public Upload upload(String bucketName, String key, InputStream input, ObjectMetadata objectMetadata) throws CosServiceException, CosClientException {
        return this.upload(new PutObjectRequest(bucketName, key, input, objectMetadata));
    }

    public Upload upload(String bucketName, String key, File file) throws CosServiceException, CosClientException {
        return this.upload(new PutObjectRequest(bucketName, key, file));
    }

    public Upload upload(PutObjectRequest putObjectRequest) throws CosServiceException, CosClientException {
        return this.doUpload(putObjectRequest, null, null, null);
    }

    public Upload upload(PutObjectRequest putObjectRequest, COSProgressListener progressListener) throws CosServiceException, CosClientException {
        return this.doUpload(putObjectRequest, null, progressListener, null);
    }

    private Upload doUpload(PutObjectRequest putObjectRequest, TransferStateChangeListener stateListener, COSProgressListener progressListener, PersistableUpload persistableUpload) throws CosServiceException, CosClientException {
        String multipartUploadId;
        TransferManager.appendSingleObjectUserAgent(putObjectRequest);
        String string = multipartUploadId = persistableUpload != null ? persistableUpload.getMultipartUploadId() : null;
        if (putObjectRequest.getMetadata() == null) {
            putObjectRequest.setMetadata(new ObjectMetadata());
        }
        ObjectMetadata metadata = putObjectRequest.getMetadata();
        File file = TransferManagerUtils.getRequestFile(putObjectRequest);
        if (file != null) {
            metadata.setContentLength(file.length());
        } else if (multipartUploadId != null) {
            throw new IllegalArgumentException("Unable to resume the upload. No file specified.");
        }
        String description = "Uploading to " + putObjectRequest.getBucketName() + DEFAULT_DELIMITER + putObjectRequest.getKey();
        TransferProgress transferProgress = new TransferProgress();
        transferProgress.setTotalBytesToTransfer(TransferManagerUtils.getContentLength(putObjectRequest));
        COSProgressListenerChain listenerChain = new COSProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), putObjectRequest.getGeneralProgressListener(), progressListener);
        putObjectRequest.setGeneralProgressListener(listenerChain);
        UploadImpl upload = new UploadImpl(description, transferProgress, listenerChain, stateListener);
        UploadCallable uploadCallable = new UploadCallable(this, this.threadPool, upload, putObjectRequest, listenerChain, multipartUploadId, transferProgress);
        UploadMonitor watcher = UploadMonitor.create(this, upload, this.threadPool, uploadCallable, putObjectRequest, listenerChain);
        upload.setMonitor(watcher);
        return upload;
    }

    public Download download(String bucket, String key, File file) {
        return this.download(new GetObjectRequest(bucket, key), file);
    }

    public Download download(GetObjectRequest getObjectRequest, File file) {
        return this.doDownload(getObjectRequest, file, null, null, false);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, COSProgressListener progressListener) {
        return this.doDownload(getObjectRequest, file, null, progressListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Download doDownload(GetObjectRequest getObjectRequest, File file, TransferStateChangeListener stateListener, COSProgressListener cosProgressListener, boolean resumeExistingDownload) {
        long lastByte;
        TransferManager.appendSingleObjectUserAgent(getObjectRequest);
        String description = "Downloading from " + getObjectRequest.getBucketName() + DEFAULT_DELIMITER + getObjectRequest.getKey();
        TransferProgress transferProgress = new TransferProgress();
        COSProgressListenerChain listenerChain = new COSProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), getObjectRequest.getGeneralProgressListener(), cosProgressListener);
        getObjectRequest.setGeneralProgressListener(new ProgressListenerChain(new TransferCompletionFilter(), listenerChain));
        long startingByte = 0L;
        long[] range = getObjectRequest.getRange();
        if (range != null && range.length == 2) {
            startingByte = range[0];
            lastByte = range[1];
        } else {
            GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey());
            if (getObjectRequest.getSSECustomerKey() != null) {
                getObjectMetadataRequest.setSSECustomerKey(getObjectRequest.getSSECustomerKey());
            }
            if (getObjectRequest.getVersionId() != null) {
                getObjectMetadataRequest.setVersionId(getObjectRequest.getVersionId());
            }
            ObjectMetadata objectMetadata = this.cos.getObjectMetadata(getObjectMetadataRequest);
            lastByte = objectMetadata.getContentLength() - 1L;
        }
        long origStartingByte = startingByte;
        DownloadImpl download = new DownloadImpl(description, transferProgress, listenerChain, null, stateListener, getObjectRequest, file);
        long totalBytesToDownload = lastByte - startingByte + 1L;
        transferProgress.setTotalBytesToTransfer(totalBytesToDownload);
        long fileLength = -1L;
        if (resumeExistingDownload) {
            if (!FileLocks.lock(file)) {
                throw new FileLockException("Fail to lock " + file + " for resume download");
            }
            try {
                if (file.exists()) {
                    fileLength = file.length();
                    getObjectRequest.setRange(startingByte += fileLength, lastByte);
                    transferProgress.updateProgress(Math.min(fileLength, totalBytesToDownload));
                    totalBytesToDownload = lastByte - startingByte + 1L;
                    if (log.isDebugEnabled()) {
                        log.debug("Resume download: totalBytesToDownload=" + totalBytesToDownload + ", origStartingByte=" + origStartingByte + ", startingByte=" + startingByte + ", lastByte=" + lastByte + ", numberOfBytesRead=" + fileLength + ", file: " + file);
                    }
                }
            }
            finally {
                FileLocks.unlock(file);
            }
        }
        if (totalBytesToDownload < 0L) {
            throw new IllegalArgumentException("Unable to determine the range for download operation.");
        }
        CountDownLatch latch = new CountDownLatch(1);
        Future<File> future = this.threadPool.submit(new DownloadCallable(this.cos, latch, getObjectRequest, resumeExistingDownload, download, file, origStartingByte, fileLength));
        download.setMonitor(new DownloadMonitor(download, future));
        latch.countDown();
        return download;
    }

    public MultipleFileDownload downloadDirectory(String bucketName, String keyPrefix, File destinationDirectory) {
        if (keyPrefix == null) {
            keyPrefix = "";
        }
        LinkedList<COSObjectSummary> objectSummaries = new LinkedList<COSObjectSummary>();
        Stack<String> commonPrefixes = new Stack<String>();
        commonPrefixes.add(keyPrefix);
        long totalSize = 0L;
        do {
            String prefix = (String)commonPrefixes.pop();
            ObjectListing listObjectsResponse = null;
            do {
                if (listObjectsResponse == null) {
                    ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withDelimiter(DEFAULT_DELIMITER).withPrefix(prefix);
                    listObjectsResponse = this.cos.listObjects(listObjectsRequest);
                } else {
                    listObjectsResponse = this.cos.listNextBatchOfObjects(listObjectsResponse);
                }
                for (COSObjectSummary s : listObjectsResponse.getObjectSummaries()) {
                    if (!s.getKey().equals(prefix) && !listObjectsResponse.getCommonPrefixes().contains(s.getKey() + DEFAULT_DELIMITER)) {
                        objectSummaries.add(s);
                        totalSize += s.getSize();
                        continue;
                    }
                    log.debug("Skipping download for object " + s.getKey() + " since it is also a virtual directory");
                }
                commonPrefixes.addAll(listObjectsResponse.getCommonPrefixes());
            } while (listObjectsResponse.isTruncated());
        } while (!commonPrefixes.isEmpty());
        ProgressListenerChain additionalListeners = new ProgressListenerChain(new ProgressListener[0]);
        TransferProgress transferProgress = new TransferProgress();
        transferProgress.setTotalBytesToTransfer(totalSize);
        MultipleFileTransferProgressUpdatingListener listener = new MultipleFileTransferProgressUpdatingListener(transferProgress, additionalListeners);
        ArrayList<DownloadImpl> downloads = new ArrayList<DownloadImpl>();
        String description = "Downloading from " + bucketName + DEFAULT_DELIMITER + keyPrefix;
        MultipleFileDownloadImpl multipleFileDownload = new MultipleFileDownloadImpl(description, transferProgress, additionalListeners, keyPrefix, bucketName, downloads);
        multipleFileDownload.setMonitor(new MultipleFileTransferMonitor(multipleFileDownload, downloads));
        CountDownLatch latch = new CountDownLatch(1);
        MultipleFileTransferStateChangeListener transferListener = new MultipleFileTransferStateChangeListener(latch, multipleFileDownload);
        for (COSObjectSummary summary : objectSummaries) {
            File f = new File(destinationDirectory, summary.getKey());
            File parentFile = f.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new RuntimeException("Couldn't create parent directories for " + f.getAbsolutePath());
            }
            downloads.add((DownloadImpl)this.doDownload((GetObjectRequest)new GetObjectRequest(summary.getBucketName(), summary.getKey()).withGeneralProgressListener(listener), f, transferListener, null, false));
        }
        if (downloads.isEmpty()) {
            multipleFileDownload.setState(Transfer.TransferState.Completed);
            return multipleFileDownload;
        }
        latch.countDown();
        return multipleFileDownload;
    }

    public MultipleFileUpload uploadDirectory(String bucketName, String virtualDirectoryKeyPrefix, File directory, boolean includeSubdirectories) {
        return this.uploadDirectory(bucketName, virtualDirectoryKeyPrefix, directory, includeSubdirectories, null);
    }

    public MultipleFileUpload uploadDirectory(String bucketName, String virtualDirectoryKeyPrefix, File directory, boolean includeSubdirectories, ObjectMetadataProvider metadataProvider) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Must provide a directory to upload");
        }
        LinkedList<File> files = new LinkedList<File>();
        this.listFiles(directory, files, includeSubdirectories);
        return this.uploadFileList(bucketName, virtualDirectoryKeyPrefix, directory, files, metadataProvider);
    }

    public MultipleFileUpload uploadFileList(String bucketName, String virtualDirectoryKeyPrefix, File directory, List<File> files) {
        return this.uploadFileList(bucketName, virtualDirectoryKeyPrefix, directory, files, null);
    }

    public MultipleFileUpload uploadFileList(String bucketName, String virtualDirectoryKeyPrefix, File directory, List<File> files, ObjectMetadataProvider metadataProvider) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Must provide a common base directory for uploaded files");
        }
        if (virtualDirectoryKeyPrefix == null || virtualDirectoryKeyPrefix.length() == 0) {
            virtualDirectoryKeyPrefix = "";
        } else if (!virtualDirectoryKeyPrefix.endsWith(DEFAULT_DELIMITER)) {
            virtualDirectoryKeyPrefix = virtualDirectoryKeyPrefix + DEFAULT_DELIMITER;
        }
        ProgressListenerChain additionalListeners = new ProgressListenerChain(new ProgressListener[0]);
        TransferProgress progress = new TransferProgress();
        MultipleFileTransferProgressUpdatingListener listener = new MultipleFileTransferProgressUpdatingListener(progress, additionalListeners);
        LinkedList<UploadImpl> uploads = new LinkedList<UploadImpl>();
        MultipleFileUploadImpl multipleFileUpload = new MultipleFileUploadImpl("Uploading etc", progress, additionalListeners, virtualDirectoryKeyPrefix, bucketName, uploads);
        multipleFileUpload.setMonitor(new MultipleFileTransferMonitor(multipleFileUpload, uploads));
        CountDownLatch latch = new CountDownLatch(1);
        MultipleFileTransferStateChangeListener transferListener = new MultipleFileTransferStateChangeListener(latch, multipleFileUpload);
        if (files == null || files.isEmpty()) {
            multipleFileUpload.setState(Transfer.TransferState.Completed);
        } else {
            int startingPosition = directory.getAbsolutePath().length();
            if (!directory.getAbsolutePath().endsWith(File.separator)) {
                ++startingPosition;
            }
            long totalSize = 0L;
            for (File f : files) {
                if (!f.isFile()) continue;
                totalSize += f.length();
                String key = f.getAbsolutePath().substring(startingPosition).replaceAll("\\\\", DEFAULT_DELIMITER);
                ObjectMetadata metadata = new ObjectMetadata();
                if (metadataProvider != null) {
                    metadataProvider.provideObjectMetadata(f, metadata);
                }
                uploads.add((UploadImpl)this.doUpload((PutObjectRequest)new PutObjectRequest(bucketName, virtualDirectoryKeyPrefix + key, f).withMetadata(metadata).withGeneralProgressListener(listener), transferListener, null, null));
            }
            progress.setTotalBytesToTransfer(totalSize);
        }
        latch.countDown();
        return multipleFileUpload;
    }

    private void listFiles(File dir, List<File> results, boolean includeSubDirectories) {
        File[] found = dir.listFiles();
        if (found != null) {
            for (File f : found) {
                if (f.isDirectory()) {
                    if (!includeSubDirectories) continue;
                    this.listFiles(f, results, includeSubDirectories);
                    continue;
                }
                results.add(f);
            }
        }
    }

    public void abortMultipartUploads(String bucketName, Date date) throws CosServiceException, CosClientException {
        ListMultipartUploadsRequest request;
        MultipartUploadListing uploadListing = this.cos.listMultipartUploads(TransferManager.appendSingleObjectUserAgent(new ListMultipartUploadsRequest(bucketName)));
        do {
            for (MultipartUpload upload : uploadListing.getMultipartUploads()) {
                if (upload.getInitiated().compareTo(date) >= 0) continue;
                this.cos.abortMultipartUpload(TransferManager.appendSingleObjectUserAgent(new AbortMultipartUploadRequest(bucketName, upload.getKey(), upload.getUploadId())));
            }
        } while ((uploadListing = this.cos.listMultipartUploads(TransferManager.appendSingleObjectUserAgent(request = new ListMultipartUploadsRequest(bucketName).withUploadIdMarker(uploadListing.getNextUploadIdMarker()).withKeyMarker(uploadListing.getNextKeyMarker())))).isTruncated());
    }

    public void shutdownNow() {
        this.shutdownNow(true);
    }

    public void shutdownNow(boolean shutDownCOSClient) {
        if (this.shutDownThreadPools) {
            this.threadPool.shutdownNow();
            this.timedThreadPool.shutdownNow();
        }
        if (shutDownCOSClient && this.cos instanceof COSClient) {
            ((COSClient)this.cos).shutdown();
        }
    }

    private void shutdownThreadPools() {
        if (this.shutDownThreadPools) {
            this.threadPool.shutdown();
            this.timedThreadPool.shutdown();
        }
    }

    public static <X extends CosServiceRequest> X appendSingleObjectUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return request;
    }

    public static <X extends CosServiceRequest> X appendMultipartUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT_MULTIPART);
        return request;
    }

    public Upload resumeUpload(PersistableUpload persistableUpload) {
        this.assertParameterNotNull(persistableUpload, "PauseUpload is mandatory to resume a upload.");
        this.configuration.setMinimumUploadPartSize(persistableUpload.getPartSize());
        this.configuration.setMultipartUploadThreshold(persistableUpload.getMutlipartUploadThreshold());
        return this.doUpload(new PutObjectRequest(persistableUpload.getBucketName(), persistableUpload.getKey(), new File(persistableUpload.getFile())), null, null, persistableUpload);
    }

    public Download resumeDownload(PersistableDownload persistableDownload) {
        this.assertParameterNotNull(persistableDownload, "PausedDownload is mandatory to resume a download.");
        GetObjectRequest request = new GetObjectRequest(persistableDownload.getBucketName(), persistableDownload.getKey(), persistableDownload.getVersionId());
        if (persistableDownload.getRange() != null && persistableDownload.getRange().length == 2) {
            long[] range = persistableDownload.getRange();
            request.setRange(range[0], range[1]);
        }
        request.setRequesterPays(persistableDownload.isRequesterPays());
        request.setResponseHeaders(persistableDownload.getResponseHeaders());
        return this.doDownload(request, new File(persistableDownload.getFile()), null, null, true);
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdownThreadPools();
    }
}

