/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.DecimalConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class FixedDecimalConverter
extends DecimalConverter {
    protected FixedDecimalConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        int fixedByteCount = this._dataType.getFixedByteCount();
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(this._isDeterministic ? fixedByteCount : fixedByteCount + 1) + 1;
        }
        return fixedByteCount + 1;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof BigDecimal)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        int fixedByteCount = this._dataType.getFixedByteCount();
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(this._isDeterministic ? fixedByteCount : fixedByteCount + 1) + 2;
        }
        return fixedByteCount + 1;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof BigDecimal)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        BigDecimal value = (BigDecimal)data;
        byte fixedByteCount = this._dataType.getFixedByteCount();
        if (this._isEncrypted) {
            int off;
            byte[] bytes;
            if (this._isDeterministic) {
                bytes = new byte[fixedByteCount];
                off = 0;
            } else {
                bytes = new byte[fixedByteCount + 1];
                ByteUtils.putByte(1, bytes, 0);
                off = 1;
            }
            ByteUtils.putBigDecimalAsFixedDecimal(value, bytes, off, this._fraction, fixedByteCount);
            byte[] encrypted = this._getEncryptedBuffer(bytes);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putBigDecimalAsFixedDecimal((BigDecimal)data, this._fraction, this._dataType);
    }

    @Override
    protected int _getNullInputArgLength() {
        if (this._isEncrypted && !this._isDeterministic) {
            return this._cipher.getEncryptedLength(1) + 2;
        }
        return 1;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        if (this._isEncrypted && !this._isDeterministic) {
            byte[] encrypted = this._getEncryptedBuffer(NON_DETERMINISTIC_NULL_MARKER_ARRAY);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putNull(this._dataType);
    }

    @Override
    public BigDecimal setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return this._checkPrecision(new BigDecimal(value.trim()));
        }
        catch (NumberFormatException e) {
            throw this._newSetConversionException(value, "java.math.BigDecimal");
        }
    }

    @Override
    protected BigDecimal _getValueAsBigDecimal(SQLParamController controller, HDataPart dataPart, boolean doNullCheck, byte[] decrypted, boolean[] outIsNull) throws SQLException {
        if (doNullCheck) {
            decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
            boolean isNull = dataPart.isNull(this, controller, decrypted);
            if (outIsNull != null) {
                outIsNull[0] = isNull;
            }
            if (isNull) {
                return null;
            }
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            return ByteUtils.getFixedDecimalAsBigDecimal(decrypted, this._isDeterministic ? 0 : 1, this._fraction, this._dataType.getFixedByteCount());
        }
        return dataPart.getFixedDecimalAsBigDecimal(this._fraction, this._dataType);
    }
}

