/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;

@Immutable
public final class WindowsRegistryUtils {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int REG_SUCCESS = 0;
    private static final int KEY_READ = 131097;
    private static final Preferences USER_ROOT = Preferences.userRoot();
    private static final Preferences SYSTEM_ROOT = Preferences.systemRoot();
    private static final Class<? extends Preferences> USER_CLASS = USER_ROOT.getClass();
    private static final Method REG_OPEN_KEY;
    private static final Method REG_CLOSE_KEY;
    private static final Method REG_QUERY_VALUE_EX;
    private static final boolean INIT_SUCCESS;

    private WindowsRegistryUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static String readString(int hkey, String key, String valueName) {
        Preferences prefs;
        if (!INIT_SUCCESS) {
            return null;
        }
        if (hkey == -2147483646) {
            prefs = SYSTEM_ROOT;
        } else if (hkey == -2147483647) {
            prefs = USER_ROOT;
        } else {
            throw new AssertionError((Object)("Unexpected hkey: " + hkey));
        }
        return WindowsRegistryUtils._readString(prefs, hkey, key, valueName);
    }

    /*
     * Exception decompiling
     */
    private static String _readString(Preferences root, int hkey, String key, String valueName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 20[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] _toCstr(String str) {
        byte[] src = str.getBytes();
        int len = src.length;
        byte[] dst = new byte[len + 1];
        System.arraycopy(src, 0, dst, 0, len);
        return dst;
    }

    static {
        Method regOpenKey = null;
        Method regCloseKey = null;
        Method regQueryValueEx = null;
        boolean initSuccess = false;
        try {
            regOpenKey = USER_CLASS.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = USER_CLASS.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = USER_CLASS.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            initSuccess = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        REG_OPEN_KEY = regOpenKey;
        REG_CLOSE_KEY = regCloseKey;
        REG_QUERY_VALUE_EX = regQueryValueEx;
        INIT_SUCCESS = initSuccess;
    }
}

