/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.drafts;

import com.sap.db.util.BufferUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_10;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.exceptions.InvalidFrameException;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.exceptions.LimitExedeedException;
import org.java_websocket.extensions.DefaultExtension;
import org.java_websocket.extensions.IExtension;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.FramedataImpl1;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ClientHandshakeBuilder;
import org.java_websocket.handshake.HandshakeBuilder;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.handshake.ServerHandshakeBuilder;

public class Draft_6455
extends Draft_17 {
    private IExtension extension;
    private List<IExtension> knownExtensions = new ArrayList<IExtension>();

    public Draft_6455() {
        this(Collections.emptyList());
    }

    public Draft_6455(IExtension inputExtension) {
        this(Collections.singletonList(inputExtension));
    }

    public Draft_6455(List<IExtension> inputExtensions) {
        boolean hasDefault = false;
        for (IExtension inputExtension : inputExtensions) {
            if (!inputExtension.getClass().equals(DefaultExtension.class)) continue;
            hasDefault = true;
        }
        this.knownExtensions.addAll(inputExtensions);
        if (!hasDefault) {
            DefaultExtension defaultExtension = new DefaultExtension();
            this.knownExtensions.add(this.knownExtensions.size(), defaultExtension);
        }
    }

    @Override
    public Draft.HandshakeState acceptHandshakeAsServer(ClientHandshake handshakedata) throws InvalidHandshakeException {
        if (super.acceptHandshakeAsServer(handshakedata) == Draft.HandshakeState.NOT_MATCHED) {
            return Draft.HandshakeState.NOT_MATCHED;
        }
        String requestedExtension = handshakedata.getFieldValue("Sec-WebSocket-Extensions");
        for (IExtension knownExtension : this.knownExtensions) {
            if (!knownExtension.acceptProvidedExtensionAsServer(requestedExtension)) continue;
            this.extension = knownExtension;
            return Draft.HandshakeState.MATCHED;
        }
        return Draft.HandshakeState.NOT_MATCHED;
    }

    @Override
    public Draft.HandshakeState acceptHandshakeAsClient(ClientHandshake request, ServerHandshake response) throws InvalidHandshakeException {
        if (super.acceptHandshakeAsClient(request, response) == Draft.HandshakeState.NOT_MATCHED) {
            return Draft.HandshakeState.NOT_MATCHED;
        }
        String requestedExtension = response.getFieldValue("Sec-WebSocket-Extensions");
        for (IExtension knownExtension : this.knownExtensions) {
            if (!knownExtension.acceptProvidedExtensionAsClient(requestedExtension)) continue;
            this.extension = knownExtension;
            return Draft.HandshakeState.MATCHED;
        }
        return Draft.HandshakeState.NOT_MATCHED;
    }

    public IExtension getExtension() {
        return this.extension;
    }

    @Override
    public ClientHandshakeBuilder postProcessHandshakeRequestAsClient(ClientHandshakeBuilder request) {
        super.postProcessHandshakeRequestAsClient(request);
        StringBuilder requestedExtensions = new StringBuilder();
        for (IExtension knownExtension : this.knownExtensions) {
            if (knownExtension.getProvidedExtensionAsClient() == null || knownExtension.getProvidedExtensionAsClient().equals("")) continue;
            requestedExtensions.append(knownExtension.getProvidedExtensionAsClient()).append("; ");
        }
        if (requestedExtensions.length() != 0) {
            request.put("Sec-WebSocket-Extensions", requestedExtensions.toString());
        }
        return request;
    }

    @Override
    public HandshakeBuilder postProcessHandshakeResponseAsServer(ClientHandshake request, ServerHandshakeBuilder response) throws InvalidHandshakeException {
        super.postProcessHandshakeResponseAsServer(request, response);
        if (this.getExtension().getProvidedExtensionAsServer().length() != 0) {
            response.put("Sec-WebSocket-Extensions", this.getExtension().getProvidedExtensionAsServer());
        }
        response.setHttpStatusMessage("Web Socket Protocol Handshake");
        response.put("Server", "TooTallNate Java-WebSocket");
        response.put("Date", this.getServerTime());
        return response;
    }

    @Override
    public Draft copyInstance() {
        ArrayList<IExtension> newExtensions = new ArrayList<IExtension>();
        for (IExtension extension : this.knownExtensions) {
            newExtensions.add(extension.copyInstance());
        }
        return new Draft_6455(newExtensions);
    }

    @Override
    public ByteBuffer createBinaryFrame(Framedata framedata) {
        this.getExtension().encodeFrame(framedata);
        if (WebSocketImpl.DEBUG) {
            System.out.println("afterEnconding(" + framedata.getPayloadData().remaining() + "): {" + (framedata.getPayloadData().remaining() > 1000 ? "too big to display" : new String(framedata.getPayloadData().array())) + "}");
        }
        return super.createBinaryFrame(framedata);
    }

    @Override
    public Framedata translateSingleFrame(ByteBuffer buffer) throws Draft_10.IncompleteException, InvalidDataException {
        byte b2;
        int realpacketsize;
        int maxpacketsize = buffer.remaining();
        if (maxpacketsize < (realpacketsize = 2)) {
            throw new Draft_10.IncompleteException(realpacketsize);
        }
        byte b1 = buffer.get();
        boolean FIN = b1 >> 8 != 0;
        boolean rsv1 = false;
        boolean rsv2 = false;
        boolean rsv3 = false;
        if ((b1 & 0x40) != 0) {
            rsv1 = true;
        }
        if ((b1 & 0x20) != 0) {
            rsv2 = true;
        }
        if ((b1 & 0x10) != 0) {
            rsv3 = true;
        }
        boolean MASK = ((b2 = buffer.get()) & 0xFFFFFF80) != 0;
        int payloadlength = b2 & 0x7F;
        Framedata.Opcode optcode = this.toOpcode((byte)(b1 & 0xF));
        if (payloadlength < 0 || payloadlength > 125) {
            if (optcode == Framedata.Opcode.PING || optcode == Framedata.Opcode.PONG || optcode == Framedata.Opcode.CLOSING) {
                throw new InvalidFrameException("more than 125 octets");
            }
            if (payloadlength == 126) {
                if (maxpacketsize < (realpacketsize += 2)) {
                    throw new Draft_10.IncompleteException(realpacketsize);
                }
                byte[] sizebytes = new byte[3];
                sizebytes[1] = buffer.get();
                sizebytes[2] = buffer.get();
                payloadlength = new BigInteger(sizebytes).intValue();
            } else {
                if (maxpacketsize < (realpacketsize += 8)) {
                    throw new Draft_10.IncompleteException(realpacketsize);
                }
                byte[] bytes = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    bytes[i] = buffer.get();
                }
                long length = new BigInteger(bytes).longValue();
                if (length > Integer.MAX_VALUE) {
                    throw new LimitExedeedException("Payloadsize is to big...");
                }
                payloadlength = (int)length;
            }
        }
        realpacketsize += MASK ? 4 : 0;
        if (maxpacketsize < (realpacketsize += payloadlength)) {
            throw new Draft_10.IncompleteException(realpacketsize);
        }
        ByteBuffer payload = ByteBuffer.allocate(this.checkAlloc(payloadlength));
        if (MASK) {
            byte[] maskskey = new byte[4];
            buffer.get(maskskey);
            for (int i = 0; i < payloadlength; ++i) {
                payload.put((byte)(buffer.get() ^ maskskey[i % 4]));
            }
        } else {
            payload.put(buffer.array(), buffer.position(), payload.limit());
            BufferUtils.position(buffer, buffer.position() + payload.limit());
        }
        FramedataImpl1 frame = FramedataImpl1.get(optcode);
        frame.setFin(FIN);
        frame.setRSV1(rsv1);
        frame.setRSV2(rsv2);
        frame.setRSV3(rsv3);
        BufferUtils.flip(payload);
        frame.setPayload(payload);
        this.getExtension().isFrameValid(frame);
        this.getExtension().decodeFrame(frame);
        if (WebSocketImpl.DEBUG) {
            System.out.println("afterDecoding(" + frame.getPayloadData().remaining() + "): {" + (frame.getPayloadData().remaining() > 1000 ? "too big to display" : new String(frame.getPayloadData().array())) + "}");
        }
        frame.isValid();
        return frame;
    }

    @Override
    public List<Framedata> translateFrame(ByteBuffer buffer) throws InvalidDataException {
        Framedata cur;
        LinkedList<Framedata> frames;
        while (true) {
            frames = new LinkedList<Framedata>();
            if (this.incompleteframe == null) break;
            try {
                BufferUtils.mark(buffer);
                int available_next_byte_count = buffer.remaining();
                int expected_next_byte_count = this.incompleteframe.remaining();
                if (expected_next_byte_count > available_next_byte_count) {
                    this.incompleteframe.put(buffer.array(), buffer.position(), available_next_byte_count);
                    BufferUtils.position(buffer, buffer.position() + available_next_byte_count);
                    return Collections.emptyList();
                }
                this.incompleteframe.put(buffer.array(), buffer.position(), expected_next_byte_count);
                BufferUtils.position(buffer, buffer.position() + expected_next_byte_count);
                cur = this.translateSingleFrame((ByteBuffer)BufferUtils.position(this.incompleteframe.duplicate(), 0));
                frames.add(cur);
                this.incompleteframe = null;
            }
            catch (Draft_10.IncompleteException e) {
                int oldsize = this.incompleteframe.limit();
                ByteBuffer extendedframe = ByteBuffer.allocate(this.checkAlloc(e.getPreferedSize()));
                assert (extendedframe.limit() > this.incompleteframe.limit());
                BufferUtils.rewind(this.incompleteframe);
                extendedframe.put(this.incompleteframe);
                this.incompleteframe = extendedframe;
                continue;
            }
            break;
        }
        while (buffer.hasRemaining()) {
            BufferUtils.mark(buffer);
            try {
                cur = this.translateSingleFrame(buffer);
                frames.add(cur);
            }
            catch (Draft_10.IncompleteException e) {
                BufferUtils.reset(buffer);
                int pref = e.getPreferedSize();
                this.incompleteframe = ByteBuffer.allocate(this.checkAlloc(pref));
                this.incompleteframe.put(buffer);
                break;
            }
        }
        return frames;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.extension != null) {
            this.extension.reset();
        }
        this.extension = null;
    }

    private String getServerTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(calendar.getTime());
    }

    @Override
    public String toString() {
        String result = super.toString();
        if (this.getExtension() != null) {
            result = result + " extension: " + this.getExtension().toString();
        }
        return result;
    }
}

