/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.controller;

import com.wego168.base.domain.Checkin;
import com.wego168.base.domain.CheckinSetting;
import com.wego168.base.service.CheckinService;
import com.wego168.base.service.CheckinSettingService;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.web.controller.CrudController;
import com.wego168.wx.token.SmallProgramUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="ActivityCheckinController")
@RequestMapping(value={"/api/admin/v1/checkin"})
public class CheckinController
extends CrudController<Checkin> {
    @Autowired
    private CheckinService checkinService;
    @Autowired
    private CheckinSettingService checkinSettingService;
    private static final Logger logger = LoggerFactory.getLogger(CheckinController.class);

    public CrudService<Checkin> getService() {
        return this.checkinService;
    }

    @GetMapping(value={"/getCodeCheckinQRcode"})
    public void getCodeCheckinQRCode(String checkinSettingId, HttpServletResponse response) {
        CheckinSetting checkinSetting = (CheckinSetting)this.checkinSettingService.selectById((Object)checkinSettingId);
        Checker.checkNull((Object)checkinSetting, (String)"\u7b7e\u5230\u8bbe\u7f6e");
        this.createQRCodeAndResponse(checkinSettingId, "pagesCommon/activity/check/code/index", response);
    }

    @GetMapping(value={"/getMobileCheckQRCode"})
    public void getMobileCheckQRCode(String checkinSettingId, HttpServletResponse response) {
        CheckinSetting checkinSetting = (CheckinSetting)this.checkinSettingService.selectById((Object)checkinSettingId);
        Checker.checkNull((Object)checkinSetting, (String)"\u7b7e\u5230\u8bbe\u7f6e");
        this.createQRCodeAndResponse(checkinSettingId, "pagesCommon/activity/check/mobile/index", response);
    }

    @GetMapping(value={"/getAirborneQRCode"})
    public void getAirborneQRCode(String checkinSettingId, HttpServletResponse response) {
        CheckinSetting checkinSetting = (CheckinSetting)this.checkinSettingService.selectById((Object)checkinSettingId);
        Checker.checkNull((Object)checkinSetting, (String)"\u7b7e\u5230\u8bbe\u7f6e");
        this.createQRCodeAndResponse(checkinSettingId, "pagesCommon/activity/check/airborne/index", response);
    }

    private void createQRCodeAndResponse(String scene, String path, HttpServletResponse response) {
        try {
            BufferedImage wxMiniCodeBuffer = SmallProgramUtil.getSmallProgramCode((String)this.getAppId(), (String)path, (String)scene);
            ImageIO.write((RenderedImage)wxMiniCodeBuffer, "png", (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            logger.error("\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25", (Throwable)e);
        }
    }
}

